/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.ColorPicker;
import king.KMessage;
import king.KingMain;
import king.KingPrefs;
import king.core.AGE;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.Kinemage;
import king.points.BallPoint;

public class GroupEditor
implements ChangeListener {
    KingMain kMain;
    Frame ownerWindow;
    JDialog kiDialog;
    JTextField kiName;
    JCheckBox kiWhiteback;
    JCheckBox kiOnewidth;
    JCheckBox kiThinline;
    JCheckBox kiPerspec;
    JCheckBox kiFlat;
    JCheckBox kiListcolor;
    JButton kiOK;
    JButton kiCancel;
    JDialog grDialog;
    JTextField grName;
    JCheckBox grIsOff;
    JCheckBox grNoButton;
    JCheckBox grDominant;
    JCheckBox grRecessiveOn;
    JCheckBox grAnimate;
    JCheckBox gr2Animate;
    JCheckBox grSelect;
    JButton grOK;
    JButton grCancel;
    JDialog suDialog;
    JTextField suName;
    JCheckBox suIsOff;
    JCheckBox suNoButton;
    JCheckBox suDominant;
    JCheckBox suRecessiveOn;
    JButton suOK;
    JButton suCancel;
    JDialog liDialog;
    boolean liFirstShow = true;
    TablePane liPanel;
    JTextField liName;
    JCheckBox liIsOff;
    JCheckBox liNoButton;
    JCheckBox liNoHilite;
    JTextField liWidth;
    JTextField liRadius;
    JTextField liAlpha;
    ColorPicker liPicker;
    KPaint originalColor = null;
    KList theKList = null;
    JButton liOK;
    JButton liCancel;
    JDialog trDialog;
    boolean trFirstShow = true;
    TablePane2 trPanel;
    JTextField trTransX;
    JTextField trTransY;
    JTextField trTransZ;
    JTextField trRotX;
    JTextField trRotY;
    JTextField trRotZ;
    JTextField trScale;
    JTextField trScaleX;
    JTextField trScaleY;
    JTextField trScaleZ;
    JCheckBox trAboutOrigin;
    JButton trBtnTrans;
    JButton trBtnRot;
    JButton trBtnAniso;
    JButton trBtnScale;
    JButton trClose;
    AGE trTarget = null;
    boolean acceptChanges = false;

    public GroupEditor(KingMain kingMain, Frame frame) {
        this.kMain = kingMain;
        this.ownerWindow = frame;
        this.makeKinemageDialog();
        this.makeGroupDialog();
        this.makeSubgroupDialog();
        this.makeListDialog();
        this.makeTransformDialog();
    }

    void makeKinemageDialog() {
        this.kiDialog = new JDialog(this.ownerWindow, "Edit kinemage properties", true);
        this.kiDialog.setDefaultCloseOperation(0);
        TablePane2 tablePane2 = new TablePane2();
        this.kiDialog.setContentPane(tablePane2);
        this.kiName = new JTextField(20);
        this.kiWhiteback = new JCheckBox("@whiteback (Default to white background)");
        this.kiOnewidth = new JCheckBox("@onewidth (No depth cueing by line width)");
        this.kiThinline = new JCheckBox("@thinline (All lines are thin)");
        this.kiPerspec = new JCheckBox("@perspective (Use realistic perspective)");
        this.kiFlat = new JCheckBox("@flat (2-D display and navigation)");
        this.kiListcolor = new JCheckBox("@listcolordominant (Default to list color)");
        this.kiOK = new JButton(new ReflectiveAction("OK", null, this, "onKinemageOK"));
        this.kiCancel = new JButton(new ReflectiveAction("Cancel", null, this, "onKinemageCancel"));
        this.kiDialog.getRootPane().setDefaultButton(this.kiOK);
        tablePane2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        tablePane2.addCell(new JLabel("Kinemage title:")).newRow();
        tablePane2.addCell(this.kiName).newRow();
        tablePane2.addCell(new JLabel("Preferred display options:")).newRow();
        tablePane2.addCell(this.kiWhiteback).newRow();
        tablePane2.addCell(this.kiOnewidth).newRow();
        tablePane2.addCell(this.kiThinline).newRow();
        tablePane2.addCell(this.kiPerspec).newRow();
        tablePane2.addCell(this.kiFlat).newRow();
        tablePane2.addCell(this.kiListcolor).newRow();
        tablePane2.startSubtable();
        tablePane2.center().memorize();
        tablePane2.addCell(this.kiOK).addCell(this.kiCancel);
        tablePane2.endSubtable();
    }

    void makeGroupDialog() {
        this.grDialog = new JDialog(this.ownerWindow, "Edit group properties", true);
        this.grDialog.setDefaultCloseOperation(0);
        TablePane2 tablePane2 = new TablePane2();
        this.grDialog.setContentPane(tablePane2);
        this.grName = new JTextField(20);
        this.grIsOff = new JCheckBox("off (Hide this and all children)");
        this.grNoButton = new JCheckBox("nobutton (Don't provide on/off button)");
        this.grDominant = new JCheckBox("dominant (Supress all children's buttons)");
        this.grRecessiveOn = new JCheckBox("collapsable (Dominant only when off)");
        this.grAnimate = new JCheckBox("animate (Include in ANIMATE animation)");
        this.gr2Animate = new JCheckBox("2animate (Include in 2ANIMATE animation)");
        this.grSelect = new JCheckBox("select (Allow selection-by-color)");
        this.grOK = new JButton(new ReflectiveAction("OK", null, this, "onGroupOK"));
        this.grCancel = new JButton(new ReflectiveAction("Cancel", null, this, "onGroupCancel"));
        this.grDialog.getRootPane().setDefaultButton(this.grOK);
        tablePane2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        tablePane2.addCell(new JLabel("Group name/identifier:")).newRow();
        tablePane2.addCell(this.grName).newRow();
        tablePane2.addCell(this.grIsOff).newRow();
        tablePane2.addCell(this.grNoButton).newRow();
        tablePane2.addCell(this.grDominant).newRow();
        tablePane2.addCell(this.grRecessiveOn).newRow();
        tablePane2.addCell(this.grAnimate).newRow();
        tablePane2.addCell(this.gr2Animate).newRow();
        tablePane2.addCell(this.grSelect).newRow();
        tablePane2.startSubtable();
        tablePane2.center().memorize();
        tablePane2.addCell(this.grOK).addCell(this.grCancel);
        tablePane2.endSubtable();
    }

    void makeSubgroupDialog() {
        this.suDialog = new JDialog(this.ownerWindow, "Edit subgroup properties", true);
        this.suDialog.setDefaultCloseOperation(0);
        TablePane2 tablePane2 = new TablePane2();
        this.suDialog.setContentPane(tablePane2);
        this.suName = new JTextField(20);
        this.suIsOff = new JCheckBox("off (Hide this and all children)");
        this.suNoButton = new JCheckBox("nobutton (Don't provide on/off button)");
        this.suDominant = new JCheckBox("dominant (Supress all children's buttons)");
        this.suRecessiveOn = new JCheckBox("collapsable (Dominant only when off)");
        this.suOK = new JButton(new ReflectiveAction("OK", null, this, "onSubgroupOK"));
        this.suCancel = new JButton(new ReflectiveAction("Cancel", null, this, "onSubgroupCancel"));
        this.suDialog.getRootPane().setDefaultButton(this.suOK);
        tablePane2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        tablePane2.addCell(new JLabel("Subgroup name/identifier:")).newRow();
        tablePane2.addCell(this.suName).newRow();
        tablePane2.addCell(this.suIsOff).newRow();
        tablePane2.addCell(this.suNoButton).newRow();
        tablePane2.addCell(this.suDominant).newRow();
        tablePane2.addCell(this.suRecessiveOn).newRow();
        tablePane2.startSubtable();
        tablePane2.center().memorize();
        tablePane2.addCell(this.suOK).addCell(this.suCancel);
        tablePane2.endSubtable();
    }

    void makeListDialog() {
        this.liDialog = new JDialog(this.ownerWindow, "Edit list properties", true);
        this.liDialog.setDefaultCloseOperation(0);
        this.liPanel = new TablePane();
        this.liDialog.setContentPane(this.liPanel);
        this.liName = new JTextField(20);
        this.liIsOff = new JCheckBox("off (Hide this list from view)");
        this.liNoButton = new JCheckBox("nobutton (Don't provide on/off button)");
        this.liNoHilite = new JCheckBox("nohighlight (No highlight on balls)");
        this.liWidth = new JTextField(6);
        JLabel jLabel = new JLabel("Line width:");
        jLabel.setLabelFor(this.liWidth);
        this.liRadius = new JTextField(6);
        JLabel jLabel2 = new JLabel("Ball radius:");
        jLabel2.setLabelFor(this.liRadius);
        this.liAlpha = new JTextField(6);
        JLabel jLabel3 = new JLabel("Alpha (0-255):");
        jLabel3.setLabelFor(this.liAlpha);
        KingPrefs kingPrefs = this.kMain.getPrefs();
        int n = kingPrefs == null ? 20 : kingPrefs.getInt("colorSwatchSize");
        this.liPicker = new ColorPicker(0, n);
        this.liPicker.addChangeListener(this);
        this.liOK = new JButton(new ReflectiveAction("OK", null, this, "onListOK"));
        this.liCancel = new JButton(new ReflectiveAction("Cancel", null, this, "onListCancel"));
        this.liDialog.getRootPane().setDefaultButton(this.liOK);
        this.liPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.liPanel.insets(2).hfill(true).vfill(false).top();
        this.liPanel.startSubtable();
        this.liPanel.addCell(new JLabel("List name/identifier:"), 2, 1).newRow();
        this.liPanel.addCell(this.liName, 2, 1).newRow();
        this.liPanel.addCell(this.liIsOff, 2, 1).newRow();
        this.liPanel.addCell(this.liNoButton, 2, 1).newRow();
        this.liPanel.addCell(this.liNoHilite, 2, 1).newRow();
        this.liPanel.addCell(jLabel).addCell(this.liWidth).newRow();
        this.liPanel.addCell(jLabel2).addCell(this.liRadius).newRow();
        this.liPanel.addCell(jLabel3).addCell(this.liAlpha).newRow();
        this.liPanel.endSubtable();
        this.liPanel.startSubtable(1, 2);
        this.liPanel.addCell(new JLabel("List color:"));
        this.liPanel.newRow();
        this.liPanel.addCell(this.liPicker);
        this.liPanel.endSubtable();
        this.liPanel.newRow();
        this.liPanel.bottom().startSubtable();
        this.liPanel.center();
        this.liPanel.add(this.liOK);
        this.liPanel.add(this.liCancel);
        this.liPanel.endSubtable();
    }

    private void makeTransformDialog() {
        this.trDialog = new JDialog(this.ownerWindow, "Transform coordinates", true);
        this.trDialog.setDefaultCloseOperation(1);
        this.trTransX = new JTextField(6);
        this.trTransY = new JTextField(6);
        this.trTransZ = new JTextField(6);
        this.trRotX = new JTextField(6);
        this.trRotY = new JTextField(6);
        this.trRotZ = new JTextField(6);
        this.trScale = new JTextField(6);
        this.trScaleX = new JTextField(6);
        this.trScaleY = new JTextField(6);
        this.trScaleZ = new JTextField(6);
        this.trBtnTrans = new JButton(new ReflectiveAction("Translate", null, this, "onTransformTranslate"));
        this.trBtnRot = new JButton(new ReflectiveAction("Rotate", null, this, "onTransformRotate"));
        this.trBtnAniso = new JButton(new ReflectiveAction("Stretch", null, this, "onTransformAnisoScale"));
        this.trBtnScale = new JButton(new ReflectiveAction("Scale", null, this, "onTransformScale"));
        this.trClose = new JButton(new ReflectiveAction("Close", null, this, "onTransformClose"));
        this.trAboutOrigin = new JCheckBox("Rotate/scale about origin", false);
        this.trPanel = new TablePane2();
        this.trPanel.insets(2).weights(1.0, 1.0).memorize();
        this.trPanel.add(new JLabel("X"));
        this.trPanel.add(new JLabel("Y"));
        this.trPanel.add(new JLabel("Z"));
        this.trPanel.newRow();
        this.trPanel.add(this.trTransX);
        this.trPanel.add(this.trTransY);
        this.trPanel.add(this.trTransZ);
        this.trPanel.hfill(true).add(this.trBtnTrans);
        this.trPanel.newRow();
        this.trPanel.add(this.trRotX);
        this.trPanel.add(this.trRotY);
        this.trPanel.add(this.trRotZ);
        this.trPanel.hfill(true).add(this.trBtnRot);
        this.trPanel.newRow();
        this.trPanel.add(this.trScaleX);
        this.trPanel.add(this.trScaleY);
        this.trPanel.add(this.trScaleZ);
        this.trPanel.hfill(true).add(this.trBtnAniso);
        this.trPanel.newRow();
        this.trPanel.center().add((Component)new JLabel("Scale factor:"), 2, 1);
        this.trPanel.add(this.trScale);
        this.trPanel.hfill(true).add(this.trBtnScale);
        this.trPanel.newRow();
        this.trPanel.center().add((Component)this.trAboutOrigin, 4, 1);
        this.trPanel.newRow();
        this.trPanel.center().add((Component)this.trClose, 4, 1);
        this.trDialog.setContentPane(this.trPanel);
    }

    public void transform(AGE aGE) {
        this.trTarget = aGE;
        this.trClearFields();
        this.trDialog.pack();
        if (this.trFirstShow) {
            this.trDialog.setLocationRelativeTo(this.ownerWindow);
            this.trFirstShow = false;
        }
        this.trDialog.setVisible(true);
    }

    private void trClearFields() {
        this.trTransX.setText("0.0");
        this.trTransY.setText("0.0");
        this.trTransZ.setText("0.0");
        this.trRotX.setText("0.0");
        this.trRotY.setText("0.0");
        this.trRotZ.setText("0.0");
        this.trScale.setText("1.0");
        this.trScaleX.setText("1.0");
        this.trScaleY.setText("1.0");
        this.trScaleZ.setText("1.0");
    }

    public boolean editKinemage(Kinemage kinemage) {
        this.kiName.setText(kinemage.getName());
        this.kiName.selectAll();
        this.kiName.requestFocus();
        this.kiWhiteback.setSelected(kinemage.atWhitebackground);
        this.kiOnewidth.setSelected(kinemage.atOnewidth);
        this.kiThinline.setSelected(kinemage.atThinline);
        this.kiPerspec.setSelected(kinemage.atPerspective);
        this.kiFlat.setSelected(kinemage.atFlat);
        this.kiListcolor.setSelected(kinemage.atListcolordominant);
        this.kiDialog.pack();
        this.kiDialog.setLocationRelativeTo(this.ownerWindow);
        this.kiDialog.setVisible(true);
        if (this.acceptChanges) {
            kinemage.setName(this.kiName.getText());
            kinemage.atWhitebackground = this.kiWhiteback.isSelected();
            kinemage.atOnewidth = this.kiOnewidth.isSelected();
            kinemage.atThinline = this.kiThinline.isSelected();
            kinemage.atPerspective = this.kiPerspec.isSelected();
            kinemage.atFlat = this.kiFlat.isSelected();
            kinemage.atListcolordominant = this.kiListcolor.isSelected();
            this.markKinModified(kinemage);
            this.kMain.publish(new KMessage(this, 512L));
        }
        return this.acceptChanges;
    }

    public boolean editGroup(KGroup kGroup) {
        this.grName.setText(kGroup.getName());
        this.grName.selectAll();
        this.grName.requestFocus();
        this.grIsOff.setSelected(!kGroup.isOn());
        this.grNoButton.setSelected(!kGroup.hasButton());
        this.grDominant.setSelected(kGroup.isDominant());
        this.grRecessiveOn.setSelected(kGroup.isCollapsible());
        this.grAnimate.setSelected(kGroup.isAnimate());
        this.gr2Animate.setSelected(kGroup.is2Animate());
        this.grSelect.setSelected(kGroup.isSelect());
        this.grDialog.pack();
        this.grDialog.setLocationRelativeTo(this.ownerWindow);
        this.grDialog.setVisible(true);
        if (this.acceptChanges) {
            kGroup.setName(this.grName.getText());
            kGroup.setOn(!this.grIsOff.isSelected());
            kGroup.setHasButton(!this.grNoButton.isSelected());
            kGroup.setDominant(this.grDominant.isSelected());
            kGroup.setCollapsible(this.grRecessiveOn.isSelected());
            kGroup.setAnimate(this.grAnimate.isSelected());
            kGroup.set2Animate(this.gr2Animate.isSelected());
            kGroup.setSelect(this.grSelect.isSelected());
            this.markKinModified(kGroup);
        }
        return this.acceptChanges;
    }

    public boolean editSubgroup(KGroup kGroup) {
        this.suName.setText(kGroup.getName());
        this.suName.selectAll();
        this.suName.requestFocus();
        this.suIsOff.setSelected(!kGroup.isOn());
        this.suNoButton.setSelected(!kGroup.hasButton());
        this.suDominant.setSelected(kGroup.isDominant());
        this.suRecessiveOn.setSelected(kGroup.isCollapsible());
        this.suDialog.pack();
        this.suDialog.setLocationRelativeTo(this.ownerWindow);
        this.suDialog.setVisible(true);
        if (this.acceptChanges) {
            kGroup.setName(this.suName.getText());
            kGroup.setOn(!this.suIsOff.isSelected());
            kGroup.setHasButton(!this.suNoButton.isSelected());
            kGroup.setDominant(this.suDominant.isSelected());
            kGroup.setCollapsible(this.suRecessiveOn.isSelected());
            this.markKinModified(kGroup);
        }
        return this.acceptChanges;
    }

    public boolean editList(KList kList) {
        this.theKList = kList;
        this.liName.setText(kList.getName());
        this.liName.selectAll();
        this.liName.requestFocus();
        this.liIsOff.setSelected(!kList.isOn());
        this.liNoButton.setSelected(!kList.hasButton());
        this.liNoHilite.setSelected(kList.getNoHighlight());
        this.liWidth.setText(Integer.toString(kList.getWidth()));
        this.liRadius.setText(Float.toString(kList.getRadius()));
        this.liAlpha.setText(Integer.toString(kList.getAlpha()));
        this.originalColor = kList.getColor();
        this.liPicker.setBackgroundMode(this.kMain.getCanvas().getEngine().backgroundMode);
        this.liPicker.setExtras(this.kMain.getKinemage().getNewPaintMap().values());
        this.liPicker.setSelection(this.originalColor);
        this.liDialog.pack();
        if (this.liFirstShow) {
            this.liDialog.setLocationRelativeTo(this.ownerWindow);
            this.liFirstShow = false;
        }
        this.liDialog.setVisible(true);
        if (this.acceptChanges) {
            kList.setName(this.liName.getText());
            kList.setOn(!this.liIsOff.isSelected());
            kList.setHasButton(!this.liNoButton.isSelected());
            kList.setNoHighlight(this.liNoHilite.isSelected());
            try {
                kList.setWidth(Integer.parseInt(this.liWidth.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (kList.getWidth() < 1) {
                kList.setWidth(1);
            }
            if (kList.getWidth() > 7) {
                kList.setWidth(7);
            }
            try {
                kList.setRadius(Float.parseFloat(this.liRadius.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                kList.setAlpha(Integer.parseInt(this.liAlpha.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (kList.getAlpha() < 0) {
                kList.setAlpha(0);
            }
            if (kList.getAlpha() > 255) {
                kList.setAlpha(255);
            }
            this.markKinModified(kList);
        } else {
            kList.setColor(this.originalColor);
        }
        this.theKList = null;
        return this.acceptChanges;
    }

    public void onKinemageOK(ActionEvent actionEvent) {
        this.acceptChanges = true;
        this.kiDialog.dispose();
    }

    public void onKinemageCancel(ActionEvent actionEvent) {
        this.acceptChanges = false;
        this.kiDialog.dispose();
    }

    public void onGroupOK(ActionEvent actionEvent) {
        this.acceptChanges = true;
        this.grDialog.dispose();
    }

    public void onGroupCancel(ActionEvent actionEvent) {
        this.acceptChanges = false;
        this.grDialog.dispose();
    }

    public void onSubgroupOK(ActionEvent actionEvent) {
        this.acceptChanges = true;
        this.suDialog.dispose();
    }

    public void onSubgroupCancel(ActionEvent actionEvent) {
        this.acceptChanges = false;
        this.suDialog.dispose();
    }

    public void onListOK(ActionEvent actionEvent) {
        this.acceptChanges = true;
        this.liDialog.dispose();
    }

    public void onListCancel(ActionEvent actionEvent) {
        this.acceptChanges = false;
        this.liDialog.dispose();
    }

    public void onTransformClose(ActionEvent actionEvent) {
        this.trDialog.dispose();
        this.trTarget = null;
    }

    public void onTransformTranslate(ActionEvent actionEvent) {
        try {
            float f = Float.parseFloat(this.trTransX.getText().trim());
            float f2 = Float.parseFloat(this.trTransY.getText().trim());
            float f3 = Float.parseFloat(this.trTransZ.getText().trim());
            GroupEditor.translate(this.trTarget, f, f2, f3);
            this.markKinModified(this.trTarget);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.trClearFields();
    }

    public void onTransformRotate(ActionEvent actionEvent) {
        float f;
        float f2;
        float f3;
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        if (this.trAboutOrigin.isSelected()) {
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        } else {
            this.trTarget.calcBoundingBox(fArray);
            f = (fArray[3] + fArray[0]) / 2.0f;
            f2 = (fArray[4] + fArray[1]) / 2.0f;
            f3 = (fArray[5] + fArray[2]) / 2.0f;
        }
        Transform transform = new Transform().likeTranslation(-f, -f2, -f3);
        Transform transform2 = new Transform();
        try {
            double d = Double.parseDouble(this.trRotX.getText().trim());
            double d2 = Double.parseDouble(this.trRotY.getText().trim());
            double d3 = Double.parseDouble(this.trRotZ.getText().trim());
            transform2.likeRotation(new Triple(1.0, 0.0, 0.0), d);
            transform.append(transform2);
            transform2.likeRotation(new Triple(0.0, 1.0, 0.0), d2);
            transform.append(transform2);
            transform2.likeRotation(new Triple(0.0, 0.0, 1.0), d3);
            transform.append(transform2);
            transform2.likeTranslation(f, f2, f3);
            transform.append(transform2);
            GroupEditor.rotate(this.trTarget, transform);
            this.markKinModified(this.trTarget);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.trClearFields();
    }

    public void onTransformScale(ActionEvent actionEvent) {
        float f;
        float f2;
        float f3;
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        if (this.trAboutOrigin.isSelected()) {
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        } else {
            this.trTarget.calcBoundingBox(fArray);
            f = (fArray[3] + fArray[0]) / 2.0f;
            f2 = (fArray[4] + fArray[1]) / 2.0f;
            f3 = (fArray[5] + fArray[2]) / 2.0f;
        }
        try {
            float f4 = Float.parseFloat(this.trScale.getText().trim());
            GroupEditor.scale(this.trTarget, f, f2, f3, f4, f4, f4);
            this.markKinModified(this.trTarget);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.trClearFields();
    }

    public void onTransformAnisoScale(ActionEvent actionEvent) {
        float f;
        float f2;
        float f3;
        float[] fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        if (this.trAboutOrigin.isSelected()) {
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        } else {
            this.trTarget.calcBoundingBox(fArray);
            f = (fArray[3] + fArray[0]) / 2.0f;
            f2 = (fArray[4] + fArray[1]) / 2.0f;
            f3 = (fArray[5] + fArray[2]) / 2.0f;
        }
        try {
            float f4 = Float.parseFloat(this.trScaleX.getText().trim());
            float f5 = Float.parseFloat(this.trScaleY.getText().trim());
            float f6 = Float.parseFloat(this.trScaleZ.getText().trim());
            GroupEditor.scale(this.trTarget, f, f2, f3, f4, f5, f6);
            this.markKinModified(this.trTarget);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.trClearFields();
    }

    public static void translate(AGE aGE, float f, float f2, float f3) {
        if (aGE instanceof KList) {
            for (KPoint kPoint : aGE) {
                kPoint.setX(kPoint.getX() + (double)f);
                kPoint.setY(kPoint.getY() + (double)f2);
                kPoint.setZ(kPoint.getZ() + (double)f3);
            }
        } else {
            Iterator iterator = aGE.iterator();
            while (iterator.hasNext()) {
                GroupEditor.translate((AGE)iterator.next(), f, f2, f3);
            }
        }
    }

    public static void rotate(AGE aGE, Transform transform) {
        if (aGE instanceof KList) {
            Triple triple = new Triple();
            for (KPoint kPoint : aGE) {
                triple.setXYZ(kPoint.getX(), kPoint.getY(), kPoint.getZ());
                transform.transform(triple);
                kPoint.setX(triple.getX());
                kPoint.setY(triple.getY());
                kPoint.setZ(triple.getZ());
            }
        } else {
            Iterator iterator = aGE.iterator();
            while (iterator.hasNext()) {
                GroupEditor.rotate((AGE)iterator.next(), transform);
            }
        }
    }

    public static void scale(AGE aGE, float f, float f2, float f3, float f4, float f5, float f6) {
        if (aGE instanceof KList) {
            float f7 = (float)Math.sqrt((double)(f4 * f4 + f5 * f5 + f6 * f6) / 3.0);
            KList kList = (KList)aGE;
            kList.setRadius(f7 * kList.getRadius());
            for (KPoint kPoint : aGE) {
                kPoint.setX((kPoint.getX() - (double)f) * (double)f4 + (double)f);
                kPoint.setY((kPoint.getY() - (double)f2) * (double)f5 + (double)f2);
                kPoint.setZ((kPoint.getZ() - (double)f3) * (double)f6 + (double)f3);
                if (!(kPoint instanceof BallPoint)) continue;
                kPoint.setRadius(f7 * kPoint.getRadius());
            }
        } else {
            Iterator iterator = aGE.iterator();
            while (iterator.hasNext()) {
                GroupEditor.scale((AGE)iterator.next(), f, f2, f3, f4, f5, f6);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.theKList.setColor(this.liPicker.getSelection());
    }

    void markKinModified(AGE aGE) {
        Kinemage kinemage = aGE.getKinemage();
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }
}

