/*
 * Decompiled with CFR 0.152.
 */
package driftwood.data;

import driftwood.data.HashFunction;
import driftwood.data.NullNaturalComparator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CheapSet
extends AbstractSet {
    static final int HASH_MULT = -1640531527;
    static final Object DELETED_PROXY = new Object();
    final HashFunction hashFunc;
    Object[] setEntries;
    int setSize = 0;
    final double loadFactor;
    int log2Capacity;
    int hashMask;
    int numChanges = 0;

    public CheapSet() {
        this(16);
    }

    public CheapSet(int n) {
        this(n, 0.75);
    }

    public CheapSet(int n, double d) {
        this(n, d, null);
    }

    public CheapSet(HashFunction hashFunction) {
        this(16, 0.75, null);
    }

    public CheapSet(int n, HashFunction hashFunction) {
        this(n, 0.75, null);
    }

    public CheapSet(int n, double d, HashFunction hashFunction) {
        this.hashFunc = hashFunction == null ? new NullNaturalComparator() : hashFunction;
        if (d < 0.1) {
            d = 0.1;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.loadFactor = d;
        this.log2Capacity = 4;
        while (1 << this.log2Capacity < n && this.log2Capacity < 30) {
            ++this.log2Capacity;
        }
        int n2 = 1 << this.log2Capacity;
        this.setEntries = new Object[n2];
        this.hashMask = this.setEntries.length - 1;
    }

    public CheapSet(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    private final int index(int n) {
        n = -1640531527 * n;
        n = n >>> 32 - this.log2Capacity & this.hashMask;
        return n;
    }

    private final void rehash(int n) {
        if (this.log2Capacity == 30) {
            throw new UnsupportedOperationException("Set has reached maximum size");
        }
        CheapSet cheapSet = new CheapSet(n, this.loadFactor, this.hashFunc);
        cheapSet.addAll(this);
        this.setEntries = cheapSet.setEntries;
        this.setSize = cheapSet.setSize;
        this.log2Capacity = cheapSet.log2Capacity;
        this.hashMask = cheapSet.hashMask;
        ++this.numChanges;
    }

    public void ensureCapacity(int n) {
        if (n > this.setEntries.length) {
            this.rehash(n);
        }
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public boolean add(Object object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("CheapSet cannot contain nulls");
        }
        if ((double)(this.setSize + 1) > this.loadFactor * (double)this.setEntries.length) {
            this.rehash(this.setEntries.length * 2);
        }
        int n = this.index(this.hashFunc.hashCodeFor(object));
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            if ((object2 = this.setEntries[n4 = n + (n2 += n3++) & this.hashMask]) != null && object2 != DELETED_PROXY) continue;
            this.setEntries[n4] = object;
            ++this.setSize;
            ++this.numChanges;
            return true;
        } while (!this.hashFunc.areEqual(object2, object));
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.setEntries.length; ++i) {
            this.setEntries[i] = null;
        }
        this.setSize = 0;
        ++this.numChanges;
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("CheapSet cannot contain nulls");
        }
        int n = this.index(this.hashFunc.hashCodeFor(object));
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            if ((object2 = this.setEntries[n4 = n + (n2 += n3++) & this.hashMask]) != null) continue;
            return null;
        } while (object2 == DELETED_PROXY || !this.hashFunc.areEqual(object2, object));
        return object2;
    }

    public Iterator iterator() {
        return new CheapIterator();
    }

    public boolean remove(Object object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("CheapSet cannot contain nulls");
        }
        int n = this.index(this.hashFunc.hashCodeFor(object));
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            if ((object2 = this.setEntries[n4 = n + (n2 += n3++) & this.hashMask]) != null) continue;
            return false;
        } while (object2 == DELETED_PROXY || !this.hashFunc.areEqual(object2, object));
        this.setEntries[n4] = DELETED_PROXY;
        --this.setSize;
        return true;
    }

    public int size() {
        return this.setSize;
    }

    class CheapIterator
    implements Iterator {
        int lastEntry = -1;
        int nextEntry = -1;
        int expectedNumChanges;

        public CheapIterator() {
            this.expectedNumChanges = CheapSet.this.numChanges;
        }

        public boolean hasNext() {
            this.checkForMods();
            if (this.nextEntry == -1) {
                this.findNext();
            }
            return this.nextEntry != -1;
        }

        private void findNext() {
            Object[] objectArray = CheapSet.this.setEntries;
            this.nextEntry = this.lastEntry + 1;
            while (this.nextEntry < objectArray.length) {
                Object object = objectArray[this.nextEntry];
                if (object != null && object != DELETED_PROXY) {
                    return;
                }
                ++this.nextEntry;
            }
            this.nextEntry = -1;
        }

        public Object next() {
            this.checkForMods();
            if (this.nextEntry == -1) {
                this.findNext();
            }
            if (this.nextEntry == -1) {
                throw new NoSuchElementException("No more elements in iteration");
            }
            this.lastEntry = this.nextEntry;
            this.nextEntry = -1;
            return CheapSet.this.setEntries[this.lastEntry];
        }

        public void remove() {
            this.checkForMods();
            if (this.lastEntry != -1) {
                CheapSet.this.setEntries[this.lastEntry] = DELETED_PROXY;
                --CheapSet.this.setSize;
            } else {
                throw new NoSuchElementException("No elements have yet been returned by this iterator");
            }
            this.expectedNumChanges = ++CheapSet.this.numChanges;
        }

        private void checkForMods() {
            if (this.expectedNumChanges != CheapSet.this.numChanges) {
                throw new ConcurrentModificationException("Backing set was changed during iteration");
            }
        }
    }
}

