/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "userwgt.h"
#include "globals.h"

#include "userinfo.h"

UserWgt::UserWgt(QListWidget* parent) :
  QObject(0),
  QListWidgetItem(parent),
  m_info(NULL)
{

}
//\*****************************************************************************
UserWgt::~UserWgt()
{
  qDebug("[~UserWgt]\n");
  delete m_info;
}
//\*****************************************************************************
void UserWgt::setInfo(UserInfo* info)
{
  m_info = info;
  setText(m_info->nickname());
}
//\*****************************************************************************
