/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef SMILESWGT_H
#define SMILESWGT_H

#include <QWidget>
#include <QLayout>
#include <QLabel>
#include <QMouseEvent>

struct Smile
{
  QStringList smiles;
  QString     name;
  Smile(QStringList smiles_, QString name_){smiles = smiles_; name = name_;}
};

class SmileLabel;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class SmilesWgt : public QWidget
{
  Q_OBJECT
  private:
    bool         m_inited;
    QGridLayout* m_grid;
    SmileLabel** m_smiles;
    int          m_smilesNum;
    int          m_smilesMaxNum;

  public:
    SmilesWgt(QWidget *parent = 0);
    ~SmilesWgt();

    void init();
    void loadTheme(const QString &);
    bool inited() const {return m_inited;}
    void clear();

  private:
    void addSmile(const QString &, const QStringList &, const QString &);

  signals:
    void smileClicked(const QString &);

};

#endif
