/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "smilelabel.h"

#include <QSize>
#include <QToolTip>
#include <QPixmap>

SmileLabel::SmileLabel(QWidget *parent) :
  QLabel(parent), m_inited(false)
{
  m_movie  = new QMovie(this);

  setMovie(m_movie);
  setAlignment(Qt::AlignCenter);
  setMouseTracking(true);
}

SmileLabel::~SmileLabel()
{

}

bool SmileLabel::load( const QString & prefix )
{
  if(!m_filename.isEmpty())
  {
    QPixmap pix(prefix + "/" + m_filename);
    m_movie->setFileName(prefix + "/" + m_filename);
//     m_movie->start();
    m_movie->jumpToNextFrame();

    m_inited = (m_movie->isValid() && !m_smileStrings.isEmpty ());
  }
  else
    return false;

  return true;
}

void SmileLabel::setSmileText(const QStringList & list)
{
  m_smileStrings = list;

  if(!m_smileStrings.isEmpty () && m_movie->isValid() && !m_filename.isEmpty())
  {
    setToolTip(m_smileStrings[0]);
    m_inited = true;
  }
  else
    m_inited = false;
}
