/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "preferences.h"
#include "globals.h"

#include <QObject>
#include <QApplication>

QString Preferences::m_settingsDir;
bool    Preferences::m_allowDiffPorts = false;
quint16 Preferences::m_portIn  = 61108;
quint16 Preferences::m_portOut = 61108;
quint64 Preferences::m_ip      = 0x7f000001;
QHostAddress Preferences::m_broadcast(0xffffffff);
quint64 Preferences::m_customIp = 0x7f000001;
QHostAddress Preferences::m_customBroadcast(0xffffffff);

Preferences::Preferences():
  m_myMsgsColor     (Qt::red),
  m_sysMsgsColor    (Qt::gray),
  m_baseMsgColor    (Qt::black),
  m_colorWholeMsg   (0),
  m_colorWholeSysMsg(1),
  m_displayMsgFormat("%time%hh:mm:ss%time% | [[%user@%comp]] : "),
  m_nlMode          (0),
  m_nlFormat        (QObject::tr("Now Listening to : %t by %a on %b")),
  m_nHistoryMsgs    (-1),
  m_historyReqTimeout(5000),
  m_smilesThemePath (defaultSmilesDir()),
  m_usersListRefreshInterval(60),
  m_usersListDeepRefreshInterval(600),
  m_isExecuteCommandOnIncomingMsg(true),
  m_warningAboutTray(true)
{
}

void Preferences::setStatusDescription(const QString & descr, int status)
{
  Q_ASSERT(status >=0 && status < 6 || status == Globals::INVISIBLE);

  if(status != Globals::INVISIBLE)
    m_statusDescription[status] = descr;
}

const QString & Preferences::statusDescription(int status) const
{
  Q_ASSERT(status >=0 && status < 6 || status == Globals::INVISIBLE);

  if(status == Globals::INVISIBLE)
    return m_statusDescription[0];

  return m_statusDescription[status];
}

void Preferences::appendStatusDescription(const QString & value)
{
 if(!value.isEmpty() && !m_statusDescriptions.contains(value))
 {
   m_statusDescriptions.removeAll(value);
   m_statusDescriptions.prepend(value);
 }
}

QString Preferences::defaultSmilesDir()
{
  QList<QDir> dirs;
  QString res;
  QDir dir;

  dirs.append(QDir(Globals::prefs()->settingsDir() + "/smiles"));

#if defined(Q_OS_LINUX)
  dir.setPath(QApplication::applicationDirPath());
  if(dir.cd("../share/qchat/emoticons"))
    dirs.append(dir);
#else
  dirs.append(QDir(QApplication::applicationDirPath() + "/emoticons"));
#endif

  res = defaultSmilesDir(dirs);

#if defined(Q_OS_LINUX)
  if(res.isEmpty())
  {
    dirs.clear();
    dirs.append(QDir(QDir::homePath() + "/.kde/share/emoticons"));

    dir.setPath(QApplication::applicationDirPath());
    if(dir.cd("../share/emoticons"))
      dirs.append(dir);

    res = defaultSmilesDir(dirs);
  }
#endif

  return res;
}

QString Preferences::defaultSmilesDir(QList<QDir> dirs)
{
  QString res;

  foreach(QDir dir, dirs)
    if(dir.exists())
      foreach(QString em_dir, dir.entryList())
      {
        if(em_dir == "." || em_dir == ".." || QFileInfo(dir.absolutePath() + "/" + em_dir).isFile() ||
           !QFile(dir.absolutePath() + "/" + em_dir + "/emoticons.xml").exists())
          continue;

        if(res.isEmpty())
          res = dir.absolutePath() + "/" + em_dir + "/";

        if(!em_dir.compare("default", Qt::CaseInsensitive))
          return dir.absolutePath() + "/" + em_dir + "/";

        else if(em_dir.contains("default", Qt::CaseInsensitive))
          res = dir.absolutePath() + "/" + em_dir + "/";
      }

  return res;
}
