#ifndef VISUAL_COLOR_H
#define VISUAL_COLOR_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "cvisual.h"

namespace visual {

class rgb 
{
public:
	float r;
	float g;
	float b;

	inline rgb() :r(1.0), g(1.0), b(1.0) {}  // white
	inline rgb( float bw) : r(bw), g(bw), b(bw) {} // From grayscale.
	inline rgb( float _r, float _g, float _b) :r(_r), g(_g), b(_b){}

	rgb unsaturate() const;
	float grayscale() const;
};

} // !namespace visual

#endif  // !VISUAL_COLOR_H
