from numpy import arange, array, sin, cos, atleast_1d, transpose, dot

curfit_test = {
#inputs:
'y' : array([1.0,1.0,1.4,1.1,1.0,1.0,4.0,9.0,13.0,
         13.4,12.8,13.1,13.0,14.0,13.0,13.5,10.0,
         2.0,3.0,2.5,2.5,2.5,3.0,4.0,3.5]),
'x' : arange(25.0)}

curfit_test_smth = {
#inputs:
'k' : [3, 3, 3, 5, 5, 5],
's' : [1000, 60, 0, 60, 10, 0],
'iopt' : [0, 1, 1, 0, 1, 1],
# results:
'fp' : array([0.265483E+03, 0.600380E+02, 0.000000E+00, 0.600201E+02,
              0.100002E+02, 0.000000E+00]),
'ier' : array([-2, 0, -1, 0, 0, -1]),
'n' : array([8, 11, 29, 13, 21, 31]),
't' : [array([0.0,    0.0,    0.0,    0.0,   24.0,   24.0,   24.0,   24.0]),
     array([0.0,    0.0,    0.0,    0.0,   12.0,   15.0,   18.0,   24.0,
            24.0,   24.0,   24.0]),
     array([0.0,    0.0,    0.0,    0.0,    2.0,    3.0,    4.0,    5.0,
            6.0,    7.0,    8.0,    9.0,   10.0,   11.0,   12.0,   13.0,
            14.0,   15.0,   16.0,   17.0,   18.0,   19.0,   20.0,   21.0,
            22.0,   24.0,   24.0,   24.0,   24.0]),
     array([0.0,    0.0,    0.0,    0.0,    0.0,    0.0,   12.0,   24.0,
            24.0,   24.0,   24.0,   24.0,   24.0]),
     array([0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    6.0,    8.0,
            9.0,   12.0,   14.0,   15.0,   16.0,   17.0,   18.0,   24.0,
            24.0,   24.0,   24.0,   24.0,   24.0]),
     array([0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    3.0,    4.0,
            5.0,    6.0,    7.0,    8.0,    9.0,   10.0,   11.0,   12.0,
            13.0,   14.0,   15.0,   16.0,   17.0,   18.0,   19.0,   20.0,
            21.0,   24.0,   24.0,   24.0,   24.0,   24.0,   24.0])],
'c' : [array([-3.5307,   19.6679,   10.0310,    0.5226]),
      array([1.7450,   -6.1367,   21.0990,   11.1564,   -0.1060,    2.0998,
             4.3288]),
      array([1.0000,    0.4704,    1.8592,    0.9446,    1.1911,    0.2910,
             3.6448,    9.1297,   13.8362,   13.5254,   12.4622,   13.4258,
             12.4346,   14.8358,   12.2222,   14.2755,   11.6757,   -0.9783,
             4.2375,    2.0285,    2.6486,    2.3770,    2.9986,    4.8757,
             3.5000]),
      array([1.9049,   -2.6240,    0.5773,   45.0508,  -10.0998,    2.7788,
             4.2385]),
      array([1.0179,   -1.2191,    9.2752,  -12.6640,   17.3909,   13.0655,
             11.7046,   14.2824,   14.9330,    8.7780,   -2.6436,    5.4611,
             0.5460,    4.9279,    3.5774]),
      array([1.0000,   -0.7624,    3.5842,   -0.4712,    2.4346,   -0.3988,
             3.6292,    9.0283,   14.4832,   13.6084,   11.9251,   14.2042,
             11.3359,   16.1291,   11.2375,   14.3636,  14.1766,   -4.8942,
             6.9048,    0.5376,    4.5146,    0.4259,    4.7049,    4.4036,
             3.5000])],
'sp' : [array([-3.5, -0.8,  1.6,  3.7,  5.5,  7.0,  8.2,  9.2,  9.9, 10.5,
            10.8, 10.8, 10.8, 10.5, 10.1,  9.5,  8.9,  8.1,  7.2,  6.2,
             5.1,  4.0,  2.9,  1.7,  0.5]),
      array([1.7,  0.4,  0.0,  0.6,  1.8,  3.6,  5.6,  7.8, 10.0, 12.0,
             13.5, 14.5, 14.7, 14.0, 12.6, 10.6,  8.2,  5.9,  3.9,  2.6,
             2.1,  2.1,  2.5,  3.3,  4.3]),
      array([1.0,  1.0,  1.4,  1.1,  1.0,  1.0,  4.0,  9.0, 13.0, 13.4,
             12.8, 13.1, 13.0, 14.0, 13.0, 13.5, 10.0,  2.0,  3.0,  2.5,
             2.5,  2.5,  3.0,  4.0,  3.5]),
      array([1.9,  0.5, -0.1,  0.3,  1.5,  3.4,  5.6,  8.0, 10.3, 12.3,
             13.8, 14.5, 14.5, 13.7, 12.3, 10.3,  8.2,  6.0,  4.1,  2.8,
             2.0,  2.0,  2.5,  3.4,  4.2]),
      array([1.0,  0.9,  1.5,  1.2,  0.6,  1.2,  4.2,  8.9, 12.6, 13.6,
             13.2, 12.7, 12.9, 13.7, 14.2, 12.9,  8.6,  4.1,  2.3,  2.2,
             2.4,  2.7,  3.2,  3.7,  3.6]),
      array([1.0,  1.0,  1.4,  1.1,  1.0,  1.0,  4.0,  9.0, 13.0, 13.4,
             12.8, 13.1, 13.0, 14.0, 13.0, 13.5, 10.0,  2.0,  3.0,  2.5,
             2.5,  2.5,  3.0,  4.0,  3.5])]
}

curfit_test_lsq = {
#inputs:
'k' : [3, 5],
# results:
'fp' : array([0.234182E+02, 0.155243E+02]),
'ier' : array([0, 0]),
't' : [array([3.0,    6.0,    9.0,   12.0,   15.0,   18.0,   21.0]),
       array([3.0,    6.0,    9.0,   12.0,   15.0,   18.0,   21.0])],
'c' : [array([0.8505,    2.4795,   -0.9480,    2.8341,   17.4216,   10.3854,
              17.1927,   -2.9343,    5.6395,    2.4292,    3.7180]),
       array([1.0199,   -1.6630,    6.3167,   -4.5892,    1.6163,   22.6478,
              3.5130,   27.5439,  -16.2085,   15.0884,   -5.3102,    8.6487,
              3.4724])], 
'sp' : [array([0.9,  1.5,  1.1,  0.5,  0.8,  2.2,  4.6,  8.1, 11.6, 13.8,
               14.1, 13.3, 12.7, 13.2, 13.7, 12.7,  9.3,  5.0,  1.8,  1.3,
               2.3,  3.4,  3.5,  3.2,  3.7]),
        array([1.0,  0.8,  1.8,  0.9,  0.3,  1.6,  4.7,  8.6, 12.0, 13.7, 
               13.7, 12.8, 12.7, 13.5, 14.2, 12.8,  8.9,  4.4,  1.8,  1.9,
               3.0,  3.0,  2.4,  4.2,  3.5])]
}

percur_test = {
'x' : array([0.0,3.922,7.843,11.765,15.686,
     19.608,23.509,27.451,31.373,35.294,39.216,43.137,47.059,50.980,
     54.902,58.824,62.745,66.667,70.588,74.510,78.431,82.353,86.275,
     90.196,94.118,98.039, 100.0]),
'y' : array([10.099,14.835,21.453,25.022,22.427,
     22.315,22.070,19.673,16.754,13.983,11.973,12.286,16.129,21.560,
     28.041,39.205,59.489,72.559,75.960,79.137,75.925,68.809,55.758,
     39.915,22.006,12.076, 10.099]),
'k' : [3, 3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5], 
'iopt' : [0, 1, 1, 1, 0, 0, -1, 0, 1, 1, 1, 0, 0, -1], 
's' : [65000.0, 500.0, 5.0, 20.0, 20.0, 0.0, -1.0, 65000.0, 500.0, 5.0, 
                                                    20.0, 20.0, 0.0, -1],
'res' : [0.140221E+05,0.500033E+03,0.499936E+01,0.200010E+02,0.199981E+02,
         0.000000E+00,0.638916E+02,0.140221E+05,0.499538E+03,0.500125E+01,
         0.200032E+02, 0.199998E+02, 0.000000E+00, 0.627153E+02],  
'err' : [-2, 0, 0, 0, 0, -1, 0, -2, 0, 0, 0, 0, -1, 0],
'knots' : [[-300.000, -200.000, -100.000,    0.000,  100.000,  200.000,
             300.000,  400.000], 
         [-49.020,  -33.333,  -21.569,    0.000,   15.686,   27.451,
           50.980,   66.667, 78.431,  100.000,  115.686,  127.451,  150.980], 
      [-21.569,   -9.804,   -1.961,    0.000,    7.843,   15.686,   27.451,
      39.216, 50.980,   58.824,   62.745,   66.667,   70.588,   74.510,
      78.431,   90.196, 98.039,  100.000,  107.843,  115.686,  127.451], 
      [-21.569,   -9.804,   -1.961,    0.000,    7.843,   15.686,   27.451,
      39.216, 50.980,   58.824,   62.745,   66.667,   70.588,   74.510,
      78.431,   90.196,  98.039,  100.000,  107.843,  115.686,  127.451], 
      [-33.333,  -21.569,   -9.804,    0.000,    7.843,   15.686,   27.451,
      39.216, 50.980,   58.824,   62.745,   66.667,   78.431,   90.196,
      100.000,  107.843, 115.686,  127.451], 
      [-9.804,   -5.882,   -1.961,    0.000,    3.922,    7.843,   11.765,
      15.686, 19.608,   23.509,   27.451,   31.373,   35.294,   39.216,
      43.137,   47.059, 50.980,   54.902,   58.824,   62.745,   66.667, 
      70.588,   74.510,   78.431, 82.353,   86.275,   90.196,   94.118, 
      98.039,  100.000,  103.922,  107.843,  111.765], 
      [-30.000,  -20.000,  -10.000,    0.000,   10.000,   20.000,   30.000,
      40.000, 50.000,   60.000,   70.000,   80.000,   90.000,  100.000,
      110.000,  120.000, 130.000], 
     [-500.000, -400.000, -300.000, -200.000, -100.000,    0.000,  100.000,
     200.000,  300.000,  400.000,  500.000,  600.000], 
     [-100.000,  -72.549,  -49.020,  -33.333,  -21.569,    0.000,   27.451,
     50.980,  66.667,   78.431,  100.000,  127.451,  150.980,  166.667,
     178.431,  200.000], 
      [-33.333,  -29.412,  -25.490,  -21.569,   -9.804,    0.000,    7.843,
      15.686,  27.451,   39.216,   50.980,   54.902,   58.824,   62.745, 
      66.667,   70.588, 74.510,   78.431,   90.196,  100.000,  107.843,
      115.686,  127.451,  139.216,  150.980], 
      [-33.333,  -29.412,  -25.490,  -21.569,   -9.804,    0.000,    7.843, 
      15.686, 27.451,   39.216,   50.980,   54.902,   58.824,   62.745,  
      66.667,   70.588,  74.510,   78.431,   90.196,  100.000,  107.843,
      115.686,  127.451,  139.216,  150.980], 
      [-41.176,  -37.255,  -33.333,  -21.569,   -9.804,    0.000,    7.843,
      15.686,  27.451,   39.216,   50.980,   58.824,   62.745,   66.667,
      78.431,   90.196,  100.000,  107.843,  115.686,  127.451,  139.216,
      150.980], 
      [-17.647,  -13.725,   -9.804,   -5.882,   -1.961,    0.000,    3.922,
      7.843,  11.765,  15.686,   19.608,   23.509,   27.451,   31.373,
      35.294,   39.216,  43.137,   47.059,   50.980,   54.902,   58.824,
      62.745,   66.667,   70.588,   74.510,   78.431,   82.353,   86.275,
      90.196,   94.118,   98.039,  100.000,  103.922,  107.843,  111.765,
      115.686,  119.608], 
      [-50.000,  -40.000,  -30.000,  -20.000,  -10.000,    0.000,   10.000,
      20.000,   30.000,   40.000,   50.000,   60.000,   70.000,   80.000,
      90.000,  100.000,  110.000,  120.000,  130.000,  140.000,  150.000]], 
'coef' : [[33.8253,  33.8253,  33.8253,  33.8253], 
        [82.4859,   1.2603,  22.4815,  18.9314,   2.8969,  71.0974,  82.4859,
        1.2603,  22.4815], 
        [12.0792,   8.4592,  26.7900,  21.5705,  23.0754,   6.6585,  19.0962,
        30.3922,  60.6512,  74.6763,  75.6664,  79.8148,  75.9320,  47.5211, 
        12.0792,   8.4592,  26.7900], 
       [13.3494,   7.8883,  25.8400,  23.0248,  21.3100,   8.9493,  15.7822,
       34.2918,  58.3060,  72.5457,  78.4441,  79.6678,  75.9053,  46.4422, 
       13.3494,   7.8883,  25.8400], 
      [45.0851,  -2.1518,  27.3155,  21.7801,  22.3697,   7.9200,  16.9739,
      33.1615,  59.0061,  80.3683,  83.5295,  45.0851,  -2.1518,  27.3155], 
      [12.6861,   8.5744,  14.9941,  21.7397,  26.7676,  21.3221,  22.5031,
      22.5483,  19.6945,  16.7365,  13.8898,  11.6012,  11.5439,  15.9402,
      21.4673,  27.5536,  36.5639,  61.4126,  74.7277,  75.0275,  80.9237,
      76.0996,  70.2252,  55.8543,  40.9132,  19.9752,  12.6861,   8.5744,
      14.9941], 
      [41.9234,  -3.2368,  32.0187,  19.5668,  20.2811,   9.2545,  14.9009, 
      44.2629, 85.8093,  78.0205,  41.9234,  -3.2368,  32.0187], 
      [33.8253,  33.8253,  33.8253,  33.8253,  33.8253,  33.8253], 
      [93.0061,  86.0013, -54.6819,  92.8215, -49.7800,  93.0061,  86.0013,
      -54.6819,  92.8215, -49.7800], 
      [71.6700,  46.2404, -16.3198,  38.4125,  13.7980,  30.8425,   1.5483,
      15.9317,  23.2525,  35.9459,  61.8592,  75.7543,  75.6340,  81.9501,
      71.6700,  46.2404,  -16.3198,  38.4125,  13.7980], 
      [72.7220,  44.8956, -14.3723,  36.0327,  16.7261,  27.3015,   4.5277, 
      14.8756,  21.4604,  40.3602,  58.6143,  73.1526,  79.2995,  79.9220,
      72.7220,  44.8956, -14.3723,  36.0327,  16.7261], 
      [76.7467,  60.6977, -17.3393,  38.5959,  14.2538,  29.7441,   0.6054,
      18.3639,  23.376,  64.2515,  86.7496,  76.7467,  60.6977, -17.3393, 
      38.5959,  14.2538], 
      [19.6912,  13.4825,   6.2608,  17.1249,  20.6067,  29.0827,  19.5270,
      23.2109,  22.6667,  19.6866,  16.7474,  13.8240,  11.5230,  10.9217, 
      16.1154,  21.0846,  28.1517,  33.8236,  63.1731,  76.4907,  73.0356, 
      83.3897,  74.8104,  72.2190,  54.5815,  43.0444,  19.6912,  13.4825, 
      6.2608,  17.1249,  20.6067], 
      [76.0273,  49.0816, -19.3982,  45.0213,  11.9440,  25.8971,   4.7660,
      15.1631,  39.6956,  94.5539,  76.0273,  49.0816, -19.3982,  45.0213,
      11.9440]],
'sp' : [[ 33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,
33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  
33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,
33.825,  33.825,  33.825,  33.825],
[ 17.610,  14.653,  15.155,  17.402,  19.674,  20.603,  20.196,  18.790,
16.816,  14.957,  13.966,  14.600,  17.612,  23.756,  33.347,  44.926,
56.587,  66.436,  72.800,  74.944,  72.364,  64.952,  54.201,  42.007,
30.257,  20.848,  17.610],
[ 10.154,  14.944,  21.971,  24.044,  23.063,  22.333,  21.684,  20.057,
16.896,  13.521,  11.727,  12.846,  16.349,  21.241,  27.607,  39.853,
59.205,  72.504,  76.193,  78.735,  76.496,  68.443,  55.748,  39.710, 
22.700,  11.437,  10.154],
[ 10.229,  14.365,  21.449,  24.103,  23.577,  22.632,  21.458,  19.571, 
16.798,  13.995,  12.290,  12.650,  15.388,  20.651,  28.832,  41.270, 
57.676,  71.156,  77.665,  79.088,  76.371,  68.148,  55.324,  39.540,
23.223,  12.010,  10.229],
[  9.743,  14.254,  21.991,  24.364,  23.262,  22.295,  21.465,  19.851,
16.958,  13.860,  12.026,  12.636,  15.698,  20.924,  28.550,  40.879, 
57.911,  70.869,  77.996,  79.646,  76.068,  67.642,  55.253,  39.918,
23.566,  11.833,   9.743],
[ 10.099,  14.835,  21.453,  25.022,  22.427,  22.315,  22.070,  19.673,
16.754,  13.983,  11.973,  12.286,  16.129,  21.560,  28.041,  39.205,
59.489,  72.559,  75.960,  79.137,  75.925,  68.809,  55.758,  39.915, 
22.006,  12.076,  10.099],
[ 10.166,  13.120,  20.713,  25.393,  24.704,  22.001,  20.333,  19.326,
17.518,  14.652,  12.293,  12.046,  14.701,  20.681,  30.057,  42.212, 
56.273,  69.600,  78.495,  80.503,  76.383,  67.397,  54.752,  39.615,
23.955,  12.571,  10.166],
[ 33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,
33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825, 
33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,  33.825,
33.825,  33.825,  33.825],
[ 17.190,  13.224,  12.783,  14.954,  18.402,  21.679,  23.510,  23.130,
20.528,  16.633,  13.010,  11.437,  13.452,  19.920,  30.599,  43.944,
57.555,  68.874,  75.847,  77.450,  73.684,  65.403,  54.103,  41.641, 
29.918,  20.589,  17.189],
[ 10.339,  14.586,  21.670,  24.495,  23.365,  21.980,  21.373,  20.137,
17.207,  13.625,  11.619,  12.650,  16.287,  21.320,  27.802,  39.806,
59.078,  72.423,  76.539,  78.499,  76.312,  68.654,  55.998,  39.403,
22.514,  11.778,  10.339],
[ 10.522,  14.367,  21.239,  24.418,  23.743,  22.313,  21.259,  19.717,
16.995,  13.900,  12.112,  12.761,  15.686,  20.527,  28.450,  41.495,
57.716,  71.117,  77.873,  78.930,  75.929,  68.453,  55.899,  39.343, 
22.654,  12.043,  10.522],
[ 10.165,  14.367,  21.641,  24.642,  23.519,  21.989,  21.225,  19.973,
17.211,  13.835,  11.858,  12.622,  15.837,  20.810,  28.467,  41.222, 
57.621,  71.020,  78.150,  79.291,  75.669,  68.002,  55.951,  39.793, 
22.835,  11.746,  10.165],
[ 10.099,  14.835,  21.453,  25.022,  22.427,  22.315,  22.070,  19.673,
16.754,  13.983,  11.973,  12.286,  16.129,  21.560,  28.041,  39.205,
59.489,  72.559,  75.960,  79.137,  75.925,  68.809,  55.758,  39.915, 
22.006,  12.076,  10.099],
[ 10.453,  13.154,  20.451,  25.336,  25.008,  22.093,  20.038,  19.155, 
17.686,  14.895,  12.260,  11.866,  14.719,  20.778,  29.917,  42.121,
56.387,  69.779,  78.508,  80.427,  76.147,  67.406,  55.065,  39.607,
23.626,  12.578,  10.453]]
}

parcur_test = {
'u' : array([120.,128.,133.,136.,138.,141.,144.,146.,149.,151.,154.,
     161.,170.,180.,190.,200.,210.,220.,230.,240.,250.,262.,269.,
     273.,278.,282.,287.,291.,295.,299.,305.,315.]),
'xa' : [-1.5141,-2.0906,-1.9253,-0.8724,-0.3074,-0.5534,0.0192,
     1.2298,2.5479,2.4710,1.7063,1.1183,0.5534,0.4727,0.3574,0.1998,
     0.2882,0.2613,0.2652,0.2805,0.4112,0.9377,1.3527,1.5564,1.6141,
     1.6333,1.1567,0.8109,0.2498,-0.2306,-0.7571,-1.1222],
'xo' : [0.5150,1.3412,2.6094,3.2358,2.7401,2.7823,3.5932,
     3.8353,2.5863,1.3105,0.6841,0.2575,0.2460,0.3689,0.2460,0.2998,
     0.3651,0.3343,0.3881,0.4573,0.5918,0.7110,0.4035,0.0769,-0.3920,
     -0.8570,-1.3412,-1.5641,-1.7409,-1.7178,-1.2989,-0.5572],
'ub':120,
'ue':320,
'k' : [3, 3, 3, 3, 3, 3, 5, 5, 5],
's' : [100.0, 1.0, 0.05, 0.25, 0.25, 0.25, 0.25, 0.0, -1], 
'ipar' : [1, 1, 1, 1, 1, 0, 0, 0, 0],
'iopt' : [0, 1, 1, 1, 0, 0, 0, 0, -1],
'res' : [0.559278E+02, 0.100021E+01, 0.499966E-01, 0.250216E+00, 0.249842E+00,
                     0.250003E+00, 0.249993E+00, 0.000000E+00, 0.943099E+00],
'err' : [-2, 0, 0, 0, 0, 0, 0, -1, 0],
'knots' : [[120., 120., 120., 120., 320., 320., 320., 320.], 
         [120., 120., 120., 120., 133., 138., 141., 144., 149., 154., 
  170., 210., 250., 278., 295., 320., 320., 320., 320.], 
         [120., 120., 120., 120., 133., 136., 138., 141., 144., 149., 
  151., 154., 161., 170., 180., 190., 210., 250., 269., 278., 
  287., 295., 320., 320., 320., 320.], 
         [120., 120., 120., 120., 133., 136., 138., 141., 144., 149., 
  151., 154., 161., 170., 180., 190., 210., 250., 269., 278., 
  287., 295., 320., 320., 320., 320.], 
         [120., 120., 120., 120., 133., 136., 138., 141., 144., 149., 
  151., 154., 170., 210., 250., 278., 287., 295., 320., 320., 
  320., 320.], 
         [0.0000, 0.0000, 0.0000, 0.0000, 0.1197, 0.1839, 0.2232, 0.2883, 
  0.4480, 0.6343, 0.6653, 0.6838, 0.7840, 1.0000, 1.0000, 1.0000, 
  1.0000], 
       [0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1197, 0.1839, 
  0.2232, 0.4480, 0.6343, 0.6653, 0.6838, 0.7840, 1.0000, 1.0000, 
  1.0000, 1.0000, 1.0000, 1.0000], 
       [0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1839, 0.2232, 
  0.2363, 0.2883, 0.3529, 0.4480, 0.5149, 0.5667, 0.6047, 0.6343, 
  0.6420, 0.6508, 0.6596, 0.6653, 0.6674, 0.6703, 0.6740, 0.6838, 
  0.7121, 0.7391, 0.7593, 0.7840, 0.8084, 0.8440, 0.8655, 0.8963, 
  1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000], 
       [0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1250, 0.2500, 
  0.3750, 0.5000, 0.6250, 0.7500, 0.8750, 1.0000, 1.0000, 1.0000, 
  1.0000, 1.0000, 1.0000]],
'sx' : [[-1.1548, 2.7543, 0.7908,  -0.1259], 
      [-1.5121,  -1.2336,  -3.5336,  -0.1351,  -0.6165, 0.0950, 3.1911, 
      0.9120,   0.2207, 0.5287,  -0.2985, 2.1710, 0.4299,  -2.2076,  -0.3992], 
      [-1.5141,  -0.8415,  -3.5384,  -0.9552,  -0.0336,  -0.8011,  -0.0719, 
      2.8821, 2.4805, 1.1626, 1.2566, 0.3134, 0.6040, 0.1359, 0.4505,  
      -0.0664,   1.1284, 1.8397, 1.3619,  -0.5533,  -1.4796,  -0.9382], 
      [-1.5126,  -0.8460,  -3.6051,  -0.8411,  -0.2731,  -0.6593, 0.0111, 
      2.6652, 2.6017, 1.1042, 1.2620, 0.3178, 0.6014, 0.1370, 0.4496,  
      -0.0659,   1.1283, 1.8398, 1.3618,  -0.5531,  -1.4799,  -0.9379], 
      [-1.5137,  -0.6761,  -3.7166,  -0.8442,  -0.1873,  -0.7240,  -0.0382, 
      2.8148, 2.3950, 0.9819, 0.2063, 0.4696,  -0.1694, 1.7368, 1.5210, 
      -0.7724, -1.2116,  -1.1237], 
      [-1.5126,  -2.1295,  -2.5681,  -0.8519,  -0.3894, 0.0129, 4.2840,
      1.2306,  0.2041, 0.6633, 3.2860,  -1.1886,  -1.0872], 
      [-1.5140,  -0.2538,  -3.9579,  -2.0558,  -0.1376,  -0.7093, 3.9083,
      3.4195,  -0.6167, 1.7279, 3.0307,  -0.5555,  -0.7361,  -1.1278], 
      [-1.5141,  -4.8893, 3.0277,  -6.9243, 2.4051,  -1.9430, 1.8101, 0.4452, 
  3.0970, 2.7686, 2.0549, 1.1258, 1.0620, 0.2999, 0.5931,  -0.1113, 
  0.4195, 0.2149, 0.3078, 0.1882, 0.9922, 0.7559, 1.4062, 1.6328, 
  1.5426, 1.8382, 1.1504, 0.6591,  -0.3452,  -0.7910,  -1.0000,  -1.1222], 
      [-1.5140,  -1.1705,  -3.7619,  -0.4161,  -0.5726, 0.7574, 5.4849, 
      -2.0698,  2.1028, 2.6719,  -1.5004,  -0.4675,  -1.1283]], 
'sy' : [[2.5710, 0.4640, 0.3999,  -1.6208], 
      [0.5161,  -1.0848, 3.3776, 2.8139, 2.7532, 4.3508, 2.1979,  -0.3601, 
  0.7465,  -0.0769, 0.7883, 0.5575,  -3.0389,  -0.1368,  -0.6145], 
      [0.5151, 0.5826, 1.3907, 3.5299, 2.5462, 2.5185, 4.2164, 3.5608, 
  0.8278, 0.6202, 0.0979, 0.2647, 0.3987, 0.2091, 0.4205, 0.3339, 
  0.9355,  -0.4440,  -1.3297,  -2.2927,  -0.4057,  -0.4095], 
      [0.5160,  -0.4483, 2.3159, 3.1579, 2.7441, 2.6293, 4.2337, 3.2004, 
  1.2412, 0.0951, 0.3634, 0.1744, 0.4209, 0.2015, 0.4258, 0.3310, 
  0.9364,  -0.4443,  -1.3297,  -2.2925,  -0.4061,  -0.4092], 
      [0.5157,  -0.0216, 1.9374, 3.3003, 2.7152, 2.4783, 4.3210, 3.3174, 
  1.0242, 0.0591, 0.4637, 0.1370, 0.6160, 0.7280,  -1.5065,  -2.0501, 
 -0.7021,  -0.2044], 
       [0.5173, 0.8949, 2.5415, 3.4316, 2.4271, 4.5986, 2.6667,  -0.1322, 
  0.3411, 0.9389,  -1.1971,  -2.5963,  -0.5047], 
       [0.5160,  11.3627, -10.2865, 7.5268,  -0.4078, 6.4015, 2.8602, 0.5783, 
 -0.1220, 1.5742,  -2.4089,  -1.9223,  -1.6493,  -0.5481], 
       [0.5150, 3.0202,  -2.1849, 6.2691, 2.1376, 2.9157, 4.2898, 3.9404, 
  2.7047, 2.0088, 0.0609, 1.2120,  -0.6203, 0.6126, 0.2469, 0.0576, 
  0.5412, 0.2445, 0.5039, 0.3663, 1.2118, 0.4929, 0.5866, 0.0256, 
 -0.4126,  -1.0048,  -1.2798,  -1.8261,  -1.8191,  -1.7347,  -0.6137,  
 -0.5572], 
       [0.5157, 0.1690, 2.5142, 3.5678, 1.7000, 5.7700, 0.8859,  -0.8397, 
  2.4599,  -3.0704,  -1.5557,  -1.2391,  -0.5543]], 
'sp' : [[  -1.1548,  2.5710, -0.7135,  2.3277, -0.4651,  2.1850, -0.3258,
2.1025, -0.2370,  2.0489, -0.1097,  1.9703,  0.0107,  1.8938,  0.0872, 
1.8441,  0.1963,  1.7711,  0.2654,  1.7236,  0.3637,  1.6539,  0.5685, 
1.4983,  0.7840,  1.3113,  0.9646,  1.1183,  1.0882,  0.9380,  1.1601,  
0.7672,  1.1854,  0.6032,  1.1693,  0.4427,  1.1171,  0.2830,  1.0338, 
0.1208,  0.9247, -0.0466,  0.7670, -0.2589,  0.6649, -0.3903,  0.6040,
-0.4685,  0.5261, -0.5696,  0.4626, -0.6535,  0.3823, -0.7624,  0.3178, 
-0.8530,  0.2534, -0.9470,  0.1895, -1.0444,  0.0951, -1.1975, -0.0553,
-1.4729],
 [  -1.5121,  0.5161, -2.1158,  1.3155, -1.8367,  2.7813, -0.8954,  2.9112, 
 -0.4539,  2.8268, -0.4538,  2.9794,  0.1608,  3.7106,  1.1126,  3.4893,  
 2.3766, 2.3660,  2.4950,  1.6528,  1.9671,  0.8609,  0.9699,  0.0639, 
 0.5592,  0.1890, 0.4118,  0.3782,  0.3610,  0.3838,  0.3472,  0.3084,
 0.3113,  0.2549,  0.2207, 0.2994,  0.1499,  0.4137,  0.2004,  0.5428,
 0.4734,  0.6320,  1.1011,  0.5682, 1.4267,  0.3319,  1.5365,  0.0978, 
 1.5511, -0.3202,  1.4407, -0.7531,  1.1510, -1.3044,  0.8062, -1.6447, 
 0.3679, -1.7989, -0.1420, -1.7090, -0.8573, -1.2727, -1.1104, -0.5605],
 [  -1.5141,  0.5151, -2.0904,  1.3399, -1.9278,  2.6176, -0.8627,  3.2135, 
 -0.3177,  2.7648, -0.5578,  2.7552,  0.0533,  3.6603,  1.1877,  3.7583, 
 2.5699,  2.6222,  2.4649,  1.3059,  1.7052,  0.6802,  1.1204,  0.2567, 
 0.5470,  0.2506,  0.4954,  0.3519,  0.3069,  0.2824,  0.2436,  0.2790, 
 0.2870,  0.3327,  0.2711,  0.3674,  0.2337,  0.3967,  0.2638,  0.4558, 
 0.4501,  0.5805,  0.9479,  0.6914,  1.3254,  0.4292,  1.5373,  0.0937, 
 1.6705, -0.4295,  1.5788, -0.8456,  1.2139, -1.3107,  0.7606, -1.6031, 
 0.2559, -1.7475, -0.2110, -1.6852, -0.7669, -1.3134, -1.1211, -0.5557],
 [  -1.5126,  0.5160, -2.1059,  1.3246, -1.8862,  2.7128, -0.8361,  3.0274,
 -0.4395,  2.8257, -0.4955,  2.8696,  0.1192,  3.6617,  1.1486,  3.6310, 
 2.4908,  2.5597,  2.5133,  1.5174,  1.7232,  0.5758,  1.1087,  0.2696, 
 0.5506,  0.2489,  0.4945,  0.3509,  0.3067,  0.2853,  0.2440,  0.2764, 
 0.2870,  0.3323,  0.2709,  0.3685,  0.2336,  0.3974,  0.2638,  0.4555, 
 0.4503,  0.5798,  0.9479,  0.6915,  1.3254,  0.4295,  1.5373,  0.0938,  
 1.6705, -0.4296,  1.5788, -0.8458,  1.2138, -1.3107,  0.7606, -1.6031, 
 0.2560, -1.7475, -0.2110, -1.6852, -0.7669, -1.3134, -1.1211, -0.5556],
 [  -1.5137,  0.5157, -2.0941,  1.3313, -1.9242,  2.6683, -0.8241,  3.1080,
 -0.3888,  2.8231, -0.5299,  2.7740,  0.0879,  3.6846,  1.1787,  3.7093, 
 2.5018,  2.5558,  2.4167,  1.4002,  1.8823,  0.6816,  1.0126,  0.2367, 
 0.5944,  0.2522,  0.4116,  0.3221,  0.3401,  0.3241,  0.3214,  0.3006, 
 0.2964,  0.2937,  0.2303,  0.3351,  0.1832,  0.4139,  0.2389,  0.5090, 
 0.4813,  0.5991,  1.0356,  0.5942,  1.3548,  0.3768,  1.4908,  0.1334, 
 1.5810, -0.3273,  1.5562, -0.8151,  1.2789, -1.3812,  0.7977, -1.6444, 
 0.2360, -1.7257, -0.2406, -1.6526, -0.7496, -1.3325, -1.1231, -0.5535],
 [  -1.5126,  0.5173, -2.0962,  1.3284, -1.9154,  2.6519, -0.8579,  3.1350,
 -0.4780,  2.7906, -0.3927,  2.8295,  0.0356,  3.5770,  1.1661,  3.8095, 
 2.6447,  2.5908,  2.4131,  1.3715,  1.6818,  0.5972,  1.0403,  0.2693, 
 0.5711,  0.2212,  0.4632,  0.2442,  0.3622,  0.2891,  0.3027,  0.3526, 
 0.2937,  0.4048,  0.2976,  0.4261,  0.3085,  0.4553,  0.3314,  0.4940, 
 0.4264,  0.5827,  0.8211,  0.5959,  1.2421,  0.3329,  1.5049,  0.0288, 
 1.6804, -0.3960,  1.6292, -0.8022,  1.2238, -1.3065,  0.8512, -1.5331, 
 0.2420, -1.7153, -0.2534, -1.7101, -0.8192, -1.4173, -1.0872, -0.5047],
 [  -1.5140,  0.5160, -2.0913,  1.3343, -1.9224,  2.6454, -0.8413,  3.1098,
 -0.5097,  2.8015, -0.4106,  2.8886,  0.1128,  3.5175,  1.1376,  3.8232, 
 2.5443,  2.6009,  2.5286,  1.3516,  1.7687,  0.6085,  0.9935,  0.3006, 
 0.4845,  0.2434,  0.3955,  0.2589,  0.3267,  0.2931,  0.2992,  0.3436, 
 0.3045,  0.3845,  0.3113,  0.4009,  0.3240,  0.4231,  0.3471,  0.4529, 
 0.4388,  0.5286,  0.8568,  0.6175,  1.2911,  0.4212,  1.5361,  0.1131, 
 1.6758, -0.3655,  1.6119, -0.8419,  1.1950, -1.3926,  0.8147, -1.6001,  
 0.2143, -1.7155, -0.2427, -1.6562, -0.7323, -1.3483, -1.1278, -0.5481],
 [  -1.5141,  0.5150, -2.0906,  1.3412, -1.9253,  2.6094, -0.8724,  3.2358,
 -0.3074,  2.7401, -0.5534,  2.7823,  0.0192,  3.5932,  1.2298,  3.8353, 
 2.5479,  2.5863,  2.4710,  1.3105,  1.7063,  0.6841,  1.1183,  0.2575, 
 0.5534,  0.2460,  0.4727,  0.3689,  0.3574,  0.2460,  0.1998,  0.2998, 
 0.2882,  0.3651,  0.2613,  0.3343,  0.2652,  0.3881,  0.2805,  0.4573,  
 0.4112,  0.5918,  0.9377,  0.7110,  1.3527,  0.4035,  1.5564,  0.0769, 
 1.6141, -0.3920,  1.6333, -0.8570,  1.1567, -1.3412,  0.8109, -1.5641,  
 0.2498, -1.7409, -0.2306, -1.7178, -0.7571, -1.2989, -1.1222, -0.5572],
 [  -1.5140,  0.5157, -2.0927,  1.3305, -1.9113,  2.6869, -0.8937,  2.9204,
 -0.4755,  2.9632, -0.3647,  3.0067,  0.1005,  3.3658,  1.0401,  3.7905, 
 2.6920,  2.7554,  2.5788,  1.2773,  1.5805,  0.4841,  0.8142,  0.2697, 
 0.4514,  0.2967,  0.4047,  0.3224,  0.3764,  0.3570,  0.3746,  0.3937, 
 0.3870,  0.4178,  0.3943,  0.4265,  0.4060,  0.4376,  0.4249,  0.4515,  
 0.4932,  0.4825,  0.8026,  0.4927,  1.1681,  0.3386,  1.4146,  0.1027, 
 1.6128, -0.3052,  1.6351, -0.7716,  1.2950, -1.3882,  0.8918, -1.6327, 
 0.1869, -1.7454, -0.3242, -1.6509, -0.7005, -1.3275, -1.1283, -0.5543]]
}

clocur_test = {
'xa' : [-4.7,-7.048,-6.894,-3.75,-1.042,0.938,2.5,3.524,4.511,5.0,4.886,
           3.524,3.2,1.302,-1.424,-3.0,-3.064,-3.665, -4.7],
'xo' : [0.0,2.565,5.785,6.495,5.909,5.318,4.33,2.957,1.642,0.0,-1.779,
            -2.957,-5.543,-7.386,-8.075,-5.196,-2.571,-1.334, 0.0],
'u' : arange(19.0)*20.0,
'k' : [3, 3, 3, 3, 3, 3, 5, 5, 5],
'ipar' : [1, 1, 1, 1, 1, 0, 0, 0, 0],
'iopt' : [0, 1, 1, 1, 0, 0, 0, 0, -1],
's' : [900., 10., 0.1, 0.5, 0.5, 0.5, 0.5, 0.0, -1],
'res' : [0.653304E+03, 0.100003E+02, 0.999982E-01, 0.499976E+00, 0.499666E+00,
       0.499997E+00, 0.500067E+00, 0.000000E+00, 0.207778E+01],
'err' : [-2, 0, 0, 0, 0, 0, 0, -1, 0],
'knots' : [[ -1080.,  -720.,  -360.,  0., 360., 720.,  1080.,  1440. ], 
        [-180., -80., -40.,   0.,  40.,  60., 100., 180., 280., 320., 
          360., 400., 420., 460.], 
        [-60., -40., -20.,   0.,  20.,  40.,  60., 100., 180., 200., 
          220., 240., 260., 280., 300., 320., 340., 360., 380., 400., 
          420.], 
        [-60., -40., -20.,   0.,  20.,  40.,  60., 100., 180., 200., 
         220., 240., 260., 280., 300., 320., 340., 360., 380., 400., 
         420.], 
        [-120., -80., -40.,   0.,  40.,  60., 100., 180., 200., 220., 
         240., 280., 320., 360., 400., 420., 460.], 
        [-0.3411, -0.2121, -0.0724,  0.0000,  0.0822,  0.1584,  0.2346, 
        0.3490, 0.5125,  0.5547,  0.5973,  0.6589,  0.7879,  0.9276,  1.0000,
        1.0822, 1.1584,  1.2346], 
        [-0.4453, -0.4027, -0.3411, -0.2121, -0.0724,  0.0000,  0.1584,  
        0.2346,  0.3490,  0.5125,  0.5547,  0.5973,  0.6589,  0.7879, 
        0.9276,  1.0000,  1.1584,  1.2346,  1.3490,  1.5125,  1.5547], 
        [-0.2786, -0.2121, -0.1345, -0.0724, -0.0399,  0.0000,  0.0822, 
        0.1584,  0.2346,  0.3001,  0.3490,  0.3927,  0.4332,  0.4720, 
        0.5125,  0.5547, 0.5973,  0.6589,  0.7214,  0.7879,  0.8655, 
        0.9276,  0.9601,  1.0000, 1.0822,  1.1584,  1.2346,  1.3001, 
        1.3490], 
        [-0.6250, -0.5000, -0.3750, -0.2500, -0.1250,  0.0000,  0.1250,
        0.2500,  0.3750,  0.5000,  0.6250,  0.7500,  0.8750,  1.0000, 
        1.1250,  1.2500, 1.3750,  1.5000,  1.6250]], 
'sx' : [[ -0.2890, -0.2890, -0.2890, -0.2890], 
     [-3.6414, -5.1410, -7.1471, -3.6077,  2.9569,  7.0497,  0.8157, -3.6414, 
      -5.1410, -7.1471], 
     [-3.6393, -4.2795, -7.6104, -7.5242, -2.2356,  2.5034,  4.8626,  5.2229, 
      3.1970,  3.5381,  1.5313, -1.7123, -3.3029, -2.9197, -3.6393, -4.2795, 
      -7.6104], 
     [-3.3998, -4.4768, -7.5699, -7.4089, -2.3288,  2.4959,  5.0209,  4.9720, 
      3.6189,  3.2870,  1.5156, -1.6335, -3.2388, -3.1205, -3.3998, -4.4768, 
      -7.5699], 
     [-3.1406, -3.8616, -9.3043, -2.0703,  2.3649,  4.9458,  5.1866,  3.1343, 
      3.9923, -2.7579, -3.1406, -3.8616, -9.3043], 
     [-2.7754, -4.3421, -7.6213, -7.4935, -2.9934,  1.5161,  5.3675,  4.7346, 
      3.5203,  3.6277, -2.8775, -2.7754, -4.3421, -7.6213], 
     [-5.1336, -1.1870, -4.9707,  -10.2635, -1.8832,  1.1682,  4.6332,  
     5.9054, 2.4087,  4.9227, -5.1336, -1.1870, -4.9707,  -10.2635, -1.8832], 
     [-2.3401, -3.8401, -5.2545, -7.7951, -8.2051, -3.8222, -1.6092,  0.6087, 
      2.7131,  3.2464,  4.9215,  4.8089,  5.8715,  1.6678,  4.7786,  0.6271, 
      -1.5750, -3.8446, -2.3401, -3.8401, -5.2545, -7.7951, -8.2051], 
     [1.0044, -5.4019, -0.9630,  -12.7083, -1.1542,  1.1652,  6.9462, 
     3.4423, 1.0044, -5.4019, -0.9630,  -12.7083, -1.1542]], 
'sy' : [[ 0.0089,  0.0089,  0.0089,  0.0089],
     [-2.8481, -0.2362,  5.1680,  7.0915,  4.1090,  1.8202,  -10.7190, 
     -2.8481,  -0.2362,  5.1680], 
     [-1.3506, -0.3010,  2.3785,  6.4303,  6.5434,  4.9464,  1.8911, -1.9032, 
      -2.6544, -5.6451, -7.5794, -8.8289, -5.1023, -2.2260, -1.3506, -0.3010, 
      2.3785], 
     [-1.2300, -0.5075,  2.6980,  6.1354,  6.7093,  4.8744,  1.8243, -1.7559, 
      -2.9185, -5.3807, -7.8932, -8.4817, -5.3102, -2.2288, -1.2300, -0.5075, 
      2.6980], 
     [-0.6661, -1.9633,  5.9976,  6.6889,  4.8408,  1.9295, -1.8934, -2.7464, 
      -6.3406,  -10.2291, -0.6661, -1.9633,  5.9976], 
     [-2.8663,  0.0279,  2.2083,  6.4113,  6.5499,  5.6375,  1.6714, -1.6993, 
      -3.2769, -6.4064,  -10.0517, -2.8663,  0.0279,  2.2083], 
     [-11.4885, -0.4907, -1.3396,  6.4019,  7.1875,  5.2912,  3.0296, 
     -1.2442,-3.8350, -7.0871,  -11.4885, -0.4907, -1.3396,  6.4019,  
     7.1875], 
     [-3.3543, -0.9872,  0.9217,  1.8210,  7.0937,  6.6891,  6.0142,  5.5460, 
      4.6549,  2.8892,  1.7125,  0.0930, -2.5059, -2.4784, -6.6540, -7.0488, 
      -9.7840, -5.4089, -3.3543, -0.9872,  0.9217,  1.8210,  7.0937], 
     [-12.0940, -3.6528, -0.7300,  5.5358,  7.2803,  5.8203, -0.2992, 
     -2.7102, -12.0940, -3.6528, -0.7300,  5.5358,  7.2803]] ,
'sp' : [[  -0.2890,  0.0089, -0.2890,  0.0089, -0.2890,  0.0089, -0.2890,  
        0.0089, -0.2890,  0.0089, -0.2890,  0.0089, -0.2890,  0.0089, 
        -0.2890, 0.0089, -0.2890,  0.0089, -0.2890,  0.0089, -0.2890, 
        0.0089, -0.2890, 0.0089, -0.2890,  0.0089, -0.2890,  0.0089, 
        -0.2890,  0.0089, -0.2890, 0.0089, -0.2890,  0.0089, -0.2890,  0.0089],
     [  -5.2923,  0.4093, -6.1787,  2.9710, -6.0695,  5.3207, -4.2389,  
     6.4366,  -1.7409,  6.1224,  0.7042,  5.1065,  2.6665,  4.1203,  4.0480,
     3.1423,  4.8338,  1.9627,  5.0087,  0.3716,  4.5831, -1.7274,  3.6691, 
     -3.9781,      2.4042, -5.9109,  0.9256, -7.0561, -0.6291, -6.9443,
     -2.1199, -5.3828,    -3.3961, -3.2874, -4.3795, -1.5164],
     [  -4.7279, -0.0293, -7.0409,  2.6072, -6.8775,  5.7691, -3.7728, 
     6.4296, -1.0175,  6.0270,  0.9227,  5.2638,  2.4441,  4.2658,  3.6274, 
     3.0527,  4.4745,  1.6179,  4.9874, -0.0452,  4.8553, -1.7122,  3.5915,
     -3.0276,  3.1468, -5.4690,  1.3252, -7.4653, -1.4368, -7.9995, -2.9739,
     -5.2440,  -3.1035, -2.5595, -3.6261, -1.3216],
     [  -4.8128, -0.0937, -7.0276,  2.7367, -6.8007,  5.6343, -3.7924,  
     6.4306,  -1.0745,  6.1030,  0.8984,  5.2829,  2.4686,  4.2353,  3.6817,
     3.0092,  4.5092,  1.5998,  4.9227,  0.0020,  4.7506, -1.6513,  3.7891,
     -3.1351,  3.0471, -5.3891,  1.2860, -7.5725, -1.3762, -7.8550, -2.9516,
     -5.3252, -3.1868, -2.5759, -3.5327, -1.2761],
     [  -4.8300, -0.1549, -6.8257,  2.7970, -7.0124,  5.6512, -3.7882,  
     6.4165, -0.9607,  6.0812,  0.9211,  5.2675,  2.4192,  4.2429,  3.6200, 
     3.0380,  4.4912,  1.6245,  5.0005, -0.0262,  4.8245, -1.7170,  3.5836, 
     -3.0535,  3.2563, -5.4018,  1.1922, -7.5794, -1.4717, -7.8576, -2.7955,
     -5.3774, -3.1970, -2.4761, -3.6292, -1.3149],
     [  -4.5913, -0.0815, -7.0773,  2.6262, -6.8714,  5.7487, -3.7630, 
     6.4357, -1.0052,  6.0385,  0.8565,  5.3025,  2.4386,  4.2481,  3.6968,  
     2.9886, 4.5577,  1.5926,  4.9321,  0.0128,  4.6151, -1.6349,  3.8307, 
     -3.1175,  3.1953, -5.4544,  1.1602, -7.4783, -1.4290, -7.9455, -2.7722,
     -5.3452,  -3.2724, -2.4829, -3.7031, -1.2936],
     [  -4.6787, -0.2073, -7.0474,  2.8389, -6.8782,  5.5855, -3.8179,  
     6.5057, -0.9262,  6.0491,  0.8978,  5.2475,  2.3835,  4.2394,  3.6211,  
     3.0351,  4.5499,  1.6308,  5.0208, -0.0120,  4.6762, -1.6795,  3.7408, 
     -3.1379,  3.0946, -5.3511,  1.3669, -7.5345, -1.5010, -8.0181, -2.8910,
     -5.2226,      -3.1657, -2.4427, -3.6475, -1.3664],
     [  -4.7000,  0.0000, -7.0480,  2.5650, -6.8940,  5.7850, -3.7500,  
     6.4950,  -1.0420,  5.9090,  0.9380,  5.3180,  2.5000,  4.3300,  3.5240, 
     2.9570,  4.5110,  1.6420,  5.0000,  0.0000,  4.8860, -1.7790,  3.5240,
     -2.9570,  3.2000, -5.5430,  1.3020, -7.3860, -1.4240, -8.0750, -3.0000,
     -5.1960,  -3.0640, -2.5710, -3.6650, -1.3340],
     [  -4.4547, -0.0336, -6.9471,  3.0553, -7.0308,  5.3645, -3.8468, 
     6.4116, -0.8360,  6.2133,  0.9573,  5.3963,  2.3828,  4.2137,  3.5767, 
     2.8525,  4.4535,  1.4584,  4.8942,  0.0339,  4.7651, -1.4260,  4.1475,
     -3.0152,  2.7862, -5.6052,  1.0706, -7.6954, -1.0414, -7.7248, -2.9141,
     -5.1502, -3.4430, -2.6947, -3.7218, -1.4943]]
}
        

def f1(x,d=0):
    if d is None: return "sin"
    if x is None: return "sin(x)"
    if d%4 == 0: return sin(x)
    if d%4 == 1: return cos(x)
    if d%4 == 2: return -sin(x)
    if d%4 == 3: return -cos(x)

def f2(x,y=0,dx=0,dy=0):
        if x is None: return "sin(x+y)"
        d=dx+dy
        if d%4 == 0: return sin(x+y)
        if d%4 == 1: return cos(x+y)
        if d%4 == 2: return -sin(x+y)
        if d%4 == 3: return -cos(x+y)

myasarray = atleast_1d

def norm2(x):
    return dot(transpose(x),x)
def makepairs(x,y):
    x,y=map(myasarray,[x,y])
    xy=array(map(lambda x,y:map(None,len(y)*[x],y),x,len(x)*[y]))
    sh=xy.shape
    xy.shape=sh[0]*sh[1],sh[2]
    return transpose(xy)

# very simple script to test interpolation with regrid and surfit
# based on example data from netlib->dierckx->regrid
 
#from numpy import *
#from scipy.interpolate.fitpack2 import SmoothBivariateSpline, \
                                       #RectBivariateSpline
#import matplotlib
#matplotlib.use('Agg')
#import pylab

## x,y coordinates
#x = linspace(-1.5,1.5,11)
#y = x                        
## data taken from daregr
#z = array([
#[-0.0325, 0.0784, 0.0432, 0.0092, 0.1523, 0.0802, 0.0925, -0.0098, \
                                                    #0.0810, -0.0146, -0.0019],  
#[0.1276, 0.0223, 0.0357, 0.1858, 0.2818, 0.1675, 0.2239, 0.1671, \
                                                    #0.0843, 0.0151, 0.0427],  
#[0.0860, 0.1267, 0.1839, 0.3010, 0.5002, 0.4683, 0.4562, 0.2688, \
                                                    #0.1276, 0.1244, 0.0377],  
#[0.0802, 0.1803, 0.3055, 0.4403, 0.6116, 0.7178, 0.6797, 0.5218, \
                                                    #0.2624, 0.1341, -0.0233],  
#[0.1321, 0.2023, 0.4446, 0.7123, 0.7944, 0.9871, 0.8430, 0.6440, \
                                                    #0.4682, 0.1319, 0.1075],  
#[0.2561, 0.1900, 0.4614, 0.7322, 0.9777, 1.0463, 0.9481, 0.6649, \
                                                    #0.4491, 0.2442, 0.1341],  
#[0.0981, 0.2009, 0.4616, 0.5514, 0.7692, 0.9831, 0.7972, 0.5937, \
                                                    #0.4190, 0.1436, 0.0995], 
#[0.0991, 0.1545, 0.3399, 0.4940, 0.6328, 0.7168, 0.6886, 0.3925, \
                                                    #0.3015, 0.1758, 0.0928],  
#[-0.0197, 0.1479, 0.1225, 0.3254, 0.3847, 0.4767, 0.4324, 0.2827, \
                                                    #0.2287, 0.0999, 0.0785],  
#[0.0032, 0.0917, 0.0246, 0.1780, 0.2394, 0.1765, 0.1642, 0.2081, \
                                                    #0.1049, 0.0493, -0.0502],  
#[0.0101, 0.0297, 0.0468, 0.0221, 0.1074, 0.0433, 0.0626, 0.1436, \
                                                    #0.1092, -0.0232, 0.0132]])

## plot original data
#pylab.subplot(1,3,1)
#pylab.imshow(z)
#pylab.title('orig')

## check regrid
#mrs = RectBivariateSpline(x,y,z)
#zr = mrs(x,y)
#print sum(abs(zr-z))
#pylab.subplot(1,3,2)
#pylab.imshow(zr)
#pylab.title('regrid')

## check surfit
## x increases in columns, y increases along rows
#ym,xm = meshgrid(y,x) # deal with meshgrid badness
#mrs = SmoothBivariateSpline(ravel(xm),ravel(ym),ravel(z),kx=3,ky=3,s=0)
#zr = mrs(x,y)
#print sum(abs(zr-z))
#pylab.subplot(1,3,3)
#pylab.imshow(zr)
#pylab.title('surfit')

#pylab.savefig('intplot.png')
#pylab.close()
