from numpy import *
from numpy.linalg import norm

def project2box(x, lb, ub):
    X = asarray(x)
    projection = copy(X)
    ind = where(projection < lb)[0]
    projection[ind] = lb[ind]
    ind = where(projection > ub)[0]
    projection[ind] = ub[ind]
    distance = norm(X-projection)
    return projection, distance

def project2ball(x, radius, center = 0.0):
    X = asarray(x)
    distance2center = norm(X-center)
    if distance2center  <= radius:
        return copy(x), 0.0
    else:
        projection = center + (X-center) * (radius / distance2center)
        distance = radius - distance2center
        return projection, distance
