from BaseProblem import NonLinProblem
from NLP import nlp_init
from numpy import max

class MMP(NonLinProblem):
    """
    Mini-Max Problem
    """
    __optionalData__ = ['A', 'Aeq', 'b', 'beq', 'lb', 'ub', 'c', 'h']
    def __init__(self, *args, **kwargs):
        if len(args) > 2: self.err('incorrect args number for MMP constructor, must be 0..2 + (optionaly) some kwargs')

        kwargs2 = kwargs.copy()
        if len(args) > 0: kwargs2['f'] = args[0]
        if len(args) > 1: kwargs2['x0'] = args[1]
        NonLinProblem.__init__(self)

        self.allowedGoals = ['minimax']

        nlp_init(self, kwargs2)

        self.probType = 'MMP'
        self.isObjFunValueASingleNumber = False
        self.showGoal = True
        self.goal = 'minimax'

    def objFuncMultiple2Single(self, fv):
        return max(fv)
