# PySNMP SMI module. Autogenerated from smidump -f python AGENTX-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:39 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( TDomain, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "TDomain", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class AgentxTAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    

# Objects

agentxMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 74)).setRevisions(("2000-01-10 00:00",))
if mibBuilder.loadTexts: agentxMIB.setOrganization("AgentX Working Group")
if mibBuilder.loadTexts: agentxMIB.setContactInfo("WG-email:   agentx@dorothy.bmc.com\nSubscribe:  agentx-request@dorothy.bmc.com\nWG-email Archive:  ftp://ftp.peer.com/pub/agentx/archives\nFTP repository:  ftp://ftp.peer.com/pub/agentx\nhttp://www.ietf.org/html.charters/agentx-charter.html\n\nChair:      Bob Natale\n            ACE*COMM Corporation\nEmail:      bnatale@acecomm.com\n\nWG editor:  Mark Ellison\n            Ellison Software Consulting, Inc.\nEmail:      ellison@world.std.com\n\nCo-author:  Lauren Heintz\n            Cisco Systems,\nEMail:      lheintz@cisco.com\n\nCo-author:  Smitha Gudur\n            Independent Consultant\nEmail:      sgudur@hotmail.com")
if mibBuilder.loadTexts: agentxMIB.setDescription("This is the MIB module for the SNMP Agent Extensibility\nProtocol (AgentX).  This MIB module will be implemented by\nthe master agent.")
agentxObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 1))
agentxGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 1, 1))
agentxDefaultTimeout = MibScalar((1, 3, 6, 1, 2, 1, 74, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255)).clone(5)).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: agentxDefaultTimeout.setDescription("The default length of time, in seconds, that the master\nagent should allow to elapse after dispatching a message\nto a session before it regards the subagent as not\nresponding.  This is a system-wide value that may\noverride the timeout value associated with a particular\nsession (agentxSessionTimeout) or a particular registered\nMIB region (agentxRegTimeout).  If the associated value of\nagentxSessionTimeout and agentxRegTimeout are zero, or\nimpractical in accordance with implementation-specific\nprocedure of the master agent, the value represented by\nthis object will be the effective timeout value for the\n\n\nmaster agent to await a response to a dispatch from a\ngiven subagent.")
agentxMasterAgentXVer = MibScalar((1, 3, 6, 1, 2, 1, 74, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxMasterAgentXVer.setDescription("The AgentX protocol version supported by this master agent.\nThe current protocol version is 1.  Note that the master agent\nmust also allow interaction with earlier version subagents.")
agentxConnection = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 1, 2))
agentxConnTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 74, 1, 2, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxConnTableLastChange.setDescription("The value of sysUpTime when the last row creation or deletion\noccurred in the agentxConnectionTable.")
agentxConnectionTable = MibTable((1, 3, 6, 1, 2, 1, 74, 1, 2, 2))
if mibBuilder.loadTexts: agentxConnectionTable.setDescription("The agentxConnectionTable tracks all current AgentX transport\nconnections.  There may be zero, one, or more AgentX sessions\ncarried on a given AgentX connection.")
agentxConnectionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1)).setIndexNames((0, "AGENTX-MIB", "agentxConnIndex"))
if mibBuilder.loadTexts: agentxConnectionEntry.setDescription("An agentxConnectionEntry contains information describing a\nsingle AgentX transport connection.  A connection may be\n\n\nused to support zero or more AgentX sessions.  An entry is\ncreated when a new transport connection is established,\nand is destroyed when the transport connection is terminated.")
agentxConnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: agentxConnIndex.setDescription("agentxConnIndex contains the value that uniquely identifies\nan open transport connection used by this master agent\nto provide AgentX service.  Values of this index should\nnot be re-used.  The value assigned to a given transport\nconnection is constant for the lifetime of that connection.")
agentxConnOpenTime = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxConnOpenTime.setDescription("The value of sysUpTime when this connection was established\nand, therefore, its value when this entry was added to the table.")
agentxConnTransportDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1, 3), TDomain()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxConnTransportDomain.setDescription("The transport protocol in use for this connection to the\nsubagent.")
agentxConnTransportAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 2, 2, 1, 4), AgentxTAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxConnTransportAddress.setDescription("The transport address of the remote (subagent) end of this\nconnection to the master agent.  This object may be zero-length\nfor unix-domain sockets (and possibly other types of transport\naddresses) since the subagent need not bind a filename to its\nlocal socket.")
agentxSession = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 1, 3))
agentxSessionTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 74, 1, 3, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionTableLastChange.setDescription("The value of sysUpTime when the last row creation or deletion\noccurred in the agentxSessionTable.")
agentxSessionTable = MibTable((1, 3, 6, 1, 2, 1, 74, 1, 3, 2))
if mibBuilder.loadTexts: agentxSessionTable.setDescription("A table of AgentX subagent sessions currently in effect.")
agentxSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1)).setIndexNames((0, "AGENTX-MIB", "agentxConnIndex"), (0, "AGENTX-MIB", "agentxSessionIndex"))
if mibBuilder.loadTexts: agentxSessionEntry.setDescription("Information about a single open session between the AgentX\nmaster agent and a subagent is contained in this entry.  An\nentry is created when a new session is successfully established\nand is destroyed either when the subagent transport connection\nhas terminated or when the subagent session is closed.")
agentxSessionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: agentxSessionIndex.setDescription("A unique index for the subagent session.  It is the same as\nh.sessionID defined in the agentx header.  Note that if\na subagent's session with the master agent is closed for\nany reason its index should not be re-used.\nA value of zero(0) is specifically allowed in order\nto be compatible with the definition of h.sessionId.")
agentxSessionObjectID = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionObjectID.setDescription("This is taken from the o.id field of the agentx-Open-PDU.\nThis attribute will report a value of '0.0' for subagents\nnot supporting the notion of an AgentX session object\nidentifier.")
agentxSessionDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionDescr.setDescription("A textual description of the session.  This is analogous to\nsysDescr defined in the SNMPv2-MIB in RFC 1907 [19] and is\ntaken from the o.descr field of the agentx-Open-PDU.\nThis attribute will report a zero-length string value for\nsubagents not supporting the notion of a session description.")
agentxSessionAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: agentxSessionAdminStatus.setDescription("The administrative (desired) status of the session.  Setting\nthe value to 'down(2)' closes the subagent session (with c.reason\nset to 'reasonByManager').")
agentxSessionOpenTime = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionOpenTime.setDescription("The value of sysUpTime when this session was opened and,\ntherefore, its value when this entry was added to the table.")
agentxSessionAgentXVer = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionAgentXVer.setDescription("The version of the AgentX protocol supported by the\nsession.  This must be less than or equal to the value of\nagentxMasterAgentXVer.")
agentxSessionTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 3, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxSessionTimeout.setDescription("The length of time, in seconds, that a master agent should\nallow to elapse after dispatching a message to this session\nbefore it regards the subagent as not responding.  This value\nis taken from the o.timeout field of the agentx-Open-PDU.\nThis is a session-specific value that may be overridden by\nvalues associated with the specific registered MIB regions\n(see agentxRegTimeout). A value of zero(0) indicates that\nthe master agent's default timeout value should be used\n\n\n(see agentxDefaultTimeout).")
agentxRegistration = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 1, 4))
agentxRegistrationTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 74, 1, 4, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegistrationTableLastChange.setDescription("The value of sysUpTime when the last row creation or deletion\noccurred in the agentxRegistrationTable.")
agentxRegistrationTable = MibTable((1, 3, 6, 1, 2, 1, 74, 1, 4, 2))
if mibBuilder.loadTexts: agentxRegistrationTable.setDescription("A table of registered regions.")
agentxRegistrationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1)).setIndexNames((0, "AGENTX-MIB", "agentxConnIndex"), (0, "AGENTX-MIB", "agentxSessionIndex"), (0, "AGENTX-MIB", "agentxRegIndex"))
if mibBuilder.loadTexts: agentxRegistrationEntry.setDescription("Contains information for a single registered region.  An\nentry is created when a session  successfully registers a\nregion and is destroyed for any of three reasons: this region\nis unregistered by the session, the session is closed,\nor the subagent connection is closed.")
agentxRegIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: agentxRegIndex.setDescription("agentxRegIndex uniquely identifies a registration entry.\nThis value is constant for the lifetime of an entry.")
agentxRegContext = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegContext.setDescription("The context in which the session supports the objects in this\nregion.  A zero-length context indicates the default context.")
agentxRegStart = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegStart.setDescription("The starting OBJECT IDENTIFIER of this registration entry.  The\nsession identified by agentxSessionIndex implements objects\nstarting at this value (inclusive).  Note that this value could\nidentify an object type, an object instance, or a partial object\ninstance.")
agentxRegRangeSubId = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegRangeSubId.setDescription("agentxRegRangeSubId is used to specify the range.  This is\ntaken from r.region_subid in the registration PDU.  If the value\nof this object is zero, no range is specified.  If it is non-zero,\nit identifies the `nth' sub-identifier in r.region for which\nthis entry's agentxRegUpperBound value is substituted in the\nOID for purposes of defining the region's upper bound.")
agentxRegUpperBound = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegUpperBound.setDescription("agentxRegUpperBound represents the upper-bound sub-identifier in\na registration.  This is taken from the r.upper_bound in the\nregistration PDU.  If agentxRegRangeSubid (r.region_subid) is\nzero, this value is also zero and is not used to define an upper\nbound for this registration.")
agentxRegPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegPriority.setDescription("The registration priority.  Lower values have higher priority.\nThis value is taken from r.priority in the register PDU.\nSessions should use the value of 127 for r.priority if a\ndefault value is desired.")
agentxRegTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegTimeout.setDescription("The timeout value, in seconds, for responses to\nrequests associated with this registered MIB region.\nA value of zero(0) indicates the default value (indicated\nby by agentxSessionTimeout or agentxDefaultTimeout) is to\nbe used.  This value is taken from the r.timeout field of\nthe agentx-Register-PDU.")
agentxRegInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 74, 1, 4, 2, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: agentxRegInstance.setDescription("The value of agentxRegInstance is `true' for\nregistrations for which the INSTANCE_REGISTRATION\nwas set, and is `false' for all other registrations.")
agentxConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 2))
agentxMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 2, 1))
agentxMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 74, 2, 2))

# Augmentions

# Groups

agentxMIBGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 74, 2, 1, 1)).setObjects(*(("AGENTX-MIB", "agentxSessionDescr"), ("AGENTX-MIB", "agentxSessionAdminStatus"), ("AGENTX-MIB", "agentxConnTransportDomain"), ("AGENTX-MIB", "agentxRegPriority"), ("AGENTX-MIB", "agentxSessionTableLastChange"), ("AGENTX-MIB", "agentxSessionAgentXVer"), ("AGENTX-MIB", "agentxConnTableLastChange"), ("AGENTX-MIB", "agentxDefaultTimeout"), ("AGENTX-MIB", "agentxConnOpenTime"), ("AGENTX-MIB", "agentxSessionTimeout"), ("AGENTX-MIB", "agentxMasterAgentXVer"), ("AGENTX-MIB", "agentxSessionObjectID"), ("AGENTX-MIB", "agentxRegRangeSubId"), ("AGENTX-MIB", "agentxRegStart"), ("AGENTX-MIB", "agentxRegUpperBound"), ("AGENTX-MIB", "agentxRegContext"), ("AGENTX-MIB", "agentxRegistrationTableLastChange"), ("AGENTX-MIB", "agentxConnTransportAddress"), ("AGENTX-MIB", "agentxRegInstance"), ("AGENTX-MIB", "agentxRegTimeout"), ("AGENTX-MIB", "agentxSessionOpenTime"), ) )
if mibBuilder.loadTexts: agentxMIBGroup.setDescription("All accessible objects in the AgentX MIB.")

# Compliances

agentxMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 74, 2, 2, 1)).setObjects(*(("AGENTX-MIB", "agentxMIBGroup"), ) )
if mibBuilder.loadTexts: agentxMIBCompliance.setDescription("The compliance statement for SNMP entities that implement the\nAgentX protocol.  Note that a compliant agent can implement all\nobjects in this MIB module as read-only.")

# Exports

# Module identity
mibBuilder.exportSymbols("AGENTX-MIB", PYSNMP_MODULE_ID=agentxMIB)

# Types
mibBuilder.exportSymbols("AGENTX-MIB", AgentxTAddress=AgentxTAddress)

# Objects
mibBuilder.exportSymbols("AGENTX-MIB", agentxMIB=agentxMIB, agentxObjects=agentxObjects, agentxGeneral=agentxGeneral, agentxDefaultTimeout=agentxDefaultTimeout, agentxMasterAgentXVer=agentxMasterAgentXVer, agentxConnection=agentxConnection, agentxConnTableLastChange=agentxConnTableLastChange, agentxConnectionTable=agentxConnectionTable, agentxConnectionEntry=agentxConnectionEntry, agentxConnIndex=agentxConnIndex, agentxConnOpenTime=agentxConnOpenTime, agentxConnTransportDomain=agentxConnTransportDomain, agentxConnTransportAddress=agentxConnTransportAddress, agentxSession=agentxSession, agentxSessionTableLastChange=agentxSessionTableLastChange, agentxSessionTable=agentxSessionTable, agentxSessionEntry=agentxSessionEntry, agentxSessionIndex=agentxSessionIndex, agentxSessionObjectID=agentxSessionObjectID, agentxSessionDescr=agentxSessionDescr, agentxSessionAdminStatus=agentxSessionAdminStatus, agentxSessionOpenTime=agentxSessionOpenTime, agentxSessionAgentXVer=agentxSessionAgentXVer, agentxSessionTimeout=agentxSessionTimeout, agentxRegistration=agentxRegistration, agentxRegistrationTableLastChange=agentxRegistrationTableLastChange, agentxRegistrationTable=agentxRegistrationTable, agentxRegistrationEntry=agentxRegistrationEntry, agentxRegIndex=agentxRegIndex, agentxRegContext=agentxRegContext, agentxRegStart=agentxRegStart, agentxRegRangeSubId=agentxRegRangeSubId, agentxRegUpperBound=agentxRegUpperBound, agentxRegPriority=agentxRegPriority, agentxRegTimeout=agentxRegTimeout, agentxRegInstance=agentxRegInstance, agentxConformance=agentxConformance, agentxMIBGroups=agentxMIBGroups, agentxMIBCompliances=agentxMIBCompliances)

# Groups
mibBuilder.exportSymbols("AGENTX-MIB", agentxMIBGroup=agentxMIBGroup)

# Compliances
mibBuilder.exportSymbols("AGENTX-MIB", agentxMIBCompliance=agentxMIBCompliance)
