/*
 * Copyright (c) 2006 Bea Lam. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#import <Cocoa/Cocoa.h>

#import <IOBluetooth/OBEX.h>
#import <IOBluetooth/objc/IOBluetoothOBEXSession.h>

@interface BBOBEXUtil : NSObject {
	//
}

/*
 * Returns a string describing a server response code (e.g. "Not Found")
 */
+ (NSString *)describeServerResponse:(OBEXOpCode)responseCode;

@end


/*
 * Reader to read a file chunk by chunk, as necessary for PUT and GET operations.
 */
@interface BBOBEXFileReader : NSObject {
	BOOL mIsClient;	
	OBEXSession *mOBEXSession;
	NSFileHandle *mFile;
}

/*
 * Creates a reader to read the given file for the given session. isClient
 * should be YES if the session is a client session, otherwise NO.
 */
- (id)initWithFile:(NSFileHandle *)file 
		forSession:(OBEXSession *)session
		  isClient:(BOOL)isClient;

/*
 * Returns the file being read.
 */
- (NSFileHandle *)file;

/*
 * Reads and returns the next chunk for the given operation. isLastChunk will 
 * be set to YES if the end of the file has been reached, or NO if it has not.
 */
- (NSData*)readNextChunkForHeaderLength:(size_t)optHdrLength
								  forOp:(OBEXOpCode)opCode
							isLastChunk:(BOOL *)outIsLastChunk;
@end


