/*
 * Copyright (c) 2006 Bea Lam. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

//
//  BBOBEXServer.h
//  BTUtil
//  
//  A basic OBEX server.
//
//  Before running a server, you will need to advertise an OBEX service. For
//  example, use the BBServiceAdvertise methods to advertise an OBEX service,
//  and use the resulting BluetoothRFCOMMChannelID to create a BBOBEXServer
//  instance.
//
//  See the included BTUtil "SimpleOBEXServer" example.
//

#import <Cocoa/Cocoa.h>
#import <Foundation/Foundation.h>

#import <IOBluetooth/Bluetooth.h>
#import <IOBluetooth/OBEX.h>

@class BBOBEXFileReader, BBOBEXServerSession, IOBluetoothUserNotification;

@interface BBOBEXServer : NSObject {
	BluetoothRFCOMMChannelID mServerChannelID;
	IOBluetoothUserNotification *mChannelOpenNotif;
	NSMutableArray *mServerSessions;

	id mDelegate;
}

/*
 * Sets whether debug messages should be displayed (default is NO).
 */
+ (void)setDebug:(BOOL)doDebug;

/*
 * Creates a server with the specified delegate. The delegate will receive 
 * delegate events from BBOBEXServerSession instances started on this server.
 */
- (id)initWithDelegate:(id)delegate;

/*
 * Starts the server on the specified channel.
 */
- (OBEXError)startOnChannelID:(BluetoothRFCOMMChannelID)channelID;

/*
 * Returns YES if the server has been started, and has not been stopped. 
 * Otherwise returns NO.
 */
- (BOOL)isRunning;

/*
 * Stops the server.
 */
- (OBEXError)stop;

/*
 * Sets the delegate, which will receive delegate events from BBOBEXServerSession
 * instances started on this server.
 */
- (void)setDelegate:(id)delegate;

/*
 * Returns the delegate.
 */
- (id)delegate;

@end

