# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     ./generate_unicodedb.py --unidata_version=5.2.0 --output=unicodedb_5_2_0

from pypy.rlib.rarithmetic import r_longlong


base_mod = None
version = '5.2.0'


def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)
        
        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError, name

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.insert(0, substring)

        prevnode = charnode // 3
        charnode = parent

    return ''.join(res)
    

_stringtable = (
'\x11TEN THOUSAND SIGN'
'\x06ESHTIN'
'\x04KAD3'
'\x03IX '
'\x06JOINED'
'\x04LASH'
'\x06JOINER'
'\tUPTSTIMME'
'\x0bOPPOSING EN'
'\x07MICOLON'
'\x0eLESS-THAN NOR '
'\x03IXT'
'\x07LEUT KA'
'\rYPOGEGRAMMENI'
'\x1dUP HEAVY AND RIGHT DOWN LIGHT'
'\nBLACK STAR'
'\x05RUHUA'
'\x05WISAD'
'\x15OPPOSING AN PLUS NAGA'
'\nMONOFONIAS'
'\r VARIANT FORM'
'\x04NGUE'
'\x0cMADDA ABOVE '
'\x0eCORNER BRACKET'
'\x03BEH'
'\x04A-HA'
'\x03BEN'
'\x03BEE'
'\tCENT SIGN'
'\x03BET'
'\x18UPRIGHT RECTANGULAR ZERO'
'\x04BIRD'
'\x0fMARRYING MAIDEN'
'\x0bMED RGYINGS'
'\x05SHIMA'
'\x04EIRT'
'\nMINUS SIGN'
'\x08MPERSAND'
'\x03NOO'
'\x03TJE'
'\x04IGER'
'\x05HIEUH'
'\x04RITU'
'\x18DIAGONAL CROSSHATCH FILL'
'\nRVICE MARK'
'\x03NOW'
'\tLAMATION '
'\x03ED '
'\x041 DU'
'\x041 DA'
'\x07R ABOVE'
'\rOBLIQUE LINE '
'\x0b TIMES ESH2'
'\x07AM ALEF'
'\x0bILCROW SIGN'
'\x06MEMBER'
'\x11NASALIZATION MARK'
'\x11BOTTOM HALF BLACK'
'\x04ARTH'
'\x08F SYMBOL'
'\x08TRICOLON'
'\x06INSHIP'
'\x05UNITY'
'\x08 KEMBANG'
'\x0295'
'\x15HORIZONTAL TABULATION'
'\tTWO DOTS '
'\x06 AND S'
'\x0cCSIMILE SIGN'
'\x14HORIZONTAL BAR WITH '
'\x06KHAH I'
'\x06TICAL '
'\x04YEH '
'\x06ENIKI '
'\nUPPER HALF'
'\x0eLOWER DIAGONAL'
'\x04OWER'
'\x08VOCALIC '
'\x04PEEP'
'\x02LF'
'\x02LD'
'\x02LE'
'\x02LC'
'\x02LA'
'\x02LO'
'\x02LL'
'\x02LM'
'\x16LONG HORIZONTAL STROKE'
'\x02LK'
'\x02LH'
'\x02LI'
'\x02LT'
'\x02LU'
'\x02LY'
'\x01A'
'\x04HEAD'
'\x02L '
'\x1cBESIDE AND JOINED WITH UNION'
'\x16RECTILINEAR BLACK STAR'
'\x04HEAT'
'\x02L2'
'\x02L0'
'\x0fOUTH EAST ARROW'
'\x16DOMAIN ANTIRESTRICTION'
'\x1cRECT CURRENT SYMBOL FORM TWO'
'\x06LASTON'
'\x0bQUIQUADRATE'
'\x15DOWN HORIZONTAL HEAVY'
'\rSMALL V BELOW'
'\x0eINVERTED DAMMA'
'\x1bRIPLE VERTICAL BAR OPERATOR'
'\x0fRIGHT HALF RING'
'\x08REVERSE '
'\x05BEITH'
'\x0bORCE SYMBOL'
'\x04SA-I'
'\x04NPEA'
'\x04OXIA'
'\rANGLE BRACKET'
'\x06M BOAR'
'\x08REVERSED'
'\x05URAMU'
'\nTEMPLATION'
'\x07DOTTED '
'\x0bDOUBLE SHAD'
'\x05SUKUN'
'\x03APH'
'\x04HAM '
'\x03APA'
'\x13DIAGONAL HALF BLACK'
'\n5 PLASTICS'
'\x11 AND MIDDLE TILDE'
'\rIMAGE BRACKET'
'\x05NINTH'
'\x08MARITAN '
'\x05MROCK'
'\x14EVERSED ROTATED RANA'
'\x07UP MARK'
'\x06SPIRAL'
'\x04ODO '
'\x07ARRED B'
'\x0bPUNCTUATION'
'\x07ARRED O'
'\x13PLACEMENT CHARACTER'
'\x043 RI'
'\x05MUOY '
'\x05HEAD '
'\x08AVY BAND'
'\x07R TSHES'
'\x12KBAR ISOLATED FORM'
'\x07KYLISMA'
'\rCROSSING MUSH'
'\x05CLICK'
'\x05FSAAQ'
'\x03YAT'
'\x06VIYANI'
'\x0bUNJO WYNN W'
'\x03YAA'
'\nUR CORNERS'
'\x05 REST'
'\tY-FOURTH '
'\x10YATHOS BASE SIGN'
'\x06PENCIL'
'\nPLICATION '
'\x07IVISION'
'\tFULL STOP'
'\x0cSUR OVER SUR'
'\tMMER AND '
'\x1bHITE DOWN-POINTING TRIANGLE'
'\x11VOICED SOUND MARK'
'\x04GGWS'
'\x06AISED '
'\x1aDROP-SHADOWED WHITE SQUARE'
'\x0cRNAM BCAD MA'
'\x14DOWN ARROWHEAD BELOW'
'\n PLUS MASH'
'\x17 HUNDRED TWENTY-EIGHTH '
'\x11INEAR ANNOTATION '
'\x06ARTER '
'\nCOMBINING '
'\x0cLTA EQUAL TO'
'\x07JIBWAY '
'\nOSSED SHEI'
'\x0bFGHANI SIGN'
'\x06 LONGA'
'\x06MILAR '
'\tXHAUSTION'
'\x07OTATED '
'\x07AXIMATA'
'\x0cNATURAL SIGN'
'\x07A NAME '
'!LESS-THAN ABOVE DOUBLE-LINE EQUAL'
'\x08VINATION'
'\x1eSUPERSCRIPT ALEF ISOLATED FORM'
'\x05XTILE'
'\x01X'
'\rGHT HALF RING'
'\x04NYIS'
'\nALENT SIGN'
'\x03DMA'
'\tAP FILLER'
'\x12OW TONE APOSTROPHE'
'\tABLED CAR'
'\x10KA- SHOG YIG MGO'
'\x0fXCLAMATION MARK'
'\x0bOF MASHFAAT'
'\x06 BELOW'
'\x04GIDA'
'\x05GRAPH'
'\x02A2'
'\nMONOGRAM B'
'\x13TO LOWER RIGHT FILL'
'\x12NINETEEN FULL STOP'
'\x1bEAVY WHITE RIGHTWARDS ARROW'
'\nDOWN ARROW'
'\x0bPHNAEK MUAN'
'\x04KURO'
'\x0cNUITY SYMBOL'
'\tRAL HEART'
'\x06 LENGA'
'\x04NGSI'
'\x18GLOTTAL STOP WITH STROKE'
'\x07SVARITA'
'\x05EVEN '
'\x08EGORIAN '
'\x02A '
'\x03253'
'\x06WIDTH '
'\x0cN ELEMENT OF'
'\x0fDAGESH OR MAPIQ'
'\x08CANDICUS'
'\x0cTHODOX CROSS'
'\x10AM ISOLATED FORM'
'\x08ULL STOP'
'\x0eDEYTEROS ICHOS'
'\x04ZERO'
'!ALL BUT UPPER LEFT QUADRANT BLACK'
'\x05OSS O'
'\x04ERET'
'\x10VERTICALLY ABOVE'
'\x03NMA'
'\tHIYYAALAA'
'\x06LEMENT'
'\x05EVENT'
'\x13WITH YEH FINAL FORM'
'\x03LON'
'\x03LOO'
'\x03LOR'
'\x03LOS'
'\x18UPWARD POINTING TRIANGLE'
'\x03LOW'
'\x0bUZEIRO SIGN'
'\x05OKEN '
'\x0bRDHAVISARGA'
'\x10NORTH WEST ARROW'
'\x0bGRAMMA SIGN'
'\x05EGIN '
'\tEMBEDDING'
'\x13LEFT TO LOWER RIGHT'
'\x08EAR SIGN'
'\x05POLI '
'\tAS MEMBER'
'\nFEATHERED '
'\x08EBEEFILI'
'\tDOWNWARDS'
'\x08IS-PILLA'
'\x04COND'
'\x16C GREATER-THAN BRACKET'
'\x0bREAKTHROUGH'
'\x07THESEOS'
'\tISEN-ISEN'
'\tEDESTRIAN'
'\x11TRIPLE DASH ARROW'
'\x07TAYANNA'
'\nARANI SIGN'
'\x1eGREATER-THAN ABOVE EQUALS SIGN'
'\x0bAESCULAPIUS'
'\x04IFAT'
'\x17OVERLAPPING LOGICAL AND'
'\x0cROWNING FACE'
'\x05VARIA'
'\x08OT BELOW'
'\x08LI GALI '
'\x05HANNA'
'\x08ISH TAIL'
'\x04DAGS'
'\x0bEPIDAUREAN '
'\x0b WITH CARON'
'\x16I YFESIS TETARTIMORION'
'\x0bME LONG CAN'
'\n WITH TICK'
'\x07STATERS'
'\x02OU'
'\x10 TIMES A PLUS NA'
'\x07DIAMOND'
'\x03MPL'
' NORMAL FACTOR SEMIDIRECT PRODUCT'
'\x03MPI'
'\x03AVE'
'\x08 HANDLES'
'\x05LAYAR'
'\x046 QA'
'\x04ADHU'
'\x04ADHE'
'\x0cVIAN LETTER '
'\x0fSPOKED ASTERISK'
'\x04UHUR'
'\x04BOVE'
'\tIDEWAYS U'
'\x04SUNG'
'\x05HOLE '
'\x08NUS SIGN'
'\x04NAL '
'\x0cCIRCLED PLUS'
'\x16INDIRECT QUESTION MARK'
'\x04ISI '
'\x05EISMA'
'\x06N SIGN'
'\x043 PA'
'\x14 ABOVE LEFT TRIANGLE'
'\x06NOWMAN'
'\x03155'
'\tIALYTIKA '
'\x05PRINT'
'\x07NANCIAL'
'\x08-PHIEUPH'
'\x05FLUTE'
'\x07HYAAUSH'
'\x0bONE HUNDRED'
'\x0bUNIT DIGIT '
'\x01E'
'\x16WITH VOICED SOUND MARK'
'\nKFONITIKON'
'\x0bIN EQUAL TO'
'\x0bNYIS -KHYIL'
'\x05DALET'
'\x0cPAP PLUS PAP'
'\x0299'
'(VERTICAL BAR AT END OF HORIZONTAL STROKE'
'\x05AR AE'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06TAIKHU'
'\x04EFT '
'\x0bDYO CHRONON'
'\x19GAD OVER GAD GAR OVER GAR'
'\x0fMALAKON CHROMA '
'\x08TONE BAR'
'\x05OTHAL'
'\x1aCLOCKWISE ARROW WITH MINUS'
'\x07MBOL B0'
'\x07CK MARK'
'\nRENCY SIGN'
'\x04WEEN'
'\n1 PLASTICS'
'\x07HASANTA'
'\x14ENARMONIOS ANTIFONIA'
'\x10TODO SOFT HYPHEN'
'\tUPPER DOT'
'\x0fALAYHE ASSALLAM'
'\t OVER BAL'
'\x04RAM '
'\x04WEET'
'\n AND ACUTE'
'\x06CREASE'
'\x11RYBLION BASE SIGN'
'\nOMMA BELOW'
'\x06ESTION'
'\x07MINGKAL'
'\x038F0'
'\x06HIEUCH'
'\x0fRMAN PENNY SIGN'
'\x02M '
'\x07 APLOUN'
'\tLOWER DOT'
'\x02M0'
'\x07KAYANNA'
'\x04OUND'
'\x04JEEM'
'\x07TCHFORK'
'\rEVERSED DAMMA'
'\x05UCEUS'
'\x05UNION'
'\x05ZYGOS'
'\x08RYNGEAL '
'\x14INVERTED CANDRABINDU'
'\rRRIAGE RETURN'
'\x08ANUDATTA'
'\x07APEZIUM'
'\x02ME'
'\x02MA'
'\x02MB'
'\x02MM'
'\x02MO'
'\x02MI'
'\x02MU'
'\x06EMOLO-'
'\x0bRYVNIA SIGN'
'\x06EDIUM '
'\x02MY'
'\x02MX'
'\x04ILDE'
'\x03DON'
'\tNDRABINDU'
'\x18SMALL ARABIC LETTER TAH '
'\x0fHORIZONTAL DASH'
'\x07PRENKHA'
'\n WITH DOTS'
'\x06YFESIS'
'\x04REAT'
'\x06OFOUND'
'\x03DOT'
'\x13UP HORIZONTAL LIGHT'
'\x0eRFACE INTEGRAL'
'\nLITTLE YUS'
'\x08ER TRUTH'
'\x0bOPPOSING IM'
'\x07ARDNESS'
'\x04VINE'
'\x07VAYANNA'
'\x08LESS SHA'
'\nHEAVY AND '
'\n WITH DOT '
'\x04INUS'
'\x03DO '
'\x03BAU'
'\x03BAR'
'\x0bMUUSIKATOAN'
'\r-PER-EM SPACE'
'\x03BAD'
'\x03BAA'
'\x03BAN'
'\x04NEO '
'\x1dEFTWARDS HARPOON WITH BARB UP'
'\x05CHULA'
'\nTERNATIVE '
'\tTIMES BAD'
'\x06I MAIM'
'\x056 RA2'
'\x03STA'
'\x05ETORU'
'\x04SADI'
'\x03STU'
'\x04MNAS'
'\x04ZETA'
'\rLVE FULL STOP'
'\x05HAALU'
'\nF SHE-GOAT'
'\x10OREAN CHARACTER '
'\x1cRECTANGULAR PATH AROUND POLE'
'\x0bREE HUNDRED'
'\x071 ARROW'
'\x07ALESMA '
'\x05 AND '
'\x0c OVER TWO PI'
'\x08AMS HORN'
'\x03ACK'
'\x06 ABOVE'
'\x04 NOT'
'\x0cVAKRAHASANYA'
'\x0eIWAZ TIR TYR T'
'\x0bTHIRDS SIGN'
' WO DOTS OVER ONE DOT PUNCTUATION'
'\x05FTEEN'
'\x04BASA'
'\x06ITABLE'
'\x04BASH'
'\x0fLMOST EQUAL TO '
'\x03KAB'
'\x03KAF'
'\x03KAK'
'\x03KAL'
'\x13HORIZONTAL ELLIPSIS'
'\x03RHO'
'\tUMED HEAD'
'\x03KAY'
'\tINVERTED '
'\rSIGN PAMUDPOD'
'\nRACTER TIE'
'\x04PEAT'
'\x044 ZE'
'\x07VAV YOD'
'\x05OWEL '
'\x0cHASIS SYMBOL'
'\nGBAKURUNEN'
'\x08UATRILLO'
"'ABOVE RIGHTWARDS HARPOON WITH BARB DOWN"
'\x0fUPERSCRIPT ALEF'
'\nRHO SYMBOL'
'\x08OVER GI4'
'\t OVER NUN'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'\x07DIGRAPH'
'\x05LAGAB'
'\x12TROFLEX HOOK BELOW'
'\x05HITE '
'\x11HORIZONTAL STROKE'
'\x0eIVE OBOLS SIGN'
'\x03ATE'
'\x12ABOVE GREATER-THAN'
'\x03ATH'
'\x03ATI'
'\x0bYEORINHIEUH'
'\x05ERET '
'\x07NSULAR '
'\x04TTER'
'\x045 AU'
'\x05 BACK'
'\x04AAMU'
'\x012'
'\x06SHORT '
'\x06SPATHI'
'\x045 A2'
'\x14HIGH TONE APOSTROPHE'
'\x05TILDE'
'\x04CART'
'\x08IAERESIS'
'\x07UKKAKHA'
'\x0fINUS SIGN BELOW'
'\x10DOUBLE DOT ABOVE'
'\x04RUTU'
'\x03AT '
'\tLLABLE OM'
'\x11JEEM INITIAL FORM'
'\x08BEVERAGE'
'\x07ITALIC '
'\x04MER '
'\x06OYANNA'
'\tLOCKWISE '
'\x10EPSILON UNDERBAR'
'\tCCER BALL'
'\x05XAGON'
'\x05NUKTA'
'\x04NANA'
'\x04LO L'
'\x1aALEF MAKSURA ISOLATED FORM'
'\x05IAUDA'
'\x04IK H'
'\x0bOLDING BACK'
'\x0bLENGTH MARK'
'\x05EAGLE'
'\x05TIMES'
'\x05BREW '
'\x04AMMA'
'\x0eWITH DIAERESIS'
'\x06OR EQU'
'\x08CRO SIGN'
'\x1eMAKSURA WITH SUPERSCRIPT ALEF '
'\x07SEXTILE'
'\x18BLACK LENTICULAR BRACKET'
'\x07 MUQDAM'
'\x0fPERTHO PEORTH P'
'\nHAAPRAANA '
'\x12DOWN-OUTPUT SYMBOL'
'6UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA '
'\x17ELVE POINTED BLACK STAR'
'\x08TAALUJA '
'\x05JUEUI'
'\x08YPORROON'
'\tRIZONTAL '
'\nENTHUSIASM'
'\x04IOTA'
'\x03XIA'
'\x03YEH'
'\tLESS-THAN'
'\x03YEE'
'\nTHMIKON N '
'\tJERUSALEM'
'\x06IRCLE '
'\x06M BULL'
'\x080 BRONZE'
'\x05LIDUS'
'\x0bMBA BAYANNA'
'\tZ DIGRAPH'
'\x06APYRUS'
'\x19PERFECTUM CUM PROLATIONE '
'\x07OX LINE'
'\rCROSSING GAN2'
'\x07SYNAGMA'
'\x06EMKATH'
'\x13LUNATE SIGMA SYMBOL'
'\tFEH WITH '
'\x06DIVIDE'
'\x18P DIRECTIONAL FORMATTING'
'\x08ONG DASH'
'\x0eAPITAL LETTER '
'\x10SMALL CAPITAL EL'
'\x05 TACK'
'\x05RITSI'
'\x05ERIN2'
'\x05WEST '
'\x04DIM2'
'\x07CULAR O'
'\rFINAL LETTER '
'\x05NCHU '
'\x0cIDENTICAL TO'
'\x16PERSET OF NOR EQUAL TO'
'\x04MTI '
'\n3 PLASTICS'
'\rTIRTA TUMETES'
'\x059 PU2'
'\x06IX OF '
'\x03RUE'
'\x11 LAGAR OVER LAGAR'
'\x06C CLEF'
'\x03JHA'
'\x03DIM'
'\x03DIN'
'\x0bNUN HAFUKHA'
'\x03DIB'
'\x0eMENSION ORIGIN'
'\x06UNTAIN'
'\x06PERSET'
'\x07COPTIC '
'\x11DENTAL PERCUSSIVE'
'\x11ESTERN PWO KAREN '
'\x08OR EQUAL'
'\x1bIMPERFECTUM CUM PROLATIONE '
'\x03UTE'
'\x01I'
'\x03IRT'
'\x03IRU'
'\tNTERPRISE'
'\x03IRI'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x05TYR T'
'\x03IRO'
'\tNOT EQUAL'
'\x07STIMATE'
'\x03IRC'
'\x03IRE'
'\nNTITY MARK'
'\rWO DOTS BELOW'
'\x0bBUT NOT EQU'
'\x03PWA'
'\x03BOX'
'\x03NAH'
'\x05NATE '
'\x06EIGHTY'
'\x03NAR'
'\x06VIRIAM'
'\rU LENGTH MARK'
'\x06EIGHTH'
'\x0cOPPOSING LU2'
'\nR2 PLUS SU'
'\nTIMES SIGN'
'\x14RIGHT QUADRANT BLACK'
'\x07VE DOT '
'\x0e WITH UNDERBAR'
'\x05LAMDA'
'\nWHITE STAR'
'\x11 ALTERNATION MARK'
'\x07OX BACK'
'\rTROFLEX CLICK'
'\nAKKHANGYAO'
'\x06EIGHT '
'\rEMPHATIC TONE'
'\x11OUBLE MONOCULAR O'
'\x07OMERANG'
'\rUSICAL LEIMMA'
'\x0fRISING DIAGONAL'
'\x05REVIA'
'\x0bBETA SYMBOL'
'\x06ISSHAR'
'\x06SQUARE'
'\tMHANCHOLL'
'\x05OPBAR'
'\x05ASKAL'
'\x08 ROTUNDA'
'\x08VE SASAK'
'\x03LK '
'\tTHOUSAND '
'\x0cATTOOED HEAD'
'\x07JECTIVE'
'\x0cEIGHTH BLOCK'
'\x1cASTERISKS ALIGNED VERTICALLY'
'\x07ELLIPSE'
'\nOON LILITH'
'\nLOGICAL OR'
'\x08 TIMES E'
'\rMILLIONS SIGN'
'\x044 DO'
'\rONGRATULATION'
'\x06PIRIT '
'\x02NN'
'\x02NO'
'\x02NA'
'\x02ND'
'\x02NE'
'\x02NG'
'\x02NY'
'\tIRCUMFLEX'
'\x02NT'
'\x02NU'
'\x02NW'
'\x0fFOUR DOTS ABOVE'
'\x02N '
'\x06IASMA '
'\x04RTAR'
'\x07S ABOVE'
'\x06BALUDA'
'\x05PONSE'
'\x03OZE'
'\x06YMBOL '
'\x0bUTH CORNERS'
'\x05MALL '
'\x0eERIC INDICATOR'
'\r DIFFERENTIAL'
'\x07VILIK B'
'\x06YLISMA'
'\x07OVER AN'
'\x07VERLINE'
'\x03AZU'
'\tSIXTEENTH'
'\tCOMPLETED'
'\x04RUNA'
'\x07F DAVID'
'\x04JONG'
'\x04RUNG'
'\x08OVERRIDE'
'\x10DOWN RIGHT BARB '
'\x05ENANO'
'\x0eOVER GUD LUGAL'
'\x042 SO'
'\rVERSE DIVIDER'
'\x12UTLINED BLACK STAR'
'\x05KASRA'
'\x0cMBELLISHMENT'
'\tNCLOSING '
'\x07MINIMA '
'\x07SHORT A'
'\rEAVENLY EARTH'
'\x0cEMISOFT SIGN'
'\x043 MI'
'\nAILED BIRD'
'\x10INES CONVERGING '
'\x08WASH KAF'
'\x17VERTICAL BISECTING LINE'
'\x0cREPONDERANCE'
'\x05EGL H'
'\x06INESE '
'\x06TIKEUT'
'\x07BINING '
'\nIVALENT TO'
'\x06OICING'
'\x04QEF '
'\x06RIPLE '
'\x07MARCATO'
'\nSE-CREE SK'
'\rBY DEFINITION'
'\x04PACE'
'\x070 WHEAT'
'\x04LOOR'
'\x04LOOP'
'\x0cLUS NOTEHEAD'
'\x05UTIES'
'\x05BLANK'
'\x05MURDA'
'\x18BERKANAN BEORC BJARKAN B'
'\x04SHAR'
'\x04APON'
'\x07UM IYEK'
'\x04SHAD'
'\x04SHAN'
'\x04SHA3'
'\nKAI SYMBOL'
'\x0eQUARTERS BLOCK'
'\x13STRATIAN FIFTY MNAS'
'\tACE NOTE '
'\x07RAYANNA'
'\x14UBLE VERTICAL STROKE'
'\x08I SHAKTI'
'#TWO HORIZONTAL STROKES TO THE RIGHT'
'\rPAIRED ARROWS'
'\x0bDONG TSHUGS'
'\x07 HYPHEN'
'\x10PRECHGESANG STEM'
'\x06WN BOW'
'\x03VE '
'\x016'
'\x06KIYEOK'
'\x07ESCENDO'
'\x05KAPPA'
'\x03VEE'
'\x07UP AND '
'\x03VEN'
'\x0cCHAIR SYMBOL'
'\x0c OR EQUAL TO'
'\x0fBINARY RELATION'
'\x06DOKMAI'
'\x03Q00'
'\x04AILM'
'\x0bCARET TILDE'
'\x050 MAN'
'\x041 QI'
'\x04OUBT'
'\tSSANGSIOS'
'\tHARACTERS'
'\x06PARKLE'
'\tHARACTER '
'\x04SKAL'
'\x05F SOW'
'\x07BAIRKAN'
'\x08OSTROPHE'
'\x07BARLINE'
'\x06ORETTE'
'\x03IP '
'\x05VER S'
'\x04IXTY'
'\x04AH I'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x04IXTH'
'\x03UR-'
'\x08RDEL NAG'
'\x0bBLACK ARROW'
'\x073 AREPA'
'\x03URE'
'\x03URA'
'\x03URL'
'\x03URN'
'\x1cMONOGRAMMOS TESSERA DODEKATA'
'\x03URT'
'\x03URU'
'\rSTERTIUS SIGN'
'\x0e KISIM5 TIMES '
'\x0eUNDER RELATION'
'\x03NSU'
'\x04REE '
'\n-LUE KARAN'
'\x0bENTHESIZED '
'\x03NGA'
'\x04IGMA'
'\x08LA LENGA'
'\x18MALL CIRCLE TO THE RIGHT'
'\x12VARIANT FORM LIMMU'
'\x03SH2'
'\x06DOTTED'
'\x088 KANAKO'
'\nTOM SYMBOL'
'\x03SH '
'\x08SPERSION'
'\x04 ALL'
'\x05THIRD'
'\x04GIBA'
'\nLET SYMBOL'
'\rFULL SURROUND'
'\n TIMES LAL'
'\x18RIGHTWARDS THEN CURVING '
'\x03SHA'
'\x0cBLACK SQUARE'
'\x08PRECEDES'
'\n KABA TENU'
'\x14JUDEO-SPANISH VARIKA'
'\x03NG '
'\x11MALL CIRCLE ABOVE'
'\x03 AN'
'\x03LUS'
'\x03LUB'
'\nHEAVY BEAT'
'\x07CISSORS'
'\x04YIS '
'\x03LUL'
'\x03LUM'
'\x07PTHAHA '
'\x16UBSCRIPT SMALL LETTER '
'\x05SASAK'
'\x06MALL A'
'\x06MALL F'
'\x05WIANG'
'\x06VIRAMA'
'\rARGOSYNTHETON'
'\x05HISTI'
'\x0bPARENTHESIS'
'\x04GEDE'
'\nCISIVENESS'
'\x0e WITH FISHHOOK'
'\x04OTE '
'\x03YA '
'\nRIGINAL OF'
'\x07NIKAHIT'
'\x03KET'
'\x0eWITH DOT BELOW'
'\x051 DWE'
'\x03OT '
'\nGANDA MARK'
'\x04ABIC'
'\x05CECEK'
'\x07OTLESS '
'\x05-ARY '
'\x07ALLOT X'
'\x0bLEFT SINGLE'
'\x04TRIA'
'\x13ASOUL ISOLATED FORM'
'\x01M'
'\x06HESHIG'
'\x0eWORD SEPARATOR'
'\x03OTH'
'\x03OTO'
'\x03OTA'
'\x07THIRDS '
'\x06 SMALL'
'\rSMALL V ABOVE'
'\x05TUUMU'
'\x05EPEAT'
'\x0cLACK DIAMOND'
'\x04IBE '
'\rPREPONDERANCE'
'\x08 PLUS EN'
'\x0fLEVEN FULL STOP'
'\x06ERMATA'
'\x04KEMP'
'\x0bPARALLEL TO'
'\x12LENTICULAR BRAKCET'
'\x13 AND TWO DOTS ABOVE'
'\x1c BETWEEN TWO HORIZONTAL BARS'
'\x042 QO'
'\x08ION SIGN'
'\x08SSESSION'
'\x15LATIN CAPITAL LETTER '
'\x03MZA'
'\x06CIRCLE'
'\x05TTED '
'\x11OINTED BLACK STAR'
'\x13EFT-POINTING ANGLE '
'\x0bSSANGKIYEOK'
'\tXIMATELY '
'\x12WESTERN PWO KAREN '
'\x13 KASKAL U GUNU DISH'
'\x08PALOCHKA'
'\x14 ABOVE SLANTED EQUAL'
'\x05TTORU'
'\x1eOPEN CENTRE EIGHT POINTED STAR'
'\x12 WITH CIRCLE BELOW'
'\x0bRANSMISSION'
'\x06NACLES'
'\x11VEN EIGHTHS BLOCK'
'\x03ZOO'
'\t AND HOOK'
'\x08ALE SIGN'
'\x04WAW '
'\x15VERTICAL LINE OVERLAY'
'\nGREE SLASH'
'\x0eED PARAGRAPHOS'
'\x07DLE DOT'
'\nEONGCHIEUM'
'\x06UZEIRO'
'\t-KHYUD PA'
'\n-HIRAGANA '
'\x05AADHU'
'\x0bETEI MAYEK '
'\x05TACK '
'\x06BELOW '
'\x04GOAL'
'\r OPPOSING KUR'
'\x05NUENG'
'\x05SIGN '
'\x0bNITIAL FORM'
'\x06LAMEDH'
'\x08MON TIME'
'\x0cVERTICAL BAR'
'\tING ABOVE'
'\x08OBOOFILI'
'\rIVE SLOW SIGN'
'\x05XTRA-'
'\t PLUS KU3'
'\x07LETTER '
'\x04UND '
'\tINE BELOW'
'\x13NGLE QUOTATION MARK'
'\x07NUTILLU'
'\x06OCENCE'
'\x05QUILL'
'\x15LESS-THAN OR EQUAL TO'
'\x05INIMA'
'\x03FWA'
'\x02O '
'\x041 SI'
'\x04IFTY'
'\x041 SA'
'\x07OUR OF '
'\tVER LUGAL'
'\x02O0'
'\x07L SEGNO'
'\x06 SIGN '
'\x05GMENT'
'\x06YBOARD'
'\x06BEFILI'
'\x13ND SOUTH WEST ARROW'
'\tIN SQUARE'
'\nOUTER JOIN'
'\x0eGYPTOLOGICAL A'
'\x04GHWA'
'\x15ALATALIZED HOOK BELOW'
'\x13TRICTED LEFT ENTRY-'
'\x070 SPEAR'
'\x16HEXIFORM LONG ANUSVARA'
'\x02OO'
'\x02ON'
'\x02OM'
'\x02OL'
'\x02OK'
'\x13NAXIAN FIVE HUNDRED'
'\x02OH'
'\x02OG'
'\x02OF'
'\x02OE'
'\x04ALES'
'\n RGYA GRAM'
'\x02OY'
'\x03RQA'
'\x02OW'
'\x04ALEF'
'\x02OT'
'\x02OS'
'\x02OR'
'\x02OQ'
'\x02OP'
'\tNIGGAHITA'
'\x04INOR'
'\rGTER TSHEG MA'
'\x04KANG'
'\x03DES'
'\x05GHULU'
'\x08REE MARK'
'\x0cNCK CONSTANT'
'\x08VOLUTION'
'\x03DEK'
'\x06ILLAGE'
'\x03DEE'
'\x19LEFTWARDS ARROW WITH HOOK'
'\x08UP HEAVY'
'\x0eDASIA PNEUMATA'
'\x15RISING DIAGONAL SLASH'
'\x03UP '
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\tDEOGRAPH '
'\x0fPERIAL ARAMAIC '
'\x06LEADER'
'\x04HETH'
'\x04HETA'
'\x0cOID NOTEHEAD'
'\x0fBELGTHOR SYMBOL'
'\x03IVE'
'\x12UNATE SIGMA SYMBOL'
'\x15QUADRANT CIRCULAR ARC'
'\x03DE6'
'\x1cUPWARDS AND RIGHTWARDS ARROW'
'\x19FFICULTY AT THE BEGINNING'
'\x03NEO'
'\x1cUP HEAVY AND LEFT DOWN LIGHT'
'\x03ACE'
'\x053 RA3'
'\x03ACH'
'\x0fQUADRUPLE DASH '
'\nLGIZ EOLHX'
'\x06INKING'
'\x03ACT'
'\x0cRIANGLE DOWN'
'\x04RING'
'\x03NER'
'\x11ABBREVIATION SIGN'
' ETALLED BLACK AND WHITE FLORETTE'
'\tMALL RING'
'\x0fTILDE DIAERESIS'
'\x03K00'
'\x07PENGKAL'
'\x04QUAD'
'\x05VZMET'
'\x19RIGHT DIAGONAL HALF BLACK'
'\x03SJE'
'\x17HANKED RIGHTWARDS ARROW'
'\x04HIRD'
'\x07RTHIAN '
'\x03MEM'
'\x06WITH T'
'\x03MEN'
'\nINAL SIGMA'
'\x03NE '
'\x04RIN2'
'\x04HIRT'
'\x064 DEER'
'\x0eMOTHETIC ABOVE'
'\x05ANGLE'
'\x0cRCHAIC SAMPI'
'\x07EL PUMP'
'\x05ENENG'
'\x06TIKENO'
'\x07ZQAPHA '
'\tYEH ABOVE'
'\x08OT ABOVE'
'\x06APISMA'
'\tLINE FEED'
'\x043 MU'
'\x04HSDA'
'\x043 ME'
'\x03EZH'
'\x03EZI'
'\x0bSHEQEL SIGN'
'\x1cEFT ARC GREATER-THAN BRACKET'
'\nENETRATION'
'\x05ORNER'
'\n WITH HOOK'
'\x15INTERSECTION OPERATOR'
'\x0bAGAZ DAEG D'
'\x04CWAA'
'\x0eVARIANT FORM A'
'\tLEFT HOOK'
'\x04MONO'
'\x04ABOR'
'\x0bROKUTASTI A'
'\x04ARB '
'\x0cUP ARROWHEAD'
'\x06RGLASS'
'\x05CREEN'
'\x04MON '
'\x08NEIFORM '
'\x05LEFT '
'\x05A-ROL'
'\x0fQUADRUPLE ARROW'
'\x07PHUTHAO'
'\x08NG RTAGS'
'\x07 TEDUNG'
'\x0cNUMERAL SIGN'
'\x03OVE'
'\x06TO BAR'
'\x11TAN ISOLATED FORM'
'\x03D70'
'\x07BOTTOM '
'\x05VRIDO'
'\x06MEDIUM'
'\x07APYEOUN'
'\x04 OF '
'\x04QOPH'
'\x0fOGOGRAM KHAMTI '
'\rW RING INSIDE'
'\x06EQUAL '
'\x07IRGHIZ '
'\x06NOR BU'
'\nMONOSPACE '
'\x06EQUALS'
'\x14DOTLESS HEAD OF KHAH'
'\x042 WO'
'\tYRANISMA '
'\x08ATAKANA '
'\x0cYOUTHFULNESS'
'\nLOWER HOOK'
'\nCROPHONIC '
'\x05HEART'
'\x03DUG'
'\x05POINT'
'\x06KASKAL'
'\x02YA'
'\x04NCEL'
'\x04AMLA'
'\x10RST QUARTER MOON'
'\rGYA GRAM SHAD'
'\x07RESILLO'
'\x10FALLING DIAGONAL'
'\x12 THROUGH DESCENDER'
'\x08THAMASAT'
'\x14SINGLE DOT TONE MARK'
'\x08 STATERS'
'\x05LABAT'
'\x08LUB SUIT'
'\x06VILIAN'
'\x06DERMA '
'\x05BASA '
'\x10PLE MEASURE REST'
'\x02YR'
'\x13ANTICLOCKWISE ARROW'
'\x0fNOON FINAL FORM'
'\x0fWITH RAIN DROPS'
'\x19STROKE AND TWO DOTS ABOVE'
'\x05 CLEF'
'\tAND ACUTE'
'\x04OMBU'
'\x01Q'
'\x0fR WITH FISHHOOK'
'\x11AEUM ONE PLETHRON'
'\x04USA '
'\x06SWORDS'
'\x10TELOUS ICHIMATOS'
'\rUSHING UPWARD'
'\nEARLY FORM'
'\x06HIEUKH'
'\x12MINAL DIGIT SHAPES'
'\t ARCHAION'
'\x04MMA '
'\rARLAUG SYMBOL'
'\x08TISMOS E'
'\x04SHE3'
'\x13TART OF RUB EL HIZB'
'\x17ININE ORDINAL INDICATOR'
'\x08GRAPH UK'
'\x15 AND SLANTED PARALLEL'
'\x04SHEI'
'\x11Y ON BLACK SQUARE'
'\x0cMALL LETTER '
'\x03VIN'
'\x03VIR'
'\x03VIS'
'\x08ART SUIT'
'\x04STAR'
'\rUPONDIUS SIGN'
'\x0fHALF FILL SPACE'
'\x04FOUR'
'\x0fPLUS SIGN BELOW'
'+UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'$LEFT TORTOISE SHELL BRACKET ORNAMENT'
'\x06ROBANG'
'\x05UDAAT'
'\nAELA-PILLA'
'\x0bCROSSING EN'
'\x05AGGER'
'\x17BALLOON-SPOKED ASTERISK'
'\x0fRNAMENT STROKE-'
'\x0fLIGHT AND LEFT '
'\tSPIRITUS '
'\nETTA-PILLA'
'\x08TAI LUE '
'\x06FF OF '
'\x05TIGMA'
'\x03IT '
'\x04KAPA'
'\x10ENTRE WHITE STAR'
'\x04KAPH'
'\x08SIFISTON'
'\x05ZENGE'
'\x0fRIANGULAR COLON'
'\tBACKSLASH'
'\x0eTWO DOT LEADER'
'\x06CHAMKO'
'\x06HE MGO'
'\x08 OTTAVA '
'\x1aRIGHT PARENTHESIS ORNAMENT'
'\x03UNT'
'\x06EDIAL '
'\x03UNG'
'\x0bTHREE TIMES'
'\x04HERU'
'\x0bPARAKALESMA'
'\x0fAND FEMALE SIGN'
'\x03ITE'
'\x03ITA'
'\x03OMU'
'\x03ITY'
'\x03ITU'
'\x16USTOMER ACCOUNT NUMBER'
'\x03AAF'
'\x08TRIANGLE'
'\x03AAN'
'\x07NTICAL '
'\x040 KO'
'\x07DIGAMMA'
'\x03BIN'
'\x07HOUSAND'
'\x06NTEVMA'
'\x03BIE'
'\x03BIB'
'\x05FIFTY'
'\rARCHAIC KOPPA'
'\x15BESIDE RIGHT TRIANGLE'
'\x14OVER LEFTWARDS ARROW'
'\x05FIFTH'
'\x0cTICLOCKWISE '
'\x08ELEPHONE'
'\x04TIP '
'\x05PEN-P'
'\x0e-CURRENCY SIGN'
'\x0bNITIAL IZHE'
'\x0eITA PLUS GISH '
'\x0fRIGHTWARDS TICK'
'\x07F WITH '
'\x11ASTERN PWO KAREN '
'\x11GENERIC MATERIALS'
'\x05LINE '
'\x03EXT'
'\rHAM DIGIT ONE'
'\rJES SU NGA RO'
'\x06 DIPLI'
'\x08FRAKTUR '
'\x04 OR '
'\x0eBLACK TRIANGLE'
'\x0eWITH DOT ABOVE'
'\x0eCOLON OPERATOR'
'\rSTABLE SYMBOL'
'\x03KIN'
'\x05DASIA'
'\x0cATNAH HAFUKH'
'\x05CECAK'
'\x02PR'
'\x02PP'
'\x02PV'
'\x02PU'
'\x02PY'
'\x0fLEFTWARDS ARROW'
'\x06AILURE'
'\tALPAPRANA'
'\x04NINE'
'\x04NING'
'\x02PE'
'\tFISH TAIL'
'\x02PH'
'\x02PI'
'\x04EHEH'
'\rSYNDESMOS NEO'
'\x02PM'
'\x0bQUARE BELOW'
'\x02P0'
'\x06BOWTIE'
'\x02P '
'\x07IGHTEEN'
'\x05 LEFT'
'\x10UPERSCRIPT ALAPH'
'\x06TAUROS'
'\x03CR '
'\x03OPO'
'\x05 FACE'
'\x08FROM BAR'
'\x17YELORUSSIAN-UKRAINIAN I'
'\x05MARK '
'\x04ANDA'
'\x12KANTAJA NAASIKYAYA'
'\x04HAYN'
'\x04AND '
'\x08MOTHETIC'
'\tLIVERANCE'
'\x06HIBIT '
'\x07BSET OF'
'\x18CONSECUTIVE EQUALS SIGNS'
'\x04RT T'
'\x07LYGISMA'
'\n AND BREVE'
'\x0cBSCRIPT ALEF'
'\x04AMBA'
'\x04RUDA'
'\x08UAREG YA'
'\x0fOUBLE BACKSLASH'
'\tPAA-PILLA'
'\x0eREH FINAL FORM'
'\x08BUNDANCE'
'\x0bHAGGAR YAZH'
'\x1aHTORA SKLIRON CHROMA VASIS'
'\x0eREATIVE HEAVEN'
'\x04DEAD'
'\x05LABOR'
'\x05JERVI'
'\x07GI GUNU'
'\x07MUNGKAH'
'\x0cHYPHEN-MINUS'
'\x0cREFACE COLON'
'\x17INUOUS UNDERLINE SYMBOL'
'\x04OPPA'
'\x05NIEUN'
'\x05METEG'
'\x0eOT PUNCTUATION'
'\x05HESS '
'\x03XAN'
'\x04ROSH'
'\x0cNGRATULATION'
'\x06CHRIVI'
'\tS DIGRAPH'
'\x05JUDGE'
'\x06NAUD N'
'\x040 PU'
'\x08GINAL OF'
'\x0cTRIPLE DASH '
'\x1aU REVERSED OVER U REVERSED'
'\x06RSHANA'
'\x04BER '
'\x08QAIRTHRA'
'\x0bGLE BRACKET'
'\x08SIGN LAE'
'\t-STACCATO'
'\x04BERD'
"'ASH FROM LEFT MEMBER OF DOUBLE VERTICAL"
'\x08U PLUS U'
'\x0f OVER SIG4 SHU2'
'\tSEMICOLON'
'\x08ARCHAION'
'\nAVE ACCENT'
'\tGITTARIUS'
'\x03VOU'
'\x03VOW'
'\x0eRETROFLEX HOOK'
'\nLINE BELOW'
'\x04ALAF'
'\x04ALAG'
'\x04ALAI'
'\x04STOP'
'\x04ELTA'
'\nDOWN HEAVY'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x06ALTIRE'
'\x0cEN FULL STOP'
'\x03O B'
'\x03O N'
'\x18LINE HORIZONTAL ELLIPSIS'
'!RIGHTWARDS HARPOON WITH BARB DOWN'
'\x03O Y'
'\x04MINI'
'\x0cENOS CHRONOU'
'\x07TA MARK'
'\x08AF WITH '
'\x05VIET '
'\x04MING'
'\x05CUBED'
'\x15NSVERSAL INTERSECTION'
'\tELLOWSHIP'
'\x05DENCE'
'\x0cOPENING LEFT'
'\x05ISTLE'
'\x0eDOUBLE-STRUCK '
'\x11UNION WITH SERIFS'
'\x03CIG'
'\x05AUTHS'
'\x08INTEGRAL'
'\x04KARA'
'\x04-UM '
'\x08AHAPRANA'
'\x0eOOTNOTE MARKER'
'\x05PTUNE'
'\x05SENTO'
'\x03DAA'
'\x08YENISEI '
'\x0eTWO DOTS ABOVE'
'\x03DAP'
'\x03DAR'
'\x03UL '
'\x10NT SCREEN SYMBOL'
'\x04ZIET'
'\x03DA '
'\x06STANCE'
'\x0bCROSSING GI'
'\x07SS-THAN'
'\x03ULU'
'\x04JEON'
'\x0bRISING DOTS'
'\x01U'
'\x05FLAKE'
'\x03ULL'
'\x06STANCY'
'\x18AND MALE AND FEMALE SIGN'
'\x03OOD'
'\x03OOF'
'\x06INSIDE'
'\x03OON'
'\n LATE FORM'
'\x03OOU'
'\x03OOT'
'\x10RAIDO RAD REID R'
'\x07 FLEXUS'
'\x03AGL'
'\x12ON-SPOKED ASTERISK'
'\x040 MA'
'\x03NYO'
'\x08ENT SIGN'
'\rTROKE OVERLAY'
'\x04MEGA'
'\x07IMILAR '
'\nUP HARPOON'
'\x07D WITH '
'\x045 TO'
'\x03BWA'
'\x05ENTRE'
'\x02-I'
'\x07RD SIGN'
'\x04TIN '
'\x11WITH NOT EQUAL TO'
'\x03MAP'
'\x03AG-'
'\x03MAR'
'\x05WENTY'
'\x04HIVE'
'\x04HILD'
'\x07LOZENGE'
'\tANTHAKHAT'
'\x03MAN'
'\x07D MOUTH'
'\x07WIGNYAN'
'\x043 A3'
'\x03EVE'
'\x0fST QUARTER MOON'
'\x06EYANNA'
'\x14 WITH HORIZONTAL BAR'
'\tORTH WIND'
'\x05WLINE'
'\x0bASE TO THE '
'\x06E WAVE'
'\x07AMAKKAN'
'\x07GE SIGN'
'\x0fSTERESIS SYMBOL'
'\x06P TACK'
'\x08MALL YUS'
'+LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x16IN DEPARTING TONE MARK'
'\x057 TWE'
'\x05UNDER'
'\x16PUNCTUATION KUNDDALIYA'
'\x0c SKEWED LEFT'
'\x04HSHU'
'\x05AXIMA'
'\x08UNDERBAR'
'\x03OR '
'\x17ALGAMATION OR COPRODUCT'
'\x0fLONG VOWEL SIGN'
'\nFTOGGOS OU'
'\tIALECT-P '
'\nCTORY HAND'
'\x0eY SMALL SQUARE'
'\x0f PLUS HI PLUS A'
'\x12ANS-SERIF CAPITAL '
'\n2 PLASTICS'
'\x03FHA'
'\x0fDIGA AELA-PILLA'
'\x07MAGE OF'
'\x12FORKED PARAGRAPHOS'
' SEMICIRCULAR ANTICLOCKWISE ARROW'
'\x04EVEN'
'\x0fESSARON CHRONON'
'\tINISHMENT'
'\x11MEEM INITIAL FORM'
'\x03ORN'
'\x03ORI'
'\x06GEADAL'
'\x03557'
'\x10 SOLIDUS OVERLAY'
'\x0bECTION MARK'
'\rWAW-AYIN-RESH'
'\x07NE DOT '
'\x05BOVE '
'\x038 I'
'\x038 A'
'\x038 E'
'\x11BERBER ACADEMY YA'
'\x04KWAA'
'\rARROW OVERLAY'
'\nME PLUS EN'
'\nTRETCHED C'
'\x0cCROSSING LU2'
'\x0b PROPORTION'
'\x04ZAYN'
'\x12CANTILLATION SIGN '
'\x04UTER'
'\x05HEAVY'
'\nROEZENIAN '
'\x0eVERTICAL LIGHT'
'\x10DEWAYS U BRACKET'
'\x04EGOL'
'\nEICH STARK'
'\x03L00'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RMUKHI '
'\x04LOW '
'\x17SING DIAGONAL CROSSING '
'\x05RIEUL'
'\x05HORSE'
'\x0b OVER BULUG'
'\x08SUCCEEDS'
'\x065 MERI'
'\x06W LINE'
'\x0f AND LOWER LEFT'
'\x0bMALL SQUARE'
'\x0bESTION MARK'
'\x0eFEHU FEOH FE F'
'\x05SHARA'
'\x05ESIS '
'\rWITH UNDERBAR'
'\x19 WITH DOUBLE GRAVE ACCENT'
'\x05SHARP'
'\x05SHARU'
"'USED AS KORANIC STOP SIGN ISOLATED FORM"
'\x04JERV'
'\x17DOWNWARDS THEN CURVING '
'\x07SUKUUDO'
'\x03I-I'
'\x04CRET'
'\rCIRCLE INSIDE'
'\x05IMES '
'\x0eALLAJALALOUHOU'
'\x06NE OF '
'\x08TTENTION'
'\x040 RA'
'\x04UNNY'
'\x05 TAIL'
'\x15GHT OPEN BOX OPERATOR'
'\x17SOLIDUS BINARY RELATION'
'\x0f CLOUD AND RAIN'
'\nERO WIDTH '
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x05 WITH'
'\x08EVENTEEN'
'\x01B'
'\x0bBANK SYMBOL'
'\x08OUR DOTS'
'\x04BETA'
'\x04BETH'
'\x03TUR'
'\x0bGRAVE-ACUTE'
'\x04RAMA'
'\x06YAKASH'
'\x17 WITH CIRCUMFLEX ACCENT'
'\x04DIC '
'\nFOUR BELOW'
'\x11YEH ISOLATED FORM'
'\x04UBED'
'\x04ELVE'
'\x08FEBRUARY'
'\x0fEFT REPEAT SIGN'
'\x06GORGON'
'\x04IKRI'
'\x04OLAM'
'\x06GO NGU'
'\x04MIL '
'\nPRALINEAR '
'\n-SHAPED HA'
'\tRUM CLEF-'
'\x06NSUZ A'
'\x08EFT HOOK'
'\x0cEQUAL TO OR '
'\x0eUNION OPERATOR'
'\x06RSIAN '
'\x02QU'
'\x0bYRIGHT SIGN'
'\x02QA'
'\x02QN'
'\x05GONEK'
'\x03B89'
'\x1bDOUBLE ANGLE QUOTATION MARK'
'\x14WITH FOUR DOTS ABOVE'
'\x0cPOETRY MARK-'
'\tPENTASEME'
'\x04KATO'
'\x04NUNG'
'\x03HUK'
'\x06CIMAL '
'\x07HEADING'
'\x0856 TURO2'
'\x10BBREVIATION SIGN'
'\x04PERS'
'\x08S INSIDE'
'\x04PER '
'\x0fFTER COMPLETION'
'\x0fVOWEL SHORTENER'
'\x0bKTIESELSKAB'
'\x0bCROSSING IM'
'\x05JOKER'
'\x03UJA'
'\x13INDEPENDENT SVARITA'
'\x03OIN'
'\x12HORIZONTALLY BELOW'
'\x06GICAL '
'\x0eBLADE SCISSORS'
'\x03IHI'
'\x03OIX'
'\x07ILLEANN'
'\x14RIGHT ANGLE WITH DOT'
'\x03GBA'
'\rOGOTYPE SIGN '
'\x03AEF'
'\t1 CHARIOT'
'\x07HUNDRED'
'\x03AEM'
'\x04MEEM'
'\x03BUR'
'\x0bMOVED BELOW'
'\tZIDA TENU'
'\x03BUT'
'\x07 PLOPHU'
'\x05MADYA'
'\x08IALYTIKA'
'\x05HIFT '
'\x03BU '
'\x13THANG LONG ANUSVARA'
'\x06PALUTA'
'\nNUMERATOR '
'\x08APITAL L'
'\x05BIRGA'
'\x08ANUSVARA'
'\x03MOI'
'\x03MOO'
'\x14DOUBLE DOT TONE MARK'
'\x03 IN'
'\x07IVE OF '
'\x0bTHAM DIGIT '
'\x07WAZ EOH'
'\x04FFIN'
'\x05RAIDA'
'\x18SINGLE-LINE NOT EQUAL TO'
'\tCANG TE-U'
'\x03ETA'
'\x11AMBDA WITH STROKE'
'\x03ETH'
'\nHOOK ABOVE'
'\x046 NA'
'\x08IGATURE '
'\nLIMITATION'
'\x04LLET'
'\rHALF INTEGRAL'
'\tGREATER Y'
'\x0bCAN RGYINGS'
'\rRRIAGE SYMBOL'
'\x06LIGON '
'\rWITH INTEGRAL'
'\x0f THROUGH CIRCLE'
'\x065 WOOL'
'\x06SEBALL'
'\rQUARTER BLOCK'
'\x03ET '
'\x08UP ARROW'
'\x15EFT OPEN BOX OPERATOR'
'\x05FLICT'
'\x0cTRIPLE DANDA'
'\x044 NE'
'\x0fST SYRIAC CROSS'
'\x16SEMI-VOICED SOUND MARK'
'\x1aIDEOGRAPHIC ITERATION MARK'
'\tHI SYMBOL'
'\x01Y'
'\x0bI TIMES NUN'
'\x0fND OF PARAGRAPH'
'\x0cEATH PRODUCT'
'\x06INAGMA'
'\x0bTURN SYMBOL'
'\x11IDEOGRAPHIC COMMA'
'\x11SQUARED TIMES KUR'
'\x07UT TIME'
'\x05MINUS'
'\x0bRPOON ABOVE'
'\x07TTHACAN'
'\x08TIMORION'
'\x0eLACE OF SAJDAH'
'\x0fU PLUS U PLUS U'
'\rROW POINTING '
'\x0cBINING MARK '
'\x0c WITH DAGESH'
'\x15DELIMITER TSHEG BSTAR'
'\n OF DHARMA'
'\x04AGON'
'\x04SEYE'
'\x02S '
'\x06STOLI '
'\x030B9'
'\x1bBRDA RNYING YIG MGO MDUN MA'
'\x05OMIKO'
'\x04DAIR'
'\x16OVER SHIR BUR OVER BUR'
'\x05MEPET'
'\rNAP PIZZICATO'
'\x05PTIVE'
'\x17QUOTATION MARK ORNAMENT'
'\x06RENGTH'
'\x12AYHE ISOLATED FORM'
'\x07ITON RA'
'\x05FEARN'
'\x06PLOPHU'
'\x0cNGLE BRACKET'
'\x049 SE'
'\x04GAML'
'\x04REPA'
'\x0fUBLE RING BELOW'
'\x0ePAO KAREN TONE'
'\x08NOT SIGN'
'\nOUND OMEGA'
'\x07EIGHTHS'
'\x07WN TACK'
'\x08REATNESS'
'\x11LAH ISOLATED FORM'
'\x06 HANDS'
'\x06KLITON'
'\rI WITH STROKE'
'\x08SHKIR KA'
'\x06RRIER '
'\x04EST '
'\x0cS SUBPUNCTIS'
'\x03XEH'
'\x0fKISIM5 TIMES BI'
'\x08COUNCIL '
'\x03TWA'
'\tWITH DOT '
'\x05PSILI'
'\x0cNNED LEATHER'
'\x03TWO'
'\x06 WITH '
'\x11-GAAHLAA TTUDDAAG'
'\x07ACCENT '
'\x0bIBLE-CREE Y'
'\x07S ICHOS'
'\x0bYAJURVEDIC '
'\x11WHITE SHOGI PIECE'
'\x05ALLEY'
'\x07OUT HUB'
'\x14SEPARATOR MIDDLE DOT'
'\tVERTICAL '
'\x05INTHU'
'\x07SQUARED'
'\x06BOFILI'
'\x08N-JOINER'
'\x08YLLABLE '
'!DIRECT PRODUCT WITH BOTTOM CLOSED'
'\x0c-BREAK SPACE'
'\x0cSIGMA SYMBOL'
'"PPROXIMATELY NOR ACTUALLY EQUAL TO'
'\x16RROW WITH ROUNDED HEAD'
'\x10RISING TONE MARK'
'\x11ME PLUS GAN2 TENU'
'\x0bARGE SQUARE'
'\x03EOW'
'\x0c-SIMPLIFIED '
'\x08GARITIC '
'\x041 KU'
'\x0cMONOGRAPH UK'
'\rKAPYEOUNPIEUP'
'\nHREE ABOVE'
'\x15NTISTRY SYMBOL LIGHT '
'\nTRESS AND '
'" TWO DOTS OVER ONE DOT PUNCTUATION'
'\x06DICINE'
'\x05LEASE'
'\x08IAGONAL '
'\x04TEN '
'\x03IN2'
'\x06IAMOND'
'\x04NDA2'
'\x06YIN-DO'
'\x05DOWN '
'\x08 OVER SU'
'\x02ST'
'\x03IN '
'\x05INTER'
'\x04INGU'
'\x04-ONE'
'\tOVER MUSH'
'\x05ENUTO'
'\rPINWHEEL STAR'
'\x07AHAPAKH'
'\x03INU'
'\nHALF BLACK'
'\x03INS'
'\x06CRIPT '
'\x0bHEAVEN MARK'
'\x03INI'
'\x03439'
'\x03IND'
'\x03INE'
'\x03ING'
'\x04TENU'
'\x04TENT'
'\x0cDIGRAPH YORI'
'\x04ORII'
'\x03AKE'
'\x05AAMAE'
'\x05RCHID'
'\x0cSECTION MARK'
'\x0bM TIMES SHE'
'\x08 PLUS RA'
'\t PLUS TUR'
'\x0cHI TIMES BAD'
'\x14AND NORTH WEST ARROW'
'\x08 PLUS RU'
'\x04SCES'
'\x0cNE HALF SIGN'
'\x05ERTIE'
'\x01F'
'\x04UGU '
'\x04AHAD'
'\x03MMA'
'\x03ERU'
'\tE TSA CAN'
'\x03KOO'
'\x03KON'
'\x0fRIGHT RERENGGAN'
'\x0bIDDLE TILDE'
'\nLOWER HALF'
'\nATAKANA DE'
'\x0fHREE DOTS BELOW'
'\tEEN WITH '
'\x03KOT'
'\x07MENT OF'
'\rYOD YOD PATAH'
'\x0bROSS ACCENT'
'\x04MWAA'
'\x05TINNE'
'\x07NUSVARA'
'\x0eEPENTHETIC YUT'
'\x0eIVE KEY SYMBOL'
'\x048 QE'
'\n2 PLUS GAL'
'\x0f ALTERNATE FORM'
'\x11PARTING TONE MARK'
'\x04OONU'
'\x04IEUC'
'\tFLAT SIGN'
'\x03ER '
'\x06TIMES '
'\x04IEUP'
'\x044 WA'
'\rCHRYSANTHEMUM'
'\nLEFT LIGHT'
'\x08ARSI YEH'
'\x02RT'
'\x02RU'
'\x02RV'
'\x02RR'
'\x02RY'
'\tQUSHSHAYA'
'\x02RE'
'\x02RA'
'\x02RN'
'\x02RO'
'\x02RI'
'\x02RK'
'\x02R7'
'\x02R0'
'\x02R2'
'\nSWASH TAIL'
'\tOVER GAN2'
'\x04NAAU'
'\x02R '
'\x04OND '
'\x05IPEHA'
'\x0cEIGHTH NOTES'
'\x1eQAF WITH LAM WITH ALEF MAKSURA'
'\x05TRAIF'
'\x0bEAVER DENE '
'\x04KICK'
'\x07UPWARDS'
'\x15-SHAPED BAG DELIMITER'
'\x073 SWORD'
'\x0cTE SEPARATOR'
'\x05 AMPS'
'\rOURTH SUBUNIT'
'\tPPOSITION'
'\x0f TIMES IGI GUNU'
'\x1bDOUBLE PRIME QUOTATION MARK'
'\nAEDA-PILLA'
'\nTELEGRAPH '
'\x05 LACA'
'\x05 ALLO'
'\x0bARPEGGIATO '
'\x07ATURAL '
'\x13VERSE FINAL BARLINE'
'\x19OVER TWO DOTS PUNCTUATION'
'\x0bROR-BARRED '
'\x07RDO RJE'
'\nRING ABOVE'
'\x08EK ONKAR'
'\x07 CHIKI '
'\x07MAI SAT'
'\n SEPARATOR'
'\x07XT PAGE'
'\x07HALANTA'
'\x03620'
'\x07THUNDER'
'\x0fIDING ENCLOSURE'
'\x07RARIETY'
'\x0eOSITION SYMBOL'
'\nTACK BELOW'
'\x14CURVED ANGLE BRACKET'
'\x039E3'
'\x07PRESENT'
'\tYEAR SIGN'
'\x15WITH THREE DOTS ABOVE'
'\x10IRCUMFLEX ACCENT'
'\x0eRK NOON GHUNNA'
'3LANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL'
'\x04ATTO'
'\x14AND NORTH EAST ARROW'
'\x05HALA '
'\x03DEG'
'\x03ZEN'
'\nLEFT-HAND '
'\x03ZER'
'\x0e-STEM TONE BAR'
'\x05URDA '
'\nOBOLS SIGN'
'\x10XCLAMATION MARK '
'\x07LOTTAL '
'\x03YWA'
'\x05WINJA'
'\x12EPIGRAPHIC LETTER '
'\x06CHO CH'
'\x07VERSED '
'\x08QUESTION'
'\x0bDIATONON DI'
'\nPENDICULAR'
'\x0bCROSSING PI'
'\nUPPER HOOK'
'\x06GHAMAL'
'\x04AMDA'
'\nIXTHS DISH'
'\x05ESO E'
'\x08OVER GA2'
'\x07DANESE '
'\x03C A'
'\x06 BLOCK'
'\x05IANCE'
'\x06VELOPE'
'\x11VEE WITH UNDERBAR'
'\x03HSA'
'\x04ITLO'
'\x04OMAN'
'\x03MIN'
'\x07ORKHON '
'\x02PA'
'\x05LEVEN'
'\x0f POINTING INDEX'
'\tGAN2 TENU'
'\x04IARA'
'\tEMPTY SET'
'\x07DRACHMA'
'\x05TSHEG'
'\nSBUB -CHAL'
'\rVICE CONTROL '
'\rAR WITH QUILL'
'\x06ISELEH'
'\x04PPER'
'\x05 ILUT'
'\x07SOLIDUS'
'\x0cROUNDED ZERO'
'\x0fMUSICAL SYMBOL '
'\t FORM TWO'
'\x08PAVIYANI'
'\x03EMK'
'\x0cWITH STROKE '
'\x0cDOT OPERATOR'
'\x03RGE'
'\x03RGO'
'\x04ROOK'
'\x03LDE'
'\x14A- SHOG GI MGO RGYAN'
'\x013'
'\x0bEKFONITIKON'
'\x061 WINE'
'\x15ER RIGHT CORNER ANGLE'
'\x03LD '
'\x0eLUS SIGN BELOW'
'\tFINAL MEM'
'\x05LTIRE'
'\x16LOW PARAPHRASE BRACKET'
'\x0bESMILO SIGN'
'\x04GESH'
'\x04ULTI'
'\x04WIND'
'\x03ILE'
'\x08DANTAJA '
'\x03ILK'
'\x03PEH'
'\x05-BEAM'
'\x03PEE'
'\x03OE '
'\x03COM'
'\x03COO'
'\x08YBEYFILI'
'\x05BOLD '
'\tM HE-GOAT'
'\x05TERIS'
'\x07KUTAARU'
'\x04INES'
'\x06DAGESH'
'\tHWAZ EH E'
'\x07OVERLAY'
'\x11WHITE PARENTHESIS'
'\x04SUIT'
'\x10DOUBLE TURNSTILE'
'\x04PEN '
'\x06CKNESS'
'\x034-0'
'\x0eEFT HALF BLACK'
'\x03OEH'
'\x05ALEPH'
'\x11CROSS PUNCTUATION'
'\x16KEEPING STILL MOUNTAIN'
'\x13OW-9 QUOTATION MARK'
'\x03MKA'
'\x04XEIA'
'\x03AIL'
'\x03AIN'
'\x0cKANA REPEAT '
'\x0fE OVER INFINITY'
'\x03GNO'
'\x05IPING'
'\x04MEAR'
'\x06EMPUS '
'\x0eORD SEPARATOR '
'\x07UPSILON'
'\x07ANGULAR'
'\x04ITSA'
'\x08ARKLEAN '
'\x0e AND DIAERESIS'
'\x08BOL SIGN'
'\tSYLLABLE '
'\tLLABLE B0'
'\x13RIGHT TO LOWER LEFT'
'\x03EPH'
'\x0bATION POINT'
'\x046 JE'
'\x06GANGIA'
'\x08GREAT SA'
'\x046 JO'
'\x0cURLY BRACKET'
'\nADDA WITH '
'\x16 OVER GAD GAR OVER GAR'
'\x05TTOCK'
'\x0cBYSMAL WATER'
'\x1bHARPOON WITH BARB DOWNWARDS'
'\t5 CYPERUS'
'\x08AVAGRAHA'
'\x03LY '
'\x0bINTO SHRINE'
'\x0cINTERSECTION'
'\x08IRD MARK'
'\x08 RASWADI'
'\x08OVER ASH'
'\x048 SU'
'\n WITH TAIL'
'\x14 WITH RETROFLEX HOOK'
'\x06CCEEDS'
'\x16DRESSED TO THE SUBJECT'
'\x04IPOD'
'\nNANGMONTHO'
'\x06UNATE '
'\x0fAMOUNT OF CHECK'
'\x06FILLER'
'\x05COLON'
'\x08YIDDISH '
'\nSH PRODUCT'
'\x11APLI DYO DODEKATA'
'\x05IMMA '
'\nANGKHANKHU'
'\x07HANGUL '
'\x0cNOT EQUAL TO'
'\x11 LAGAB TIMES ASH2'
'\x06IRTEEN'
'\x05OTERI'
'\tOKOUFISMA'
'\x04SILI'
'\x06PSILON'
'\x07ASUTORU'
'\x13PARAGRAPH SEPARATOR'
'\x06THIRD '
'\x032DD'
'\x11VARIANT FORM USSU'
'\tBO GYFU G'
'\rHAKASSIAN CHE'
'\x0b PLUS NUNUZ'
'\x07NUMBER '
'\x01J'
'\nOPEN SHELF'
'\x05 MARK'
'\n NOTEHEAD '
'\x06THIRDS'
'\x0fGROUP SEPARATOR'
'\x08DS-CREE '
'\x05RICEM'
'\x05HAH I'
'\x04SEEN'
'\nADAK BINDI'
'\x10UP-OUTPUT SYMBOL'
'\rFOREMENTIONED'
'\nPEDAL MARK'
'\x0fNORMAL SUBGROUP'
'\nSPACE MARK'
'\nSCAN LINE-'
'\x10R PLUS GAN2 TENU'
'\x0eYEH FINAL FORM'
'\nU3 PLUS AN'
'\x04FIRE'
'\x0cPHEME JOINER'
'\x05GOGI '
'\x07HROUGH '
'\x07MAKSURA'
'\x033-0'
'\x12UP ARROWHEAD BELOW'
'\x05FISTO'
'\tON GROUND'
'\x11VRE TOURNOIS SIGN'
'\x02-A'
'\x02-O'
'\x06CARIK '
'\x03YUT'
'\x02-U'
'\x02-W'
'\x04GAIN'
'\x05VOICE'
'\x04NGLE'
'\x01 '
'\x04EKAA'
'\x05FORCE'
'\x04WULU'
'\nACE SYMBOL'
'\x14THROUGH SMALL CIRCLE'
'\x11BLACK SHOGI PIECE'
'\x11UP AND HORIZONTAL'
'\x08ABAAFILI'
'\rINVERTED FORK'
'\x14ANGE ANTIRESTRICTION'
'\x06XO NEO'
'\x16SHORT VERTICAL STROKES'
'\x08TINGUISH'
'\x12NITE PART INTEGRAL'
'\x07RA REPA'
'\x02-0'
'\x02-2'
'\tINSULAR G'
'\x05DANDA'
'\x07GAYANNA'
'\x03GUD'
'\x05ILLU '
'\x11BRACKET EXTENSION'
'\x05NOTCH'
'\x0eVRON SNOWFLAKE'
'\x07 PLUS A'
'\x0fLETTER CAPITAL '
'\x03HUR'
'\x05RCURY'
'\x08EVEN OF '
'\x06ASHGAB'
'\x06EN GHE'
'\x07YANMAR '
'\x11HORIZONTAL SINGLE'
'\x04GISH'
'\x05ALLI '
'\x08ATHERING'
'\x16NOT INCLUDING THE POLE'
'#RIGHT-POINTING ANGLE QUOTATION MARK'
'\x0b-LINE STAFF'
'\tCROSSING '
'\rBACKSLASH BAR'
'\x03RES'
'\x05LOURE'
'\x02S0'
'\tAPUN IYEK'
'\x08WN ARROW'
'\x03REH'
'\x08ULA SIGN'
'\x11MANENT PAPER SIGN'
'\x11RIGHTWARDS ARROWS'
'\x03REE'
'\x03LFA'
'\x04LEFT'
'\x03LF '
'\x04LEF '
'\x07AVIYANI'
'\x02SY'
'\x08ACKSPACE'
'\x08VESSEL B'
'\x05FENCE'
'\x04HOOK'
'\x02SS'
'\x02SU'
'\x03EK '
'\x03QUA'
'\x02SI'
'\x02SH'
'\x02SO'
'\x03QUF'
'\x02SA'
'\x02SE'
'\x0eAROUND-PROFILE'
'\rBOTTOM CORNER'
'\x03CAL'
'\x05SIXTH'
'\x0bLOTI NAGRI '
'\x0bXESTES SIGN'
'\x04ASIA'
'\x1bDGE-TAILED RIGHTWARDS ARROW'
'\x06ARSEOS'
'\x06METRIC'
'\x08PAIRTHRA'
'\x03CA9'
'\x03UDY'
'\x0fCIRCUIT-OUTPUT '
'\x03OGH'
'\t5 BATHTUB'
'\x05BISAH'
'\x10EVERSED VISARGA '
'\x03GHT'
'\x03GAT'
'\x03MIM'
'\x0cZIGZAG ARROW'
'\x03 OF'
'\x03GHE'
'\x06TRAPLI'
'\x03GHA'
'\x07LEK TOO'
'\x03MIT'
'\x07FLUENCE'
'\tMAHAPRANA'
'\x18LY-RECYCLED PAPER SYMBOL'
'\x03VAV'
'\x0cEAGULL BELOW'
'\x05CHECK'
'\x07SIGN PA'
'\x08BOL FOR '
'\x05 HAA '
'\nPLUS NAGA '
'\x04GRU '
'\x05TONE '
'\x05TONE-'
'\x03MI '
'\rGAW KAREN SHA'
'\x03GAB'
'\x0cETRETES SIGN'
'\x05IKARA'
'\x07HI SIGN'
'\x0fUSTER NOTEHEAD '
'\nUR YIG MGO'
'\x07STERISK'
'\t OPENING '
'\x10VARIANT FORM ESH'
'\x017'
'\x07RCHAIC '
'\x07SPRINGS'
'\tESAME DOT'
'\x0bCANDRABINDU'
'\x0cDOWED WHITE '
'\x04AAFU'
'\x0cWARDS BULLET'
'\x05RATHA'
'\x05TTOM '
'\x14LEFT AND LOWER RIGHT'
'\tCHMA SIGN'
'\tOVER SHE '
'\x06OGONEK'
'\x04GONG'
'\x07LLIANCE'
'\x08 TALENTS'
'\x04RGU2'
'\x1e-HIRAGANA PROLONGED SOUND MARK'
'\x13 WITH STRIKETHROUGH'
'\x04APPA'
'\nHOGI PIECE'
'\x06HEISEI'
'\nEVANAGARI '
'\x08ERO SIGN'
'\x0cNGLE BARLINE'
'\x13VASTNESS OR WASTING'
'\x06CHADIN'
'\x08ONE FOR '
'\x16PRECEDED BY APOSTROPHE'
'\x0c IN TRIANGLE'
'\x17RTOISE SHELL BRACKETED '
'\x16GREATER-THAN DIAERESIS'
'\tURUZ UR U'
'\x07CHEINAP'
' -POINTING ANGLE BRACKET ORNAMENT'
'\x05CCENT'
'\x04SINK'
'\x04LUIS'
'\x10-POINTING ANGLE '
'\nGGRAVATION'
'\rOWN-POINTING '
'\x05REREN'
'\x06 ARROW'
'\x05KHAPH'
'\x061 HORN'
'\x14CENTRE VERTICAL LINE'
'\t OVER LUM'
'\x04BEAM'
'\x05STORM'
'\x06KTIKO '
'\tURASHTRA '
'\x14DOUBLE ANGLE BRACKET'
'\x035-0'
'\x0fIMISEOS CHRONOU'
'\nWARDS VANE'
'\nUMAN EARTH'
'\x07SYMBOL '
'\tTABE SIGN'
'\x17BARBED RIGHTWARDS ARROW'
'\x0cLACK HEXAGON'
'\x10SERIFS AT BOTTOM'
'\x0eOBLIQUE HYPHEN'
'\tLAM WITH '
'\x05ARGE '
'\x0cDOWN HARPOON'
'\x07 WOLOSO'
'\x05NASHI'
'\tOWER LEFT'
'\tATHAMASAT'
'\x14ARXIS KAI FTHORA VOU'
'\x04FITA'
'\tTOS ICHOS'
'\x04DASH'
'\nNAKE BELOW'
'\x05ORUTO'
'\x05O RUA'
'\x06RRED O'
'\x03ZAI'
'\x0eSTROKE OVERLAY'
'\x04HID '
'\x05PIEUP'
'\x07IP SIGN'
'\x058 RO2'
'\nMINO TILE '
'\x0eOLIDUS OVERLAY'
'\x05GORGI'
'\x0cIRTY-SECOND '
'\x07APITAL '
'\x12 OVER INVERTED SHU'
'$DOUBLE-LINE EQUAL ABOVE GREATER-THAN'
'\x0cGREEN DRAGON'
'\x11MALL WHITE CIRCLE'
'\x07MENIAN '
'\x0cOACTIVE SIGN'
'\x03VUU'
'\x040 ZO'
'\tROJECTION'
'\x03NJE'
'\x0bRESCENT BAR'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x07DOUBLE '
'\x03HWA'
'\x13ND SLANTED PARALLEL'
'\x04NOUT'
'\x0bROSSED-TAIL'
'\x04ITH '
'\nAL BARLINE'
'\x01N'
'\x08INVERTED'
'\x07OCALIC '
'\x0f WITH DOT ABOVE'
'\x05TON A'
'\x06-CREE '
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x0bOR OPERATOR'
'\x03EIS'
'\rQUARTERS SIGN'
'\x03EIE'
'\x05FAAFU'
'\x12 WITH CIRCLE ABOVE'
'\x08SKLIRON '
'\nDDAH ABOVE'
'\x10ONE EIGHTH BLOCK'
'\tAIGHTNESS'
'\x19TTED SUBSTITUTION BRACKET'
'\x06INGAAT'
'\x02MP'
'\x10RIZONTAL ELLIPSE'
'\x06ULDRON'
'\x13DOWN AND HORIZONTAL'
'\x08FISHHOOK'
'\x18-POINTING TRIANGLE WITH '
'\x0eROSS ON SHIELD'
'\x0fGHT REPEAT SIGN'
'\x04PING'
'\x03EI '
'\x0cMING TO MEET'
'\x0eTIMES OPERATOR'
'\x08 OVER MU'
'\x05ARROW'
'\x03UB2'
'\x05ALETH'
'\x04OUR '
'\nLONG OVER '
'\x04MAI '
'\x03OAY'
'\x03PII'
'\x03PIN'
'\x0bLON SKEWED '
'\x03PIC'
'\x08LONG S T'
'\x04INAP'
'\x06TILDE '
'\x0bHIGH STROKE'
'\x11RIGHT HALF CIRCLE'
'\x10MIDIRECT PRODUCT'
'\x06STROFO'
'\rCURLY BRACKET'
'\x08FRICAN D'
'\x15MORPHOLOGICAL DIVIDER'
'\x05 SHAD'
'\x05AMEKH'
'\x07URGLASS'
'\x06CATAWA'
'\tBRUL SHAD'
'\x0bENG DIGRAPH'
'\x08FINAL TH'
'\x0bWHITE ARROW'
'\x04CAYN'
'\nUMBER SIGN'
'\tING LANES'
'\x03MWA'
'\x05BLOCK'
'\nYRILLIC EN'
'\x07UBUFILI'
'\x03AME'
'\x06APLI M'
'\x06LISHA '
'\nEVERSED PE'
'\x08ECH YIWN'
'\tIVINATION'
'\x15GRAMMOS OKTO DODEKATA'
'\x04UPLE'
'\x05HETHE'
'\x19LEFT PARENTHESIS ORNAMENT'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x06HO HOI'
'\x07IKHAHIT'
'\x04SIS '
'\x18WO DOTS VERTICALLY ABOVE'
'\x0bVAMAGOMUKHA'
'\x05OKOJI'
'\tETER SIGN'
'\tEARDROP-S'
'\n RESUPINUS'
'\x05CIEUC'
'\x03KUU'
'\x0270'
'\x03KUR'
'\x03KUN'
'\tEEM WITH '
'\rUPERIMPOSED X'
'\x04OTUS'
'\x07NESTED '
'\x030-0'
'\x045 NU'
'\x0eSOUTH ARABIAN '
'\nOWEL SIGN '
'\rWN TACK BELOW'
'\tZIR SASAK'
'\tHIGH TONE'
'\tOVER LONG'
'\x0bLU PLUS IGI'
'\x03YNN'
'\x11RIGHT ARROW ABOVE'
'\x05EQUAL'
'\x0cWORD DIVIDER'
'\x07PANESE '
'\x03X00'
'\tFOUR DOTS'
'\x07PERATOR'
'\x10ADIAN SYLLABICS '
'\x02TT'
'\x02TU'
'\x02TS'
'\x02TO'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'\x02A4'
'\x04NAG '
'\x02TI'
'\x02TE'
'\x02TA'
'\x02AA'
'\x02AC'
'\x02AB'
'\x02AE'
'\x02AD'
'\x02AG'
'\x02AF'
'\x02AI'
'\x02AH'
'\x02AK'
'\x02AM'
'\x02AL'
'\x02T0'
'\x02AN'
'\x02AP'
'\x02AS'
'\x02AR'
'\x02AU'
'\x02AT'
'\x02AW'
'\x02AV'
'\x0eSQUIGGLE ARROW'
'\x0fULGAR FRACTION '
'\x0bDOUBLE AND '
'\x07NJAEMLI'
'\x02T '
'\nTWO SHORTS'
'\tROW WITH '
'\x06ITIAL '
'"IGHUR KAZAKH KIRGHIZ ALEF MAKSURA '
'\tABOVE TO '
'\x04TAWA'
'\x13URRENCY SYMBOL BAHT'
'\x05SSERA'
'\x13UBSTITUTION BRACKET'
'\x06M DASH'
'\x14 OVER TUR ZA OVER ZA'
'\x05F EWE'
'\nW OR MODEL'
'\x04SHTA'
'\x06OPEN E'
'\x06BAFILI'
'\nING LARGE '
'\x0cQUIRREL TAIL'
'\x0cPUNCTUATION '
'\x07RA SIGN'
'\t OR EQUAL'
'\x12NYOOGA NAAKSIKYAYA'
'\x05KWAEN'
'\tLEMENT OF'
'\nUBLE DASH '
'\x06LAFRON'
'\x02JE'
'\x06HERMES'
'\x11VARIANT FORM ASH9'
'\x08OWN TACK'
'\x0eLEFT HALF RING'
'\x14GRA GCAN -CHAR RTAGS'
'\nALEF LAMED'
'\nUR HUNDRED'
'\x07ISIBLE '
'\nFFICULTIES'
'\x07SAYANNA'
'\x04EESU'
'\x0cUTH-SLAVEY K'
'\x05MAQAF'
'\x17RIGHT DIAGONAL ELLIPSIS'
'\x04FIVE'
'\x12EVENTEEN FULL STOP'
'\x08OMMA BAR'
'\x0cDOUBLE ARROW'
'\x0cMIDDLE TILDE'
'\x04CRON'
'\x0bONG-BRANCH-'
'\x07TRICAL '
'\x17CIRCUMFLEX ACCENT ABOVE'
'\x06CORNER'
'\x04KAAF'
'\x07OP MARK'
'\x05OMEGA'
'\x05WINDU'
'\rOTHIC LETTER '
'\x0bACKNOWLEDGE'
'\x12 AND SMASH PRODUCT'
'\x05ABOVE'
'\x04REH '
'\x08PERFECTA'
'\x05QUEEN'
'\x04MARK'
'\x04MARU'
'\x08UND SIGN'
'\x1cLEFTWARDS OF DOWNWARDS ARROW'
'\x03TOP'
'\x04RIPT'
'\x03TON'
'\x03TOO'
'\x16UPPER RIGHT AND LOWER '
'\x13OVER E NUN OVER NUN'
'\x0eVONIC ASTERISK'
'\x03HIP'
'\x03HIT'
'\x05UMMER'
'\tVISARGAYA'
'\x0b WITH DASIA'
'\x06BARREE'
'\x03HID'
'\x0eIGHTWARDS VANE'
'\x03HIN'
'\x1aOCKED FEMALE AND MALE SIGN'
'\x13FLORAL HEART BULLET'
'\x07AELAENG'
'\x15OVER RIGHTWARDS ARROW'
'\tRECTANGLE'
'\x03AVA'
'\x06INDIC '
'\nRIGHT HOOK'
'\x05GREE '
'\x0bRIGHT LIGHT'
'\x07RAGANA '
'\x0fMZA ABOVE WITH '
'\x03EGA'
'\x0bULO TWO SUM'
'\tTRAIGHT U'
'\x03RAE'
'\x0fEFT PARENTHESIS'
'\x03RAA'
'\x03RAN'
'\x08LASH BAR'
'\x03RAI'
'\x0bVISARGA ONE'
'\x19CROSSING NORTH EAST ARROW'
'\x14 AND DIAGONAL STROKE'
'\x03RAY'
'!EFT-POINTING ANGLE QUOTATION MARK'
'\rTOP HALF RING'
'\x0fDESCENDING TONE'
'\x08ABOAFILI'
'\x0cWIGGLY FENCE'
'\x05SLASH'
'\x04ROA '
'\x05WATTO'
'\x05ACRON'
'\x06RGIAN '
'\x05IKURU'
'\x06WO OF '
'\x05CEDES'
'\x03IFT'
'\x03OCK'
'\x06HARP S'
'\nLANE MERGE'
'\x08 OVER KG'
'\x03IFF'
'\x08TWO DOTS'
'\x08EVERSED '
'\x0b AND MACRON'
'\t PLUS SUM'
'\x06LIGION'
'\x16BINING GEMINATION MARK'
'\tMES WITH '
'\x10IFTEEN FULL STOP'
'\x06TAU RO'
'\x04OLON'
'\x07Y MUCH '
'\tFINAL NGA'
'0LANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL'
'\x05SAUIL'
'\x050 OIL'
'\x14PROLONGED SOUND MARK'
'\x03F8C'
'\x03MUT'
'\x04HORI'
'\x07OREVMA '
'\x05PEITH'
'\x0b WITH COMMA'
'\x03 SA'
'\x08NINETEEN'
'\x07ALTILLO'
'\x03ASU'
'\x07LLABLE '
'\nFAHRENHEIT'
'\x06UFISMA'
'\x03NUM'
'\x03ASE'
'\x0bOLD NUBIAN '
'\x032-0'
'\x03DUN'
'\x0eIAGONAL STROKE'
'\x03AS '
'\x03DUR'
'\tUNGSEONG '
'\x11A PLUS HA PLUS DA'
'\x05PAATO'
'\x05 CAPO'
'\x0cLEFT HARPOON'
'\x12ORK ON THE DECAYED'
'\x04ENAT'
'\nDIGIT ZERO'
'\x0fAND PARALLEL TO'
'\x05BLACK'
'\x0bISIGOTHIC Z'
'\tARROWHEAD'
'\x05KUSMA'
'\x06JUDIJE'
'\x05RNED '
'\x04HAH '
'\x17ESS OUTLINED WHITE STAR'
'\x10 AND LIGHT RIGHT'
'\x08XCELLENT'
'\x0f WITH DIAERESIS'
'\x0bIPLE TONGUE'
'\x05GRAVE'
'\x06ILBOAT'
'\x07AY SIGN'
'\x04MEKH'
'\x0eTOP HALF BLACK'
'\x10ECIMAL SEPARATOR'
'\x06SOUNAP'
'\x079 CLOTH'
'\x0cOING TO MEET'
'\x0cBAHIRGOMUKHA'
'\x08TART OF '
'\x04MUSH'
'\x07EULEUNG'
'\rMALL CAPITAL '
'\x13DENOMINATOR SIXTEEN'
'\tHAH WITH '
'\tDOWN AND '
'\x08OLLOWING'
'\x0eZAH WITH MEEM '
'\tZAL SASAK'
'\x05REEK '
'\x18ARROW POINTING DIRECTLY '
'\x07OW LINE'
'\x05SILA3'
'\x03121'
'\x05MAAEH'
'\x08KATAKANA'
'\x04RROI'
'&ABOVE LEFTWARDS HARPOON WITH BARB DOWN'
'\x06GURAMU'
'\x06OPEN P'
'\x12INDEPENDENT VOWEL '
'\x06OPEN D'
'\x07I RTAGS'
'\x0fDI ALLAHOU ANHU'
'\x05NABLA'
'\tPIDERY HA'
'\x04LUMN'
'\t APODEXIA'
'\x0cEEPING SMALL'
'\x05AMATS'
'\x06CALATE'
'\x0cFALLING DOTS'
'\x16INVERTED SMALL V ABOVE'
'\rDOUBLE STROKE'
'\x03WN '
'\x05G YUS'
'\x0bWARDS ARROW'
'\x05METRY'
'\x07CENTRE '
'\x06OW TIE'
'\x0eLMOST EQUAL TO'
'\x13CE OF INTEREST SIGN'
'\n OVER KAD5'
'\x14TRANSPOSITION MARKER'
'\x1fHEART EXCLAMATION MARK ORNAMENT'
'\x073 MONTH'
'\x06VOWEL '
'\nLCROW SIGN'
'\x05ITHI '
'\x0cNERSHIP SIGN'
'\x07MANCHU '
'\x07ES NOT '
'\x04AGAB'
'\x0cSS-THAN SIGN'
'\x07 SYMBOL'
'\x1aINDUSTRIAL STANDARD SYMBOL'
'\x04SECT'
'\x05MPARE'
'\x15HAND INTERIOR PRODUCT'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x07 CER-WA'
'\tOCCLUSION'
'\x0eOUNDED CORNERS'
'\x0eAMNUC PII KUUH'
'\x16BAR ABOVE INTERSECTION'
'\x11CONSONANT SIGN PA'
'\rWAVY LOW LINE'
'\x05TTERN'
'\x05URTLE'
'\nED FIGURE-'
'\x04RAFE'
'\x12TO LOWER LEFT FILL'
'\x10HOLDING TOGETHER'
'\x06BEGIN '
'\x08SNA LDAN'
'\x03PPA'
'\x0e AND DOT ABOVE'
'\x11WO VERTICAL DOTS '
'\x0bNUMBER SIGN'
'\x06DALETH'
'\x031-0'
'\x17ANG DEPARTING TONE MARK'
'\x04NWAA'
'\rMALL LETTER Z'
'\x0fEXPONENT SYMBOL'
'\rMALL LETTER J'
'\x02BE'
'\x07KOQNDON'
'\x02BB'
'\x03TIV'
'\x02BO'
'\x02BI'
'\x03TIO'
'\x04LAT '
'\x0fNVERTED UBADAMA'
'\x02BS'
'\x03TIE'
'\x02BY'
'\x04ATHA'
'\x08OPRODUCT'
'\tSEPTEMBER'
'\x05CAUSE'
'\x03NNA'
'\x11VARIANT FORM IMIN'
'\x07MEETORU'
'\x04KOET'
'\nTAL RUNOUT'
'\nACK CIRCLE'
'\x10SOUTH EAST ARROW'
'\x10GAAHLAA TTUDDAAG'
'\x07GLAGOLI'
'\x08ASTERN W'
'\x08UMMATION'
'\x05URITY'
'\x0f WITH DESCENDER'
'\tBKHASIAN '
'\x03VY '
'\x05OINT '
'\x02B0'
'\n TIMES SHE'
'\x06EASURE'
'\x06HIVETE'
'\x04BSET'
'\x0eOLD RESOLUTION'
'\x0cWHITE CIRCLE'
'\x03H00'
'\x02U0'
'\x02U3'
'\x05NADA '
'\x03EEL'
'\x10CORNER DOWNWARDS'
'\x03EEN'
'\x03EEE'
'\x1cFOUR BALLOON-SPOKED ASTERISK'
'\x1eSAD WITH LAM WITH ALEF MAKSURA'
'\x02U '
'\x05ETION'
'\rWITH ASTERISK'
'\x10LIGHT AND RIGHT '
'\x03RON'
'\x03ROC'
'\x0fESIDE LESS-THAN'
'\x03ROG'
'\x0f QUOTATION MARK'
'\x03LLO'
'\x03ROP'
'\x03LLA'
'\x07YAH LI '
'\rETROFLEX HOOK'
'\x081 BARLEY'
'\x07HALF BL'
'\x02UX'
'\x02UZ'
'\x02UU'
'\x02UT'
'\x02UQ'
'\x02UP'
'\x02US'
'\nZH DIGRAPH'
'\x02UM'
'\x02UL'
'\x11-9 QUOTATION MARK'
'\x02UN'
'\x02UK'
'\x02UE'
'\x02UD'
'\x02UG'
'\x02UA'
'\x02UB'
'\x0372C'
'\x05CROSS'
'\x11CIRCUMFLEX ACCENT'
'\x0eHORIZONTAL BAR'
'\nSGOR RTAGS'
'\x03IDE'
'\nUARDEDNESS'
'\tOF STIMME'
'\rLATERAL CLICK'
'\x03FEE'
'\x03FEH'
'\x04TED '
'\x06LOSED '
'\x05YECEK'
'\tDUN3 GUNU'
'\x12SYMMETRIC SWAPPING'
'\x03 UP'
'\x0eUP RIGHT BARB '
'\x06NINETY'
'\x0eSECOND SUBUNIT'
'\x06ANGUL '
'\x07VEW NOW'
'\x07RISIMOU'
'\x10 WITH DOT INSIDE'
'\x1fEFTWARDS HARPOON WITH BARB DOWN'
'\x07TH ROOT'
'\x047 JA'
'\x0fATINATE MYSLITE'
'\x06ARBUTA'
'\tTIMES PAP'
'\x06IN DOT'
'\x11AUKAZ LAGU LOGR L'
'\x0fYNCHRONOUS IDLE'
'\x0bSIGN VIRAMA'
'\x05PATAH'
'\x05PATAK'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x08SQUARED '
'\x06HYPHEN'
'\x0eLITTLE SECTION'
'\nOLON EQUAL'
'\x04OOTH'
'\x04HAN '
'\x06MACRON'
'\x046 RU'
'\x08CHATTAWA'
'\rLVEOLAR CLICK'
'\x0bCREDIT SIGN'
'\tOENICIAN '
'\rFINAL SEMKATH'
'\x0cGHT OPEN BOX'
'\rOON NOTEHEAD '
'\x08LOW STOP'
'\x10MULTIPLICATION X'
'\x045 JU'
'\x04RUIS'
'\x12MATHEMATICAL SPACE'
'\x15DIGRAMMOS EX DODEKATA'
'\x05EO-EU'
'\x08P HALF O'
'\x07EN SIGN'
'\x07LL SIGN'
'\x04MBOO'
'\x05LASMA'
'\r WITH JEGOGAN'
'\x05 REPA'
'\x16CURLY BRACKET ORNAMENT'
'\x1eMODIFIER LETTER LEFT HALF RING'
'\x05GESH2'
'\rUPSILON WITH '
'\x06OLIDUS'
'\x05SOL S'
'\nMIDDLE DOT'
'\x0cAND CRESCENT'
'\x06HORT A'
'\x15ACUTE AND HOOK SYMBOL'
'\x04IVE '
'\x07CAYANNA'
'\x0eTURKIC LETTER '
'\x12 WITH PALATAL HOOK'
'\x08LESSER Y'
'\x10STERISK OPERATOR'
'\x12LENTICULAR BRACKET'
'\x08NAM BCAD'
'\x07 OVER S'
'\tBJARKAN B'
'\x17PA OVER PA GAR OVER GAR'
'\x07 OVER M'
'\x06TERON '
'\x04TUG2'
'\x0bWAVY HAMZA '
'\x05ICRON'
'\x01V'
'\x07 TIMES '
'\nHORT-TWIG-'
'\x0cLINKING MARK'
'\x03RCH'
'\x0bMADDA ABOVE'
'\x05ALATH'
'\x1bBRDA RNYING YIG MGO SGAB MA'
'\x047 RE'
'\r DIMINUTION-1'
'\x15FLATTENED PARENTHESIS'
'\x04IRIQ'
'\x04IRIT'
'\x07-TIKEUT'
'\x05PEECH'
'\x05HIDET'
'\x04ANT '
'\x08ANE TREE'
'\x07DIARGON'
'\x05MUSIC'
'\x0b SHOE STILE'
'\x15GRUENT WITH DOT ABOVE'
'\x0fWO HEADED ARROW'
'\x10STRING FRETBOARD'
'\x0cSOLATED FORM'
'\x04904A'
'\x07 GROUND'
'\x08TION KEY'
'\x05NA PO'
'\x1a NEGATED WITH VERTICAL BAR'
'\x05PASEQ'
'\x03JOT'
'\x0bSPIRATED FA'
'\x03JOY'
'\x03PRO'
'\x0bFIXED-FORM '
'\x19 OVER NUN LAGAR TIMES SAL'
'\x06ENTIMA'
'\x06 CARET'
'\x04URDA'
'\x1a OR APPROXIMATELY EQUAL TO'
'\x0cFT RERENGGAN'
'\tNGTH MARK'
'\x05 GORA'
'\x03ISH'
'\x04LIWN'
'\x03Y00'
'\rUPWARDS ARROW'
'\x0bSYMBOL FOR '
'\x04EAT '
'\tCLOSED PL'
'\rEIGHTHS BLOCK'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\nBSTRUCTION'
'\rFIXED-FORM RA'
'\x04HWAA'
'\x05SHADE'
'\x04 NEO'
'\x0eSURROUND FROM '
'\x05PEN O'
'\x06GS-PA '
'\x04EATH'
'\x05PEN E'
'\x0ePLITTING APART'
'\x03SSA'
'\x05DIPLI'
'\x0bORT BARLINE'
'\x1bRIGHT ARC LESS-THAN BRACKET'
'#OUNDED HIGH STOP WITH FILLED CENTRE'
'\x0cGRAVE ACCENT'
'\x15OHAMMAD ISOLATED FORM'
'\tIGH HAMZA'
'\x0eBAG MEMBERSHIP'
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x03ECH'
'\x03RMA'
'\x05ECEDE'
'\x04WAHA'
'\x0cGXI RADICAL '
'\x08JAVIYANI'
'\x04AR A'
'\x07POMOFO '
'\x0bESH DIGRAPH'
'\x0bTONAL MARK '
'\x08LOW LINE'
'\x04 BAR'
'\rROSGEGRAMMENI'
'\x15MAKSURA ISOLATED FORM'
'\x16FLATTENED OPEN A ABOVE'
'\tITRA SIGN'
'\x05TNESS'
'\x06AYANNA'
'\tRDEL DKAR'
'\x06EENTH '
'\x06ASSING'
'\x16ALEF WITH LAM WITH YEH'
'\x06EMASTI'
'\x1aE ONE-WAY LEFT WAY TRAFFIC'
'\x08IN SPACE'
'\x06ORPIUS'
'\x03POT'
'\x04DLE '
'\x03CYA'
'\x05UBITO'
'\x13ANS-SERIF CAPITAL L'
'\nDIATONIKI '
'\x05HIGH '
'\nFLATTENED '
'\n ENCLOSURE'
'\x0eLEFT TURNSTILE'
'\x1dSEMICIRCULAR PATH AROUND POLE'
'\rLEGETOS ICHOS'
'\x064 DART'
'\x05EDUNG'
'\x05TMAAU'
'\x0fMEEM FINAL FORM'
'\x15ELATIONAL COMPOSITION'
'\x05EGION'
'\x17VERSAL RECYCLING SYMBOL'
'\x08SANYAKA '
'\x0cULL NOTEHEAD'
'\x042 NO'
'\t EQUAL TO'
'\x04CHEE'
'\x07ORCULUS'
'\x04CHEH'
'\x0bHORA DIGIT '
'\x05ONG S'
'\x08HAN-AKAT'
'-ED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE'
'\x08-HEADED '
'\x07CLOSURE'
'\x0eTHOUSANDS SIGN'
'\x07YAYANNA'
'\x08BLINEAR '
'\x03AW '
'\x15ABOVE SHORT DOWN TACK'
'\x13GAPPED CIRCLE ARROW'
'\x06 LELET'
'\x0eOPPOSING PIRIG'
'\x0218'
'\x05COND '
'#OR LOWER LEFT CURLY BRACKET SECTION'
'\x05MEIZI'
'\x08TTO MARK'
'\x0cUBLE SVARITA'
'\x07VAGRAHA'
'\x0207'
'\nLE-DELAYED'
'\x0209'
'\x0fORMATION SOURCE'
'\x0bRIPLE ARROW'
'\x06HUR PA'
'\x01C'
'\x03B00'
'\x08LOCATIVE'
'\x05THEMA'
'\x04HALF'
'\x07OVER DU'
'\x13SEVEN EIGHTHS BLOCK'
'\x05ALING'
'\x045 DE'
'\x072 WOMAN'
'\nWITH MEEM '
'\x05IVATE'
'\tLEFTWARDS'
'\rLONG ANUSVARA'
'\x04RUKU'
'\x0e ISOLATED FORM'
'\nICAL TAPER'
'\x06ARADDO'
'\x05MBOL '
'\x02C-'
'\x05-TAIL'
'\nLINE STAFF'
'\x02C0'
'\rWO DOTS ABOVE'
'\x10VE EIGHTHS BLOCK'
'\x02CK'
'\x02CH'
'\x02CO'
'\x02CC'
'\x02CA'
'\x02CE'
'\x02CR'
'\x02CW'
'\x02CT'
'\x05MIEUM'
'\x0eXO EKFONITIKON'
'\x05SHESH'
'\x0bEQUALS SIGN'
'\x04LAM '
'\x0cBLACK CIRCLE'
'\x18TEARDROP-SPOKED ASTERISK'
'\nIMPERFECTA'
'\x11P ON BLACK SQUARE'
'\x05ADDAK'
'\x02DU'
'\x08OK ABOVE'
'\x02V0'
'\x0fVERTICAL STROKE'
'\x02VA'
'\x06ECTION'
'\x02VE'
'\x02VI'
'\x17REE VARIATION SELECTOR '
'\x02VO'
'\x11WARDS ARROW BELOW'
'\x02VU'
'\rROSSING LANES'
'\x13RROW NO-BREAK SPACE'
'\x04LAMD'
'\x11URNED COMMA ABOVE'
'\x11CAL SYMBOL BOTTOM'
'\x0bOR EQUAL TO'
'\n-POINTING '
'\x0eUBHAYATO MUKHA'
'\tE PLUS EN'
'\x05BALAG'
'\x06CHEMA '
'\x0cYPTOGRAMMIC '
'\x08ARISTERA'
'\nTOP CORNER'
'\x04ALL '
'\x0bLOSED ENTRY'
'\x08HESPIAN '
'\x06OSETTE'
'\x04LPHA'
'\x06GEDOLA'
'\x03ALE'
'\x12HARPOON WITH BARB '
'\rVERTICAL BAR '
'\x06IFIED '
'\nPERCUSSIVE'
'\x08-KHIEUKH'
'\x07T ABOVE'
'\x1cOUND-TIPPED RIGHTWARDS ARROW'
'\x07MBRELLA'
'\x0cBZHI MIG CAN'
'\r B BAR SYMBOL'
'\x19FECTIVENESS OR DISTORTION'
'\x12DOUBLE PUNCTUATION'
'\x10FFERENCE BETWEEN'
'\tIGHTH ASH'
'\x04INTO'
'\tDIAERESIS'
'\x05PI RO'
'\x08OPERATOR'
'\x07AULDRON'
'\x04AMPI'
'\x0cFEATHER MARK'
'\x04LIUM'
'\x03SUM'
'\x07JARATI '
'\nHORIZONTAL'
'\x03TEH'
'\x03TEN'
'\nND OF AYAH'
'\x16AISED OMISSION BRACKET'
'\x0cLATALIZATION'
'\x03TER'
'\x0fMURDA MAHAPRANA'
'\x08NSULAR G'
'\x08NSULAR D'
'\x11 WITH TILDE ABOVE'
'\x06ENTION'
'\x05WARDS'
'\x13TIONAL DIGIT SHAPES'
'\x08AH WITH '
'\x04MYA '
'\x01Z'
'\x0eRIPLE UNDERDOT'
'\rORNER BRACKET'
'\x07AUNTLET'
'\x10EN MILLIONS SIGN'
'\x03SU '
'\x1fRIGHTWARDS HARPOON WITH BARB UP'
'\x05NCORA'
'\x0fLEFT DOWN BARB '
'\x0bAILLESS PHI'
'\x0fACHES THE LIMIT'
'\x10HORIZONTAL HEAVY'
'\x14OTLESS J WITH STROKE'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'\x04DISH'
'\x03HO '
'\x03EAN'
'\x07MEDIUM '
'\x03EAF'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'*OWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\rH-TYPE SYMBOL'
'\x11HAH ISOLATED FORM'
'\x03EAT'
'\x07LABIAL '
'\x1d WITH REVERSED NEGATION SLASH'
'\x04OMMA'
'\x08HAVIYANI'
'\nLHAG RTAGS'
'\x07IBIFILI'
'\x08ASTERISK'
'\x0eTHALAN ETHEL O'
'\x03HOU'
'\rOTEHEAD BLACK'
'\x0f-CARRIER LETTER'
'\x0fREVERSED OPEN E'
'\x18GREATER-THAN OR EQUAL TO'
'\x07EPHONE '
'\x16POINTING UPWARDS BELOW'
'\x04TEXT'
'\x07-MACRON'
'\rROKEE LETTER '
'\x11OWER NUMERAL SIGN'
'\x12 WITH CROSSED-TAIL'
'\n MAHAPRANA'
'\x0fCAPITAL LETTER '
'\x010'
'\x03LHA'
'\t TROMIKON'
'\x06IRCLES'
'\x10LEFT PARENTHESIS'
'\x03FIN'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\x08MANGALAM'
'\tNOCULAR O'
'\x10UNCTUATION SPACE'
'\x03ORU'
'\x06TTAVA '
"'WITH OPEN ARM ENDING IN ARROW POINTING "
'\x0fMIDDLE DIAGONAL'
'\x05TONOS'
'\x04NESS'
'\x05KOPPA'
'\x07AL SIGN'
'\x11EMICOLON UNDERBAR'
'\x0bINDERGARTEN'
'\x05SHGAB'
'\x0b WITH MAPIQ'
'\x07VISARGA'
'\x04FLAT'
'\x08THOUSAND'
'\x0cMPTY CENTRE '
'\x05YENAP'
'\x13 IN A RECTANGLE BOX'
'\x0c CROSSING GU'
'\x05RING '
'\x13 AND PROSGEGRAMMENI'
'\x03EVA'
'\x06-HIDET'
'\x05LATIK'
'\x03UKU'
'\x06IGHTH '
'\x11ABOVE EQUALS SIGN'
'\tLISSANDO '
'\x1cEDGE-TAILED RIGHTWARDS ARROW'
'\x10HORIZONTAL LIGHT'
'\x06AUTUMN'
'\x0bSYURA SASAK'
'\t FROM BAR'
'\x05UGUST'
'\tEBIT SIGN'
'\x06TIRYAK'
'\x07RANGKEP'
'\x10POSTPOSITION MEN'
'\x07IRPLANE'
'\x07PAYANNA'
'\x03HAN'
'\tBASE UNIT'
'\tLL SYMBOL'
'\nARAKALESMA'
')ULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT'
'\tTTED STEM'
'\x08BATBEIT '
'\nCHAD RTAGS'
'\x13CIRCLED SANS-SERIF '
'\x0fITION INDICATOR'
'\x0fLEFT HALF BLACK'
'\nTIMES TAK4'
'\x08HARMONIC'
'\x05DAMMA'
'\x04UNAP'
'\x04UNAV'
'\x08ETRASEME'
'\x17DSTONE GRAVEYARD SYMBOL'
'\x04UNAH'
'\x12ATIN SMALL LETTER '
'\x1aTENDED ARABIC-INDIC DIGIT '
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x08OPENING '
'\x05HI RO'
'\nNASPIRATED'
'\x0fN-ARY SUMMATION'
'\x08LONG LEG'
'\x06AKABAT'
'\x14INVERSE WHITE CIRCLE'
'\x06BANWA '
'\r TIMES KASKAL'
'\x07-CREE R'
'\x05ALAPH'
'\nTESE CROSS'
'\x0fHEH MEDIAL FORM'
'\nTER SYMBOL'
'\x05CLIFF'
'\nK2 PLUS BU'
'\x05ESHE3'
'\x0bCCUMULATION'
'\x08SUPERSET'
'\x03RTE'
'\x0bFOURTH ROOT'
'\x04EZZO'
'\tVOCALIC R'
'\tWORDSPACE'
'\x03RTH'
'\x0f2 CHARIOT FRAME'
'\r BEHIND CLOUD'
'\x03RTY'
'\x03RT '
'\x01G'
'\x0fCONSONANT SIGN '
'\x05WU318'
'\x04EEK '
'\x07T BELOW'
'\x07NG SIGN'
'\x08EST WIND'
'\x11GREATER-THAN SIGN'
'\x03II '
'\rOPPOSING NAGA'
'\x05ASEIA'
'\x16SYMPTOTICALLY EQUAL TO'
'\x021A'
'\x05AL TO'
'\x021D'
'\x06ISSIMO'
'\nWO SHORTS '
'\x18ORIZONTAL BAR WITH NOTCH'
'\nEARTH MARK'
'\x04AULA'
'\x04NUUN'
'\x07KOMBUVA'
'\x0bLOGICAL AND'
'\x04UMAN'
'\x11ATHERING TOGETHER'
'\x03JK '
'\x0eOUSING THUNDER'
'\x07GINESE '
'\x0211'
'\x06RKAANU'
'\x0216'
'\x07TAISYOU'
'\x0cLOWER CORNER'
'\x04LISH'
'\x02DO'
'\x02DI'
'\x02DD'
'\x02DE'
'\x06YELLOW'
'\x02DA'
'\x04HREE'
'\x02DY'
'\x04EIWS'
'\x04FWAA'
'\x02DR'
'\x073 SPICE'
'\x07SMALL L'
'\x07SMALL V'
'\x05RRECT'
'\rPPOSING LUGAL'
'\x0fPRIOT SYLLABLE '
'\x04INTE'
'\x03S O'
'\x03DHE'
'\x05UPLE '
'\x03DHA'
'\x15 AND THREE DOTS ABOVE'
'\x06HLAVI '
'\nOUR FIFTHS'
'\x08ERAL URN'
'\x10BRACKET ORNAMENT'
'\x07FINAL Y'
'\x08BACK YER'
'\x02D '
'\nAPOSTROPHE'
'\x02D0'
'\x02WG'
'\x04GHOM'
'\x02WE'
'\x02WA'
'\x03QAR'
'\x02WO'
'\x02WN'
'\nDASH ARROW'
'\x15ALLING DIAGONAL SLASH'
'\x02WU'
'\x03QAF'
'\x0bRACHMA SIGN'
'\tETRASIMOU'
'\x03RIP'
'\x03RIG'
'\nOSTAL MARK'
'\x03HAH'
'\x07HM SIGN'
'\x03HAL'
'\x03HAM'
'\x04RISH'
'\x08COUNT OF'
'\x03HAA'
'\x03HAD'
'\x0bHJONG TILE '
'\x03HAR'
'\x0b UPPER HALF'
'\x02W '
'\tURNED GAN'
'\x07JERAN J'
'\x05 SIGN'
'\x04BAR '
'\x02W0'
'\x14WARE-FUNCTION SYMBOL'
'\x11LAPPING LESS-THAN'
'\x08PEE SIGN'
'\x12 PLUS LU PLUS ESH2'
'\x04HELL'
'\x0bCOMPOSITION'
'\nGAS BZUNG '
'\x03FO '
'\x08COUNTERS'
'\x03LJE'
'\x07FAYANNA'
'\x05A UNA'
'\x05THAM '
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x07MYSLITE'
'\x05M RAM'
'\x08HUNDRED '
'\rRIGHT HARPOON'
'\x07NTAINS '
'\x0cACUTE ACCENT'
'\x06AGRANT'
'\x05MALON'
'\x04CHIL'
'\x1eDOWNWARDS AND RIGHTWARDS ARROW'
'\x042 RO'
'\x07ERCIAL '
'\x07LAGIOS '
'\x17P SYMBOL FOR LIGHTHOUSE'
'\x06SICKLE'
'\x06UPTURN'
'\rCRIPTION TAKE'
'\tAOS ICHOS'
'\x047 DI'
'\x14YRENAIC TWO DRACHMAS'
'\n4 PLASTICS'
'\x06SUBSET'
'\x06QUARE '
'\x05SEGOL'
'\x13ND SOUTH EAST ARROW'
'\x04OBRO'
'\nA PLUS IGI'
'\x07 CIRCLE'
'\x0cAPYEOUNPIEUP'
'\x04LOLL'
'\x07FINAGH '
'\x08RECORDER'
'\x05GADOL'
'\x15HOUSAND MILLIONS SIGN'
'\x05HOUR '
'\nNUMBER TEN'
'\x07OURTEEN'
'\x06EXISTS'
'\nA PLUS KUR'
'\x08NCE SIGN'
'\x04MESO'
'\n TIMES BAD'
'\rYUUKALEAPINTU'
'\nLE LETTER '
'\x02TY'
'\x0bARGE CIRCLE'
'\x07N WITH '
'\x06QUARED'
'\x07CELSIUS'
'\x0bVOWEL SIGN '
'\nCIRCUMFLEX'
'\x08V OVER M'
'\x0bINTERROBANG'
'\x0cHALF BRACKET'
'\x0351F'
'\x02A0'
'\x0cCROSSING KAL'
'\n6 PLASTICS'
'\x014'
'\x06BETAN '
'\x08RSECTION'
'\x05RASS '
'\x06 EQUID'
'\x05AR B '
'\x05FAIHU'
'\x07THIEUTH'
'\x07MIDDLE '
'\x05ORGON'
'\x07TERNITY'
'\x05BREVE'
'\x11EMIDIRECT PRODUCT'
'\tONGSEONG '
'\x13GYPTIAN HIEROGLYPH '
'\n2 PLUS ASH'
'\x1bCONTINUOUS UNDERLINE SYMBOL'
'\r WITH OVERBAR'
'\x0bZIGZAG LINE'
'\x08WO ABOVE'
'\x19BUT NOT ACTUALLY EQUAL TO'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\tOO DENNEN'
'\x056 TA2'
'\x07READING'
'\n WITH CURL'
'\x05SCHWA'
'\nILING FACE'
'\x05ATIYA'
'\x05PITER'
'\x03ZUP'
'\x08ALLIANCE'
'\x05PPAGE'
'\x02AY'
'\x08DVISVARA'
'\x0eRONIAN SIGN ET'
'\x03RRY'
'\x15DOWN HORIZONTAL LIGHT'
'\nX NOTEHEAD'
'\x0cRIGHT ARROW '
'\x05OWER '
'\x14AND SOUTH WEST ARROW'
'\tADEG ADEG'
'\x05DOTS-'
'\x0cLAGAR TIMES '
'\x04URCH'
'\x03USE'
'\x03USH'
'\x18-HEADED RIGHTWARDS ARROW'
'\nLPAPRAANA '
'\x07NAYANNA'
'\x03XWG'
'\tILE TILDE'
'\x05 TENU'
'\x11DOUBLE ARCH BELOW'
'\x13ARENTHESIS NOTEHEAD'
'\x08 TTUDDAG'
'\x05PCHA '
'\x10SLANTED EQUAL TO'
'\x0bIAN LETTER '
'\x12KOREAN CHARACTER O'
'\x16OVER LEFTWARDS HARPOON'
'\tLVIN SIGN'
'\x06BISHOP'
'\x0cPER-EM SPACE'
'\x05DIUM '
'\rILE SEPARATOR'
'&EH WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x05ALPHA'
'\x06LAZY S'
'\x0fAMARITAN SOURCE'
'\x05TROKE'
'\x05SHAN '
'\x03SIC'
'\x07BREVIS '
'\x08ONE MARK'
'\n WITH PLUS'
'\x0bRONTHISMATA'
'\x06ARRIER'
'\x04ORTY'
'\x03TAS'
'\x05LAMED'
'\x08EQUAL TO'
'\x03TAA'
'\x03TAB'
'\x03TAL'
'\x03TAM'
'\x03TAN'
'\x03TAO'
'\x03TAH'
'\x05PRIME'
'\x0cUN WITH RAYS'
'\x04KAKO'
'\x19OUTLINED RIGHTWARDS ARROW'
'\x18E PLUS A PLUS SU PLUS NA'
'\x0bQUARTER ASH'
'\x03DJA'
'\x03TA '
'\x08EVERANCE'
'\x04ORT '
'\tRNEY PARA'
'\x08NVERTED '
'\x0eVERTICAL HEAVY'
'\x05SHANG'
'\x06LOWER '
'\x0bACUTE-GRAVE'
'\x14HIGH RATHA OR LOW PA'
'\x08MULTIMAP'
'\x08ING ROD '
'\x07JEGOGAN'
'\nHOTIC HOOK'
'\x0b0 FOOTSTOOL'
'\rEWDATA SQUARE'
'\x14VAL WITH OVAL INSIDE'
'\x06FONIAS'
'\tMPLIFIED '
'\x01K'
'\tDOT BELOW'
'\x04RIME'
'\tAMPERSAND'
'\x03BLE'
'\x06MADR M'
'\x03BLA'
'\nWITH CARON'
'\tPOSTROPHE'
'\x06H NOTE'
'\rLEFT QUADRANT'
'\x0bUG RTAGS GY'
'\x06POKED '
'\x08GBASINNA'
'\x067 KAPO'
'\x06RIISAP'
'\nVIOUS PAGE'
'\tVERLONG A'
'\x05SHAR2'
'\x05DHADH'
'\x07HIRTEEN'
'\x04IITO'
'\x0eITERATION MARK'
'\x03OUR'
'\x03OUT'
'\x0bLEFT DOUBLE'
'\x0cOHAZARD SIGN'
'\n SCHROEDER'
'\x066 TREE'
'\x03LTA'
'\x04LEPH'
'\x11GREATER-THAN NOR '
'\x03LTI'
'\x0fCORNER WITH DOT'
'\x04HEEN'
'\x06HAMZA '
'\tAVE ARROW'
'\x12ASTROLOGICAL SIGN '
'\x04GUNU'
'\x16SHORT RIGHTWARDS ARROW'
'\x11INTEGRAL OPERATOR'
'\rNSONANT SIGN '
'\x10HAH INITIAL FORM'
'\x042 PE'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x08PE DRIVE'
'\x05TSERE'
'\x04OENG'
'\x05KURON'
'\x15ARYSTIAN FIVE HUNDRED'
'\tTUTEYASAT'
'\x0bVARYS ICHOS'
'\x04CHOR'
'\x0eSQUARE BRACKET'
'\x0fOWER HALF BLACK'
'\x04YWAA'
'\x0bMALL CIRCLE'
'\x07ARALLEL'
'\x0cMFLEX ACCENT'
'\x16LATIN CAPITAL LETTER S'
'\x04ARP '
'&ASHED TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x03D42'
'\x04AKRA'
'\x06NGBAT '
'\tADMA GDAN'
'\x07TRAINER'
'\x12GATIVE ACKNOWLEDGE'
'\x0fONTOUR INTEGRAL'
'\x15EQUAL TO OR LESS-THAN'
'\nUBLE GRAVE'
'\r CROSSING KA2'
'\x07BARREKH'
'\x08-CREE TH'
'\nCHECK MARK'
'\tWASH TAIL'
'\x10LD ASSYRIAN ONE '
'\x08RIYOOSAN'
'\x0cVER EQUAL TO'
'\x05NTAIN'
'\x0220'
'\x0221'
'\x0222'
'\x04PLUM'
'\x0cGLOTTAL STOP'
'\x0fYIG MGO SGAB MA'
'\x04PLUS'
'\x15MALL Q WITH HOOK TAIL'
'\x0fSIXTEENTH NOTES'
'\x0fATA LINK ESCAPE'
'\x05GURE '
'\x07SECTION'
'\x08 PLUS DU'
'\x03LAM'
'\x0cETARTIMORION'
'\x03AYB'
'\x022D'
'\x022F'
'\x08 PLUS DI'
'\x06THORA '
'\tOUND SIGN'
'\x05HIRTY'
'\x11WIDE BRIDGE ABOVE'
'\x05RELAA'
'\x13ITED LIABILITY SIGN'
'\x16INVERTED SMALL V BELOW'
'\x02E '
'\tOMBINING '
'\nD WITH DOT'
'\nWITH BARB '
'\x02E0'
'\x02E2'
'\x02EM'
'\x02EL'
'\x02EO'
'\x02EN'
'\x02EI'
'\x02EH'
'\x02EK'
'\x02EE'
'\x02ED'
'\x02EF'
'\x02EA'
'\x04WAVE'
'\x11DELPHIC FIVE MNAS'
'\x02EY'
'\x02EU'
'\x02ET'
'\x02EW'
'\x02EP'
'\x02ER'
'\x04AMIL'
'\x07DISIMOU'
'\tERCIAL AT'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x06NTOGEN'
'\x0cXIRON KLASMA'
'\tIDEOGRAM '
'\tO HUNDRED'
'\x14DIRECT QUESTION MARK'
'\x06TATED '
'\x02X '
'\x07UNDRED '
'\x0bIL FRAGMENT'
'\x08NGTHENER'
'\x08YIG MGO '
'\x10EFORE COMPLETION'
'\x02XO'
'\x0318D'
'\x02XA'
'\x02XG'
'\x14L FUNCTIONAL SYMBOL '
'\x1d OVER RIGHTWARDS ARROW TO BAR'
'\x02XT'
'\x1bIDE-HEADED RIGHTWARDS ARROW'
'\x04ETAL'
'\x04EACE'
'\x08LEFT TO '
'\x0eRIGHT QUADRANT'
'\x04YUDH'
'\x18COMPATIBILITY IDEOGRAPH-'
'\x05FATHA'
'\x08PERSIAN '
'\x08ALLY EQU'
'\x05IRAMA'
'\x05MAPIQ'
'\tREVERSED '
'\x06APLOUN'
'\x0fWITH DOWN ARROW'
'\x0eLEFTWARDS TICK'
'\x16ND RECORDING COPYRIGHT'
'\x05 TELU'
'\x0fREVERSE SOLIDUS'
'\x06OCIETY'
'\x12KATAKANA-HIRAGANA '
'\x051 TWO'
'\x110 WHEELED CHARIOT'
'\x03IWN'
'\x08 OVER ZI'
'\x03IWR'
'\x018'
'\x06THREE '
'\tNIHSHVASA'
'\x041 PO'
'!DOUBLE-LINE EQUAL ABOVE LESS-THAN'
'\x07CIRCLE '
'\x08OVER TIR'
'\x06BULLET'
'\x0bCROSSING BU'
'\x16WASALLAM ISOLATED FORM'
'\x03 SU'
'\x06EDILLA'
'\x15REVERSED FEATHER MARK'
'\nASTERISCUS'
'\tODIASTOLE'
'\x05MISRA'
'\x06TERNAT'
'\x03GER'
'\x0fDIALYTIKA TONOS'
'\t UNDERBAR'
'\x03TCH'
'\x03GED'
'\tHIGH STOP'
'\x07BAYANNA'
'\x05ALOG '
'\x05ACCAT'
'\x06STROKE'
'\x04IQAA'
'\rS KAI APOTHES'
'\x05LONG '
'\x14INTERPOLATION MARKER'
'\x18GHT TRIFOLIATE SNOWFLAKE'
'\x05OW PA'
'\x0eVERTICAL ABOVE'
'\x10UBJOINED LETTER '
'\x15YIG MGO TSHEG SHAD MA'
'\nLIGHT BEAT'
'\x14ONCAVE-SIDED DIAMOND'
'\x0bILIQUA SIGN'
'\x05PRING'
'\x06TOPBAR'
'\x0cSH ZIDA TENU'
'\x12WHITE VERTICAL BAR'
'\x07ASURED '
'\x05BAARU'
'\x03ND '
'\x04IGN '
'\x05ZAYIN'
'\x04MBIC'
'\x03HER'
'\x0bINTEGRATION'
'\x03HEE'
'\x03HEN'
'\x03HEH'
'\x0eTIMES SHU TENU'
'\x11OPEN CIRCLE ARROW'
'\x08HREE OF '
'\x058 NWA'
'\tGRAM FOR '
'\x0eTILDE OPERATOR'
'\x0bUPADHMANIYA'
'\x0cRRESPONDS TO'
'\x04NIC '
'\x08SHOE JOT'
'\x06ARROW '
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x14MULTIPLE PUNCTUATION'
'\x03OWN'
'\x10HMATULLAH ALAYHE'
'\x1dCONTAINING BLACK SMALL SQUARE'
'\x0cOTATION MARK'
'\x0fHEAVY AND LEFT '
'\x05ARERU'
'\x07OCTOBER'
'\x0fHOUSAND STATERS'
'\x03OW '
'\x04TER '
'\x03LVE'
'\x07SAMPHAO'
'\tTUKWENTIS'
'\x07JAYANNA'
'\x05WHITE'
'\x06FINAL '
'\x04ARC '
'\x10DOUBLE HEAD MARK'
'\x10ULDERED OPEN BOX'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x0cSMALL CIRCLE'
'\nSHARP SIGN'
'\x04TURU'
'\x08NO SLASH'
'\x06OTTED-'
'\x04TURN'
'\x1bIDE ARC ANTICLOCKWISE ARROW'
'\x08ELLIPSIS'
'\x05TYPE-'
'\x18VOICED LARYNGEAL SPIRANT'
'\t PLUS GUD'
'\x05TAL S'
'\x0cRAH BEN YOMO'
'\t2 GARMENT'
'\x11NAUDIZ NYD NAUD N'
'\x1aLEFTWARDS OF UPWARDS ARROW'
'\nOANDAKHIAT'
'\x03TAV'
'\x04ANG '
'\rGISTERED SIGN'
'\x08YEN SIGN'
'\x0cDE MARK SIGN'
'\x05RUDAA'
'\x05ITON '
'\x08 SQUARED'
'\rWITH TWO DOTS'
'\x07ANDERER'
'\x04TWAA'
'\x03305'
'\x01O'
'\x0eQUOTATION MARK'
'\x06IG YUS'
'\x04AYIN'
'\x08MUSICAL '
'\rINVERTED TURN'
'\t THOUSAND'
'\x04HADE'
'\x04RUCK'
'\x0cUBSCRIPT TWO'
'\x10THREE DOTS ABOVE'
'\x05EYYAL'
'\x03TAR'
'\nATER-THAN '
'\x0cPOGEGRAMMENI'
'\nAL SYMBOL '
'\x13TURNED PADA PISELEH'
'\x0cMANNAZ MAN M'
'\x04LY H'
'\x18HEAVY BLACK HEART BULLET'
'\nTHAPASCAN '
'\tOURA SIGN'
'\x07OINTED '
'\x05HORT '
'\x10PEN CENTRE CROSS'
'\x06NOKHUK'
'\x04EUCH'
'\x11NEGATIVE CIRCLED '
'\nNGUAGE TAG'
'\x1aTHREE DOTS ABOVE DOWNWARDS'
'\x08 CEDILLA'
'\rD COMMA ABOVE'
'\x06ANUARY'
'\x04DEL '
'\x06TE TSE'
'\x12NYET THYOOM TA-ROL'
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'\x05BHADH'
'\x08 TIMES U'
'\x06IANGLE'
'\x073 WHEEL'
'\x08 TIMES A'
'\x05CTRIC'
'\x04DELT'
'\x0cLER CONSTANT'
'\x10RIGHT HALF BLACK'
'\x05CKING'
'\x1bROTATED FLORAL HEART BULLET'
'\rWAVY OVERLINE'
'\x06QETANA'
'\x0fINGLE HEAD MARK'
'\x0bBZHI -KHYIL'
'\x11ABBREVIATION MARK'
'\x05BARB '
'\x02 A'
'\x02 K'
'\x02 M'
'\x02 P'
'\x02 U'
'\x11 PUNCTUATION MARK'
'\x04ALDA'
'\tDESCENDER'
'\x04QAAF'
'\x06SIXTHS'
'\tNFORZANDO'
'&RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW'
'\x08MMATION '
'\x0bHAMZA ABOVE'
'\x07E FACE-'
'\x13SPACING CANDRABINDU'
'\x08 HUNDRED'
'\x05CARON'
'\x10CIRCUMFLEX ABOVE'
'\x03UOP'
'\x04UKUN'
'\tTO CORNER'
'\rDOUBLE CIRCLE'
'\x03UON'
'\x04TIC '
'\nIDGE BELOW'
'\x13QUESTION MARK ABOVE'
'\x0bBREVE BELOW'
'\x03FT '
'\tCUBE ROOT'
'\x05SHOOK'
'\x1ePOINTED RECTILINEAR BLACK STAR'
'\x08D RIGHT '
'\x05OURCE'
'\x03FTY'
'\x04EEEE'
'\x04IRGA'
'\x0fLATION FUNCTION'
'\x0239'
'\x0234'
'\x07N2 TENU'
'\x07S BELOW'
'\x11VERAGE WITH SLASH'
'\x02FT'
'\x02FA'
'\x04EUNG'
'\x06RIGHT '
'\x02FE'
'\x02TH'
'\x02FI'
'\x04 C D'
'\x02FL'
'\x03SMA'
'\x02FO'
'\x08THIOPIC '
'\x08RADICAL '
'\x0bFEMALE SIGN'
'\x07LAYANNA'
'\x03JER'
'\x06ETTER '
'\x06ANSIOS'
'\x052 PTE'
'\x03JEU'
'\x0fABOVE LESS-THAN'
'\tMBROIDERY'
'\x03JEE'
'\x02F0'
'\x02F3'
'\x08RAMMA GG'
'\x07UBADAMA'
'\x02YI'
'\x0cSHED BARLINE'
'\x02YO'
'\x02YN'
'\x04SLUR'
'\x11OURTEEN FULL STOP'
'\x02YE'
'\nIDDLE MARK'
'\nUNCIA SIGN'
'\x0bOUBLE ARROW'
'\x02YU'
'\x02YT'
'\x0bIGGLY FENCE'
'\x06DIESIS'
'\x08HEG SHAD'
'\x06OBELUS'
'\x04IGH '
' TOP-LIGHTED RIGHTWARDS ARROWHEAD'
'\x04IGHT'
'\nDA PLUS HA'
'\x0c OVER KISIM5'
'\x0bIN TRIANGLE'
'$OR LOWER RIGHT CURLY BRACKET SECTION'
'\x08L-LAKUNA'
'\x06UUMISH'
'\x03BHA'
'\x02Y '
'\x0cDENTAL CLICK'
'\rSIGN AVAGRAHA'
'\x07GOLIAN '
'\x15-ROUND NOTEHEAD DOWN '
'\x0bGREEK CROSS'
'\x05UTE A'
'\x07 KEFULA'
'\x08UP LIGHT'
'\x05DIAN '
'\nLINDRICITY'
'\nSSANGARAEA'
'\x04ONOS'
'\x06BOTTOM'
'\x08KOUFISMA'
'\x04ONON'
'\x0bULAR BULLET'
'\tDAD WITH '
'\x08VISARGA '
'\x0fHREE DOTS ABOVE'
'\x030 U'
'\x05 MEGA'
'\nEUR-DE-LIS'
'\x17WESTERN PWO KAREN TONE-'
'\x07QUARIUS'
'\x05SCAPE'
'\x03LPA'
'\x19TAB OVER TAB GAR OVER GAR'
'\x04LETE'
'\x04LETH'
'\x05RANUS'
'\x0bRAVE ACCENT'
'\x04ARA '
'\x06MUCAAD'
'\tLARGEMENT'
'\x04ROSS'
'\x05TUEUM'
'\x16DOUBLE SOLIDUS OVERLAY'
'\x04GLE '
'\x06APITAL'
'\x05QUIRY'
'\x0fBJOINED LETTER '
'\x0cKHMIMIC KHEI'
'\x05LENIS'
'\x07LOSING '
'\x02NI'
'\x06AESURA'
'\x07RAKHANG'
'\nTERMINATOR'
'\x1cHADED WHITE RIGHTWARDS ARROW'
'\x08MALL AXE'
'\x08ETA SIGN'
'\x13C DIGRAPH WITH CURL'
'\x0cRIGHT SINGLE'
'\x04NION'
'\x07ROGRESS'
'\x05EEM I'
'\tNO TELEIA'
'\x03ZJE'
'\x0bN THE VERGE'
'\nVE HUNDRED'
'\x0bOUBLE DANDA'
'\x0b2 PLUS GIR2'
'\x05BINDI'
'\x07STROKE '
'\r-OR-PLUS SIGN'
'\x0eJOINED SQUARES'
'\x07AS SIGN'
'\nRUPEE SIGN'
'\x1fUPWARDS HARPOON WITH BARB RIGHT'
'\x08 CURRENT'
'\x0c LINE SYMBOL'
'\x07AME DOT'
'\x07PALLAWA'
'\x1eHIGH-REVERSED-9 QUOTATION MARK'
'\rVOWEL SIGN PA'
'\x11HORIZONTAL DOUBLE'
'\x05SHEYE'
'\x14 WITH FATHATAN ABOVE'
'\rONG RIGHT LEG'
'\x05COMMA'
'\x0cIRAGANA HOKA'
'\x14CONSONANT SIGN HAARU'
'\x06SHAYIM'
'\x0c WITH STROKE'
'\x0eCENTURIAL SIGN'
'\x0cFERENCE MARK'
'\x03TO '
'\x15INVERTED GLOTTAL STOP'
'\x05RIGHT'
'\nCTION MARK'
'\x12LEFT-STEM TONE BAR'
'\x0bERCENT SIGN'
'\x07HIN DOT'
'\x08OVER SAG'
'\nBROKEN BAR'
'\x04LACK'
'\x06OINTER'
'\x0fSTROKE NOT SIGN'
'\x06YGISMA'
'\x04OFT '
'\x07ACTION '
'\x0cMUM TIMES PA'
'\x04SONG'
'\x07PERSAND'
'\x07VANESE '
'\x07CANDRA '
'\x08OVERLINE'
'\x07SERTION'
'\x0cRION CHRONON'
'\nROAD OMEGA'
'\x04MIIN'
'\x05MACUS'
'\x08CLOSED T'
'\x10LEFT ARROW ABOVE'
'\x0cGAW KAREN EU'
'\x04EVMA'
'\x04DOT '
'\x06WEORTH'
'\x0cANG KHANG GY'
'\x05TEGEH'
'\x01S'
'\x17ALEF MAKSURA FINAL FORM'
'\x06DRAGON'
'\x04ROAR'
'\x14ALF TRIANGULAR COLON'
'\tBO BAIMAI'
'\x08PLUS SAR'
'\x03RAM'
'\x06UPPER '
'\x03UMX'
'\x04LAKE'
'\x0fXTEEN FULL STOP'
'\x06CHURCH'
'\x03OLD'
'\x03OLE'
'\x03IKU'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x03OLL'
'\x0c WITH CIRCLE'
'\tWITH HOOK'
'\x05KNIFE'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x08LF RING '
'\x06PECIAL'
'\x13ICTLY EQUIVALENT TO'
'\x18T BLACK RIGHTWARDS ARROW'
'\nRUPEE MARK'
'\rDOUBLE MUCAAD'
'\x04IRED'
'\x07KORONIS'
'\x06CER-WA'
'\x10LOSED LITTLE YUS'
'\x0cINTEGRATION '
'\x05YURII'
'\x06INDHI '
'\tCHOSEONG '
'\tNK SYMBOL'
'\x04CYCL'
'\x07REREKAN'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x05SION '
'\x08ETARTOS '
'\x03GAY'
'\x07REAT SA'
'\x03GAR'
'\x03SOO'
'\x03SON'
'\x03 FA'
'\x03GAL'
'\x03GAG'
'\x12NORMAL SUBGROUP OF'
'\x03GAD'
'\nRIGHTWARDS'
'\x03SO '
'\x08IRA SIGN'
'\x07BOURING'
'\nEBENSTIMME'
'\rNUMERATOR ONE'
'\rMESSENIAN TEN'
'\x13HURISAZ THURS THORN'
'\x08NUMERAL '
'\nSHOE STILE'
'\x05DELTA'
'\x1fIN WHITE CIRCLE IN BLACK SQUARE'
'\x05GAMAN'
'\rHERICAL ANGLE'
'\x05GAMAL'
'\x12SMALL CIRCLE ABOVE'
'\x04JOT '
'\x0cPALATAL HOOK'
'\x06EVENTH'
'\x08IR SPACE'
'\nDIRGA MURE'
'\x05QATAN'
'\x06EVENTY'
'\tAISED DOT'
'\x08 NUTILLU'
'\x0bDOACHASHMEE'
'\tKABA TENU'
'\x07PAYEROK'
'\x07BRACKET'
'\x0bON PEDESTAL'
'\x07A -PHRU'
'\x04ARGI'
'\x05DIAL '
'\x04ARGA'
'\x0cGEBA KAREN I'
'\x04KING'
'\x05ICHON'
'\x03OSS'
'\x04ONAP'
'\x07T MINUS'
'\x05INGSA'
'\x05ICHOS'
'\x05MEEMU'
'\x10 AND LOWER RIGHT'
'\tGRIK SIGN'
'\x05WAAVU'
'\x05MEEM '
'\x10BBREVIATION MARK'
'\x0eTETARTOS ICHOS'
'\x07DEAVOUR'
'\x04ONA '
'\x05ALEF '
'\r WITHOUT SNOW'
'\x04D HA'
'\x05TSADI'
'\x10LEFT HALF CIRCLE'
'\x0bGENTLE WIND'
'>DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR'
'\x0eEPSILON SYMBOL'
'\x16LEFT TRIANGLE OPERATOR'
'\x1bPHARYNGEAL VOICED FRICATIVE'
'\x08ECTANGLE'
'\x0bTENS DIGIT '
'\x04GRAL'
'\nME PLUS DA'
'\x05SCENT'
'\rSAL PLUS TUG2'
'\x05IDGE '
'\x04HIIN'
'\x0eEND OF SECTION'
'\x0bCELANDIC-YR'
'\x04OUT '
'\n TIMES KUR'
'\x04ABLE'
'\x0bMOST EQUAL '
'\x06-HIEUH'
'\x05BHETH'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\x1aIANGLE BESIDE VERTICAL BAR'
'\x03ZHA'
'\x0fAL INTERSECTION'
'\x0cING OPERATOR'
'\x10DITORIAL CORONIS'
'\x0fENCH FRANC SIGN'
'\x0fBELOW LONG DASH'
'\x11OPEN-HEADED ARROW'
'\x081 HELMET'
'\x05DATUS'
'\x0240'
'\x17DOT BELOW AND DOT ABOVE'
'\nFINAL FORM'
'\x06UDATTA'
'\x05QAAFU'
'\x024D'
'\x024E'
'\x024B'
'\x07CURVED '
'\x04ANCH'
'\rUFFLE PRODUCT'
'\x04DAL '
'\tTANDSTILL'
'\x0fSEMIVOWEL SIGN '
'\x05UBUTS'
'\x04LIFI'
'\x07NYI ZLA'
'\x04LIFU'
'\x05ERN W'
'\x17RAISED OMISSION BRACKET'
'\x05AMOND'
'\x02G3'
'\x02G2'
'\x06UYANNA'
'\x02G0'
'\x02G9'
'\x02G '
'\x03CES'
'\x03SIX'
'\x02GS'
'\x02GR'
'\x1bZERO FOR ODD POWERS OF FOUR'
'\x02GG'
'\x02GE'
'\x02GB'
'\x02GA'
'\x02GO'
'\x02GN'
'\x02GI'
'\x05YIZET'
'\x0fBINDING BRACKET'
'\x0b-FEATHERED '
'\x0cDIGRAPH KOTO'
'\x04LAAN'
'\x05AVROS'
'\x05NGMAN'
'\n NOTATION '
'\x0cKAPPA SYMBOL'
'\x06F MARE'
'\x02Z0'
'\x02Z2'
'\x10IMENSIONAL ANGLE'
'\x02ZO'
'\x02ZH'
'\x02ZI'
'\x07OSITION'
'\x02ZE'
'\x02ZA'
'\x0eYOUTHFUL FOLLY'
'\tHALSHELET'
'\x04GIT '
'\x0bBUMPY ABOVE'
'\x11TERSYLLABIC TSHEG'
'\x0f PARESTIGMENON '
'\x10 OR THE IMAGE OF'
'\x04TOP '
'\nUT NOT EQU'
'\x04 OHM'
'\x05CHED '
'\x08NI ABOVE'
'\x11QUAT REVERSED ESH'
'\r WITH TEE TOP'
'\x14SEPARATOR KEY SYMBOL'
'\x0bLATIN CROSS'
'\tLEFT HALF'
'\x16MNYAM YIG GI MGO RGYAN'
'\x0eWITH FATHATAN '
'\nHAN DIGIT '
'\x16TRIPLE RIGHT TURNSTILE'
'\x06CHIRET'
'\n WITH BASE'
'\x0bUNCTUATION '
'\x06ANCHOR'
'\x07PRICORN'
'\rAWELLEMET YAZ'
'\t PLUS ASH'
'\x05NGLE '
'\x0bTHEMATICAL '
'\x13C LESS-THAN BRACKET'
'\x04ATER'
'\x0bSTORIC SITE'
'\x06HIEUTH'
'\x05JANG '
'\x14SCRIPTION CHARACTER '
'\x0bCONTAIN AS '
'\x04WTIE'
'\x1b DIVIDED BY HORIZONTAL RULE'
'\x03UKY'
'\x12OTLESS DALATH RISH'
'\x07URATION'
'\tHIMA SIMA'
'\x03ONG'
'\x03ONE'
'\tKU RU KHA'
'\x10HIGH SPACING DOT'
'\x07LLOWING'
'\x04FORK'
'\x04IMES'
'\x03ON '
'\x03U U'
'\x04FORE'
'\rMULTIOCULAR O'
'\x04IMEL'
'\x08STERISK '
'\x05ALF H'
'\x05DKAR '
'\x11EAR SCREEN SYMBOL'
'\x07ASES AS'
'\x0cREVERSE MARK'
'\x0f OPERATOR WITH '
'\x0c-DZUD RTAGS '
'\x16TWO HORIZONTAL STROKES'
'\x13VERTICAL TABULATION'
'\x03CH '
'\x0cIRST SUBUNIT'
'\x03SAM'
'\x03SAL'
'\x06UBLE X'
'\x03SAG'
'\x03 HU'
'\x04DGER'
'\x03 HE'
'\x03SAT'
'\x03CHA'
'\rL-TYPE SYMBOL'
'\x03CHE'
'\x03CHI'
'\x14RIGHT-POINTING ANGLE'
'\x05IKEUT'
'\x0eTHAKA ANUDATTA'
'\x15AKIA TELOUS ICHIMATOS'
'\x04HORN'
'\x04 RHO'
'\x05OKARA'
'\x03MUG'
'\x10HEAVY AND RIGHT '
'\x0bND TWO DOTS'
'\x07OVER U '
'\x05EMALE'
'\x05HANGE'
'\x06SYOUWA'
'\x14BSET OF NOR EQUAL TO'
'\x0fUGMENTATION DOT'
'\x03QOT'
'\x03QOF'
'\x04OBAT'
'\x1fRIANGLE-HEADED RIGHTWARDS ARROW'
'\nANGULAR TO'
'\x01W'
'\x040 NI'
'\x07DAYANNA'
'\x0bGAYANUKITTA'
'\x08NG BELOW'
'\x045 WE'
'\x05ARET '
'\tANEROSIS '
'\x04YODH'
'\x0fNOT TILDE ABOVE'
'\x04MASH'
'\x03NUN'
'\x0bRISING TONE'
'\x08WO DOTS '
'\x07TALL AA'
'\x05CAANG'
'\x03EUX'
'\x04WAIR'
'\x0eSMALL LETTER J'
'\x14LIQUE ANGLE OPENING '
'\x07PEGERMA'
'\x0bGHAIN WITH '
'\x1dSIBE SYLLABLE BOUNDARY MARKER'
'\x0eAU LENGTH MARK'
'\x04WYNN'
'\x050 DWO'
'\x11KHAH INITIAL FORM'
'\x08IN WITH '
'\x05 GUNU'
'\x05ATIN '
'\x1fETALLED OUTLINED BLACK FLORETTE'
'\x08ULLS LEG'
'\x01-'
'\x04CHWA'
'\x12FIVE EIGHTHS BLOCK'
'\x0f DEYTEROU ICHOU'
'\x0fLEVEL TONE MARK'
'\tEAVY DOWN'
'\x03CWI'
'\x05TWEEL'
'\x03CWA'
'\x15OREAN STANDARD SYMBOL'
'\x061 GOLD'
'\tURAMAZDAA'
'\x05CAUDA'
'\x01R'
'\rSEVEN EIGHTHS'
'\x047 ZA'
'\tNVERTED M'
'\x07VESTAN '
'\x04ENTH'
'\x06DERBAR'
'\x04ANA '
'\x04ENTY'
'\x05L TAG'
'\tNVERTED R'
'\tONE MARK-'
'\x0eAILLE PATTERN '
'\x12ODD POWERS OF FOUR'
'\x08HARPOON '
'\x04SIGN'
'\x03WER'
'\x06IRINGU'
'\x04ANAP'
'\x08 PLUS LU'
'\x05WITH '
'\x0fEH INITIAL FORM'
'\x06TAKANA'
'\x07ROKEN L'
'\x05HADDA'
'\x08 PLUS LA'
'\x14GHTWARDS ARROW BELOW'
'\x10RIGHT DOWN BARB '
'\x05UBURU'
'\x05MI RO'
'"NTICLOCKWISE-ROTATED DIVISION SIGN'
'\x04QOPA'
'\x04RGON'
'\x04IRTY'
'\x17GREEK SMALL LETTER IOTA'
'\x10ENUMERATION SIGN'
'\x14REVERSED ONE HUNDRED'
'\x07BE ROOT'
'\x04TUKI'
'\tRTER NOTE'
'\x06N DASH'
'"TEARDROP-SPOKED PROPELLER ASTERISK'
'\x06KAYAH '
'\x04LOVO'
'\x18RMITIAN CONJUGATE MATRIX'
'\rQUESTION MARK'
'\x05YANNA'
'\nRED DRAGON'
'\tCRESCENDO'
'\x1eCONTAINING BLACK SMALL DIAMOND'
'\tPANYANGGA'
'\x04NGA2'
'\x15SHORT LEFTWARDS ARROW'
'\n7 PLASTICS'
'\x05CEREK'
'\x06URNED '
'\x1b-FEATHERED RIGHTWARDS ARROW'
'\x05AINS '
'\x04WER '
'\x031 O'
'\x05RUSH '
'\x049 PI'
'\r GAR OVER GAR'
'\x04RPSE'
'\x08LUS SIGN'
'#BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD'
'\nE PLUS SUM'
'\x0bMEDIAL FORM'
'\x08IDEWAYS '
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x05ATAF '
'\x0cFIVE HUNDRED'
'\x05KO LA'
'\rEFTWARDS TICK'
'\x06EATHER'
'\x18EQUAL TO OR GREATER-THAN'
'\x0fYIG MGO MDUN MA'
'\x05BELOW'
'\x04TACK'
'\x08SS-THAN '
'\x08ESCENDER'
'\rHINESE TONE Y'
'\x0bAPPROXIMATE'
'\x08NITIAL Z'
'\x04RKLE'
'\x0fRIGHT TURNSTILE'
'\x0bURNED COMMA'
'\x03IOS'
'\x13SH PLUS HU PLUS ASH'
'\x03ION'
'\x07SH TAIL'
'\x01D'
'\x05WIDE '
'\tDELIMITER'
'\x19TERNION INTEGRAL OPERATOR'
'\x14YIG MGO PHUR SHAD MA'
'\x04STLE'
'\nIKRON ISON'
'\tRPORATION'
'\x0255'
'\x0256'
'\x0250'
'\x0253'
'\x10OETIC VERSE SIGN'
'\tOP HALF O'
'\tIRST MARK'
'\x02HZ'
'\x07TH MARK'
'\x02HV'
'\x02HW'
'\x02HU'
'\x02HI'
'\x02HO'
'\x0eIGHTWARDS TICK'
'\x02HM'
'\x02HA'
'\x02HE'
'\x04ESH2'
'\x04HOKE'
'\x0bHITE DRAGON'
'\tB DIGRAPH'
'\x0bFINAL SIGMA'
'\x0cCENDING NODE'
'\x06NDA TA'
'\nINVERTED V'
'\x0cSAZ IS ISS I'
'\x08ESH LOOP'
'\x08QUARTERS'
'\x06TEDUNG'
'\x04KAUN'
'\x05HREAD'
'\x05INITY'
'\x02H '
'\tORINHIEUH'
'\x08SANGSIOS'
'\x05RATER'
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x07PPROACH'
'\r HEADED ARROW'
'\x05SICLE'
'\x03AD3'
'\x06MEEM I'
'\x10MIDDLE AND BELOW'
'\x13VARIANT WITH SQUARE'
'\rSMALL LETTER '
'\x03ADU'
'\x08AR TSHES'
'\x03ADE'
'\x06 PLUS '
'\x0bZERO THIRDS'
'\x06WN BOX'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x0cMETA STAVROU'
'\x08MAKSURA '
'\x07 LONSUM'
'\x04TIKI'
'\x15VOICED ITERATION MARK'
'\x03BRA'
'\tPOINTING '
'\x06GHUNNA'
'\x05ELMET'
'\x19HREE DOTS ABOVE DOWNWARDS'
'\tOVER ASH '
'\x03VER'
'\tPADE SUIT'
'\x12HOUSANDS SEPARATOR'
'\t GARSHUNI'
'\nRIGHT HALF'
'\x03ESS'
'\x04ARK '
'\x06HEAVEN'
'\x03ESC'
'\x07QUARTER'
'\x03ESI'
'\x03ESH'
'%ONCAVE-POINTED BLACK RIGHTWARDS ARROW'
'\x04ROUT'
'\x05RASHA'
'\tSYNTHETON'
'\rDOTTED ZLAMA '
'\x19RANCH BANK IDENTIFICATION'
'\x05IRCLE'
'\x1bEMICIRCULAR CLOCKWISE ARROW'
'\rI LENGTH MARK'
'\x0cMPHASIS MARK'
'\x04ONE '
'\x07TLINED '
'\x04ONE-'
'\x08WON SIGN'
'\x08MEASURE '
'\x05SARGA'
'\x05ERSON'
'\x06SKAPI '
'\tLLAR SIGN'
'\x04ONEK'
'\nTWO THIRDS'
'\x06ACCENT'
'\x08IMANSIS '
'\x0bTRUNCATED A'
'\x05JEEM '
'\x07OVERBAR'
'\x0fEFTWARDS ARROWS'
'\x19INVERTED EXCLAMATION MARK'
'\x06-IEUNG'
'\t DRACHMAS'
'\tLEFT TACK'
'\nSIXTEENTHS'
'\x05CALYA'
'\x06EN BOX'
'\x08CIRCLED '
'\rDOUBLE HYPHEN'
'\rCRIPTIONAL PA'
'\x07 WITH S'
'\x0cFEMININE DOT'
'\x06KUSHU2'
'\x07 WITH D'
'\x18STROKE THROUGH DESCENDER'
'\x036-0'
'\x05 DOTS'
'\tYANUKITTA'
' TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0eGERED TREMOLO-'
'\x0bEXCLAMATION'
'\x07CHU CAN'
'\rALEF MAKSURA '
'\x07VALENT '
'\x11 TO BLACK DIAMOND'
'\tSEPARATOR'
'\x05HALF '
'\tTO-RIGHT '
'\x0bRIGHT-HAND '
'\tRTER MARK'
'\x0eALF TREE TRUNK'
'\x07DIPLOUN'
'\x08ORNAMENT'
'\tFRACTION '
'\x08FLOURISH'
'\x04GAN2'
'\x011'
'\x06 ENTRY'
'\nNAASIKYAYA'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\nAB2 TIMES '
'\x1bENTATION FORM FOR VERTICAL '
'\x04MLYA'
'\x04REST'
'\nHREE DOTS '
'\x04MUOY'
'\tARISTERA '
'\x06OOMUUT'
'\nHEADSTROKE'
'\x07SUCCEED'
'\x1dSUPERSCRIPT ALEF INITIAL FORM'
'\x0cIDDLE-WELSH '
'\tG IN HOLE'
'\t WITH DOT'
'\x08CE SKATE'
'\x08RAM FOR '
'\tCURRENCY '
'\x04ULUG'
'\rVERTICAL FILL'
'\x0eOUR OBOLS SIGN'
'\x03THA'
'\x0fMAL SUBGROUP OF'
'\x04ULU '
'\x05F COW'
'\x08RK SHADE'
'\x19DOUBLE CANDRABINDU VIRAMA'
'\x0fEATER-THAN SIGN'
'\x06HIEUPH'
'\x05NIGHT'
'\x0cCROSSING GI4'
'\x04VEDE'
'\nUM ROTUNDA'
'\x08IGHT OF '
'\x03NIG'
'\x07OGDIAN '
'\x08MOUNTAIN'
'\rCHROMA SYNAFI'
'\x10 ON BLACK SQUARE'
'\x12PERFIXED LETTER RA'
'\x16TORTOISE SHELL BRACKET'
'\x1cFTING POINT RIGHTWARDS ARROW'
'\rNTY FULL STOP'
'\x05EIGHT'
'\x06 RIGHT'
'\x03END'
'\x03ENG'
'\x06HAM AI'
'\x1dEVERSED LUNATE EPSILON SYMBOL'
'\x03ENT'
'\x03ENU'
'\x05IYEOK'
'\x04RROW'
'\x03F14'
'\x0cUPPER CORNER'
'\x05GIMEL'
'\x05OTHES'
'\x11PUNCTUATION SIGN '
'\x0eTWO WHITE DOTS'
'\x08TICK IN '
'\x0e CROSSING GABA'
'\x0fVOWEL SEPARATOR'
'\x03SET'
'\x17ORIGINAL OF OR EQUAL TO'
'\x03IM5'
'\tKEMPHRENG'
'\nEDIAL FORM'
'\x03IMA'
'\x03IME'
'\nRAGGISMATA'
'\x08LOGICAL '
'\x03SE '
'\x044 TE'
'\x05MANNA'
'\x04ILUY'
'\x06EAHMUK'
'\x07BESIDE '
'\x1bDOTTED INTERPOLATION MARKER'
'%RIGHT TORTOISE SHELL BRACKET ORNAMENT'
'\tCAPITAL Q'
'\tCAPITAL L'
'\tCAPITAL D'
'\tCAPITAL F'
'\x1dDOWN HEAVY AND RIGHT UP LIGHT'
'\nETA SYMBOL'
'\x03GOU'
'\x03AY '
'\nSSANGPIEUP'
'\x0bXAGRAM FOR '
'\x0fDIAGONAL STROKE'
'\x05SAMPI'
'\x10OUR POINTED STAR'
'\x06ORTION'
')NT-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x08NAVIYANI'
'\x0fSHORT OVER LONG'
'\x03ADA'
'\x05D OF '
'\x10B2 TENU PLUS TAB'
'\x0eRIGHT TRIANGLE'
'\x0fCLOSED BY CURVE'
'\x06OUBLE '
'\x14HADOWED WHITE SQUARE'
'\x04ARIA'
'\x08AST WIND'
'\x05DESTY'
'\x13VARIANT FORM ILIMMU'
'\x01H'
'\x03EQU'
'\x0cINITIAL FORM'
'\x04ADDA'
'\x05SHED '
'\x08MEM-QOPH'
'\x04IANO'
'\x06ORONIS'
'\x08IGI GUNU'
'\x0fOLIDUS OPERATOR'
'\x083 ARMOUR'
'\x0bMIDDLE STEM'
'\x10ISTOS DISC SIGN '
'\x04ONG '
'\rMINUS SIMILAR'
'\x0cKHAMTI TONE-'
'\x07CHIEUCH'
'\x04ONGA'
'\x0eTHREE QUARTERS'
'\x05 ADEG'
'\nTYPE COLON'
'\x13IMIDIA SEXTULA SIGN'
'\tIGHT DOWN'
'\x0229'
'\x06PHRASE'
'\x07ETNAHTA'
'\rWO-LINE STAFF'
'\tD SALTIRE'
'\x04MMU2'
'\x06 QATAN'
'\nRAINIAN IE'
'\tZENE RING'
'\x0fSHITA PLUS GISH'
'\x03WAI'
'\nIDEOGRAPH '
'\x03WAA'
'\x03WAZ'
'\x03WAW'
'\x03WAU'
'\rPERFECTA REST'
'\x04SIKI'
'\x19DIAERESIS AND HOOK SYMBOL'
'\x08SLANTED '
'\x04HAR2'
'\x04UON '
'\x04CUTE'
'\x036D7'
'\x0bOT OPERATOR'
'\x12FACING SVASTI SIGN'
'\x02I0'
'\x08HAGALL H'
'\x04SED '
'\x05SASA '
'\x02I '
'\x02IX'
'\x0fORIZONTAL COLON'
'\x02IP'
'\x02IS'
'\x02IR'
'\x02IT'
'\x0cRING OVERLAY'
'\x02II'
'\x02IH'
'\x02IJ'
'\x02IM'
'\x02IL'
'\x02IN'
'\x02IA'
'\x02IC'
'\x02IE'
'\x02ID'
'\x02IG'
'\x0fGH VOLTAGE SIGN'
'\x13ARTIAL DIFFERENTIAL'
'\x04AME '
'\x04ZATA'
'\x05RACHY'
'\x0bGSUM -KHYIL'
'\t OPERATOR'
'\x0eUSPENSION MARK'
'\x05ACUTE'
'\tZERO SIGN'
'\x18INTERSECTION WITH SERIFS'
'\x12 AND YPOGEGRAMMENI'
'\x0eQUINARIUS SIGN'
'\x0c ON PEDESTAL'
'\x17OVER RIGHTWARDS HARPOON'
'\x06NTIIMU'
'\x0bPERISPOMENI'
'\x08OVER BU '
'\x04MUM '
'\tRISPOMENI'
'\x18 OVER TOP SQUARE BRACKET'
'\x07ALOCHKA'
'\x05UKARA'
'\x049 TU'
'\x049 TA'
'\x0fWHITE DOT RIGHT'
'\rGHT ARROWHEAD'
'\x10-BREAKING HYPHEN'
'\nLEK ATTAK '
'\x05UBLE '
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x05CARET'
'\x06U MARK'
'\x10MIDDLE AND RIGHT'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\x06ERESIS'
'\x05KERET'
'\x05ZILDE'
'\x0cCROSSING NUN'
'\tARCHAIC M'
'\x03TRI'
'\x04PII '
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\x15CTOR OR CROSS PRODUCT'
'\nLEFT HEAVY'
'\x040 WI'
'\x0bNWHEEL STAR'
'\x16TRIPLE VERTICAL STROKE'
'\x05QUARE'
'\x1aJECT REPLACEMENT CHARACTER'
'\rISOLATED FORM'
'\x06TY SET'
'\tVELOPMENT'
'\x11CANCELLATION MARK'
'\x0c DIMINUTION-'
'\x08TURNED M'
'\x03LE '
'\x06CANDRA'
'\tR PLUS RA'
'\x10OMPLETE INFINITY'
'\x05TKAAN'
'\x08OHM SIGN'
'\x06RUPEE '
'\x04URUS'
'\x05ZHAIN'
'\x03UEH'
'\x0b-MINUS SIGN'
'\x03RD '
'\rLEFT TRIANGLE'
'\nMILLE SIGN'
'\x0cENARIUS SIGN'
'\tVANAGARI '
'\x03ELL'
'\x03ELF'
'\x03ELD'
'\nQUALS SIGN'
'\x0fBAR ABOVE UNION'
'\x03ELS'
'\x03ELT'
'\x03LEF'
'\tUTER JOIN'
'\x11RIGHT PARENTHESIS'
'\x05VAAVU'
'\x11RIATION SELECTOR-'
'\x1cISMILLAH AR-RAHMAN AR-RAHEEM'
'\x05RIAC '
'\x05 SARI'
'\x16IGEL LONG-BRANCH-SOL S'
'\tLEFT AND '
'\x08EMICOLON'
'\tHALF RING'
'\x05HREE '
'\x0b WITH TITLO'
'\n PLUS SHU2'
'\x04ASH2'
'\x13OUR DOT PUNCTUATION'
'\x07HAYANNA'
'\x11IGHTEEN FULL STOP'
'\x0cRANCHING OUT'
'\x05HAINU'
'\x015'
'\x0fDOWNWARDS ARROW'
'\x03ICE'
'\x07 STRIDE'
'\x05LAGUS'
'\x08EH WITH '
'\nEUTRAL YER'
'\x08OO TYPE '
'\x0eREE-LINE STAFF'
'\x04THOR'
'\x05O PLA'
'\x03AH '
'\x04PRIL'
'\x0eVERTICAL COLON'
'\x15ARKENING OF THE LIGHT'
'\x06N YANG'
'\x045 MO'
'\x04MEN '
'\x07TALENTS'
'\x1f-HEADED ARROW FROM SMALL CIRCLE'
'\x03GIR'
'\x07RCHAION'
'\x07RILLIC '
'\x05YPHEN'
'\x04MENT'
'\x0bASHED ARROW'
'\x0cF TREE TRUNK'
'\x07EAVY YA'
'\x0fORT EQUALS SIGN'
'\x10IRCLE X NOTEHEAD'
'\tPLUS SIGN'
'\x10NORTH EAST ARROW'
'\x06F CLEF'
'\x08NOVEMBER'
'\x08ARKENING'
'\x08RAUGHTS '
'\x08POSITION'
'\x04ARON'
'\x04POSE'
'\x07TIVATE '
'\x10IVE POINTED STAR'
'\x06OBELOS'
'\x08OTIFIED '
'\x06LATIN '
'\x0bHOOK SYMBOL'
'\x07ARDROP-'
'\tCHAVIYANI'
'\x08TAL MARK'
'\tYEH WITH '
'\x0bCUTE ACCENT'
'\t247 DIPTE'
'\x05UNOO '
'\tNUSVARAYA'
'\x0bHREE BALUDA'
'\x03SHE'
'\rMELODIC QITSA'
'\x07FORKING'
'\x14RUMAI PALAUNG TONE-5'
'\x06ANGKAT'
'\x04BEND'
'\x047 TI'
'\tITTLE YUS'
'\x0e WITH LONG LEG'
'\x05BASSA'
'\x03YIN'
'\x14TOP SEMICIRCLE ARROW'
'\x10PRECEDING SUBSET'
'\tAGOLITIC '
'\nRNING SIGN'
'\rERTION SYMBOL'
'\x0bLT OF CLOTH'
'\x07DRIL BU'
'\x16WITH JEEM INITIAL FORM'
'\x0fALMOST EQUAL TO'
'\x05YEROK'
'\x044 KE'
'\x05ERKHA'
'\x0bIMEL SYMBOL'
'\x0e HASER FOR VAV'
'\x17IDE ARC CLOCKWISE ARROW'
'\x15LETTER SMALL CAPITAL '
'\x05EMLJA'
'\x08LOW TONE'
'\x0eSHAN MEDIAL WA'
'\x16DOUBLE VERTICAL STROKE'
'\rPLUS OPERATOR'
'\nQUISH QUAD'
'\x04QAPH'
'\x07PRODUCT'
'\x0bSANS-SERIF '
'\x14CURRENCY SYMBOL RIEL'
'\x05QITSA'
'\x07ENTAGON'
'\x04LING'
'\x0cTRAGRAM FOR '
'\x04LINE'
'\x04NET '
'\x10RECORD SEPARATOR'
'\x04VIDA'
'\x06IFTEEN'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\x04VIDE'
'\x0cIDEOGRAPHIC '
'\x11AMPHYLIAN DIGAMMA'
'\x01L'
'\x06UP BOW'
'\x06NIRUGU'
'\x06LONG E'
'\x04EETA'
'\nON MEDIAL '
'\x0bANNOTATION '
'\x0eDOES NOT EXIST'
'\x07CKWISE '
'\x03LUE'
'\x12LOSED CIRCLE ARROW'
'\x0bLTERNATE YA'
'\x03LUG'
'\n BACKSLASH'
'\tSOF PASUQ'
'\nD OF PROOF'
'\x06AGE OF'
'\x04GORT'
'\x08VERTICAL'
'\x0bUSTRAL SIGN'
'\x14AND SOUTH EAST ARROW'
'\x10 AND HEAVY RIGHT'
'\x10CORNER LEFTWARDS'
'\x04GORG'
'\x0fPRISHTHAMATRA E'
'\x05-SIOS'
'\x0fRECEPTIVE EARTH'
'\x07ONE BAR'
'\x07ONG LEG'
'\nUTION SIGN'
'\x07ECEMBER'
'\x07RESSION'
'\x06SYMBOL'
'\x10 TIMES GAN2 TENU'
'\x13VARIATION INDICATOR'
'\x13ANSPOSITION BRACKET'
'\x0fITH FINGERNAILS'
'\x0eUNIT SEPARATOR'
'\tILIPPINE '
'\x08DIFONIAS'
'\x17ARC ANTICLOCKWISE ARROW'
'\x07PANSIOS'
'\x03TLE'
'\r-ESASA DOTTED'
'\x05EAST '
'\tPERSET OF'
'\x06KE PHO'
'\x05GALGA'
'\x08ATE MARK'
'\x15YMPTOTICALLY EQUAL TO'
'\x08M BRANCH'
'\x02XI'
'\rFTWARDS ARROW'
'\x08VERGENCE'
'\x0fHORIZONTAL FILL'
'\x05PEPET'
'\tNOTEHEAD '
'\x1cDOWN HEAVY AND LEFT UP LIGHT'
'\x07USSYERU'
'\x0eLINE EXTENSION'
'\x0cCANDRA BELOW'
'\nHITE ARROW'
'\x0bMUNCIA SIGN'
'\x0bJOYOUS LAKE'
'\x07-INDIC '
'\x04NTOC'
'\x06INCUNX'
'\x02XE'
'\x0279'
'\x0bBOTTOM MARK'
'\x05RONIS'
'\x0bJIHVAMULIYA'
'\x0eOUR DOTS ABOVE'
'\x1aORTHOGONAL CROSSHATCH FILL'
'\x0fODIFIER LETTER '
'\x03DZE'
'\x06 TONE-'
'\x13IN CHEN SPUNGS SHAD'
'\x08GENITIVE'
'\x06URTEEN'
'\x02JA'
'\x07OKRYTIE'
'\x02BA'
'\x15MALE WITH STROKE SIGN'
'\x06GLAZ H'
'\x03IAL'
'\nLENDED YUS'
'\tMODYNAMIC'
'\x05LLEL '
'\x05EGALI'
'\x0eAI LENGTH MARK'
'\x03PHI'
'\x03PHA'
'\x18YZANTINE MUSICAL SYMBOL '
'\x07OWILO S'
'\rMASORA CIRCLE'
'\x05SHORT'
'\x02BR'
'\x05TTER '
'\x13ARABIC FORM SHAPING'
'\x07 MENDUT'
'\x05-ALAF'
'\x0cTHETA SYMBOL'
'\x03AN2'
'\x08CHEIKHEI'
'\x04UT H'
'\x1bLESS-THAN ABOVE EQUALS SIGN'
'\x0bX DRAWINGS '
'\x05ENDEP'
'\x05AMBOO'
'\x1a LESS THAN THE DENOMINATOR'
'\x07KHIEUKH'
'\x07STRUCK '
'\t PLUS LAL'
'\rITING THROUGH'
'\x03AND'
'\x03ANG'
'\rU WITH STROKE'
'\x03ANA'
'\x05HIRIQ'
'\x03ANO'
'\x10 INSERTION POINT'
'\x10WITH CENTRED DOT'
'\x04NSUB'
'\x0cANTARGOMUKHA'
'\x0fTVIMADUR SYMBOL'
'\x0cLINGING FIRE'
'\x03WAN'
'\x06 AGUNG'
'\x10QUALS SIGN BELOW'
'\x15INTERSECTING LOGICAL '
'\x07NUBIAN '
'\x0bSINGLE AND '
'\x07WO MARK'
'\x04PAWN'
'\x14FORMS LIGHT VERTICAL'
'\tLACKFOOT '
'\rOMAN NUMERAL '
'\x04WAAK'
'\x18LEFT DIAGONAL HALF BLACK'
'\x08LORRAINE'
'\x05 DEKA'
'\x06A HAAM'
'\x05NSYON'
'\x05CHOOL'
'\x05 KAWI'
'\x1bCIRCLE WITH NORTHWEST ARROW'
'\tORIZONTAL'
'\tP DIGRAPH'
'\x06IYANNA'
'\x06O SIGN'
'\nRIGHT AND '
'\x11CTION APPLICATION'
'\x1aLINE FEED SEPARATOR SYMBOL'
'\x019'
'\x0fZAIN FINAL FORM'
'\x11NTED EQUAL TO OR '
'\x1a GAD OVER GAD GAR OVER GAR'
'\x04NDAP'
'\x03YOO'
'\x05CHADA'
'\x06ECEDES'
'\x05LACK '
'&AL WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x03YOD'
'\x07ER THAN'
'\x08ESS-THAN'
'\x03YOT'
'\x04SHU2'
'\nELT BUCKLE'
'\x06FATHA '
'\x06KRISIS'
'\x07POINTER'
'\nNOON WITH '
'\t AND TAIL'
'\x07SMANYA '
'\x08AIYANNOI'
'\x04HAVE'
'\nM STALLION'
'\x04YUKU'
'\x04RAEA'
'\x0b OVER IDIM '
'\x0eEVERSE SOLIDUS'
'\tBAR ABOVE'
'\x15BUT NOT EQUIVALENT TO'
'\rVE-LINE STAFF'
'\x04SIOS'
'\nUBLE DANDA'
'\x19MULTIPLICATION SIGN BELOW'
'\x04ZAIN'
'\tDIAGONAL '
'\x08LFWIDTH '
'\nLAGAR GUNU'
'\x0bCROSSING UR'
'\x11HIRTEEN FULL STOP'
'\x05OLONG'
'\x08ANS SIGN'
'\x02B6'
'\x07DHALATH'
'\x04PLE '
'\tTONE MAI '
'\tMALE SIGN'
'\x04SUKU'
'\x02B2'
'\x03ASH'
'\x0cMIDDLE PIECE'
'\x07INE OF '
'\x05ITING'
'\x0bOUBLE ACUTE'
'\x11PRECEDING SOLIDUS'
'\x0fLLING DIAGONAL '
'\x0f CORNER BRACKET'
'\x0cWN ARROWHEAD'
'\x05EARTH'
'\rNUMERIC SIGN '
'\x05NDRA '
'\x06-MINUS'
'\x0bIOR PRODUCT'
'\x06IGAMMA'
'\x04MUIN'
'\x02U2'
'\x0bRIPLE PRIME'
'\x0bMIDDLE HOOK'
'\x0cCIAN LETTER '
'\x05MAI K'
'\x04NGIA'
'\x16HORT HORIZONTAL STROKE'
'\x04REIA'
'\x06WHITE '
'\x04TAK4'
'\rRIPLE SVARITA'
'\x04NOT '
'\tAROSHTHI '
'\x0e AND SMALL TAH'
'\tMETOBELUS'
'\x06FIFTHS'
'\x15SHADOWED WHITE SQUARE'
'\x06QAMATS'
'\x08RINHIEUH'
'\x04ZELO'
'\x15ORTOISE SHELL BRACKET'
'\x0fNE EIGHTH BLOCK'
' VED STEM PARAGRAPH SIGN ORNAMENT'
'\tKSTREPTON'
'\x15OCAL NOTATION SYMBOL-'
'\x04NOTE'
'\nREVERSED I'
'\x03HHA'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x07OT SIGN'
'\x0bNUMBER ZERO'
'\x03LA3'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x04HEEP'
'\x07PARTURE'
'\x05YAMOK'
'\x03UAT'
'\x05HATHI'
'\x03EH '
'\x03UAN'
'\x03UAE'
'\x08VISION S'
'\x0fING SYMBOL FOR '
'\x0cAND OPERATOR'
'\x15TEEN POINTED ASTERISK'
'\x0bJECT SYMBOL'
'\x04MAN '
'\x01P'
'\x0b TACK BELOW'
'\x03EHI'
'\x03LAL'
'\x0fTRIANGULAR MARK'
'\x04IPT '
'#BESIDE AND JOINED WITH INTERSECTION'
'\x03LAI'
'\x14INING OBLIQUE STROKE'
'\x0b PLUS MASH2'
'\x03LAG'
'\x05GALI '
'\x04UBLE'
'\x16WITH HORIZONTAL STROKE'
'\x03LAS'
'\x0cRIGHT DOUBLE'
'\tOGRAPHIC '
'\x16ROUND A POINT OPERATOR'
'\x06EGEAN '
'\x05VERSE'
'\x05GAMMA'
'\t TIMES GA'
'\x07HAARKAA'
'\x03IG4'
'\x10WITH HAMZA ABOVE'
')CK-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x05VOWEL'
'\rZHOU NUMERAL '
'!TWO DOTS ABOVE AND TWO DOTS BELOW'
'\rIFIER LETTER '
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x14HAR2 TIMES GAL PLUS '
'\x06BLACK '
'\x08ZWARAKAY'
'\x03IGN'
'\x0fED PAPER SYMBOL'
'\x03IGI'
'\x03IGH'
'\x0bCOMMA ABOVE'
'\x12ENTERING TONE MARK'
'\x05 JERA'
'\x05DIGA '
'\x04ASLA'
'\x04HAIN'
'\x0cGREATER-THAN'
'\x04HAIR'
'\nDOWN LIGHT'
'\x19NIVERSAL RECYCLING SYMBOL'
'\x03AL2'
'\x0cERTICAL LINE'
'\rLOCATION SIGN'
'\x0bL TIMES LAL'
'\x05BENDE'
'\x0cON WITH BALL'
'\x07RRECTUS'
'\tSMALL YUS'
'\rRPENTRY PLANE'
'\tMUKPHRENG'
'\x08TO-LEFT '
'\x08YER YAGH'
'\x04HOST'
'\rQUARE BRACKET'
'\nMONTH SIGN'
'\x03NTY'
'\x03ALL'
'\x10RIGHTWARDS ARROW'
'\x03ALK'
'\x03ALF'
'\x0eTROKE NOT SIGN'
'\x05IGIT '
'\x03ALC'
'\x03ALA'
'\x03NTI'
'\tDUS RTAGS'
'\x06KAVYKA'
'\x03ALT'
'\x06DVANCE'
'\x06SAADIY'
'\tDOT ABOVE'
'\x06HEAVY '
'\x02UR'
'\x06LAMADH'
'\x0fIRCUMFLEX BELOW'
'\x0bSSIVE-PULL-'
'\n FROM WALL'
'\x02UO'
'\x0bTRESS SIGN '
'\tNTRACTION'
'\tTONE MARK'
'\x0fNJOINING MACRON'
'\x11NG STROKE OVERLAY'
'\x04BANG'
'\x05EAVEN'
'\x0bINDICESIMA '
'\x04A IE'
'\r SKEWED RIGHT'
'\x08 SLIDING'
'\x04OTTO'
'\x08D SYMBOL'
'\x07NEQUDAA'
'\x07 RAMBAT'
'\tDOWN TACK'
'\x11PINWHEEL ASTERISK'
'\rCROSSING GISH'
'\x06TAMING'
'\x0bEORGIAN NAR'
'\x0eSMALL TRIANGLE'
'\x06WARDS '
'\x07BIG YUS'
'\x04ROTO'
'\x0cGONAL STROKE'
'\tHOT SASAK'
'\x13ET WITH WHITE CROSS'
'\nA TANG LAI'
'*LA USED AS KORANIC STOP SIGN ISOLATED FORM'
'\x16LLAHOU ALAYHE WASALLAM'
'$GREATER-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1eAND JOINED BY DASH WITH SUBSET'
'\x08YRILLIC '
'\x07PHIEUPH'
'\tHREE DOTS'
'\x04RUSI'
'\x07ENTRED '
'\x06SMALL '
'\x0bUBLE TONGUE'
'\x0bED EQUAL TO'
'\x03WO '
'\nANS-SERIF '
'\x03-TE'
'\tTIMES SHE'
'\x028C'
'\x04NOON'
'\x04RESH'
'\x06KNIFE '
'\x08NUSVARA '
'\x0cSHORT RIKRIK'
'\x07 EQUALS'
'\x02K2'
'\x07 SLOWLY'
'\nSTROM SIGN'
'\x02K4'
'\x04CURL'
'\x07BAMBOOS'
'\x08I SYMBOL'
'\x05STILE'
'\x0cSECTION SIGN'
'\nERISPOMENI'
'\tWUNG DASH'
'\x11 PLUS SHA3 PLUS A'
'\x02KA'
'\x02KE'
'\x02KI'
'\x02KH'
'\x02KO'
'\x02KS'
'\x02KW'
'\x02KU'
'\x03KO '
'\x0fNOT APPROXIMATE'
'\x07ZIGZAG '
'\tEXTENSION'
'\x08ARTYRIA '
'\x11CLOSED LITTLE YUS'
'\x0cOTTOM HALF O'
'\x0eOLUME INTEGRAL'
'\nATRICHISMA'
'!DOWNWARDS HARPOON WITH BARB RIGHT'
'\x04SANG'
'\x0cOUR INTEGRAL'
'\x05ETTI '
'\x04O MA'
'\x08OVERLAID'
'\x0bLOSING MARK'
'\x05HIUTH'
'\tUBSTITUTE'
'\x0cPROTOS ICHOS'
'\nPLUS BELOW'
'\x06ZHITSA'
'\x04OONE'
'\x0bSHAAYATHIYA'
'\x07T RIGHT'
'\x06INGLE '
'\x06ITHER '
'\x0bSECOND MARK'
'\x15TONE MARK SGAW KAREN '
'\x05IEUNG'
'\x07DOFONON'
'\r BZHI MIG CAN'
'\x0eENDED MULTIMAP'
'\x04PICK'
'\x05TIPPI'
'\x03TH '
'\x08LONG BAR'
'\nC WITH DOT'
'\x03THY'
'\x03THO'
'\x06DIGIT '
'\x06JEEM I'
'\x05IHVUS'
'\x03NII'
'\x03NIB'
'\x08OVER NUN'
'\x03NIA'
'\x04ATIM'
'\x04TAIN'
'\x04ITEM'
'\x04TAIL'
'\x0cSINGLE-LINE '
'\rSAMYOK SANNYA'
'\x05LIGHT'
'\x07WO FOR '
'\x0bTHREE DOTS '
'\x08PUSHPIKA'
'\nOLLAR SIGN'
'\x04MALL'
'\nI ARCHAION'
'\x03EF '
'\x07ROTUNDA'
'\x0fIMPERFECTA REST'
'\tTAKHALLUS'
'\x10RACTION ONE HALF'
'\x03EFT'
'\x10EXCLAMATION MARK'
'\x06RISEME'
'\x12WITH STROKE SYMBOL'
'\x0bLOTTAL STOP'
'\x04ALTA'
'\x05ITUAL'
'\x04LEIA'
'\x05AMED '
'\x047 KI'
'\x08JUNCTION'
'\nPPA SYMBOL'
'\x047 KA'
'\x0ePARESTIGMENON '
'\x04THER'
'\x06AITING'
'\x02RD'
'\x0bARROW ABOVE'
'\x13EVEN POWERS OF FOUR'
'\rMINUS WHITE X'
'\rDIAERESIZED U'
'\x0eNYI ZLA NAA DA'
'\x04TEEN'
'\x12JEEM ISOLATED FORM'
'\x13SUBSTITUTION MARKER'
'\x03IES'
'\x03IER'
'\x14IMAGE OF OR EQUAL TO'
'\x10PLACEHOLDER MARK'
'\nITING HAND'
'\x08CAPITAL '
'\rANNED LEATHER'
'\x07IRCLED '
'\x05IGHT '
'\x0ePOINTING INDEX'
'\x06ODHADH'
'\tUURDHAJA '
'\x07F SASAK'
'\x0fIAMOND UNDERBAR'
'\x14PARENTHESIS ORNAMENT'
'\x0cARALLELOGRAM'
'\x03PLI'
'\x0eINVERTED BREVE'
'\x06SURANG'
'\nVERTICAL B'
'\x05KHAH '
'\x03BXG'
'\x06FAMILY'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x05I KOI'
'\x04YANG'
'\x06-PIEUP'
'\x0cS ABOVE SIGN'
'\x07ESTIVAL'
'\x05O KAI'
'\x06RIKRIK'
'\tOUTH WIND'
'\x15TILDE OPERATOR ABOVE '
'\x04DOWN'
'\x06ABOVE '
'\tAJANYALAN'
'\x03ARU'
'\rVERTICAL LINE'
'\x06KEYCAP'
'\x03ARC'
'\x03ARG'
'\x08UNDERTIE'
'\rTHIRD SUBUNIT'
'\x05CAKRA'
'\x06RIPT G'
'\x04GGER'
'\x0eMULTIPLICATION'
'\x04BORE'
'\x04NCIL'
'\tERTY LINE'
'\x07SHESHIG'
'\x04HUEN'
'\x03B57'
'\r BLACK SQUARE'
'\x0bDOLLAR SIGN'
'\x05DEXIA'
'\x05HOLAM'
'\x06 MELIK'
'\x16DOWNWARDS ZIGZAG ARROW'
'\x08O SYMBOL'
'\nINHERENT A'
'\x01T'
'\x05HOLAR'
'\x0cAR DIAERESIS'
'\x18POINTING DOWNWARDS ABOVE'
'\x07STERING'
'\x0fFRACTION DIGIT '
'\x072 OLIVE'
'\x07AN MARK'
'\x05E GEE'
'\x04SHYA'
'\x06ATTIC '
'\x14 OVER LAGAR GUNU SHE'
'\x13UP HORIZONTAL HEAVY'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x0eCRIFICIAL WINE'
'\x05 LINE'
'\x0bNUSVARA ONE'
'\x04 LAI'
'\x05DALAT'
'\x06NISTER'
'\nLIGHT AND '
'\x08ATH MARK'
'\nRSI SYMBOL'
'\x08MIONIAN '
'\x12ULL AND CROSSBONES'
'\x0fTWO WITH STROKE'
'\x05ASPER'
'\x06 MURDA'
'\x12ARAGRAPH SEPARATOR'
'\tHREE FOR '
'\x0bTETRAFONIAS'
'\tALI GALI '
'\x06 KAPAL'
'\x12SINGLE PUNCTUATION'
'\x06ALL AA'
'\x11CONTOURED OUTLINE'
'\x03HE '
'\x07WO WAEN'
'\x07UP TACK'
'\x06SIEUNG'
'\x06R THAN'
'\x10BOTTOM HALF RING'
'\x15DOUBLE LEFT TURNSTILE'
'\x07PECTIVE'
'\x07AYALAM '
'\x0bRIGHT HEAVY'
'\x05O ANG'
'\x07-KIYEOK'
'\x08ORM FEED'
'\x0fUMAI PALAUNG FA'
'\x18CULINE ORDINAL INDICATOR'
'\tI PLUS LI'
'\x06LITIKI'
'\x06EILING'
'\x03NDO'
'\nUNKIA SIGN'
'\x08UBLE BAR'
'\x05SPACE'
'\x06IXTEEN'
'\x05AGMA '
'\nPLUS ERIN2'
'\x07PERVISE'
'\x0cERPENDICULAR'
'\x04EENU'
'\x04SELF'
'\x14CLUB-SPOKED ASTERISK'
'\rSILI PNEUMATA'
'\x04EENG'
'\x06ALENTS'
)
_charnodes =[70758,
 -33936,
 -1,
 132371,
 34747,
 -1,
 197694,
 104236,
 -1,
 262727,
 169245,
 -1,
 327957,
 251140,
 -1,
 393238,
 280647,
 -1,
 -65529,
 346183,
 195071,
 -65528,
 396588,
 195070,
 -65527,
 506107,
 195069,
 -65526,
 555888,
 195068,
 -65525,
 605632,
 195067,
 -65524,
 656179,
 195066,
 -65523,
 775428,
 195065,
 -65522,
 825353,
 195064,
 -65521,
 874626,
 195063,
 -65520,
 925298,
 195062,
 -65519,
 1034822,
 195061,
 -65518,
 1084557,
 195060,
 -65517,
 1134189,
 195059,
 -65516,
 1184784,
 195058,
 -65515,
 1293992,
 195057,
 -1,
 1344078,
 195056,
 1507367,
 331052,
 -1,
 -65512,
 1460295,
 195055,
 -65511,
 1510700,
 195054,
 -65510,
 1620219,
 195053,
 -65509,
 1670000,
 195052,
 -65508,
 1719744,
 195051,
 -65507,
 1770291,
 195050,
 -65506,
 1889540,
 195049,
 -65505,
 1939465,
 195048,
 -65504,
 1988738,
 195047,
 -65503,
 2039410,
 195046,
 -65502,
 2148934,
 195045,
 -65501,
 2198669,
 195044,
 -65500,
 2248301,
 195043,
 -65499,
 2298896,
 195042,
 -65498,
 2408104,
 195041,
 -1,
 2458190,
 195040,
 2621496,
 1489147,
 -1,
 -65495,
 2574407,
 195039,
 -65494,
 2624812,
 195038,
 -65493,
 2734331,
 195037,
 -65492,
 2784112,
 195036,
 -65491,
 2833856,
 195035,
 -65490,
 2884403,
 195034,
 -65489,
 3003652,
 195033,
 -65488,
 3053577,
 195032,
 -65487,
 3102850,
 195031,
 -65486,
 3153522,
 195030,
 -65485,
 3263046,
 195029,
 -65484,
 3312781,
 195028,
 -65483,
 3362413,
 195027,
 -65482,
 3413008,
 195026,
 -65481,
 3522216,
 195025,
 -1,
 3572302,
 195024,
 3735625,
 2587504,
 -1,
 -65478,
 3688519,
 195023,
 -65477,
 3738924,
 195022,
 -65476,
 3848443,
 195021,
 -65475,
 3898224,
 195020,
 -65474,
 3947968,
 195019,
 -65473,
 3998515,
 195018,
 -65472,
 4117764,
 195017,
 -65471,
 4167689,
 195016,
 -65470,
 4216962,
 195015,
 -65469,
 4267634,
 195014,
 -65468,
 4377158,
 195013,
 -65467,
 4426893,
 195012,
 -65466,
 4476525,
 195011,
 -65465,
 4527120,
 195010,
 -65464,
 4636328,
 195009,
 -1,
 4686414,
 195008,
 4849754,
 3685824,
 -1,
 -65461,
 4802631,
 195007,
 -65460,
 4853036,
 195006,
 -65459,
 4962555,
 195005,
 -65458,
 5012336,
 195004,
 -65457,
 5062080,
 195003,
 -65456,
 5112627,
 195002,
 -65455,
 5231876,
 195001,
 -65454,
 5281801,
 195000,
 -65453,
 5331074,
 194999,
 -65452,
 5381746,
 194998,
 -65451,
 5491270,
 194997,
 -65450,
 5541005,
 194996,
 -65449,
 5590637,
 194995,
 -65448,
 5641232,
 194994,
 -65447,
 5750440,
 194993,
 -1,
 5800526,
 194992,
 5963883,
 4784947,
 -1,
 -65444,
 5916743,
 194991,
 -65443,
 5967148,
 194990,
 -65442,
 6076667,
 194989,
 -65441,
 6126448,
 194988,
 -65440,
 6176192,
 194987,
 -65439,
 6226739,
 194986,
 -65438,
 6345988,
 194985,
 -65437,
 6395913,
 194984,
 -65436,
 6445186,
 194983,
 -65435,
 6495858,
 194982,
 -65434,
 6605382,
 194981,
 -65433,
 6655117,
 194980,
 -65432,
 6704749,
 194979,
 -65431,
 6755344,
 194978,
 -65430,
 6864552,
 194977,
 -1,
 6914638,
 194976,
 7078012,
 5952772,
 -1,
 -65427,
 7030855,
 194975,
 -65426,
 7081260,
 194974,
 -65425,
 7190779,
 194973,
 -65424,
 7240560,
 194972,
 -65423,
 7290304,
 194971,
 -65422,
 7340851,
 194970,
 -65421,
 7460100,
 194969,
 -65420,
 7510025,
 194968,
 -65419,
 7559298,
 194967,
 -65418,
 7609970,
 194966,
 -65417,
 7719494,
 194965,
 -65416,
 7769229,
 194964,
 -65415,
 7818861,
 194963,
 -65414,
 7869456,
 194962,
 -65413,
 7978664,
 194961,
 -1,
 8028750,
 194960,
 8192141,
 7051273,
 -1,
 -65410,
 8144967,
 194959,
 -65409,
 8195372,
 194958,
 -65408,
 8304891,
 194957,
 -65407,
 8354672,
 194956,
 -65406,
 8404416,
 194955,
 -65405,
 8454963,
 194954,
 -65404,
 8574212,
 194953,
 -65403,
 8624137,
 194952,
 -65402,
 8673410,
 194951,
 -65401,
 8724082,
 194950,
 -65400,
 8833606,
 194949,
 -65399,
 8883341,
 194948,
 -65398,
 8932973,
 194947,
 -65397,
 8983568,
 194946,
 -65396,
 9092776,
 194945,
 -1,
 9142862,
 194944,
 9306270,
 8149122,
 -1,
 -65393,
 9259079,
 194943,
 -65392,
 9309484,
 194942,
 -65391,
 9419003,
 194941,
 -65390,
 9468784,
 194940,
 -65389,
 9518528,
 194939,
 -65388,
 9569075,
 194938,
 -65387,
 9688324,
 194937,
 -65386,
 9738249,
 194936,
 -65385,
 9787522,
 194935,
 -65384,
 9838194,
 194934,
 -65383,
 9947718,
 194933,
 -65382,
 9997453,
 194932,
 -65381,
 10047085,
 194931,
 -65380,
 10097680,
 194930,
 -65379,
 10206888,
 194929,
 -1,
 10256974,
 194928,
 10420399,
 9248370,
 -1,
 -65376,
 10373191,
 194927,
 -65375,
 10423596,
 194926,
 -65374,
 10533115,
 194925,
 -65373,
 10582896,
 194924,
 -65372,
 10632640,
 194923,
 -65371,
 10683187,
 194922,
 -65370,
 10802436,
 194921,
 -65369,
 10852361,
 194920,
 -65368,
 10901634,
 194919,
 -65367,
 10952306,
 194918,
 -65366,
 11061830,
 194917,
 -65365,
 11111565,
 194916,
 -65364,
 11161197,
 194915,
 -65363,
 11211792,
 194914,
 -65362,
 11321000,
 194913,
 -1,
 11371086,
 194912,
 11534528,
 10406470,
 -1,
 -65359,
 11487303,
 194911,
 -65358,
 11537708,
 194910,
 -65357,
 11647227,
 194909,
 -65356,
 11697008,
 194908,
 -65355,
 11746752,
 194907,
 -65354,
 11797299,
 194906,
 -65353,
 11916548,
 194905,
 -65352,
 11966473,
 194904,
 -65351,
 12015746,
 194903,
 -65350,
 12066418,
 194902,
 -65349,
 12175942,
 194901,
 -65348,
 12225677,
 194900,
 -65347,
 12275309,
 194899,
 -65346,
 12325904,
 194898,
 -65345,
 12435112,
 194897,
 -1,
 12485198,
 194896,
 12648657,
 11504781,
 -1,
 -65342,
 12601415,
 194895,
 -65341,
 12651820,
 194894,
 -65340,
 12761339,
 194893,
 -65339,
 12811120,
 194892,
 -65338,
 12860864,
 194891,
 -65337,
 12911411,
 194890,
 -65336,
 13030660,
 194889,
 -65335,
 13080585,
 194888,
 -65334,
 13129858,
 194887,
 -65333,
 13180530,
 194886,
 -65332,
 13290054,
 194885,
 -65331,
 13339789,
 194884,
 -65330,
 13389421,
 194883,
 -65329,
 13440016,
 194882,
 -65328,
 13549224,
 194881,
 -1,
 13599310,
 194880,
 13762786,
 12602989,
 -1,
 -65325,
 13715527,
 194879,
 -65324,
 13765932,
 194878,
 -65323,
 13875451,
 194877,
 -65322,
 13925232,
 194876,
 -65321,
 13974976,
 194875,
 -65320,
 14025523,
 194874,
 -65319,
 14144772,
 194873,
 -65318,
 14194697,
 194872,
 -65317,
 14243970,
 194871,
 -65316,
 14294642,
 194870,
 -65315,
 14404166,
 194869,
 -65314,
 14453901,
 194868,
 -65313,
 14503533,
 194867,
 -65312,
 14554128,
 194866,
 -65311,
 14663336,
 194865,
 -1,
 14713422,
 194864,
 14876915,
 13702160,
 -1,
 -65308,
 14829639,
 194863,
 -65307,
 14880044,
 194862,
 -65306,
 14989563,
 194861,
 -65305,
 15039344,
 194860,
 -65304,
 15089088,
 194859,
 -65303,
 15139635,
 194858,
 -65302,
 15258884,
 194857,
 -65301,
 15308809,
 194856,
 -65300,
 15358082,
 194855,
 -65299,
 15408754,
 194854,
 -65298,
 15518278,
 194853,
 -65297,
 15568013,
 194852,
 -65296,
 15617645,
 194851,
 -65295,
 15668240,
 194850,
 -65294,
 15777448,
 194849,
 -1,
 15827534,
 194848,
 15991044,
 14859944,
 -1,
 -65291,
 15943751,
 194847,
 -65290,
 15994156,
 194846,
 -65289,
 16103675,
 194845,
 -65288,
 16153456,
 194844,
 -65287,
 16203200,
 194843,
 -65286,
 16253747,
 194842,
 -65285,
 16372996,
 194841,
 -65284,
 16422921,
 194840,
 -65283,
 16472194,
 194839,
 -65282,
 16522866,
 194838,
 -65281,
 16632390,
 194837,
 -65280,
 16682125,
 194836,
 -65279,
 16731757,
 194835,
 -65278,
 16782352,
 194834,
 -65277,
 16891560,
 194833,
 -1,
 16941646,
 194832,
 17170431,
 15958606,
 -1,
 -65274,
 17057863,
 194831,
 -65273,
 17108268,
 194830,
 -65272,
 17217787,
 194829,
 -65271,
 17267568,
 194828,
 -65270,
 17317312,
 194827,
 -65269,
 17367859,
 194826,
 -65268,
 17487108,
 194825,
 -65267,
 17537033,
 194824,
 -65266,
 17586306,
 194823,
 -65265,
 17636978,
 194822,
 -65264,
 17746502,
 194821,
 -65263,
 17796237,
 194820,
 -65262,
 17845869,
 194819,
 -65261,
 17896464,
 194818,
 -65260,
 18005672,
 194817,
 -1,
 18055758,
 194816,
 18219558,
 301065,
 -1,
 18284839,
 18171975,
 -1,
 -65256,
 18237511,
 194815,
 -65255,
 18287916,
 194814,
 -65254,
 18397435,
 194813,
 -65253,
 18447216,
 194812,
 -65252,
 18496960,
 194811,
 -65251,
 18547507,
 194810,
 -65250,
 18666756,
 194809,
 -65249,
 18716681,
 194808,
 -65248,
 18765954,
 194807,
 -65247,
 18816626,
 194806,
 -65246,
 18926150,
 194805,
 -65245,
 18975885,
 194804,
 -65244,
 19025517,
 194803,
 -65243,
 19076112,
 194802,
 -65242,
 19185320,
 194801,
 -1,
 19235406,
 194800,
 19398968,
 18222380,
 -1,
 -65239,
 19351623,
 194799,
 -65238,
 19402028,
 194798,
 -65237,
 19511547,
 194797,
 -65236,
 19561328,
 194796,
 -65235,
 19611072,
 194795,
 -65234,
 19661619,
 194794,
 -65233,
 19780868,
 194793,
 -65232,
 19830793,
 194792,
 -65231,
 19880066,
 194791,
 -65230,
 19930738,
 194790,
 -65229,
 20040262,
 194789,
 -65228,
 20089997,
 194788,
 -65227,
 20139629,
 194787,
 -65226,
 20190224,
 194786,
 -65225,
 20299432,
 194785,
 -1,
 20349518,
 194784,
 20513097,
 19380475,
 -1,
 -65222,
 20465735,
 194783,
 -65221,
 20516140,
 194782,
 -65220,
 20625659,
 194781,
 -65219,
 20675440,
 194780,
 -65218,
 20725184,
 194779,
 -65217,
 20775731,
 194778,
 -65216,
 20894980,
 194777,
 -65215,
 20944905,
 194776,
 -65214,
 20994178,
 194775,
 -65213,
 21044850,
 194774,
 -65212,
 21154374,
 194773,
 -65211,
 21204109,
 194772,
 -65210,
 21253741,
 194771,
 -65209,
 21304336,
 194770,
 -65208,
 21413544,
 194769,
 -1,
 21463630,
 194768,
 21627226,
 20478832,
 -1,
 -65205,
 21579847,
 194767,
 -65204,
 21630252,
 194766,
 -65203,
 21739771,
 194765,
 -65202,
 21789552,
 194764,
 -65201,
 21839296,
 194763,
 -65200,
 21889843,
 194762,
 -65199,
 22009092,
 194761,
 -65198,
 22059017,
 194760,
 -65197,
 22108290,
 194759,
 -65196,
 22158962,
 194758,
 -65195,
 22268486,
 194757,
 -65194,
 22318221,
 194756,
 -65193,
 22367853,
 194755,
 -65192,
 22418448,
 194754,
 -65191,
 22527656,
 194753,
 -1,
 22577742,
 194752,
 22741355,
 21577152,
 -1,
 -65188,
 22693959,
 194751,
 -65187,
 22744364,
 194750,
 -65186,
 22853883,
 194749,
 -65185,
 22903664,
 194748,
 -65184,
 22953408,
 194747,
 -65183,
 23003955,
 194746,
 -65182,
 23123204,
 194745,
 -65181,
 23173129,
 194744,
 -65180,
 23222402,
 194743,
 -65179,
 23273074,
 194742,
 -65178,
 23382598,
 194741,
 -65177,
 23432333,
 194740,
 -65176,
 23481965,
 194739,
 -65175,
 23532560,
 194738,
 -65174,
 23641768,
 194737,
 -1,
 23691854,
 194736,
 23855484,
 22676275,
 -1,
 -65171,
 23808071,
 194735,
 -65170,
 23858476,
 194734,
 -65169,
 23967995,
 194733,
 -65168,
 24017776,
 194732,
 -65167,
 24067520,
 194731,
 -65166,
 24118067,
 194730,
 -65165,
 24237316,
 194729,
 -65164,
 24287241,
 194728,
 -65163,
 24336514,
 194727,
 -65162,
 24387186,
 194726,
 -65161,
 24496710,
 194725,
 -65160,
 24546445,
 194724,
 -65159,
 24596077,
 194723,
 -65158,
 24646672,
 194722,
 -65157,
 24755880,
 194721,
 -1,
 24805966,
 194720,
 24969613,
 23844100,
 -1,
 -65154,
 24922183,
 194719,
 -65153,
 24972588,
 194718,
 -65152,
 25082107,
 194717,
 -65151,
 25131888,
 194716,
 -65150,
 25181632,
 194715,
 -65149,
 25232179,
 194714,
 -65148,
 25351428,
 194713,
 -65147,
 25401353,
 194712,
 -65146,
 25450626,
 194711,
 -65145,
 25501298,
 194710,
 -65144,
 25610822,
 194709,
 -65143,
 25660557,
 194708,
 -65142,
 25710189,
 194707,
 -65141,
 25760784,
 194706,
 -65140,
 25869992,
 194705,
 -1,
 25920078,
 194704,
 26083742,
 24942601,
 -1,
 -65137,
 26036295,
 194703,
 -65136,
 26086700,
 194702,
 -65135,
 26196219,
 194701,
 -65134,
 26246000,
 194700,
 -65133,
 26295744,
 194699,
 -65132,
 26346291,
 194698,
 -65131,
 26465540,
 194697,
 -65130,
 26515465,
 194696,
 -65129,
 26564738,
 194695,
 -65128,
 26615410,
 194694,
 -65127,
 26724934,
 194693,
 -65126,
 26774669,
 194692,
 -65125,
 26824301,
 194691,
 -65124,
 26874896,
 194690,
 -65123,
 26984104,
 194689,
 -1,
 27034190,
 194688,
 27197871,
 26040450,
 -1,
 -65120,
 27150407,
 194687,
 -65119,
 27200812,
 194686,
 -65118,
 27310331,
 194685,
 -65117,
 27360112,
 194684,
 -65116,
 27409856,
 194683,
 -65115,
 27460403,
 194682,
 -65114,
 27579652,
 194681,
 -65113,
 27629577,
 194680,
 -65112,
 27678850,
 194679,
 -65111,
 27729522,
 194678,
 -65110,
 27839046,
 194677,
 -65109,
 27888781,
 194676,
 -65108,
 27938413,
 194675,
 -65107,
 27989008,
 194674,
 -65106,
 28098216,
 194673,
 -1,
 28148302,
 194672,
 28312000,
 27139698,
 -1,
 -65103,
 28264519,
 194671,
 -65102,
 28314924,
 194670,
 -65101,
 28424443,
 194669,
 -65100,
 28474224,
 194668,
 -65099,
 28523968,
 194667,
 -65098,
 28574515,
 194666,
 -65097,
 28693764,
 194665,
 -65096,
 28743689,
 194664,
 -65095,
 28792962,
 194663,
 -65094,
 28843634,
 194662,
 -65093,
 28953158,
 194661,
 -65092,
 29002893,
 194660,
 -65091,
 29052525,
 194659,
 -65090,
 29103120,
 194658,
 -65089,
 29212328,
 194657,
 -1,
 29262414,
 194656,
 29426129,
 28297798,
 -1,
 -65086,
 29378631,
 194655,
 -65085,
 29429036,
 194654,
 -65084,
 29538555,
 194653,
 -65083,
 29588336,
 194652,
 -65082,
 29638080,
 194651,
 -65081,
 29688627,
 194650,
 -65080,
 29807876,
 194649,
 -65079,
 29857801,
 194648,
 -65078,
 29907074,
 194647,
 -65077,
 29957746,
 194646,
 -65076,
 30067270,
 194645,
 -65075,
 30117005,
 194644,
 -65074,
 30166637,
 194643,
 -65073,
 30217232,
 194642,
 -65072,
 30326440,
 194641,
 -1,
 30376526,
 194640,
 30540258,
 29396109,
 -1,
 -65069,
 30492743,
 194639,
 -65068,
 30543148,
 194638,
 -65067,
 30652667,
 194637,
 -65066,
 30702448,
 194636,
 -65065,
 30752192,
 194635,
 -65064,
 30802739,
 194634,
 -65063,
 30921988,
 194633,
 -65062,
 30971913,
 194632,
 -65061,
 31021186,
 194631,
 -65060,
 31071858,
 194630,
 -65059,
 31181382,
 194629,
 -65058,
 31231117,
 194628,
 -65057,
 31280749,
 194627,
 -65056,
 31331344,
 194626,
 -65055,
 31440552,
 194625,
 -1,
 31490638,
 194624,
 31654387,
 30494317,
 -1,
 -65052,
 31606855,
 194623,
 -65051,
 31657260,
 194622,
 -65050,
 31766779,
 194621,
 -65049,
 31816560,
 194620,
 -65048,
 31866304,
 194619,
 -65047,
 31916851,
 194618,
 -65046,
 32036100,
 194617,
 -65045,
 32086025,
 194616,
 -65044,
 32135298,
 194615,
 -65043,
 32185970,
 194614,
 -65042,
 32295494,
 194613,
 -65041,
 32345229,
 194612,
 -65040,
 32394861,
 194611,
 -65039,
 32445456,
 194610,
 -65038,
 32554664,
 194609,
 -1,
 32604750,
 194608,
 32768516,
 31593488,
 -1,
 -65035,
 32720967,
 194607,
 -65034,
 32771372,
 194606,
 -65033,
 32880891,
 194605,
 -65032,
 32930672,
 194604,
 -65031,
 32980416,
 194603,
 -65030,
 33030963,
 194602,
 -65029,
 33150212,
 194601,
 -65028,
 33200137,
 194600,
 -65027,
 33249410,
 194599,
 -65026,
 33300082,
 194598,
 -65025,
 33409606,
 194597,
 -65024,
 33459341,
 194596,
 -65023,
 33508973,
 194595,
 -65022,
 33559568,
 194594,
 -65021,
 33668776,
 194593,
 -1,
 33718862,
 194592,
 33882645,
 32751272,
 -1,
 -65018,
 33835079,
 194591,
 -65017,
 33885484,
 194590,
 -65016,
 33995003,
 194589,
 -65015,
 34044784,
 194588,
 -65014,
 34094528,
 194587,
 -65013,
 34145075,
 194586,
 -65012,
 34264324,
 194585,
 -65011,
 34314249,
 194584,
 -65010,
 34363522,
 194583,
 -65009,
 34414194,
 194582,
 -65008,
 34523718,
 194581,
 -65007,
 34573453,
 194580,
 -65006,
 34623085,
 194579,
 -65005,
 34673680,
 194578,
 -65004,
 34782888,
 194577,
 -1,
 34832974,
 194576,
 35061759,
 33849934,
 -1,
 -65001,
 34949191,
 194575,
 -65000,
 34999596,
 194574,
 -64999,
 35109115,
 194573,
 -64998,
 35158896,
 194572,
 -64997,
 35208640,
 194571,
 -64996,
 35259187,
 194570,
 -64995,
 35378436,
 194569,
 -64994,
 35428361,
 194568,
 -64993,
 35477634,
 194567,
 -64992,
 35528306,
 194566,
 -64991,
 35637830,
 194565,
 -64990,
 35687565,
 194564,
 -64989,
 35737197,
 194563,
 -64988,
 35787792,
 194562,
 -64987,
 35897000,
 194561,
 -1,
 35947086,
 194560,
 36175871,
 18154291,
 -1,
 36176440,
 36078158,
 -1,
 -64983,
 36128839,
 195087,
 -64982,
 36179244,
 195086,
 -64981,
 36288763,
 195085,
 -64980,
 36338544,
 195084,
 -64979,
 36388288,
 195083,
 -64978,
 36438835,
 195082,
 -64977,
 36558084,
 195081,
 -64976,
 36608009,
 195080,
 -64975,
 36657282,
 195079,
 -64974,
 36707954,
 195078,
 -64973,
 36817478,
 195077,
 -64972,
 36867213,
 195076,
 -64971,
 36916845,
 195075,
 -64970,
 36967440,
 195074,
 -64969,
 37076648,
 195073,
 -1,
 37126734,
 195072,
 37355519,
 36159144,
 -1,
 -64966,
 37271803,
 195101,
 -64965,
 37321584,
 195100,
 -64964,
 37371328,
 195099,
 -64963,
 37421875,
 195098,
 -64962,
 37541124,
 195097,
 -64961,
 37591049,
 195096,
 -64960,
 37640322,
 195095,
 -64959,
 37690994,
 195094,
 -64958,
 37800518,
 195093,
 -64957,
 37850253,
 195092,
 -64956,
 37899885,
 195091,
 -64955,
 37950480,
 195090,
 -64954,
 38059688,
 195089,
 -1,
 38109774,
 195088,
 38338559,
 215111,
 -1,
 38339417,
 38262020,
 -1,
 38404698,
 38291527,
 -1,
 -64949,
 38357063,
 63999,
 -64948,
 38407468,
 63998,
 -64947,
 38516987,
 63997,
 -64946,
 38566768,
 63996,
 -64945,
 38616512,
 63995,
 -64944,
 38667059,
 63994,
 -64943,
 38786308,
 63993,
 -64942,
 38836233,
 63992,
 -64941,
 38885506,
 63991,
 -64940,
 38936178,
 63990,
 -64939,
 39045702,
 63989,
 -64938,
 39095437,
 63988,
 -64937,
 39145069,
 63987,
 -64936,
 39195664,
 63986,
 -64935,
 39304872,
 63985,
 -1,
 39354958,
 63984,
 39518827,
 38341932,
 -1,
 -64932,
 39471175,
 63983,
 -64931,
 39521580,
 63982,
 -64930,
 39631099,
 63981,
 -64929,
 39680880,
 63980,
 -64928,
 39730624,
 63979,
 -64927,
 39781171,
 63978,
 -64926,
 39900420,
 63977,
 -64925,
 39950345,
 63976,
 -64924,
 39999618,
 63975,
 -64923,
 40050290,
 63974,
 -64922,
 40159814,
 63973,
 -64921,
 40209549,
 63972,
 -64920,
 40259181,
 63971,
 -64919,
 40309776,
 63970,
 -64918,
 40418984,
 63969,
 -1,
 40469070,
 63968,
 40632956,
 39500027,
 -1,
 -64915,
 40585287,
 63967,
 -64914,
 40635692,
 63966,
 -64913,
 40745211,
 63965,
 -64912,
 40794992,
 63964,
 -64911,
 40844736,
 63963,
 -64910,
 40895283,
 63962,
 -64909,
 41014532,
 63961,
 -64908,
 41064457,
 63960,
 -64907,
 41113730,
 63959,
 -64906,
 41164402,
 63958,
 -64905,
 41273926,
 63957,
 -64904,
 41323661,
 63956,
 -64903,
 41373293,
 63955,
 -64902,
 41423888,
 63954,
 -64901,
 41533096,
 63953,
 -1,
 41583182,
 63952,
 41747085,
 40598384,
 -1,
 -64898,
 41699399,
 63951,
 -64897,
 41749804,
 63950,
 -64896,
 41859323,
 63949,
 -64895,
 41909104,
 63948,
 -64894,
 41958848,
 63947,
 -64893,
 42009395,
 63946,
 -64892,
 42128644,
 63945,
 -64891,
 42178569,
 63944,
 -64890,
 42227842,
 63943,
 -64889,
 42278514,
 63942,
 -64888,
 42388038,
 63941,
 -64887,
 42437773,
 63940,
 -64886,
 42487405,
 63939,
 -64885,
 42538000,
 63938,
 -64884,
 42647208,
 63937,
 -1,
 42697294,
 63936,
 42861214,
 41696704,
 -1,
 -64881,
 42813511,
 63935,
 -64880,
 42863916,
 63934,
 -64879,
 42973435,
 63933,
 -64878,
 43023216,
 63932,
 -64877,
 43072960,
 63931,
 -64876,
 43123507,
 63930,
 -64875,
 43242756,
 63929,
 -64874,
 43292681,
 63928,
 -64873,
 43341954,
 63927,
 -64872,
 43392626,
 63926,
 -64871,
 43502150,
 63925,
 -64870,
 43551885,
 63924,
 -64869,
 43601517,
 63923,
 -64868,
 43652112,
 63922,
 -64867,
 43761320,
 63921,
 -1,
 43811406,
 63920,
 43975343,
 42795827,
 -1,
 -64864,
 43927623,
 63919,
 -64863,
 43978028,
 63918,
 -64862,
 44087547,
 63917,
 -64861,
 44137328,
 63916,
 -64860,
 44187072,
 63915,
 -64859,
 44237619,
 63914,
 -64858,
 44356868,
 63913,
 -64857,
 44406793,
 63912,
 -64856,
 44456066,
 63911,
 -64855,
 44506738,
 63910,
 -64854,
 44616262,
 63909,
 -64853,
 44665997,
 63908,
 -64852,
 44715629,
 63907,
 -64851,
 44766224,
 63906,
 -64850,
 44875432,
 63905,
 -1,
 44925518,
 63904,
 45089472,
 43963652,
 -1,
 -64847,
 45041735,
 63903,
 -64846,
 45092140,
 63902,
 -64845,
 45201659,
 63901,
 -64844,
 45251440,
 63900,
 -64843,
 45301184,
 63899,
 -64842,
 45351731,
 63898,
 -64841,
 45470980,
 63897,
 -64840,
 45520905,
 63896,
 -64839,
 45570178,
 63895,
 -64838,
 45620850,
 63894,
 -64837,
 45730374,
 63893,
 -64836,
 45780109,
 63892,
 -64835,
 45829741,
 63891,
 -64834,
 45880336,
 63890,
 -64833,
 45989544,
 63889,
 -1,
 46039630,
 63888,
 46203601,
 45062153,
 -1,
 -64830,
 46155847,
 63887,
 -64829,
 46206252,
 63886,
 -64828,
 46315771,
 63885,
 -64827,
 46365552,
 63884,
 -64826,
 46415296,
 63883,
 -64825,
 46465843,
 63882,
 -64824,
 46585092,
 63881,
 -64823,
 46635017,
 63880,
 -64822,
 46684290,
 63879,
 -64821,
 46734962,
 63878,
 -64820,
 46844486,
 63877,
 -64819,
 46894221,
 63876,
 -64818,
 46943853,
 63875,
 -64817,
 46994448,
 63874,
 -64816,
 47103656,
 63873,
 -1,
 47153742,
 63872,
 47317730,
 46160002,
 -1,
 -64813,
 47269959,
 63871,
 -64812,
 47320364,
 63870,
 -64811,
 47429883,
 63869,
 -64810,
 47479664,
 63868,
 -64809,
 47529408,
 63867,
 -64808,
 47579955,
 63866,
 -64807,
 47699204,
 63865,
 -64806,
 47749129,
 63864,
 -64805,
 47798402,
 63863,
 -64804,
 47849074,
 63862,
 -64803,
 47958598,
 63861,
 -64802,
 48008333,
 63860,
 -64801,
 48057965,
 63859,
 -64800,
 48108560,
 63858,
 -64799,
 48217768,
 63857,
 -1,
 48267854,
 63856,
 48431859,
 47259250,
 -1,
 -64796,
 48384071,
 63855,
 -64795,
 48434476,
 63854,
 -64794,
 48543995,
 63853,
 -64793,
 48593776,
 63852,
 -64792,
 48643520,
 63851,
 -64791,
 48694067,
 63850,
 -64790,
 48813316,
 63849,
 -64789,
 48863241,
 63848,
 -64788,
 48912514,
 63847,
 -64787,
 48963186,
 63846,
 -64786,
 49072710,
 63845,
 -64785,
 49122445,
 63844,
 -64784,
 49172077,
 63843,
 -64783,
 49222672,
 63842,
 -64782,
 49331880,
 63841,
 -1,
 49381966,
 63840,
 49545988,
 48417350,
 -1,
 -64779,
 49498183,
 63839,
 -64778,
 49548588,
 63838,
 -64777,
 49658107,
 63837,
 -64776,
 49707888,
 63836,
 -64775,
 49757632,
 63835,
 -64774,
 49808179,
 63834,
 -64773,
 49927428,
 63833,
 -64772,
 49977353,
 63832,
 -64771,
 50026626,
 63831,
 -64770,
 50077298,
 63830,
 -64769,
 50186822,
 63829,
 -64768,
 50236557,
 63828,
 -64767,
 50286189,
 63827,
 -64766,
 50336784,
 63826,
 -64765,
 50445992,
 63825,
 -1,
 50496078,
 63824,
 50660117,
 49515661,
 -1,
 -64762,
 50612295,
 63823,
 -64761,
 50662700,
 63822,
 -64760,
 50772219,
 63821,
 -64759,
 50822000,
 63820,
 -64758,
 50871744,
 63819,
 -64757,
 50922291,
 63818,
 -64756,
 51041540,
 63817,
 -64755,
 51091465,
 63816,
 -64754,
 51140738,
 63815,
 -64753,
 51191410,
 63814,
 -64752,
 51300934,
 63813,
 -64751,
 51350669,
 63812,
 -64750,
 51400301,
 63811,
 -64749,
 51450896,
 63810,
 -64748,
 51560104,
 63809,
 -1,
 51610190,
 63808,
 51774246,
 50613869,
 -1,
 -64745,
 51726407,
 63807,
 -64744,
 51776812,
 63806,
 -64743,
 51886331,
 63805,
 -64742,
 51936112,
 63804,
 -64741,
 51985856,
 63803,
 -64740,
 52036403,
 63802,
 -64739,
 52155652,
 63801,
 -64738,
 52205577,
 63800,
 -64737,
 52254850,
 63799,
 -64736,
 52305522,
 63798,
 -64735,
 52415046,
 63797,
 -64734,
 52464781,
 63796,
 -64733,
 52514413,
 63795,
 -64732,
 52565008,
 63794,
 -64731,
 52674216,
 63793,
 -1,
 52724302,
 63792,
 52888375,
 51713040,
 -1,
 -64728,
 52840519,
 63791,
 -64727,
 52890924,
 63790,
 -64726,
 53000443,
 63789,
 -64725,
 53050224,
 63788,
 -64724,
 53099968,
 63787,
 -64723,
 53150515,
 63786,
 -64722,
 53269764,
 63785,
 -64721,
 53319689,
 63784,
 -64720,
 53368962,
 63783,
 -64719,
 53419634,
 63782,
 -64718,
 53529158,
 63781,
 -64717,
 53578893,
 63780,
 -64716,
 53628525,
 63779,
 -64715,
 53679120,
 63778,
 -64714,
 53788328,
 63777,
 -1,
 53838414,
 63776,
 54002504,
 52870824,
 -1,
 -64711,
 53954631,
 63775,
 -64710,
 54005036,
 63774,
 -64709,
 54114555,
 63773,
 -64708,
 54164336,
 63772,
 -64707,
 54214080,
 63771,
 -64706,
 54264627,
 63770,
 -64705,
 54383876,
 63769,
 -64704,
 54433801,
 63768,
 -64703,
 54483074,
 63767,
 -64702,
 54533746,
 63766,
 -64701,
 54643270,
 63765,
 -64700,
 54693005,
 63764,
 -64699,
 54742637,
 63763,
 -64698,
 54793232,
 63762,
 -64697,
 54902440,
 63761,
 -1,
 54952526,
 63760,
 55181311,
 53969486,
 -1,
 -64694,
 55068743,
 63759,
 -64693,
 55119148,
 63758,
 -64692,
 55228667,
 63757,
 -64691,
 55278448,
 63756,
 -64690,
 55328192,
 63755,
 -64689,
 55378739,
 63754,
 -64688,
 55497988,
 63753,
 -64687,
 55547913,
 63752,
 -64686,
 55597186,
 63751,
 -64685,
 55647858,
 63750,
 -64684,
 55757382,
 63749,
 -64683,
 55807117,
 63748,
 -64682,
 55856749,
 63747,
 -64681,
 55907344,
 63746,
 -64680,
 56016552,
 63745,
 -1,
 56066638,
 63744,
 56295423,
 38273843,
 -1,
 56296299,
 56195952,
 -1,
 -64676,
 56248391,
 64207,
 -64675,
 56298796,
 64206,
 -64674,
 56408315,
 64205,
 -64673,
 56458096,
 64204,
 -64672,
 56507840,
 64203,
 -64671,
 56558387,
 64202,
 -64670,
 56677636,
 64201,
 -64669,
 56727561,
 64200,
 -64668,
 56776834,
 64199,
 -64667,
 56827506,
 64198,
 -64666,
 56937030,
 64197,
 -64665,
 56986765,
 64196,
 -64664,
 57036397,
 64195,
 -64663,
 57086992,
 64194,
 -64662,
 57196200,
 64193,
 -1,
 57246286,
 64192,
 57410428,
 56245696,
 -1,
 -64659,
 57362503,
 64191,
 -64658,
 57412908,
 64190,
 -64657,
 57522427,
 64189,
 -64656,
 57572208,
 64188,
 -64655,
 57621952,
 64187,
 -64654,
 57672499,
 64186,
 -64653,
 57791748,
 64185,
 -64652,
 57841673,
 64184,
 -64651,
 57890946,
 64183,
 -64650,
 57941618,
 64182,
 -64649,
 58051142,
 64181,
 -64648,
 58100877,
 64180,
 -64647,
 58150509,
 64179,
 -64646,
 58201104,
 64178,
 -64645,
 58310312,
 64177,
 -1,
 58360398,
 64176,
 58524557,
 57344819,
 -1,
 -64642,
 58476615,
 64175,
 -64641,
 58527020,
 64174,
 -64640,
 58636539,
 64173,
 -64639,
 58686320,
 64172,
 -64638,
 58736064,
 64171,
 -64637,
 58786611,
 64170,
 -64636,
 58905860,
 64169,
 -64635,
 58955785,
 64168,
 -64634,
 59005058,
 64167,
 -64633,
 59055730,
 64166,
 -64632,
 59165254,
 64165,
 -64631,
 59214989,
 64164,
 -64630,
 59264621,
 64163,
 -64629,
 59315216,
 64162,
 -64628,
 59424424,
 64161,
 -1,
 59474510,
 64160,
 59638686,
 58512644,
 -1,
 -64625,
 59590727,
 64159,
 -64624,
 59641132,
 64158,
 -64623,
 59750651,
 64157,
 -64622,
 59800432,
 64156,
 -64621,
 59850176,
 64155,
 -64620,
 59900723,
 64154,
 -64619,
 60019972,
 64153,
 -64618,
 60069897,
 64152,
 -64617,
 60119170,
 64151,
 -64616,
 60169842,
 64150,
 -64615,
 60279366,
 64149,
 -64614,
 60329101,
 64148,
 -64613,
 60378733,
 64147,
 -64612,
 60429328,
 64146,
 -64611,
 60538536,
 64145,
 -1,
 60588622,
 64144,
 60752815,
 59611145,
 -1,
 -64608,
 60704839,
 64143,
 -64607,
 60755244,
 64142,
 -64606,
 60864763,
 64141,
 -64605,
 60914544,
 64140,
 -64604,
 60964288,
 64139,
 -64603,
 61014835,
 64138,
 -64602,
 61134084,
 64137,
 -64601,
 61184009,
 64136,
 -64600,
 61233282,
 64135,
 -64599,
 61283954,
 64134,
 -64598,
 61393478,
 64133,
 -64597,
 61443213,
 64132,
 -64596,
 61492845,
 64131,
 -64595,
 61543440,
 64130,
 -64594,
 61652648,
 64129,
 -1,
 61702734,
 64128,
 61866944,
 60708994,
 -1,
 -64591,
 61818951,
 64127,
 -64590,
 61869356,
 64126,
 -64589,
 61978875,
 64125,
 -64588,
 62028656,
 64124,
 -64587,
 62078400,
 64123,
 -64586,
 62128947,
 64122,
 -64585,
 62248196,
 64121,
 -64584,
 62298121,
 64120,
 -64583,
 62347394,
 64119,
 -64582,
 62398066,
 64118,
 -64581,
 62507590,
 64117,
 -64580,
 62557325,
 64116,
 -64579,
 62606957,
 64115,
 -64578,
 62657552,
 64114,
 -64577,
 62766760,
 64113,
 -1,
 62816846,
 64112,
 62981073,
 61852230,
 -1,
 -64574,
 62933063,
 64095,
 -64573,
 62983468,
 64094,
 -64572,
 63092987,
 64093,
 -64571,
 63142768,
 64092,
 -64570,
 63192512,
 64091,
 -64569,
 63243059,
 64090,
 -64568,
 63362308,
 64089,
 -64567,
 63412233,
 64088,
 -64566,
 63461506,
 64087,
 -64565,
 63512178,
 64086,
 -64564,
 63621702,
 64085,
 -64563,
 63671437,
 64084,
 -64562,
 63721069,
 64083,
 -64561,
 63771664,
 64082,
 -64560,
 63880872,
 64081,
 -1,
 63930958,
 64080,
 64095202,
 62950541,
 -1,
 -64557,
 64047175,
 64079,
 -64556,
 64097580,
 64078,
 -64555,
 64207099,
 64077,
 -64554,
 64256880,
 64076,
 -64553,
 64306624,
 64075,
 -64552,
 64357171,
 64074,
 -64551,
 64476420,
 64073,
 -64550,
 64526345,
 64072,
 -64549,
 64575618,
 64071,
 -64548,
 64626290,
 64070,
 -64547,
 64735814,
 64069,
 -64546,
 64785549,
 64068,
 -64545,
 64835181,
 64067,
 -64544,
 64885776,
 64066,
 -64543,
 64994984,
 64065,
 -1,
 65045070,
 64064,
 65209331,
 64048749,
 -1,
 -64540,
 65161287,
 64063,
 -64539,
 65211692,
 64062,
 -64538,
 65321211,
 64061,
 -64537,
 65370992,
 64060,
 -64536,
 65420736,
 64059,
 -64535,
 65471283,
 64058,
 -64534,
 65590532,
 64057,
 -64533,
 65640457,
 64056,
 -64532,
 65689730,
 64055,
 -64531,
 65740402,
 64054,
 -64530,
 65849926,
 64053,
 -64529,
 65899661,
 64052,
 -64528,
 65949293,
 64051,
 -64527,
 65999888,
 64050,
 -64526,
 66109096,
 64049,
 -1,
 66159182,
 64048,
 66323460,
 65191592,
 -1,
 -64523,
 66275399,
 64031,
 -64522,
 66325804,
 64030,
 -64521,
 66435323,
 64029,
 -64520,
 66485104,
 64028,
 -64519,
 66534848,
 64027,
 -64518,
 66585395,
 64026,
 -64517,
 66704644,
 64025,
 -64516,
 66754569,
 64024,
 -64515,
 66803842,
 64023,
 -64514,
 66854514,
 64022,
 -64513,
 66964038,
 64021,
 -64512,
 67013773,
 64020,
 -64511,
 67063405,
 64019,
 -64510,
 67114000,
 64018,
 -64509,
 67223208,
 64017,
 -1,
 67273294,
 64016,
 67437589,
 66290254,
 -1,
 -64506,
 67389511,
 64015,
 -64505,
 67439916,
 64014,
 -64504,
 67549435,
 64013,
 -64503,
 67599216,
 64012,
 -64502,
 67648960,
 64011,
 -64501,
 67699507,
 64010,
 -64500,
 67818756,
 64009,
 -64499,
 67868681,
 64008,
 -64498,
 67917954,
 64007,
 -64497,
 67968626,
 64006,
 -64496,
 68078150,
 64005,
 -64495,
 68127885,
 64004,
 -64494,
 68177517,
 64003,
 -64493,
 68228112,
 64002,
 -64492,
 68337320,
 64001,
 -1,
 68387406,
 64000,
 68551716,
 67378802,
 -1,
 -64489,
 68532475,
 64109,
 -64488,
 68582256,
 64108,
 -64487,
 68632000,
 64107,
 -64486,
 68682547,
 64106,
 -64485,
 68801796,
 64105,
 -64484,
 68851721,
 64104,
 -64483,
 68900994,
 64103,
 -64482,
 68951666,
 64102,
 -64481,
 69061190,
 64101,
 -64480,
 69110925,
 64100,
 -64479,
 69160557,
 64099,
 -64478,
 69211152,
 64098,
 -64477,
 69320360,
 64097,
 -1,
 69370446,
 64096,
 69534771,
 68490256,
 -1,
 -64474,
 69515515,
 64045,
 -64473,
 69565296,
 64044,
 -64472,
 69615040,
 64043,
 -64471,
 69665587,
 64042,
 -64470,
 69784836,
 64041,
 -64469,
 69834761,
 64040,
 -64468,
 69884034,
 64039,
 -64467,
 69934706,
 64038,
 -64466,
 70044230,
 64037,
 -64465,
 70093965,
 64036,
 -64464,
 70143597,
 64035,
 -64463,
 70194192,
 64034,
 -64462,
 70303400,
 64033,
 -1,
 70353486,
 64032,
 70582271,
 69515515,
 -1,
 -64459,
 70505732,
 64217,
 -64458,
 70555657,
 64216,
 -64457,
 70604930,
 64215,
 -64456,
 70655602,
 64214,
 -64455,
 70765126,
 64213,
 -64454,
 70814861,
 64212,
 -64453,
 70864493,
 64211,
 -64452,
 70915088,
 64210,
 -64451,
 71024296,
 64209,
 -1,
 71074382,
 64208,
 71238894,
 172335,
 -1,
 71304293,
 71203696,
 -1,
 71369821,
 71255663,
 -1,
 71435335,
 71346062,
 -1,
 -64445,
 71398743,
 11976,
 -64444,
 71454458,
 11952,
 -64443,
 71535092,
 11977,
 -64442,
 71603649,
 11973,
 -1,
 71687370,
 12007,
 71828555,
 71427466,
 -1,
 -64439,
 71789969,
 12019,
 -64438,
 71856784,
 12014,
 -1,
 71951236,
 11993,
 72090703,
 71780423,
 -1,
 -64435,
 72052798,
 12010,
 -64434,
 72090416,
 11996,
 -1,
 72185493,
 12005,
 72352850,
 72076943,
 -1,
 -64431,
 72331572,
 11987,
 -1,
 72384697,
 11994,
 72549461,
 72320717,
 -1,
 -64428,
 72525831,
 11984,
 -1,
 72553410,
 11988,
 72746072,
 72486188,
 -1,
 -64425,
 72687253,
 12012,
 -1,
 72770075,
 12000,
 -64423,
 72699624,
 11995,
 -64422,
 72891400,
 12002,
 -64421,
 72984488,
 12016,
 -64420,
 73012288,
 11979,
 -1,
 73072953,
 12006,
 73270368,
 71356047,
 -1,
 -64417,
 73253166,
 11970,
 -1,
 73295743,
 11905,
 73466979,
 73210013,
 -1,
 -64414,
 73411762,
 11936,
 -1,
 73501711,
 11983,
 -64412,
 73410267,
 11943,
 -1,
 73644478,
 11931,
 73794692,
 71280526,
 -1,
 73860208,
 73734301,
 -1,
 73925743,
 73830701,
 -1,
 73991275,
 73904965,
 -1,
 -64406,
 73925489,
 12008,
 -1,
 74046608,
 11980,
 74187886,
 73974674,
 -1,
 -64403,
 74136239,
 11974,
 -1,
 74235504,
 11942,
 -1,
 74156041,
 12009,
 -1,
 73859873,
 11951,
 74515575,
 73796908,
 -1,
 74581110,
 74480366,
 -1,
 74646645,
 74573194,
 -1,
 -64396,
 74615025,
 11907,
 -1,
 74680339,
 11908,
 -1,
 74625336,
 11906,
 -1,
 74539526,
 11915,
 74974332,
 74472744,
 -1,
 75039867,
 74951867,
 -1,
 -64390,
 74990875,
 11925,
 -1,
 75084088,
 11924,
 -1,
 74991560,
 11922,
 75302015,
 74914576,
 -1,
 -64386,
 75253019,
 11949,
 -1,
 75346232,
 11948,
 75498626,
 75242378,
 -1,
 -64383,
 75449627,
 11917,
 -1,
 75542840,
 11916,
 -64381,
 75460797,
 11932,
 -1,
 75684138,
 11958,
 75826319,
 73736788,
 -1,
 75891852,
 75799800,
 -1,
 75957385,
 75834733,
 -1,
 -64376,
 75908379,
 11990,
 -1,
 76001592,
 11989,
 -64374,
 75948732,
 11935,
 -64373,
 76094297,
 11965,
 -1,
 76162712,
 11933,
 76414975,
 75828524,
 -1,
 -64370,
 76306082,
 11957,
 -1,
 76374555,
 11964,
 76547225,
 75775424,
 -1,
 76612756,
 76520696,
 -1,
 -64366,
 76548015,
 11910,
 -64365,
 76618531,
 12003,
 -1,
 76729592,
 11946,
 76874903,
 76593043,
 -1,
 -64362,
 76825883,
 11963,
 -1,
 76919096,
 11962,
 -64360,
 76861145,
 11992,
 -1,
 77058826,
 11950,
 77202596,
 76526405,
 -1,
 77268129,
 77136691,
 -1,
 77333662,
 77241155,
 -1,
 -64355,
 77284635,
 11938,
 -1,
 77377848,
 11937,
 77594623,
 77273723,
 -1,
 -64352,
 77481243,
 11982,
 -1,
 77574456,
 11981,
 77791231,
 77219019,
 -1,
 -64349,
 77677851,
 11972,
 -1,
 77771064,
 11971,
 77923502,
 77188751,
 -1,
 77989035,
 77907420,
 -1,
 78054569,
 77981066,
 -1,
 -64344,
 78022897,
 11919,
 -1,
 78088211,
 11920,
 -64342,
 78033208,
 11918,
 -1,
 78196355,
 11921,
 78446591,
 77972484,
 -1,
 -64339,
 78333211,
 11986,
 -1,
 78426424,
 11985,
 78578870,
 77877964,
 -1,
 78644405,
 78530159,
 -1,
 78709939,
 78636426,
 -1,
 -64334,
 78671249,
 12018,
 -1,
 78738064,
 12013,
 -64332,
 78658174,
 12011,
 -1,
 78882728,
 12015,
 -1,
 78625497,
 11945,
 79103166,
 78562194,
 -1,
 79168700,
 79074762,
 -1,
 79234235,
 79136457,
 -1,
 -64326,
 79185179,
 11927,
 -1,
 79278392,
 11926,
 -1,
 79214843,
 12001,
 -64323,
 79116975,
 11975,
 -1,
 79483731,
 11928,
 79627462,
 79039788,
 -1,
 79692996,
 79565948,
 -1,
 79758531,
 79685002,
 -1,
 -64318,
 79726833,
 11998,
 -1,
 79792147,
 11999,
 -1,
 79737144,
 11997,
 -64315,
 79667658,
 11947,
 -1,
 79988967,
 11960,
 80151755,
 79619466,
 -1,
 -64312,
 80113041,
 12017,
 -64311,
 80150913,
 11969,
 -64310,
 80263727,
 11923,
 -1,
 80325835,
 11911,
 80479441,
 80131335,
 -1,
 80544976,
 80413491,
 -1,
 -64306,
 80533920,
 11929,
 -64305,
 80552532,
 11959,
 -1,
 80659878,
 11991,
 -1,
 80487067,
 11904,
 80872663,
 80465454,
 -1,
 80938197,
 80864650,
 -1,
 -64300,
 80906481,
 11954,
 -1,
 80971795,
 11955,
 -64298,
 80916792,
 11953,
 -1,
 81079939,
 11956,
 81265886,
 80840397,
 -1,
 81331421,
 81235103,
 -1,
 81396956,
 81323402,
 -1,
 -64293,
 81365233,
 11967,
 -1,
 81430547,
 11968,
 -1,
 81375544,
 11966,
 -1,
 81321049,
 12004,
 81724643,
 81254816,
 -1,
 81790178,
 81689255,
 -1,
 -64287,
 81741083,
 11941,
 -1,
 81834296,
 11940,
 -1,
 81771696,
 11909,
 82052327,
 81705211,
 -1,
 -64283,
 81995451,
 11944,
 -64282,
 82075650,
 11914,
 -1,
 82147126,
 11934,
 82314474,
 82042689,
 -1,
 -64279,
 82265371,
 11913,
 -1,
 82358584,
 11912,
 82511085,
 82266183,
 -1,
 -64276,
 82458543,
 11978,
 -1,
 82516209,
 11939,
 -1,
 82487303,
 11961,
 82837503,
 71214353,
 -1,
 82838781,
 82756498,
 12752,
 82904313,
 82804683,
 12757,
 82969845,
 82870219,
 12741,
 83035380,
 82935755,
 12750,
 -1,
 83003085,
 12769,
 -1,
 83024288,
 12747,
 83231991,
 82948933,
 12749,
 -1,
 83199693,
 12744,
 -64264,
 83223946,
 12746,
 -1,
 83330765,
 12742,
 83494139,
 82893216,
 12743,
 -1,
 83462367,
 12748,
 -64260,
 83463836,
 12768,
 -1,
 83592909,
 12758,
 83756295,
 82814862,
 12753,
 83821825,
 83722187,
 12759,
 -64256,
 83787723,
 12766,
 -1,
 83855583,
 12745,
 84018436,
 83800901,
 12740,
 -64253,
 83984331,
 12760,
 -1,
 84051661,
 12767,
 -64251,
 84010378,
 12761,
 -64250,
 84203936,
 12755,
 -1,
 84248269,
 12762,
 84411659,
 83745184,
 12754,
 -64247,
 84377547,
 12764,
 -64246,
 84444877,
 12770,
 -1,
 84523259,
 12763,
 84673805,
 84403594,
 12736,
 -1,
 84630824,
 12765,
 -64242,
 84645552,
 12738,
 -64241,
 84773087,
 12737,
 -64240,
 84815165,
 12771,
 -64239,
 84892968,
 12751,
 -64238,
 84982011,
 12756,
 -1,
 85058597,
 12739,
 85199338,
 79713,
 -1,
 85264864,
 85142244,
 -1,
 85330255,
 85206277,
 -1,
 85394861,
 85296845,
 -1,
 85460340,
 85328691,
 73909,
 85525858,
 85398544,
 73911,
 85655551,
 85480489,
 -1,
 85656929,
 85543258,
 -1,
 85722404,
 85590835,
 -1,
 85787936,
 85703389,
 -1,
 -64226,
 85777259,
 73914,
 -64225,
 85834163,
 73913,
 -1,
 85893699,
 73912,
 86050082,
 85743266,
 73917,
 -1,
 86001941,
 73918,
 -64221,
 86007080,
 73916,
 -1,
 86164254,
 73915,
 86312237,
 85698446,
 -1,
 86377769,
 86295442,
 -1,
 86443304,
 86314284,
 73957,
 -1,
 86394874,
 73958,
 -1,
 86427058,
 73959,
 86639916,
 86311731,
 -1,
 -64213,
 86619399,
 73956,
 -1,
 86691471,
 73955,
 -1,
 86601893,
 73960,
 86902069,
 86279885,
 -1,
 86967602,
 86841501,
 73933,
 87033137,
 86936717,
 73934,
 -1,
 86988092,
 73935,
 -1,
 86972768,
 73936,
 87293951,
 86901555,
 -1,
 -64204,
 87209223,
 73932,
 -1,
 87269594,
 73931,
 87426364,
 86872375,
 -1,
 87491896,
 87410098,
 73946,
 -1,
 87479099,
 73947,
 87622971,
 87425843,
 -1,
 -64198,
 87564052,
 73945,
 -1,
 87658807,
 73944,
 -1,
 87577494,
 73948,
 87885123,
 87409554,
 -1,
 87950657,
 87819059,
 -1,
 88016192,
 87936655,
 73938,
 -1,
 87995858,
 73939,
 -1,
 87984609,
 73937,
 -64190,
 87908012,
 73941,
 -1,
 88205259,
 73940,
 88343880,
 87821612,
 -1,
 88409414,
 88300840,
 73929,
 -1,
 88395733,
 73930,
 88604671,
 88395407,
 73927,
 -1,
 88520146,
 73928,
 88671565,
 88324347,
 -1,
 88737099,
 88610973,
 73924,
 -1,
 88688613,
 73925,
 -64180,
 88699087,
 73926,
 -1,
 88802099,
 73923,
 88999251,
 88620480,
 -1,
 89064784,
 88988909,
 73921,
 -1,
 89016305,
 73922,
 89260031,
 88998707,
 -1,
 -64174,
 89180319,
 73920,
 -1,
 89241851,
 73919,
 89392470,
 88946529,
 73962,
 89522175,
 89372923,
 73963,
 -1,
 89429244,
 73964,
 89589080,
 89371544,
 73952,
 -1,
 89527095,
 73953,
 89720155,
 89530964,
 -1,
 -64166,
 89659549,
 73951,
 -1,
 89750948,
 73950,
 89916766,
 89659549,
 -1,
 -64163,
 89897179,
 73943,
 -1,
 89928683,
 73942,
 -64161,
 89905133,
 73961,
 -64160,
 90066296,
 73954,
 -1,
 90112766,
 73949,
 -1,
 85609763,
 73965,
 90375528,
 85482792,
 73974,
 90505215,
 90313744,
 73975,
 90570751,
 90395689,
 -1,
 -64154,
 90458028,
 73976,
 -64153,
 90524108,
 73977,
 -1,
 90576614,
 73978,
 90768747,
 90361487,
 73970,
 -64150,
 90726915,
 73972,
 -1,
 90821928,
 73971,
 90965357,
 90748167,
 73979,
 -1,
 90918509,
 73980,
 91096431,
 90945787,
 73968,
 -1,
 91050206,
 73969,
 91227505,
 91083265,
 73966,
 -1,
 91210078,
 73967,
 -64142,
 91168168,
 73981,
 -64141,
 91300436,
 73973,
 -1,
 91403347,
 73910,
 91555219,
 85399709,
 73984,
 91620735,
 91534599,
 -1,
 91686269,
 91573869,
 73994,
 91815935,
 91649226,
 -1,
 -64135,
 91704696,
 73999,
 -64134,
 91775304,
 73998,
 -64133,
 91872107,
 73997,
 -64132,
 91901329,
 73996,
 -1,
 91982688,
 73995,
 92209151,
 91624464,
 73992,
 -1,
 92124243,
 73993,
 92276105,
 91596686,
 -1,
 92341640,
 92259218,
 74001,
 92471295,
 92296233,
 -1,
 92472711,
 92398986,
 -1,
 92538246,
 92421388,
 -1,
 -64123,
 92526573,
 74004,
 -1,
 92541152,
 74003,
 -1,
 92520712,
 74005,
 -1,
 92462544,
 74002,
 -1,
 92299782,
 74000,
 92931469,
 92245133,
 73988,
 93061119,
 92886057,
 -1,
 -64116,
 92934958,
 73989,
 -1,
 93044763,
 73990,
 93193618,
 92886057,
 -1,
 93259153,
 93145434,
 -1,
 -64112,
 93206369,
 73986,
 -1,
 93261100,
 73985,
 -1,
 93206328,
 73987,
 -1,
 93132819,
 73991,
 93586859,
 91502433,
 74006,
 93652380,
 93525008,
 74008,
 93782015,
 93606953,
 -1,
 93783451,
 93669722,
 -1,
 93848985,
 93721185,
 74009,
 -1,
 93801085,
 74010,
 -64102,
 93826183,
 74012,
 -1,
 93959064,
 74011,
 -1,
 93753981,
 74013,
 94176673,
 93631751,
 74021,
 94242208,
 94123873,
 -1,
 -64097,
 94197410,
 74024,
 -1,
 94264616,
 74023,
 -1,
 94197890,
 74022,
 94504359,
 94157051,
 74014,
 94633983,
 94458921,
 -1,
 94635430,
 94521690,
 -1,
 -64091,
 94593228,
 74016,
 -1,
 94669778,
 74015,
 -1,
 94575643,
 74017,
 94897577,
 94446164,
 74019,
 -1,
 94859099,
 74020,
 -64086,
 94883471,
 74018,
 -1,
 94995342,
 74007,
 95223807,
 93519890,
 73982,
 -1,
 95136960,
 73983,
 95290934,
 85380751,
 -1,
 95356418,
 95224627,
 74167,
 95421948,
 95334035,
 -1,
 95487478,
 95370688,
 74168,
 95617023,
 95441961,
 -1,
 95618549,
 95504730,
 -1,
 95684027,
 95552307,
 74169,
 95749560,
 95664861,
 -1,
 -64074,
 95738290,
 74172,
 -64073,
 95791496,
 74171,
 -1,
 95855171,
 74170,
 -64071,
 95721928,
 74175,
 -64070,
 95968552,
 74174,
 -1,
 96063119,
 74173,
 96208322,
 95631201,
 74213,
 96273855,
 96189149,
 -1,
 -64066,
 96220446,
 74215,
 -1,
 96273203,
 74214,
 -64064,
 96229026,
 74218,
 -64063,
 96450811,
 74217,
 -1,
 96505100,
 74216,
 96667083,
 96184206,
 -1,
 96732618,
 96650130,
 -1,
 96798150,
 96720791,
 74207,
 -1,
 96782837,
 74208,
 96929225,
 96743720,
 -1,
 -64056,
 96880556,
 74206,
 -1,
 96987150,
 74205,
 -1,
 96909278,
 74204,
 -1,
 96694437,
 74209,
 97256914,
 96637239,
 -1,
 97322448,
 97204065,
 -1,
 97387983,
 97308303,
 74194,
 -1,
 97335808,
 74195,
 -1,
 97341037,
 74193,
 97648639,
 97261725,
 74191,
 -1,
 97541416,
 74192,
 97715671,
 97242767,
 -1,
 97781205,
 97662817,
 74198,
 -1,
 97767055,
 74199,
 -64042,
 97744533,
 74197,
 -1,
 97873022,
 74196,
 98043357,
 97654941,
 -1,
 98108892,
 97985108,
 74188,
 98238463,
 98089693,
 -1,
 -64037,
 98108205,
 74190,
 -1,
 98220467,
 74189,
 -1,
 98055147,
 74187,
 98436578,
 98010829,
 -1,
 98502112,
 98398406,
 74182,
 -1,
 98475064,
 74183,
 98697215,
 98435891,
 74180,
 -1,
 98612487,
 74181,
 98764263,
 98428298,
 -1,
 98829798,
 98698035,
 -1,
 -64027,
 98819964,
 74211,
 -1,
 98862797,
 74210,
 -1,
 98799687,
 74212,
 99091947,
 98706004,
 -1,
 99157482,
 99028268,
 74200,
 -1,
 99099329,
 74201,
 -1,
 99126892,
 74202,
 99354095,
 99074962,
 -1,
 99419630,
 99287859,
 74184,
 -1,
 99405455,
 74185,
 -1,
 99369595,
 74186,
 99616242,
 99302848,
 -1,
 -64015,
 99555485,
 74177,
 -1,
 99639793,
 74176,
 -64013,
 99556131,
 74203,
 -64012,
 99784117,
 74179,
 -1,
 99825423,
 74178,
 -1,
 95569317,
 74219,
 100139007,
 95466759,
 74220,
 100204543,
 100029481,
 -1,
 100206074,
 100130602,
 74221,
 -1,
 100165537,
 74222,
 100401151,
 100176509,
 74223,
 -1,
 100328946,
 74224,
 100468223,
 95363668,
 74228,
 100597759,
 100445376,
 74229,
 -1,
 100485158,
 74230,
 100664833,
 100454031,
 74226,
 -1,
 100606123,
 74227,
 -1,
 100612497,
 74225,
 100861490,
 95303521,
 74235,
 100927013,
 100799504,
 74237,
 101056511,
 100881449,
 -1,
 101058080,
 100984202,
 -1,
 101123615,
 101006604,
 -1,
 101189133,
 101093687,
 -1,
 101254668,
 101147121,
 -1,
 101320203,
 101207661,
 74246,
 -1,
 101298299,
 74247,
 -1,
 101258256,
 74245,
 -1,
 101193885,
 74248,
 101582352,
 101144223,
 -1,
 -63985,
 101549652,
 74255,
 -1,
 101625979,
 74254,
 101778963,
 101539112,
 -1,
 -63982,
 101726049,
 74253,
 -1,
 101780780,
 74252,
 101975574,
 101712638,
 -1,
 -63979,
 101931045,
 74250,
 -1,
 102019195,
 74249,
 102172184,
 101956025,
 74240,
 -1,
 102141610,
 74241,
 -63975,
 102134961,
 74256,
 -63974,
 102251308,
 74251,
 -63973,
 102352288,
 74244,
 -63972,
 102385668,
 74243,
 -63971,
 102452625,
 74242,
 -63970,
 102502624,
 74239,
 -1,
 102588934,
 74238,
 -1,
 101105928,
 74257,
 102827555,
 101033870,
 -1,
 -63966,
 102796326,
 74260,
 -1,
 102834774,
 74261,
 -63964,
 102766931,
 74259,
 -1,
 102972226,
 74258,
 103155243,
 100903320,
 74263,
 103284735,
 103109673,
 -1,
 103286314,
 103193848,
 -1,
 -63959,
 103228895,
 74264,
 -1,
 103319622,
 74265,
 -1,
 103277857,
 74266,
 103548462,
 103096916,
 74269,
 103677951,
 103504542,
 74270,
 -1,
 103593886,
 74271,
 -63953,
 103534223,
 74268,
 -63952,
 103728018,
 74267,
 -63951,
 103763565,
 74262,
 -1,
 103844843,
 74236,
 104071167,
 100800669,
 74231,
 -63948,
 103962274,
 74234,
 -63947,
 104055961,
 74233,
 -1,
 104124047,
 74232,
 104269483,
 95260983,
 -1,
 104334993,
 104203059,
 74071,
 104400507,
 104297674,
 -1,
 104465990,
 104367821,
 -1,
 104531519,
 104399667,
 74082,
 104597053,
 104510727,
 74085,
 -1,
 104587197,
 74086,
 -63938,
 104571098,
 74084,
 -1,
 104713871,
 74083,
 104859204,
 104470685,
 74087,
 104924739,
 104800373,
 -1,
 -63934,
 104900563,
 74089,
 -1,
 104979920,
 74090,
 -1,
 104876478,
 74088,
 105250815,
 104806241,
 74091,
 -1,
 105138616,
 74092,
 105317968,
 104441742,
 -1,
 105383500,
 105300882,
 -1,
 -63927,
 105330529,
 74115,
 -63926,
 105432498,
 74114,
 -63925,
 105450796,
 74113,
 -1,
 105513779,
 74112,
 105711182,
 105317171,
 74110,
 -1,
 105690375,
 74111,
 -63921,
 105647197,
 74117,
 -1,
 105825717,
 74116,
 105973336,
 105259604,
 -1,
 106038870,
 105909548,
 74100,
 106168319,
 106019549,
 -1,
 -63916,
 106062303,
 74103,
 -63915,
 106147484,
 74102,
 -1,
 106200276,
 74101,
 106430463,
 105978013,
 74104,
 -1,
 106320568,
 74105,
 106497629,
 105920353,
 74119,
 -63910,
 106452642,
 74123,
 -63909,
 106538725,
 74122,
 -63908,
 106608891,
 74121,
 -1,
 106632208,
 74120,
 106825315,
 106446272,
 -1,
 106890850,
 106758963,
 -1,
 -63904,
 106870023,
 74078,
 -63903,
 106945044,
 74077,
 -1,
 107002107,
 74076,
 -1,
 106829981,
 74079,
 107218535,
 106758963,
 74072,
 107284070,
 107198715,
 74073,
 -1,
 107226459,
 74074,
 -1,
 107225174,
 74075,
 107480683,
 107188535,
 -1,
 107546218,
 107419805,
 74096,
 -1,
 107526395,
 74097,
 -1,
 107504128,
 74095,
 107742830,
 107437352,
 -1,
 -63891,
 107704509,
 74107,
 -1,
 107744556,
 74106,
 107939441,
 107728527,
 -1,
 -63888,
 107886433,
 74099,
 -1,
 107944093,
 74098,
 108136052,
 107878557,
 -1,
 -63885,
 108077652,
 74094,
 -1,
 108179100,
 74093,
 108332663,
 108072236,
 -1,
 -63882,
 108273750,
 74081,
 -1,
 108341658,
 74080,
 -63880,
 108310299,
 74124,
 -63879,
 108502372,
 74118,
 -63878,
 108546448,
 74109,
 -1,
 108606032,
 74108,
 108791425,
 104380667,
 -1,
 108856958,
 108776006,
 74131,
 -1,
 108817409,
 74132,
 -63873,
 108825741,
 74130,
 -63872,
 108940909,
 74129,
 -1,
 108991504,
 74128,
 109184645,
 108732180,
 74140,
 109314047,
 109138985,
 -1,
 -63868,
 109234102,
 74142,
 -1,
 109292777,
 74141,
 109446793,
 109170319,
 74135,
 109576191,
 109401129,
 -1,
 -63864,
 109449504,
 74136,
 -1,
 109546613,
 74137,
 109708940,
 109388372,
 -1,
 -63861,
 109677709,
 74139,
 -1,
 109712400,
 74138,
 109905550,
 109678903,
 74133,
 -1,
 109857405,
 74134,
 110036624,
 109843472,
 74125,
 -1,
 110007335,
 74126,
 -1,
 109985216,
 74127,
 110233245,
 104281953,
 74154,
 110298772,
 110212359,
 74163,
 -1,
 110241009,
 74164,
 110429846,
 110284431,
 74160,
 -1,
 110408787,
 74161,
 110560920,
 110398605,
 74157,
 -1,
 110493906,
 74158,
 -63847,
 110548383,
 74165,
 -63846,
 110648616,
 74162,
 -63845,
 110712962,
 74159,
 -63844,
 110775917,
 74156,
 -1,
 110849274,
 74155,
 111019689,
 110172317,
 74144,
 111085219,
 110995342,
 -1,
 111150753,
 111067545,
 74152,
 -1,
 111125070,
 74153,
 -63838,
 111133586,
 74151,
 -1,
 111239686,
 74150,
 111412903,
 111047882,
 -1,
 111478438,
 111359841,
 74146,
 -1,
 111458555,
 74147,
 -1,
 111415520,
 74145,
 -63832,
 111369512,
 74149,
 -1,
 111655163,
 74148,
 -63830,
 110986975,
 74166,
 -1,
 111786425,
 74143,
 111937298,
 104245134,
 -1,
 112002787,
 111920018,
 -1,
 112068294,
 111941789,
 -1,
 112133820,
 112009812,
 74438,
 112263167,
 112096458,
 -1,
 112264882,
 112188267,
 74444,
 -1,
 112243795,
 74445,
 112395957,
 112213440,
 -1,
 -63820,
 112377754,
 74441,
 -1,
 112419334,
 74440,
 -63818,
 112374306,
 74449,
 -63817,
 112571052,
 74448,
 -63816,
 112599363,
 74447,
 -63815,
 112704920,
 74446,
 -63814,
 112765320,
 74443,
 -63813,
 112793623,
 74442,
 -1,
 112853811,
 74439,
 113051328,
 112112903,
 74451,
 113180671,
 113005609,
 -1,
 -63809,
 113067948,
 74452,
 -1,
 113132461,
 74453,
 113313476,
 113031419,
 74435,
 113442815,
 113276106,
 -1,
 -63805,
 113362336,
 74437,
 -1,
 113378099,
 74436,
 -63803,
 113271266,
 74454,
 -1,
 113557569,
 74450,
 113706708,
 112001843,
 74413,
 113772241,
 113659501,
 74414,
 113901567,
 113734858,
 -1,
 113903307,
 113784673,
 74421,
 -1,
 113857852,
 74422,
 -63796,
 113851873,
 74420,
 -63795,
 114021791,
 74419,
 -63794,
 114039587,
 74418,
 -63793,
 114120079,
 74417,
 -63792,
 114168032,
 74416,
 -1,
 114230067,
 74415,
 -63790,
 113723838,
 74425,
 -63789,
 114415304,
 74424,
 -1,
 114433650,
 74423,
 114624223,
 113642796,
 74426,
 114689752,
 114579106,
 74432,
 -63785,
 114660613,
 74434,
 -1,
 114693136,
 74433,
 114886365,
 114644009,
 -1,
 114951900,
 114841844,
 -1,
 -63781,
 114926499,
 74429,
 -1,
 114953696,
 74428,
 -1,
 114932120,
 74427,
 -63778,
 114842920,
 74431,
 -1,
 115191386,
 74430,
 115408895,
 114571105,
 74455,
 -63775,
 115294292,
 74458,
 -63774,
 115348496,
 74457,
 -1,
 115432513,
 74456,
 115607298,
 111936307,
 74387,
 115672830,
 115574477,
 74389,
 115802111,
 115627049,
 -1,
 115803899,
 115689818,
 -1,
 115869421,
 115750753,
 -1,
 -63767,
 115824290,
 74406,
 -63766,
 115913991,
 74405,
 -63765,
 115941972,
 74404,
 -63764,
 116014528,
 74403,
 -1,
 116069392,
 74402,
 116262640,
 115845006,
 -1,
 -63761,
 116221349,
 74400,
 -1,
 116285958,
 74399,
 116459251,
 116232503,
 -1,
 -63758,
 116448493,
 74395,
 -1,
 116482560,
 74394,
 116655861,
 116423892,
 74391,
 -1,
 116604352,
 74392,
 -63754,
 116625405,
 74401,
 -63753,
 116765592,
 74398,
 -63752,
 116789170,
 74397,
 -63751,
 116859207,
 74396,
 -63750,
 116963763,
 74393,
 -1,
 116982579,
 74390,
 -63748,
 115779233,
 74407,
 -63747,
 117122448,
 74388,
 -1,
 117215869,
 74408,
 117376768,
 115658383,
 74409,
 -1,
 117330482,
 74410,
 -63743,
 117355783,
 74412,
 -1,
 117487413,
 74411,
 117638923,
 115554145,
 74466,
 117704453,
 117617927,
 74473,
 -1,
 117691652,
 74474,
 117835527,
 117645908,
 74471,
 -1,
 117823220,
 74472,
 117966601,
 117815547,
 74468,
 -1,
 117904400,
 74469,
 -63734,
 117921108,
 74470,
 -1,
 118048556,
 74467,
 118292479,
 117577885,
 74459,
 118294287,
 118195917,
 74461,
 118423551,
 118262925,
 74462,
 -1,
 118306087,
 74463,
 -63728,
 118282507,
 74465,
 -63727,
 118480742,
 74464,
 -1,
 118535251,
 74460,
 118687606,
 111884129,
 74507,
 118753094,
 118666503,
 74536,
 118818611,
 118699873,
 74551,
 118884145,
 118781130,
 -1,
 118949660,
 118851277,
 -1,
 119015195,
 118883123,
 74556,
 -63719,
 118994183,
 74559,
 -63718,
 119054554,
 74558,
 -1,
 119131791,
 74557,
 -1,
 118962017,
 74560,
 119342880,
 118896481,
 -1,
 -63714,
 119288676,
 74574,
 -63713,
 119388411,
 74573,
 -1,
 119446584,
 74572,
 119605028,
 119281821,
 -1,
 -63710,
 119559842,
 74564,
 -63709,
 119611988,
 74563,
 -1,
 119713436,
 74562,
 119867175,
 119580558,
 -1,
 -63706,
 119855761,
 74570,
 -1,
 119912886,
 74569,
 120063785,
 119800627,
 74552,
 -1,
 120030015,
 74553,
 -63702,
 120021423,
 74571,
 -63701,
 120147320,
 74568,
 -63700,
 120212844,
 74567,
 -63699,
 120267079,
 74566,
 -63698,
 120381397,
 74565,
 -63697,
 120437171,
 74561,
 -63696,
 120481990,
 74555,
 -1,
 120524994,
 74554,
 120782847,
 118851600,
 74575,
 -1,
 120692396,
 74576,
 120850240,
 118756368,
 74539,
 120979455,
 120812746,
 -1,
 120981305,
 120903575,
 74545,
 121110527,
 120961757,
 -1,
 -63688,
 121007733,
 74547,
 -1,
 121100020,
 74546,
 121243454,
 120914739,
 -1,
 121308989,
 121223901,
 -1,
 -63684,
 121248541,
 74541,
 -1,
 121354675,
 74540,
 -1,
 121294479,
 74542,
 -63681,
 121222040,
 74544,
 -1,
 121551283,
 74543,
 121702210,
 120789149,
 74549,
 -1,
 121654893,
 74550,
 121833285,
 121656361,
 -1,
 -63676,
 121824545,
 74538,
 -1,
 121886363,
 74537,
 -1,
 121801869,
 74548,
 122095442,
 118733051,
 74515,
 122160977,
 122049577,
 -1,
 122226509,
 122112346,
 -1,
 122292043,
 122176277,
 74519,
 -1,
 122270803,
 74520,
 -63668,
 122228658,
 74518,
 -1,
 122360032,
 74517,
 122554191,
 122217761,
 74522,
 -1,
 122522603,
 74523,
 -63664,
 122535320,
 74516,
 -1,
 122655357,
 74521,
 -1,
 122122441,
 74524,
 122881885,
 122036820,
 74525,
 122947416,
 122844362,
 -1,
 -63659,
 122894177,
 74529,
 -63658,
 122953133,
 74528,
 -63657,
 123055222,
 74527,
 -1,
 123081602,
 74526,
 123275100,
 122908837,
 74531,
 123404287,
 123237578,
 -1,
 -63653,
 123293048,
 74533,
 -1,
 123350045,
 74532,
 -1,
 123220108,
 74530,
 123602790,
 122836642,
 74577,
 123668323,
 123565258,
 -1,
 123733857,
 123658212,
 74579,
 -1,
 123712775,
 74580,
 -63646,
 123721709,
 74581,
 -1,
 123798323,
 74578,
 -63644,
 123602863,
 74582,
 -63643,
 123971559,
 74584,
 -1,
 123999248,
 74583,
 124192621,
 123556905,
 -1,
 124258155,
 124170957,
 -1,
 -63639,
 124204194,
 74512,
 -63638,
 124257825,
 74511,
 -1,
 124351626,
 74510,
 -63636,
 124236141,
 74509,
 -1,
 124474635,
 74508,
 124651377,
 124157899,
 -1,
 124716912,
 124604013,
 74586,
 -1,
 124683788,
 74587,
 -1,
 124663649,
 74588,
 124913523,
 124607784,
 74534,
 -1,
 124892243,
 74535,
 -63628,
 124892805,
 74585,
 -63627,
 124992960,
 74514,
 -1,
 125047824,
 74513,
 125241285,
 118620979,
 73728,
 125306766,
 125189568,
 73738,
 125372295,
 125260841,
 -1,
 125437830,
 125323610,
 -1,
 125503357,
 125376669,
 -1,
 -63620,
 125455724,
 73745,
 -1,
 125514731,
 73744,
 125699968,
 125480595,
 -1,
 -63617,
 125673690,
 73742,
 -1,
 125750927,
 73741,
 -63615,
 125649685,
 73748,
 -63614,
 125860980,
 73747,
 -63613,
 125899650,
 73746,
 -63612,
 126007731,
 73743,
 -63611,
 126054729,
 73740,
 -1,
 126142976,
 73739,
 -1,
 125407869,
 73749,
 126418943,
 125309968,
 73750,
 126484479,
 126317770,
 -1,
 -63606,
 126408685,
 73755,
 -63605,
 126426541,
 73754,
 -63604,
 126499628,
 73753,
 -63603,
 126569873,
 73752,
 -1,
 126647726,
 73751,
 126814107,
 125292175,
 73760,
 126879641,
 126776522,
 -1,
 126945171,
 126849335,
 -1,
 -63598,
 126883997,
 73766,
 -1,
 126990990,
 73765,
 -63596,
 126914156,
 73768,
 -63595,
 127126604,
 73767,
 -63594,
 127187379,
 73764,
 -63593,
 127227279,
 73763,
 -63592,
 127276930,
 73762,
 -1,
 127361542,
 73761,
 -63590,
 126832796,
 73770,
 -1,
 127492620,
 73769,
 127666087,
 126789518,
 -1,
 127731622,
 127648658,
 73784,
 127797156,
 127685673,
 -1,
 127862690,
 127777666,
 -1,
 127928225,
 127816038,
 73788,
 -1,
 127889990,
 73789,
 -1,
 127916245,
 73787,
 -63581,
 127811684,
 73785,
 -1,
 128101074,
 73786,
 -63579,
 127752229,
 73791,
 -1,
 128193552,
 73790,
 -1,
 127720415,
 73783,
 128452528,
 127628490,
 -1,
 -63575,
 128430637,
 73736,
 -63574,
 128477751,
 73735,
 -63573,
 128571024,
 73734,
 -63572,
 128637803,
 73733,
 -63571,
 128694707,
 73732,
 -63570,
 128732561,
 73731,
 -63569,
 128782560,
 73730,
 -1,
 128844595,
 73729,
 129042360,
 128408872,
 73773,
 129107895,
 128996393,
 -1,
 129173429,
 129062903,
 -1,
 -63564,
 129123749,
 73777,
 -1,
 129171633,
 73776,
 -63562,
 129118222,
 73775,
 -1,
 129309628,
 73774,
 -1,
 129092684,
 73778,
 129566652,
 129021191,
 -1,
 129632187,
 129524209,
 73780,
 -1,
 129608896,
 73781,
 -1,
 129569369,
 73782,
 129828800,
 129536311,
 73757,
 129957887,
 129791178,
 -1,
 -63553,
 129877178,
 73759,
 -1,
 129898358,
 73758,
 130090946,
 129775708,
 73771,
 -1,
 130051931,
 73772,
 -63549,
 130047699,
 73779,
 -63548,
 130201851,
 73756,
 -1,
 130225168,
 73737,
 130418703,
 125197608,
 -1,
 130484195,
 130365281,
 74337,
 130549730,
 130440488,
 74339,
 130615255,
 130510984,
 74349,
 130744319,
 130569257,
 -1,
 130746325,
 130662106,
 -1,
 -63540,
 130733975,
 74359,
 -63539,
 130771651,
 74358,
 -63538,
 130816803,
 74357,
 -63537,
 130876158,
 74356,
 -63536,
 130940953,
 74355,
 -63535,
 131056581,
 74354,
 -63534,
 131093771,
 74353,
 -63533,
 131148819,
 74352,
 -63532,
 131231349,
 74351,
 -1,
 131290471,
 74350,
 131530751,
 130696417,
 74360,
 -1,
 131440493,
 74361,
 131661823,
 130569257,
 -1,
 131663838,
 131567190,
 -1,
 131729371,
 131641890,
 74342,
 -1,
 131692080,
 74343,
 -63524,
 131698284,
 74344,
 -63523,
 131838867,
 74341,
 -1,
 131901832,
 74340,
 132057056,
 131647382,
 74347,
 -1,
 131995638,
 74348,
 -63519,
 132007852,
 74345,
 -1,
 132178317,
 74346,
 -1,
 130516950,
 74338,
 132384766,
 130422941,
 74316,
 132450295,
 132335386,
 74322,
 132579327,
 132412618,
 -1,
 132581355,
 132500556,
 74330,
 132710399,
 132535612,
 -1,
 132712426,
 132601506,
 74332,
 -1,
 132690043,
 74333,
 -1,
 132653343,
 74331,
 132909039,
 132514611,
 -1,
 132974574,
 132863650,
 74324,
 -1,
 132952187,
 74325,
 -1,
 132930856,
 74323,
 133171186,
 132855649,
 -1,
 -63503,
 133125794,
 74335,
 -1,
 133205260,
 74334,
 133367797,
 133127464,
 -1,
 -63500,
 133329085,
 74329,
 -1,
 133369132,
 74328,
 -63498,
 133318221,
 74327,
 -1,
 133518603,
 74326,
 133695483,
 132391508,
 74319,
 133824511,
 133683839,
 -1,
 -63494,
 133714806,
 74321,
 -1,
 133800154,
 74320,
 -63492,
 133673517,
 74336,
 -63491,
 133895184,
 74318,
 -1,
 133962470,
 74317,
 134154249,
 132318003,
 74302,
 134219781,
 134131347,
 74304,
 134285316,
 134173737,
 -1,
 -63486,
 134257190,
 74306,
 -63485,
 134317849,
 74307,
 -1,
 134372650,
 74305,
 -1,
 134264071,
 74308,
 134613000,
 134160980,
 74310,
 -63481,
 134550544,
 74311,
 -1,
 134654653,
 74309,
 -1,
 134550544,
 74303,
 134938623,
 134090028,
 74312,
 135004159,
 134829097,
 -1,
 135006222,
 134891866,
 -1,
 -63475,
 134967494,
 74314,
 -1,
 135004979,
 74313,
 -1,
 134997281,
 74315,
 135268429,
 130398459,
 -1,
 135333940,
 135201587,
 73813,
 135399471,
 135300813,
 73814,
 135528447,
 135339994,
 -1,
 135530521,
 135431885,
 -1,
 135596054,
 135469213,
 73821,
 -1,
 135547326,
 73822,
 135727128,
 135529267,
 73819,
 -1,
 135661231,
 73820,
 -1,
 135688390,
 73823,
 135923742,
 135515791,
 -1,
 135989277,
 135870305,
 73829,
 -63460,
 135930452,
 73831,
 -1,
 136043016,
 73830,
 -1,
 135922483,
 73828,
 136251425,
 135870305,
 -1,
 -63456,
 136205986,
 73837,
 -1,
 136291583,
 73836,
 136448035,
 136234372,
 73825,
 -1,
 136426910,
 73826,
 136579110,
 136396224,
 -1,
 -63451,
 136517789,
 73818,
 -1,
 136590726,
 73817,
 136775721,
 136512307,
 -1,
 -63448,
 136722524,
 73816,
 -1,
 136775343,
 73815,
 -63446,
 136763373,
 73835,
 -63445,
 136926879,
 73834,
 -63444,
 136973678,
 73833,
 -63443,
 137042723,
 73832,
 -63442,
 137106017,
 73827,
 -1,
 137214387,
 73824,
 137365555,
 135378183,
 73839,
 137494527,
 137298739,
 -1,
 -63438,
 137399437,
 73841,
 -1,
 137449069,
 73840,
 -1,
 137306708,
 73838,
 137693253,
 135280481,
 73850,
 137758778,
 137649448,
 73860,
 137824313,
 137711213,
 73861,
 137953279,
 137802835,
 73862,
 -1,
 137868371,
 73863,
 -1,
 137792653,
 73864,
 138086461,
 137706944,
 73854,
 -63428,
 138023952,
 73856,
 -1,
 138084839,
 73855,
 138283073,
 138040361,
 -1,
 -63425,
 138274081,
 73853,
 -63424,
 138312586,
 73851,
 -1,
 138383997,
 73852,
 138545219,
 138249933,
 73857,
 -1,
 138506438,
 73858,
 -63420,
 138496446,
 73865,
 -1,
 138658706,
 73859,
 138870783,
 137631901,
 73842,
 138872905,
 138748500,
 73844,
 -63416,
 138810384,
 73846,
 -1,
 138899291,
 73845,
 139069515,
 138829096,
 73847,
 -1,
 139011011,
 73848,
 -63412,
 139024034,
 73849,
 -1,
 139148736,
 73843,
 139331714,
 135204140,
 73866,
 139397222,
 139283543,
 73889,
 139526143,
 139359434,
 -1,
 139528277,
 139447951,
 -1,
 139593811,
 139461427,
 73903,
 -1,
 139582462,
 73904,
 -63404,
 139540321,
 73906,
 -1,
 139663517,
 73905,
 139855961,
 139461427,
 73890,
 139921496,
 139842363,
 73891,
 -1,
 139862187,
 73892,
 -1,
 139877672,
 73893,
 140118109,
 139825463,
 -1,
 140183644,
 140057187,
 73900,
 -1,
 140156112,
 73901,
 -1,
 140144540,
 73902,
 140380256,
 140064609,
 -1,
 -63393,
 140359931,
 73908,
 -1,
 140383248,
 73907,
 140576866,
 140360115,
 73897,
 -1,
 140555347,
 73898,
 140707940,
 140538185,
 73895,
 -1,
 140686419,
 73896,
 -63387,
 140690373,
 73899,
 -1,
 140775648,
 73894,
 140970095,
 139353384,
 73879,
 141099007,
 140923945,
 -1,
 141101164,
 140986714,
 -1,
 141166699,
 141082275,
 73880,
 -1,
 141135530,
 73881,
 -1,
 141103011,
 73882,
 -63379,
 141051301,
 73885,
 -63378,
 141295679,
 73884,
 -1,
 141373185,
 73883,
 141559928,
 140907536,
 73869,
 141688831,
 141522122,
 -1,
 141690996,
 141600654,
 -1,
 -63373,
 141670838,
 73874,
 -1,
 141713926,
 73873,
 -63371,
 141637473,
 73875,
 -63370,
 141823922,
 73872,
 -63369,
 141928840,
 73871,
 -1,
 141977835,
 73870,
 142149755,
 141538567,
 -1,
 -63366,
 142100239,
 73887,
 -1,
 142185909,
 73886,
 142346366,
 142103593,
 -1,
 -63363,
 142307835,
 73867,
 -1,
 142370135,
 73868,
 -63361,
 142286934,
 73888,
 -63360,
 142528143,
 73878,
 -63359,
 142592776,
 73877,
 -1,
 142612503,
 73876,
 142805161,
 139322762,
 -1,
 142870681,
 142738227,
 74475,
 142936205,
 142837453,
 74483,
 143065087,
 142898378,
 -1,
 143067273,
 142956194,
 -1,
 -63352,
 143013729,
 74487,
 -1,
 143068460,
 74486,
 -63350,
 143028422,
 74489,
 -63349,
 143226033,
 74488,
 -63348,
 143283467,
 74485,
 -1,
 143355509,
 74484,
 143526035,
 142890025,
 -1,
 143591569,
 143477082,
 -1,
 -63344,
 143527858,
 74478,
 -1,
 143636891,
 74477,
 -63342,
 143561341,
 74479,
 -1,
 143753585,
 74476,
 143919255,
 143474112,
 74480,
 144048127,
 143873065,
 -1,
 -63338,
 143934885,
 74482,
 -1,
 144033565,
 74481,
 -63336,
 143897863,
 74491,
 -1,
 144170876,
 74490,
 144312481,
 142809245,
 74494,
 144378015,
 144291079,
 74497,
 144506879,
 144331817,
 -1,
 144509086,
 144414795,
 74499,
 -1,
 144495912,
 74500,
 -1,
 144475415,
 74498,
 -63328,
 144363151,
 74496,
 -1,
 144674474,
 74495,
 144836775,
 144258913,
 74501,
 144902308,
 144815367,
 74505,
 -1,
 144859869,
 74506,
 -63323,
 144843348,
 74504,
 -63322,
 145002807,
 74503,
 -1,
 145075789,
 74502,
 145293311,
 144772396,
 74492,
 -1,
 145208403,
 74493,
 145361101,
 142746196,
 -1,
 145426624,
 145307489,
 74284,
 145492155,
 145381026,
 74290,
 145557684,
 145445929,
 -1,
 145623217,
 145508698,
 -1,
 -63313,
 145600297,
 74293,
 -63312,
 145645772,
 74292,
 -1,
 145687347,
 74291,
 145885363,
 145573708,
 74294,
 -1,
 145820636,
 74295,
 -1,
 145819036,
 74296,
 146145279,
 145509997,
 74297,
 146210815,
 146035753,
 -1,
 146213050,
 146098522,
 -1,
 146278585,
 146146099,
 74298,
 -1,
 146248992,
 74299,
 -1,
 146245632,
 74300,
 -1,
 146182781,
 74301,
 146540733,
 145458893,
 74286,
 -1,
 146519123,
 74287,
 -63298,
 146495771,
 74289,
 -63297,
 146658201,
 74288,
 -1,
 146693789,
 74285,
 146868425,
 145359667,
 74272,
 146933955,
 146822818,
 74278,
 -1,
 146871312,
 74279,
 147065030,
 146887721,
 -1,
 -63291,
 147031319,
 74273,
 -1,
 147100285,
 74274,
 -63289,
 147043591,
 74277,
 -63288,
 147243922,
 74276,
 -1,
 147264528,
 74275,
 147458251,
 146806941,
 74282,
 -1,
 147414312,
 74283,
 147652607,
 147393836,
 74280,
 -1,
 147564430,
 74281,
 147720424,
 145299613,
 74047,
 147785941,
 147661396,
 74062,
 147851476,
 147739689,
 -1,
 -63279,
 147817751,
 74063,
 -63278,
 147867045,
 74066,
 -63277,
 147918965,
 74065,
 -1,
 147996583,
 74064,
 -1,
 147834278,
 74067,
 148244700,
 147752653,
 74053,
 148373503,
 148183197,
 74054,
 148439039,
 148263977,
 -1,
 -63271,
 148326834,
 74056,
 -63270,
 148416812,
 74057,
 -63269,
 148476541,
 74058,
 -1,
 148510759,
 74055,
 148703455,
 148229775,
 74059,
 -63266,
 148640784,
 74061,
 -1,
 148754389,
 74060,
 148900067,
 148641811,
 74050,
 149028863,
 148887045,
 -1,
 -63262,
 148915621,
 74052,
 -1,
 148979796,
 74051,
 -63260,
 148854434,
 74070,
 -63259,
 149140743,
 74069,
 -63258,
 149183784,
 74068,
 -63257,
 149241280,
 74049,
 -1,
 149331809,
 74048,
 149489922,
 147702674,
 -1,
 149555444,
 149428381,
 74029,
 149684223,
 149517514,
 -1,
 149686509,
 149608180,
 74030,
 -1,
 149623824,
 74031,
 -63250,
 149632865,
 74038,
 -63249,
 149802060,
 74037,
 -63248,
 149861272,
 74036,
 -63247,
 149893609,
 74035,
 -63246,
 149989811,
 74034,
 -63245,
 150044836,
 74033,
 -1,
 150081760,
 74032,
 150276349,
 149501793,
 74039,
 150341884,
 150263537,
 74040,
 150470655,
 150303946,
 -1,
 -63240,
 150368454,
 74045,
 -63239,
 150439928,
 74044,
 -63238,
 150481949,
 74043,
 -63237,
 150571348,
 74042,
 -1,
 150626828,
 74041,
 -1,
 150274934,
 74046,
 150929407,
 150209331,
 74025,
 150931713,
 150819881,
 -1,
 -63232,
 150882220,
 74026,
 -1,
 150966909,
 74027,
 -1,
 150916751,
 74028,
 151193885,
 149477792,
 -1,
 151259416,
 151132317,
 74367,
 151324945,
 151213097,
 -1,
 151390480,
 151275866,
 -1,
 151456008,
 151336801,
 74375,
 -1,
 151393296,
 74376,
 151587082,
 151394461,
 74373,
 -1,
 151535040,
 74374,
 151718157,
 151535040,
 -1,
 -63220,
 151664481,
 74371,
 -1,
 151722141,
 74370,
 151914767,
 151651123,
 74368,
 -1,
 151862720,
 74369,
 -1,
 151850284,
 74372,
 -1,
 151342319,
 74377,
 152240127,
 151292217,
 74378,
 152305663,
 152130601,
 -1,
 152307991,
 152193370,
 -1,
 -63211,
 152284969,
 74381,
 -63210,
 152334534,
 74380,
 -1,
 152375909,
 74379,
 -1,
 152271580,
 74382,
 152635676,
 151192371,
 74362,
 -63206,
 152623520,
 74365,
 -63205,
 152657192,
 74364,
 -1,
 152746235,
 74363,
 -1,
 152615353,
 74366,
 152963382,
 151141824,
 -1,
 153028903,
 152896307,
 73792,
 153094434,
 153013903,
 73796,
 -63199,
 153051636,
 73798,
 -1,
 153095847,
 73797,
 153291044,
 153072903,
 73799,
 -1,
 153225273,
 73800,
 -63195,
 153273631,
 73795,
 -63194,
 153398858,
 73794,
 -1,
 153467131,
 73793,
 153618737,
 152975201,
 73805,
 153684269,
 153572393,
 -1,
 153749804,
 153667220,
 -1,
 -63189,
 153710781,
 73807,
 -1,
 153772523,
 73806,
 -1,
 153720923,
 73808,
 154011951,
 153662727,
 73811,
 -1,
 153949200,
 73812,
 154206207,
 153997052,
 73809,
 -1,
 154090510,
 73810,
 154337279,
 153557149,
 73801,
 154402815,
 154236106,
 -1,
 -63180,
 154321861,
 73804,
 -63179,
 154380680,
 73803,
 -1,
 154403635,
 73802,
 154601802,
 152928203,
 -1,
 154667326,
 154540189,
 74595,
 154732858,
 154615232,
 74598,
 -1,
 154673385,
 74599,
 -63173,
 154709761,
 74601,
 -63172,
 154830541,
 74600,
 -63171,
 154881645,
 74597,
 -1,
 154966012,
 74596,
 155126083,
 154613601,
 74602,
 155191617,
 155109958,
 74603,
 -1,
 155164356,
 74604,
 -63166,
 155132500,
 74606,
 -1,
 155271252,
 74605,
 155453769,
 155058995,
 74589,
 155519303,
 155407401,
 -1,
 -63162,
 155469740,
 74590,
 -1,
 155534025,
 74591,
 -63160,
 155455445,
 74593,
 -1,
 155682509,
 74592,
 -1,
 155424169,
 74594,
 155975679,
 154580231,
 -1,
 155978061,
 155845427,
 74383,
 -1,
 155925952,
 74384,
 -63154,
 155924321,
 74386,
 -1,
 156047517,
 74385,
 156240346,
 85317476,
 -1,
 156305782,
 156190791,
 -1,
 156371301,
 156262070,
 -1,
 156436823,
 156311619,
 74812,
 156502358,
 156390441,
 -1,
 -63147,
 156450240,
 74815,
 -1,
 156500787,
 74814,
 -1,
 156470413,
 74813,
 156764507,
 156384704,
 -1,
 156830042,
 156750538,
 74834,
 -1,
 156762322,
 74835,
 -1,
 156770248,
 74808,
 157026654,
 156704145,
 -1,
 -63139,
 156972897,
 74800,
 -1,
 157029392,
 74790,
 157223265,
 156978910,
 -1,
 -63136,
 157169505,
 74785,
 -1,
 157226000,
 74776,
 157419875,
 157210356,
 74754,
 -1,
 157388458,
 74828,
 -63132,
 157366113,
 74767,
 -1,
 157515940,
 74761,
 157745151,
 156333075,
 -1,
 157747563,
 157656974,
 -1,
 157813098,
 157714814,
 -1,
 -63127,
 157759329,
 74801,
 -1,
 157815824,
 74791,
 -1,
 157764882,
 74844,
 158075247,
 157695424,
 -1,
 158140782,
 158061258,
 74836,
 -1,
 158073042,
 74837,
 -1,
 158080968,
 74809,
 158337394,
 158027486,
 -1,
 -63119,
 158283617,
 74786,
 -1,
 158340112,
 74777,
 158534004,
 158324468,
 74755,
 -1,
 158502570,
 74829,
 -63115,
 158480225,
 74768,
 -1,
 158630052,
 74762,
 158796186,
 156296586,
 -1,
 158861706,
 158779875,
 -1,
 158927229,
 158801297,
 -1,
 158992763,
 158873441,
 74798,
 -1,
 158925010,
 74799,
 159186943,
 158929936,
 74788,
 -1,
 159056082,
 74789,
 159254913,
 158875072,
 -1,
 159320448,
 159195080,
 74806,
 -1,
 159252690,
 74807,
 -1,
 159306442,
 74833,
 159517060,
 159209585,
 -1,
 -63101,
 159487115,
 74811,
 -1,
 159549408,
 74810,
 159713671,
 159469278,
 -1,
 -63098,
 159659873,
 74784,
 -1,
 159716368,
 74775,
 159910281,
 159700724,
 74753,
 -1,
 159878826,
 74827,
 -1,
 159875236,
 74760,
 160169983,
 158850839,
 -1,
 160172430,
 160047736,
 -1,
 -63091,
 160115345,
 74846,
 -1,
 160202916,
 74843,
 160369041,
 160112017,
 -1,
 -63088,
 160315233,
 74797,
 -1,
 160371728,
 74787,
 160565652,
 160321246,
 -1,
 -63085,
 160511841,
 74783,
 -1,
 160568336,
 74774,
 160762263,
 160513472,
 -1,
 -63082,
 160702408,
 74805,
 -1,
 160813770,
 74832,
 160958873,
 160749300,
 74752,
 -1,
 160927402,
 74826,
 -1,
 160925279,
 74841,
 161155505,
 158771086,
 -1,
 161221030,
 161089770,
 -1,
 161286561,
 161181373,
 -1,
 161352096,
 161240105,
 -1,
 -63073,
 161299904,
 74819,
 -1,
 161350451,
 74818,
 -1,
 161304173,
 74817,
 -63070,
 161232737,
 74770,
 -63069,
 161583562,
 74793,
 -63068,
 161641405,
 74779,
 -63067,
 161710244,
 74764,
 -1,
 161797876,
 74757,
 161941934,
 161153054,
 -1,
 162007465,
 161928948,
 74756,
 -1,
 161975978,
 74830,
 -63062,
 161964940,
 74816,
 -63061,
 162084705,
 74769,
 -63060,
 162173386,
 74792,
 -63059,
 162231229,
 74778,
 -1,
 162300068,
 74763,
 162529279,
 161930034,
 -1,
 -63056,
 162418028,
 74803,
 -1,
 162496676,
 74802,
 162662852,
 161127672,
 -1,
 162728385,
 162605462,
 -1,
 162793910,
 162681475,
 -1,
 -63051,
 162736785,
 74845,
 -1,
 162824356,
 74842,
 162990521,
 162746078,
 -1,
 -63048,
 162936673,
 74782,
 -1,
 162993168,
 74773,
 163187132,
 162925868,
 -1,
 -63045,
 163130839,
 74840,
 -1,
 163217103,
 74847,
 163383743,
 163134912,
 -1,
 -63042,
 163323848,
 74804,
 -1,
 163435210,
 74831,
 -63040,
 163331234,
 74796,
 -1,
 163549280,
 74848,
 163774463,
 162698331,
 -1,
 -63037,
 163665619,
 74849,
 -1,
 163757014,
 74850,
 163908050,
 162636878,
 -1,
 163973583,
 163850646,
 -1,
 164039114,
 163955582,
 74822,
 -63032,
 164007053,
 74824,
 -63031,
 164056685,
 74823,
 -1,
 164142945,
 74825,
 -63029,
 163985249,
 74772,
 -63028,
 164270538,
 74795,
 -63027,
 164328381,
 74781,
 -63026,
 164397220,
 74766,
 -1,
 164484852,
 74759,
 164691967,
 163907630,
 -1,
 -63023,
 164580716,
 74838,
 -1,
 164674530,
 74839,
 164888575,
 163846630,
 -1,
 164891093,
 164778638,
 74820,
 -1,
 164843117,
 74821,
 -63018,
 164837217,
 74771,
 -63017,
 164991434,
 74794,
 -63016,
 165049277,
 74780,
 -63015,
 165118116,
 74765,
 -1,
 165205748,
 74758,
 165412863,
 156221748,
 -1,
 165415390,
 165336701,
 -1,
 -63011,
 165347904,
 74867,
 -1,
 165433824,
 74866,
 -63009,
 165399210,
 74865,
 -1,
 165602352,
 74864,
 165743080,
 85243143,
 -1,
 165808614,
 165695799,
 -1,
 165874149,
 165790149,
 -1,
 -63004,
 165816041,
 8910,
 -1,
 165925715,
 8911,
 -1,
 165827861,
 9130,
 -63001,
 165795968,
 10081,
 -1,
 166071876,
 164,
 -62999,
 165706940,
 9982,
 -1,
 166246013,
 8731,
 166399312,
 85132083,
 -1,
 166464784,
 166354216,
 -1,
 166530317,
 166420891,
 -1,
 166595282,
 166493040,
 5281,
 166660804,
 166527795,
 5264,
 166726338,
 166610116,
 -1,
 166791707,
 166716810,
 -1,
 166857215,
 166782346,
 -1,
 166922745,
 166832014,
 -1,
 166988277,
 166858028,
 5737,
 -1,
 166923564,
 5738,
 -62986,
 166934369,
 5735,
 -62985,
 167091448,
 5736,
 -62984,
 167123101,
 5739,
 -1,
 167183155,
 5740,
 167381499,
 166858028,
 5604,
 -1,
 167316780,
 5605,
 -62980,
 167327585,
 5602,
 -62979,
 167484664,
 5603,
 -62978,
 167516317,
 5606,
 -1,
 167576371,
 5607,
 167774733,
 166841999,
 -1,
 167840263,
 167756690,
 -1,
 167905795,
 167775532,
 5686,
 -1,
 167841068,
 5687,
 -62972,
 167851873,
 5684,
 -62971,
 168008952,
 5685,
 -62970,
 168040605,
 5688,
 -1,
 168100659,
 5689,
 168299017,
 167775532,
 5692,
 -1,
 168234284,
 5693,
 -62966,
 168245089,
 5690,
 -62965,
 168402168,
 5691,
 -62964,
 168433821,
 5694,
 -1,
 168493875,
 5695,
 168692244,
 167749518,
 -1,
 168757776,
 168627500,
 5725,
 -1,
 168693036,
 5726,
 -62959,
 168703841,
 5723,
 -62958,
 168860920,
 5724,
 -62957,
 168892573,
 5727,
 -1,
 168952627,
 5728,
 169213951,
 168674194,
 -1,
 169216535,
 169086252,
 5598,
 -1,
 169151788,
 5599,
 -62952,
 169162593,
 5596,
 -62951,
 169319672,
 5597,
 -62950,
 169351325,
 5600,
 -1,
 169411379,
 5601,
 169609776,
 166770939,
 -1,
 169675299,
 169574347,
 -1,
 169740831,
 169610540,
 5706,
 -1,
 169676076,
 5707,
 -62944,
 169686881,
 5704,
 -62943,
 169843960,
 5705,
 -62942,
 169875613,
 5708,
 -1,
 169935667,
 5709,
 170134058,
 169660047,
 -1,
 170199590,
 170069292,
 5674,
 -1,
 170134828,
 5675,
 -62937,
 170145633,
 5672,
 -62936,
 170302712,
 5673,
 -62935,
 170334365,
 5676,
 -1,
 170394419,
 5677,
 170592815,
 170069292,
 -1,
 170658350,
 170548520,
 -1,
 -62931,
 170630210,
 6389,
 -1,
 170714592,
 6382,
 -1,
 170593580,
 5203,
 -1,
 170530973,
 5204,
 170986050,
 169576141,
 -1,
 171051576,
 170967954,
 -1,
 171117108,
 170986796,
 5574,
 -1,
 171052332,
 5575,
 -62923,
 171063137,
 5572,
 -62922,
 171220216,
 5573,
 -62921,
 171251869,
 5576,
 -1,
 171311923,
 5577,
 171510331,
 171029317,
 -1,
 -62918,
 171456353,
 6381,
 -1,
 171508531,
 6384,
 171706941,
 171445548,
 5617,
 -1,
 171642156,
 5618,
 171838015,
 171639603,
 5620,
 -1,
 171770675,
 6383,
 -62912,
 171784033,
 5615,
 -62911,
 171941112,
 5616,
 -1,
 171972765,
 5619,
 172165712,
 170960782,
 -1,
 172231242,
 172147602,
 5722,
 172296774,
 172166444,
 5718,
 -1,
 172231980,
 5719,
 -62905,
 172242785,
 5716,
 -62904,
 172399864,
 5717,
 -62903,
 172431517,
 5720,
 -1,
 172491571,
 5721,
 172689996,
 172166444,
 5712,
 -1,
 172625196,
 5713,
 -62899,
 172636001,
 5710,
 -62898,
 172793080,
 5711,
 -62897,
 172824733,
 5714,
 -1,
 172884787,
 5715,
 173083231,
 172134711,
 -1,
 173148760,
 173052215,
 5633,
 173214292,
 173083948,
 5629,
 -1,
 173149484,
 5630,
 -62891,
 173160289,
 5627,
 -62890,
 173317368,
 5628,
 -62889,
 173349021,
 5631,
 -1,
 173409075,
 5632,
 173670399,
 173130642,
 -1,
 173673051,
 173542700,
 5623,
 -1,
 173608236,
 5624,
 -62884,
 173619041,
 5621,
 -62883,
 173776120,
 5622,
 -62882,
 173807773,
 5625,
 -1,
 173867827,
 5626,
 174066286,
 173036236,
 -1,
 174131815,
 174019276,
 -1,
 174197347,
 174066988,
 5662,
 -1,
 174132524,
 5663,
 -62876,
 174143329,
 5660,
 -62875,
 174300408,
 5661,
 -62874,
 174332061,
 5664,
 -1,
 174392115,
 5665,
 174590569,
 174066988,
 5655,
 -1,
 174525740,
 5656,
 -62870,
 174557418,
 6386,
 -62869,
 174667617,
 5652,
 -62868,
 174759160,
 5654,
 -62867,
 174790813,
 5657,
 -1,
 174850867,
 5659,
 175049340,
 174050959,
 -1,
 175114870,
 175031186,
 -1,
 175180402,
 175050028,
 5680,
 -1,
 175115564,
 5681,
 -62861,
 175126369,
 5678,
 -62860,
 175283448,
 5679,
 -62859,
 175315101,
 5682,
 -1,
 175375155,
 5683,
 175573624,
 175050028,
 5668,
 -1,
 175508780,
 5669,
 -62855,
 175519585,
 5666,
 -62854,
 175676664,
 5667,
 -62853,
 175708317,
 5670,
 -1,
 175768371,
 5671,
 175966854,
 175031186,
 5195,
 176032388,
 175944517,
 -1,
 176097920,
 175967532,
 5592,
 -1,
 176033068,
 5593,
 -62847,
 176043873,
 5590,
 -62846,
 176200952,
 5591,
 -62845,
 176232605,
 5594,
 -1,
 176292659,
 5595,
 -62843,
 175970461,
 5175,
 -1,
 176461249,
 5174,
 176622221,
 175931339,
 5702,
 176687753,
 176557356,
 5698,
 -1,
 176622892,
 5699,
 -62838,
 176633697,
 5696,
 -62837,
 176790776,
 5697,
 -62836,
 176822429,
 5700,
 -1,
 176882483,
 5701,
 177080980,
 176609696,
 5614,
 177146512,
 177016108,
 5610,
 -1,
 177081644,
 5611,
 -62831,
 177092449,
 5608,
 -62830,
 177249528,
 5609,
 -62829,
 177281181,
 5612,
 -1,
 177341235,
 5613,
 177539740,
 177036584,
 -1,
 177605271,
 177474860,
 5636,
 -1,
 177540396,
 5637,
 -62824,
 177551201,
 5634,
 -62823,
 177708280,
 5635,
 -62822,
 177739933,
 5638,
 -62821,
 177833677,
 5329,
 -1,
 177865523,
 5639,
 178064035,
 177488505,
 -1,
 178129567,
 177999148,
 5648,
 -1,
 178064684,
 5649,
 -62816,
 178075489,
 5646,
 -62815,
 178232568,
 5647,
 -62814,
 178264221,
 5650,
 -1,
 178324275,
 5651,
 178522794,
 178041669,
 -1,
 178588326,
 178457900,
 5586,
 -1,
 178523436,
 5587,
 -62809,
 178534241,
 5584,
 -62808,
 178691320,
 5585,
 -62807,
 178722973,
 5588,
 -1,
 178783027,
 5589,
 178981553,
 178500871,
 -1,
 179047085,
 178916652,
 5580,
 -1,
 178982188,
 5581,
 -62802,
 178992993,
 5578,
 -62801,
 179150072,
 5579,
 -62800,
 179181725,
 5582,
 -1,
 179241779,
 5583,
 179440312,
 178922068,
 -1,
 179505844,
 179375404,
 5642,
 -1,
 179440940,
 5643,
 -62795,
 179451745,
 5640,
 -62794,
 179608824,
 5641,
 -62793,
 179640477,
 5644,
 -1,
 179700531,
 5645,
 179899071,
 179403847,
 -1,
 179964603,
 179834156,
 5731,
 -1,
 179899692,
 5732,
 -62788,
 179910497,
 5729,
 -62787,
 180067576,
 5730,
 -62786,
 180099229,
 5733,
 -1,
 180159283,
 5734,
 180357825,
 179837085,
 5129,
 -1,
 180336813,
 5703,
 -1,
 180327873,
 5128,
 180617215,
 166658867,
 5265,
 -1,
 180492445,
 5258,
 180685516,
 166638405,
 -1,
 180751047,
 180657400,
 5272,
 -1,
 180722936,
 5274,
 180882121,
 180689053,
 5268,
 -1,
 180820125,
 5270,
 181013195,
 180814643,
 5276,
 -1,
 180945715,
 5278,
 -1,
 180948268,
 5266,
 181209806,
 180657400,
 5261,
 -1,
 181181688,
 5262,
 181340880,
 181147805,
 5259,
 -1,
 181278877,
 5260,
 -62767,
 181295164,
 5741,
 -1,
 181407020,
 5257,
 181603156,
 166572869,
 -1,
 181668670,
 181538092,
 5132,
 181796863,
 181618485,
 -1,
 181799741,
 181689681,
 -1,
 181865191,
 181774222,
 -1,
 181930719,
 181842757,
 -1,
 181996250,
 181902584,
 5373,
 -1,
 181968120,
 5375,
 182127324,
 181934237,
 5369,
 -1,
 182065309,
 5371,
 182258398,
 182059827,
 5377,
 -1,
 182190899,
 5379,
 -1,
 182193452,
 5367,
 182517759,
 181909909,
 -1,
 182520546,
 182426872,
 5406,
 -1,
 182492408,
 5408,
 182651620,
 182458525,
 5402,
 -1,
 182589597,
 5404,
 182782694,
 182584115,
 5410,
 -1,
 182715187,
 5412,
 -1,
 182717740,
 5400,
 182979317,
 181849743,
 5355,
 183044848,
 182956869,
 -1,
 183110379,
 183016696,
 5347,
 -1,
 183082232,
 5349,
 183241453,
 183048349,
 5343,
 -1,
 183179421,
 5345,
 183372527,
 183173939,
 5351,
 -1,
 183305011,
 5353,
 -1,
 183307564,
 5341,
 183569138,
 183016696,
 5450,
 -1,
 183540984,
 6369,
 183700212,
 183501619,
 5453,
 -1,
 183632691,
 6370,
 -1,
 183635244,
 5444,
 183896830,
 182927993,
 5440,
 184025087,
 183874373,
 -1,
 184027897,
 183934200,
 5430,
 -1,
 183999736,
 5432,
 184158971,
 183965853,
 5426,
 -1,
 184096925,
 5428,
 184290045,
 184091443,
 5434,
 -1,
 184222515,
 5436,
 -1,
 184225068,
 5424,
 184486664,
 183887242,
 -1,
 184552199,
 184464197,
 -1,
 184617730,
 184524024,
 5214,
 -1,
 184589560,
 5216,
 184748804,
 184555677,
 5210,
 -1,
 184686749,
 5212,
 184879878,
 184681267,
 5218,
 -1,
 184812339,
 5220,
 -1,
 184814892,
 5208,
 -1,
 184514314,
 5481,
 185142033,
 184474016,
 5194,
 185270271,
 185119557,
 -1,
 185273100,
 185179384,
 5185,
 -1,
 185244920,
 5187,
 185404174,
 185211037,
 5181,
 -1,
 185342109,
 5183,
 185535248,
 185336627,
 5189,
 -1,
 185467699,
 5191,
 -1,
 185470252,
 5179,
 185731866,
 185082452,
 5308,
 185860095,
 185709381,
 -1,
 185862933,
 185769208,
 5299,
 -1,
 185834744,
 5301,
 185994007,
 185800861,
 5295,
 -1,
 185931933,
 5297,
 186125081,
 185926451,
 5303,
 -1,
 186057523,
 5305,
 -1,
 186060076,
 5293,
 186321698,
 185709381,
 -1,
 186387229,
 186293496,
 5139,
 -1,
 186359032,
 5141,
 186518303,
 186325149,
 5135,
 -1,
 186456221,
 5137,
 186649377,
 186450739,
 5144,
 -1,
 186581811,
 5146,
 -1,
 186584364,
 5133,
 186845994,
 186310625,
 -1,
 186911525,
 186817784,
 5243,
 -1,
 186883320,
 5245,
 187042599,
 186849437,
 5239,
 -1,
 186980509,
 5241,
 187173673,
 186975027,
 5247,
 -1,
 187106099,
 5249,
 -1,
 187108652,
 5237,
 187370290,
 186809433,
 -1,
 187435821,
 187342072,
 5273,
 -1,
 187407608,
 5275,
 187566895,
 187373725,
 5269,
 -1,
 187504797,
 5271,
 187697969,
 187499315,
 5277,
 -1,
 187630387,
 5279,
 -1,
 187632940,
 5267,
 187894584,
 187348231,
 5457,
 -62668,
 187876569,
 5455,
 -62667,
 187931896,
 5516,
 -62666,
 187963549,
 5515,
 -62665,
 188026156,
 5514,
 -1,
 188089139,
 5517,
 188287804,
 187833148,
 -1,
 188353339,
 188220211,
 5324,
 -1,
 188285747,
 5326,
 -1,
 188288300,
 5322,
 -1,
 188254240,
 5468,
 -1,
 181775910,
 6365,
 188681039,
 181640440,
 5138,
 188809215,
 188652792,
 5140,
 188874751,
 188699393,
 -1,
 188877646,
 188784913,
 5535,
 188943178,
 188855109,
 -1,
 189008709,
 188914936,
 5754,
 -1,
 188980472,
 5755,
 189139783,
 188946589,
 5752,
 -1,
 189077661,
 5753,
 189270857,
 189072179,
 5756,
 -1,
 189203251,
 5757,
 -1,
 189240769,
 5751,
 -62645,
 188914936,
 5533,
 -62644,
 189405341,
 5532,
 -62643,
 189467948,
 5531,
 -1,
 189530931,
 5534,
 -1,
 188833680,
 5758,
 189795154,
 188613427,
 5143,
 -62639,
 189743737,
 6323,
 -1,
 189793075,
 5145,
 190054399,
 189733021,
 5134,
 -1,
 189929629,
 5136,
 190122904,
 181558568,
 5328,
 190188395,
 190055219,
 5319,
 190253928,
 190168246,
 -1,
 190319455,
 190228366,
 -1,
 190384986,
 190308321,
 5386,
 -1,
 190317363,
 5390,
 -62629,
 190366937,
 5380,
 -62628,
 190465274,
 5389,
 -62627,
 190519578,
 5388,
 -62626,
 190624982,
 5391,
 -1,
 190665750,
 5387,
 190843746,
 190296901,
 -1,
 -62623,
 190785173,
 5142,
 -1,
 190865893,
 5147,
 -62621,
 190813016,
 5437,
 -62620,
 191012079,
 5221,
 -62619,
 191065647,
 5327,
 -62618,
 191121631,
 5306,
 -62617,
 191183641,
 5250,
 -1,
 191244940,
 5280,
 191433578,
 190186291,
 5320,
 -1,
 191371421,
 5313,
 -1,
 191382137,
 6332,
 191630197,
 190154038,
 -1,
 191695732,
 191567125,
 5499,
 191761263,
 191667448,
 5495,
 -1,
 191732984,
 5496,
 191892337,
 191699101,
 5493,
 -1,
 191830173,
 5494,
 192023411,
 191824691,
 5497,
 -1,
 191955763,
 5498,
 -1,
 191958316,
 5492,
 -1,
 191681239,
 5500,
 192285566,
 191596237,
 5525,
 192351098,
 192217907,
 5523,
 192416633,
 192283443,
 5524,
 -1,
 192354461,
 5518,
 -1,
 192354461,
 5744,
 192613244,
 192322808,
 5521,
 -1,
 192584952,
 5522,
 192806911,
 192551069,
 5519,
 -1,
 192682141,
 5520,
 192875398,
 192262981,
 -1,
 192940929,
 192847096,
 6346,
 -1,
 192912632,
 6348,
 193072003,
 192878749,
 6342,
 -1,
 193009821,
 6344,
 193203077,
 193004339,
 5323,
 -1,
 193135411,
 5325,
 -1,
 193137964,
 5321,
 193399693,
 192813862,
 5526,
 193465225,
 193371384,
 5747,
 -1,
 193436920,
 5748,
 193596299,
 193403037,
 5745,
 -1,
 193534109,
 5746,
 193789951,
 193528627,
 5749,
 -1,
 193659699,
 5750,
 193858448,
 193371384,
 5316,
 -62577,
 193806969,
 6331,
 -1,
 193895672,
 5317,
 194055060,
 193827901,
 -1,
 194120595,
 193992861,
 5473,
 -1,
 194058397,
 5475,
 -1,
 194055468,
 5471,
 194317206,
 193992861,
 5314,
 -1,
 194255005,
 5315,
 -62569,
 194298770,
 5330,
 -1,
 194383148,
 5312,
 194579415,
 190113162,
 5222,
 194644909,
 194560914,
 5482,
 194710434,
 194614333,
 5550,
 194775965,
 194682104,
 5546,
 -1,
 194747640,
 5547,
 194907039,
 194713757,
 5544,
 -1,
 194844829,
 5545,
 195038113,
 194839347,
 5548,
 -1,
 194970419,
 5549,
 -1,
 194972972,
 5543,
 195234726,
 194687813,
 -1,
 195300261,
 195167027,
 6372,
 -1,
 195232563,
 5480,
 -1,
 195235116,
 6371,
 195496872,
 195206392,
 5476,
 -1,
 195468536,
 5477,
 195627946,
 195434653,
 5472,
 -1,
 195565725,
 5474,
 195759020,
 195560243,
 5478,
 -1,
 195691315,
 5479,
 -1,
 195693868,
 5470,
 195955642,
 194635146,
 -1,
 196021174,
 195937170,
 5487,
 196086705,
 195992824,
 5485,
 -1,
 196058360,
 6374,
 196217779,
 196018995,
 5486,
 -1,
 196150067,
 6375,
 -62540,
 196184295,
 6373,
 -62539,
 196286621,
 5484,
 -1,
 196349228,
 5483,
 -62537,
 195992824,
 5225,
 -62536,
 196483229,
 5224,
 -62535,
 196545836,
 5223,
 -1,
 196608819,
 5226,
 196807618,
 195932997,
 -1,
 196873149,
 196779256,
 5213,
 -1,
 196844792,
 5215,
 197004223,
 196810909,
 5209,
 -1,
 196941981,
 5211,
 197135297,
 196936499,
 5217,
 -1,
 197067571,
 5219,
 -1,
 197070124,
 5207,
 197331913,
 196739876,
 -1,
 197397445,
 197303544,
 5512,
 -1,
 197369080,
 6377,
 -62522,
 197363943,
 6376,
 -62521,
 197466269,
 5511,
 -62520,
 197528876,
 5510,
 -1,
 197591859,
 5513,
 197790670,
 197280377,
 -1,
 -62517,
 197762296,
 5490,
 -62516,
 197793949,
 5489,
 -62515,
 197856556,
 5488,
 -1,
 197919539,
 5491,
 198118354,
 197722931,
 5205,
 198183889,
 198050611,
 5206,
 -1,
 198121629,
 5197,
 -1,
 198132345,
 6327,
 198380500,
 198089976,
 5200,
 -1,
 198352120,
 5201,
 198511574,
 198318237,
 5198,
 -1,
 198449309,
 5199,
 -1,
 198446380,
 5196,
 198708247,
 194553742,
 5381,
 198773745,
 198640435,
 5364,
 198839279,
 198722169,
 6335,
 198967295,
 198773934,
 -1,
 198970338,
 198858402,
 -1,
 199035870,
 198941944,
 5529,
 -1,
 199007480,
 6379,
 -62497,
 199002343,
 6378,
 -62496,
 199104669,
 5528,
 -62495,
 199167276,
 5527,
 -1,
 199230259,
 5530,
 199429096,
 198951826,
 -1,
 199494629,
 199400696,
 5570,
 -1,
 199466232,
 6380,
 -62490,
 199432349,
 5569,
 -62489,
 199560492,
 5568,
 -1,
 199623475,
 5571,
 199822316,
 199381708,
 -1,
 199887851,
 199767905,
 5653,
 -1,
 199833441,
 6385,
 -1,
 199825565,
 5658,
 -62483,
 199795101,
 5441,
 -62482,
 200057105,
 5282,
 -1,
 200090196,
 5311,
 200343551,
 198771507,
 5365,
 -1,
 200218781,
 5358,
 200412164,
 198755218,
 5413,
 200477691,
 200389445,
 -1,
 200543222,
 200449272,
 5405,
 -62475,
 200491641,
 6338,
 -1,
 200580344,
 5407,
 200739832,
 200480925,
 5401,
 -1,
 200677533,
 5403,
 200870906,
 200672051,
 5409,
 -1,
 200803123,
 5411,
 -1,
 200805676,
 5399,
 201067518,
 200449272,
 5395,
 -62467,
 201015929,
 6336,
 -1,
 201104632,
 5396,
 201264129,
 200999731,
 5397,
 -62464,
 201212537,
 6337,
 -1,
 201261875,
 5398,
 201460739,
 201201821,
 5393,
 -1,
 201398429,
 5394,
 -1,
 201395500,
 5392,
 201657356,
 200389445,
 5383,
 201722887,
 201628920,
 5372,
 -1,
 201694456,
 5374,
 201853961,
 201660573,
 5368,
 -1,
 201791645,
 5370,
 201985035,
 201786163,
 5376,
 -1,
 201917235,
 5378,
 -1,
 201919788,
 5366,
 202181652,
 201628920,
 5361,
 202247186,
 202138625,
 -1,
 -62449,
 202188472,
 5255,
 -62448,
 202294682,
 5254,
 -62447,
 202347963,
 5253,
 -1,
 202400253,
 5256,
 -62445,
 202195577,
 6334,
 -1,
 202546424,
 5362,
 202705942,
 202119325,
 5359,
 -1,
 202643613,
 5360,
 -1,
 202640684,
 5357,
 202902584,
 198656633,
 5438,
 202968102,
 202857809,
 -1,
 203033628,
 202955168,
 -1,
 -62437,
 203015385,
 5192,
 -1,
 203040405,
 5173,
 -62435,
 203019592,
 5420,
 -62434,
 203207493,
 5149,
 -62433,
 203253052,
 5202,
 -62432,
 203336076,
 5363,
 -62431,
 203368085,
 5127,
 -62430,
 203424121,
 5318,
 -62429,
 203505877,
 5289,
 -62428,
 203557337,
 5337,
 -62427,
 203638885,
 5233,
 -1,
 203706132,
 5263,
 203885614,
 202945349,
 -1,
 203951145,
 203857144,
 5429,
 -1,
 203922680,
 5431,
 204082219,
 203888797,
 5425,
 -1,
 204019869,
 5427,
 204213293,
 204014387,
 5433,
 -1,
 204145459,
 5435,
 -1,
 204148012,
 5423,
 204409906,
 203817779,
 5421,
 204475441,
 204342067,
 5422,
 -1,
 204413085,
 5415,
 -1,
 204423801,
 6340,
 204672053,
 204381432,
 5418,
 -62412,
 204620409,
 6339,
 -1,
 204709112,
 5419,
 204868663,
 204609693,
 5416,
 -1,
 204806301,
 5417,
 -1,
 204803372,
 5414,
 205065303,
 202852423,
 5469,
 205130831,
 205002909,
 5461,
 205196366,
 205065349,
 -1,
 205261888,
 205174023,
 -1,
 205327423,
 205199517,
 -1,
 -62402,
 205265702,
 5156,
 -1,
 205326257,
 5155,
 -1,
 205302451,
 6367,
 205589573,
 205228029,
 -1,
 205655108,
 205571863,
 -1,
 -62397,
 205608114,
 5158,
 -1,
 205702673,
 5157,
 -1,
 205603964,
 5162,
 205917256,
 205563790,
 -1,
 -62393,
 205859080,
 6366,
 -1,
 205969354,
 5160,
 -62391,
 205874935,
 5154,
 -62390,
 206083251,
 5161,
 -62389,
 206140382,
 5159,
 -62388,
 206203339,
 5152,
 -62387,
 206301000,
 5153,
 -1,
 206358033,
 5151,
 -1,
 205133981,
 5462,
 206572626,
 205062963,
 5465,
 206700543,
 206504755,
 5466,
 -1,
 206575773,
 5460,
 206769236,
 206544120,
 5463,
 -1,
 206740728,
 5464,
 -62379,
 206750937,
 5467,
 -62378,
 206833995,
 5742,
 -1,
 206900524,
 5459,
 207096944,
 205049487,
 5354,
 207162464,
 207074117,
 -1,
 207227995,
 207133944,
 5346,
 -1,
 207199480,
 5348,
 207359069,
 207165597,
 5342,
 -1,
 207296669,
 5344,
 207490143,
 207291187,
 5350,
 -1,
 207422259,
 5352,
 -1,
 207424812,
 5340,
 207686759,
 207143826,
 5542,
 207752291,
 207658232,
 5538,
 -1,
 207723768,
 5539,
 207883365,
 207689885,
 5536,
 -1,
 207820957,
 5537,
 208076799,
 207815475,
 5540,
 -1,
 207946547,
 5541,
 208145515,
 207618867,
 5338,
 208211050,
 208077619,
 5339,
 -1,
 208148637,
 5332,
 -1,
 208159353,
 6333,
 208407661,
 208116984,
 5335,
 -1,
 208379128,
 5336,
 208538735,
 208345245,
 5333,
 -1,
 208476317,
 5334,
 -1,
 208473388,
 5331,
 208735367,
 207037012,
 5307,
 208800889,
 208712517,
 -1,
 208866420,
 208772344,
 5298,
 -1,
 208837880,
 5300,
 208997494,
 208803997,
 5294,
 -1,
 208935069,
 5296,
 209128568,
 208929587,
 5302,
 -1,
 209060659,
 5304,
 -1,
 209063212,
 5292,
 209325181,
 208732979,
 5290,
 209390716,
 209257267,
 5291,
 -1,
 209328285,
 5284,
 -1,
 209339001,
 6330,
 209587328,
 209296632,
 5287,
 209715199,
 209558776,
 5288,
 -1,
 209591593,
 5385,
 209783940,
 209521964,
 5283,
 209911807,
 209758981,
 -1,
 -62333,
 209827079,
 5458,
 -1,
 209899151,
 5356,
 210046086,
 209721501,
 5285,
 -1,
 209983645,
 5286,
 -1,
 210027410,
 5309,
 210242721,
 208682432,
 -1,
 210308253,
 210228272,
 -1,
 210373774,
 210285381,
 5759,
 -62325,
 210345208,
 5558,
 -62324,
 210376861,
 5557,
 -62323,
 210439468,
 5556,
 -1,
 210502451,
 5559,
 210701459,
 210328872,
 -1,
 -62320,
 210672888,
 5562,
 -62319,
 210704541,
 5561,
 -62318,
 210767148,
 5560,
 -1,
 210830131,
 5563,
 211029144,
 210669879,
 -1,
 -62315,
 211000568,
 5566,
 -62314,
 211032221,
 5565,
 -62313,
 211094828,
 5564,
 -1,
 211157811,
 5567,
 -62311,
 211003278,
 5384,
 -62310,
 211328248,
 5554,
 -62309,
 211359901,
 5553,
 -62308,
 211422508,
 5552,
 -1,
 211485491,
 5555,
 211684512,
 210258459,
 -1,
 -62305,
 211662087,
 6388,
 -1,
 211734159,
 6387,
 -1,
 211633472,
 5439,
 211946678,
 210220295,
 5456,
 212012202,
 211923781,
 -1,
 212077733,
 211983608,
 6353,
 -1,
 212049144,
 6354,
 212208807,
 212015261,
 6351,
 -1,
 212146333,
 6352,
 212339881,
 212140851,
 6355,
 -1,
 212271923,
 5454,
 -1,
 212309441,
 6350,
 212536494,
 211944243,
 5451,
 212602029,
 212468531,
 5452,
 -1,
 212539549,
 5445,
 -1,
 212550265,
 6341,
 212798640,
 212507896,
 5448,
 -1,
 212770040,
 5449,
 212929714,
 212736157,
 5446,
 -1,
 212867229,
 5447,
 213060789,
 212895258,
 -1,
 -62284,
 213027047,
 6368,
 -1,
 213060908,
 5443,
 -1,
 212995372,
 5442,
 213322954,
 211933600,
 5193,
 213388480,
 213300037,
 -1,
 213454011,
 213359864,
 5184,
 -62278,
 213402233,
 6326,
 -1,
 213490936,
 5186,
 213650621,
 213391517,
 5180,
 -1,
 213588125,
 5182,
 213781695,
 213582643,
 5188,
 -1,
 213713715,
 5190,
 -1,
 213716268,
 5178,
 213978308,
 213320499,
 5176,
 214043843,
 213910323,
 5177,
 -1,
 213981341,
 5168,
 -1,
 213992057,
 6325,
 214240455,
 213949688,
 5171,
 -62266,
 214188665,
 6324,
 -1,
 214277368,
 5172,
 214437065,
 214177949,
 5169,
 -1,
 214374557,
 5170,
 -1,
 214371628,
 5167,
 214633693,
 213291319,
 5251,
 214699220,
 214610757,
 5252,
 214764751,
 214631219,
 5246,
 -62258,
 214712953,
 6329,
 -1,
 214762291,
 5248,
 214961361,
 214736120,
 5242,
 -1,
 214932728,
 5244,
 215092435,
 214898845,
 5238,
 -1,
 215029917,
 5240,
 -1,
 215026988,
 5236,
 215289048,
 214631219,
 5234,
 215354583,
 215221043,
 5235,
 -1,
 215292061,
 5228,
 -1,
 215302777,
 6328,
 215551194,
 215260408,
 5231,
 -1,
 215522552,
 5232,
 215682268,
 215488669,
 5229,
 -1,
 215619741,
 5230,
 -1,
 215616812,
 5227,
 215878895,
 214605048,
 5125,
 215944428,
 215811843,
 -1,
 216009957,
 215899432,
 6361,
 216137727,
 215987013,
 -1,
 216141027,
 216046840,
 6347,
 -1,
 216112376,
 6349,
 216334335,
 216078493,
 6343,
 -1,
 216209565,
 6345,
 216403175,
 215984014,
 6362,
 -1,
 216384402,
 6363,
 -62232,
 216393098,
 6357,
 -62231,
 216521120,
 6356,
 -62230,
 216539732,
 6360,
 -62229,
 216633655,
 6358,
 -1,
 216693616,
 6359,
 -62227,
 215892601,
 6320,
 -62226,
 216833272,
 5126,
 -1,
 216882472,
 5165,
 217058554,
 215810867,
 5130,
 217124083,
 216990515,
 5131,
 -62222,
 217072249,
 6322,
 -1,
 217127069,
 5122,
 217320694,
 217095626,
 -1,
 -62219,
 217294734,
 5382,
 -1,
 217326164,
 5310,
 217517304,
 217258141,
 5148,
 -1,
 217455533,
 5551,
 -62215,
 217465465,
 6321,
 -1,
 217603368,
 5166,
 217779459,
 217001277,
 5509,
 217844991,
 217711411,
 5507,
 217910526,
 217776947,
 5508,
 -1,
 217847965,
 5502,
 -1,
 217847965,
 5743,
 218107137,
 217816312,
 5505,
 -1,
 218078456,
 5506,
 218300415,
 218044573,
 5503,
 -1,
 218175645,
 5504,
 218369286,
 217716893,
 5123,
 -62203,
 218324264,
 5164,
 -1,
 218372253,
 5124,
 218565897,
 218303788,
 5121,
 -62200,
 218520872,
 5163,
 -1,
 218591004,
 6364,
 218762508,
 218547090,
 -1,
 -62197,
 218745628,
 5120,
 -1,
 218796343,
 5501,
 -1,
 218731670,
 5150,
 219086847,
 166493267,
 -1,
 -62193,
 219002119,
 9803,
 -1,
 219067716,
 917631,
 219221322,
 166442247,
 -1,
 219286852,
 219188982,
 -1,
 219352344,
 219232097,
 66226,
 219480063,
 219297633,
 66239,
 219545599,
 219363169,
 66212,
 -62186,
 219428705,
 66235,
 -62185,
 219500141,
 66256,
 -1,
 219550736,
 66248,
 219745566,
 219326350,
 66224,
 219811099,
 219735434,
 66242,
 -1,
 219747344,
 66243,
 219942173,
 219792274,
 66222,
 -1,
 219878416,
 66223,
 -1,
 219916174,
 66232,
 220138787,
 219685460,
 66218,
 220266495,
 220085696,
 66250,
 -62175,
 220171405,
 66253,
 -62174,
 220221037,
 66252,
 -1,
 220271632,
 66251,
 220466471,
 220093736,
 66229,
 -62171,
 220421416,
 66227,
 -62170,
 220497613,
 66244,
 -1,
 220575995,
 66238,
 220728618,
 220456330,
 66221,
 220856319,
 220718474,
 66247,
 -1,
 220730384,
 66230,
 220925229,
 220712591,
 66211,
 221052927,
 220903675,
 66214,
 -1,
 220926992,
 66254,
 221121839,
 220902663,
 66213,
 -1,
 221099271,
 66249,
 221252913,
 221108640,
 66231,
 -1,
 221189136,
 66209,
 221383987,
 221221175,
 66236,
 -1,
 221320208,
 66237,
 221515061,
 221321373,
 66233,
 -1,
 221452445,
 66245,
 221646135,
 221480653,
 66240,
 -1,
 221582352,
 66241,
 221777209,
 221580588,
 66234,
 -1,
 221713424,
 66255,
 221908283,
 221755643,
 66210,
 -1,
 221844496,
 66220,
 222039358,
 221871118,
 -1,
 -62147,
 222011604,
 66246,
 -1,
 222067435,
 66225,
 222235968,
 221971251,
 66208,
 -1,
 222172176,
 66215,
 -62143,
 222169007,
 66228,
 -62142,
 222309693,
 66216,
 -62141,
 222403832,
 66219,
 -1,
 222444992,
 66217,
 222629192,
 219221292,
 -1,
 222694727,
 222619018,
 8248,
 -1,
 222679927,
 8257,
 -1,
 222648191,
 8453,
 -62135,
 222570136,
 711,
 -1,
 222879117,
 9936,
 223022413,
 219199739,
 -1,
 -62132,
 222957396,
 9764,
 -1,
 223054377,
 8454,
 -62130,
 223006643,
 9761,
 -62129,
 223197500,
 9963,
 -1,
 223260773,
 9809,
 223416263,
 166370552,
 -1,
 223481555,
 223355476,
 -1,
 223547082,
 223419643,
 -1,
 223612320,
 223509360,
 -1,
 223677840,
 223600336,
 -1,
 223743359,
 223618405,
 -1,
 223808861,
 223677740,
 -1,
 223874393,
 223782798,
 11757,
 -1,
 223862566,
 11765,
 -62118,
 223851783,
 11756,
 -62117,
 223960360,
 11753,
 -62116,
 224010836,
 11752,
 -1,
 224120463,
 11751,
 224267618,
 223746205,
 -1,
 224333153,
 224250841,
 -1,
 -62112,
 224321031,
 11775,
 -1,
 224330547,
 11772,
 -1,
 224267564,
 11767,
 224595301,
 224231371,
 -1,
 -62108,
 224573878,
 11748,
 -1,
 224595244,
 11749,
 224791912,
 224543353,
 -1,
 -62105,
 224737121,
 11771,
 -1,
 224813595,
 11770,
 224988523,
 224781706,
 -1,
 -62102,
 224941743,
 11760,
 -1,
 224988460,
 11758,
 225185134,
 224941730,
 -1,
 -62099,
 225161794,
 11763,
 -1,
 225182515,
 11762,
 225381745,
 225163515,
 -1,
 -62096,
 225328336,
 11768,
 -1,
 225381676,
 11747,
 225578356,
 225328576,
 -1,
 -62093,
 225549577,
 11774,
 -1,
 225578284,
 11744,
 -62091,
 225541373,
 11745,
 -62090,
 225718848,
 11755,
 -62089,
 225811704,
 11754,
 -62088,
 225855114,
 11769,
 -62087,
 225906785,
 11773,
 -62086,
 226025423,
 11750,
 -62085,
 226081203,
 11759,
 -62084,
 226121603,
 11746,
 -62083,
 226188206,
 11764,
 -62082,
 226275924,
 11761,
 -1,
 226296627,
 11766,
 226495877,
 223730080,
 -1,
 226561411,
 226427699,
 -1,
 -62078,
 226544947,
 42621,
 -1,
 226590551,
 1156,
 -62076,
 226551885,
 1158,
 -1,
 226742777,
 1159,
 226889097,
 226485642,
 -1,
 -62073,
 226839906,
 1155,
 -62072,
 226921372,
 42610,
 -1,
 226983922,
 42608,
 227151244,
 226855518,
 -1,
 -62069,
 227113607,
 1160,
 -1,
 227154671,
 42609,
 -62067,
 227092787,
 42607,
 -62066,
 227285743,
 1161,
 -62065,
 227400899,
 42620,
 -1,
 227420015,
 1157,
 227610006,
 223649016,
 -1,
 227675541,
 227552699,
 -1,
 227741076,
 227632357,
 787,
 -1,
 227721424,
 789,
 -1,
 227719286,
 806,
 -1,
 227663169,
 65062,
 228003226,
 227541811,
 -1,
 228068761,
 227962918,
 780,
 -1,
 228001831,
 812,
 -1,
 228003809,
 784,
 228265373,
 227939513,
 -1,
 -62052,
 228246922,
 8409,
 -1,
 228319947,
 8405,
 228461983,
 228215775,
 770,
 -1,
 228395047,
 813,
 -1,
 228432002,
 807,
 228658667,
 223596175,
 -1,
 228724167,
 228635737,
 -1,
 228789697,
 228702910,
 -1,
 228855207,
 228721459,
 867,
 -62043,
 228816072,
 7638,
 -62042,
 228891896,
 7637,
 -1,
 228920620,
 7636,
 229117355,
 228832519,
 876,
 229244927,
 229069865,
 -1,
 -62038,
 229171723,
 7651,
 -1,
 229226614,
 7626,
 229379501,
 229101199,
 7645,
 -1,
 229341753,
 7653,
 229510575,
 229316765,
 869,
 -1,
 229474177,
 7640,
 229641649,
 229444908,
 868,
 -1,
 229613841,
 7641,
 229772723,
 229604208,
 872,
 -1,
 229744194,
 7639,
 -62028,
 229736395,
 7654,
 -62027,
 229836719,
 879,
 -62026,
 229930184,
 878,
 -62025,
 229980001,
 871,
 -62024,
 230090122,
 877,
 -62023,
 230139790,
 7652,
 -62022,
 230202616,
 870,
 -62021,
 230251816,
 7648,
 -62020,
 230302292,
 875,
 -62019,
 230396215,
 7644,
 -62018,
 230474642,
 874,
 -62017,
 230524621,
 7642,
 -62016,
 230586503,
 7635,
 -1,
 230668539,
 873,
 230883327,
 228773239,
 -1,
 -62013,
 230798599,
 7650,
 -62012,
 230841640,
 7649,
 -62011,
 230892116,
 7647,
 -62010,
 231001743,
 7646,
 -1,
 231048909,
 7643,
 231214560,
 228713022,
 -1,
 231280093,
 231167017,
 -1,
 231345620,
 231211827,
 -1,
 231411153,
 231325970,
 -1,
 231476686,
 231343466,
 -1,
 -62003,
 231454838,
 852,
 -1,
 231498981,
 7678,
 231735295,
 231429161,
 -1,
 -62000,
 231651446,
 8430,
 -1,
 231695589,
 8406,
 231931903,
 231387269,
 -1,
 -61997,
 231848054,
 841,
 -1,
 231892197,
 794,
 232066521,
 231324083,
 -1,
 232132056,
 232040566,
 -1,
 -61993,
 232110198,
 796,
 -1,
 232154341,
 849,
 -1,
 232080105,
 8400,
 232394204,
 232033822,
 -1,
 -61989,
 232372342,
 845,
 -1,
 232416485,
 8417,
 -1,
 232344467,
 792,
 232718335,
 231267840,
 -1,
 -61985,
 232608008,
 8429,
 -1,
 232667934,
 8426,
 232852968,
 231185656,
 -1,
 232918503,
 232792329,
 -1,
 232984037,
 232892302,
 -1,
 -61980,
 232929269,
 822,
 -1,
 233004055,
 824,
 -61978,
 232924270,
 8402,
 -1,
 233153530,
 8427,
 -1,
 232864810,
 818,
 233439231,
 232800614,
 -1,
 -61974,
 233356215,
 65057,
 -1,
 233418734,
 65056,
 233573927,
 228636923,
 -1,
 233639437,
 233544952,
 -1,
 233704964,
 233621271,
 -1,
 233770483,
 233653653,
 -1,
 233836018,
 233714035,
 -1,
 -61967,
 233814134,
 840,
 -1,
 233858277,
 782,
 -1,
 233790436,
 8422,
 234098167,
 233706554,
 864,
 234225663,
 234050601,
 -1,
 -61962,
 234142647,
 65059,
 -1,
 234205166,
 65058,
 234360314,
 234047922,
 -1,
 -61959,
 234337120,
 858,
 -1,
 234403291,
 866,
 234556924,
 234320538,
 862,
 -1,
 234489895,
 863,
 234687998,
 234523862,
 861,
 -1,
 234620967,
 860,
 -61953,
 234661647,
 831,
 -61952,
 234780757,
 819,
 -61951,
 234873854,
 865,
 -61950,
 234911654,
 783,
 -61949,
 234987534,
 7629,
 -1,
 235047549,
 779,
 235212300,
 233694602,
 -1,
 235277833,
 235164713,
 -1,
 235343368,
 235234533,
 775,
 -1,
 235323600,
 856,
 -1,
 235321462,
 803,
 235601919,
 235237687,
 -1,
 -61941,
 235501478,
 7616,
 -1,
 235571837,
 7617,
 -1,
 235168028,
 798,
 235802149,
 233593194,
 -1,
 235867676,
 235790705,
 -1,
 235933202,
 235857290,
 -1,
 -61935,
 235899121,
 43234,
 -1,
 235964435,
 43235,
 236129813,
 235906958,
 -1,
 -61932,
 236111211,
 43238,
 -1,
 236141182,
 43239,
 236326424,
 236079175,
 -1,
 -61929,
 236294642,
 43236,
 -1,
 236333058,
 43237,
 -61927,
 236259683,
 43232,
 -61926,
 236499256,
 43233,
 -61925,
 236532278,
 43241,
 -1,
 236634314,
 43240,
 236785188,
 235808101,
 -1,
 -61922,
 236748032,
 43248,
 -61921,
 236795745,
 43243,
 -61920,
 236865961,
 43247,
 -61919,
 236932472,
 43246,
 -61918,
 236985117,
 43245,
 -61917,
 237101007,
 43244,
 -1,
 237110067,
 43242,
 -1,
 236757680,
 43249,
 237436927,
 235738181,
 776,
 -1,
 237307943,
 804,
 237506118,
 233551111,
 -1,
 237571649,
 237443229,
 -1,
 237637181,
 237524838,
 -1,
 237702716,
 237589545,
 -1,
 237768246,
 237657766,
 -1,
 237833779,
 237700458,
 -1,
 237899314,
 237765427,
 -1,
 237964849,
 237869558,
 -1,
 -61904,
 237917133,
 854,
 -1,
 237962906,
 7679,
 -1,
 237898850,
 848,
 -1,
 237877366,
 853,
 238354431,
 237786153,
 -1,
 -61899,
 238270582,
 8431,
 -1,
 238314725,
 8407,
 238489147,
 237746611,
 -1,
 238554682,
 238463094,
 -1,
 -61895,
 238532726,
 825,
 -1,
 238576869,
 855,
 -1,
 238502633,
 8401,
 -1,
 238439315,
 793,
 -1,
 237643672,
 8428,
 239009791,
 237576457,
 -1,
 -61889,
 238899029,
 8408,
 -61888,
 238991478,
 805,
 -1,
 239035621,
 778,
 239271935,
 237505836,
 -1,
 239275589,
 239196787,
 -1,
 -61884,
 239246923,
 788,
 -1,
 239286978,
 8421,
 -1,
 239211400,
 802,
 239537755,
 237481579,
 -1,
 239603281,
 239503077,
 -1,
 239668813,
 239574293,
 -1,
 239734348,
 239658378,
 -1,
 -61877,
 239723091,
 119362,
 -1,
 239764795,
 119363,
 -1,
 239681319,
 119364,
 -61874,
 239599726,
 837,
 -61873,
 239978120,
 834,
 -61872,
 240036049,
 835,
 -1,
 240097477,
 836,
 240320511,
 239534899,
 -1,
 240324186,
 240221437,
 -1,
 240389719,
 240276521,
 -1,
 240455254,
 240368855,
 768,
 -1,
 240388135,
 790,
 -1,
 240442679,
 832,
 240713727,
 240366728,
 -1,
 -61863,
 240611994,
 7621,
 -1,
 240685233,
 7624,
 -1,
 240276390,
 847,
 240914031,
 239469363,
 -1,
 240979556,
 240895273,
 -1,
 241045089,
 240931881,
 -1,
 241110624,
 241024215,
 769,
 -1,
 241043495,
 791,
 -1,
 241098039,
 833,
 241369087,
 241022088,
 -1,
 -61853,
 241267354,
 7623,
 -1,
 241319397,
 7625,
 241503849,
 240934184,
 -1,
 241569384,
 241447148,
 -1,
 -61849,
 241550730,
 8410,
 -1,
 241623755,
 8404,
 -1,
 241502374,
 8423,
 241831532,
 241480073,
 -1,
 -61845,
 241809526,
 857,
 -1,
 241853669,
 8432,
 242089983,
 241766985,
 -1,
 -61842,
 242006134,
 7677,
 -1,
 242050277,
 844,
 242224762,
 240853588,
 -1,
 242290297,
 242181948,
 772,
 242355829,
 242267272,
 -1,
 -61837,
 242313675,
 7622,
 -61836,
 242388182,
 7628,
 -1,
 242468369,
 7620,
 242679807,
 242308137,
 -1,
 -61833,
 242596791,
 65061,
 -61832,
 242659310,
 65060,
 -1,
 242727030,
 817,
 -1,
 242226262,
 800,
 242945669,
 242158892,
 -1,
 243011204,
 242883683,
 -1,
 243076735,
 242984846,
 -1,
 -61826,
 243058732,
 8414,
 -1,
 243083993,
 8418,
 243273345,
 243016551,
 8413,
 -1,
 243257088,
 8416,
 -61822,
 243206629,
 8420,
 -61821,
 243393734,
 8419,
 -1,
 243403757,
 8415,
 -1,
 242996179,
 839,
 243666575,
 242919310,
 -1,
 243732107,
 243637735,
 -1,
 243797642,
 243705742,
 -1,
 -61815,
 243742709,
 821,
 -1,
 243817495,
 823,
 -1,
 243737710,
 8403,
 -61812,
 243713538,
 7619,
 -61811,
 244003433,
 827,
 -61810,
 244079554,
 7618,
 -1,
 244144077,
 828,
 244321943,
 243656074,
 -1,
 244387476,
 244256728,
 771,
 244514815,
 244339753,
 -1,
 -61805,
 244404053,
 820,
 -1,
 244496502,
 816,
 -61803,
 244350298,
 786,
 -61802,
 244613069,
 8424,
 -1,
 244687700,
 8411,
 244846239,
 244258973,
 -1,
 244911774,
 244813964,
 -1,
 244977309,
 244896402,
 -1,
 245042844,
 244922523,
 785,
 -1,
 244975655,
 815,
 -1,
 245014601,
 826,
 -1,
 244944560,
 811,
 -1,
 244883682,
 7632,
 245370534,
 244830866,
 -1,
 245436067,
 245315739,
 774,
 -61790,
 245400056,
 7627,
 -1,
 245434407,
 814,
 245694463,
 245410965,
 -1,
 -61787,
 245610614,
 810,
 -1,
 245654757,
 838,
 245829292,
 245315425,
 -1,
 245894826,
 245815712,
 -1,
 -61783,
 245857566,
 846,
 -1,
 245946786,
 797,
 -61781,
 245832542,
 7634,
 -1,
 246022609,
 7633,
 246222513,
 245777813,
 -1,
 246288048,
 246165875,
 -1,
 -61777,
 246265974,
 809,
 -1,
 246310117,
 781,
 -1,
 246223930,
 830,
 246550197,
 246193400,
 -1,
 246615732,
 246496991,
 808,
 -1,
 246551005,
 7630,
 -1,
 246553540,
 773,
 246812345,
 246528414,
 -1,
 -61769,
 246761900,
 795,
 -61768,
 246840535,
 777,
 -1,
 246884779,
 843,
 247074492,
 246800379,
 -1,
 -61765,
 247052406,
 7631,
 -1,
 247096549,
 859,
 247271103,
 247043692,
 -1,
 -61762,
 247249014,
 851,
 -1,
 247293157,
 829,
 247467714,
 247257504,
 -1,
 -61759,
 247418524,
 799,
 -1,
 247473740,
 801,
 247664325,
 247437261,
 -1,
 -61756,
 247596628,
 12441,
 -1,
 247677501,
 12442,
 247860936,
 247613511,
 -1,
 -61753,
 247845261,
 8412,
 -1,
 247866074,
 850,
 -61751,
 247829824,
 8425,
 -1,
 248034179,
 842,
 248188623,
 223486548,
 -1,
 248254158,
 248154816,
 -1,
 -61747,
 248185189,
 8274,
 -1,
 248275483,
 64,
 -1,
 248185651,
 44,
 248516306,
 248175008,
 -1,
 -61743,
 248466308,
 9092,
 -1,
 248514996,
 8705,
 -1,
 248485354,
 9732,
 248778642,
 223467936,
 -1,
 248844177,
 248750148,
 -1,
 248909617,
 248817550,
 -1,
 248975143,
 248852030,
 -1,
 249040622,
 248945912,
 11423,
 249106157,
 248991384,
 -1,
 249171687,
 249043016,
 -1,
 249237215,
 249152402,
 -1,
 249302749,
 249168691,
 11471,
 -1,
 249292170,
 11477,
 -61730,
 249248435,
 11469,
 -1,
 249402808,
 11475,
 249564898,
 249190050,
 -1,
 -61727,
 249545138,
 11483,
 -1,
 249599416,
 11461,
 -61725,
 249509803,
 11455,
 -61724,
 249712817,
 11479,
 -61723,
 249805794,
 11463,
 -61722,
 249860204,
 11481,
 -1,
 249909240,
 11445,
 250150911,
 249156602,
 -1,
 250154731,
 250043688,
 -1,
 -61718,
 250126749,
 11489,
 -1,
 250195612,
 11487,
 -61716,
 250135781,
 11491,
 -1,
 250282330,
 11485,
 -1,
 249039833,
 11441,
 250547958,
 249018619,
 -1,
 250613492,
 250493404,
 -1,
 -61711,
 250586190,
 11451,
 -61710,
 250621818,
 11449,
 -61709,
 250701916,
 11467,
 -1,
 250750686,
 11443,
 -61707,
 250582456,
 1007,
 -1,
 250912642,
 11399,
 251072253,
 250521486,
 -1,
 251137786,
 251052946,
 -1,
 -61703,
 251118002,
 1005,
 -1,
 251172280,
 995,
 -61701,
 251071449,
 11403,
 -61700,
 251314610,
 11429,
 -1,
 251363071,
 11457,
 251531012,
 251034710,
 -1,
 251596547,
 251493819,
 -1,
 -61696,
 251538983,
 11500,
 -61695,
 251634766,
 11453,
 -61694,
 251678897,
 11502,
 -1,
 251747739,
 11447,
 -1,
 251528971,
 11459,
 251989770,
 251498807,
 -1,
 252055304,
 251970450,
 -1,
 -61689,
 251992221,
 11437,
 -1,
 252089784,
 999,
 -61687,
 252008095,
 11421,
 -1,
 252183726,
 11413,
 252382989,
 251979146,
 -1,
 -61684,
 252338215,
 11409,
 -1,
 252404248,
 11431,
 252579600,
 252369312,
 -1,
 -61681,
 252532383,
 11439,
 -1,
 252582045,
 11425,
 252776211,
 252563087,
 -1,
 -61678,
 252741510,
 11415,
 -1,
 252788354,
 11473,
 252972822,
 252756882,
 -1,
 -61675,
 252918451,
 1001,
 -1,
 252974018,
 11407,
 253169433,
 252948115,
 -1,
 -61672,
 253155269,
 1003,
 -1,
 253184083,
 11397,
 253366044,
 253118535,
 -1,
 -61669,
 253302941,
 11435,
 -1,
 253400504,
 997,
 253562655,
 253297459,
 -1,
 -61666,
 253515351,
 11393,
 -1,
 253600819,
 11465,
 -61664,
 253543905,
 11405,
 -61663,
 253742660,
 11395,
 -61662,
 253784268,
 11433,
 -61661,
 253839791,
 11427,
 -61660,
 253928526,
 11419,
 -61659,
 253956018,
 11417,
 -61658,
 254022927,
 11411,
 -1,
 254107035,
 11401,
 254345215,
 248912759,
 -1,
 254349099,
 254257038,
 -1,
 -61654,
 254292641,
 11495,
 -1,
 254390570,
 11498,
 254545710,
 254316855,
 -1,
 -61651,
 254510527,
 11497,
 -1,
 254566906,
 11492,
 -61649,
 254502884,
 11496,
 -61648,
 254705384,
 11494,
 -1,
 254785031,
 11493,
 254939016,
 248871792,
 -1,
 255004547,
 254875466,
 -1,
 255070026,
 254975224,
 11422,
 255135561,
 255020696,
 -1,
 255201091,
 255072328,
 -1,
 255266619,
 255181714,
 -1,
 255332153,
 255198003,
 11470,
 -1,
 255321482,
 11476,
 -61638,
 255277747,
 11468,
 -1,
 255432120,
 11474,
 255594302,
 255219362,
 -1,
 -61635,
 255574450,
 11482,
 -1,
 255628728,
 11460,
 -61633,
 255539115,
 11454,
 -61632,
 255742129,
 11478,
 -61631,
 255835106,
 11462,
 -61630,
 255889516,
 11480,
 -1,
 255938552,
 11444,
 256180223,
 255185914,
 -1,
 256184135,
 256073000,
 -1,
 -61626,
 256156061,
 11488,
 -1,
 256224924,
 11486,
 -61624,
 256165093,
 11490,
 -1,
 256311642,
 11484,
 -1,
 255069145,
 11440,
 256577362,
 255047931,
 -1,
 256642896,
 256522716,
 -1,
 -61619,
 256615502,
 11450,
 -61618,
 256651130,
 11448,
 -61617,
 256731228,
 11466,
 -1,
 256779998,
 11442,
 -61615,
 256611768,
 1006,
 -1,
 256941954,
 11398,
 257101657,
 256550798,
 -1,
 257167190,
 257082258,
 -1,
 -61611,
 257147314,
 1004,
 -1,
 257201592,
 994,
 -61609,
 257100761,
 11402,
 -61608,
 257343922,
 11428,
 -1,
 257392383,
 11456,
 257560416,
 257064022,
 -1,
 257625951,
 257523131,
 -1,
 -61604,
 257568295,
 11499,
 -61603,
 257664078,
 11452,
 -61602,
 257708209,
 11501,
 -1,
 257777051,
 11446,
 -1,
 257558283,
 11458,
 258019174,
 257528119,
 -1,
 258084708,
 257999762,
 -1,
 -61597,
 258021533,
 11436,
 -1,
 258119096,
 998,
 -61595,
 258037407,
 11420,
 -1,
 258213038,
 11412,
 258412393,
 258008458,
 -1,
 -61592,
 258367527,
 11408,
 -1,
 258433560,
 11430,
 258609004,
 258398624,
 -1,
 -61589,
 258561695,
 11438,
 -1,
 258611357,
 11424,
 258805615,
 258592399,
 -1,
 -61586,
 258770822,
 11414,
 -1,
 258817666,
 11472,
 259002226,
 258786194,
 -1,
 -61583,
 258947763,
 1000,
 -1,
 259003330,
 11406,
 259198837,
 258977427,
 -1,
 -61580,
 259184581,
 1002,
 -1,
 259213395,
 11396,
 259395448,
 259147847,
 -1,
 -61577,
 259332253,
 11434,
 -1,
 259429816,
 996,
 259592059,
 259326771,
 -1,
 -61574,
 259544663,
 11392,
 -1,
 259630131,
 11464,
 -61572,
 259573217,
 11404,
 -61571,
 259771972,
 11394,
 -61570,
 259813580,
 11432,
 -61569,
 259869103,
 11426,
 -61568,
 259957838,
 11418,
 -61567,
 259985330,
 11416,
 -61566,
 260052239,
 11410,
 -1,
 260136347,
 11400,
 260374527,
 254973318,
 -1,
 260378503,
 260255563,
 -1,
 -61562,
 260351040,
 11505,
 -1,
 260433587,
 11504,
 -1,
 260353956,
 11503,
 260640653,
 254896310,
 -1,
 -61558,
 260578351,
 11516,
 -61557,
 260639895,
 11515,
 -61556,
 260703767,
 11513,
 -1,
 260806224,
 11514,
 260968336,
 260589639,
 -1,
 -61553,
 260901195,
 11518,
 -1,
 261022253,
 11517,
 -1,
 260923209,
 11519,
 -1,
 248790733,
 169,
 261296049,
 248721407,
 -1,
 261361582,
 261263579,
 -1,
 261427105,
 261295392,
 -1,
 261492632,
 261416330,
 -1,
 -61545,
 261458161,
 119649,
 -1,
 261523475,
 119650,
 261689243,
 261465998,
 -1,
 -61542,
 261670251,
 119653,
 -1,
 261700222,
 119654,
 261885854,
 261638215,
 -1,
 -61539,
 261853682,
 119651,
 -1,
 261892098,
 119652,
 -61537,
 261861688,
 119648,
 -61536,
 262025782,
 119656,
 -1,
 262127818,
 119655,
 262340607,
 261401701,
 -1,
 262344613,
 262268298,
 -1,
 -61532,
 262310129,
 119658,
 -1,
 262375443,
 119659,
 262541224,
 262317966,
 -1,
 -61529,
 262522219,
 119662,
 -1,
 262552190,
 119663,
 262737835,
 262490183,
 -1,
 -61526,
 262705650,
 119660,
 -1,
 262744066,
 119661,
 -61524,
 262713656,
 119657,
 -61523,
 262877750,
 119665,
 -1,
 262979786,
 119664,
 263192575,
 261330419,
 -1,
 -61520,
 263084603,
 9013,
 -1,
 263185677,
 9012,
 263327681,
 261250344,
 -1,
 263393214,
 263316874,
 -1,
 263458748,
 263370628,
 -1,
 263524280,
 263435687,
 -1,
 -61514,
 263458174,
 8955,
 -61513,
 263568633,
 8957,
 -1,
 263586570,
 8954,
 263847935,
 263481561,
 -1,
 263851963,
 263738192,
 8883,
 -1,
 263790246,
 8885,
 -1,
 263782919,
 8715,
 -61507,
 263446646,
 8750,
 -1,
 263992341,
 9089,
 -61505,
 263381652,
 9740,
 -61504,
 264141814,
 9010,
 -1,
 264205707,
 10861,
 264376261,
 263260629,
 58,
 264503295,
 264328233,
 -1,
 -61500,
 264418697,
 8353,
 -1,
 264448950,
 8788,
 -61498,
 264346235,
 8792,
 -1,
 264585486,
 9904,
 264770014,
 223363705,
 -1,
 264835481,
 264751892,
 -1,
 264900782,
 264800304,
 -1,
 264966314,
 264872272,
 -1,
 265031647,
 264899884,
 1101,
 265097170,
 264985896,
 1085,
 265224191,
 265045279,
 -1,
 -61489,
 265150889,
 1226,
 -61488,
 265213862,
 1315,
 -61487,
 265246348,
 1224,
 -1,
 265330567,
 1187,
 265490391,
 265080463,
 1083,
 265617407,
 265438495,
 -1,
 -61483,
 265544105,
 1222,
 -61482,
 265607078,
 1313,
 -1,
 265639564,
 1299,
 265818073,
 265463694,
 1089,
 -1,
 265776948,
 1195,
 265949147,
 265794823,
 1088,
 -1,
 265882566,
 1167,
 266080221,
 265888340,
 1084,
 -1,
 266031476,
 1230,
 -61474,
 266029127,
 1092,
 -1,
 266168751,
 1261,
 266342389,
 264999223,
 -1,
 266407916,
 266312952,
 -1,
 266473451,
 266360851,
 -1,
 266538982,
 266451195,
 -1,
 -61468,
 266511576,
 1287,
 -61467,
 266560386,
 1283,
 -1,
 266603820,
 1281,
 -61465,
 266511576,
 1285,
 -61464,
 266731901,
 1295,
 -61463,
 266807635,
 1293,
 -61462,
 266886336,
 1291,
 -1,
 266963485,
 1289,
 -1,
 266431963,
 1153,
 267194354,
 266339123,
 1082,
 267321343,
 267142431,
 -1,
 -61457,
 267222243,
 1181,
 -61456,
 267294981,
 1183,
 -61455,
 267343500,
 1220,
 -1,
 267427719,
 1179,
 -61453,
 267146911,
 1135,
 -61452,
 267543426,
 1116,
 -1,
 267604650,
 1228,
 267784202,
 266279069,
 1080,
 267849728,
 267754744,
 1105,
 267976703,
 267838858,
 -1,
 267980799,
 267877934,
 -1,
 -61446,
 267912630,
 42579,
 -61445,
 267980897,
 1129,
 -61444,
 268045612,
 1125,
 -61443,
 268165142,
 42589,
 -61442,
 268230151,
 1133,
 -1,
 268239667,
 42583,
 -1,
 267911987,
 42567,
 268505092,
 267783468,
 1077,
 268632063,
 268453151,
 -1,
 -61437,
 268528075,
 1104,
 -1,
 268602582,
 1239,
 268767240,
 268453151,
 -1,
 -61434,
 268726938,
 1251,
 -61433,
 268790219,
 1117,
 -1,
 268861150,
 1253,
 269090815,
 268755147,
 1141,
 -1,
 268975234,
 1143,
 269160479,
 267757454,
 -1,
 269226004,
 269140882,
 -1,
 269291536,
 269193341,
 -1,
 269357071,
 269228189,
 1081,
 -1,
 269308276,
 1163,
 -1,
 269301601,
 1118,
 -61423,
 269256935,
 42647,
 -61422,
 269531571,
 1211,
 -61421,
 269595202,
 1097,
 -1,
 269615923,
 1096,
 269815834,
 269199064,
 -1,
 269881368,
 269749548,
 -1,
 -61417,
 269820500,
 42599,
 -1,
 269930127,
 42597,
 -61415,
 269858185,
 1100,
 -1,
 270043142,
 42595,
 270209052,
 269772387,
 1199,
 -1,
 270181926,
 1201,
 270340126,
 270185610,
 1241,
 -1,
 270297519,
 1243,
 -1,
 270277771,
 1165,
 270536747,
 269138171,
 -1,
 270602278,
 270499787,
 -1,
 270667811,
 270535980,
 1109,
 -1,
 270598913,
 42563,
 -61404,
 270642982,
 42633,
 -61403,
 270764263,
 42627,
 -1,
 270842294,
 1119,
 270995496,
 270558082,
 1106,
 -1,
 270944659,
 42569,
 -61399,
 270960871,
 42625,
 -61398,
 271063547,
 42605,
 -1,
 271125804,
 1076,
 271323193,
 270499787,
 -1,
 271388724,
 271303570,
 -1,
 271454259,
 271322412,
 1078,
 271581183,
 271402271,
 -1,
 271585330,
 271497467,
 -1,
 -61391,
 271520837,
 1245,
 -1,
 271628426,
 1175,
 -1,
 271551702,
 1218,
 -1,
 271419623,
 42629,
 271974399,
 271322412,
 1079,
 271978552,
 271891871,
 -1,
 -61385,
 271914053,
 1247,
 -1,
 272021642,
 1177,
 -1,
 271957761,
 42561,
 272240708,
 271270521,
 -1,
 272306238,
 272189527,
 1099,
 272433151,
 272254239,
 -1,
 -61379,
 272334558,
 1273,
 -1,
 272402629,
 42577,
 272568385,
 272237363,
 1103,
 -61376,
 272557450,
 1123,
 -1,
 272567596,
 1305,
 -61374,
 272512865,
 1102,
 -61373,
 272719144,
 42591,
 -1,
 272767133,
 1111,
 272961616,
 272229770,
 -1,
 273027146,
 272934798,
 -1,
 -61369,
 272992487,
 42639,
 -61368,
 273045167,
 42641,
 -61367,
 273136054,
 1115,
 -1,
 273157420,
 1094,
 273354830,
 272960812,
 1090,
 273481727,
 273302815,
 -1,
 -61363,
 273405862,
 42635,
 -1,
 273457031,
 1197,
 -61361,
 273320167,
 42637,
 -1,
 273592916,
 42643,
 273748060,
 272907712,
 -1,
 273813589,
 273679155,
 -1,
 273879124,
 273767385,
 1257,
 -1,
 273836463,
 1259,
 -1,
 273827003,
 1185,
 274075736,
 273750173,
 -1,
 -61353,
 274039466,
 42603,
 -1,
 274099127,
 1131,
 -61351,
 274019007,
 1110,
 -61350,
 274245421,
 42573,
 -61349,
 274321957,
 42587,
 -1,
 274337068,
 1073,
 274534502,
 273679155,
 1072,
 274600034,
 274493252,
 -1,
 274665568,
 274575956,
 1213,
 -1,
 274624308,
 1215,
 -61343,
 274643379,
 1193,
 -1,
 274780615,
 1249,
 274927717,
 274547999,
 -1,
 -61340,
 274890462,
 1235,
 -1,
 274959574,
 1233,
 -1,
 274858086,
 1311,
 275189871,
 274499277,
 -1,
 275255406,
 275167670,
 1075,
 275382271,
 275203359,
 -1,
 275386475,
 275290373,
 1171,
 -1,
 275326038,
 1275,
 -61332,
 275352303,
 1169,
 -61331,
 275503014,
 1173,
 -1,
 275554183,
 1271,
 -1,
 275211138,
 1107,
 275779703,
 275134305,
 1091,
 275845237,
 275727647,
 -1,
 275910772,
 275822843,
 -1,
 -61325,
 275896083,
 1267,
 -1,
 275911749,
 1265,
 -1,
 275870362,
 1263,
 276234239,
 275812663,
 1145,
 -1,
 276153509,
 1108,
 276303999,
 275760018,
 -1,
 276369534,
 276235059,
 1093,
 276435069,
 276317471,
 -1,
 -61317,
 276404485,
 1279,
 -61316,
 276453004,
 1277,
 -1,
 276537223,
 1203,
 -1,
 276379701,
 1098,
 -1,
 276334823,
 42645,
 276828296,
 276265840,
 -1,
 276893830,
 276806070,
 1095,
 277020671,
 276841759,
 -1,
 277024901,
 276936955,
 -1,
 -61308,
 276960325,
 1269,
 -1,
 277067914,
 1207,
 -1,
 276987107,
 1209,
 -61305,
 276867296,
 42585,
 -1,
 277262932,
 42631,
 277418127,
 276804871,
 -1,
 277483661,
 277374860,
 -1,
 -61301,
 277458726,
 1297,
 -61300,
 277520879,
 42581,
 -1,
 277598663,
 42565,
 -61298,
 277431401,
 1147,
 -1,
 277723571,
 1303,
 277876886,
 277404064,
 -1,
 277942420,
 277810476,
 1087,
 278069247,
 277890335,
 -1,
 -61293,
 277993382,
 1191,
 -1,
 278044551,
 1317,
 -61291,
 277894815,
 1137,
 -1,
 278185669,
 1231,
 278335643,
 277847288,
 1086,
 278401177,
 278280195,
 1121,
 -1,
 278383081,
 1149,
 -61286,
 278390154,
 1151,
 -1,
 278489519,
 1255,
 278663327,
 278318735,
 -1,
 -61283,
 278619010,
 1113,
 -61282,
 278711436,
 1127,
 -1,
 278772147,
 1301,
 278925474,
 278617384,
 -1,
 -61279,
 278881154,
 1114,
 -1,
 278973043,
 42575,
 279122085,
 278866602,
 -1,
 -61276,
 279064072,
 42571,
 -1,
 279123847,
 42601,
 -61274,
 279087335,
 1309,
 -61273,
 279280893,
 1074,
 -61272,
 279330521,
 1307,
 -61271,
 279405442,
 1112,
 -1,
 279468974,
 1139,
 279707647,
 264913254,
 -1,
 -61268,
 279617125,
 1205,
 -61267,
 279663982,
 1189,
 -1,
 279764346,
 1237,
 279908754,
 264880701,
 -1,
 279974286,
 279880016,
 -1,
 280039620,
 279907628,
 1069,
 280105143,
 279993640,
 1053,
 280231935,
 280053023,
 -1,
 -61260,
 280158633,
 1225,
 -61259,
 280221606,
 1314,
 -61258,
 280254092,
 1223,
 -1,
 280338311,
 1186,
 280498364,
 280088207,
 1051,
 280625151,
 280446239,
 -1,
 -61254,
 280551849,
 1221,
 -61253,
 280614822,
 1312,
 -1,
 280647308,
 1298,
 280826046,
 280471438,
 1057,
 -1,
 280784692,
 1194,
 280957120,
 280802567,
 1056,
 -1,
 280890310,
 1166,
 281088194,
 280896084,
 1052,
 -1,
 281039220,
 1229,
 -61245,
 281036871,
 1060,
 -1,
 281176495,
 1260,
 281350362,
 280006967,
 -1,
 281415889,
 281320696,
 -1,
 281481424,
 281368595,
 -1,
 281546955,
 281458939,
 -1,
 -61239,
 281519320,
 1286,
 -61238,
 281568130,
 1282,
 -1,
 281611564,
 1280,
 -61236,
 281519320,
 1284,
 -61235,
 281739645,
 1294,
 -61234,
 281815379,
 1292,
 -61233,
 281894080,
 1290,
 -1,
 281971229,
 1288,
 -1,
 281439707,
 1152,
 282202327,
 281346867,
 1050,
 282329087,
 282150175,
 -1,
 -61228,
 282229987,
 1180,
 -61227,
 282302725,
 1182,
 -61226,
 282351244,
 1219,
 -1,
 282435463,
 1178,
 -61224,
 282154655,
 1134,
 -61223,
 282551170,
 1036,
 -1,
 282612394,
 1227,
 282792175,
 281286813,
 1048,
 282857701,
 282762488,
 1025,
 282984447,
 282846602,
 -1,
 282988772,
 282885678,
 -1,
 -61217,
 282920374,
 42578,
 -61216,
 282988641,
 1128,
 -61215,
 283053356,
 1124,
 -61214,
 283172886,
 42588,
 -61213,
 283237895,
 1132,
 -1,
 283247411,
 42582,
 -1,
 282919731,
 42566,
 283513065,
 282791212,
 1045,
 283639807,
 283460895,
 -1,
 -61208,
 283535819,
 1024,
 -1,
 283610326,
 1238,
 283775213,
 283460895,
 -1,
 -61205,
 283734682,
 1250,
 -61204,
 283797963,
 1037,
 -1,
 283868894,
 1252,
 284098559,
 283762891,
 1140,
 -1,
 283982978,
 1142,
 284168452,
 282765198,
 -1,
 284233977,
 284148626,
 -1,
 284299509,
 284201085,
 -1,
 284365044,
 284235933,
 1049,
 -1,
 284316020,
 1162,
 -1,
 284309345,
 1038,
 -61194,
 284264679,
 42646,
 -61193,
 284539315,
 1210,
 -61192,
 284602946,
 1065,
 -1,
 284623667,
 1064,
 284823807,
 284206808,
 -1,
 284889341,
 284757292,
 -1,
 -61188,
 284828244,
 42598,
 -1,
 284937871,
 42596,
 -61186,
 284865929,
 1068,
 -1,
 285050886,
 42594,
 285217025,
 284780131,
 1198,
 -1,
 285189670,
 1200,
 285348099,
 285193354,
 1240,
 -1,
 285305263,
 1242,
 -1,
 285285515,
 1164,
 285544720,
 284145915,
 -1,
 285610251,
 285507531,
 -1,
 285675784,
 285543724,
 1029,
 -1,
 285606657,
 42562,
 -61175,
 285650726,
 42632,
 -61174,
 285772007,
 42626,
 -1,
 285850038,
 1039,
 286003469,
 285565826,
 1026,
 -1,
 285952403,
 42568,
 -61170,
 285968615,
 42624,
 -61169,
 286071291,
 42604,
 -1,
 286133548,
 1044,
 286331166,
 285507531,
 -1,
 286396697,
 286311314,
 -1,
 286462232,
 286330156,
 1046,
 286588927,
 286410015,
 -1,
 286593303,
 286505211,
 -1,
 -61162,
 286528581,
 1244,
 -1,
 286636170,
 1174,
 -1,
 286559446,
 1217,
 -1,
 286427367,
 42628,
 286982143,
 286330156,
 1047,
 286986525,
 286899615,
 -1,
 -61156,
 286921797,
 1246,
 -1,
 287029386,
 1176,
 -1,
 286965505,
 42560,
 287248681,
 286278265,
 -1,
 287314211,
 287197271,
 1067,
 287440895,
 287261983,
 -1,
 -61150,
 287342302,
 1272,
 -1,
 287410373,
 42576,
 287576358,
 287245107,
 1071,
 -61147,
 287565194,
 1122,
 -1,
 287575340,
 1304,
 -61145,
 287520609,
 1070,
 -61144,
 287726888,
 42590,
 -1,
 287774877,
 1031,
 287969589,
 287237514,
 -1,
 288035119,
 287942542,
 -1,
 -61140,
 288000231,
 42638,
 -61139,
 288052911,
 42640,
 -61138,
 288143798,
 1035,
 -1,
 288165164,
 1062,
 288362803,
 287968556,
 1058,
 288489471,
 288310559,
 -1,
 -61134,
 288413606,
 42634,
 -1,
 288464775,
 1196,
 -61132,
 288327911,
 42636,
 -1,
 288600660,
 42642,
 288756033,
 287915456,
 -1,
 288821562,
 288686899,
 -1,
 288887097,
 288775129,
 1256,
 -1,
 288844207,
 1258,
 -1,
 288834747,
 1184,
 289083709,
 288757917,
 -1,
 -61124,
 289047210,
 42602,
 -1,
 289106871,
 1130,
 -61122,
 289026751,
 1030,
 -61121,
 289253165,
 42572,
 -61120,
 289329701,
 42586,
 -1,
 289344812,
 1041,
 289542475,
 288686899,
 1040,
 289608007,
 289500996,
 -1,
 289673541,
 289583700,
 1212,
 -1,
 289632052,
 1214,
 -61114,
 289651123,
 1192,
 -1,
 289788359,
 1248,
 289935690,
 289555743,
 -1,
 -61111,
 289898206,
 1234,
 -1,
 289967318,
 1232,
 -1,
 289865830,
 1310,
 290197844,
 289507021,
 -1,
 290263379,
 290175414,
 1043,
 290390015,
 290211103,
 -1,
 290394448,
 290298117,
 1170,
 -1,
 290333782,
 1274,
 -61103,
 290360047,
 1168,
 -61102,
 290510758,
 1172,
 -1,
 290561927,
 1270,
 -1,
 290218882,
 1027,
 290787676,
 290142049,
 1059,
 290853210,
 290735391,
 -1,
 290918745,
 290830587,
 -1,
 -61096,
 290903827,
 1266,
 -1,
 290919493,
 1264,
 -1,
 290878106,
 1262,
 291241983,
 290820407,
 1144,
 -1,
 291161253,
 1028,
 291311972,
 290767762,
 -1,
 291377507,
 291242803,
 1061,
 291443042,
 291325215,
 -1,
 -61088,
 291412229,
 1278,
 -61087,
 291460748,
 1276,
 -1,
 291544967,
 1202,
 -1,
 291387445,
 1066,
 -1,
 291342567,
 42644,
 291836269,
 291273584,
 -1,
 291901803,
 291813814,
 1063,
 292028415,
 291849503,
 -1,
 292032874,
 291944699,
 -1,
 -61079,
 291968069,
 1268,
 -1,
 292075658,
 1206,
 -1,
 291994851,
 1208,
 -61076,
 291875040,
 42584,
 -1,
 292270676,
 42630,
 292426100,
 291812615,
 -1,
 292491634,
 292382604,
 -1,
 -61072,
 292466470,
 1296,
 -61071,
 292528623,
 42580,
 -1,
 292606407,
 42564,
 -61069,
 292439145,
 1146,
 -1,
 292731315,
 1302,
 292884857,
 292396280,
 1054,
 292950391,
 292829187,
 1120,
 -1,
 292932073,
 1148,
 -61064,
 292939146,
 1150,
 -1,
 293038511,
 1254,
 293212543,
 292870560,
 -1,
 293278078,
 293145900,
 1055,
 293404671,
 293225759,
 -1,
 -61059,
 293328806,
 1190,
 -1,
 293379975,
 1316,
 -1,
 293230239,
 1136,
 293605763,
 293195407,
 -1,
 -61055,
 293561218,
 1033,
 -61054,
 293653644,
 1126,
 -1,
 293714355,
 1300,
 293867910,
 293559592,
 -1,
 -61051,
 293823362,
 1034,
 -1,
 293915251,
 42574,
 294064521,
 293808810,
 -1,
 -61048,
 294006280,
 42570,
 -1,
 294066055,
 42600,
 -61046,
 294029543,
 1308,
 -61045,
 294223101,
 1042,
 -61044,
 294272729,
 1306,
 -61043,
 294347650,
 1032,
 -1,
 294411182,
 1138,
 294649855,
 279920998,
 -1,
 -61040,
 294559333,
 1204,
 -61039,
 294606190,
 1188,
 -1,
 294706554,
 1236,
 294850966,
 279848293,
 -1,
 -61036,
 294786905,
 7467,
 -61035,
 294855639,
 1216,
 -1,
 294957430,
 42606,
 -61033,
 294812295,
 1154,
 -61032,
 295086812,
 42623,
 -1,
 295165123,
 42622,
 295309789,
 264800340,
 -1,
 295375264,
 295298442,
 -1,
 -61028,
 295319393,
 67633,
 -61027,
 295410936,
 67632,
 -61026,
 295442589,
 67631,
 -61025,
 295505196,
 67630,
 -1,
 295568179,
 67629,
 295768486,
 295348110,
 -1,
 -61022,
 295712609,
 67628,
 -61021,
 295804152,
 67627,
 -61020,
 295835805,
 67626,
 -61019,
 295898412,
 67625,
 -1,
 295961395,
 67624,
 296161708,
 295744775,
 -1,
 -61016,
 296105825,
 67623,
 -61015,
 296197368,
 67622,
 -61014,
 296229021,
 67621,
 -61013,
 296291628,
 67620,
 -1,
 296354611,
 67619,
 296554930,
 296147360,
 -1,
 -61010,
 296499041,
 67618,
 -61009,
 296590584,
 67617,
 -61008,
 296622237,
 67616,
 -61007,
 296684844,
 67615,
 -1,
 296747827,
 67614,
 296948152,
 296508712,
 -1,
 -61004,
 296892257,
 67613,
 -61003,
 296983800,
 67612,
 -61002,
 297015453,
 67611,
 -61001,
 297078060,
 67610,
 -1,
 297141043,
 67609,
 297341374,
 296886868,
 -1,
 -60998,
 297285473,
 67608,
 -60997,
 297377016,
 67607,
 -60996,
 297408669,
 67606,
 -60995,
 297471276,
 67605,
 -1,
 297534259,
 67604,
 297734596,
 297324175,
 -1,
 -60992,
 297678689,
 67603,
 -60991,
 297770232,
 67602,
 -60990,
 297801885,
 67601,
 -60989,
 297864492,
 67600,
 -1,
 297927475,
 67599,
 298127818,
 297701687,
 -1,
 -60986,
 298071905,
 67598,
 -60985,
 298163448,
 67597,
 -60984,
 298195101,
 67596,
 -60983,
 298257708,
 67595,
 -1,
 298320691,
 67594,
 298521039,
 298103621,
 -1,
 -60980,
 298491128,
 67637,
 -60979,
 298522781,
 67636,
 -60978,
 298585388,
 67635,
 -1,
 298648371,
 67634,
 298848722,
 298483659,
 -1,
 -60975,
 298818808,
 67647,
 -1,
 298844979,
 67644,
 299045333,
 298780591,
 -1,
 -60972,
 298978604,
 67640,
 -1,
 299041587,
 67639,
 299241944,
 298996428,
 -1,
 -60969,
 299212024,
 67592,
 -1,
 299238195,
 67589,
 -60967,
 299186017,
 67588,
 -60966,
 299408632,
 67587,
 -60965,
 299440285,
 67586,
 -60964,
 299502892,
 67585,
 -1,
 299565875,
 67584,
 -1,
 295281413,
 9005,
 299832160,
 264706285,
 -1,
 299897693,
 299762424,
 -1,
 299963212,
 299862222,
 -1,
 300028465,
 299899037,
 -1,
 300093998,
 299968442,
 -1,
 300159474,
 300066702,
 -1,
 300225000,
 300103521,
 -1,
 -60954,
 300214297,
 12972,
 -60953,
 300244264,
 12944,
 -1,
 300290621,
 12956,
 300487147,
 300213642,
 -1,
 -60950,
 300439341,
 12971,
 -1,
 300509024,
 12945,
 300683758,
 300420396,
 -1,
 -60947,
 300621461,
 12934,
 -1,
 300694777,
 12953,
 -60945,
 300656767,
 12949,
 -60944,
 300849094,
 12947,
 -60943,
 300926315,
 12933,
 -1,
 300995714,
 12870,
 301142521,
 300107847,
 -1,
 301208055,
 301078685,
 -1,
 -60939,
 301169917,
 12932,
 -60938,
 301222310,
 12939,
 -1,
 301272309,
 12950,
 -60936,
 301175282,
 12931,
 -1,
 301445845,
 12955,
 301601280,
 301118727,
 -1,
 301666815,
 301534508,
 -1,
 301732350,
 301639566,
 -1,
 -60931,
 301720970,
 12961,
 -1,
 301768880,
 12974,
 -1,
 301688747,
 12970,
 -1,
 301638206,
 12968,
 302060038,
 301539924,
 -1,
 302125572,
 301993260,
 -1,
 -60925,
 302092289,
 12942,
 -1,
 302139124,
 12969,
 -60923,
 302069660,
 12938,
 -1,
 302284297,
 12954,
 302453259,
 301993260,
 -1,
 -60920,
 302410150,
 12957,
 -60919,
 302454951,
 12973,
 -60918,
 302555710,
 12935,
 -1,
 302580274,
 12943,
 302780945,
 302414704,
 -1,
 302846480,
 302750968,
 -1,
 -60914,
 302811200,
 12963,
 -60913,
 302854674,
 12962,
 -1,
 302920796,
 12951,
 -1,
 302790700,
 12965,
 303174165,
 302769546,
 -1,
 -60909,
 303139057,
 12929,
 -60908,
 303204371,
 12930,
 -1,
 303273397,
 12937,
 303436314,
 303127848,
 -1,
 303501849,
 303372445,
 -1,
 -60904,
 303438627,
 12936,
 -1,
 303519590,
 12976,
 -1,
 303456220,
 12948,
 303763998,
 303419023,
 -1,
 -60900,
 303703771,
 12966,
 -60899,
 303817278,
 12967,
 -1,
 303835823,
 12952,
 304026145,
 303739717,
 -1,
 -60896,
 303970189,
 12941,
 -1,
 304066731,
 12940,
 304222756,
 303993143,
 -1,
 -60893,
 304161392,
 12871,
 -1,
 304251699,
 12869,
 304419367,
 304202642,
 -1,
 -60890,
 304405359,
 12964,
 -1,
 304417822,
 12946,
 304615978,
 304350003,
 -1,
 -60887,
 304561448,
 12959,
 -1,
 304634122,
 12975,
 -60885,
 304565455,
 12868,
 -60884,
 304745711,
 12958,
 -60883,
 304853304,
 12928,
 -1,
 304931236,
 12960,
 305135615,
 300028737,
 -1,
 -60880,
 305050887,
 127276,
 -1,
 305101680,
 127275,
 305271402,
 300011151,
 -1,
 305336937,
 305247321,
 -1,
 305402446,
 305314494,
 -1,
 -60875,
 305364939,
 9449,
 -60874,
 305414777,
 9448,
 -60873,
 305465263,
 9447,
 -60872,
 305574725,
 9446,
 -60871,
 305624264,
 9445,
 -60870,
 305674081,
 9444,
 -60869,
 305784202,
 9443,
 -60868,
 305833870,
 9442,
 -60867,
 305902855,
 9441,
 -60866,
 305933629,
 9440,
 -60865,
 306043296,
 9439,
 -60864,
 306093304,
 9438,
 -60863,
 306142504,
 9437,
 -60862,
 306192980,
 9436,
 -60861,
 306302607,
 9435,
 -60860,
 306352439,
 9434,
 -60859,
 306401996,
 9433,
 -60858,
 306452637,
 9432,
 -60857,
 306561938,
 9431,
 -60856,
 306611917,
 9430,
 -60855,
 306661447,
 9429,
 -60854,
 306711852,
 9428,
 -60853,
 306821371,
 9427,
 -60852,
 306871152,
 9426,
 -60851,
 306920896,
 9425,
 -1,
 306971443,
 9424,
 307232767,
 305365566,
 -1,
 -60848,
 307134411,
 9423,
 -60847,
 307184249,
 9422,
 -60846,
 307234735,
 9421,
 -60845,
 307344197,
 9420,
 -60844,
 307393736,
 9419,
 -60843,
 307443553,
 9418,
 -60842,
 307553674,
 9417,
 -60841,
 307603342,
 9416,
 -60840,
 307672327,
 9415,
 -60839,
 307703101,
 9414,
 -60838,
 307812768,
 9413,
 -60837,
 307862776,
 9412,
 -60836,
 307911976,
 9411,
 -60835,
 307962452,
 9410,
 -60834,
 308072079,
 9409,
 -60833,
 308121911,
 9408,
 -60832,
 308171468,
 9407,
 -60831,
 308222109,
 9406,
 -60830,
 308331410,
 9405,
 -60829,
 308381389,
 9404,
 -60828,
 308430919,
 9403,
 -60827,
 308481324,
 9402,
 -60826,
 308590843,
 9401,
 -60825,
 308640624,
 9400,
 -60824,
 308690368,
 9399,
 -1,
 308740915,
 9398,
 -1,
 305321362,
 10688,
 309007030,
 305222340,
 -1,
 309072530,
 308995466,
 -1,
 309138046,
 309037287,
 -1,
 309203581,
 309124215,
 9331,
 309329919,
 309154857,
 -1,
 309334642,
 309257610,
 -1,
 -60815,
 309299441,
 12882,
 -1,
 309364755,
 12883,
 309531253,
 309307278,
 -1,
 -60812,
 309511531,
 12886,
 -1,
 309541502,
 12887,
 309727864,
 309470872,
 -1,
 -60809,
 309660972,
 12881,
 -1,
 309781810,
 12873,
 309924475,
 309676103,
 -1,
 -60806,
 309891570,
 12884,
 -1,
 309929986,
 12885,
 -60804,
 309867062,
 12889,
 -1,
 310100170,
 12888,
 -1,
 309173064,
 9323,
 310317712,
 309078431,
 -1,
 310383247,
 310264441,
 12890,
 310509567,
 310334505,
 -1,
 310514308,
 310437258,
 -1,
 -60797,
 310479089,
 12892,
 -1,
 310544403,
 12893,
 310710919,
 310486926,
 -1,
 -60794,
 310691179,
 12977,
 -1,
 310721150,
 12978,
 310907530,
 310650520,
 -1,
 -60791,
 310840620,
 12891,
 -1,
 310961458,
 12874,
 311104141,
 310855751,
 -1,
 -60788,
 311071218,
 12894,
 -1,
 311109634,
 12895,
 -60786,
 311046710,
 12980,
 -1,
 311279818,
 12979,
 -1,
 310341562,
 9324,
 311558143,
 310285749,
 9321,
 -1,
 311476324,
 12872,
 311628457,
 309020743,
 -1,
 311693989,
 311598328,
 -1,
 311759524,
 311658181,
 12981,
 311885823,
 311710761,
 -1,
 311890585,
 311813514,
 -1,
 -60776,
 311855345,
 12983,
 -1,
 311920659,
 12984,
 312087196,
 311863182,
 -1,
 -60773,
 312067435,
 12987,
 -1,
 312097406,
 12988,
 312283807,
 312026776,
 -1,
 -60770,
 312216876,
 12982,
 -1,
 312337714,
 12875,
 312480418,
 312232007,
 -1,
 -60767,
 312447474,
 12985,
 -1,
 312485890,
 12986,
 -60765,
 312422966,
 12990,
 -1,
 312656074,
 12989,
 -1,
 311742959,
 9325,
 312934399,
 311650140,
 -1,
 312939176,
 312820345,
 12991,
 -1,
 312918116,
 12876,
 -1,
 312897466,
 9326,
 313135792,
 311601038,
 -1,
 313201325,
 313065570,
 -1,
 -60756,
 313142828,
 12877,
 -1,
 313225146,
 9327,
 313458687,
 313133499,
 -1,
 -60753,
 313339436,
 12878,
 -1,
 313421754,
 9328,
 313594549,
 313068844,
 -1,
 313660084,
 313565758,
 -1,
 -60749,
 313601580,
 12879,
 -1,
 313683898,
 9329,
 -1,
 313609595,
 9322,
 -1,
 313550975,
 9330,
 313987827,
 308973879,
 -1,
 314053360,
 313928673,
 -1,
 314118846,
 314041738,
 -1,
 -60742,
 314062689,
 13025,
 -60741,
 314154232,
 13027,
 -60740,
 314185885,
 13024,
 -60739,
 314248492,
 13026,
 -1,
 314311475,
 13023,
 314512068,
 314091406,
 -1,
 -60736,
 314455905,
 13020,
 -60735,
 314547448,
 13022,
 -60734,
 314579101,
 13019,
 -60733,
 314641708,
 13021,
 -1,
 314704691,
 13018,
 314905290,
 314488071,
 -1,
 -60730,
 314849121,
 13048,
 -60729,
 314940664,
 13050,
 -60728,
 314972317,
 13047,
 -60727,
 315034924,
 13049,
 -1,
 315097907,
 13046,
 315298512,
 314858792,
 -1,
 -60724,
 315242337,
 13030,
 -60723,
 315333880,
 13032,
 -60722,
 315365533,
 13029,
 -60721,
 315428140,
 13031,
 -1,
 315491123,
 13028,
 315691734,
 315236948,
 -1,
 -60718,
 315635553,
 13040,
 -60717,
 315727096,
 13042,
 -60716,
 315758749,
 13039,
 -60715,
 315821356,
 13041,
 -1,
 315884339,
 13038,
 316084956,
 315658551,
 -1,
 -60712,
 316028769,
 13015,
 -60711,
 316120312,
 13017,
 -60710,
 316151965,
 13014,
 -60709,
 316214572,
 13016,
 -1,
 316277555,
 13013,
 316478178,
 316064658,
 -1,
 -60706,
 316421985,
 13035,
 -60705,
 316513528,
 13037,
 -60704,
 316545181,
 13034,
 -60703,
 316607788,
 13036,
 -1,
 316670771,
 13033,
 316871399,
 316453701,
 -1,
 -60700,
 316841208,
 13054,
 -60699,
 316872861,
 13052,
 -60698,
 316935468,
 13053,
 -1,
 316998451,
 13051,
 317199083,
 316818041,
 -1,
 -60695,
 317142881,
 13044,
 -60694,
 317234424,
 13045,
 -1,
 317260595,
 13043,
 -60692,
 317142881,
 13010,
 -60691,
 317431032,
 13012,
 -60690,
 317462685,
 13009,
 -60689,
 317525292,
 13011,
 -1,
 317588275,
 13008,
 317849599,
 313987443,
 -1,
 -60686,
 317724214,
 12925,
 -1,
 317796301,
 12924,
 317985561,
 313967506,
 -1,
 318051095,
 317944207,
 -1,
 318116602,
 318039434,
 -1,
 318182136,
 318091889,
 12898,
 -1,
 318152545,
 12912,
 318373887,
 318156988,
 12907,
 -1,
 318283617,
 12921,
 318444287,
 318101920,
 -1,
 318509821,
 318392673,
 12901,
 -1,
 318480225,
 12915,
 318701567,
 318488590,
 12908,
 -1,
 318611297,
 12922,
 318771972,
 318411063,
 -1,
 318837506,
 318750988,
 12896,
 -1,
 318807905,
 12910,
 319029247,
 318778775,
 12906,
 -1,
 318938977,
 12920,
 319099657,
 318733168,
 -1,
 319165191,
 319048007,
 12904,
 -1,
 319135585,
 12918,
 319356927,
 319098621,
 12905,
 -1,
 319266657,
 12919,
 319427341,
 319086875,
 12903,
 319553535,
 319378473,
 -1,
 -60660,
 319436641,
 12926,
 -1,
 319488819,
 12917,
 319689487,
 319411790,
 12902,
 -1,
 319659873,
 12916,
 319820561,
 319634434,
 12899,
 -1,
 319790945,
 12913,
 319951635,
 319763506,
 12897,
 -1,
 319922017,
 12911,
 320082709,
 319913055,
 12900,
 -1,
 320053089,
 12914,
 320274431,
 320012678,
 12909,
 -1,
 320184161,
 12923,
 -60648,
 318015330,
 9097,
 -1,
 320276590,
 10162,
 320475950,
 317962491,
 -1,
 320541484,
 320411805,
 -1,
 320607017,
 320515909,
 -1,
 320672543,
 320595338,
 -1,
 -60642,
 320637169,
 9313,
 -1,
 320702483,
 9314,
 320869154,
 320645006,
 -1,
 -60639,
 320849259,
 9317,
 -1,
 320879230,
 9318,
 321065765,
 320817223,
 -1,
 -60636,
 321032690,
 9315,
 -1,
 321071106,
 9316,
 -60634,
 320997731,
 9450,
 -60633,
 321237304,
 9312,
 -60632,
 321270326,
 9320,
 -1,
 321372362,
 9319,
 321585151,
 320592211,
 -1,
 -60629,
 321454121,
 8856,
 -1,
 321575767,
 10808,
 -60627,
 320521522,
 8857,
 -1,
 321705716,
 8861,
 321852211,
 320461216,
 -1,
 -60624,
 321816893,
 12342,
 -60623,
 321855779,
 8853,
 -60622,
 321972257,
 10681,
 -1,
 322016105,
 10679,
 322179896,
 321827653,
 -1,
 322245431,
 322114459,
 -1,
 -60618,
 322186848,
 10026,
 -1,
 322279508,
 10686,
 -1,
 322207691,
 127278,
 322507579,
 322168202,
 -1,
 -60614,
 322447551,
 9098,
 -1,
 322548068,
 8855,
 322704190,
 322483463,
 -1,
 -60611,
 322678073,
 8858,
 -1,
 322754065,
 10680,
 322900801,
 322642516,
 -1,
 -60608,
 322864283,
 10806,
 -1,
 322900149,
 8854,
 323097412,
 322861936,
 -1,
 -60605,
 323058995,
 9938,
 -1,
 323139835,
 127277,
 323294023,
 323027763,
 -1,
 -60602,
 323253323,
 8859,
 -1,
 323335693,
 10684,
 -60600,
 323233063,
 10678,
 -60599,
 323429371,
 10050,
 -60598,
 323541928,
 10689,
 -60597,
 323562422,
 8860,
 -1,
 323655764,
 10687,
 323878911,
 299914281,
 -1,
 323883868,
 323794343,
 -1,
 323949393,
 323856352,
 -1,
 -60592,
 323885430,
 9684,
 -1,
 323962742,
 9683,
 324146004,
 323921806,
 -1,
 -60589,
 324100318,
 10683,
 -1,
 324149290,
 10690,
 324342615,
 324128399,
 -1,
 -60586,
 324309832,
 9682,
 -1,
 324358037,
 9680,
 -60584,
 324321183,
 9677,
 -60583,
 324476432,
 10691,
 -60582,
 324574949,
 9681,
 -60581,
 324628718,
 10677,
 -1,
 324667752,
 9685,
 -1,
 323857371,
 10682,
 324993023,
 299841377,
 -1,
 -60577,
 324899697,
 94,
 -1,
 324968644,
 10768,
 325129273,
 299811730,
 -1,
 325194693,
 325061932,
 -1,
 325260228,
 325157376,
 -1,
 325325685,
 325248394,
 -1,
 325391211,
 325298062,
 -1,
 -60570,
 325350600,
 5096,
 -60569,
 325400417,
 5095,
 -60568,
 325491960,
 5094,
 -60567,
 325523613,
 5093,
 -60566,
 325586220,
 5092,
 -1,
 325649203,
 5091,
 325849970,
 325373583,
 -1,
 -60563,
 325809352,
 5090,
 -60562,
 325859169,
 5089,
 -60561,
 325950712,
 5088,
 -60560,
 325982365,
 5087,
 -60559,
 326044972,
 5086,
 -1,
 326107955,
 5085,
 -60557,
 325785757,
 5080,
 -60556,
 326241580,
 5078,
 -1,
 326304563,
 5076,
 326505340,
 325298062,
 5069,
 -60553,
 326464712,
 5074,
 -60552,
 326514529,
 5073,
 -60551,
 326606072,
 5072,
 -60550,
 326637725,
 5071,
 -60549,
 326700332,
 5070,
 -1,
 326763315,
 5068,
 326964100,
 326458664,
 -1,
 327029631,
 326894387,
 5054,
 -1,
 327009170,
 5056,
 -60544,
 326989000,
 5061,
 -60543,
 327104353,
 5060,
 -60542,
 327195896,
 5059,
 -60541,
 327227549,
 5058,
 -1,
 327290156,
 5057,
 327488396,
 326943634,
 -1,
 -60538,
 327447752,
 5042,
 -60537,
 327497569,
 5041,
 -60536,
 327589112,
 5040,
 -60535,
 327621405,
 5055,
 -60534,
 327686301,
 5039,
 -60533,
 327748908,
 5038,
 -1,
 327811891,
 5037,
 328012692,
 327465211,
 -1,
 -60530,
 327972040,
 5083,
 -60529,
 328021857,
 5082,
 -60528,
 328113400,
 5081,
 -60527,
 328139518,
 5084,
 -60526,
 328210589,
 5079,
 -60525,
 328273196,
 5077,
 -1,
 328336179,
 5075,
 328536987,
 327959161,
 -1,
 -60522,
 328496328,
 5108,
 -60521,
 328546145,
 5107,
 -60520,
 328637688,
 5106,
 -60519,
 328669341,
 5105,
 -60518,
 328731948,
 5104,
 -1,
 328794931,
 5103,
 328995746,
 328512325,
 -1,
 -60515,
 328955080,
 5102,
 -60514,
 329004897,
 5101,
 -60513,
 329096440,
 5100,
 -60512,
 329128093,
 5099,
 -60511,
 329190700,
 5098,
 -1,
 329253683,
 5097,
 329454505,
 328941258,
 -1,
 -60508,
 329413832,
 5067,
 -60507,
 329463649,
 5066,
 -60506,
 329555192,
 5065,
 -60505,
 329586845,
 5064,
 -60504,
 329649452,
 5063,
 -1,
 329712435,
 5062,
 329913264,
 329436815,
 -1,
 -60501,
 329872584,
 5048,
 -60500,
 329922401,
 5047,
 -60499,
 330013944,
 5046,
 -60498,
 330045597,
 5045,
 -60497,
 330108204,
 5044,
 -1,
 330171187,
 5043,
 330372023,
 329877197,
 -1,
 -60494,
 330331336,
 5036,
 -60493,
 330381153,
 5035,
 -60492,
 330472696,
 5034,
 -60491,
 330504349,
 5033,
 -60490,
 330566956,
 5032,
 -1,
 330629939,
 5030,
 330830781,
 330310228,
 -1,
 -60487,
 330774369,
 5053,
 -60486,
 330865912,
 5052,
 -60485,
 330897565,
 5051,
 -60484,
 330960172,
 5050,
 -1,
 331023155,
 5049,
 -60482,
 330790088,
 5029,
 -60481,
 331167585,
 5028,
 -60480,
 331259128,
 5027,
 -60479,
 331341775,
 5031,
 -60478,
 331356317,
 5026,
 -60477,
 331418924,
 5025,
 -1,
 331481907,
 5024,
 -1,
 325193276,
 10003,
 331748405,
 325124915,
 -1,
 331813939,
 331681556,
 -1,
 331879434,
 331752805,
 -1,
 331944916,
 331848556,
 -1,
 332010443,
 331898152,
 43590,
 -1,
 331974349,
 43586,
 -60468,
 331956857,
 43592,
 -60467,
 332129674,
 43589,
 -60466,
 332158609,
 43595,
 -60465,
 332248327,
 43593,
 -60464,
 332323232,
 43591,
 -60463,
 332385935,
 43594,
 -60462,
 332435767,
 43584,
 -60461,
 332498637,
 43585,
 -1,
 332561479,
 43588,
 332731358,
 331898152,
 -1,
 332796889,
 332710802,
 -1,
 -60457,
 332755139,
 43536,
 -60456,
 332845558,
 43538,
 -1,
 332858163,
 43537,
 333059036,
 332760781,
 -1,
 -60453,
 333017283,
 43530,
 -1,
 333054771,
 43531,
 -60451,
 333017283,
 43543,
 -1,
 333185843,
 43544,
 333386722,
 332716448,
 -1,
 -60448,
 333335928,
 43547,
 -60447,
 333429171,
 43548,
 -1,
 333447987,
 43546,
 333648870,
 333363451,
 -1,
 -60444,
 333625779,
 43542,
 -60443,
 333678608,
 43545,
 -1,
 333710131,
 43541,
 333911018,
 333594048,
 -1,
 -60440,
 333887923,
 43550,
 -60439,
 333959681,
 43553,
 -1,
 333972275,
 43549,
 334173165,
 333899146,
 -1,
 -60436,
 334150067,
 43540,
 -1,
 334168883,
 43539,
 334369776,
 334145422,
 -1,
 -60433,
 334321324,
 43558,
 -1,
 334365491,
 43559,
 334566387,
 334307924,
 -1,
 -60430,
 334524611,
 43551,
 -1,
 334562099,
 43552,
 334762998,
 334532919,
 -1,
 -60427,
 334739891,
 43527,
 -1,
 334758707,
 43526,
 334959609,
 334713548,
 -1,
 -60424,
 334936499,
 43535,
 -1,
 334955315,
 43534,
 335156220,
 334923469,
 -1,
 -60421,
 335133107,
 43529,
 -1,
 335151923,
 43528,
 335352831,
 335117383,
 -1,
 -60418,
 335329715,
 43533,
 -1,
 335348531,
 43532,
 335549441,
 335282995,
 43520,
 -1,
 335485085,
 43524,
 -60414,
 335490084,
 43554,
 -60413,
 335641843,
 43557,
 -60412,
 335689569,
 43522,
 -60411,
 335759785,
 43555,
 -60410,
 335846648,
 43525,
 -60409,
 335872766,
 43556,
 -60408,
 335943837,
 43521,
 -60407,
 336050611,
 43560,
 -1,
 336071980,
 43523,
 336270358,
 331844661,
 -1,
 336335887,
 336200499,
 -1,
 -60403,
 336279393,
 43569,
 -60402,
 336337053,
 43568,
 -1,
 336397107,
 43561,
 336598033,
 336279393,
 43565,
 -1,
 336530732,
 43570,
 336729107,
 336567544,
 43567,
 -1,
 336661804,
 43566,
 336860181,
 336664733,
 43562,
 -1,
 336795805,
 43563,
 -1,
 336827832,
 43564,
 337056804,
 336257393,
 -1,
 337122330,
 337044874,
 -1,
 -60391,
 337086705,
 43602,
 -1,
 337152019,
 43603,
 337318941,
 337094542,
 -1,
 -60388,
 337298795,
 43606,
 -1,
 337328766,
 43607,
 337515552,
 337266759,
 -1,
 -60385,
 337482226,
 43604,
 -1,
 337520642,
 43605,
 -60383,
 337447267,
 43600,
 -60382,
 337686840,
 43601,
 -60381,
 337719862,
 43609,
 -1,
 337821898,
 43608,
 337974317,
 337020623,
 -1,
 338039849,
 337943404,
 -1,
 -60377,
 337976102,
 43587,
 -60376,
 338043476,
 43596,
 -1,
 338150290,
 43597,
 -60374,
 337980452,
 43571,
 -60373,
 338266346,
 43574,
 -60372,
 338315689,
 43572,
 -1,
 338363134,
 43573,
 338624511,
 337929006,
 -1,
 338629681,
 338540795,
 -1,
 -60368,
 338601203,
 43614,
 -1,
 338637533,
 43613,
 -60366,
 338575899,
 43615,
 -1,
 338756899,
 43612,
 -60364,
 331748007,
 8256,
 -1,
 338904961,
 9939,
 339088440,
 331683997,
 -1,
 -60361,
 339046438,
 9911,
 -1,
 339128993,
 9767,
 -1,
 339054179,
 9962,
 339350608,
 325111439,
 -1,
 339416143,
 339320056,
 -1,
 339481670,
 339367599,
 -1,
 339547205,
 339445966,
 -1,
 339612738,
 339498644,
 -1,
 339678272,
 339548225,
 10960,
 -1,
 339615398,
 10962,
 339869695,
 339636084,
 10959,
 -1,
 339746470,
 10961,
 339940420,
 339555996,
 10828,
 -1,
 339895506,
 10832,
 -1,
 339920417,
 10829,
 -1,
 339505510,
 8272,
 340202574,
 339463889,
 -1,
 340268106,
 340163440,
 -1,
 -60343,
 340235254,
 8754,
 -1,
 340315869,
 10561,
 -60341,
 340249775,
 8631,
 -60340,
 340433461,
 8635,
 -60339,
 340473528,
 8753,
 -1,
 340556481,
 10227,
 -1,
 340160710,
 9729,
 -1,
 339390878,
 9114,
 340857948,
 339283244,
 -1,
 340923480,
 340794166,
 -1,
 340989015,
 340871590,
 -1,
 341054550,
 340930931,
 -1,
 -60331,
 341026575,
 65098,
 -1,
 341080149,
 65102,
 -1,
 341026162,
 8452,
 -1,
 340953507,
 162,
 341382235,
 340887552,
 -1,
 -60326,
 341340250,
 184,
 -1,
 341412259,
 8373,
 -1,
 341333506,
 9907,
 341704703,
 340833543,
 -1,
 341709925,
 341617448,
 -1,
 341775457,
 341639619,
 -1,
 -60320,
 341716326,
 9876,
 -1,
 341810074,
 127370,
 341972068,
 341715821,
 -1,
 -60317,
 341955686,
 9768,
 -1,
 341972608,
 9769,
 -1,
 341925813,
 9932,
 -1,
 341641730,
 8354,
 342302301,
 8788,
 -1,
 342366592,
 342229811,
 -1,
 342431912,
 342339723,
 -1,
 342496776,
 342402958,
 -1,
 342562268,
 342482715,
 -1,
 342627681,
 342511393,
 -1,
 342693088,
 342561957,
 -1,
 342758562,
 342679288,
 -1,
 342824050,
 342743456,
 120421,
 -60304,
 342775455,
 120769,
 -60303,
 342825117,
 120761,
 -1,
 342931867,
 120767,
 343086197,
 342812042,
 120425,
 -60300,
 343025632,
 120753,
 -1,
 343106072,
 120765,
 343282809,
 343055608,
 120420,
 343408639,
 343220820,
 -1,
 -60296,
 343307458,
 120760,
 -1,
 343369299,
 120770,
 343544956,
 343215404,
 120410,
 -60293,
 343499234,
 120752,
 -1,
 343560800,
 120750,
 343741566,
 343506891,
 120431,
 -1,
 343687484,
 120751,
 343872640,
 343672751,
 120429,
 -1,
 343808157,
 120759,
 344003714,
 343816033,
 120426,
 -1,
 343954016,
 120766,
 344134788,
 343975822,
 120424,
 -1,
 344072220,
 120764,
 344265862,
 344110343,
 120423,
 -1,
 344242590,
 120762,
 344396936,
 344218920,
 120419,
 -1,
 344340321,
 120758,
 344528010,
 344334932,
 120418,
 -1,
 344471393,
 120757,
 344659084,
 344510095,
 120417,
 -1,
 344608013,
 120756,
 344790158,
 344625463,
 120416,
 -1,
 344742227,
 120755,
 344921232,
 344725661,
 120414,
 -1,
 344859252,
 120754,
 345052306,
 344884941,
 120412,
 -1,
 344986948,
 120748,
 345183380,
 345000007,
 120411,
 -1,
 345123211,
 120763,
 345314454,
 345159931,
 120409,
 -1,
 345257365,
 120749,
 345445528,
 345275248,
 120408,
 -1,
 345422235,
 120768,
 345576602,
 345390528,
 120407,
 -1,
 345522492,
 120747,
 345707676,
 345506611,
 120406,
 -1,
 345669117,
 120746,
 -60259,
 345653881,
 120430,
 -60258,
 345813829,
 120428,
 -60257,
 345863368,
 120427,
 -60256,
 345910589,
 120422,
 -60255,
 345985740,
 120415,
 -1,
 346080146,
 120413,
 346232023,
 342745979,
 -1,
 346297511,
 346219914,
 120399,
 346363046,
 346236896,
 120727,
 -1,
 346320016,
 120737,
 -1,
 346317336,
 120739,
 346559659,
 346282400,
 120395,
 -60247,
 346511007,
 120743,
 -60246,
 346560669,
 120735,
 -1,
 346667419,
 120741,
 346821807,
 346529016,
 120394,
 346947583,
 346759764,
 -1,
 -60242,
 346846402,
 120734,
 -1,
 346908243,
 120744,
 347083954,
 346754348,
 120384,
 -60239,
 347038178,
 120726,
 -1,
 347099744,
 120724,
 347280564,
 347045835,
 120405,
 -1,
 347226428,
 120725,
 347411638,
 347211695,
 120403,
 -1,
 347347101,
 120733,
 347542712,
 347354977,
 120400,
 -1,
 347492960,
 120740,
 347673786,
 347514766,
 120398,
 -1,
 347611164,
 120738,
 347804860,
 347649287,
 120397,
 -1,
 347781534,
 120736,
 347935934,
 347757864,
 120393,
 -1,
 347879265,
 120732,
 348067008,
 347873876,
 120392,
 -1,
 348010337,
 120731,
 348198082,
 348049039,
 120391,
 -1,
 348146957,
 120730,
 348329156,
 348164407,
 120390,
 -1,
 348281171,
 120729,
 348460230,
 348264605,
 120388,
 -1,
 348398196,
 120728,
 348591304,
 348423885,
 120386,
 -1,
 348525892,
 120722,
 348722378,
 348567803,
 120383,
 -1,
 348665237,
 120723,
 348853452,
 348683120,
 120382,
 -1,
 348830107,
 120742,
 348984526,
 348798400,
 120381,
 -1,
 348930364,
 120721,
 349115600,
 348914483,
 120380,
 -1,
 349076989,
 120720,
 -60207,
 349061753,
 120404,
 -60206,
 349221701,
 120402,
 -60205,
 349271240,
 120401,
 -60204,
 349318461,
 120396,
 -60203,
 349393612,
 120389,
 -60202,
 349488018,
 120387,
 -1,
 349521991,
 120385,
 349705435,
 346216864,
 -1,
 -60199,
 349691788,
 120777,
 -60198,
 349717103,
 120775,
 -1,
 349816264,
 120771,
 -60196,
 349688509,
 120773,
 -60195,
 349901603,
 120776,
 -60194,
 349989704,
 120745,
 -60193,
 350072554,
 120774,
 -1,
 350137370,
 120772,
 350295317,
 342679288,
 -1,
 350360805,
 350280096,
 120317,
 -60189,
 350312095,
 120711,
 -60188,
 350361757,
 120703,
 -1,
 350468507,
 120709,
 350622952,
 350348682,
 120321,
 -60185,
 350562272,
 120695,
 -1,
 350642712,
 120707,
 350819564,
 350592248,
 120316,
 350945279,
 350757460,
 -1,
 -60181,
 350844098,
 120702,
 -1,
 350905939,
 120712,
 351081711,
 350752044,
 120306,
 -60178,
 351035874,
 120694,
 -1,
 351097440,
 120692,
 351278321,
 351043531,
 120327,
 -1,
 351224124,
 120693,
 351409395,
 351209391,
 120325,
 -1,
 351344797,
 120701,
 351540469,
 351352673,
 120322,
 -1,
 351490656,
 120708,
 351671543,
 351512462,
 120320,
 -1,
 351608860,
 120706,
 351802617,
 351646983,
 120319,
 -1,
 351779230,
 120704,
 351933691,
 351755560,
 120315,
 -1,
 351876961,
 120700,
 352064765,
 351871572,
 120314,
 -1,
 352008033,
 120699,
 352195839,
 352046735,
 120313,
 -1,
 352144653,
 120698,
 352326913,
 352162103,
 120312,
 -1,
 352278867,
 120697,
 352457987,
 352262301,
 120310,
 -1,
 352395892,
 120696,
 352589061,
 352421581,
 120308,
 -1,
 352523588,
 120690,
 352720135,
 352536647,
 120307,
 -1,
 352659851,
 120705,
 352851209,
 352696571,
 120305,
 -1,
 352794005,
 120691,
 352982283,
 352811888,
 120304,
 -1,
 352958875,
 120710,
 353113357,
 352927168,
 120303,
 -1,
 353059132,
 120689,
 353244431,
 353043251,
 120302,
 -1,
 353205757,
 120688,
 -60144,
 353190521,
 120326,
 -60143,
 353350469,
 120324,
 -60142,
 353400008,
 120323,
 -60141,
 353447229,
 120318,
 -60140,
 353522380,
 120311,
 -1,
 353616786,
 120309,
 353768778,
 350282619,
 -1,
 353834266,
 353756554,
 120295,
 353899801,
 353773536,
 120669,
 -1,
 353856656,
 120679,
 -1,
 353853976,
 120681,
 354096414,
 353819040,
 120291,
 -60132,
 354047647,
 120685,
 -60131,
 354097309,
 120677,
 -1,
 354204059,
 120683,
 354358562,
 354065656,
 120290,
 354484223,
 354296404,
 -1,
 -60127,
 354383042,
 120676,
 -1,
 354444883,
 120686,
 354620709,
 354290988,
 120280,
 -60124,
 354574818,
 120668,
 -1,
 354636384,
 120666,
 354817319,
 354582475,
 120301,
 -1,
 354763068,
 120667,
 354948393,
 354748335,
 120299,
 -1,
 354883741,
 120675,
 355079467,
 354891617,
 120296,
 -1,
 355029600,
 120682,
 355210541,
 355051406,
 120294,
 -1,
 355147804,
 120680,
 355341615,
 355185927,
 120293,
 -1,
 355318174,
 120678,
 355472689,
 355294504,
 120289,
 -1,
 355415905,
 120674,
 355603763,
 355410516,
 120288,
 -1,
 355546977,
 120673,
 355734837,
 355585679,
 120287,
 -1,
 355683597,
 120672,
 355865911,
 355701047,
 120286,
 -1,
 355817811,
 120671,
 355996985,
 355801245,
 120284,
 -1,
 355934836,
 120670,
 356128059,
 355960525,
 120282,
 -1,
 356062532,
 120664,
 356259133,
 356104443,
 120279,
 -1,
 356201877,
 120665,
 356390207,
 356219760,
 120278,
 -1,
 356366747,
 120684,
 356521281,
 356335040,
 120277,
 -1,
 356467004,
 120663,
 356652355,
 356451123,
 120276,
 -1,
 356613629,
 120662,
 -60092,
 356598393,
 120300,
 -60091,
 356758341,
 120298,
 -60090,
 356807880,
 120297,
 -60089,
 356855101,
 120292,
 -60088,
 356930252,
 120285,
 -60087,
 357024658,
 120283,
 -1,
 357058631,
 120281,
 357242200,
 353755505,
 -1,
 357307726,
 357229962,
 -1,
 -60083,
 357271793,
 120814,
 -1,
 357337107,
 120815,
 357504337,
 357279630,
 -1,
 -60080,
 357483883,
 120818,
 -1,
 357513854,
 120819,
 357700948,
 357451847,
 -1,
 -60077,
 357667314,
 120816,
 -1,
 357705730,
 120817,
 -60075,
 357632355,
 120812,
 -60074,
 357871928,
 120813,
 -60073,
 357904950,
 120821,
 -1,
 358006986,
 120820,
 358159708,
 357226912,
 -1,
 -60070,
 358145932,
 120719,
 -60069,
 358171247,
 120717,
 -1,
 358270408,
 120713,
 -60067,
 358142653,
 120715,
 -60066,
 358355747,
 120718,
 -60065,
 358443848,
 120687,
 -60064,
 358526698,
 120716,
 -1,
 358591514,
 120714,
 358749592,
 342561957,
 -1,
 358815101,
 358735608,
 -1,
 -60060,
 358776779,
 120379,
 -60059,
 358826617,
 120378,
 -60058,
 358877103,
 120377,
 -60057,
 358986565,
 120376,
 -60056,
 359036104,
 120375,
 -60055,
 359085921,
 120374,
 -60054,
 359196042,
 120373,
 -60053,
 359245710,
 120372,
 -60052,
 359314695,
 120371,
 -60051,
 359345469,
 120370,
 -60050,
 359455136,
 120369,
 -60049,
 359505144,
 120368,
 -60048,
 359554344,
 120367,
 -60047,
 359604820,
 120366,
 -60046,
 359714447,
 120365,
 -60045,
 359764279,
 120364,
 -60044,
 359813836,
 120363,
 -60043,
 359864477,
 120362,
 -60042,
 359973778,
 120361,
 -60041,
 360023757,
 120360,
 -60040,
 360073287,
 120359,
 -60039,
 360123692,
 120358,
 -60038,
 360233211,
 120357,
 -60037,
 360282992,
 120356,
 -60036,
 360332736,
 120355,
 -1,
 360383283,
 120354,
 360644607,
 358802299,
 -1,
 -60033,
 360546251,
 120353,
 -60032,
 360596089,
 120352,
 -60031,
 360646575,
 120351,
 -60030,
 360756037,
 120350,
 -60029,
 360805576,
 120349,
 -60028,
 360855393,
 120348,
 -60027,
 360965514,
 120347,
 -60026,
 361015182,
 120346,
 -60025,
 361084167,
 120345,
 -60024,
 361114941,
 120344,
 -60023,
 361224608,
 120343,
 -60022,
 361274616,
 120342,
 -60021,
 361323816,
 120341,
 -60020,
 361374292,
 120340,
 -60019,
 361483919,
 120339,
 -60018,
 361533751,
 120338,
 -60017,
 361583308,
 120337,
 -60016,
 361633949,
 120336,
 -60015,
 361743250,
 120335,
 -60014,
 361793229,
 120334,
 -60013,
 361842759,
 120333,
 -60012,
 361893164,
 120332,
 -60011,
 362002683,
 120331,
 -60010,
 362052464,
 120330,
 -60009,
 362102208,
 120329,
 -1,
 362152755,
 120328,
 362354099,
 358735608,
 -1,
 -60006,
 362315723,
 120275,
 -60005,
 362365561,
 120274,
 -60004,
 362416047,
 120273,
 -60003,
 362525509,
 120272,
 -60002,
 362575048,
 120271,
 -60001,
 362624865,
 120270,
 -60000,
 362734986,
 120269,
 -59999,
 362784654,
 120268,
 -59998,
 362853639,
 120267,
 -59997,
 362884413,
 120266,
 -59996,
 362994080,
 120265,
 -59995,
 363044088,
 120264,
 -59994,
 363093288,
 120263,
 -59993,
 363143764,
 120262,
 -59992,
 363253391,
 120261,
 -59991,
 363303223,
 120260,
 -59990,
 363352780,
 120259,
 -59989,
 363403421,
 120258,
 -59988,
 363512722,
 120257,
 -59987,
 363562701,
 120256,
 -59986,
 363612231,
 120255,
 -59985,
 363662636,
 120254,
 -59984,
 363772155,
 120253,
 -59983,
 363821936,
 120252,
 -59982,
 363871680,
 120251,
 -1,
 363922227,
 120250,
 364123598,
 362341243,
 -1,
 -59979,
 364085195,
 120249,
 -59978,
 364135033,
 120248,
 -59977,
 364185519,
 120247,
 -59976,
 364294981,
 120246,
 -59975,
 364344520,
 120245,
 -59974,
 364394337,
 120244,
 -59973,
 364504458,
 120243,
 -59972,
 364554126,
 120242,
 -59971,
 364623111,
 120241,
 -59970,
 364653885,
 120240,
 -59969,
 364763552,
 120239,
 -59968,
 364813560,
 120238,
 -59967,
 364862760,
 120237,
 -59966,
 364913236,
 120236,
 -59965,
 365022863,
 120235,
 -59964,
 365072695,
 120234,
 -59963,
 365122252,
 120233,
 -59962,
 365172893,
 120232,
 -59961,
 365282194,
 120231,
 -59960,
 365332173,
 120230,
 -59959,
 365381703,
 120229,
 -59958,
 365432108,
 120228,
 -59957,
 365541627,
 120227,
 -59956,
 365591408,
 120226,
 -59955,
 365641152,
 120225,
 -1,
 365691699,
 120224,
 365953023,
 364110193,
 -1,
 365958610,
 365880714,
 -1,
 -59951,
 365922545,
 120804,
 -1,
 365987859,
 120805,
 366155221,
 365930382,
 -1,
 -59948,
 366134635,
 120808,
 -1,
 366164606,
 120809,
 366351832,
 366102599,
 -1,
 -59945,
 366318066,
 120806,
 -1,
 366356482,
 120807,
 -59943,
 366283107,
 120802,
 -59942,
 366522680,
 120803,
 -59941,
 366555702,
 120811,
 -1,
 366657738,
 120810,
 366870527,
 342509445,
 -1,
 366876149,
 366796536,
 -1,
 -59937,
 366837707,
 120015,
 -59936,
 366887545,
 120014,
 -59935,
 366938031,
 120013,
 -59934,
 367047493,
 120012,
 -59933,
 367097032,
 120011,
 -59932,
 367146849,
 120010,
 -59931,
 367256970,
 120009,
 -59930,
 367306638,
 120008,
 -59929,
 367375623,
 120007,
 -59928,
 367406397,
 120006,
 -59927,
 367516064,
 120005,
 -59926,
 367549736,
 120003,
 -59925,
 367600212,
 120002,
 -59924,
 367709839,
 120001,
 -59923,
 367759671,
 120000,
 -59922,
 367809228,
 119999,
 -59921,
 367859869,
 119998,
 -59920,
 367969170,
 119997,
 -59919,
 368003143,
 119995,
 -59918,
 368097531,
 119993,
 -59917,
 368147312,
 119992,
 -59916,
 368197056,
 119991,
 -1,
 368247603,
 119990,
 368508927,
 366863227,
 -1,
 -59913,
 368410571,
 119989,
 -59912,
 368460409,
 119988,
 -59911,
 368510895,
 119987,
 -59910,
 368620357,
 119986,
 -59909,
 368669896,
 119985,
 -59908,
 368719713,
 119984,
 -59907,
 368829834,
 119983,
 -59906,
 368879502,
 119982,
 -59905,
 368913725,
 119980,
 -59904,
 369023392,
 119979,
 -59903,
 369073400,
 119978,
 -59902,
 369122600,
 119977,
 -59901,
 369201463,
 119974,
 -59900,
 369251020,
 119973,
 -59899,
 369329869,
 119970,
 -59898,
 369408251,
 119967,
 -59897,
 369458032,
 119966,
 -1,
 369492787,
 119964,
 369694575,
 342445857,
 -1,
 369759869,
 369628325,
 -1,
 369825343,
 369745656,
 -1,
 369890831,
 369809824,
 119953,
 -59891,
 369841823,
 120653,
 -59890,
 369891485,
 120645,
 -1,
 369998235,
 120651,
 370152978,
 369878410,
 119957,
 -59887,
 370092000,
 120637,
 -1,
 370172440,
 120649,
 370349590,
 370121976,
 119952,
 370475007,
 370287188,
 -1,
 -59883,
 370373826,
 120644,
 -1,
 370435667,
 120654,
 370611737,
 370281772,
 119942,
 -59880,
 370565602,
 120636,
 -1,
 370627168,
 120634,
 370808347,
 370573259,
 119963,
 -1,
 370753852,
 120635,
 370939421,
 370739119,
 119961,
 -1,
 370874525,
 120643,
 371070495,
 370882401,
 119958,
 -1,
 371020384,
 120650,
 371201569,
 371042190,
 119956,
 -1,
 371138588,
 120648,
 371332643,
 371176711,
 119955,
 -1,
 371308958,
 120646,
 371463717,
 371285288,
 119951,
 -1,
 371406689,
 120642,
 371594791,
 371401300,
 119950,
 -1,
 371537761,
 120641,
 371725865,
 371576463,
 119949,
 -1,
 371674381,
 120640,
 371856939,
 371691831,
 119948,
 -1,
 371808595,
 120639,
 371988013,
 371792029,
 119946,
 -1,
 371925620,
 120638,
 372119087,
 371951309,
 119944,
 -1,
 372053316,
 120632,
 372250161,
 372066375,
 119943,
 -1,
 372189579,
 120647,
 372381235,
 372226299,
 119941,
 -1,
 372323733,
 120633,
 372512309,
 372341616,
 119940,
 -1,
 372488603,
 120652,
 372643383,
 372456896,
 119939,
 -1,
 372588860,
 120631,
 372774457,
 372572979,
 119938,
 -1,
 372735485,
 120630,
 -59846,
 372720249,
 119962,
 -59845,
 372880197,
 119960,
 -59844,
 372929736,
 119959,
 -59843,
 372976957,
 119954,
 -59842,
 373052108,
 119947,
 -1,
 373146514,
 119945,
 373298804,
 369812347,
 -1,
 373364292,
 373286282,
 119931,
 373429827,
 373303264,
 120611,
 -1,
 373386384,
 120621,
 -1,
 373383704,
 120623,
 373626440,
 373348768,
 119927,
 -59834,
 373577375,
 120627,
 -59833,
 373627037,
 120619,
 -1,
 373733787,
 120625,
 373888588,
 373595384,
 119926,
 374013951,
 373826132,
 -1,
 -59829,
 373912770,
 120618,
 -1,
 373974611,
 120628,
 374150735,
 373820716,
 119916,
 -59826,
 374104546,
 120610,
 -1,
 374166112,
 120608,
 374347345,
 374112203,
 119937,
 -1,
 374292796,
 120609,
 374478419,
 374278063,
 119935,
 -1,
 374413469,
 120617,
 374609493,
 374421345,
 119932,
 -1,
 374559328,
 120624,
 374740567,
 374581134,
 119930,
 -1,
 374677532,
 120622,
 374871641,
 374715655,
 119929,
 -1,
 374847902,
 120620,
 375002715,
 374824232,
 119925,
 -1,
 374945633,
 120616,
 375133789,
 374940244,
 119924,
 -1,
 375076705,
 120615,
 375264863,
 375115407,
 119923,
 -1,
 375213325,
 120614,
 375395937,
 375230775,
 119922,
 -1,
 375347539,
 120613,
 375527011,
 375330973,
 119920,
 -1,
 375464564,
 120612,
 375658085,
 375490253,
 119918,
 -1,
 375592260,
 120606,
 375789159,
 375634171,
 119915,
 -1,
 375731605,
 120607,
 375920233,
 375749488,
 119914,
 -1,
 375896475,
 120626,
 376051307,
 375864768,
 119913,
 -1,
 375996732,
 120605,
 376182381,
 375980851,
 119912,
 -1,
 376143357,
 120604,
 -59794,
 376128121,
 119936,
 -59793,
 376288069,
 119934,
 -59792,
 376337608,
 119933,
 -59791,
 376384829,
 119928,
 -59790,
 376459980,
 119921,
 -59789,
 376554386,
 119919,
 -1,
 376588359,
 119917,
 376772216,
 373283232,
 -1,
 -59786,
 376758156,
 120661,
 -59785,
 376783471,
 120659,
 -1,
 376882632,
 120655,
 -59783,
 376754877,
 120657,
 -59782,
 376967971,
 120660,
 -59781,
 377056072,
 120629,
 -59780,
 377138922,
 120658,
 -1,
 377203738,
 120656,
 377362155,
 369731470,
 -1,
 377427636,
 377297802,
 -1,
 377493123,
 377412000,
 119849,
 -59775,
 377443999,
 120537,
 -59774,
 377493661,
 120529,
 -1,
 377600411,
 120535,
 377755270,
 377480586,
 119853,
 -59771,
 377694176,
 120521,
 -1,
 377774616,
 120533,
 377951882,
 377724152,
 119848,
 378077183,
 377889364,
 -1,
 -59767,
 377976002,
 120528,
 -1,
 378037843,
 120538,
 378214029,
 377883948,
 119838,
 -59764,
 378167778,
 120520,
 -1,
 378229344,
 120518,
 378410640,
 378190075,
 119837,
 -59761,
 378394507,
 120779,
 -1,
 378418581,
 120517,
 378607250,
 378372043,
 119859,
 -1,
 378552636,
 120519,
 378738324,
 378537903,
 119857,
 -1,
 378673309,
 120527,
 378869398,
 378681185,
 119854,
 -1,
 378819168,
 120534,
 379000472,
 378840974,
 119852,
 -1,
 378937372,
 120532,
 379131546,
 378975495,
 119851,
 -1,
 379107742,
 120530,
 379262620,
 379084072,
 119847,
 -1,
 379205473,
 120526,
 379393694,
 379200084,
 119846,
 -1,
 379336545,
 120525,
 379524768,
 379375247,
 119845,
 -1,
 379473165,
 120524,
 379655842,
 379490615,
 119844,
 -1,
 379607379,
 120523,
 379786916,
 379590813,
 119842,
 -1,
 379724404,
 120522,
 379917990,
 379750093,
 119840,
 -1,
 379852100,
 120516,
 380049064,
 379865159,
 119839,
 -1,
 379988363,
 120531,
 380180138,
 380009328,
 119836,
 -1,
 380156315,
 120536,
 380311212,
 380124608,
 119835,
 -1,
 380256572,
 120515,
 380442286,
 380240691,
 119834,
 -1,
 380403197,
 120514,
 -59729,
 380387961,
 119858,
 -59728,
 380547909,
 119856,
 -59727,
 380597448,
 119855,
 -59726,
 380644669,
 119850,
 -59725,
 380719820,
 119843,
 -1,
 380814226,
 119841,
 381026303,
 377374597,
 -1,
 381032144,
 380952312,
 -1,
 -59721,
 380993483,
 120067,
 -59720,
 381043321,
 120066,
 -59719,
 381093807,
 120065,
 -59718,
 381203269,
 120064,
 -59717,
 381252808,
 120063,
 -59716,
 381302625,
 120062,
 -59715,
 381412746,
 120061,
 -59714,
 381462414,
 120060,
 -59713,
 381531399,
 120059,
 -59712,
 381562173,
 120058,
 -59711,
 381671840,
 120057,
 -59710,
 381721848,
 120056,
 -59709,
 381771048,
 120055,
 -59708,
 381821524,
 120054,
 -59707,
 381931151,
 120053,
 -59706,
 381980983,
 120052,
 -59705,
 382030540,
 120051,
 -59704,
 382081181,
 120050,
 -59703,
 382190482,
 120049,
 -59702,
 382240461,
 120048,
 -59701,
 382289991,
 120047,
 -59700,
 382340396,
 120046,
 -59699,
 382449915,
 120045,
 -59698,
 382499696,
 120044,
 -59697,
 382549440,
 120043,
 -1,
 382599987,
 120042,
 382861311,
 381019003,
 -1,
 -59694,
 382762955,
 120041,
 -59693,
 382812793,
 120040,
 -59692,
 382863279,
 120039,
 -59691,
 382972741,
 120038,
 -59690,
 383022280,
 120037,
 -59689,
 383072097,
 120036,
 -59688,
 383182218,
 120035,
 -59687,
 383231886,
 120034,
 -59686,
 383300871,
 120033,
 -59685,
 383331645,
 120032,
 -59684,
 383441312,
 120031,
 -59683,
 383491320,
 120030,
 -59682,
 383540520,
 120029,
 -59681,
 383590996,
 120028,
 -59680,
 383700623,
 120027,
 -59679,
 383750455,
 120026,
 -59678,
 383800012,
 120025,
 -59677,
 383850653,
 120024,
 -59676,
 383959954,
 120023,
 -59675,
 384009933,
 120022,
 -59674,
 384059463,
 120021,
 -59673,
 384109868,
 120020,
 -59672,
 384219387,
 120019,
 -59671,
 384269168,
 120018,
 -59670,
 384318912,
 120017,
 -1,
 384369459,
 120016,
 384571170,
 377303456,
 -1,
 384636679,
 384556792,
 -1,
 -59666,
 384597963,
 120223,
 -59665,
 384647801,
 120222,
 -59664,
 384698287,
 120221,
 -59663,
 384807749,
 120220,
 -59662,
 384857288,
 120219,
 -59661,
 384907105,
 120218,
 -59660,
 385017226,
 120217,
 -59659,
 385066894,
 120216,
 -59658,
 385135879,
 120215,
 -59657,
 385166653,
 120214,
 -59656,
 385276320,
 120213,
 -59655,
 385326328,
 120212,
 -59654,
 385375528,
 120211,
 -59653,
 385426004,
 120210,
 -59652,
 385535631,
 120209,
 -59651,
 385585463,
 120208,
 -59650,
 385635020,
 120207,
 -59649,
 385685661,
 120206,
 -59648,
 385794962,
 120205,
 -59647,
 385844941,
 120204,
 -59646,
 385894471,
 120203,
 -59645,
 385944876,
 120202,
 -59644,
 386054395,
 120201,
 -59643,
 386104176,
 120200,
 -59642,
 386153920,
 120199,
 -1,
 386204467,
 120198,
 386465791,
 384623483,
 -1,
 -59639,
 386367435,
 120197,
 -59638,
 386417273,
 120196,
 -59637,
 386467759,
 120195,
 -59636,
 386577221,
 120194,
 -59635,
 386626760,
 120193,
 -59634,
 386676577,
 120192,
 -59633,
 386786698,
 120191,
 -59632,
 386836366,
 120190,
 -59631,
 386905351,
 120189,
 -59630,
 386936125,
 120188,
 -59629,
 387045792,
 120187,
 -59628,
 387095800,
 120186,
 -59627,
 387145000,
 120185,
 -59626,
 387195476,
 120184,
 -59625,
 387305103,
 120183,
 -59624,
 387354935,
 120182,
 -59623,
 387404492,
 120181,
 -59622,
 387455133,
 120180,
 -59621,
 387564434,
 120179,
 -59620,
 387614413,
 120178,
 -59619,
 387663943,
 120177,
 -59618,
 387714348,
 120176,
 -59617,
 387823867,
 120175,
 -59616,
 387873648,
 120174,
 -59615,
 387923392,
 120173,
 -1,
 387973939,
 120172,
 388175704,
 384557947,
 -1,
 388241191,
 388162954,
 119827,
 388306726,
 388179936,
 120495,
 -1,
 388263056,
 120505,
 -1,
 388260376,
 120507,
 388503339,
 388225440,
 119823,
 -59607,
 388454047,
 120511,
 -59606,
 388503709,
 120503,
 -1,
 388610459,
 120509,
 388765487,
 388472056,
 119822,
 388890623,
 388702804,
 -1,
 -59602,
 388789442,
 120502,
 -1,
 388851283,
 120512,
 389027634,
 388697388,
 119812,
 -59599,
 388981218,
 120494,
 -1,
 389042784,
 120492,
 389224245,
 389003515,
 119811,
 -59596,
 389207947,
 120778,
 -1,
 389232021,
 120491,
 389420855,
 389185483,
 119833,
 -1,
 389366076,
 120493,
 389551929,
 389351343,
 119831,
 -1,
 389486749,
 120501,
 389683003,
 389494625,
 119828,
 -1,
 389632608,
 120508,
 389814077,
 389654414,
 119826,
 -1,
 389750812,
 120506,
 389945151,
 389788935,
 119825,
 -1,
 389921182,
 120504,
 390076225,
 389897512,
 119821,
 -1,
 390018913,
 120500,
 390207299,
 390013524,
 119820,
 -1,
 390149985,
 120499,
 390338373,
 390188687,
 119819,
 -1,
 390286605,
 120498,
 390469447,
 390304055,
 119818,
 -1,
 390420819,
 120497,
 390600521,
 390404253,
 119816,
 -1,
 390537844,
 120496,
 390731595,
 390563533,
 119814,
 -1,
 390665540,
 120490,
 390862669,
 390691696,
 119810,
 -1,
 390838683,
 120510,
 390993743,
 390806976,
 119809,
 -1,
 390938940,
 120489,
 391124817,
 390923059,
 119808,
 -1,
 391085565,
 120488,
 -59566,
 391070329,
 119832,
 -59565,
 391230277,
 119830,
 -59564,
 391279816,
 119829,
 -59563,
 391327037,
 119824,
 -59562,
 391402188,
 119817,
 -59561,
 391496594,
 119815,
 -1,
 391530567,
 119813,
 391714662,
 388161905,
 -1,
 391780188,
 391701898,
 -1,
 -59557,
 391743729,
 120784,
 -1,
 391809043,
 120785,
 391976799,
 391751566,
 -1,
 -59554,
 391955819,
 120788,
 -1,
 391985790,
 120789,
 392173410,
 391923783,
 -1,
 -59551,
 392139250,
 120786,
 -1,
 392177666,
 120787,
 -59549,
 392104291,
 120782,
 -59548,
 392343864,
 120783,
 -59547,
 392376886,
 120791,
 -1,
 392478922,
 120790,
 392632170,
 391698848,
 -1,
 -59544,
 392617868,
 120545,
 -59543,
 392643183,
 120543,
 -1,
 392742344,
 120539,
 -59541,
 392614589,
 120541,
 -59540,
 392827683,
 120544,
 -59539,
 392915784,
 120513,
 -59538,
 392998634,
 120542,
 -1,
 393063450,
 120540,
 393222117,
 369628325,
 -1,
 393287591,
 393207544,
 -1,
 393353077,
 393271712,
 119901,
 -59533,
 393303711,
 120595,
 -59532,
 393353373,
 120587,
 -1,
 393460123,
 120593,
 393615226,
 393328891,
 119889,
 393680761,
 393552409,
 -1,
 -59528,
 393630412,
 120485,
 -1,
 393681053,
 120484,
 -1,
 393622933,
 120575,
 393942909,
 393602442,
 119905,
 -59524,
 393881568,
 120579,
 -1,
 393962008,
 120591,
 394139521,
 393911544,
 119900,
 394264575,
 394076756,
 -1,
 -59520,
 394163394,
 120586,
 -1,
 394225235,
 120596,
 394401668,
 394071340,
 119890,
 -59517,
 394355170,
 120578,
 -1,
 394416736,
 120576,
 394598278,
 394362827,
 119911,
 -1,
 394543420,
 120577,
 394729352,
 394528687,
 119909,
 -1,
 394664093,
 120585,
 394860426,
 394671969,
 119906,
 -1,
 394809952,
 120592,
 394991500,
 394831758,
 119904,
 -1,
 394928156,
 120590,
 395122574,
 394966279,
 119903,
 -1,
 395098526,
 120588,
 395253648,
 395074856,
 119899,
 -1,
 395196257,
 120584,
 395384722,
 395190868,
 119898,
 -1,
 395327329,
 120583,
 395515796,
 395366031,
 119897,
 -1,
 395463949,
 120582,
 395646870,
 395481399,
 119896,
 -1,
 395598163,
 120581,
 395777944,
 395581597,
 119894,
 -1,
 395715188,
 120580,
 395909018,
 395740877,
 119892,
 -1,
 395842884,
 120574,
 396040092,
 395855943,
 119891,
 -1,
 395979147,
 120589,
 396171166,
 396000112,
 119888,
 -1,
 396147099,
 120594,
 396302240,
 396115392,
 119887,
 -1,
 396247356,
 120573,
 396433314,
 396231475,
 119886,
 -1,
 396393981,
 120572,
 -59485,
 396378745,
 119910,
 -59484,
 396538693,
 119908,
 -59483,
 396588232,
 119907,
 -59482,
 396635453,
 119902,
 -1,
 396710604,
 119895,
 396892124,
 393274235,
 -1,
 396957612,
 396879242,
 119879,
 397023147,
 396896224,
 120553,
 -1,
 396979344,
 120563,
 -1,
 396976664,
 120565,
 397219760,
 396941728,
 119875,
 -59474,
 397170335,
 120569,
 -59473,
 397219997,
 120561,
 -1,
 397326747,
 120567,
 397481908,
 397188344,
 119874,
 397606911,
 397419092,
 -1,
 -59469,
 397505730,
 120560,
 -1,
 397567571,
 120570,
 397744055,
 397413676,
 119864,
 -59466,
 397697506,
 120552,
 -1,
 397759072,
 120550,
 397940665,
 397705163,
 119885,
 -1,
 397885756,
 120551,
 398071739,
 397871023,
 119883,
 -1,
 398006429,
 120559,
 398202813,
 398014305,
 119880,
 -1,
 398152288,
 120566,
 398333887,
 398174094,
 119878,
 -1,
 398270492,
 120564,
 398464961,
 398308615,
 119877,
 -1,
 398440862,
 120562,
 398596035,
 398417192,
 119873,
 -1,
 398538593,
 120558,
 398727109,
 398533204,
 119872,
 -1,
 398669665,
 120557,
 398858183,
 398708367,
 119871,
 -1,
 398806285,
 120556,
 398989257,
 398823735,
 119870,
 -1,
 398940499,
 120555,
 399120331,
 398923933,
 119868,
 -1,
 399057524,
 120554,
 399251405,
 399083213,
 119866,
 -1,
 399185220,
 120548,
 399382479,
 399227131,
 119863,
 -1,
 399324565,
 120549,
 399513553,
 399342448,
 119862,
 -1,
 399489435,
 120568,
 399644627,
 399457728,
 119861,
 -1,
 399589692,
 120547,
 399775701,
 399573811,
 119860,
 -1,
 399736317,
 120546,
 -59434,
 399721081,
 119884,
 -59433,
 399881029,
 119882,
 -59432,
 399930568,
 119881,
 -59431,
 399977789,
 119876,
 -59430,
 400052940,
 119869,
 -59429,
 400147346,
 119867,
 -1,
 400181319,
 119865,
 400365536,
 396876192,
 -1,
 -59426,
 400351116,
 120603,
 -59425,
 400376431,
 120601,
 -1,
 400475592,
 120597,
 -59423,
 400347837,
 120599,
 -59422,
 400560931,
 120602,
 -59421,
 400649032,
 120571,
 -59420,
 400731882,
 120600,
 -1,
 400796698,
 120598,
 400955434,
 393161643,
 -1,
 401020929,
 400940792,
 -1,
 -59416,
 400981963,
 120483,
 -59415,
 401031801,
 120482,
 -59414,
 401082287,
 120481,
 -59413,
 401191749,
 120480,
 -59412,
 401241288,
 120479,
 -59411,
 401291105,
 120478,
 -59410,
 401401226,
 120477,
 -59409,
 401450894,
 120476,
 -59408,
 401519879,
 120475,
 -59407,
 401550653,
 120474,
 -59406,
 401660320,
 120473,
 -59405,
 401710328,
 120472,
 -59404,
 401759528,
 120471,
 -59403,
 401810004,
 120470,
 -59402,
 401919631,
 120469,
 -59401,
 401969463,
 120468,
 -59400,
 402019020,
 120467,
 -59399,
 402069661,
 120466,
 -59398,
 402178962,
 120465,
 -59397,
 402228941,
 120464,
 -59396,
 402278471,
 120463,
 -59395,
 402328876,
 120462,
 -59394,
 402438395,
 120461,
 -59393,
 402488176,
 120460,
 -59392,
 402537920,
 120459,
 -1,
 402588467,
 120458,
 402790428,
 401007483,
 -1,
 -59389,
 402751435,
 120457,
 -59388,
 402801273,
 120456,
 -59387,
 402851759,
 120455,
 -59386,
 402961221,
 120454,
 -59385,
 403010760,
 120453,
 -59384,
 403060577,
 120452,
 -59383,
 403170698,
 120451,
 -59382,
 403220366,
 120450,
 -59381,
 403289351,
 120449,
 -59380,
 403320125,
 120448,
 -59379,
 403429792,
 120447,
 -59378,
 403479800,
 120446,
 -59377,
 403529000,
 120445,
 -59376,
 403579476,
 120444,
 -59375,
 403689103,
 120443,
 -59374,
 403738935,
 120442,
 -59373,
 403788492,
 120441,
 -59372,
 403839133,
 120440,
 -59371,
 403948434,
 120439,
 -59370,
 403998413,
 120438,
 -59369,
 404047943,
 120437,
 -59368,
 404098348,
 120436,
 -59367,
 404207867,
 120435,
 -59366,
 404257648,
 120434,
 -59365,
 404307392,
 120433,
 -1,
 404357939,
 120432,
 404619263,
 402776433,
 -1,
 404625440,
 404546954,
 -1,
 -59361,
 404588785,
 120824,
 -1,
 404654099,
 120825,
 404822051,
 404596622,
 -1,
 -59358,
 404800875,
 120828,
 -1,
 404830846,
 120829,
 405018662,
 404768839,
 -1,
 -59355,
 404984306,
 120826,
 -1,
 405022722,
 120827,
 -59353,
 404949347,
 120822,
 -59352,
 405188920,
 120823,
 -59351,
 405221942,
 120831,
 -1,
 405323978,
 120830,
 405477480,
 400897677,
 -1,
 405542982,
 405462776,
 -1,
 -59347,
 405503947,
 120171,
 -59346,
 405553785,
 120170,
 -59345,
 405604271,
 120169,
 -59344,
 405713733,
 120168,
 -59343,
 405763272,
 120167,
 -59342,
 405813089,
 120166,
 -59341,
 405923210,
 120165,
 -59340,
 405972878,
 120164,
 -59339,
 406041863,
 120163,
 -59338,
 406072637,
 120162,
 -59337,
 406182304,
 120161,
 -59336,
 406232312,
 120160,
 -59335,
 406281512,
 120159,
 -59334,
 406331988,
 120158,
 -59333,
 406441615,
 120157,
 -59332,
 406491447,
 120156,
 -59331,
 406541004,
 120155,
 -59330,
 406591645,
 120154,
 -59329,
 406700946,
 120153,
 -59328,
 406750925,
 120152,
 -59327,
 406800455,
 120151,
 -59326,
 406850860,
 120150,
 -59325,
 406960379,
 120149,
 -59324,
 407010160,
 120148,
 -59323,
 407059904,
 120147,
 -1,
 407110451,
 120146,
 407312474,
 405529467,
 -1,
 -59320,
 407257721,
 120144,
 -59319,
 407308207,
 120143,
 -59318,
 407417669,
 120142,
 -59317,
 407467208,
 120141,
 -59316,
 407517025,
 120140,
 -59315,
 407627146,
 120139,
 -59314,
 407676814,
 120138,
 -59313,
 407739640,
 120134,
 -59312,
 407773780,
 120132,
 -59311,
 407883407,
 120131,
 -59310,
 407933239,
 120130,
 -59309,
 407982796,
 120129,
 -59308,
 408033437,
 120128,
 -59307,
 408127181,
 120126,
 -59306,
 408176711,
 120125,
 -59305,
 408227116,
 120124,
 -59304,
 408336635,
 120123,
 -59303,
 408370624,
 120121,
 -1,
 408421171,
 120120,
 408682495,
 407298417,
 -1,
 408688734,
 408610186,
 -1,
 -59299,
 408652017,
 120794,
 -1,
 408717331,
 120795,
 408885345,
 408659854,
 -1,
 -59296,
 408864107,
 120798,
 -1,
 408894078,
 120799,
 409081956,
 408832071,
 -1,
 -59293,
 409047538,
 120796,
 -1,
 409085954,
 120797,
 -59291,
 409012579,
 120792,
 -59290,
 409252152,
 120793,
 -59289,
 409285174,
 120801,
 -1,
 409387210,
 120800,
 409540762,
 405418400,
 -1,
 409606276,
 409526008,
 -1,
 -59285,
 409567179,
 120119,
 -59284,
 409617017,
 120118,
 -59283,
 409667503,
 120117,
 -59282,
 409776965,
 120116,
 -59281,
 409826504,
 120115,
 -59280,
 409876321,
 120114,
 -59279,
 409986442,
 120113,
 -59278,
 410036110,
 120112,
 -59277,
 410105095,
 120111,
 -59276,
 410135869,
 120110,
 -59275,
 410245536,
 120109,
 -59274,
 410295544,
 120108,
 -59273,
 410344744,
 120107,
 -59272,
 410395220,
 120106,
 -59271,
 410504847,
 120105,
 -59270,
 410554679,
 120104,
 -59269,
 410604236,
 120103,
 -59268,
 410654877,
 120102,
 -59267,
 410764178,
 120101,
 -59266,
 410814157,
 120100,
 -59265,
 410863687,
 120099,
 -59264,
 410914092,
 120098,
 -59263,
 411023611,
 120097,
 -59262,
 411073392,
 120096,
 -59261,
 411123136,
 120095,
 -1,
 411173683,
 120094,
 411435007,
 409592699,
 -1,
 -59258,
 411320953,
 120092,
 -59257,
 411371439,
 120091,
 -59256,
 411480901,
 120090,
 -59255,
 411530440,
 120089,
 -59254,
 411580257,
 120088,
 -59253,
 411690378,
 120087,
 -59252,
 411740046,
 120086,
 -59251,
 411774269,
 120084,
 -59250,
 411883936,
 120083,
 -59249,
 411933944,
 120082,
 -59248,
 411983144,
 120081,
 -59247,
 412033620,
 120080,
 -59246,
 412143247,
 120079,
 -59245,
 412193079,
 120078,
 -59244,
 412242636,
 120077,
 -59243,
 412321485,
 120074,
 -59242,
 412371015,
 120073,
 -59241,
 412421420,
 120072,
 -59240,
 412530939,
 120071,
 -59239,
 412564928,
 120069,
 -1,
 412615475,
 120068,
 412817569,
 409510151,
 -1,
 412883102,
 412800998,
 -1,
 -59235,
 412860552,
 10221,
 -1,
 412914489,
 10215,
 -59233,
 412841263,
 10223,
 -59232,
 413031108,
 10219,
 -1,
 413074524,
 10217,
 413335551,
 412756717,
 -1,
 413341861,
 413259750,
 -1,
 -59228,
 413319304,
 10220,
 -1,
 413373241,
 10214,
 -59226,
 413300015,
 10222,
 -59225,
 413489860,
 10218,
 -1,
 413533276,
 10216,
 413735219,
 342412943,
 -1,
 413800748,
 413722487,
 -1,
 413866232,
 413738341,
 -1,
 413931702,
 413825904,
 -1,
 413997237,
 413909906,
 -1,
 414062772,
 413947151,
 -1,
 414128304,
 414014760,
 3451,
 -1,
 414080296,
 3450,
 414259378,
 414109327,
 3453,
 -1,
 414240399,
 3454,
 -59213,
 414206358,
 3452,
 -1,
 414355767,
 3455,
 -1,
 413991731,
 3355,
 -1,
 413926195,
 3354,
 414652605,
 413889736,
 -1,
 414718140,
 414604595,
 -1,
 414783674,
 414692615,
 3339,
 -1,
 414758151,
 3424,
 414973951,
 414764687,
 3340,
 -1,
 414895759,
 3425,
 -1,
 414647091,
 3381,
 415111363,
 414639498,
 -1,
 415176897,
 415098250,
 -1,
 -59200,
 415152563,
 3360,
 -1,
 415171379,
 3359,
 -59198,
 415152563,
 3365,
 -1,
 415302451,
 3364,
 415504584,
 415063336,
 -1,
 -59195,
 415444004,
 3358,
 -59194,
 415505181,
 3363,
 -59193,
 415608467,
 3353,
 -1,
 415630131,
 3368,
 415832270,
 415480059,
 -1,
 415897804,
 415807739,
 -1,
 -59189,
 415873459,
 3362,
 -1,
 415892275,
 3361,
 -59187,
 415873459,
 3367,
 -1,
 416023347,
 3366,
 416225490,
 415761203,
 3333,
 -59184,
 416167777,
 3348,
 -59183,
 416225437,
 3344,
 -1,
 416285491,
 3334,
 416487638,
 416196494,
 -1,
 -59180,
 416437932,
 3383,
 -59179,
 416528819,
 3382,
 -1,
 416547635,
 3384,
 416749787,
 416468623,
 -1,
 416815322,
 416730767,
 -1,
 -59175,
 416744190,
 3380,
 -1,
 416809779,
 3379,
 -1,
 416744243,
 3378,
 417077469,
 416692065,
 3337,
 -1,
 417019745,
 3338,
 417208544,
 417051911,
 -1,
 -59169,
 417155497,
 3377,
 -1,
 417202995,
 3376,
 417405155,
 417192352,
 -1,
 -59166,
 417380787,
 3371,
 -1,
 417399603,
 3370,
 417601765,
 417373432,
 3346,
 -1,
 417570040,
 3347,
 417732840,
 417567031,
 -1,
 -59161,
 417708467,
 3350,
 -1,
 417727283,
 3349,
 417929451,
 417682124,
 -1,
 -59158,
 417905075,
 3357,
 -1,
 417923891,
 3356,
 418126061,
 417863837,
 3335,
 -1,
 418060445,
 3336,
 418257136,
 418088653,
 -1,
 -59153,
 418232755,
 3352,
 -1,
 418251571,
 3351,
 418453746,
 418188588,
 3342,
 -1,
 418385196,
 3343,
 418584821,
 418397632,
 -1,
 -59148,
 418560435,
 3373,
 -1,
 418579251,
 3372,
 -59146,
 418524196,
 3375,
 -59145,
 418713510,
 3374,
 -1,
 418822579,
 3385,
 418978058,
 413830197,
 -1,
 419043582,
 418906852,
 -1,
 419109116,
 419017991,
 3395,
 -1,
 419083527,
 3396,
 419299327,
 419090063,
 3426,
 -1,
 419221135,
 3427,
 419371266,
 418972467,
 -1,
 -59136,
 419313505,
 3404,
 -59135,
 419371165,
 3400,
 -1,
 419431219,
 3390,
 419633412,
 419313505,
 3393,
 -1,
 419575649,
 3394,
 419764486,
 419601656,
 3402,
 -1,
 419732728,
 3403,
 419895560,
 419698845,
 3391,
 -1,
 419829917,
 3392,
 420085759,
 419826988,
 3398,
 -1,
 419958060,
 3399,
 420157722,
 418953467,
 -1,
 420223257,
 420142247,
 -1,
 420288783,
 420210058,
 -1,
 -59122,
 420251889,
 3432,
 -1,
 420317203,
 3433,
 420485394,
 420259726,
 -1,
 -59119,
 420463979,
 3436,
 -1,
 420493950,
 3437,
 420682005,
 420431943,
 -1,
 -59116,
 420647410,
 3434,
 -1,
 420685826,
 3435,
 -59114,
 420612451,
 3430,
 -59113,
 420852024,
 3431,
 -59112,
 420885046,
 3439,
 -1,
 420987082,
 3438,
 -1,
 420204687,
 3449,
 421206305,
 420095237,
 -1,
 421271838,
 421166336,
 -1,
 -59107,
 421248170,
 3331,
 -1,
 421281265,
 3405,
 421527551,
 421200691,
 -1,
 -59104,
 421428020,
 3389,
 -1,
 421480682,
 3330,
 421665062,
 421155524,
 -1,
 421730597,
 421641350,
 -1,
 -59100,
 421692254,
 3442,
 -1,
 421740611,
 3441,
 -1,
 421691185,
 3440,
 421992747,
 421641872,
 -1,
 422058282,
 421969030,
 -1,
 -59095,
 422034390,
 3443,
 -1,
 422083461,
 3444,
 -1,
 422036529,
 3445,
 -1,
 421966878,
 3415,
 422385970,
 413767043,
 -1,
 422451504,
 422333997,
 -1,
 -59089,
 422425993,
 9894,
 -1,
 422459252,
 9895,
 -59087,
 422425993,
 9794,
 -1,
 422588459,
 9893,
 -1,
 422348328,
 10016,
 422844794,
 413698418,
 -1,
 422910274,
 422815630,
 -1,
 422975802,
 422844395,
 -1,
 423041337,
 422935408,
 -1,
 -59080,
 423002718,
 127006,
 -1,
 423042809,
 126988,
 -1,
 423026564,
 126997,
 423303487,
 422925662,
 -1,
 423369022,
 423263088,
 -1,
 -59075,
 423330398,
 127007,
 -1,
 423370489,
 126989,
 -1,
 423354244,
 126998,
 -59072,
 423257474,
 127015,
 -59071,
 423598523,
 127014,
 -1,
 423683198,
 126977,
 423827789,
 422897034,
 -1,
 423893320,
 423782223,
 -1,
 423958855,
 423852912,
 -1,
 -59066,
 423920222,
 127002,
 -1,
 423960313,
 126984,
 -1,
 423944068,
 126993,
 424280063,
 423860807,
 -1,
 424286540,
 424180592,
 -1,
 -59061,
 424247902,
 127003,
 -1,
 424287993,
 126985,
 -1,
 424271748,
 126994,
 424548696,
 423774279,
 -1,
 424614227,
 424486359,
 -1,
 424679762,
 424573808,
 -1,
 -59055,
 424641118,
 127004,
 -1,
 424681209,
 126986,
 -1,
 424664964,
 126995,
 425000959,
 424558834,
 -1,
 425007447,
 424901488,
 -1,
 -59050,
 424968798,
 127005,
 -1,
 425008889,
 126987,
 -1,
 424992644,
 126996,
 425269599,
 424516856,
 -1,
 425335134,
 425213217,
 -1,
 425400669,
 425294704,
 -1,
 -59044,
 425362014,
 127001,
 -1,
 425402105,
 126983,
 -1,
 425385860,
 126992,
 -1,
 425281490,
 127011,
 425728358,
 425221416,
 -1,
 425793893,
 425711365,
 -1,
 425859428,
 425753456,
 -1,
 -59037,
 425820766,
 127009,
 -1,
 425860857,
 126991,
 -1,
 425844612,
 127000,
 -1,
 425736395,
 126979,
 426187117,
 425659692,
 -1,
 426252652,
 426164280,
 -1,
 426318187,
 426212208,
 -1,
 -59030,
 426279518,
 127008,
 -1,
 426319609,
 126990,
 -1,
 426303364,
 126999,
 -1,
 426230639,
 126976,
 426645873,
 426160965,
 -1,
 -59025,
 426592060,
 127017,
 -59024,
 426686915,
 126982,
 -1,
 426739450,
 126978,
 426908020,
 426627585,
 -1,
 -59021,
 426865512,
 127012,
 -1,
 426933316,
 127019,
 -59019,
 426882807,
 126980,
 -59018,
 427070609,
 127010,
 -59017,
 427114419,
 127018,
 -59016,
 427187321,
 126981,
 -59015,
 427247979,
 127013,
 -1,
 427328539,
 127016,
 427497853,
 422815630,
 -1,
 -59012,
 427476806,
 12348,
 -1,
 427550642,
 186,
 -59010,
 427442595,
 9901,
 -59009,
 427657936,
 9967,
 -1,
 427713639,
 175,
 427891551,
 342334712,
 -1,
 427956882,
 427866363,
 -1,
 428022416,
 427940614,
 -1,
 428087783,
 427992974,
 -1,
 428153313,
 428022666,
 -1,
 428218773,
 428139914,
 7511,
 428284306,
 428193633,
 -1,
 428349834,
 428213043,
 7492,
 -58999,
 428310013,
 7579,
 -1,
 428346668,
 7494,
 428546444,
 428324103,
 692,
 -1,
 428485215,
 693,
 428677518,
 428483156,
 7514,
 -1,
 428657814,
 7597,
 -58993,
 428635336,
 7610,
 -58992,
 428761864,
 7500,
 -58991,
 428808349,
 7502,
 -1,
 428917650,
 7587,
 -58989,
 428259699,
 7508,
 -58988,
 429008864,
 7615,
 -1,
 429093935,
 7605,
 429267359,
 428178288,
 7580,
 429332893,
 429218873,
 -1,
 429398426,
 429267101,
 7590,
 -58983,
 429372746,
 694,
 -1,
 429434406,
 7591,
 -58981,
 429340513,
 7608,
 -58980,
 429546792,
 7600,
 -1,
 429641359,
 7595,
 -58978,
 429308315,
 7521,
 -1,
 429755811,
 7581,
 429922725,
 429238158,
 738,
 429988259,
 429882224,
 -1,
 -58974,
 429974770,
 7586,
 -1,
 430005487,
 7498,
 -58972,
 429919335,
 7513,
 -1,
 430123615,
 7603,
 430315946,
 429853996,
 7497,
 -58969,
 430288664,
 7614,
 -58968,
 430350609,
 7582,
 -58967,
 430397090,
 7604,
 -1,
 430447398,
 7505,
 430643631,
 430278349,
 7501,
 430709166,
 430598812,
 -1,
 -58963,
 430690901,
 7520,
 -1,
 430758521,
 7518,
 -1,
 430642500,
 736,
 430971315,
 430587328,
 7495,
 -58959,
 430956584,
 7509,
 -58958,
 430981436,
 7517,
 -1,
 431031619,
 7601,
 431233463,
 430931915,
 7611,
 431357951,
 431179039,
 -1,
 -58954,
 431240551,
 7612,
 -1,
 431349631,
 7613,
 431495610,
 431175521,
 7512,
 -58951,
 431444576,
 7607,
 -1,
 431519838,
 7606,
 431692222,
 431469831,
 691,
 431816703,
 431646604,
 -1,
 -58947,
 431710984,
 7583,
 -1,
 431789206,
 740,
 431954370,
 431660280,
 7506,
 432078847,
 431902597,
 -1,
 -58943,
 431987960,
 7507,
 -1,
 432016684,
 7499,
 432216518,
 431935119,
 737,
 432340991,
 432162079,
 -1,
 -58939,
 432223591,
 7593,
 -1,
 432319102,
 7594,
 432478665,
 432191739,
 7496,
 -58936,
 432439402,
 7585,
 -1,
 432485781,
 7519,
 432675276,
 432407347,
 7491,
 -58933,
 432635389,
 7493,
 -1,
 432719270,
 7516,
 432871886,
 432633032,
 7515,
 -1,
 432810591,
 7609,
 433002960,
 432855456,
 7510,
 -1,
 432978331,
 7602,
 433134035,
 432966686,
 -1,
 -58926,
 433075559,
 7599,
 -1,
 433138336,
 7598,
 433330645,
 433070676,
 7504,
 -1,
 433269343,
 7596,
 433461719,
 433279692,
 690,
 -1,
 433422880,
 7592,
 433592794,
 433395869,
 -1,
 -58919,
 433529460,
 7589,
 -1,
 433628710,
 7588,
 433789404,
 433570706,
 688,
 -1,
 433728095,
 689,
 -58915,
 433734265,
 696,
 -58914,
 433850287,
 739,
 -58913,
 433959749,
 695,
 -58912,
 434016567,
 7503,
 -1,
 434063431,
 7584,
 434248164,
 428099270,
 -1,
 -58909,
 434228627,
 42785,
 -1,
 434266420,
 42784,
 434503679,
 434226066,
 -1,
 -58906,
 434424648,
 42890,
 -1,
 434489635,
 765,
 434641428,
 428047216,
 -1,
 434706946,
 434592825,
 -1,
 434772461,
 434681095,
 7487,
 434896895,
 434726796,
 -1,
 -58900,
 434789672,
 7483,
 -1,
 434834732,
 7474,
 435034607,
 434740472,
 7484,
 -1,
 434976609,
 7485,
 435165681,
 434978240,
 7470,
 -1,
 435094831,
 7471,
 435296755,
 435094323,
 7468,
 -1,
 435227948,
 7469,
 -58892,
 435270469,
 7490,
 -58891,
 435385544,
 11389,
 -58890,
 435435361,
 7489,
 -58889,
 435545482,
 7488,
 -58888,
 435607968,
 7486,
 -58887,
 435641640,
 7482,
 -58886,
 435692116,
 7481,
 -58885,
 435801743,
 7480,
 -58884,
 435851575,
 7479,
 -58883,
 435901132,
 7478,
 -58882,
 435951773,
 7477,
 -58881,
 436061074,
 7476,
 -58880,
 436111053,
 7475,
 -58879,
 436145452,
 7473,
 -1,
 436254971,
 7472,
 436410893,
 434682003,
 -1,
 436476424,
 436356920,
 -1,
 -58875,
 436441252,
 42754,
 -58874,
 436488592,
 42758,
 -58873,
 436551370,
 42756,
 -1,
 436625016,
 42752,
 436862975,
 436444315,
 -1,
 -58870,
 436768932,
 42755,
 -58869,
 436816272,
 42759,
 -58868,
 436879050,
 42757,
 -1,
 436952696,
 42753,
 437131792,
 436395760,
 -1,
 -58865,
 437060642,
 722,
 -1,
 437150631,
 723,
 -58863,
 437084105,
 7544,
 -58862,
 437274835,
 735,
 -58861,
 437348331,
 42889,
 -1,
 437406687,
 710,
 437590577,
 434622095,
 -1,
 437656110,
 437528283,
 -1,
 437721645,
 437605417,
 -1,
 437787163,
 437671515,
 -1,
 437852698,
 437738101,
 767,
 -1,
 437781301,
 753,
 -1,
 437800042,
 42773,
 438049312,
 437749757,
 -1,
 438114847,
 437986158,
 -1,
 -58850,
 438046218,
 42763,
 -1,
 438150778,
 42768,
 -1,
 438097745,
 751,
 438376995,
 438035850,
 -1,
 -58846,
 438357923,
 744,
 -1,
 438374360,
 759,
 438573606,
 438323634,
 -1,
 -58843,
 438508326,
 755,
 -1,
 438617837,
 754,
 -58841,
 438559928,
 716,
 -58840,
 438708933,
 752,
 -58839,
 438792858,
 717,
 -58838,
 438877457,
 42783,
 -58837,
 438925222,
 718,
 -58836,
 438989020,
 42888,
 -1,
 439061117,
 719,
 -1,
 437669506,
 42778,
 439353343,
 437587407,
 -1,
 -58832,
 439273945,
 703,
 -1,
 439314779,
 706,
 439491135,
 437564679,
 -1,
 439556664,
 439420523,
 -1,
 -58828,
 439501302,
 42779,
 -58827,
 439598353,
 42782,
 -58826,
 439673410,
 42781,
 -58825,
 439683210,
 42780,
 -1,
 439767520,
 760,
 439949883,
 439542682,
 -1,
 -58822,
 439929305,
 702,
 -1,
 439970139,
 707,
 440146494,
 439904140,
 -1,
 -58819,
 440112278,
 705,
 -1,
 440182263,
 701,
 -1,
 440111340,
 734,
 440408656,
 439422252,
 -1,
 440474189,
 440345941,
 -1,
 440539719,
 440417253,
 -1,
 440605253,
 440468619,
 -1,
 -58812,
 440536586,
 42764,
 -1,
 440641146,
 42769,
 -58810,
 440536586,
 745,
 -1,
 440772218,
 42774,
 440991743,
 440498504,
 -1,
 440998475,
 440861835,
 -1,
 -58806,
 440929802,
 42760,
 -1,
 441034362,
 42765,
 -58804,
 440929802,
 741,
 -1,
 441165434,
 42770,
 441384959,
 440441334,
 -1,
 -58801,
 441306515,
 764,
 -1,
 441344308,
 762,
 441522784,
 440345172,
 -1,
 441588319,
 441456797,
 -1,
 441653854,
 441563387,
 -1,
 441719385,
 441603113,
 -1,
 441784919,
 441648267,
 -1,
 -58794,
 441716234,
 42762,
 -1,
 441820794,
 42767,
 -58792,
 441716234,
 743,
 -1,
 441951866,
 42772,
 442171391,
 441678106,
 -1,
 442178141,
 442064103,
 -1,
 -58788,
 442136486,
 757,
 -1,
 442206845,
 758,
 -1,
 442136486,
 756,
 -1,
 441584764,
 727,
 -1,
 441542460,
 713,
 442571371,
 441485309,
 -1,
 442636901,
 442524247,
 -1,
 -58781,
 442574119,
 42775,
 -58780,
 442656555,
 42776,
 -1,
 442724590,
 42777,
 442899048,
 442592179,
 -1,
 -58777,
 442873980,
 725,
 -1,
 442919259,
 709,
 443154431,
 442877719,
 -1,
 -58774,
 443060245,
 698,
 -1,
 443123921,
 750,
 443292275,
 442549138,
 -1,
 443357810,
 443261464,
 -1,
 443423344,
 443286667,
 -1,
 -58769,
 443354634,
 42761,
 -1,
 443459194,
 42766,
 -58767,
 443354634,
 742,
 -1,
 443590266,
 42771,
 -1,
 443328436,
 721,
 443816569,
 443234145,
 -1,
 443882103,
 443757183,
 -1,
 -58762,
 443857020,
 724,
 -1,
 443902299,
 708,
 -58760,
 443852686,
 42864,
 -1,
 444040645,
 749,
 444209789,
 443778765,
 -1,
 -58757,
 444179405,
 715,
 -58756,
 444260973,
 704,
 -1,
 444325349,
 4348,
 444471936,
 444154489,
 -1,
 -58753,
 444414282,
 746,
 -1,
 444493335,
 747,
 444668547,
 444429512,
 -1,
 -58750,
 444603662,
 748,
 -1,
 444718051,
 712,
 444865158,
 444654986,
 -1,
 -58747,
 444840139,
 699,
 -1,
 444870564,
 720,
 445061769,
 444848544,
 -1,
 -58744,
 445026627,
 697,
 -1,
 445102001,
 726,
 445258380,
 445017547,
 -1,
 -58741,
 445238675,
 763,
 -1,
 445276468,
 761,
 445454991,
 445186867,
 -1,
 -58738,
 445419884,
 700,
 -1,
 445500442,
 714,
 -1,
 445403854,
 766,
 -58735,
 427976279,
 10762,
 -1,
 445696326,
 8871,
 445848414,
 427908392,
 -1,
 445913943,
 445817534,
 -1,
 445979445,
 445850981,
 -1,
 446044858,
 445965706,
 -1,
 446110392,
 445973802,
 -1,
 446175900,
 446038835,
 -1,
 446241435,
 446106478,
 -1,
 -58726,
 446213413,
 6297,
 -1,
 446259682,
 6296,
 -1,
 446176038,
 6218,
 446503582,
 446117729,
 6215,
 -1,
 446434604,
 6217,
 446634657,
 446489994,
 -1,
 -58720,
 446584492,
 6228,
 -1,
 446628659,
 6224,
 446831267,
 446602488,
 6214,
 -1,
 446762284,
 6216,
 446962342,
 446780108,
 -1,
 -58715,
 446940585,
 6234,
 -1,
 446956339,
 6227,
 447158952,
 446934675,
 6222,
 -1,
 447087411,
 6232,
 447290027,
 447133947,
 -1,
 -58710,
 447262505,
 6236,
 -1,
 447284019,
 6225,
 -58708,
 447228964,
 6229,
 -58707,
 447449322,
 6230,
 -58706,
 447495897,
 6221,
 -58705,
 447565176,
 6220,
 -58704,
 447668630,
 6235,
 -58703,
 447680422,
 6223,
 -58702,
 447756737,
 6211,
 -58701,
 447864783,
 6231,
 -58700,
 447879325,
 6213,
 -58699,
 447973738,
 6233,
 -58698,
 448007468,
 6212,
 -58697,
 448115266,
 6226,
 -1,
 448188929,
 6219,
 -58695,
 446060204,
 6204,
 -1,
 448267059,
 6194,
 448469727,
 445973299,
 6176,
 448535262,
 448400238,
 -1,
 448600770,
 448521610,
 -1,
 448666304,
 448587146,
 -1,
 -58689,
 448641459,
 6285,
 -1,
 448660275,
 6284,
 -58687,
 448646208,
 6278,
 -1,
 448791347,
 6288,
 448993991,
 448575739,
 -1,
 449059526,
 448922419,
 6289,
 -58683,
 449012996,
 6274,
 -1,
 449106057,
 6313,
 -1,
 449021968,
 6286,
 449321674,
 448922419,
 6279,
 -58679,
 449308234,
 6272,
 -1,
 449364882,
 6295,
 449518285,
 449281995,
 -1,
 -58676,
 449493427,
 6293,
 -1,
 449512243,
 6294,
 449714896,
 449501600,
 -1,
 -58673,
 449690035,
 6291,
 -1,
 449708851,
 6290,
 449911507,
 449666344,
 -1,
 -58670,
 449846045,
 6287,
 -1,
 449949331,
 6282,
 450108117,
 449845405,
 6280,
 -1,
 450064001,
 6276,
 450239192,
 450084426,
 -1,
 -58665,
 450178084,
 6311,
 -1,
 450246497,
 6310,
 -58663,
 450193046,
 6273,
 -58662,
 450404757,
 6275,
 -58661,
 450459472,
 6292,
 -58660,
 450551759,
 6281,
 -58659,
 450591824,
 6283,
 -1,
 450632550,
 6277,
 -1,
 448469798,
 6185,
 450894587,
 448440206,
 -1,
 450960121,
 450831022,
 -1,
 451025636,
 450920395,
 -1,
 -58653,
 451000755,
 6258,
 -1,
 451019571,
 6255,
 451222246,
 450967393,
 6241,
 -1,
 451153196,
 6240,
 451353321,
 451208586,
 -1,
 -58648,
 451303084,
 6254,
 -1,
 451347251,
 6248,
 451549931,
 451287197,
 6238,
 -1,
 451494521,
 6239,
 451681005,
 451525043,
 6245,
 -1,
 451609395,
 6253,
 451812079,
 451653267,
 6244,
 -1,
 451740467,
 6252,
 -58640,
 451748047,
 6247,
 -58639,
 451896961,
 6256,
 -58638,
 451956088,
 6246,
 -58637,
 452059087,
 6243,
 -58636,
 452121078,
 6250,
 -58635,
 452174079,
 6251,
 -58634,
 452201772,
 6237,
 -58633,
 452298768,
 6249,
 -58632,
 452375106,
 6257,
 -1,
 452449111,
 6242,
 -58630,
 450935219,
 6193,
 -1,
 452526899,
 6192,
 452729621,
 450826150,
 6190,
 452853759,
 452663197,
 -1,
 452860688,
 452781801,
 -1,
 452926209,
 452820939,
 -1,
 -58624,
 452901299,
 6308,
 -1,
 452920115,
 6309,
 453122820,
 452912522,
 -1,
 -58621,
 453075426,
 6302,
 -1,
 453116723,
 6304,
 453319431,
 453097723,
 -1,
 -58618,
 453294515,
 6305,
 -1,
 453347447,
 6303,
 453516042,
 453278576,
 -1,
 -58615,
 453454884,
 6307,
 -1,
 453509939,
 6300,
 -58613,
 453474128,
 6306,
 -58612,
 453648408,
 6299,
 -58611,
 453739088,
 6314,
 -58610,
 453777423,
 6301,
 -58609,
 453859214,
 6298,
 -1,
 453943964,
 6312,
 -58607,
 452832549,
 6263,
 -58606,
 454052265,
 6261,
 -58605,
 454156239,
 6260,
 -58604,
 454170781,
 6259,
 -1,
 454271231,
 6262,
 454433561,
 452689867,
 -1,
 -58601,
 454379945,
 6207,
 -58600,
 454474139,
 6209,
 -1,
 454492979,
 6205,
 454695707,
 454375265,
 6180,
 -1,
 454626604,
 6182,
 454826781,
 454663416,
 6179,
 -1,
 454757676,
 6181,
 454957856,
 454807183,
 -1,
 -58593,
 454932915,
 6208,
 -1,
 454951731,
 6191,
 455154467,
 454922551,
 -1,
 -58590,
 455129523,
 6203,
 -1,
 455148339,
 6202,
 455351077,
 455085356,
 6177,
 -1,
 455281964,
 6183,
 455482152,
 455310407,
 -1,
 -58585,
 455415965,
 6210,
 -1,
 455476019,
 6196,
 -58583,
 455420964,
 6198,
 -58582,
 455641322,
 6200,
 -58581,
 455690665,
 6199,
 -58580,
 455753433,
 6188,
 -58579,
 455822712,
 6187,
 -58578,
 455875357,
 6184,
 -58577,
 455987702,
 6197,
 -58576,
 456005789,
 6178,
 -58575,
 456100202,
 6206,
 -58574,
 456175251,
 6189,
 -58573,
 456237311,
 6201,
 -58572,
 456296464,
 6195,
 -1,
 456380929,
 6186,
 456530755,
 445964657,
 -1,
 456596281,
 456517002,
 -1,
 -58568,
 456558833,
 6162,
 -1,
 456624147,
 6163,
 456792892,
 456566670,
 -1,
 -58565,
 456770923,
 6166,
 -1,
 456800894,
 6167,
 456989503,
 456738887,
 -1,
 -58562,
 456954354,
 6164,
 -1,
 456992770,
 6165,
 -58560,
 456919395,
 6160,
 -58559,
 457158968,
 6161,
 -58558,
 457191990,
 6169,
 -1,
 457294026,
 6168,
 457448267,
 456476743,
 -1,
 457513801,
 457407747,
 -1,
 457579336,
 457500042,
 -1,
 -58553,
 457541873,
 6156,
 -1,
 457607187,
 6157,
 -1,
 457552184,
 6155,
 -58550,
 457443659,
 6147,
 -1,
 457784782,
 6149,
 457972558,
 457403502,
 -1,
 -58547,
 457901591,
 6153,
 -1,
 458008055,
 6152,
 458169169,
 457931850,
 -1,
 -58544,
 458115155,
 6146,
 -1,
 458164693,
 6148,
 -58542,
 458146157,
 6158,
 -58541,
 458296956,
 6150,
 -58540,
 458404864,
 6151,
 -58539,
 458477208,
 6154,
 -58538,
 458529808,
 6145,
 -1,
 458571970,
 6144,
 458817535,
 445881592,
 -1,
 458824541,
 458725974,
 -1,
 458890076,
 458769017,
 -1,
 -58533,
 458868134,
 9867,
 -1,
 458937175,
 9866,
 -1,
 458872670,
 119552,
 -1,
 458764763,
 9101,
 -1,
 445782074,
 9968,
 459283653,
 427833185,
 -1,
 459349168,
 459247534,
 -1,
 459414700,
 459316608,
 -1,
 459479966,
 459373424,
 -1,
 459545488,
 459447544,
 -1,
 459611023,
 459481684,
 -1,
 459676558,
 459545851,
 -1,
 459742063,
 459646862,
 -1,
 459807596,
 459728266,
 -1,
 459873131,
 459774207,
 -1,
 -58518,
 459840760,
 119164,
 -1,
 459900752,
 119166,
 -1,
 459838892,
 119141,
 -58515,
 459742806,
 119142,
 -58514,
 460080074,
 119213,
 -1,
 460148771,
 119176,
 460331895,
 459710748,
 -1,
 460397430,
 460273752,
 -1,
 -58510,
 460376646,
 119154,
 -58509,
 460426381,
 119153,
 -58508,
 460476013,
 119152,
 -58507,
 460526608,
 119151,
 -1,
 460635816,
 119150,
 -1,
 460375422,
 119175,
 460856191,
 460318090,
 -1,
 460921726,
 460829959,
 -1,
 460987261,
 460853176,
 -1,
 -58501,
 460934765,
 119145,
 -58500,
 460985360,
 119144,
 -1,
 461094568,
 119143,
 -1,
 460941759,
 119179,
 -1,
 460867414,
 119165,
 461380483,
 460818429,
 -1,
 -58495,
 461315687,
 119210,
 -58494,
 461430527,
 119178,
 -1,
 461489543,
 119173,
 461642631,
 461308723,
 -1,
 461708166,
 461593141,
 119163,
 -1,
 461649127,
 119169,
 -1,
 461681405,
 119149,
 461904777,
 461577505,
 119167,
 -1,
 461845735,
 119168,
 -58486,
 461885073,
 119211,
 -58485,
 461998389,
 119174,
 -58484,
 462050822,
 119170,
 -58483,
 462128418,
 119212,
 -1,
 462212226,
 119177,
 -1,
 459613470,
 119092,
 -1,
 459573264,
 119052,
 462494615,
 459525775,
 -1,
 462560148,
 462444612,
 -1,
 -58477,
 462527334,
 119130,
 -1,
 462580041,
 119131,
 462815231,
 462493853,
 -1,
 -58474,
 462696019,
 119253,
 -1,
 462792509,
 119255,
 462953370,
 462468359,
 -1,
 -58471,
 462897154,
 119247,
 -1,
 462954107,
 119186,
 -58469,
 462897883,
 119093,
 -58468,
 463129432,
 119109,
 -58467,
 463184977,
 119059,
 -1,
 463220008,
 119073,
 463412172,
 459466122,
 -1,
 463477684,
 463385863,
 119190,
 463601663,
 463445685,
 -1,
 463608753,
 463491807,
 -1,
 463674280,
 463546260,
 -1,
 463739814,
 463642887,
 -1,
 -58459,
 463706982,
 119120,
 -1,
 463759689,
 119121,
 -58457,
 463706982,
 119112,
 -1,
 463890761,
 119113,
 464067499,
 463642887,
 -1,
 -58454,
 464034662,
 119116,
 -1,
 464087369,
 119117,
 464264110,
 464005869,
 -1,
 -58451,
 464231270,
 119114,
 -1,
 464283977,
 119115,
 464519167,
 464209702,
 -1,
 -58448,
 464427878,
 119118,
 -1,
 464480585,
 119119,
 464715775,
 463577798,
 -1,
 -58445,
 464624486,
 119124,
 -1,
 464677193,
 119125,
 464853952,
 463425576,
 -1,
 464919484,
 464787581,
 -1,
 464985019,
 464878769,
 119243,
 465108991,
 464963710,
 -1,
 -58439,
 464997997,
 119246,
 -58438,
 465048592,
 119245,
 -1,
 465157800,
 119244,
 -1,
 464938224,
 119242,
 465436671,
 464852676,
 -1,
 465443775,
 465331440,
 119239,
 -1,
 465401121,
 119241,
 -1,
 465403057,
 119240,
 465640388,
 464789411,
 119191,
 465764351,
 465589289,
 -1,
 -58429,
 465662100,
 119194,
 -1,
 465725227,
 119193,
 465902537,
 465617810,
 -1,
 465968072,
 465853484,
 -1,
 -58425,
 465944326,
 119104,
 -1,
 466016449,
 119138,
 -1,
 465947271,
 119064,
 466230219,
 465861152,
 119256,
 -1,
 466182324,
 119260,
 -1,
 466207873,
 119063,
 466426866,
 463382414,
 -1,
 466492378,
 466360477,
 -1,
 466557913,
 466421679,
 -1,
 466623446,
 466544010,
 -1,
 466688979,
 466552290,
 -1,
 -58414,
 466665222,
 119105,
 -1,
 466737345,
 119139,
 466943999,
 466647231,
 -1,
 -58411,
 466861830,
 119103,
 -1,
 466933953,
 119137,
 467140607,
 466597000,
 -1,
 -58408,
 467039665,
 119068,
 -1,
 467106839,
 119067,
 -1,
 466508158,
 119040,
 467344357,
 466423084,
 -1,
 467409892,
 467275698,
 -1,
 467475424,
 467344493,
 -1,
 -58402,
 467442534,
 119229,
 -58401,
 467517190,
 119238,
 -1,
 467560777,
 119230,
 467795967,
 467439538,
 -1,
 -58398,
 467704678,
 119225,
 -58397,
 467779334,
 119236,
 -1,
 467822921,
 119226,
 -1,
 467357721,
 119051,
 468065258,
 467307322,
 -1,
 468130793,
 468046055,
 -1,
 -58392,
 468097894,
 119110,
 -1,
 468150601,
 119111,
 -1,
 468073920,
 119250,
 468392943,
 468042642,
 -1,
 468458478,
 468358037,
 -1,
 -58387,
 468414612,
 119088,
 -1,
 468509854,
 119089,
 -1,
 468416346,
 119045,
 468720625,
 468322596,
 119254,
 -1,
 468662212,
 119259,
 -1,
 468678947,
 119181,
 468917260,
 466372679,
 -1,
 468982779,
 468850845,
 -1,
 469048314,
 468933928,
 -1,
 469113849,
 469024245,
 -1,
 -58377,
 469061229,
 119148,
 -58376,
 469111824,
 119147,
 -1,
 469221032,
 119146,
 -1,
 469064989,
 119042,
 -1,
 469030464,
 119066,
 469507072,
 468950264,
 -1,
 469572607,
 469442422,
 -1,
 -58370,
 469530033,
 119069,
 -1,
 469597207,
 119065,
 -1,
 469534330,
 119185,
 469834756,
 469445928,
 119074,
 469958655,
 469774299,
 -1,
 -58365,
 469879973,
 119076,
 -1,
 469951097,
 119075,
 470096903,
 469773665,
 -1,
 -58362,
 470063974,
 119231,
 -1,
 470116681,
 119232,
 470293514,
 470052476,
 -1,
 -58359,
 470249620,
 119084,
 -1,
 470344862,
 119085,
 470548479,
 470229722,
 119056,
 -1,
 470419495,
 119057,
 470621217,
 468884728,
 -1,
 470686745,
 470560555,
 -1,
 470752273,
 470662824,
 119195,
 -58352,
 470728360,
 119205,
 -1,
 470778446,
 119204,
 -58350,
 470734084,
 119203,
 -58349,
 470915081,
 119202,
 -58348,
 470964354,
 119201,
 -58347,
 471015026,
 119200,
 -58346,
 471124550,
 119199,
 -58345,
 471174285,
 119198,
 -58344,
 471223917,
 119197,
 -1,
 471274512,
 119196,
 471473182,
 470620963,
 -1,
 471538717,
 471402170,
 -1,
 -58340,
 471514886,
 119106,
 -1,
 471587009,
 119140,
 -1,
 471487966,
 119062,
 471859199,
 471433929,
 -1,
 -58336,
 471780517,
 119095,
 -1,
 471851641,
 119094,
 471997490,
 470595835,
 -1,
 472063016,
 471925555,
 -1,
 472128549,
 472014344,
 119220,
 -1,
 472064130,
 119221,
 -58330,
 472097184,
 119044,
 -58329,
 472196588,
 119049,
 -1,
 472279299,
 119050,
 472456236,
 472040270,
 -1,
 -58326,
 472399004,
 119082,
 -58325,
 472482649,
 119083,
 -1,
 472522544,
 119041,
 472718383,
 472399501,
 -1,
 -58322,
 472650768,
 119078,
 -1,
 472759976,
 119077,
 472973311,
 472649004,
 -1,
 -58319,
 472851588,
 119209,
 -1,
 472954626,
 119187,
 473111618,
 471940544,
 -1,
 473177149,
 473085191,
 -1,
 473242682,
 473107756,
 -1,
 473308217,
 473199816,
 -1,
 473373752,
 473286017,
 119224,
 -1,
 473302492,
 119235,
 -1,
 473304364,
 119132,
 -1,
 473294451,
 119058,
 473694207,
 473194984,
 -1,
 -58308,
 473571814,
 119061,
 -1,
 473632044,
 119060,
 473890815,
 473107005,
 -1,
 -58305,
 473788052,
 119157,
 -58304,
 473866675,
 119159,
 -58303,
 473941106,
 119161,
 -1,
 473979560,
 119155,
 474160207,
 473094560,
 -1,
 474225735,
 474127608,
 -1,
 474291270,
 474209309,
 119257,
 -1,
 474232772,
 119258,
 -1,
 474262930,
 119252,
 474487884,
 474156332,
 -1,
 474553419,
 474459631,
 -1,
 -58294,
 474481947,
 119215,
 -1,
 474572031,
 119214,
 -1,
 474498256,
 119261,
 -58291,
 474422617,
 119108,
 -58290,
 474792889,
 119183,
 -1,
 474844866,
 119126,
 475012188,
 474096212,
 -1,
 475077716,
 474949051,
 119227,
 475201535,
 475026473,
 -1,
 -58285,
 475119366,
 119237,
 -1,
 475162953,
 119228,
 475339863,
 475025123,
 -1,
 -58282,
 475278534,
 119081,
 -1,
 475334108,
 119098,
 475536474,
 475296494,
 -1,
 -58279,
 475503462,
 119122,
 -1,
 475556169,
 119123,
 -58277,
 475498122,
 119184,
 -1,
 475675030,
 119222,
 475864171,
 474973901,
 -1,
 475929700,
 475837703,
 -1,
 475995233,
 475859184,
 -1,
 -58272,
 475974532,
 119249,
 -1,
 475994120,
 119248,
 476250111,
 475930080,
 -1,
 -58269,
 476145451,
 119188,
 -1,
 476224479,
 119189,
 476388456,
 475868456,
 119070,
 476512255,
 476327899,
 -1,
 -58265,
 476433573,
 119072,
 -1,
 476504697,
 119071,
 476708863,
 476349411,
 -1,
 -58262,
 476606612,
 119217,
 -1,
 476701854,
 119218,
 476847223,
 475837703,
 -1,
 476912756,
 476777772,
 -1,
 476978291,
 476844722,
 -1,
 477043826,
 476933527,
 -1,
 -58256,
 476991085,
 119055,
 -58255,
 477041680,
 119054,
 -1,
 477150888,
 119053,
 -1,
 477019588,
 119048,
 -1,
 476924639,
 119043,
 477495295,
 476846237,
 -1,
 -58250,
 477405085,
 119180,
 -1,
 477453928,
 119047,
 477633665,
 476777772,
 -1,
 477699198,
 477600246,
 -1,
 -58246,
 477654676,
 119158,
 -58245,
 477733299,
 119160,
 -58244,
 477807730,
 119162,
 -58243,
 477851927,
 119208,
 -1,
 477911720,
 119156,
 478150655,
 477660106,
 -1,
 -58240,
 478068486,
 119102,
 -1,
 478140609,
 119136,
 478289035,
 477576906,
 -1,
 478354568,
 478217956,
 -1,
 478420102,
 478304263,
 -1,
 -58235,
 478362780,
 119090,
 -1,
 478446425,
 119091,
 -58233,
 478396166,
 119101,
 -1,
 478599361,
 119135,
 478806015,
 478338414,
 -1,
 -58230,
 478727333,
 119097,
 -1,
 478798457,
 119096,
 478944402,
 478240040,
 -1,
 479009935,
 478890711,
 -1,
 -58226,
 478965908,
 119086,
 -1,
 479061150,
 119087,
 -58224,
 478968319,
 119129,
 -58223,
 479166861,
 119128,
 -1,
 479242711,
 119207,
 479403160,
 478924431,
 -1,
 479468695,
 479380524,
 119223,
 479592447,
 479417385,
 -1,
 -58218,
 479511785,
 119233,
 -1,
 479584787,
 119234,
 -1,
 479411786,
 119046,
 479796382,
 479377843,
 -1,
 479861917,
 479745632,
 -1,
 -58213,
 479837958,
 119100,
 -58212,
 479875909,
 119216,
 -1,
 479975617,
 119134,
 -1,
 479789109,
 119206,
 480189603,
 479769413,
 -1,
 480255138,
 480119926,
 -1,
 -58207,
 480231174,
 119099,
 -1,
 480303297,
 119133,
 -1,
 480235534,
 119219,
 480517286,
 480146632,
 -1,
 -58203,
 480454629,
 119127,
 -1,
 480551103,
 119251,
 480713897,
 480463563,
 -1,
 -58200,
 480669844,
 119171,
 -1,
 480765086,
 119172,
 -58198,
 480673739,
 119182,
 -58197,
 480874003,
 119107,
 -1,
 480943390,
 119192,
 481165311,
 459363369,
 -1,
 -58194,
 481074127,
 9839,
 -58193,
 481101642,
 9838,
 -1,
 481184076,
 9837,
 481369282,
 459313728,
 -1,
 481434813,
 481297924,
 -1,
 481500348,
 481408393,
 215,
 481624063,
 481449001,
 -1,
 481631417,
 481511224,
 -1,
 -58186,
 481570922,
 10811,
 -58185,
 481648392,
 10805,
 -58184,
 481733566,
 10804,
 -1,
 481796146,
 10807,
 482017279,
 481605031,
 -1,
 -58181,
 481900956,
 10801,
 -1,
 482008284,
 10800,
 -1,
 481429423,
 10005,
 482221249,
 481411453,
 8844,
 482344959,
 482169897,
 -1,
 -58176,
 482217818,
 8846,
 -1,
 482338046,
 8845,
 -1,
 482162772,
 8888,
 482607103,
 481341965,
 -1,
 -58172,
 482481767,
 8810,
 -1,
 482597800,
 8811,
 482745802,
 459232629,
 -1,
 482811211,
 482725519,
 -1,
 482876743,
 482779472,
 -1,
 482942182,
 482840887,
 -1,
 483007717,
 482916787,
 4097,
 483131391,
 482940871,
 -1,
 483138768,
 483047675,
 -1,
 483204303,
 483113211,
 -1,
 -58162,
 483178931,
 43625,
 -1,
 483197747,
 43624,
 -1,
 483178931,
 43626,
 483466451,
 483090860,
 -1,
 -58158,
 483441075,
 43623,
 -1,
 483459891,
 43622,
 483663062,
 483417384,
 -1,
 -58155,
 483601444,
 43621,
 -1,
 483656499,
 43627,
 483859673,
 483611340,
 -1,
 -58152,
 483834291,
 43620,
 -1,
 483853107,
 43619,
 484056284,
 483836818,
 -1,
 -58149,
 484030899,
 43630,
 -1,
 484049715,
 43629,
 484252895,
 484014960,
 -1,
 -58146,
 484227507,
 43618,
 -1,
 484246323,
 43617,
 -58144,
 484224809,
 43634,
 -58143,
 484415149,
 43633,
 -58142,
 484464300,
 43628,
 -58141,
 484526505,
 43635,
 -58140,
 484617875,
 43616,
 -1,
 484679935,
 43631,
 -1,
 482935603,
 4096,
 484908284,
 482912142,
 -1,
 484973817,
 484882867,
 4176,
 485097471,
 484907855,
 -1,
 485104876,
 484990248,
 -1,
 -58133,
 485043236,
 4218,
 -1,
 485098291,
 4220,
 485301487,
 485069111,
 -1,
 -58130,
 485276083,
 4214,
 -1,
 485294899,
 4213,
 -58128,
 485273385,
 4217,
 -58127,
 485474236,
 4224,
 -58126,
 485544537,
 4221,
 -58125,
 485603763,
 4225,
 -58124,
 485666451,
 4215,
 -58123,
 485728511,
 4222,
 -58122,
 485787664,
 4219,
 -58121,
 485850192,
 4216,
 -58120,
 485937665,
 4223,
 -1,
 485950259,
 4130,
 -58118,
 484923052,
 4177,
 -58117,
 486103063,
 4193,
 -1,
 486146867,
 4126,
 486350085,
 484844116,
 -1,
 486415620,
 486322537,
 -1,
 486481153,
 486370923,
 -1,
 -58112,
 486411564,
 4189,
 -1,
 486474547,
 4188,
 -58110,
 486416408,
 4186,
 -58109,
 486610959,
 4187,
 -1,
 486673708,
 4136,
 -1,
 486343475,
 4121,
 486939916,
 486300968,
 -1,
 487005449,
 486890792,
 -1,
 -58104,
 486943780,
 4106,
 -1,
 486998835,
 4111,
 -58102,
 486943780,
 4105,
 -58101,
 487173779,
 4100,
 -1,
 487195443,
 4116,
 487398673,
 486867684,
 -1,
 487464207,
 487372039,
 4178,
 -1,
 487437575,
 4179,
 487653375,
 487444111,
 4180,
 -1,
 487575183,
 4181,
 487726359,
 487384458,
 -1,
 487791893,
 487712138,
 -1,
 -58092,
 487766451,
 4108,
 -1,
 487785267,
 4107,
 -58090,
 487766451,
 4113,
 -1,
 487916339,
 4112,
 488119580,
 487656748,
 4135,
 488243199,
 488059215,
 -1,
 -58086,
 488131747,
 4207,
 -58085,
 488206009,
 4206,
 -1,
 488252999,
 4208,
 488447266,
 488093947,
 -1,
 488512800,
 488421627,
 -1,
 -58081,
 488487347,
 4110,
 -1,
 488506163,
 4109,
 -58079,
 488487347,
 4115,
 -1,
 488637235,
 4114,
 488840487,
 488420165,
 -1,
 488906022,
 488773730,
 -1,
 -58075,
 488882108,
 4197,
 -1,
 488904986,
 4198,
 -1,
 488833843,
 4125,
 489168171,
 488801997,
 -1,
 -58071,
 489138560,
 4159,
 -58070,
 489208243,
 4099,
 -1,
 489227059,
 4098,
 489430318,
 489095987,
 4129,
 -58067,
 489371489,
 4138,
 -1,
 489440272,
 43642,
 489626928,
 489371489,
 4133,
 -1,
 489568097,
 4134,
 489758003,
 489600263,
 -1,
 -58062,
 489744290,
 4238,
 -1,
 489751347,
 4123,
 489954614,
 489740704,
 -1,
 -58059,
 489929139,
 4118,
 -1,
 489947955,
 4117,
 490151225,
 489934479,
 -1,
 -58056,
 490078974,
 4128,
 -1,
 490144563,
 4124,
 490347836,
 490099404,
 -1,
 -58053,
 490322355,
 4104,
 -1,
 490341171,
 4103,
 490544446,
 490281117,
 4131,
 -1,
 490477725,
 4132,
 490675521,
 490503024,
 -1,
 -58048,
 490650035,
 4102,
 -1,
 490668851,
 4101,
 490872132,
 490618304,
 -1,
 -58045,
 490846643,
 4120,
 -1,
 490865459,
 4119,
 -58043,
 490810404,
 4122,
 -58042,
 491035896,
 4137,
 -1,
 491108787,
 4127,
 491323391,
 482814839,
 -1,
 -58039,
 491208412,
 43637,
 -58038,
 491282123,
 43636,
 -1,
 491370928,
 43638,
 491527560,
 482781070,
 -1,
 491593069,
 491493882,
 -1,
 491658586,
 491562894,
 -1,
 491724121,
 491614869,
 -1,
 491789652,
 491673613,
 -1,
 -58031,
 491724402,
 4234,
 -58030,
 491833926,
 4233,
 -58029,
 491867757,
 4232,
 -1,
 491918352,
 4231,
 492175359,
 491734257,
 -1,
 492182872,
 492066829,
 -1,
 -58025,
 492129901,
 4236,
 -1,
 492180496,
 4235,
 -1,
 492116461,
 4237,
 -1,
 491683062,
 4171,
 492510560,
 491627385,
 -1,
 -58020,
 492489286,
 4205,
 -58019,
 492539021,
 4204,
 -58018,
 492588653,
 4203,
 -58017,
 492639248,
 4202,
 -1,
 492748456,
 4201,
 492903779,
 492469504,
 -1,
 -58014,
 492879018,
 4152,
 -1,
 492912113,
 4153,
 493100390,
 492880919,
 -1,
 -58011,
 493047405,
 4251,
 -1,
 493141672,
 4250,
 493297001,
 493028147,
 -1,
 -58008,
 493269566,
 4154,
 -1,
 493308138,
 4150,
 -58006,
 493276262,
 4239,
 -58005,
 493438033,
 43643,
 -58004,
 493515382,
 4170,
 -1,
 493588793,
 4151,
 493755771,
 491565086,
 -1,
 493821297,
 493741450,
 -1,
 -58000,
 493783281,
 4242,
 -1,
 493848595,
 4243,
 494017908,
 493791118,
 -1,
 -57997,
 493995371,
 4246,
 -1,
 494025342,
 4247,
 494214519,
 493963335,
 -1,
 -57994,
 494178802,
 4244,
 -1,
 494217218,
 4245,
 -57992,
 494143843,
 4240,
 -57991,
 494383416,
 4241,
 -57990,
 494416438,
 4249,
 -1,
 494518474,
 4248,
 494731263,
 493689719,
 -1,
 494738818,
 494601011,
 -1,
 494804353,
 494705866,
 -1,
 -57985,
 494748955,
 43641,
 -57984,
 494842168,
 43640,
 -1,
 494910980,
 43639,
 -1,
 494752567,
 4174,
 495132037,
 494702504,
 -1,
 -57980,
 495104312,
 4254,
 -1,
 495173124,
 4255,
 -57978,
 495090550,
 4172,
 -57977,
 495309286,
 4175,
 -1,
 495328218,
 4173,
 495525292,
 491490357,
 -1,
 495590800,
 495495054,
 -1,
 495656335,
 495547029,
 -1,
 495721869,
 495586604,
 4228,
 -1,
 495653341,
 4229,
 -57970,
 495683773,
 4230,
 -1,
 495804901,
 4227,
 -1,
 495626077,
 4194,
 496049557,
 495518436,
 -1,
 496115091,
 496022791,
 4182,
 -1,
 496088327,
 4183,
 496304127,
 496094863,
 4184,
 -1,
 496225935,
 4185,
 496377242,
 495977267,
 -1,
 496442777,
 496310429,
 4146,
 496566271,
 496393547,
 4252,
 -1,
 496441501,
 4253,
 -1,
 496370483,
 4140,
 496704926,
 496350910,
 -1,
 -57956,
 496645985,
 4211,
 -57955,
 496707265,
 4210,
 -1,
 496801217,
 4212,
 496967073,
 496640944,
 -1,
 -57952,
 496922819,
 4200,
 -1,
 496997863,
 4199,
 497163683,
 496908129,
 4143,
 -1,
 497104737,
 4144,
 497294758,
 497101535,
 -1,
 -57947,
 497261816,
 4148,
 -1,
 497337751,
 4147,
 497491368,
 497227933,
 4141,
 -1,
 497424541,
 4142,
 497622442,
 497421612,
 4145,
 -1,
 497553885,
 4149,
 -57941,
 497595313,
 4139,
 -1,
 497724176,
 4209,
 497884602,
 495509873,
 -1,
 497950128,
 497870218,
 -1,
 -57937,
 497912049,
 4162,
 -1,
 497977363,
 4163,
 498146739,
 497919886,
 -1,
 -57934,
 498124139,
 4166,
 -1,
 498154110,
 4167,
 498343350,
 498092103,
 -1,
 -57931,
 498307570,
 4164,
 -1,
 498345986,
 4165,
 -57929,
 498272611,
 4160,
 -57928,
 498512184,
 4161,
 -57927,
 498545206,
 4169,
 -1,
 498647242,
 4168,
 498802118,
 497845967,
 -1,
 498867653,
 498737748,
 -1,
 498933185,
 498806787,
 -1,
 -57922,
 498871332,
 4155,
 -57921,
 498960618,
 4157,
 -57920,
 499009961,
 4156,
 -1,
 499104179,
 4158,
 499318783,
 498912939,
 -1,
 -57917,
 499194653,
 4190,
 -57916,
 499257254,
 4191,
 -1,
 499319550,
 4192,
 -1,
 498847132,
 4226,
 499588553,
 498786565,
 -1,
 -57912,
 499568770,
 4196,
 -1,
 499636545,
 4195,
 -1,
 499548287,
 43632,
 499850825,
 482676012,
 -1,
 499916307,
 499786963,
 -1,
 499981818,
 499895951,
 -1,
 500047353,
 499949904,
 -1,
 500112851,
 499997992,
 -1,
 500178385,
 500089476,
 43977,
 -1,
 500153130,
 44001,
 500367359,
 500106035,
 43973,
 -1,
 500284202,
 43999,
 500440535,
 500098442,
 -1,
 500506070,
 500417955,
 43975,
 -1,
 500480810,
 44000,
 -1,
 500466057,
 43978,
 500702683,
 500423072,
 -1,
 500768218,
 500630323,
 43972,
 -1,
 500742954,
 43998,
 -1,
 500730200,
 43984,
 500964831,
 500666679,
 -1,
 501030366,
 500901537,
 43968,
 -1,
 501005098,
 43995,
 -1,
 500990345,
 43976,
 501226977,
 500914074,
 43971,
 -1,
 501201706,
 43997,
 501358051,
 501209583,
 43970,
 -1,
 501332778,
 43996,
 501489126,
 501306060,
 -1,
 -57883,
 501466531,
 43990,
 -1,
 501516632,
 43987,
 501685736,
 501422237,
 43983,
 -1,
 501660458,
 44002,
 501816811,
 501647053,
 -1,
 -57878,
 501753505,
 43986,
 -1,
 501842313,
 43992,
 502013422,
 501790971,
 -1,
 -57875,
 501990819,
 43991,
 -1,
 502038921,
 43993,
 502210033,
 501956032,
 -1,
 -57872,
 502171992,
 43994,
 -1,
 502203187,
 43989,
 -57870,
 502195280,
 43980,
 -57869,
 502383818,
 43979,
 -57868,
 502427837,
 43982,
 -57867,
 502510110,
 43969,
 -57866,
 502556306,
 43988,
 -57865,
 502611771,
 43981,
 -57864,
 502696599,
 43974,
 -1,
 502762943,
 43985,
 -1,
 499981723,
 44012,
 502996488,
 499966321,
 -1,
 503062014,
 502982026,
 -1,
 -57859,
 503023857,
 44018,
 -1,
 503089171,
 44019,
 503258625,
 503031694,
 -1,
 -57856,
 503235947,
 44022,
 -1,
 503265918,
 44023,
 503455236,
 503203911,
 -1,
 -57853,
 503419378,
 44020,
 -1,
 503457794,
 44021,
 -57851,
 503384419,
 44016,
 -57850,
 503623992,
 44017,
 -57849,
 503657014,
 44025,
 -1,
 503759050,
 44024,
 503914001,
 502959157,
 -1,
 -57846,
 503874420,
 44006,
 -57845,
 503940401,
 44008,
 -57844,
 503998981,
 44007,
 -57843,
 504081196,
 44003,
 -57842,
 504119094,
 44010,
 -57841,
 504192752,
 44004,
 -57840,
 504257036,
 44009,
 -1,
 504346009,
 44005,
 -57838,
 503894734,
 44011,
 -1,
 504452623,
 44013,
 504634920,
 499879754,
 -1,
 504700441,
 504604265,
 -1,
 504765976,
 504648745,
 -1,
 -57833,
 504751064,
 10089,
 -1,
 504787847,
 10101,
 -1,
 504715796,
 10093,
 505028126,
 504649307,
 -1,
 505093661,
 504976425,
 -1,
 -57828,
 505078744,
 10088,
 -1,
 505115527,
 10100,
 -1,
 505043476,
 10092,
 505355809,
 504997774,
 -1,
 -57824,
 505306246,
 9900,
 -1,
 505388342,
 9618,
 505552420,
 505313614,
 -1,
 -57821,
 505491428,
 10091,
 -1,
 505569325,
 10090,
 -57819,
 505507720,
 9898,
 -57818,
 505685287,
 10073,
 -57817,
 505770784,
 8287,
 -1,
 505838731,
 9899,
 506011195,
 504601064,
 -1,
 506076729,
 505948602,
 8737,
 506200063,
 506025001,
 -1,
 506207800,
 506102480,
 -1,
 506273327,
 506142349,
 -1,
 -57810,
 506242665,
 10664,
 -1,
 506287707,
 10665,
 506469938,
 506254540,
 -1,
 -57807,
 506425492,
 10668,
 -1,
 506520734,
 10670,
 506666549,
 506448326,
 -1,
 -57804,
 506622100,
 10669,
 -1,
 506717342,
 10671,
 506920959,
 506620528,
 -1,
 -57801,
 506832489,
 10666,
 -1,
 506877531,
 10667,
 -1,
 506148474,
 10651,
 -57798,
 506019854,
 10653,
 -1,
 507080344,
 8798,
 507256392,
 505963640,
 -1,
 507321922,
 507241866,
 -1,
 507387456,
 507283287,
 -1,
 -57793,
 507339070,
 9173,
 -1,
 507379746,
 9174,
 -57791,
 507372115,
 9175,
 -1,
 507544891,
 9176,
 507715141,
 507272891,
 -1,
 -57788,
 507667034,
 9172,
 -1,
 507761292,
 9170,
 -57786,
 507691780,
 9171,
 -57785,
 507854631,
 9177,
 -1,
 507940054,
 9169,
 -1,
 507204952,
 9791,
 508231679,
 499783837,
 -1,
 508239448,
 508124456,
 -1,
 508304983,
 508194967,
 -1,
 508370518,
 508253225,
 -1,
 508436053,
 508343689,
 8722,
 508559359,
 508384297,
 -1,
 508567124,
 508474791,
 -1,
 -57775,
 508507989,
 10796,
 -57774,
 508586881,
 10795,
 -57773,
 508662073,
 10794,
 -1,
 508746611,
 10793,
 -1,
 508535387,
 10810,
 -1,
 508367930,
 8770,
 -1,
 508339481,
 8723,
 -1,
 508248697,
 10751,
 509156955,
 508213499,
 -1,
 -57766,
 509097441,
 8943,
 -1,
 509158558,
 183,
 -57764,
 509113184,
 8357,
 -1,
 509285727,
 181,
 509487016,
 342281871,
 -1,
 509551602,
 509412147,
 -1,
 509617032,
 509491261,
 -1,
 509681962,
 509585294,
 -1,
 509747487,
 509614986,
 -1,
 509813020,
 509726351,
 -1,
 509878545,
 509780304,
 -1,
 509943464,
 509863306,
 116,
 510008963,
 509884257,
 -1,
 510074498,
 509962610,
 -1,
 510140012,
 510047495,
 633,
 510263295,
 510084383,
 -1,
 -57750,
 510189993,
 11385,
 -57749,
 510232032,
 634,
 -1,
 510285452,
 635,
 510467695,
 510116754,
 613,
 510590975,
 510403003,
 686,
 -1,
 510514640,
 687,
 510664306,
 510395187,
 592,
 -57743,
 510623229,
 594,
 -1,
 510659884,
 7426,
 510860917,
 510631160,
 -1,
 -57740,
 510818107,
 7432,
 -1,
 510856492,
 7444,
 511057527,
 510796372,
 623,
 -1,
 511036566,
 624,
 511188601,
 510990493,
 7433,
 -1,
 511147896,
 42879,
 -57734,
 511132281,
 654,
 -57733,
 511292229,
 653,
 -57732,
 511341768,
 652,
 -57731,
 511436170,
 647,
 -57730,
 511495823,
 42881,
 -57729,
 511545655,
 670,
 -57728,
 511608525,
 7543,
 -57727,
 511642924,
 477,
 -1,
 511748646,
 397,
 -1,
 510009940,
 42871,
 511975063,
 509953311,
 -1,
 512040586,
 511933296,
 -1,
 -57722,
 511975327,
 566,
 -57721,
 512036575,
 539,
 -57720,
 512154871,
 7793,
 -57719,
 512202882,
 355,
 -1,
 512281519,
 357,
 512433809,
 512014587,
 -1,
 512499342,
 512369151,
 -1,
 -57715,
 512473206,
 7789,
 -1,
 512517349,
 7787,
 512753663,
 512476585,
 -1,
 -57712,
 512679444,
 11366,
 -1,
 512739203,
 7831,
 -57710,
 512399621,
 359,
 -57709,
 512832871,
 648,
 -57708,
 512928382,
 427,
 -57707,
 512975962,
 7541,
 -57706,
 513029494,
 7791,
 -1,
 513103500,
 429,
 513285789,
 511941880,
 -1,
 513351324,
 513223062,
 -1,
 -57702,
 513295643,
 424,
 -57701,
 513388132,
 389,
 -1,
 513434668,
 445,
 -1,
 513307471,
 7446,
 513679010,
 513262482,
 -1,
 513744545,
 513620655,
 254,
 513867775,
 513713702,
 42853,
 -1,
 513748073,
 42855,
 -1,
 513694015,
 7546,
 -57693,
 513638347,
 42793,
 -57692,
 513946736,
 678,
 -57691,
 514010192,
 42795,
 -57690,
 514095165,
 679,
 -57689,
 514172058,
 680,
 -1,
 514228285,
 11383,
 514399972,
 509910264,
 111,
 514465500,
 514344223,
 -1,
 514530995,
 514439582,
 -1,
 514596530,
 514476460,
 417,
 514719743,
 514527677,
 -1,
 -57682,
 514593850,
 7905,
 -57681,
 514670934,
 7903,
 -57680,
 514746827,
 7901,
 -57679,
 514822457,
 7907,
 -1,
 514901521,
 7899,
 -1,
 514555095,
 7887,
 515120830,
 514504955,
 -1,
 515186364,
 515087608,
 -1,
 515251897,
 515138135,
 -1,
 515317432,
 515204325,
 559,
 -1,
 515270549,
 561,
 -1,
 515291254,
 7885,
 515571711,
 515229463,
 -1,
 -57669,
 515467723,
 525,
 -1,
 515556881,
 337,
 515768319,
 515118149,
 246,
 -1,
 515663765,
 555,
 515841735,
 515079024,
 -1,
 515907270,
 515775276,
 244,
 516030463,
 515838397,
 -1,
 -57662,
 515904570,
 7895,
 -57661,
 515981654,
 7893,
 -57660,
 516057547,
 7891,
 -57659,
 516133177,
 7897,
 -1,
 516212241,
 7889,
 -1,
 515885999,
 466,
 516431564,
 515773498,
 245,
 516554751,
 516362685,
 -1,
 -57654,
 516453018,
 557,
 -57653,
 516521694,
 7759,
 -1,
 516605457,
 7757,
 516759248,
 516387482,
 333,
 516882431,
 516690365,
 -1,
 -57649,
 516778443,
 7761,
 -1,
 516867601,
 7763,
 517021396,
 516686593,
 -1,
 -57646,
 516959111,
 11386,
 -57645,
 517023471,
 42829,
 -1,
 517135697,
 42827,
 517283542,
 516987141,
 248,
 -1,
 517213883,
 511,
 517414616,
 517232894,
 491,
 -1,
 517367701,
 493,
 -57639,
 517399550,
 527,
 -57638,
 517499339,
 242,
 -57637,
 517573846,
 335,
 -1,
 517654033,
 243,
 517807841,
 514412421,
 -1,
 517873375,
 517774584,
 596,
 -1,
 517820799,
 7575,
 518062079,
 517803308,
 603,
 -1,
 517951871,
 7571,
 -57630,
 517748577,
 547,
 -57629,
 518102264,
 42831,
 -1,
 518133917,
 419,
 518332189,
 514329900,
 101,
 518397705,
 518276383,
 -1,
 518463219,
 518355824,
 -1,
 518528752,
 518396716,
 234,
 518651903,
 518476841,
 -1,
 518659823,
 518533882,
 -1,
 -57621,
 518591546,
 7877,
 -57620,
 518668630,
 7875,
 -57619,
 518744523,
 7873,
 -57618,
 518820153,
 7879,
 -1,
 518899217,
 7871,
 -1,
 518633590,
 7705,
 519118578,
 518494338,
 553,
 -1,
 519058247,
 7709,
 -1,
 519097263,
 283,
 519315194,
 518437115,
 -1,
 519380729,
 519281912,
 -1,
 519446264,
 519332439,
 -1,
 -57609,
 519420022,
 7865,
 -1,
 519464165,
 279,
 -1,
 519410716,
 517,
 -1,
 519312453,
 235,
 519773950,
 519271066,
 275,
 519897087,
 519705021,
 -1,
 -57603,
 519793099,
 7701,
 -1,
 519882257,
 7703,
 520036096,
 519705658,
 7869,
 -1,
 519964711,
 7707,
 -57599,
 520001797,
 583,
 -57598,
 520107367,
 7570,
 -57597,
 520182014,
 281,
 -57596,
 520246567,
 11384,
 -57595,
 520348670,
 519,
 -57594,
 520372566,
 7867,
 -57593,
 520448459,
 232,
 -57592,
 520522966,
 277,
 -1,
 520603153,
 233,
 520757010,
 518369048,
 658,
 520880127,
 520705065,
 -1,
 520888081,
 520795559,
 -1,
 520953615,
 520846192,
 -1,
 -57586,
 520888223,
 659,
 -1,
 520997807,
 495,
 -57584,
 520937897,
 442,
 -1,
 521090407,
 7578,
 -1,
 520815729,
 441,
 521346839,
 520705698,
 643,
 521469951,
 521291039,
 -1,
 -57579,
 521352551,
 7576,
 -57578,
 521448062,
 7563,
 -1,
 521527167,
 646,
 521674521,
 521332106,
 42859,
 -1,
 521651090,
 240,
 521805596,
 521610808,
 -1,
 -57573,
 521783630,
 42787,
 -1,
 521848230,
 42789,
 -1,
 521739046,
 331,
 522067796,
 518259507,
 97,
 522133320,
 522011935,
 -1,
 522198824,
 522091376,
 -1,
 522264359,
 522132268,
 226,
 522387455,
 522195389,
 -1,
 -57565,
 522261562,
 7851,
 -57564,
 522338646,
 7849,
 -57563,
 522414539,
 7847,
 -57562,
 522490169,
 7853,
 -1,
 522569233,
 7845,
 -1,
 522242991,
 462,
 522788657,
 522172667,
 -1,
 522854191,
 522755320,
 -1,
 522919726,
 522805847,
 -1,
 522985261,
 522872037,
 551,
 -1,
 522938261,
 481,
 -1,
 522958966,
 7841,
 -1,
 522884124,
 513,
 523304959,
 522785861,
 228,
 -1,
 523200405,
 479,
 523378488,
 522751190,
 259,
 523501567,
 523309501,
 -1,
 -57548,
 523375674,
 7861,
 -57547,
 523452758,
 7859,
 -57546,
 523528651,
 7857,
 -57545,
 523604281,
 7863,
 -1,
 523683345,
 7855,
 523837248,
 523351303,
 -1,
 523902783,
 523770013,
 -1,
 523968318,
 523837705,
 -1,
 524033853,
 523920613,
 229,
 -1,
 523964091,
 507,
 -1,
 524007542,
 7681,
 -1,
 523896753,
 7834,
 -1,
 523858022,
 7567,
 -57535,
 523768890,
 227,
 -57534,
 524327173,
 11365,
 -57533,
 524376318,
 261,
 -57532,
 524448410,
 257,
 -57531,
 524542974,
 515,
 -57530,
 524566870,
 7843,
 -57529,
 524642763,
 224,
 -1,
 524731921,
 225,
 524885836,
 522063148,
 230,
 525008895,
 524829983,
 -1,
 -57525,
 524907162,
 483,
 -1,
 524994065,
 509,
 525147982,
 524842184,
 42809,
 -1,
 525088950,
 42811,
 525279056,
 525106685,
 593,
 -1,
 525226367,
 7568,
 -57519,
 525222521,
 42813,
 -57518,
 525350753,
 42807,
 -57517,
 525442296,
 42805,
 -1,
 525468467,
 42803,
 525672325,
 522008417,
 117,
 525737857,
 525620265,
 -1,
 525803392,
 525710759,
 -1,
 525868901,
 525777147,
 -1,
 525934432,
 525800517,
 252,
 526057471,
 525882409,
 -1,
 526065503,
 525939450,
 -1,
 -57508,
 526021274,
 470,
 -57507,
 526084555,
 476,
 -57506,
 526163976,
 474,
 -1,
 526239249,
 472,
 -1,
 526039158,
 7795,
 526516223,
 525901048,
 -1,
 526524260,
 526436119,
 -1,
 -57501,
 526477771,
 533,
 -1,
 526566929,
 369,
 -1,
 526485226,
 7909,
 526786414,
 525842846,
 -1,
 526851949,
 526731692,
 432,
 526974975,
 526782909,
 -1,
 -57495,
 526849082,
 7919,
 -57494,
 526926166,
 7917,
 -57493,
 527002059,
 7915,
 -57492,
 527077689,
 7921,
 -1,
 527156753,
 7913,
 -1,
 526810327,
 7911,
 527376242,
 526718010,
 361,
 527499263,
 527324201,
 -1,
 -57487,
 527415414,
 7797,
 -1,
 527445294,
 7801,
 527638390,
 527334256,
 -1,
 527703925,
 527571756,
 251,
 -1,
 527632423,
 7799,
 -1,
 527682479,
 468,
 527900537,
 527611143,
 -1,
 -57480,
 527836468,
 367,
 -1,
 527921254,
 7577,
 528097147,
 527856282,
 363,
 -1,
 528044124,
 7803,
 -57476,
 528046334,
 371,
 -57475,
 528212990,
 535,
 -57474,
 528247243,
 249,
 -57473,
 528321750,
 365,
 -1,
 528401937,
 250,
 -1,
 525734082,
 649,
 528621443,
 525685344,
 650,
 -1,
 528590374,
 7551,
 -57468,
 528556628,
 42872,
 -1,
 528682284,
 7531,
 528883623,
 525641614,
 115,
 528949143,
 528827679,
 -1,
 529014669,
 528907120,
 -1,
 529080202,
 528993199,
 353,
 -1,
 529034719,
 7783,
 -57461,
 529010399,
 537,
 -57460,
 529144620,
 349,
 -1,
 529242242,
 351,
 529407889,
 528983919,
 -1,
 529473424,
 529381494,
 7779,
 -1,
 529427935,
 7785,
 -1,
 529425637,
 7777,
 529670035,
 529384977,
 347,
 -1,
 529624543,
 7781,
 -57452,
 529615297,
 575,
 -57451,
 529771134,
 7562,
 -57450,
 529818714,
 7540,
 -1,
 529880716,
 642,
 530063262,
 528922613,
 -1,
 530128795,
 530029816,
 7441,
 -57446,
 530085673,
 7442,
 -1,
 530163238,
 7443,
 -57444,
 530069345,
 7453,
 -57443,
 530303115,
 7455,
 -1,
 530375417,
 7454,
 530522020,
 530021232,
 -1,
 530587555,
 530472175,
 601,
 530710527,
 530531615,
 -1,
 -57438,
 530593127,
 7573,
 -1,
 530667148,
 602,
 -1,
 530572530,
 609,
 -57435,
 530493357,
 645,
 -57434,
 530868068,
 223,
 -1,
 530933896,
 42892,
 531111883,
 528856327,
 114,
 531177407,
 531059753,
 -1,
 531242942,
 531150247,
 -1,
 531308464,
 531204093,
 -1,
 531373999,
 531259991,
 -1,
 531439534,
 531347574,
 7771,
 -1,
 531392405,
 7773,
 -1,
 531391717,
 7769,
 -1,
 531338268,
 529,
 531701683,
 531287695,
 -1,
 -57422,
 531681195,
 636,
 -1,
 531703154,
 7775,
 531898293,
 531652151,
 638,
 -1,
 531825873,
 7539,
 532029368,
 531856240,
 -1,
 -57417,
 531994754,
 343,
 -1,
 532073391,
 345,
 -57415,
 532013481,
 637,
 -57414,
 532191493,
 589,
 -57413,
 532261502,
 7561,
 -57412,
 532309082,
 7538,
 -57411,
 532407294,
 531,
 -1,
 532465169,
 341,
 -1,
 531227147,
 42843,
 532684744,
 531130252,
 -1,
 532750276,
 532636424,
 604,
 532873215,
 532694303,
 -1,
 -57405,
 532755815,
 7572,
 -1,
 532829836,
 605,
 533012422,
 532708208,
 8580,
 -1,
 532987764,
 42815,
 -57401,
 532950335,
 639,
 -1,
 533073196,
 600,
 533274570,
 532639909,
 42869,
 -1,
 533207657,
 42845,
 -1,
 533205456,
 612,
 533471214,
 531091087,
 108,
 533536738,
 533415199,
 -1,
 533602258,
 533494640,
 -1,
 -57393,
 533536671,
 564,
 -57392,
 533650679,
 7741,
 -57391,
 533698690,
 316,
 -1,
 533777327,
 318,
 533929942,
 533563389,
 -1,
 533995477,
 533890794,
 7735,
 -1,
 533948309,
 7737,
 -1,
 533981170,
 11361,
 534192089,
 533892288,
 -1,
 -57384,
 534123578,
 619,
 -1,
 534188090,
 320,
 534388700,
 534134208,
 -1,
 -57381,
 534366538,
 620,
 -1,
 534405653,
 410,
 -57379,
 534354181,
 322,
 -57378,
 534525287,
 621,
 -57377,
 534620798,
 7557,
 -57376,
 534656374,
 7739,
 -57375,
 534732540,
 42825,
 -1,
 534824465,
 314,
 534978536,
 533494329,
 383,
 535101439,
 534922527,
 -1,
 535109607,
 535017723,
 -1,
 -57370,
 535046644,
 7835,
 -1,
 535128266,
 7836,
 -1,
 535060220,
 7837,
 -57367,
 534910643,
 683,
 -57366,
 535326885,
 42866,
 -57365,
 535377008,
 682,
 -57364,
 535450316,
 457,
 -57363,
 535505437,
 622,
 -1,
 535576896,
 411,
 535765006,
 533403805,
 105,
 535830532,
 535708959,
 -1,
 535896054,
 535804155,
 -1,
 535961588,
 535862520,
 -1,
 -57357,
 535925788,
 521,
 -1,
 535987946,
 7883,
 536215551,
 535893061,
 239,
 -1,
 536088251,
 7727,
 536289272,
 535827514,
 297,
 -1,
 536217639,
 7725,
 536420347,
 536247152,
 -1,
 -57350,
 536353580,
 238,
 -1,
 536464303,
 464,
 -57348,
 536385797,
 616,
 -57347,
 536556903,
 7574,
 -57346,
 536631550,
 303,
 -57345,
 536703642,
 299,
 -57344,
 536798206,
 523,
 -57343,
 536822102,
 7881,
 -57342,
 536897995,
 236,
 -57341,
 536972502,
 301,
 -1,
 537052689,
 237,
 537206795,
 535761907,
 -1,
 -57338,
 537191818,
 42887,
 -57337,
 537241486,
 42885,
 -57336,
 537310471,
 42883,
 -57335,
 537364173,
 7545,
 -57334,
 537413703,
 42876,
 -1,
 537508091,
 42874,
 537665549,
 537141876,
 617,
 -1,
 537634342,
 7548,
 -1,
 537634702,
 42861,
 537862192,
 535738619,
 100,
 537927713,
 537806111,
 -1,
 537993237,
 537885552,
 -1,
 -57326,
 537927583,
 545,
 -57325,
 538041591,
 7699,
 -57324,
 538089602,
 7697,
 -1,
 538168239,
 271,
 538320920,
 537978250,
 -1,
 -57321,
 538253917,
 396,
 -1,
 538333172,
 598,
 538517530,
 538269324,
 599,
 -1,
 538498512,
 7569,
 538648605,
 538486639,
 -1,
 -57316,
 538622070,
 7693,
 -1,
 538666213,
 7691,
 -57314,
 538614021,
 273,
 -57313,
 538815102,
 7553,
 -57312,
 538862682,
 7533,
 -1,
 538916214,
 7695,
 539107366,
 537886667,
 499,
 539230207,
 539055145,
 -1,
 539238437,
 539104122,
 675,
 -1,
 539200931,
 677,
 -1,
 539201889,
 454,
 539435051,
 539042329,
 -1,
 539500586,
 539382476,
 567,
 539623423,
 539469350,
 607,
 -1,
 539501654,
 644,
 -1,
 539433117,
 305,
 539762734,
 539364652,
 -1,
 -57299,
 539717786,
 676,
 -1,
 539791909,
 7839,
 -57297,
 539717797,
 42865,
 -1,
 539933135,
 568,
 540090440,
 537812264,
 110,
 540155974,
 540038185,
 -1,
 540221509,
 540128679,
 -1,
 540287032,
 540179312,
 -1,
 -57291,
 540221343,
 565,
 -57290,
 540335351,
 7755,
 -57289,
 540383362,
 326,
 -1,
 540461999,
 328,
 540614716,
 540266127,
 -1,
 -57286,
 540583401,
 414,
 -57285,
 540616050,
 7753,
 -1,
 540688030,
 626,
 540876863,
 540583791,
 -1,
 -57282,
 540850294,
 7751,
 -1,
 540894437,
 7749,
 -57280,
 540808250,
 241,
 -57279,
 541013351,
 627,
 -57278,
 541108862,
 7559,
 -57277,
 541156442,
 7536,
 -57276,
 541223371,
 505,
 -1,
 541312529,
 324,
 -1,
 540170671,
 329,
 -57273,
 540111013,
 42868,
 -1,
 541479628,
 460,
 541663324,
 540066706,
 104,
 541728856,
 541607199,
 -1,
 541794384,
 541702395,
 -1,
 541859918,
 541729279,
 -1,
 -57267,
 541833334,
 7717,
 -1,
 541877477,
 7715,
 -57265,
 541791301,
 7719,
 -1,
 542029962,
 11368,
 542187604,
 541752176,
 -1,
 -57262,
 542120748,
 293,
 -57261,
 542218370,
 7721,
 -1,
 542297007,
 543,
 -57259,
 542152965,
 295,
 -57258,
 542389622,
 7830,
 -57257,
 542463628,
 614,
 -1,
 542548072,
 7723,
 542711898,
 541704411,
 42791,
 -1,
 542648927,
 615,
 -57253,
 542667976,
 405,
 -1,
 542814610,
 11382,
 542974064,
 541621104,
 99,
 543039592,
 542917919,
 -1,
 543105124,
 542997360,
 -1,
 543170657,
 543070338,
 231,
 -1,
 543100603,
 7689,
 -57246,
 543104927,
 597,
 -57245,
 543234860,
 265,
 -1,
 543345583,
 269,
 -57243,
 543070469,
 572,
 -57242,
 543446668,
 392,
 -57241,
 543546588,
 267,
 -1,
 543606289,
 263,
 543760493,
 542994748,
 -1,
 543826028,
 543726840,
 -1,
 -57237,
 543782715,
 666,
 -1,
 543832067,
 631,
 -1,
 543785387,
 606,
 544088175,
 543691490,
 42797,
 -1,
 544041071,
 42799,
 -1,
 544024216,
 42863,
 544284804,
 542932939,
 122,
 544407551,
 544228639,
 -1,
 544415863,
 544323835,
 -1,
 544481398,
 544350719,
 -1,
 -57227,
 544454774,
 7827,
 -1,
 544498917,
 380,
 -1,
 544454794,
 11372,
 544743547,
 544373616,
 -1,
 -57223,
 544677791,
 657,
 -57222,
 544742188,
 7825,
 -1,
 544852911,
 382,
 545005694,
 544712590,
 -1,
 -57219,
 544969809,
 576,
 -1,
 545034146,
 438,
 -57217,
 544945511,
 656,
 -57216,
 545172094,
 7566,
 -57215,
 545219674,
 7542,
 -57214,
 545273206,
 7829,
 -57213,
 545347212,
 549,
 -1,
 545441297,
 378,
 545595542,
 544227961,
 121,
 545661077,
 545539359,
 -1,
 545726603,
 545634555,
 -1,
 545792138,
 545661439,
 -1,
 -57207,
 545765494,
 7925,
 -1,
 545809637,
 7823,
 -1,
 545723461,
 255,
 546054285,
 545674892,
 436,
 -1,
 545984989,
 7927,
 -57202,
 545985594,
 7929,
 -57201,
 546150661,
 591,
 -57200,
 546196257,
 7833,
 -57199,
 546271898,
 563,
 -57198,
 546315604,
 7935,
 -57197,
 546400715,
 7923,
 -57196,
 546475073,
 375,
 -1,
 546555409,
 253,
 -1,
 545609537,
 541,
 546775206,
 545558839,
 107,
 546840741,
 546719007,
 -1,
 546906268,
 546814203,
 -1,
 -57190,
 546835301,
 7731,
 -57189,
 546924746,
 42819,
 -1,
 547010698,
 11370,
 547168414,
 546871557,
 42817,
 -1,
 547120828,
 42821,
 547299489,
 547126128,
 -1,
 -57184,
 547264642,
 311,
 -1,
 547343279,
 489,
 -57182,
 547269246,
 7556,
 -57181,
 547435894,
 7733,
 -57180,
 547509900,
 409,
 -1,
 547603985,
 7729,
 -1,
 546785705,
 312,
 547823797,
 546735821,
 103,
 547889331,
 547767583,
 -1,
 547954860,
 547847024,
 -1,
 -57174,
 547887916,
 285,
 -57173,
 547985538,
 291,
 -1,
 548064175,
 487,
 -57171,
 547920133,
 485,
 -57170,
 548186750,
 7555,
 -57169,
 548237978,
 7713,
 -57168,
 548296332,
 608,
 -57167,
 548396252,
 289,
 -57166,
 548441302,
 287,
 -1,
 548521489,
 501,
 -57164,
 547873389,
 578,
 -1,
 548607300,
 611,
 548806851,
 547765696,
 98,
 548872384,
 548750623,
 -1,
 548937914,
 548841327,
 -1,
 -57159,
 548911222,
 7685,
 -1,
 548955365,
 7683,
 -57157,
 548903361,
 387,
 -57156,
 549099781,
 384,
 -57155,
 549169790,
 7552,
 -57154,
 549217370,
 7532,
 -57153,
 549270902,
 7687,
 -1,
 549344908,
 595,
 -57151,
 548844996,
 42823,
 -57150,
 549511208,
 7447,
 -1,
 549520707,
 629,
 549724368,
 548762824,
 118,
 549789901,
 549668127,
 -1,
 549855432,
 549763323,
 -1,
 -57145,
 549784421,
 7807,
 -1,
 549873866,
 42847,
 -57143,
 549786682,
 7805,
 -57142,
 550004254,
 11377,
 -57141,
 550087294,
 7564,
 -57140,
 550131340,
 651,
 -1,
 550231935,
 11380,
 -57138,
 549732985,
 42849,
 -57137,
 550332751,
 42851,
 -1,
 550420695,
 42857,
 550576349,
 549706144,
 112,
 550641884,
 550520095,
 -1,
 550707414,
 550610830,
 -1,
 550772949,
 550670242,
 7549,
 -1,
 550710377,
 42833,
 -1,
 550724385,
 42837,
 -57129,
 550677118,
 7560,
 -57128,
 550921306,
 7537,
 -57127,
 550983308,
 421,
 -57126,
 551075482,
 42835,
 -57125,
 551148764,
 7767,
 -1,
 551208465,
 7765,
 -1,
 550615451,
 632,
 551428330,
 550511188,
 109,
 551493862,
 551372063,
 -1,
 551559394,
 551462767,
 -1,
 -57119,
 551532662,
 7747,
 -1,
 551576805,
 7745,
 -57117,
 551529086,
 7558,
 -57116,
 551707738,
 7535,
 -57115,
 551769740,
 625,
 -1,
 551863825,
 7743,
 552018153,
 551468893,
 -1,
 -57112,
 551974088,
 7933,
 -1,
 552010500,
 7931,
 -1,
 551973029,
 42867,
 552280310,
 551400261,
 119,
 552402943,
 552224031,
 -1,
 552411377,
 552319227,
 -1,
 552476912,
 552346111,
 -1,
 -57105,
 552450166,
 7817,
 -1,
 552494309,
 7815,
 -1,
 552408133,
 7813,
 -57102,
 552356641,
 7832,
 -57101,
 552687244,
 11379,
 -57100,
 552757707,
 7809,
 -57099,
 552832065,
 373,
 -1,
 552912401,
 7811,
 553066749,
 552217917,
 113,
 553132284,
 553010463,
 -1,
 553197818,
 553080460,
 672,
 -1,
 553139515,
 587,
 -57093,
 553172391,
 42839,
 -1,
 553304739,
 42841,
 -1,
 553112756,
 569,
 553525508,
 553011271,
 102,
 553591043,
 553469215,
 -1,
 -57088,
 553560702,
 7554,
 -57087,
 553608282,
 7534,
 -57086,
 553670284,
 402,
 -1,
 553770204,
 7711,
 -1,
 553541508,
 681,
 553984267,
 553472716,
 106,
 554106879,
 553927967,
 -1,
 554115338,
 554007408,
 -1,
 -57080,
 554065164,
 669,
 -57079,
 554113836,
 309,
 -1,
 554224559,
 496,
 -1,
 554080517,
 585,
 554500095,
 553912239,
 120,
 554565631,
 554386719,
 -1,
 554574096,
 554481915,
 -1,
 -57073,
 554510836,
 7819,
 -1,
 554570821,
 7821,
 -1,
 554543742,
 7565,
 554893311,
 509821286,
 -1,
 554901784,
 554780743,
 -1,
 554967318,
 554846279,
 64256,
 -57067,
 554946191,
 64260,
 -1,
 554965149,
 64259,
 -57065,
 554946191,
 64258,
 -1,
 555096221,
 64257,
 -57063,
 554846005,
 64262,
 -57062,
 555230913,
 339,
 -57061,
 555310823,
 64261,
 -1,
 555402653,
 307,
 555614207,
 509772350,
 -1,
 -57058,
 555537243,
 7550,
 -1,
 555566253,
 7547,
 555810815,
 509682003,
 -1,
 -57055,
 555681711,
 8339,
 -57054,
 555775176,
 7525,
 -57053,
 555824993,
 7524,
 -57052,
 555912622,
 8340,
 -57051,
 555988231,
 7523,
 -57050,
 556047608,
 8338,
 -57049,
 556094156,
 11388,
 -57048,
 556144797,
 7522,
 -57047,
 556207404,
 8337,
 -1,
 556270387,
 8336,
 556475195,
 509639536,
 -1,
 556540730,
 556417209,
 -1,
 556606263,
 556507472,
 -1,
 556671336,
 556571896,
 79,
 556736866,
 556614943,
 -1,
 556802360,
 556710302,
 -1,
 556867895,
 556747180,
 416,
 556990463,
 556798397,
 -1,
 -57037,
 556864570,
 7904,
 -57036,
 556941654,
 7902,
 -57035,
 557017547,
 7900,
 -57034,
 557093177,
 7906,
 -1,
 557172241,
 7898,
 -1,
 556825815,
 7886,
 557392195,
 556775675,
 -1,
 557457729,
 557358328,
 -1,
 557523262,
 557408855,
 -1,
 557588797,
 557475045,
 558,
 -1,
 557541269,
 560,
 -1,
 557561974,
 7884,
 557842431,
 557500183,
 -1,
 -57024,
 557738443,
 524,
 -1,
 557827601,
 336,
 558039039,
 557388869,
 214,
 -1,
 557934485,
 554,
 558113100,
 557349744,
 -1,
 558178635,
 558045996,
 212,
 558301183,
 558109117,
 -1,
 -57017,
 558175290,
 7894,
 -57016,
 558252374,
 7892,
 -57015,
 558328267,
 7890,
 -57014,
 558403897,
 7896,
 -1,
 558482961,
 7888,
 -1,
 558156719,
 465,
 558702929,
 558044218,
 213,
 558825471,
 558633405,
 -1,
 -57009,
 558723738,
 556,
 -57008,
 558792414,
 7758,
 -1,
 558876177,
 7756,
 559030615,
 558637652,
 -1,
 559096150,
 558982972,
 332,
 559218687,
 559026621,
 -1,
 -57003,
 559114699,
 7760,
 -1,
 559203857,
 7762,
 -1,
 559040637,
 415,
 559423833,
 558995717,
 216,
 -1,
 559353531,
 510,
 559554907,
 559372542,
 490,
 -1,
 559507349,
 492,
 559685982,
 559481601,
 -1,
 -56995,
 559621871,
 42828,
 -1,
 559734097,
 42826,
 -56993,
 559670270,
 526,
 -56992,
 559835595,
 210,
 -56991,
 559910102,
 334,
 -1,
 559990289,
 211,
 560144741,
 556683141,
 -1,
 -56988,
 560110840,
 390,
 -1,
 560139564,
 400,
 -56986,
 560084833,
 546,
 -56985,
 560307448,
 42830,
 -1,
 560339101,
 418,
 560538011,
 556598067,
 65,
 560603535,
 560481567,
 -1,
 560669043,
 560561008,
 -1,
 560734578,
 560601900,
 194,
 560857087,
 560665021,
 -1,
 -56978,
 560731194,
 7850,
 -56977,
 560808278,
 7848,
 -56976,
 560884171,
 7846,
 -56975,
 560959801,
 7852,
 -1,
 561038865,
 7844,
 -1,
 560712623,
 461,
 561258876,
 560642299,
 -1,
 561324410,
 561224952,
 -1,
 561389945,
 561275479,
 -1,
 561455480,
 561341669,
 550,
 -1,
 561407893,
 480,
 -1,
 561428598,
 7840,
 -1,
 561353756,
 512,
 561774591,
 561255493,
 196,
 -1,
 561670037,
 478,
 561848707,
 561220822,
 258,
 561971199,
 561779133,
 -1,
 -56961,
 561845306,
 7860,
 -56960,
 561922390,
 7858,
 -56959,
 561998283,
 7856,
 -56958,
 562073913,
 7862,
 -1,
 562152977,
 7854,
 562307463,
 561808283,
 -1,
 562372998,
 562259173,
 197,
 -1,
 562302651,
 506,
 -1,
 562346102,
 7680,
 -56952,
 562238522,
 195,
 -56951,
 562534661,
 570,
 -56950,
 562583806,
 260,
 -56949,
 562655898,
 256,
 -56948,
 562750462,
 514,
 -56947,
 562774358,
 7842,
 -56946,
 562850251,
 192,
 -1,
 562939409,
 193,
 563093907,
 560532780,
 198,
 563216383,
 563037471,
 -1,
 -56942,
 563114650,
 482,
 -1,
 563201553,
 508,
 563356053,
 563049672,
 42808,
 -1,
 563296438,
 42810,
 -56938,
 563298937,
 42812,
 -56937,
 563427169,
 42806,
 -56936,
 563518712,
 42804,
 -56935,
 563576317,
 11373,
 -56934,
 563633984,
 393,
 -1,
 563675955,
 42802,
 563880393,
 560467244,
 69,
 563945918,
 563823903,
 -1,
 564011434,
 563903344,
 -1,
 564076967,
 563944236,
 202,
 564199423,
 564024361,
 -1,
 564208038,
 564081402,
 -1,
 -56926,
 564139066,
 7876,
 -56925,
 564216150,
 7874,
 -56924,
 564292043,
 7872,
 -56923,
 564367673,
 7878,
 -1,
 564446737,
 7870,
 -1,
 564181110,
 7704,
 564666793,
 564041858,
 552,
 -1,
 564605767,
 7708,
 -1,
 564644783,
 282,
 564863409,
 563984635,
 -1,
 564928944,
 564829432,
 -1,
 564994479,
 564879959,
 -1,
 -56914,
 564967542,
 7864,
 -1,
 565011685,
 278,
 -1,
 564958236,
 516,
 -1,
 564859973,
 203,
 565322165,
 564818586,
 274,
 565444607,
 565252541,
 -1,
 -56908,
 565340619,
 7700,
 -1,
 565429777,
 7702,
 565584311,
 565253178,
 7868,
 -1,
 565512231,
 7706,
 -56904,
 565549317,
 582,
 -56903,
 565663998,
 280,
 -56902,
 565765118,
 518,
 -56901,
 565789014,
 7866,
 -56900,
 565864907,
 200,
 -56899,
 565939414,
 276,
 -1,
 566019601,
 201,
 566174146,
 563916568,
 439,
 566296575,
 566121513,
 -1,
 -56895,
 566202721,
 494,
 -1,
 566232177,
 440,
 566436292,
 566158730,
 42858,
 -1,
 566412178,
 208,
 566567367,
 566371896,
 -1,
 -56890,
 566544718,
 42786,
 -1,
 566609318,
 42788,
 -56888,
 566515362,
 425,
 -1,
 566696742,
 330,
 566895093,
 563820385,
 85,
 566960628,
 566842409,
 -1,
 567026163,
 566932903,
 -1,
 567091674,
 566999291,
 -1,
 567157205,
 567022661,
 220,
 567279615,
 567104553,
 -1,
 567288276,
 567161594,
 -1,
 -56879,
 567243418,
 469,
 -56878,
 567306699,
 475,
 -56877,
 567386120,
 473,
 -1,
 567461393,
 471,
 -1,
 567261302,
 7794,
 567738367,
 567123192,
 -1,
 567747033,
 567658263,
 -1,
 -56872,
 567699915,
 532,
 -1,
 567789073,
 368,
 -1,
 567707370,
 7908,
 568009187,
 567064990,
 -1,
 568074722,
 567953836,
 431,
 568197119,
 568005053,
 -1,
 -56866,
 568071226,
 7918,
 -56865,
 568148310,
 7916,
 -56864,
 568224203,
 7914,
 -56863,
 568299833,
 7920,
 -1,
 568378897,
 7912,
 -1,
 568032471,
 7910,
 568599015,
 567940154,
 360,
 568721407,
 568546345,
 -1,
 -56858,
 568637558,
 7796,
 -1,
 568667438,
 7800,
 568861163,
 568556400,
 -1,
 568926698,
 568793900,
 219,
 -1,
 568854567,
 7798,
 -1,
 568904623,
 467,
 569123309,
 568816282,
 362,
 -1,
 569069660,
 7802,
 -56850,
 569068321,
 366,
 -56849,
 569202942,
 370,
 -56848,
 569304062,
 534,
 -56847,
 569338315,
 217,
 -56846,
 569412822,
 364,
 -1,
 569493009,
 218,
 -1,
 566956226,
 580,
 -1,
 566907488,
 433,
 569778709,
 566879626,
 84,
 569844229,
 569722143,
 -1,
 569909756,
 569801584,
 -1,
 -56839,
 569839327,
 538,
 -56838,
 569957623,
 7792,
 -56837,
 570005634,
 354,
 -1,
 570084271,
 356,
 570237441,
 569882875,
 -1,
 570302976,
 570171903,
 -1,
 -56833,
 570275958,
 7788,
 -1,
 570320101,
 7786,
 -1,
 570255562,
 574,
 -56830,
 570202373,
 358,
 -56829,
 570504551,
 430,
 -56828,
 570570102,
 7790,
 -1,
 570644108,
 428,
 570827276,
 569816929,
 -1,
 570892808,
 570753843,
 11375,
 -1,
 570850813,
 11376,
 -56823,
 570848456,
 581,
 -56822,
 570958420,
 412,
 -56821,
 571068047,
 42880,
 -1,
 571102451,
 42878,
 571286032,
 570801286,
 -1,
 -56818,
 571229467,
 423,
 -56817,
 571321956,
 388,
 -1,
 571368492,
 444,
 571548179,
 571257500,
 222,
 571670527,
 571516454,
 42852,
 -1,
 571550825,
 42854,
 -56812,
 571506635,
 42792,
 -1,
 571681872,
 42794,
 571875893,
 569710749,
 73,
 571941420,
 571819295,
 -1,
 572006943,
 571914491,
 -1,
 572072477,
 571972856,
 -1,
 572138012,
 572023383,
 -1,
 -56805,
 572110966,
 7882,
 -1,
 572155109,
 304,
 -1,
 572101660,
 520,
 572456959,
 572003397,
 207,
 -1,
 572329659,
 7726,
 572531233,
 571937850,
 296,
 -1,
 572459047,
 7724,
 572662308,
 572488560,
 -1,
 -56797,
 572594988,
 206,
 -1,
 572705711,
 463,
 -56795,
 572627205,
 407,
 -56794,
 572807422,
 302,
 -56793,
 572879514,
 298,
 -56792,
 572974078,
 522,
 -56791,
 572997974,
 7880,
 -56790,
 573073867,
 204,
 -56789,
 573148374,
 300,
 -1,
 573228561,
 205,
 573383219,
 571872243,
 -1,
 -56786,
 573367690,
 42886,
 -56785,
 573417358,
 42884,
 -56784,
 573486343,
 42882,
 -56783,
 573540045,
 42877,
 -56782,
 573589575,
 42875,
 -1,
 573683963,
 42873,
 -56780,
 573351822,
 42860,
 -1,
 573776500,
 406,
 573973064,
 571844494,
 83,
 574038596,
 573916447,
 -1,
 574104125,
 573995888,
 -1,
 574169658,
 574081967,
 352,
 -1,
 574123487,
 7782,
 -56773,
 574099167,
 536,
 -56772,
 574233388,
 348,
 -1,
 574331010,
 350,
 574497345,
 574072687,
 -1,
 574562880,
 574470262,
 7778,
 -1,
 574516703,
 7784,
 -1,
 574514405,
 7776,
 574759491,
 574473745,
 346,
 -1,
 574713311,
 7780,
 -1,
 574704065,
 11390,
 -56763,
 574002360,
 586,
 -56762,
 574908260,
 7838,
 -56761,
 574993546,
 399,
 -1,
 575039624,
 42891,
 575218270,
 573945095,
 82,
 575283802,
 575165481,
 -1,
 575349337,
 575255975,
 -1,
 575414865,
 575309821,
 -1,
 575480400,
 575365719,
 -1,
 575545935,
 575453302,
 7770,
 -1,
 575498133,
 7772,
 -1,
 575497445,
 7768,
 -1,
 575443996,
 528,
 575808084,
 575372144,
 -1,
 -56749,
 575772802,
 342,
 -1,
 575851439,
 344,
 -56747,
 575791529,
 11364,
 -56746,
 575969541,
 588,
 -56745,
 576009590,
 7774,
 -56744,
 576119806,
 530,
 -1,
 576177681,
 340,
 -1,
 575332875,
 42842,
 576397917,
 575235980,
 -1,
 -56740,
 576326956,
 398,
 -1,
 576446814,
 42814,
 -1,
 576372781,
 42844,
 576660083,
 575196815,
 76,
 576725618,
 576603423,
 -1,
 576791140,
 576686077,
 -1,
 576856675,
 576751338,
 7734,
 -1,
 576808853,
 7736,
 -1,
 576841714,
 11360,
 577053288,
 576748400,
 -1,
 -56730,
 577035511,
 7740,
 -56729,
 577083522,
 315,
 -1,
 577162159,
 317,
 577315435,
 577021838,
 -1,
 -56726,
 577277858,
 321,
 -1,
 577334866,
 456,
 577512046,
 577277120,
 -1,
 -56723,
 577442874,
 11362,
 -1,
 577507386,
 319,
 -56721,
 577451382,
 7738,
 -56720,
 577658620,
 42824,
 -56719,
 577704130,
 573,
 -1,
 577816081,
 313,
 -1,
 576672460,
 455,
 578036356,
 576602745,
 89,
 578101891,
 577979679,
 -1,
 578167418,
 578074875,
 -1,
 578232953,
 578101759,
 -1,
 -56712,
 578205814,
 7924,
 -1,
 578249957,
 7822,
 -1,
 578163781,
 376,
 578495100,
 578115212,
 435,
 -1,
 578425309,
 7926,
 -56707,
 578425914,
 7928,
 -56706,
 578590981,
 590,
 -56705,
 578646682,
 562,
 -56704,
 578690388,
 7934,
 -56703,
 578775499,
 7922,
 -56702,
 578849857,
 374,
 -1,
 578930193,
 221,
 -1,
 578049857,
 540,
 579150486,
 577985832,
 78,
 579216021,
 579093791,
 -1,
 579281546,
 579194511,
 -1,
 -56696,
 579249641,
 544,
 -56695,
 579282290,
 7752,
 -1,
 579354270,
 413,
 579543694,
 579238768,
 -1,
 -56692,
 579525879,
 7754,
 -56691,
 579573890,
 325,
 -1,
 579652527,
 327,
 579805841,
 579512175,
 -1,
 -56688,
 579778678,
 7750,
 -1,
 579822821,
 7748,
 -56686,
 579736634,
 209,
 -56685,
 579974088,
 459,
 -56684,
 580020683,
 504,
 -1,
 580109841,
 323,
 -1,
 579162828,
 458,
 580330152,
 579123451,
 68,
 580395686,
 580273439,
 -1,
 580461212,
 580364174,
 -1,
 580526747,
 580415028,
 498,
 -1,
 580455319,
 453,
 -1,
 580489122,
 272,
 580723360,
 580418416,
 -1,
 -56674,
 580705527,
 7698,
 -56673,
 580753538,
 7696,
 -1,
 580832175,
 270,
 580985507,
 580691823,
 -1,
 -56670,
 580958326,
 7692,
 -1,
 581002469,
 7690,
 -56668,
 580950465,
 395,
 -56667,
 581121398,
 7694,
 -1,
 581195404,
 394,
 581435391,
 580353995,
 497,
 -1,
 581307287,
 452,
 581509817,
 580305810,
 72,
 581575350,
 581453087,
 -1,
 581640880,
 581548283,
 -1,
 581706414,
 581575167,
 -1,
 -56659,
 581679222,
 7716,
 -1,
 581723365,
 7714,
 -56657,
 581637189,
 7718,
 -1,
 581875850,
 11367,
 582034100,
 581598064,
 -1,
 -56654,
 581966636,
 292,
 -56653,
 582064258,
 7720,
 -1,
 582142895,
 542,
 -56651,
 581998853,
 294,
 -1,
 582262888,
 7722,
 -56649,
 581546947,
 502,
 -56648,
 582402267,
 42790,
 -1,
 582463890,
 11381,
 582623943,
 581469901,
 71,
 582689477,
 582567199,
 -1,
 582755007,
 582646640,
 -1,
 -56643,
 582687532,
 284,
 -56642,
 582785154,
 290,
 -1,
 582863791,
 486,
 -56640,
 582719749,
 484,
 -56639,
 582972058,
 7712,
 -56638,
 583030412,
 403,
 -56637,
 583130332,
 288,
 -56636,
 583175382,
 286,
 -1,
 583255569,
 500,
 -56634,
 582673005,
 577,
 -1,
 583341380,
 404,
 583541461,
 582581104,
 67,
 583606994,
 583484703,
 -1,
 583672526,
 583564144,
 -1,
 583738060,
 583637122,
 199,
 -1,
 583667387,
 7688,
 -56627,
 583670572,
 264,
 -1,
 583846831,
 268,
 -56625,
 583637253,
 571,
 -56624,
 583947916,
 391,
 -56623,
 584047836,
 266,
 -1,
 584107537,
 262,
 584262356,
 583537378,
 42796,
 -1,
 584214639,
 42798,
 -1,
 584197784,
 42862,
 584458981,
 583499723,
 90,
 584581119,
 584402207,
 -1,
 584590044,
 584497403,
 -1,
 584655579,
 584524287,
 -1,
 -56614,
 584628342,
 7826,
 -1,
 584672485,
 379,
 -1,
 584628362,
 11371,
 584917727,
 584558478,
 -1,
 -56610,
 584881233,
 11391,
 -1,
 584945570,
 437,
 585114338,
 584874864,
 -1,
 -56607,
 585046828,
 7824,
 -1,
 585157551,
 381,
 -56605,
 585053558,
 7828,
 -56604,
 585258636,
 548,
 -1,
 585352721,
 377,
 585507571,
 584421687,
 75,
 585629695,
 585450783,
 -1,
 585638635,
 585545979,
 -1,
 -56599,
 585567077,
 7730,
 -56598,
 585656522,
 42818,
 -1,
 585742474,
 11369,
 585900781,
 585603333,
 42816,
 -1,
 585852604,
 42820,
 586031856,
 585857904,
 -1,
 -56593,
 585996418,
 310,
 -1,
 586075055,
 488,
 -56591,
 585971062,
 7732,
 -56590,
 586176140,
 408,
 -1,
 586270225,
 7728,
 586425087,
 585478981,
 87,
 586490622,
 586368287,
 -1,
 586556154,
 586463483,
 -1,
 586621689,
 586490367,
 -1,
 -56584,
 586594422,
 7816,
 -1,
 586638565,
 7814,
 -1,
 586552389,
 7812,
 -56581,
 586503820,
 11378,
 -56580,
 586836427,
 7808,
 -56579,
 586910785,
 372,
 -1,
 586991121,
 7810,
 -1,
 586441044,
 503,
 587211529,
 586380488,
 86,
 587277062,
 587154719,
 -1,
 587342596,
 587249915,
 -1,
 -56573,
 587271013,
 7806,
 -1,
 587360458,
 42846,
 -56571,
 587273274,
 7804,
 -1,
 587486860,
 434,
 -56569,
 587219577,
 42848,
 -56568,
 587622735,
 42850,
 -1,
 587710679,
 42856,
 587866899,
 587192736,
 80,
 587988991,
 587810079,
 -1,
 587997967,
 587900814,
 -1,
 588063502,
 587960226,
 11363,
 -1,
 588000361,
 42832,
 -1,
 588014369,
 42836,
 -56560,
 587945612,
 420,
 -56559,
 588234394,
 42834,
 -56558,
 588307676,
 7766,
 -1,
 588367377,
 7764,
 588522269,
 587808192,
 66,
 588587804,
 588465439,
 -1,
 588653336,
 588556143,
 -1,
 -56553,
 588626038,
 7684,
 -1,
 588670181,
 7682,
 -56551,
 588618177,
 386,
 -56550,
 588814597,
 579,
 -56549,
 588854646,
 7686,
 -1,
 588928652,
 385,
 -1,
 588559812,
 42822,
 589177639,
 588456532,
 77,
 589243172,
 589120799,
 -1,
 589308706,
 589211503,
 -1,
 -56543,
 589281398,
 7746,
 -1,
 589325541,
 7744,
 -56541,
 589256332,
 11374,
 -1,
 589481489,
 7742,
 589692927,
 589217629,
 -1,
 -56538,
 589591752,
 7932,
 -1,
 589628164,
 7930,
 589833003,
 589105071,
 88,
 589955071,
 589807007,
 -1,
 -56534,
 589834740,
 7818,
 -1,
 589894725,
 7820,
 590095151,
 589770045,
 81,
 590217215,
 590038303,
 -1,
 -56530,
 590134695,
 42838,
 -1,
 590201507,
 42840,
 590357299,
 590041804,
 74,
 590479359,
 590300447,
 -1,
 -56526,
 590387461,
 584,
 -1,
 590449729,
 308,
 590675967,
 590301255,
 70,
 590741503,
 590562591,
 -1,
 -56522,
 590632588,
 401,
 -1,
 590732508,
 7710,
 590938111,
 556548454,
 -1,
 -56519,
 590816961,
 338,
 -1,
 590923165,
 306,
 -1,
 556508143,
 10013,
 591143808,
 556410213,
 -1,
 591209320,
 591112078,
 -1,
 591274855,
 591161924,
 -1,
 591340355,
 591246599,
 640,
 591405890,
 591292300,
 -1,
 -56511,
 591377671,
 7449,
 -1,
 591420712,
 7438,
 -1,
 591360165,
 42870,
 591668039,
 591305976,
 7439,
 -56507,
 591607649,
 7445,
 -56506,
 591689513,
 7440,
 -1,
 591727916,
 630,
 591930187,
 591652234,
 7451,
 592052223,
 591902561,
 -1,
 -56502,
 591967495,
 7450,
 -1,
 591990060,
 11387,
 592192334,
 591858988,
 7431,
 -56499,
 592162584,
 7459,
 -1,
 592224529,
 7430,
 592388944,
 592170639,
 671,
 -1,
 592356902,
 7436,
 592520018,
 592320669,
 618,
 -1,
 592491850,
 641,
 592651092,
 592479949,
 610,
 -1,
 592587359,
 667,
 592782166,
 592592320,
 665,
 -1,
 592708911,
 7427,
 592913240,
 592708403,
 7424,
 -1,
 592842028,
 7425,
 -56487,
 592871371,
 7458,
 -56486,
 592986745,
 655,
 -56485,
 593081157,
 7457,
 -56484,
 593130696,
 7456,
 -56483,
 593180513,
 7452,
 -56482,
 593274766,
 42801,
 -56481,
 593353120,
 7448,
 -56480,
 593386792,
 628,
 -56479,
 593437268,
 7437,
 -56478,
 593531191,
 7435,
 -56477,
 593580748,
 7434,
 -56476,
 593675154,
 668,
 -56475,
 593709127,
 42800,
 -56474,
 593803515,
 7429,
 -1,
 593853296,
 7428,
 -1,
 591215415,
 663,
 594092909,
 591153574,
 -1,
 594158444,
 594037959,
 -1,
 -56469,
 594086089,
 674,
 -1,
 594197009,
 426,
 -1,
 594090445,
 451,
 594420594,
 594046581,
 -1,
 594486129,
 594379050,
 -1,
 -56464,
 594443829,
 684,
 -1,
 594478506,
 664,
 -1,
 594417744,
 685,
 594748276,
 594388563,
 662,
 -1,
 594716198,
 446,
 594879350,
 594711702,
 660,
 -1,
 594847270,
 673,
 595010425,
 594805555,
 -1,
 -56456,
 594965167,
 450,
 -1,
 595051942,
 7461,
 -56454,
 594947287,
 422,
 -56453,
 595178541,
 447,
 -56452,
 595237919,
 7460,
 -56451,
 595322531,
 443,
 -56450,
 595373120,
 661,
 -56449,
 595423521,
 449,
 -1,
 595501731,
 448,
 595722239,
 591088813,
 -1,
 595731332,
 595629929,
 -1,
 -56445,
 595712416,
 43004,
 -1,
 595740743,
 43003,
 595927943,
 595663005,
 -1,
 -56442,
 595899676,
 43005,
 -1,
 595920674,
 43006,
 -1,
 595904419,
 43007,
 596190176,
 509552069,
 -1,
 596255664,
 596125029,
 -1,
 596321167,
 596239754,
 -1,
 596386702,
 596279465,
 -1,
 -56435,
 596348933,
 3735,
 -1,
 596380785,
 3734,
 -1,
 596352248,
 3733,
 596648852,
 596302240,
 -1,
 596714387,
 596607145,
 -1,
 -56430,
 596676613,
 3742,
 -1,
 596708465,
 3740,
 -1,
 596679928,
 3739,
 596976536,
 596598056,
 -1,
 -56426,
 596943277,
 3725,
 -56425,
 597007608,
 3737,
 -1,
 597077654,
 3719,
 597238685,
 596939063,
 -1,
 597304220,
 597196969,
 -1,
 -56421,
 597266437,
 3716,
 -1,
 597298289,
 3714,
 -1,
 597269752,
 3713,
 597566368,
 597207490,
 -1,
 -56417,
 597528581,
 3722,
 -1,
 597560433,
 3754,
 597762979,
 597497071,
 -1,
 -56414,
 597702575,
 3749,
 -1,
 597772200,
 3747,
 597959590,
 597721257,
 -1,
 -56411,
 597921797,
 3758,
 -1,
 597953649,
 3755,
 598156201,
 597920272,
 -1,
 -56408,
 598118405,
 3741,
 -1,
 598150257,
 3743,
 -56406,
 598122925,
 3746,
 -56405,
 598313201,
 3751,
 -56404,
 598383864,
 3757,
 -56403,
 598413231,
 3745,
 -56402,
 598509565,
 3732,
 -56401,
 598572106,
 3720,
 -1,
 598634098,
 3738,
 598811586,
 596216885,
 -1,
 598877110,
 598737715,
 3760,
 -56397,
 598819449,
 3779,
 -56396,
 598876756,
 3763,
 -56395,
 598939805,
 3780,
 -1,
 598999859,
 3762,
 599204792,
 598819449,
 3766,
 -1,
 599147129,
 3767,
 599335866,
 599144289,
 3768,
 -1,
 599275361,
 3769,
 599466941,
 599316415,
 -1,
 -56388,
 599402136,
 3771,
 -1,
 599482892,
 3761,
 599663551,
 599398557,
 3764,
 -1,
 599595165,
 3765,
 599794625,
 599592236,
 3776,
 -1,
 599726237,
 3777,
 -1,
 599760120,
 3778,
 599991248,
 598794609,
 -1,
 600056774,
 599975306,
 -1,
 -56379,
 600017137,
 3794,
 -1,
 600082451,
 3795,
 600253385,
 600024974,
 -1,
 -56376,
 600229227,
 3798,
 -1,
 600259198,
 3799,
 600449996,
 600197191,
 -1,
 -56373,
 600412658,
 3796,
 -1,
 600451074,
 3797,
 -56371,
 600377699,
 3792,
 -56370,
 600617272,
 3793,
 -56369,
 600650294,
 3801,
 -1,
 600752330,
 3800,
 600908758,
 599971544,
 -1,
 600974292,
 600892810,
 -1,
 -56365,
 600905885,
 3786,
 -1,
 601012638,
 3785,
 -56363,
 600937918,
 3784,
 -1,
 601120627,
 3787,
 601301977,
 600878590,
 -1,
 -56360,
 601241576,
 3773,
 -1,
 601293569,
 3772,
 601498588,
 601260201,
 -1,
 -56357,
 601430810,
 3804,
 -1,
 601493423,
 3805,
 -56355,
 601433842,
 3789,
 -56354,
 601667634,
 3782,
 -56353,
 601725968,
 3759,
 -1,
 601802860,
 3788,
 601957360,
 596135495,
 -1,
 602022894,
 601904169,
 -1,
 602088423,
 602006922,
 -1,
 602153958,
 602070807,
 -1,
 -56347,
 602094525,
 68414,
 -1,
 602152787,
 68412,
 -1,
 602080262,
 11004,
 602416106,
 602061958,
 -1,
 -56343,
 602355109,
 68415,
 -1,
 602455740,
 68413,
 -56341,
 602400562,
 10200,
 -56340,
 602582057,
 10782,
 -56339,
 602660276,
 10201,
 -1,
 602678119,
 9711,
 602931199,
 602007361,
 10923,
 -1,
 602807974,
 10925,
 -56335,
 601897119,
 9790,
 -1,
 602971676,
 917505,
 603137444,
 509483165,
 -1,
 603202815,
 603069219,
 -1,
 603268344,
 603163820,
 -1,
 603333765,
 603231804,
 -1,
 603399267,
 603274688,
 -1,
 603464773,
 603373224,
 -1,
 603530252,
 603423310,
 -1,
 603595773,
 603507270,
 -1,
 -56325,
 603575792,
 65669,
 -56324,
 603631351,
 65668,
 -1,
 603688101,
 65667,
 603857920,
 603575556,
 -1,
 -56321,
 603788945,
 65677,
 -1,
 603897813,
 65676,
 604054531,
 603822089,
 -1,
 -56318,
 603980906,
 65675,
 -1,
 604053273,
 65674,
 604251142,
 604002434,
 -1,
 -56315,
 604196647,
 65673,
 -1,
 604246376,
 65672,
 604447753,
 604184178,
 -1,
 -56312,
 604408408,
 65671,
 -1,
 604463858,
 65670,
 -56310,
 604383652,
 65666,
 -56309,
 604601265,
 65665,
 -1,
 604643039,
 65664,
 604840983,
 603463282,
 -1,
 -56306,
 604820740,
 65713,
 -56305,
 604870665,
 65712,
 -56304,
 604919938,
 65711,
 -56303,
 604970610,
 65710,
 -56302,
 605080134,
 65709,
 -56301,
 605129869,
 65708,
 -56300,
 605209566,
 65707,
 -56299,
 605264981,
 65706,
 -56298,
 605339304,
 65705,
 -1,
 605389390,
 65704,
 605561889,
 604788866,
 -1,
 -56295,
 605541636,
 65722,
 -56294,
 605591561,
 65721,
 -56293,
 605640834,
 65720,
 -56292,
 605721118,
 65719,
 -56291,
 605785229,
 65718,
 -56290,
 605842497,
 65717,
 -56289,
 605885456,
 65716,
 -56288,
 605994664,
 65715,
 -1,
 606044750,
 65714,
 606217258,
 605538886,
 -1,
 -56285,
 606169612,
 65703,
 -56284,
 606246921,
 65702,
 -56283,
 606296194,
 65701,
 -56282,
 606375053,
 65699,
 -56281,
 606424685,
 65698,
 -56280,
 606475280,
 65697,
 -56279,
 606558850,
 65696,
 -1,
 606634574,
 65695,
 606807090,
 606181385,
 -1,
 -56276,
 606786820,
 65729,
 -56275,
 606849606,
 65728,
 -56274,
 606899341,
 65727,
 -56273,
 606948973,
 65726,
 -56272,
 606999568,
 65725,
 -56271,
 607108776,
 65724,
 -1,
 607158862,
 65723,
 607331384,
 606768269,
 -1,
 -56268,
 607264370,
 65694,
 -56267,
 607338966,
 65693,
 -56266,
 607392784,
 65692,
 -56265,
 607499504,
 65691,
 -1,
 607524504,
 65690,
 607724606,
 607261712,
 -1,
 -56262,
 607670564,
 65682,
 -56261,
 607750184,
 65681,
 -56260,
 607839696,
 65680,
 -56259,
 607875188,
 65679,
 -1,
 607919431,
 65678,
 608117826,
 607669869,
 -1,
 -56256,
 608048144,
 65687,
 -56255,
 608128635,
 65686,
 -1,
 608200761,
 65685,
 608436223,
 608097540,
 -1,
 -56252,
 608349577,
 65731,
 -1,
 608404046,
 65730,
 608632831,
 603395088,
 -1,
 608642128,
 608553542,
 -1,
 -56248,
 608621828,
 65757,
 -56247,
 608671753,
 65756,
 -56246,
 608721026,
 65755,
 -56245,
 608771698,
 65754,
 -56244,
 608881222,
 65753,
 -56243,
 608926111,
 65752,
 -56242,
 608980589,
 65751,
 -56241,
 609031184,
 65750,
 -1,
 609140392,
 65749,
 609297497,
 608603277,
 -1,
 -56238,
 609277188,
 65748,
 -56237,
 609327113,
 65747,
 -56236,
 609361522,
 65745,
 -56235,
 609471046,
 65744,
 -56234,
 609525436,
 65743,
 -56233,
 609584807,
 65742,
 -56232,
 609632313,
 65741,
 -1,
 609720294,
 65740,
 609887328,
 609242733,
 -1,
 -56229,
 609820274,
 65739,
 -56228,
 609913997,
 65738,
 -56227,
 609962570,
 65737,
 -56226,
 610014224,
 65736,
 -56225,
 610079149,
 65735,
 -1,
 610150006,
 65734,
 610402303,
 609817616,
 -1,
 -56222,
 610293573,
 65733,
 -1,
 610373879,
 65732,
 610598911,
 603346557,
 -1,
 610608259,
 610472976,
 -1,
 610673776,
 610582184,
 -1,
 -56217,
 610653444,
 65778,
 -56216,
 610703369,
 65777,
 -56215,
 610752642,
 65776,
 -56214,
 610803314,
 65775,
 -56213,
 610912838,
 65774,
 -56212,
 610962573,
 65773,
 -56211,
 611012205,
 65772,
 -56210,
 611062800,
 65771,
 -56209,
 611172008,
 65770,
 -1,
 611222094,
 65769,
 611394683,
 610632270,
 -1,
 -56206,
 611374340,
 65768,
 -56205,
 611424265,
 65767,
 -56204,
 611473538,
 65766,
 -56203,
 611524210,
 65765,
 -56202,
 611633734,
 65764,
 -56201,
 611683469,
 65763,
 -56200,
 611733101,
 65762,
 -56199,
 611783696,
 65761,
 -56198,
 611892904,
 65760,
 -1,
 611942990,
 65759,
 612115586,
 611324944,
 -1,
 -56195,
 612095236,
 65784,
 -56194,
 612145161,
 65783,
 -56193,
 612194434,
 65782,
 -56192,
 612245106,
 65781,
 -56191,
 612307984,
 65780,
 -1,
 612417192,
 65779,
 -1,
 612088156,
 65785,
 -56188,
 610573556,
 65786,
 -1,
 612568289,
 65758,
 612771054,
 603281009,
 -1,
 612836571,
 612716670,
 -1,
 612902033,
 612784258,
 -1,
 -56183,
 612845840,
 65572,
 -56182,
 612950696,
 65551,
 -56181,
 612962609,
 65608,
 -56180,
 613069673,
 65592,
 -56179,
 613094071,
 65597,
 -56178,
 613162136,
 65558,
 -56177,
 613257930,
 65567,
 -56176,
 613294585,
 65603,
 -1,
 613363839,
 65554,
 613557403,
 612878918,
 -1,
 -56173,
 613533400,
 65586,
 -56172,
 613568879,
 65585,
 -56171,
 613642719,
 65546,
 -56170,
 613703933,
 65565,
 -56169,
 613763430,
 65591,
 -56168,
 613811551,
 65578,
 -56167,
 613906956,
 65564,
 -56166,
 613941703,
 65545,
 -1,
 614020231,
 65570,
 614212773,
 613487632,
 -1,
 -56163,
 614143973,
 65606,
 -56162,
 614218491,
 65538,
 -56161,
 614298908,
 65577,
 -56160,
 614363809,
 65580,
 -56159,
 614405152,
 65600,
 -56158,
 614482472,
 65562,
 -56157,
 614541838,
 65560,
 -56156,
 614604517,
 65573,
 -1,
 614685873,
 65599,
 614868143,
 614171214,
 -1,
 -56153,
 614810674,
 65582,
 -56152,
 614873855,
 65536,
 -56151,
 614959886,
 65543,
 -56150,
 615006561,
 65561,
 -56149,
 615069731,
 65589,
 -56148,
 615170514,
 65587,
 -56147,
 615189696,
 65566,
 -56146,
 615287483,
 65579,
 -1,
 615317964,
 65541,
 615523512,
 614801010,
 -1,
 -56143,
 615499475,
 65590,
 -56142,
 615537670,
 65610,
 -56141,
 615637647,
 65553,
 -56140,
 615681429,
 65611,
 -56139,
 615740182,
 65550,
 -56138,
 615817566,
 65607,
 -56137,
 615888783,
 65539,
 -1,
 615922993,
 65576,
 616113345,
 615484557,
 -1,
 -56134,
 616077904,
 65605,
 -56133,
 616124588,
 65547,
 -56132,
 616201132,
 65542,
 -56131,
 616287545,
 65552,
 -56130,
 616315030,
 65601,
 -56129,
 616377298,
 65594,
 -56128,
 616441288,
 65583,
 -1,
 616548356,
 65593,
 616703178,
 616058477,
 -1,
 -56125,
 616675225,
 65568,
 -56124,
 616708867,
 65537,
 -56123,
 616811655,
 65588,
 -56122,
 616845505,
 65549,
 -56121,
 616900751,
 65609,
 -56120,
 616964918,
 65574,
 -56119,
 617031122,
 65581,
 -1,
 617132871,
 65563,
 617293011,
 616677032,
 -1,
 -56116,
 617264407,
 65596,
 -56115,
 617286705,
 65571,
 -56114,
 617401046,
 65559,
 -56113,
 617421565,
 65544,
 -56112,
 617490968,
 65557,
 -56111,
 617552938,
 65584,
 -56110,
 617650204,
 65569,
 -1,
 617718628,
 65540,
 617882840,
 617256969,
 -1,
 -56107,
 617822561,
 65612,
 -56106,
 617878528,
 65602,
 -56105,
 617956997,
 65555,
 -1,
 618018787,
 65556,
 618266623,
 617862404,
 -1,
 -56102,
 618174432,
 65613,
 -1,
 618247218,
 65604,
 618463231,
 612765236,
 -1,
 618472673,
 618371081,
 -1,
 -56098,
 618452228,
 65629,
 -56097,
 618471026,
 65628,
 -56096,
 618548845,
 65627,
 -1,
 618599440,
 65626,
 618800356,
 618405490,
 -1,
 -56093,
 618761357,
 65624,
 -1,
 618810989,
 65623,
 618996967,
 618761357,
 -1,
 -56090,
 618976516,
 65621,
 -1,
 619010178,
 65620,
 619193578,
 618970792,
 -1,
 -56087,
 619173124,
 65617,
 -1,
 619223049,
 65616,
 -56085,
 619172204,
 65625,
 -56084,
 619362649,
 65622,
 -56083,
 619421911,
 65619,
 -1,
 619484302,
 65618,
 619708415,
 612698172,
 -1,
 619717879,
 619626152,
 -1,
 619783411,
 619662957,
 -1,
 -56078,
 619723811,
 65689,
 -1,
 619782031,
 65688,
 619980022,
 619713552,
 -1,
 -56075,
 619913313,
 65684,
 -1,
 620007847,
 65683,
 -1,
 619921230,
 65700,
 -1,
 619695142,
 65746,
 620363775,
 603214889,
 -1,
 620373246,
 620275953,
 -1,
 620438781,
 620344743,
 -1,
 -56068,
 620394867,
 10771,
 -1,
 620433796,
 10770,
 -1,
 620385699,
 10772,
 -1,
 620346944,
 8232,
 620766554,
 603136596,
 -1,
 620832089,
 620707983,
 -1,
 620897576,
 620766565,
 -1,
 620963078,
 620865422,
 -1,
 -56060,
 620910252,
 6426,
 -56059,
 621001139,
 6425,
 -1,
 621019955,
 6427,
 621225224,
 620899364,
 6421,
 -1,
 621174056,
 6410,
 621356299,
 621208970,
 -1,
 -56054,
 621328819,
 6412,
 -1,
 621347635,
 6411,
 621552910,
 621336992,
 -1,
 -56051,
 621525427,
 6417,
 -1,
 621544243,
 6416,
 621749521,
 621501736,
 -1,
 -56048,
 621719187,
 6405,
 -1,
 621740851,
 6415,
 621946132,
 621711671,
 -1,
 -56045,
 621918643,
 6402,
 -1,
 621937459,
 6401,
 622142743,
 621892300,
 -1,
 -56042,
 622115251,
 6409,
 -1,
 622134067,
 6408,
 622339354,
 622102221,
 -1,
 -56039,
 622311859,
 6404,
 -1,
 622330675,
 6403,
 622535965,
 622311675,
 -1,
 -56036,
 622508467,
 6414,
 -1,
 622527283,
 6413,
 622732576,
 622492528,
 -1,
 -56033,
 622705075,
 6407,
 -1,
 622723891,
 6406,
 622929187,
 622673344,
 -1,
 -56030,
 622901683,
 6419,
 -1,
 622920499,
 6418,
 -56028,
 622889194,
 6424,
 -56027,
 623069609,
 6422,
 -56026,
 623120294,
 6420,
 -56025,
 623182590,
 6423,
 -1,
 623294899,
 6428,
 623453501,
 620865422,
 -1,
 623519028,
 623390270,
 -1,
 623584557,
 623467816,
 -1,
 -56020,
 623554195,
 6449,
 -1,
 623575859,
 6452,
 -56018,
 623534562,
 6451,
 -56017,
 623724969,
 6455,
 -56016,
 623791480,
 6453,
 -56015,
 623841190,
 6454,
 -56014,
 623903486,
 6456,
 -56013,
 624025551,
 6448,
 -1,
 624050376,
 6450,
 624239929,
 623483386,
 -1,
 -56010,
 624165965,
 6459,
 -56009,
 624286781,
 6457,
 -56008,
 624298457,
 6464,
 -1,
 624411037,
 6458,
 624623615,
 624204136,
 -1,
 -56005,
 624503844,
 6441,
 -56004,
 624593130,
 6443,
 -1,
 624642473,
 6442,
 624829769,
 623434448,
 -1,
 624895304,
 624764404,
 -1,
 624960834,
 624821043,
 6432,
 -55999,
 624899937,
 6438,
 -1,
 624957597,
 6436,
 625157444,
 624925944,
 6440,
 -1,
 625122552,
 6437,
 625288518,
 625085740,
 6439,
 -1,
 625216812,
 6435,
 -55993,
 625227617,
 6434,
 -1,
 625350813,
 6433,
 -1,
 624853403,
 6400,
 625616215,
 624812401,
 -1,
 625681741,
 625599882,
 -1,
 -55988,
 625641713,
 6472,
 -1,
 625707027,
 6473,
 625878352,
 625649550,
 -1,
 -55985,
 625853803,
 6476,
 -1,
 625883774,
 6477,
 626074963,
 625821767,
 -1,
 -55982,
 626037234,
 6474,
 -1,
 626075650,
 6475,
 -55980,
 626002275,
 6470,
 -55979,
 626241848,
 6471,
 -55978,
 626274870,
 6479,
 -1,
 626376906,
 6478,
 -55976,
 625587939,
 6469,
 -1,
 626516546,
 6468,
 -1,
 620795224,
 13007,
 626730394,
 620724227,
 -1,
 626795927,
 626664805,
 -1,
 626861418,
 626779530,
 -1,
 626926949,
 626834566,
 -1,
 626992484,
 626884550,
 -1,
 -55968,
 626942428,
 42232,
 -55967,
 626989853,
 42236,
 -55966,
 627089764,
 42237,
 -55965,
 627144991,
 42234,
 -1,
 627207794,
 42235,
 -1,
 626947557,
 42233,
 627451240,
 626894734,
 -1,
 -55961,
 627423667,
 42206,
 -1,
 627442483,
 42205,
 -55959,
 627423667,
 42197,
 -1,
 627573555,
 42196,
 627778925,
 626800481,
 42228,
 -55956,
 627753874,
 42230,
 -1,
 627772716,
 42229,
 627975536,
 627736523,
 -1,
 -55953,
 627947955,
 42211,
 -1,
 627966771,
 42212,
 628172147,
 627943310,
 -1,
 -55950,
 628144563,
 42219,
 -1,
 628163379,
 42210,
 628368758,
 628152736,
 -1,
 -55947,
 628341171,
 42194,
 -1,
 628359987,
 42193,
 628565368,
 628333816,
 42227,
 -1,
 628493612,
 42231,
 628696443,
 628514088,
 -1,
 -55942,
 628666003,
 42213,
 -1,
 628687667,
 42208,
 628893054,
 628658487,
 -1,
 -55939,
 628865459,
 42200,
 -1,
 628884275,
 42199,
 629089665,
 628867986,
 -1,
 -55936,
 629062067,
 42216,
 -1,
 629080883,
 42214,
 629286276,
 629049037,
 -1,
 -55933,
 629258675,
 42221,
 -1,
 629277491,
 42198,
 629482886,
 629214508,
 42224,
 -1,
 629421921,
 42225,
 629613961,
 629455099,
 -1,
 -55928,
 629583657,
 42204,
 -1,
 629605171,
 42195,
 629810572,
 629570416,
 -1,
 -55925,
 629782963,
 42203,
 -1,
 629801779,
 42202,
 630007182,
 629736243,
 42222,
 -1,
 629935404,
 42223,
 -55921,
 629943332,
 42220,
 -55920,
 630101677,
 42215,
 -55919,
 630163690,
 42218,
 -55918,
 630198182,
 42207,
 -55917,
 630260478,
 42209,
 -55916,
 630378998,
 42201,
 -55915,
 630397085,
 42226,
 -55914,
 630497535,
 42217,
 -1,
 630575617,
 42192,
 630783999,
 626746158,
 -1,
 -55911,
 630654487,
 42239,
 -1,
 630760951,
 42238,
 630924705,
 626677606,
 -1,
 630990240,
 630871081,
 -1,
 -55907,
 630924583,
 10072,
 -55906,
 631011087,
 9617,
 -55905,
 631095821,
 10099,
 -1,
 631123652,
 10098,
 -1,
 630927931,
 9735,
 -55902,
 630871024,
 8374,
 -55901,
 631333691,
 8356,
 -1,
 631421773,
 9806,
 631580442,
 603065644,
 -1,
 631645838,
 631546108,
 -1,
 631711264,
 631591977,
 -1,
 631776699,
 631678862,
 -1,
 631842227,
 631757918,
 91,
 631963647,
 631788585,
 -1,
 631973296,
 631879079,
 -1,
 632038830,
 631947605,
 -1,
 -55891,
 631995857,
 10637,
 -1,
 632051393,
 10639,
 -55889,
 631978396,
 10635,
 -1,
 632169887,
 8261,
 -55887,
 631947547,
 9121,
 -55886,
 632326123,
 9123,
 -1,
 632414211,
 9122,
 632563126,
 631773341,
 -1,
 -55883,
 632497532,
 8216,
 -1,
 632568728,
 11814,
 632759737,
 632491308,
 -1,
 -55880,
 632693824,
 9609,
 -1,
 632774426,
 8907,
 -55878,
 632709826,
 11778,
 -1,
 632900148,
 10181,
 633087438,
 631747847,
 -1,
 633152973,
 633070490,
 -1,
 633218500,
 633101990,
 8596,
 633339903,
 633164841,
 -1,
 633349571,
 633255335,
 -1,
 -55871,
 633306339,
 8697,
 -55870,
 633379077,
 8622,
 -1,
 633458091,
 8700,
 -1,
 633295942,
 10568,
 633677256,
 633168973,
 8660,
 633798655,
 633619743,
 -1,
 -55865,
 633699555,
 10500,
 -1,
 633772293,
 8654,
 633939403,
 633647941,
 -1,
 -55862,
 633917746,
 11012,
 -1,
 633967200,
 8621,
 -55860,
 633908599,
 8703,
 -1,
 634068867,
 11020,
 -1,
 633110336,
 11788,
 634332632,
 633058117,
 -1,
 634398167,
 634262427,
 -1,
 634463699,
 634354544,
 -1,
 -55854,
 634409158,
 10627,
 -1,
 634486748,
 12302,
 -55852,
 634437768,
 12312,
 -55851,
 634622777,
 12314,
 -55850,
 634659231,
 10629,
 -1,
 634745948,
 12310,
 -1,
 634364405,
 10712,
 634988001,
 634289008,
 -1,
 635053534,
 634933446,
 123,
 635174911,
 634999849,
 -1,
 -55844,
 635063547,
 9127,
 -55843,
 635164408,
 9128,
 -1,
 635186167,
 9129,
 -55841,
 635011036,
 12300,
 -55840,
 635338209,
 9948,
 -1,
 635430876,
 8968,
 635577837,
 634913587,
 -1,
 635643368,
 635526440,
 -1,
 635708901,
 635581650,
 12296,
 -1,
 635682676,
 10641,
 635895807,
 635674791,
 -1,
 -55833,
 635811964,
 10203,
 -1,
 635850612,
 10202,
 636092415,
 635614471,
 -1,
 636102124,
 635986533,
 -1,
 -55829,
 636066754,
 11056,
 -1,
 636095626,
 11058,
 -1,
 636072087,
 10643,
 636364278,
 635561354,
 -1,
 636429809,
 636335367,
 -1,
 -55824,
 636398858,
 10703,
 -1,
 636473338,
 11785,
 636626420,
 636406243,
 -1,
 -55821,
 636558781,
 9610,
 -1,
 636647115,
 9613,
 -55819,
 636606554,
 12308,
 -1,
 636752345,
 8867,
 636954113,
 636304832,
 -1,
 637019646,
 636889792,
 -1,
 637085179,
 636973418,
 -1,
 -55814,
 637024272,
 10574,
 -1,
 637098858,
 10570,
 637337599,
 637017092,
 -1,
 -55811,
 637220880,
 10571,
 -1,
 637295466,
 10576,
 637534207,
 636999001,
 -1,
 -55808,
 637452424,
 10647,
 -1,
 637498460,
 12304,
 637675016,
 636913661,
 -1,
 637740551,
 637650711,
 -1,
 -55804,
 637691678,
 10714,
 -55803,
 637771002,
 8220,
 -55802,
 637804959,
 11816,
 -1,
 637863004,
 12298,
 -1,
 637689319,
 11780,
 638133773,
 637608351,
 40,
 638255103,
 638080041,
 -1,
 -55797,
 638143739,
 9115,
 -55796,
 638200823,
 9117,
 -1,
 638312451,
 9116,
 638461458,
 638098680,
 -1,
 638526993,
 638396822,
 -1,
 -55792,
 638468580,
 9614,
 -1,
 638524062,
 9615,
 -1,
 638503250,
 10197,
 638789143,
 638404679,
 -1,
 638854678,
 638720157,
 -1,
 -55787,
 638811187,
 9611,
 -1,
 638892275,
 10620,
 -1,
 638786895,
 8970,
 639116826,
 638772244,
 -1,
 -55783,
 639047390,
 9144,
 -1,
 639126993,
 11808,
 639313437,
 639070333,
 -1,
 -55780,
 639264608,
 9612,
 -1,
 639332071,
 9686,
 -55778,
 639241209,
 8905,
 -55777,
 639471826,
 10204,
 -1,
 639520443,
 11804,
 639706752,
 631692800,
 -1,
 639772232,
 639655590,
 8592,
 639837767,
 639718441,
 -1,
 639903284,
 639808935,
 -1,
 639968812,
 639886730,
 -1,
 640034345,
 639913972,
 8610,
 640155647,
 639976735,
 -1,
 -55768,
 640056547,
 11065,
 -1,
 640142763,
 11066,
 640352255,
 639967039,
 -1,
 -55765,
 640240172,
 11025,
 -1,
 640289422,
 11024,
 640493103,
 639928317,
 -1,
 -55762,
 640425458,
 8698,
 -1,
 640517317,
 11064,
 -55760,
 640449763,
 8695,
 -55759,
 640653573,
 8602,
 -55758,
 640737472,
 10566,
 -55757,
 640752980,
 8619,
 -1,
 640833164,
 8617,
 641017405,
 639886730,
 -1,
 641082937,
 640955865,
 -1,
 641148472,
 641032725,
 8676,
 -1,
 641111752,
 8633,
 -1,
 641082017,
 10525,
 641400831,
 641029049,
 -1,
 -55749,
 641271727,
 11070,
 -55748,
 641370931,
 10618,
 -1,
 641406567,
 10615,
 641607236,
 641000611,
 -1,
 641672769,
 641532978,
 -1,
 -55744,
 641636960,
 11083,
 -1,
 641715491,
 11074,
 -55742,
 641636960,
 10611,
 -55741,
 641831554,
 10563,
 -1,
 641912099,
 11082,
 642065990,
 641544886,
 8612,
 -1,
 642039342,
 10527,
 -1,
 642016755,
 8646,
 -1,
 639794193,
 10521,
 642328156,
 639743360,
 -1,
 642393691,
 642291099,
 -1,
 642459220,
 642347156,
 -1,
 642524755,
 642405417,
 -1,
 642590289,
 642507939,
 -1,
 642655824,
 642567823,
 -1,
 -55729,
 642586433,
 10602,
 -1,
 642675127,
 10594,
 -1,
 642613255,
 10598,
 -55726,
 642526003,
 10578,
 -1,
 642855606,
 10586,
 -1,
 642482083,
 8636,
 643170303,
 642442398,
 -1,
 643180122,
 643060777,
 -1,
 -55721,
 643115827,
 10582,
 -55720,
 643183286,
 10590,
 -55719,
 643280231,
 10603,
 -1,
 643306219,
 10599,
 -1,
 643137443,
 8637,
 -1,
 642369129,
 8651,
 643638893,
 642311562,
 -1,
 643704426,
 643598577,
 -1,
 643769961,
 643660406,
 -1,
 643835496,
 643734166,
 -1,
 643901031,
 643806631,
 -1,
 643966565,
 643883433,
 11067,
 644087807,
 643908895,
 -1,
 -55708,
 643988707,
 11068,
 -1,
 644074923,
 11069,
 -55706,
 643923171,
 11060,
 -1,
 644205995,
 11061,
 -1,
 643838646,
 11062,
 -1,
 643762917,
 11063,
 -1,
 643742330,
 8606,
 644612095,
 643636506,
 -1,
 -55700,
 644516087,
 10510,
 -1,
 644570790,
 8666,
 644753016,
 643610875,
 -1,
 644818551,
 644727630,
 -1,
 644884086,
 644767398,
 8656,
 644949621,
 644830249,
 -1,
 645015156,
 644920743,
 -1,
 -55693,
 644971747,
 10498,
 -1,
 645044485,
 8653,
 -1,
 644952758,
 10502,
 -1,
 644906001,
 10523,
 -1,
 644843767,
 10508,
 -1,
 644795175,
 8672,
 645473915,
 644723525,
 -1,
 -55686,
 645452082,
 8678,
 -1,
 645501536,
 8604,
 -55684,
 645423652,
 8668,
 -55683,
 645606137,
 11077,
 -55682,
 645668404,
 8647,
 -55681,
 645770615,
 8701,
 -1,
 645799811,
 11013,
 646053887,
 639677576,
 -1,
 646063749,
 645971536,
 -1,
 -55677,
 645995515,
 8237,
 -55676,
 646079743,
 8206,
 -1,
 646122051,
 8234,
 646325897,
 646036305,
 -1,
 -55673,
 646266601,
 171,
 -55672,
 646335390,
 10748,
 -1,
 646382684,
 9001,
 646588044,
 646293390,
 -1,
 -55669,
 646552564,
 10553,
 -1,
 646620267,
 10154,
 646840319,
 646563134,
 4054,
 -1,
 646713372,
 4056,
 646915827,
 631607007,
 -1,
 646981317,
 646849893,
 -1,
 647046809,
 646964618,
 -1,
 647112340,
 647030154,
 -1,
 -55661,
 647084467,
 7246,
 -1,
 647103283,
 7245,
 647308951,
 647079822,
 -1,
 -55658,
 647281075,
 7192,
 -1,
 647299891,
 7191,
 -55656,
 647281075,
 7179,
 -1,
 647430963,
 7178,
 647636637,
 647027104,
 -1,
 -55653,
 647561982,
 7183,
 -55652,
 647674291,
 7184,
 -1,
 647693107,
 7182,
 647898785,
 647585064,
 -1,
 -55649,
 647834660,
 7177,
 -55648,
 647933587,
 7173,
 -1,
 647955251,
 7181,
 648160933,
 647860535,
 -1,
 -55645,
 648086270,
 7169,
 -55644,
 648198579,
 7170,
 -1,
 648217395,
 7168,
 648423081,
 648132859,
 -1,
 -55641,
 648392489,
 7193,
 -55640,
 648448016,
 7247,
 -1,
 648479539,
 7180,
 648685228,
 648390542,
 -1,
 -55637,
 648657331,
 7201,
 -1,
 648676147,
 7200,
 648881839,
 648618580,
 -1,
 -55634,
 648807166,
 7190,
 -1,
 648872755,
 7189,
 649078450,
 648856466,
 -1,
 -55631,
 649003774,
 7198,
 -1,
 649069363,
 7197,
 649275061,
 649037517,
 -1,
 -55628,
 649200382,
 7172,
 -1,
 649265971,
 7171,
 649471672,
 649218119,
 -1,
 -55625,
 649396990,
 7186,
 -1,
 649462579,
 7185,
 649668283,
 649427824,
 -1,
 -55622,
 649640371,
 7175,
 -1,
 649659187,
 7174,
 649864894,
 649608640,
 -1,
 -55619,
 649790206,
 7188,
 -1,
 649855795,
 7187,
 -55617,
 649800740,
 7194,
 -55616,
 650021098,
 7202,
 -55615,
 650083571,
 7199,
 -55614,
 650135977,
 7195,
 -55613,
 650183422,
 7196,
 -55612,
 650301942,
 7176,
 -1,
 650314547,
 7203,
 650520275,
 646963569,
 -1,
 650585801,
 650503562,
 -1,
 -55608,
 650545393,
 7234,
 -1,
 650610707,
 7235,
 650782412,
 650553230,
 -1,
 -55605,
 650757483,
 7238,
 -1,
 650787454,
 7239,
 650979023,
 650725447,
 -1,
 -55602,
 650940914,
 7236,
 -1,
 650979330,
 7237,
 -55600,
 650905955,
 7232,
 -55599,
 651145528,
 7233,
 -55598,
 651178550,
 7241,
 -1,
 651280586,
 7240,
 651437789,
 650479311,
 -1,
 651503318,
 651386152,
 7216,
 -1,
 651446047,
 7220,
 651634392,
 651465015,
 7213,
 -1,
 651613015,
 7221,
 -55591,
 651617674,
 7219,
 -55590,
 651736327,
 7218,
 -55589,
 651811232,
 7217,
 -55588,
 651829844,
 7214,
 -1,
 651939471,
 7215,
 652093157,
 651398197,
 -1,
 652158688,
 652031841,
 7210,
 -1,
 652097377,
 7211,
 652289762,
 652123384,
 7208,
 -1,
 652254456,
 7209,
 -55581,
 652220573,
 7207,
 -55580,
 652348716,
 7212,
 -1,
 652435941,
 7206,
 652617452,
 652043054,
 -1,
 652682986,
 652600714,
 -1,
 652748521,
 652648578,
 7231,
 -1,
 652700964,
 7230,
 -1,
 652684019,
 7227,
 -55573,
 652648044,
 7228,
 -1,
 652912857,
 7229,
 653131775,
 652584846,
 -1,
 653141744,
 653039976,
 -1,
 -55569,
 653077540,
 7204,
 -1,
 653150633,
 7205,
 653393919,
 653105658,
 -1,
 -55566,
 653289093,
 7222,
 -1,
 653333732,
 7223,
 653535001,
 646887553,
 -1,
 653600513,
 653499640,
 -1,
 653666048,
 653543899,
 -1,
 653731579,
 653627109,
 10877,
 653852671,
 653660330,
 -1,
 653862650,
 653747429,
 10881,
 -1,
 653836496,
 10883,
 -1,
 653801365,
 10879,
 654059262,
 653706132,
 -1,
 -55555,
 653991171,
 8818,
 -1,
 654083911,
 8804,
 -55553,
 654039976,
 8822,
 -1,
 654227617,
 10885,
 -1,
 653628533,
 8806,
 654452494,
 653525811,
 -1,
 654518027,
 654392053,
 -1,
 654583560,
 654485390,
 -1,
 654649095,
 654522376,
 -1,
 -55546,
 654579828,
 10893,
 -1,
 654644166,
 10895,
 -1,
 654593023,
 10899,
 -55543,
 654520853,
 10614,
 -55542,
 654892684,
 10897,
 -1,
 654924884,
 10891,
 655163391,
 654481910,
 -1,
 -55539,
 655048985,
 10887,
 -1,
 655155179,
 10889,
 655304466,
 654423463,
 -1,
 -55536,
 655269972,
 10875,
 -55535,
 655298618,
 8918,
 -1,
 655375614,
 10873,
 655566612,
 655278910,
 10918,
 -1,
 655500256,
 10920,
 655697687,
 655497486,
 -1,
 -55530,
 655629571,
 8934,
 -1,
 655722311,
 8808,
 -55528,
 655668617,
 60,
 -1,
 655865933,
 8922,
 -1,
 653499640,
 9804,
 656090966,
 631521913,
 -1,
 656156473,
 656070578,
 -1,
 656221983,
 656139658,
 66199,
 -55522,
 656205194,
 66200,
 -1,
 656262034,
 66185,
 656418593,
 656170280,
 66191,
 -1,
 656366888,
 66193,
 656549667,
 656351828,
 66190,
 -1,
 656482900,
 66192,
 656680741,
 656511287,
 66187,
 -1,
 656642359,
 66196,
 656811815,
 656608556,
 66177,
 -1,
 656760104,
 66202,
 656942889,
 656752064,
 66178,
 -1,
 656917394,
 66179,
 657073963,
 656868147,
 66176,
 -1,
 657022248,
 66201,
 -55508,
 657031115,
 66184,
 -55507,
 657131439,
 66204,
 -55506,
 657240901,
 66183,
 -55505,
 657274721,
 66194,
 -55504,
 657368974,
 66198,
 -55503,
 657437959,
 66197,
 -55502,
 657468733,
 66188,
 -55501,
 657578400,
 66195,
 -55500,
 657641103,
 66189,
 -55499,
 657674956,
 66186,
 -55498,
 657725597,
 66182,
 -55497,
 657834898,
 66203,
 -55496,
 657884877,
 66180,
 -1,
 657963259,
 66181,
 658178047,
 656122623,
 -1,
 658188117,
 658056549,
 -1,
 658253629,
 658171274,
 67887,
 -1,
 658236810,
 67892,
 658384703,
 658220942,
 67891,
 -1,
 658352014,
 67886,
 658515777,
 658332968,
 67883,
 -1,
 658464040,
 67896,
 658646851,
 658493071,
 67881,
 -1,
 658588281,
 67895,
 658777925,
 658574636,
 67876,
 -1,
 658726184,
 67894,
 658908999,
 658703155,
 67872,
 -1,
 658857256,
 67893,
 -55480,
 658850425,
 67879,
 -55479,
 658994376,
 67877,
 -55478,
 659044193,
 67888,
 -55477,
 659141895,
 67885,
 -55476,
 659172669,
 67890,
 -55475,
 659266808,
 67884,
 -55474,
 659300948,
 67882,
 -55473,
 659394871,
 67880,
 -55472,
 659429533,
 67878,
 -55471,
 659523277,
 67874,
 -55470,
 659572807,
 67889,
 -55469,
 659667195,
 67875,
 -55468,
 659716976,
 67897,
 -1,
 659766720,
 67873,
 -1,
 658168246,
 67903,
 660023207,
 656055544,
 -1,
 660088695,
 659993413,
 -1,
 660154227,
 660031830,
 -1,
 660219746,
 660119815,
 -1,
 660285277,
 660187022,
 -1,
 -55460,
 660259669,
 10065,
 -1,
 660323407,
 10558,
 -55458,
 660222058,
 9727,
 -55457,
 660416537,
 9694,
 -55456,
 660473341,
 9998,
 -55455,
 660538994,
 10063,
 -1,
 660640324,
 10195,
 660809574,
 660155117,
 -1,
 -55452,
 660746346,
 9722,
 -55451,
 660814429,
 10559,
 -1,
 660875289,
 9695,
 661071722,
 660782666,
 -1,
 -55448,
 661030384,
 9691,
 -55447,
 661070695,
 9697,
 -1,
 661151683,
 9604,
 661333869,
 661035019,
 -1,
 -55444,
 661265853,
 9606,
 -1,
 661354187,
 9603,
 661530480,
 661306502,
 -1,
 -55441,
 661471716,
 9602,
 -1,
 661527198,
 9601,
 -55439,
 661486482,
 9607,
 -55438,
 661697679,
 9605,
 -1,
 661733359,
 9987,
 661979135,
 660100137,
 -1,
 -55435,
 661900841,
 95,
 -55434,
 661932685,
 12319,
 -1,
 662012273,
 8270,
 662185871,
 660021513,
 -1,
 662251396,
 662132315,
 -1,
 662316927,
 662232576,
 -1,
 662382460,
 662266957,
 10232,
 -1,
 662340654,
 10237,
 662513534,
 662331046,
 10229,
 -1,
 662471726,
 10235,
 -1,
 662463012,
 11059,
 662765567,
 662262825,
 -1,
 662775683,
 662675719,
 -1,
 -55422,
 662725709,
 10234,
 -1,
 662789798,
 10231,
 -1,
 662747260,
 10206,
 663037836,
 662218345,
 -1,
 663103371,
 663019008,
 -1,
 663168904,
 663053389,
 10233,
 -1,
 663127086,
 10238,
 663299978,
 663117478,
 10230,
 -1,
 663258158,
 10236,
 -1,
 663249444,
 10239,
 -1,
 663033706,
 10205,
 663617535,
 663009531,
 -1,
 -55410,
 663488015,
 10188,
 -1,
 663565558,
 10982,
 663758757,
 662126568,
 -1,
 663824283,
 663693033,
 8744,
 663945215,
 663770153,
 -1,
 663955354,
 663860647,
 -1,
 664020888,
 663914493,
 -1,
 664086423,
 663996183,
 -1,
 -55402,
 664025500,
 10851,
 -1,
 664124665,
 10850,
 -1,
 664043081,
 10834,
 -55399,
 663995367,
 10843,
 -1,
 664276996,
 10845,
 -1,
 663882554,
 10841,
 664600575,
 663802707,
 8743,
 664666111,
 664487199,
 -1,
 664676258,
 664569853,
 -1,
 664741793,
 664651543,
 -1,
 -55392,
 664680860,
 10848,
 -1,
 664780025,
 10846,
 -1,
 664698441,
 10833,
 -55389,
 664615324,
 10847,
 -55388,
 664978407,
 10842,
 -1,
 664997892,
 10844,
 665255935,
 663695262,
 9674,
 -1,
 665170159,
 10208,
 -1,
 659979907,
 8468,
 665399015,
 509414700,
 -1,
 665463887,
 665357560,
 -1,
 665528362,
 665387827,
 -1,
 665593859,
 665485902,
 -1,
 665659323,
 665554061,
 -1,
 665724847,
 665635398,
 77877,
 -1,
 665649971,
 77878,
 665855921,
 665669229,
 77874,
 -1,
 665781043,
 77875,
 665986995,
 665785360,
 77872,
 -1,
 665912115,
 77873,
 666118069,
 665944654,
 77869,
 -1,
 666043187,
 77870,
 -55370,
 666096900,
 77882,
 -55369,
 666212361,
 77881,
 -55368,
 666261634,
 77880,
 -55367,
 666312306,
 77879,
 -55366,
 666406029,
 77876,
 -1,
 666484392,
 77871,
 666642376,
 665632424,
 -1,
 666707902,
 666589314,
 77844,
 -1,
 666633011,
 77845,
 666838976,
 666668173,
 77840,
 -1,
 666764083,
 77841,
 -55359,
 666817796,
 77847,
 -55358,
 666933257,
 77846,
 -55357,
 666967666,
 77843,
 -55356,
 667077190,
 77842,
 -55355,
 667111021,
 77839,
 -55354,
 667161616,
 77838,
 -55353,
 667270824,
 77837,
 -1,
 667320910,
 77836,
 667494357,
 666600014,
 -1,
 667559884,
 667426418,
 77830,
 -55349,
 667499968,
 77832,
 -1,
 667550515,
 77831,
 667756494,
 667535942,
 77828,
 -1,
 667681587,
 77829,
 -55345,
 667735300,
 77835,
 -55344,
 667850761,
 77834,
 -55343,
 667900034,
 77833,
 -55342,
 667978893,
 77827,
 -55341,
 668028525,
 77826,
 -55340,
 668079120,
 77825,
 -1,
 668188328,
 77824,
 668346337,
 667438701,
 -1,
 668411864,
 668275728,
 77860,
 -1,
 668336947,
 77861,
 -55335,
 668390660,
 77868,
 -55334,
 668506121,
 77867,
 -55333,
 668555394,
 77866,
 -55332,
 668606066,
 77865,
 -55331,
 668715590,
 77864,
 -55330,
 668765325,
 77863,
 -55329,
 668814957,
 77862,
 -55328,
 668909224,
 77859,
 -1,
 668959310,
 77858,
 669132780,
 668278386,
 -1,
 -55325,
 669111556,
 77902,
 -55324,
 669161481,
 77901,
 -55323,
 669210754,
 77900,
 -55322,
 669261426,
 77899,
 -55321,
 669370950,
 77898,
 -55320,
 669420685,
 77897,
 -55319,
 669470317,
 77896,
 -55318,
 669520912,
 77895,
 -55317,
 669630120,
 77894,
 -1,
 669680206,
 77893,
 669853687,
 669108806,
 -1,
 -55314,
 669832452,
 77892,
 -55313,
 669882377,
 77891,
 -55312,
 669931650,
 77890,
 -55311,
 669982322,
 77889,
 -55310,
 670091846,
 77888,
 -55309,
 670141581,
 77887,
 -55308,
 670191213,
 77886,
 -55307,
 670241808,
 77885,
 -55306,
 670351016,
 77884,
 -1,
 670401102,
 77883,
 670574594,
 669783056,
 -1,
 -55303,
 670553348,
 77857,
 -55302,
 670603273,
 77856,
 -55301,
 670652546,
 77855,
 -55300,
 670703218,
 77854,
 -55299,
 670812742,
 77853,
 -55298,
 670862477,
 77852,
 -55297,
 670912109,
 77851,
 -55296,
 670962704,
 77850,
 -55295,
 671071912,
 77849,
 -1,
 671121998,
 77848,
 -1,
 670523593,
 77903,
 671416319,
 665554034,
 -1,
 671426576,
 671318606,
 -1,
 671492104,
 671373442,
 78867,
 -55289,
 671432128,
 78869,
 -1,
 671482675,
 78868,
 -55287,
 671470852,
 78871,
 -55286,
 671651849,
 78870,
 -55285,
 671686258,
 78866,
 -55284,
 671795782,
 78865,
 -55283,
 671845517,
 78864,
 -55282,
 671895149,
 78863,
 -55281,
 671945744,
 78862,
 -1,
 672054952,
 78861,
 672213019,
 671355920,
 -1,
 -55278,
 672191748,
 78891,
 -55277,
 672241673,
 78890,
 -55276,
 672290946,
 78889,
 -55275,
 672341618,
 78888,
 -55274,
 672451142,
 78887,
 -55273,
 672500877,
 78886,
 -55272,
 672550509,
 78885,
 -55271,
 672601104,
 78884,
 -55270,
 672710312,
 78883,
 -1,
 672760398,
 78882,
 672933926,
 672186024,
 -1,
 -55267,
 672912644,
 78881,
 -55266,
 672962569,
 78880,
 -55265,
 673011842,
 78879,
 -55264,
 673062514,
 78878,
 -55263,
 673172038,
 78877,
 -55262,
 673221773,
 78876,
 -55261,
 673271405,
 78875,
 -55260,
 673322000,
 78874,
 -55259,
 673431208,
 78873,
 -1,
 673481294,
 78872,
 673710079,
 672878189,
 -1,
 -55256,
 673584144,
 78894,
 -55255,
 673693352,
 78893,
 -1,
 673743438,
 78892,
 673917081,
 665476392,
 -1,
 673982562,
 673874510,
 -1,
 674048059,
 673926765,
 -1,
 674113583,
 673994882,
 78361,
 -1,
 674038579,
 78362,
 674244657,
 674089542,
 78358,
 -1,
 674169651,
 78359,
 674375731,
 674204813,
 78356,
 -1,
 674300723,
 78357,
 674506805,
 674319981,
 78354,
 -1,
 674431795,
 78355,
 -55242,
 674485508,
 78364,
 -55241,
 674600969,
 78363,
 -55240,
 674635378,
 78360,
 -55239,
 674698256,
 78353,
 -55238,
 674807464,
 78352,
 -1,
 674857550,
 78351,
 675031112,
 674021032,
 -1,
 675096639,
 674994185,
 78336,
 -55234,
 675036608,
 78338,
 -1,
 675087155,
 78337,
 -55232,
 675075332,
 78339,
 -55231,
 675240066,
 78335,
 -55230,
 675290738,
 78334,
 -55229,
 675400262,
 78333,
 -55228,
 675449997,
 78332,
 -55227,
 675499629,
 78331,
 -55226,
 675550224,
 78330,
 -55225,
 675659432,
 78329,
 -1,
 675709518,
 78328,
 675883092,
 674960400,
 -1,
 675948619,
 675859014,
 78345,
 -1,
 675873587,
 78346,
 -55220,
 675927300,
 78350,
 -55219,
 676042761,
 78349,
 -55218,
 676092034,
 78348,
 -55217,
 676142706,
 78347,
 -55216,
 676236429,
 78344,
 -55215,
 676286061,
 78343,
 -55214,
 676336656,
 78342,
 -55213,
 676445864,
 78341,
 -1,
 676495950,
 78340,
 676669534,
 675840590,
 -1,
 -55210,
 676648196,
 78327,
 -55209,
 676698121,
 78326,
 -55208,
 676747394,
 78325,
 -55207,
 676798066,
 78324,
 -55206,
 676907590,
 78323,
 -55205,
 676957325,
 78322,
 -55204,
 677006957,
 78321,
 -55203,
 677057552,
 78320,
 -1,
 677166760,
 78319,
 677380095,
 676629645,
 -1,
 -55200,
 677254160,
 78367,
 -55199,
 677363368,
 78366,
 -1,
 677413454,
 78365,
 677587072,
 673935257,
 -1,
 677652593,
 677559976,
 -1,
 677718118,
 677615625,
 78409,
 -1,
 677643059,
 78410,
 677849192,
 677691048,
 78401,
 -1,
 677774131,
 78402,
 677980266,
 677806670,
 78399,
 -1,
 677905203,
 78400,
 -55189,
 677958916,
 78411,
 -55188,
 678058114,
 78408,
 -55187,
 678108786,
 78407,
 -55186,
 678218310,
 78406,
 -55185,
 678268045,
 78405,
 -55184,
 678317677,
 78404,
 -1,
 678368272,
 78403,
 678570107,
 677610062,
 -1,
 -55181,
 678548740,
 78398,
 -55180,
 678598665,
 78397,
 -55179,
 678647938,
 78396,
 -55178,
 678698610,
 78395,
 -55177,
 678808134,
 78394,
 -55176,
 678857869,
 78393,
 -55175,
 678907501,
 78392,
 -55174,
 678958096,
 78391,
 -1,
 679067304,
 78390,
 679280639,
 678499344,
 -1,
 679291006,
 679154704,
 78414,
 -1,
 679215923,
 78415,
 -55169,
 679263912,
 78413,
 -1,
 679379534,
 78412,
 679608319,
 677512057,
 -1,
 679618701,
 679526056,
 -1,
 679684228,
 679565442,
 78385,
 -1,
 679609139,
 78386,
 -55163,
 679662852,
 78388,
 -55162,
 679778313,
 78387,
 -55161,
 679812722,
 78384,
 -55160,
 679922246,
 78383,
 -55159,
 679971981,
 78382,
 -55158,
 680021613,
 78381,
 -55157,
 680072208,
 78380,
 -55156,
 680181416,
 78379,
 -1,
 680231502,
 78378,
 680405144,
 679576142,
 -1,
 680470672,
 680380998,
 78372,
 -1,
 680395571,
 78373,
 -55151,
 680449284,
 78377,
 -55150,
 680564745,
 78376,
 -55149,
 680614018,
 78375,
 -55148,
 680664690,
 78374,
 -55147,
 680758413,
 78371,
 -55146,
 680808045,
 78370,
 -55145,
 680858640,
 78369,
 -1,
 680967848,
 78368,
 -1,
 680367240,
 78389,
 681191677,
 673876188,
 -1,
 681257136,
 681167430,
 -1,
 681322661,
 681214542,
 77997,
 -55139,
 681253021,
 78006,
 -55138,
 681362322,
 78005,
 -55137,
 681412301,
 78004,
 -55136,
 681461831,
 78003,
 -55135,
 681512236,
 78002,
 -55134,
 681621755,
 78001,
 -55133,
 681671536,
 78000,
 -55132,
 681721280,
 77999,
 -1,
 681771827,
 77998,
 681978023,
 681282701,
 78011,
 -1,
 681902899,
 78012,
 682109097,
 681907216,
 78008,
 -1,
 682033971,
 78009,
 -55126,
 682087684,
 78017,
 -55125,
 682203145,
 78016,
 -55124,
 682252418,
 78015,
 -55123,
 682303090,
 78014,
 -55122,
 682412614,
 78013,
 -55121,
 682446445,
 78010,
 -1,
 682540712,
 78007,
 682698945,
 681188978,
 -1,
 682764474,
 682645634,
 78025,
 -55117,
 682738578,
 78033,
 -55116,
 682788557,
 78032,
 -55115,
 682838087,
 78031,
 -55114,
 682888492,
 78030,
 -55113,
 682998011,
 78029,
 -55112,
 683047792,
 78028,
 -55111,
 683097536,
 78027,
 -1,
 683148083,
 78026,
 -55109,
 682696306,
 78024,
 -55108,
 683330118,
 78023,
 -55107,
 683379853,
 78022,
 -55106,
 683429485,
 78021,
 -55105,
 683480080,
 78020,
 -55104,
 683589288,
 78019,
 -1,
 683639374,
 78018,
 683813070,
 682658957,
 -1,
 683878596,
 683776009,
 77994,
 -1,
 683803443,
 77995,
 684009670,
 683810418,
 77991,
 -1,
 683934515,
 77992,
 -55097,
 683988228,
 77996,
 -55096,
 684087426,
 77993,
 -55095,
 684182086,
 77990,
 -55094,
 684231821,
 77989,
 -55093,
 684281453,
 77988,
 -55092,
 684332048,
 77987,
 -55091,
 684441256,
 77986,
 -1,
 684491342,
 77985,
 684665051,
 683757165,
 -1,
 684730577,
 684625037,
 77978,
 -1,
 684655411,
 77979,
 684861651,
 684703400,
 77974,
 -1,
 684786483,
 77975,
 -55084,
 684840196,
 77984,
 -55083,
 684955657,
 77983,
 -55082,
 685004930,
 77982,
 -55081,
 685055602,
 77981,
 -55080,
 685165126,
 77980,
 -55079,
 685198957,
 77977,
 -55078,
 685249552,
 77976,
 -1,
 685343310,
 77973,
 685517031,
 684594192,
 -1,
 685582558,
 685463682,
 77969,
 -1,
 685507379,
 77970,
 -55073,
 685561092,
 77972,
 -55072,
 685676553,
 77971,
 -55071,
 685710962,
 77968,
 -55070,
 685820486,
 77967,
 -55069,
 685870221,
 77966,
 -55068,
 685919853,
 77965,
 -55067,
 685970448,
 77964,
 -55066,
 686079656,
 77963,
 -1,
 686129742,
 77962,
 686303474,
 685489832,
 -1,
 -55063,
 686281988,
 77961,
 -55062,
 686331913,
 77960,
 -55061,
 686381186,
 77959,
 -55060,
 686431858,
 77958,
 -55059,
 686541382,
 77957,
 -55058,
 686591117,
 77956,
 -55057,
 686640749,
 77955,
 -55056,
 686691344,
 77954,
 -55055,
 686800552,
 77953,
 -1,
 686850638,
 77952,
 687079423,
 686260814,
 -1,
 687089909,
 686987273,
 77949,
 -1,
 687014707,
 77950,
 -55050,
 687068420,
 77951,
 -55049,
 687167618,
 77948,
 -55048,
 687218290,
 77947,
 -55047,
 687327814,
 77946,
 -55046,
 687377549,
 77945,
 -55045,
 687427181,
 77944,
 -55044,
 687477776,
 77943,
 -1,
 687586984,
 77942,
 687745359,
 681147616,
 -1,
 687810840,
 687674384,
 -1,
 687876364,
 687768142,
 78726,
 -55039,
 687853199,
 78738,
 -55038,
 687903031,
 78737,
 -55037,
 687952588,
 78736,
 -55036,
 688003229,
 78735,
 -55035,
 688112530,
 78734,
 -55034,
 688162509,
 78733,
 -55033,
 688212039,
 78732,
 -55032,
 688262444,
 78731,
 -55031,
 688371963,
 78730,
 -55030,
 688421744,
 78729,
 -55029,
 688471488,
 78728,
 -1,
 688522035,
 78727,
 688728334,
 687854852,
 78749,
 -1,
 688653107,
 78750,
 688859408,
 688691209,
 78747,
 -1,
 688784179,
 78748,
 688990482,
 688803437,
 78741,
 -1,
 688915251,
 78742,
 -55021,
 688937090,
 78746,
 -55020,
 689053298,
 78745,
 -55019,
 689162822,
 78744,
 -55018,
 689212557,
 78743,
 -55017,
 689247248,
 78740,
 -1,
 689356456,
 78739,
 689514798,
 687768142,
 -1,
 689580323,
 689487528,
 78690,
 -55013,
 689510557,
 78699,
 -55012,
 689619858,
 78698,
 -55011,
 689669837,
 78697,
 -55010,
 689719367,
 78696,
 -55009,
 689769772,
 78695,
 -55008,
 689879291,
 78694,
 -55007,
 689929072,
 78693,
 -55006,
 689978816,
 78692,
 -1,
 690029363,
 78691,
 690235686,
 689526914,
 78706,
 -55003,
 690175424,
 78708,
 -1,
 690225971,
 78707,
 690432296,
 690164752,
 78700,
 -1,
 690357043,
 78701,
 -54999,
 690410756,
 78710,
 -54998,
 690526217,
 78709,
 -54997,
 690560626,
 78705,
 -54996,
 690670150,
 78704,
 -54995,
 690719885,
 78703,
 -1,
 690769517,
 78702,
 690956606,
 689487528,
 -1,
 691022131,
 690929320,
 78712,
 -54991,
 690977648,
 78715,
 -54990,
 691027392,
 78714,
 -1,
 691077939,
 78713,
 691284278,
 690951184,
 78716,
 -54987,
 691224000,
 78718,
 -1,
 691274547,
 78717,
 -54985,
 691262724,
 78725,
 -54984,
 691443721,
 78724,
 -54983,
 691492994,
 78723,
 -54982,
 691543666,
 78722,
 -54981,
 691653190,
 78721,
 -54980,
 691702925,
 78720,
 -54979,
 691752557,
 78719,
 -1,
 691831374,
 78711,
 692005197,
 690900589,
 -1,
 692070721,
 691951746,
 78761,
 -1,
 691995443,
 78762,
 692201795,
 692014701,
 78756,
 -1,
 692126515,
 78757,
 692332869,
 692174504,
 78753,
 -1,
 692257587,
 78754,
 692463943,
 692290126,
 78751,
 -1,
 692388659,
 78752,
 -54968,
 692442372,
 78764,
 -54967,
 692557833,
 78763,
 -54966,
 692592242,
 78760,
 -54965,
 692701766,
 78759,
 -54964,
 692751501,
 78758,
 -1,
 692786192,
 78755,
 693043199,
 691973528,
 78765,
 -1,
 692912947,
 78766,
 693119393,
 687678953,
 -1,
 693184866,
 693076558,
 -1,
 693250392,
 693116530,
 78423,
 -54957,
 693192775,
 78429,
 -54956,
 693243180,
 78428,
 -54955,
 693352699,
 78427,
 -54954,
 693402480,
 78426,
 -54953,
 693452224,
 78425,
 -1,
 693502771,
 78424,
 693709146,
 693226054,
 78421,
 -1,
 693633843,
 78422,
 693840220,
 693681832,
 78416,
 -1,
 693764915,
 78417,
 -54947,
 693818628,
 78432,
 -54946,
 693934089,
 78431,
 -54945,
 693983362,
 78430,
 -54944,
 694062221,
 78420,
 -54943,
 694111853,
 78419,
 -1,
 694162448,
 78418,
 694364531,
 693128813,
 -1,
 694430056,
 694296178,
 78469,
 -54939,
 694401275,
 78473,
 -54938,
 694451056,
 78472,
 -54937,
 694500800,
 78471,
 -1,
 694551347,
 78470,
 694757738,
 694373997,
 78465,
 -1,
 694682419,
 78466,
 694888812,
 694714958,
 78461,
 -1,
 694813491,
 78462,
 -54931,
 694867204,
 78476,
 -54930,
 694982665,
 78475,
 -54929,
 695031938,
 78474,
 -54928,
 695126598,
 78468,
 -54927,
 695176333,
 78467,
 -54926,
 695211024,
 78464,
 -1,
 695320232,
 78463,
 695478658,
 694293520,
 -1,
 695544182,
 695457028,
 78459,
 -1,
 695468851,
 78460,
 695675256,
 695519814,
 78454,
 -1,
 695599923,
 78455,
 695806330,
 695635085,
 78452,
 -1,
 695730995,
 78453,
 695937404,
 695763534,
 78447,
 -1,
 695862067,
 78448,
 -54915,
 695900169,
 78458,
 -54914,
 696014978,
 78457,
 -54913,
 696065650,
 78456,
 -54912,
 696143469,
 78451,
 -54911,
 696194064,
 78450,
 -1,
 696303272,
 78449,
 696461713,
 695451304,
 -1,
 696527239,
 696418894,
 78433,
 -54907,
 696482672,
 78436,
 -54906,
 696532416,
 78435,
 -1,
 696582963,
 78434,
 696789385,
 696505604,
 78445,
 -1,
 696714035,
 78446,
 -54902,
 696752137,
 78444,
 -54901,
 696866946,
 78443,
 -54900,
 696917618,
 78442,
 -54899,
 697027142,
 78441,
 -54898,
 697076877,
 78440,
 -54897,
 697126509,
 78439,
 -54896,
 697177104,
 78438,
 -1,
 697286312,
 78437,
 697444764,
 696421517,
 -1,
 -54893,
 697423108,
 78486,
 -54892,
 697473033,
 78485,
 -54891,
 697522306,
 78484,
 -54890,
 697572978,
 78483,
 -54889,
 697682502,
 78482,
 -54888,
 697732237,
 78481,
 -54887,
 697781869,
 78480,
 -54886,
 697832464,
 78479,
 -54885,
 697941672,
 78478,
 -1,
 697991758,
 78477,
 698220543,
 697420358,
 -1,
 698231200,
 698122830,
 78487,
 -54881,
 698170816,
 78489,
 -1,
 698221363,
 78488,
 -1,
 698203816,
 78490,
 698493417,
 693047081,
 -1,
 698558905,
 698465960,
 -1,
 698624428,
 698487824,
 78268,
 -54875,
 698598290,
 78276,
 -54874,
 698648269,
 78275,
 -54873,
 698697799,
 78274,
 -54872,
 698748204,
 78273,
 -54871,
 698857723,
 78272,
 -54870,
 698907504,
 78271,
 -54869,
 698957248,
 78270,
 -1,
 699007795,
 78269,
 699214254,
 698570882,
 78283,
 -1,
 699138867,
 78284,
 699345328,
 699145842,
 78281,
 -1,
 699269939,
 78282,
 699476402,
 699320902,
 78279,
 -1,
 699401011,
 78280,
 699607476,
 699433550,
 78265,
 -1,
 699532083,
 78266,
 -54859,
 699585796,
 78286,
 -54858,
 699701257,
 78285,
 -54857,
 699763853,
 78278,
 -54856,
 699813485,
 78277,
 -1,
 699907752,
 78267,
 700066247,
 698502765,
 -1,
 700131773,
 700010093,
 78304,
 -54852,
 700071360,
 78306,
 -1,
 700121907,
 78305,
 700328383,
 700104360,
 78301,
 -1,
 700252979,
 78302,
 -54848,
 700306692,
 78312,
 -54847,
 700422153,
 78311,
 -54846,
 700471426,
 78310,
 -54845,
 700522098,
 78309,
 -54844,
 700631622,
 78308,
 -54843,
 700681357,
 78307,
 -54842,
 700716048,
 78303,
 -1,
 700809806,
 78300,
 700983765,
 699995152,
 -1,
 701049290,
 700946441,
 78297,
 -1,
 700973875,
 78298,
 701180364,
 701009037,
 78292,
 -1,
 701104947,
 78293,
 701311438,
 701109264,
 78289,
 -1,
 701236019,
 78290,
 -54833,
 701289732,
 78299,
 -54832,
 701388930,
 78296,
 -54831,
 701439602,
 78295,
 -54830,
 701549126,
 78294,
 -54829,
 701582957,
 78291,
 -54828,
 701677224,
 78288,
 -1,
 701727310,
 78287,
 701901282,
 700940878,
 -1,
 701966809,
 701873832,
 78253,
 -54824,
 701906368,
 78255,
 -1,
 701956915,
 78254,
 702163419,
 701910637,
 78257,
 -1,
 702087987,
 78258,
 -54820,
 702141700,
 78264,
 -54819,
 702257161,
 78263,
 -54818,
 702306434,
 78262,
 -54817,
 702357106,
 78261,
 -54816,
 702466630,
 78260,
 -54815,
 702516365,
 78259,
 -1,
 702551056,
 78256,
 702808063,
 701861005,
 -1,
 702818789,
 702710350,
 78313,
 -1,
 702743347,
 78314,
 -54810,
 702778509,
 78318,
 -54809,
 702893677,
 78317,
 -54808,
 702944272,
 78316,
 -1,
 703053480,
 78315,
 703212081,
 698458502,
 -1,
 703277560,
 703171725,
 -1,
 703343085,
 703223938,
 78132,
 -1,
 703267635,
 78133,
 703474159,
 703274610,
 78130,
 -1,
 703398707,
 78131,
 703605233,
 703449670,
 78128,
 -1,
 703529779,
 78129,
 -54798,
 703583492,
 78135,
 -54797,
 703698953,
 78134,
 -54796,
 703761549,
 78127,
 -54795,
 703811181,
 78126,
 -54794,
 703861776,
 78125,
 -54793,
 703970984,
 78124,
 -1,
 704021070,
 78123,
 704195078,
 703221357,
 -1,
 704260603,
 704157705,
 78120,
 -1,
 704185139,
 78121,
 704391677,
 704206978,
 78118,
 -1,
 704316211,
 78119,
 704522751,
 704364200,
 78111,
 -1,
 704447283,
 78112,
 -54784,
 704500996,
 78122,
 -54783,
 704585330,
 78117,
 -54782,
 704694854,
 78116,
 -54781,
 704744589,
 78115,
 -54780,
 704794221,
 78114,
 -54779,
 704844816,
 78113,
 -1,
 704938574,
 78110,
 705112594,
 704123920,
 -1,
 705178121,
 705085096,
 78100,
 -1,
 705102643,
 78101,
 -54774,
 705156356,
 78109,
 -54773,
 705271817,
 78108,
 -54772,
 705321090,
 78107,
 -54771,
 705371762,
 78106,
 -54770,
 705481286,
 78105,
 -54769,
 705531021,
 78104,
 -54768,
 705580653,
 78103,
 -54767,
 705631248,
 78102,
 -1,
 705725006,
 78099,
 705899038,
 705085096,
 -1,
 705964565,
 705842797,
 78091,
 -1,
 705889075,
 78092,
 -54762,
 705942788,
 78098,
 -54761,
 706058249,
 78097,
 -54760,
 706107522,
 78096,
 -54759,
 706158194,
 78095,
 -54758,
 706267718,
 78094,
 -54757,
 706317453,
 78093,
 -54756,
 706352144,
 78090,
 -54755,
 706461352,
 78089,
 -1,
 706511438,
 78088,
 706685481,
 705856078,
 -1,
 706751009,
 706657960,
 78078,
 -1,
 706675507,
 78079,
 -54750,
 706729220,
 78087,
 -54749,
 706844681,
 78086,
 -54748,
 706893954,
 78085,
 -54747,
 706944626,
 78084,
 -54746,
 707054150,
 78083,
 -54745,
 707103885,
 78082,
 -54744,
 707153517,
 78081,
 -1,
 707204112,
 78080,
 707461119,
 706660934,
 -1,
 707471918,
 707378856,
 78137,
 -54740,
 707427184,
 78140,
 -54739,
 707476928,
 78139,
 -1,
 707527475,
 78138,
 -54737,
 707415661,
 78142,
 -54736,
 707662864,
 78141,
 -1,
 707756622,
 78136,
 707930744,
 703180375,
 -1,
 707996223,
 707890317,
 -1,
 708061749,
 707971654,
 78196,
 -1,
 707986227,
 78197,
 708192823,
 708005485,
 78193,
 -1,
 708117299,
 78194,
 -54728,
 708171012,
 78201,
 -54727,
 708286473,
 78200,
 -54726,
 708335746,
 78199,
 -54725,
 708386418,
 78198,
 -54724,
 708480141,
 78195,
 -54723,
 708514832,
 78192,
 -54722,
 708624040,
 78191,
 -1,
 708674126,
 78190,
 708848204,
 707939949,
 -1,
 708913730,
 708794498,
 78186,
 -1,
 708838195,
 78187,
 709044804,
 708845170,
 78184,
 -1,
 708969267,
 78185,
 -54715,
 709022980,
 78189,
 -54714,
 709138441,
 78188,
 -54713,
 709216838,
 78183,
 -54712,
 709266573,
 78182,
 -54711,
 709316205,
 78181,
 -54710,
 709366800,
 78180,
 -54709,
 709476008,
 78179,
 -1,
 709526094,
 78178,
 709700185,
 708776976,
 -1,
 709765711,
 709631602,
 78173,
 -1,
 709690163,
 78174,
 709896785,
 709722702,
 78166,
 -1,
 709821235,
 78167,
 -54702,
 709874948,
 78177,
 -54701,
 709990409,
 78176,
 -54700,
 710039682,
 78175,
 -54699,
 710134342,
 78172,
 -54698,
 710184077,
 78171,
 -54697,
 710233709,
 78170,
 -54696,
 710284304,
 78169,
 -1,
 710393512,
 78168,
 710552166,
 709657166,
 -1,
 710617693,
 710498434,
 78150,
 -54692,
 710557120,
 78152,
 -1,
 710607667,
 78151,
 710814303,
 710549106,
 78148,
 -1,
 710738739,
 78149,
 -54688,
 710792452,
 78154,
 -54687,
 710907913,
 78153,
 -54686,
 710986310,
 78147,
 -54685,
 711036045,
 78146,
 -54684,
 711085677,
 78145,
 -54683,
 711136272,
 78144,
 -1,
 711245480,
 78143,
 711404146,
 710524584,
 -1,
 711469673,
 711376552,
 78156,
 -1,
 711394099,
 78157,
 -54678,
 711447812,
 78165,
 -54677,
 711563273,
 78164,
 -54676,
 711612546,
 78163,
 -54675,
 711663218,
 78162,
 -54674,
 711772742,
 78161,
 -54673,
 711822477,
 78160,
 -54672,
 711872109,
 78159,
 -54671,
 711922704,
 78158,
 -1,
 712016462,
 78155,
 712245247,
 711379526,
 -1,
 -54668,
 712150157,
 78206,
 -54667,
 712199789,
 78205,
 -54666,
 712250384,
 78204,
 -54665,
 712359592,
 78203,
 -1,
 712409678,
 78202,
 712583860,
 707876364,
 -1,
 712649351,
 712556200,
 -1,
 712714877,
 712608909,
 78560,
 -54660,
 712654272,
 78562,
 -1,
 712704819,
 78561,
 712911487,
 712661122,
 78565,
 -1,
 712835891,
 78566,
 -54656,
 712889604,
 78568,
 -54655,
 713005065,
 78567,
 -54654,
 713039474,
 78564,
 -54653,
 713148998,
 78563,
 -54652,
 713182829,
 78559,
 -54651,
 713233424,
 78558,
 -54650,
 713342632,
 78557,
 -1,
 713392718,
 78556,
 713566868,
 712578064,
 -1,
 713632395,
 713498226,
 78575,
 -54646,
 713571776,
 78577,
 -1,
 713622323,
 78576,
 -54644,
 713610500,
 78580,
 -54643,
 713791497,
 78579,
 -54642,
 713840770,
 78578,
 -54641,
 713935430,
 78574,
 -54640,
 713985165,
 78573,
 -54639,
 714034797,
 78572,
 -54638,
 714085392,
 78571,
 -54637,
 714194600,
 78570,
 -1,
 714244686,
 78569,
 714418848,
 713510509,
 -1,
 714484375,
 714394182,
 78586,
 -1,
 714408755,
 78587,
 -54632,
 714462468,
 78591,
 -54631,
 714577929,
 78590,
 -54630,
 714627202,
 78589,
 -54629,
 714677874,
 78588,
 -54628,
 714771597,
 78585,
 -54627,
 714821229,
 78584,
 -54626,
 714871824,
 78583,
 -54625,
 714981032,
 78582,
 -1,
 715031118,
 78581,
 715205292,
 714375758,
 -1,
 715270819,
 715136626,
 78551,
 -1,
 715195187,
 78552,
 715401893,
 715199504,
 78546,
 -1,
 715326259,
 78547,
 -54618,
 715379972,
 78555,
 -54617,
 715495433,
 78554,
 -54616,
 715544706,
 78553,
 -54615,
 715639366,
 78550,
 -54614,
 715689101,
 78549,
 -54613,
 715738733,
 78548,
 -1,
 715833000,
 78545,
 716046335,
 715164813,
 -1,
 -54610,
 715923058,
 78598,
 -54609,
 716032582,
 78597,
 -54608,
 716082317,
 78596,
 -54607,
 716131949,
 78595,
 -54606,
 716182544,
 78594,
 -54605,
 716291752,
 78593,
 -1,
 716341838,
 78592,
 716516073,
 712535961,
 -1,
 716581570,
 716444688,
 -1,
 716647096,
 716559620,
 78674,
 -1,
 716571443,
 78675,
 716778170,
 716590701,
 78667,
 -1,
 716702515,
 78668,
 -54597,
 716740617,
 78673,
 -54596,
 716855426,
 78672,
 -54595,
 716906098,
 78671,
 -54594,
 717015622,
 78670,
 -54593,
 717065357,
 78669,
 -54592,
 717100048,
 78666,
 -54591,
 717209256,
 78665,
 -1,
 717259342,
 78664,
 717433550,
 716525165,
 -1,
 717499077,
 717362192,
 78678,
 -1,
 717423411,
 78679,
 -54586,
 717477124,
 78686,
 -54585,
 717592585,
 78685,
 -54584,
 717641858,
 78684,
 -54583,
 717692530,
 78683,
 -54582,
 717802054,
 78682,
 -54581,
 717851789,
 78681,
 -54580,
 717901421,
 78680,
 -54579,
 717995688,
 78677,
 -1,
 718045774,
 78676,
 718219994,
 717390414,
 -1,
 718285522,
 718151282,
 78648,
 -54575,
 718224832,
 78650,
 -1,
 718275379,
 78649,
 -54573,
 718263556,
 78653,
 -54572,
 718444553,
 78652,
 -54571,
 718493826,
 78651,
 -54570,
 718588486,
 78647,
 -54569,
 718638221,
 78646,
 -54568,
 718687853,
 78645,
 -54567,
 718738448,
 78644,
 -1,
 718847656,
 78643,
 719006437,
 718192296,
 -1,
 -54564,
 718984452,
 78663,
 -54563,
 719034377,
 78662,
 -54562,
 719083650,
 78661,
 -54561,
 719134322,
 78660,
 -54560,
 719243846,
 78659,
 -54559,
 719293581,
 78658,
 -54558,
 719343213,
 78657,
 -54557,
 719393808,
 78656,
 -54556,
 719503016,
 78655,
 -1,
 719553102,
 78654,
 719781887,
 718965901,
 -1,
 -54553,
 719655952,
 78689,
 -54552,
 719765160,
 78688,
 -1,
 719815246,
 78687,
 719989530,
 716464649,
 -1,
 720055032,
 719946318,
 -1,
 720120557,
 720033028,
 78610,
 -1,
 720044851,
 78611,
 720251631,
 720082953,
 78608,
 -1,
 720175923,
 78609,
 720382705,
 720197762,
 78606,
 -1,
 720306995,
 78607,
 720513779,
 720326253,
 78601,
 -1,
 720438067,
 78602,
 -54540,
 720445042,
 78605,
 -54539,
 720620102,
 78604,
 -54538,
 720669837,
 78603,
 -54537,
 720704528,
 78600,
 -1,
 720813736,
 78599,
 720972549,
 720027304,
 -1,
 721038075,
 720903794,
 78619,
 -1,
 720962355,
 78620,
 721169149,
 721010344,
 78613,
 -1,
 721093427,
 78614,
 -54530,
 721147140,
 78623,
 -54529,
 721262601,
 78622,
 -54528,
 721311874,
 78621,
 -54527,
 721406534,
 78618,
 -54526,
 721456269,
 78617,
 -54525,
 721505901,
 78616,
 -54524,
 721556496,
 78615,
 -1,
 721650254,
 78612,
 721824528,
 720901136,
 -1,
 -54521,
 721802500,
 78633,
 -54520,
 721852425,
 78632,
 -54519,
 721901698,
 78631,
 -54518,
 721952370,
 78630,
 -54517,
 722061894,
 78629,
 -54516,
 722111629,
 78628,
 -54515,
 722161261,
 78627,
 -54514,
 722211856,
 78626,
 -54513,
 722321064,
 78625,
 -1,
 722371150,
 78624,
 722599935,
 721768045,
 -1,
 722610963,
 722488941,
 78638,
 -1,
 722535219,
 78639,
 722742037,
 722539536,
 78636,
 -1,
 722666291,
 78637,
 -54506,
 722673266,
 78642,
 -54505,
 722848326,
 78641,
 -54504,
 722898061,
 78640,
 -54503,
 722976424,
 78635,
 -1,
 723026510,
 78634,
 723200843,
 719951270,
 -1,
 723266344,
 723129360,
 -1,
 723331870,
 723228681,
 78066,
 -1,
 723256115,
 78067,
 723462944,
 723288654,
 78057,
 -1,
 723387187,
 78058,
 -54495,
 723440900,
 78068,
 -54494,
 723540098,
 78065,
 -54493,
 723590770,
 78064,
 -54492,
 723700294,
 78063,
 -54491,
 723750029,
 78062,
 -54490,
 723799661,
 78061,
 -54489,
 723850256,
 78060,
 -1,
 723959464,
 78059,
 724118325,
 723238568,
 -1,
 724183851,
 724064386,
 78053,
 -1,
 724108083,
 78054,
 724314925,
 724115058,
 78051,
 -1,
 724239155,
 78052,
 -54482,
 724292868,
 78056,
 -54481,
 724408329,
 78055,
 -54480,
 724486726,
 78050,
 -54479,
 724536461,
 78049,
 -54478,
 724586093,
 78048,
 -54477,
 724636688,
 78047,
 -54476,
 724745896,
 78046,
 -1,
 724795982,
 78045,
 724970305,
 724075086,
 -1,
 725035832,
 724948228,
 78043,
 -1,
 724960051,
 78044,
 725166906,
 724998153,
 78041,
 -1,
 725091123,
 78042,
 -54469,
 725112962,
 78040,
 -54468,
 725229170,
 78039,
 -54467,
 725338694,
 78038,
 -54466,
 725388429,
 78037,
 -54465,
 725438061,
 78036,
 -54464,
 725488656,
 78035,
 -1,
 725597864,
 78034,
 725811199,
 724913773,
 -1,
 725822276,
 725716109,
 78073,
 -1,
 725746483,
 78074,
 -54459,
 725784585,
 78077,
 -54458,
 725899394,
 78076,
 -54457,
 725950066,
 78075,
 -54456,
 726027885,
 78072,
 -54455,
 726078480,
 78071,
 -54454,
 726187688,
 78070,
 -1,
 726237774,
 78069,
 726412151,
 723169022,
 -1,
 726477669,
 726384296,
 -1,
 726543191,
 726452806,
 78842,
 -54449,
 726472861,
 78851,
 -54448,
 726582162,
 78850,
 -54447,
 726632141,
 78849,
 -54446,
 726681671,
 78848,
 -54445,
 726732076,
 78847,
 -54444,
 726841595,
 78846,
 -54443,
 726891376,
 78845,
 -54442,
 726941120,
 78844,
 -1,
 726991667,
 78843,
 727198560,
 726474354,
 78852,
 -54439,
 727171986,
 78860,
 -54438,
 727221965,
 78859,
 -54437,
 727271495,
 78858,
 -54436,
 727321900,
 78857,
 -54435,
 727431419,
 78856,
 -54434,
 727481200,
 78855,
 -54433,
 727530944,
 78854,
 -1,
 727581491,
 78853,
 -54431,
 727157901,
 78841,
 -54430,
 727731821,
 78840,
 -54429,
 727782416,
 78839,
 -54428,
 727891624,
 78838,
 -1,
 727941710,
 78837,
 728170495,
 726434382,
 -1,
 728181611,
 728044560,
 78821,
 -54424,
 728152315,
 78825,
 -54423,
 728202096,
 78824,
 -54422,
 728251840,
 78823,
 -1,
 728302387,
 78822,
 728509294,
 728125037,
 78826,
 -54419,
 728448448,
 78828,
 -1,
 728498995,
 78827,
 728705904,
 728484422,
 78831,
 -1,
 728630067,
 78832,
 728836978,
 728665229,
 78829,
 -1,
 728761139,
 78830,
 -54413,
 728814852,
 78836,
 -54412,
 728930313,
 78835,
 -54411,
 728979586,
 78834,
 -54410,
 729030258,
 78833,
 -1,
 729136808,
 78820,
 729295773,
 726354363,
 -1,
 729361285,
 729267880,
 -1,
 729426811,
 729292402,
 78530,
 -1,
 729350963,
 78531,
 729557885,
 729383502,
 78523,
 -1,
 729482035,
 78524,
 -54402,
 729535748,
 78534,
 -54401,
 729651209,
 78533,
 -54400,
 729700482,
 78532,
 -54399,
 729795142,
 78529,
 -54398,
 729844877,
 78528,
 -54397,
 729894509,
 78527,
 -54396,
 729945104,
 78526,
 -1,
 730054312,
 78525,
 730213266,
 729317966,
 -1,
 730278793,
 730156653,
 78514,
 -54392,
 730217920,
 78516,
 -1,
 730268467,
 78515,
 730475403,
 730207248,
 78512,
 -1,
 730399539,
 78513,
 -54388,
 730453252,
 78522,
 -54387,
 730568713,
 78521,
 -54386,
 730617986,
 78520,
 -54385,
 730668658,
 78519,
 -54384,
 730778182,
 78518,
 -54383,
 730827917,
 78517,
 -1,
 730906280,
 78511,
 731119615,
 730141712,
 -1,
 -54380,
 731043076,
 78544,
 -54379,
 731093001,
 78543,
 -54378,
 731142274,
 78542,
 -54377,
 731192946,
 78541,
 -54376,
 731302470,
 78540,
 -54375,
 731352205,
 78539,
 -54374,
 731401837,
 78538,
 -54373,
 731452432,
 78537,
 -54372,
 731561640,
 78536,
 -1,
 731611726,
 78535,
 731786177,
 729254318,
 -1,
 731851693,
 731758248,
 -1,
 731917217,
 731813897,
 78789,
 -1,
 731841331,
 78790,
 732048291,
 731863170,
 78787,
 -1,
 731972403,
 78788,
 732179365,
 732007565,
 78783,
 -1,
 732103475,
 78784,
 732310439,
 732136014,
 78778,
 -1,
 732234547,
 78779,
 -54360,
 732288260,
 78791,
 -54359,
 732372594,
 78786,
 -54358,
 732482118,
 78785,
 -54357,
 732515949,
 78782,
 -54356,
 732566544,
 78781,
 -1,
 732675752,
 78780,
 732834745,
 731808334,
 -1,
 732900272,
 732812548,
 78776,
 -1,
 732824371,
 78777,
 733031346,
 732843629,
 78769,
 -1,
 732955443,
 78770,
 -54349,
 732993545,
 78775,
 -54348,
 733108354,
 78774,
 -54347,
 733159026,
 78773,
 -54346,
 733268550,
 78772,
 -54345,
 733318285,
 78771,
 -54344,
 733352976,
 78768,
 -1,
 733462184,
 78767,
 733675519,
 732763152,
 -1,
 733686716,
 733580429,
 78796,
 -1,
 733610803,
 78797,
 -54339,
 733661766,
 78798,
 -54338,
 733761133,
 78795,
 -54337,
 733811728,
 78794,
 -54336,
 733920936,
 78793,
 -1,
 733971022,
 78792,
 734145505,
 731741218,
 -1,
 734211023,
 734102094,
 -1,
 734276551,
 734139408,
 77915,
 -54331,
 734231408,
 77918,
 -54330,
 734281152,
 77917,
 -1,
 734331699,
 77916,
 -54328,
 734254340,
 77925,
 -54327,
 734500873,
 77924,
 -54326,
 734550146,
 77923,
 -54325,
 734600818,
 77922,
 -54324,
 734710342,
 77921,
 -54323,
 734760077,
 77920,
 -54322,
 734809709,
 77919,
 -1,
 734903976,
 77914,
 735063003,
 734183080,
 -1,
 735128530,
 735019598,
 77926,
 -1,
 735052595,
 77927,
 -54317,
 735106308,
 77936,
 -54316,
 735221769,
 77935,
 -54315,
 735271042,
 77934,
 -54314,
 735321714,
 77933,
 -54313,
 735431238,
 77932,
 -54312,
 735480973,
 77931,
 -54311,
 735530605,
 77930,
 -54310,
 735581200,
 77929,
 -1,
 735690408,
 77928,
 735903743,
 734991376,
 -1,
 -54307,
 735808653,
 77941,
 -54306,
 735858285,
 77940,
 -54305,
 735908880,
 77939,
 -54304,
 736018088,
 77938,
 -1,
 736068174,
 77937,
 736242679,
 734119249,
 -1,
 736308206,
 736199246,
 -1,
 736373733,
 736285956,
 78225,
 -1,
 736297779,
 78226,
 736504807,
 736348742,
 78220,
 -1,
 736428851,
 78221,
 -54296,
 736466953,
 78224,
 -54295,
 736581762,
 78223,
 -54294,
 736632434,
 78222,
 -54293,
 736726157,
 78219,
 -54292,
 736775789,
 78218,
 -54291,
 736826384,
 78217,
 -1,
 736935592,
 78216,
 737148927,
 736280232,
 -1,
 737160177,
 737066664,
 78229,
 -1,
 737084211,
 78230,
 737291251,
 737116750,
 78227,
 -1,
 737215283,
 78228,
 -54284,
 737266246,
 78234,
 -54283,
 737381517,
 78233,
 -54282,
 737431149,
 78232,
 -1,
 737481744,
 78231,
 737684487,
 736178805,
 -1,
 737750020,
 737641038,
 -1,
 737815547,
 737693293,
 78494,
 -1,
 737739571,
 78495,
 737946621,
 737787560,
 78491,
 -1,
 737870643,
 78492,
 -54274,
 737924356,
 78501,
 -54273,
 738039817,
 78500,
 -54272,
 738089090,
 78499,
 -54271,
 738139762,
 78498,
 -54270,
 738249286,
 78497,
 -54269,
 738299021,
 78496,
 -1,
 738333712,
 78493,
 738590719,
 737722024,
 -1,
 -54266,
 738508456,
 78503,
 -1,
 738558542,
 78502,
 738733076,
 737632645,
 -1,
 738798603,
 738692237,
 78802,
 -54262,
 738737600,
 78804,
 -1,
 738788147,
 78803,
 738995213,
 738760713,
 78809,
 -1,
 738919219,
 78810,
 739126287,
 738926194,
 78806,
 -1,
 739050291,
 78807,
 -54256,
 739072130,
 78808,
 -54255,
 739232326,
 78805,
 -54254,
 739266157,
 78801,
 -54253,
 739316752,
 78800,
 -1,
 739425960,
 78799,
 739585055,
 738671545,
 -1,
 739650583,
 739516018,
 78249,
 -1,
 739574579,
 78250,
 739781657,
 739578896,
 78244,
 -1,
 739705651,
 78245,
 -54246,
 739743753,
 78252,
 -54245,
 739858562,
 78251,
 -54244,
 739953222,
 78248,
 -54243,
 740002957,
 78247,
 -54242,
 740052589,
 78246,
 -1,
 740146856,
 78243,
 740305962,
 739539826,
 -1,
 740371490,
 740280902,
 77908,
 -1,
 740295475,
 77909,
 -54237,
 740349188,
 77913,
 -54236,
 740464649,
 77912,
 -54235,
 740513922,
 77911,
 -54234,
 740564594,
 77910,
 -54233,
 740658317,
 77907,
 -54232,
 740707949,
 77906,
 -54231,
 740758544,
 77905,
 -1,
 740867752,
 77904,
 741026868,
 740259486,
 -1,
 741092397,
 740998824,
 78811,
 -1,
 741016371,
 78812,
 -54226,
 741054473,
 78819,
 -54225,
 741169282,
 78818,
 -54224,
 741219954,
 78817,
 -54223,
 741329478,
 78816,
 -54222,
 741379213,
 78815,
 -54221,
 741428845,
 78814,
 -1,
 741479440,
 78813,
 741682238,
 740978581,
 -1,
 741747767,
 741613170,
 78212,
 -1,
 741671731,
 78213,
 -54216,
 741709833,
 78215,
 -54215,
 741824642,
 78214,
 -54214,
 741919302,
 78211,
 -54213,
 741969037,
 78210,
 -54212,
 742018669,
 78209,
 -54211,
 742069264,
 78208,
 -1,
 742178472,
 78207,
 742337607,
 741615906,
 -1,
 -54208,
 742299657,
 78242,
 -54207,
 742348930,
 78241,
 -54206,
 742399602,
 78240,
 -54205,
 742509126,
 78239,
 -54204,
 742558861,
 78238,
 -54203,
 742608493,
 78237,
 -54202,
 742659088,
 78236,
 -1,
 742768296,
 78235,
 742981631,
 742268618,
 -1,
 -54199,
 742873218,
 78510,
 -54198,
 742923890,
 78509,
 -54197,
 743033414,
 78508,
 -54196,
 743083149,
 78507,
 -54195,
 743132781,
 78506,
 -54194,
 743183376,
 78505,
 -1,
 743292584,
 78504,
 743452263,
 665428262,
 -1,
 743517747,
 743417742,
 -1,
 743583280,
 743458237,
 -1,
 743648385,
 743540429,
 -1,
 743713889,
 743605965,
 -1,
 743779418,
 743682885,
 -1,
 743844951,
 743705900,
 11670,
 -1,
 743771436,
 11669,
 743976025,
 743768883,
 11667,
 -1,
 743899955,
 4895,
 -1,
 743905437,
 11668,
 744172636,
 743705900,
 4893,
 -1,
 744099116,
 4892,
 744303710,
 744096563,
 4888,
 -1,
 744227635,
 4891,
 -54177,
 744240993,
 4889,
 -54176,
 744398072,
 4894,
 -1,
 744429725,
 4890,
 744631403,
 743656603,
 -1,
 744696932,
 744594680,
 4774,
 -1,
 744620851,
 11658,
 744828006,
 744623404,
 4773,
 -1,
 744754476,
 4772,
 744959080,
 744751923,
 4768,
 -1,
 744882995,
 4771,
 -54167,
 744917226,
 4775,
 -54166,
 745027425,
 4769,
 -1,
 745085085,
 4770,
 745286771,
 744571513,
 -1,
 745352302,
 745213228,
 11741,
 -1,
 745278764,
 11740,
 745483376,
 745276211,
 11736,
 -1,
 745407283,
 11739,
 -54159,
 745420641,
 11737,
 -54158,
 745577720,
 11742,
 -1,
 745609373,
 11738,
 745811065,
 745255749,
 -1,
 745876598,
 745737516,
 4885,
 -1,
 745803052,
 4884,
 746007672,
 745800499,
 4880,
 -1,
 745931571,
 4883,
 -1,
 745937053,
 4882,
 746204283,
 745774328,
 4878,
 -1,
 746128179,
 4879,
 746335357,
 746130732,
 4877,
 -1,
 746261804,
 4876,
 746466431,
 746259251,
 4872,
 -1,
 746390323,
 4875,
 -54144,
 746403681,
 4873,
 -1,
 746526877,
 4874,
 746728619,
 743614350,
 -1,
 746794124,
 746701714,
 -1,
 746859653,
 746757368,
 4670,
 -1,
 746783539,
 11652,
 746990727,
 746786092,
 4669,
 -1,
 746917164,
 4668,
 747121801,
 746914611,
 4664,
 -1,
 747045683,
 4667,
 -54134,
 747079914,
 4671,
 -54133,
 747190113,
 4665,
 -1,
 747247773,
 4666,
 747449493,
 746749899,
 -1,
 747515023,
 747375916,
 4645,
 -1,
 747441452,
 4644,
 747646097,
 747438899,
 4640,
 -1,
 747569971,
 4643,
 -54126,
 747604202,
 4647,
 -54125,
 747714401,
 4641,
 -54124,
 747805944,
 4646,
 -1,
 747837597,
 4642,
 748039325,
 747415438,
 -1,
 748104856,
 747965740,
 11685,
 -1,
 748031276,
 11684,
 748235930,
 748028723,
 11680,
 -1,
 748159795,
 11683,
 -54117,
 748173153,
 11681,
 -54116,
 748330232,
 11686,
 -1,
 748361885,
 11682,
 748563620,
 747965740,
 4661,
 748629155,
 748520655,
 -1,
 -54112,
 748558618,
 5004,
 -54111,
 748642239,
 4992,
 -54110,
 748692929,
 5000,
 -1,
 748763176,
 4996,
 -1,
 748555564,
 4660,
 749022374,
 748526840,
 4662,
 -1,
 748946227,
 11651,
 749153448,
 748946227,
 4656,
 -1,
 749077299,
 4659,
 -54103,
 749111530,
 4663,
 -54102,
 749221729,
 4657,
 -1,
 749279389,
 4658,
 749481169,
 746710410,
 -1,
 749546678,
 749454226,
 -1,
 749612207,
 749509880,
 4902,
 -1,
 749536051,
 11663,
 749743281,
 749538604,
 4901,
 -1,
 749669676,
 4900,
 749874355,
 749667123,
 4896,
 -1,
 749798195,
 4899,
 -54092,
 749832426,
 4903,
 -54091,
 749942625,
 4897,
 -1,
 750000285,
 4898,
 750202047,
 749502411,
 -1,
 750267577,
 750165240,
 4934,
 -1,
 750191411,
 4935,
 750398651,
 750193964,
 4933,
 -1,
 750325036,
 4932,
 750529725,
 750322483,
 4928,
 -1,
 750453555,
 4931,
 -54082,
 750466913,
 4929,
 -1,
 750590109,
 4930,
 750791880,
 750167950,
 -1,
 750857410,
 750718252,
 4925,
 -1,
 750783788,
 4924,
 750988484,
 750781235,
 4920,
 -1,
 750912307,
 4923,
 -54075,
 750946538,
 4927,
 -54074,
 751056737,
 4921,
 -54073,
 751148280,
 4926,
 -1,
 751179933,
 4922,
 751381706,
 750755064,
 4726,
 -1,
 751305523,
 11654,
 751512780,
 751308076,
 4725,
 -1,
 751439148,
 4724,
 751643854,
 751436595,
 4720,
 -1,
 751567667,
 4723,
 -54065,
 751601898,
 4727,
 -54064,
 751712097,
 4721,
 -1,
 751769757,
 4722,
 751971574,
 749415741,
 -1,
 752037088,
 751944594,
 -1,
 752102617,
 752005957,
 -1,
 752168150,
 752028972,
 4701,
 -1,
 752094508,
 4700,
 752299224,
 752091955,
 4696,
 -1,
 752223027,
 4699,
 -1,
 752228509,
 4698,
 752495835,
 752028972,
 4693,
 -1,
 752422188,
 4692,
 752626909,
 752419635,
 4688,
 -1,
 752550707,
 4691,
 -54050,
 752564065,
 4689,
 -54049,
 752721144,
 4694,
 -1,
 752752797,
 4690,
 752954600,
 751977081,
 -1,
 753020131,
 752880940,
 11717,
 -1,
 752946476,
 11716,
 753151205,
 752943923,
 11712,
 -1,
 753074995,
 11715,
 -54042,
 753088353,
 11713,
 -54041,
 753245432,
 11718,
 -1,
 753277085,
 11714,
 753478894,
 752923461,
 -1,
 753544427,
 753405228,
 4685,
 -1,
 753470764,
 4684,
 753675501,
 753468211,
 4680,
 -1,
 753599283,
 4683,
 -1,
 753604765,
 4682,
 753872112,
 753442040,
 4678,
 -1,
 753795891,
 4679,
 754003186,
 753798444,
 4677,
 -1,
 753929516,
 4676,
 754134260,
 753926963,
 4672,
 -1,
 754058035,
 4675,
 -54027,
 754071393,
 4673,
 -1,
 754194589,
 4674,
 754396443,
 751931703,
 -1,
 754461957,
 754321327,
 -1,
 754527486,
 754430789,
 -1,
 754593019,
 754453804,
 4805,
 -1,
 754519340,
 4804,
 754724093,
 754516787,
 4800,
 -1,
 754647859,
 4803,
 -1,
 754653341,
 4802,
 754920704,
 754453804,
 4797,
 -1,
 754847020,
 4796,
 755051778,
 754844467,
 4792,
 -1,
 754975539,
 4795,
 -54013,
 754988897,
 4793,
 -54012,
 755145976,
 4798,
 -1,
 755177629,
 4794,
 755379469,
 754401913,
 -1,
 755445000,
 755305772,
 11725,
 -1,
 755371308,
 11724,
 755576074,
 755368755,
 11720,
 -1,
 755499827,
 11723,
 -54005,
 755513185,
 11721,
 -54004,
 755670264,
 11726,
 -1,
 755701917,
 11722,
 755903763,
 755348293,
 -1,
 755969296,
 755830060,
 4789,
 -1,
 755895596,
 4788,
 756100370,
 755893043,
 4784,
 -1,
 756024115,
 4787,
 -1,
 756029597,
 4786,
 756296981,
 755866872,
 4782,
 -1,
 756220723,
 4783,
 756428055,
 756223276,
 4781,
 -1,
 756354348,
 4780,
 756559129,
 756351795,
 4776,
 -1,
 756482867,
 4779,
 -53990,
 756496225,
 4777,
 -1,
 756619421,
 4778,
 756821311,
 754350960,
 -1,
 756886828,
 756775792,
 -1,
 756952357,
 756859794,
 -1,
 757017888,
 756878636,
 11709,
 -1,
 756944172,
 11708,
 757148962,
 756941619,
 11704,
 -1,
 757072691,
 11707,
 -53981,
 757086049,
 11705,
 -53980,
 757243128,
 11710,
 -1,
 757274781,
 11706,
 757476647,
 756878636,
 11693,
 -1,
 757402924,
 11692,
 757607721,
 757400371,
 11688,
 -1,
 757531443,
 11691,
 -53974,
 757544801,
 11689,
 -53973,
 757701880,
 11694,
 -1,
 757733533,
 11690,
 757935414,
 756859794,
 -1,
 758000943,
 757898488,
 4910,
 -1,
 757924659,
 11664,
 758132017,
 757927212,
 4909,
 -1,
 758058284,
 4908,
 758263091,
 758055731,
 4904,
 -1,
 758186803,
 4907,
 -53964,
 758221034,
 4911,
 -53963,
 758331233,
 4905,
 -1,
 758388893,
 4906,
 758590776,
 757898488,
 4734,
 -1,
 758514483,
 11655,
 758721850,
 758517036,
 4733,
 -1,
 758648108,
 4732,
 758852924,
 758645555,
 4728,
 -1,
 758776627,
 4731,
 -53955,
 758810858,
 4735,
 -53954,
 758921057,
 4729,
 -1,
 758978717,
 4730,
 759180639,
 756799904,
 -1,
 759246162,
 759153554,
 -1,
 759311691,
 759169843,
 4912,
 759377226,
 759238502,
 -1,
 759442757,
 759303468,
 4821,
 -1,
 759369004,
 4820,
 759573831,
 759366451,
 4816,
 -1,
 759497523,
 4819,
 -53944,
 759510881,
 4817,
 -53943,
 759667960,
 4822,
 -1,
 759699613,
 4818,
 -1,
 759300915,
 4915,
 759967053,
 759274744,
 4918,
 -1,
 759890739,
 11665,
 760098127,
 759893292,
 4917,
 -1,
 760024364,
 4916,
 -53936,
 760056042,
 4919,
 -53935,
 760166241,
 4913,
 -1,
 760223901,
 4914,
 760425815,
 759214917,
 -1,
 760491349,
 760352044,
 5007,
 -1,
 760417580,
 5006,
 -53930,
 760420509,
 5005,
 -1,
 760546099,
 4951,
 760753497,
 760388856,
 4950,
 -1,
 760677171,
 11666,
 760884571,
 760679724,
 4949,
 -1,
 760810796,
 4948,
 761015645,
 760808243,
 4944,
 -1,
 760939315,
 4947,
 -53922,
 760952673,
 4945,
 -1,
 761075869,
 4946,
 761277818,
 759136203,
 -1,
 761343337,
 761250706,
 -1,
 761408867,
 761269548,
 4837,
 -1,
 761335084,
 4836,
 761539941,
 761332531,
 4832,
 -1,
 761463603,
 4835,
 -53914,
 761497834,
 4839,
 -53913,
 761608033,
 4833,
 -53912,
 761699576,
 4838,
 -1,
 761731229,
 4834,
 761933169,
 761298891,
 -1,
 761998700,
 761859372,
 11701,
 -1,
 761924908,
 11700,
 762129774,
 761922355,
 11696,
 -1,
 762053427,
 11699,
 -53905,
 762066785,
 11697,
 -53904,
 762223864,
 11702,
 -1,
 762255517,
 11698,
 762457459,
 761896184,
 4830,
 -1,
 762381107,
 11659,
 762588533,
 762383660,
 4829,
 -1,
 762514732,
 4828,
 762719607,
 762512179,
 4824,
 -1,
 762643251,
 4827,
 -53896,
 762677482,
 4831,
 -53895,
 762787681,
 4825,
 -1,
 762845341,
 4826,
 763047313,
 761202607,
 -1,
 763112835,
 762987129,
 -1,
 763178366,
 763039020,
 11733,
 -1,
 763104556,
 11732,
 763309440,
 763102003,
 11728,
 -1,
 763233075,
 11731,
 -53887,
 763246433,
 11729,
 -53886,
 763403512,
 11734,
 -1,
 763435165,
 11730,
 763637129,
 763081541,
 -1,
 763702662,
 763563308,
 4749,
 -1,
 763628844,
 4748,
 763833736,
 763626291,
 4744,
 -1,
 763757363,
 4747,
 -1,
 763762845,
 4746,
 764030347,
 763600120,
 4742,
 -1,
 763953971,
 4743,
 764161421,
 763956524,
 4741,
 -1,
 764087596,
 4740,
 764292495,
 764085043,
 4736,
 -1,
 764216115,
 4739,
 -53872,
 764229473,
 4737,
 -1,
 764352669,
 4738,
 764554661,
 762993960,
 -1,
 764620188,
 764494457,
 -1,
 764685717,
 764583160,
 4766,
 -1,
 764609331,
 11657,
 764816791,
 764611884,
 4765,
 -1,
 764742956,
 4764,
 764947865,
 764740403,
 4760,
 -1,
 764871475,
 4763,
 -53862,
 764905706,
 4767,
 -53861,
 765015905,
 4761,
 -1,
 765073565,
 4762,
 765275550,
 764583160,
 4758,
 -1,
 765199155,
 11656,
 765406624,
 765201708,
 4757,
 -1,
 765332780,
 4756,
 765537698,
 765330227,
 4752,
 -1,
 765461299,
 4755,
 -53853,
 765495530,
 4759,
 -53852,
 765605729,
 4753,
 -1,
 765663389,
 4754,
 765865401,
 764524795,
 -1,
 765930928,
 765835515,
 -1,
 765996457,
 765893880,
 4862,
 -1,
 765920051,
 11661,
 766127531,
 765922604,
 4861,
 -1,
 766053676,
 4860,
 766258605,
 766051123,
 4856,
 -1,
 766182195,
 4859,
 -53842,
 766216426,
 4863,
 -53841,
 766326625,
 4857,
 -1,
 766384285,
 4858,
 766586290,
 765893880,
 4854,
 -1,
 766509875,
 11660,
 766717364,
 766512428,
 4853,
 -1,
 766643500,
 4852,
 766848438,
 766640947,
 4848,
 -1,
 766772019,
 4851,
 -53833,
 766806250,
 4855,
 -53832,
 766916449,
 4849,
 -1,
 766974109,
 4850,
 767176139,
 765838226,
 -1,
 767241667,
 767148946,
 -1,
 767307197,
 767167788,
 4629,
 -1,
 767233324,
 4628,
 767438271,
 767230771,
 4624,
 -1,
 767361843,
 4627,
 -53824,
 767396074,
 4631,
 -53823,
 767506273,
 4625,
 -53822,
 767597816,
 4630,
 -1,
 767629469,
 4626,
 767831493,
 767204600,
 4614,
 -1,
 767755059,
 4615,
 767962567,
 767757612,
 4613,
 -1,
 767888684,
 4612,
 768093641,
 767886131,
 4608,
 -1,
 768017203,
 4611,
 -53814,
 768030561,
 4609,
 -1,
 768153757,
 4610,
 768355802,
 767107668,
 -1,
 768421329,
 768324421,
 -1,
 768486863,
 768347436,
 4995,
 -1,
 768412972,
 4994,
 -53808,
 768415901,
 4993,
 -1,
 768541491,
 4639,
 768749011,
 768384248,
 4638,
 -1,
 768672563,
 11649,
 768880085,
 768675116,
 4637,
 -1,
 768806188,
 4636,
 769011159,
 768803635,
 4632,
 -1,
 768934707,
 4635,
 -53800,
 768945188,
 4953,
 -53799,
 769079137,
 4633,
 -1,
 769136797,
 4634,
 769338856,
 768297031,
 -1,
 769404384,
 769307461,
 -1,
 769469918,
 769330476,
 5003,
 -1,
 769396012,
 5002,
 -53793,
 769398941,
 5001,
 -1,
 769524531,
 4943,
 769732066,
 769330476,
 4941,
 -1,
 769658156,
 4940,
 769863140,
 769655603,
 4936,
 -1,
 769786675,
 4939,
 -53787,
 769797156,
 4954,
 -53786,
 769931105,
 4937,
 -53785,
 770022648,
 4942,
 -1,
 770054301,
 4938,
 770256374,
 769277376,
 -1,
 770321902,
 770224965,
 -1,
 770387436,
 770247980,
 4999,
 -1,
 770313516,
 4998,
 -53779,
 770316445,
 4997,
 -1,
 770442035,
 4711,
 770649584,
 770284792,
 4710,
 -1,
 770573107,
 11653,
 770780658,
 770575660,
 4709,
 -1,
 770706732,
 4708,
 770911732,
 770704179,
 4704,
 -1,
 770835251,
 4707,
 -53771,
 770848609,
 4705,
 -1,
 770971805,
 4706,
 771173889,
 770225415,
 -1,
 771239417,
 771136760,
 4654,
 -1,
 771162931,
 11650,
 771370491,
 771165484,
 4653,
 -1,
 771296556,
 4652,
 771501565,
 771294003,
 4648,
 -1,
 771425075,
 4651,
 -53762,
 771435556,
 4952,
 -53761,
 771590378,
 4655,
 -53760,
 771635041,
 4649,
 -1,
 771692701,
 4650,
 771894795,
 771149455,
 -1,
 771960324,
 771857656,
 4622,
 -1,
 771883827,
 11648,
 772091398,
 771886380,
 4621,
 -1,
 772017452,
 4620,
 772222472,
 772014899,
 4616,
 -1,
 772145971,
 4619,
 -53751,
 772180202,
 4623,
 -53750,
 772290401,
 4617,
 -1,
 772348061,
 4618,
 772550165,
 771838668,
 -1,
 772615694,
 772513016,
 4870,
 -1,
 772539187,
 11662,
 772746768,
 772541740,
 4869,
 -1,
 772672812,
 4868,
 772877842,
 772670259,
 4864,
 -1,
 772801331,
 4867,
 -53741,
 772835562,
 4871,
 -53740,
 772945761,
 4865,
 -1,
 773003421,
 4866,
 773205534,
 772489849,
 -1,
 773271064,
 773168376,
 4846,
 -1,
 773194547,
 4847,
 773402138,
 773197100,
 4845,
 -1,
 773328172,
 4844,
 773533212,
 773325619,
 4840,
 -1,
 773456691,
 4843,
 -53731,
 773470049,
 4841,
 -1,
 773593245,
 4842,
 773795367,
 773174085,
 -1,
 773860897,
 773758200,
 4814,
 -1,
 773784371,
 4815,
 773991971,
 773786924,
 4813,
 -1,
 773917996,
 4812,
 774123045,
 773915443,
 4808,
 -1,
 774046515,
 4811,
 -53722,
 774059873,
 4809,
 -1,
 774183069,
 4810,
 774438911,
 773747912,
 -1,
 774450730,
 774311212,
 4717,
 -1,
 774376748,
 4716,
 774581804,
 774374195,
 4712,
 -1,
 774505267,
 4715,
 -53715,
 774539498,
 4719,
 -53714,
 774649697,
 4713,
 -53713,
 774741240,
 4718,
 -1,
 774772893,
 4714,
 775028735,
 743509292,
 -1,
 -53710,
 774897739,
 4964,
 -1,
 775005807,
 4960,
 775171650,
 743461572,
 -1,
 775237177,
 775153034,
 -1,
 775302711,
 775198133,
 4978,
 -1,
 775265580,
 4988,
 -53704,
 775239776,
 4979,
 -1,
 775394618,
 4980,
 775564860,
 775202702,
 -1,
 -53701,
 775495497,
 4983,
 -1,
 775596716,
 4984,
 775761471,
 775505991,
 -1,
 -53698,
 775720929,
 4981,
 -1,
 775759309,
 4982,
 -53696,
 775713145,
 4986,
 -53695,
 775897155,
 4987,
 -1,
 775952684,
 4985,
 776154703,
 775125065,
 -1,
 776220231,
 776124667,
 -1,
 776285766,
 776145296,
 5009,
 -1,
 776242105,
 5016,
 -1,
 776211253,
 5012,
 776482378,
 776180023,
 -1,
 -53687,
 776413124,
 5017,
 -1,
 776497449,
 5013,
 -53685,
 776449695,
 5008,
 -53684,
 776658769,
 5011,
 -53683,
 776725623,
 5010,
 -53682,
 776762717,
 5015,
 -1,
 776843328,
 5014,
 777006684,
 776135025,
 -1,
 777072211,
 776988042,
 -1,
 -53678,
 777029873,
 4970,
 -1,
 777095187,
 4971,
 777268822,
 777037710,
 -1,
 -53675,
 777241963,
 4974,
 -1,
 777271934,
 4975,
 777465433,
 777209927,
 -1,
 -53672,
 777425394,
 4972,
 -1,
 777463810,
 4973,
 -53670,
 777433400,
 4969,
 -53669,
 777597494,
 4977,
 -1,
 777699530,
 4976,
 777858657,
 776961098,
 -1,
 777924192,
 777790036,
 -1,
 -53665,
 777850790,
 4963,
 -1,
 777938866,
 4959,
 -1,
 777849301,
 4965,
 778186340,
 777836960,
 -1,
 -53661,
 778122248,
 4966,
 -1,
 778233536,
 4968,
 -53659,
 778143385,
 4961,
 -53658,
 778352355,
 4967,
 -1,
 778372631,
 4962,
 778579592,
 743390922,
 -1,
 778645123,
 778527238,
 -1,
 778710650,
 778584952,
 -1,
 778776184,
 778679689,
 61,
 778895359,
 778720297,
 -1,
 778907252,
 778765107,
 -1,
 778972786,
 778844917,
 -1,
 -53649,
 778934880,
 10867,
 -53648,
 779017343,
 10609,
 -53647,
 779078505,
 10865,
 -1,
 779104789,
 11072,
 779354111,
 778919155,
 10723,
 -1,
 779255690,
 10724,
 779485183,
 778876327,
 -1,
 -53642,
 779410148,
 10871,
 -53641,
 779456825,
 10854,
 -1,
 779530058,
 10926,
 -53639,
 778727431,
 10862,
 -1,
 779637216,
 8789,
 779878399,
 778654761,
 -1,
 779890306,
 779789903,
 -1,
 779955841,
 779827621,
 -1,
 -53634,
 779893786,
 8927,
 -53633,
 779952352,
 8926,
 -53632,
 780015207,
 8924,
 -1,
 780131240,
 8925,
 -1,
 779885876,
 8797,
 -1,
 779839801,
 8917,
 780468223,
 778573981,
 -1,
 780480135,
 780385830,
 -1,
 -53626,
 780418821,
 10872,
 -1,
 780493237,
 8781,
 -1,
 780448570,
 8794,
 780742300,
 778504111,
 -1,
 780807831,
 780698996,
 -1,
 780873357,
 780789130,
 -1,
 -53620,
 780830961,
 1778,
 -1,
 780896275,
 1779,
 781069968,
 780838798,
 -1,
 -53617,
 781043051,
 1782,
 -1,
 781073022,
 1783,
 781266579,
 781011015,
 -1,
 -53614,
 781226482,
 1780,
 -1,
 781264898,
 1781,
 -53612,
 781191523,
 1776,
 -53611,
 781431096,
 1777,
 -53610,
 781464118,
 1785,
 -1,
 781566154,
 1784,
 781778943,
 780761968,
 -1,
 781790875,
 781648313,
 -1,
 -53606,
 781760227,
 8265,
 -1,
 781804799,
 33,
 -1,
 781761474,
 8761,
 782053036,
 780665592,
 -1,
 782118569,
 781994173,
 8712,
 782237695,
 782062633,
 -1,
 782249638,
 782153127,
 -1,
 -53599,
 782175614,
 8947,
 -53598,
 782252444,
 8952,
 -53597,
 782348770,
 8953,
 -53596,
 782417145,
 8950,
 -53595,
 782435082,
 8946,
 -1,
 782556380,
 8949,
 782761983,
 782206390,
 -1,
 -53592,
 782649900,
 10194,
 -1,
 782699150,
 10969,
 782958591,
 782081741,
 -1,
 -53589,
 782871849,
 9191,
 -1,
 782916213,
 8961,
 783101625,
 781984340,
 -1,
 783167157,
 783079840,
 -1,
 783232692,
 783140955,
 8709,
 783351807,
 783172895,
 -1,
 -53583,
 783264358,
 10674,
 -53582,
 783311192,
 10675,
 -53581,
 783400185,
 10673,
 -1,
 783460172,
 10676,
 -1,
 783160010,
 9091,
 783745023,
 783111209,
 -1,
 -53577,
 783673339,
 8195,
 -53576,
 783690030,
 8193,
 -1,
 783768509,
 8212,
 783953606,
 783070471,
 -1,
 784019139,
 783895309,
 -1,
 784084671,
 783996902,
 -1,
 -53571,
 784013900,
 10734,
 -53570,
 784075757,
 10736,
 -1,
 784147303,
 10738,
 784400383,
 784063303,
 -1,
 -53567,
 784276044,
 10735,
 -53566,
 784337901,
 10737,
 -1,
 784409447,
 10739,
 784662527,
 783956187,
 -1,
 -53563,
 784574057,
 8998,
 -1,
 784619099,
 9003,
 784805585,
 783917630,
 -1,
 784871120,
 784749609,
 -1,
 784936654,
 784849312,
 -1,
 785002189,
 784899551,
 -1,
 -53557,
 784925530,
 10039,
 -53556,
 785008476,
 10037,
 -1,
 785055898,
 10036,
 -1,
 784970847,
 10049,
 -53553,
 784905883,
 10058,
 -1,
 785255501,
 10035,
 -1,
 784830838,
 9834,
 785526489,
 784751912,
 -1,
 785592022,
 785470505,
 -1,
 -53548,
 785573883,
 8194,
 -53547,
 785590574,
 8192,
 -1,
 785669053,
 8211,
 -53545,
 785534277,
 9993,
 -53544,
 785811011,
 9094,
 -1,
 785895189,
 8718,
 786050782,
 785463137,
 -1,
 786116317,
 785992111,
 -1,
 -53540,
 786051341,
 8352,
 -1,
 786139555,
 8364,
 -1,
 786079448,
 8455,
 786378466,
 785974067,
 -1,
 786444001,
 786335395,
 9793,
 -1,
 786396628,
 9178,
 -1,
 786383405,
 9841,
 786640613,
 786307301,
 -1,
 -53532,
 786605966,
 8793,
 -1,
 786685339,
 8494,
 -53530,
 786618767,
 9167,
 -1,
 786804038,
 11790,
 786970310,
 665322291,
 -1,
 787035527,
 786937095,
 -1,
 787100930,
 786965006,
 -1,
 787166446,
 787043369,
 -1,
 787231860,
 787140239,
 -1,
 787296756,
 787169638,
 -1,
 787361669,
 787261326,
 -1,
 787427121,
 787334034,
 -1,
 787492642,
 787368111,
 -1,
 787558143,
 787465106,
 -1,
 787623676,
 787532449,
 -1,
 787689207,
 787592615,
 -1,
 787754742,
 787655532,
 -1,
 -53515,
 787727256,
 64872,
 -1,
 787787187,
 64871,
 -1,
 787698567,
 64938,
 788016890,
 787617949,
 -1,
 -53511,
 787969474,
 64778,
 -1,
 788014347,
 64814,
 -53509,
 787986409,
 64824,
 -1,
 788180403,
 64806,
 788398079,
 787601735,
 -1,
 -53506,
 788314089,
 64746,
 -1,
 788382616,
 64818,
 788541196,
 787524460,
 -1,
 788606727,
 788510119,
 -1,
 788672260,
 788573036,
 -1,
 -53501,
 788644760,
 64877,
 -1,
 788704691,
 64876,
 788922367,
 788653087,
 -1,
 -53498,
 788841368,
 64875,
 -1,
 788901299,
 64874,
 789065482,
 788535453,
 -1,
 -53495,
 789018050,
 64780,
 -1,
 789062923,
 64816,
 -53493,
 789034985,
 64745,
 -1,
 789228979,
 64808,
 789393171,
 788511987,
 -1,
 789458704,
 789321885,
 -1,
 -53489,
 789411266,
 64777,
 -1,
 789456139,
 64813,
 -53487,
 789383617,
 64873,
 -53486,
 789624809,
 64823,
 -1,
 789687731,
 64805,
 789851929,
 789373983,
 -1,
 789917463,
 789780637,
 -1,
 -53482,
 789870018,
 64779,
 -1,
 789914891,
 64815,
 -53480,
 789886953,
 64825,
 -1,
 790080947,
 64807,
 790245148,
 789775033,
 -1,
 -53477,
 790218829,
 64766,
 -1,
 790277555,
 64794,
 790441759,
 790193387,
 -1,
 -53474,
 790415437,
 64781,
 -1,
 790474163,
 64809,
 790691839,
 790412824,
 -1,
 -53471,
 790612045,
 64765,
 -1,
 790670771,
 64793,
 790888447,
 787435731,
 -1,
 790900520,
 790764624,
 -1,
 790966055,
 790844457,
 -1,
 -53466,
 790935529,
 64756,
 -1,
 791005261,
 64610,
 -1,
 790899514,
 64607,
 791228205,
 790857003,
 -1,
 791293740,
 791172137,
 -1,
 -53461,
 791263209,
 64755,
 -1,
 791332941,
 64609,
 -1,
 791227194,
 64606,
 791555888,
 791205295,
 -1,
 -53457,
 791525353,
 64754,
 -1,
 791595085,
 64608,
 -1,
 791480202,
 64611,
 791818082,
 787368111,
 -1,
 791883583,
 791784300,
 -1,
 791949115,
 791852455,
 -1,
 792014647,
 791915372,
 -1,
 -53450,
 791987096,
 64867,
 -1,
 792047027,
 64866,
 792211258,
 791964024,
 -1,
 -53447,
 792183704,
 64864,
 -1,
 792243635,
 64863,
 -1,
 792138890,
 64865,
 792473406,
 791877789,
 -1,
 -53443,
 792425922,
 64543,
 -1,
 792470795,
 64688,
 -1,
 792442857,
 64743,
 792735561,
 791856018,
 -1,
 792801094,
 792709793,
 -1,
 792866628,
 792729757,
 -1,
 -53437,
 792819138,
 64541,
 -1,
 792864011,
 64686,
 -53435,
 792841484,
 64860,
 -1,
 793032681,
 64821,
 793247743,
 792779079,
 -1,
 -53432,
 793163753,
 64744,
 -1,
 793232280,
 64817,
 793390929,
 792716319,
 -1,
 793456461,
 793359783,
 -1,
 -53428,
 793400199,
 64966,
 -1,
 793487248,
 64936,
 793653072,
 793385117,
 -1,
 -53425,
 793605570,
 64542,
 -1,
 793650443,
 64687,
 -1,
 793622505,
 64822,
 793915225,
 793361651,
 -1,
 793980757,
 793884071,
 -1,
 -53420,
 793940665,
 64861,
 -1,
 794011536,
 64862,
 794177368,
 793909405,
 -1,
 -53417,
 794129858,
 64540,
 -1,
 794174731,
 64685,
 -1,
 794146793,
 64820,
 794439516,
 793838265,
 -1,
 -53413,
 794413133,
 64764,
 -1,
 794471859,
 64792,
 794636127,
 794387691,
 -1,
 -53410,
 794609741,
 64782,
 -1,
 794668467,
 64810,
 794886143,
 794607128,
 -1,
 -53407,
 794806349,
 64763,
 -1,
 794865075,
 64791,
 795082751,
 791741235,
 -1,
 795094910,
 794966043,
 -1,
 795160429,
 795044216,
 -1,
 795225962,
 795129255,
 -1,
 795291497,
 795175288,
 -1,
 -53400,
 795263896,
 64869,
 -1,
 795323827,
 64868,
 -1,
 795235207,
 64937,
 795607039,
 795154589,
 -1,
 -53396,
 795506114,
 64544,
 -1,
 795550987,
 64689,
 795750260,
 795126636,
 -1,
 795815793,
 795704249,
 -1,
 -53392,
 795788184,
 64965,
 -1,
 795848115,
 64870,
 796065791,
 795744413,
 -1,
 -53389,
 795964866,
 64545,
 -1,
 796009739,
 64691,
 796209015,
 795673273,
 -1,
 -53386,
 796182605,
 64774,
 -1,
 796241331,
 64802,
 796405626,
 796157163,
 -1,
 -53383,
 796379213,
 64783,
 -1,
 796437939,
 64811,
 796602237,
 796376600,
 -1,
 -53380,
 796575821,
 64773,
 -1,
 796634547,
 64801,
 -1,
 796570680,
 64690,
 796917759,
 795070095,
 -1,
 796929924,
 796787454,
 -1,
 796995459,
 796873769,
 -1,
 -53374,
 796933288,
 65008,
 -1,
 797034573,
 65017,
 -1,
 796974709,
 65018,
 -1,
 796854586,
 65013,
 797323234,
 787342730,
 -1,
 797388729,
 797297258,
 -1,
 797454227,
 797354860,
 -1,
 797519758,
 797423015,
 -1,
 -53366,
 797463431,
 64931,
 -53365,
 797553720,
 64855,
 -53364,
 797578378,
 64853,
 -53363,
 797676217,
 64854,
 -1,
 797747088,
 64932,
 797912977,
 797448349,
 -1,
 -53360,
 797865410,
 64526,
 -1,
 797910283,
 64676,
 -53358,
 797882345,
 64739,
 -1,
 798076339,
 64626,
 798240672,
 797426578,
 -1,
 798306205,
 798214817,
 -1,
 798371738,
 798274983,
 -1,
 798437273,
 798342387,
 -1,
 -53352,
 798409624,
 64850,
 -1,
 798469555,
 64849,
 -1,
 798374557,
 64851,
 798752767,
 798300317,
 -1,
 -53348,
 798651842,
 64524,
 -1,
 798696715,
 64674,
 798949375,
 798284103,
 -1,
 -53345,
 798865385,
 64740,
 -1,
 798933912,
 64677,
 799092648,
 798221343,
 -1,
 799158181,
 799061415,
 -1,
 -53341,
 799101831,
 64929,
 -53340,
 799160989,
 64852,
 -1,
 799254416,
 64930,
 799473663,
 799086749,
 -1,
 -53337,
 799372738,
 64525,
 -1,
 799417611,
 64675,
 799616944,
 799063283,
 -1,
 799682477,
 799585703,
 -1,
 -53333,
 799626119,
 64927,
 -53332,
 799685277,
 64848,
 -1,
 799778704,
 64928,
 799997951,
 799611037,
 -1,
 -53329,
 799897026,
 64523,
 -1,
 799941899,
 64673,
 800141235,
 799539897,
 -1,
 -53326,
 800114765,
 64528,
 -1,
 800173491,
 64629,
 800337846,
 800112152,
 -1,
 -53323,
 800311373,
 64527,
 -1,
 800370099,
 64628,
 -53321,
 800314630,
 64625,
 -53320,
 800469900,
 64624,
 -1,
 800533742,
 64627,
 800731085,
 797361042,
 -1,
 800796620,
 800705130,
 -1,
 800862145,
 800762732,
 -1,
 800927679,
 800790685,
 -1,
 -53314,
 800880066,
 64530,
 -1,
 800924939,
 64678,
 -53312,
 800897001,
 64741,
 -1,
 801090995,
 64632,
 801255364,
 800785081,
 -1,
 -53309,
 801228877,
 64532,
 -1,
 801287603,
 64635,
 801451975,
 801226264,
 -1,
 -53306,
 801425485,
 64531,
 -1,
 801484211,
 64634,
 -53304,
 801428742,
 64631,
 -53303,
 801584012,
 64630,
 -53302,
 801647854,
 64633,
 -53301,
 801760027,
 64529,
 -1,
 801801779,
 64742,
 -1,
 800773471,
 64603,
 802095103,
 800686013,
 -1,
 802107353,
 802007916,
 -1,
 802172885,
 802076071,
 -1,
 802238419,
 802122104,
 -1,
 -53294,
 802210712,
 64882,
 -1,
 802270643,
 64881,
 -53292,
 802182023,
 64884,
 -1,
 802372253,
 64883,
 802566104,
 802101405,
 -1,
 -53289,
 802518466,
 64551,
 -1,
 802563339,
 64819,
 -1,
 802535401,
 64826,
 802828252,
 802030265,
 -1,
 -53285,
 802801741,
 64758,
 -1,
 802860467,
 64786,
 803024863,
 802771728,
 -1,
 -53282,
 802977218,
 64550,
 -1,
 803022091,
 64696,
 803274751,
 802995736,
 -1,
 -53279,
 803194957,
 64757,
 -1,
 803253683,
 64785,
 803418173,
 797297680,
 -1,
 803483681,
 803390354,
 -1,
 803549214,
 803406643,
 -1,
 803614745,
 803497539,
 -1,
 803680240,
 803537715,
 -1,
 803745773,
 803624548,
 -1,
 803811307,
 803715873,
 -1,
 -53270,
 803784781,
 64515,
 -1,
 803843507,
 64616,
 -53268,
 803784781,
 64490,
 -1,
 803974579,
 64491,
 804192255,
 803706243,
 -1,
 -53265,
 804112461,
 64492,
 -1,
 804171187,
 64493,
 804335607,
 803619449,
 -1,
 804401140,
 804286462,
 -1,
 -53261,
 804374605,
 64500,
 -1,
 804433331,
 64501,
 804651007,
 804378951,
 -1,
 -53258,
 804571213,
 64516,
 -1,
 804629939,
 64617,
 804794365,
 804301676,
 -1,
 804859899,
 804722845,
 -1,
 -53254,
 804812226,
 64514,
 -1,
 804857099,
 64666,
 -53252,
 804829161,
 64735,
 -1,
 805023155,
 64614,
 805187588,
 804766610,
 -1,
 805253121,
 805165383,
 -1,
 -53248,
 805222377,
 64736,
 -1,
 805290904,
 64667,
 805502975,
 805183310,
 -1,
 -53245,
 805402050,
 64513,
 -1,
 805446923,
 64664,
 805646345,
 805148035,
 -1,
 805711880,
 805574813,
 -1,
 -53241,
 805664194,
 64502,
 -1,
 805709067,
 64504,
 -1,
 805678515,
 64503,
 805974028,
 805577833,
 -1,
 -53237,
 805947469,
 64494,
 -1,
 806006195,
 64495,
 806170639,
 805924862,
 -1,
 -53234,
 806144077,
 64496,
 -1,
 806202803,
 64497,
 806367250,
 806113036,
 -1,
 -53231,
 806340685,
 64498,
 -1,
 806399411,
 64499,
 806563861,
 806347128,
 -1,
 -53228,
 806516162,
 64512,
 -1,
 806561035,
 64663,
 -53226,
 806540550,
 64613,
 -53225,
 806695820,
 64612,
 -53224,
 806759662,
 64615,
 -1,
 806859832,
 64665,
 807075839,
 803584571,
 -1,
 807088157,
 806951069,
 -1,
 -53220,
 807040450,
 64598,
 -1,
 807085323,
 64731,
 -1,
 807012801,
 64942,
 807403519,
 803526983,
 -1,
 -53216,
 807319529,
 64753,
 -1,
 807388056,
 64734,
 807546924,
 803449708,
 -1,
 807612455,
 807515559,
 -1,
 807677990,
 807578476,
 -1,
 -53211,
 807650200,
 64925,
 -1,
 807710131,
 64924,
 -1,
 807621511,
 64944,
 807940138,
 807540893,
 -1,
 -53207,
 807892418,
 64600,
 -1,
 807937291,
 64733,
 -53205,
 807909353,
 64752,
 -1,
 808103347,
 64659,
 808267825,
 807517427,
 -1,
 808333360,
 808196253,
 -1,
 -53201,
 808285634,
 64597,
 -1,
 808330507,
 64730,
 -1,
 808257985,
 64943,
 808595508,
 808190649,
 -1,
 -53197,
 808568909,
 64602,
 -1,
 808627635,
 64662,
 808792119,
 808518315,
 -1,
 -53194,
 808744386,
 64599,
 -1,
 808789259,
 64732,
 808988730,
 808762904,
 -1,
 -53191,
 808962125,
 64601,
 -1,
 809020851,
 64661,
 -53189,
 808965382,
 64658,
 -53188,
 809120652,
 64657,
 -1,
 809184494,
 64660,
 809382012,
 803363674,
 -1,
 809447503,
 809347999,
 -1,
 809513034,
 809416103,
 -1,
 809578567,
 809472601,
 -1,
 809644100,
 809510117,
 -1,
 -53181,
 809617485,
 65273,
 -1,
 809676211,
 65274,
 809893887,
 809624739,
 -1,
 -53178,
 809814093,
 65271,
 -1,
 809872819,
 65272,
 810090495,
 809500901,
 -1,
 -53175,
 810010701,
 65269,
 -1,
 810069427,
 65270,
 810233933,
 809483041,
 -1,
 -53172,
 810207309,
 64579,
 -1,
 810266035,
 64646,
 -53170,
 810207309,
 65275,
 -1,
 810397107,
 65276,
 810561626,
 809413484,
 -1,
 810627157,
 810530215,
 -1,
 810692692,
 810576248,
 -1,
 -53165,
 810664856,
 64904,
 -1,
 810724787,
 64903,
 -1,
 810636167,
 64941,
 810954840,
 810555549,
 -1,
 -53161,
 810907074,
 64578,
 -1,
 810951947,
 64716,
 -53159,
 810924009,
 64749,
 -1,
 811118003,
 64645,
 811282534,
 810532083,
 -1,
 811348067,
 811251111,
 -1,
 811413599,
 811314028,
 -1,
 -53154,
 811385752,
 64954,
 -1,
 811445683,
 64956,
 811610210,
 811384051,
 -1,
 -53151,
 811582360,
 64899,
 -1,
 811642291,
 64900,
 -1,
 811553671,
 64940,
 811925503,
 811276445,
 -1,
 -53147,
 811824578,
 64575,
 -1,
 811869451,
 64713,
 812068978,
 811254674,
 -1,
 812134513,
 812042913,
 -1,
 812200046,
 812103079,
 -1,
 812265580,
 812165996,
 -1,
 -53141,
 812237720,
 64949,
 -1,
 812297651,
 64896,
 -53139,
 812209031,
 64897,
 -1,
 812427152,
 64898,
 812646399,
 812128413,
 -1,
 -53136,
 812545474,
 64576,
 -1,
 812590347,
 64714,
 -1,
 812103085,
 64717,
 812855417,
 812049439,
 -1,
 812920950,
 812809145,
 -1,
 -53131,
 812893080,
 64902,
 -1,
 812953011,
 64901,
 813170687,
 812849309,
 -1,
 -53128,
 813069762,
 64577,
 -1,
 813114635,
 64715,
 813367295,
 812778169,
 -1,
 -53125,
 813287501,
 64580,
 -1,
 813346227,
 64647,
 813510831,
 809341239,
 -1,
 813576353,
 813446714,
 -1,
 813641865,
 813542252,
 -1,
 813707396,
 813610407,
 -1,
 813772931,
 813673324,
 -1,
 -53118,
 813745048,
 64963,
 -1,
 813804979,
 64955,
 -1,
 813716359,
 64951,
 814035079,
 813635741,
 -1,
 -53114,
 813987266,
 64572,
 -1,
 814032139,
 64712,
 -53112,
 814004201,
 64748,
 -1,
 814198195,
 64642,
 814362767,
 813595782,
 -1,
 814428301,
 814291101,
 -1,
 -53108,
 814380482,
 64571,
 -1,
 814425355,
 64711,
 -53106,
 814397417,
 64747,
 -1,
 814591411,
 64641,
 814755989,
 814328735,
 -1,
 814821523,
 814725921,
 -1,
 -53102,
 814794829,
 64573,
 -1,
 814853555,
 64643,
 -53100,
 814794829,
 64567,
 -1,
 814984627,
 64640,
 815149208,
 814678713,
 -1,
 -53097,
 815122509,
 64574,
 -1,
 815181235,
 64644,
 815345819,
 815071915,
 -1,
 -53094,
 815297986,
 64570,
 -1,
 815342859,
 64710,
 815542430,
 815325560,
 -1,
 -53091,
 815494594,
 64568,
 -1,
 815539467,
 64708,
 815792127,
 815485712,
 -1,
 -53088,
 815691202,
 64569,
 -1,
 815736075,
 64709,
 815988735,
 813525606,
 -1,
 816001189,
 815858361,
 -1,
 -53084,
 815974477,
 64772,
 -1,
 816033203,
 64800,
 816197800,
 815970962,
 -1,
 -53081,
 816149954,
 64539,
 -1,
 816194827,
 64684,
 816394411,
 816177528,
 -1,
 -53078,
 816346562,
 64537,
 -1,
 816391435,
 64683,
 816591022,
 816365080,
 -1,
 -53075,
 816564301,
 64771,
 -1,
 816623027,
 64799,
 -1,
 816546068,
 64538,
 816853214,
 813487557,
 -1,
 816918717,
 816823539,
 -1,
 816984250,
 816887207,
 -1,
 817049781,
 816950124,
 -1,
 -53068,
 817021848,
 64920,
 -1,
 817081779,
 64919,
 817246392,
 816998776,
 -1,
 -53065,
 817218456,
 64952,
 -1,
 817278387,
 64957,
 -53063,
 817189767,
 64967,
 -1,
 817407888,
 64921,
 817627135,
 816912541,
 -1,
 -53060,
 817526210,
 64587,
 -1,
 817571083,
 64722,
 817770697,
 816890770,
 -1,
 817836230,
 817744545,
 -1,
 817901763,
 817804711,
 -1,
 -53055,
 817845127,
 64947,
 -53054,
 817904285,
 64917,
 -1,
 817997712,
 64918,
 818216959,
 817830045,
 -1,
 -53051,
 818116034,
 64588,
 -1,
 818160907,
 64723,
 818413567,
 817813831,
 -1,
 -53048,
 818329577,
 64751,
 -1,
 818398104,
 64726,
 818557138,
 817736556,
 -1,
 818622669,
 818525607,
 -1,
 -53044,
 818566023,
 64922,
 -1,
 818653072,
 64923,
 818819280,
 818550941,
 -1,
 -53041,
 818771394,
 64590,
 -1,
 818816267,
 64725,
 -53039,
 818788329,
 64750,
 -1,
 818982323,
 64652,
 819146965,
 818479801,
 -1,
 -53036,
 819120205,
 64592,
 -1,
 819178931,
 64655,
 819343576,
 819069611,
 -1,
 -53033,
 819295682,
 64589,
 -1,
 819340555,
 64724,
 819540187,
 819314200,
 -1,
 -53030,
 819513421,
 64591,
 -1,
 819572147,
 64654,
 -53028,
 819516678,
 64651,
 -53027,
 819671948,
 64650,
 -1,
 819735790,
 64653,
 819933444,
 816783956,
 -1,
 819998979,
 819880148,
 -1,
 820064489,
 819969267,
 -1,
 820130022,
 820032935,
 -1,
 -53021,
 820073351,
 64960,
 -53020,
 820132509,
 64909,
 -53019,
 820229176,
 64914,
 -1,
 820286137,
 64908,
 820510719,
 820058269,
 -1,
 -53016,
 820409794,
 64581,
 -1,
 820454667,
 64718,
 820654321,
 820044831,
 -1,
 820719854,
 820622759,
 -1,
 -53012,
 820663175,
 64953,
 -53011,
 820722333,
 64911,
 -1,
 820778122,
 64910,
 821035007,
 820648093,
 -1,
 -53008,
 820934082,
 64583,
 -1,
 820978955,
 64720,
 821178617,
 820603256,
 -1,
 821244150,
 821147047,
 -1,
 -53004,
 821187463,
 64907,
 -53003,
 821246621,
 64906,
 -1,
 821302410,
 64905,
 821559295,
 821172381,
 -1,
 -53000,
 821458370,
 64582,
 -1,
 821503243,
 64719,
 821702911,
 821144428,
 -1,
 821768445,
 821631133,
 -1,
 -52996,
 821720514,
 64584,
 -1,
 821765387,
 64721,
 -52994,
 821692865,
 64945,
 -1,
 821931443,
 64649,
 822096130,
 821668767,
 -1,
 -52991,
 822048881,
 64585,
 -1,
 822128051,
 64648,
 -1,
 822033957,
 64586,
 -1,
 819951539,
 65012,
 822423847,
 819871168,
 -1,
 822489382,
 822397546,
 -1,
 822554895,
 822461330,
 -1,
 822620428,
 822528673,
 -1,
 822685963,
 822548637,
 -1,
 -52982,
 822638018,
 64518,
 -1,
 822682891,
 64669,
 -1,
 822610369,
 64962,
 823001087,
 822597959,
 -1,
 -52978,
 822917097,
 64738,
 -1,
 822985624,
 64672,
 823144725,
 822520684,
 -1,
 823210259,
 823072925,
 -1,
 -52974,
 823162306,
 64520,
 -1,
 823207179,
 64671,
 -52972,
 823179241,
 64737,
 -1,
 823373235,
 64620,
 823537946,
 823125023,
 -1,
 823603481,
 823466141,
 -1,
 -52968,
 823555522,
 64519,
 -1,
 823600395,
 64670,
 -1,
 823527873,
 64926,
 823865629,
 823460537,
 -1,
 -52964,
 823838797,
 64522,
 -1,
 823897523,
 64623,
 824062240,
 823845240,
 -1,
 -52961,
 824014274,
 64517,
 -1,
 824059147,
 64668,
 824258851,
 824032792,
 -1,
 -52958,
 824232013,
 64521,
 -1,
 824290739,
 64622,
 -52956,
 824235270,
 64619,
 -52955,
 824390540,
 64618,
 -1,
 824454382,
 64621,
 -1,
 822462854,
 65021,
 824717643,
 822346547,
 -1,
 824783168,
 824685642,
 -1,
 824848691,
 824748908,
 -1,
 824914224,
 824817063,
 -1,
 824979758,
 824879980,
 -1,
 -52947,
 824951704,
 64887,
 -1,
 825011635,
 64886,
 -52945,
 824923015,
 64950,
 -1,
 825141136,
 64888,
 825360383,
 824842397,
 -1,
 -52942,
 825259458,
 64554,
 -1,
 825304331,
 64699,
 825504058,
 824818931,
 -1,
 825569591,
 825457593,
 -1,
 -52938,
 825541528,
 64964,
 -1,
 825601459,
 64885,
 825819135,
 825497757,
 -1,
 -52935,
 825718210,
 64553,
 -1,
 825763083,
 64698,
 825962813,
 825426617,
 -1,
 -52932,
 825935949,
 64760,
 -1,
 825994675,
 64788,
 826212351,
 825933336,
 -1,
 -52929,
 826132557,
 64759,
 -1,
 826191283,
 64787,
 826356042,
 824757903,
 -1,
 826421576,
 826335751,
 -1,
 826487109,
 826388495,
 -1,
 -52924,
 826460237,
 64829,
 -1,
 826518963,
 64828,
 826736639,
 826414440,
 -1,
 -52921,
 826656845,
 64605,
 -1,
 826715571,
 64656,
 -52919,
 826360973,
 65010,
 -1,
 826819581,
 65015,
 -1,
 826279297,
 65011,
 827076973,
 824689554,
 -1,
 827142495,
 827031485,
 -1,
 827208020,
 827108204,
 -1,
 827273553,
 827176359,
 -1,
 -52912,
 827216775,
 64858,
 -1,
 827303824,
 64859,
 827523071,
 827201693,
 -1,
 -52909,
 827422146,
 64536,
 -1,
 827467019,
 64682,
 827666777,
 827178227,
 -1,
 827732312,
 827594909,
 -1,
 -52905,
 827684290,
 64535,
 -1,
 827729163,
 64681,
 -1,
 827656641,
 64959,
 827994460,
 827589305,
 -1,
 -52901,
 827967565,
 64768,
 -1,
 828026291,
 64796,
 828243967,
 827964952,
 -1,
 -52898,
 828164173,
 64767,
 -1,
 828222899,
 64795,
 828440575,
 827116138,
 -1,
 828453223,
 828353388,
 -1,
 828518756,
 828421543,
 -1,
 -52893,
 828455581,
 64916,
 -1,
 828511370,
 64915,
 828768255,
 828446877,
 -1,
 -52890,
 828667330,
 64594,
 -1,
 828712203,
 64728,
 828911978,
 828432760,
 -1,
 -52887,
 828863938,
 64593,
 -1,
 828908811,
 64727,
 -52885,
 828849701,
 64596,
 -52884,
 829079359,
 64729,
 -1,
 829101300,
 64595,
 829305227,
 827040577,
 -1,
 829370741,
 829285407,
 -1,
 829436274,
 829324217,
 -1,
 -52879,
 829408152,
 64880,
 -1,
 829468083,
 64879,
 829685759,
 829364381,
 -1,
 -52876,
 829584834,
 64548,
 -1,
 829629707,
 64694,
 829829500,
 829319544,
 -1,
 829895033,
 829797799,
 -1,
 -52872,
 829838215,
 64939,
 -1,
 829925264,
 64878,
 830144511,
 829823133,
 -1,
 -52869,
 830043586,
 64547,
 -1,
 830088459,
 64693,
 830288255,
 829751993,
 -1,
 -52866,
 830261325,
 64776,
 -1,
 830320051,
 64804,
 830484866,
 830235883,
 -1,
 -52863,
 830457933,
 64784,
 -1,
 830516659,
 64812,
 830681477,
 830454418,
 -1,
 -52860,
 830633410,
 64549,
 -1,
 830678283,
 64695,
 830878088,
 830660984,
 -1,
 -52857,
 830830018,
 64546,
 -1,
 830874891,
 64692,
 831127551,
 830848536,
 -1,
 -52854,
 831047757,
 64775,
 -1,
 831106483,
 64803,
 831271333,
 829248204,
 -1,
 831336868,
 831217876,
 -1,
 831402391,
 831302508,
 -1,
 831467924,
 831370663,
 -1,
 831533458,
 831416696,
 -1,
 -52847,
 831505304,
 64857,
 -1,
 831565235,
 64856,
 -52845,
 831476615,
 64933,
 -1,
 831694736,
 64935,
 831913983,
 831395997,
 -1,
 -52842,
 831813058,
 64534,
 -1,
 831857931,
 64680,
 832057758,
 831351160,
 -1,
 832123291,
 832026023,
 -1,
 -52838,
 832066439,
 64958,
 -1,
 832153488,
 64934,
 832372735,
 832051357,
 -1,
 -52835,
 832271810,
 64533,
 -1,
 832316683,
 64679,
 832516513,
 831980217,
 -1,
 -52832,
 832489549,
 64770,
 -1,
 832548275,
 64798,
 832765951,
 832486936,
 -1,
 -52829,
 832686157,
 64769,
 -1,
 832744883,
 64797,
 -1,
 831274258,
 65019,
 832975294,
 831198999,
 -1,
 833040813,
 832955423,
 -1,
 833106346,
 832994233,
 -1,
 -52823,
 833078168,
 64893,
 -1,
 833138099,
 64892,
 833355775,
 833034397,
 -1,
 -52820,
 833254850,
 64559,
 -1,
 833299723,
 64704,
 833499570,
 833006444,
 -1,
 833565105,
 833427613,
 -1,
 -52816,
 833516994,
 64560,
 -1,
 833561867,
 64705,
 -1,
 833489345,
 64961,
 833827253,
 833422009,
 -1,
 -52812,
 833800269,
 64562,
 -1,
 833858995,
 64637,
 834023864,
 833806712,
 -1,
 -52809,
 833975746,
 64557,
 -1,
 834020619,
 64702,
 834220475,
 833966864,
 -1,
 -52806,
 834172354,
 64558,
 -1,
 834217227,
 64703,
 834469887,
 834190872,
 -1,
 -52803,
 834390093,
 64561,
 -1,
 834448819,
 64636,
 834613716,
 832913113,
 -1,
 834679251,
 834548039,
 -1,
 834744778,
 834644844,
 -1,
 834810311,
 834712999,
 -1,
 834875845,
 834759032,
 -1,
 -52796,
 834847640,
 64948,
 -1,
 834907571,
 64894,
 -52794,
 834818951,
 64946,
 -1,
 835025330,
 64895,
 835256319,
 834738333,
 -1,
 -52791,
 835155394,
 64564,
 -1,
 835200267,
 64707,
 835400141,
 834667193,
 -1,
 -52788,
 835373133,
 64566,
 -1,
 835431859,
 64639,
 835596752,
 835343120,
 -1,
 -52785,
 835548610,
 64563,
 -1,
 835593483,
 64706,
 835846143,
 835567128,
 -1,
 -52782,
 835766349,
 64565,
 -1,
 835825075,
 64638,
 -1,
 834657866,
 65009,
 836055526,
 834581492,
 -1,
 836121053,
 836021100,
 -1,
 836186586,
 836089255,
 -1,
 -52776,
 836129671,
 64890,
 -52775,
 836204978,
 64889,
 -1,
 836282256,
 64891,
 836501503,
 836114589,
 -1,
 -52772,
 836400578,
 64556,
 -1,
 836445451,
 64701,
 836645344,
 836043449,
 -1,
 -52769,
 836618317,
 64762,
 -1,
 836677043,
 64790,
 836841955,
 836624760,
 -1,
 -52766,
 836793794,
 64555,
 -1,
 836838667,
 64700,
 837091327,
 836812312,
 -1,
 -52763,
 837011533,
 64761,
 -1,
 837070259,
 64789,
 837235179,
 836004483,
 -1,
 837300714,
 837163165,
 -1,
 -52759,
 837252546,
 64552,
 -1,
 837297419,
 64697,
 -1,
 837269481,
 64827,
 837562864,
 837162462,
 -1,
 837628399,
 837490845,
 -1,
 -52754,
 837580226,
 64505,
 -1,
 837625099,
 64507,
 -1,
 837594547,
 64506,
 837890547,
 837530887,
 -1,
 -52750,
 837848926,
 64604,
 -1,
 837886528,
 65014,
 -1,
 837851239,
 65016,
 838205439,
 787259728,
 -1,
 838218302,
 838133130,
 -1,
 838283789,
 838178235,
 1578,
 838349318,
 838226985,
 -1,
 838414847,
 838279764,
 -1,
 838480382,
 838365684,
 1577,
 838598655,
 838423593,
 -1,
 -52740,
 838518861,
 65171,
 -52739,
 838542572,
 1731,
 -1,
 838643123,
 65172,
 -1,
 838451623,
 65176,
 838873602,
 838383015,
 -1,
 -52735,
 838835751,
 1661,
 -1,
 838871244,
 1660,
 839070213,
 838801565,
 -1,
 -52732,
 839022018,
 65173,
 -1,
 839066891,
 65175,
 -1,
 839036339,
 65174,
 839385087,
 838309307,
 1663,
 839450623,
 839275561,
 -1,
 839463435,
 839325853,
 -1,
 -52726,
 839415234,
 64354,
 -1,
 839460107,
 64356,
 -52724,
 839432169,
 64357,
 -1,
 839626163,
 64355,
 839791132,
 838236712,
 1670,
 839856661,
 839751099,
 1671,
 839974911,
 839799849,
 -1,
 839987731,
 839850141,
 -1,
 -52718,
 839939522,
 64382,
 -1,
 839984395,
 64384,
 -52716,
 839956457,
 64385,
 -1,
 840150451,
 64383,
 840368127,
 839799849,
 -1,
 840380953,
 840243357,
 -1,
 -52712,
 840332738,
 64378,
 -1,
 840377611,
 64380,
 -52710,
 840315325,
 1727,
 -52709,
 840546281,
 64381,
 -1,
 840609203,
 64379,
 840774186,
 839745325,
 1657,
 840839716,
 840734139,
 1658,
 840957951,
 840782889,
 -1,
 840970786,
 840833181,
 -1,
 -52703,
 840922562,
 64350,
 -1,
 840967435,
 64352,
 -52701,
 840939497,
 64353,
 -1,
 841133491,
 64351,
 841351167,
 840782889,
 -1,
 841364008,
 841226397,
 -1,
 -52697,
 841315778,
 64358,
 -1,
 841360651,
 64360,
 -52695,
 841332713,
 64361,
 -1,
 841526707,
 64359,
 841691702,
 840745874,
 -1,
 841757234,
 841651643,
 1579,
 841875455,
 841700393,
 -1,
 841888304,
 841750685,
 -1,
 -52689,
 841840066,
 65177,
 -1,
 841884939,
 65179,
 -52687,
 841857001,
 65180,
 -1,
 842050995,
 65178,
 842268671,
 841703942,
 1584,
 842334207,
 842159145,
 -1,
 -52683,
 842254413,
 65195,
 -1,
 842313139,
 65196,
 842530815,
 841638397,
 1591,
 842596351,
 842421289,
 -1,
 842609211,
 842471581,
 -1,
 -52678,
 842560962,
 65217,
 -1,
 842605835,
 65219,
 -52676,
 842550217,
 1695,
 -52675,
 842774505,
 65220,
 -1,
 842837427,
 65218,
 843002489,
 838189970,
 -1,
 843067995,
 842962363,
 1607,
 843186175,
 843011113,
 -1,
 843199049,
 843064556,
 1729,
 843317247,
 843142185,
 -1,
 843330118,
 843192477,
 -1,
 -52667,
 843281858,
 64422,
 -1,
 843326731,
 64424,
 -52665,
 843307669,
 1730,
 -52664,
 843495401,
 64425,
 -1,
 843558323,
 64423,
 843723344,
 843164358,
 1726,
 843841535,
 843666473,
 -1,
 843854414,
 843716765,
 -1,
 -52659,
 843806146,
 64426,
 -1,
 843851019,
 64428,
 -52657,
 843823081,
 64429,
 -1,
 844017075,
 64427,
 844182102,
 843691431,
 -1,
 844247637,
 844114410,
 1728,
 844365823,
 844190761,
 -1,
 -52652,
 844286029,
 64420,
 -1,
 844344755,
 64421,
 -1,
 844216825,
 1791,
 844575321,
 844109981,
 -1,
 -52648,
 844527042,
 65257,
 -1,
 844571915,
 65259,
 -52646,
 844543977,
 65260,
 -1,
 844737971,
 65258,
 844903028,
 842990387,
 -1,
 844968562,
 844874642,
 1581,
 845086719,
 844911657,
 -1,
 845099629,
 845002151,
 -1,
 845165158,
 845079946,
 -1,
 845230691,
 845132712,
 -1,
 -52638,
 845191513,
 1666,
 -1,
 845243621,
 1879,
 845479935,
 845201163,
 -1,
 -52635,
 845382108,
 1880,
 -1,
 845440229,
 1669,
 845623915,
 845090795,
 -1,
 845689450,
 845546291,
 -1,
 -52631,
 845656769,
 1903,
 -1,
 845679714,
 1906,
 -1,
 845658230,
 1902,
 -52628,
 845586391,
 1665,
 -1,
 845888906,
 1916,
 846082672,
 845027485,
 -1,
 -52625,
 846034370,
 65185,
 -1,
 846079243,
 65187,
 -52623,
 846051305,
 65188,
 -1,
 846245299,
 65186,
 846462975,
 844899171,
 1569,
 -1,
 846363623,
 65152,
 846594047,
 844855241,
 1652,
 846659583,
 846484521,
 -1,
 -52617,
 846534243,
 1656,
 -52616,
 846644449,
 1654,
 -1,
 846669534,
 1653,
 846869166,
 842971387,
 -1,
 846934678,
 846791475,
 -1,
 847000202,
 846909071,
 1583,
 847118335,
 846943273,
 -1,
 847131272,
 847033767,
 -1,
 847196801,
 847111562,
 -1,
 -52608,
 847151738,
 1881,
 -1,
 847231848,
 1679,
 847393412,
 847123087,
 -1,
 -52605,
 847344840,
 1774,
 -1,
 847381481,
 1882,
 847590022,
 847352121,
 1674,
 -1,
 847566863,
 1675,
 -52601,
 847521996,
 1673,
 -1,
 847649599,
 1680,
 -52599,
 847104077,
 65193,
 -1,
 847818163,
 65194,
 847983250,
 846969083,
 1590,
 848101375,
 847926313,
 -1,
 848114319,
 847976605,
 -1,
 -52594,
 848065986,
 65213,
 -1,
 848110859,
 65215,
 -52592,
 848044522,
 1787,
 -52591,
 848279529,
 65216,
 -1,
 848342451,
 65214,
 848560127,
 847939924,
 1676,
 848625663,
 848450601,
 -1,
 -52587,
 848545869,
 64388,
 -1,
 848604595,
 64389,
 848769695,
 846891024,
 -1,
 848835227,
 848744079,
 1672,
 848953343,
 848778281,
 -1,
 -52582,
 848873549,
 64392,
 -1,
 848932275,
 64393,
 849149951,
 848791892,
 1677,
 849215487,
 849040425,
 -1,
 -52578,
 849135693,
 64386,
 -1,
 849194419,
 64387,
 849359526,
 848696931,
 1668,
 849477631,
 849302569,
 -1,
 849490596,
 849352861,
 -1,
 -52573,
 849442242,
 64370,
 -1,
 849487115,
 64372,
 -52571,
 849459177,
 64373,
 -1,
 849653171,
 64371,
 849818282,
 849309864,
 1678,
 849936383,
 849761321,
 -1,
 -52567,
 849856589,
 64390,
 -1,
 849915315,
 64391,
 850132991,
 849748505,
 -1,
 -52564,
 850037019,
 1647,
 -52563,
 850096435,
 1697,
 -1,
 850133249,
 1646,
 850342623,
 846791475,
 -1,
 850408144,
 850315598,
 1575,
 850526207,
 850351145,
 -1,
 850539210,
 850441029,
 -1,
 850604742,
 850484504,
 -1,
 850670268,
 850563673,
 -1,
 850735800,
 850638966,
 1573,
 850853887,
 850678825,
 -1,
 -52553,
 850774093,
 65159,
 -1,
 850832819,
 65160,
 851050495,
 850683109,
 1571,
 851116031,
 850940969,
 -1,
 -52549,
 851036237,
 65155,
 -1,
 851094963,
 65156,
 851260096,
 850621678,
 1570,
 851378175,
 851203113,
 -1,
 -52545,
 851298381,
 65153,
 -1,
 851357107,
 65154,
 851522243,
 851211446,
 -1,
 -52542,
 851490934,
 1651,
 -1,
 851535077,
 1650,
 851771391,
 851487055,
 -1,
 -52539,
 851676493,
 1907,
 -1,
 851723941,
 1908,
 851967999,
 850582430,
 1649,
 852033535,
 851858473,
 -1,
 -52535,
 851953741,
 64336,
 -1,
 852012467,
 64337,
 852177614,
 850482113,
 1609,
 852295679,
 852120617,
 -1,
 -52531,
 852215885,
 65263,
 -1,
 852274611,
 65264,
 -52529,
 852150349,
 65165,
 -1,
 852405683,
 65166,
 852570846,
 850380198,
 1593,
 852688895,
 852513833,
 -1,
 852701913,
 852568448,
 -1,
 852767446,
 852669352,
 -1,
 -52523,
 852691349,
 1887,
 -1,
 852780261,
 1885,
 853016575,
 852737803,
 -1,
 -52520,
 852944287,
 1886,
 -1,
 852976869,
 1696,
 853160668,
 852629661,
 -1,
 -52517,
 853112258,
 65225,
 -1,
 853157131,
 65227,
 -52515,
 853129193,
 65228,
 -1,
 853323187,
 65226,
 -1,
 852495660,
 1749,
 853553932,
 850301239,
 -1,
 853619439,
 853488211,
 1705,
 853737471,
 853562409,
 -1,
 853750506,
 853652903,
 -1,
 853816041,
 853730698,
 -1,
 853881576,
 853786379,
 -1,
 -52506,
 853836252,
 1892,
 -52505,
 853915766,
 1596,
 -1,
 853959909,
 1891,
 -1,
 853834789,
 1595,
 -1,
 853794012,
 1890,
 854274797,
 853678237,
 -1,
 -52500,
 854226370,
 64398,
 -1,
 854271243,
 64400,
 -52498,
 854243305,
 64401,
 -1,
 854437299,
 64399,
 854602492,
 853565943,
 1603,
 854720511,
 854545449,
 -1,
 854733559,
 854635943,
 -1,
 854799093,
 854713738,
 -1,
 -52492,
 854752293,
 1919,
 -1,
 854804639,
 1710,
 -52490,
 854730956,
 1707,
 -1,
 854973660,
 1708,
 855126778,
 854661277,
 -1,
 -52487,
 855078338,
 65241,
 -1,
 855123211,
 65243,
 -52485,
 855095273,
 65244,
 -1,
 855289267,
 65242,
 855454469,
 854535068,
 -1,
 855520001,
 855417327,
 1737,
 855638015,
 855462953,
 -1,
 -52480,
 855558221,
 64482,
 -1,
 855616947,
 64483,
 855834623,
 855451329,
 1733,
 855900159,
 855725097,
 -1,
 -52476,
 855820365,
 64480,
 -1,
 855879091,
 64481,
 856096767,
 855411016,
 1582,
 856162303,
 855987241,
 -1,
 856175370,
 856037533,
 -1,
 -52471,
 856126914,
 65189,
 -1,
 856171787,
 65191,
 -52469,
 856143849,
 65192,
 -1,
 856337843,
 65190,
 856503094,
 853499176,
 -1,
 856568609,
 856438684,
 1606,
 856686591,
 856511529,
 -1,
 856699672,
 856602023,
 -1,
 856765203,
 856679818,
 -1,
 -52462,
 856692992,
 1895,
 -1,
 856793940,
 1725,
 856961814,
 856743672,
 -1,
 -52459,
 856913096,
 1897,
 -1,
 856985617,
 1896,
 -52457,
 856893644,
 1724,
 -1,
 857116985,
 1721,
 857289500,
 856669019,
 1722,
 857407487,
 857232425,
 -1,
 -52453,
 857327693,
 64414,
 -1,
 857386419,
 64415,
 857551647,
 857217181,
 -1,
 -52450,
 857503170,
 65253,
 -1,
 857548043,
 65255,
 -52448,
 857520105,
 65256,
 -1,
 857714099,
 65254,
 857879343,
 856524493,
 1709,
 857944873,
 857821092,
 1713,
 858062847,
 857887785,
 -1,
 858075943,
 857938077,
 -1,
 -52442,
 858027458,
 64410,
 -1,
 858072331,
 64412,
 -52440,
 858044393,
 64413,
 -1,
 858238387,
 64411,
 858456063,
 857887785,
 -1,
 858469165,
 858331293,
 -1,
 -52436,
 858420674,
 64467,
 -1,
 858465547,
 64469,
 -52434,
 858437609,
 64470,
 -1,
 858631603,
 64468,
 858849279,
 857806435,
 1667,
 858914815,
 858739753,
 -1,
 858927924,
 858790045,
 -1,
 -52429,
 858879426,
 64374,
 -1,
 858924299,
 64376,
 -52427,
 858896361,
 64377,
 -1,
 859090355,
 64375,
 859255644,
 856467342,
 -1,
 859321160,
 859205562,
 1587,
 859439103,
 859264041,
 -1,
 859452227,
 859354535,
 -1,
 859517758,
 859432330,
 -1,
 859583293,
 859457695,
 1691,
 -1,
 859539579,
 1692,
 -1,
 859529333,
 1901,
 -52417,
 859469794,
 1904,
 -52416,
 859748857,
 1918,
 -52415,
 859773759,
 1884,
 -52414,
 859872895,
 1917,
 -1,
 859942299,
 1690,
 860107590,
 859379869,
 -1,
 -52411,
 860059074,
 65201,
 -1,
 860103947,
 65203,
 -52409,
 860076009,
 65204,
 -1,
 860270003,
 65202,
 860435282,
 859267569,
 1589,
 860553215,
 860378153,
 -1,
 860566349,
 860432768,
 -1,
 -52404,
 860494080,
 1693,
 -1,
 860595028,
 1694,
 860762960,
 860493981,
 -1,
 -52401,
 860714434,
 65209,
 -1,
 860759307,
 65211,
 -52399,
 860731369,
 65212,
 -1,
 860925363,
 65210,
 861090650,
 860394068,
 1588,
 861208575,
 861033513,
 -1,
 861221719,
 861083805,
 -1,
 -52394,
 861173186,
 65205,
 -1,
 861218059,
 65207,
 -52392,
 861151722,
 1786,
 -52391,
 861386729,
 65208,
 -1,
 861449651,
 65206,
 -52389,
 861019321,
 1706,
 -1,
 861541139,
 1648,
 861746048,
 859193977,
 -1,
 861811580,
 861705659,
 1610,
 861929471,
 861754409,
 -1,
 861942635,
 861844903,
 -1,
 862008167,
 861904855,
 1574,
 862126079,
 861951017,
 -1,
 862139237,
 862001309,
 -1,
 -52380,
 862090690,
 65161,
 -1,
 862135563,
 65163,
 -52378,
 862107625,
 65164,
 -1,
 862301619,
 65162,
 862466922,
 861988234,
 -1,
 -52375,
 862406815,
 1745,
 -1,
 862474228,
 1741,
 -1,
 862423096,
 1742,
 862729079,
 861889950,
 1746,
 862846975,
 862671913,
 -1,
 862860149,
 862762407,
 -1,
 862925682,
 862822359,
 1747,
 863043583,
 862868521,
 -1,
 -52367,
 862963789,
 64432,
 -1,
 863022515,
 64433,
 863240191,
 862890319,
 -1,
 -52364,
 863145293,
 1914,
 -1,
 863192741,
 1915,
 -52362,
 862832717,
 64430,
 -1,
 863350195,
 64431,
 863515514,
 862656669,
 -1,
 -52359,
 863466946,
 65265,
 -1,
 863511819,
 65267,
 -52357,
 863483881,
 65268,
 -1,
 863677875,
 65266,
 863895551,
 861747041,
 1736,
 863961087,
 863786025,
 -1,
 -52353,
 863881293,
 64475,
 -1,
 863940019,
 64476,
 864105376,
 861713671,
 -1,
 864170901,
 864064955,
 1585,
 864288767,
 864113705,
 -1,
 864301971,
 864204199,
 -1,
 864367498,
 864266126,
 -1,
 864433033,
 864295818,
 -1,
 864498568,
 864384200,
 1682,
 -1,
 864421927,
 1685,
 -1,
 864462935,
 1905,
 -1,
 864391074,
 1883,
 864760717,
 864289400,
 -1,
 -52340,
 864684437,
 1899,
 -1,
 864773349,
 1687,
 864957327,
 864719161,
 1684,
 -1,
 864906719,
 1686,
 -52336,
 864889036,
 1683,
 -52335,
 865057273,
 1775,
 -52334,
 865116119,
 1900,
 -1,
 865147711,
 1689,
 -52332,
 864274509,
 65197,
 -1,
 865316275,
 65198,
 865481628,
 864149303,
 1723,
 865599487,
 865424425,
 -1,
 865612698,
 865474717,
 -1,
 -52327,
 865564098,
 64416,
 -1,
 865608971,
 64418,
 -52325,
 865581033,
 64419,
 -1,
 865775027,
 64417,
 865992703,
 865424930,
 1681,
 866058239,
 865883177,
 -1,
 -52321,
 865978445,
 64396,
 -1,
 866037171,
 64397,
 866202560,
 864054880,
 -1,
 866268089,
 866173842,
 1576,
 866333618,
 866210857,
 -1,
 866399149,
 866301351,
 -1,
 866464682,
 866379146,
 -1,
 866530217,
 866434827,
 -1,
 866595752,
 866484700,
 1874,
 -1,
 866525957,
 1875,
 -1,
 866533333,
 1872,
 -1,
 866476472,
 1876,
 -52309,
 866420792,
 1878,
 -52308,
 866817388,
 1877,
 -1,
 866882255,
 1873,
 867054512,
 866326685,
 -1,
 -52305,
 867005890,
 65167,
 -1,
 867050763,
 65169,
 -52303,
 867022825,
 65170,
 -1,
 867216819,
 65168,
 867434495,
 866293179,
 1664,
 867500031,
 867324969,
 -1,
 867513271,
 867375261,
 -1,
 -52298,
 867464642,
 64346,
 -1,
 867509515,
 64348,
 -52296,
 867481577,
 64349,
 -1,
 867675571,
 64347,
 867893247,
 866227643,
 1659,
 867958783,
 867783721,
 -1,
 867972030,
 867834013,
 -1,
 -52291,
 867923394,
 64338,
 -1,
 867968267,
 64340,
 -52289,
 867940329,
 64341,
 -1,
 868134323,
 64339,
 868299746,
 866142279,
 -1,
 868365266,
 868239748,
 1740,
 868483071,
 868308009,
 -1,
 868496333,
 868398503,
 -1,
 868561865,
 868422493,
 -1,
 868627400,
 868541834,
 -1,
 -52281,
 868584781,
 1909,
 -1,
 868632229,
 1910,
 -1,
 868564506,
 1911,
 868889548,
 868541834,
 -1,
 -52277,
 868842533,
 1598,
 -1,
 868918100,
 1599,
 -1,
 868858361,
 1597,
 869151696,
 868423837,
 -1,
 -52273,
 869103042,
 64508,
 -1,
 869147915,
 64510,
 -52271,
 869119977,
 64511,
 -1,
 869313971,
 64509,
 869531647,
 868324795,
 1601,
 869597183,
 869422121,
 -1,
 869610461,
 869512615,
 -1,
 869675994,
 869590410,
 -1,
 869741529,
 869646091,
 -1,
 -52264,
 869695964,
 1889,
 -1,
 869775478,
 1701,
 -1,
 869669120,
 1888,
 870055935,
 869640047,
 -1,
 -52260,
 869941336,
 1698,
 -1,
 870037622,
 1699,
 870200288,
 869537949,
 -1,
 -52257,
 870151618,
 65233,
 -1,
 870196491,
 65235,
 -52255,
 870168553,
 65236,
 -1,
 870362547,
 65234,
 870527998,
 868255437,
 -1,
 870593519,
 870474231,
 1711,
 870711295,
 870536233,
 -1,
 870724586,
 870626727,
 -1,
 870790121,
 870704522,
 -1,
 -52248,
 870717696,
 1714,
 -1,
 870818644,
 1716,
 -1,
 870721740,
 1712,
 871052269,
 870652061,
 -1,
 -52244,
 871003586,
 64402,
 -1,
 871048459,
 64404,
 -52242,
 871020521,
 64405,
 -1,
 871214515,
 64403,
 871379959,
 870570915,
 1594,
 871497727,
 871322665,
 -1,
 871511028,
 871372957,
 -1,
 -52237,
 871462338,
 65229,
 -1,
 871507211,
 65231,
 -52235,
 871440874,
 1788,
 -52234,
 871675881,
 65232,
 -1,
 871738803,
 65230,
 871956479,
 871352539,
 1715,
 872022015,
 871846953,
 -1,
 872035324,
 871897245,
 -1,
 -52229,
 871986626,
 64406,
 -1,
 872031499,
 64408,
 -52227,
 872003561,
 64409,
 -1,
 872197555,
 64407,
 872363021,
 870499553,
 1608,
 872480767,
 872305705,
 -1,
 872494091,
 872396199,
 -1,
 872559621,
 872456151,
 1572,
 872677375,
 872502313,
 -1,
 -52220,
 872597581,
 65157,
 -1,
 872656307,
 65158,
 872821768,
 872524111,
 -1,
 -52217,
 872779085,
 1912,
 -1,
 872826533,
 1913,
 -52215,
 872756988,
 1738,
 -52214,
 872949964,
 1732,
 -1,
 873061596,
 1743,
 -52212,
 872466509,
 65261,
 -1,
 873180595,
 65262,
 873346075,
 872304382,
 1662,
 873411605,
 873305531,
 1702,
 873529343,
 873354281,
 -1,
 873542675,
 873404573,
 -1,
 -52206,
 873493954,
 64366,
 -1,
 873538827,
 64368,
 -52204,
 873510889,
 64369,
 -1,
 873704883,
 64367,
 873922559,
 873354281,
 -1,
 873935897,
 873797789,
 -1,
 -52200,
 873887170,
 64342,
 -1,
 873932043,
 64344,
 -52198,
 873904105,
 64345,
 -1,
 874098099,
 64343,
 874263593,
 873305349,
 1604,
 874381311,
 874206249,
 -1,
 874394660,
 874296743,
 -1,
 874460193,
 874373591,
 -1,
 -52192,
 874428534,
 1720,
 -1,
 874472677,
 1719,
 -52190,
 874416184,
 1717,
 -52189,
 874634460,
 1718,
 -1,
 874647746,
 1898,
 874853415,
 874322077,
 -1,
 -52186,
 874804674,
 65245,
 -1,
 874849547,
 65247,
 -52184,
 874821609,
 65248,
 -1,
 875015603,
 65246,
 875181109,
 874229545,
 -1,
 875246641,
 875152274,
 1592,
 875364351,
 875189289,
 -1,
 875377711,
 875239581,
 -1,
 -52178,
 875328962,
 65221,
 -1,
 875373835,
 65223,
 -52176,
 875345897,
 65224,
 -1,
 875539891,
 65222,
 875757567,
 875218342,
 1586,
 875823103,
 875648041,
 -1,
 -52172,
 875743309,
 65199,
 -1,
 875802035,
 65200,
 875967552,
 875134205,
 1739,
 876033085,
 875938706,
 1700,
 876150783,
 875975721,
 -1,
 876164155,
 876026013,
 -1,
 -52166,
 876115394,
 64362,
 -1,
 876160267,
 64364,
 -52164,
 876132329,
 64365,
 -1,
 876326323,
 64363,
 876543999,
 875975721,
 -1,
 -52161,
 876464205,
 64478,
 -1,
 876522931,
 64479,
 876688460,
 875914114,
 -1,
 876753992,
 876647852,
 1580,
 876871679,
 876696617,
 -1,
 876885062,
 876746909,
 -1,
 -52155,
 876836290,
 65181,
 -1,
 876881163,
 65183,
 -52153,
 876853225,
 65184,
 -1,
 877047219,
 65182,
 877264895,
 876725138,
 1688,
 877330431,
 877155369,
 -1,
 -52149,
 877250637,
 64394,
 -1,
 877309363,
 64395,
 877474901,
 876623713,
 1735,
 877540434,
 877417513,
 -1,
 877605968,
 877517461,
 1655,
 -1,
 877558759,
 64477,
 -52143,
 877578317,
 64471,
 -1,
 877702579,
 64472,
 877920255,
 877486710,
 -1,
 -52140,
 877836265,
 64489,
 -1,
 877904792,
 64488,
 878064735,
 877431067,
 1602,
 878182399,
 878007337,
 -1,
 878195802,
 878097831,
 -1,
 -52135,
 878157133,
 1704,
 -1,
 878238940,
 1703,
 878392413,
 878123165,
 -1,
 -52132,
 878343618,
 65237,
 -1,
 878388491,
 65239,
 -52130,
 878360553,
 65240,
 -1,
 878554547,
 65238,
 878720105,
 878002255,
 1605,
 878837759,
 878662697,
 -1,
 878851172,
 878724350,
 -1,
 -52125,
 878819446,
 1894,
 -1,
 878863589,
 1893,
 879047783,
 878778525,
 -1,
 -52122,
 878998978,
 65249,
 -1,
 879043851,
 65251,
 -52120,
 879015913,
 65252,
 -1,
 879209907,
 65250,
 879375472,
 878644524,
 1744,
 879493119,
 879318057,
 -1,
 879506542,
 879368349,
 -1,
 -52115,
 879457730,
 64484,
 -1,
 879502603,
 64486,
 -52113,
 879474665,
 64487,
 -1,
 879668659,
 64485,
 879886335,
 879306433,
 1734,
 879951871,
 879776809,
 -1,
 -52109,
 879872077,
 64473,
 -1,
 879930803,
 64474,
 880096432,
 787195790,
 -1,
 880161941,
 880024458,
 -1,
 880227469,
 880113992,
 -1,
 880292989,
 880201359,
 -1,
 880358524,
 880230758,
 -1,
 -52102,
 880308191,
 1750,
 -52101,
 880364022,
 1751,
 -1,
 880441549,
 1558,
 -1,
 880280051,
 1753,
 880686210,
 880222804,
 -1,
 880751745,
 880649416,
 -1,
 -52096,
 880702914,
 1762,
 -1,
 880747787,
 1752,
 -1,
 880722853,
 1764,
 881013893,
 880665994,
 -1,
 -52092,
 880991969,
 1755,
 -1,
 881025533,
 1557,
 -52090,
 880989816,
 1559,
 -52089,
 881137251,
 1767,
 -52088,
 881197344,
 1760,
 -52087,
 881283862,
 1756,
 -52086,
 881348089,
 1759,
 -52085,
 881450807,
 1768,
 -52084,
 881463097,
 1754,
 -1,
 881535933,
 1761,
 881734800,
 880163813,
 -1,
 -52081,
 881677078,
 1763,
 -1,
 881737807,
 1773,
 -52079,
 881661539,
 1766,
 -52078,
 881902817,
 1765,
 -52077,
 881925200,
 1562,
 -52076,
 882022213,
 1560,
 -1,
 882083115,
 1561,
 882259108,
 880122362,
 -1,
 882324638,
 882222990,
 -1,
 882390171,
 882246451,
 -1,
 -52071,
 882317602,
 1537,
 -52070,
 882429520,
 1552,
 -1,
 882457134,
 1539,
 882704383,
 882354436,
 -1,
 -52067,
 882607191,
 1790,
 -1,
 882676040,
 1789,
 882848929,
 882264489,
 -1,
 -52064,
 882809557,
 1554,
 -1,
 882862904,
 1555,
 -52062,
 882827811,
 1556,
 -52061,
 883005620,
 1551,
 -1,
 883035799,
 1553,
 883242154,
 882194273,
 -1,
 883307689,
 883187920,
 1618,
 883425279,
 883250217,
 -1,
 -52056,
 883341289,
 65151,
 -1,
 883411021,
 65150,
 -1,
 883241810,
 1622,
 883635374,
 883209676,
 1617,
 883752959,
 883577897,
 -1,
 -52051,
 883668969,
 65149,
 -1,
 883738701,
 65148,
 -52049,
 883568092,
 1758,
 -1,
 883870160,
 1563,
 884028603,
 880035911,
 -1,
 884094136,
 883977883,
 1614,
 884159670,
 884036649,
 -1,
 -52044,
 884120793,
 1630,
 -52043,
 884193257,
 65143,
 -1,
 884262989,
 65142,
 884473855,
 884117513,
 1611,
 -1,
 884374503,
 65136,
 -52039,
 884017483,
 1748,
 -52038,
 884487892,
 1538,
 -1,
 884591553,
 1645,
 884749509,
 883996923,
 -1,
 884815044,
 884671283,
 -1,
 884880579,
 884754515,
 1615,
 884946112,
 884838409,
 1612,
 -1,
 884898791,
 65138,
 885129215,
 884888617,
 -1,
 -52030,
 885045225,
 65145,
 -1,
 885114957,
 65144,
 -1,
 884820562,
 1549,
 -1,
 884763124,
 1643,
 885404876,
 884729226,
 -1,
 885470410,
 885326643,
 -1,
 885535945,
 885437648,
 1600,
 -1,
 885499348,
 65137,
 -1,
 885495415,
 65139,
 -52021,
 885427568,
 1566,
 -1,
 885701530,
 1644,
 885863634,
 885333072,
 1616,
 885929167,
 885821449,
 1613,
 -1,
 885881831,
 65140,
 886112255,
 885871657,
 -1,
 -52015,
 886028265,
 65147,
 -1,
 886097997,
 65146,
 886256854,
 885820469,
 -1,
 -52012,
 886186631,
 1626,
 -52011,
 886270862,
 1627,
 -1,
 886346041,
 1628,
 886519002,
 886224135,
 -1,
 -52008,
 886470530,
 1772,
 -52007,
 886509382,
 1629,
 -1,
 886607326,
 1544,
 886781150,
 886495648,
 -1,
 -52004,
 886749538,
 1550,
 -52003,
 886784774,
 1769,
 -1,
 886875789,
 1642,
 887043299,
 886705452,
 -1,
 887108834,
 886997863,
 -1,
 -51999,
 887059196,
 1770,
 -1,
 887134439,
 1771,
 -1,
 887062325,
 1757,
 887370982,
 886968230,
 -1,
 -51995,
 887311344,
 1624,
 -1,
 887381441,
 1619,
 887567593,
 887329369,
 -1,
 -51992,
 887535734,
 1621,
 -1,
 887579877,
 1620,
 -51990,
 887544654,
 1625,
 -51989,
 887731939,
 1567,
 -51988,
 887778816,
 1536,
 -51987,
 887817207,
 1623,
 -1,
 887924215,
 1548,
 888143871,
 787140949,
 -1,
 888157437,
 888070513,
 -1,
 888222963,
 888137098,
 -1,
 -51982,
 888178929,
 1634,
 -1,
 888244243,
 1635,
 888419574,
 888186766,
 -1,
 -51979,
 888391019,
 1638,
 -1,
 888420990,
 1639,
 888616185,
 888358983,
 -1,
 -51976,
 888574450,
 1636,
 -1,
 888612866,
 1637,
 -51974,
 888539491,
 1632,
 -51973,
 888779064,
 1633,
 -51972,
 888812086,
 1641,
 -1,
 888914122,
 1640,
 889074944,
 888094582,
 -1,
 -51969,
 888995840,
 1546,
 -1,
 889112829,
 1545,
 -51967,
 889030270,
 1543,
 -1,
 889233528,
 1542,
 889402750,
 787045528,
 -1,
 889468223,
 889358384,
 -1,
 889533751,
 889430352,
 -1,
 889599243,
 889486192,
 -1,
 889664777,
 889570194,
 -1,
 -51960,
 889623995,
 1395,
 -1,
 889652019,
 1401,
 -51958,
 889625848,
 1409,
 -1,
 889783091,
 1390,
 889992463,
 889523500,
 -1,
 -51955,
 889972106,
 1384,
 -51954,
 890028946,
 1383,
 -1,
 890076231,
 1381,
 890254610,
 889946059,
 -1,
 -51951,
 890223030,
 1386,
 -1,
 890241843,
 1382,
 890451220,
 890216861,
 1397,
 -1,
 890407156,
 1410,
 890582295,
 890401992,
 -1,
 -51946,
 890543352,
 1400,
 -1,
 890607085,
 1406,
 890778906,
 890561930,
 -1,
 -51943,
 890739960,
 1385,
 -1,
 890804216,
 1407,
 890975517,
 890742670,
 -1,
 -51940,
 890943923,
 1399,
 -1,
 891000251,
 1405,
 891172128,
 890942727,
 -1,
 -51937,
 891131323,
 1408,
 -1,
 891159347,
 1404,
 891368739,
 891148704,
 -1,
 -51934,
 891328517,
 1411,
 -1,
 891393467,
 1402,
 891565350,
 891346898,
 -1,
 -51931,
 891510056,
 1391,
 -1,
 891601810,
 1412,
 891761961,
 891507404,
 -1,
 -51928,
 891722274,
 1403,
 -1,
 891749171,
 1393,
 891958572,
 891717325,
 -1,
 -51925,
 891930016,
 1379,
 -1,
 891980142,
 1394,
 -51923,
 891897053,
 1389,
 -51922,
 892085944,
 1413,
 -51921,
 892142005,
 1398,
 -51920,
 892217735,
 1396,
 -51919,
 892303001,
 1388,
 -51918,
 892356504,
 1387,
 -51917,
 892451230,
 1392,
 -51916,
 892498227,
 1414,
 -51915,
 892569616,
 1380,
 -51914,
 892600586,
 1378,
 -1,
 892704022,
 1377,
 892927999,
 889471334,
 -1,
 892941629,
 892848859,
 -1,
 -51910,
 892880093,
 64279,
 -51909,
 892928437,
 64275,
 -51908,
 893011864,
 64277,
 -1,
 893089799,
 64276,
 -51906,
 892891542,
 64278,
 -1,
 893214713,
 1415,
 893400436,
 889420656,
 -1,
 893465971,
 893327178,
 -1,
 893531463,
 893418352,
 -1,
 893596997,
 893502354,
 -1,
 -51900,
 893556155,
 1347,
 -1,
 893584179,
 1353,
 -51898,
 893558008,
 1361,
 -1,
 893715251,
 1342,
 893924683,
 893455660,
 -1,
 -51895,
 893904266,
 1336,
 -51894,
 893961106,
 1335,
 -1,
 894008391,
 1333,
 894186830,
 893878219,
 -1,
 -51891,
 894155190,
 1338,
 -1,
 894174003,
 1334,
 894383440,
 894149021,
 1349,
 -1,
 894339316,
 1362,
 894514515,
 894334152,
 -1,
 -51886,
 894475512,
 1352,
 -1,
 894539245,
 1358,
 894711126,
 894494090,
 -1,
 -51883,
 894672120,
 1337,
 -1,
 894736376,
 1359,
 894907737,
 894674830,
 -1,
 -51880,
 894876083,
 1351,
 -1,
 894932411,
 1357,
 895104348,
 894874887,
 -1,
 -51877,
 895063483,
 1360,
 -1,
 895091507,
 1356,
 895300959,
 895080864,
 -1,
 -51874,
 895260677,
 1363,
 -1,
 895325627,
 1354,
 895497570,
 895279058,
 -1,
 -51871,
 895442216,
 1343,
 -1,
 895533970,
 1364,
 895694181,
 895439564,
 -1,
 -51868,
 895654434,
 1355,
 -1,
 895681331,
 1345,
 895890792,
 895649485,
 -1,
 -51865,
 895862176,
 1331,
 -1,
 895912302,
 1346,
 -51863,
 895829213,
 1341,
 -51862,
 896018104,
 1365,
 -51861,
 896074165,
 1350,
 -51860,
 896149895,
 1348,
 -51859,
 896235161,
 1340,
 -51858,
 896288664,
 1339,
 -51857,
 896383390,
 1344,
 -51856,
 896430387,
 1366,
 -51855,
 896501776,
 1332,
 -51854,
 896532746,
 1330,
 -1,
 896636182,
 1329,
 -1,
 893419856,
 1373,
 896873847,
 893324588,
 -1,
 -51850,
 896796683,
 1372,
 -1,
 896908409,
 1371,
 897070458,
 896795443,
 -1,
 -51847,
 897028460,
 1370,
 -1,
 897100658,
 1375,
 -51845,
 897038051,
 1374,
 -51844,
 897217438,
 1369,
 -51843,
 897282671,
 1418,
 -1,
 897320471,
 1417,
 897529221,
 889340709,
 -1,
 897594754,
 897458358,
 -1,
 -51839,
 897534508,
 10548,
 -1,
 897583758,
 10549,
 897843199,
 897531093,
 -1,
 -51836,
 897755575,
 10551,
 -1,
 897809354,
 10550,
 -51834,
 897508162,
 9800,
 -1,
 897940336,
 8978,
 898119156,
 787012000,
 -1,
 898184683,
 898078387,
 -1,
 898250153,
 898121418,
 -1,
 898315686,
 898195953,
 9109,
 898433023,
 898257961,
 -1,
 898446741,
 898349307,
 -1,
 898512272,
 898407121,
 -1,
 -51825,
 898460605,
 9047,
 -1,
 898528849,
 9036,
 898708883,
 898439325,
 -1,
 -51822,
 898682475,
 9017,
 -1,
 898739780,
 9018,
 898957311,
 898667951,
 9044,
 -1,
 898851298,
 9037,
 899036568,
 898396308,
 -1,
 -51817,
 898984893,
 9040,
 -1,
 899053137,
 9043,
 899233179,
 898958072,
 -1,
 -51814,
 899168068,
 9027,
 -1,
 899272890,
 9031,
 899429790,
 899185520,
 -1,
 -51811,
 899377131,
 9056,
 -1,
 899464265,
 9020,
 -51809,
 899376939,
 9025,
 -51808,
 899603583,
 9032,
 -51807,
 899632335,
 9072,
 -51806,
 899684571,
 9071,
 -51805,
 899773964,
 9019,
 -51804,
 899865512,
 9028,
 -51803,
 899899754,
 9016,
 -1,
 899952564,
 9026,
 900202495,
 898245066,
 -1,
 -51800,
 900086172,
 9048,
 -1,
 900147502,
 9054,
 900347323,
 898218235,
 -1,
 900412850,
 900307665,
 -1,
 900478385,
 900355113,
 -1,
 900543919,
 900408543,
 -1,
 -51794,
 900479388,
 9034,
 -1,
 900560396,
 9038,
 -51792,
 900508187,
 9062,
 -1,
 900669139,
 9073,
 -1,
 900422381,
 9046,
 900937146,
 900371887,
 -1,
 901002679,
 900879401,
 -1,
 -51787,
 900928570,
 9067,
 -51786,
 901046165,
 9042,
 -1,
 901086942,
 9058,
 901316607,
 900960368,
 -1,
 -51783,
 901200284,
 9049,
 -1,
 901308309,
 9035,
 -1,
 900916168,
 9050,
 901526981,
 900299632,
 -1,
 901592516,
 901453450,
 -1,
 901658048,
 901531445,
 -1,
 -51777,
 901598957,
 9021,
 -1,
 901669397,
 9055,
 -51775,
 901593500,
 9052,
 -51774,
 901805580,
 9022,
 -51773,
 901873374,
 9061,
 -1,
 901918644,
 9033,
 -1,
 901538884,
 9066,
 902182350,
 901476500,
 -1,
 902247885,
 902124585,
 -1,
 902313419,
 902178015,
 -1,
 -51767,
 902282489,
 9041,
 -51766,
 902329868,
 9045,
 -1,
 902397662,
 9057,
 -51764,
 902273677,
 9053,
 -1,
 902504147,
 9074,
 -1,
 902191853,
 9039,
 902772181,
 902145934,
 -1,
 902837714,
 902751626,
 -1,
 -51759,
 902794912,
 9069,
 -1,
 902882706,
 9059,
 -51757,
 902811088,
 9015,
 -51756,
 902981257,
 9023,
 -1,
 903054113,
 9070,
 903230937,
 902699165,
 -1,
 903296472,
 903160436,
 9075,
 -1,
 903256277,
 9080,
 -1,
 903237378,
 9014,
 903493084,
 903197959,
 -1,
 -51749,
 903439785,
 9030,
 -1,
 903526814,
 9076,
 903689694,
 903439532,
 9077,
 -1,
 903649493,
 9081,
 903820769,
 903632475,
 -1,
 -51744,
 903764717,
 9029,
 -1,
 903837055,
 9063,
 904017380,
 903785081,
 -1,
 -51741,
 903952796,
 9051,
 -1,
 904036062,
 9060,
 904213990,
 903974789,
 9082,
 -1,
 904173781,
 9078,
 -51737,
 904185744,
 9068,
 -51736,
 904276242,
 9064,
 -51735,
 904354283,
 9065,
 -51734,
 904402115,
 9079,
 -1,
 904484340,
 9024,
 904672755,
 898135584,
 -1,
 904738290,
 904602534,
 -1,
 904803825,
 904670101,
 -1,
 904869360,
 904749493,
 8773,
 -1,
 904834936,
 8786,
 -1,
 904822142,
 10864,
 -1,
 904760662,
 8774,
 -1,
 904691785,
 8784,
 -1,
 904601383,
 39,
 905262660,
 898095724,
 -1,
 905328179,
 905204420,
 -1,
 905393671,
 905307530,
 -1,
 905459198,
 905360197,
 -1,
 905524732,
 905420024,
 65800,
 905641983,
 905466921,
 -1,
 -51717,
 905544542,
 65827,
 -1,
 905592899,
 65818,
 905838591,
 905491775,
 65809,
 -1,
 905747756,
 65836,
 905917957,
 905429906,
 -1,
 905983491,
 905860691,
 65801,
 906100735,
 905925673,
 -1,
 -51710,
 906003294,
 65828,
 -1,
 906051651,
 65819,
 906297343,
 905950778,
 65810,
 -1,
 906206508,
 65837,
 906428415,
 905876917,
 65808,
 -1,
 906337580,
 65835,
 906507796,
 905357198,
 -1,
 906573326,
 906478955,
 65804,
 906638859,
 906529807,
 65813,
 -1,
 906599724,
 65840,
 906821631,
 906581033,
 -1,
 -51699,
 906724190,
 65831,
 -1,
 906772547,
 65822,
 907018239,
 906508926,
 65805,
 907032081,
 906923023,
 65814,
 -1,
 906992940,
 65841,
 907214847,
 906974249,
 -1,
 -51693,
 907117406,
 65832,
 -1,
 907165763,
 65823,
 907359779,
 906446919,
 -1,
 907425308,
 907320568,
 -1,
 907490842,
 907402477,
 65802,
 907608063,
 907433001,
 -1,
 -51687,
 907510622,
 65829,
 -1,
 907558979,
 65820,
 907804671,
 907445957,
 65811,
 -1,
 907713836,
 65838,
 907935743,
 907352221,
 -1,
 907949601,
 907836669,
 65803,
 908066815,
 907891753,
 -1,
 -51680,
 907969374,
 65830,
 -1,
 908017731,
 65821,
 908263423,
 907911350,
 65812,
 -1,
 908172588,
 65839,
 908342825,
 907293238,
 65807,
 908408358,
 908299279,
 65816,
 -1,
 908369196,
 65843,
 908591103,
 908350505,
 -1,
 -51672,
 908493662,
 65834,
 -1,
 908542019,
 65825,
 908736047,
 908312778,
 65806,
 908801580,
 908673657,
 65815,
 -1,
 908762412,
 65842,
 908984319,
 908743721,
 -1,
 -51666,
 908886878,
 65833,
 -1,
 908935235,
 65824,
 909180927,
 908702008,
 65799,
 909246463,
 909071401,
 -1,
 -51662,
 909149022,
 65826,
 -1,
 909197379,
 65817,
 909391422,
 905294661,
 -1,
 909456955,
 909318630,
 -1,
 909522488,
 909396039,
 -1,
 -51657,
 909462117,
 65851,
 -1,
 909554193,
 65848,
 -51655,
 909501662,
 65850,
 -51654,
 909668736,
 65849,
 -1,
 909739132,
 65847,
 909967359,
 909398063,
 -1,
 -51651,
 909889065,
 65792,
 -1,
 909905978,
 65793,
 910112321,
 909360289,
 -1,
 -51648,
 910091486,
 65855,
 -1,
 910127488,
 65854,
 -51646,
 910080759,
 65853,
 -51645,
 910254151,
 65852,
 -1,
 910332998,
 65794,
 910505609,
 905229606,
 -1,
 910571144,
 910435685,
 -1,
 910636622,
 910492467,
 68352,
 910702154,
 910558003,
 68353,
 -51639,
 910662904,
 68355,
 -1,
 910712104,
 68357,
 910898764,
 910626092,
 68358,
 -1,
 910822700,
 68359,
 -51635,
 910859512,
 68354,
 -1,
 910974248,
 68356,
 911160918,
 910581032,
 -1,
 911226451,
 911115981,
 -1,
 -51631,
 911188426,
 68387,
 -51630,
 911244541,
 68388,
 -1,
 911281452,
 68386,
 -51628,
 911188426,
 68390,
 -51627,
 911416099,
 68391,
 -1,
 911478060,
 68389,
 911685212,
 911124366,
 -1,
 911750746,
 911655826,
 -1,
 -51623,
 911712714,
 68403,
 -1,
 911740204,
 68401,
 -51621,
 911723596,
 68404,
 -1,
 911871276,
 68399,
 912078432,
 911607727,
 -1,
 -51618,
 912040394,
 68370,
 -51617,
 912096509,
 68371,
 -1,
 912133420,
 68369,
 912340580,
 912057738,
 -1,
 -51614,
 912286175,
 68381,
 -51613,
 912374198,
 68378,
 -1,
 912395564,
 68377,
 912602728,
 912295629,
 -1,
 -51610,
 912570806,
 68374,
 -51609,
 912633485,
 68373,
 -1,
 912657708,
 68372,
 912864875,
 912555979,
 -1,
 -51606,
 912832950,
 68402,
 -1,
 912854316,
 68400,
 913061486,
 912802425,
 -1,
 -51603,
 913023434,
 68394,
 -1,
 913050924,
 68395,
 913258096,
 912996193,
 68366,
 -1,
 913192801,
 68367,
 913389170,
 913218808,
 68362,
 -1,
 913349880,
 68363,
 913520244,
 913315997,
 68364,
 -1,
 913447069,
 68365,
 913651319,
 913490834,
 -1,
 -51594,
 913575843,
 68393,
 -1,
 913640748,
 68405,
 913847929,
 913575212,
 68360,
 -1,
 913771820,
 68361,
 913979004,
 913815803,
 -1,
 -51589,
 913947062,
 68380,
 -1,
 913968428,
 68379,
 914175615,
 913915328,
 -1,
 -51586,
 914143670,
 68385,
 -1,
 914165036,
 68384,
 -51584,
 914128125,
 68396,
 -51583,
 914311590,
 68397,
 -51582,
 914371136,
 68382,
 -51581,
 914427811,
 68392,
 -51580,
 914490104,
 68398,
 -51579,
 914612178,
 68368,
 -51578,
 914645890,
 68376,
 -51577,
 914727182,
 68383,
 -1,
 914783315,
 68375,
 -1,
 910532425,
 68409,
 915027611,
 910449960,
 -1,
 915093138,
 914960620,
 -1,
 915158670,
 915045232,
 -1,
 -51571,
 915117046,
 8755,
 -1,
 915197661,
 10560,
 -51569,
 915131567,
 8630,
 -51568,
 915315253,
 8634,
 -51567,
 915380750,
 10769,
 -1,
 915438273,
 10226,
 915617432,
 915048141,
 -1,
 915682967,
 915538680,
 8736,
 915800063,
 915621151,
 -1,
 -51562,
 915683740,
 10660,
 -1,
 915750765,
 10654,
 -1,
 915660657,
 8491,
 -51559,
 915595224,
 9765,
 -51558,
 915969424,
 10193,
 -1,
 916034356,
 9875,
 916207273,
 915000975,
 -1,
 916272800,
 916171984,
 -1,
 916338335,
 916218293,
 8776,
 -1,
 916274685,
 10863,
 -1,
 916290942,
 8778,
 916534947,
 916232378,
 -1,
 -51550,
 916474113,
 9095,
 -1,
 916551915,
 9941,
 916731558,
 916456250,
 -1,
 -51547,
 916688880,
 8780,
 -1,
 916739762,
 9006,
 916979711,
 916655404,
 -1,
 -51544,
 916888069,
 9879,
 -1,
 916914743,
 8501,
 917124785,
 916170638,
 -1,
 917190318,
 917065521,
 -1,
 917255853,
 917147959,
 42,
 -1,
 917227000,
 8727,
 -1,
 917185108,
 8258,
 -51537,
 917164184,
 8771,
 -51536,
 917415704,
 8870,
 -1,
 917486053,
 9738,
 917649082,
 917076848,
 -1,
 917714613,
 917611240,
 -1,
 -51532,
 917656612,
 10655,
 -1,
 917723701,
 180,
 917911224,
 917687225,
 -1,
 -51529,
 917860691,
 8299,
 -1,
 917951131,
 8301,
 -51527,
 917866849,
 8448,
 -1,
 918070633,
 9190,
 918238909,
 917578324,
 -1,
 -51524,
 918202103,
 38,
 -1,
 918239657,
 10815,
 918435520,
 918206715,
 -1,
 -51521,
 918363655,
 9772,
 -1,
 918442395,
 8449,
 -51519,
 918409013,
 8371,
 -51518,
 918560874,
 9883,
 -51517,
 918659985,
 9810,
 -51516,
 918699931,
 8525,
 -51515,
 918783080,
 9992,
 -1,
 918816534,
 1547,
 919026647,
 786907769,
 -1,
 919092182,
 918952093,
 -1,
 919157717,
 919032873,
 -1,
 919223175,
 919097460,
 -1,
 919287695,
 919166248,
 -1,
 919353065,
 919240651,
 -1,
 919418579,
 919287649,
 41727,
 919484111,
 919385351,
 41730,
 -1,
 919406511,
 41729,
 919615185,
 919444728,
 41721,
 -1,
 919537583,
 41720,
 -51502,
 919537583,
 41726,
 -1,
 919722400,
 41728,
 919877338,
 919345309,
 41711,
 919942871,
 919801132,
 41714,
 -51498,
 919865263,
 41713,
 -1,
 919984544,
 41715,
 -51496,
 919865263,
 41710,
 -51495,
 920118666,
 41709,
 -1,
 920181152,
 41712,
 920336096,
 919814777,
 41733,
 920401629,
 920302855,
 41736,
 -1,
 920324015,
 41735,
 -51490,
 920324015,
 41732,
 -51489,
 920511882,
 41731,
 -1,
 920574368,
 41734,
 920729316,
 920257331,
 41718,
 -51486,
 920651695,
 41717,
 -51485,
 920774026,
 41716,
 -1,
 920836512,
 41719,
 920991463,
 920689912,
 -1,
 -51482,
 920913839,
 41722,
 -1,
 921033120,
 41723,
 921239551,
 920915244,
 41725,
 -1,
 921110447,
 41724,
 921319173,
 919289280,
 -1,
 921384689,
 921245853,
 41080,
 921450222,
 921308460,
 41083,
 -51475,
 921372591,
 41082,
 -1,
 921491872,
 41084,
 -51473,
 921372591,
 41079,
 -51472,
 921625994,
 41078,
 -1,
 921688480,
 41081,
 921843447,
 921322105,
 41101,
 921908980,
 921810183,
 41104,
 -1,
 921831343,
 41103,
 -51467,
 921831343,
 41100,
 -51466,
 922019210,
 41099,
 -1,
 922081696,
 41102,
 922236669,
 921778017,
 41095,
 922302202,
 922203399,
 41098,
 -1,
 922224559,
 41097,
 -51461,
 922224559,
 41094,
 -51460,
 922412426,
 41093,
 -1,
 922474912,
 41096,
 922629889,
 922197240,
 41091,
 -51457,
 922552239,
 41090,
 -51456,
 922674570,
 41089,
 -1,
 922737056,
 41092,
 922943487,
 922551091,
 41087,
 -51453,
 922814383,
 41086,
 -51452,
 922936714,
 41085,
 -1,
 922999200,
 41088,
 923154207,
 921260748,
 -1,
 923219726,
 923080861,
 42035,
 923285259,
 923143468,
 42039,
 -51447,
 923207599,
 42038,
 -51446,
 923329930,
 42037,
 -1,
 923392416,
 42040,
 -51444,
 923207599,
 42034,
 -51443,
 923526538,
 42033,
 -1,
 923589024,
 42036,
 923744021,
 923154273,
 42048,
 923809553,
 923710727,
 42051,
 -1,
 923731887,
 42050,
 923940627,
 923770104,
 42042,
 -1,
 923862959,
 42041,
 -51436,
 923862959,
 42047,
 -1,
 924047776,
 42049,
 924202779,
 923681401,
 42054,
 924268312,
 924169479,
 42057,
 -1,
 924190639,
 42056,
 -51431,
 924190639,
 42053,
 -51430,
 924378506,
 42052,
 -1,
 924440992,
 42055,
 924647423,
 924163320,
 42045,
 -51427,
 924518319,
 42044,
 -51426,
 924640650,
 42043,
 -1,
 924703136,
 42046,
 924858167,
 923120903,
 -1,
 924923686,
 924795513,
 41895,
 924989219,
 924890375,
 41898,
 -1,
 924911535,
 41897,
 -51420,
 924911535,
 41894,
 -51419,
 925099402,
 41893,
 -1,
 925161888,
 41896,
 925316908,
 924858209,
 41889,
 925382441,
 925283591,
 41892,
 -1,
 925304751,
 41891,
 -51414,
 925304751,
 41888,
 -51413,
 925492618,
 41887,
 -1,
 925555104,
 41890,
 925710128,
 925240620,
 41885,
 -51410,
 925632431,
 41884,
 -51409,
 925754762,
 41883,
 -1,
 925817248,
 41886,
 925972276,
 925631283,
 41878,
 -51406,
 925894575,
 41877,
 -51405,
 926016906,
 41876,
 -1,
 926079392,
 41879,
 926285823,
 925932792,
 41881,
 -51402,
 926156719,
 41880,
 -1,
 926276000,
 41882,
 926431055,
 924825851,
 -1,
 926496574,
 926365537,
 41316,
 926562107,
 926463239,
 41319,
 -1,
 926484399,
 41318,
 -51396,
 926484399,
 41315,
 -51395,
 926672266,
 41314,
 -1,
 926734752,
 41317,
 926889796,
 926423197,
 41299,
 926955329,
 926813484,
 41302,
 -1,
 926877615,
 41301,
 -51390,
 926877615,
 41298,
 -51389,
 927065482,
 41297,
 -1,
 927127968,
 41300,
 927283016,
 926850296,
 41309,
 -51386,
 927205295,
 41308,
 -51385,
 927327626,
 41307,
 -1,
 927390112,
 41310,
 927545164,
 927204147,
 41305,
 -51382,
 927467439,
 41304,
 -51381,
 927589770,
 41303,
 -1,
 927652256,
 41306,
 927858687,
 927468844,
 41312,
 -51378,
 927729583,
 41311,
 -1,
 927848864,
 41313,
 928003939,
 926368377,
 -1,
 928069464,
 927930525,
 42060,
 928134997,
 927993132,
 42064,
 -51373,
 928057263,
 42063,
 -51372,
 928179594,
 42062,
 -1,
 928242080,
 42065,
 -51370,
 928057263,
 42059,
 -51369,
 928376202,
 42058,
 -1,
 928438688,
 42061,
 928593759,
 928003937,
 42075,
 928659292,
 928554232,
 42067,
 -51365,
 928581551,
 42066,
 -1,
 928700832,
 42068,
 -51363,
 928581551,
 42074,
 -51362,
 928834954,
 42073,
 -1,
 928897440,
 42076,
 929103871,
 928554232,
 42071,
 -51359,
 928974767,
 42070,
 -51358,
 929097098,
 42069,
 -1,
 929159584,
 42072,
 929314677,
 927958733,
 -1,
 929380200,
 929275128,
 41577,
 -51354,
 929302447,
 41576,
 -51353,
 929424778,
 41575,
 -1,
 929487264,
 41578,
 929642348,
 929301299,
 41570,
 -51350,
 929564591,
 41569,
 -51349,
 929686922,
 41568,
 -1,
 929749408,
 41571,
 929904495,
 929619230,
 41574,
 -51346,
 929826735,
 41573,
 -1,
 929949066,
 41572,
 930101106,
 929875375,
 41566,
 -51343,
 930023343,
 41565,
 -1,
 930142624,
 41567,
 930349055,
 930024748,
 41580,
 -51340,
 930219951,
 41579,
 -1,
 930339232,
 41581,
 930494334,
 929249121,
 41363,
 930559865,
 930454776,
 41352,
 -51336,
 930482095,
 41351,
 -1,
 930601376,
 41353,
 930756475,
 930526471,
 41366,
 -1,
 930678703,
 41365,
 -51332,
 930678703,
 41362,
 -51331,
 930866570,
 41361,
 -1,
 930929056,
 41364,
 931084165,
 930420893,
 41343,
 931149698,
 931007788,
 41346,
 -51327,
 931071919,
 41345,
 -1,
 931191200,
 41347,
 -51325,
 931071919,
 41342,
 -51324,
 931325322,
 41341,
 -1,
 931387808,
 41344,
 931542921,
 931044600,
 41356,
 -51321,
 931465135,
 41355,
 -51320,
 931587466,
 41354,
 -1,
 931649952,
 41357,
 931805068,
 931466540,
 41359,
 -51317,
 931727279,
 41358,
 -1,
 931846560,
 41360,
 932052991,
 931726131,
 41349,
 -51314,
 931923887,
 41348,
 -1,
 932043168,
 41350,
 932198418,
 919258002,
 -1,
 932263857,
 932171407,
 -1,
 932329370,
 932198241,
 41389,
 932394901,
 932289784,
 41379,
 -51308,
 932317103,
 41378,
 -1,
 932436384,
 41380,
 932591511,
 932361479,
 41392,
 -1,
 932513711,
 41391,
 -51304,
 932513711,
 41388,
 -51303,
 932701578,
 41387,
 -1,
 932764064,
 41390,
 932919201,
 932255901,
 41369,
 932984734,
 932842796,
 41372,
 -51299,
 932906927,
 41371,
 -1,
 933026208,
 41373,
 -51297,
 932906927,
 41368,
 -51296,
 933160330,
 41367,
 -1,
 933222816,
 41370,
 933377959,
 932856441,
 41395,
 933443492,
 933344519,
 41398,
 -1,
 933365679,
 41397,
 -51291,
 933365679,
 41394,
 -51290,
 933553546,
 41393,
 -1,
 933616032,
 41396,
 933771179,
 933298995,
 41376,
 -51287,
 933693359,
 41375,
 -51286,
 933815690,
 41374,
 -1,
 933878176,
 41377,
 934033326,
 933731576,
 41382,
 -51283,
 933955503,
 41381,
 -1,
 934074784,
 41383,
 934281215,
 933956908,
 41385,
 -51280,
 934152111,
 41384,
 -1,
 934271392,
 41386,
 934426575,
 932192852,
 -1,
 934492091,
 934360929,
 41125,
 934557622,
 934452472,
 41117,
 -51275,
 934479791,
 41116,
 -1,
 934599072,
 41118,
 934754232,
 934524167,
 41128,
 -1,
 934676399,
 41127,
 -51271,
 934676399,
 41124,
 -51270,
 934864266,
 41123,
 -1,
 934926752,
 41126,
 935081922,
 934418589,
 41107,
 935147455,
 935005484,
 41110,
 -51266,
 935069615,
 41109,
 -1,
 935188896,
 41111,
 -51264,
 935069615,
 41106,
 -51263,
 935323018,
 41105,
 -1,
 935385504,
 41108,
 935540679,
 935019129,
 41130,
 935606213,
 935507207,
 41133,
 -1,
 935528367,
 41132,
 -51258,
 935528367,
 41129,
 -1,
 935713184,
 41131,
 935868363,
 935501048,
 41121,
 -51255,
 935790511,
 41120,
 -51254,
 935912842,
 41119,
 -1,
 935975328,
 41122,
 936181759,
 935789363,
 41114,
 -51251,
 936052655,
 41113,
 -51250,
 936174986,
 41112,
 -1,
 936237472,
 41115,
 936392679,
 934348719,
 -1,
 936458200,
 936319133,
 41544,
 936523733,
 936381740,
 41548,
 -51245,
 936445871,
 41547,
 -51244,
 936568202,
 41546,
 -1,
 936630688,
 41549,
 -51242,
 936445871,
 41543,
 -51241,
 936764810,
 41542,
 -1,
 936827296,
 41545,
 936982492,
 936434974,
 41556,
 -51238,
 936904623,
 41555,
 -51237,
 937026954,
 41554,
 -1,
 937089440,
 41557,
 937244640,
 936942840,
 41560,
 -51234,
 937166767,
 41559,
 -51233,
 937289098,
 41558,
 -1,
 937351584,
 41561,
 937506788,
 937165619,
 41552,
 -51230,
 937428911,
 41551,
 -51229,
 937551242,
 41550,
 -1,
 937613728,
 41553,
 937820159,
 937430316,
 41563,
 -51226,
 937691055,
 41562,
 -1,
 937810336,
 41564,
 937965567,
 936336680,
 -1,
 938031088,
 937891997,
 41322,
 938096621,
 937954604,
 41326,
 -51221,
 938018735,
 41325,
 -51220,
 938141066,
 41324,
 -1,
 938203552,
 41327,
 -51218,
 938018735,
 41321,
 -51217,
 938337674,
 41320,
 -1,
 938400160,
 41323,
 938555380,
 937952051,
 41330,
 -51214,
 938477487,
 41329,
 -51213,
 938599818,
 41328,
 -1,
 938662304,
 41331,
 938817528,
 938489697,
 -1,
 938883063,
 938777848,
 41333,
 -1,
 938805167,
 41332,
 -1,
 938861962,
 41340,
 939079676,
 938777848,
 -1,
 -51206,
 939001775,
 41335,
 -51205,
 939124106,
 41334,
 -1,
 939186592,
 41336,
 939393023,
 939003180,
 41338,
 -51202,
 939263919,
 41337,
 -1,
 939383200,
 41339,
 939538435,
 937942302,
 41591,
 -51199,
 939460527,
 41590,
 -51198,
 939582858,
 41589,
 -1,
 939645344,
 41592,
 939800583,
 939498744,
 41595,
 -51195,
 939722671,
 41594,
 -51194,
 939845002,
 41593,
 -1,
 939907488,
 41596,
 940062731,
 939721523,
 41587,
 -51191,
 939984815,
 41586,
 -51190,
 940107146,
 41585,
 -1,
 940169632,
 41588,
 940324879,
 939989149,
 -1,
 940390414,
 940248364,
 41584,
 -1,
 940312495,
 41583,
 -1,
 940369290,
 41582,
 940638207,
 940248364,
 41598,
 -51183,
 940509103,
 41597,
 -1,
 940628384,
 41599,
 940783726,
 932151243,
 -1,
 940849201,
 940736459,
 -1,
 940914716,
 940775581,
 41682,
 940980249,
 940838188,
 41686,
 -51177,
 940902319,
 41685,
 -51176,
 941024650,
 41684,
 -1,
 941087136,
 41687,
 -51174,
 940902319,
 41681,
 -51173,
 941221258,
 41680,
 -1,
 941283744,
 41683,
 941439010,
 940851833,
 41705,
 941504543,
 941405447,
 41708,
 -1,
 941426607,
 41707,
 -51168,
 941426607,
 41704,
 -51167,
 941614474,
 41703,
 -1,
 941676960,
 41706,
 941832231,
 941373281,
 41699,
 941897765,
 941798663,
 41702,
 -1,
 941819823,
 41701,
 -51162,
 941819823,
 41698,
 -1,
 942004640,
 41700,
 942159915,
 941753139,
 41690,
 -51159,
 942081967,
 41689,
 -51158,
 942204298,
 41688,
 -1,
 942266784,
 41691,
 942422062,
 942120184,
 41693,
 -51155,
 942344111,
 41692,
 -1,
 942463392,
 41694,
 942669823,
 942345516,
 41696,
 -51152,
 942540719,
 41695,
 -1,
 942660000,
 41697,
 942815309,
 940819346,
 -1,
 942880827,
 942749537,
 41815,
 942946358,
 942841080,
 41803,
 -51147,
 942868399,
 41802,
 -1,
 942987680,
 41804,
 943142968,
 942912775,
 41818,
 -1,
 943065007,
 41817,
 -51143,
 943065007,
 41814,
 -51142,
 943252874,
 41813,
 -1,
 943315360,
 41816,
 943470657,
 942817913,
 41821,
 943536190,
 943437063,
 41824,
 -1,
 943458223,
 41823,
 -51137,
 943458223,
 41820,
 -51136,
 943646090,
 41819,
 -1,
 943708576,
 41822,
 943863877,
 943430904,
 41807,
 -51133,
 943785903,
 41806,
 -51132,
 943908234,
 41805,
 -1,
 943970720,
 41808,
 944126025,
 943787308,
 41811,
 -51129,
 944048047,
 41810,
 -51128,
 944170378,
 41809,
 -1,
 944232864,
 41812,
 944439295,
 944046899,
 41800,
 -51125,
 944310191,
 41799,
 -51124,
 944432522,
 41798,
 -1,
 944495008,
 41801,
 944650326,
 942749537,
 41636,
 944715857,
 944610552,
 41625,
 -51120,
 944637871,
 41624,
 -1,
 944757152,
 41626,
 944912467,
 944682247,
 41639,
 -1,
 944834479,
 41638,
 -51116,
 944834479,
 41635,
 -51115,
 945022346,
 41634,
 -1,
 945084832,
 41637,
 945240157,
 944576669,
 41615,
 945305690,
 945163564,
 41618,
 -51111,
 945227695,
 41617,
 -1,
 945346976,
 41619,
 -51109,
 945227695,
 41614,
 -51108,
 945481098,
 41613,
 -1,
 945543584,
 41616,
 945698915,
 945177209,
 41642,
 945764448,
 945665287,
 41645,
 -1,
 945686447,
 41644,
 -51103,
 945686447,
 41641,
 -51102,
 945874314,
 41640,
 -1,
 945936800,
 41643,
 946092135,
 945659128,
 41629,
 -51099,
 946014127,
 41628,
 -51098,
 946136458,
 41627,
 -1,
 946198944,
 41630,
 946354283,
 946012979,
 41622,
 -51095,
 946276271,
 41621,
 -51094,
 946398602,
 41620,
 -1,
 946461088,
 41623,
 946667519,
 946277676,
 41632,
 -51091,
 946538415,
 41631,
 -1,
 946657696,
 41633,
 946813129,
 940746638,
 -1,
 946878604,
 946775950,
 -1,
 946944119,
 946804893,
 41772,
 947009652,
 946867500,
 41775,
 -51085,
 946931631,
 41774,
 -1,
 947050912,
 41776,
 -51083,
 946931631,
 41771,
 -51082,
 947185034,
 41770,
 -1,
 947247520,
 41773,
 947402877,
 946881145,
 41794,
 947468410,
 947369223,
 41797,
 -1,
 947390383,
 41796,
 -51077,
 947390383,
 41793,
 -51076,
 947578250,
 41792,
 -1,
 947640736,
 41795,
 947796097,
 947337057,
 41790,
 -51073,
 947718063,
 41789,
 -51072,
 947840394,
 41788,
 -1,
 947902880,
 41791,
 948058245,
 947756280,
 41783,
 -51069,
 947980207,
 41782,
 -51068,
 948102538,
 41781,
 -1,
 948165024,
 41784,
 948320393,
 947979059,
 41779,
 -51065,
 948242351,
 41778,
 -51064,
 948364682,
 41777,
 -1,
 948427168,
 41780,
 948633599,
 948243756,
 41786,
 -51061,
 948504495,
 41785,
 -1,
 948623776,
 41787,
 948779176,
 946848658,
 -1,
 948844694,
 948713313,
 41916,
 948910225,
 948804856,
 41904,
 -51056,
 948832175,
 41903,
 -1,
 948951456,
 41905,
 949106835,
 948876551,
 41919,
 -1,
 949028783,
 41918,
 -51052,
 949028783,
 41915,
 -51051,
 949216650,
 41914,
 -1,
 949279136,
 41917,
 949434524,
 948781689,
 41922,
 949500057,
 949400839,
 41925,
 -1,
 949421999,
 41924,
 -51046,
 949421999,
 41921,
 -51045,
 949609866,
 41920,
 -1,
 949672352,
 41923,
 949827744,
 949394680,
 41908,
 -51042,
 949749679,
 41907,
 -51041,
 949872010,
 41906,
 -1,
 949934496,
 41909,
 950089892,
 949751084,
 41912,
 -51038,
 950011823,
 41911,
 -51037,
 950134154,
 41910,
 -1,
 950196640,
 41913,
 950403071,
 950010675,
 41901,
 -51034,
 950273967,
 41900,
 -51033,
 950396298,
 41899,
 -1,
 950458784,
 41902,
 950614193,
 948713313,
 41760,
 950679724,
 950574328,
 41749,
 -51029,
 950601647,
 41748,
 -1,
 950720928,
 41750,
 950876334,
 950646023,
 41763,
 -1,
 950798255,
 41762,
 -51025,
 950798255,
 41759,
 -51024,
 950986122,
 41758,
 -1,
 951048608,
 41761,
 951204024,
 950540445,
 41739,
 951269557,
 951127340,
 41742,
 -51020,
 951191471,
 41741,
 -1,
 951310752,
 41743,
 -51018,
 951191471,
 41738,
 -51017,
 951444874,
 41737,
 -1,
 951507360,
 41740,
 951662782,
 951140985,
 41766,
 951728315,
 951629063,
 41769,
 -1,
 951650223,
 41768,
 -51012,
 951650223,
 41765,
 -51011,
 951838090,
 41764,
 -1,
 951900576,
 41767,
 952056002,
 951622904,
 41753,
 -51008,
 951977903,
 41752,
 -51007,
 952100234,
 41751,
 -1,
 952162720,
 41754,
 952318150,
 951976755,
 41746,
 -51004,
 952240047,
 41745,
 -51003,
 952362378,
 41744,
 -1,
 952424864,
 41747,
 952631295,
 952241452,
 41756,
 -51000,
 952502191,
 41755,
 -1,
 952621472,
 41757,
 952776973,
 946748864,
 -1,
 952842475,
 952712640,
 -1,
 952907988,
 952776545,
 41070,
 952973519,
 952868088,
 41059,
 -50994,
 952895407,
 41058,
 -1,
 953014688,
 41060,
 953170129,
 952939783,
 41073,
 -1,
 953092015,
 41072,
 -50990,
 953092015,
 41069,
 -50989,
 953279882,
 41068,
 -1,
 953342368,
 41071,
 953497820,
 952834205,
 41048,
 953563353,
 953421100,
 41052,
 -50985,
 953485231,
 41051,
 -50984,
 953607562,
 41050,
 -1,
 953670048,
 41053,
 -50982,
 953485231,
 41047,
 -50981,
 953804170,
 41046,
 -1,
 953866656,
 41049,
 954022112,
 953434745,
 41076,
 -50978,
 953943983,
 41075,
 -50977,
 954066314,
 41074,
 -1,
 954128800,
 41077,
 954284260,
 953982200,
 41063,
 -50974,
 954206127,
 41062,
 -50973,
 954328458,
 41061,
 -1,
 954390944,
 41064,
 954546408,
 954204979,
 41056,
 -50970,
 954468271,
 41055,
 -50969,
 954590602,
 41054,
 -1,
 954653088,
 41057,
 954859519,
 954469676,
 41066,
 -50966,
 954730415,
 41065,
 -1,
 954849696,
 41067,
 955005172,
 952776545,
 41006,
 955070703,
 954965240,
 40995,
 -50962,
 954992559,
 40994,
 -1,
 955111840,
 40996,
 955267313,
 955036935,
 41009,
 -1,
 955189167,
 41008,
 -50958,
 955189167,
 41005,
 -50957,
 955377034,
 41004,
 -1,
 955439520,
 41007,
 955595004,
 954931357,
 40984,
 955660537,
 955518252,
 40988,
 -50953,
 955582383,
 40987,
 -50952,
 955704714,
 40986,
 -1,
 955767200,
 40989,
 -50950,
 955582383,
 40983,
 -50949,
 955901322,
 40982,
 -1,
 955963808,
 40985,
 956119298,
 955531897,
 41012,
 956184831,
 956085511,
 41015,
 -1,
 956106671,
 41014,
 -50944,
 956106671,
 41011,
 -50943,
 956294538,
 41010,
 -1,
 956357024,
 41013,
 956512518,
 956079352,
 40999,
 -50940,
 956434351,
 40998,
 -50939,
 956556682,
 40997,
 -1,
 956619168,
 41000,
 956774666,
 956433203,
 40992,
 -50936,
 956696495,
 40991,
 -50935,
 956818826,
 40990,
 -1,
 956881312,
 40993,
 957087743,
 956697900,
 41002,
 -50932,
 956958639,
 41001,
 -1,
 957077920,
 41003,
 957233484,
 952728432,
 -1,
 957298986,
 957203346,
 -1,
 957364504,
 957232993,
 41842,
 957430036,
 957324536,
 41831,
 -50926,
 957351855,
 41830,
 -50925,
 957474186,
 41829,
 -1,
 957536672,
 41832,
 957692182,
 957396231,
 41845,
 -1,
 957613999,
 41844,
 -50921,
 957613999,
 41841,
 -1,
 957798816,
 41843,
 957954334,
 957301369,
 41848,
 958019867,
 957920519,
 41851,
 -1,
 957941679,
 41850,
 -50916,
 957941679,
 41847,
 -50915,
 958129546,
 41846,
 -1,
 958192032,
 41849,
 958347554,
 957914360,
 41835,
 -50912,
 958269359,
 41834,
 -50911,
 958391690,
 41833,
 -1,
 958454176,
 41836,
 958609702,
 958270764,
 41839,
 -50908,
 958531503,
 41838,
 -50907,
 958653834,
 41837,
 -1,
 958716320,
 41840,
 958922751,
 958530355,
 41827,
 -50904,
 958793647,
 41826,
 -50903,
 958915978,
 41825,
 -1,
 958978464,
 41828,
 959134003,
 957232993,
 41670,
 959199534,
 959094008,
 41659,
 -50899,
 959121327,
 41658,
 -1,
 959240608,
 41660,
 959396144,
 959165703,
 41673,
 -1,
 959317935,
 41672,
 -50895,
 959317935,
 41669,
 -50894,
 959505802,
 41668,
 -1,
 959568288,
 41671,
 959723835,
 959060125,
 41648,
 959789368,
 959647020,
 41652,
 -50890,
 959711151,
 41651,
 -50889,
 959833482,
 41650,
 -1,
 959895968,
 41653,
 -50887,
 959711151,
 41647,
 -50886,
 960030090,
 41646,
 -1,
 960092576,
 41649,
 960248129,
 959660665,
 41676,
 960313662,
 960214279,
 41679,
 -1,
 960235439,
 41678,
 -50881,
 960235439,
 41675,
 -50880,
 960423306,
 41674,
 -1,
 960485792,
 41677,
 960641349,
 960208120,
 41663,
 -50877,
 960563119,
 41662,
 -50876,
 960685450,
 41661,
 -1,
 960747936,
 41664,
 960903497,
 960561971,
 41656,
 -50873,
 960825263,
 41655,
 -50872,
 960947594,
 41654,
 -1,
 961010080,
 41657,
 961216511,
 960826668,
 41666,
 -50869,
 961087407,
 41665,
 -1,
 961206688,
 41667,
 961362312,
 957187789,
 -1,
 961427818,
 961316557,
 -1,
 961493336,
 961361761,
 41516,
 961558867,
 961453304,
 41504,
 -50863,
 961480623,
 41503,
 -50862,
 961602954,
 41502,
 -1,
 961665440,
 41505,
 961821013,
 961524999,
 41519,
 -1,
 961742767,
 41518,
 -50858,
 961742767,
 41515,
 -50857,
 961930634,
 41514,
 -1,
 961993120,
 41517,
 962148702,
 961419421,
 41494,
 962214236,
 962071852,
 41496,
 -50853,
 962135983,
 41495,
 -1,
 962255264,
 41497,
 -50851,
 962135983,
 41493,
 -1,
 962389386,
 41492,
 962541922,
 962108664,
 41508,
 -50848,
 962463663,
 41507,
 -50847,
 962585994,
 41506,
 -1,
 962648480,
 41509,
 962804070,
 962465068,
 41512,
 -50844,
 962725807,
 41511,
 -50843,
 962848138,
 41510,
 -1,
 962910624,
 41513,
 963117055,
 962724659,
 41500,
 -50840,
 962987951,
 41499,
 -50839,
 963110282,
 41498,
 -1,
 963172768,
 41501,
 963328372,
 961361761,
 41460,
 963393903,
 963288312,
 41448,
 -50835,
 963315631,
 41447,
 -50834,
 963437962,
 41446,
 -1,
 963500448,
 41449,
 963656049,
 963360007,
 41463,
 -1,
 963577775,
 41462,
 -50830,
 963577775,
 41459,
 -50829,
 963765642,
 41458,
 -1,
 963828128,
 41461,
 963983740,
 963254429,
 41436,
 964049273,
 963906860,
 41440,
 -50825,
 963970991,
 41439,
 -50824,
 964093322,
 41438,
 -1,
 964155808,
 41441,
 -50822,
 963970991,
 41435,
 -50821,
 964289930,
 41434,
 -1,
 964352416,
 41437,
 964508032,
 963943672,
 41452,
 -50818,
 964429743,
 41451,
 -50817,
 964552074,
 41450,
 -1,
 964614560,
 41453,
 964770180,
 964431148,
 41456,
 -50814,
 964691887,
 41455,
 -50813,
 964814218,
 41454,
 -1,
 964876704,
 41457,
 965083135,
 964690739,
 41444,
 -50810,
 964954031,
 41443,
 -50809,
 965076362,
 41442,
 -1,
 965138848,
 41445,
 965294527,
 961290836,
 -1,
 965360032,
 965248717,
 -1,
 965425555,
 965293921,
 41538,
 965491086,
 965385464,
 41527,
 -50803,
 965412783,
 41526,
 -1,
 965532064,
 41528,
 965687696,
 965457159,
 41541,
 -1,
 965609391,
 41540,
 -50799,
 965609391,
 41537,
 -50798,
 965797258,
 41536,
 -1,
 965859744,
 41539,
 966015383,
 965385464,
 41531,
 -50795,
 965937071,
 41530,
 -50794,
 966059402,
 41529,
 -1,
 966121888,
 41532,
 966277531,
 965935923,
 41524,
 -50791,
 966199215,
 41523,
 -50790,
 966321546,
 41522,
 -1,
 966384032,
 41525,
 966539678,
 966200620,
 41534,
 -50787,
 966461359,
 41533,
 -1,
 966580640,
 41535,
 966787071,
 966509999,
 41521,
 -1,
 966657967,
 41520,
 966867370,
 965293921,
 41157,
 966932901,
 966827256,
 41147,
 -50781,
 966854575,
 41146,
 -50780,
 966976906,
 41145,
 -1,
 967039392,
 41148,
 967195047,
 966898951,
 41160,
 -1,
 967116719,
 41159,
 -50776,
 967116719,
 41156,
 -50775,
 967304586,
 41155,
 -1,
 967367072,
 41158,
 967522737,
 966793373,
 41136,
 967588270,
 967445804,
 41139,
 -50771,
 967509935,
 41138,
 -1,
 967629216,
 41140,
 -50769,
 967509935,
 41135,
 -50768,
 967763338,
 41134,
 -1,
 967825824,
 41137,
 967981493,
 967459449,
 41163,
 -50765,
 967903151,
 41162,
 -50764,
 968025482,
 41161,
 -1,
 968087968,
 41164,
 968243641,
 967941368,
 41151,
 -50761,
 968165295,
 41150,
 -50760,
 968287626,
 41149,
 -1,
 968350112,
 41152,
 968505789,
 968164147,
 41143,
 -50757,
 968427439,
 41142,
 -50756,
 968549770,
 41141,
 -1,
 968612256,
 41144,
 968818687,
 968428844,
 41154,
 -1,
 968689583,
 41153,
 968899062,
 965235404,
 -1,
 968964570,
 968839884,
 -1,
 969030090,
 968898401,
 42025,
 969095621,
 968989944,
 42017,
 -50748,
 969017263,
 42016,
 -1,
 969136544,
 42018,
 969292231,
 969061639,
 42028,
 -1,
 969213871,
 42027,
 -50744,
 969213871,
 42024,
 -50743,
 969401738,
 42023,
 -1,
 969464224,
 42026,
 969619922,
 968956061,
 42010,
 969685455,
 969542956,
 42014,
 -50739,
 969607087,
 42013,
 -50738,
 969729418,
 42012,
 -1,
 969791904,
 42015,
 -50736,
 969607087,
 42009,
 -50735,
 969926026,
 42008,
 -1,
 969988512,
 42011,
 970144214,
 969556601,
 42031,
 -50732,
 970065839,
 42030,
 -50731,
 970188170,
 42029,
 -1,
 970250656,
 42032,
 970457087,
 970104056,
 42021,
 -50728,
 970327983,
 42020,
 -50727,
 970450314,
 42019,
 -1,
 970512800,
 42022,
 970668516,
 968898401,
 41970,
 970734047,
 970628344,
 41962,
 -50723,
 970655663,
 41961,
 -50722,
 970777994,
 41960,
 -1,
 970840480,
 41963,
 970996193,
 970700039,
 41973,
 -1,
 970917807,
 41972,
 -50718,
 970917807,
 41969,
 -50717,
 971105674,
 41968,
 -1,
 971168160,
 41971,
 971323884,
 970594461,
 41954,
 971389417,
 971246892,
 41958,
 -50713,
 971311023,
 41957,
 -50712,
 971433354,
 41956,
 -1,
 971495840,
 41959,
 -50710,
 971311023,
 41953,
 -50709,
 971629962,
 41952,
 -1,
 971692448,
 41955,
 971848178,
 971260537,
 41976,
 971913711,
 971814151,
 41979,
 -1,
 971835311,
 41978,
 -50704,
 971835311,
 41975,
 -50703,
 972023178,
 41974,
 -1,
 972085664,
 41977,
 972292095,
 971807992,
 41966,
 -50700,
 972162991,
 41965,
 -50699,
 972285322,
 41964,
 -1,
 972347808,
 41967,
 972503597,
 968866043,
 -1,
 972569107,
 972470523,
 -1,
 972634625,
 972502881,
 41293,
 972700156,
 972594424,
 41282,
 -50693,
 972621743,
 41281,
 -1,
 972741024,
 41283,
 972896766,
 972666119,
 41296,
 -1,
 972818351,
 41295,
 -50689,
 972818351,
 41292,
 -50688,
 973006218,
 41291,
 -1,
 973068704,
 41294,
 973224456,
 972560541,
 41272,
 973289989,
 973147436,
 41275,
 -50684,
 973211567,
 41274,
 -1,
 973330848,
 41276,
 -50682,
 973211567,
 41271,
 -50681,
 973464970,
 41270,
 -1,
 973527456,
 41273,
 973683212,
 973184248,
 41286,
 -50678,
 973604783,
 41285,
 -50677,
 973727114,
 41284,
 -1,
 973789600,
 41287,
 973945360,
 973603635,
 41279,
 -50674,
 973866927,
 41278,
 -50673,
 973989258,
 41277,
 -1,
 974051744,
 41280,
 974258175,
 973868332,
 41289,
 -50670,
 974129071,
 41288,
 -1,
 974248352,
 41290,
 974404123,
 972502881,
 41238,
 974469654,
 974370055,
 41241,
 -1,
 974391215,
 41240,
 974600728,
 974429432,
 41228,
 -1,
 974522287,
 41227,
 -50663,
 974522287,
 41237,
 -50662,
 974710154,
 41236,
 -1,
 974772640,
 41239,
 974928418,
 974330013,
 41218,
 974993951,
 974851372,
 41221,
 -50658,
 974915503,
 41220,
 -1,
 975034784,
 41222,
 -50656,
 974915503,
 41217,
 -50655,
 975168906,
 41216,
 -1,
 975231392,
 41219,
 975387174,
 974888184,
 41231,
 -50652,
 975308719,
 41230,
 -50651,
 975431050,
 41229,
 -1,
 975493536,
 41232,
 975649322,
 975307571,
 41225,
 -50648,
 975570863,
 41224,
 -50647,
 975693194,
 41223,
 -1,
 975755680,
 41226,
 975962111,
 975572268,
 41234,
 -50644,
 975833007,
 41233,
 -1,
 975952288,
 41235,
 976108129,
 972469511,
 -1,
 976173639,
 976073991,
 -1,
 976239159,
 976107361,
 41866,
 976304690,
 976205063,
 41869,
 -1,
 976226223,
 41868,
 976435764,
 976264440,
 41855,
 -1,
 976357295,
 41854,
 -50635,
 976357295,
 41865,
 -50634,
 976545162,
 41864,
 -1,
 976607648,
 41867,
 976763453,
 976175737,
 41872,
 976828986,
 976729351,
 41875,
 -1,
 976750511,
 41874,
 -50629,
 976750511,
 41871,
 -50628,
 976938378,
 41870,
 -1,
 977000864,
 41873,
 977156673,
 976723192,
 41858,
 -50625,
 977078191,
 41857,
 -50624,
 977200522,
 41856,
 -1,
 977263008,
 41859,
 977418821,
 977079596,
 41862,
 -50621,
 977340335,
 41861,
 -50620,
 977462666,
 41860,
 -1,
 977525152,
 41863,
 977731583,
 977339187,
 41853,
 -1,
 977602479,
 41852,
 977812048,
 976107361,
 41942,
 977877579,
 977771768,
 41931,
 -50614,
 977799087,
 41930,
 -1,
 977918368,
 41932,
 978074189,
 977843463,
 41945,
 -1,
 977995695,
 41944,
 -50610,
 977995695,
 41941,
 -50609,
 978183562,
 41940,
 -1,
 978246048,
 41943,
 978401878,
 977748601,
 41948,
 978467411,
 978367751,
 41951,
 -1,
 978388911,
 41950,
 -50604,
 978388911,
 41947,
 -50603,
 978576778,
 41946,
 -1,
 978639264,
 41949,
 978795098,
 978361592,
 41935,
 -50600,
 978716591,
 41934,
 -50599,
 978838922,
 41933,
 -1,
 978901408,
 41936,
 979057246,
 978715443,
 41928,
 -50596,
 978978735,
 41927,
 -50595,
 979101066,
 41926,
 -1,
 979163552,
 41929,
 979369983,
 978980140,
 41938,
 -50592,
 979240879,
 41937,
 -1,
 979360160,
 41939,
 979516037,
 976080527,
 -1,
 979581548,
 979449697,
 41424,
 979647079,
 979541240,
 41413,
 -50587,
 979568559,
 41412,
 -50586,
 979690890,
 41411,
 -1,
 979753376,
 41414,
 979909225,
 979612935,
 41427,
 -1,
 979830703,
 41426,
 -50582,
 979830703,
 41423,
 -50581,
 980018570,
 41422,
 -1,
 980081056,
 41425,
 980236916,
 979507357,
 41401,
 980302449,
 980159788,
 41405,
 -50577,
 980223919,
 41404,
 -50576,
 980346250,
 41403,
 -1,
 980408736,
 41406,
 -50574,
 980223919,
 41400,
 -50573,
 980542858,
 41399,
 -1,
 980605344,
 41402,
 980761210,
 980173433,
 41430,
 980826743,
 980727047,
 41433,
 -1,
 980748207,
 41432,
 -50568,
 980748207,
 41429,
 -50567,
 980936074,
 41428,
 -1,
 980998560,
 41431,
 981154430,
 980720888,
 41417,
 -50564,
 981075887,
 41416,
 -50563,
 981198218,
 41415,
 -1,
 981260704,
 41418,
 981416578,
 981074739,
 41409,
 -50560,
 981338031,
 41408,
 -50559,
 981460362,
 41407,
 -1,
 981522848,
 41410,
 981729279,
 981339436,
 41420,
 -50556,
 981600175,
 41419,
 -1,
 981719456,
 41421,
 981875365,
 979465416,
 -1,
 981940878,
 981801117,
 41188,
 982006411,
 981863724,
 41192,
 -50551,
 981927855,
 41191,
 -50550,
 982050186,
 41190,
 -1,
 982112672,
 41193,
 -50548,
 981927855,
 41187,
 -50547,
 982246794,
 41186,
 -1,
 982309280,
 41189,
 982465172,
 981877369,
 41212,
 982530705,
 982430983,
 41215,
 -1,
 982452143,
 41214,
 -50542,
 982452143,
 41211,
 -50541,
 982640010,
 41210,
 -1,
 982702496,
 41213,
 982858394,
 982398817,
 41206,
 982923927,
 982824199,
 41209,
 -1,
 982845359,
 41208,
 -50536,
 982845359,
 41205,
 -50535,
 983033226,
 41204,
 -1,
 983095712,
 41207,
 983251614,
 982818040,
 41200,
 -50532,
 983173039,
 41199,
 -50531,
 983295370,
 41198,
 -1,
 983357856,
 41201,
 983513762,
 983171891,
 41196,
 -50528,
 983435183,
 41195,
 -50527,
 983557514,
 41194,
 -1,
 983620000,
 41197,
 983826431,
 983436588,
 -1,
 -50524,
 983697327,
 41202,
 -1,
 983816608,
 41203,
 983972548,
 981850528,
 -1,
 984038063,
 983906145,
 41036,
 984103594,
 983997688,
 41028,
 -50519,
 984025007,
 41027,
 -1,
 984144288,
 41029,
 984300204,
 984069383,
 41039,
 -1,
 984221615,
 41038,
 -50515,
 984221615,
 41035,
 -50514,
 984409482,
 41034,
 -1,
 984471968,
 41037,
 984627894,
 983963805,
 41018,
 984693427,
 984550700,
 41021,
 -50510,
 984614831,
 41020,
 -1,
 984734112,
 41022,
 -50508,
 984614831,
 41017,
 -50507,
 984868234,
 41016,
 -1,
 984930720,
 41019,
 985086652,
 984564345,
 41042,
 985152185,
 985052423,
 41045,
 -1,
 985073583,
 41044,
 -50502,
 985073583,
 41041,
 -50501,
 985261450,
 41040,
 -1,
 985323936,
 41043,
 985479872,
 985046264,
 41032,
 -50498,
 985401263,
 41031,
 -50497,
 985523594,
 41030,
 -1,
 985586080,
 41033,
 985792511,
 985400115,
 41025,
 -50494,
 985663407,
 41024,
 -50493,
 985785738,
 41023,
 -1,
 985848224,
 41026,
 986004193,
 983908985,
 -1,
 986069711,
 985937761,
 42115,
 986135242,
 986029304,
 42107,
 -50488,
 986056623,
 42106,
 -50487,
 986178954,
 42105,
 -1,
 986241440,
 42108,
 986397388,
 986100999,
 42118,
 -1,
 986318767,
 42117,
 -50483,
 986318767,
 42114,
 -50482,
 986506634,
 42113,
 -1,
 986569120,
 42116,
 986725079,
 985995421,
 42099,
 986790612,
 986647852,
 42103,
 -50478,
 986711983,
 42102,
 -50477,
 986834314,
 42101,
 -1,
 986896800,
 42104,
 -50475,
 986711983,
 42098,
 -50474,
 987030922,
 42097,
 -1,
 987093408,
 42100,
 987249373,
 986661497,
 42121,
 987314906,
 987215111,
 42124,
 -1,
 987236271,
 42123,
 -50469,
 987236271,
 42120,
 -50468,
 987424138,
 42119,
 -1,
 987486624,
 42122,
 987693055,
 987208952,
 42111,
 -50465,
 987563951,
 42110,
 -50464,
 987686282,
 42109,
 -1,
 987748768,
 42112,
 987904766,
 985982346,
 -1,
 987970284,
 987838305,
 41266,
 988035815,
 987929848,
 41255,
 -50459,
 987957167,
 41254,
 -50458,
 988079498,
 41253,
 -1,
 988141984,
 41256,
 988297961,
 988001543,
 41269,
 -1,
 988219311,
 41268,
 -50454,
 988219311,
 41265,
 -50453,
 988407178,
 41264,
 -1,
 988469664,
 41267,
 988625651,
 987895965,
 41244,
 988691184,
 988548396,
 41247,
 -50449,
 988612527,
 41246,
 -1,
 988731808,
 41248,
 -50447,
 988612527,
 41243,
 -50446,
 988865930,
 41242,
 -1,
 988928416,
 41245,
 989084407,
 988585208,
 41259,
 -50443,
 989005743,
 41258,
 -50442,
 989128074,
 41257,
 -1,
 989190560,
 41260,
 989346555,
 989004595,
 41251,
 -50439,
 989267887,
 41250,
 -50438,
 989390218,
 41249,
 -1,
 989452704,
 41252,
 989659135,
 989269292,
 41262,
 -50435,
 989530031,
 41261,
 -1,
 989649312,
 41263,
 989805339,
 987835709,
 -1,
 989870857,
 989738849,
 41998,
 989936388,
 989830392,
 41990,
 -50430,
 989857711,
 41989,
 -50429,
 989980042,
 41988,
 -1,
 990042528,
 41991,
 990198534,
 989902087,
 42001,
 -1,
 990119855,
 42000,
 -50425,
 990119855,
 41997,
 -50424,
 990307722,
 41996,
 -1,
 990370208,
 41999,
 990526225,
 989796509,
 41982,
 990591758,
 990448940,
 41986,
 -50420,
 990513071,
 41985,
 -50419,
 990635402,
 41984,
 -1,
 990697888,
 41987,
 -50417,
 990513071,
 41981,
 -50416,
 990832010,
 41980,
 -1,
 990894496,
 41983,
 991050519,
 990462585,
 42004,
 991116052,
 991016199,
 42007,
 -1,
 991037359,
 42006,
 -50411,
 991037359,
 42003,
 -50410,
 991225226,
 42002,
 -1,
 991287712,
 42005,
 991494143,
 991010040,
 41994,
 -50407,
 991365039,
 41993,
 -50406,
 991487370,
 41992,
 -1,
 991549856,
 41995,
 991705912,
 989761847,
 -1,
 991771429,
 991639393,
 41488,
 991836960,
 991730936,
 41476,
 -50401,
 991758255,
 41475,
 -1,
 991877536,
 41477,
 992033570,
 991802631,
 41491,
 -1,
 991954863,
 41490,
 -50397,
 991954863,
 41487,
 -50396,
 992142730,
 41486,
 -1,
 992205216,
 41489,
 992361260,
 991697053,
 41466,
 992426793,
 992283948,
 41469,
 -50392,
 992348079,
 41468,
 -1,
 992467360,
 41470,
 -50390,
 992348079,
 41465,
 -50389,
 992601482,
 41464,
 -1,
 992663968,
 41467,
 992820016,
 992320760,
 41480,
 -50386,
 992741295,
 41479,
 -50385,
 992863626,
 41478,
 -1,
 992926112,
 41481,
 993082164,
 992742700,
 41484,
 -50382,
 993003439,
 41483,
 -50381,
 993125770,
 41482,
 -1,
 993188256,
 41485,
 993394687,
 993002291,
 41473,
 -50378,
 993265583,
 41472,
 -50377,
 993387914,
 41471,
 -1,
 993450400,
 41474,
 993606478,
 991643719,
 -1,
 993671999,
 993539937,
 41178,
 993737532,
 993637639,
 41181,
 -1,
 993658799,
 41180,
 -50371,
 993658799,
 41177,
 -50370,
 993846666,
 41176,
 -1,
 993909152,
 41179,
 994065219,
 993608313,
 41184,
 -50367,
 993986479,
 41183,
 -50366,
 994108810,
 41182,
 -1,
 994171296,
 41185,
 994327367,
 993990813,
 41167,
 -50363,
 994248623,
 41166,
 -50362,
 994370954,
 41165,
 -1,
 994433440,
 41168,
 994589515,
 994247475,
 41171,
 -50359,
 994510767,
 41170,
 -50358,
 994633098,
 41169,
 -1,
 994695584,
 41172,
 994902015,
 994548984,
 41174,
 -50355,
 994772911,
 41173,
 -1,
 994892192,
 41175,
 995048291,
 993527727,
 -1,
 995113815,
 994973853,
 42079,
 995179348,
 995036460,
 42083,
 -50350,
 995100591,
 42082,
 -50349,
 995222922,
 42081,
 -1,
 995285408,
 42084,
 -50347,
 995100591,
 42078,
 -50346,
 995419530,
 42077,
 -1,
 995482016,
 42080,
 995638109,
 995050105,
 42093,
 995703642,
 995603719,
 42096,
 -1,
 995624879,
 42095,
 -50341,
 995624879,
 42092,
 -50340,
 995812746,
 42091,
 -1,
 995875232,
 42094,
 996031329,
 995597560,
 42089,
 -50337,
 995952559,
 42088,
 -50336,
 996074890,
 42087,
 -1,
 996137376,
 42090,
 996343807,
 996007198,
 42086,
 -1,
 996214703,
 42085,
 996424562,
 995013445,
 -1,
 996490088,
 996357985,
 40981,
 996605951,
 996449528,
 41605,
 -50329,
 996476847,
 41604,
 -1,
 996596128,
 41606,
 996752236,
 996410163,
 41602,
 -50326,
 996673455,
 41601,
 -50325,
 996795786,
 41600,
 -1,
 996858272,
 41603,
 997014383,
 996711672,
 41608,
 -50322,
 996935599,
 41607,
 -1,
 997054880,
 41609,
 997261311,
 996937004,
 41611,
 -50319,
 997132207,
 41610,
 -1,
 997251488,
 41612,
 997407610,
 996350109,
 40962,
 997473143,
 997330220,
 40966,
 -50315,
 997394351,
 40965,
 -50314,
 997516682,
 40964,
 -1,
 997579168,
 40967,
 -50312,
 997394351,
 40961,
 -50311,
 997713290,
 40960,
 -1,
 997775776,
 40963,
 997931902,
 997367032,
 40977,
 -50308,
 997853103,
 40976,
 -50307,
 997975434,
 40975,
 -1,
 998037920,
 40978,
 998194050,
 997851955,
 40970,
 -50304,
 998115247,
 40969,
 -50303,
 998237578,
 40968,
 -1,
 998300064,
 40971,
 998456197,
 998169886,
 40973,
 -50300,
 998377391,
 40972,
 -1,
 998496672,
 40974,
 998703103,
 998378796,
 40980,
 -1,
 998573999,
 40979,
 998834175,
 919183663,
 -1,
 998849423,
 998734704,
 -1,
 998914956,
 998785657,
 42172,
 -50293,
 998892938,
 42147,
 -1,
 998955424,
 42132,
 -50291,
 998875167,
 42173,
 -50290,
 999081342,
 42174,
 -1,
 999143862,
 42179,
 999308182,
 998801355,
 -1,
 999373715,
 999241569,
 -1,
 -50286,
 999339271,
 42177,
 -1,
 999414176,
 42146,
 -50284,
 999307048,
 42180,
 -50283,
 999499491,
 42155,
 -1,
 999555891,
 42162,
 999766941,
 999270286,
 -1,
 999832476,
 999736210,
 -1,
 -50279,
 999768697,
 42160,
 -50278,
 999873773,
 42170,
 -50277,
 999892719,
 42178,
 -1,
 999973403,
 42176,
 -1,
 999773855,
 42133,
 1000225700,
 999720653,
 -1,
 1000291233,
 1000179405,
 -1,
 -50272,
 1000267038,
 42150,
 -1,
 1000285935,
 42134,
 -50270,
 1000220387,
 42166,
 -50269,
 1000445424,
 42135,
 -1,
 1000473395,
 42145,
 1000684458,
 1000168744,
 -1,
 1000749992,
 1000620665,
 -1,
 -50265,
 1000679151,
 42151,
 -1,
 1000785278,
 42131,
 -50263,
 1000705483,
 42164,
 -1,
 1000878239,
 42181,
 1001077680,
 1000624844,
 -1,
 1001143215,
 1001018060,
 -1,
 -50259,
 1001079417,
 42165,
 -50258,
 1001156750,
 42154,
 -1,
 1001244079,
 42167,
 -1,
 1001102584,
 42163,
 1001470902,
 1001046930,
 -1,
 1001536437,
 1001392047,
 -1,
 -50253,
 1001512222,
 42143,
 -50252,
 1001531119,
 42175,
 -1,
 1001637255,
 42137,
 -1,
 1001459631,
 42157,
 1001864122,
 1001442959,
 -1,
 1001929657,
 1001789597,
 42129,
 -1,
 1001852204,
 42171,
 -1,
 1001860311,
 42138,
 1002126269,
 1001800313,
 -1,
 -50244,
 1002085624,
 42141,
 -1,
 1002161543,
 42158,
 1002322880,
 1002075336,
 -1,
 -50241,
 1002298605,
 42159,
 -1,
 1002345968,
 42161,
 1002519491,
 1002300810,
 -1,
 -50238,
 1002452833,
 42152,
 -1,
 1002529307,
 42144,
 1002716102,
 1002494368,
 -1,
 -50235,
 1002676722,
 42156,
 -1,
 1002729614,
 42142,
 1002912713,
 1002644052,
 -1,
 -50232,
 1002841839,
 42140,
 -1,
 1002903709,
 42136,
 1003109324,
 1002869047,
 -1,
 -50229,
 1003079047,
 42130,
 -1,
 1003097388,
 42182,
 1003305935,
 1003075835,
 -1,
 -50226,
 1003239265,
 42169,
 -1,
 1003317469,
 42148,
 1003502546,
 1003240896,
 -1,
 -50223,
 1003478253,
 42149,
 -1,
 1003503726,
 42139,
 -50221,
 1003456753,
 42168,
 -50220,
 1003664141,
 42128,
 -1,
 1003693807,
 42153,
 -1,
 919128783,
 9775,
 -1,
 919040856,
 165,
 1004028395,
 918961600,
 -1,
 1004092639,
 1003992327,
 -1,
 1004158171,
 1004057950,
 -1,
 1004223706,
 1004113488,
 -1,
 1004289115,
 1004191400,
 10241,
 1004354588,
 1004213264,
 10243,
 1004420093,
 1004293741,
 10247,
 1004485614,
 1004375181,
 10255,
 1004551143,
 1004456518,
 10271,
 1004616676,
 1004478066,
 10303,
 1004682211,
 1004558466,
 10367,
 -1,
 1004640265,
 10495,
 -1,
 1004640265,
 10431,
 1004878822,
 1004558466,
 10335,
 -1,
 1004836873,
 10463,
 -1,
 1004836873,
 10399,
 1005075435,
 1004478066,
 10287,
 1005140970,
 1005017218,
 10351,
 -1,
 1005099017,
 10479,
 -1,
 1005099017,
 10415,
 1005337581,
 1005017218,
 10319,
 -1,
 1005295625,
 10447,
 -1,
 1005295625,
 10383,
 1005534198,
 1004456518,
 10263,
 1005599731,
 1005461106,
 10295,
 1005665266,
 1005541506,
 10359,
 -1,
 1005623305,
 10487,
 -1,
 1005623305,
 10423,
 1005861877,
 1005541506,
 10327,
 -1,
 1005819913,
 10455,
 -1,
 1005819913,
 10391,
 1006058490,
 1005461106,
 10279,
 1006124025,
 1006000258,
 10343,
 -1,
 1006082057,
 10471,
 -1,
 1006082057,
 10407,
 1006320636,
 1006000258,
 10311,
 -1,
 1006278665,
 10439,
 -1,
 1006278665,
 10375,
 1006517261,
 1004375181,
 10251,
 1006582790,
 1006488134,
 10267,
 1006648323,
 1006509682,
 10299,
 1006713858,
 1006590082,
 10363,
 -1,
 1006671881,
 10491,
 -1,
 1006671881,
 10427,
 1006910469,
 1006590082,
 10331,
 -1,
 1006868489,
 10459,
 -1,
 1006868489,
 10395,
 1007107082,
 1006509682,
 10283,
 1007172617,
 1007048834,
 10347,
 -1,
 1007130633,
 10475,
 -1,
 1007130633,
 10411,
 1007369228,
 1007048834,
 10315,
 -1,
 1007327241,
 10443,
 -1,
 1007327241,
 10379,
 1007565845,
 1006488134,
 10259,
 1007631378,
 1007492722,
 10291,
 1007696913,
 1007573122,
 10355,
 -1,
 1007654921,
 10483,
 -1,
 1007654921,
 10419,
 1007893524,
 1007573122,
 10323,
 -1,
 1007851529,
 10451,
 -1,
 1007851529,
 10387,
 1008090137,
 1007492722,
 10275,
 1008155672,
 1008031874,
 10339,
 -1,
 1008113673,
 10467,
 -1,
 1008113673,
 10403,
 1008352283,
 1008031874,
 10307,
 -1,
 1008310281,
 10435,
 -1,
 1008310281,
 10371,
 1008548924,
 1004293741,
 10245,
 1008614445,
 1008503949,
 10253,
 1008679974,
 1008585286,
 10269,
 1008745507,
 1008606834,
 10301,
 1008811042,
 1008687234,
 10365,
 -1,
 1008769033,
 10493,
 -1,
 1008769033,
 10429,
 1009007653,
 1008687234,
 10333,
 -1,
 1008965641,
 10461,
 -1,
 1008965641,
 10397,
 1009204266,
 1008606834,
 10285,
 1009269801,
 1009145986,
 10349,
 -1,
 1009227785,
 10477,
 -1,
 1009227785,
 10413,
 1009466412,
 1009145986,
 10317,
 -1,
 1009424393,
 10445,
 -1,
 1009424393,
 10381,
 1009663029,
 1008585286,
 10261,
 1009728562,
 1009589874,
 10293,
 1009794097,
 1009670274,
 10357,
 -1,
 1009752073,
 10485,
 -1,
 1009752073,
 10421,
 1009990708,
 1009670274,
 10325,
 -1,
 1009948681,
 10453,
 -1,
 1009948681,
 10389,
 1010187321,
 1009589874,
 10277,
 1010252856,
 1010129026,
 10341,
 -1,
 1010210825,
 10469,
 -1,
 1010210825,
 10405,
 1010449467,
 1010129026,
 10309,
 -1,
 1010407433,
 10437,
 -1,
 1010407433,
 10373,
 1010646092,
 1008503949,
 10249,
 1010711621,
 1010616902,
 10265,
 1010777154,
 1010638450,
 10297,
 1010842689,
 1010718850,
 10361,
 -1,
 1010800649,
 10489,
 -1,
 1010800649,
 10425,
 1011039300,
 1010718850,
 10329,
 -1,
 1010997257,
 10457,
 -1,
 1010997257,
 10393,
 1011235913,
 1010638450,
 10281,
 1011301448,
 1011177602,
 10345,
 -1,
 1011259401,
 10473,
 -1,
 1011259401,
 10409,
 1011498059,
 1011177602,
 10313,
 -1,
 1011456009,
 10441,
 -1,
 1011456009,
 10377,
 1011694676,
 1010616902,
 10257,
 1011760209,
 1011621490,
 10289,
 1011825744,
 1011701890,
 10353,
 -1,
 1011783689,
 10481,
 -1,
 1011783689,
 10417,
 1012022355,
 1011701890,
 10321,
 -1,
 1011980297,
 10449,
 -1,
 1011980297,
 10385,
 1012218968,
 1011621490,
 10273,
 1012284503,
 1012160642,
 10337,
 -1,
 1012242441,
 10465,
 -1,
 1012242441,
 10401,
 1012481114,
 1012160642,
 10305,
 -1,
 1012439049,
 10433,
 -1,
 1012439049,
 10369,
 1012677787,
 1004213264,
 10242,
 1012743292,
 1012616813,
 10246,
 1012808813,
 1012698253,
 10254,
 1012874342,
 1012779590,
 10270,
 1012939875,
 1012801138,
 10302,
 1013005410,
 1012881538,
 10366,
 -1,
 1012963337,
 10494,
 -1,
 1012963337,
 10430,
 1013202021,
 1012881538,
 10334,
 -1,
 1013159945,
 10462,
 -1,
 1013159945,
 10398,
 1013398634,
 1012801138,
 10286,
 1013464169,
 1013340290,
 10350,
 -1,
 1013422089,
 10478,
 -1,
 1013422089,
 10414,
 1013660780,
 1013340290,
 10318,
 -1,
 1013618697,
 10446,
 -1,
 1013618697,
 10382,
 1013857397,
 1012779590,
 10262,
 1013922930,
 1013784178,
 10294,
 1013988465,
 1013864578,
 10358,
 -1,
 1013946377,
 10486,
 -1,
 1013946377,
 10422,
 1014185076,
 1013864578,
 10326,
 -1,
 1014142985,
 10454,
 -1,
 1014142985,
 10390,
 1014381689,
 1013784178,
 10278,
 1014447224,
 1014323330,
 10342,
 -1,
 1014405129,
 10470,
 -1,
 1014405129,
 10406,
 1014643835,
 1014323330,
 10310,
 -1,
 1014601737,
 10438,
 -1,
 1014601737,
 10374,
 1014840460,
 1012698253,
 10250,
 1014905989,
 1014811206,
 10266,
 1014971522,
 1014832754,
 10298,
 1015037057,
 1014913154,
 10362,
 -1,
 1014994953,
 10490,
 -1,
 1014994953,
 10426,
 1015233668,
 1014913154,
 10330,
 -1,
 1015191561,
 10458,
 -1,
 1015191561,
 10394,
 1015430281,
 1014832754,
 10282,
 1015495816,
 1015371906,
 10346,
 -1,
 1015453705,
 10474,
 -1,
 1015453705,
 10410,
 1015692427,
 1015371906,
 10314,
 -1,
 1015650313,
 10442,
 -1,
 1015650313,
 10378,
 1015889044,
 1014811206,
 10258,
 1015954577,
 1015815794,
 10290,
 1016020112,
 1015896194,
 10354,
 -1,
 1015977993,
 10482,
 -1,
 1015977993,
 10418,
 1016216723,
 1015896194,
 10322,
 -1,
 1016174601,
 10450,
 -1,
 1016174601,
 10386,
 1016413336,
 1015815794,
 10274,
 1016478871,
 1016354946,
 10338,
 -1,
 1016436745,
 10466,
 -1,
 1016436745,
 10402,
 1016675482,
 1016354946,
 10306,
 -1,
 1016633353,
 10434,
 -1,
 1016633353,
 10370,
 1016872123,
 1012616813,
 10244,
 1016937644,
 1016827021,
 10252,
 1017003173,
 1016908358,
 10268,
 1017068706,
 1016929906,
 10300,
 1017134241,
 1017010306,
 10364,
 -1,
 1017092105,
 10492,
 -1,
 1017092105,
 10428,
 1017330852,
 1017010306,
 10332,
 -1,
 1017288713,
 10460,
 -1,
 1017288713,
 10396,
 1017527465,
 1016929906,
 10284,
 1017593000,
 1017469058,
 10348,
 -1,
 1017550857,
 10476,
 -1,
 1017550857,
 10412,
 1017789611,
 1017469058,
 10316,
 -1,
 1017747465,
 10444,
 -1,
 1017747465,
 10380,
 1017986228,
 1016908358,
 10260,
 1018051761,
 1017912946,
 10292,
 1018117296,
 1017993346,
 10356,
 -1,
 1018075145,
 10484,
 -1,
 1018075145,
 10420,
 1018313907,
 1017993346,
 10324,
 -1,
 1018271753,
 10452,
 -1,
 1018271753,
 10388,
 1018510520,
 1017912946,
 10276,
 1018576055,
 1018452098,
 10340,
 -1,
 1018533897,
 10468,
 -1,
 1018533897,
 10404,
 1018772666,
 1018452098,
 10308,
 -1,
 1018730505,
 10436,
 -1,
 1018730505,
 10372,
 1018969291,
 1016827021,
 10248,
 1019034820,
 1018939974,
 10264,
 1019100353,
 1018961522,
 10296,
 1019165888,
 1019041922,
 10360,
 -1,
 1019123721,
 10488,
 -1,
 1019123721,
 10424,
 1019362499,
 1019041922,
 10328,
 -1,
 1019320329,
 10456,
 -1,
 1019320329,
 10392,
 1019559112,
 1018961522,
 10280,
 1019624647,
 1019500674,
 10344,
 -1,
 1019582473,
 10472,
 -1,
 1019582473,
 10408,
 1019821258,
 1019500674,
 10312,
 -1,
 1019779081,
 10440,
 -1,
 1019779081,
 10376,
 1020017875,
 1018939974,
 10256,
 1020083408,
 1019944562,
 10288,
 1020148943,
 1020024962,
 10352,
 -1,
 1020106761,
 10480,
 -1,
 1020106761,
 10416,
 1020345554,
 1020024962,
 10320,
 -1,
 1020303369,
 10448,
 -1,
 1020303369,
 10384,
 1020542167,
 1019944562,
 10272,
 1020607702,
 1020483714,
 10336,
 -1,
 1020565513,
 10464,
 -1,
 1020565513,
 10400,
 1020804313,
 1020483714,
 10304,
 -1,
 1020762121,
 10432,
 -1,
 1020762121,
 10368,
 -1,
 1004150124,
 10240,
 1021066462,
 1004079630,
 -1,
 -49955,
 1021039758,
 9099,
 -1,
 1021055170,
 166,
 -1,
 1020999835,
 728,
 1021328991,
 1004065373,
 -1,
 1021394193,
 1021248307,
 -1,
 1021459699,
 1021368736,
 -1,
 1021525231,
 1021418744,
 -1,
 1021590763,
 1021468459,
 -1,
 1021656296,
 1021552526,
 118801,
 1021771775,
 1021596713,
 -1,
 -49945,
 1021651050,
 118865,
 -1,
 1021736788,
 118802,
 1021968383,
 1021625704,
 -1,
 -49942,
 1021848941,
 118957,
 -1,
 1021915736,
 118866,
 1022115054,
 1021521081,
 -1,
 -49939,
 1022044266,
 118916,
 -1,
 1022113089,
 118818,
 -1,
 1022065535,
 118819,
 1022377202,
 1021463837,
 -1,
 -49935,
 1022317739,
 118835,
 -1,
 1022364997,
 118797,
 -1,
 1022296871,
 118917,
 1022639359,
 1021424903,
 -1,
 1022704892,
 1022581427,
 -1,
 -49930,
 1022668565,
 119022,
 -49929,
 1022702943,
 119018,
 -49928,
 1022774648,
 119017,
 -49927,
 1022862414,
 119023,
 -49926,
 1022943186,
 119021,
 -49925,
 1022996115,
 119019,
 -1,
 1023051776,
 119020,
 1023279103,
 1022668438,
 -1,
 -49922,
 1023196183,
 118899,
 -1,
 1023237416,
 118935,
 1023425804,
 1022579635,
 -1,
 1023491331,
 1023347306,
 -1,
 -49918,
 1023433766,
 118945,
 -1,
 1023519488,
 118938,
 1023687942,
 1023414179,
 -1,
 -49915,
 1023615547,
 118941,
 -1,
 1023694495,
 118942,
 1023884553,
 1023659896,
 -1,
 -49912,
 1023824459,
 118944,
 -1,
 1023875229,
 118943,
 1024131071,
 1023861969,
 -1,
 -49909,
 1024021067,
 118939,
 -1,
 1024071837,
 118940,
 1024327679,
 1023368488,
 -1,
 1024343312,
 1024207323,
 -1,
 -49905,
 1024266150,
 118876,
 -1,
 1024329108,
 118882,
 -1,
 1024319556,
 118824,
 1024605500,
 1021350199,
 -1,
 1024671008,
 1024554570,
 -1,
 1024736538,
 1024614882,
 118800,
 1024851967,
 1024676905,
 -1,
 1024867609,
 1024725228,
 -1,
 -49897,
 1024822246,
 119024,
 -49896,
 1024868145,
 119026,
 -1,
 1024971635,
 118862,
 -1,
 1024800065,
 118812,
 1025245183,
 1024676905,
 -1,
 1025260831,
 1025118444,
 -1,
 -49891,
 1025215462,
 119025,
 -49890,
 1025261361,
 119027,
 -1,
 1025364851,
 118863,
 -1,
 1025193281,
 118811,
 1025588525,
 1024636167,
 -1,
 1025654060,
 1025565082,
 -1,
 1025719593,
 1025573683,
 -1,
 1025785128,
 1025659945,
 -1,
 1025850663,
 1025704755,
 -1,
 -49882,
 1025821452,
 118913,
 -1,
 1025863762,
 118914,
 -1,
 1025779818,
 118915,
 -1,
 1025728994,
 118834,
 1026228223,
 1025678584,
 -1,
 -49877,
 1026102844,
 118868,
 -1,
 1026204455,
 118860,
 -1,
 1025603812,
 118796,
 1026440498,
 1025547512,
 -1,
 1026506032,
 1026371736,
 118842,
 -1,
 1026443973,
 118850,
 -49871,
 1026451623,
 118858,
 -1,
 1026609531,
 118921,
 1026768182,
 1026388845,
 118820,
 1026883583,
 1026708521,
 -1,
 -49867,
 1026768689,
 119028,
 -1,
 1026872179,
 118911,
 1027030331,
 1026712091,
 -1,
 1027095866,
 1026975251,
 -1,
 -49863,
 1027055903,
 118906,
 -1,
 1027113556,
 118839,
 -1,
 1027023257,
 118791,
 -1,
 1026956213,
 118881,
 1027423579,
 1024567182,
 -1,
 1027489098,
 1027390686,
 -1,
 1027554628,
 1027410633,
 119006,
 1027670015,
 1027494953,
 -1,
 1027685699,
 1027597706,
 -1,
 -49854,
 1027633566,
 119008,
 -1,
 1027705131,
 119009,
 -1,
 1027642875,
 119007,
 1027997695,
 1027495698,
 119010,
 1028063231,
 1027888169,
 -1,
 1028078921,
 1027990922,
 -1,
 -49848,
 1028026782,
 119012,
 -1,
 1028098347,
 119013,
 -1,
 1028036091,
 119011,
 1028341075,
 1027424889,
 -1,
 1028406609,
 1028283688,
 -1,
 1028472144,
 1028384776,
 -1,
 -49842,
 1028401258,
 118885,
 -49841,
 1028504340,
 118827,
 -1,
 1028535617,
 118826,
 -1,
 1028433770,
 118803,
 1028849663,
 1028356107,
 118886,
 -1,
 1028766514,
 118792,
 1028930904,
 1028318602,
 -1,
 1028996438,
 1028894419,
 118910,
 -1,
 1028942685,
 118815,
 -49833,
 1028964794,
 118852,
 -1,
 1029054492,
 119016,
 1029258586,
 1028852915,
 118825,
 -1,
 1029207829,
 118889,
 -1,
 1029179202,
 118813,
 1029455228,
 1027398048,
 -1,
 1029520742,
 1029396127,
 -1,
 1029586275,
 1029460960,
 -1,
 1029651808,
 1029528872,
 118841,
 -1,
 1029601045,
 118874,
 -49823,
 1029576436,
 118897,
 -49822,
 1029713951,
 118895,
 -1,
 1029780287,
 118892,
 1030029311,
 1029557903,
 -1,
 -49819,
 1029908120,
 118807,
 -1,
 1029970077,
 118784,
 1030176111,
 1029442860,
 -1,
 1030241644,
 1030131686,
 -1,
 1030307179,
 1030219146,
 -1,
 -49814,
 1030246993,
 118859,
 -1,
 1030297757,
 118857,
 -1,
 1030229926,
 118849,
 1030569326,
 1030161344,
 118840,
 -1,
 1030518549,
 118861,
 -1,
 1030538914,
 118786,
 1030765945,
 1030119957,
 -1,
 1030831480,
 1030709760,
 -1,
 1030897013,
 1030809557,
 118793,
 1031012351,
 1030837289,
 -1,
 -49804,
 1030891626,
 118878,
 -1,
 1030960449,
 118846,
 1031208959,
 1030820277,
 -1,
 -49801,
 1031088234,
 118879,
 -1,
 1031157057,
 118845,
 -1,
 1030794018,
 118814,
 1031471103,
 1030691666,
 -1,
 -49797,
 1031350378,
 118873,
 -1,
 1031419201,
 118822,
 1031617946,
 1029392455,
 -1,
 1031683477,
 1031574825,
 -1,
 1031749000,
 1031633213,
 -1,
 1031814532,
 1031691560,
 -1,
 1031880067,
 1031783784,
 -1,
 -49790,
 1031814961,
 118977,
 -1,
 1031918451,
 118978,
 -1,
 1031852905,
 118971,
 -49787,
 1031778069,
 118976,
 -49786,
 1032080760,
 118970,
 -49785,
 1032183762,
 118975,
 -1,
 1032226816,
 118973,
 1032404363,
 1031691704,
 -1,
 -49782,
 1032342744,
 118974,
 -1,
 1032437846,
 118982,
 1032600974,
 1032346920,
 -1,
 -49779,
 1032526869,
 118983,
 -1,
 1032620804,
 118972,
 1032797585,
 1032523258,
 -1,
 -49776,
 1032716487,
 118980,
 -1,
 1032835127,
 118979,
 1032994195,
 1032729921,
 118836,
 -1,
 1032959138,
 118969,
 -49772,
 1032915875,
 118987,
 -1,
 1033047655,
 118988,
 1033256345,
 1031648116,
 -1,
 -49769,
 1033234141,
 118958,
 -49768,
 1033240775,
 118959,
 -1,
 1033359415,
 118960,
 -1,
 1033188272,
 118981,
 1033584058,
 1031583995,
 -1,
 1033649592,
 1033509021,
 -1,
 1033715109,
 1033583726,
 -1,
 1033780642,
 1033692554,
 -1,
 1033846177,
 1033718194,
 -1,
 -49760,
 1033782013,
 118990,
 -1,
 1033854988,
 118995,
 -1,
 1033803017,
 118991,
 -49757,
 1033707431,
 118993,
 -49756,
 1034056499,
 118994,
 -1,
 1034113530,
 118992,
 1034304941,
 1033668301,
 -1,
 1034370476,
 1034259656,
 118930,
 1034485759,
 1034334056,
 -1,
 1034501547,
 1034403611,
 -1,
 -49750,
 1034436401,
 118931,
 -1,
 1034539891,
 118932,
 -1,
 1034478924,
 118933,
 -1,
 1034330508,
 119014,
 1034829237,
 1034224435,
 -1,
 1034894772,
 1034765179,
 -1,
 1034960306,
 1034837984,
 -1,
 -49743,
 1034894945,
 119002,
 -1,
 1034998336,
 119003,
 -49741,
 1034881737,
 119005,
 -1,
 1035106132,
 119004,
 -1,
 1034860085,
 118937,
 1035353527,
 1034806266,
 118918,
 -1,
 1035283889,
 118912,
 -1,
 1035286993,
 119015,
 -49735,
 1033609645,
 118831,
 -1,
 1035503399,
 118785,
 1035681241,
 1033561482,
 -1,
 1035746763,
 1035646215,
 -1,
 1035812295,
 1035682722,
 -1,
 1035877826,
 1035737935,
 -1,
 1035943361,
 1035797299,
 -1,
 -49728,
 1035913996,
 118838,
 -1,
 1035956306,
 118851,
 -1,
 1035872362,
 118883,
 1036205509,
 1035852192,
 -1,
 -49724,
 1036136341,
 118891,
 -1,
 1036223632,
 118894,
 -49722,
 1036130036,
 118896,
 -1,
 1036333887,
 118893,
 1036582911,
 1035737245,
 -1,
 -49719,
 1036510202,
 118919,
 -49718,
 1036533338,
 118934,
 -1,
 1036583731,
 118832,
 1036795348,
 1035715474,
 -1,
 1036860883,
 1036717356,
 -1,
 1036926418,
 1036783526,
 118829,
 1036991953,
 1036856782,
 -1,
 -49712,
 1036949158,
 118903,
 -1,
 1036998309,
 118902,
 -1,
 1036914455,
 118904,
 -1,
 1036884241,
 118905,
 -1,
 1036791871,
 118804,
 1037385176,
 1036717356,
 -1,
 -49706,
 1037326215,
 118920,
 -49705,
 1037394620,
 118833,
 -1,
 1037492868,
 118799,
 -1,
 1037320868,
 118823,
 1037712880,
 1035608660,
 -1,
 1037778415,
 1037688845,
 -1,
 1037843938,
 1037755786,
 -1,
 1037909471,
 1037781426,
 -1,
 -49698,
 1037851571,
 118950,
 -1,
 1037930790,
 118951,
 1038155775,
 1037871475,
 -1,
 -49695,
 1038055825,
 118953,
 -1,
 1038134079,
 118952,
 1038302697,
 1037818272,
 -1,
 1038368230,
 1038278159,
 -1,
 -49691,
 1038324520,
 118962,
 -1,
 1038370124,
 118946,
 1038614527,
 1038322376,
 -1,
 -49688,
 1038527363,
 118963,
 -1,
 1038592831,
 118955,
 1038761452,
 1038243220,
 -1,
 -49685,
 1038737587,
 118947,
 -1,
 1038747988,
 118949,
 -49683,
 1038717736,
 118961,
 -49682,
 1038907793,
 118954,
 -1,
 1038944596,
 118948,
 -1,
 1037744449,
 118871,
 1039220226,
 1037648505,
 -1,
 1039285756,
 1039180046,
 -1,
 1039351289,
 1039229040,
 -1,
 1039416822,
 1039321005,
 -1,
 -49675,
 1039352573,
 118989,
 -1,
 1039425548,
 118999,
 -49673,
 1039343527,
 118997,
 -49672,
 1039561523,
 118998,
 -1,
 1039618554,
 118996,
 1039859711,
 1039276879,
 -1,
 -49669,
 1039744817,
 118908,
 -1,
 1039848307,
 118909,
 1040056319,
 1039260064,
 -1,
 1040072193,
 1039965432,
 -1,
 1040137728,
 1040045494,
 118794,
 -1,
 1040069017,
 118795,
 -1,
 1040083676,
 118867,
 -1,
 1040011867,
 118864,
 1040399893,
 1039173325,
 -1,
 1040465425,
 1040328425,
 -1,
 1040530958,
 1040428694,
 -1,
 1040596493,
 1040456527,
 -1,
 1040662025,
 1040573101,
 -1,
 -49656,
 1040639308,
 118929,
 -1,
 1040678344,
 118928,
 1040858636,
 1040584940,
 -1,
 -49653,
 1040793393,
 119029,
 -1,
 1040896883,
 118927,
 -1,
 1040790849,
 118806,
 -1,
 1040563223,
 118898,
 1041235967,
 1040455285,
 -1,
 -49648,
 1041153663,
 118965,
 -1,
 1041209203,
 118964,
 1041382932,
 1040384702,
 -1,
 -49645,
 1041305639,
 119001,
 -1,
 1041408513,
 119000,
 -1,
 1041338318,
 118853,
 1041645091,
 1040358648,
 -1,
 1041710620,
 1041584111,
 -1,
 1041776155,
 1041650729,
 -1,
 -49639,
 1041705066,
 118856,
 -49638,
 1041780335,
 118787,
 -1,
 1041856340,
 118788,
 -1,
 1041752572,
 118816,
 1042103839,
 1041640407,
 -1,
 -49634,
 1042032746,
 118901,
 -1,
 1042101569,
 118828,
 1042300450,
 1042039217,
 -1,
 -49631,
 1042229354,
 118855,
 -1,
 1042298177,
 118805,
 -1,
 1042254481,
 118875,
 1042562609,
 1041569949,
 -1,
 1042628139,
 1042485170,
 -1,
 1042693674,
 1042565191,
 -1,
 1042759209,
 1042664086,
 -1,
 -49624,
 1042687640,
 118968,
 -1,
 1042744115,
 118837,
 -1,
 1042719536,
 118967,
 -1,
 1042642289,
 118936,
 1043086896,
 1042589582,
 -1,
 1043152431,
 1043050857,
 -1,
 -49618,
 1043081322,
 118854,
 -1,
 1043150145,
 118810,
 -1,
 1043116678,
 118956,
 -1,
 1043028383,
 118847,
 1043480124,
 1042484524,
 -1,
 1043545653,
 1043428522,
 -1,
 -49612,
 1043476511,
 118880,
 -1,
 1043538315,
 118900,
 1043742264,
 1043488040,
 -1,
 -49609,
 1043718433,
 118907,
 -1,
 1043749785,
 118966,
 -49607,
 1043692645,
 118798,
 -49606,
 1043903468,
 118888,
 -49605,
 1043948411,
 118869,
 -1,
 1044043937,
 118884,
 1044201031,
 1043451535,
 -1,
 1044266566,
 1044122924,
 -1,
 1044332101,
 1044206092,
 -1,
 1044397634,
 1044309386,
 -1,
 -49599,
 1044358944,
 118924,
 -1,
 1044396675,
 118925,
 -49597,
 1044339421,
 118926,
 -49596,
 1044526629,
 118922,
 -1,
 1044581844,
 118923,
 -1,
 1044267217,
 118830,
 -1,
 1044227793,
 118877,
 1044921938,
 1044151367,
 -1,
 1044987468,
 1044866865,
 -1,
 -49590,
 1044909920,
 118984,
 -49589,
 1044976665,
 118986,
 -1,
 1045054630,
 118985,
 1045249615,
 1044932705,
 -1,
 -49586,
 1045178474,
 118887,
 -1,
 1045247297,
 118843,
 1045495807,
 1045206518,
 -1,
 -49583,
 1045374616,
 118808,
 -1,
 1045436573,
 118870,
 1045642842,
 1044872435,
 -1,
 1045708377,
 1045616609,
 -1,
 1045773912,
 1045648425,
 -1,
 -49578,
 1045702762,
 118872,
 -49577,
 1045778031,
 118789,
 -1,
 1045854036,
 118790,
 -1,
 1045750268,
 118817,
 -1,
 1045684585,
 118809,
 1046167133,
 1045607687,
 -1,
 -49572,
 1046128490,
 118821,
 -1,
 1046161917,
 118844,
 -49570,
 1046124079,
 118890,
 -1,
 1046287594,
 118848,
 1046495101,
 1021248307,
 -1,
 1046560519,
 1046466191,
 -1,
 1046626047,
 1046486253,
 -1,
 1046691490,
 1046553957,
 -1,
 1046756970,
 1046668682,
 -1,
 1046822505,
 1046676275,
 6946,
 1046937599,
 1046762537,
 -1,
 -49561,
 1046831779,
 6947,
 -49560,
 1046904680,
 6942,
 -1,
 1046971328,
 6941,
 -1,
 1046765866,
 6983,
 1047215727,
 1046699304,
 -1,
 1047281261,
 1047135027,
 6950,
 -1,
 1047256492,
 6945,
 -49554,
 1047211044,
 6940,
 -1,
 1047375507,
 6935,
 1047543412,
 1047171383,
 -1,
 1047608947,
 1047462707,
 6931,
 -49550,
 1047585728,
 6981,
 -1,
 1047626291,
 6932,
 -1,
 1047584289,
 6982,
 1047871098,
 1047496720,
 6948,
 1047986175,
 1047830375,
 -1,
 1048002169,
 1047874681,
 -1,
 -49544,
 1047943078,
 6944,
 -1,
 1047999020,
 6943,
 -1,
 1047968460,
 6949,
 1048264319,
 1047790387,
 -1,
 1048329853,
 1048196801,
 6917,
 -1,
 1048259354,
 6918,
 -49538,
 1048282146,
 6987,
 -1,
 1048401974,
 6928,
 1048592003,
 1048204972,
 6962,
 1048707071,
 1048537211,
 -1,
 -49534,
 1048595832,
 6961,
 -1,
 1048686227,
 6960,
 1048854150,
 1048529321,
 6957,
 1048969215,
 1048802177,
 6923,
 -1,
 1048849178,
 6924,
 1049050761,
 1048773374,
 6958,
 1049165823,
 1048971453,
 6925,
 -1,
 1049045786,
 6926,
 1049247371,
 1049020109,
 6921,
 -1,
 1049176858,
 6922,
 1049378445,
 1049185656,
 6951,
 -1,
 1049356019,
 6952,
 1049509519,
 1049342630,
 6929,
 -1,
 1049439002,
 6930,
 1049640593,
 1049481718,
 6938,
 -1,
 1049615250,
 6939,
 1049771667,
 1049581622,
 6919,
 -1,
 1049701146,
 6920,
 1049902741,
 1049734803,
 6933,
 -1,
 1049851535,
 6934,
 1050033816,
 1049824556,
 -1,
 -49513,
 1049966273,
 6927,
 -1,
 1050076096,
 6984,
 1050230426,
 1049984080,
 6936,
 -1,
 1050167999,
 6937,
 1050361500,
 1050202625,
 6953,
 -1,
 1050280534,
 6954,
 -49507,
 1050307218,
 6986,
 -49506,
 1050422308,
 6956,
 -49505,
 1050511594,
 6959,
 -49504,
 1050548850,
 6985,
 -49503,
 1050611622,
 6955,
 -1,
 1050720691,
 6963,
 1050885835,
 1046629894,
 -1,
 1050951345,
 1050851579,
 -1,
 1051016875,
 1050870579,
 -1,
 1051082409,
 1050942246,
 7012,
 1051197439,
 1051022377,
 -1,
 -49496,
 1051124749,
 7013,
 -1,
 1051140523,
 7018,
 -49494,
 1051019176,
 7017,
 -1,
 1051312347,
 7015,
 1051475630,
 1050938668,
 -1,
 -49491,
 1051406346,
 7016,
 -1,
 1051466534,
 7010,
 -49489,
 1051406346,
 7011,
 -49488,
 1051636020,
 7009,
 -1,
 1051674536,
 7014,
 1051868860,
 1050871531,
 -1,
 1051934391,
 1051796193,
 -1,
 1051999925,
 1051881640,
 7021,
 -1,
 1051947891,
 7024,
 1052180479,
 1051919143,
 7022,
 -1,
 1052078963,
 7025,
 -49480,
 1051895688,
 7019,
 -49479,
 1052217572,
 7023,
 -49478,
 1052268805,
 7027,
 -49477,
 1052365572,
 7020,
 -1,
 1052433418,
 7026,
 1052589764,
 1051806811,
 -1,
 1052655297,
 1052535567,
 -1,
 -49473,
 1052585994,
 7033,
 -49472,
 1052657576,
 7036,
 -1,
 1052758871,
 7032,
 1052966911,
 1052604097,
 -1,
 -49469,
 1052864704,
 7035,
 -1,
 1052926464,
 7034,
 1053163519,
 1052556890,
 -1,
 1053179592,
 1053059881,
 -1,
 -49465,
 1053126857,
 7028,
 -1,
 1053188596,
 7029,
 1053425663,
 1053140803,
 -1,
 -49462,
 1053323456,
 7030,
 -1,
 1053385216,
 7031,
 1053572829,
 1050840117,
 -1,
 1053638355,
 1053549962,
 -1,
 1053703890,
 1053588390,
 6974,
 1053818879,
 1053643817,
 -1,
 1053834961,
 1053705276,
 6975,
 -1,
 1053764378,
 6977,
 -1,
 1053800995,
 6976,
 -1,
 1053653414,
 6965,
 1054097109,
 1053570892,
 6966,
 -1,
 1054067113,
 6967,
 1054228183,
 1054070508,
 6968,
 -1,
 1054166507,
 6969,
 1054359257,
 1054168293,
 6970,
 -1,
 1054288666,
 6971,
 1054490331,
 1054331105,
 6978,
 -1,
 1054419738,
 6979,
 1054670847,
 1054416929,
 6972,
 -1,
 1054550810,
 6973,
 1054752491,
 1053548913,
 -1,
 1054818017,
 1054729610,
 -1,
 -49440,
 1054771441,
 6994,
 -1,
 1054836755,
 6995,
 1055014628,
 1054779278,
 -1,
 -49437,
 1054983531,
 6998,
 -1,
 1055013502,
 6999,
 1055211239,
 1054951495,
 -1,
 -49434,
 1055166962,
 6996,
 -1,
 1055205378,
 6997,
 -49432,
 1055132003,
 6992,
 -49431,
 1055371576,
 6993,
 -49430,
 1055404598,
 7001,
 -1,
 1055506634,
 7000,
 1055670003,
 1054680325,
 -1,
 1055735535,
 1055637456,
 -1,
 -49426,
 1055675146,
 6912,
 -1,
 1055770776,
 6913,
 -49424,
 1055712269,
 6915,
 -49423,
 1055893796,
 6964,
 -49422,
 1055924755,
 6914,
 -1,
 1056003919,
 6916,
 1056194296,
 1055608184,
 -1,
 1056259831,
 1056121428,
 -1,
 -49418,
 1056188885,
 7008,
 -1,
 1056293652,
 7003,
 -1,
 1056234677,
 7002,
 1056521981,
 1056134152,
 -1,
 1056587516,
 1056460152,
 -1,
 -49413,
 1056529007,
 7007,
 -1,
 1056584691,
 7005,
 -1,
 1056556279,
 7006,
 -49410,
 1056466098,
 7004,
 -1,
 1056804422,
 6980,
 1057030143,
 1046545153,
 -1,
 1057046278,
 1056924247,
 -1,
 1057111813,
 1056971038,
 9744,
 1057226751,
 1057047839,
 -1,
 -49404,
 1057097647,
 9746,
 -1,
 1057183706,
 9745,
 -1,
 1057032111,
 10007,
 -1,
 1056978896,
 10057,
 1057505147,
 1046529693,
 -1,
 1057570672,
 1057432933,
 -1,
 1057636124,
 1057512744,
 -1,
 1057701646,
 1057575628,
 -1,
 -49396,
 1057675599,
 42686,
 -49395,
 1057723841,
 42694,
 -1,
 1057767499,
 42674,
 1057963794,
 1057654477,
 -1,
 -49392,
 1057907552,
 42707,
 -49391,
 1057992339,
 42708,
 -1,
 1058014003,
 42709,
 1058225940,
 1057896289,
 42685,
 -1,
 1058169326,
 42684,
 1058357015,
 1058203018,
 -1,
 -49386,
 1058304139,
 42731,
 -1,
 1058379201,
 42695,
 -49384,
 1058316701,
 42664,
 -49383,
 1058480335,
 42691,
 -49382,
 1058543773,
 42703,
 -49381,
 1058617071,
 42673,
 -1,
 1058669363,
 42715,
 1058881321,
 1057591607,
 -1,
 1058946848,
 1058839800,
 42719,
 -49377,
 1058888877,
 42734,
 -1,
 1058965730,
 42735,
 1059143460,
 1058868524,
 -1,
 -49374,
 1059090565,
 42692,
 -49373,
 1059186058,
 42683,
 -1,
 1059216680,
 42706,
 -49371,
 1059067505,
 42682,
 -49370,
 1059338081,
 42659,
 -49369,
 1059409272,
 42729,
 -49368,
 1059461277,
 42725,
 -1,
 1059521331,
 42657,
 1059733300,
 1058808404,
 42675,
 1059798829,
 1059654956,
 -1,
 -49364,
 1059740968,
 42722,
 -1,
 1059811262,
 42671,
 1059995440,
 1059732928,
 -1,
 -49361,
 1059952053,
 42720,
 -1,
 1060004325,
 42727,
 -49359,
 1059927905,
 42677,
 -49358,
 1060150520,
 42726,
 -49357,
 1060182173,
 42702,
 -1,
 1060242227,
 42723,
 1060454206,
 1059694478,
 -1,
 1060519738,
 1060422546,
 -1,
 -49353,
 1060452193,
 42688,
 -49352,
 1060543736,
 42710,
 -49351,
 1060619671,
 42678,
 -1,
 1060680639,
 42680,
 -49349,
 1060466827,
 42676,
 -49348,
 1060771997,
 42679,
 -49347,
 1060877247,
 42681,
 -1,
 1060909919,
 42732,
 1061109576,
 1060418823,
 -1,
 1061175107,
 1061031212,
 -1,
 -49343,
 1061122181,
 42704,
 -49342,
 1061182760,
 42721,
 -1,
 1061227820,
 42661,
 1061437254,
 1061099677,
 -1,
 -49339,
 1061361821,
 42668,
 -1,
 1061459393,
 42669,
 -49337,
 1061369697,
 42700,
 -1,
 1061577198,
 42705,
 1061764945,
 1061083552,
 -1,
 1061830476,
 1061697377,
 -1,
 -49333,
 1061752108,
 42696,
 -1,
 1061839342,
 42711,
 1062027087,
 1061752108,
 -1,
 -49330,
 1061974149,
 42693,
 -1,
 1062014252,
 42698,
 -49328,
 1061951645,
 42717,
 -1,
 1062142771,
 42667,
 1062354777,
 1061741962,
 -1,
 1062420309,
 1062276396,
 -1,
 -49324,
 1062397322,
 42728,
 -1,
 1062427944,
 42730,
 1062616920,
 1062339379,
 -1,
 -49321,
 1062538540,
 42662,
 -1,
 1062601523,
 42672,
 -1,
 1062541469,
 42724,
 1062879071,
 1062325903,
 -1,
 -49317,
 1062811489,
 42701,
 -49316,
 1062872812,
 42718,
 -49315,
 1062934685,
 42716,
 -49314,
 1063035066,
 42670,
 -1,
 1063060275,
 42666,
 1063272292,
 1062815815,
 -1,
 -49311,
 1063204705,
 42712,
 -49310,
 1063265947,
 42713,
 -49309,
 1063359937,
 42699,
 -1,
 1063405516,
 42733,
 1063599976,
 1063207545,
 -1,
 -49306,
 1063547025,
 42689,
 -49305,
 1063593708,
 42687,
 -1,
 1063650099,
 42690,
 1063862123,
 1063564101,
 -1,
 -49302,
 1063809219,
 42697,
 -1,
 1063846707,
 42714,
 -49300,
 1063794529,
 42658,
 -49299,
 1064017144,
 42663,
 -49298,
 1064048797,
 42665,
 -49297,
 1064146369,
 42660,
 -1,
 1064174387,
 42656,
 1064386423,
 1057520714,
 -1,
 1064451958,
 1064313428,
 -1,
 1064517493,
 1064387379,
 -1,
 -49292,
 1064475476,
 42737,
 -1,
 1064529507,
 42736,
 -1,
 1064439718,
 42741,
 -1,
 1064372693,
 42740,
 -49288,
 1064318263,
 42742,
 -49287,
 1064810211,
 42743,
 -49286,
 1064854095,
 42738,
 -1,
 1064896023,
 42739,
 -49284,
 1057440221,
 9918,
 -1,
 1065081510,
 10155,
 1065238677,
 1046453496,
 -1,
 1065304122,
 1065210616,
 -1,
 1065369528,
 1065275023,
 -1,
 1065435053,
 1065345946,
 -1,
 1065500560,
 1065400571,
 -1,
 1065566091,
 1065458936,
 -1,
 1065631624,
 1065519348,
 9591,
 1065746431,
 1065554365,
 -1,
 -49274,
 1065657961,
 9484,
 -49273,
 1065703003,
 9488,
 -1,
 1065778978,
 9516,
 1066008575,
 1065575280,
 -1,
 -49270,
 1065930540,
 9550,
 -1,
 1065975586,
 9548,
 1066205183,
 1065502465,
 -1,
 1066221455,
 1066117088,
 -1,
 -49266,
 1066160264,
 9585,
 -1,
 1066207821,
 9586,
 -1,
 1066168534,
 9587,
 1066483607,
 1065447572,
 9589,
 1066598399,
 1066406333,
 -1,
 1066614677,
 1066517394,
 -1,
 -49260,
 1066587306,
 9524,
 -1,
 1066644674,
 9597,
 -49258,
 1066575465,
 9492,
 -1,
 1066751579,
 9496,
 1066942364,
 1066454828,
 9474,
 1067057151,
 1066865085,
 -1,
 -49254,
 1066968681,
 9500,
 -49253,
 1067013723,
 9508,
 -1,
 1067089698,
 9532,
 1067270051,
 1066900339,
 -1,
 1067335584,
 1067196045,
 -1,
 -49249,
 1067296361,
 9584,
 -1,
 1067341403,
 9583,
 1067581439,
 1067281008,
 -1,
 -49246,
 1067492969,
 9581,
 -1,
 1067538011,
 9582,
 1067728806,
 1067201685,
 -1,
 -49243,
 1067700012,
 9478,
 -1,
 1067745058,
 9476,
 1067925417,
 1067657369,
 -1,
 -49240,
 1067896620,
 9482,
 -1,
 1067941666,
 9480,
 1068122027,
 1067865691,
 9588,
 -1,
 1068093270,
 9596,
 -49236,
 1068082793,
 9590,
 -1,
 1068203810,
 9472,
 1068433407,
 1065356751,
 -1,
 1068449714,
 1068331029,
 -1,
 -49232,
 1068404885,
 9546,
 -49231,
 1068443494,
 9530,
 -1,
 1068512666,
 9522,
 1068711862,
 1068413616,
 -1,
 -49228,
 1068645257,
 9533,
 -49227,
 1068737270,
 9525,
 -1,
 1068817338,
 9517,
 -49225,
 1068630140,
 9539,
 -1,
 1068941915,
 9541,
 1069105123,
 1065322493,
 -1,
 1069170644,
 1069050803,
 -1,
 1069236163,
 1069147752,
 -1,
 1069301694,
 1069195527,
 -1,
 -49219,
 1069229926,
 9505,
 -1,
 1069300600,
 9485,
 1069498305,
 1069230829,
 -1,
 -49216,
 1069426534,
 9513,
 -1,
 1069497208,
 9489,
 -49214,
 1069475335,
 9543,
 -1,
 1069645913,
 9519,
 1069825996,
 1069158559,
 -1,
 1069891527,
 1069785351,
 -1,
 -49210,
 1069851382,
 9503,
 -1,
 1069933001,
 9486,
 1070088138,
 1069820653,
 -1,
 -49207,
 1070047990,
 9511,
 -1,
 1070129609,
 9490,
 -49205,
 1070010430,
 9537,
 -1,
 1070236682,
 9520,
 1070415824,
 1069798402,
 -1,
 -49202,
 1070389822,
 9554,
 -49201,
 1070436858,
 9557,
 -1,
 1070507452,
 9572,
 1070727167,
 1070359107,
 -1,
 -49198,
 1070638254,
 9555,
 -49197,
 1070670383,
 9558,
 -1,
 1070749053,
 9573,
 1070989311,
 1069139735,
 -1,
 1071005658,
 1070911276,
 9553,
 1071120383,
 1070928317,
 -1,
 -49192,
 1071031913,
 9568,
 -49191,
 1071076955,
 9571,
 -1,
 1071152930,
 9580,
 1071333342,
 1070931597,
 -1,
 -49188,
 1071294057,
 9562,
 -49187,
 1071339099,
 9565,
 -1,
 1071415074,
 9577,
 1071595490,
 1071278704,
 -1,
 -49184,
 1071556201,
 9556,
 -49183,
 1071601243,
 9559,
 -1,
 1071677218,
 9574,
 -1,
 1071546146,
 9552,
 1071923203,
 1069079782,
 -1,
 1071988717,
 1071876093,
 -1,
 1072054250,
 1071941876,
 9595,
 1072168959,
 1071976893,
 -1,
 -49176,
 1072080489,
 9487,
 -49175,
 1072125531,
 9491,
 -1,
 1072201506,
 9523,
 1072431103,
 1071997808,
 -1,
 -49172,
 1072353068,
 9551,
 -1,
 1072398114,
 9549,
 1072578548,
 1071935636,
 9593,
 1072693247,
 1072501181,
 -1,
 1072709618,
 1072615055,
 -1,
 -49167,
 1072677989,
 9599,
 -1,
 1072751166,
 9499,
 -49165,
 1072670313,
 9495,
 -1,
 1072856866,
 9531,
 1073037305,
 1072549676,
 9475,
 1073151999,
 1072959933,
 -1,
 -49161,
 1073063529,
 9507,
 -49160,
 1073108571,
 9515,
 -1,
 1073184546,
 9547,
 1073364988,
 1072968853,
 -1,
 -49157,
 1073336108,
 9479,
 -1,
 1073381154,
 9477,
 1073561599,
 1073293465,
 -1,
 -49154,
 1073532716,
 9483,
 -1,
 1073577762,
 9481,
 1073758209,
 1073501787,
 9592,
 -1,
 1073703317,
 9598,
 -49150,
 1073718889,
 9594,
 -1,
 1073839906,
 9473,
 1074020382,
 1071851412,
 -1,
 1074085901,
 1073997416,
 -1,
 1074151432,
 1074045191,
 -1,
 -49145,
 1074084728,
 9493,
 -1,
 1074148762,
 9506,
 1074348043,
 1074080493,
 -1,
 -49142,
 1074281336,
 9497,
 -1,
 1074345370,
 9514,
 -49140,
 1074298969,
 9527,
 -1,
 1074463699,
 9544,
 1074675734,
 1074008223,
 -1,
 1074741265,
 1074635015,
 -1,
 -49136,
 1074717129,
 9494,
 -1,
 1074781114,
 9502,
 1074937876,
 1074670317,
 -1,
 -49133,
 1074913737,
 9498,
 -1,
 1074977722,
 9510,
 -49131,
 1074889738,
 9528,
 -1,
 1075088893,
 9536,
 1075265562,
 1074648066,
 -1,
 -49128,
 1075239486,
 9560,
 -49127,
 1075286522,
 9563,
 -1,
 1075357116,
 9575,
 1075576831,
 1075208771,
 -1,
 -49124,
 1075487918,
 9561,
 -49123,
 1075520047,
 9564,
 -1,
 1075598717,
 9576,
 1075789871,
 1073956245,
 -1,
 1075855395,
 1075762178,
 -1,
 -49119,
 1075829310,
 9566,
 -49118,
 1075876346,
 9569,
 -1,
 1075946940,
 9578,
 1076117543,
 1075832424,
 -1,
 -49115,
 1076094847,
 9501,
 -49114,
 1076152313,
 9509,
 -1,
 1076199513,
 9535,
 1076379691,
 1076039839,
 -1,
 -49111,
 1076323887,
 9504,
 -49110,
 1076382073,
 9512,
 -1,
 1076462602,
 9538,
 1076690943,
 1076322883,
 -1,
 -49107,
 1076602030,
 9567,
 -49106,
 1076634159,
 9570,
 -1,
 1076712829,
 9579,
 1076953087,
 1075749127,
 -1,
 1076969524,
 1076834107,
 -1,
 -49102,
 1076924565,
 9545,
 -49101,
 1076963174,
 9529,
 -1,
 1077032346,
 9521,
 1077231672,
 1076927249,
 -1,
 -49098,
 1077164937,
 9534,
 -49097,
 1077256950,
 9526,
 -1,
 1077337018,
 9518,
 -49095,
 1077160046,
 9540,
 -1,
 1077465329,
 9542,
 1077624959,
 1065252917,
 -1,
 1077690490,
 1077552485,
 -1,
 1077755973,
 1077609267,
 12570,
 1077821504,
 1077697832,
 12578,
 -49089,
 1077763368,
 12713,
 -1,
 1077839565,
 12580,
 1078018114,
 1077753697,
 12576,
 -1,
 1077943063,
 12719,
 1078149188,
 1077942429,
 12574,
 -1,
 1078074135,
 12718,
 -1,
 1078075988,
 12720,
 1078345805,
 1077677356,
 12572,
 1078411337,
 1078287656,
 12579,
 -49080,
 1078353192,
 12709,
 -1,
 1078429389,
 12581,
 -49078,
 1078375687,
 12582,
 -49077,
 1078532253,
 12575,
 -49076,
 1078641554,
 12573,
 -1,
 1078660396,
 12708,
 1078870100,
 1078270109,
 12583,
 1078935632,
 1078795031,
 12714,
 -1,
 1078877480,
 12723,
 -49071,
 1078867809,
 12585,
 -49070,
 1079031047,
 12712,
 -49069,
 1079059028,
 12716,
 -1,
 1079165842,
 12589,
 1079328859,
 1078828280,
 12571,
 1079394392,
 1079270696,
 -1,
 -49065,
 1079336232,
 12711,
 -1,
 1079412429,
 12722,
 -49063,
 1079326561,
 12577,
 -49062,
 1079549176,
 12710,
 -1,
 1079583316,
 12721,
 1079787614,
 1079279563,
 12567,
 -49059,
 1079711901,
 12705,
 -1,
 1079821202,
 12563,
 1079984225,
 1079729448,
 12555,
 1080098815,
 1079936717,
 12587,
 -1,
 1080002253,
 12717,
 1080180836,
 1079936717,
 12557,
 -49053,
 1080112993,
 12707,
 -1,
 1080188200,
 12588,
 1080377446,
 1080112993,
 12584,
 -1,
 1080302359,
 12715,
 1080508520,
 1080338318,
 12569,
 -1,
 1080476562,
 12565,
 1080639594,
 1080447692,
 12560,
 -1,
 1080563869,
 12706,
 1080770668,
 1080589168,
 12568,
 -1,
 1080738706,
 12564,
 1080901742,
 1080704448,
 12549,
 -1,
 1080833889,
 12704,
 -49041,
 1080821679,
 12562,
 -49040,
 1080980680,
 12586,
 -49039,
 1081075082,
 12554,
 -49038,
 1081128199,
 12566,
 -49037,
 1081158973,
 12561,
 -49036,
 1081268640,
 12550,
 -49035,
 1081287252,
 12551,
 -49034,
 1081396879,
 12556,
 -49033,
 1081446711,
 12558,
 -49032,
 1081525138,
 12559,
 -49031,
 1081559111,
 12552,
 -1,
 1081653499,
 12553,
 1081868287,
 1077614479,
 -1,
 -49028,
 1081795978,
 12725,
 -49027,
 1081858464,
 12724,
 -49026,
 1081905463,
 12726,
 -1,
 1081983890,
 12727,
 1082146961,
 1077565647,
 -1,
 1082212485,
 1082106119,
 -1,
 1082278020,
 1082162032,
 -1,
 -49021,
 1082224726,
 8972,
 -1,
 1082272345,
 8991,
 -1,
 1082231905,
 11813,
 1082540170,
 1082141421,
 -1,
 1082605705,
 1082489712,
 -1,
 -49016,
 1082552406,
 8973,
 -1,
 1082600025,
 8990,
 -1,
 1082559585,
 11812,
 1082867852,
 1082495801,
 9141,
 -1,
 1082836652,
 9142,
 -49011,
 1082835080,
 9185,
 -49010,
 1082925471,
 9181,
 -49009,
 1082999167,
 8993,
 -49008,
 1083072306,
 9183,
 -1,
 1083166784,
 10555,
 1083375615,
 1082110186,
 8904,
 1083441151,
 1083262239,
 -1,
 -49004,
 1083350757,
 10706,
 -1,
 1083409671,
 10705,
 1083588893,
 1065159980,
 -1,
 1083654421,
 1083530536,
 -1,
 1083719955,
 1083628056,
 -1,
 1083785437,
 1083647333,
 -1,
 1083850912,
 1083749639,
 -1,
 1083916446,
 1083769651,
 2480,
 1084030975,
 1083852063,
 -1,
 -48995,
 1083933432,
 2544,
 -1,
 1083966160,
 2545,
 -48993,
 1083853225,
 2524,
 -1,
 1084144051,
 2525,
 1084309669,
 1083769572,
 -1,
 1084375203,
 1084273927,
 2443,
 -1,
 1084339463,
 2528,
 1084555263,
 1084345999,
 2444,
 -1,
 1084477071,
 2529,
 1084637355,
 1084286346,
 -1,
 1084702889,
 1084614026,
 -1,
 -48984,
 1084668339,
 2464,
 -1,
 1084687155,
 2463,
 -48982,
 1084668339,
 2469,
 -1,
 1084818227,
 2468,
 1085030576,
 1084579112,
 -1,
 -48979,
 1084959780,
 2462,
 -48978,
 1085020957,
 2467,
 -48977,
 1085124243,
 2457,
 -1,
 1085145907,
 2472,
 1085358262,
 1084995835,
 -1,
 1085423796,
 1085323515,
 -1,
 -48973,
 1085389235,
 2466,
 -1,
 1085408051,
 2465,
 -48971,
 1085389235,
 2471,
 -1,
 1085539123,
 2470,
 1085751482,
 1085276979,
 2437,
 -48968,
 1085683553,
 2452,
 -48967,
 1085741213,
 2448,
 -1,
 1085801267,
 2438,
 1086013630,
 1085712270,
 -1,
 -48964,
 1085953708,
 2487,
 -48963,
 1086044595,
 2486,
 -1,
 1086063411,
 2488,
 1086275778,
 1085968695,
 -1,
 1086341313,
 1086241203,
 2454,
 -1,
 1086306802,
 2510,
 -1,
 1086260019,
 2453,
 1086537925,
 1086210681,
 -1,
 -48956,
 1086467108,
 2527,
 -1,
 1086522163,
 2479,
 1086734535,
 1086469985,
 2441,
 -1,
 1086666593,
 2442,
 1086865610,
 1086708128,
 -1,
 -48951,
 1086831027,
 2475,
 -1,
 1086849843,
 2474,
 1087062221,
 1086804684,
 -1,
 -48948,
 1087027635,
 2461,
 -1,
 1087046451,
 2460,
 1087258831,
 1086986397,
 2439,
 -1,
 1087183005,
 2440,
 1087389906,
 1087211213,
 -1,
 -48943,
 1087355315,
 2456,
 -1,
 1087374131,
 2455,
 1087586517,
 1087339376,
 -1,
 -48940,
 1087551923,
 2459,
 -1,
 1087570739,
 2458,
 1087783128,
 1087520192,
 -1,
 -48937,
 1087748531,
 2477,
 -1,
 1087767347,
 2476,
 -48935,
 1087741176,
 2451,
 -48934,
 1087901606,
 2478,
 -48933,
 1087963902,
 2482,
 -48932,
 1088076211,
 2489,
 -1,
 1088097580,
 2447,
 1088307437,
 1083739189,
 -1,
 1088372963,
 1088226020,
 -1,
 1088438497,
 1088337159,
 2499,
 -1,
 1088402695,
 2500,
 1088618495,
 1088409231,
 2530,
 -1,
 1088540303,
 2531,
 1088700647,
 1088291635,
 -1,
 -48923,
 1088632673,
 2508,
 -48922,
 1088690333,
 2504,
 -1,
 1088750387,
 2494,
 1088962793,
 1088632673,
 2497,
 -1,
 1088894817,
 2498,
 1089093867,
 1088886941,
 2495,
 -1,
 1089018013,
 2496,
 -48916,
 1089051896,
 2507,
 -1,
 1089146156,
 2503,
 1089356027,
 1088282993,
 -1,
 1089421553,
 1089332618,
 -1,
 -48912,
 1089374449,
 2536,
 -1,
 1089439763,
 2537,
 1089618164,
 1089382286,
 -1,
 -48909,
 1089586539,
 2540,
 -1,
 1089616510,
 2541,
 1089814775,
 1089554503,
 -1,
 -48906,
 1089769970,
 2538,
 -1,
 1089808386,
 2539,
 -48904,
 1089735011,
 2534,
 -48903,
 1089974584,
 2535,
 -48902,
 1090007606,
 2543,
 -1,
 1090109642,
 2542,
 1090273540,
 1089283333,
 -1,
 1090339071,
 1090223360,
 -1,
 -48898,
 1090305194,
 2435,
 -1,
 1090338289,
 2509,
 1090535682,
 1090257715,
 -1,
 -48895,
 1090485044,
 2493,
 -1,
 1090537706,
 2434,
 -48893,
 1090458852,
 2492,
 -1,
 1090672798,
 2433,
 1090863373,
 1090240400,
 -1,
 1090928908,
 1090797742,
 -1,
 1090994441,
 1090905482,
 -1,
 -48888,
 1090947313,
 2549,
 -1,
 1091012627,
 2550,
 1091191051,
 1090957624,
 2548,
 -1,
 1091162896,
 2552,
 -1,
 1091120771,
 2551,
 -1,
 1090873938,
 2553,
 1091453200,
 1090832585,
 -1,
 -48881,
 1091417481,
 2547,
 -1,
 1091462399,
 2546,
 -48879,
 1091377733,
 2554,
 -48878,
 1091576323,
 2555,
 -1,
 1091679262,
 2519,
 1091895295,
 1083688112,
 9004,
 -1,
 1091807290,
 9187,
 1091977496,
 1083630986,
 -1,
 -48873,
 1091898959,
 8812,
 -1,
 1091988624,
 8502,
 1092174107,
 1091953289,
 -1,
 -48870,
 1092129998,
 9836,
 -1,
 1092176361,
 9835,
 -48868,
 1092125830,
 9086,
 -1,
 1092316851,
 8757,
 1092501924,
 1083507454,
 -1,
 1092567459,
 1092451396,
 -1,
 1092632984,
 1092506665,
 -1,
 1092698417,
 1092582256,
 -1,
 1092763945,
 1092629581,
 -1,
 1092829477,
 1092718903,
 -1,
 -48860,
 1092796437,
 9822,
 -1,
 1092831144,
 9818,
 -48858,
 1092767311,
 9820,
 -48857,
 1092969721,
 9819,
 -48856,
 1093063702,
 9823,
 -1,
 1093111606,
 9821,
 1093288238,
 1092729929,
 9679,
 1093402623,
 1093223711,
 -1,
 -48852,
 1093322461,
 9864,
 -48851,
 1093386566,
 9865,
 -1,
 1093404810,
 10733,
 -48849,
 1093230169,
 9960,
 -48848,
 1093545129,
 9827,
 -1,
 1093611391,
 10028,
 1093812545,
 1092659086,
 -1,
 1093878074,
 1093739092,
 -1,
 1093943609,
 1093828060,
 -1,
 1094009143,
 1093904270,
 -1,
 -48842,
 1093967204,
 11089,
 -1,
 1094043692,
 9642,
 -48840,
 1093941360,
 11050,
 -1,
 1094126573,
 11049,
 -1,
 1093897652,
 9787,
 -48837,
 1093832731,
 9728,
 -48836,
 1094360420,
 9733,
 -48835,
 1094436908,
 9632,
 -48834,
 1094499216,
 9824,
 -48833,
 1094520026,
 9927,
 -48832,
 1094605144,
 9751,
 -1,
 1094656310,
 9986,
 1094861139,
 1093783183,
 -1,
 1094926667,
 1094836798,
 -1,
 1094992199,
 1094876554,
 -1,
 -48827,
 1094922346,
 9664,
 -48826,
 1095032305,
 9666,
 -1,
 1095095741,
 9668,
 1095254346,
 1094931497,
 -1,
 -48823,
 1095230368,
 9754,
 -1,
 1095264107,
 9944,
 -1,
 1095194812,
 8268,
 1095516496,
 1094884600,
 -1,
 1095582031,
 1095481226,
 -1,
 -48818,
 1095549743,
 9698,
 -1,
 1095616751,
 9699,
 -1,
 1095511966,
 10731,
 1095892991,
 1095457636,
 -1,
 -48814,
 1095768652,
 11035,
 -1,
 1095836519,
 11044,
 1096040801,
 1094825223,
 -1,
 1096106336,
 1096000062,
 -1,
 1096171867,
 1096056202,
 -1,
 1096237401,
 1096145312,
 -1,
 -48808,
 1096197818,
 9658,
 -1,
 1096273423,
 11091,
 -48806,
 1096167530,
 9654,
 -1,
 1096408561,
 9656,
 1096565087,
 1096146432,
 -1,
 1096630622,
 1096507046,
 10145,
 -1,
 1096549173,
 10148,
 -1,
 1096587348,
 8269,
 -1,
 1096502657,
 9755,
 -1,
 1096068188,
 9644,
 1096958317,
 1096005883,
 -1,
 1097023847,
 1096894227,
 9670,
 1097138175,
 1096963113,
 -1,
 -48795,
 1097045882,
 10730,
 -48794,
 1097092975,
 9830,
 -1,
 1097196267,
 10070,
 1097351530,
 1096993693,
 -1,
 -48791,
 1097283714,
 9922,
 -1,
 1097378589,
 9923,
 1097596927,
 1097292385,
 -1,
 -48788,
 1097478250,
 9660,
 -1,
 1097588209,
 9662,
 1097744758,
 1096890209,
 -1,
 1097810293,
 1097718176,
 -1,
 1097875826,
 1097744246,
 -1,
 -48783,
 1097843503,
 9701,
 -1,
 1097910511,
 9700,
 1098121215,
 1097825674,
 -1,
 -48780,
 1098002538,
 9650,
 -1,
 1098112497,
 9652,
 -1,
 1097784261,
 9851,
 1098334590,
 1097671252,
 -1,
 1098400125,
 1098256331,
 -1,
 1098465659,
 1098360718,
 -1,
 -48774,
 1098434604,
 9724,
 -1,
 1098464321,
 9726,
 -48772,
 1098397808,
 11047,
 -1,
 1098583021,
 11045,
 -1,
 1098324688,
 9912,
 1098858885,
 1098302354,
 -1,
 1098924418,
 1098816760,
 -1,
 -48767,
 1098866539,
 10711,
 -1,
 1098931723,
 11052,
 1099169791,
 1098845484,
 -1,
 -48764,
 1099044062,
 11042,
 -1,
 1099116119,
 9829,
 1099317642,
 1098824588,
 -1,
 1099383177,
 1099236018,
 -1,
 -48760,
 1099326985,
 9646,
 -1,
 1099373256,
 11054,
 -1,
 1099315697,
 11037,
 1099645326,
 1099294090,
 -1,
 -48756,
 1099593433,
 9942,
 -48755,
 1099668795,
 9951,
 -1,
 1099706617,
 9742,
 1099907475,
 1099581511,
 -1,
 1099973010,
 1099878031,
 -1,
 -48751,
 1099898680,
 10047,
 -1,
 1099981300,
 9873,
 -1,
 1099940537,
 10022,
 1100235158,
 1099880864,
 -1,
 -48747,
 1100205583,
 11039,
 -1,
 1100276717,
 9648,
 -48745,
 1100210569,
 10002,
 -1,
 1100362360,
 10707,
 1100611583,
 1092596872,
 -1,
 1100628383,
 1100502340,
 -1,
 -48741,
 1100578763,
 8488,
 -48740,
 1100657927,
 8476,
 -48739,
 1100683421,
 8465,
 -48738,
 1100792722,
 8460,
 -1,
 1100839792,
 8493,
 1101070335,
 1100548730,
 -1,
 -48735,
 1100967666,
 10164,
 -48734,
 1101061247,
 10165,
 -1,
 1101122419,
 10166,
 -1,
 1092528405,
 9250,
 1101349350,
 1092433761,
 -1,
 1101414858,
 1101301710,
 -1,
 1101480386,
 1101342053,
 -1,
 1101545904,
 1101421864,
 -1,
 1101611435,
 1101480569,
 -1,
 -48726,
 1101560912,
 6671,
 -1,
 1101595443,
 6670,
 1101808046,
 1101563597,
 -1,
 -48723,
 1101782991,
 6659,
 -1,
 1101792051,
 6658,
 -48721,
 1101744553,
 6667,
 -1,
 1101923123,
 6666,
 1102135731,
 1101472340,
 -1,
 -48718,
 1102073208,
 6663,
 -1,
 1102119731,
 6662,
 -48716,
 1102064676,
 6672,
 -48715,
 1102281971,
 6675,
 -48714,
 1102340578,
 6664,
 -48713,
 1102403244,
 6676,
 -48712,
 1102465449,
 6673,
 -48711,
 1102531960,
 6660,
 -48710,
 1102578430,
 6674,
 -48709,
 1102700495,
 6656,
 -48708,
 1102762486,
 6669,
 -48707,
 1102821811,
 6678,
 -48706,
 1102884499,
 6657,
 -48705,
 1102940176,
 6665,
 -48704,
 1103002704,
 6668,
 -48703,
 1103090177,
 6661,
 -1,
 1103102771,
 6677,
 1103315400,
 1101433909,
 -1,
 -48700,
 1103247201,
 6680,
 -48699,
 1103338744,
 6682,
 -48698,
 1103370397,
 6679,
 -48697,
 1103433004,
 6681,
 -1,
 1103520238,
 6683,
 -48695,
 1103275399,
 6686,
 -1,
 1103670432,
 6687,
 1103839714,
 1101356019,
 -1,
 1103905247,
 1103766885,
 -1,
 1103970767,
 1103846696,
 -1,
 -48690,
 1103933075,
 5957,
 -1,
 1103954739,
 5960,
 -48688,
 1103899684,
 5964,
 -48687,
 1104120042,
 5967,
 -48686,
 1104164705,
 5954,
 -48685,
 1104241122,
 5958,
 -48684,
 1104303788,
 5968,
 -48683,
 1104365993,
 5965,
 -48682,
 1104432504,
 5961,
 -48681,
 1104482214,
 5963,
 -48680,
 1104544510,
 5966,
 -48679,
 1104666575,
 5955,
 -48678,
 1104681117,
 5953,
 -48677,
 1104787891,
 5969,
 -48676,
 1104850579,
 5956,
 -48675,
 1104906256,
 5959,
 -48674,
 1104990721,
 5962,
 -1,
 1105003315,
 5952,
 1105264639,
 1103858741,
 -1,
 -48671,
 1105147745,
 5971,
 -1,
 1105205405,
 5970,
 1105461247,
 1103758084,
 -1,
 1105478117,
 1105368554,
 8226,
 -1,
 1105446392,
 8729,
 -1,
 1105412979,
 9678,
 1105723391,
 1101273245,
 -1,
 1105740266,
 1105636957,
 -1,
 -48663,
 1105677809,
 10744,
 -1,
 1105762230,
 10745,
 -1,
 1105695238,
 9763,
 1106003951,
 1004004746,
 -1,
 1106068514,
 1105920819,
 -1,
 1106133790,
 1106036072,
 -1,
 1106199190,
 1106086447,
 -1,
 1106264627,
 1106126181,
 -1,
 1106330120,
 1106235023,
 -1,
 1106395652,
 1106287423,
 -1,
 1106461174,
 1106350391,
 -1,
 -48652,
 1106417325,
 6692,
 -48651,
 1106491827,
 6693,
 -1,
 1106510643,
 6691,
 1106723321,
 1106437514,
 -1,
 -48648,
 1106688435,
 6709,
 -1,
 1106707251,
 6708,
 1106919932,
 1106696608,
 -1,
 -48645,
 1106885043,
 6717,
 -1,
 1106903859,
 6715,
 1107116543,
 1106869104,
 -1,
 -48642,
 1107081651,
 6699,
 -1,
 1107100467,
 6697,
 -48640,
 1107045412,
 6719,
 -48639,
 1107252908,
 6698,
 -48638,
 1107318985,
 6704,
 -48637,
 1107409331,
 6732,
 -1,
 1107468543,
 6716,
 1107640838,
 1106314035,
 6723,
 -1,
 1107561772,
 6739,
 -48633,
 1107587267,
 6724,
 -1,
 1107690238,
 6730,
 1107903006,
 1106278728,
 -1,
 1107968525,
 1107863438,
 -1,
 -48629,
 1107908268,
 6727,
 -48628,
 1107999155,
 6726,
 -1,
 1108017971,
 6728,
 1108230673,
 1107923255,
 -1,
 -48625,
 1108186797,
 6690,
 -48624,
 1108261299,
 6689,
 -1,
 1108280115,
 6688,
 1108492820,
 1108206986,
 -1,
 -48621,
 1108457907,
 6707,
 -1,
 1108476723,
 6706,
 1108689431,
 1108466080,
 -1,
 -48618,
 1108654515,
 6713,
 -1,
 1108673331,
 6712,
 1108886042,
 1108638576,
 -1,
 -48615,
 1108851123,
 6696,
 -1,
 1108869939,
 6695,
 -48613,
 1108814884,
 6720,
 -48612,
 1109022921,
 6702,
 -48611,
 1109113267,
 6729,
 -1,
 1109172479,
 6714,
 1109344803,
 1107866887,
 -1,
 1109410338,
 1109263155,
 6721,
 -48607,
 1109352930,
 6701,
 -1,
 1109400349,
 6705,
 -1,
 1109356739,
 6722,
 1109672487,
 1109286184,
 -1,
 -48603,
 1109601316,
 6700,
 -48602,
 1109700243,
 6694,
 -1,
 1109721907,
 6710,
 1109934633,
 1109604193,
 6735,
 -1,
 1109866337,
 6736,
 1110065707,
 1109858461,
 6733,
 -1,
 1109989533,
 6734,
 -48596,
 1110018282,
 6725,
 -48595,
 1110124181,
 6738,
 -48594,
 1110183846,
 6718,
 -48593,
 1110266040,
 6740,
 -48592,
 1110349249,
 6737,
 -48591,
 1110411280,
 6703,
 -48590,
 1110495745,
 6711,
 -1,
 1110508339,
 6731,
 1110721109,
 1106191621,
 -1,
 1110786622,
 1110675767,
 -1,
 1110852155,
 1110762793,
 -1,
 1110917690,
 1110823371,
 -1,
 -48584,
 1110886982,
 6777,
 -48583,
 1110936717,
 6776,
 -1,
 1110986349,
 6775,
 -1,
 1110843393,
 6780,
 1111245373,
 1110782067,
 6824,
 -1,
 1111187653,
 6825,
 -1,
 1111180907,
 6819,
 1111441987,
 1110726316,
 -1,
 1111507521,
 1111410874,
 6826,
 -1,
 1111449797,
 6827,
 -48574,
 1111479240,
 6818,
 -1,
 1111574713,
 6752,
 1111769672,
 1111383750,
 -1,
 1111835206,
 1111697167,
 6772,
 -1,
 1111811670,
 6744,
 -48569,
 1111808311,
 6823,
 -1,
 1111929374,
 6779,
 1112097354,
 1111695742,
 6816,
 -1,
 1112069192,
 6817,
 1112228429,
 1112037389,
 -1,
 -48564,
 1112151056,
 6774,
 -1,
 1112260264,
 6773,
 1112425040,
 1112192263,
 -1,
 -48561,
 1112343814,
 6822,
 -1,
 1112462453,
 6778,
 1112621651,
 1112392594,
 -1,
 -48558,
 1112549076,
 6820,
 -1,
 1112658775,
 6828,
 -48556,
 1112547011,
 6821,
 -1,
 1112781753,
 6829,
 1112949355,
 1110674485,
 -1,
 1113014876,
 1112907000,
 6763,
 1113080410,
 1112934649,
 -1,
 -48551,
 1113045110,
 6764,
 -1,
 1113089253,
 6771,
 -48549,
 1113014905,
 6765,
 -1,
 1113234680,
 6768,
 1113408096,
 1112946529,
 6761,
 1113473631,
 1113339745,
 6762,
 -1,
 1113394476,
 6760,
 -1,
 1113394476,
 6759,
 1113670244,
 1113326387,
 6753,
 -48542,
 1113594013,
 6769,
 -48541,
 1113656620,
 6767,
 -1,
 1113719603,
 6755,
 1113932391,
 1113646474,
 -1,
 -48538,
 1113899231,
 6770,
 -1,
 1113974541,
 6756,
 1114129001,
 1113856157,
 6757,
 -1,
 1114052765,
 6758,
 -48534,
 1114065725,
 6754,
 -1,
 1114180908,
 6766,
 1114391161,
 1112883450,
 -1,
 1114456687,
 1114367370,
 -1,
 -48530,
 1114409201,
 6802,
 -1,
 1114474515,
 6803,
 1114653298,
 1114417038,
 -1,
 -48527,
 1114621291,
 6806,
 -1,
 1114651262,
 6807,
 1114849909,
 1114589255,
 -1,
 -48524,
 1114804722,
 6804,
 -1,
 1114843138,
 6805,
 -48522,
 1114769763,
 6800,
 -48521,
 1115009336,
 6801,
 -48520,
 1115042358,
 6809,
 -1,
 1115144394,
 6808,
 1115308679,
 1114339885,
 -1,
 1115374205,
 1115284874,
 -1,
 -48516,
 1115326705,
 6786,
 -1,
 1115392019,
 6787,
 1115570816,
 1115334542,
 -1,
 -48513,
 1115538795,
 6790,
 -1,
 1115568766,
 6791,
 1115767427,
 1115506759,
 -1,
 -48510,
 1115722226,
 6788,
 -1,
 1115760642,
 6789,
 -48508,
 1115687267,
 6784,
 -48507,
 1115926840,
 6785,
 -48506,
 1115959862,
 6793,
 -1,
 1116061898,
 6792,
 1116274687,
 1115257930,
 -1,
 1116291733,
 1116181163,
 -1,
 1116357262,
 1116217940,
 -1,
 1116422797,
 1116286979,
 -1,
 -48500,
 1116359081,
 6741,
 -1,
 1116406526,
 6742,
 -1,
 1116341043,
 6748,
 1116684945,
 1116327567,
 -1,
 -48496,
 1116641619,
 6746,
 -1,
 1116724799,
 6743,
 -48494,
 1116624556,
 6750,
 -48493,
 1116836029,
 6747,
 -48492,
 1116891128,
 6745,
 -1,
 1116983809,
 6749,
 -1,
 1116268059,
 6783,
 1117209332,
 1106130499,
 -1,
 1117274838,
 1117136229,
 -1,
 1117340343,
 1117207525,
 -1,
 1117405853,
 1117281576,
 -1,
 -48485,
 1117364653,
 43664,
 -48484,
 1117428984,
 43672,
 -1,
 1117499030,
 43656,
 1117668002,
 1117360439,
 -1,
 1117733537,
 1117635474,
 -1,
 -48480,
 1117691128,
 43650,
 -1,
 1117763998,
 43652,
 -1,
 1117691128,
 43648,
 1117995685,
 1117644170,
 -1,
 -48476,
 1117953272,
 43668,
 -1,
 1118026142,
 43670,
 1118192296,
 1117968800,
 -1,
 -48473,
 1118149880,
 43676,
 -1,
 1118222750,
 43678,
 1118388907,
 1118141296,
 -1,
 -48470,
 1118346488,
 43658,
 -1,
 1118419358,
 43660,
 -48468,
 1118347693,
 43684,
 -48467,
 1118534939,
 43690,
 -48466,
 1118590629,
 43662,
 -48465,
 1118652847,
 43686,
 -48464,
 1118739704,
 43694,
 -48463,
 1118769071,
 43682,
 -48462,
 1118831361,
 43688,
 -48461,
 1118943646,
 43692,
 -48460,
 1119006358,
 43654,
 -48459,
 1119068451,
 43680,
 -48458,
 1119127549,
 43666,
 -1,
 1119186546,
 43674,
 1119420415,
 1117288776,
 -1,
 1119437500,
 1119313192,
 -1,
 -48454,
 1119396269,
 43665,
 -48453,
 1119460600,
 43673,
 -1,
 1119530646,
 43657,
 1119699649,
 1119392055,
 -1,
 1119765184,
 1119667090,
 -1,
 -48449,
 1119722744,
 43651,
 -1,
 1119795614,
 43653,
 -1,
 1119722744,
 43649,
 1120027332,
 1119675786,
 -1,
 -48445,
 1119984888,
 43669,
 -1,
 1120057758,
 43671,
 1120223943,
 1120000416,
 -1,
 -48442,
 1120181496,
 43677,
 -1,
 1120254366,
 43679,
 1120420554,
 1120172912,
 -1,
 -48439,
 1120378104,
 43659,
 -1,
 1120450974,
 43661,
 -48437,
 1120379309,
 43685,
 -48436,
 1120566555,
 43691,
 -48435,
 1120622245,
 43663,
 -48434,
 1120684463,
 43687,
 -48433,
 1120771320,
 43695,
 -48432,
 1120800687,
 43683,
 -48431,
 1120862977,
 43689,
 -48430,
 1120975262,
 43693,
 -48429,
 1121037974,
 43655,
 -48428,
 1121100067,
 43681,
 -48427,
 1121159165,
 43667,
 -1,
 1121218162,
 43675,
 1121403621,
 1117219913,
 -1,
 1121469149,
 1121321779,
 -1,
 -48423,
 1121403513,
 43708,
 -48422,
 1121480899,
 43707,
 -48421,
 1121541416,
 43709,
 -48420,
 1121591892,
 43710,
 -1,
 1121649459,
 43697,
 1121862369,
 1121400673,
 43700,
 1121927904,
 1121783084,
 43699,
 -1,
 1121846067,
 43705,
 -1,
 1121846067,
 43706,
 1122124515,
 1121786013,
 43698,
 -1,
 1122042675,
 43704,
 -48412,
 1122082040,
 43702,
 -1,
 1122176300,
 43701,
 1122386668,
 1121344259,
 -1,
 1122452201,
 1122361307,
 -1,
 -48408,
 1122393384,
 43739,
 -1,
 1122493514,
 43743,
 -48406,
 1122415134,
 43741,
 -48405,
 1122575615,
 43740,
 -1,
 1122656353,
 43742,
 1122845425,
 1122359000,
 -1,
 -48402,
 1122820461,
 43713,
 -48401,
 1122871026,
 43714,
 -48400,
 1122903295,
 43712,
 -1,
 1122997694,
 43711,
 1123221503,
 1122817983,
 -1,
 -48397,
 1123116414,
 43703,
 -1,
 1123210071,
 43696,
 1123418111,
 1117162500,
 -1,
 1123435265,
 1123345802,
 -1,
 1123500796,
 1123400851,
 -1,
 -48392,
 1123425906,
 6516,
 -48391,
 1123535430,
 6515,
 -48390,
 1123585165,
 6514,
 -48389,
 1123634797,
 6513,
 -1,
 1123685392,
 6512,
 1123894015,
 1123461006,
 -1,
 -48386,
 1123858867,
 6497,
 -1,
 1123877683,
 6483,
 -48384,
 1123858867,
 6487,
 -1,
 1124008755,
 6486,
 1124221700,
 1123355948,
 6507,
 -48381,
 1124189074,
 6502,
 -1,
 1124207916,
 6501,
 1124418311,
 1124139827,
 6499,
 -48378,
 1124364483,
 6508,
 -1,
 1124407453,
 6509,
 1124614921,
 1124349793,
 6503,
 -1,
 1124535596,
 6506,
 1124745996,
 1124587936,
 -1,
 -48373,
 1124710835,
 6490,
 -1,
 1124729651,
 6489,
 1124942606,
 1124703480,
 6505,
 -1,
 1124900088,
 6504,
 1125073681,
 1124883752,
 -1,
 -48368,
 1125035667,
 6482,
 -1,
 1125057331,
 6498,
 1125270292,
 1125028151,
 -1,
 -48365,
 1125235123,
 6496,
 -1,
 1125253939,
 6480,
 -48363,
 1125198884,
 6485,
 -48362,
 1125422765,
 6481,
 -48361,
 1125481715,
 6493,
 -48360,
 1125537452,
 6484,
 -48359,
 1125596889,
 6495,
 -48358,
 1125650342,
 6491,
 -48357,
 1125712638,
 6488,
 -48356,
 1125783709,
 6500,
 -48355,
 1125890483,
 6494,
 -1,
 1125949695,
 6492,
 1126122435,
 1106085581,
 -1,
 1126187925,
 1126061097,
 -1,
 1126253407,
 1126157967,
 -1,
 1126318936,
 1126216793,
 -1,
 1126384445,
 1126283966,
 -1,
 -48348,
 1126334411,
 917626,
 -48347,
 1126384249,
 917625,
 -48346,
 1126434735,
 917624,
 -48345,
 1126544197,
 917623,
 -48344,
 1126593736,
 917622,
 -48343,
 1126643553,
 917621,
 -48342,
 1126753674,
 917620,
 -48341,
 1126803342,
 917619,
 -48340,
 1126872327,
 917618,
 -48339,
 1126903101,
 917617,
 -48338,
 1127012768,
 917616,
 -48337,
 1127062776,
 917615,
 -48336,
 1127111976,
 917614,
 -48335,
 1127162452,
 917613,
 -48334,
 1127272079,
 917612,
 -48333,
 1127321911,
 917611,
 -48332,
 1127371468,
 917610,
 -48331,
 1127422109,
 917609,
 -48330,
 1127531410,
 917608,
 -48329,
 1127581389,
 917607,
 -48328,
 1127630919,
 917606,
 -48327,
 1127681324,
 917605,
 -48326,
 1127790843,
 917604,
 -48325,
 1127840624,
 917603,
 -48324,
 1127890368,
 917602,
 -1,
 1127940915,
 917601,
 1128202239,
 1126335038,
 -1,
 -48321,
 1128103883,
 917594,
 -48320,
 1128153721,
 917593,
 -48319,
 1128204207,
 917592,
 -48318,
 1128313669,
 917591,
 -48317,
 1128363208,
 917590,
 -48316,
 1128413025,
 917589,
 -48315,
 1128523146,
 917588,
 -48314,
 1128572814,
 917587,
 -48313,
 1128641799,
 917586,
 -48312,
 1128672573,
 917585,
 -48311,
 1128782240,
 917584,
 -48310,
 1128832248,
 917583,
 -48309,
 1128881448,
 917582,
 -48308,
 1128931924,
 917581,
 -48307,
 1129041551,
 917580,
 -48306,
 1129091383,
 917579,
 -48305,
 1129140940,
 917578,
 -48304,
 1129191581,
 917577,
 -48303,
 1129300882,
 917576,
 -48302,
 1129350861,
 917575,
 -48301,
 1129400391,
 917574,
 -48300,
 1129450796,
 917573,
 -48299,
 1129560315,
 917572,
 -48298,
 1129610096,
 917571,
 -48297,
 1129659840,
 917570,
 -1,
 1129710387,
 917569,
 1129923422,
 1126239532,
 -1,
 1129988957,
 1129881716,
 -1,
 -48293,
 1129943865,
 917595,
 -48292,
 1129980319,
 917544,
 -1,
 1130061618,
 917627,
 -1,
 1129933955,
 917564,
 -1,
 1129867963,
 917599,
 1130382191,
 1126217979,
 -1,
 1130447726,
 1130355879,
 -1,
 1130513252,
 1130423690,
 -1,
 -48285,
 1130465521,
 917554,
 -1,
 1130530835,
 917555,
 1130709863,
 1130473358,
 -1,
 -48282,
 1130677611,
 917558,
 -1,
 1130707582,
 917559,
 1130906474,
 1130645575,
 -1,
 -48279,
 1130861042,
 917556,
 -1,
 1130899458,
 917557,
 -48277,
 1130826083,
 917552,
 -48276,
 1131065656,
 917553,
 -48275,
 1131098678,
 917561,
 -1,
 1131200714,
 917560,
 -1,
 1130422764,
 917540,
 1131430773,
 1130345735,
 -1,
 1131496308,
 1131406234,
 -1,
 -48270,
 1131451193,
 917597,
 -48269,
 1131487647,
 917545,
 -1,
 1131568946,
 917629,
 -1,
 1131468305,
 917596,
 1131823996,
 1131379568,
 -1,
 1131889531,
 1131781368,
 -1,
 1131955066,
 1131810732,
 -1,
 -48263,
 1131910659,
 917568,
 -1,
 1131938611,
 917548,
 -1,
 1131874773,
 917562,
 -1,
 1131826143,
 917598,
 1132282752,
 1131784078,
 -1,
 -48258,
 1132207426,
 917536,
 -48257,
 1132295121,
 917551,
 -1,
 1132382672,
 917563,
 1132544900,
 1132200755,
 -1,
 -48254,
 1132484703,
 917546,
 -48253,
 1132564844,
 917543,
 -1,
 1132593520,
 917542,
 1132807047,
 1132478154,
 -1,
 -48250,
 1132763908,
 917538,
 -1,
 1132805197,
 917567,
 1133003658,
 1132779936,
 -1,
 -48247,
 1132967857,
 917547,
 -1,
 1133029005,
 917541,
 1133200269,
 1132965483,
 -1,
 -48244,
 1133166590,
 917566,
 -1,
 1133196618,
 917600,
 1133396880,
 1133120812,
 -1,
 -48241,
 1133316107,
 917537,
 -1,
 1133431083,
 917565,
 -48239,
 1133372600,
 917628,
 -48238,
 1133515834,
 917630,
 -48237,
 1133604352,
 917539,
 -48236,
 1133655035,
 917549,
 -1,
 1133708823,
 917550,
 1133921197,
 1126144249,
 -1,
 1133986729,
 1133847909,
 -1,
 1134052250,
 1133927720,
 -1,
 -48231,
 1134014099,
 5893,
 -1,
 1134035763,
 5896,
 -48229,
 1133980708,
 5900,
 -48228,
 1134201066,
 5903,
 -48227,
 1134245729,
 5890,
 -48226,
 1134322146,
 5894,
 -48225,
 1134384812,
 5904,
 -48224,
 1134447992,
 5897,
 -48223,
 1134497702,
 5899,
 -48222,
 1134559998,
 5902,
 -48221,
 1134682063,
 5891,
 -48220,
 1134696605,
 5889,
 -48219,
 1134803379,
 5905,
 -48218,
 1134866067,
 5892,
 -48217,
 1134921744,
 5895,
 -48216,
 1135006209,
 5898,
 -1,
 1135018803,
 5888,
 1135231916,
 1133939765,
 -1,
 -48213,
 1135163233,
 5907,
 -1,
 1135220893,
 5906,
 -1,
 1135178286,
 5908,
 1135542271,
 1133872645,
 -1,
 1135559616,
 1135420773,
 -1,
 1135625138,
 1135500584,
 -1,
 -48207,
 1135586963,
 5989,
 -1,
 1135608627,
 5992,
 -48205,
 1135553572,
 5996,
 -48204,
 1135773930,
 5999,
 -48203,
 1135818593,
 5986,
 -48202,
 1135895010,
 5990,
 -48201,
 1135957676,
 6000,
 -48200,
 1136020856,
 5993,
 -48199,
 1136070566,
 5995,
 -48198,
 1136132862,
 5998,
 -48197,
 1136254927,
 5987,
 -48196,
 1136269469,
 5985,
 -48195,
 1136373395,
 5988,
 -48194,
 1136429072,
 5991,
 -48193,
 1136513537,
 5994,
 -1,
 1136526131,
 5984,
 1136787455,
 1135512629,
 -1,
 -48190,
 1136670561,
 6003,
 -1,
 1136728221,
 6002,
 1136935968,
 1126055538,
 -1,
 1137001455,
 1136862565,
 -1,
 1137066956,
 1136942376,
 -1,
 1137132489,
 1137007912,
 -1,
 -48184,
 1137056541,
 2985,
 -1,
 1137115955,
 2979,
 -48182,
 1137060900,
 2974,
 -48181,
 1137290899,
 2969,
 -1,
 1137312563,
 2984,
 1137525712,
 1136984883,
 2949,
 -48178,
 1137456993,
 2964,
 -48177,
 1137514653,
 2960,
 -1,
 1137574707,
 2950,
 1137787860,
 1137485710,
 -1,
 -48174,
 1137727148,
 2999,
 -48173,
 1137818035,
 2998,
 -1,
 1137836851,
 3000,
 1138050009,
 1137757839,
 -1,
 1138115544,
 1138019983,
 -1,
 -48169,
 1138033406,
 2996,
 -1,
 1138098995,
 2995,
 -1,
 1138033459,
 2994,
 1138377691,
 1137981281,
 2953,
 -1,
 1138308961,
 2954,
 1138508766,
 1138353546,
 -1,
 -48163,
 1138450914,
 2975,
 -1,
 1138492211,
 2980,
 1138705377,
 1138472199,
 -1,
 -48160,
 1138641321,
 2993,
 -1,
 1138688819,
 2992,
 1138901987,
 1138662648,
 2962,
 -1,
 1138859256,
 2963,
 1139033061,
 1138825373,
 2951,
 -1,
 1138956445,
 2952,
 1139164135,
 1138953516,
 2958,
 -1,
 1139084588,
 2959,
 -48152,
 1139092516,
 2991,
 -48151,
 1139244275,
 2997,
 -48150,
 1139297656,
 2986,
 -48149,
 1139347366,
 2990,
 -48148,
 1139466191,
 2965,
 -48147,
 1139528182,
 2972,
 -48146,
 1139587507,
 3001,
 -1,
 1139637328,
 2970,
 1139819520,
 1136965883,
 -1,
 1139885054,
 1139793063,
 -1,
 1139950580,
 1139860874,
 -1,
 -48141,
 1139902705,
 3048,
 -1,
 1139968019,
 3049,
 1140147191,
 1139910542,
 -1,
 -48138,
 1140114795,
 3052,
 -1,
 1140144766,
 3053,
 1140343802,
 1140082759,
 -1,
 -48135,
 1140298226,
 3050,
 -1,
 1140336642,
 3051,
 -48133,
 1140263267,
 3046,
 -48132,
 1140502840,
 3047,
 -48131,
 1140535862,
 3055,
 -1,
 1140637898,
 3054,
 -48129,
 1139835966,
 3062,
 -1,
 1140746712,
 3059,
 1140933645,
 1139772469,
 -1,
 1140999173,
 1140851507,
 -1,
 -48125,
 1140930401,
 3020,
 -48124,
 1140988061,
 3016,
 -1,
 1141048115,
 3006,
 1141261319,
 1140930401,
 3009,
 -1,
 1141192545,
 3010,
 1141392393,
 1141218552,
 3018,
 -1,
 1141349624,
 3019,
 1141523467,
 1141315741,
 3007,
 -1,
 1141446813,
 3008,
 1141702655,
 1141443884,
 3014,
 -1,
 1141574956,
 3015,
 1141785619,
 1140871876,
 -1,
 1141851153,
 1141750918,
 -1,
 -48112,
 1141801822,
 3058,
 -1,
 1141850179,
 3057,
 -48110,
 1141800753,
 3056,
 -1,
 1142011273,
 3066,
 1142178840,
 1141712133,
 -1,
 1142244375,
 1142127872,
 -1,
 -48106,
 1142209706,
 2947,
 -1,
 1142242801,
 3021,
 -1,
 1142177992,
 2946,
 1142506523,
 1142096691,
 -1,
 -48102,
 1142430014,
 3031,
 -1,
 1142547548,
 3064,
 -48100,
 1142442943,
 3061,
 -48099,
 1142662462,
 3065,
 -48098,
 1142695579,
 3024,
 -48097,
 1142807660,
 3060,
 -1,
 1142846141,
 3063,
 -48095,
 1136904400,
 9801,
 -1,
 1142985454,
 9991,
 1143162264,
 1105991837,
 -1,
 1143227714,
 1143114895,
 -1,
 1143293070,
 1143187342,
 -1,
 1143358561,
 1143249256,
 -1,
 1143424047,
 1143334282,
 -1,
 1143489578,
 1143399818,
 -1,
 -48087,
 1143454131,
 3995,
 -1,
 1143472947,
 3994,
 1143686189,
 1143449486,
 -1,
 -48084,
 1143650739,
 4010,
 -1,
 1143669555,
 4009,
 -48082,
 1143650739,
 4000,
 -1,
 1143800627,
 3999,
 1144013880,
 1143388411,
 -1,
 1144079411,
 1143963595,
 -1,
 -48078,
 1144043955,
 4012,
 -1,
 1144062771,
 4011,
 1144276022,
 1144043771,
 -1,
 -48075,
 1144240563,
 3997,
 -1,
 1144259379,
 3996,
 -48073,
 1144240563,
 4002,
 -1,
 1144390451,
 4001,
 1144603709,
 1143954728,
 -1,
 -48070,
 1144532004,
 3993,
 -48069,
 1144593181,
 3998,
 -48068,
 1144696467,
 3988,
 -1,
 1144718131,
 4003,
 1144931393,
 1144563598,
 -1,
 -48065,
 1144870572,
 4021,
 -48064,
 1144961459,
 4020,
 -1,
 1144980275,
 4022,
 1145193541,
 1144885559,
 -1,
 -48061,
 1145141072,
 4025,
 -48060,
 1145223603,
 3985,
 -1,
 1145242419,
 3984,
 1145455689,
 1145140772,
 -1,
 -48057,
 1145383972,
 4027,
 -48056,
 1145473258,
 4026,
 -1,
 1145522601,
 4028,
 1145717836,
 1145405387,
 -1,
 -48053,
 1145682355,
 4014,
 -1,
 1145701171,
 4015,
 1145914447,
 1145690528,
 -1,
 -48050,
 1145878963,
 4005,
 -1,
 1145897779,
 4004,
 1146111058,
 1145865933,
 -1,
 -48047,
 1146075571,
 3987,
 -1,
 1146094387,
 3986,
 1146307669,
 1146059632,
 -1,
 -48044,
 1146272179,
 3990,
 -1,
 1146290995,
 3989,
 1146504280,
 1146240448,
 -1,
 -48041,
 1146468787,
 4007,
 -1,
 1146487603,
 4006,
 -48039,
 1146432548,
 4017,
 -48038,
 1146652906,
 4013,
 -48037,
 1146702249,
 4018,
 -48036,
 1146752934,
 4008,
 -48035,
 1146815230,
 4019,
 -48034,
 1146933750,
 3991,
 -48033,
 1146993075,
 4023,
 -48032,
 1147011891,
 4024,
 -1,
 1147098114,
 4016,
 1147290752,
 1143314938,
 -1,
 1147356274,
 1147254023,
 -1,
 1147421808,
 1147313760,
 -1,
 1147487338,
 1147363799,
 -1,
 1147552873,
 1147438797,
 -1,
 -48025,
 1147502358,
 4047,
 -48024,
 1147537343,
 3870,
 -1,
 1147614894,
 3869,
 -1,
 1147500725,
 4046,
 1147928575,
 1147449752,
 -1,
 1147946095,
 1147832013,
 -1,
 -48019,
 1147895574,
 3868,
 -48018,
 1147930559,
 3867,
 -1,
 1148008110,
 3866,
 -1,
 1147871098,
 3871,
 -48015,
 1147368559,
 3967,
 -1,
 1148203403,
 3966,
 1148404853,
 1147284516,
 -1,
 -48012,
 1148323193,
 3902,
 -1,
 1148398353,
 3975,
 1148601464,
 1148330580,
 -1,
 -48009,
 1148567056,
 3977,
 -1,
 1148631760,
 3903,
 1148798075,
 1148519163,
 -1,
 -48006,
 1148742448,
 3974,
 -1,
 1148799067,
 3976,
 1148994686,
 1148737538,
 -1,
 -48003,
 1148911950,
 3979,
 -1,
 1148993943,
 3978,
 -48001,
 1148939730,
 3971,
 -1,
 1149166343,
 3970,
 1149370367,
 1147224697,
 -1,
 1149387917,
 1149271048,
 -1,
 1149453447,
 1149316004,
 4041,
 1149566975,
 1149391913,
 -1,
 -47995,
 1149439324,
 4042,
 -47994,
 1149552108,
 4043,
 -1,
 1149607741,
 4044,
 1149781129,
 1149389593,
 4037,
 -1,
 1149707977,
 4039,
 1149912204,
 1149753760,
 -1,
 -47989,
 1149860713,
 4040,
 -1,
 1149932497,
 4038,
 -1,
 1149881604,
 4036,
 -1,
 1149310080,
 3840,
 1150239950,
 1143262863,
 -1,
 1150305483,
 1150198096,
 -1,
 1150370969,
 1150281098,
 -1,
 1150436500,
 1150346634,
 -1,
 -47981,
 1150400947,
 3915,
 -1,
 1150419763,
 3914,
 1150633111,
 1150396302,
 -1,
 -47978,
 1150597555,
 3930,
 -1,
 1150616371,
 3929,
 -47976,
 1150597555,
 3920,
 -1,
 1150747443,
 3919,
 1150960802,
 1150335227,
 -1,
 1151026333,
 1150910411,
 -1,
 -47972,
 1150990771,
 3932,
 -1,
 1151009587,
 3931,
 1151222944,
 1150990587,
 -1,
 -47969,
 1151187379,
 3917,
 -1,
 1151206195,
 3916,
 -47967,
 1151187379,
 3922,
 -1,
 1151337267,
 3921,
 1151550631,
 1150901544,
 -1,
 -47964,
 1151478820,
 3913,
 -47963,
 1151539997,
 3918,
 -47962,
 1151643283,
 3908,
 -1,
 1151664947,
 3923,
 1151878316,
 1151504695,
 -1,
 -47959,
 1151825744,
 3945,
 -47958,
 1151918031,
 3947,
 -47957,
 1151973811,
 3905,
 -1,
 1151992627,
 3904,
 1152206000,
 1151838094,
 -1,
 -47954,
 1152145068,
 3941,
 -47953,
 1152235955,
 3940,
 -1,
 1152254771,
 3942,
 1152468147,
 1152155595,
 -1,
 -47950,
 1152432563,
 3934,
 -1,
 1152451379,
 3935,
 1152664758,
 1152431367,
 -1,
 -47947,
 1152600489,
 3948,
 -1,
 1152647987,
 3938,
 1152861369,
 1152637344,
 -1,
 -47944,
 1152825779,
 3925,
 -1,
 1152844595,
 3924,
 1153057980,
 1152812749,
 -1,
 -47941,
 1153022387,
 3907,
 -1,
 1153041203,
 3906,
 1153254591,
 1153006448,
 -1,
 -47938,
 1153218995,
 3910,
 -1,
 1153237811,
 3909,
 1153451202,
 1153187264,
 -1,
 -47935,
 1153415603,
 3927,
 -1,
 1153434419,
 3926,
 -47933,
 1153379364,
 3937,
 -47932,
 1153599722,
 3933,
 -47931,
 1153634214,
 3928,
 -47930,
 1153696510,
 3939,
 -47929,
 1153815030,
 3911,
 -47928,
 1153874355,
 3943,
 -47927,
 1153922812,
 3946,
 -47926,
 1153958707,
 3944,
 -1,
 1154044930,
 3936,
 1154285567,
 1150238759,
 -1,
 -47923,
 1154187614,
 3862,
 -1,
 1154254040,
 3861,
 1154434313,
 1150169815,
 -1,
 1154499802,
 1154385613,
 -1,
 1154565335,
 1154456387,
 -1,
 1154630870,
 1154520716,
 -1,
 1154696405,
 1154561734,
 -1,
 -47916,
 1154614925,
 3842,
 -1,
 1154688769,
 3843,
 -1,
 1154661607,
 3841,
 -1,
 1154567602,
 3860,
 1155071999,
 1154519435,
 -1,
 -47911,
 1154950808,
 3898,
 -1,
 1155031570,
 3899,
 1155220708,
 1154448240,
 -1,
 1155286240,
 1155183470,
 -1,
 1155351775,
 1155248597,
 -1,
 -47906,
 1155271610,
 3859,
 -1,
 1155366518,
 3894,
 -1,
 1155316007,
 3846,
 1155613923,
 1155245126,
 -1,
 -47902,
 1155568803,
 3845,
 -1,
 1155626240,
 4052,
 -1,
 1155542996,
 3896,
 1155876076,
 1155161384,
 -1,
 1155941609,
 1155801406,
 -1,
 1156007144,
 1155878322,
 4050,
 -1,
 1155948383,
 3856,
 -1,
 1155931555,
 3854,
 1156251647,
 1155893765,
 -1,
 -47893,
 1156149501,
 3895,
 -1,
 1156230681,
 3893,
 1156400371,
 1155808704,
 -1,
 1156465906,
 1156360078,
 -1,
 1156531441,
 1156419895,
 -1,
 -47888,
 1156470868,
 3849,
 -1,
 1156533848,
 4048,
 -1,
 1156504761,
 3892,
 -1,
 1156384762,
 3850,
 1156859128,
 1156367782,
 -1,
 1156924663,
 1156801135,
 -1,
 -47882,
 1156888678,
 3844,
 -1,
 1156924294,
 4051,
 -1,
 1156886358,
 3851,
 1157186811,
 1156800946,
 -1,
 -47878,
 1157145096,
 3855,
 -1,
 1157212920,
 3897,
 1157383422,
 1157146510,
 -1,
 -47875,
 1157335406,
 3853,
 -1,
 1157390202,
 3848,
 1157580033,
 1157346567,
 -1,
 -47872,
 1157550546,
 3857,
 -1,
 1157573698,
 3858,
 1157776644,
 1157539707,
 -1,
 -47869,
 1157703320,
 3900,
 -1,
 1157784082,
 3901,
 -47867,
 1157732729,
 3847,
 -47866,
 1157906599,
 3973,
 -47865,
 1158000632,
 4049,
 -47864,
 1158040408,
 3972,
 -1,
 1158103885,
 3852,
 1158300965,
 1154408817,
 -1,
 1158366488,
 1158266442,
 -1,
 1158432014,
 1158342026,
 -1,
 -47859,
 1158383857,
 3883,
 -1,
 1158449171,
 3884,
 1158628625,
 1158391694,
 -1,
 -47856,
 1158595947,
 3887,
 -1,
 1158625918,
 3888,
 1158825236,
 1158563911,
 -1,
 -47853,
 1158779378,
 3885,
 -1,
 1158817794,
 3886,
 -47851,
 1158744419,
 3891,
 -47850,
 1158983992,
 3882,
 -47849,
 1159017014,
 3890,
 -1,
 1159119050,
 3889,
 1159283995,
 1158342026,
 -1,
 -47846,
 1159235825,
 3874,
 -1,
 1159301139,
 3875,
 1159480606,
 1159243662,
 -1,
 -47843,
 1159447915,
 3878,
 -1,
 1159477886,
 3879,
 1159677217,
 1159415879,
 -1,
 -47840,
 1159631346,
 3876,
 -1,
 1159669762,
 3877,
 -47838,
 1159596387,
 3872,
 -47837,
 1159835960,
 3873,
 -47836,
 1159868982,
 3881,
 -1,
 1159971018,
 3880,
 1160135990,
 1158253621,
 -1,
 1160201515,
 1160053476,
 -1,
 1160267049,
 1160164615,
 3958,
 -1,
 1160230151,
 3959,
 1160445951,
 1160236687,
 3960,
 -1,
 1160367759,
 3961,
 1160529197,
 1160132449,
 3956,
 -1,
 1160460129,
 3957,
 1160660271,
 1160501446,
 3968,
 -1,
 1160583325,
 3969,
 1160791345,
 1160617208,
 3964,
 -1,
 1160748280,
 3965,
 1160922419,
 1160714397,
 3954,
 -1,
 1160845469,
 3955,
 1161053493,
 1160842540,
 3962,
 -1,
 1160973612,
 3963,
 -1,
 1160995301,
 3953,
 1161250107,
 1160067936,
 -1,
 -47816,
 1161186744,
 4035,
 -47815,
 1161271695,
 4033,
 -47814,
 1161306411,
 4032,
 -1,
 1161380146,
 4034,
 1161577792,
 1161204330,
 -1,
 1161643327,
 1161537422,
 -1,
 -47810,
 1161585590,
 3863,
 -1,
 1161633346,
 3865,
 -1,
 1161569464,
 3864,
 1161953279,
 1161539900,
 4030,
 -1,
 1161879849,
 4031,
 1162036609,
 1143180165,
 -1,
 1162102144,
 1161962853,
 -1,
 1162167662,
 1162035833,
 -1,
 1162233195,
 1162085171,
 11568,
 1162298698,
 1162197243,
 11575,
 1162364233,
 1162262779,
 11577,
 -1,
 1162331026,
 11578,
 -1,
 1162331026,
 11576,
 1162560845,
 1162248139,
 11619,
 -47796,
 1162510283,
 11621,
 -1,
 1162593170,
 11594,
 1162757456,
 1162536330,
 11612,
 -47793,
 1162732938,
 11615,
 -1,
 1162789778,
 11613,
 1162954067,
 1162717070,
 11609,
 -47790,
 1162913678,
 11610,
 -1,
 1162986386,
 11611,
 1163150678,
 1162907959,
 11581,
 1163263999,
 1163117458,
 11589,
 -1,
 1163182994,
 11583,
 1163347289,
 1163101901,
 11571,
 1163460607,
 1163314066,
 11606,
 -1,
 1163379602,
 11572,
 1163543899,
 1163310343,
 11604,
 -1,
 1163506951,
 11605,
 1163674973,
 1163510674,
 11584,
 -1,
 1163641746,
 11587,
 1163806047,
 1163607488,
 11569,
 -1,
 1163772818,
 11570,
 -47776,
 1163739769,
 11618,
 -47775,
 1163899717,
 11617,
 -47774,
 1163949256,
 11616,
 -47773,
 1163996477,
 11591,
 -47772,
 1164106144,
 11602,
 -47771,
 1164139816,
 11599,
 -47770,
 1164190292,
 11598,
 -47769,
 1164299919,
 11597,
 -47768,
 1164333772,
 11574,
 -47767,
 1164396615,
 11580,
 -47766,
 1164475463,
 11614,
 -1,
 1164510003,
 11588,
 -47764,
 1162164065,
 11603,
 -47763,
 1164646557,
 11593,
 -1,
 1164744164,
 11579,
 1164920186,
 1162143114,
 -1,
 1164985721,
 1164850025,
 -1,
 1165051250,
 1164939575,
 11582,
 -1,
 1165018002,
 11590,
 1165182325,
 1165002445,
 -1,
 -47756,
 1165122856,
 11600,
 -1,
 1165214610,
 11607,
 -47754,
 1165143832,
 11596,
 -47753,
 1165307197,
 11592,
 -47752,
 1165368102,
 11601,
 -1,
 1165476754,
 11586,
 -1,
 1164947565,
 11620,
 1165706621,
 1164851975,
 -1,
 -47748,
 1165644492,
 11573,
 -1,
 1165738898,
 11585,
 1165950975,
 1165624115,
 -1,
 -47745,
 1165876304,
 11608,
 -1,
 1165898660,
 11595,
 -1,
 1162061843,
 11631,
 1166165392,
 1161973332,
 126,
 1166278655,
 1166103593,
 -1,
 1166296459,
 1166180078,
 8764,
 1166409727,
 1166234665,
 -1,
 1166427528,
 1166325159,
 -1,
 -47737,
 1166358357,
 10859,
 -1,
 1166466268,
 10858,
 1166671871,
 1166402723,
 -1,
 -47734,
 1166597247,
 10610,
 -1,
 1166619157,
 11081,
 1166868479,
 1166259623,
 -1,
 1166886287,
 1166780271,
 -1,
 -47730,
 1166850166,
 11807,
 -1,
 1166894309,
 11806,
 -1,
 1166822177,
 11803,
 1167148434,
 1166089001,
 10750,
 -1,
 1167083217,
 68410,
 1167279509,
 1167091657,
 -1,
 -47724,
 1167236837,
 10709,
 -1,
 1167295751,
 10708,
 -47722,
 1167232490,
 8266,
 -47721,
 1167431994,
 10053,
 -1,
 1167478793,
 10717,
 1167672985,
 1143082284,
 -1,
 1167738397,
 1167642255,
 -1,
 1167803929,
 1167673417,
 -1,
 1167869411,
 1167721208,
 -1,
 1167934946,
 1167839893,
 -1,
 1168000420,
 1167881416,
 -1,
 1168065955,
 1167940915,
 -1,
 1168131489,
 1168028935,
 3083,
 -1,
 1168094471,
 3168,
 1168310271,
 1168101007,
 3084,
 -1,
 1168232079,
 3169,
 -1,
 1167983411,
 3125,
 1168459179,
 1167975818,
 -1,
 1168524712,
 1168434570,
 -1,
 -47705,
 1168488883,
 3104,
 -1,
 1168507699,
 3103,
 -47703,
 1168463532,
 3160,
 -47702,
 1168685491,
 3109,
 -1,
 1168704307,
 3108,
 1168917938,
 1168423163,
 -1,
 1168983471,
 1168881915,
 -1,
 -47698,
 1168947635,
 3106,
 -1,
 1168966451,
 3105,
 -47696,
 1168944937,
 3161,
 -47695,
 1169144243,
 3111,
 -1,
 1169163059,
 3110,
 1169376695,
 1168858408,
 -1,
 -47692,
 1169304612,
 3102,
 -47691,
 1169365789,
 3107,
 -47690,
 1169469075,
 3097,
 -1,
 1169490739,
 3112,
 1169704379,
 1169294131,
 3077,
 -47687,
 1169635169,
 3092,
 -47686,
 1169692829,
 3088,
 -1,
 1169752883,
 3078,
 1169966527,
 1169663886,
 -1,
 -47683,
 1169905324,
 3127,
 -47682,
 1169996211,
 3126,
 -1,
 1170015027,
 3128,
 1170228673,
 1169897313,
 3081,
 -1,
 1170159457,
 3082,
 1170359748,
 1170191623,
 -1,
 -47677,
 1170295209,
 3121,
 -1,
 1170342707,
 3120,
 1170556359,
 1170332064,
 -1,
 -47674,
 1170520499,
 3115,
 -1,
 1170539315,
 3114,
 1170752969,
 1170513144,
 3090,
 -1,
 1170709752,
 3091,
 1170884044,
 1170722447,
 -1,
 -47669,
 1170801406,
 3123,
 -1,
 1170866995,
 3122,
 1171080655,
 1170837815,
 -1,
 -47666,
 1171044787,
 3094,
 -1,
 1171063603,
 3093,
 1171277266,
 1171018444,
 -1,
 -47663,
 1171241395,
 3101,
 -1,
 1171260211,
 3100,
 1171473876,
 1171200157,
 3079,
 -1,
 1171396765,
 3080,
 1171604951,
 1171424973,
 -1,
 -47658,
 1171569075,
 3096,
 -1,
 1171587891,
 3095,
 1171801561,
 1171524908,
 3086,
 -1,
 1171721516,
 3087,
 1171932636,
 1171749744,
 -1,
 -47653,
 1171896755,
 3099,
 -1,
 1171915571,
 3098,
 1172129247,
 1171865024,
 -1,
 -47650,
 1172093363,
 3117,
 -1,
 1172112179,
 3116,
 -47648,
 1172057124,
 3119,
 -47647,
 1172246438,
 3118,
 -1,
 1172355507,
 3129,
 -1,
 1167881861,
 3157,
 1172588021,
 1167821877,
 -1,
 1172653545,
 1172505316,
 -1,
 1172719079,
 1172616455,
 3139,
 -1,
 1172681991,
 3140,
 1172897791,
 1172688527,
 3170,
 -1,
 1172819599,
 3171,
 1172981229,
 1172570931,
 -1,
 -47637,
 1172911969,
 3148,
 -47636,
 1172969629,
 3144,
 -1,
 1173029683,
 3134,
 1173243375,
 1172911969,
 3137,
 -1,
 1173174113,
 3138,
 1173374449,
 1173200120,
 3146,
 -1,
 1173331192,
 3147,
 1173505523,
 1173297309,
 3135,
 -1,
 1173428381,
 3136,
 1173684223,
 1173425452,
 3142,
 -1,
 1173556524,
 3143,
 1173767683,
 1172562289,
 -1,
 1173833209,
 1173742986,
 -1,
 -47624,
 1173784817,
 3176,
 -1,
 1173850131,
 3177,
 1174029820,
 1173792654,
 -1,
 -47621,
 1173996907,
 3180,
 -1,
 1174026878,
 3181,
 1174226431,
 1173964871,
 -1,
 -47618,
 1174180338,
 3178,
 -1,
 1174218754,
 3179,
 -47616,
 1174145379,
 3174,
 -47615,
 1174384952,
 3175,
 -47614,
 1174417974,
 3183,
 -1,
 1174520010,
 3182,
 1174685199,
 1173743040,
 -1,
 1174750731,
 1174660490,
 -1,
 1174816264,
 1174725071,
 -1,
 -47609,
 1174779245,
 3194,
 -1,
 1174856407,
 3197,
 1175060479,
 1174791891,
 -1,
 -47606,
 1174975853,
 3195,
 -1,
 1175053015,
 3198,
 1175209486,
 1174690214,
 -1,
 -47603,
 1175172461,
 3193,
 -1,
 1175249623,
 3196,
 -1,
 1175170670,
 3192,
 1175471640,
 1174611205,
 -1,
 1175537171,
 1175420160,
 -1,
 -47598,
 1175501994,
 3075,
 -1,
 1175535089,
 3149,
 1175733782,
 1175454515,
 -1,
 -47595,
 1175681844,
 3133,
 -1,
 1175734506,
 3074,
 -47593,
 1175659157,
 3199,
 -1,
 1175869598,
 3073,
 -1,
 1175441990,
 3158,
 1176174591,
 1167753684,
 -1,
 -47589,
 1176089993,
 8481,
 -47588,
 1176144781,
 8981,
 -1,
 1176230896,
 9990,
 1176389267,
 1167707676,
 -1,
 1176454704,
 1176337264,
 -1,
 1176520233,
 1176411384,
 -1,
 1176585766,
 1176460584,
 -1,
 1176651301,
 1176561034,
 -1,
 -47581,
 1176587132,
 119563,
 -47580,
 1176666012,
 119582,
 -1,
 1176709307,
 119573,
 -1,
 1176581997,
 119608,
 1177026559,
 1176505333,
 -1,
 -47576,
 1176915263,
 119634,
 -1,
 1176989697,
 119630,
 1177175598,
 1176439265,
 -1,
 1177241133,
 1177095468,
 -1,
 -47572,
 1177191182,
 119590,
 -1,
 1177237638,
 119613,
 -1,
 1177165719,
 119631,
 -47569,
 1177137883,
 119585,
 -1,
 1177434156,
 119558,
 1177634366,
 1176418555,
 -1,
 1177699895,
 1177557149,
 -1,
 1177765429,
 1177625172,
 -1,
 -47564,
 1177695817,
 119625,
 -1,
 1177762451,
 119612,
 -47562,
 1177735368,
 119568,
 -1,
 1177904105,
 119636,
 1178093115,
 1177619756,
 -1,
 -47559,
 1178065199,
 119623,
 -47558,
 1178107537,
 119567,
 -1,
 1178149296,
 119586,
 -47556,
 1178017126,
 119584,
 -47555,
 1178279658,
 119619,
 -1,
 1178389396,
 119624,
 1178551879,
 1177554220,
 -1,
 1178617411,
 1178492200,
 -1,
 -47551,
 1178575845,
 119603,
 -47550,
 1178643346,
 119583,
 -1,
 1178700308,
 119600,
 -47548,
 1178535728,
 119626,
 -47547,
 1178832078,
 119610,
 -47546,
 1178868822,
 119618,
 -1,
 1178953906,
 119580,
 1179141713,
 1178514695,
 -1,
 1179207248,
 1179061548,
 -1,
 1179272782,
 1179166606,
 -1,
 1179338317,
 1179195549,
 -1,
 -47540,
 1179268913,
 119579,
 -1,
 1179334260,
 119596,
 -1,
 1179261805,
 119598,
 -47537,
 1179207419,
 119578,
 -1,
 1179527317,
 119572,
 -1,
 1179181694,
 119605,
 1179797082,
 1179076679,
 -1,
 1179862613,
 1179727721,
 -1,
 -47532,
 1179812622,
 119595,
 -1,
 1179880299,
 119559,
 1180059224,
 1179819256,
 -1,
 -47529,
 1180034488,
 119638,
 -1,
 1180086615,
 119576,
 -47527,
 1180033481,
 119606,
 -1,
 1180185125,
 119632,
 1180386914,
 1179756430,
 -1,
 1180452448,
 1180362122,
 -1,
 1180517983,
 1180409080,
 -1,
 -47522,
 1180466429,
 119601,
 -1,
 1180536280,
 119628,
 -1,
 1180451830,
 119593,
 -47519,
 1180379316,
 119621,
 -1,
 1180733556,
 119627,
 1180911208,
 1180337869,
 -1,
 1180976741,
 1180849562,
 119592,
 -1,
 1180909806,
 119615,
 -47514,
 1180922124,
 119614,
 -47513,
 1181041796,
 119602,
 -1,
 1181116948,
 119599,
 1181304430,
 1180883360,
 -1,
 1181369964,
 1181221683,
 -1,
 -47509,
 1181314443,
 119604,
 -1,
 1181392630,
 119588,
 -47507,
 1181314862,
 119594,
 -1,
 1181493838,
 119571,
 1181697651,
 1181221683,
 -1,
 -47504,
 1181658241,
 119564,
 -47503,
 1181702742,
 119633,
 -47502,
 1181801678,
 119577,
 -1,
 1181845093,
 119617,
 1182025335,
 1181622868,
 -1,
 -47499,
 1181984972,
 119560,
 -47498,
 1182035814,
 119609,
 -1,
 1182103750,
 119616,
 1182287484,
 1181994639,
 -1,
 1182353019,
 1182204723,
 -1,
 -47494,
 1182294776,
 119597,
 -1,
 1182378447,
 119637,
 -1,
 1182300632,
 119589,
 1182615168,
 1182219712,
 -1,
 -47490,
 1182583347,
 119566,
 -47489,
 1182625657,
 119587,
 -1,
 1182699482,
 119561,
 1182877315,
 1182566634,
 -1,
 -47486,
 1182832863,
 119620,
 -1,
 1182914317,
 119575,
 1183073926,
 1182833912,
 -1,
 -47483,
 1183009395,
 119565,
 -1,
 1183098076,
 119635,
 1183270537,
 1183027511,
 -1,
 -47480,
 1183187529,
 119591,
 -1,
 1183279975,
 119562,
 1183467148,
 1183237542,
 -1,
 -47477,
 1183394001,
 119622,
 -1,
 1183452870,
 119570,
 1183663759,
 1183433618,
 -1,
 -47474,
 1183585562,
 119574,
 -1,
 1183649921,
 119629,
 -47472,
 1183591402,
 119569,
 -47471,
 1183799691,
 119607,
 -47470,
 1183842896,
 119611,
 -1,
 1183938076,
 119581,
 1184122518,
 1176329512,
 -1,
 -47467,
 1184097674,
 9978,
 -1,
 1184119030,
 8376,
 1184366591,
 1184091125,
 -1,
 -47464,
 1184238669,
 10043,
 -1,
 1184324373,
 10170,
 1184515963,
 1167639442,
 -1,
 1184581471,
 1184432947,
 -1,
 1184646939,
 1184548200,
 -1,
 1184712461,
 1184594800,
 -1,
 1184777996,
 1184636682,
 -1,
 1184843445,
 1184737166,
 -1,
 1184908975,
 1184801753,
 -1,
 1184974503,
 1184826163,
 3632,
 1185040036,
 1184895274,
 -1,
 -47453,
 1185012043,
 3651,
 -1,
 1185035659,
 3652,
 -47451,
 1184965204,
 3635,
 -47450,
 1185156396,
 3649,
 -1,
 1185219379,
 3634,
 1185433259,
 1184905057,
 3640,
 1185498794,
 1185353004,
 3638,
 -1,
 1185418540,
 3639,
 -1,
 1185429345,
 3641,
 1185695405,
 1185355933,
 3636,
 -1,
 1185618077,
 3637,
 -47442,
 1185651960,
 3650,
 -1,
 1185746220,
 3648,
 1186004991,
 1184835013,
 -1,
 1186023092,
 1185916814,
 -1,
 -47438,
 1185968332,
 3626,
 -47437,
 1186045176,
 3595,
 -1,
 1186127025,
 3624,
 -1,
 1185996523,
 3625,
 1186350788,
 1184818570,
 -1,
 1186416321,
 1186317202,
 -1,
 1186481856,
 1186342341,
 -1,
 1186547390,
 1186439441,
 -1,
 1186612924,
 1186464563,
 -1,
 -47429,
 1186553128,
 3600,
 -1,
 1186628728,
 3607,
 -47427,
 1186541578,
 3606,
 -1,
 1186771252,
 3608,
 -47425,
 1186474761,
 3602,
 -1,
 1186877879,
 3601,
 -1,
 1186412664,
 3660,
 1187184639,
 1186342341,
 -1,
 -47421,
 1187090445,
 3605,
 -1,
 1187148352,
 3599,
 1187333840,
 1186275924,
 -1,
 1187399375,
 1187275258,
 -1,
 1187464909,
 1187337257,
 -1,
 1187530442,
 1187440010,
 -1,
 -47415,
 1187465650,
 3658,
 -1,
 1187559838,
 3657,
 -47413,
 1187478079,
 3633,
 -47412,
 1187681726,
 3656,
 -1,
 1187738278,
 3659,
 -47410,
 1187436855,
 3654,
 -1,
 1187843528,
 3655,
 -1,
 1187373193,
 3617,
 1188120283,
 1187287351,
 -1,
 1188185818,
 1188084126,
 -1,
 1188251353,
 1188123689,
 -1,
 1188316888,
 1188224984,
 -1,
 -47403,
 1188283594,
 3588,
 -47402,
 1188354365,
 3587,
 -47401,
 1188374168,
 3589,
 -1,
 1188454906,
 3586,
 -1,
 1188275288,
 3590,
 -1,
 1188194392,
 3675,
 -1,
 1188160625,
 3585,
 1188841189,
 1188092320,
 -1,
 1188906723,
 1188807570,
 -1,
 1188972258,
 1188832709,
 -1,
 1189037793,
 1188901453,
 -1,
 -47392,
 1188966410,
 3612,
 -1,
 1189044748,
 3614,
 -1,
 1188993868,
 3616,
 -1,
 1188906399,
 3642,
 -47388,
 1188874907,
 3611,
 -1,
 1189336546,
 3631,
 1189496555,
 1188781352,
 -1,
 1189562089,
 1189426653,
 -1,
 -47384,
 1189492577,
 3609,
 -1,
 1189582261,
 3603,
 -47382,
 1189503080,
 3661,
 -1,
 1189690987,
 3591,
 1189889777,
 1189465743,
 -1,
 1189955311,
 1189815749,
 -1,
 -47378,
 1189924375,
 3621,
 -1,
 1189941519,
 3628,
 -47376,
 1189885793,
 3622,
 -1,
 1190074843,
 3653,
 1190282998,
 1189825728,
 -1,
 1190348532,
 1190224396,
 3592,
 -1,
 1190299341,
 3594,
 -47371,
 1190274753,
 3596,
 -1,
 1190414248,
 3593,
 1190610683,
 1190216313,
 -1,
 1190676218,
 1190540828,
 -1,
 -47367,
 1190610856,
 3597,
 -1,
 1190683136,
 3618,
 -1,
 1190607086,
 3662,
 1190938367,
 1190568227,
 -1,
 1191003902,
 1190898068,
 3613,
 -1,
 1190944040,
 3615,
 -1,
 1190964953,
 3663,
 1191200514,
 1190900999,
 -1,
 -47359,
 1191130977,
 3620,
 -1,
 1191205843,
 3619,
 1191397125,
 1191149737,
 -1,
 -47356,
 1191353854,
 3630,
 -1,
 1191404922,
 3627,
 1191593736,
 1191317690,
 -1,
 -47353,
 1191520061,
 3604,
 -1,
 1191630156,
 3598,
 -47351,
 1191569194,
 3623,
 -47350,
 1191765899,
 3629,
 -47349,
 1191815113,
 3610,
 -1,
 1191858706,
 3674,
 -1,
 1184719528,
 3647,
 1192165375,
 1184686449,
 -1,
 1192183569,
 1192093066,
 -1,
 -47344,
 1192134897,
 3666,
 -1,
 1192200211,
 3667,
 1192380180,
 1192142734,
 -1,
 -47341,
 1192346987,
 3670,
 -1,
 1192376958,
 3671,
 1192576791,
 1192314951,
 -1,
 -47338,
 1192530418,
 3668,
 -1,
 1192568834,
 3669,
 -47336,
 1192495459,
 3664,
 -47335,
 1192735032,
 3665,
 -47334,
 1192768054,
 3673,
 -1,
 1192870090,
 3672,
 1193082879,
 1184609594,
 -1,
 1193101137,
 1192961381,
 -1,
 1193166627,
 1193076106,
 -1,
 1193232160,
 1193118058,
 1932,
 -1,
 1193149229,
 1947,
 -47327,
 1193185273,
 1944,
 -47326,
 1193319672,
 1952,
 -1,
 1193367145,
 1939,
 1193559849,
 1193125774,
 -1,
 1193625383,
 1193526162,
 -1,
 -47322,
 1193601070,
 1949,
 -1,
 1193629289,
 1921,
 -47320,
 1193601070,
 1936,
 -1,
 1193747661,
 1950,
 1193953070,
 1193508811,
 -1,
 1194018605,
 1193870131,
 -1,
 -47316,
 1193936314,
 1938,
 -1,
 1194001203,
 1948,
 -1,
 1193975032,
 1953,
 1194280754,
 1193903821,
 -1,
 -47312,
 1194246907,
 1935,
 -47311,
 1194314304,
 1955,
 -1,
 1194350775,
 1934,
 1194542903,
 1194244347,
 -1,
 1194608438,
 1194459955,
 -1,
 -47307,
 1194526138,
 1937,
 -1,
 1194593334,
 1951,
 -1,
 1194529122,
 1931,
 1194870586,
 1194482984,
 -1,
 -47303,
 1194805570,
 1922,
 -1,
 1194877413,
 1969,
 1195067197,
 1194839695,
 -1,
 -47300,
 1195016533,
 1925,
 -1,
 1195054091,
 1933,
 1195263808,
 1195020599,
 -1,
 -47297,
 1195215210,
 1946,
 -1,
 1195268279,
 1926,
 1195460419,
 1195230098,
 -1,
 -47294,
 1195411818,
 1945,
 -1,
 1195467237,
 1920,
 1195657030,
 1195377459,
 -1,
 -47291,
 1195617825,
 1927,
 -1,
 1195657074,
 1954,
 -47289,
 1195574733,
 1940,
 -47288,
 1195813734,
 1957,
 -47287,
 1195886958,
 1928,
 -47286,
 1195927169,
 1923,
 -47285,
 1196010949,
 1956,
 -47284,
 1196052000,
 1941,
 -47283,
 1196141381,
 1929,
 -47282,
 1196193831,
 1942,
 -47281,
 1196252575,
 1930,
 -47280,
 1196346365,
 1943,
 -1,
 1196364004,
 1924,
 1196574549,
 1193057528,
 -1,
 -47277,
 1196500286,
 1963,
 -47276,
 1196574125,
 1966,
 -1,
 1196648213,
 1967,
 1196836697,
 1196494124,
 -1,
 -47273,
 1196773144,
 1965,
 -47272,
 1196821125,
 1961,
 -1,
 1196893704,
 1964,
 1197098844,
 1196753715,
 -1,
 -47269,
 1197040399,
 1958,
 -1,
 1197102207,
 1959,
 -47267,
 1197039572,
 1962,
 -47266,
 1197212831,
 1968,
 -1,
 1197310313,
 1960,
 1197492080,
 1184519763,
 -1,
 1197557611,
 1197429801,
 -1,
 1197623142,
 1197526671,
 -1,
 1197688677,
 1197546664,
 -1,
 -47260,
 1197647465,
 9886,
 -1,
 1197692507,
 9887,
 -1,
 1197653249,
 11057,
 1197950825,
 1197586683,
 -1,
 -47256,
 1197880382,
 8278,
 -1,
 1197977348,
 10176,
 -47254,
 1197889089,
 8694,
 -1,
 1198076705,
 10870,
 1198325759,
 1197520008,
 -1,
 1198344047,
 1198229710,
 -1,
 -47250,
 1198301725,
 10146,
 -1,
 1198372794,
 10147,
 -1,
 1198296893,
 8196,
 1198606199,
 1197446643,
 -1,
 1198671734,
 1198525740,
 -1,
 1198737269,
 1198609449,
 -1,
 -47244,
 1198689227,
 8707,
 -1,
 1198771906,
 8708,
 -1,
 1198698865,
 8756,
 -1,
 1198641712,
 10727,
 1199064954,
 1198537063,
 -1,
 -47239,
 1199004333,
 9736,
 -1,
 1199062383,
 9928,
 -1,
 1199012102,
 8201,
 1199327143,
 1184478471,
 -1,
 1199392675,
 1199249565,
 -1,
 1199458192,
 1199363795,
 -1,
 1199523715,
 1199406624,
 -1,
 -47232,
 1199495715,
 10997,
 -47231,
 1199552699,
 8874,
 -47230,
 1199618307,
 10624,
 -1,
 1199644339,
 10996,
 1199851398,
 1199495584,
 -1,
 -47227,
 1199804739,
 8244,
 -1,
 1199841571,
 10747,
 1200048009,
 1199792369,
 -1,
 -47224,
 1199969895,
 10999,
 -1,
 1200085928,
 11000,
 1200244620,
 1199964822,
 -1,
 -47221,
 1200211989,
 10857,
 -1,
 1200278955,
 10856,
 -47219,
 1200165946,
 8779,
 -47218,
 1200373079,
 11003,
 -47217,
 1200436920,
 8749,
 -1,
 1200501196,
 10998,
 1200703386,
 1199413846,
 -1,
 1200768916,
 1200665413,
 -1,
 -47213,
 1200703392,
 9780,
 -1,
 1200795819,
 9781,
 -47211,
 1200704356,
 9779,
 -47210,
 1200930893,
 9782,
 -47209,
 1200990187,
 9777,
 -47208,
 1201060811,
 9776,
 -47207,
 1201099681,
 9778,
 -1,
 1201198942,
 9783,
 1201358754,
 1200673623,
 -1,
 1201424289,
 1201275640,
 -1,
 1201489824,
 1201358111,
 -1,
 -47202,
 1201420700,
 10699,
 -47201,
 1201494842,
 10701,
 -1,
 1201593564,
 10698,
 -1,
 1201442416,
 10141,
 -1,
 1201382197,
 8227,
 -1,
 1201295840,
 8285,
 1201948582,
 1199309619,
 -1,
 -47195,
 1201878612,
 10971,
 -1,
 1201970359,
 8482,
 -1,
 1201893571,
 8872,
 1202210765,
 1199283448,
 -1,
 1202276284,
 1202139775,
 -1,
 1202341806,
 1202233607,
 -1,
 1202407341,
 1202289520,
 -1,
 -47188,
 1202352214,
 8974,
 -1,
 1202399833,
 8989,
 -1,
 1202359393,
 11811,
 1202669491,
 1202268909,
 -1,
 1202735026,
 1202617200,
 -1,
 -47183,
 1202679894,
 8975,
 -1,
 1202727513,
 8988,
 -1,
 1202687073,
 11810,
 1202997175,
 1202625395,
 -1,
 1203062710,
 1202924762,
 10554,
 -1,
 1203015619,
 10557,
 -1,
 1202982425,
 10556,
 -47176,
 1202962568,
 9184,
 -47175,
 1203213113,
 9140,
 -47174,
 1203249567,
 9180,
 -47173,
 1203323263,
 8992,
 -1,
 1203396402,
 9182,
 1203587020,
 1202215379,
 -1,
 1203652555,
 1203526864,
 -1,
 1203718082,
 1203576434,
 -1,
 -47168,
 1203663058,
 127552,
 -47167,
 1203714750,
 127560,
 -1,
 1203767548,
 127557,
 1203980229,
 1203656834,
 -1,
 -47164,
 1203946798,
 127558,
 -1,
 1203979138,
 127556,
 1204176840,
 1203948102,
 -1,
 -47161,
 1204109029,
 127555,
 -1,
 1204179594,
 127559,
 1204420607,
 1204137422,
 -1,
 -47158,
 1204346676,
 127554,
 -1,
 1204386634,
 127553,
 -1,
 1203606398,
 127274,
 -1,
 1203531484,
 9008,
 1204701150,
 1202141025,
 -1,
 1204766685,
 1204644210,
 -1,
 1204832213,
 1204725646,
 -1,
 1204897748,
 1204763152,
 -1,
 -47150,
 1204830841,
 8516,
 -47149,
 1204932239,
 8514,
 -1,
 1204979405,
 8513,
 -1,
 1204822391,
 8526,
 1205225432,
 1204749107,
 -1,
 -47145,
 1205163044,
 10658,
 -1,
 1205207408,
 8523,
 -47143,
 1205159264,
 9929,
 -47142,
 1205355616,
 8985,
 -47141,
 1205450303,
 8489,
 -47140,
 1205518929,
 8498,
 -1,
 1205556315,
 9930,
 -1,
 1204726620,
 8366,
 1205862399,
 1204663109,
 -1,
 1205880814,
 1205740997,
 -1,
 1205946341,
 1205801018,
 -1,
 1206011876,
 1205883945,
 -1,
 -47133,
 1205929271,
 8282,
 -1,
 1206003668,
 8229,
 -1,
 1205983503,
 11818,
 1206274024,
 1205912005,
 -1,
 -47129,
 1206214013,
 10760,
 -1,
 1206311276,
 10759,
 1206470635,
 1206244324,
 -1,
 -47126,
 1206396649,
 10838,
 -1,
 1206506323,
 10837,
 -47124,
 1206428967,
 10697,
 -47123,
 1206596385,
 10869,
 -1,
 1206655659,
 8273,
 -1,
 1205802517,
 10041,
 1206930780,
 1105962894,
 -1,
 1206995308,
 1206867611,
 -1,
 1207060843,
 1206929830,
 -1,
 1207126303,
 1206998057,
 -1,
 1207191588,
 1207050836,
 -1,
 1207257085,
 1207136254,
 -1,
 -47114,
 1207219013,
 13244,
 -47113,
 1207268552,
 13238,
 -47112,
 1207347086,
 13234,
 -47111,
 1207378516,
 13211,
 -47110,
 1207488143,
 13205,
 -47109,
 1207535309,
 13197,
 -47108,
 1207584839,
 13196,
 -1,
 1207632691,
 13186,
 1207846916,
 1207173939,
 13187,
 1207912449,
 1207769245,
 -1,
 -47104,
 1207847312,
 13124,
 -1,
 1207896225,
 13123,
 -47102,
 1207860194,
 13126,
 -47101,
 1208079484,
 13127,
 -1,
 1208146129,
 13125,
 1208305675,
 1207784489,
 -1,
 1208371209,
 1208261880,
 -1,
 1208436744,
 1208295235,
 13223,
 -1,
 1208392912,
 13224,
 -1,
 1208400304,
 13249,
 -47094,
 1208305061,
 13217,
 -1,
 1208563278,
 13221,
 1208764432,
 1208227997,
 -1,
 1208829966,
 1208699314,
 13129,
 -1,
 1208785392,
 13130,
 -47089,
 1208798863,
 13269,
 -1,
 1208914690,
 13128,
 1209092116,
 1208689236,
 13212,
 1209204735,
 1209029673,
 -1,
 -47085,
 1209091493,
 13215,
 -1,
 1209153102,
 13219,
 1209354264,
 1209011500,
 -1,
 1209419799,
 1209314963,
 13131,
 -1,
 1209361720,
 13132,
 -1,
 1209340219,
 13133,
 1209616410,
 1209316165,
 13245,
 -1,
 1209574248,
 13247,
 1209747484,
 1209562312,
 13239,
 -1,
 1209705320,
 13241,
 1209878558,
 1209679296,
 13190,
 -1,
 1209803392,
 13268,
 -47073,
 1209837454,
 13235,
 -47072,
 1209945464,
 13227,
 -47071,
 1210001054,
 13270,
 -47070,
 1210109583,
 13206,
 -47069,
 1210169735,
 13202,
 -1,
 1210222285,
 13198,
 1210402887,
 1207144759,
 -1,
 1210468395,
 1210327636,
 13214,
 1210580991,
 1210405929,
 -1,
 1210599466,
 1210481520,
 -1,
 -47063,
 1210531383,
 13222,
 -1,
 1210622998,
 13262,
 -1,
 1210533285,
 13218,
 1210861615,
 1210390743,
 13076,
 -47059,
 1210804022,
 13079,
 -47058,
 1210871503,
 13078,
 -1,
 1210936072,
 13077,
 1211123764,
 1210778419,
 13188,
 1211189299,
 1211086087,
 -1,
 -47054,
 1211123651,
 13069,
 -1,
 1211190323,
 13068,
 -1,
 1211111601,
 13067,
 1211451447,
 1211096301,
 -1,
 -47050,
 1211376817,
 13082,
 -1,
 1211490514,
 13083,
 1211648058,
 1211407608,
 -1,
 -47047,
 1211571172,
 13085,
 -1,
 1211642540,
 13086,
 -47045,
 1211607294,
 13074,
 -47044,
 1211806533,
 13246,
 -47043,
 1211856072,
 13240,
 -47042,
 1211950474,
 13263,
 -47041,
 1211977080,
 13226,
 -47040,
 1212075663,
 13208,
 -47039,
 1212125495,
 13261,
 -47038,
 1212201351,
 13201,
 -47037,
 1212253901,
 13199,
 -47036,
 1212310524,
 13084,
 -47035,
 1212372687,
 13193,
 -47034,
 1212431808,
 13189,
 -1,
 1212526489,
 13248,
 1212696676,
 1210374560,
 -1,
 1212762190,
 1212615980,
 -1,
 1212827724,
 1212701992,
 -1,
 -47029,
 1212765844,
 13114,
 -1,
 1212825598,
 13112,
 -47027,
 1212765861,
 13111,
 -1,
 1212951073,
 13115,
 1213155411,
 1212678963,
 13225,
 1213220946,
 1213072179,
 -1,
 -47023,
 1213161903,
 13100,
 -1,
 1213216489,
 13099,
 -1,
 1213155935,
 13184,
 1213483096,
 1213077661,
 -1,
 1213548631,
 1213436215,
 -1,
 -47018,
 1213472712,
 13103,
 -1,
 1213570296,
 13104,
 -1,
 1213485671,
 13102,
 1213810779,
 1213439224,
 -1,
 -47014,
 1213786083,
 13120,
 -1,
 1213824729,
 13117,
 -47012,
 1213772613,
 13242,
 -47011,
 1213953224,
 13236,
 -47010,
 1214031758,
 13232,
 -47009,
 1214100743,
 13274,
 -47008,
 1214132838,
 13273,
 -47007,
 1214194260,
 13272,
 -47006,
 1214301074,
 13271,
 -47005,
 1214335047,
 13194,
 -1,
 1214413680,
 13174,
 1214597244,
 1212658501,
 -1,
 1214662778,
 1214536984,
 -1,
 1214728301,
 1214621664,
 -1,
 1214793834,
 1214685447,
 -1,
 -46999,
 1214737831,
 9640,
 -1,
 1214776498,
 11028,
 1215037439,
 1214720749,
 -1,
 -46996,
 1214908487,
 9639,
 -1,
 1214973106,
 9705,
 1215187058,
 1214697103,
 -1,
 1215252593,
 1215139371,
 -1,
 -46992,
 1215179065,
 9706,
 -1,
 1215288397,
 11029,
 -1,
 1215188885,
 9703,
 -46989,
 1215152031,
 9637,
 -46988,
 1215457765,
 11026,
 -46987,
 1215536869,
 9704,
 -46986,
 1215615388,
 9638,
 -46985,
 1215680721,
 9636,
 -46984,
 1215693201,
 9641,
 -46983,
 1215817492,
 10720,
 -1,
 1215824416,
 11027,
 -46981,
 1214594496,
 13277,
 -1,
 1215974451,
 13143,
 1216170128,
 1214563218,
 -1,
 1216235649,
 1216100193,
 -1,
 -46977,
 1216177797,
 13109,
 -46976,
 1216254430,
 13107,
 -1,
 1216314369,
 13106,
 1216497798,
 1216191736,
 -1,
 1216563333,
 1216453880,
 -1,
 -46972,
 1216498064,
 13121,
 -1,
 1216568616,
 13122,
 -1,
 1216503080,
 13119,
 1216825480,
 1216469408,
 13259,
 -1,
 1216742195,
 13169,
 1216956555,
 1216744748,
 -1,
 -46966,
 1216877687,
 13113,
 -1,
 1216958263,
 13110,
 1217153165,
 1216873267,
 13258,
 -1,
 1217081419,
 13098,
 -46962,
 1217101771,
 13200,
 -46961,
 1217242621,
 127488,
 -1,
 1217300173,
 13004,
 1217480863,
 1216120525,
 -1,
 1217546389,
 1217403037,
 -1,
 -46957,
 1217502404,
 13075,
 -46956,
 1217585541,
 13073,
 -1,
 1217638035,
 13072,
 1217808537,
 1217463091,
 -1,
 -46953,
 1217753126,
 13070,
 -46952,
 1217792422,
 13071,
 -1,
 1217908367,
 13311,
 1218070683,
 1217725562,
 13080,
 -1,
 1218012472,
 13081,
 -46948,
 1218003577,
 13257,
 -46947,
 1218137464,
 13228,
 -46946,
 1218230663,
 13203,
 -1,
 1218264512,
 13191,
 1218463918,
 1217443079,
 -1,
 1218529444,
 1218386077,
 -1,
 -46942,
 1218454517,
 13137,
 -46941,
 1218529705,
 13138,
 -1,
 1218592065,
 10958,
 1218791591,
 1218470385,
 13229,
 1218904063,
 1218737272,
 13230,
 -1,
 1218813136,
 13231,
 1218988202,
 1218721633,
 -1,
 -46935,
 1218950657,
 13140,
 -1,
 1218993871,
 13139,
 1219184813,
 1218907436,
 -1,
 -46932,
 1219139112,
 13142,
 -1,
 1219170229,
 13141,
 -1,
 1219114927,
 8730,
 1219446972,
 1218411376,
 -1,
 1219512499,
 1219371604,
 13213,
 1219624959,
 1219449897,
 -1,
 -46926,
 1219511717,
 13216,
 -1,
 1219573326,
 13220,
 1219774645,
 1219468536,
 13255,
 -1,
 1219737932,
 13183,
 1219905720,
 1219691315,
 -1,
 -46921,
 1219877280,
 8851,
 -1,
 1219939983,
 13192,
 -46919,
 1219850388,
 8852,
 -46918,
 1220065531,
 13253,
 -46917,
 1220115312,
 13252,
 -1,
 1220175734,
 13254,
 1220364488,
 1219410171,
 -1,
 1220430017,
 1220289108,
 13175,
 1220542463,
 1220367401,
 -1,
 -46912,
 1220429221,
 13176,
 -1,
 1220490830,
 13177,
 1220692163,
 1220346675,
 13170,
 -1,
 1220634768,
 13092,
 -46908,
 1220641477,
 13094,
 -46907,
 1220791951,
 13207,
 -46906,
 1220825804,
 127376,
 -46905,
 1220918238,
 13093,
 -1,
 1220951488,
 13256,
 1221150929,
 1220304168,
 -1,
 1221216459,
 1221067571,
 13185,
 -1,
 1221139226,
 13096,
 -46900,
 1221178181,
 13243,
 -46899,
 1221293256,
 13237,
 -46898,
 1221371790,
 13233,
 -46897,
 1221451158,
 13097,
 -46896,
 1221468756,
 13210,
 -1,
 1221544007,
 13195,
 1221740764,
 1221070124,
 -1,
 1221806297,
 1221702919,
 -1,
 1221871832,
 1221723991,
 -1,
 -46891,
 1221822435,
 13181,
 -46890,
 1221898977,
 13180,
 -46889,
 1221950232,
 13182,
 -1,
 1222007139,
 13179,
 -1,
 1221822157,
 13005,
 -46886,
 1221752008,
 13006,
 -46885,
 1222196461,
 13063,
 -1,
 1222267947,
 13064,
 1222461670,
 1221699470,
 -1,
 1222527200,
 1222426884,
 -1,
 -46881,
 1222483192,
 13091,
 -1,
 1222514845,
 13090,
 1222723811,
 1222443827,
 -1,
 -46878,
 1222690433,
 13088,
 -1,
 1222731593,
 13087,
 -46876,
 1222669512,
 13276,
 -46875,
 1222882567,
 13275,
 -1,
 1222948242,
 13089,
 1223117039,
 1222383773,
 -1,
 1223182570,
 1223056680,
 13260,
 -46871,
 1223123420,
 13061,
 -1,
 1223182146,
 13060,
 1223379182,
 1223113282,
 8847,
 1223491583,
 1223307689,
 -1,
 -46867,
 1223381541,
 8932,
 -1,
 1223462896,
 8849,
 -1,
 1223309153,
 13178,
 1223706872,
 1223048640,
 -1,
 1223772403,
 1223623475,
 -1,
 -46862,
 1223734535,
 13172,
 -1,
 1223793441,
 13101,
 -46860,
 1223741710,
 13108,
 -46859,
 1223896381,
 13251,
 -46858,
 1223973837,
 13118,
 -46857,
 1224022179,
 13105,
 -1,
 1224134310,
 13116,
 1224296704,
 1223623475,
 -1,
 -46854,
 1224226657,
 13171,
 -46853,
 1224278181,
 13057,
 -46852,
 1224370429,
 13056,
 -46851,
 1224410194,
 13058,
 -46850,
 1224483412,
 13250,
 -46849,
 1224598708,
 13059,
 -1,
 1224635554,
 13279,
 1224821000,
 1224252664,
 -1,
 1224886533,
 1224745427,
 8848,
 1224998911,
 1224815017,
 -1,
 -46844,
 1224888869,
 8933,
 -1,
 1224970224,
 8850,
 -46842,
 1224832200,
 13173,
 -46841,
 1225076803,
 13066,
 -1,
 1225138168,
 13065,
 1225345296,
 1224789647,
 -1,
 1225410828,
 1225301240,
 -1,
 -46837,
 1225338782,
 8977,
 -1,
 1225426637,
 13266,
 -46835,
 1225328559,
 13267,
 -46834,
 1225547048,
 13265,
 -46833,
 1225597524,
 13264,
 -1,
 1225671167,
 10957,
 1225869589,
 1225278073,
 -1,
 1225935124,
 1225810405,
 -1,
 -46829,
 1225869712,
 13135,
 -1,
 1225951229,
 13134,
 -1,
 1225906507,
 13136,
 1226197274,
 1225803847,
 -1,
 1226262809,
 1226153208,
 -1,
 -46824,
 1226180049,
 9974,
 -1,
 1226254051,
 9165,
 -1,
 1226187348,
 13209,
 1226524957,
 1226171786,
 -1,
 -46820,
 1226450584,
 13095,
 -1,
 1226553735,
 13204,
 -46818,
 1226476620,
 13278,
 -1,
 1226678336,
 13062,
 1226899455,
 1207077070,
 -1,
 1226918222,
 1226792144,
 -1,
 1226983729,
 1226885702,
 -1,
 1227049253,
 1226953988,
 -1,
 -46812,
 1227015279,
 127511,
 -1,
 1227065156,
 127509,
 1227245864,
 1226985069,
 -1,
 -46809,
 1227202953,
 127534,
 -1,
 1227258957,
 127506,
 1227442475,
 1227166736,
 -1,
 -46806,
 1227402699,
 127516,
 -1,
 1227458381,
 127520,
 -46804,
 1227384916,
 127517,
 -46803,
 1227565103,
 127532,
 -46802,
 1227679022,
 127505,
 -46801,
 1227689721,
 127524,
 -46800,
 1227769756,
 127525,
 -1,
 1227855529,
 127518,
 1228032318,
 1226907250,
 -1,
 1228097846,
 1227953168,
 -1,
 -46796,
 1228014175,
 127527,
 -46795,
 1228126559,
 127537,
 -1,
 1228189137,
 127504,
 1228359993,
 1228065350,
 -1,
 -46792,
 1228304216,
 127519,
 -1,
 1228344699,
 127515,
 1228556604,
 1228295789,
 -1,
 -46789,
 1228519766,
 127528,
 -1,
 1228569404,
 127535,
 -46787,
 1228521751,
 127526,
 -1,
 1228688224,
 127513,
 1228884293,
 1227992526,
 -1,
 1228949826,
 1228833358,
 -1,
 -46783,
 1228920068,
 127530,
 -1,
 1228964430,
 127529,
 -46781,
 1228890580,
 127512,
 -46780,
 1229119284,
 127508,
 -1,
 1229165850,
 127533,
 1229343049,
 1228838921,
 -1,
 -46777,
 1229269836,
 127536,
 -46776,
 1229346601,
 127523,
 -1,
 1229409203,
 127510,
 1229605197,
 1229281410,
 -1,
 -46773,
 1229558721,
 127521,
 -46772,
 1229622382,
 127522,
 -1,
 1229679305,
 127514,
 -1,
 1229551055,
 127531,
 1229932884,
 1226876814,
 -1,
 -46768,
 1229891470,
 127309,
 -46767,
 1229965356,
 10696,
 -46766,
 1230017373,
 10695,
 -46765,
 1230092539,
 127308,
 -1,
 1230124485,
 9949,
 1230326106,
 1229857613,
 -1,
 -46762,
 1230287685,
 127302,
 -46761,
 1230350222,
 127298,
 -46760,
 1230428576,
 127295,
 -46759,
 1230462248,
 127293,
 -1,
 1230519744,
 127281,
 1230719325,
 1230297504,
 -1,
 -46756,
 1230647820,
 127310,
 -1,
 1230709027,
 8862,
 1230915936,
 1230643796,
 -1,
 -46753,
 1230861512,
 127307,
 -1,
 1230901429,
 8863,
 1231112547,
 1230868791,
 -1,
 -46750,
 1231066596,
 9919,
 -1,
 1231112340,
 127507,
 1231309158,
 1231046727,
 -1,
 -46747,
 1231276549,
 11820,
 -1,
 1231325442,
 10693,
 -46745,
 1231230264,
 8864,
 -46744,
 1231431550,
 10692,
 -46743,
 1231534482,
 127306,
 -46742,
 1231572538,
 8865,
 -1,
 1231651185,
 10694,
 -1,
 1207019674,
 10151,
 1231899211,
 1206927993,
 -1,
 1231964630,
 1231866275,
 -1,
 1232030104,
 1231889765,
 -1,
 1232095608,
 1231988622,
 -1,
 1232161140,
 1232060485,
 -1,
 -46734,
 1232128213,
 1869,
 -46733,
 1232165500,
 1870,
 -1,
 1232249102,
 1871,
 -46731,
 1232089744,
 1809,
 -46730,
 1232364984,
 1835,
 -46729,
 1232410364,
 1827,
 -1,
 1232473147,
 1832,
 1232685437,
 1232024128,
 1830,
 1232797695,
 1232617155,
 -1,
 -46725,
 1232686342,
 1838,
 -46724,
 1232787147,
 1839,
 -1,
 1232841955,
 1837,
 1233013121,
 1232659850,
 -1,
 1233078656,
 1232945490,
 1819,
 -1,
 1233042349,
 1820,
 -1,
 1233019422,
 1836,
 1233275267,
 1232967463,
 1821,
 -1,
 1233236538,
 1822,
 1233406342,
 1233237255,
 -1,
 -46715,
 1233352341,
 1834,
 -1,
 1233412078,
 1831,
 1233602952,
 1233369526,
 1815,
 -1,
 1233559825,
 1818,
 1233734026,
 1233562208,
 1811,
 -1,
 1233697709,
 1812,
 1233865101,
 1233697019,
 -1,
 -46708,
 1233826063,
 1814,
 -1,
 1233876218,
 1813,
 -46706,
 1233835640,
 1817,
 -46705,
 1234027745,
 1816,
 -46704,
 1234095579,
 1833,
 -46703,
 1234154392,
 1826,
 -46702,
 1234196334,
 1825,
 -46701,
 1234296048,
 1824,
 -46700,
 1234317200,
 1823,
 -46699,
 1234399955,
 1828,
 -46698,
 1234439468,
 1829,
 -46697,
 1234517468,
 1810,
 -1,
 1234601506,
 1808,
 1234782627,
 1231995794,
 -1,
 1234848158,
 1234702904,
 -1,
 1234913693,
 1234785321,
 -1,
 -46692,
 1234876534,
 1851,
 -1,
 1234920677,
 1850,
 -1,
 1234882660,
 1852,
 1235175842,
 1234784339,
 -1,
 -46688,
 1235132945,
 1803,
 -46687,
 1235212318,
 1804,
 -1,
 1235261599,
 1805,
 -1,
 1235141998,
 1797,
 1235503532,
 1234720404,
 -1,
 1235569064,
 1235435127,
 -1,
 1235634599,
 1235505632,
 1795,
 -1,
 1235564932,
 1800,
 -1,
 1235551767,
 1793,
 1235877887,
 1235516062,
 -1,
 1235896747,
 1235767776,
 1796,
 -1,
 1235869055,
 1801,
 -1,
 1235813911,
 1794,
 1236093363,
 1235477898,
 -1,
 1236158896,
 1236037102,
 -1,
 -46673,
 1236121718,
 1860,
 -1,
 1236165861,
 1859,
 1236402175,
 1236123403,
 -1,
 -46670,
 1236318326,
 1862,
 -1,
 1236362469,
 1861,
 1236552121,
 1236055303,
 -1,
 1236617655,
 1236479168,
 -1,
 -46666,
 1236580470,
 1847,
 -1,
 1236624613,
 1846,
 -46664,
 1236563989,
 1855,
 -1,
 1236735054,
 1858,
 1236945341,
 1236478434,
 -1,
 -46661,
 1236869210,
 1845,
 -46660,
 1236973686,
 1844,
 -1,
 1237017829,
 1843,
 1237207489,
 1236869451,
 -1,
 -46657,
 1237131354,
 1842,
 -46656,
 1237235830,
 1841,
 -1,
 1237279973,
 1840,
 1237469638,
 1237126444,
 -1,
 1237535173,
 1237435746,
 -1,
 -46652,
 1237497974,
 1854,
 -1,
 1237542117,
 1853,
 -1,
 1237467783,
 1792,
 1237797323,
 1237417034,
 -1,
 1237862858,
 1237737175,
 -1,
 -46647,
 1237821033,
 1799,
 -1,
 1237866075,
 1798,
 -1,
 1237835053,
 1802,
 1238125006,
 1237713369,
 -1,
 -46643,
 1238087798,
 1864,
 -1,
 1238131941,
 1863,
 1238321617,
 1238088737,
 -1,
 -46640,
 1238269730,
 1848,
 -1,
 1238323270,
 1849,
 -46638,
 1238256028,
 1857,
 -46637,
 1238463865,
 1865,
 -46636,
 1238547851,
 1856,
 -46635,
 1238602805,
 1866,
 -1,
 1238671177,
 1807,
 1238845970,
 1231902425,
 -1,
 1238911491,
 1238771045,
 -1,
 1238976990,
 1238885770,
 -1,
 1239042524,
 1238951306,
 -1,
 -46629,
 1238998264,
 43024,
 -1,
 1239071134,
 43025,
 -46627,
 1238998264,
 43028,
 -1,
 1239202206,
 43029,
 1239370212,
 1238939899,
 -1,
 1239435746,
 1239333115,
 -1,
 -46623,
 1239391480,
 43026,
 -1,
 1239464350,
 43027,
 -46621,
 1239391480,
 43030,
 -1,
 1239595422,
 43031,
 1239763431,
 1239332103,
 -1,
 -46618,
 1239697839,
 43040,
 -1,
 1239784696,
 43038,
 1239960042,
 1239734688,
 -1,
 -46615,
 1239915768,
 43033,
 -1,
 1239988638,
 43034,
 1240156653,
 1239912759,
 -1,
 -46612,
 1240112376,
 43015,
 -1,
 1240185246,
 43016,
 1240353264,
 1240093388,
 -1,
 -46609,
 1240308984,
 43022,
 -1,
 1240381854,
 43023,
 1240549875,
 1240303309,
 -1,
 -46606,
 1240505592,
 43017,
 -1,
 1240578462,
 43018,
 1240746486,
 1240497008,
 -1,
 -46603,
 1240702200,
 43020,
 -1,
 1240775070,
 43021,
 1240943097,
 1240677824,
 -1,
 -46600,
 1240898808,
 43035,
 -1,
 1240971678,
 43036,
 -46598,
 1240872801,
 43011,
 -46597,
 1241077413,
 43041,
 -46596,
 1241160952,
 43013,
 -46595,
 1241193242,
 43032,
 -46594,
 1241255855,
 43037,
 -46593,
 1241318145,
 43039,
 -46592,
 1241389213,
 43009,
 -46591,
 1241495966,
 43042,
 -46590,
 1241517356,
 43012,
 -1,
 1241580339,
 43008,
 1241795081,
 1238862901,
 -1,
 -46587,
 1241724769,
 43045,
 -46586,
 1241786005,
 43047,
 -46585,
 1241847965,
 43044,
 -46584,
 1241910572,
 43046,
 -1,
 1241973555,
 43043,
 1242188302,
 1241726746,
 -1,
 -46581,
 1242139789,
 43051,
 -46580,
 1242189421,
 43050,
 -46579,
 1242240016,
 43049,
 -1,
 1242349224,
 43048,
 1242562559,
 1242113285,
 -1,
 -46576,
 1242435167,
 43014,
 -46575,
 1242533345,
 43010,
 -1,
 1242579144,
 43019,
 1242824703,
 1238770260,
 -1,
 1242843722,
 1242716136,
 -1,
 1242909216,
 1242802062,
 -1,
 1242974743,
 1242882217,
 9242,
 -1,
 1242910230,
 9254,
 1243105818,
 1242917422,
 -1,
 -46567,
 1243054579,
 9218,
 -1,
 1243103046,
 9217,
 1243302429,
 1243037833,
 -1,
 -46564,
 1243255286,
 9230,
 -1,
 1243334054,
 9231,
 -46562,
 1243247134,
 9238,
 -46561,
 1243422018,
 9248,
 -1,
 1243516818,
 8527,
 1243695659,
 1242872059,
 -1,
 1243761194,
 1243614508,
 -1,
 1243826728,
 1243696579,
 -1,
 1243892262,
 1243800970,
 -1,
 -46555,
 1243842801,
 9234,
 -1,
 1243908115,
 9235,
 -46553,
 1243853112,
 9233,
 -1,
 1244016259,
 9236,
 1244266495,
 1243784125,
 9249,
 -1,
 1244155414,
 9253,
 -1,
 1243714782,
 9232,
 1244416565,
 1243614508,
 -1,
 1244482100,
 1244355880,
 -1,
 1244547635,
 1244447512,
 -1,
 1244613170,
 1244521866,
 -1,
 1244678705,
 1244537901,
 9220,
 -1,
 1244613944,
 9239,
 -1,
 1244606841,
 9219,
 -1,
 1244539742,
 9241,
 -1,
 1244505117,
 9221,
 -1,
 1244439449,
 9243,
 1245071930,
 1244355880,
 -1,
 1245137465,
 1244990764,
 -1,
 -46536,
 1245067477,
 9252,
 -1,
 1245156323,
 9237,
 -1,
 1245067113,
 9216,
 1245399613,
 1245005895,
 -1,
 -46532,
 1245374361,
 9228,
 -1,
 1245417296,
 9244,
 1245596224,
 1245346896,
 -1,
 -46529,
 1245515652,
 9229,
 -1,
 1245588519,
 9240,
 1245792835,
 1245527488,
 -1,
 -46526,
 1245759775,
 9223,
 -1,
 1245795956,
 9224,
 -46524,
 1245753849,
 9227,
 -46523,
 1245958174,
 9247,
 -46522,
 1246023219,
 9246,
 -46521,
 1246046724,
 9226,
 -46520,
 1246102114,
 9225,
 -46519,
 1246188273,
 9245,
 -1,
 1246258374,
 9222,
 -1,
 1242786761,
 9007,
 1246513930,
 1231815475,
 -1,
 1246579384,
 1246452410,
 -1,
 1246644879,
 1246504293,
 -1,
 1246710357,
 1246590152,
 -1,
 1246775892,
 1246649651,
 -1,
 1246841426,
 1246737671,
 43144,
 -1,
 1246803207,
 43145,
 1247019007,
 1246809743,
 43146,
 -1,
 1246940815,
 43147,
 -1,
 1246692147,
 43182,
 1247169115,
 1246684554,
 -1,
 1247234649,
 1247143306,
 -1,
 -46504,
 1247197619,
 43165,
 -1,
 1247216435,
 43164,
 -46502,
 1247197619,
 43170,
 -1,
 1247347507,
 43169,
 1247562336,
 1247108392,
 -1,
 -46499,
 1247489060,
 43163,
 -46498,
 1247550237,
 43168,
 -46497,
 1247653523,
 43158,
 -1,
 1247675187,
 43173,
 1247890022,
 1247525115,
 -1,
 1247955556,
 1247852795,
 -1,
 -46493,
 1247918515,
 43167,
 -1,
 1247937331,
 43166,
 -46491,
 1247918515,
 43172,
 -1,
 1248068403,
 43171,
 1248283242,
 1247806259,
 43138,
 -46488,
 1248212833,
 43153,
 -46487,
 1248270493,
 43150,
 -1,
 1248330547,
 43139,
 1248545390,
 1248241550,
 -1,
 -46484,
 1248482988,
 43184,
 -46483,
 1248573875,
 43183,
 -1,
 1248592691,
 43185,
 1248807536,
 1248474977,
 43142,
 -1,
 1248737121,
 43143,
 1248938611,
 1248778656,
 -1,
 -46478,
 1248901555,
 43175,
 -1,
 1248920371,
 43174,
 1249135221,
 1248894200,
 43151,
 -1,
 1249090808,
 43152,
 1249266296,
 1249103503,
 -1,
 -46473,
 1249182462,
 43187,
 -1,
 1249248051,
 43181,
 1249462907,
 1249218871,
 -1,
 -46470,
 1249425843,
 43155,
 -1,
 1249444659,
 43154,
 1249659518,
 1249399500,
 -1,
 -46467,
 1249622451,
 43162,
 -1,
 1249641267,
 43161,
 1249856128,
 1249581213,
 43140,
 -1,
 1249777821,
 43141,
 1249987203,
 1249806029,
 -1,
 -46462,
 1249950131,
 43157,
 -1,
 1249968947,
 43156,
 1250183813,
 1249905964,
 43148,
 -1,
 1250102572,
 43149,
 1250314888,
 1250130800,
 -1,
 -46457,
 1250277811,
 43160,
 -1,
 1250296627,
 43159,
 1250511499,
 1250246080,
 -1,
 -46454,
 1250474419,
 43177,
 -1,
 1250493235,
 43176,
 -46452,
 1250438180,
 43179,
 -46451,
 1250642345,
 43180,
 -46450,
 1250693030,
 43178,
 -1,
 1250802099,
 43186,
 1250970273,
 1246596149,
 -1,
 1251035797,
 1250886372,
 -1,
 1251101331,
 1250997511,
 43194,
 -1,
 1251063047,
 43195,
 1251278847,
 1251069583,
 43196,
 -1,
 1251200655,
 43197,
 1251363481,
 1250951987,
 -1,
 -46441,
 1251293025,
 43203,
 -46440,
 1251350685,
 43200,
 -1,
 1251410739,
 43189,
 1251625627,
 1251293025,
 43192,
 -1,
 1251555169,
 43193,
 1251756701,
 1251581176,
 43201,
 -1,
 1251712248,
 43202,
 1251887775,
 1251678365,
 43190,
 -1,
 1251809437,
 43191,
 1252065279,
 1251806508,
 43198,
 -1,
 1251937580,
 43199,
 1252149938,
 1250932987,
 -1,
 1252215472,
 1252121767,
 -1,
 1252280998,
 1252189578,
 -1,
 -46427,
 1252231409,
 43218,
 -1,
 1252296723,
 43219,
 1252477609,
 1252239246,
 -1,
 -46424,
 1252443499,
 43222,
 -1,
 1252473470,
 43223,
 1252674220,
 1252411463,
 -1,
 -46421,
 1252626930,
 43220,
 -1,
 1252665346,
 43221,
 -46419,
 1252591971,
 43216,
 -46418,
 1252831544,
 43217,
 -46417,
 1252864566,
 43225,
 -1,
 1252966602,
 43224,
 -46415,
 1252173043,
 43215,
 -1,
 1253061341,
 43214,
 1253264055,
 1252074757,
 -1,
 1253329590,
 1253211392,
 -1,
 -46411,
 1253293226,
 43137,
 -1,
 1253326321,
 43204,
 -1,
 1253261512,
 43136,
 -1,
 1253221898,
 43188,
 1253657350,
 1246495991,
 -1,
 1253722836,
 1253582181,
 -1,
 1253788350,
 1253696906,
 -1,
 -46404,
 1253760213,
 2065,
 -46403,
 1253819783,
 2056,
 -1,
 1253847142,
 2069,
 1254050498,
 1253709981,
 -1,
 -46400,
 1253982841,
 2052,
 -46399,
 1254090122,
 2055,
 -1,
 1254120744,
 2063,
 1254312645,
 1254008718,
 -1,
 -46396,
 1254252033,
 2062,
 -1,
 1254327416,
 2068,
 1254509256,
 1254243776,
 -1,
 -46393,
 1254475143,
 2049,
 -1,
 1254515173,
 2053,
 -46391,
 1254444119,
 2054,
 -46390,
 1254642703,
 2057,
 -46389,
 1254721884,
 2067,
 -46388,
 1254774440,
 2066,
 -46387,
 1254863768,
 2061,
 -46386,
 1254905710,
 2060,
 -46385,
 1254960291,
 2059,
 -46384,
 1255040159,
 2058,
 -46383,
 1255123532,
 2050,
 -46382,
 1255186708,
 2064,
 -46381,
 1255269979,
 2051,
 -1,
 1255290241,
 2048,
 1255492326,
 1253674037,
 -1,
 1255557851,
 1255446815,
 -1,
 1255623384,
 1255473971,
 2082,
 -1,
 1255539507,
 2079,
 -46375,
 1255552865,
 2086,
 -46374,
 1255676061,
 2089,
 -1,
 1255738668,
 2076,
 1255951070,
 1255513336,
 2091,
 1256062975,
 1255903680,
 2081,
 -1,
 1255932723,
 2078,
 1256147681,
 1255909262,
 -1,
 -46368,
 1256103971,
 2092,
 -1,
 1256158198,
 2085,
 1256344291,
 1256063795,
 2083,
 -1,
 1256260403,
 2080,
 -46364,
 1256273761,
 2087,
 -46363,
 1256396957,
 2090,
 -1,
 1256459564,
 2077,
 1256671993,
 1255433006,
 -1,
 1256737518,
 1256588083,
 -1,
 1256803051,
 1256676648,
 -1,
 -46358,
 1256737238,
 2110,
 -1,
 1256823011,
 2098,
 -46356,
 1256749484,
 2100,
 -46355,
 1256949721,
 2108,
 -1,
 1256981936,
 2097,
 1257196273,
 1256685515,
 -1,
 -46352,
 1257150732,
 2104,
 -1,
 1257193525,
 2106,
 1257392884,
 1257154446,
 -1,
 -46349,
 1257310235,
 2109,
 -1,
 1257376170,
 2101,
 -46347,
 1257348058,
 2107,
 -46346,
 1257557513,
 2105,
 -46345,
 1257627044,
 2096,
 -46344,
 1257688144,
 2103,
 -1,
 1257705662,
 2099,
 1257917189,
 1256596052,
 -1,
 1257982721,
 1257880518,
 -1,
 1258048253,
 1257948582,
 2070,
 -1,
 1258017463,
 2071,
 -46338,
 1257991468,
 2072,
 -46337,
 1258151332,
 2093,
 -46336,
 1258178802,
 2075,
 -1,
 1258245956,
 2073,
 1258487807,
 1257951671,
 -1,
 -46333,
 1258364021,
 2084,
 -46332,
 1258428573,
 2088,
 -1,
 1258506482,
 2074,
 -1,
 1257873225,
 2102,
 -46329,
 1253612527,
 9796,
 -46328,
 1258704565,
 9747,
 -46327,
 1258777041,
 9973,
 -1,
 1258829141,
 9808,
 1259031491,
 1246443361,
 -1,
 1259096916,
 1258970408,
 9737,
 1259162451,
 1259031852,
 -1,
 1259227953,
 1259087205,
 -1,
 1259293458,
 1259167016,
 -1,
 -46320,
 1259220004,
 7057,
 -46319,
 1259318931,
 7053,
 -1,
 1259340595,
 7060,
 1259555605,
 1259251598,
 -1,
 -46316,
 1259482148,
 7087,
 -1,
 1259537203,
 7070,
 1259752216,
 1259508023,
 -1,
 -46313,
 1259714995,
 7086,
 -1,
 1259733811,
 7050,
 1259948826,
 1259670828,
 7048,
 -1,
 1259878241,
 7049,
 1260079900,
 1259864883,
 7043,
 -1,
 1259998508,
 7046,
 -46307,
 1260039977,
 7056,
 -46306,
 1260137508,
 7066,
 -46305,
 1260230317,
 7071,
 -46304,
 1260292330,
 7069,
 -46303,
 1260354803,
 7063,
 -46302,
 1260402529,
 7045,
 -46301,
 1260478946,
 7058,
 -46300,
 1260538281,
 7067,
 -46299,
 1260601049,
 7051,
 -46298,
 1260670328,
 7061,
 -46297,
 1260756216,
 7047,
 -46296,
 1260785574,
 7065,
 -46295,
 1260847870,
 7068,
 -46294,
 1260966390,
 7055,
 -46293,
 1260984477,
 7044,
 -46292,
 1261091251,
 7072,
 -46291,
 1261153939,
 7052,
 -46290,
 1261215999,
 7062,
 -46289,
 1261275152,
 7059,
 -46288,
 1261337680,
 7054,
 -1,
 1261425153,
 7064,
 1261587263,
 1259200881,
 -1,
 1261652789,
 1261561226,
 -1,
 -46284,
 1261603057,
 7090,
 -1,
 1261668371,
 7091,
 1261849400,
 1261610894,
 -1,
 -46281,
 1261815147,
 7094,
 -1,
 1261845118,
 7095,
 1262046011,
 1261783111,
 -1,
 -46278,
 1261998578,
 7092,
 -1,
 1262036994,
 7093,
 -46276,
 1261963619,
 7088,
 -46275,
 1262203192,
 7089,
 -46274,
 1262236214,
 7097,
 -1,
 1262338250,
 7096,
 1262504775,
 1261544878,
 -1,
 1262570310,
 1262443816,
 -1,
 -46270,
 1262540283,
 7077,
 -46269,
 1262606009,
 7079,
 -46268,
 1262626584,
 7076,
 -46267,
 1262709308,
 7081,
 -1,
 1262773739,
 7078,
 -1,
 1262502852,
 7080,
 1263029070,
 1262442464,
 -1,
 1263094605,
 1262968104,
 -1,
 1263160140,
 1263044301,
 -1,
 -46261,
 1263075499,
 7042,
 -1,
 1263143979,
 7041,
 -1,
 1263104323,
 7040,
 -1,
 1263037133,
 7082,
 1263534079,
 1262972267,
 -1,
 1263553362,
 1263409961,
 -1,
 -46255,
 1263511567,
 7075,
 -1,
 1263571909,
 7074,
 -1,
 1263472369,
 7073,
 -1,
 1259112119,
 9925,
 1263881093,
 1259028328,
 -1,
 1263946605,
 1263813106,
 -1,
 1264012128,
 1263871678,
 8835,
 1264123903,
 1263948841,
 -1,
 1264143197,
 1264051363,
 -1,
 -46246,
 1264097888,
 10952,
 -46245,
 1264144933,
 10956,
 -46244,
 1264221306,
 10950,
 -1,
 1264307491,
 10954,
 1264470879,
 1264090494,
 8839,
 -1,
 1264409915,
 10948,
 -1,
 1264400450,
 8843,
 1264667492,
 1263973799,
 -1,
 -46238,
 1264594568,
 10944,
 -46237,
 1264703070,
 10946,
 -1,
 1264717882,
 10942,
 1264929641,
 1264641187,
 -1,
 1264995176,
 1264866964,
 -1,
 -46233,
 1264916545,
 10966,
 -1,
 1265004404,
 10964,
 -1,
 1264923157,
 10619,
 1265257324,
 1264894441,
 -1,
 -46229,
 1265208115,
 10967,
 -1,
 1265295025,
 10968,
 -1,
 1265227551,
 10185,
 1265565695,
 1263880069,
 -1,
 1265585011,
 1265487503,
 -1,
 1265650546,
 1265534305,
 -1,
 -46223,
 1265589544,
 8319,
 -1,
 1265637533,
 8305,
 -1,
 1265591921,
 8317,
 1265912694,
 1265558922,
 -1,
 -46219,
 1265862897,
 178,
 -1,
 1265928211,
 179,
 1266109305,
 1265870734,
 -1,
 -46216,
 1266074987,
 8310,
 -1,
 1266104958,
 8311,
 1266305916,
 1266042951,
 -1,
 -46213,
 1266258418,
 8308,
 -1,
 1266296834,
 8309,
 1266502527,
 1266224428,
 -1,
 -46210,
 1266469163,
 8316,
 -1,
 1266524734,
 8312,
 -46208,
 1266420067,
 8304,
 -46207,
 1266665820,
 8318,
 -46206,
 1266731881,
 8314,
 -46205,
 1266790712,
 185,
 -46204,
 1266823734,
 8313,
 -1,
 1266893539,
 8315,
 1267092398,
 1263824529,
 -1,
 1267157914,
 1267025797,
 -1,
 1267223434,
 1267131786,
 -1,
 -46199,
 1267173617,
 8322,
 -1,
 1267238931,
 8323,
 1267420045,
 1267181454,
 -1,
 -46196,
 1267385707,
 8326,
 -1,
 1267415678,
 8327,
 1267616656,
 1267353671,
 -1,
 -46193,
 1267569138,
 8324,
 -1,
 1267607554,
 8325,
 1267813267,
 1267535148,
 -1,
 -46190,
 1267779883,
 8332,
 -1,
 1267835454,
 8328,
 -46188,
 1267730787,
 8320,
 -46187,
 1267976540,
 8334,
 -46186,
 1268042601,
 8330,
 -46185,
 1268101432,
 8321,
 -46184,
 1268134454,
 8329,
 -46183,
 1268204259,
 8331,
 -1,
 1268286053,
 8333,
 1268514815,
 1267089906,
 -1,
 1268534181,
 1268393662,
 8834,
 1268645887,
 1268470825,
 -1,
 1268665250,
 1268573347,
 -1,
 -46177,
 1268619872,
 10951,
 -46176,
 1268666917,
 10955,
 -46175,
 1268743290,
 10949,
 -1,
 1268829475,
 10953,
 1268992932,
 1268612478,
 8838,
 -1,
 1268931899,
 10947,
 -1,
 1268922434,
 8842,
 1269189545,
 1268495783,
 -1,
 -46169,
 1269116552,
 10943,
 -46168,
 1269225054,
 10945,
 -1,
 1269239866,
 10941,
 1269497855,
 1269163171,
 -1,
 1269517229,
 1269388948,
 -1,
 -46164,
 1269438529,
 10963,
 -1,
 1269526388,
 10965,
 -1,
 1269488767,
 10617,
 1269779390,
 1267028372,
 8827,
 1269891071,
 1269716009,
 -1,
 1269910457,
 1269818531,
 -1,
 1269975988,
 1269883310,
 -1,
 -46157,
 1269912101,
 10930,
 -1,
 1269988474,
 10928,
 1270172599,
 1269946368,
 -1,
 -46154,
 1270124528,
 10934,
 -1,
 1270205731,
 10938,
 -46152,
 1270119546,
 10932,
 -1,
 1270336803,
 10936,
 1270500284,
 1269831000,
 -1,
 -46149,
 1270422787,
 8831,
 -1,
 1270515527,
 8829,
 -46147,
 1270423529,
 8881,
 -1,
 1270666794,
 8937,
 1270827970,
 1269735374,
 -1,
 -46144,
 1270759864,
 10763,
 -46143,
 1270834479,
 9138,
 -1,
 1270915872,
 9139,
 -1,
 1270747218,
 8751,
 1271155788,
 1258952861,
 -1,
 1271221310,
 1271094568,
 -1,
 1271286839,
 1271155789,
 -1,
 1271352344,
 1271211365,
 -1,
 1271417821,
 1271268147,
 -1,
 1271483349,
 1271369353,
 -1,
 1271548876,
 1271457162,
 -1,
 -46133,
 1271466743,
 3495,
 -1,
 1271560366,
 3501,
 1271745487,
 1271511291,
 -1,
 -46130,
 1271706444,
 3497,
 -1,
 1271756974,
 3503,
 -46128,
 1271694448,
 3508,
 -46127,
 1271861036,
 3482,
 -46126,
 1271962462,
 3490,
 -46125,
 1272009987,
 3484,
 -46124,
 1272083480,
 3488,
 -1,
 1272158449,
 3510,
 1272335320,
 1271401772,
 -1,
 -46121,
 1272297201,
 3463,
 -1,
 1272330415,
 3464,
 -46119,
 1272297201,
 3461,
 -46118,
 1272491600,
 3478,
 -46117,
 1272518311,
 3513,
 -46116,
 1272632510,
 3475,
 -1,
 1272674478,
 3462,
 1272859633,
 1271341652,
 -1,
 1272925165,
 1272775475,
 -1,
 1272990700,
 1272845760,
 -1,
 1273056227,
 1272964490,
 -1,
 -46110,
 1272974071,
 3496,
 -1,
 1273067694,
 3502,
 1273252838,
 1273018619,
 -1,
 -46107,
 1273213772,
 3498,
 -1,
 1273264302,
 3504,
 -46105,
 1273201776,
 3509,
 -46104,
 1273368364,
 3483,
 -46103,
 1273469790,
 3491,
 -46102,
 1273517315,
 3485,
 -46101,
 1273590808,
 3489,
 -1,
 1273665777,
 3511,
 -1,
 1272952561,
 3512,
 1273954303,
 1272898486,
 -1,
 -46097,
 1273848820,
 3522,
 -46096,
 1273925268,
 3499,
 -1,
 1273995588,
 3525,
 1274170362,
 1272780957,
 -1,
 1274235893,
 1274104208,
 -1,
 -46092,
 1274197745,
 3469,
 -1,
 1274261072,
 3470,
 1274432504,
 1274151725,
 -1,
 -46089,
 1274394353,
 3471,
 -1,
 1274457680,
 3472,
 -46087,
 1274394353,
 3465,
 -1,
 1274598590,
 3466,
 1274760192,
 1274116598,
 -1,
 1274825726,
 1274722555,
 -1,
 -46083,
 1274786636,
 3500,
 -1,
 1274837166,
 3507,
 -46081,
 1274780510,
 3494,
 -1,
 1274959107,
 3487,
 1275153413,
 1274680877,
 -1,
 1275218948,
 1275090604,
 -1,
 -46077,
 1275180785,
 3521,
 -1,
 1275224909,
 3493,
 -1,
 1275182769,
 3492,
 1275481097,
 1275088625,
 -1,
 -46073,
 1275421684,
 3523,
 -46072,
 1275498132,
 3505,
 -1,
 1275568452,
 3517,
 1275743244,
 1275410273,
 -1,
 -46069,
 1275705073,
 3467,
 -1,
 1275768400,
 3468,
 1275939855,
 1275698424,
 -1,
 -46066,
 1275901681,
 3476,
 -1,
 1275925682,
 3477,
 1276136466,
 1275858220,
 -1,
 -46063,
 1276098289,
 3473,
 -1,
 1276131503,
 3474,
 -46061,
 1276082838,
 3514,
 -46060,
 1276252302,
 3520,
 -46059,
 1276321258,
 3515,
 -46058,
 1276392162,
 3486,
 -46057,
 1276496409,
 3524,
 -1,
 1276545569,
 3526,
 1276726321,
 1271303221,
 -1,
 1276791845,
 1276678455,
 -1,
 1276857377,
 1276718392,
 -1,
 1276922912,
 1276804339,
 3545,
 1277034495,
 1276860401,
 -1,
 -46050,
 1276949332,
 3550,
 -46049,
 1276983858,
 3549,
 -1,
 1277046518,
 3548,
 -1,
 1276892271,
 3547,
 1277362175,
 1276829827,
 -1,
 -46045,
 1277244290,
 3540,
 -46044,
 1277299352,
 3538,
 -1,
 1277381289,
 3536,
 1277578285,
 1276763032,
 -1,
 1277643817,
 1277537939,
 -1,
 -46040,
 1277607370,
 3571,
 -1,
 1277636437,
 3570,
 -46038,
 1277571970,
 3542,
 -46037,
 1277790096,
 3546,
 -46036,
 1277823640,
 3539,
 -1,
 1277905577,
 3537,
 1278102576,
 1277537939,
 -1,
 -46033,
 1278066122,
 3551,
 -1,
 1278095189,
 3544,
 -1,
 1278029558,
 3535,
 1278364726,
 1276650757,
 -1,
 1278430261,
 1278280499,
 -1,
 -46028,
 1278397494,
 3458,
 -1,
 1278452364,
 3530,
 -1,
 1278371208,
 3459,
 -1,
 1278294381,
 3572,
 1278757949,
 1271243793,
 -1,
 1278823483,
 1278725775,
 -1,
 -46022,
 1278758871,
 8218,
 -1,
 1278830293,
 8249,
 -46020,
 1278760378,
 8250,
 -1,
 1278977423,
 8219,
 -1,
 1278687463,
 8767,
 1279216710,
 1271138089,
 -1,
 1279282242,
 1279146405,
 -1,
 -46015,
 1279202919,
 10909,
 -1,
 1279318952,
 10910,
 1279478853,
 1279255715,
 -1,
 -46012,
 1279447772,
 10911,
 -1,
 1279462154,
 10912,
 -1,
 1279443977,
 10860,
 1279787007,
 1279133615,
 -1,
 1279806538,
 1279696746,
 -1,
 -46007,
 1279730548,
 10038,
 -1,
 1279797479,
 10046,
 -46005,
 1279777145,
 10042,
 -1,
 1279922386,
 8198,
 1280134302,
 1271120786,
 -1,
 1280199825,
 1280049971,
 -1,
 1280265356,
 1280117824,
 -1,
 1280330841,
 1280181043,
 -1,
 1280396371,
 1280292103,
 -1,
 -45998,
 1280337617,
 66684,
 -1,
 1280380204,
 66680,
 -45996,
 1280346343,
 66679,
 -45995,
 1280530082,
 66664,
 -45994,
 1280624004,
 66682,
 -45993,
 1280689042,
 66669,
 -45992,
 1280749197,
 66673,
 -1,
 1280804861,
 66665,
 1280986208,
 1280285944,
 -1,
 -45989,
 1280929934,
 66668,
 -45988,
 1281012999,
 66681,
 -45987,
 1281039219,
 66677,
 -45986,
 1281121576,
 66666,
 -45985,
 1281213859,
 66678,
 -1,
 1281253888,
 66676,
 1281444966,
 1280904492,
 -1,
 1281510500,
 1281360691,
 -1,
 -45981,
 1281484170,
 66672,
 -1,
 1281537287,
 66685,
 -45979,
 1281444246,
 66683,
 -1,
 1281666698,
 66663,
 1281838187,
 1281418634,
 -1,
 1281903722,
 1281803154,
 -1,
 -45975,
 1281874799,
 66644,
 -1,
 1281922532,
 66654,
 -1,
 1281828579,
 66641,
 1282165871,
 1281759389,
 -1,
 -45971,
 1282099271,
 66662,
 -45970,
 1282178131,
 66674,
 -1,
 1282236940,
 66686,
 1282428018,
 1282122186,
 -1,
 -45967,
 1282388805,
 66687,
 -1,
 1282409267,
 66648,
 1282624629,
 1282377969,
 -1,
 -45964,
 1282549406,
 66667,
 -1,
 1282608428,
 66658,
 1282821240,
 1282582414,
 -1,
 -45961,
 1282744215,
 66646,
 -1,
 1282841848,
 66645,
 1283017851,
 1282744916,
 -1,
 -45958,
 1282982326,
 66661,
 -1,
 1283026790,
 66656,
 1283214462,
 1282982802,
 -1,
 -45955,
 1283141642,
 66649,
 -1,
 1283195141,
 66659,
 -45953,
 1283138642,
 66655,
 -45952,
 1283339619,
 66653,
 -45951,
 1283420308,
 66675,
 -45950,
 1283499951,
 66670,
 -45949,
 1283523309,
 66640,
 -45948,
 1283634072,
 66671,
 -45947,
 1283689344,
 66660,
 -45946,
 1283738151,
 66642,
 -45945,
 1283798138,
 66657,
 -45944,
 1283893660,
 66652,
 -45943,
 1283944751,
 66643,
 -45942,
 1283994586,
 66651,
 -45941,
 1284089856,
 66647,
 -1,
 1284124835,
 66650,
 1284328592,
 1280202922,
 -1,
 -45938,
 1284255328,
 10032,
 -45937,
 1284354018,
 10014,
 -1,
 1284383591,
 10061,
 -1,
 1284244736,
 9752,
 1284656284,
 1280154872,
 -1,
 1284721819,
 1284605641,
 -1,
 1284787351,
 1284695858,
 10976,
 1284898815,
 1284723753,
 -1,
 -45930,
 1284783220,
 10984,
 -1,
 1284864683,
 10985,
 1285049497,
 1284758964,
 10975,
 -1,
 1285000499,
 10983,
 -45926,
 1285005223,
 10564,
 -1,
 1285143868,
 10974,
 -1,
 1284676489,
 9085,
 -45923,
 1284615649,
 10722,
 -1,
 1285312827,
 9961,
 1285508334,
 1280057940,
 -1,
 1285573869,
 1285423923,
 -1,
 1285639404,
 1285489412,
 -1,
 1285704938,
 1285575721,
 -1,
 1285770432,
 1285666055,
 -1,
 1285835963,
 1285739578,
 -1,
 1285901482,
 1285809546,
 -1,
 1285967016,
 1285862213,
 -1,
 -45913,
 1285922040,
 8561,
 -1,
 1285963324,
 8571,
 -45911,
 1285916691,
 8562,
 -1,
 1286116789,
 8569,
 1286294704,
 1285834823,
 -1,
 1286360239,
 1286215837,
 -1,
 1286425774,
 1286307069,
 8564,
 -1,
 1286381567,
 8574,
 -1,
 1286381750,
 8572,
 -1,
 1286312434,
 8563,
 1286687924,
 1286254904,
 8560,
 1286799359,
 1286624297,
 -1,
 -45901,
 1286701918,
 8575,
 -1,
 1286750275,
 8573,
 1286950071,
 1286645646,
 -1,
 -45898,
 1286915435,
 8565,
 -1,
 1286945406,
 8566,
 1287146682,
 1286868268,
 -1,
 -45895,
 1287081339,
 8570,
 -1,
 1287168574,
 8567,
 -1,
 1287074358,
 8568,
 1287408831,
 1285809050,
 -1,
 -45891,
 1287372936,
 65118,
 -45890,
 1287397791,
 65114,
 -1,
 1287479090,
 65116,
 -1,
 1287378449,
 65128,
 1287736520,
 1285688620,
 -1,
 1287802053,
 1287676774,
 8714,
 1287913471,
 1287734559,
 -1,
 -45884,
 1287785854,
 8948,
 -1,
 1287896313,
 8951,
 -45882,
 1287718923,
 65111,
 -45881,
 1288030507,
 65126,
 -1,
 1288069846,
 65112,
 1288260818,
 1287683146,
 -1,
 1288326350,
 1288211061,
 -1,
 1288391885,
 1288287655,
 -1,
 -45876,
 1288310142,
 8956,
 -1,
 1288420601,
 8958,
 -1,
 1288309360,
 8717,
 1288654033,
 1288245164,
 -1,
 -45872,
 1288607235,
 65131,
 -1,
 1288635187,
 65104,
 -1,
 1288571349,
 65109,
 1288916184,
 1288176376,
 -1,
 1288981719,
 1288872052,
 -1,
 -45867,
 1288945800,
 65117,
 -45866,
 1288970655,
 65113,
 -1,
 1289051954,
 65115,
 -1,
 1288924291,
 65124,
 1289309403,
 1288889738,
 -1,
 -45862,
 1289228817,
 68411,
 -1,
 1289293784,
 732,
 1289506014,
 1289279904,
 -1,
 -45859,
 1289467825,
 65122,
 -1,
 1289528973,
 65130,
 1289702625,
 1289421619,
 -1,
 -45856,
 1289640031,
 65121,
 -1,
 1289683312,
 65120,
 -45854,
 1289637196,
 10849,
 -45853,
 1289827639,
 65108,
 -45852,
 1289926371,
 65110,
 -45851,
 1289973248,
 65119,
 -45850,
 1290027703,
 65105,
 -45849,
 1290089467,
 65123,
 -45848,
 1290176259,
 65125,
 -45847,
 1290208791,
 65106,
 -1,
 1290331456,
 65129,
 1290534911,
 1285674378,
 10922,
 -1,
 1290411686,
 10924,
 -1,
 1285575151,
 10803,
 -1,
 1285508845,
 8995,
 1290751242,
 1285463288,
 -1,
 1290816772,
 1290680161,
 -1,
 1290882307,
 1290789201,
 -1,
 1290947835,
 1290850418,
 -1,
 1291013368,
 1290886822,
 8600,
 1291124735,
 1290949673,
 -1,
 -45835,
 1291036743,
 10533,
 -45834,
 1291100200,
 8690,
 -45833,
 1291151010,
 10541,
 -1,
 1291226673,
 10537,
 -45831,
 1290952601,
 11010,
 -45830,
 1291347021,
 8664,
 -1,
 1291394947,
 11018,
 1291649023,
 1290868604,
 -1,
 1291668736,
 1291542182,
 8601,
 1291780095,
 1291605033,
 -1,
 -45825,
 1291692103,
 10534,
 -1,
 1291733009,
 10538,
 -45823,
 1291607961,
 11011,
 -45822,
 1291871309,
 8665,
 -1,
 1291919235,
 11019,
 -1,
 1290835865,
 8471,
 1292193030,
 1290737313,
 47,
 -1,
 1292143923,
 10742,
 1292324105,
 1292148988,
 -1,
 -45816,
 1292274097,
 9108,
 -1,
 1292312142,
 173,
 -1,
 1292244180,
 9917,
 1292586271,
 1290697584,
 -1,
 1292651805,
 1292547335,
 -1,
 1292717340,
 1292622278,
 -1,
 1292782871,
 1292690299,
 -1,
 -45809,
 1292743943,
 8475,
 -45808,
 1292818848,
 8472,
 -45807,
 1292837460,
 8499,
 -45806,
 1292947087,
 8466,
 -45805,
 1292966045,
 8464,
 -45804,
 1293075346,
 8459,
 -45803,
 1293109319,
 8497,
 -45802,
 1293159724,
 8496,
 -1,
 1293237696,
 8492,
 1293484031,
 1292754680,
 -1,
 -45799,
 1293393144,
 8500,
 -45798,
 1293471375,
 8467,
 -45797,
 1293518541,
 8458,
 -1,
 1293552940,
 8495,
 -1,
 1292656674,
 8456,
 -45794,
 1292597519,
 9807,
 -1,
 1293756100,
 9878,
 1293962542,
 1292504364,
 -1,
 1294028068,
 1293881266,
 -1,
 -45790,
 1293948295,
 9914,
 -45789,
 1294026182,
 10802,
 -1,
 1294094816,
 59,
 1294290215,
 1293985678,
 -1,
 -45786,
 1294205895,
 9916,
 -1,
 1294312831,
 65093,
 1294486826,
 1294236764,
 -1,
 -45783,
 1294411497,
 8980,
 -1,
 1294476091,
 167,
 -45781,
 1294403497,
 9913,
 -45780,
 1294641969,
 8726,
 -45779,
 1294664106,
 8480,
 -1,
 1294738939,
 8979,
 1294945597,
 1293936010,
 -1,
 1295011129,
 1294861107,
 -1,
 1295076662,
 1294944731,
 -1,
 1295142196,
 1295031544,
 -1,
 -45773,
 1295081875,
 8902,
 -1,
 1295129577,
 10017,
 -45771,
 1295068086,
 8795,
 -1,
 1295283177,
 9770,
 1295515647,
 1295003497,
 -1,
 -45768,
 1295410053,
 9882,
 -1,
 1295452969,
 9877,
 1295712255,
 1294972167,
 -1,
 -45765,
 1295624326,
 8803,
 -45764,
 1295673725,
 10025,
 -1,
 1295736285,
 9188,
 1295928650,
 1294913167,
 -1,
 1295994181,
 1295844147,
 -1,
 1296059716,
 1295963414,
 -1,
 1296125250,
 1295980135,
 10901,
 -1,
 1296069030,
 10903,
 1296302079,
 1296096168,
 10902,
 -1,
 1296200102,
 10904,
 -1,
 1296000363,
 42611,
 1296498687,
 1295918831,
 -1,
 1296518473,
 1296392982,
 -1,
 -45752,
 1296443113,
 10839,
 -1,
 1296552787,
 10840,
 -1,
 1296436524,
 9011,
 1296780627,
 1295899040,
 -1,
 1296846159,
 1296738898,
 8738,
 1296957439,
 1296783463,
 -1,
 -45746,
 1296855188,
 10657,
 -1,
 1296914011,
 10656,
 1297108306,
 1296761651,
 -1,
 -45743,
 1297070262,
 10055,
 -1,
 1297120339,
 32,
 -1,
 1297043154,
 8375,
 1297370455,
 1296695733,
 -1,
 1297435990,
 1297299586,
 9731,
 -1,
 1297394597,
 9924,
 -1,
 1297364835,
 10052,
 1297632602,
 1297322295,
 -1,
 -45735,
 1297606288,
 9760,
 -1,
 1297670982,
 9975,
 -45733,
 1297604531,
 8275,
 -1,
 1297766854,
 10700,
 1297961573,
 1206895506,
 -1,
 1298026610,
 1297875763,
 -1,
 1298091990,
 1297964328,
 -1,
 1298157501,
 1298040525,
 -1,
 1298223019,
 1298085651,
 -1,
 1298288265,
 1298158284,
 -1,
 1298353689,
 1298238702,
 -1,
 1298419081,
 1298283522,
 4527,
 1298530303,
 1298379912,
 -1,
 1298550126,
 1298454944,
 -1,
 1298615660,
 1298483553,
 4530,
 1298726911,
 1298576520,
 -1,
 -45719,
 1298603252,
 55257,
 -45718,
 1298716238,
 4563,
 -45717,
 1298783961,
 55258,
 -1,
 1298792838,
 4564,
 -45715,
 1298579470,
 4533,
 -1,
 1298964823,
 4567,
 1299139957,
 1298501943,
 -1,
 1299205491,
 1299104012,
 4528,
 1299316735,
 1299166344,
 -1,
 -45710,
 1299240526,
 4556,
 -1,
 1299251590,
 55254,
 -45708,
 1299131799,
 4568,
 -1,
 1299417971,
 4565,
 1299598714,
 1299086431,
 4529,
 1299709951,
 1299559560,
 -1,
 -45704,
 1299633742,
 4562,
 -45703,
 1299652212,
 4561,
 -1,
 1299710342,
 55256,
 1299926398,
 1299554762,
 -1,
 1299991933,
 1299888702,
 4569,
 -1,
 1299950812,
 55260,
 -1,
 1299965754,
 55259,
 1300188546,
 1299899786,
 -1,
 1300254081,
 1300148849,
 4558,
 -1,
 1300212956,
 4559,
 -1,
 1300213948,
 4532,
 1300450695,
 1300146062,
 -1,
 1300516230,
 1300422769,
 -1,
 -45691,
 1300485710,
 4566,
 -1,
 1300504180,
 55253,
 -1,
 1300478167,
 4531,
 -45688,
 1300378674,
 4557,
 -1,
 1300693382,
 4534,
 1300909482,
 1298376590,
 -1,
 1300975001,
 1300881521,
 -1,
 1301040527,
 1300944462,
 4539,
 1301151743,
 1301001352,
 -1,
 -45682,
 1301028084,
 55277,
 -1,
 1301094004,
 55276,
 1301302673,
 1300962548,
 55245,
 -1,
 1301275733,
 55246,
 1301433747,
 1301232642,
 4560,
 -1,
 1301380672,
 55255,
 -45676,
 1301371896,
 55270,
 -45675,
 1301492786,
 4607,
 -45674,
 1301576799,
 55264,
 -45673,
 1301618292,
 4521,
 -45672,
 1301733659,
 4590,
 -1,
 1301766335,
 55289,
 1302003711,
 1300936919,
 4538,
 1302069247,
 1301918856,
 -1,
 1302089118,
 1301996938,
 -1,
 -45667,
 1302049393,
 4584,
 -1,
 1302114492,
 55281,
 1302285729,
 1302059424,
 -1,
 -45664,
 1302219105,
 4586,
 -1,
 1302307159,
 55278,
 1302482340,
 1302237495,
 -1,
 -45661,
 1302446348,
 4583,
 -1,
 1302498163,
 55275,
 1302678951,
 1302428528,
 -1,
 -45658,
 1302612295,
 55279,
 -1,
 1302662909,
 55280,
 -45656,
 1302608898,
 4585,
 -45655,
 1302821983,
 55274,
 -1,
 1302856070,
 55282,
 1303072193,
 1300879776,
 -1,
 1303137720,
 1303005537,
 4536,
 1303248895,
 1303098504,
 -1,
 1303268783,
 1303172686,
 4537,
 -1,
 1303213391,
 55271,
 1303399857,
 1303198722,
 4579,
 -1,
 1303317757,
 55268,
 1303530932,
 1303346032,
 -1,
 -45645,
 1303464263,
 55272,
 -1,
 1303514877,
 55273,
 -45643,
 1303452916,
 55267,
 -45642,
 1303699161,
 4580,
 -45641,
 1303739487,
 55269,
 -1,
 1303773574,
 4581,
 1303989693,
 1303101454,
 4545,
 1304100863,
 1303950472,
 -1,
 -45637,
 1304005816,
 55291,
 -45636,
 1304090190,
 55290,
 -1,
 1304124408,
 4595,
 1304363007,
 1303945559,
 4587,
 1304428543,
 1304278152,
 -1,
 -45632,
 1304321016,
 55283,
 -1,
 1304381079,
 55284,
 1304579539,
 1303023927,
 -1,
 1304645068,
 1304543500,
 4520,
 1304756223,
 1304605832,
 -1,
 1304776134,
 1304680014,
 4522,
 -1,
 1304749969,
 4548,
 -45625,
 1304706050,
 4547,
 -45624,
 1304845304,
 4603,
 -45623,
 1304900658,
 4602,
 -45622,
 1305006891,
 4605,
 -45621,
 1305018758,
 4606,
 -1,
 1305134116,
 4604,
 1305300434,
 1304570725,
 -1,
 1305365968,
 1305270688,
 -1,
 -45617,
 1305299297,
 4582,
 -1,
 1305395214,
 4596,
 -45615,
 1305295874,
 55261,
 -1,
 1305508959,
 4578,
 -1,
 1305226647,
 4543,
 1305759205,
 1304525919,
 4535,
 1305870335,
 1305719944,
 -1,
 1305890266,
 1305782158,
 -1,
 1305955801,
 1305862257,
 -1,
 -45608,
 1305925198,
 4574,
 -1,
 1305949234,
 55263,
 -1,
 1305917655,
 4573,
 1306217950,
 1305860512,
 -1,
 1306283485,
 1306151265,
 4572,
 -1,
 1306251149,
 55265,
 -1,
 1306239319,
 4575,
 1306480097,
 1306164080,
 -1,
 -45600,
 1306413383,
 55266,
 -1,
 1306463997,
 4576,
 -45598,
 1306409986,
 4571,
 -45597,
 1306604594,
 55262,
 -45596,
 1306664564,
 4570,
 -1,
 1306722694,
 4577,
 1306938866,
 1305732490,
 -1,
 1307004401,
 1306899057,
 4526,
 1307115519,
 1306965128,
 -1,
 1307135466,
 1307039310,
 55248,
 -1,
 1307109265,
 55249,
 1307266541,
 1307081584,
 -1,
 -45588,
 1307199815,
 55250,
 -1,
 1307250429,
 55251,
 -45586,
 1307217080,
 55252,
 -45585,
 1307393026,
 4555,
 -45584,
 1307466744,
 55247,
 -1,
 1307516532,
 4554,
 -1,
 1306964156,
 4544,
 1307790847,
 1306866738,
 4523,
 1307901951,
 1307751560,
 -1,
 1307921911,
 1307829642,
 -1,
 -45578,
 1307882097,
 4550,
 -1,
 1307947196,
 4553,
 1308118522,
 1307868016,
 -1,
 -45575,
 1308051783,
 4524,
 -1,
 1308102397,
 55244,
 -45573,
 1308087886,
 4551,
 -45572,
 1308244994,
 55243,
 -45571,
 1308348504,
 4552,
 -45570,
 1308368500,
 4549,
 -1,
 1308426630,
 4525,
 1308642823,
 1307746762,
 -1,
 1308708358,
 1308616506,
 4592,
 1308819455,
 1308669064,
 -1,
 -45565,
 1308743246,
 4593,
 -45564,
 1308807256,
 4594,
 -45563,
 1308851295,
 55285,
 -1,
 1308885382,
 55286,
 -1,
 1308670526,
 4601,
 1309167117,
 1308557702,
 4546,
 1309278207,
 1309127816,
 -1,
 -45558,
 1309162498,
 4598,
 -45557,
 1309236216,
 4600,
 -45556,
 1309291570,
 4597,
 -1,
 1309375583,
 4599,
 1309560339,
 1309139227,
 4540,
 1309671423,
 1309521032,
 -1,
 1309691410,
 1309577527,
 -1,
 -45551,
 1309655308,
 4588,
 -1,
 1309683095,
 4591,
 -1,
 1309615002,
 4589,
 1309999103,
 1309506416,
 -1,
 1310019096,
 1309886791,
 4541,
 1310130175,
 1309979784,
 -1,
 -45545,
 1310048908,
 55288,
 -1,
 1310088184,
 55287,
 -1,
 1309937405,
 4542,
 1310392319,
 1298295009,
 -1,
 1310412351,
 1310278265,
 -1,
 1310477862,
 1310340961,
 4466,
 1310588927,
 1310438536,
 -1,
 1310608927,
 1310499274,
 4498,
 -1,
 1310563576,
 4497,
 1310740001,
 1310526764,
 4496,
 -1,
 1310694648,
 4495,
 1310871075,
 1310655283,
 4494,
 -1,
 1310788908,
 55223,
 -45532,
 1310799713,
 4499,
 -45531,
 1310956792,
 55224,
 -1,
 1310988445,
 4500,
 1311198769,
 1310432504,
 4461,
 1311309823,
 1311159432,
 -1,
 1311329836,
 1311195769,
 -1,
 1311395371,
 1311245107,
 4484,
 -1,
 1311313196,
 4485,
 -1,
 1311348146,
 4486,
 1311591982,
 1311245107,
 55218,
 -1,
 1311509804,
 55219,
 -45521,
 1311546616,
 4487,
 -45520,
 1311643805,
 4488,
 -1,
 1311741362,
 55220,
 1311919671,
 1311116588,
 4456,
 1312030719,
 1311874296,
 4455,
 1312096255,
 1311945864,
 -1,
 -45515,
 1311976484,
 4517,
 -45514,
 1312044897,
 4478,
 -1,
 1312136440,
 4477,
 1312312893,
 1311834931,
 4451,
 1312378428,
 1312273544,
 -1,
 -45510,
 1312334253,
 4473,
 -45509,
 1312372577,
 4516,
 -1,
 1312464120,
 4472,
 -1,
 1312296236,
 4452,
 1312751615,
 1312233629,
 4468,
 -1,
 1312642067,
 4503,
 1312837200,
 1310333085,
 4469,
 1312948223,
 1312797832,
 -1,
 1312968265,
 1312834169,
 -1,
 1313033797,
 1312883507,
 4505,
 -45500,
 1312951596,
 55230,
 -1,
 1313035269,
 55229,
 1313230407,
 1312951596,
 55232,
 -1,
 1313185016,
 55231,
 -45496,
 1313159009,
 55235,
 -1,
 1313316088,
 55234,
 1313492555,
 1312922872,
 4506,
 -1,
 1313421362,
 55233,
 1313623629,
 1313407795,
 4504,
 -1,
 1313592832,
 4509,
 -45490,
 1313552225,
 4507,
 -45489,
 1313675421,
 55236,
 -1,
 1313773031,
 4508,
 1313951326,
 1312754988,
 4454,
 1314016857,
 1313879905,
 4467,
 1314127871,
 1313977480,
 -1,
 1314147926,
 1314000172,
 55227,
 -45483,
 1314076513,
 4502,
 -1,
 1314168056,
 55226,
 -45481,
 1314076513,
 4501,
 -45480,
 1314299128,
 55228,
 -1,
 1314325299,
 55225,
 1314586623,
 1313971448,
 4453,
 1314652159,
 1314501768,
 -1,
 -45476,
 1314535265,
 4475,
 -45475,
 1314626808,
 4474,
 -1,
 1314690535,
 4476,
 1314868843,
 1313905912,
 4457,
 1314934378,
 1314829448,
 -1,
 1314999909,
 1314865785,
 -1,
 1315065443,
 1314917676,
 4481,
 -1,
 1315020024,
 55216,
 1315241983,
 1314980659,
 4518,
 -1,
 1315114284,
 4519,
 1315327591,
 1314954488,
 4482,
 -1,
 1315256370,
 55217,
 1315458665,
 1315245356,
 4480,
 -1,
 1315413240,
 4479,
 -1,
 1315387233,
 4483,
 -1,
 1314852140,
 4460,
 1315720824,
 1314784051,
 4449,
 1315786355,
 1315689984,
 4510,
 1315897343,
 1315746952,
 -1,
 1315917424,
 1315769644,
 55238,
 -1,
 1315871992,
 4511,
 -45455,
 1315845985,
 4512,
 -45454,
 1315969181,
 4513,
 -1,
 1316029235,
 55237,
 1316245111,
 1315746952,
 -1,
 -45451,
 1316173665,
 4471,
 -45450,
 1316265208,
 4470,
 -1,
 1316328935,
 4515,
 -1,
 1316162860,
 4450,
 1316572801,
 1315649377,
 4462,
 1316683775,
 1316533384,
 -1,
 1316703868,
 1316594122,
 4492,
 -1,
 1316658424,
 55221,
 1316834942,
 1316619059,
 4489,
 -1,
 1316752684,
 4490,
 -45441,
 1316763489,
 4493,
 -45440,
 1316895989,
 55222,
 -1,
 1316975433,
 4491,
 1317162631,
 1316533061,
 -1,
 1317228164,
 1317080364,
 4464,
 -1,
 1317182712,
 4463,
 1317359238,
 1317143347,
 4458,
 -1,
 1317276972,
 4459,
 -1,
 1317279901,
 4465,
 -45432,
 1317118736,
 4514,
 -1,
 1317491161,
 4448,
 1317687091,
 1298245899,
 -1,
 1317752495,
 1317644174,
 -1,
 1317818016,
 1317714135,
 4361,
 1317928959,
 1317778568,
 -1,
 1317949073,
 1317853600,
 -1,
 1318014608,
 1317882209,
 4402,
 -1,
 1317988241,
 4403,
 -1,
 1317978126,
 4410,
 1318211220,
 1317922186,
 -1,
 -45421,
 1318171249,
 4399,
 -1,
 1318236348,
 4409,
 1318407831,
 1318162743,
 -1,
 -45418,
 1318371596,
 4397,
 -1,
 1318399383,
 4408,
 1318604442,
 1318353776,
 -1,
 -45415,
 1318537543,
 4406,
 -1,
 1318588157,
 4407,
 -45413,
 1318526703,
 4404,
 -45412,
 1318730754,
 4400,
 -45411,
 1318794290,
 4398,
 -45410,
 1318878303,
 4401,
 -45409,
 1318969627,
 4405,
 -1,
 1318977926,
 4411,
 1319239679,
 1317789809,
 -1,
 1319259812,
 1319167370,
 -1,
 -45405,
 1319219825,
 4356,
 -1,
 1319284924,
 43385,
 1319456422,
 1319229006,
 4362,
 -1,
 1319429205,
 43381,
 1319587496,
 1319395519,
 4365,
 -1,
 1319546076,
 43384,
 -45399,
 1319506913,
 43388,
 -45398,
 1319648258,
 4377,
 -45397,
 1319721976,
 4360,
 -45396,
 1319777330,
 4372,
 -45395,
 1319837300,
 4353,
 -45394,
 1319952667,
 4423,
 -1,
 1319960966,
 4440,
 1320177357,
 1317722528,
 -1,
 1320242888,
 1320110433,
 4359,
 1320353791,
 1320203400,
 -1,
 1320373948,
 1320265614,
 -1,
 1320439483,
 1320335575,
 4385,
 1320550399,
 1320400008,
 -1,
 1320570552,
 1320478090,
 -1,
 -45385,
 1320530545,
 4387,
 -1,
 1320595644,
 43378,
 -45383,
 1320508408,
 4388,
 -45382,
 1320689268,
 4386,
 -1,
 1320771775,
 4390,
 -1,
 1320401480,
 4389,
 1321029311,
 1320347018,
 -1,
 -45378,
 1320989297,
 4384,
 -1,
 1321054396,
 4393,
 1321225922,
 1320980791,
 -1,
 -45375,
 1321189644,
 4382,
 -1,
 1321217431,
 43379,
 1321422533,
 1321171824,
 -1,
 -45372,
 1321355591,
 4391,
 -1,
 1321406205,
 4392,
 -45370,
 1321393881,
 4394,
 -45369,
 1321546802,
 4383,
 -1,
 1321599366,
 43380,
 1321815756,
 1320206350,
 4369,
 1321926655,
 1321776264,
 -1,
 -45365,
 1321819128,
 4438,
 -1,
 1321861510,
 43386,
 -1,
 1321771351,
 4416,
 1322143463,
 1320123248,
 -1,
 1322208988,
 1322105243,
 -1,
 1322274520,
 1322165236,
 -1,
 1322340053,
 1322231694,
 -1,
 1322405588,
 1322311793,
 -1,
 -45357,
 1322374734,
 4413,
 -1,
 1322410175,
 4431,
 -1,
 1322367191,
 4412,
 1322713087,
 1322285936,
 -1,
 -45353,
 1322600775,
 4430,
 -1,
 1322651389,
 4436,
 1322909695,
 1322229253,
 4366,
 1322975231,
 1322824840,
 -1,
 -45349,
 1322898219,
 4434,
 -1,
 1322910086,
 4435,
 1323126501,
 1322132646,
 -1,
 1323192034,
 1323083662,
 -1,
 1323257569,
 1323163761,
 -1,
 -45344,
 1323226702,
 4415,
 -1,
 1323262143,
 4433,
 -1,
 1323219159,
 4414,
 1323565055,
 1323137904,
 -1,
 -45340,
 1323452743,
 4432,
 -1,
 1323503357,
 4437,
 1323761663,
 1323059527,
 4364,
 -1,
 1323679019,
 4429,
 1323847417,
 1322073090,
 4357,
 1323958271,
 1323807880,
 -1,
 1323978479,
 1323870094,
 -1,
 1324044014,
 1323950193,
 -1,
 -45332,
 1323965684,
 43367,
 -45331,
 1324047352,
 43370,
 -1,
 1324097140,
 43365,
 -1,
 1324005591,
 43372,
 1324371699,
 1323929911,
 -1,
 -45327,
 1324335372,
 43364,
 -45326,
 1324363159,
 43374,
 -1,
 1324452723,
 43371,
 -45324,
 1324293364,
 43366,
 -45323,
 1324571640,
 43369,
 -45322,
 1324626994,
 4376,
 -45321,
 1324711007,
 43368,
 -45320,
 1324745094,
 4378,
 -1,
 1324835007,
 43373,
 1325027082,
 1323819291,
 4363,
 1325137919,
 1324987528,
 -1,
 1325158143,
 1325062560,
 -1,
 -45315,
 1325091169,
 4420,
 -45314,
 1325187086,
 4427,
 -1,
 1325244759,
 4422,
 1325420290,
 1325131146,
 -1,
 -45311,
 1325380209,
 4418,
 -1,
 1325445308,
 4426,
 1325616901,
 1325366128,
 -1,
 -45308,
 1325549895,
 4424,
 -1,
 1325600509,
 4425,
 -45306,
 1325585998,
 4421,
 -45305,
 1325743106,
 43382,
 -45304,
 1325825119,
 4419,
 -45303,
 1325866612,
 4417,
 -1,
 1325924742,
 43383,
 1326141204,
 1325000074,
 -1,
 1326206739,
 1326101105,
 4355,
 1326317567,
 1326167176,
 -1,
 -45298,
 1326241358,
 43362,
 -45297,
 1326267394,
 4446,
 -45296,
 1326341112,
 43361,
 -45295,
 1326414943,
 43360,
 -45294,
 1326456436,
 4375,
 -1,
 1326538943,
 43363,
 -1,
 1326166204,
 4368,
 1326796575,
 1326092599,
 -1,
 1326862108,
 1326721893,
 -1,
 1326927641,
 1326832032,
 -1,
 -45288,
 1326860641,
 4395,
 -1,
 1326956558,
 4439,
 -45286,
 1326891660,
 4396,
 -45285,
 1327053826,
 4379,
 -1,
 1327135839,
 4381,
 1327320862,
 1326825740,
 4352,
 -1,
 1327265103,
 4442,
 -1,
 1327246743,
 4367,
 1327517479,
 1326724146,
 4354,
 1327628287,
 1327477896,
 -1,
 -45278,
 1327504628,
 4373,
 -45277,
 1327617614,
 4443,
 -45276,
 1327651832,
 4374,
 -45275,
 1327701620,
 4371,
 -45274,
 1327759750,
 4445,
 -1,
 1327849663,
 4444,
 1328041773,
 1327463519,
 4358,
 1328152575,
 1328002184,
 -1,
 -45270,
 1328028916,
 43376,
 -45269,
 1328141902,
 43377,
 -45268,
 1328176120,
 4380,
 -1,
 1328225908,
 43375,
 1328434992,
 1327997386,
 -1,
 -45265,
 1328408378,
 4428,
 -1,
 1328462398,
 4441,
 1328631602,
 1328349574,
 4370,
 -1,
 1328598925,
 43387,
 -1,
 1328566745,
 4447,
 1328828328,
 1317610853,
 -1,
 1328893769,
 1328759417,
 -1,
 1328959292,
 1328811308,
 12630,
 1329024826,
 1328932666,
 12673,
 1329135615,
 1328985224,
 -1,
 -45255,
 1329059406,
 12674,
 -1,
 1329123416,
 12675,
 1329332223,
 1328979192,
 12629,
 -1,
 1329256524,
 12678,
 1329418049,
 1328887649,
 12640,
 1329528831,
 1329378440,
 -1,
 1329549120,
 1329439178,
 12683,
 -1,
 1329503480,
 12682,
 -1,
 1329469597,
 12684,
 1329745734,
 1329372408,
 12635,
 1329856511,
 1329706120,
 -1,
 1329876805,
 1329736740,
 12679,
 -1,
 1329794348,
 12680,
 -1,
 1329797277,
 12681,
 1330073416,
 1329660723,
 12625,
 -1,
 1329990956,
 12626,
 -1,
 1329993885,
 12642,
 1330270042,
 1328850830,
 -1,
 1330335571,
 1330241649,
 -1,
 -45236,
 1330257140,
 12600,
 -45235,
 1330370126,
 12614,
 -45234,
 1330404344,
 12611,
 -45233,
 1330459698,
 12645,
 -45232,
 1330519668,
 12594,
 -45231,
 1330635035,
 12672,
 -45230,
 1330643334,
 12677,
 -1,
 1330733247,
 12617,
 1330970623,
 1330297047,
 12613,
 1331036159,
 1330885768,
 -1,
 -45226,
 1330912500,
 12668,
 -45225,
 1330994168,
 12669,
 -45224,
 1331049522,
 12667,
 -45223,
 1331109492,
 12666,
 -1,
 1331191999,
 12670,
 1331384170,
 1330199554,
 12601,
 1331494911,
 1331344520,
 -1,
 1331515233,
 1331419552,
 -1,
 1331580767,
 1331448161,
 12604,
 -1,
 1331548045,
 12651,
 -45216,
 1331544078,
 12607,
 -1,
 1331667287,
 12652,
 1331842916,
 1331488138,
 -1,
 -45213,
 1331802737,
 12650,
 -1,
 1331867836,
 12606,
 1332039526,
 1331764852,
 12602,
 -1,
 1332006797,
 12649,
 -45209,
 1331958753,
 12653,
 -45208,
 1332139598,
 12605,
 -45207,
 1332182111,
 12603,
 -1,
 1332216198,
 12608,
 1332432760,
 1331354016,
 -1,
 1332498294,
 1332365665,
 12610,
 1332609023,
 1332458632,
 -1,
 1332629361,
 1332532814,
 12612,
 1332740095,
 1332589704,
 -1,
 -45200,
 1332616436,
 12661,
 -1,
 1332682356,
 12660,
 1332891508,
 1332602250,
 -1,
 -45197,
 1332851313,
 12659,
 -1,
 1332916412,
 12663,
 -45195,
 1332813428,
 12658,
 -1,
 1333027007,
 12662,
 -45193,
 1332461582,
 12621,
 -1,
 1333174615,
 12671,
 1333350274,
 1332384055,
 -1,
 1333415807,
 1333275493,
 -1,
 1333481341,
 1333385632,
 -1,
 -45188,
 1333414241,
 12664,
 -1,
 1333510158,
 12676,
 -45186,
 1333445260,
 12665,
 -1,
 1333623903,
 12657,
 1333809025,
 1333379340,
 12593,
 -1,
 1333776269,
 12595,
 -1,
 1333734807,
 12619,
 1334005641,
 1333277746,
 12596,
 1334116351,
 1333965960,
 -1,
 -45179,
 1333992692,
 12646,
 -45178,
 1334105678,
 12647,
 -45177,
 1334169688,
 12648,
 -45176,
 1334182278,
 12598,
 -1,
 1334272191,
 12597,
 1334464399,
 1333965637,
 -1,
 1334529932,
 1334381868,
 12638,
 -1,
 1334484216,
 12637,
 1334661006,
 1334444851,
 12632,
 -1,
 1334578476,
 12633,
 -1,
 1334581405,
 12639,
 1334857621,
 1334410335,
 12609,
 1334968319,
 1334817928,
 -1,
 1334988692,
 1334892960,
 -1,
 -45165,
 1334921569,
 12654,
 -1,
 1335009623,
 12656,
 -1,
 1334957646,
 12655,
 1335250841,
 1334772531,
 12623,
 1335316376,
 1335219712,
 12685,
 -1,
 1335233836,
 12686,
 -1,
 1335233836,
 12624,
 1335512988,
 1335168300,
 12628,
 -45157,
 1335441249,
 12641,
 -1,
 1335532792,
 12627,
 1335709599,
 1335485834,
 -1,
 -45154,
 1335669361,
 12599,
 -1,
 1335734460,
 12620,
 1335906209,
 1335663864,
 12631,
 -1,
 1335823660,
 12634,
 1336037283,
 1335826589,
 12643,
 -1,
 1335992578,
 12615,
 1336168358,
 1335982960,
 -1,
 -45147,
 1336101191,
 12616,
 -1,
 1336151805,
 12618,
 -45145,
 1336096609,
 12636,
 -1,
 1336279430,
 12622,
 -45143,
 1328753797,
 12334,
 -45142,
 1336431065,
 12644,
 -1,
 1336492249,
 12335,
 1336737791,
 1298193110,
 -1,
 1336758196,
 1336665482,
 -1,
 1336823728,
 1336718149,
 -1,
 -45137,
 1336777976,
 12322,
 -1,
 1336849727,
 12345,
 1337020339,
 1336787858,
 -1,
 -45134,
 1336956499,
 12323,
 -1,
 1337046586,
 12346,
 -1,
 1336972725,
 12344,
 1337282487,
 1336715150,
 -1,
 -45130,
 1337247083,
 12326,
 -1,
 1337277054,
 12327,
 1337479098,
 1337215047,
 -1,
 -45127,
 1337430514,
 12324,
 -1,
 1337468930,
 12325,
 -45125,
 1337438520,
 12321,
 -45124,
 1337602614,
 12329,
 -1,
 1337704650,
 12328,
 1337917439,
 1298123824,
 -1,
 1337937874,
 1337795941,
 -1,
 1338003394,
 1337875752,
 -1,
 -45119,
 1337962131,
 5925,
 -1,
 1337983795,
 5928,
 -45117,
 1337928740,
 5932,
 -45116,
 1338149098,
 5935,
 -45115,
 1338193761,
 5922,
 -45114,
 1338270178,
 5926,
 -45113,
 1338332844,
 5936,
 -45112,
 1338395049,
 5933,
 -45111,
 1338461560,
 5929,
 -45110,
 1338511270,
 5931,
 -45109,
 1338573566,
 5934,
 -45108,
 1338695631,
 5923,
 -45107,
 1338710173,
 5921,
 -45106,
 1338816947,
 5937,
 -45105,
 1338879635,
 5924,
 -45104,
 1338935312,
 5927,
 -45103,
 1339019777,
 5930,
 -1,
 1339032371,
 5920,
 1339248597,
 1337887797,
 -1,
 -45100,
 1339176801,
 5939,
 -1,
 1339234461,
 5938,
 -1,
 1339167385,
 5940,
 1339510894,
 1298060935,
 -1,
 1339576351,
 1339452115,
 -1,
 1339641886,
 1339511849,
 -1,
 1339707419,
 1339565413,
 -1,
 1339772907,
 1339664270,
 -1,
 1339838438,
 1339693962,
 -1,
 1339903968,
 1339769465,
 -1,
 -45090,
 1339832161,
 65389,
 -45089,
 1339923704,
 65390,
 -1,
 1339949875,
 65388,
 -45087,
 1339832161,
 65385,
 -45086,
 1340105135,
 65391,
 -45085,
 1340185848,
 65387,
 -45084,
 1340217501,
 65384,
 -45083,
 1340280108,
 65386,
 -1,
 1340343091,
 65383,
 -45081,
 1339766625,
 65405,
 -45080,
 1340513528,
 65407,
 -45079,
 1340545181,
 65404,
 -45078,
 1340607788,
 65406,
 -1,
 1340670771,
 65403,
 1340887025,
 1339710760,
 65437,
 -45075,
 1340815201,
 65415,
 -45074,
 1340906744,
 65417,
 -45073,
 1340938397,
 65414,
 -45072,
 1341001004,
 65416,
 -1,
 1341063987,
 65413,
 1341280247,
 1340859786,
 -1,
 -45069,
 1341208417,
 65410,
 -45068,
 1341299960,
 65412,
 -45067,
 1341331613,
 65409,
 -45066,
 1341394220,
 65411,
 -1,
 1341457203,
 65408,
 1341673469,
 1341240583,
 -1,
 -45063,
 1341601633,
 65433,
 -45062,
 1341693176,
 65435,
 -45061,
 1341724829,
 65432,
 -45060,
 1341787436,
 65434,
 -1,
 1341850419,
 65431,
 1342066691,
 1341596244,
 -1,
 -45057,
 1341994849,
 65425,
 -45056,
 1342086392,
 65427,
 -45055,
 1342118045,
 65424,
 -45054,
 1342180652,
 65426,
 -1,
 1342243635,
 65423,
 1342459913,
 1342017847,
 -1,
 -45051,
 1342388065,
 65400,
 -45050,
 1342479608,
 65402,
 -45049,
 1342511261,
 65399,
 -45048,
 1342573868,
 65401,
 -1,
 1342636851,
 65398,
 1342853135,
 1342423954,
 -1,
 -45045,
 1342781281,
 65420,
 -45044,
 1342872824,
 65422,
 -45043,
 1342904477,
 65419,
 -45042,
 1342967084,
 65421,
 -1,
 1343030067,
 65418,
 1343246355,
 1342784121,
 -1,
 -45039,
 1343174497,
 65429,
 -45038,
 1343266040,
 65430,
 -1,
 1343292211,
 65428,
 1343508502,
 1343206213,
 -1,
 -45035,
 1343462648,
 65382,
 -1,
 1343488819,
 65436,
 -45033,
 1343436641,
 65395,
 -45032,
 1343659256,
 65397,
 -45031,
 1343690909,
 65394,
 -45030,
 1343753516,
 65396,
 -1,
 1343816499,
 65393,
 -45028,
 1339622996,
 65438,
 -45027,
 1343963709,
 65439,
 -1,
 1344041950,
 65381,
 -1,
 1339578656,
 65392,
 1344295008,
 1339511325,
 -1,
 1344360543,
 1344218469,
 -1,
 1344426027,
 1344289794,
 65449,
 1344536575,
 1344386184,
 -1,
 1344557094,
 1344461216,
 -1,
 -45019,
 1344489825,
 65452,
 -1,
 1344585742,
 65455,
 -45017,
 1344507064,
 65454,
 -45016,
 1344722510,
 65453,
 -45015,
 1344765023,
 65451,
 -45014,
 1344806516,
 65450,
 -1,
 1344864646,
 65456,
 1345081395,
 1344356985,
 -1,
 1345146926,
 1344998700,
 65483,
 -1,
 1345101048,
 65482,
 1345278000,
 1345061683,
 65476,
 -1,
 1345195308,
 65477,
 -45007,
 1345206113,
 65495,
 -45006,
 1345363192,
 65490,
 -1,
 1345394845,
 65499,
 1345605691,
 1345038222,
 -1,
 1345671226,
 1345577073,
 -1,
 -45002,
 1345592564,
 65448,
 -45001,
 1345705550,
 65462,
 -45000,
 1345739768,
 65459,
 -44999,
 1345789556,
 65442,
 -1,
 1345872063,
 65465,
 -1,
 1345632471,
 65461,
 1346129985,
 1345565509,
 -1,
 1346195518,
 1346047276,
 65493,
 -1,
 1346149624,
 65492,
 1346326592,
 1346110259,
 65485,
 -1,
 1346243884,
 65486,
 -1,
 1346246813,
 65494,
 1346523205,
 1346099616,
 -1,
 1346588740,
 1346455905,
 65458,
 -1,
 1346555789,
 65460,
 -1,
 1346551822,
 65469,
 1346785353,
 1346450482,
 65444,
 1346895871,
 1346745480,
 -1,
 -44984,
 1346765190,
 65446,
 -1,
 1346855103,
 65445,
 1347047501,
 1346736439,
 -1,
 1347113036,
 1347010828,
 65441,
 -1,
 1347080077,
 65443,
 -1,
 1347038615,
 65467,
 1347309648,
 1346964780,
 65479,
 -44977,
 1347237729,
 65498,
 -1,
 1347329272,
 65478,
 1347506259,
 1347282314,
 -1,
 -44974,
 1347465841,
 65447,
 -1,
 1347530940,
 65468,
 1347702869,
 1347460344,
 65484,
 -1,
 1347620140,
 65487,
 1347833943,
 1347623069,
 65500,
 -1,
 1347789058,
 65463,
 1347965018,
 1347779440,
 -1,
 -44967,
 1347897671,
 65464,
 -1,
 1347948285,
 65466,
 1348161628,
 1347879731,
 65474,
 -1,
 1348078892,
 65475,
 -44963,
 1348089697,
 65491,
 -44962,
 1348238431,
 65457,
 -1,
 1348272518,
 65470,
 -1,
 1344295385,
 65440,
 1348554851,
 1344251497,
 -1,
 -44958,
 1348496317,
 65515,
 -1,
 1348589377,
 65379,
 1348751462,
 1348490843,
 -1,
 -44955,
 1348692925,
 65513,
 -1,
 1348785985,
 65378,
 1348948073,
 1348718192,
 -1,
 -44952,
 1348863511,
 65377,
 -1,
 1348969975,
 65380,
 -44950,
 1348890504,
 65518,
 -44949,
 1349088930,
 65514,
 -44948,
 1349178395,
 65512,
 -44947,
 1349241416,
 65516,
 -1,
 1349263571,
 65517,
 1349472369,
 1339426350,
 -1,
 -44944,
 1349421800,
 9773,
 -1,
 1349509446,
 9874,
 -1,
 1349429906,
 8202,
 1349734872,
 1297943852,
 -1,
 1349800230,
 1349653822,
 -1,
 1349865684,
 1349766799,
 -1,
 1349931212,
 1349820752,
 -1,
 1349996671,
 1349892349,
 -1,
 -44936,
 1349950615,
 64296,
 -44935,
 1350033212,
 64295,
 -44934,
 1350078442,
 64293,
 -44933,
 1350111837,
 64292,
 -44932,
 1350220214,
 64291,
 -44931,
 1350258347,
 64294,
 -44930,
 1350307176,
 64290,
 -1,
 1350379230,
 64289,
 1350586507,
 1349953422,
 -1,
 1350652041,
 1350526392,
 1513,
 1350762495,
 1350583583,
 -1,
 1350783110,
 1350651716,
 64329,
 1350893567,
 1350697602,
 -1,
 -44923,
 1350791685,
 64301,
 -1,
 1350870681,
 64300,
 1351090175,
 1350739854,
 -1,
 -44920,
 1350988293,
 64299,
 -1,
 1351067289,
 64298,
 1351286783,
 1350590309,
 1505,
 -1,
 1351172928,
 64321,
 1351372947,
 1350540140,
 -1,
 1351438478,
 1351299648,
 1507,
 -1,
 1351369536,
 64323,
 1351569552,
 1351357021,
 1498,
 -1,
 1351500608,
 64314,
 -44911,
 1351527352,
 1509,
 -44910,
 1351660440,
 1503,
 -1,
 1351690620,
 1501,
 1351897246,
 1351287603,
 -1,
 1351962781,
 1351863951,
 -1,
 1352028314,
 1351914951,
 1488,
 1352138751,
 1351959839,
 -1,
 -44904,
 1352063045,
 64303,
 -44903,
 1352102458,
 64302,
 -1,
 1352177507,
 64304,
 1352400895,
 1351946517,
 -1,
 -44900,
 1352321897,
 64297,
 -1,
 1352375568,
 64288,
 -1,
 1351929003,
 1506,
 1352618149,
 1351869834,
 -1,
 1352683681,
 1352536385,
 1510,
 -1,
 1352614720,
 64326,
 1352814755,
 1352635882,
 1496,
 -1,
 1352745792,
 64312,
 1352990719,
 1352753697,
 1514,
 -1,
 1352876864,
 64330,
 1353076905,
 1352586630,
 1497,
 1353187327,
 1353008415,
 -1,
 -44888,
 1353110381,
 64285,
 -1,
 1353142084,
 64313,
 1353339053,
 1353013193,
 1493,
 1353449471,
 1353270559,
 -1,
 -44884,
 1353377106,
 64331,
 -1,
 1353404228,
 64309,
 1353601201,
 1353265728,
 1508,
 1353711615,
 1353532703,
 -1,
 -44880,
 1353608610,
 64334,
 -1,
 1353666372,
 64324,
 1353863349,
 1353519709,
 1499,
 1353973759,
 1353794847,
 -1,
 -44876,
 1353870754,
 64333,
 -1,
 1353928516,
 64315,
 1354125496,
 1353824694,
 1492,
 -44873,
 1354098058,
 1495,
 -1,
 1354138437,
 64308,
 1354322108,
 1354039580,
 1489,
 1354432511,
 1354253599,
 -1,
 -44869,
 1354329506,
 64332,
 -1,
 1354387268,
 64305,
 1354584254,
 1354275327,
 1494,
 -1,
 1354515264,
 64310,
 1354715328,
 1354555196,
 1512,
 -1,
 1354646336,
 64328,
 1354846402,
 1354674961,
 1511,
 -1,
 1354777408,
 64327,
 1354977476,
 1354806168,
 1504,
 -1,
 1354908480,
 64320,
 1355108550,
 1354901884,
 1502,
 -1,
 1355039552,
 64318,
 1355239624,
 1355059178,
 1500,
 -1,
 1355170624,
 64316,
 1355370698,
 1355202856,
 1490,
 -1,
 1355301696,
 64306,
 1355546623,
 1355287912,
 1491,
 -1,
 1355432768,
 64307,
 1355677695,
 1349861734,
 -1,
 1355698387,
 1355567590,
 -1,
 1355763921,
 1355635943,
 -1,
 -44848,
 1355732358,
 1522,
 -1,
 1355765705,
 1520,
 -44846,
 1355696325,
 64287,
 -1,
 1355879100,
 1521,
 -1,
 1355637707,
 64335,
 1356157184,
 1349797176,
 -1,
 1356222684,
 1356103627,
 -1,
 1356288219,
 1356137267,
 -1,
 1356353754,
 1356209429,
 -1,
 -44839,
 1356311206,
 1428,
 -1,
 1356368790,
 1429,
 -1,
 1356277463,
 1432,
 -1,
 1356211964,
 1454,
 1356681443,
 1356195210,
 -1,
 1356746978,
 1356598572,
 -1,
 1356812513,
 1356685287,
 -1,
 -44832,
 1356767014,
 1449,
 -1,
 1356824066,
 1440,
 -1,
 1356738127,
 1435,
 -1,
 1356679651,
 1430,
 1357140200,
 1356603988,
 -1,
 1357205734,
 1357106494,
 1445,
 -1,
 1357161198,
 1446,
 -44825,
 1357153628,
 1443,
 -1,
 1357268842,
 1444,
 1357467884,
 1357093057,
 -1,
 1357533419,
 1357429730,
 1436,
 -1,
 1357452712,
 1437,
 -1,
 1357489695,
 1438,
 1357730031,
 1357423050,
 -1,
 -44818,
 1357672046,
 1434,
 -1,
 1357749320,
 1450,
 1357926642,
 1357686670,
 -1,
 -44815,
 1357885243,
 1427,
 -1,
 1357921193,
 1426,
 1358123253,
 1357856473,
 -1,
 -44812,
 1358073986,
 1439,
 -1,
 1358104527,
 1448,
 1358319864,
 1358056824,
 -1,
 -44809,
 1358253158,
 1441,
 -1,
 1358324483,
 1433,
 1358516475,
 1358280955,
 -1,
 -44806,
 1358485934,
 1453,
 -1,
 1358539531,
 1447,
 -44804,
 1358436915,
 1431,
 -44803,
 1358669835,
 1451,
 -44802,
 1358741981,
 1452,
 -44801,
 1358808185,
 1425,
 -1,
 1358836211,
 1442,
 1359040802,
 1356126624,
 -1,
 1359106330,
 1358982994,
 -1,
 1359171850,
 1359070098,
 -1,
 1359237383,
 1359132703,
 -1,
 -44795,
 1359186753,
 1457,
 -44794,
 1359272005,
 1459,
 -1,
 1359311418,
 1458,
 1359499529,
 1359167078,
 1465,
 -1,
 1359465808,
 1466,
 -1,
 1359443269,
 1460,
 1359696144,
 1359128462,
 -1,
 1359761678,
 1359659922,
 -1,
 -44787,
 1359704581,
 1473,
 -1,
 1359774645,
 1456,
 -44785,
 1359704581,
 1474,
 -1,
 1359887273,
 1462,
 1360089364,
 1359621437,
 -1,
 1360154899,
 1360030580,
 1464,
 -1,
 1360118942,
 1479,
 -1,
 1360113166,
 1467,
 -44779,
 1360040695,
 1461,
 -44778,
 1360293282,
 1471,
 -44777,
 1360359994,
 1463,
 -44776,
 1360409656,
 1469,
 -44775,
 1360470260,
 64286,
 -1,
 1360529684,
 1468,
 1360789503,
 1359065170,
 -1,
 1360810270,
 1360697537,
 -1,
 -44771,
 1360766495,
 1524,
 -1,
 1360837602,
 1523,
 -44769,
 1360776971,
 1475,
 -44768,
 1360950790,
 1472,
 -44767,
 1360992283,
 1478,
 -1,
 1361077262,
 1470,
 1361313791,
 1358967511,
 -1,
 -44764,
 1361186445,
 1476,
 -44763,
 1361302142,
 1455,
 -1,
 1361317663,
 1477,
 1361531269,
 1349763735,
 -1,
 1361596732,
 1361503626,
 -1,
 1361662267,
 1361569574,
 -1,
 1361727789,
 1361607536,
 -1,
 -44757,
 1361654731,
 19904,
 -44756,
 1361761211,
 19933,
 -1,
 1361805047,
 19953,
 1361989938,
 1361642291,
 -1,
 1362055473,
 1361949959,
 -1,
 -44752,
 1362003903,
 19954,
 -1,
 1362038738,
 19910,
 -1,
 1361989883,
 19932,
 1362317621,
 1361949509,
 -1,
 -44748,
 1362282783,
 19951,
 -1,
 1362336999,
 19959,
 -44746,
 1362284435,
 19905,
 -44745,
 1362428222,
 19957,
 -44744,
 1362513856,
 19955,
 -44743,
 1362612553,
 19961,
 -44742,
 1362668495,
 19960,
 -1,
 1362748457,
 19940,
 -1,
 1361612187,
 19913,
 1362972998,
 1361557755,
 -1,
 1363038529,
 1362890028,
 -1,
 -44737,
 1363003490,
 19956,
 -44736,
 1363030792,
 19943,
 -1,
 1363087046,
 19944,
 1363300676,
 1362958493,
 -1,
 -44733,
 1363222649,
 19962,
 -1,
 1363290192,
 19906,
 -44731,
 1363259682,
 19935,
 -1,
 1363462841,
 19939,
 1363628369,
 1362921165,
 -1,
 1363693904,
 1363588359,
 -1,
 1363759439,
 1363637948,
 -1,
 1363824974,
 1363728800,
 -1,
 1363890509,
 1363778808,
 -1,
 -44724,
 1363850638,
 19937,
 -1,
 1363878724,
 19917,
 -1,
 1363811546,
 19931,
 -1,
 1363795422,
 19929,
 -1,
 1363683467,
 19925,
 -1,
 1363642281,
 19948,
 1364349271,
 1363584910,
 -1,
 1364414805,
 1364269962,
 -1,
 -44716,
 1364385246,
 19912,
 -1,
 1364402867,
 19965,
 -44714,
 1364372980,
 19915,
 -1,
 1364555585,
 19926,
 1364742493,
 1364313510,
 -1,
 1364808027,
 1364679976,
 -1,
 -44710,
 1364731288,
 19928,
 -1,
 1364791404,
 19964,
 -44708,
 1364744094,
 19934,
 -1,
 1364922054,
 19945,
 1365135714,
 1364674982,
 -1,
 1365201249,
 1365108106,
 -1,
 -44704,
 1365122979,
 19927,
 -1,
 1365184558,
 19936,
 -1,
 1365124916,
 19952,
 1365463398,
 1365105056,
 -1,
 -44700,
 1365388670,
 19949,
 -44699,
 1365484736,
 19938,
 -1,
 1365546762,
 19914,
 1365725547,
 1365417208,
 -1,
 1365791082,
 1365651977,
 -1,
 -44695,
 1365757894,
 19950,
 -1,
 1365815070,
 19941,
 -1,
 1365735153,
 19942,
 1366053232,
 1365670986,
 -1,
 1366118767,
 1365990696,
 -1,
 -44690,
 1366033536,
 19923,
 -1,
 1366114837,
 19909,
 -1,
 1366056577,
 19947,
 1366380916,
 1365982656,
 -1,
 -44686,
 1366297277,
 19946,
 -44685,
 1366414149,
 19924,
 -1,
 1366464149,
 19967,
 1366643064,
 1366295347,
 -1,
 -44682,
 1366604402,
 19922,
 -44681,
 1366638459,
 19966,
 -1,
 1366700955,
 19958,
 1366905211,
 1366602565,
 -1,
 -44678,
 1366845718,
 19921,
 -1,
 1366942401,
 19908,
 1367101822,
 1366822831,
 -1,
 -44675,
 1367022462,
 19930,
 -1,
 1367131000,
 19918,
 1367298433,
 1367033927,
 -1,
 -44672,
 1367239290,
 19920,
 -1,
 1367291498,
 19916,
 -44670,
 1367256876,
 19907,
 -44669,
 1367425391,
 19963,
 -44668,
 1367502266,
 19911,
 -1,
 1367545423,
 19919,
 1367757268,
 1361445683,
 -1,
 1367822803,
 1367699278,
 -1,
 1367888273,
 1367767920,
 -1,
 1367953805,
 1367850057,
 11096,
 1368019340,
 1367885087,
 -1,
 -44661,
 1367944462,
 9955,
 -1,
 1368014078,
 11095,
 -1,
 1367983247,
 11097,
 1368281488,
 1367914934,
 -1,
 -44657,
 1368216877,
 10054,
 -1,
 1368264252,
 10004,
 -1,
 1368243174,
 10152,
 1368543645,
 1367817664,
 -1,
 1368609180,
 1368499893,
 -1,
 1368674711,
 1368567477,
 -1,
 -44651,
 1368616690,
 10167,
 -44650,
 1368710271,
 10168,
 -1,
 1368771443,
 10169,
 1368981503,
 1368609833,
 -1,
 1369002395,
 1368894932,
 -1,
 -44646,
 1368926259,
 10150,
 -1,
 1369016988,
 10149,
 -1,
 1368927245,
 10084,
 -1,
 1368531495,
 10008,
 1369330084,
 1368515978,
 -1,
 1369395619,
 1369268394,
 -1,
 1369461154,
 1369346455,
 -1,
 -44639,
 1369431486,
 10051,
 -1,
 1369473393,
 10045,
 -1,
 1369385303,
 10171,
 -1,
 1369355034,
 10142,
 1369788842,
 1369286542,
 -1,
 1369854376,
 1369759979,
 -1,
 -44633,
 1369791832,
 10075,
 -1,
 1369889556,
 10076,
 -44631,
 1369775875,
 10056,
 -1,
 1369965436,
 10136,
 1370182065,
 1369748743,
 -1,
 1370247600,
 1370137150,
 -1,
 1370313135,
 1370184261,
 -1,
 -44626,
 1370244062,
 10095,
 -1,
 1370327212,
 10097,
 -1,
 1370254269,
 10137,
 -1,
 1370193489,
 10140,
 1370640823,
 1370148495,
 -1,
 1370706357,
 1370563462,
 -1,
 -44620,
 1370637278,
 10094,
 -1,
 1370720428,
 10096,
 -44618,
 1370652891,
 10157,
 -1,
 1370852370,
 11093,
 1371034046,
 1370557740,
 -1,
 1371099579,
 1370967178,
 -1,
 -44614,
 1371066318,
 10071,
 -1,
 1371127431,
 10082,
 1371340799,
 1371071386,
 -1,
 -44611,
 1371256475,
 10059,
 -1,
 1371316360,
 10040,
 1371492802,
 1370993477,
 -1,
 -44608,
 1371444969,
 10132,
 -44607,
 1371473464,
 9947,
 -1,
 1371571181,
 10173,
 1371754950,
 1371446520,
 -1,
 -44604,
 1371705617,
 11094,
 -44603,
 1371741245,
 10030,
 -1,
 1371839981,
 10012,
 1372017099,
 1371715835,
 -1,
 1372082634,
 1371980622,
 -1,
 -44599,
 1372020056,
 10077,
 -1,
 1372117780,
 10078,
 -1,
 1372033946,
 10144,
 -44596,
 1371940135,
 10074,
 -44595,
 1372270232,
 10158,
 -44594,
 1372375923,
 10138,
 -44593,
 1372418821,
 10006,
 -44592,
 1372482593,
 10083,
 -44591,
 1372562140,
 10010,
 -44590,
 1372614594,
 10020,
 -1,
 1372684657,
 10033,
 -1,
 1367770436,
 9980,
 1372934615,
 1367671559,
 -1,
 -44586,
 1372905003,
 9937,
 -1,
 1372941456,
 9096,
 -1,
 1372894922,
 8889,
 1373196870,
 1349654685,
 -1,
 1373262404,
 1373136443,
 -1,
 1373327937,
 1373185381,
 -1,
 1373393392,
 1373284238,
 -1,
 1373458923,
 1373313930,
 -1,
 1373524449,
 1373389433,
 -1,
 -44577,
 1373452129,
 12421,
 -44576,
 1373543672,
 12423,
 -1,
 1373569843,
 12419,
 1373786596,
 1373475127,
 -1,
 -44573,
 1373703468,
 12438,
 -1,
 1373766451,
 12437,
 -44571,
 1373735146,
 12430,
 -44570,
 1373910881,
 12357,
 -44569,
 1373987247,
 12387,
 -44568,
 1374067960,
 12361,
 -44567,
 1374099613,
 12355,
 -44566,
 1374162220,
 12359,
 -1,
 1374225203,
 12353,
 -44564,
 1373386593,
 12377,
 -44563,
 1374395640,
 12381,
 -44562,
 1374427293,
 12375,
 -44561,
 1374489900,
 12379,
 -1,
 1374552883,
 12373,
 1374769654,
 1373330728,
 12435,
 -44558,
 1374697313,
 12396,
 -44557,
 1374788856,
 12398,
 -44556,
 1374820509,
 12395,
 -44555,
 1374883116,
 12397,
 -1,
 1374946099,
 12394,
 1375162876,
 1374715851,
 -1,
 -44552,
 1375090529,
 12378,
 -44551,
 1375182072,
 12382,
 -44550,
 1375213725,
 12376,
 -44549,
 1375276332,
 12380,
 -1,
 1375339315,
 12374,
 1375556098,
 1375135114,
 -1,
 -44546,
 1375483745,
 12388,
 -44545,
 1375575288,
 12392,
 -44544,
 1375606941,
 12385,
 -44543,
 1375669548,
 12390,
 -1,
 1375732531,
 12383,
 1375949320,
 1375515911,
 -1,
 -44540,
 1375876961,
 12427,
 -44539,
 1375968504,
 12429,
 -44538,
 1376000157,
 12426,
 -44537,
 1376062764,
 12428,
 -1,
 1376125747,
 12425,
 1376342542,
 1375918496,
 -1,
 -44534,
 1376270177,
 12407,
 -44533,
 1376361720,
 12413,
 -44532,
 1376393373,
 12404,
 -44531,
 1376455980,
 12410,
 -1,
 1376518963,
 12401,
 1376735764,
 1376264788,
 -1,
 -44528,
 1376663393,
 12416,
 -44527,
 1376754936,
 12418,
 -44526,
 1376786589,
 12415,
 -44525,
 1376849196,
 12417,
 -1,
 1376912179,
 12414,
 1377128986,
 1376686391,
 -1,
 -44522,
 1377056609,
 12367,
 -44521,
 1377148152,
 12371,
 -44520,
 1377179805,
 12365,
 -44519,
 1377242412,
 12369,
 -1,
 1377305395,
 12363,
 1377522208,
 1377092498,
 -1,
 -44516,
 1377449825,
 12405,
 -44515,
 1377541368,
 12411,
 -44514,
 1377573021,
 12402,
 -44513,
 1377635628,
 12408,
 -1,
 1377698611,
 12399,
 1377915430,
 1377470157,
 -1,
 -44510,
 1377843041,
 12368,
 -44509,
 1377934584,
 12372,
 -44508,
 1377966237,
 12366,
 -44507,
 1378028844,
 12370,
 -1,
 1378091827,
 12364,
 1378308652,
 1377876219,
 -1,
 -44504,
 1378236257,
 12389,
 -44503,
 1378327800,
 12393,
 -44502,
 1378359453,
 12386,
 -44501,
 1378422060,
 12391,
 -1,
 1378485043,
 12384,
 1378701874,
 1378237888,
 -1,
 -44498,
 1378629473,
 12406,
 -44497,
 1378721016,
 12412,
 -44496,
 1378752669,
 12403,
 -44495,
 1378815276,
 12409,
 -1,
 1378878259,
 12400,
 1379095095,
 1378661189,
 -1,
 -44492,
 1379048696,
 12434,
 -44491,
 1379080349,
 12432,
 -44490,
 1379142956,
 12433,
 -1,
 1379205939,
 12431,
 1379422779,
 1379025529,
 -1,
 -44487,
 1379350369,
 12422,
 -44486,
 1379441912,
 12424,
 -1,
 1379468083,
 12420,
 -44484,
 1379368240,
 12436,
 -44483,
 1379612513,
 12358,
 -44482,
 1379704056,
 12362,
 -44481,
 1379735709,
 12356,
 -44480,
 1379798316,
 12360,
 -1,
 1379861299,
 12354,
 -44478,
 1373289271,
 12446,
 -44477,
 1380028899,
 12445,
 -1,
 1380075446,
 12447,
 -44475,
 1373221040,
 9964,
 -1,
 1380238776,
 9889,
 1380405850,
 1373150456,
 -1,
 1380471379,
 1380324933,
 -1,
 1380536909,
 1380406123,
 -1,
 -44470,
 1380504836,
 9149,
 -44469,
 1380538498,
 9148,
 -44468,
 1380601453,
 9147,
 -1,
 1380695720,
 9146,
 1380864592,
 1380466112,
 -1,
 -44465,
 1380801325,
 11043,
 -1,
 1380868629,
 8213,
 -44463,
 1380831748,
 9897,
 -44462,
 1381028118,
 9135,
 -1,
 1381080080,
 8230,
 1381257814,
 1380398945,
 -1,
 -44459,
 1381193391,
 8962,
 -1,
 1381247698,
 8987,
 1381454425,
 1381196375,
 -1,
 -44456,
 1381390476,
 9832,
 -1,
 1381438620,
 9749,
 -1,
 1381380863,
 8763,
 1381716580,
 1380336249,
 -1,
 1381782115,
 1381685664,
 -1,
 1381847650,
 1381734942,
 8208,
 1381913184,
 1381782569,
 -1,
 -44449,
 1381832009,
 11802,
 -1,
 1381931092,
 8259,
 -44447,
 1381847200,
 8231,
 -1,
 1382078328,
 45,
 -1,
 1381800106,
 11794,
 -1,
 1381710078,
 9102,
 -1,
 1381633983,
 8372,
 1382438738,
 1297909453,
 -1,
 1382503716,
 1382397191,
 -1,
 1382569251,
 1382419756,
 -1,
 1382634745,
 1382504087,
 -1,
 1382699849,
 1382590350,
 -1,
 1382765379,
 1382620042,
 -1,
 1382830911,
 1382688101,
 -1,
 1382896279,
 1382753947,
 -1,
 1382961802,
 1382835795,
 969,
 1383071743,
 1382892831,
 -1,
 1383092859,
 1382996384,
 -1,
 1383158393,
 1383027291,
 8032,
 1383268351,
 1383076285,
 -1,
 1383289460,
 1383140191,
 8034,
 -1,
 1383253562,
 8098,
 1383420534,
 1383253640,
 8038,
 -1,
 1383384634,
 8102,
 1383551608,
 1383334999,
 8036,
 -1,
 1383515706,
 8100,
 -1,
 1383465070,
 8096,
 1383792639,
 1383129000,
 8182,
 -1,
 1383712314,
 8183,
 1383879300,
 1383018989,
 8033,
 1383989247,
 1383797181,
 -1,
 1384010367,
 1383861087,
 8035,
 -1,
 1383974458,
 8099,
 1384141441,
 1383974536,
 8039,
 -1,
 1384105530,
 8103,
 1384272515,
 1384055895,
 8037,
 -1,
 1384236602,
 8101,
 -1,
 1384185966,
 8097,
 1384469126,
 1383795551,
 8060,
 -1,
 1384433210,
 8178,
 1384600200,
 1384383575,
 8061,
 -1,
 1384564282,
 8180,
 -44407,
 1384513646,
 8179,
 -1,
 1384678152,
 974,
 1384906751,
 1382905026,
 959,
 1384972287,
 1384793375,
 -1,
 1384993424,
 1384858888,
 8000,
 1385103359,
 1384911293,
 -1,
 -44401,
 1384975199,
 8002,
 -1,
 1385038935,
 8004,
 1385255572,
 1384919533,
 8001,
 1385365503,
 1385173437,
 -1,
 -44397,
 1385237343,
 8003,
 -1,
 1385301079,
 8005,
 -44395,
 1385171807,
 8056,
 -44394,
 1385464584,
 972,
 -1,
 1385497687,
 8057,
 1385714370,
 1382812972,
 -1,
 1385779893,
 1385652706,
 951,
 1385889791,
 1385710879,
 -1,
 1385910950,
 1385814432,
 -1,
 1385976484,
 1385845339,
 7968,
 1386086399,
 1385894333,
 -1,
 1386107551,
 1385958239,
 7970,
 -1,
 1386071610,
 8082,
 1386238625,
 1386071688,
 7974,
 -1,
 1386202682,
 8086,
 1386369699,
 1386153047,
 7972,
 -1,
 1386333754,
 8084,
 -1,
 1386283118,
 8080,
 1386610687,
 1385947048,
 8134,
 -1,
 1386530362,
 8135,
 1386697391,
 1385837037,
 7969,
 1386807295,
 1386615229,
 -1,
 1386828458,
 1386679135,
 7971,
 -1,
 1386792506,
 8083,
 1386959532,
 1386792584,
 7975,
 -1,
 1386923578,
 8087,
 1387090606,
 1386873943,
 7973,
 -1,
 1387054650,
 8085,
 -1,
 1387004014,
 8081,
 1387287217,
 1386613599,
 8052,
 -1,
 1387251258,
 8130,
 1387418291,
 1387201623,
 8053,
 -1,
 1387382330,
 8132,
 -44364,
 1387331694,
 8131,
 -1,
 1387496200,
 942,
 1387724799,
 1385714272,
 949,
 1387790335,
 1387611423,
 -1,
 1387811515,
 1387676936,
 7952,
 1387921407,
 1387729341,
 -1,
 -44358,
 1387793247,
 7954,
 -1,
 1387856983,
 7956,
 1388073663,
 1387737581,
 7953,
 1388183551,
 1387991485,
 -1,
 -44354,
 1388055391,
 7955,
 -1,
 1388119127,
 7957,
 -44352,
 1387989855,
 8050,
 -44351,
 1388282632,
 941,
 -1,
 1388315735,
 8051,
 1388532454,
 1385628467,
 -1,
 1388597987,
 1388477949,
 945,
 1388707839,
 1388528927,
 -1,
 1388729041,
 1388632480,
 -1,
 1388794575,
 1388663387,
 7936,
 1388904447,
 1388712381,
 -1,
 1388925642,
 1388776287,
 7938,
 -1,
 1388889658,
 8066,
 1389056716,
 1388889736,
 7942,
 -1,
 1389020730,
 8070,
 1389187790,
 1388971095,
 7940,
 -1,
 1389151802,
 8068,
 -1,
 1389101166,
 8064,
 1389428735,
 1388765096,
 8118,
 -1,
 1389348410,
 8119,
 1389515482,
 1388655085,
 7937,
 1389625343,
 1389433277,
 -1,
 1389646549,
 1389497183,
 7939,
 -1,
 1389610554,
 8067,
 1389777623,
 1389610632,
 7943,
 -1,
 1389741626,
 8071,
 1389908697,
 1389691991,
 7941,
 -1,
 1389872698,
 8069,
 -1,
 1389822062,
 8065,
 1390105310,
 1389458632,
 -1,
 1390170845,
 1390068586,
 8048,
 -1,
 1390134842,
 8114,
 -1,
 1390134758,
 8112,
 1390367456,
 1390019671,
 8049,
 -1,
 1390331450,
 8116,
 -44319,
 1390280814,
 8115,
 -44318,
 1390445320,
 940,
 -1,
 1390506650,
 8113,
 1390739455,
 1388533892,
 -1,
 -44315,
 1390658227,
 883,
 -1,
 1390707475,
 985,
 1390891777,
 1388466238,
 965,
 1391001599,
 1390822687,
 -1,
 1391022836,
 1390917883,
 -1,
 1391088367,
 1390952576,
 971,
 1391198207,
 1391006141,
 -1,
 -44308,
 1391070047,
 8162,
 -44307,
 1391166216,
 944,
 -44306,
 1391249032,
 8167,
 -1,
 1391264855,
 8163,
 1391525887,
 1391023857,
 8017,
 1391591423,
 1391399357,
 -1,
 -44302,
 1391463263,
 8019,
 -44301,
 1391576712,
 8023,
 -1,
 1391592535,
 8021,
 1391809275,
 1390991776,
 -1,
 1391874810,
 1391743579,
 8016,
 1391984639,
 1391792573,
 -1,
 -44296,
 1391856479,
 8018,
 -44295,
 1391969928,
 8022,
 -1,
 1391985751,
 8020,
 -1,
 1391845288,
 8166,
 1392268030,
 1391752392,
 -1,
 -44291,
 1392231910,
 8160,
 -1,
 1392296810,
 8058,
 -44289,
 1392214792,
 973,
 -44288,
 1392378967,
 8059,
 -1,
 1392472730,
 8161,
 1392661276,
 1390810714,
 953,
 1392771071,
 1392592159,
 -1,
 1392792335,
 1392687355,
 -1,
 1392857866,
 1392722048,
 970,
 1392967679,
 1392775613,
 -1,
 -44281,
 1392839519,
 8146,
 -44280,
 1392935688,
 912,
 -44279,
 1393018504,
 8151,
 -1,
 1393034327,
 8147,
 1393295359,
 1392793329,
 7985,
 1393360895,
 1393168829,
 -1,
 -44275,
 1393232735,
 7987,
 -44274,
 1393346184,
 7991,
 -1,
 1393362007,
 7989,
 1393578774,
 1392761248,
 -1,
 1393644309,
 1393513051,
 7984,
 1393754111,
 1393562045,
 -1,
 -44269,
 1393625951,
 7986,
 -44268,
 1393739400,
 7990,
 -1,
 1393755223,
 7988,
 -1,
 1393614760,
 8150,
 1394037529,
 1393521864,
 -1,
 -44264,
 1394001382,
 8144,
 -1,
 1394066282,
 8054,
 -44262,
 1393984264,
 943,
 -44261,
 1394148439,
 8055,
 -1,
 1394242202,
 8145,
 1394430755,
 1392617358,
 -1,
 1394496288,
 1394344755,
 -1,
 -44257,
 1394433320,
 1019,
 -1,
 1394478106,
 993,
 -44255,
 1394421616,
 987,
 -44254,
 1394614300,
 963,
 -1,
 1394719134,
 1016,
 1394889512,
 1394399648,
 -1,
 -44251,
 1394824863,
 968,
 -44250,
 1394874525,
 960,
 -44249,
 1394981275,
 966,
 -1,
 1395052157,
 887,
 1395217196,
 1394807421,
 961,
 1395326975,
 1395148063,
 -1,
 -44245,
 1395213576,
 8164,
 -1,
 1395274221,
 8165,
 1395479343,
 1395189130,
 -1,
 -44242,
 1395402720,
 952,
 -1,
 1395483160,
 964,
 1395675954,
 1395429687,
 -1,
 -44239,
 1395602477,
 991,
 -1,
 1395677523,
 954,
 1395872565,
 1395636475,
 -1,
 -44236,
 1395840907,
 989,
 -1,
 1395864981,
 948,
 -44234,
 1395790159,
 950,
 -44233,
 1396035767,
 958,
 -44232,
 1396054841,
 957,
 -44231,
 1396117429,
 956,
 -44230,
 1396185506,
 955,
 -44229,
 1396254688,
 881,
 -44228,
 1396365945,
 947,
 -44227,
 1396423129,
 962,
 -44226,
 1396486744,
 967,
 -1,
 1396522455,
 946,
 1396724546,
 1382782825,
 -1,
 -44223,
 1396643587,
 891,
 -1,
 1396738613,
 893,
 -1,
 1396673077,
 892,
 1397030911,
 1382687059,
 -1,
 -44219,
 1396904573,
 7528,
 -44218,
 1397019221,
 7529,
 -44217,
 1397086841,
 7527,
 -44216,
 1397142104,
 7530,
 -1,
 1397177815,
 7526,
 1397380097,
 1382671227,
 -1,
 1397445627,
 1397345935,
 -1,
 1397511162,
 1397399888,
 -1,
 1397576565,
 1397434011,
 -1,
 1397642088,
 1397515859,
 937,
 1397751807,
 1397572895,
 -1,
 1397773147,
 1397676448,
 -1,
 1397838682,
 1397707355,
 8040,
 1397948415,
 1397756349,
 -1,
 1397969750,
 1397873056,
 -1,
 1398035285,
 1397940136,
 8046,
 -1,
 1397982113,
 8110,
 -1,
 1397979235,
 8104,
 1398231896,
 1397885791,
 8042,
 -1,
 1398178721,
 8106,
 1398407167,
 1398146135,
 8044,
 -1,
 1398309793,
 8108,
 -1,
 1397782627,
 8188,
 1398559589,
 1397699053,
 8041,
 1398669311,
 1398477245,
 -1,
 1398690657,
 1398593952,
 -1,
 1398756192,
 1398661032,
 8047,
 -1,
 1398703009,
 8111,
 -1,
 1398700131,
 8105,
 1398952803,
 1398606687,
 8043,
 -1,
 1398899617,
 8107,
 1399128063,
 1398867031,
 8045,
 -1,
 1399030689,
 8109,
 -44186,
 1398475615,
 8186,
 -44185,
 1399161608,
 911,
 -1,
 1399194711,
 8187,
 1399455743,
 1397585090,
 927,
 1399521279,
 1399342367,
 -1,
 1399542638,
 1399407880,
 8008,
 1399652351,
 1399460285,
 -1,
 -44179,
 1399524191,
 8010,
 -1,
 1399587927,
 8012,
 1399804786,
 1399468525,
 8009,
 1399914495,
 1399722429,
 -1,
 -44175,
 1399786335,
 8011,
 -1,
 1399850071,
 8013,
 -44173,
 1399720799,
 8184,
 -44172,
 1400013576,
 908,
 -1,
 1400046679,
 8185,
 1400263582,
 1397493036,
 -1,
 1400329105,
 1400201698,
 919,
 1400438783,
 1400259871,
 -1,
 1400460164,
 1400363424,
 -1,
 1400525699,
 1400394331,
 7976,
 1400635391,
 1400443325,
 -1,
 1400656767,
 1400560032,
 -1,
 1400722302,
 1400627112,
 7982,
 -1,
 1400669089,
 8094,
 -1,
 1400666211,
 8088,
 1400918913,
 1400572767,
 7978,
 -1,
 1400865697,
 8090,
 1401094143,
 1400833111,
 7980,
 -1,
 1400996769,
 8092,
 -1,
 1400469603,
 8140,
 1401246606,
 1400386029,
 7977,
 1401356287,
 1401164221,
 -1,
 1401377674,
 1401280928,
 -1,
 1401443209,
 1401348008,
 7983,
 -1,
 1401389985,
 8095,
 -1,
 1401387107,
 8089,
 1401639820,
 1401293663,
 7979,
 -1,
 1401586593,
 8091,
 1401815039,
 1401554007,
 7981,
 -1,
 1401717665,
 8093,
 -44145,
 1401162591,
 8138,
 -44144,
 1401848584,
 905,
 -1,
 1401881687,
 8139,
 1402142719,
 1400263264,
 917,
 1402208255,
 1402029343,
 -1,
 1402229655,
 1402094856,
 7960,
 1402339327,
 1402147261,
 -1,
 -44138,
 1402211167,
 7962,
 -1,
 1402274903,
 7964,
 1402491803,
 1402155501,
 7961,
 1402601471,
 1402409405,
 -1,
 -44134,
 1402473311,
 7963,
 -1,
 1402537047,
 7965,
 -44132,
 1402407775,
 8136,
 -44131,
 1402700552,
 904,
 -1,
 1402733655,
 8137,
 1402950590,
 1400177459,
 -1,
 1403016125,
 1402895869,
 913,
 1403125759,
 1402946847,
 -1,
 1403147181,
 1403050400,
 -1,
 1403212716,
 1403081307,
 7944,
 1403322367,
 1403130301,
 -1,
 1403343784,
 1403247008,
 -1,
 1403409319,
 1403314088,
 7950,
 -1,
 1403356065,
 8078,
 -1,
 1403353187,
 8072,
 1403605930,
 1403259743,
 7946,
 -1,
 1403552673,
 8074,
 1403781119,
 1403520087,
 7948,
 -1,
 1403683745,
 8076,
 -1,
 1403156579,
 8124,
 1403933623,
 1403073005,
 7945,
 1404043263,
 1403851197,
 -1,
 1404064691,
 1403967904,
 -1,
 1404130226,
 1404034984,
 7951,
 -1,
 1404076961,
 8079,
 -1,
 1404074083,
 8073,
 1404326837,
 1403980639,
 7947,
 -1,
 1404273569,
 8075,
 1404502015,
 1404240983,
 7949,
 -1,
 1404404641,
 8077,
 1404588986,
 1403876552,
 -1,
 -44103,
 1404552678,
 8120,
 -1,
 1404617578,
 8122,
 -44101,
 1404535560,
 902,
 -44100,
 1404699735,
 8123,
 -1,
 1404793498,
 8121,
 -1,
 1402939840,
 882,
 1405047762,
 1402869338,
 921,
 1405157375,
 1404978463,
 -1,
 1405178823,
 1405073659,
 -1,
 1405244358,
 1405114097,
 7993,
 1405353983,
 1405161917,
 -1,
 -44092,
 1405225823,
 7995,
 -44091,
 1405339272,
 7999,
 -1,
 1405355095,
 7997,
 -1,
 1405173888,
 938,
 1405637580,
 1405109512,
 7992,
 1405747199,
 1405555133,
 -1,
 -44086,
 1405619039,
 7994,
 -44085,
 1405732488,
 7998,
 -1,
 1405748311,
 7996,
 1405965263,
 1405580488,
 -1,
 -44082,
 1405928934,
 8152,
 -1,
 1405993834,
 8154,
 -44080,
 1405911816,
 906,
 -44079,
 1406075991,
 8155,
 -1,
 1406169754,
 8153,
 1406358497,
 1404981310,
 933,
 1406468095,
 1406289183,
 -1,
 1406489563,
 1406384379,
 -1,
 1406555098,
 1406424817,
 8025,
 1406664703,
 1406472637,
 -1,
 -44072,
 1406536543,
 8027,
 -44071,
 1406649992,
 8031,
 -1,
 1406665815,
 8029,
 -1,
 1406484608,
 939,
 1406948318,
 1406432456,
 -1,
 -44067,
 1406911974,
 8168,
 -1,
 1406976874,
 8170,
 -44065,
 1406894856,
 910,
 -44064,
 1407059031,
 8171,
 -1,
 1407152794,
 8169,
 1407341542,
 1406327200,
 -1,
 -44061,
 1407276703,
 936,
 -44060,
 1407326365,
 928,
 -44059,
 1407433115,
 934,
 -1,
 1407503997,
 886,
 1407669226,
 1407297422,
 -1,
 -44056,
 1407590428,
 931,
 -44055,
 1407695262,
 1015,
 -1,
 1407738380,
 1018,
 1407931373,
 1407640970,
 -1,
 -44052,
 1407854560,
 920,
 -1,
 1407935000,
 932,
 1408127983,
 1407849085,
 929,
 -1,
 1408066962,
 8172,
 -44048,
 1408045391,
 918,
 -44047,
 1408225463,
 926,
 -44046,
 1408244537,
 925,
 -44045,
 1408307125,
 924,
 -44044,
 1408375202,
 923,
 -44043,
 1408441987,
 922,
 -44042,
 1408509920,
 880,
 -44041,
 1408621177,
 915,
 -44040,
 1408674342,
 916,
 -44039,
 1408741976,
 935,
 -1,
 1408777687,
 914,
 -1,
 1397434374,
 1017,
 1409045502,
 1397397353,
 -1,
 -44035,
 1408964355,
 1021,
 -1,
 1409059381,
 1023,
 -44033,
 1409012413,
 1012,
 -44032,
 1409162674,
 975,
 -1,
 1409255989,
 1022,
 1409438806,
 1397293875,
 -1,
 1409504338,
 1409362946,
 -1,
 1409569832,
 1409476075,
 -1,
 1409635351,
 1409523988,
 -1,
 1409700880,
 1409580285,
 65859,
 1409810431,
 1409635369,
 -1,
 1409831947,
 1409738122,
 -1,
 1409897482,
 1409757328,
 65862,
 -1,
 1409833234,
 65870,
 -1,
 1409869920,
 65864,
 1410094095,
 1409761347,
 65861,
 1410203647,
 1410028585,
 -1,
 -44018,
 1410124512,
 65868,
 -1,
 1410141137,
 65875,
 -1,
 1410010065,
 65871,
 1410465791,
 1409654966,
 65860,
 1410531327,
 1410356265,
 -1,
 1410552854,
 1410459018,
 -1,
 1410618389,
 1410478224,
 65863,
 -1,
 1410542746,
 65878,
 -1,
 1410590816,
 65866,
 -1,
 1410468817,
 65873,
 1410880546,
 1409596550,
 -1,
 1410946077,
 1410843538,
 -1,
 1411011612,
 1410897519,
 -1,
 -44005,
 1410976480,
 65867,
 -1,
 1410993105,
 65874,
 -1,
 1410981012,
 65857,
 1411273760,
 1410865791,
 -1,
 -44001,
 1411238624,
 65869,
 -1,
 1411255249,
 65876,
 -43999,
 1411234774,
 65856,
 -1,
 1411403178,
 65858,
 1411645439,
 1410811658,
 -1,
 1411666982,
 1411573130,
 -1,
 -43995,
 1411619631,
 65877,
 -1,
 1411704928,
 65865,
 -43993,
 1411582929,
 65872,
 -1,
 1411780938,
 65879,
 1411994689,
 1409541514,
 -1,
 1412060217,
 1411939821,
 -1,
 1412125744,
 1412031882,
 -1,
 1412191278,
 1412088722,
 -1,
 -43987,
 1412108705,
 65899,
 -1,
 1412216378,
 65893,
 -43985,
 1412139249,
 65884,
 -1,
 1412339125,
 65892,
 1412518964,
 1412084024,
 65881,
 1412628479,
 1412453417,
 -1,
 -43981,
 1412531038,
 65905,
 -1,
 1412579395,
 65898,
 1412825087,
 1412473108,
 -1,
 1412846648,
 1412701806,
 -1,
 -43977,
 1412793182,
 65906,
 -1,
 1412841539,
 65902,
 -1,
 1412800694,
 65897,
 1413152767,
 1411988350,
 -1,
 1413174335,
 1413062932,
 -1,
 1413239869,
 1413119229,
 65887,
 -1,
 1413193727,
 65901,
 1413414911,
 1413193910,
 65894,
 -1,
 1413302560,
 65895,
 1413545983,
 1413119793,
 65888,
 -1,
 1413433632,
 65889,
 1413633095,
 1411947018,
 -1,
 1413698630,
 1413604999,
 -1,
 -43964,
 1413644081,
 65890,
 -43963,
 1413722424,
 65882,
 -1,
 1413755047,
 65896,
 -1,
 1413623119,
 65880,
 1414026315,
 1413548939,
 -1,
 1414091850,
 1413956891,
 65883,
 -1,
 1414053170,
 65886,
 -1,
 1414051877,
 65900,
 1414288462,
 1413970800,
 -1,
 -43955,
 1414236947,
 65885,
 -1,
 1414304520,
 65903,
 -43953,
 1414208972,
 65908,
 -43952,
 1414407844,
 65904,
 -43951,
 1414506992,
 65891,
 -1,
 1414567378,
 65907,
 1414747221,
 1409463559,
 -1,
 -43948,
 1414683403,
 65926,
 -1,
 1414766037,
 65927,
 -1,
 1414702286,
 903,
 1415009405,
 1409384637,
 -1,
 1415074911,
 1414958221,
 119327,
 -43943,
 1415042308,
 119356,
 -43942,
 1415092233,
 119355,
 -43941,
 1415141506,
 119354,
 -43940,
 1415236166,
 119353,
 -43939,
 1415269997,
 119352,
 -43938,
 1415320592,
 119351,
 -1,
 1415414350,
 119350,
 1415599207,
 1415036584,
 119325,
 -43935,
 1415566596,
 119337,
 -43934,
 1415616521,
 119336,
 -43933,
 1415665794,
 119335,
 -43932,
 1415744653,
 119334,
 -43931,
 1415794285,
 119333,
 -43930,
 1415844880,
 119332,
 -1,
 1415954088,
 119331,
 1416123502,
 1415517200,
 119326,
 -43927,
 1416090884,
 119343,
 -43926,
 1416124546,
 119342,
 -43925,
 1416175218,
 119341,
 -43924,
 1416284742,
 119340,
 -43923,
 1416334477,
 119339,
 -1,
 1416384109,
 119338,
 1416582260,
 1416088134,
 119328,
 -43920,
 1416531085,
 119361,
 -43919,
 1416580717,
 119360,
 -43918,
 1416631312,
 119359,
 -43917,
 1416740520,
 119358,
 -1,
 1416790606,
 119357,
 1416975483,
 1416515181,
 -1,
 -43914,
 1416942852,
 119349,
 -43913,
 1416992777,
 119348,
 -43912,
 1417042050,
 119347,
 -43911,
 1417092722,
 119346,
 -43910,
 1417155600,
 119345,
 -1,
 1417249358,
 119344,
 -43908,
 1416927241,
 119330,
 -1,
 1417369730,
 119329,
 1417565341,
 1414952136,
 -1,
 1417630876,
 1417533611,
 -1,
 1417696394,
 1417592488,
 119296,
 -43903,
 1417663748,
 119314,
 -43902,
 1417713673,
 119313,
 -43901,
 1417762946,
 119312,
 -43900,
 1417813618,
 119311,
 -43899,
 1417923142,
 119310,
 -43898,
 1417972877,
 119309,
 -43897,
 1418022509,
 119308,
 -43896,
 1418073104,
 119307,
 -43895,
 1418182312,
 119306,
 -1,
 1418232398,
 119305,
 1418417296,
 1417660998,
 119300,
 -43892,
 1418366093,
 119324,
 -43891,
 1418415725,
 119323,
 -43890,
 1418466320,
 119322,
 -43889,
 1418575528,
 119321,
 -1,
 1418625614,
 119320,
 1418810518,
 1418335248,
 119297,
 -43886,
 1418759309,
 119319,
 -43885,
 1418808941,
 119318,
 -43884,
 1418859536,
 119317,
 -43883,
 1418968744,
 119316,
 -1,
 1419018830,
 119315,
 -43881,
 1418777860,
 119304,
 -43880,
 1419155465,
 119303,
 -43879,
 1419204738,
 119302,
 -43878,
 1419255410,
 119301,
 -43877,
 1419349133,
 119299,
 -1,
 1419398765,
 119298,
 -1,
 1417593706,
 8175,
 1419662514,
 1417531023,
 -1,
 1419728045,
 1419616592,
 -1,
 1419793577,
 1419683726,
 -1,
 1419859111,
 1419733572,
 -1,
 1419924644,
 1419827616,
 -1,
 -43869,
 1419859615,
 7466,
 -1,
 1419909277,
 7464,
 -43867,
 1419842173,
 7465,
 -43866,
 1420040610,
 7463,
 -1,
 1420155513,
 7462,
 -43864,
 1419784048,
 986,
 -1,
 1420263167,
 992,
 -43862,
 1419761051,
 1011,
 -43861,
 1420395283,
 990,
 -43860,
 1420439684,
 988,
 -1,
 1420505261,
 984,
 1420711088,
 1419661762,
 -1,
 -43857,
 1420641781,
 1010,
 -1,
 1420733466,
 1013,
 -43855,
 1420657166,
 885,
 -1,
 1420851358,
 65923,
 1421038783,
 1419622651,
 -1,
 1421104313,
 1420954853,
 -1,
 1421169848,
 1421030138,
 -1,
 -43850,
 1421085535,
 8173,
 -43849,
 1421198984,
 8129,
 -1,
 1421214807,
 8174,
 -1,
 1421116168,
 901,
 1421497534,
 1421039345,
 8190,
 1421606911,
 1421414845,
 -1,
 -43844,
 1421478751,
 8157,
 -43843,
 1421592200,
 8159,
 -1,
 1421608023,
 8158,
 -1,
 1421445407,
 65915,
 1421890763,
 1421010314,
 -1,
 1421956293,
 1421853586,
 -1,
 1422021828,
 1421877244,
 -1,
 -43837,
 1421958541,
 65912,
 -1,
 1422019711,
 65918,
 -1,
 1421984377,
 977,
 1422283976,
 1421926167,
 -1,
 -43833,
 1422201349,
 65911,
 -1,
 1422281855,
 65917,
 -43831,
 1422200525,
 65929,
 -43830,
 1422435099,
 900,
 -1,
 1422460868,
 65914,
 1422677205,
 1421859232,
 -1,
 1422742737,
 1422611035,
 8127,
 1422852095,
 1422660029,
 -1,
 -43825,
 1422723935,
 8141,
 -43824,
 1422837384,
 8143,
 -1,
 1422853207,
 8142,
 -43822,
 1422686307,
 8126,
 -43821,
 1423040396,
 982,
 -43820,
 1423065711,
 981,
 -1,
 1423171496,
 8128,
 1423332571,
 1422630136,
 -1,
 1423398104,
 1423263796,
 65909,
 -1,
 1423329568,
 65910,
 -43815,
 1423316575,
 8189,
 -43814,
 1423501287,
 65924,
 -1,
 1423528043,
 65916,
 1423725793,
 1423282487,
 -1,
 1423791327,
 1423639347,
 -1,
 -43810,
 1423762077,
 1008,
 -1,
 1423826828,
 983,
 -43808,
 1423705580,
 65922,
 -1,
 1423950782,
 8125,
 1424119013,
 1423668163,
 -1,
 -43805,
 1424083945,
 978,
 -43804,
 1424147708,
 980,
 -1,
 1424192509,
 979,
 1424381162,
 1424078087,
 -1,
 1424446697,
 1424326825,
 -1,
 -43800,
 1424417370,
 1020,
 -1,
 1424478158,
 1009,
 -1,
 1424408806,
 1014,
 1424708845,
 1424310905,
 -1,
 -43796,
 1424661875,
 890,
 -1,
 1424689761,
 65913,
 1424905456,
 1424630356,
 -1,
 -43793,
 1424824853,
 119365,
 -1,
 1424906281,
 65921,
 1425102067,
 1424836679,
 -1,
 -43790,
 1425063853,
 65919,
 -1,
 1425085363,
 65920,
 -43788,
 1425065495,
 65930,
 -43787,
 1425233637,
 65925,
 -43786,
 1425323747,
 894,
 -43785,
 1425353506,
 884,
 -43784,
 1425410609,
 65928,
 -1,
 1425480249,
 976,
 1425735679,
 1382587752,
 -1,
 1425757449,
 1425644792,
 -1,
 1425822982,
 1425689051,
 -1,
 1425888513,
 1425772261,
 10878,
 1425997823,
 1425805482,
 -1,
 1426019584,
 1425892581,
 10882,
 -1,
 1425945226,
 10884,
 -1,
 1425946517,
 10880,
 1426216196,
 1425851284,
 -1,
 -43773,
 1426136323,
 8819,
 -1,
 1426229063,
 8805,
 -43771,
 1426134631,
 8823,
 -1,
 1426372769,
 10886,
 1426587647,
 1425783692,
 -1,
 -43768,
 1426491846,
 10916,
 -1,
 1426553361,
 8807,
 1426740502,
 1425670963,
 -1,
 1426806035,
 1426668277,
 -1,
 1426871568,
 1426761614,
 -1,
 1426937103,
 1426798600,
 -1,
 -43762,
 1426856052,
 10894,
 -1,
 1426956648,
 10896,
 -1,
 1426876418,
 10900,
 -43759,
 1426840703,
 10616,
 -43758,
 1427113823,
 10898,
 -1,
 1427216417,
 10892,
 1427439615,
 1426758134,
 -1,
 -43755,
 1427325209,
 10888,
 -1,
 1427431403,
 10890,
 1427592474,
 1426699687,
 -1,
 -43752,
 1427546196,
 10876,
 -43751,
 1427574842,
 8919,
 -1,
 1427651838,
 10874,
 1427854623,
 1427520960,
 -1,
 1427920158,
 1427812238,
 -1,
 -43747,
 1427840259,
 8935,
 -1,
 1427932999,
 8809,
 -1,
 1427861550,
 10917,
 1428182305,
 1427817278,
 10919,
 -1,
 1428104160,
 10921,
 -43742,
 1428141449,
 62,
 -1,
 1428263942,
 8923,
 -1,
 1382495562,
 96,
 1428510208,
 1382430561,
 -1,
 1428575638,
 1428455194,
 -1,
 1428641126,
 1428497765,
 -1,
 1428706606,
 1428583624,
 -1,
 1428772141,
 1428643123,
 -1,
 1428837675,
 1428731143,
 2699,
 -1,
 1428796679,
 2784,
 1429012479,
 1428803215,
 2700,
 -1,
 1428934287,
 2785,
 -1,
 1428685619,
 2741,
 1429165364,
 1428678026,
 -1,
 1429230898,
 1429136778,
 -1,
 -43727,
 1429191091,
 2720,
 -1,
 1429209907,
 2719,
 -43725,
 1429191091,
 2725,
 -1,
 1429340979,
 2724,
 1429558585,
 1429101864,
 -1,
 -43722,
 1429482532,
 2718,
 -43721,
 1429543709,
 2723,
 -43720,
 1429646995,
 2713,
 -1,
 1429668659,
 2728,
 1429886271,
 1429518587,
 -1,
 1429951805,
 1429846267,
 -1,
 -43716,
 1429911987,
 2722,
 -1,
 1429930803,
 2721,
 -43714,
 1429911987,
 2727,
 -1,
 1430061875,
 2726,
 1430279491,
 1429799731,
 2693,
 -43711,
 1430206305,
 2708,
 -43710,
 1430263965,
 2704,
 -1,
 1430324019,
 2694,
 1430541639,
 1430235022,
 -1,
 -43707,
 1430476460,
 2743,
 -43706,
 1430567347,
 2742,
 -1,
 1430586163,
 2744,
 1430803785,
 1430468449,
 2697,
 -1,
 1430730593,
 2698,
 1430934860,
 1430772128,
 -1,
 -43701,
 1430895027,
 2731,
 -1,
 1430913843,
 2730,
 1431131471,
 1430900367,
 -1,
 -43698,
 1431044862,
 2739,
 -1,
 1431110451,
 2738,
 1431328082,
 1431081271,
 -1,
 -43695,
 1431288243,
 2710,
 -1,
 1431307059,
 2709,
 1431524693,
 1431261900,
 -1,
 -43692,
 1431484851,
 2717,
 -1,
 1431503667,
 2716,
 1431721303,
 1431443613,
 2695,
 -1,
 1431640221,
 2696,
 1431852378,
 1431668429,
 -1,
 -43687,
 1431812531,
 2712,
 -1,
 1431831347,
 2711,
 1432048989,
 1431796592,
 -1,
 -43684,
 1432009139,
 2715,
 -1,
 1432027955,
 2714,
 1432245600,
 1431977408,
 -1,
 -43681,
 1432205747,
 2733,
 -1,
 1432224563,
 2732,
 -43679,
 1432169508,
 2735,
 -43678,
 1432373673,
 2736,
 -43677,
 1432460536,
 2707,
 -43676,
 1432489894,
 2734,
 -43675,
 1432598963,
 2745,
 -1,
 1432620332,
 2703,
 1432835453,
 1428581449,
 -1,
 1432900986,
 1432757509,
 -1,
 1432966509,
 1432814308,
 -1,
 1433032043,
 1432925447,
 2755,
 -1,
 1432990983,
 2756,
 1433206783,
 1432997519,
 2786,
 -1,
 1433128591,
 2787,
 1433294193,
 1432879923,
 -1,
 -43665,
 1433220961,
 2764,
 -43664,
 1433278621,
 2760,
 -1,
 1433338675,
 2750,
 1433556339,
 1433220961,
 2753,
 -1,
 1433483105,
 2754,
 1433687413,
 1433475229,
 2751,
 -1,
 1433606301,
 2752,
 1433818488,
 1433642759,
 -1,
 -43657,
 1433771256,
 2761,
 -1,
 1433799980,
 2757,
 -43655,
 1433771256,
 2763,
 -1,
 1433931052,
 2759,
 1434189823,
 1432856327,
 -1,
 -43652,
 1434098936,
 2705,
 -1,
 1434127660,
 2701,
 1434342795,
 1432805745,
 -1,
 1434408321,
 1434314122,
 -1,
 -43648,
 1434355953,
 2792,
 -1,
 1434421267,
 2793,
 1434604932,
 1434363790,
 -1,
 -43645,
 1434568043,
 2796,
 -1,
 1434598014,
 2797,
 1434801543,
 1434536007,
 -1,
 -43642,
 1434751474,
 2794,
 -1,
 1434789890,
 2795,
 -43640,
 1434716515,
 2790,
 -43639,
 1434956088,
 2791,
 -43638,
 1434989110,
 2799,
 -1,
 1435091146,
 2798,
 1435260308,
 1434264837,
 -1,
 1435325839,
 1435204864,
 -1,
 -43634,
 1435286698,
 2691,
 -1,
 1435319793,
 2765,
 1435522450,
 1435239219,
 -1,
 -43631,
 1435466548,
 2749,
 -1,
 1435519210,
 2690,
 -43629,
 1435440356,
 2748,
 -1,
 1435654302,
 2689,
 -43627,
 1435215166,
 2801,
 -1,
 1435772571,
 2768,
 1435981311,
 1428503517,
 -1,
 1436046808,
 1435903333,
 -1,
 1436112286,
 1436018058,
 -1,
 1436177820,
 1436083594,
 -1,
 -43621,
 1436137907,
 2592,
 -1,
 1436156723,
 2591,
 -43619,
 1436137907,
 2597,
 -1,
 1436287795,
 2596,
 1436505507,
 1436048680,
 -1,
 -43616,
 1436429348,
 2590,
 -43615,
 1436490525,
 2595,
 -43614,
 1436593811,
 2585,
 -1,
 1436615475,
 2600,
 1436833193,
 1436465403,
 -1,
 1436898727,
 1436793083,
 -1,
 -43610,
 1436858803,
 2594,
 -1,
 1436877619,
 2593,
 -43608,
 1436858803,
 2599,
 -1,
 1437008691,
 2598,
 1437226413,
 1436746547,
 2565,
 -43605,
 1437153121,
 2580,
 -43604,
 1437210781,
 2576,
 -1,
 1437270835,
 2566,
 1437488562,
 1437176119,
 -1,
 1437554097,
 1437451154,
 -1,
 -43600,
 1437514163,
 2649,
 -1,
 1437532979,
 2582,
 -1,
 1437467443,
 2581,
 1437816247,
 1437435597,
 -1,
 1437881782,
 1437778834,
 -1,
 -43595,
 1437841843,
 2650,
 -1,
 1437860659,
 2584,
 -1,
 1437795123,
 2583,
 1438143929,
 1437742945,
 2569,
 -1,
 1438070625,
 2570,
 1438275004,
 1438099342,
 -1,
 -43589,
 1438235059,
 2614,
 -1,
 1438253875,
 2616,
 1438471615,
 1438233863,
 -1,
 -43586,
 1438402985,
 2652,
 -1,
 1438450483,
 2608,
 1438668226,
 1438439840,
 -1,
 -43583,
 1438628275,
 2603,
 -1,
 1438647091,
 2602,
 1438864837,
 1438633615,
 -1,
 -43580,
 1438778110,
 2611,
 -1,
 1438843699,
 2610,
 1439061448,
 1438798540,
 -1,
 -43577,
 1439021491,
 2589,
 -1,
 1439040307,
 2588,
 1439258058,
 1438980253,
 2567,
 -1,
 1439176861,
 2568,
 1439389133,
 1439202160,
 -1,
 -43572,
 1439349171,
 2587,
 -1,
 1439367987,
 2586,
 1439585744,
 1439317440,
 -1,
 -43569,
 1439545779,
 2605,
 -1,
 1439564595,
 2604,
 -43567,
 1439543081,
 2651,
 -43566,
 1439706148,
 2607,
 -43565,
 1439792371,
 2613,
 -43564,
 1439835797,
 2579,
 -43563,
 1439895462,
 2606,
 -43562,
 1440004531,
 2617,
 -43561,
 1440063743,
 2654,
 -1,
 1440126401,
 2575,
 1440306662,
 1436017009,
 -1,
 1440372188,
 1440277898,
 -1,
 -43557,
 1440319729,
 2664,
 -1,
 1440385043,
 2665,
 1440568799,
 1440327566,
 -1,
 -43554,
 1440531819,
 2668,
 -1,
 1440561790,
 2669,
 1440765410,
 1440499783,
 -1,
 -43551,
 1440715250,
 2666,
 -1,
 1440753666,
 2667,
 -43549,
 1440680291,
 2662,
 -43548,
 1440919864,
 2663,
 -43547,
 1440952886,
 2671,
 -1,
 1441054922,
 2670,
 1441224177,
 1440255029,
 -1,
 1441289707,
 1441137459,
 -1,
 -43543,
 1441216353,
 2636,
 -43542,
 1441274013,
 2632,
 -1,
 1441334067,
 2622,
 1441551853,
 1441216353,
 2625,
 -1,
 1441478497,
 2626,
 1441682927,
 1441470621,
 2623,
 -1,
 1441601693,
 2624,
 -43536,
 1441605269,
 2635,
 -1,
 1441764801,
 2631,
 1441945082,
 1441146117,
 -1,
 1442010613,
 1441889536,
 -1,
 -43532,
 1441971370,
 2563,
 -1,
 1442004465,
 2637,
 -43530,
 1441938934,
 2677,
 -43529,
 1442131696,
 2641,
 -43528,
 1442190564,
 2620,
 -43527,
 1442293003,
 2562,
 -1,
 1442337563,
 2561,
 -43525,
 1441865627,
 2675,
 -43524,
 1442505035,
 2672,
 -43523,
 1442519217,
 2674,
 -43522,
 1442597676,
 2676,
 -1,
 1442675918,
 2673,
 -1,
 1435896575,
 8370,
 1442928302,
 1428426028,
 -1,
 1442993831,
 1442880760,
 -1,
 1443059362,
 1442932546,
 -1,
 1443124797,
 1442981221,
 -1,
 1443190283,
 1443087250,
 -1,
 1443255816,
 1443103539,
 -1,
 -43513,
 1443214599,
 4340,
 -1,
 1443237164,
 4336,
 -43511,
 1443178177,
 4341,
 -43510,
 1443415471,
 4338,
 -1,
 1443433772,
 4337,
 1443649041,
 1443134320,
 -1,
 1443714575,
 1443611538,
 -1,
 -43506,
 1443677606,
 4329,
 -1,
 1443717653,
 4333,
 -43504,
 1443677603,
 4332,
 -1,
 1443848716,
 4330,
 1444042262,
 1443620234,
 -1,
 1444107797,
 1443955507,
 -1,
 -43500,
 1444066567,
 4322,
 -1,
 1444109608,
 4311,
 -1,
 1444055441,
 4345,
 1444369945,
 1443987403,
 -1,
 -43496,
 1444317566,
 4319,
 -1,
 1444386229,
 4310,
 1444566556,
 1444325262,
 -1,
 -43493,
 1444505016,
 4328,
 -1,
 1444569612,
 4321,
 1444763167,
 1444534688,
 -1,
 -43490,
 1444710782,
 4324,
 -1,
 1444766229,
 4318,
 1444959778,
 1444712759,
 -1,
 -43487,
 1444907390,
 4325,
 -1,
 1444962828,
 4313,
 1445156389,
 1444893388,
 -1,
 -43484,
 1445119395,
 4331,
 -1,
 1445168248,
 4335,
 1445353000,
 1445103309,
 -1,
 -43481,
 1445299320,
 4326,
 -1,
 1445356044,
 4306,
 1445549611,
 1445268780,
 -1,
 -43478,
 1445485864,
 4308,
 -1,
 1445572116,
 4344,
 1445746222,
 1445462835,
 -1,
 -43475,
 1445682472,
 4304,
 -1,
 1445774758,
 4346,
 -43473,
 1445700016,
 4343,
 -43472,
 1445868627,
 4334,
 -43471,
 1445955815,
 4339,
 -43470,
 1445998155,
 4309,
 -43469,
 1446080701,
 4323,
 -43468,
 1446143597,
 4320,
 -43467,
 1446217965,
 4327,
 -43466,
 1446258328,
 4317,
 -43465,
 1446320435,
 4316,
 -43464,
 1446393986,
 4315,
 -43463,
 1446500922,
 4314,
 -43462,
 1446561190,
 4312,
 -43461,
 1446617364,
 4342,
 -43460,
 1446645725,
 4307,
 -1,
 1446711528,
 4305,
 1446925935,
 1443084990,
 -1,
 1446991429,
 1446888338,
 -1,
 1447056962,
 1446904627,
 -1,
 -43455,
 1447015687,
 11556,
 -1,
 1447038252,
 11552,
 -43453,
 1446979265,
 11557,
 -43452,
 1447216559,
 11554,
 -1,
 1447234860,
 11553,
 1447450187,
 1446935408,
 -1,
 1447515721,
 1447412626,
 -1,
 -43448,
 1447478694,
 11545,
 -1,
 1447518741,
 11549,
 -43446,
 1447478691,
 11548,
 -1,
 1447649804,
 11546,
 1447843406,
 1447395275,
 -1,
 -43443,
 1447790974,
 11535,
 -1,
 1447859637,
 11526,
 1448040017,
 1447780834,
 -1,
 -43440,
 1447998727,
 11538,
 -1,
 1448041768,
 11527,
 1448236628,
 1447995278,
 -1,
 -43437,
 1448175032,
 11544,
 -1,
 1448239628,
 11537,
 1448433239,
 1448204704,
 -1,
 -43434,
 1448380798,
 11540,
 -1,
 1448436245,
 11534,
 1448629850,
 1448382775,
 -1,
 -43431,
 1448577406,
 11541,
 -1,
 1448632844,
 11529,
 1448826461,
 1448563404,
 -1,
 -43428,
 1448789411,
 11547,
 -1,
 1448838264,
 11551,
 1449023072,
 1448773325,
 -1,
 -43425,
 1448969336,
 11542,
 -1,
 1449026060,
 11522,
 -43423,
 1448948819,
 11550,
 -43422,
 1449167079,
 11555,
 -43421,
 1449209419,
 11525,
 -43420,
 1449291965,
 11539,
 -43419,
 1449354861,
 11536,
 -43418,
 1449429229,
 11543,
 -43417,
 1449469592,
 11533,
 -43416,
 1449531699,
 11532,
 -43415,
 1449605250,
 11531,
 -43414,
 1449712186,
 11530,
 -43413,
 1449772454,
 11528,
 -43412,
 1449825717,
 11524,
 -43411,
 1449856989,
 11523,
 -43410,
 1449922792,
 11521,
 -1,
 1450009100,
 11520,
 1450202785,
 1446871614,
 -1,
 1450268279,
 1450165138,
 -1,
 1450333812,
 1450181427,
 -1,
 -43405,
 1450292487,
 4292,
 -1,
 1450315052,
 4288,
 -43403,
 1450256065,
 4293,
 -43402,
 1450493359,
 4290,
 -1,
 1450511660,
 4289,
 1450727037,
 1450212208,
 -1,
 1450792571,
 1450689426,
 -1,
 -43398,
 1450755494,
 4281,
 -1,
 1450795541,
 4285,
 -43396,
 1450755491,
 4284,
 -1,
 1450926604,
 4282,
 1451120256,
 1450672075,
 -1,
 -43393,
 1451067774,
 4271,
 -1,
 1451136437,
 4262,
 1451316867,
 1451057634,
 -1,
 -43390,
 1451275527,
 4274,
 -1,
 1451318568,
 4263,
 1451513478,
 1451272078,
 -1,
 -43387,
 1451451832,
 4280,
 -1,
 1451516428,
 4273,
 1451710089,
 1451481504,
 -1,
 -43384,
 1451657598,
 4276,
 -1,
 1451713045,
 4270,
 1451906700,
 1451659575,
 -1,
 -43381,
 1451854206,
 4277,
 -1,
 1451909644,
 4265,
 1452103311,
 1451840204,
 -1,
 -43378,
 1452066211,
 4283,
 -1,
 1452115064,
 4287,
 1452299922,
 1452050125,
 -1,
 -43375,
 1452246136,
 4278,
 -1,
 1452302860,
 4258,
 -43373,
 1452225619,
 4286,
 -43372,
 1452443879,
 4291,
 -43371,
 1452486219,
 4261,
 -43370,
 1452568765,
 4275,
 -43369,
 1452631661,
 4272,
 -43368,
 1452706029,
 4279,
 -43367,
 1452746392,
 4269,
 -43366,
 1452808499,
 4268,
 -43365,
 1452882050,
 4267,
 -43364,
 1452988986,
 4266,
 -43363,
 1453049254,
 4264,
 -43362,
 1453102517,
 4260,
 -43361,
 1453133789,
 4259,
 -43360,
 1453199592,
 4257,
 -1,
 1453285900,
 4256,
 -1,
 1450136175,
 4347,
 1453588479,
 1442993945,
 -1,
 1453610662,
 1453496148,
 -1,
 -43355,
 1453530371,
 8782,
 -1,
 1453623111,
 8785,
 -1,
 1453538127,
 8762,
 1453872811,
 1442931221,
 9881,
 1453981695,
 1453800881,
 -1,
 -43350,
 1453868408,
 9965,
 -1,
 1453919266,
 9966,
 -43348,
 1453798962,
 12307,
 -43347,
 1454051076,
 8368,
 -1,
 1454126624,
 9802,
 1454331695,
 1442893455,
 -1,
 1454397230,
 1454296277,
 -1,
 1454462703,
 1454357182,
 -1,
 1454528186,
 1454417806,
 -1,
 1454593718,
 1454490514,
 -1,
 1454659253,
 1454531042,
 11339,
 -1,
 1454595811,
 11356,
 -1,
 1454572339,
 11342,
 1454855864,
 1454520597,
 11348,
 -1,
 1454788980,
 11349,
 -43335,
 1454795598,
 11346,
 -1,
 1454945989,
 11332,
 1455118019,
 1454457465,
 -1,
 1455183552,
 1455033644,
 -1,
 1455249087,
 1455142151,
 -1,
 -43330,
 1455175521,
 11343,
 -1,
 1455233181,
 11344,
 -1,
 1455165766,
 11317,
 -43327,
 1455109985,
 11347,
 -43326,
 1455463672,
 11350,
 -1,
 1455494109,
 11345,
 1455707851,
 1455036573,
 11323,
 1455773383,
 1455664920,
 -1,
 -43322,
 1455706190,
 11355,
 -1,
 1455754540,
 11321,
 1455969994,
 1455687482,
 -1,
 -43319,
 1455938597,
 11351,
 -1,
 1456004615,
 11353,
 -1,
 1455894812,
 11322,
 1456232143,
 1455678858,
 -1,
 -43315,
 1456155480,
 11333,
 -43314,
 1456232095,
 11340,
 -1,
 1456286388,
 11357,
 1456494291,
 1456191739,
 -1,
 -43311,
 1456461909,
 11319,
 -43310,
 1456507739,
 11316,
 -1,
 1456550885,
 11324,
 1456756438,
 1456439243,
 -1,
 -43307,
 1456697197,
 11318,
 -1,
 1456786829,
 11320,
 1456953049,
 1456724384,
 -1,
 -43304,
 1456890010,
 11330,
 -1,
 1456934188,
 11338,
 1457149660,
 1456905464,
 -1,
 -43301,
 1457086895,
 11337,
 -1,
 1457134393,
 11329,
 1457346271,
 1457114767,
 -1,
 -43298,
 1457285483,
 11326,
 -1,
 1457353188,
 11358,
 1457542882,
 1457276999,
 -1,
 -43295,
 1457455500,
 11335,
 -1,
 1457532991,
 11354,
 1457739493,
 1457470912,
 -1,
 -43292,
 1457697035,
 11313,
 -1,
 1457757449,
 11352,
 -43290,
 1457700904,
 11314,
 -43289,
 1457882054,
 11334,
 -43288,
 1457919856,
 11331,
 -43287,
 1458002815,
 11328,
 -43286,
 1458080336,
 11327,
 -43285,
 1458147368,
 11325,
 -43284,
 1458188314,
 11336,
 -43283,
 1458269972,
 11315,
 -43282,
 1458320489,
 11341,
 -1,
 1458379724,
 11312,
 1458634751,
 1454408254,
 -1,
 1458657017,
 1458546574,
 -1,
 1458722549,
 1458619282,
 -1,
 1458788084,
 1458659810,
 11291,
 -1,
 1458724579,
 11308,
 -1,
 1458701107,
 11294,
 1458984695,
 1458649365,
 11300,
 -1,
 1458917748,
 11301,
 -43272,
 1458924366,
 11298,
 -1,
 1459074757,
 11284,
 1459246850,
 1458586233,
 -1,
 1459312383,
 1459162412,
 -1,
 1459377918,
 1459270919,
 -1,
 -43267,
 1459304289,
 11295,
 -1,
 1459361949,
 11296,
 -1,
 1459294534,
 11269,
 -43264,
 1459238753,
 11299,
 -43263,
 1459592440,
 11302,
 -1,
 1459622877,
 11297,
 1459836682,
 1459165341,
 11275,
 1459902214,
 1459793688,
 -1,
 -43259,
 1459834958,
 11307,
 -1,
 1459883308,
 11273,
 1460098825,
 1459816250,
 -1,
 -43256,
 1460067365,
 11303,
 -1,
 1460133383,
 11305,
 -1,
 1460023580,
 11274,
 1460360974,
 1459807626,
 -1,
 -43252,
 1460284248,
 11285,
 -43251,
 1460360863,
 11292,
 -1,
 1460415156,
 11309,
 1460623122,
 1460320507,
 -1,
 -43248,
 1460590677,
 11271,
 -43247,
 1460636507,
 11268,
 -1,
 1460679653,
 11276,
 1460885269,
 1460568011,
 -1,
 -43244,
 1460825965,
 11270,
 -1,
 1460915597,
 11272,
 1461081880,
 1460853152,
 -1,
 -43241,
 1461018778,
 11282,
 -1,
 1461062956,
 11290,
 1461278491,
 1461034232,
 -1,
 -43238,
 1461215663,
 11289,
 -1,
 1461263161,
 11281,
 1461475102,
 1461243535,
 -1,
 -43235,
 1461414251,
 11278,
 -1,
 1461481956,
 11310,
 1461671713,
 1461405767,
 -1,
 -43232,
 1461584268,
 11287,
 -1,
 1461661759,
 11306,
 1461868324,
 1461599680,
 -1,
 -43229,
 1461825803,
 11265,
 -1,
 1461886217,
 11304,
 -43227,
 1461829672,
 11266,
 -43226,
 1462010822,
 11286,
 -43225,
 1462048624,
 11283,
 -43224,
 1462131583,
 11280,
 -43223,
 1462209104,
 11279,
 -43222,
 1462276136,
 11277,
 -43221,
 1462317082,
 11288,
 -43220,
 1462398740,
 11267,
 -43219,
 1462449257,
 11293,
 -1,
 1462508492,
 11264,
 -1,
 1454324654,
 10726,
 1462785873,
 1454269624,
 -1,
 1462851381,
 1462721832,
 -1,
 1462916916,
 1462781860,
 -1,
 -43213,
 1462864911,
 66369,
 -1,
 1462935551,
 66378,
 -1,
 1462843058,
 66365,
 1463179064,
 1462822282,
 -1,
 -43209,
 1463148707,
 66360,
 -1,
 1463191579,
 66372,
 1463375675,
 1463097501,
 -1,
 -43206,
 1463304121,
 66358,
 -1,
 1463354982,
 66375,
 1463572286,
 1463337874,
 -1,
 -43203,
 1463530435,
 66376,
 -1,
 1463564236,
 66359,
 1463768897,
 1463485235,
 -1,
 -43200,
 1463738751,
 66356,
 -1,
 1463766366,
 66352,
 -43198,
 1463700647,
 66373,
 -43197,
 1463929040,
 66367,
 -43196,
 1463969843,
 66371,
 -43195,
 1464025363,
 66370,
 -43194,
 1464087753,
 66357,
 -43193,
 1464162080,
 66368,
 -43192,
 1464208915,
 66377,
 -43191,
 1464320471,
 66364,
 -43190,
 1464388196,
 66363,
 -43189,
 1464428901,
 66362,
 -43188,
 1464508748,
 66366,
 -43187,
 1464541325,
 66354,
 -43186,
 1464634546,
 66374,
 -43185,
 1464688009,
 66361,
 -43184,
 1464732550,
 66355,
 -1,
 1464803103,
 66353,
 -1,
 1462750532,
 8503,
 1465080661,
 1382388023,
 -1,
 1465145885,
 1464992563,
 -1,
 1465211130,
 1465081128,
 -1,
 1465276551,
 1465153562,
 -1,
 1465341835,
 1465231246,
 -1,
 1465407328,
 1465312650,
 -1,
 1465472860,
 1465359608,
 -1,
 1465538395,
 1465440672,
 12108,
 -1,
 1465474680,
 12169,
 -1,
 1465457443,
 12143,
 1465735007,
 1465388332,
 -1,
 -43170,
 1465702816,
 12091,
 -1,
 1465737731,
 12115,
 -1,
 1465701203,
 12148,
 1465997159,
 1465375136,
 -1,
 1466062692,
 1465912620,
 -1,
 -43165,
 1466005511,
 12180,
 -1,
 1466065429,
 12141,
 -43163,
 1466022924,
 12076,
 -43162,
 1466185628,
 12052,
 -1,
 1466266954,
 12144,
 1466455920,
 1465959314,
 -1,
 1466521453,
 1466408184,
 -1,
 1466586988,
 1466446650,
 -1,
 -43157,
 1466546735,
 12083,
 -1,
 1466571933,
 12203,
 -1,
 1466509027,
 12087,
 1466892287,
 1466436908,
 -1,
 -43153,
 1466761988,
 12185,
 -1,
 1466865136,
 12154,
 1467045749,
 1466371372,
 -1,
 -43150,
 1466958578,
 12163,
 -43149,
 1467026732,
 12178,
 -43148,
 1467091617,
 12036,
 -1,
 1467179526,
 12057,
 1467373434,
 1467010703,
 -1,
 1467438969,
 1467286323,
 -1,
 -43144,
 1467383037,
 12202,
 -1,
 1467438754,
 12035,
 -1,
 1467402840,
 12122,
 1467701118,
 1467286323,
 -1,
 -43140,
 1467630201,
 12104,
 -43139,
 1467679530,
 12228,
 -1,
 1467803189,
 12223,
 1467963265,
 1467619485,
 -1,
 -43136,
 1467876129,
 12151,
 -1,
 1467961226,
 12135,
 1468159876,
 1467906928,
 -1,
 -43133,
 1468097843,
 12098,
 -1,
 1468196236,
 12064,
 -43131,
 1468075702,
 12130,
 -43130,
 1468297405,
 12103,
 -43129,
 1468385324,
 12101,
 -43128,
 1468403508,
 12211,
 -43127,
 1468488967,
 12089,
 -43126,
 1468588535,
 12073,
 -1,
 1468609001,
 12138,
 1468815267,
 1465301243,
 -1,
 1468880790,
 1468767480,
 -1,
 1468946321,
 1468851594,
 12034,
 1469054975,
 1468887351,
 -1,
 -43120,
 1468942257,
 12136,
 -1,
 1469023822,
 12084,
 -43118,
 1468906224,
 12044,
 -43117,
 1469166118,
 12120,
 -43116,
 1469196009,
 12094,
 -43115,
 1469286093,
 12125,
 -1,
 1469321700,
 12111,
 1469536156,
 1468799133,
 -1,
 1469601690,
 1469491086,
 -1,
 -43111,
 1469535433,
 12196,
 -1,
 1469629330,
 12139,
 -43109,
 1469515649,
 12056,
 -1,
 1469730278,
 12099,
 1469929376,
 1469494535,
 -1,
 -43106,
 1469858425,
 12082,
 -43105,
 1469935781,
 12238,
 -1,
 1469989742,
 12243,
 1470234623,
 1469844780,
 -1,
 -43102,
 1470141939,
 12229,
 -1,
 1470174169,
 12109,
 1470388154,
 1468743104,
 -1,
 1470453674,
 1470340344,
 -1,
 -43098,
 1470411589,
 12088,
 -43097,
 1470438179,
 12219,
 -43096,
 1470549240,
 12134,
 -43095,
 1470597144,
 12189,
 -1,
 1470652955,
 12168,
 1470846894,
 1470412039,
 -1,
 -43092,
 1470795372,
 12160,
 -43091,
 1470838407,
 12090,
 -1,
 1470934492,
 12096,
 1471109042,
 1470811791,
 -1,
 -43088,
 1471049923,
 12205,
 -43087,
 1471100813,
 12174,
 -1,
 1471156697,
 12234,
 1471371190,
 1471027357,
 -1,
 -43084,
 1471288315,
 12191,
 -43083,
 1471406792,
 12227,
 -1,
 1471448781,
 12068,
 1471633337,
 1471284019,
 -1,
 -43080,
 1471574888,
 12149,
 -1,
 1471656501,
 12184,
 -1,
 1471578285,
 12182,
 1471895503,
 1470358922,
 -1,
 1471961023,
 1471853831,
 -1,
 -43075,
 1471893938,
 12237,
 -43074,
 1471976897,
 12106,
 -1,
 1472008665,
 12145,
 1472223171,
 1471873843,
 -1,
 -43071,
 1472152846,
 12209,
 -43070,
 1472201476,
 12220,
 -1,
 1472303442,
 12047,
 1472485317,
 1472170225,
 12038,
 -1,
 1472414879,
 12086,
 1472616392,
 1472453869,
 -1,
 -43065,
 1472581728,
 12244,
 -1,
 1472598248,
 12081,
 1472813003,
 1472568568,
 -1,
 -43062,
 1472733804,
 12242,
 -1,
 1472790752,
 12166,
 1473009614,
 1472731293,
 -1,
 -43059,
 1472922360,
 12129,
 -1,
 1473026241,
 12172,
 -1,
 1472959925,
 12055,
 1473271778,
 1471825991,
 -1,
 1473337301,
 1473190045,
 -1,
 -43054,
 1473271458,
 12226,
 -43053,
 1473333670,
 12117,
 -43052,
 1473402726,
 12222,
 -1,
 1473497383,
 12133,
 1473664985,
 1473250099,
 -1,
 -43049,
 1473635004,
 12119,
 -43048,
 1473649446,
 12123,
 -1,
 1473739859,
 12207,
 1473927132,
 1473623303,
 -1,
 -43045,
 1473849019,
 12236,
 -1,
 1473940106,
 12217,
 1474123743,
 1473891983,
 -1,
 -43042,
 1474052729,
 12214,
 -1,
 1474107545,
 12245,
 -43040,
 1474092269,
 12113,
 -43039,
 1474246575,
 12188,
 -1,
 1474345030,
 12155,
 1474516981,
 1473215344,
 -1,
 1474582505,
 1474469112,
 -1,
 -43035,
 1474540357,
 12124,
 -43034,
 1474608012,
 12045,
 -43033,
 1474672556,
 12075,
 -43032,
 1474718904,
 12112,
 -1,
 1474759133,
 12170,
 1474975727,
 1474547343,
 -1,
 1475041261,
 1474888499,
 -1,
 -43028,
 1474999109,
 12118,
 -1,
 1475042600,
 12114,
 -43026,
 1475002670,
 12176,
 -1,
 1475176319,
 12058,
 1475368947,
 1474888499,
 -1,
 -43023,
 1475312893,
 12147,
 -43022,
 1475370524,
 12224,
 -1,
 1475430797,
 12190,
 -43020,
 1475293255,
 12194,
 -1,
 1475557483,
 12070,
 1475762185,
 1474474821,
 -1,
 1475827706,
 1475674931,
 -1,
 1475893241,
 1475740449,
 12193,
 -1,
 1475836249,
 12175,
 -1,
 1475837796,
 12116,
 1476089853,
 1475785991,
 -1,
 -43012,
 1476047156,
 12206,
 -1,
 1476092431,
 12051,
 1476286464,
 1476041976,
 -1,
 -43009,
 1476217269,
 12079,
 -1,
 1476278402,
 12069,
 1476483075,
 1476248998,
 -1,
 -43006,
 1476398380,
 12195,
 -1,
 1476507899,
 12213,
 1476679686,
 1476445074,
 -1,
 -43003,
 1476603963,
 12137,
 -1,
 1476690214,
 12230,
 1476919295,
 1476594988,
 -1,
 -43000,
 1476806453,
 12177,
 -1,
 1476861334,
 12110,
 1477072923,
 1475682900,
 -1,
 1477138452,
 1477025016,
 -1,
 1477203984,
 1477064545,
 -1,
 1477269519,
 1477139752,
 -1,
 -42994,
 1477239199,
 12077,
 -1,
 1477294331,
 12201,
 -1,
 1477222673,
 12061,
 1477531667,
 1477162247,
 -1,
 -42990,
 1477483876,
 12165,
 -1,
 1477521979,
 12192,
 -1,
 1477453464,
 12105,
 1477793815,
 1477056669,
 -1,
 -42986,
 1477764705,
 12162,
 -1,
 1477788026,
 12233,
 1477990426,
 1477709100,
 -1,
 -42983,
 1477904853,
 12128,
 -1,
 1477992987,
 12161,
 -1,
 1477927436,
 12040,
 1478252587,
 1477037711,
 -1,
 1478318114,
 1478167852,
 -1,
 1478383648,
 1478230835,
 -1,
 -42977,
 1478353596,
 12208,
 -1,
 1478379591,
 12212,
 -42975,
 1478340200,
 12041,
 -1,
 1478530494,
 12210,
 1478711334,
 1478236317,
 -1,
 -42972,
 1478630179,
 12033,
 -42971,
 1478729998,
 12131,
 -1,
 1478801659,
 12039,
 1478973480,
 1478668596,
 12199,
 -1,
 1478937180,
 12085,
 1479147519,
 1478886195,
 -1,
 -42966,
 1479020451,
 12074,
 -1,
 1479113796,
 12107,
 1479301181,
 1478214546,
 -1,
 1479366706,
 1479213875,
 -1,
 1479432240,
 1479331471,
 -1,
 -42961,
 1479396147,
 12121,
 -1,
 1479423217,
 12093,
 -42959,
 1479351072,
 12095,
 -1,
 1479591300,
 12221,
 1479759927,
 1479318776,
 -1,
 1479825462,
 1479718151,
 -1,
 -42955,
 1479759535,
 12218,
 -1,
 1479826728,
 12179,
 -1,
 1479747233,
 12037,
 1480087612,
 1479675180,
 -1,
 1480153147,
 1480000307,
 -1,
 -42950,
 1480083853,
 12092,
 -1,
 1480177915,
 12216,
 -1,
 1480089096,
 12231,
 -1,
 1480018796,
 12054,
 1480480842,
 1479216428,
 -1,
 1480546370,
 1480393523,
 -1,
 1480611905,
 1480504583,
 12159,
 -1,
 1480565009,
 12063,
 -1,
 1480582538,
 12215,
 1480808516,
 1480466069,
 12241,
 -1,
 1480738728,
 12067,
 1480939591,
 1480744232,
 -1,
 -42938,
 1480884068,
 12042,
 -1,
 1480948351,
 12062,
 -42936,
 1480892874,
 12140,
 -42935,
 1481089400,
 12235,
 -1,
 1481155134,
 12043,
 1481332822,
 1480439047,
 -1,
 1481398351,
 1481250973,
 -1,
 -42931,
 1481358220,
 12078,
 -42930,
 1481405153,
 12053,
 -1,
 1481473107,
 12150,
 1481660499,
 1481311027,
 -1,
 -42927,
 1481631114,
 12239,
 -42926,
 1481693600,
 12097,
 -1,
 1481754022,
 12204,
 -42924,
 1481601213,
 12187,
 -42923,
 1481848721,
 12071,
 -1,
 1481938372,
 12186,
 1482119263,
 1481279181,
 -1,
 1482184794,
 1482071288,
 12065,
 -42919,
 1482097397,
 12198,
 -1,
 1482219369,
 12066,
 1482381405,
 1482115497,
 -1,
 -42916,
 1482315409,
 12171,
 -1,
 1482409382,
 12146,
 -42914,
 1482349657,
 12225,
 -1,
 1482494914,
 12200,
 1482709094,
 1482086816,
 -1,
 1482774627,
 1482667271,
 -1,
 -42910,
 1482690611,
 12126,
 -1,
 1482783684,
 12059,
 -42908,
 1482687199,
 12050,
 -42907,
 1482885630,
 12158,
 -1,
 1482999221,
 12183,
 1483167853,
 1482661112,
 -1,
 1483233386,
 1483135392,
 -1,
 -42903,
 1483197364,
 12167,
 -1,
 1483259223,
 12048,
 1483429996,
 1483152163,
 12032,
 -1,
 1483401267,
 12080,
 -1,
 1483342581,
 12156,
 1483626612,
 1483080499,
 -1,
 1483692145,
 1483557270,
 -1,
 -42896,
 1483613915,
 12142,
 -1,
 1483679746,
 12164,
 -42894,
 1483657577,
 12100,
 -42893,
 1483807520,
 12157,
 -1,
 1483887641,
 12060,
 1484085369,
 1483562280,
 -1,
 1484150904,
 1484037368,
 -1,
 -42889,
 1484121482,
 12102,
 -1,
 1484150447,
 12240,
 -1,
 1484101098,
 12153,
 1484413054,
 1484003485,
 -1,
 1484478589,
 1484348712,
 -1,
 -42884,
 1484418227,
 12173,
 -1,
 1484487751,
 12072,
 -1,
 1484422227,
 12046,
 1484740737,
 1484354760,
 -1,
 -42880,
 1484662593,
 12197,
 -1,
 1484735858,
 12181,
 1484937348,
 1484706294,
 -1,
 -42877,
 1484895495,
 12152,
 -1,
 1484949510,
 12127,
 -42875,
 1484883977,
 12232,
 -42874,
 1485082216,
 12132,
 -1,
 1485154385,
 12049,
 1485373439,
 1465216927,
 -1,
 1485396175,
 1485243128,
 -1,
 1485461710,
 1485361813,
 -1,
 1485527185,
 1485403336,
 -1,
 1485592720,
 1485462835,
 -1,
 1485658254,
 1485550855,
 3211,
 -1,
 1485616391,
 3296,
 1485832191,
 1485622927,
 3212,
 -1,
 1485753999,
 3297,
 -1,
 1485505331,
 3253,
 1485985943,
 1485497738,
 -1,
 1486051477,
 1485956490,
 -1,
 -42860,
 1486010803,
 3232,
 -1,
 1486029619,
 3231,
 -42858,
 1486010803,
 3237,
 -1,
 1486160691,
 3236,
 1486379164,
 1485921576,
 -1,
 -42855,
 1486302244,
 3230,
 -42854,
 1486363421,
 3235,
 -42853,
 1486466707,
 3225,
 -1,
 1486488371,
 3240,
 1486706850,
 1486338299,
 -1,
 1486772384,
 1486665979,
 -1,
 -42849,
 1486731699,
 3234,
 -1,
 1486750515,
 3233,
 -42847,
 1486731699,
 3239,
 -1,
 1486881587,
 3238,
 1487100070,
 1486619443,
 3205,
 -42844,
 1487026017,
 3220,
 -42843,
 1487083677,
 3216,
 -1,
 1487143731,
 3206,
 1487362218,
 1487054734,
 -1,
 -42840,
 1487296172,
 3255,
 -42839,
 1487387059,
 3254,
 -1,
 1487405875,
 3256,
 1487624364,
 1487288161,
 3209,
 -1,
 1487550305,
 3210,
 1487755439,
 1487582471,
 -1,
 -42834,
 1487686057,
 3249,
 -1,
 1487733555,
 3248,
 1487952050,
 1487722912,
 -1,
 -42831,
 1487911347,
 3243,
 -1,
 1487930163,
 3242,
 1488148660,
 1487903992,
 3218,
 -1,
 1488100600,
 3219,
 1488279735,
 1488113295,
 -1,
 -42826,
 1488192254,
 3251,
 -1,
 1488257843,
 3250,
 1488476346,
 1488228663,
 -1,
 -42823,
 1488435635,
 3222,
 -1,
 1488454451,
 3221,
 1488672957,
 1488409292,
 -1,
 -42820,
 1488632243,
 3229,
 -1,
 1488651059,
 3228,
 1488869567,
 1488591005,
 3207,
 -1,
 1488787613,
 3208,
 1489000642,
 1488815821,
 -1,
 -42815,
 1488959923,
 3224,
 -1,
 1488978739,
 3223,
 1489197252,
 1488915756,
 3214,
 -1,
 1489112364,
 3215,
 1489328327,
 1489140592,
 -1,
 -42810,
 1489287603,
 3227,
 -1,
 1489306419,
 3226,
 1489524938,
 1489255872,
 -1,
 -42807,
 1489484211,
 3245,
 -1,
 1489503027,
 3244,
 -42805,
 1489447972,
 3247,
 -42804,
 1489637286,
 3246,
 -42803,
 1489746355,
 3257,
 -1,
 1489805567,
 3294,
 -1,
 1485403781,
 3285,
 1490049249,
 1485343797,
 -1,
 1490114773,
 1489961700,
 -1,
 1490180307,
 1490072839,
 3267,
 -1,
 1490138375,
 3268,
 1490354175,
 1490144911,
 3298,
 -1,
 1490275983,
 3299,
 1490442457,
 1490027315,
 -1,
 -42793,
 1490368353,
 3276,
 -42792,
 1490426013,
 3272,
 -1,
 1490486067,
 3262,
 1490704603,
 1490368353,
 3265,
 -1,
 1490630497,
 3266,
 1490835677,
 1490656504,
 3274,
 -1,
 1490787576,
 3275,
 1490966751,
 1490753693,
 3263,
 -1,
 1490884765,
 3264,
 1491140607,
 1490881836,
 3270,
 -1,
 1491012908,
 3271,
 1491228911,
 1490018673,
 -1,
 1491294437,
 1491199370,
 -1,
 -42780,
 1491241201,
 3304,
 -1,
 1491306515,
 3305,
 1491491048,
 1491249038,
 -1,
 -42777,
 1491453291,
 3308,
 -1,
 1491483262,
 3309,
 1491687659,
 1491421255,
 -1,
 -42774,
 1491636722,
 3306,
 -1,
 1491675138,
 3307,
 -42772,
 1491601763,
 3302,
 -42771,
 1491841336,
 3303,
 -42770,
 1491874358,
 3311,
 -1,
 1491976394,
 3310,
 1492146425,
 1491150085,
 -1,
 1492211955,
 1492090112,
 -1,
 -42766,
 1492171946,
 3203,
 -1,
 1492205041,
 3277,
 1492408566,
 1492124467,
 -1,
 -42763,
 1492351796,
 3261,
 -1,
 1492404458,
 3202,
 -42761,
 1492359791,
 3314,
 -42760,
 1492522212,
 3260,
 -1,
 1492636033,
 3313,
 -1,
 1492111942,
 3286,
 1492867461,
 1465169341,
 -1,
 1492932992,
 1492800553,
 -1,
 1492998524,
 1492854117,
 -1,
 1493063974,
 1492952974,
 -1,
 1493129505,
 1492982666,
 -1,
 1493195013,
 1493087495,
 -1,
 -42751,
 1493120865,
 12797,
 -42750,
 1493212408,
 12799,
 -42749,
 1493244061,
 12796,
 -42748,
 1493306668,
 12798,
 -1,
 1493369651,
 12795,
 1493588235,
 1493156754,
 -1,
 -42745,
 1493514081,
 12791,
 -42744,
 1493605624,
 12793,
 -42743,
 1493637277,
 12790,
 -42742,
 1493699884,
 12792,
 -1,
 1493762867,
 12789,
 1493981455,
 1493516921,
 -1,
 -42739,
 1493907297,
 12517,
 -42738,
 1493998840,
 12519,
 -1,
 1494025011,
 12515,
 1494243603,
 1493930295,
 -1,
 -42735,
 1494169441,
 12784,
 -42734,
 1494224172,
 12534,
 -1,
 1494287155,
 12533,
 1494505750,
 1494214026,
 -1,
 -42731,
 1494431585,
 12483,
 -1,
 1494523128,
 12787,
 1494702361,
 1494460302,
 -1,
 -42728,
 1494628193,
 12786,
 -1,
 1494685853,
 12785,
 -42726,
 1494649066,
 12526,
 -42725,
 1494824801,
 12453,
 -42724,
 1494916344,
 12457,
 -42723,
 1494948665,
 12788,
 -42722,
 1495011253,
 12794,
 -42721,
 1495079069,
 12451,
 -42720,
 1495141676,
 12455,
 -1,
 1495204659,
 12449,
 -42718,
 1493055329,
 12473,
 -42717,
 1495375096,
 12477,
 -42716,
 1495406749,
 12471,
 -42715,
 1495469356,
 12475,
 -1,
 1495532339,
 12469,
 1495750956,
 1492999464,
 12531,
 -42712,
 1495676769,
 12492,
 -42711,
 1495768312,
 12494,
 -42710,
 1495799965,
 12491,
 -42709,
 1495862572,
 12493,
 -1,
 1495925555,
 12490,
 1496144178,
 1495695307,
 -1,
 -42706,
 1496069985,
 12474,
 -42705,
 1496161528,
 12478,
 -42704,
 1496193181,
 12472,
 -42703,
 1496255788,
 12476,
 -1,
 1496318771,
 12470,
 1496537400,
 1496085704,
 -1,
 -42700,
 1496463201,
 12532,
 -42699,
 1496554744,
 12538,
 -42698,
 1496586397,
 12536,
 -42697,
 1496649004,
 12537,
 -1,
 1496711987,
 12535,
 1496930622,
 1496507786,
 -1,
 -42694,
 1496856417,
 12484,
 -42693,
 1496947960,
 12488,
 -42692,
 1496979613,
 12481,
 -42691,
 1497042220,
 12486,
 -1,
 1497105203,
 12479,
 1497323844,
 1496888583,
 -1,
 -42688,
 1497249633,
 12523,
 -42687,
 1497341176,
 12525,
 -42686,
 1497372829,
 12522,
 -42685,
 1497435436,
 12524,
 -1,
 1497498419,
 12521,
 1497717066,
 1497291168,
 -1,
 -42682,
 1497642849,
 12503,
 -42681,
 1497734392,
 12509,
 -42680,
 1497766045,
 12500,
 -42679,
 1497828652,
 12506,
 -1,
 1497891635,
 12497,
 1498110288,
 1497637460,
 -1,
 -42676,
 1498036065,
 12512,
 -42675,
 1498127608,
 12514,
 -42674,
 1498159261,
 12511,
 -42673,
 1498221868,
 12513,
 -1,
 1498284851,
 12510,
 1498503510,
 1498059063,
 -1,
 -42670,
 1498429281,
 12463,
 -42669,
 1498520824,
 12467,
 -42668,
 1498552477,
 12461,
 -42667,
 1498615084,
 12465,
 -1,
 1498678067,
 12459,
 1498896732,
 1498465170,
 -1,
 -42664,
 1498822497,
 12501,
 -42663,
 1498914040,
 12507,
 -42662,
 1498945693,
 12498,
 -42661,
 1499008300,
 12504,
 -1,
 1499071283,
 12495,
 1499289954,
 1498842829,
 -1,
 -42658,
 1499215713,
 12464,
 -42657,
 1499307256,
 12468,
 -42656,
 1499338909,
 12462,
 -42655,
 1499401516,
 12466,
 -1,
 1499464499,
 12460,
 1499683176,
 1499248891,
 -1,
 -42652,
 1499608929,
 12485,
 -42651,
 1499700472,
 12489,
 -42650,
 1499732125,
 12482,
 -42649,
 1499794732,
 12487,
 -1,
 1499857715,
 12480,
 1500076398,
 1499610560,
 -1,
 -42646,
 1500002145,
 12502,
 -42645,
 1500093688,
 12508,
 -42644,
 1500125341,
 12499,
 -42643,
 1500187948,
 12505,
 -1,
 1500250931,
 12496,
 1500469619,
 1500033861,
 -1,
 -42640,
 1500421368,
 12530,
 -42639,
 1500453021,
 12528,
 -42638,
 1500515628,
 12529,
 -1,
 1500578611,
 12527,
 1500797303,
 1500398201,
 -1,
 -42635,
 1500723041,
 12518,
 -42634,
 1500814584,
 12520,
 -1,
 1500840755,
 12516,
 -42632,
 1500723041,
 12454,
 -42631,
 1501011192,
 12458,
 -42630,
 1501042845,
 12452,
 -42629,
 1501105452,
 12456,
 -1,
 1501168435,
 12450,
 -42627,
 1492958007,
 12542,
 -42626,
 1501328350,
 12539,
 -42625,
 1501401571,
 12541,
 -1,
 1501474497,
 12543,
 1501691903,
 1492853954,
 -1,
 -42622,
 1501562452,
 12443,
 -42621,
 1501643325,
 12444,
 -42620,
 1501718591,
 12540,
 -1,
 1501805927,
 12448,
 1501977053,
 1492806747,
 -1,
 1502042561,
 1501898085,
 -1,
 1502108046,
 1502001403,
 -1,
 1502173580,
 1502066939,
 -1,
 -42614,
 1502132659,
 69787,
 -42613,
 1502185591,
 69786,
 -1,
 1502217011,
 69785,
 -42611,
 1502132659,
 69793,
 -1,
 1502348083,
 69792,
 1502566804,
 1502078346,
 -1,
 1502632338,
 1502537098,
 -1,
 -42607,
 1502591411,
 69784,
 -1,
 1502610227,
 69783,
 -42605,
 1502591411,
 69791,
 -1,
 1502741299,
 69790,
 1502960025,
 1502502184,
 -1,
 -42602,
 1502882852,
 69782,
 -42601,
 1502944029,
 69789,
 -42600,
 1503047315,
 69777,
 -1,
 1503068979,
 69794,
 1503287709,
 1502872371,
 69763,
 -42597,
 1503213409,
 69772,
 -42596,
 1503271069,
 69770,
 -1,
 1503331123,
 69764,
 1503549857,
 1503242126,
 -1,
 -42593,
 1503483564,
 69805,
 -42592,
 1503574451,
 69804,
 -1,
 1503593267,
 69806,
 1503812003,
 1503475553,
 69767,
 -1,
 1503737697,
 69768,
 1503943078,
 1503769863,
 -1,
 -42587,
 1503902131,
 69788,
 -1,
 1503920947,
 69801,
 1504139689,
 1503910304,
 -1,
 -42584,
 1504098739,
 69796,
 -1,
 1504117555,
 69795,
 1504336300,
 1504088375,
 -1,
 -42581,
 1504295347,
 69774,
 -1,
 1504314163,
 69773,
 1504532911,
 1504269004,
 -1,
 -42578,
 1504491955,
 69781,
 -1,
 1504510771,
 69780,
 1504729521,
 1504450717,
 69765,
 -1,
 1504647325,
 69766,
 1504860596,
 1504675533,
 -1,
 -42573,
 1504819635,
 69776,
 -1,
 1504838451,
 69775,
 1505057207,
 1504803696,
 -1,
 -42570,
 1505016243,
 69779,
 -1,
 1505035059,
 69778,
 1505253818,
 1504984512,
 -1,
 -42567,
 1505212851,
 69798,
 -1,
 1505231667,
 69797,
 -42565,
 1505176612,
 69800,
 -42564,
 1505393907,
 69803,
 -42563,
 1505467640,
 69771,
 -42562,
 1505496998,
 69799,
 -42561,
 1505559294,
 69802,
 -42560,
 1505671603,
 69807,
 -1,
 1505692972,
 69769,
 1505909196,
 1501989941,
 -1,
 1505974726,
 1505821491,
 -1,
 -42556,
 1505900385,
 69816,
 -42555,
 1505958045,
 69814,
 -1,
 1506018099,
 69808,
 1506236872,
 1505900385,
 69811,
 -1,
 1506162529,
 69812,
 1506367946,
 1506154653,
 69809,
 -1,
 1506285725,
 69810,
 -42549,
 1506319608,
 69815,
 -1,
 1506413868,
 69813,
 1506630101,
 1505863566,
 -1,
 1506695636,
 1506580986,
 -1,
 1506761169,
 1506639104,
 -1,
 -42544,
 1506720938,
 69762,
 -1,
 1506754033,
 69817,
 -42542,
 1506677988,
 69818,
 -42541,
 1506891934,
 69760,
 -1,
 1506951368,
 69761,
 -1,
 1506622163,
 69822,
 1507219930,
 1506588923,
 -1,
 1507285465,
 1507181390,
 -1,
 -42536,
 1507215320,
 69823,
 -1,
 1507284221,
 69825,
 -1,
 1507209949,
 69824,
 -42533,
 1507159552,
 69821,
 -42532,
 1507505751,
 69820,
 -1,
 1507535061,
 69819,
 1507786751,
 1501917278,
 -1,
 1507809794,
 1507665253,
 -1,
 1507875299,
 1507745064,
 -1,
 -42527,
 1507798052,
 43281,
 -42526,
 1507896979,
 43277,
 -1,
 1507918643,
 43284,
 1508137446,
 1507845514,
 -1,
 -42523,
 1508096435,
 43294,
 -1,
 1508115251,
 43282,
 1508334057,
 1508091790,
 -1,
 -42520,
 1508293043,
 43279,
 -1,
 1508311859,
 43278,
 1508530668,
 1508301216,
 -1,
 -42517,
 1508489651,
 43286,
 -1,
 1508508467,
 43285,
 1508727279,
 1508482296,
 -1,
 -42514,
 1508678904,
 43301,
 -1,
 1508707628,
 43299,
 1508923890,
 1508675895,
 -1,
 -42511,
 1508882867,
 43275,
 -1,
 1508901683,
 43274,
 1509120501,
 1508885394,
 -1,
 -42508,
 1509056994,
 43283,
 -1,
 1509098291,
 43295,
 -42506,
 1509076777,
 43280,
 -42505,
 1509239844,
 43291,
 -42504,
 1509329130,
 43293,
 -42503,
 1509391603,
 43296,
 -42502,
 1509444009,
 43290,
 -42501,
 1509494694,
 43287,
 -42500,
 1509556990,
 43292,
 -42499,
 1509628061,
 43300,
 -42498,
 1509731987,
 43276,
 -42497,
 1509787664,
 43288,
 -42496,
 1509850192,
 43297,
 -42495,
 1509937665,
 43289,
 -1,
 1509950259,
 43298,
 1510169104,
 1507778929,
 -1,
 1510234630,
 1510139274,
 -1,
 -42491,
 1510181105,
 43266,
 -1,
 1510246419,
 43267,
 1510431241,
 1510188942,
 -1,
 -42488,
 1510393195,
 43270,
 -1,
 1510423166,
 43271,
 1510627852,
 1510361159,
 -1,
 -42485,
 1510576626,
 43268,
 -1,
 1510615042,
 43269,
 -42483,
 1510541667,
 43264,
 -42482,
 1510781240,
 43265,
 -42481,
 1510814262,
 43273,
 -1,
 1510916298,
 43272,
 1511086614,
 1510108233,
 -1,
 1511152147,
 1511012193,
 43304,
 -1,
 1511066924,
 43302,
 1511283221,
 1511066924,
 43303,
 -1,
 1511197996,
 43305,
 -1,
 1511234808,
 43306,
 1511479834,
 1511020551,
 -1,
 1511545369,
 1511439697,
 43308,
 -1,
 1511473266,
 43309,
 -1,
 1511474206,
 43307,
 1511784447,
 1511400709,
 -1,
 -42468,
 1511712230,
 43311,
 -1,
 1511765196,
 43310,
 1511938896,
 1465107346,
 -1,
 1512004339,
 1511855277,
 -1,
 1512069767,
 1511958414,
 -1,
 1512135272,
 1511988087,
 -1,
 1512200760,
 1512102304,
 -1,
 1512266292,
 1512155100,
 -1,
 1512331825,
 1512223880,
 -1,
 1512397355,
 1512259008,
 -1,
 1512462888,
 1512359204,
 -1,
 -42457,
 1512402986,
 6649,
 -1,
 1512468183,
 6633,
 1512701951,
 1512398461,
 -1,
 -42454,
 1512599594,
 6648,
 -1,
 1512664791,
 6632,
 1512856110,
 1512359857,
 -1,
 -42451,
 1512796202,
 6647,
 -1,
 1512861399,
 6631,
 1513095167,
 1512768868,
 -1,
 -42448,
 1512992810,
 6646,
 -1,
 1513058007,
 6630,
 1513291775,
 1512264745,
 -1,
 -42445,
 1513189418,
 6645,
 -1,
 1513254615,
 6629,
 1513445943,
 1512212245,
 -1,
 -42442,
 1513386026,
 6642,
 -1,
 1513451223,
 6626,
 -1,
 1513380751,
 6624,
 1513708110,
 1512126219,
 -1,
 1513773643,
 1513665672,
 -1,
 1513839169,
 1513740704,
 -1,
 1513904702,
 1513754289,
 -1,
 -42435,
 1513844778,
 6655,
 -1,
 1513909975,
 6639,
 1514143743,
 1513850645,
 -1,
 -42432,
 1514041386,
 6652,
 -1,
 1514106583,
 6636,
 1514297928,
 1513766336,
 -1,
 1514363461,
 1514259748,
 -1,
 -42428,
 1514303530,
 6654,
 -1,
 1514368727,
 6638,
 1514602495,
 1514299005,
 -1,
 -42425,
 1514500138,
 6653,
 -1,
 1514565335,
 6637,
 1514799103,
 1514210660,
 -1,
 -42422,
 1514696746,
 6651,
 -1,
 1514761943,
 6635,
 1514995711,
 1513706537,
 -1,
 -42419,
 1514893354,
 6650,
 -1,
 1514958551,
 6634,
 1515149917,
 1513670412,
 -1,
 1515215448,
 1515116960,
 -1,
 1515280983,
 1515169756,
 6133,
 1515388927,
 1515238536,
 -1,
 1515412053,
 1515273664,
 -1,
 -42412,
 1515364416,
 6137,
 -1,
 1515427256,
 6136,
 -42410,
 1515347663,
 6135,
 -1,
 1515568918,
 6134,
 -1,
 1515242903,
 6130,
 1515805275,
 1515142592,
 -1,
 -42406,
 1515757632,
 6132,
 -1,
 1515820472,
 6131,
 -42404,
 1515760016,
 6128,
 -1,
 1515962134,
 6129,
 1516132964,
 1515077056,
 -1,
 1516198497,
 1516094756,
 -1,
 -42400,
 1516138538,
 6644,
 -1,
 1516203735,
 6628,
 1516437503,
 1516134013,
 -1,
 -42397,
 1516335146,
 6643,
 -1,
 1516400343,
 6627,
 1516591719,
 1516045668,
 -1,
 -42394,
 1516531754,
 6641,
 -1,
 1516596951,
 6625,
 -1,
 1516540702,
 6640,
 1516896255,
 1512086010,
 -1,
 1516919407,
 1516780992,
 -1,
 1516984942,
 1516831539,
 -1,
 -42388,
 1516907644,
 6099,
 -42387,
 1516999788,
 6101,
 -1,
 1517080925,
 6091,
 -1,
 1516936542,
 6104,
 1517312627,
 1516867895,
 -1,
 -42383,
 1517272869,
 6106,
 -42382,
 1517323384,
 6100,
 -1,
 1517389289,
 6094,
 1517574775,
 1517224755,
 -1,
 -42379,
 1517490665,
 6108,
 -42378,
 1517568757,
 6109,
 -1,
 1517627923,
 6095,
 1517836922,
 1517544842,
 -1,
 -42375,
 1517785518,
 6090,
 -1,
 1517853836,
 6093,
 1518033533,
 1517794567,
 -1,
 -42372,
 1517990677,
 6092,
 -1,
 1518060002,
 6087,
 1518230144,
 1517976432,
 -1,
 -42369,
 1518179069,
 6098,
 -1,
 1518234949,
 6102,
 -42367,
 1518177270,
 6088,
 -42366,
 1518344503,
 6097,
 -42365,
 1518461371,
 6096,
 -42364,
 1518471317,
 6105,
 -42363,
 1518543326,
 6086,
 -42362,
 1518604486,
 6089,
 -1,
 1518688146,
 6103,
 1518885560,
 1511990629,
 -1,
 1518951057,
 1518855562,
 -1,
 1519016588,
 1518903569,
 -1,
 -42357,
 1518968056,
 6029,
 -1,
 1518994227,
 6027,
 1519213199,
 1518977938,
 -1,
 -42354,
 1519164664,
 6034,
 -1,
 1519190835,
 6032,
 -42352,
 1519164664,
 6033,
 -1,
 1519321907,
 6031,
 1519540886,
 1518886184,
 -1,
 -42349,
 1519493549,
 6025,
 -42348,
 1519557880,
 6035,
 -42347,
 1519590170,
 6030,
 -1,
 1519693462,
 6020,
 1519868572,
 1519489335,
 -1,
 1519934106,
 1519829906,
 -1,
 -42343,
 1519885560,
 6019,
 -1,
 1519911731,
 6017,
 -42341,
 1519885560,
 6018,
 -1,
 1520042803,
 6016,
 1520261794,
 1519811440,
 -1,
 1520327328,
 1520223122,
 -1,
 -42337,
 1520278776,
 6024,
 -1,
 1520304947,
 6022,
 -42335,
 1520278776,
 6023,
 -1,
 1520436019,
 6021,
 1520655014,
 1520215950,
 -1,
 -42332,
 1520588453,
 6046,
 -42331,
 1520679347,
 6045,
 -1,
 1520698163,
 6047,
 1520917163,
 1520621984,
 -1,
 1520982698,
 1520878482,
 -1,
 -42327,
 1520934136,
 6039,
 -1,
 1520960307,
 6037,
 -1,
 1520934136,
 6038,
 1521244846,
 1520881295,
 -1,
 -42323,
 1521196280,
 6043,
 -1,
 1521222451,
 6049,
 1521441457,
 1521203451,
 -1,
 -42320,
 1521392888,
 6028,
 -1,
 1521419059,
 6026,
 -42318,
 1521394093,
 6041,
 -42317,
 1521581339,
 6044,
 -42316,
 1521633711,
 6042,
 -42315,
 1521696473,
 6050,
 -42314,
 1521749935,
 6040,
 -42313,
 1521858995,
 6048,
 -1,
 1521930753,
 6036,
 1522096847,
 1518824521,
 -1,
 1522162380,
 1522017541,
 -1,
 1522227903,
 1522074419,
 -1,
 -42308,
 1522153313,
 6085,
 -42307,
 1522210973,
 6083,
 -42306,
 1522273580,
 6082,
 -1,
 1522336563,
 6070,
 1522555586,
 1522156153,
 6073,
 -42303,
 1522483833,
 6074,
 -1,
 1522533171,
 6079,
 1522752197,
 1522480993,
 6075,
 -42300,
 1522677601,
 6076,
 -1,
 1522729779,
 6077,
 1522948808,
 1522669725,
 6071,
 -42297,
 1522866333,
 6072,
 -1,
 1522928940,
 6080,
 1523145419,
 1522900216,
 -1,
 -42294,
 1523096824,
 6084,
 -1,
 1523125548,
 6078,
 -1,
 1523060012,
 6081,
 1523449855,
 1522132351,
 -1,
 -42290,
 1523330365,
 6068,
 -1,
 1523385139,
 6069,
 1523604196,
 1522035478,
 -1,
 1523669728,
 1523526973,
 -1,
 1523735253,
 1523595105,
 6055,
 1523800788,
 1523660641,
 6057,
 -1,
 1523741896,
 6058,
 -1,
 1523749175,
 6056,
 1523997402,
 1523647283,
 -1,
 -42281,
 1523922785,
 6067,
 -42280,
 1523985725,
 6051,
 -42279,
 1524045981,
 6064,
 -1,
 1524106035,
 6052,
 1524325085,
 1523960446,
 -1,
 -42276,
 1524253979,
 6066,
 -1,
 1524347192,
 6065,
 1524521695,
 1524242589,
 6053,
 -1,
 1524439197,
 6054,
 -1,
 1524436268,
 6063,
 1524718306,
 1523599769,
 6059,
 -1,
 1524646521,
 6060,
 1524891647,
 1524630320,
 6061,
 -1,
 1524777593,
 6062,
 1524980466,
 1523573105,
 -1,
 1525045992,
 1524950410,
 -1,
 -42265,
 1524992241,
 6114,
 -1,
 1525057555,
 6115,
 1525242603,
 1525000078,
 -1,
 -42262,
 1525204331,
 6118,
 -1,
 1525234302,
 6119,
 1525439214,
 1525172295,
 -1,
 -42259,
 1525387762,
 6116,
 -1,
 1525426178,
 6117,
 -42257,
 1525352803,
 6112,
 -42256,
 1525592376,
 6113,
 -42255,
 1525625398,
 6121,
 -1,
 1525727434,
 6120,
 -1,
 1524944372,
 6107,
 1526005759,
 1511970821,
 -1,
 1526029091,
 1525884261,
 -1,
 1526094588,
 1525998986,
 -1,
 1526160122,
 1526064522,
 -1,
 -42248,
 1526120380,
 68147,
 -42247,
 1526184371,
 68123,
 -1,
 1526203187,
 68122,
 -42245,
 1526118835,
 68128,
 -1,
 1526334259,
 68127,
 1526553346,
 1526053115,
 -1,
 1526618880,
 1526511867,
 -1,
 -42241,
 1526577587,
 68125,
 -1,
 1526596403,
 68124,
 -42239,
 1526577587,
 68130,
 -1,
 1526727475,
 68129,
 1526946566,
 1526507406,
 -1,
 -42236,
 1526879916,
 68142,
 -42235,
 1526970803,
 68141,
 -1,
 1526989619,
 68143,
 1527208714,
 1526881576,
 -1,
 -42232,
 1527131172,
 68121,
 -42231,
 1527192349,
 68126,
 -1,
 1527251763,
 68131,
 1527470862,
 1527157047,
 -1,
 -42228,
 1527439311,
 68146,
 -42227,
 1527495091,
 68113,
 -1,
 1527513907,
 68112,
 1527733009,
 1527437728,
 -1,
 -42224,
 1527691699,
 68133,
 -1,
 1527710515,
 68132,
 1527929620,
 1527678669,
 -1,
 -42221,
 1527888307,
 68115,
 -1,
 1527907123,
 68114,
 1528126231,
 1527872368,
 -1,
 -42218,
 1528084915,
 68118,
 -1,
 1528103731,
 68117,
 1528322842,
 1528053184,
 -1,
 -42215,
 1528281523,
 68135,
 -1,
 1528300339,
 68134,
 -42213,
 1528278825,
 68144,
 -42212,
 1528441892,
 68137,
 -42211,
 1528528115,
 68140,
 -42210,
 1528580521,
 68138,
 -42209,
 1528631206,
 68136,
 -42208,
 1528693502,
 68139,
 -42207,
 1528812022,
 68119,
 -42206,
 1528871347,
 68145,
 -1,
 1528890163,
 68096,
 1529109297,
 1525965614,
 -1,
 1529174825,
 1529067771,
 -1,
 1529240360,
 1529126136,
 -1,
 -42201,
 1529206355,
 68183,
 -1,
 1529275786,
 68176,
 -1,
 1529164509,
 68182,
 1529502508,
 1529138831,
 -1,
 -42197,
 1529438444,
 68181,
 -1,
 1529499455,
 68184,
 1529699119,
 1529445232,
 -1,
 -42194,
 1529633988,
 68179,
 -1,
 1529723977,
 68178,
 -42192,
 1529650114,
 68177,
 -1,
 1529840289,
 68180,
 1530026811,
 1529050312,
 -1,
 1530092346,
 1529942724,
 -1,
 1530157881,
 1530012933,
 -1,
 -42187,
 1530103439,
 68099,
 -42186,
 1530148705,
 68098,
 -42185,
 1530240248,
 68102,
 -42184,
 1530271901,
 68097,
 -1,
 1530334508,
 68101,
 -1,
 1530074406,
 68108,
 -1,
 1530042205,
 68159,
 1530682179,
 1529947397,
 -1,
 1530747711,
 1530628093,
 -1,
 -42178,
 1530676289,
 68109,
 -1,
 1530758890,
 68154,
 -42176,
 1530692433,
 68111,
 -42175,
 1530901761,
 68153,
 -42174,
 1530975776,
 68152,
 -1,
 1531003080,
 68110,
 1531206474,
 1530614468,
 -1,
 1531272007,
 1531176330,
 -1,
 -42170,
 1531197536,
 68165,
 -1,
 1531286965,
 68164,
 1531510783,
 1531231366,
 -1,
 -42167,
 1531413342,
 68167,
 -1,
 1531461699,
 68166,
 1531707391,
 1531175281,
 -1,
 1531730766,
 1531635082,
 -1,
 -42163,
 1531676913,
 68161,
 -1,
 1531742227,
 68162,
 -42161,
 1531687224,
 68160,
 -1,
 1531850371,
 68163,
 1532058451,
 1511853356,
 -1,
 -42158,
 1531979265,
 9000,
 -1,
 1532071724,
 8490,
 -42156,
 1532015834,
 12927,
 -1,
 1532189694,
 8365,
 1532386854,
 1465021640,
 -1,
 1532452275,
 1532298035,
 -1,
 1532517554,
 1532413288,
 -1,
 1532583073,
 1532450417,
 -1,
 1532648590,
 1532520596,
 -1,
 1532713869,
 1532583208,
 -1,
 1532779368,
 1532659405,
 42507,
 1532844901,
 1532724941,
 -1,
 1532910432,
 1532759340,
 42500,
 -42145,
 1532845352,
 42501,
 -1,
 1532890412,
 42271,
 1533107042,
 1532861688,
 42460,
 -1,
 1533058296,
 42384,
 -42141,
 1533032289,
 42421,
 -42140,
 1533155485,
 42308,
 -1,
 1533215539,
 42348,
 -42138,
 1532765848,
 42428,
 -42137,
 1533384117,
 42467,
 -1,
 1533436428,
 42315,
 1533631350,
 1532737787,
 -1,
 1533696881,
 1533582584,
 42450,
 1533762416,
 1533659284,
 -1,
 -42132,
 1533716876,
 42514,
 -42131,
 1533743014,
 42538,
 -42130,
 1533861839,
 42513,
 -42129,
 1533911295,
 42512,
 -1,
 1533970429,
 42539,
 -1,
 1533713656,
 42374,
 1534221171,
 1533611308,
 42490,
 -1,
 1534135596,
 42261,
 -42124,
 1534146401,
 42411,
 -42123,
 1534269597,
 42298,
 -1,
 1534329651,
 42337,
 1534548862,
 1533559417,
 -1,
 1534614393,
 1534500088,
 42464,
 -1,
 1534565624,
 42388,
 1534745467,
 1534528812,
 42506,
 -1,
 1534659884,
 42275,
 -42116,
 1534670689,
 42425,
 -42115,
 1534793885,
 42312,
 -1,
 1534853939,
 42352,
 1535073158,
 1534481100,
 -1,
 1535138689,
 1535024376,
 42457,
 -1,
 1535089912,
 42381,
 1535269763,
 1535053100,
 42497,
 -1,
 1535184172,
 42268,
 -42108,
 1535194977,
 42418,
 -42107,
 1535318173,
 42305,
 -1,
 1535378227,
 42344,
 1535597448,
 1535024376,
 42463,
 -1,
 1535548664,
 42387,
 1535728522,
 1535511852,
 42505,
 -1,
 1535642924,
 42274,
 -42101,
 1535653729,
 42424,
 -42100,
 1535776925,
 42311,
 -1,
 1535836979,
 42351,
 1536056229,
 1532633684,
 -1,
 1536121750,
 1536011920,
 -1,
 1536187281,
 1536072952,
 42438,
 -1,
 1536138488,
 42363,
 1536318355,
 1536101676,
 42478,
 -1,
 1536232748,
 42250,
 -42092,
 1536243553,
 42400,
 -42091,
 1536366749,
 42287,
 -1,
 1536426803,
 42326,
 1536646046,
 1536048576,
 -1,
 1536711577,
 1536597240,
 42436,
 -1,
 1536662776,
 42361,
 1536842651,
 1536625964,
 42475,
 -1,
 1536757036,
 42248,
 -42084,
 1536767841,
 42398,
 -42083,
 1536891037,
 42285,
 -1,
 1536951091,
 42323,
 1537170336,
 1536597240,
 42462,
 -1,
 1537121528,
 42386,
 1537301410,
 1537084716,
 42504,
 -1,
 1537215788,
 42273,
 -42077,
 1537226593,
 42423,
 -42076,
 1537349789,
 42310,
 -1,
 1537409843,
 42350,
 1537629117,
 1536014587,
 -1,
 1537694646,
 1537590162,
 -1,
 1537760175,
 1537655698,
 -1,
 1537825706,
 1537711352,
 42446,
 -1,
 1537776888,
 42370,
 1537956780,
 1537740076,
 42486,
 -1,
 1537871148,
 42257,
 -42067,
 1537881953,
 42407,
 -42066,
 1538005149,
 42294,
 -1,
 1538065203,
 42333,
 1538284465,
 1537711352,
 42445,
 -1,
 1538235640,
 42369,
 1538415539,
 1538198828,
 42485,
 -1,
 1538329900,
 42256,
 -42060,
 1538340705,
 42406,
 -42059,
 1538463901,
 42293,
 -1,
 1538523955,
 42332,
 1538743224,
 1537645816,
 42449,
 -1,
 1538694392,
 42373,
 1538874298,
 1538657580,
 42489,
 -1,
 1538788652,
 42260,
 -42053,
 1538799457,
 42410,
 -42052,
 1538922653,
 42297,
 -1,
 1538982707,
 42336,
 1539202000,
 1537577271,
 -1,
 1539267528,
 1539168672,
 -1,
 1539333058,
 1539181868,
 42476,
 -42047,
 1539267880,
 42477,
 -1,
 1539312940,
 42249,
 1539529668,
 1539284216,
 42437,
 -1,
 1539480824,
 42362,
 1539660742,
 1539441459,
 42324,
 -1,
 1539595560,
 42325,
 -42041,
 1539585889,
 42399,
 -1,
 1539709085,
 42286,
 1539922890,
 1539218680,
 42459,
 -1,
 1539874040,
 42383,
 1540053964,
 1539837228,
 42499,
 -1,
 1539968300,
 42270,
 1540185038,
 1539965747,
 42346,
 -1,
 1540119848,
 42347,
 -42033,
 1540110177,
 42420,
 -1,
 1540233373,
 42307,
 1540447203,
 1539147469,
 -1,
 1540512731,
 1540373952,
 -1,
 1540578261,
 1540463864,
 42439,
 -42028,
 1540529400,
 42364,
 -1,
 1540578600,
 42440,
 1540774872,
 1540492588,
 42479,
 -42025,
 1540709672,
 42480,
 -1,
 1540754732,
 42251,
 -42023,
 1540700001,
 42401,
 -42022,
 1540888733,
 42288,
 -1,
 1540948787,
 42327,
 1541168094,
 1540427052,
 42502,
 -42019,
 1541102888,
 42503,
 -1,
 1541147948,
 42272,
 1541364704,
 1541119224,
 42461,
 -1,
 1541315832,
 42385,
 -42015,
 1541289825,
 42422,
 -42014,
 1541413021,
 42309,
 -1,
 1541473075,
 42349,
 1541692403,
 1540390859,
 -1,
 1541757932,
 1541653394,
 -1,
 1541823463,
 1541709048,
 42454,
 -1,
 1541774584,
 42378,
 1541954537,
 1541737772,
 42494,
 -1,
 1541868844,
 42265,
 -42006,
 1541879649,
 42415,
 -42005,
 1542002845,
 42302,
 -1,
 1542062899,
 42341,
 1542282222,
 1541709048,
 42453,
 -1,
 1542233336,
 42377,
 1542413296,
 1542196524,
 42493,
 -1,
 1542327596,
 42264,
 -41999,
 1542338401,
 42414,
 -41998,
 1542461597,
 42301,
 -1,
 1542521651,
 42340,
 1542740994,
 1541649221,
 -1,
 1542806520,
 1542692088,
 42431,
 1542872055,
 1542757624,
 42356,
 -1,
 1542806824,
 42357,
 -1,
 1542806824,
 42432,
 1543068668,
 1542720812,
 42470,
 1543134203,
 1542982956,
 42243,
 -1,
 1543068968,
 42244,
 -1,
 1543068968,
 42471,
 1543330814,
 1542993761,
 42393,
 -1,
 1543265576,
 42394,
 1543461888,
 1543248029,
 42280,
 -1,
 1543396648,
 42281,
 1543634943,
 1543373619,
 42318,
 -1,
 1543527720,
 42319,
 1543724050,
 1542710666,
 -1,
 1543789579,
 1543685010,
 -1,
 1543855110,
 1543740664,
 42444,
 -1,
 1543806200,
 42368,
 1543986184,
 1543769388,
 42484,
 -1,
 1543900460,
 42255,
 -41975,
 1543911265,
 42405,
 -41974,
 1544034461,
 42292,
 -1,
 1544094515,
 42331,
 1544313869,
 1543740664,
 42443,
 -1,
 1544264952,
 42367,
 1544444943,
 1544228140,
 42483,
 -1,
 1544359212,
 42254,
 -41968,
 1544370017,
 42404,
 -41967,
 1544493213,
 42291,
 -1,
 1544553267,
 42330,
 1544772642,
 1543677838,
 -1,
 1544838171,
 1544733586,
 -1,
 1544903702,
 1544789240,
 42452,
 -1,
 1544854776,
 42376,
 1545034776,
 1544817964,
 42492,
 -1,
 1544949036,
 42263,
 -41959,
 1544959841,
 42413,
 -41958,
 1545083037,
 42300,
 -1,
 1545143091,
 42339,
 1545362461,
 1544789240,
 42451,
 -1,
 1545313528,
 42375,
 1545493535,
 1545276716,
 42491,
 -1,
 1545407788,
 42262,
 -41952,
 1545418593,
 42412,
 -41951,
 1545541789,
 42299,
 -1,
 1545601843,
 42338,
 1545821234,
 1544699328,
 -1,
 1545886763,
 1545782162,
 -1,
 1545952294,
 1545837816,
 42434,
 -1,
 1545903352,
 42359,
 1546083368,
 1545866540,
 42473,
 -1,
 1545997612,
 42246,
 -41943,
 1546008417,
 42396,
 -41942,
 1546131613,
 42283,
 -1,
 1546191667,
 42321,
 1546411053,
 1545837816,
 42435,
 -1,
 1546362104,
 42360,
 1546542127,
 1546325292,
 42474,
 -1,
 1546456364,
 42247,
 -41936,
 1546467169,
 42397,
 -41935,
 1546590365,
 42284,
 -1,
 1546650419,
 42322,
 1546869823,
 1545782162,
 -1,
 1546935350,
 1546820856,
 42429,
 -41931,
 1546886392,
 42355,
 -1,
 1546935592,
 42430,
 1547131961,
 1546849580,
 42468,
 -41928,
 1547066664,
 42469,
 -1,
 1547111724,
 42242,
 1547328571,
 1547056993,
 42391,
 -1,
 1547263272,
 42392,
 1547459645,
 1547245725,
 42278,
 -1,
 1547394344,
 42279,
 1547632639,
 1547371315,
 42316,
 -1,
 1547525416,
 42317,
 1547721800,
 1546833551,
 -1,
 1547787331,
 1547636012,
 42487,
 -41918,
 1547736707,
 42508,
 -1,
 1547767084,
 42258,
 1547983941,
 1547738360,
 42447,
 -1,
 1547934968,
 42371,
 -41914,
 1547908961,
 42408,
 -41913,
 1548032157,
 42295,
 -1,
 1548092211,
 42334,
 1548311632,
 1547649657,
 -1,
 1548377163,
 1548262648,
 42458,
 -1,
 1548328184,
 42382,
 1548508237,
 1548291372,
 42498,
 -1,
 1548422444,
 42269,
 -41906,
 1548433249,
 42419,
 -41905,
 1548556445,
 42306,
 -1,
 1548616499,
 42345,
 1548835928,
 1548252360,
 -1,
 1548901459,
 1548786936,
 42442,
 -1,
 1548852472,
 42366,
 1549032533,
 1548815660,
 42482,
 -1,
 1548946732,
 42253,
 -41898,
 1548957537,
 42403,
 -41897,
 1549080733,
 42290,
 -1,
 1549140787,
 42329,
 1549360224,
 1548793095,
 -1,
 1549425755,
 1549311224,
 42448,
 -1,
 1549376760,
 42372,
 1549556829,
 1549339948,
 42488,
 -1,
 1549471020,
 42259,
 -41890,
 1549481825,
 42409,
 -41889,
 1549605021,
 42296,
 -1,
 1549665075,
 42335,
 1549884520,
 1549326752,
 -1,
 1549950051,
 1549835512,
 42433,
 -1,
 1549901048,
 42358,
 1550081125,
 1549864236,
 42472,
 -1,
 1549995308,
 42245,
 -41882,
 1550006113,
 42395,
 -41881,
 1550129309,
 42282,
 -1,
 1550189363,
 42320,
 1550408816,
 1549816524,
 -1,
 1550474347,
 1550359800,
 42456,
 -1,
 1550425336,
 42380,
 1550605421,
 1550388524,
 42496,
 -1,
 1550519596,
 42267,
 -41874,
 1550530401,
 42417,
 -41873,
 1550653597,
 42304,
 -1,
 1550713651,
 42343,
 1550933112,
 1550338119,
 -1,
 1550998643,
 1550884088,
 42441,
 -1,
 1550949624,
 42365,
 1551129717,
 1550912812,
 42481,
 -1,
 1551043884,
 42252,
 -41866,
 1551054689,
 42402,
 -41865,
 1551177885,
 42289,
 -1,
 1551237939,
 42328,
 1551457408,
 1550875504,
 -1,
 1551522939,
 1551408376,
 42455,
 -1,
 1551473912,
 42379,
 1551654013,
 1551437100,
 42495,
 -1,
 1551568172,
 42266,
 -41858,
 1551578977,
 42416,
 -41857,
 1551702173,
 42303,
 -1,
 1551762227,
 42342,
 1551981700,
 1551408376,
 42426,
 1552047235,
 1551932664,
 42353,
 -1,
 1551981864,
 42354,
 -1,
 1551981864,
 42427,
 1552243848,
 1551895852,
 42465,
 1552309383,
 1552157996,
 42240,
 -1,
 1552244008,
 42241,
 -1,
 1552244008,
 42466,
 1552505994,
 1552168801,
 42389,
 -1,
 1552440616,
 42390,
 1552637068,
 1552423069,
 42276,
 -1,
 1552571688,
 42277,
 1552809983,
 1552548659,
 42313,
 -1,
 1552702760,
 42314,
 1552941055,
 1532591112,
 -1,
 1552964755,
 1552868746,
 -1,
 -41839,
 1552920884,
 42525,
 -41838,
 1552959400,
 42517,
 -1,
 1553031653,
 42521,
 1553226904,
 1552922875,
 -1,
 1553292439,
 1553177848,
 -1,
 -41834,
 1553248564,
 42523,
 -1,
 1553290245,
 42526,
 -1,
 1553257303,
 42522,
 1553554587,
 1553174839,
 -1,
 -41830,
 1553477642,
 42524,
 -1,
 1553590363,
 42516,
 1553751198,
 1553483847,
 -1,
 -41827,
 1553721435,
 42515,
 -1,
 1553752549,
 42520,
 -41825,
 1553719685,
 42518,
 -41824,
 1553865713,
 42527,
 -1,
 1553980771,
 42519,
 1554144431,
 1532551537,
 -1,
 1554209957,
 1554113930,
 -1,
 -41820,
 1554155761,
 42530,
 -1,
 1554221075,
 42531,
 1554406568,
 1554163598,
 -1,
 -41817,
 1554367851,
 42534,
 -1,
 1554397822,
 42535,
 1554603179,
 1554335815,
 -1,
 -41814,
 1554551282,
 42532,
 -1,
 1554589698,
 42533,
 -41812,
 1554516323,
 42528,
 -41811,
 1554755896,
 42529,
 -41810,
 1554788918,
 42537,
 -1,
 1554890954,
 42536,
 -41808,
 1554101987,
 42511,
 -41807,
 1554974231,
 42510,
 -1,
 1555080695,
 42509,
 1555300351,
 1532479860,
 -1,
 1555324194,
 1555218088,
 65024,
 1555389631,
 1555289348,
 917762,
 -41802,
 1555354884,
 917942,
 -41801,
 1555404809,
 917941,
 -41800,
 1555454082,
 917940,
 -41799,
 1555504754,
 917939,
 -41798,
 1555614278,
 917938,
 -41797,
 1555664013,
 917937,
 -41796,
 1555713645,
 917936,
 -41795,
 1555764240,
 917935,
 -41794,
 1555873448,
 917934,
 -1,
 1555923534,
 917933,
 1556110538,
 1555339273,
 917761,
 -41791,
 1556075780,
 917932,
 -41790,
 1556125705,
 917931,
 -41789,
 1556174978,
 917930,
 -41788,
 1556225650,
 917929,
 -41787,
 1556335174,
 917928,
 -41786,
 1556384909,
 917927,
 -41785,
 1556434541,
 917926,
 -41784,
 1556485136,
 917925,
 -41783,
 1556594344,
 917924,
 -1,
 1556644430,
 917923,
 1556831445,
 1556043906,
 917760,
 -41780,
 1556796676,
 917922,
 -41779,
 1556846601,
 917921,
 -41778,
 1556895874,
 917920,
 -41777,
 1556946546,
 917919,
 -41776,
 1557056070,
 917918,
 -41775,
 1557105805,
 917917,
 -41774,
 1557155437,
 917916,
 -41773,
 1557206032,
 917915,
 -41772,
 1557315240,
 917914,
 -1,
 1557365326,
 917913,
 1557552352,
 1556749938,
 65039,
 -41769,
 1557517572,
 917912,
 -41768,
 1557567497,
 917911,
 -41767,
 1557616770,
 917910,
 -41766,
 1557667442,
 917909,
 -41765,
 1557776966,
 917908,
 -41764,
 1557826701,
 917907,
 -41763,
 1557876333,
 917906,
 -41762,
 1557926928,
 917905,
 -41761,
 1558036136,
 917904,
 -1,
 1558086222,
 917903,
 1558273259,
 1557514822,
 65038,
 -41758,
 1558238468,
 917902,
 -41757,
 1558288393,
 917901,
 -41756,
 1558337666,
 917900,
 -41755,
 1558388338,
 917899,
 -41754,
 1558497862,
 917898,
 -41753,
 1558547597,
 917897,
 -41752,
 1558597229,
 917896,
 -41751,
 1558647824,
 917895,
 -41750,
 1558757032,
 917894,
 -1,
 1558807118,
 917893,
 1558994166,
 1558219917,
 65037,
 -41747,
 1558959364,
 917892,
 -41746,
 1559009289,
 917891,
 -41745,
 1559058562,
 917890,
 -41744,
 1559109234,
 917889,
 -41743,
 1559218758,
 917888,
 -41742,
 1559268493,
 917887,
 -41741,
 1559318125,
 917886,
 -41740,
 1559368720,
 917885,
 -41739,
 1559477928,
 917884,
 -1,
 1559528014,
 917883,
 1559715073,
 1558924909,
 65036,
 -41736,
 1559680260,
 917882,
 -41735,
 1559730185,
 917881,
 -41734,
 1559779458,
 917880,
 -41733,
 1559830130,
 917879,
 -41732,
 1559939654,
 917878,
 -41731,
 1559989389,
 917877,
 -41730,
 1560039021,
 917876,
 -41729,
 1560089616,
 917875,
 -41728,
 1560198824,
 917874,
 -1,
 1560248910,
 917873,
 1560435980,
 1559630864,
 65035,
 -41725,
 1560401156,
 917872,
 -41724,
 1560451081,
 917871,
 -41723,
 1560500354,
 917870,
 -41722,
 1560551026,
 917869,
 -41721,
 1560660550,
 917868,
 -41720,
 1560710285,
 917867,
 -41719,
 1560759917,
 917866,
 -41718,
 1560810512,
 917865,
 -41717,
 1560919720,
 917864,
 -1,
 1560969806,
 917863,
 1561156887,
 1560395432,
 65034,
 -41714,
 1561122052,
 917862,
 -41713,
 1561171977,
 917861,
 -41712,
 1561221250,
 917860,
 -41711,
 1561271922,
 917859,
 -41710,
 1561381446,
 917858,
 -41709,
 1561431181,
 917857,
 -41708,
 1561480813,
 917856,
 -41707,
 1561531408,
 917855,
 -41706,
 1561640616,
 917854,
 -1,
 1561690702,
 917853,
 1561919487,
 1561100878,
 65033,
 -41703,
 1561842948,
 917852,
 -41702,
 1561892873,
 917851,
 -41701,
 1561942146,
 917850,
 -41700,
 1561992818,
 917849,
 -41699,
 1562102342,
 917848,
 -41698,
 1562152077,
 917847,
 -41697,
 1562201709,
 917846,
 -41696,
 1562252304,
 917845,
 -41695,
 1562361512,
 917844,
 -1,
 1562411598,
 917843,
 1562598758,
 1555239952,
 65025,
 1562664238,
 1562545293,
 917767,
 -41691,
 1562629380,
 917992,
 -41690,
 1562679305,
 917991,
 -41689,
 1562728578,
 917990,
 -41688,
 1562779250,
 917989,
 -41687,
 1562888774,
 917988,
 -41686,
 1562938509,
 917987,
 -41685,
 1562988141,
 917986,
 -41684,
 1563038736,
 917985,
 -41683,
 1563147944,
 917984,
 -1,
 1563198030,
 917983,
 1563385145,
 1562594925,
 917766,
 -41680,
 1563350276,
 917982,
 -41679,
 1563400201,
 917981,
 -41678,
 1563449474,
 917980,
 -41677,
 1563500146,
 917979,
 -41676,
 1563609670,
 917978,
 -41675,
 1563659405,
 917977,
 -41674,
 1563709037,
 917976,
 -41673,
 1563759632,
 917975,
 -41672,
 1563868840,
 917974,
 -1,
 1563918926,
 917973,
 1564106052,
 1563300880,
 917765,
 -41669,
 1564071172,
 917972,
 -41668,
 1564121097,
 917971,
 -41667,
 1564170370,
 917970,
 -41666,
 1564221042,
 917969,
 -41665,
 1564330566,
 917968,
 -41664,
 1564380301,
 917967,
 -41663,
 1564429933,
 917966,
 -41662,
 1564480528,
 917965,
 -41661,
 1564589736,
 917964,
 -1,
 1564639822,
 917963,
 1564826959,
 1564065448,
 917764,
 -41658,
 1564792068,
 917962,
 -41657,
 1564841993,
 917961,
 -41656,
 1564891266,
 917960,
 -41655,
 1564941938,
 917959,
 -41654,
 1565051462,
 917958,
 -41653,
 1565101197,
 917957,
 -41652,
 1565150829,
 917956,
 -41651,
 1565201424,
 917955,
 -41650,
 1565310632,
 917954,
 -1,
 1565360718,
 917953,
 1565547866,
 1564770894,
 917763,
 -41647,
 1565512964,
 917952,
 -41646,
 1565562889,
 917951,
 -41645,
 1565612162,
 917950,
 -41644,
 1565662834,
 917949,
 -41643,
 1565772358,
 917948,
 -41642,
 1565822093,
 917947,
 -41641,
 1565871725,
 917946,
 -41640,
 1565922320,
 917945,
 -41639,
 1566031528,
 917944,
 -1,
 1566081614,
 917943,
 1566268770,
 1565510214,
 917768,
 -41636,
 1566187122,
 917999,
 -41635,
 1566296646,
 917998,
 -41634,
 1566346381,
 917997,
 -41633,
 1566396013,
 917996,
 -41632,
 1566446608,
 917995,
 -41631,
 1566555816,
 917994,
 -1,
 1566605902,
 917993,
 -41629,
 1566233860,
 917772,
 -41628,
 1566742537,
 917771,
 -41627,
 1566791810,
 917770,
 -1,
 1566842482,
 917769,
 1567055217,
 1562563844,
 65032,
 -41624,
 1567020292,
 917842,
 -41623,
 1567070217,
 917841,
 -41622,
 1567119490,
 917840,
 -41621,
 1567170162,
 917839,
 -41620,
 1567279686,
 917838,
 -41619,
 1567329421,
 917837,
 -41618,
 1567379053,
 917836,
 -41617,
 1567429648,
 917835,
 -41616,
 1567538856,
 917834,
 -1,
 1567588942,
 917833,
 1567776124,
 1567004681,
 65031,
 -41613,
 1567741188,
 917832,
 -41612,
 1567791113,
 917831,
 -41611,
 1567840386,
 917830,
 -41610,
 1567891058,
 917829,
 -41609,
 1568000582,
 917828,
 -41608,
 1568050317,
 917827,
 -41607,
 1568099949,
 917826,
 -41606,
 1568150544,
 917825,
 -41605,
 1568259752,
 917824,
 -1,
 1568309838,
 917823,
 1568497031,
 1567709314,
 65030,
 -41602,
 1568462084,
 917822,
 -41601,
 1568512009,
 917821,
 -41600,
 1568561282,
 917820,
 -41599,
 1568611954,
 917819,
 -41598,
 1568721478,
 917818,
 -41597,
 1568771213,
 917817,
 -41596,
 1568820845,
 917816,
 -41595,
 1568871440,
 917815,
 -41594,
 1568980648,
 917814,
 -1,
 1569030734,
 917813,
 1569217938,
 1568415346,
 65029,
 -41591,
 1569182980,
 917812,
 -41590,
 1569232905,
 917811,
 -41589,
 1569282178,
 917810,
 -41588,
 1569332850,
 917809,
 -41587,
 1569442374,
 917808,
 -41586,
 1569492109,
 917807,
 -41585,
 1569541741,
 917806,
 -41584,
 1569592336,
 917805,
 -41583,
 1569701544,
 917804,
 -1,
 1569751630,
 917803,
 1569938845,
 1569180230,
 65028,
 -41580,
 1569903876,
 917802,
 -41579,
 1569953801,
 917801,
 -41578,
 1570003074,
 917800,
 -41577,
 1570053746,
 917799,
 -41576,
 1570163270,
 917798,
 -41575,
 1570213005,
 917797,
 -41574,
 1570262637,
 917796,
 -41573,
 1570313232,
 917795,
 -41572,
 1570422440,
 917794,
 -1,
 1570472526,
 917793,
 1570659752,
 1569885325,
 65027,
 -41569,
 1570624772,
 917792,
 -41568,
 1570674697,
 917791,
 -41567,
 1570723970,
 917790,
 -41566,
 1570774642,
 917789,
 -41565,
 1570884166,
 917788,
 -41564,
 1570933901,
 917787,
 -41563,
 1570983533,
 917786,
 -41562,
 1571034128,
 917785,
 -41561,
 1571143336,
 917784,
 -1,
 1571193422,
 917783,
 1571422207,
 1570590317,
 65026,
 -41558,
 1571345668,
 917782,
 -41557,
 1571395593,
 917781,
 -41556,
 1571444866,
 917780,
 -41555,
 1571495538,
 917779,
 -41554,
 1571605062,
 917778,
 -41553,
 1571654797,
 917777,
 -41552,
 1571704429,
 917776,
 -41551,
 1571755024,
 917775,
 -41550,
 1571864232,
 917774,
 -1,
 1571914318,
 917773,
 1572101637,
 1532366124,
 -1,
 1572167139,
 1572027925,
 -1,
 1572232654,
 1572087045,
 -1,
 1572298174,
 1572143923,
 -1,
 1572363709,
 1572265800,
 -1,
 1572429242,
 1572298894,
 7403,
 -1,
 1572360564,
 7404,
 -41541,
 1572371861,
 7409,
 -41540,
 1572497953,
 7402,
 -1,
 1572590494,
 7401,
 -1,
 1572276756,
 7410,
 1572822468,
 1572250443,
 -1,
 1572888001,
 1572777406,
 7395,
 -1,
 1572819316,
 7399,
 1573019075,
 1572802450,
 7397,
 -1,
 1572950388,
 7400,
 -1,
 1572931810,
 7394,
 1573215689,
 1572779271,
 -1,
 1573281224,
 1573148501,
 -1,
 -41529,
 1573236158,
 7396,
 -1,
 1573261202,
 7398,
 -1,
 1573208211,
 7408,
 -41526,
 1573173847,
 7380,
 -41525,
 1573487688,
 7405,
 -41524,
 1573558290,
 7379,
 -41523,
 1573616596,
 7407,
 -1,
 1573660286,
 7406,
 1573912575,
 1572165639,
 -1,
 1573936596,
 1573799252,
 -1,
 1574002130,
 1573853365,
 7383,
 -1,
 1573949971,
 7385,
 -41517,
 1573928893,
 7382,
 -1,
 1574083229,
 7381,
 1574264280,
 1573905802,
 -1,
 -41514,
 1574181120,
 7390,
 -41513,
 1574295538,
 7387,
 -1,
 1574324383,
 7391,
 1574526427,
 1574232015,
 -1,
 -41510,
 1574482551,
 7388,
 -1,
 1574515901,
 7376,
 1574723038,
 1574471677,
 -1,
 -41507,
 1574664999,
 7386,
 -1,
 1574733546,
 7389,
 -41505,
 1574648936,
 7377,
 -41504,
 1574857940,
 7392,
 -41503,
 1574899732,
 7378,
 -41502,
 1575014693,
 7384,
 -1,
 1575073790,
 7393,
 1575247363,
 1572123911,
 -1,
 1575312895,
 1575158450,
 -1,
 1575378413,
 1575276073,
 124,
 1575485439,
 1575310377,
 -1,
 1575509484,
 1575400871,
 -1,
 1575575019,
 1575458883,
 -1,
 -41494,
 1575532662,
 10992,
 -1,
 1575576805,
 10991,
 -1,
 1575515102,
 9087,
 -1,
 1575477251,
 9168,
 1575902708,
 1575309308,
 -1,
 1575968242,
 1575838975,
 12337,
 1576075263,
 1575900201,
 -1,
 -41487,
 1575944901,
 12339,
 -1,
 1576028297,
 12341,
 1576271871,
 1575882030,
 12338,
 -1,
 1576176002,
 12340,
 1576361465,
 1575848361,
 -1,
 -41482,
 1576327715,
 10186,
 -41481,
 1576382505,
 10978,
 -41480,
 1576462169,
 10980,
 -1,
 1576480955,
 10704,
 -41478,
 1576308033,
 10650,
 -41477,
 1576604730,
 11823,
 -41476,
 1576718852,
 9896,
 -41475,
 1576747604,
 12347,
 -41474,
 1576821129,
 8286,
 -1,
 1576901648,
 8942,
 1577082370,
 1575249904,
 -1,
 -41471,
 1576998503,
 8920,
 -1,
 1577114536,
 8921,
 -1,
 1577040520,
 8483,
 -41468,
 1575162167,
 9910,
 -1,
 1577306083,
 10799,
 1577475617,
 1572037171,
 -1,
 1577541138,
 1577434246,
 -1,
 1577606666,
 1577510282,
 -1,
 -41463,
 1577527663,
 8531,
 -1,
 1577628974,
 8530,
 1577803277,
 1577559950,
 -1,
 -41460,
 1577721713,
 8537,
 -1,
 1577822859,
 8528,
 -41458,
 1577761750,
 188,
 -41457,
 1577911537,
 8529,
 -41456,
 1578007429,
 189,
 -41455,
 1578053862,
 8533,
 -1,
 1578113356,
 8539,
 1578327578,
 1577510282,
 -1,
 1578393111,
 1578289635,
 -1,
 -41451,
 1578351130,
 190,
 -41450,
 1578424360,
 8535,
 -1,
 1578452084,
 8540,
 1578696703,
 1578360599,
 -1,
 -41447,
 1578586858,
 8532,
 -1,
 1578686504,
 8534,
 1578851871,
 1578256455,
 -1,
 1578917406,
 1578791955,
 -1,
 -41443,
 1578868630,
 8538,
 -1,
 1578910836,
 8541,
 -1,
 1578862744,
 8536,
 -41440,
 1578810084,
 8585,
 -1,
 1579136265,
 8542,
 1579310629,
 1577392285,
 -1,
 -41437,
 1579241035,
 9805,
 -41436,
 1579323651,
 8983,
 -1,
 1579366886,
 9996,
 -1,
 1579278389,
 8752,
 1579639077,
 1532344571,
 -1,
 1579704156,
 1579588856,
 -1,
 1579769503,
 1579637772,
 -1,
 1579834980,
 1579732780,
 -1,
 1579900515,
 1579767021,
 -1,
 1579966003,
 1579859392,
 -1,
 -41427,
 1579884146,
 127123,
 -41426,
 1579993670,
 127122,
 -41425,
 1580043405,
 127121,
 -41424,
 1580093037,
 127120,
 -41423,
 1580143632,
 127119,
 -41422,
 1580252840,
 127118,
 -1,
 1580302926,
 127117,
 1580490299,
 1579899609,
 -1,
 -41419,
 1580408434,
 127116,
 -41418,
 1580517958,
 127115,
 -41417,
 1580567693,
 127114,
 -41416,
 1580617325,
 127113,
 -41415,
 1580667920,
 127112,
 -41414,
 1580777128,
 127111,
 -1,
 1580827214,
 127110,
 1581014595,
 1580421009,
 -1,
 -41411,
 1580932722,
 127109,
 -41410,
 1581042246,
 127108,
 -41409,
 1581091981,
 127107,
 -41408,
 1581141613,
 127106,
 -41407,
 1581192208,
 127105,
 -41406,
 1581301416,
 127104,
 -1,
 1581351502,
 127103,
 1581538891,
 1580946377,
 -1,
 -41403,
 1581457010,
 127102,
 -41402,
 1581566534,
 127101,
 -41401,
 1581616269,
 127100,
 -41400,
 1581665901,
 127099,
 -41399,
 1581716496,
 127098,
 -41398,
 1581825704,
 127097,
 -1,
 1581875790,
 127096,
 1582063187,
 1581476034,
 -1,
 -41395,
 1581981298,
 127095,
 -41394,
 1582090822,
 127094,
 -41393,
 1582140557,
 127093,
 -41392,
 1582190189,
 127092,
 -41391,
 1582240784,
 127091,
 -41390,
 1582349992,
 127090,
 -1,
 1582400078,
 127089,
 1582587483,
 1582001683,
 -1,
 -41387,
 1582505586,
 127088,
 -41386,
 1582615110,
 127087,
 -41385,
 1582664845,
 127086,
 -41384,
 1582714477,
 127085,
 -41383,
 1582765072,
 127084,
 -41382,
 1582874280,
 127083,
 -1,
 1582924366,
 127082,
 1583153151,
 1582522617,
 -1,
 -41379,
 1583029874,
 127081,
 -41378,
 1583139398,
 127080,
 -41377,
 1583189133,
 127079,
 -41376,
 1583238765,
 127078,
 -41375,
 1583289360,
 127077,
 -41374,
 1583398568,
 127076,
 -1,
 1583448654,
 127075,
 -1,
 1579815941,
 127074,
 1583742975,
 1579777826,
 -1,
 1583767198,
 1583633645,
 -1,
 1583832686,
 1583726016,
 -1,
 -41368,
 1583750770,
 127073,
 -41367,
 1583860294,
 127072,
 -41366,
 1583910029,
 127071,
 -41365,
 1583959661,
 127070,
 -41364,
 1584010256,
 127069,
 -41363,
 1584119464,
 127068,
 -1,
 1584169550,
 127067,
 1584356982,
 1583766233,
 -1,
 -41360,
 1584275058,
 127066,
 -41359,
 1584384582,
 127065,
 -41358,
 1584434317,
 127064,
 -41357,
 1584483949,
 127063,
 -41356,
 1584534544,
 127062,
 -41355,
 1584643752,
 127061,
 -1,
 1584693838,
 127060,
 1584881278,
 1584287633,
 -1,
 -41352,
 1584799346,
 127059,
 -41351,
 1584908870,
 127058,
 -41350,
 1584958605,
 127057,
 -41349,
 1585008237,
 127056,
 -41348,
 1585058832,
 127055,
 -41347,
 1585168040,
 127054,
 -1,
 1585218126,
 127053,
 1585405574,
 1584813001,
 -1,
 -41344,
 1585323634,
 127052,
 -41343,
 1585433158,
 127051,
 -41342,
 1585482893,
 127050,
 -41341,
 1585532525,
 127049,
 -41340,
 1585583120,
 127048,
 -41339,
 1585692328,
 127047,
 -1,
 1585742414,
 127046,
 1585929870,
 1585342658,
 -1,
 -41336,
 1585847922,
 127045,
 -41335,
 1585957446,
 127044,
 -41334,
 1586007181,
 127043,
 -41333,
 1586056813,
 127042,
 -41332,
 1586107408,
 127041,
 -41331,
 1586216616,
 127040,
 -1,
 1586266702,
 127039,
 1586454166,
 1585868307,
 -1,
 -41328,
 1586372210,
 127038,
 -41327,
 1586481734,
 127037,
 -41326,
 1586531469,
 127036,
 -41325,
 1586581101,
 127035,
 -41324,
 1586631696,
 127034,
 -41323,
 1586740904,
 127033,
 -1,
 1586790990,
 127032,
 1587019775,
 1586389241,
 -1,
 -41320,
 1586896498,
 127031,
 -41319,
 1587006022,
 127030,
 -41318,
 1587055757,
 127029,
 -41317,
 1587105389,
 127028,
 -41316,
 1587155984,
 127027,
 -41315,
 1587265192,
 127026,
 -1,
 1587315278,
 127025,
 -1,
 1583682565,
 127024,
 1587568395,
 1579735582,
 -1,
 1587633894,
 1587500073,
 -1,
 1587699378,
 1587575664,
 -1,
 1587764913,
 1587667858,
 -1,
 1587830448,
 1587732849,
 -1,
 1587895975,
 1587799434,
 -1,
 -41306,
 1587841265,
 9462,
 -1,
 1587906579,
 9463,
 1588092586,
 1587849102,
 -1,
 -41303,
 1588053355,
 9466,
 -1,
 1588083326,
 9467,
 1588289197,
 1588021319,
 -1,
 -41300,
 1588236786,
 9464,
 -1,
 1588275202,
 9465,
 -41298,
 1588244792,
 9461,
 -41297,
 1588408886,
 9469,
 -1,
 1588510922,
 9468,
 -1,
 1587776440,
 9470,
 -1,
 1587704453,
 10868,
 1588813500,
 1587652494,
 -1,
 1588879031,
 1588737889,
 -1,
 -41291,
 1588795457,
 8913,
 -41290,
 1588875668,
 10940,
 -1,
 1588948852,
 8912,
 1589141178,
 1588824890,
 -1,
 -41287,
 1589055322,
 10831,
 -1,
 1589137735,
 10830,
 -41285,
 1589107864,
 10988,
 -1,
 1589298126,
 11005,
 1589468869,
 1588776591,
 -1,
 1589534404,
 1589419256,
 -1,
 1589599937,
 1589490501,
 -1,
 -41280,
 1589538987,
 8222,
 -1,
 1589634628,
 8215,
 1589837823,
 1589526504,
 -1,
 -41277,
 1589716713,
 10836,
 -1,
 1589826387,
 10835,
 -1,
 1589455409,
 10645,
 1590058700,
 1589396885,
 -1,
 1590124235,
 1590004137,
 -1,
 1590189770,
 1590058215,
 -1,
 -41271,
 1590147259,
 8875,
 -1,
 1590196580,
 10981,
 -1,
 1590131044,
 10979,
 -1,
 1590087209,
 8214,
 1590517458,
 1590024608,
 -1,
 1590582993,
 1590473991,
 -1,
 1590648528,
 1590542774,
 8243,
 -1,
 1590587458,
 12318,
 -1,
 1590613330,
 10939,
 -1,
 1590501667,
 10746,
 1590910678,
 1590452465,
 -1,
 1590976213,
 1590826599,
 10913,
 -1,
 1590892947,
 10915,
 -1,
 1590942632,
 10914,
 1591172825,
 1590835041,
 -1,
 -41256,
 1591097614,
 10987,
 -1,
 1591190715,
 8915,
 1591369436,
 1591117924,
 -1,
 -41253,
 1591315606,
 8914,
 -1,
 1591389297,
 8748,
 1591566047,
 1591326971,
 -1,
 -41250,
 1591501726,
 10986,
 -1,
 1591553805,
 8225,
 -41248,
 1591516952,
 65100,
 -41247,
 1591703398,
 10646,
 -41246,
 1591785187,
 8263,
 -41245,
 1591827275,
 11799,
 -41244,
 1591911823,
 8223,
 -41243,
 1591992898,
 8252,
 -1,
 1592035965,
 733,
 1592221448,
 1587590280,
 -1,
 1592286973,
 1592185651,
 -1,
 1592352498,
 1592255355,
 -1,
 1592418027,
 1592318368,
 8473,
 -1,
 1592334493,
 8511,
 -41236,
 1592360907,
 8484,
 -41235,
 1592505607,
 8477,
 -41234,
 1592536381,
 8474,
 -41233,
 1592614184,
 8469,
 -41232,
 1592705938,
 8461,
 -41231,
 1592777337,
 8510,
 -1,
 1592818544,
 8450,
 1593007865,
 1592267941,
 -1,
 1593073400,
 1592975096,
 -1,
 -41227,
 1593004748,
 8521,
 -41226,
 1593055389,
 8520,
 -41225,
 1593117996,
 8519,
 -1,
 1593227515,
 8518,
 -1,
 1593033287,
 8517,
 1593466620,
 1592975096,
 -1,
 -41221,
 1593389648,
 8508,
 -1,
 1593498233,
 8509,
 -1,
 1593411024,
 8512,
 1593728775,
 1592209779,
 -1,
 1593794308,
 1593689366,
 -1,
 1593859842,
 1593720487,
 -1,
 -41215,
 1593775719,
 10907,
 -1,
 1593891752,
 10908,
 -41213,
 1593779621,
 11001,
 -1,
 1593999803,
 11002,
 1594228735,
 1593720487,
 -1,
 -41210,
 1594103399,
 10905,
 -1,
 1594219432,
 10906,
 -1,
 1593696567,
 10719,
 1594490879,
 1592166606,
 -1,
 -41206,
 1594414818,
 9891,
 -1,
 1594466616,
 9890,
 1594646333,
 1587513588,
 -1,
 1594711860,
 1594613248,
 -1,
 1594777371,
 1594622771,
 -1,
 1594842906,
 1594736914,
 8595,
 1594949631,
 1594774569,
 -1,
 1594973975,
 1594865063,
 -1,
 1595039508,
 1594896642,
 -1,
 -41197,
 1594993079,
 8627,
 -1,
 1595046858,
 8626,
 -41195,
 1594954657,
 10504,
 -41194,
 1595173797,
 8671,
 -1,
 1595264871,
 8629,
 -41192,
 1594895155,
 10515,
 -41191,
 1595382897,
 8693,
 -1,
 1595421366,
 8615,
 -1,
 1594785831,
 11796,
 1595694889,
 1594719757,
 -1,
 1595760420,
 1595627099,
 -1,
 1595825955,
 1595692073,
 -1,
 1595891489,
 1595785705,
 -1,
 -41184,
 1595843913,
 10607,
 -1,
 1595924559,
 10597,
 -41182,
 1595812659,
 10585,
 -1,
 1596011190,
 10593,
 -1,
 1595768739,
 8643,
 1596325887,
 1595713129,
 -1,
 1596350248,
 1596216361,
 -1,
 -41177,
 1596271411,
 10581,
 -1,
 1596338870,
 10589,
 -1,
 1596293027,
 8642,
 1596612396,
 1595663754,
 -1,
 -41173,
 1596552609,
 8609,
 -1,
 1596619613,
 10507,
 1596809007,
 1596569851,
 -1,
 -41170,
 1596760547,
 8659,
 -1,
 1596836647,
 8675,
 -41168,
 1596741490,
 8623,
 -41167,
 1596940185,
 8681,
 -41166,
 1596992249,
 10225,
 -41165,
 1597054516,
 8650,
 -1,
 1597120387,
 11015,
 1597333306,
 1594643497,
 -1,
 1597398839,
 1597290620,
 8868,
 -1,
 1597318170,
 10993,
 -41160,
 1597334548,
 8945,
 -41159,
 1597452867,
 10623,
 -1,
 1597532507,
 8964,
 1597767679,
 1597267520,
 -1,
 -41156,
 1597677285,
 10729,
 -1,
 1597736199,
 10728,
 1597923148,
 1594615178,
 -1,
 1597988679,
 1597862199,
 -1,
 1598054210,
 1597930352,
 -1,
 -41151,
 1598006255,
 8284,
 -1,
 1598078025,
 9676,
 -41149,
 1597991948,
 11784,
 -41148,
 1598167628,
 11034,
 -41147,
 1598272092,
 11798,
 -41146,
 1598344146,
 11795,
 -1,
 1598379654,
 10649,
 1598619647,
 1597920297,
 -1,
 -41143,
 1598526643,
 8724,
 -41142,
 1598586606,
 8901,
 -41141,
 1598636771,
 8760,
 -1,
 1598711013,
 729,
 1598906202,
 1597860982,
 -1,
 1598971729,
 1598829062,
 -1,
 1599037264,
 1598912527,
 8832,
 -1,
 1598972739,
 8928,
 -1,
 1598958383,
 8876,
 1599233877,
 1598927070,
 -1,
 1599299412,
 1599165264,
 8939,
 -1,
 1599234883,
 8941,
 -1,
 1599209991,
 8716,
 1599496023,
 1599192887,
 8833,
 -1,
 1599431491,
 8929,
 1599627097,
 1599412001,
 8740,
 -1,
 1599570226,
 10990,
 -1,
 1599558704,
 8878,
 -41125,
 1598850802,
 8363,
 -1,
 1599782077,
 36,
 1599955084,
 1579617580,
 -1,
 1600020492,
 1599916309,
 -1,
 1600085954,
 1599939941,
 -1,
 1600151400,
 1600038798,
 -1,
 1600216934,
 1600111506,
 -1,
 1600282469,
 1600163965,
 -1,
 -41117,
 1600232696,
 2322,
 -41116,
 1600261420,
 2318,
 -1,
 1600324403,
 2308,
 -1,
 1600193331,
 2358,
 -41113,
 1600149164,
 2359,
 -1,
 1600521011,
 2360,
 1600741233,
 1600108795,
 -1,
 1600806767,
 1600698619,
 -1,
 1600872301,
 1600764155,
 -1,
 -41108,
 1600829875,
 2396,
 -1,
 1600848691,
 2430,
 -41106,
 1600829875,
 2338,
 -1,
 1600979763,
 2337,
 -41104,
 1600764339,
 2343,
 -1,
 1601110835,
 2342,
 1601331064,
 1600681160,
 -1,
 1601396599,
 1601264947,
 -1,
 1601462133,
 1601352967,
 2315,
 -1,
 1601418503,
 2400,
 1601634303,
 1601425039,
 2316,
 -1,
 1601556111,
 2401,
 -1,
 1601307443,
 2357,
 1601789823,
 1601264936,
 -1,
 1601855356,
 1601723688,
 -1,
 -41093,
 1601772317,
 2345,
 -1,
 1601831731,
 2339,
 -41091,
 1601776676,
 2334,
 -41090,
 1602006675,
 2329,
 -1,
 1602028339,
 2344,
 1602248582,
 1601734349,
 -1,
 1602314115,
 1602208658,
 -1,
 -41086,
 1602271667,
 2394,
 -1,
 1602290483,
 2328,
 -41084,
 1602282093,
 2429,
 -41083,
 1602465427,
 2427,
 -1,
 1602487091,
 2327,
 1602707341,
 1602190192,
 -1,
 1602772876,
 1602618163,
 2330,
 1602879487,
 1602738034,
 -1,
 -41078,
 1602788600,
 2321,
 -41077,
 1602817324,
 2317,
 -1,
 1602880307,
 2418,
 -1,
 1602730419,
 2331,
 1603166099,
 1602676106,
 -1,
 1603231633,
 1603134858,
 -1,
 -41072,
 1603189171,
 2336,
 -1,
 1603207987,
 2335,
 -41070,
 1603189171,
 2341,
 -1,
 1603339059,
 2340,
 1603559319,
 1603076915,
 2309,
 -41067,
 1603483489,
 2324,
 -41066,
 1603541149,
 2320,
 -1,
 1603601203,
 2310,
 1603821467,
 1603515655,
 -1,
 -41063,
 1603750313,
 2353,
 -41062,
 1603844531,
 2397,
 -1,
 1603863347,
 2352,
 1604083616,
 1603784335,
 -1,
 1604149151,
 1604046479,
 -1,
 -41058,
 1604059902,
 2356,
 -1,
 1604125491,
 2355,
 -1,
 1604059955,
 2354,
 1604411301,
 1604030775,
 -1,
 1604476836,
 1604371346,
 -1,
 -41053,
 1604434355,
 2393,
 -1,
 1604453171,
 2326,
 -1,
 1604387635,
 2325,
 1604738985,
 1604342476,
 -1,
 -41049,
 1604702710,
 2428,
 -41048,
 1604762035,
 2333,
 -1,
 1604780851,
 2332,
 1605001133,
 1604664768,
 -1,
 -41045,
 1604958643,
 2349,
 -41044,
 1605030401,
 2431,
 -1,
 1605042995,
 2348,
 1605263280,
 1604943819,
 -1,
 -41041,
 1605220787,
 2425,
 -1,
 1605239603,
 2395,
 1605459891,
 1605190265,
 -1,
 -41038,
 1605381156,
 2399,
 -1,
 1605436211,
 2351,
 1605656501,
 1605384033,
 2313,
 -1,
 1605580641,
 2314,
 1605787576,
 1605622176,
 -1,
 -41033,
 1605745075,
 2347,
 -1,
 1605763891,
 2346,
 1605984186,
 1605703837,
 2311,
 -1,
 1605900445,
 2312,
 1606115261,
 1605944210,
 -1,
 -41028,
 1606077248,
 2426,
 -1,
 1606091571,
 2361,
 -41026,
 1606041305,
 2392,
 -41025,
 1606262008,
 2323,
 -41024,
 1606291366,
 2350,
 -41023,
 1606394111,
 2398,
 -1,
 1606421804,
 2319,
 1606639578,
 1600031797,
 -1,
 1606705096,
 1606550244,
 -1,
 1606770630,
 1606661383,
 2371,
 -1,
 1606726919,
 2372,
 1606942719,
 1606733455,
 2402,
 -1,
 1606864527,
 2403,
 1607032780,
 1606657799,
 -1,
 -41014,
 1606982904,
 2377,
 -41013,
 1607061151,
 2389,
 -1,
 1607077164,
 2373,
 1607294928,
 1606943539,
 -1,
 -41010,
 1607219041,
 2380,
 -41009,
 1607276701,
 2376,
 -1,
 1607336755,
 2366,
 1607557074,
 1607219041,
 2369,
 -1,
 1607481185,
 2370,
 1607688149,
 1607472146,
 -1,
 -41004,
 1607638264,
 2378,
 -1,
 1607666988,
 2374,
 1607884759,
 1607604381,
 2367,
 -1,
 1607800989,
 2368,
 -41000,
 1607847805,
 2382,
 -40999,
 1607965944,
 2379,
 -1,
 1607994668,
 2375,
 1608212466,
 1606592398,
 -1,
 1608277999,
 1608161786,
 -1,
 1608343523,
 1608210590,
 2305,
 1608450047,
 1608274985,
 -1,
 1608474593,
 1608377738,
 -1,
 -40992,
 1608419569,
 43253,
 -1,
 1608484883,
 43254,
 -40990,
 1608393092,
 43251,
 -1,
 1608601902,
 43255,
 1608802278,
 1608285440,
 -1,
 -40987,
 1608760490,
 2307,
 -1,
 1608793585,
 2381,
 1608998889,
 1608713011,
 -1,
 -40984,
 1608940340,
 2365,
 -1,
 1608993002,
 2306,
 -40982,
 1608949739,
 43250,
 -40981,
 1609163235,
 43256,
 -40980,
 1609176292,
 2364,
 -40979,
 1609240431,
 2304,
 -40978,
 1609347398,
 2417,
 -1,
 1609416676,
 43252,
 1609629695,
 1608244513,
 -1,
 -40975,
 1609543102,
 2385,
 -1,
 1609568146,
 2386,
 1609785347,
 1608169723,
 -1,
 1609850881,
 1609751719,
 -1,
 1609916407,
 1609819530,
 -1,
 -40970,
 1609861361,
 2408,
 -1,
 1609926675,
 2409,
 1610113018,
 1609869198,
 -1,
 -40967,
 1610073451,
 2412,
 -1,
 1610103422,
 2413,
 1610309629,
 1610041415,
 -1,
 -40964,
 1610256882,
 2410,
 -1,
 1610295298,
 2411,
 -40962,
 1610221923,
 2406,
 -40961,
 1610461496,
 2407,
 -40960,
 1610494518,
 2415,
 -1,
 1610596554,
 2414,
 -40958,
 1609802995,
 2405,
 -1,
 1610691293,
 2404,
 1610899462,
 1609729741,
 -1,
 -40955,
 1610851277,
 2387,
 -1,
 1610876883,
 43257,
 1611096073,
 1610810163,
 -1,
 -40952,
 1611058202,
 2388,
 -1,
 1611087703,
 2416,
 -40950,
 1611015835,
 2384,
 -40949,
 1611251500,
 43259,
 -1,
 1611319104,
 43258,
 1611489389,
 1599973262,
 -1,
 1611554924,
 1611404269,
 -1,
 1611620413,
 1611512510,
 -1,
 1611685914,
 1611533612,
 -1,
 1611751442,
 1611638670,
 66629,
 -1,
 1611711378,
 66631,
 1611882516,
 1611685160,
 66636,
 -1,
 1611826893,
 66637,
 -40939,
 1611838277,
 66639,
 -40938,
 1611964689,
 66627,
 -40937,
 1612035335,
 66633,
 -40936,
 1612063316,
 66635,
 -40935,
 1612172943,
 66634,
 -1,
 1612204103,
 66625,
 1612406817,
 1611600914,
 -1,
 1612472349,
 1612356856,
 66610,
 -1,
 1612422392,
 66611,
 1612603423,
 1612383027,
 66608,
 -1,
 1612563346,
 66609,
 -40928,
 1612519581,
 66606,
 -1,
 1612647724,
 66607,
 1612865576,
 1612355871,
 -1,
 1612931108,
 1612815608,
 66604,
 -1,
 1612881144,
 66605,
 1613062182,
 1612841779,
 66602,
 -1,
 1613022098,
 66603,
 -40921,
 1612978333,
 66600,
 -1,
 1613106476,
 66601,
 1613324331,
 1612808139,
 -1,
 -40918,
 1613273626,
 66632,
 -1,
 1613338049,
 66630,
 1613520942,
 1613292938,
 -1,
 -40915,
 1613470234,
 66628,
 -1,
 1613534657,
 66619,
 1613717553,
 1613470968,
 -1,
 -40912,
 1613673285,
 66613,
 -1,
 1613699229,
 66638,
 -40910,
 1613633137,
 66615,
 -40909,
 1613859096,
 66614,
 -40908,
 1613897353,
 66626,
 -40907,
 1613975304,
 66617,
 -40906,
 1614025355,
 66623,
 -40905,
 1614127490,
 66622,
 -40904,
 1614201746,
 66616,
 -40903,
 1614260604,
 66624,
 -40902,
 1614292808,
 66620,
 -40901,
 1614379547,
 66621,
 -40900,
 1614414094,
 66618,
 -1,
 1614515678,
 66612,
 1614741503,
 1611563582,
 -1,
 1614766153,
 1614613804,
 -1,
 1614831681,
 1614718862,
 66589,
 -1,
 1614791570,
 66591,
 1614962755,
 1614765352,
 66596,
 -1,
 1614907085,
 66597,
 -40892,
 1614918469,
 66599,
 -40891,
 1615044881,
 66587,
 -40890,
 1615115527,
 66593,
 -40889,
 1615143508,
 66595,
 -40888,
 1615253135,
 66594,
 -1,
 1615284295,
 66585,
 1615487056,
 1614681106,
 -1,
 1615552588,
 1615437048,
 66570,
 -1,
 1615502584,
 66571,
 1615683662,
 1615463219,
 66568,
 -1,
 1615643538,
 66569,
 -40881,
 1615599773,
 66566,
 -1,
 1615727916,
 66567,
 1615945815,
 1615436063,
 -1,
 1616011347,
 1615895800,
 66564,
 -1,
 1615961336,
 66565,
 1616142421,
 1615921971,
 66562,
 -1,
 1616102290,
 66563,
 -40874,
 1616058525,
 66560,
 -1,
 1616186668,
 66561,
 1616404570,
 1615888331,
 -1,
 -40871,
 1616353818,
 66592,
 -1,
 1616418241,
 66590,
 1616601181,
 1616373130,
 -1,
 -40868,
 1616550426,
 66588,
 -1,
 1616614849,
 66579,
 1616797792,
 1616551160,
 -1,
 -40865,
 1616753477,
 66573,
 -1,
 1616779421,
 66598,
 -40863,
 1616713329,
 66575,
 -40862,
 1616939288,
 66574,
 -40861,
 1616977545,
 66586,
 -40860,
 1617055496,
 66577,
 -40859,
 1617105547,
 66583,
 -40858,
 1617207682,
 66582,
 -40857,
 1617281938,
 66576,
 -40856,
 1617340796,
 66584,
 -40855,
 1617373000,
 66580,
 -40854,
 1617459739,
 66581,
 -40853,
 1617494286,
 66578,
 -1,
 1617595870,
 66572,
 -1,
 1611512293,
 9739,
 1617846404,
 1611417264,
 -1,
 1617911930,
 1617773973,
 -1,
 1617977463,
 1617834746,
 -1,
 1618042995,
 1617932169,
 -1,
 -40846,
 1617995369,
 9150,
 -1,
 1618040411,
 9163,
 1618239606,
 1617963856,
 -1,
 -40843,
 1618191977,
 9151,
 -1,
 1618237019,
 9164,
 -1,
 1618187725,
 9158,
 1618542591,
 1617933735,
 -1,
 -40839,
 1618423914,
 9155,
 -1,
 1618486119,
 9152,
 1618698367,
 1617843309,
 9162,
 1618804735,
 1618625823,
 -1,
 -40835,
 1618712013,
 9160,
 -40834,
 1618751594,
 9157,
 -1,
 1618813799,
 9154,
 1619066879,
 1618632227,
 9161,
 1619132415,
 1618953503,
 -1,
 -40830,
 1619039693,
 9159,
 -40829,
 1619079274,
 9156,
 -1,
 1619141479,
 9153,
 1619353736,
 1617782313,
 -1,
 -40826,
 1619309961,
 176,
 -40825,
 1619355804,
 8457,
 -1,
 1619430445,
 8451,
 1619615883,
 1619279679,
 -1,
 -40822,
 1619570637,
 9110,
 -1,
 1619619394,
 9192,
 -1,
 1619527414,
 8796,
 1619878168,
 1599871133,
 -1,
 1619943624,
 1619822285,
 -1,
 1620009146,
 1619865462,
 -1,
 1620074648,
 1619977610,
 -1,
 1620140180,
 1620019441,
 50,
 1620246527,
 1620071465,
 -1,
 -40813,
 1620117015,
 9353,
 -1,
 1620223479,
 127235,
 1620443135,
 1620084755,
 51,
 1620508671,
 1620333609,
 -1,
 -40809,
 1620379159,
 9354,
 -1,
 1620485623,
 127236,
 1620664481,
 1620027278,
 -1,
 1620730013,
 1620624747,
 54,
 1620836351,
 1620661289,
 -1,
 -40804,
 1620706839,
 9357,
 -1,
 1620813303,
 127239,
 1621032959,
 1620654718,
 55,
 1621098495,
 1620923433,
 -1,
 -40800,
 1620968983,
 9358,
 -1,
 1621075447,
 127240,
 1621254314,
 1620592711,
 -1,
 1621319846,
 1621201394,
 52,
 1621426175,
 1621251113,
 -1,
 -40795,
 1621296663,
 9355,
 -1,
 1621403127,
 127237,
 1621622783,
 1621239810,
 53,
 1621688319,
 1621513257,
 -1,
 -40791,
 1621558807,
 9356,
 -1,
 1621665271,
 127238,
 1621844142,
 1621166435,
 48,
 1621950463,
 1621775401,
 -1,
 -40787,
 1621820951,
 127232,
 -1,
 1621927415,
 127233,
 1622106290,
 1621799224,
 49,
 1622212607,
 1622037545,
 -1,
 -40783,
 1622083095,
 9352,
 -1,
 1622189559,
 127234,
 1622368438,
 1622028854,
 57,
 1622474751,
 1622299689,
 -1,
 -40779,
 1622345239,
 9360,
 -1,
 1622451703,
 127242,
 1622671359,
 1622327498,
 56,
 1622736895,
 1622561833,
 -1,
 -40775,
 1622607383,
 9359,
 -1,
 1622713847,
 127241,
 1622933503,
 1619967879,
 -1,
 1622958271,
 1622857566,
 119557,
 1623064575,
 1622908332,
 -1,
 -40770,
 1622968228,
 119556,
 -1,
 1623055720,
 119555,
 1623220418,
 1622897730,
 -1,
 -40767,
 1623180710,
 9869,
 -1,
 1623249751,
 9870,
 1623417029,
 1623180178,
 -1,
 -40764,
 1623350008,
 119554,
 -1,
 1623399549,
 119553,
 1623654399,
 1623343501,
 -1,
 -40761,
 1623573926,
 9871,
 -1,
 1623642967,
 9868,
 1623810294,
 1619891146,
 -1,
 1623875815,
 1623760394,
 -1,
 1623941337,
 1623838184,
 -1,
 1624006872,
 1623908721,
 -1,
 1624072399,
 1623975306,
 -1,
 -40754,
 1624017137,
 10123,
 -1,
 1624082451,
 10124,
 1624269010,
 1624024974,
 -1,
 -40751,
 1624229227,
 10127,
 -1,
 1624259198,
 10128,
 1624465621,
 1624197191,
 -1,
 -40748,
 1624412658,
 10125,
 -1,
 1624451074,
 10126,
 -40746,
 1624420664,
 10122,
 -40745,
 1624584758,
 10130,
 -1,
 1624686794,
 10129,
 -1,
 1623952312,
 10131,
 1624924390,
 1623908721,
 -1,
 1624989917,
 1624892810,
 -1,
 -40740,
 1624934641,
 10103,
 -1,
 1624999955,
 10104,
 1625186528,
 1624942478,
 -1,
 -40737,
 1625146731,
 10107,
 -1,
 1625176702,
 10108,
 1625383139,
 1625114695,
 -1,
 -40734,
 1625330162,
 10105,
 -1,
 1625368578,
 10106,
 -40732,
 1625338168,
 10102,
 -40731,
 1625502262,
 10110,
 -1,
 1625604298,
 10109,
 -1,
 1624869816,
 10111,
 1625882623,
 1623819491,
 -1,
 1625907445,
 1625809265,
 -1,
 1625972972,
 1625875850,
 -1,
 -40725,
 1625917681,
 10113,
 -1,
 1625982995,
 10114,
 1626169583,
 1625925518,
 -1,
 -40722,
 1626129771,
 10117,
 -1,
 1626159742,
 10118,
 1626366194,
 1626097735,
 -1,
 -40719,
 1626313202,
 10115,
 -1,
 1626351618,
 10116,
 -40717,
 1626321208,
 10112,
 -40716,
 1626485302,
 10120,
 -1,
 1626587338,
 10119,
 -1,
 1625852856,
 10121,
 1626824961,
 1623720755,
 -1,
 1626890496,
 1626743380,
 -1,
 1626956031,
 1626819038,
 -1,
 1627021566,
 1626912167,
 -1,
 -40709,
 1626958309,
 11032,
 -40708,
 1627037413,
 11031,
 -40707,
 1627096327,
 11030,
 -1,
 1627128352,
 11033,
 -1,
 1626963694,
 8900,
 -1,
 1626890400,
 8960,
 -1,
 1626851203,
 168,
 1627545864,
 1626775523,
 -1,
 -40701,
 1627463282,
 9861,
 -40700,
 1627572806,
 9860,
 -40699,
 1627622541,
 9859,
 -40698,
 1627672173,
 9858,
 -40697,
 1627722768,
 9857,
 -1,
 1627831976,
 9856,
 1628004625,
 1627485384,
 -1,
 1628070160,
 1627920541,
 -1,
 1628135695,
 1628023149,
 -1,
 1628201230,
 1628088206,
 -1,
 -40691,
 1628110889,
 8725,
 -1,
 1628232535,
 247,
 -1,
 1628116280,
 8903,
 -1,
 1628055316,
 8739,
 -1,
 1627980865,
 9902,
 1628594452,
 1627957134,
 -1,
 -40685,
 1628540183,
 9090,
 -1,
 1628571632,
 9933,
 -40683,
 1628535582,
 12291,
 -40682,
 1628701603,
 9107,
 -40681,
 1628772395,
 9009,
 -1,
 1628864190,
 8783,
 1629053216,
 1619788595,
 -1,
 1629118749,
 1629012906,
 -1,
 -40677,
 1629076948,
 10143,
 -40676,
 1629136655,
 65097,
 -1,
 1629190229,
 65101,
 -40674,
 1629077467,
 9619,
 -40673,
 1629298834,
 8504,
 -1,
 1629414649,
 8224,
 1629618175,
 1629009159,
 -1,
 1629643044,
 1629487923,
 -1,
 -40669,
 1629601951,
 10139,
 -1,
 1629640938,
 8367,
 -1,
 1629562183,
 9946,
 1629905753,
 1579588856,
 -1,
 1629971027,
 1629867663,
 -1,
 1630036499,
 1629915342,
 -1,
 1630101881,
 1629975584,
 -1,
 1630167383,
 1630031216,
 -1,
 1630232897,
 1630077747,
 68608,
 1630298422,
 1630145836,
 -1,
 -40659,
 1630225017,
 68632,
 -40658,
 1630332298,
 68677,
 -40657,
 1630381966,
 68670,
 -40656,
 1630450951,
 68668,
 -40655,
 1630493992,
 68644,
 -40654,
 1630588559,
 68640,
 -40653,
 1630638391,
 68634,
 -40652,
 1630701261,
 68623,
 -40651,
 1630779643,
 68627,
 -1,
 1630813632,
 68619,
 1631019320,
 1630250894,
 68669,
 -1,
 1630978962,
 68671,
 -40647,
 1630945913,
 68630,
 -40646,
 1631118730,
 68675,
 -40645,
 1631171847,
 68666,
 -40644,
 1631202621,
 68660,
 -40643,
 1631280424,
 68643,
 -40642,
 1631374991,
 68638,
 -40641,
 1631422157,
 68621,
 -40640,
 1631500539,
 68625,
 -1,
 1631534528,
 68617,
 1631740237,
 1630145836,
 -1,
 1631805767,
 1631673640,
 -1,
 -40636,
 1631732345,
 68650,
 -40635,
 1631839626,
 68646,
 -40634,
 1631880909,
 68653,
 -1,
 1631943536,
 68648,
 -40632,
 1631748043,
 68628,
 -40631,
 1632065186,
 68673,
 -40630,
 1632164256,
 68655,
 -40629,
 1632182868,
 68642,
 -40628,
 1632240426,
 68641,
 -1,
 1632336752,
 68658,
 1632526675,
 1631689976,
 68614,
 1632592208,
 1632439596,
 68615,
 -1,
 1632538935,
 68636,
 -40623,
 1632560522,
 68679,
 -40622,
 1632644413,
 68664,
 -1,
 1632754080,
 68656,
 1632919894,
 1632442525,
 68611,
 -40619,
 1632841021,
 68662,
 -1,
 1632926576,
 68657,
 -1,
 1632834116,
 68680,
 1633222655,
 1630090995,
 -1,
 1633247595,
 1633092403,
 68609,
 1633313121,
 1633160492,
 68610,
 1633378652,
 1633246504,
 68645,
 -1,
 1633322701,
 68654,
 -40611,
 1633305209,
 68633,
 -40610,
 1633478026,
 68678,
 -40609,
 1633521975,
 68635,
 -40608,
 1633584845,
 68624,
 -1,
 1633631680,
 68620,
 -40606,
 1633239673,
 68631,
 -40605,
 1633805706,
 68676,
 -40604,
 1633834658,
 68672,
 -40603,
 1633924359,
 68667,
 -40602,
 1633955133,
 68661,
 -40601,
 1634016038,
 68652,
 -40600,
 1634127503,
 68639,
 -40599,
 1634174669,
 68622,
 -40598,
 1634253051,
 68626,
 -1,
 1634287040,
 68618,
 1634492787,
 1633160492,
 68613,
 1634558320,
 1634426152,
 -1,
 -40594,
 1634484857,
 68651,
 -40593,
 1634592138,
 68647,
 -1,
 1634630512,
 68649,
 -40591,
 1634500555,
 68629,
 -40590,
 1634752162,
 68674,
 -1,
 1634827120,
 68659,
 1635017079,
 1634442488,
 -1,
 1635082614,
 1634929964,
 68616,
 -1,
 1635029303,
 68637,
 -1,
 1635003709,
 68665,
 1635319807,
 1634932893,
 68612,
 -1,
 1635200317,
 68663,
 1635410364,
 1630050123,
 -1,
 1635475891,
 1635329285,
 -1,
 1635541377,
 1635432699,
 -1,
 1635606911,
 1635451699,
 66477,
 1635713023,
 1635519756,
 66508,
 -1,
 1635603696,
 66509,
 -40576,
 1635530593,
 66479,
 -1,
 1635719325,
 66478,
 1635934597,
 1635451699,
 66464,
 1636040703,
 1635890423,
 66504,
 -40572,
 1635957171,
 66506,
 -1,
 1635996912,
 66505,
 1636196745,
 1635902858,
 -1,
 -40569,
 1636120417,
 66476,
 -40568,
 1636219315,
 66480,
 -1,
 1636238131,
 66475,
 1636458893,
 1636149134,
 -1,
 -40565,
 1636390572,
 66498,
 -40564,
 1636481459,
 66497,
 -1,
 1636500275,
 66495,
 1636721041,
 1636377172,
 -1,
 -40561,
 1636644705,
 66488,
 -40560,
 1636702365,
 66487,
 -1,
 1636762419,
 66486,
 1636983189,
 1636646336,
 -1,
 1637048724,
 1636893491,
 66482,
 -1,
 1637002899,
 66510,
 -1,
 1636999829,
 66511,
 1637245336,
 1636894639,
 -1,
 -40553,
 1637212375,
 66507,
 -1,
 1637221171,
 66471,
 1637441947,
 1637184712,
 -1,
 -40550,
 1637357725,
 66491,
 -1,
 1637417779,
 66490,
 1637638558,
 1637397767,
 -1,
 -40547,
 1637562209,
 66493,
 -1,
 1637614387,
 66492,
 1637835169,
 1637571880,
 -1,
 -40544,
 1637758817,
 66485,
 -1,
 1637810995,
 66484,
 1638031780,
 1637781815,
 -1,
 -40541,
 1637955425,
 66468,
 -1,
 1638007603,
 66467,
 1638228391,
 1637962444,
 -1,
 -40538,
 1638144157,
 66474,
 -1,
 1638204211,
 66473,
 1638425002,
 1638172365,
 -1,
 -40535,
 1638348641,
 66470,
 -1,
 1638400819,
 66469,
 -40533,
 1638379305,
 66496,
 -40532,
 1638542372,
 66489,
 -40531,
 1638610785,
 66466,
 -40530,
 1638681976,
 66481,
 -40529,
 1638728446,
 66494,
 -40528,
 1638799517,
 66465,
 -40527,
 1638906291,
 66499,
 -40526,
 1638965503,
 66483,
 -1,
 1639021648,
 66472,
 1639211451,
 1635406532,
 -1,
 1639276985,
 1639179658,
 -1,
 1639342520,
 1639232325,
 -1,
 -40521,
 1639292152,
 66514,
 -1,
 1639363903,
 66516,
 -1,
 1639290293,
 66515,
 -40518,
 1639231800,
 66513,
 -1,
 1639530563,
 66517,
 -1,
 1639145840,
 66512,
 1639801318,
 1635325093,
 -1,
 1639866848,
 1639720293,
 -1,
 1639932360,
 1639779628,
 66308,
 1639997889,
 1639884686,
 66324,
 -1,
 1639957394,
 66318,
 1640128963,
 1639953671,
 66323,
 -1,
 1640081294,
 66331,
 -40508,
 1640062248,
 66317,
 -40507,
 1640178260,
 66316,
 -40506,
 1640287887,
 66315,
 -40505,
 1640357854,
 66327,
 -1,
 1640384583,
 66330,
 1640587725,
 1639878967,
 -1,
 -40502,
 1640511329,
 66322,
 -40501,
 1640610230,
 66329,
 -40500,
 1640631596,
 66306,
 -1,
 1640694579,
 66314,
 1640915407,
 1640511329,
 66326,
 -1,
 1640839009,
 66334,
 1641046482,
 1640883594,
 -1,
 -40495,
 1641003446,
 66312,
 -1,
 1641024812,
 66325,
 1641243093,
 1641011616,
 -1,
 -40492,
 1641200054,
 66328,
 -1,
 1641221420,
 66320,
 1641439703,
 1641158813,
 66313,
 -1,
 1641355421,
 66333,
 -40488,
 1641393958,
 66310,
 -40487,
 1641512189,
 66309,
 -40486,
 1641598028,
 66321,
 -40485,
 1641651448,
 66319,
 -40484,
 1641724342,
 66311,
 -40483,
 1641777158,
 66307,
 -40482,
 1641853524,
 66332,
 -40481,
 1641901664,
 66305,
 -1,
 1641939763,
 66304,
 1642201087,
 1639819794,
 -1,
 1642226148,
 1642111252,
 -1,
 -40477,
 1642167549,
 66337,
 -1,
 1642242230,
 66339,
 -40475,
 1642168113,
 66338,
 -1,
 1642377528,
 66336,
 1642594303,
 1639735554,
 -1,
 1642619406,
 1642472805,
 -1,
 1642684910,
 1642587530,
 -1,
 1642750444,
 1642644370,
 -1,
 -40469,
 1642676562,
 68220,
 -1,
 1642750494,
 68219,
 -40467,
 1642676562,
 68215,
 -1,
 1642881566,
 68201,
 1643078132,
 1642637198,
 -1,
 1643143667,
 1642988339,
 -1,
 -40463,
 1643111818,
 68202,
 -40462,
 1643145696,
 68207,
 -1,
 1643219053,
 68206,
 -1,
 1643079096,
 68198,
 1643471353,
 1643034875,
 -1,
 1643536888,
 1643428275,
 -1,
 -40457,
 1643488194,
 68217,
 -1,
 1643546733,
 68211,
 -1,
 1643470512,
 68213,
 1643799036,
 1643417911,
 -1,
 -40453,
 1643718619,
 68205,
 -1,
 1643775141,
 68203,
 1643995646,
 1643755958,
 68192,
 -1,
 1643946257,
 68194,
 1644126721,
 1643939533,
 -1,
 -40448,
 1644081540,
 68212,
 -1,
 1644114677,
 68214,
 1644323332,
 1644036915,
 -1,
 -40445,
 1644274096,
 68210,
 -1,
 1644349774,
 68209,
 -40443,
 1644247899,
 68216,
 -40442,
 1644475262,
 68218,
 -40441,
 1644545249,
 68197,
 -40440,
 1644617532,
 68199,
 -40439,
 1644637042,
 68196,
 -40438,
 1644737432,
 68204,
 -40437,
 1644767612,
 68195,
 -40436,
 1644832023,
 68193,
 -40435,
 1644929294,
 68208,
 -1,
 1644969436,
 68200,
 1645215743,
 1642555566,
 -1,
 1645240850,
 1645098180,
 -1,
 -40431,
 1645195576,
 68221,
 -1,
 1645228199,
 68222,
 -1,
 1645157264,
 68223,
 1645543423,
 1629965109,
 -1,
 1645568570,
 1645421925,
 -1,
 1645634079,
 1645478707,
 -1,
 1645699611,
 1645544243,
 -1,
 -40424,
 1645654853,
 7267,
 -40423,
 1645683284,
 7266,
 -40422,
 1645777207,
 7264,
 -1,
 1645826764,
 7265,
 -40420,
 1645667722,
 7259,
 -40419,
 1645943590,
 7261,
 -40418,
 1646055055,
 7262,
 -1,
 1646102221,
 7260,
 1646289446,
 1645596303,
 -1,
 1646354978,
 1646199603,
 7258,
 -1,
 1646265139,
 7263,
 -40413,
 1646278497,
 7273,
 -40412,
 1646435576,
 7283,
 -40411,
 1646467229,
 7268,
 -1,
 1646529836,
 7278,
 1646748203,
 1646212961,
 -1,
 -40408,
 1646674553,
 7277,
 -40407,
 1646730007,
 7276,
 -40406,
 1646835963,
 7275,
 -1,
 1646885744,
 7274,
 1647075888,
 1646697720,
 -1,
 -40403,
 1647015112,
 7286,
 -40402,
 1647075756,
 7284,
 -40401,
 1647166354,
 7287,
 -1,
 1647197632,
 7285,
 1647403573,
 1646991517,
 -1,
 -40398,
 1647355790,
 7269,
 -40397,
 1647424775,
 7272,
 -40396,
 1647450921,
 7271,
 -1,
 1647559570,
 7270,
 1647771647,
 1647316268,
 -1,
 -40393,
 1647659414,
 7282,
 -40392,
 1647761824,
 7279,
 -40391,
 1647795496,
 7281,
 -1,
 1647872003,
 7280,
 1648058952,
 1645535601,
 -1,
 1648124478,
 1648027018,
 -1,
 -40387,
 1648068849,
 7250,
 -1,
 1648134163,
 7251,
 1648321089,
 1648076686,
 -1,
 -40384,
 1648280939,
 7254,
 -1,
 1648310910,
 7255,
 1648517700,
 1648248903,
 -1,
 -40381,
 1648464370,
 7252,
 -1,
 1648502786,
 7253,
 -40379,
 1648429411,
 7248,
 -40378,
 1648668984,
 7249,
 -40377,
 1648702006,
 7257,
 -1,
 1648804042,
 7256,
 1648976461,
 1648023968,
 -1,
 1649041996,
 1648930898,
 -1,
 -40373,
 1648993246,
 7294,
 -1,
 1649060030,
 7295,
 -1,
 1649007241,
 7292,
 1649304144,
 1648889781,
 -1,
 -40369,
 1649231142,
 7290,
 -1,
 1649315542,
 7288,
 -40367,
 1649251666,
 7291,
 -40366,
 1649438467,
 7289,
 -1,
 1649494094,
 7293,
 1649697485,
 1629926663,
 -1,
 1649763016,
 1649612957,
 -1,
 1649828551,
 1649680847,
 -1,
 1649894044,
 1649747301,
 -1,
 1649959518,
 1649833160,
 -1,
 1650025053,
 1649892659,
 -1,
 1650090587,
 1649980679,
 2827,
 -1,
 1650046215,
 2912,
 1650262015,
 1650052751,
 2828,
 -1,
 1650183823,
 2913,
 -1,
 1649935155,
 2869,
 1650418276,
 1649927562,
 -1,
 1650483810,
 1650386314,
 -1,
 -40351,
 1650440627,
 2848,
 -1,
 1650459443,
 2847,
 -40349,
 1650440627,
 2853,
 -1,
 1650590515,
 2852,
 1650811497,
 1650351400,
 -1,
 -40346,
 1650732068,
 2846,
 -40345,
 1650793245,
 2851,
 -40344,
 1650896531,
 2841,
 -1,
 1650918195,
 2856,
 1651139183,
 1650768123,
 -1,
 1651204717,
 1651095803,
 -1,
 -40340,
 1651161523,
 2850,
 -1,
 1651180339,
 2849,
 -40338,
 1651161523,
 2855,
 -1,
 1651311411,
 2854,
 1651532403,
 1651049267,
 2821,
 -40335,
 1651455841,
 2836,
 -40334,
 1651513501,
 2832,
 -1,
 1651573555,
 2822,
 1651794551,
 1651484558,
 -1,
 -40331,
 1651725996,
 2871,
 -40330,
 1651816883,
 2870,
 -1,
 1651835699,
 2872,
 1652056699,
 1651750151,
 -1,
 -40327,
 1651984809,
 2908,
 -40326,
 1652079027,
 2909,
 -1,
 1652097843,
 2864,
 1652318846,
 1651982969,
 -1,
 -40323,
 1652239396,
 2911,
 -1,
 1652294451,
 2863,
 1652515456,
 1652242273,
 2825,
 -1,
 1652438881,
 2826,
 1652646531,
 1652480416,
 -1,
 -40318,
 1652603315,
 2859,
 -1,
 1652622131,
 2858,
 1652843142,
 1652608655,
 -1,
 -40315,
 1652753150,
 2867,
 -1,
 1652818739,
 2866,
 1653039753,
 1652789559,
 -1,
 -40312,
 1652996531,
 2838,
 -1,
 1653015347,
 2837,
 1653236364,
 1652970188,
 -1,
 -40309,
 1653193139,
 2845,
 -1,
 1653211955,
 2844,
 1653432974,
 1653151901,
 2823,
 -1,
 1653348509,
 2824,
 1653564049,
 1653376717,
 -1,
 -40304,
 1653520819,
 2840,
 -1,
 1653539635,
 2839,
 1653760660,
 1653504880,
 -1,
 -40301,
 1653717427,
 2843,
 -1,
 1653736243,
 2842,
 1653957271,
 1653685696,
 -1,
 -40298,
 1653914035,
 2861,
 -1,
 1653932851,
 2860,
 -40296,
 1653901546,
 2929,
 -40295,
 1654103288,
 2835,
 -40294,
 1654132646,
 2862,
 -40293,
 1654241715,
 2873,
 -1,
 1654263084,
 2831,
 1654481580,
 1649839157,
 -1,
 1654547106,
 1654391524,
 -1,
 1654612640,
 1654502663,
 2883,
 -1,
 1654568199,
 2884,
 1654783999,
 1654574735,
 2914,
 -1,
 1654705807,
 2915,
 1654874790,
 1654457139,
 -1,
 -40284,
 1654798177,
 2892,
 -40283,
 1654855837,
 2888,
 -1,
 1654915891,
 2878,
 1655136936,
 1654798177,
 2881,
 -1,
 1655060321,
 2882,
 1655268010,
 1655052445,
 2879,
 -1,
 1655183517,
 2880,
 -40277,
 1655217400,
 2891,
 -1,
 1655311660,
 2887,
 1655530170,
 1654448497,
 -1,
 1655595696,
 1655498122,
 -1,
 -40273,
 1655539953,
 2920,
 -1,
 1655605267,
 2921,
 1655792307,
 1655547790,
 -1,
 -40270,
 1655752043,
 2924,
 -1,
 1655782014,
 2925,
 1655988918,
 1655720007,
 -1,
 -40267,
 1655935474,
 2922,
 -1,
 1655973890,
 2923,
 -40265,
 1655900515,
 2918,
 -40264,
 1656140088,
 2919,
 -40263,
 1656173110,
 2927,
 -1,
 1656275146,
 2926,
 1656447683,
 1655448837,
 -1,
 1656513214,
 1656388864,
 -1,
 -40259,
 1656470698,
 2819,
 -1,
 1656503793,
 2893,
 1656709825,
 1656423219,
 -1,
 -40256,
 1656650548,
 2877,
 -1,
 1656703210,
 2818,
 -40254,
 1656624356,
 2876,
 -1,
 1656838302,
 2817,
 1657037510,
 1656357683,
 -1,
 -40251,
 1656953150,
 2903,
 -1,
 1657060459,
 2902,
 -1,
 1656953413,
 2928,
 -1,
 1649751180,
 8886,
 1657365195,
 1649678630,
 -1,
 -40246,
 1657325916,
 64831,
 -1,
 1657373285,
 64830,
 -40244,
 1657276717,
 9766,
 -1,
 1657500070,
 10183,
 1657692926,
 1649661402,
 -1,
 1657758448,
 1657611621,
 -1,
 1657823954,
 1657668403,
 66710,
 -40239,
 1657784654,
 66688,
 -1,
 1657799475,
 66715,
 1658020565,
 1657776014,
 -1,
 -40236,
 1657973915,
 66697,
 -1,
 1657996083,
 66696,
 1658217175,
 1657969912,
 66713,
 -1,
 1658166520,
 66717,
 1658348250,
 1658163511,
 -1,
 -40231,
 1658304947,
 66693,
 -1,
 1658335334,
 66703,
 1658544860,
 1658260780,
 66711,
 -1,
 1658457388,
 66716,
 1658675935,
 1658501371,
 -1,
 -40226,
 1658632627,
 66698,
 -1,
 1658679205,
 66694,
 -40224,
 1658596388,
 66709,
 -40223,
 1658820269,
 66692,
 -40222,
 1658897633,
 66707,
 -40221,
 1658926945,
 66714,
 -40220,
 1659003362,
 66690,
 -40219,
 1659062697,
 66695,
 -40218,
 1659150225,
 66702,
 -40217,
 1659209611,
 66706,
 -40216,
 1659283256,
 66705,
 -40215,
 1659350734,
 66704,
 -40214,
 1659425270,
 66691,
 -40213,
 1659443357,
 66712,
 -40212,
 1659550131,
 66708,
 -40211,
 1659612819,
 66700,
 -40210,
 1659674879,
 66701,
 -40209,
 1659723685,
 66699,
 -1,
 1659818497,
 66689,
 1660026879,
 1657725297,
 -1,
 1660052212,
 1659954570,
 -1,
 -40205,
 1659996401,
 66722,
 -1,
 1660061715,
 66723,
 1660248823,
 1660004238,
 -1,
 -40202,
 1660208491,
 66726,
 -1,
 1660238462,
 66727,
 1660445434,
 1660176455,
 -1,
 -40199,
 1660391922,
 66724,
 -1,
 1660430338,
 66725,
 -40197,
 1660356963,
 66720,
 -40196,
 1660596536,
 66721,
 -40195,
 1660629558,
 66729,
 -1,
 1660731594,
 66728,
 1660904230,
 1657636557,
 -1,
 1660969765,
 1660814505,
 -1,
 1661035298,
 1660888421,
 -1,
 1661100805,
 1660958561,
 -1,
 -40189,
 1661056263,
 5778,
 -40188,
 1661091846,
 5783,
 -1,
 1661146073,
 5766,
 1661362953,
 1661048266,
 -1,
 -40185,
 1661278803,
 5785,
 -40184,
 1661374928,
 5779,
 -1,
 1661443750,
 5781,
 1661625100,
 1661314958,
 -1,
 -40181,
 1661553173,
 5774,
 -1,
 1661620212,
 5764,
 1661821711,
 1661574392,
 -1,
 -40178,
 1661777159,
 5782,
 -1,
 1661803287,
 5777,
 1662018322,
 1661754664,
 -1,
 -40175,
 1661974767,
 5765,
 -1,
 1662007991,
 5773,
 1662214933,
 1661933725,
 -1,
 -40172,
 1662182319,
 5780,
 -1,
 1662222966,
 5784,
 1662411544,
 1662155632,
 -1,
 -40169,
 1662363702,
 5769,
 -1,
 1662386528,
 5770,
 -40167,
 1662339300,
 5768,
 -40166,
 1662546715,
 5775,
 -40165,
 1662609513,
 5786,
 -40164,
 1662703506,
 5771,
 -40163,
 1662736960,
 5762,
 -40162,
 1662832423,
 5772,
 -40161,
 1662862360,
 5763,
 -40160,
 1662927784,
 5767,
 -40159,
 1662977083,
 5761,
 -1,
 1663049422,
 5776,
 -40157,
 1660965728,
 5760,
 -40156,
 1663211657,
 5788,
 -1,
 1663270660,
 5787,
 -1,
 1660927175,
 731,
 1663525689,
 1660869024,
 -1,
 1663591223,
 1663473077,
 -1,
 1663656754,
 1663521833,
 -1,
 1663722286,
 1663593423,
 -1,
 -40149,
 1663663256,
 10044,
 -40148,
 1663725782,
 10011,
 -40147,
 1663762586,
 10027,
 -1,
 1663861105,
 10034,
 1664049969,
 1663653524,
 -1,
 -40144,
 1663965249,
 10180,
 -1,
 1664053108,
 10179,
 -1,
 1663965470,
 9251,
 1664352255,
 1663612040,
 -1,
 1664377654,
 1664243505,
 -1,
 -40139,
 1664332358,
 9104,
 -1,
 1664385286,
 9103,
 -1,
 1664323629,
 10174,
 -40136,
 1663530460,
 8997,
 -1,
 1664600998,
 9741,
 1664770888,
 1663447720,
 -1,
 1664836414,
 1664695744,
 -1,
 -40132,
 1664793647,
 9286,
 -40131,
 1664838615,
 9285,
 -1,
 1664931236,
 9284,
 1665098561,
 1664792827,
 -1,
 -40128,
 1665020786,
 9290,
 -1,
 1665128180,
 9288,
 1665295172,
 1665039216,
 -1,
 -40125,
 1665216591,
 9289,
 -1,
 1665326005,
 9281,
 -40123,
 1665225864,
 9283,
 -40122,
 1665422988,
 9280,
 -40121,
 1665511775,
 9282,
 -1,
 1665552841,
 9287,
 1665753935,
 1664694113,
 -1,
 1665819470,
 1665711243,
 -1,
 -40117,
 1665735080,
 9885,
 -40116,
 1665839074,
 10015,
 -40115,
 1665901276,
 10009,
 -1,
 1665925274,
 10029,
 -1,
 1665764317,
 8485,
 1666212692,
 1665678784,
 -1,
 1666278227,
 1666167767,
 -1,
 -40110,
 1666216084,
 10662,
 -1,
 1666311326,
 10663,
 -1,
 1666238514,
 65532,
 1666540375,
 1666136813,
 -1,
 -40106,
 1666468595,
 11819,
 -1,
 1666525140,
 8228,
 -40104,
 1666456516,
 8254,
 -1,
 1666681164,
 8486,
 1666868589,
 1629861127,
 -1,
 1666933809,
 1666783389,
 -1,
 1666999335,
 1666864998,
 -1,
 1667064760,
 1666929705,
 -1,
 1667130223,
 1667016590,
 -1,
 1667195753,
 1667095646,
 93,
 1667301375,
 1667126313,
 -1,
 1667326822,
 1667216807,
 -1,
 1667392356,
 1667285333,
 -1,
 -40093,
 1667333585,
 10640,
 -1,
 1667389121,
 10638,
 -40091,
 1667316124,
 10636,
 -1,
 1667507615,
 8262,
 -40089,
 1667285275,
 9124,
 -40088,
 1667663851,
 9126,
 -1,
 1667751939,
 9125,
 1667916652,
 1667111069,
 -1,
 -40085,
 1667835260,
 8217,
 -1,
 1667906456,
 11815,
 -40083,
 1667850946,
 11779,
 -40082,
 1668058332,
 8908,
 -1,
 1668106804,
 10182,
 1668309887,
 1667040051,
 -1,
 1668375418,
 1668240420,
 8735,
 1668481023,
 1668305961,
 -1,
 1668506485,
 1668396455,
 -1,
 -40076,
 1668474207,
 9084,
 -1,
 1668539597,
 8894,
 1668703095,
 1668459236,
 12297,
 -1,
 1668661108,
 10642,
 -40072,
 1668659882,
 10652,
 -40071,
 1668801326,
 11776,
 -1,
 1668812205,
 11777,
 1669070847,
 1668330759,
 -1,
 1669096318,
 1668964965,
 -1,
 -40067,
 1669045186,
 8692,
 -1,
 1669074058,
 10228,
 -1,
 1669008038,
 10644,
 1669358473,
 1668264773,
 -1,
 1669424008,
 1669272475,
 -1,
 1669489540,
 1669364592,
 -1,
 -40061,
 1669419206,
 10628,
 -1,
 1669496796,
 12303,
 -40059,
 1669447816,
 12313,
 -40058,
 1669632825,
 12315,
 -40057,
 1669669279,
 10630,
 -1,
 1669755996,
 12311,
 -1,
 1669374453,
 10713,
 1670013842,
 1669302269,
 -1,
 1670079377,
 1669973783,
 -1,
 1670144910,
 1669989171,
 -1,
 -40051,
 1670071845,
 10608,
 -1,
 1670136869,
 12299,
 -40049,
 1670080286,
 10715,
 -40048,
 1670290682,
 8221,
 -1,
 1670324639,
 11817,
 -1,
 1670012391,
 11781,
 1670603674,
 1669954416,
 -1,
 1670669208,
 1670533318,
 125,
 1670774783,
 1670599721,
 -1,
 -40042,
 1670663419,
 9131,
 -40041,
 1670764280,
 9132,
 -1,
 1670786039,
 9133,
 -40039,
 1670610908,
 12301,
 -1,
 1670965212,
 8969,
 1671127969,
 1670571402,
 -1,
 1671193503,
 1671083271,
 -1,
 1671259038,
 1671143093,
 8895,
 -1,
 1671171269,
 10702,
 -1,
 1671221242,
 11786,
 -40032,
 1671157850,
 12309,
 -1,
 1671369177,
 8866,
 1671586726,
 1671045535,
 41,
 1671692287,
 1671517225,
 -1,
 -40028,
 1671580923,
 9118,
 -40027,
 1671638007,
 9120,
 -1,
 1671749635,
 9119,
 1671914409,
 1671554068,
 -1,
 -40024,
 1671829214,
 9145,
 -1,
 1671908817,
 11809,
 1672111020,
 1671863544,
 -1,
 -40021,
 1672071506,
 10198,
 -1,
 1672140912,
 9621,
 1672307631,
 1672048765,
 -1,
 -40018,
 1672243040,
 9616,
 -1,
 1672310503,
 9687,
 1672504242,
 1672235079,
 -1,
 -40015,
 1672420687,
 8971,
 -1,
 1672481661,
 10621,
 1672700853,
 1672469319,
 -1,
 -40012,
 1672659080,
 10648,
 -1,
 1672705116,
 12305,
 -40010,
 1672654380,
 11789,
 -40009,
 1672809465,
 8906,
 -1,
 1672892091,
 11805,
 1673094168,
 1667030528,
 -1,
 1673159648,
 1673027238,
 8594,
 1673225183,
 1673090089,
 -1,
 1673290701,
 1673180583,
 -1,
 1673356228,
 1673258378,
 -1,
 1673421761,
 1673285620,
 8611,
 1673527295,
 1673348383,
 -1,
 -40000,
 1673428195,
 10516,
 -1,
 1673514411,
 10517,
 1673723903,
 1673338687,
 -1,
 -39997,
 1673611820,
 11023,
 -1,
 1673661070,
 11022,
 1673880519,
 1673299965,
 -1,
 -39994,
 1673797106,
 8699,
 -1,
 1673888965,
 10513,
 -39992,
 1673821411,
 8696,
 -39991,
 1674025221,
 8603,
 -39990,
 1674109120,
 10565,
 -39989,
 1674124628,
 8620,
 -39988,
 1674204812,
 8618,
 -1,
 1674276777,
 8628,
 1674470357,
 1673258378,
 -1,
 1674535890,
 1674400697,
 -1,
 -39984,
 1674446767,
 10567,
 -39983,
 1674544753,
 11076,
 -1,
 1674632104,
 11075,
 1674838015,
 1674458585,
 -1,
 -39980,
 1674715809,
 10526,
 -1,
 1674797589,
 8677,
 1674994652,
 1674437795,
 -1,
 1675060185,
 1674904626,
 -1,
 -39976,
 1675008608,
 11084,
 -1,
 1675087139,
 11080,
 -39974,
 1675008608,
 10612,
 -39973,
 1675212602,
 10562,
 -1,
 1675283747,
 10613,
 1675453406,
 1674916534,
 8614,
 -1,
 1675410990,
 10528,
 -1,
 1675374801,
 8644,
 -1,
 1673165841,
 10522,
 1675715572,
 1673115008,
 -1,
 1675781107,
 1675662747,
 -1,
 1675846636,
 1675718804,
 -1,
 1675912171,
 1675777065,
 -1,
 1675977705,
 1675879587,
 -1,
 1676043240,
 1675939471,
 -1,
 -39961,
 1675958081,
 10604,
 -1,
 1676022001,
 10600,
 -1,
 1675965946,
 10596,
 -39958,
 1675897651,
 10579,
 -1,
 1676227254,
 10587,
 -1,
 1675853731,
 8640,
 1676541951,
 1675814046,
 -1,
 1676567538,
 1676432425,
 -1,
 -39953,
 1676487475,
 10583,
 -39952,
 1676554934,
 10591,
 -39951,
 1676651879,
 10605,
 -1,
 1676700385,
 10601,
 -1,
 1676509091,
 8641,
 -1,
 1675726613,
 8652,
 1677026309,
 1675683210,
 -1,
 1677091842,
 1676970225,
 -1,
 1677157377,
 1677032054,
 -1,
 1677222912,
 1677105814,
 -1,
 1677288447,
 1677178279,
 -1,
 1677353981,
 1677255081,
 10518,
 1677459455,
 1677280543,
 -1,
 -39940,
 1677360355,
 10519,
 -1,
 1677446571,
 10520,
 -39938,
 1677294819,
 10496,
 -1,
 1677577643,
 10497,
 -1,
 1677210294,
 10501,
 -1,
 1677134565,
 10512,
 -1,
 1677113978,
 8608,
 1677983743,
 1677008154,
 -1,
 -39932,
 1677887735,
 10511,
 -1,
 1677942438,
 8667,
 1678140432,
 1676982523,
 -1,
 1678205967,
 1678099278,
 -1,
 1678271502,
 1678139046,
 8658,
 1678337037,
 1678201897,
 -1,
 1678402572,
 1678292391,
 -1,
 -39925,
 1678343395,
 10499,
 -1,
 1678416133,
 8655,
 -1,
 1678324406,
 10503,
 -1,
 1678277649,
 10524,
 -1,
 1678215415,
 10509,
 -1,
 1678166823,
 8674,
 1678861332,
 1678095173,
 -1,
 1678926867,
 1678823730,
 8680,
 -1,
 1678892307,
 8688,
 -1,
 1678873184,
 8605,
 -39915,
 1678795300,
 8669,
 -39914,
 1679043321,
 11078,
 -39913,
 1679105588,
 8649,
 -1,
 1679207799,
 8702,
 1679385638,
 1673049224,
 -1,
 1679451165,
 1679350855,
 -1,
 -39909,
 1679367163,
 8238,
 -39908,
 1679451391,
 8207,
 -1,
 1679493699,
 8235,
 1679713313,
 1679407953,
 -1,
 -39905,
 1679638249,
 187,
 -39904,
 1679707038,
 10749,
 -1,
 1679754332,
 9002,
 1679975460,
 1679665038,
 -1,
 -39901,
 1679936863,
 10552,
 -1,
 1679991915,
 10153,
 1680211967,
 1679934782,
 4053,
 -1,
 1680085020,
 4055,
 -1,
 1679322302,
 10813,
 1680368685,
 1666916617,
 -1,
 -39895,
 1680288791,
 11824,
 -39894,
 1680375534,
 8728,
 -39893,
 1680411984,
 8790,
 -39892,
 1680510960,
 8791,
 -1,
 1680565477,
 730,
 1680761904,
 1680292842,
 -1,
 -39889,
 1680699122,
 10544,
 -1,
 1680747608,
 10539,
 -1,
 1680704281,
 65020,
 1681024197,
 1666856801,
 -1,
 1681089681,
 1680972424,
 -1,
 1681155211,
 1681007973,
 -1,
 1681220674,
 1681106830,
 -1,
 1681286207,
 1681159378,
 -1,
 -39881,
 1681206487,
 5863,
 -39880,
 1681266897,
 5840,
 -39879,
 1681355736,
 5836,
 -39878,
 1681394058,
 5805,
 -39877,
 1681470592,
 5823,
 -39876,
 1681559894,
 5849,
 -39875,
 1681638740,
 5821,
 -39874,
 1681683584,
 5843,
 -1,
 1681750064,
 5830,
 -39872,
 1681231881,
 5861,
 -39871,
 1681904246,
 5834,
 -1,
 1681967535,
 5835,
 1682138184,
 1681169656,
 5806,
 -39868,
 1682080122,
 5855,
 -39867,
 1682147433,
 5801,
 -39866,
 1682190599,
 5845,
 -39865,
 1682267432,
 5808,
 -1,
 1682312492,
 5807,
 1682531408,
 1682099855,
 -1,
 1682596943,
 1682465900,
 -1,
 -39861,
 1682517207,
 5862,
 -39860,
 1682573706,
 5804,
 -39859,
 1682674006,
 5848,
 -39858,
 1682752852,
 5820,
 -1,
 1682771367,
 5829,
 -1,
 1682534924,
 5850,
 1683055703,
 1682446493,
 -1,
 1683121235,
 1682971430,
 5853,
 -1,
 1683080413,
 5852,
 -39852,
 1683046662,
 5831,
 -39851,
 1683208708,
 5825,
 -39850,
 1683236585,
 5857,
 -1,
 1683336367,
 5864,
 1683514460,
 1682967852,
 5826,
 -39847,
 1683464465,
 5799,
 -39846,
 1683495718,
 5814,
 -39845,
 1683574603,
 5846,
 -1,
 1683644949,
 5856,
 1683842146,
 1683470587,
 5841,
 1683907681,
 1683790824,
 -1,
 -39841,
 1683872160,
 5844,
 -39840,
 1683905832,
 5824,
 -1,
 1684000399,
 5851,
 -1,
 1683827328,
 5854,
 1684235368,
 1683782512,
 5837,
 1684300902,
 1684147500,
 -1,
 -39835,
 1684233512,
 5811,
 -1,
 1684331693,
 5860,
 -39833,
 1684252532,
 5858,
 -1,
 1684462765,
 5859,
 1684628589,
 1684178637,
 5813,
 1684694124,
 1684540716,
 -1,
 -39829,
 1684649223,
 5828,
 -1,
 1684689568,
 5815,
 -1,
 1684627989,
 5816,
 1684956274,
 1684538163,
 -1,
 -39825,
 1684881047,
 5800,
 -39824,
 1684940969,
 5833,
 -39823,
 1685044178,
 5803,
 -1,
 1685081396,
 5802,
 1685283956,
 1684882041,
 5796,
 -1,
 1685239047,
 5795,
 1685415030,
 1685238597,
 5797,
 -1,
 1685325249,
 5817,
 1685546105,
 1685382538,
 -1,
 -39816,
 1685459446,
 5839,
 -1,
 1685563902,
 5798,
 1685742716,
 1685502506,
 -1,
 -39813,
 1685652275,
 5810,
 -1,
 1685757796,
 5812,
 1685939327,
 1685698995,
 -1,
 -39810,
 1685901850,
 5818,
 -1,
 1685920999,
 5819,
 -39808,
 1685880779,
 5838,
 -39807,
 1686046639,
 5866,
 -39806,
 1686140104,
 5793,
 -39805,
 1686198786,
 5794,
 -39804,
 1686255539,
 5809,
 -39803,
 1686318397,
 5865,
 -39802,
 1686377904,
 5832,
 -39801,
 1686477919,
 5822,
 -39800,
 1686543775,
 5847,
 -39799,
 1686604187,
 5827,
 -39798,
 1686649945,
 5792,
 -1,
 1686707576,
 5842,
 -39796,
 1681118123,
 5871,
 -39795,
 1686890234,
 5867,
 -39794,
 1686936252,
 5868,
 -39793,
 1686982574,
 5869,
 -39792,
 1687037938,
 5872,
 -1,
 1687104960,
 5870,
 1687315651,
 1681020947,
 -1,
 1687381168,
 1687245508,
 -1,
 1687446683,
 1687348618,
 -1,
 1687512215,
 1687401285,
 -1,
 -39786,
 1687459398,
 69235,
 -1,
 1687532863,
 69226,
 1687708826,
 1687470994,
 -1,
 -39783,
 1687622049,
 69236,
 -1,
 1687729722,
 69227,
 -1,
 1687655861,
 69225,
 1687970978,
 1687398286,
 -1,
 1688036511,
 1687930219,
 -1,
 -39778,
 1687981071,
 69230,
 -1,
 1688051711,
 69239,
 1688272895,
 1687960190,
 -1,
 -39775,
 1688177679,
 69231,
 -1,
 1688248319,
 69240,
 1688429737,
 1687898183,
 -1,
 1688495270,
 1688378616,
 -1,
 -39771,
 1688429526,
 69237,
 -1,
 1688504005,
 69228,
 1688731647,
 1688410269,
 -1,
 -39768,
 1688642792,
 69238,
 -1,
 1688707254,
 69229,
 1688888492,
 1688351286,
 -1,
 -39765,
 1688833039,
 69233,
 -1,
 1688903679,
 69242,
 1689085103,
 1688846538,
 -1,
 -39762,
 1689010809,
 69232,
 -1,
 1689100287,
 69241,
 -1,
 1688997140,
 69234,
 1689347261,
 1687347569,
 -1,
 1689412788,
 1689314698,
 -1,
 -39757,
 1689356529,
 69217,
 -1,
 1689421843,
 69218,
 1689609399,
 1689364366,
 -1,
 -39754,
 1689568619,
 69221,
 -1,
 1689598590,
 69222,
 1689806010,
 1689536583,
 -1,
 -39751,
 1689752050,
 69219,
 -1,
 1689790466,
 69220,
 -39749,
 1689760056,
 69216,
 -39748,
 1689924150,
 69224,
 -1,
 1690026186,
 69223,
 1690238975,
 1689304720,
 -1,
 1690264770,
 1690156166,
 -1,
 -39744,
 1690181767,
 69245,
 -39743,
 1690287062,
 69244,
 -1,
 1690336133,
 69243,
 -1,
 1690221772,
 69246,
 -39740,
 1687259608,
 8360,
 -1,
 1690532671,
 10740,
 1690723626,
 1680936236,
 -1,
 1690789109,
 1690677443,
 -1,
 1690854627,
 1690707301,
 -1,
 1690920145,
 1690787112,
 -1,
 1690985676,
 1690845817,
 -1,
 -39733,
 1690948086,
 43333,
 -1,
 1690960691,
 43323,
 1691182287,
 1690928845,
 -1,
 -39730,
 1691135635,
 43331,
 -1,
 1691157299,
 43314,
 -39728,
 1691125776,
 43332,
 -1,
 1691288371,
 43317,
 1691509972,
 1690837588,
 -1,
 -39725,
 1691472385,
 43330,
 -1,
 1691484979,
 43320,
 -39723,
 1691429924,
 43327,
 -39722,
 1691650282,
 43328,
 -39721,
 1691705826,
 43315,
 -39720,
 1691768492,
 43324,
 -39719,
 1691830697,
 43325,
 -39718,
 1691897208,
 43318,
 -39717,
 1691943678,
 43326,
 -39716,
 1692065743,
 43312,
 -39715,
 1692127734,
 43322,
 -39714,
 1692187059,
 43329,
 -39713,
 1692249747,
 43313,
 -39712,
 1692305424,
 43316,
 -39711,
 1692367952,
 43321,
 -39710,
 1692455425,
 43319,
 -1,
 1692468019,
 43334,
 1692689647,
 1690793160,
 -1,
 1692755182,
 1692623121,
 -1,
 1692820712,
 1692667180,
 43337,
 -39705,
 1692743521,
 43341,
 -1,
 1692795699,
 43342,
 1693017323,
 1692730163,
 -1,
 -39702,
 1692940129,
 43340,
 -1,
 1692997789,
 43338,
 -39700,
 1692940129,
 43336,
 -39699,
 1693162744,
 43339,
 -1,
 1693194397,
 43335,
 -1,
 1692702557,
 43347,
 1693476084,
 1692632783,
 -1,
 1693541618,
 1693408552,
 43344,
 -1,
 1693484749,
 43343,
 -39693,
 1693496583,
 43345,
 -1,
 1693631378,
 43346,
 -1,
 1693403096,
 43359,
 1693869333,
 1690753651,
 -1,
 1693934860,
 1693812942,
 -1,
 1694000379,
 1693902218,
 -1,
 1694065914,
 1693913048,
 8765,
 -1,
 1694031710,
 8909,
 -1,
 1694029722,
 8247,
 1694262527,
 1693932775,
 -1,
 1694328062,
 1694208021,
 8246,
 -1,
 1694265410,
 12317,
 -1,
 1694279361,
 10989,
 1694524674,
 1694214030,
 -1,
 -39679,
 1694484944,
 8271,
 -1,
 1694529833,
 8515,
 1694721285,
 1694488992,
 -1,
 -39676,
 1694667075,
 8245,
 -1,
 1694695931,
 8267,
 1694917895,
 1694640570,
 10659,
 -1,
 1694833043,
 10661,
 -39672,
 1694867196,
 9753,
 -39671,
 1695004387,
 11822,
 -39670,
 1695040608,
 8976,
 -39669,
 1695103562,
 11793,
 -1,
 1695174048,
 10672,
 1695416319,
 1693865001,
 -1,
 1695442194,
 1695305201,
 92,
 1695547391,
 1695372329,
 -1,
 -39664,
 1695472163,
 10743,
 -39663,
 1695534276,
 10184,
 -1,
 1695579886,
 10741,
 1695809535,
 1695409288,
 -1,
 -39660,
 1695734911,
 11079,
 -1,
 1695756821,
 11073,
 1695966497,
 1693821215,
 -1,
 1696032032,
 1695930716,
 -1,
 1696097567,
 1695980569,
 -1,
 -39655,
 1696053072,
 9849,
 -39654,
 1696107650,
 9848,
 -39653,
 1696138438,
 9847,
 -39652,
 1696238376,
 9846,
 -39651,
 1696274380,
 9845,
 -39650,
 1696348707,
 9844,
 -1,
 1696403028,
 9843,
 -1,
 1696018785,
 9850,
 -1,
 1695996763,
 9852,
 1696752934,
 1695917966,
 -1,
 1696818469,
 1696671330,
 -1,
 -39644,
 1696732176,
 9953,
 -1,
 1696841384,
 9952,
 -1,
 1696734061,
 8479,
 -39641,
 1696678571,
 9166,
 -39640,
 1696990539,
 65533,
 -39639,
 1697094816,
 174,
 -1,
 1697162818,
 8251,
 1697342818,
 1690672376,
 -1,
 1697408350,
 1697307035,
 -1,
 1697473870,
 1697360402,
 -1,
 1697539384,
 1697400903,
 -1,
 1697604919,
 1697454237,
 -1,
 1697670451,
 1697545469,
 8548,
 1697775615,
 1697600553,
 -1,
 -39630,
 1697678174,
 8577,
 -1,
 1697726531,
 8558,
 1697972223,
 1697620150,
 8556,
 1698037759,
 1697862697,
 -1,
 -39626,
 1697940318,
 8583,
 -1,
 1697983884,
 8582,
 -1,
 1697550834,
 8547,
 1698260287,
 1697506698,
 -1,
 1698325820,
 1698214725,
 -1,
 -39621,
 1698274552,
 8545,
 -1,
 1698315836,
 8555,
 1698522430,
 1698272693,
 8553,
 -1,
 1698471212,
 8578,
 -1,
 1698465811,
 8546,
 1698719045,
 1698214200,
 8544,
 1698824191,
 1698649129,
 -1,
 1698850115,
 1698726750,
 8559,
 -1,
 1698799895,
 8576,
 1699020799,
 1698775107,
 8557,
 -1,
 1698929964,
 8584,
 1699112265,
 1698670478,
 -1,
 1699177800,
 1699071339,
 8549,
 -1,
 1699100576,
 8581,
 -1,
 1699101310,
 8550,
 1699374412,
 1699024172,
 -1,
 -39605,
 1699302779,
 8554,
 -1,
 1699390014,
 8551,
 -39603,
 1699329640,
 8579,
 -1,
 1699492406,
 8552,
 1699702102,
 1697425294,
 -1,
 1699767637,
 1699613996,
 -1,
 1699833171,
 1699714790,
 -1,
 -39598,
 1699763750,
 65939,
 -1,
 1699862207,
 65936,
 -39596,
 1699749836,
 65944,
 -1,
 1699991869,
 65938,
 -1,
 1699715503,
 65941,
 1700226394,
 1699657979,
 -1,
 -39592,
 1700146789,
 65945,
 -39591,
 1700250705,
 65940,
 -1,
 1700317448,
 65942,
 -39589,
 1700176344,
 65937,
 -39588,
 1700447821,
 65943,
 -39587,
 1700505139,
 65947,
 -1,
 1700570422,
 65946,
 1700790271,
 1697355365,
 -1,
 -39584,
 1700699569,
 10085,
 -39583,
 1700750807,
 10087,
 -1,
 1700839987,
 8506,
 1701052415,
 1697252147,
 -1,
 1701078377,
 1700927645,
 -1,
 1701143912,
 1701037405,
 -1,
 -39578,
 1701059148,
 11787,
 -39577,
 1701157157,
 11782,
 -1,
 1701233137,
 11783,
 -1,
 1701076264,
 9926,
 1701471596,
 1701021696,
 -1,
 -39573,
 1701403808,
 9762,
 -1,
 1701477740,
 9143,
 -1,
 1701408376,
 8758,
 1701734253,
 1666832800,
 -1,
 1701799476,
 1701643059,
 -1,
 1701865006,
 1701754119,
 -1,
 1701930527,
 1701781516,
 -1,
 1701995944,
 1701891042,
 -1,
 1702061453,
 1701952190,
 -1,
 -39564,
 1702002635,
 9397,
 -39563,
 1702052473,
 9396,
 -39562,
 1702102959,
 9395,
 -39561,
 1702212421,
 9394,
 -39560,
 1702261960,
 9393,
 -39559,
 1702311777,
 9392,
 -39558,
 1702421898,
 9391,
 -39557,
 1702471566,
 9390,
 -39556,
 1702540551,
 9389,
 -39555,
 1702571325,
 9388,
 -39554,
 1702680992,
 9387,
 -39553,
 1702731000,
 9386,
 -39552,
 1702780200,
 9385,
 -39551,
 1702830676,
 9384,
 -39550,
 1702940303,
 9383,
 -39549,
 1702990135,
 9382,
 -39548,
 1703039692,
 9381,
 -39547,
 1703090333,
 9380,
 -39546,
 1703199634,
 9379,
 -39545,
 1703249613,
 9378,
 -39544,
 1703299143,
 9377,
 -39543,
 1703349548,
 9376,
 -39542,
 1703459067,
 9375,
 -39541,
 1703508848,
 9374,
 -39540,
 1703558592,
 9373,
 -1,
 1703609139,
 9372,
 1703870463,
 1702003262,
 -1,
 -39537,
 1703772107,
 127273,
 -39536,
 1703821945,
 127272,
 -39535,
 1703872431,
 127271,
 -39534,
 1703981893,
 127270,
 -39533,
 1704031432,
 127269,
 -39532,
 1704081249,
 127268,
 -39531,
 1704191370,
 127267,
 -39530,
 1704241038,
 127266,
 -39529,
 1704310023,
 127265,
 -39528,
 1704340797,
 127264,
 -39527,
 1704450464,
 127263,
 -39526,
 1704500472,
 127262,
 -39525,
 1704549672,
 127261,
 -39524,
 1704600148,
 127260,
 -39523,
 1704709775,
 127259,
 -39522,
 1704759607,
 127258,
 -39521,
 1704809164,
 127257,
 -39520,
 1704859805,
 127256,
 -39519,
 1704969106,
 127255,
 -39518,
 1705019085,
 127254,
 -39517,
 1705068615,
 127253,
 -39516,
 1705119020,
 127252,
 -39515,
 1705228539,
 127251,
 -39514,
 1705278320,
 127250,
 -39513,
 1705328064,
 127249,
 -1,
 1705378611,
 127248,
 1705600475,
 1701954766,
 -1,
 1705665974,
 1705551758,
 -1,
 1705731501,
 1705588577,
 -1,
 -39508,
 1705699353,
 12860,
 -1,
 1705729320,
 12848,
 1705928112,
 1705698698,
 -1,
 -39505,
 1705858861,
 12859,
 -1,
 1705928544,
 12849,
 1706124723,
 1705839916,
 -1,
 -39502,
 1706040981,
 12838,
 -1,
 1706099442,
 12866,
 -39500,
 1706076287,
 12853,
 -39499,
 1706268614,
 12851,
 -1,
 1706345835,
 12837,
 1706517949,
 1705592903,
 -1,
 1706583483,
 1706432669,
 -1,
 -39495,
 1706523901,
 12836,
 -39494,
 1706576294,
 12843,
 -1,
 1706626293,
 12854,
 -39492,
 1706529266,
 12835,
 -1,
 1706812521,
 12864,
 1706976707,
 1706445222,
 -1,
 1707042241,
 1706928014,
 -1,
 -39488,
 1707009418,
 12865,
 -1,
 1707057328,
 12862,
 -39486,
 1706970039,
 12857,
 -1,
 1707157653,
 12867,
 1707369927,
 1706943882,
 -1,
 -39483,
 1707313393,
 12833,
 -39482,
 1707378707,
 12834,
 -1,
 1707447733,
 12841,
 1707632075,
 1707281708,
 -1,
 -39479,
 1707546791,
 12861,
 -39478,
 1707647550,
 12839,
 -1,
 1707672114,
 12847,
 1707894222,
 1707586373,
 -1,
 -39475,
 1707816845,
 12845,
 -1,
 1707913387,
 12844,
 1708090833,
 1707826472,
 -1,
 -39472,
 1708017572,
 12840,
 -1,
 1708089308,
 12852,
 1708287444,
 1708008020,
 -1,
 -39469,
 1708210076,
 12842,
 -1,
 1708300037,
 12846,
 1708484055,
 1708227440,
 -1,
 -39466,
 1708399362,
 12855,
 -1,
 1708514427,
 12858,
 -39464,
 1708437816,
 12832,
 -39463,
 1708602335,
 12856,
 -39462,
 1708709355,
 12850,
 -1,
 1708756431,
 12863,
 1708942846,
 1705529885,
 -1,
 1709008355,
 1708882800,
 -1,
 1709073889,
 1708935495,
 12808,
 1709178879,
 1709003817,
 -1,
 -39456,
 1709061985,
 12828,
 -1,
 1709114163,
 12822,
 1709375487,
 1708986109,
 12809,
 -1,
 1709285217,
 12823,
 1709467112,
 1708975498,
 -1,
 1709532646,
 1709421169,
 12802,
 -1,
 1709481825,
 12816,
 1709703167,
 1709486268,
 12811,
 -1,
 1709612897,
 12825,
 1709794797,
 1709431200,
 -1,
 1709860331,
 1709721953,
 12805,
 -1,
 1709809505,
 12819,
 1710030847,
 1709817870,
 12812,
 -1,
 1709940577,
 12826,
 1710122482,
 1709740343,
 -1,
 1710188016,
 1710080268,
 12800,
 -1,
 1710137185,
 12814,
 1710358527,
 1710108055,
 12810,
 -1,
 1710268257,
 12824,
 1710450164,
 1710085710,
 12806,
 -1,
 1710399329,
 12820,
 1710581238,
 1710373890,
 12803,
 -1,
 1710530401,
 12817,
 1710712312,
 1710502962,
 12801,
 -1,
 1710661473,
 12815,
 1710843386,
 1710652511,
 12804,
 -1,
 1710792545,
 12818,
 1710974460,
 1710809371,
 12807,
 -1,
 1710923617,
 12821,
 1711144959,
 1710883206,
 12813,
 -1,
 1711054689,
 12827,
 1711236623,
 1708872388,
 -1,
 1711302149,
 1711203722,
 -1,
 1711367683,
 1711245543,
 -1,
 -39422,
 1711332471,
 9351,
 -1,
 1711381320,
 9343,
 -39420,
 1711313366,
 9344,
 -1,
 1711510965,
 9341,
 1711695368,
 1711253390,
 -1,
 -39417,
 1711663105,
 9347,
 -1,
 1711685047,
 9348,
 1711891979,
 1711622215,
 -1,
 -39414,
 1711836099,
 9345,
 -1,
 1711918665,
 9346,
 1712088590,
 1711803692,
 -1,
 -39411,
 1712016763,
 9342,
 -1,
 1712075394,
 9349,
 -1,
 1712023679,
 9350,
 1712350748,
 1711202673,
 -1,
 1712416275,
 1712317834,
 -1,
 -39406,
 1712359665,
 9333,
 -1,
 1712424979,
 9334,
 1712612886,
 1712367502,
 -1,
 -39403,
 1712571755,
 9337,
 -1,
 1712601726,
 9338,
 1712809497,
 1712539719,
 -1,
 -39400,
 1712755186,
 9335,
 -1,
 1712793602,
 9336,
 -39398,
 1712763192,
 9332,
 -39397,
 1712927286,
 9340,
 -1,
 1713029322,
 9339,
 1713242111,
 1712295682,
 -1,
 -39394,
 1713125200,
 12829,
 -1,
 1713222193,
 12830,
 1713399336,
 1701839667,
 -1,
 1713464869,
 1713361466,
 -1,
 1713530404,
 1713419687,
 -1,
 -39389,
 1713478240,
 10995,
 -1,
 1713509281,
 10994,
 -1,
 1713463733,
 8741,
 1713831935,
 1713375283,
 -1,
 -39385,
 1713710822,
 11791,
 -1,
 1713785669,
 8233,
 1714028543,
 1713366410,
 -1,
 1714054700,
 1713951265,
 -1,
 -39381,
 1713985456,
 9853,
 -1,
 1714035615,
 8706,
 -39379,
 1713990753,
 12880,
 -1,
 1714166195,
 12349,
 1714382385,
 1701829895,
 -1,
 -39376,
 1714311974,
 9106,
 -1,
 1714361803,
 9105,
 1714618367,
 1714343567,
 -1,
 -39373,
 1714540718,
 11801,
 -1,
 1714608698,
 9908,
 1714775784,
 1701757842,
 -1,
 1714841280,
 1714684723,
 -1,
 1714906752,
 1714779951,
 -1,
 1714972276,
 1714824549,
 -1,
 1715037761,
 1714939274,
 -1,
 1715103292,
 1715004810,
 -1,
 -39365,
 1715059123,
 43114,
 -1,
 1715077939,
 43113,
 1715299903,
 1715054478,
 -1,
 -39362,
 1715255731,
 43089,
 -1,
 1715274547,
 43088,
 -39360,
 1715255731,
 43081,
 -1,
 1715405619,
 43080,
 1715627590,
 1714969896,
 -1,
 -39357,
 1715547172,
 43079,
 -39356,
 1715608349,
 43116,
 -39355,
 1715711635,
 43075,
 -1,
 1715733299,
 43083,
 1715955274,
 1715578766,
 -1,
 -39352,
 1715872112,
 43094,
 -39351,
 1715976627,
 43098,
 -1,
 1715995443,
 43099,
 1716217422,
 1715910907,
 -1,
 -39348,
 1716170537,
 43090,
 -39347,
 1716226064,
 43115,
 -1,
 1716257587,
 43082,
 1716479570,
 1716157296,
 -1,
 1716545105,
 1716388659,
 43076,
 -1,
 1716457441,
 43123,
 -1,
 1716500915,
 43077,
 1716741717,
 1716388659,
 43101,
 -39340,
 1716680208,
 43120,
 -1,
 1716768496,
 43117,
 1716938328,
 1716682699,
 -1,
 -39337,
 1716894131,
 43092,
 -1,
 1716912947,
 43093,
 1717134939,
 1716868126,
 -1,
 -39334,
 1717047446,
 43118,
 -1,
 1717152691,
 43119,
 1717331550,
 1717098912,
 -1,
 -39331,
 1717287347,
 43085,
 -1,
 1717306163,
 43084,
 1717528161,
 1717276983,
 -1,
 -39328,
 1717483955,
 43073,
 -1,
 1717502771,
 43072,
 1717724772,
 1717470925,
 -1,
 -39325,
 1717677715,
 43109,
 -1,
 1717699379,
 43074,
 1717921382,
 1717636396,
 43104,
 -1,
 1717833004,
 43110,
 -39321,
 1717840932,
 43095,
 -39320,
 1717999277,
 43107,
 -39319,
 1718061290,
 43091,
 -39318,
 1718105953,
 43103,
 -39317,
 1718176169,
 43096,
 -39316,
 1718238937,
 43106,
 -39315,
 1718328568,
 43105,
 -39314,
 1718357926,
 43087,
 -39313,
 1718420222,
 43097,
 -39312,
 1718538742,
 43078,
 -39311,
 1718556829,
 43102,
 -39310,
 1718663603,
 43100,
 -39309,
 1718722815,
 43108,
 -1,
 1718800897,
 43086,
 1718969980,
 1714923406,
 -1,
 1719035515,
 1718892385,
 -1,
 1719101050,
 1718985763,
 -1,
 -39304,
 1719020580,
 43112,
 -39303,
 1719109866,
 43111,
 -1,
 1719159209,
 43121,
 -1,
 1719058549,
 43122,
 -1,
 1718984493,
 43124,
 1719494271,
 1718891223,
 -1,
 -39298,
 1719410083,
 43126,
 -1,
 1719469203,
 43127,
 -1,
 1719442296,
 43125,
 1719795711,
 1714865139,
 -1,
 1719821964,
 1719696240,
 -1,
 1719887494,
 1719770360,
 -1,
 1719953029,
 1719799721,
 66020,
 -1,
 1719917043,
 66045,
 -1,
 1719888728,
 66022,
 1720149642,
 1719796531,
 -1,
 -39288,
 1720116618,
 66028,
 -39287,
 1720179759,
 66018,
 -1,
 1720206296,
 66003,
 -39285,
 1720066343,
 66012,
 -1,
 1720334443,
 66004,
 1720542868,
 1719773070,
 -1,
 1720608400,
 1720498587,
 -1,
 -39281,
 1720572320,
 66024,
 -1,
 1720633639,
 66011,
 -39279,
 1720554459,
 66042,
 -39278,
 1720755336,
 66043,
 -39277,
 1720831511,
 66021,
 -1,
 1720869406,
 66015,
 1721067163,
 1720466880,
 -1,
 1721132696,
 1721015544,
 -1,
 -39273,
 1721086789,
 66010,
 -1,
 1721113101,
 66017,
 1721329306,
 1721079233,
 66033,
 -1,
 1721251942,
 66023,
 -1,
 1721283711,
 66027,
 1721525921,
 1721031072,
 -1,
 1721591455,
 1721486991,
 -1,
 -39266,
 1721504385,
 66001,
 -1,
 1721595240,
 66034,
 -39264,
 1721502427,
 66000,
 -1,
 1721702077,
 66036,
 1721919141,
 1721492874,
 -1,
 -39261,
 1721842998,
 66032,
 -39260,
 1721912731,
 66008,
 -1,
 1721965193,
 66002,
 1722181289,
 1721877394,
 -1,
 -39257,
 1722104495,
 66025,
 -39256,
 1722183944,
 66026,
 -1,
 1722268514,
 66006,
 1722443436,
 1722135365,
 -1,
 -39253,
 1722371431,
 66005,
 -1,
 1722418544,
 66044,
 1722640047,
 1722397959,
 -1,
 -39250,
 1722580470,
 66037,
 -1,
 1722638851,
 66029,
 1722836658,
 1722552230,
 -1,
 -39247,
 1722765557,
 66014,
 -1,
 1722819641,
 66013,
 1723033269,
 1722745639,
 -1,
 -39244,
 1722942256,
 66038,
 -1,
 1723054331,
 66016,
 1723229880,
 1722975949,
 -1,
 -39241,
 1723185745,
 66041,
 -1,
 1723236330,
 66007,
 1723426491,
 1723172861,
 -1,
 -39238,
 1723366653,
 66031,
 -1,
 1723432721,
 66019,
 -39236,
 1723338889,
 66035,
 -39235,
 1723537861,
 66039,
 -39234,
 1723600134,
 66040,
 -39233,
 1723667762,
 66030,
 -1,
 1723752102,
 66009,
 1723950821,
 1714778825,
 -1,
 1724016347,
 1723868517,
 -1,
 1724081862,
 1723967374,
 -1,
 -39228,
 1724016056,
 67860,
 -39227,
 1724075561,
 67854,
 -1,
 1724168921,
 67857,
 1724344009,
 1724048778,
 -1,
 -39224,
 1724290538,
 67848,
 -1,
 1724342808,
 67861,
 1724540619,
 1724299702,
 67844,
 -1,
 1724507530,
 67847,
 1724671694,
 1724449587,
 -1,
 -39219,
 1724580594,
 67840,
 -1,
 1724695974,
 67855,
 -39217,
 1724603360,
 67846,
 -39216,
 1724831110,
 67849,
 -39215,
 1724892389,
 67845,
 -39214,
 1724920919,
 67859,
 -39213,
 1725018897,
 67858,
 -39212,
 1725051456,
 67856,
 -39211,
 1725150104,
 67853,
 -39210,
 1725180284,
 67852,
 -39209,
 1725267285,
 67851,
 -39208,
 1725305437,
 67850,
 -39207,
 1725383735,
 67842,
 -39206,
 1725472467,
 67843,
 -1,
 1725497628,
 67841,
 1725720292,
 1723945668,
 -1,
 1725785826,
 1725687178,
 -1,
 1725851360,
 1725739845,
 -1,
 -39201,
 1725799672,
 67866,
 -1,
 1725871423,
 67864,
 -39199,
 1725794323,
 67867,
 -1,
 1725994421,
 67863,
 1726218239,
 1725739320,
 67862,
 -1,
 1726128127,
 67865,
 -1,
 1725637213,
 67871,
 1726414847,
 1723912237,
 -1,
 -39193,
 1726342906,
 5941,
 -1,
 1726381739,
 5942,
 1726572338,
 1714730247,
 -1,
 1726637865,
 1726483756,
 -1,
 1726703384,
 1726588814,
 -1,
 1726768919,
 1726660325,
 -1,
 1726834427,
 1726729871,
 -1,
 1726899962,
 1726746063,
 -1,
 1726965489,
 1726863334,
 -1,
 -39184,
 1726903388,
 65047,
 -1,
 1726939378,
 65091,
 1727162100,
 1726905200,
 -1,
 -39181,
 1727090886,
 65079,
 -1,
 1727168476,
 65089,
 -39179,
 1727119496,
 65081,
 -39178,
 1727304505,
 65095,
 -39177,
 1727340959,
 65077,
 -39176,
 1727421124,
 65085,
 -39175,
 1727468943,
 65083,
 -1,
 1727530076,
 65087,
 -1,
 1726835387,
 65075,
 1727817480,
 1726783751,
 -1,
 1727883007,
 1727780838,
 -1,
 -39170,
 1727800050,
 65048,
 -1,
 1727856882,
 65092,
 1728079618,
 1727822704,
 -1,
 -39167,
 1728008390,
 65080,
 -1,
 1728085980,
 65090,
 -39165,
 1728037000,
 65082,
 -39164,
 1728222009,
 65096,
 -39163,
 1728258463,
 65078,
 -39162,
 1728338628,
 65086,
 -39161,
 1728386447,
 65084,
 -1,
 1728447580,
 65088,
 1728669452,
 1727728940,
 -1,
 -39158,
 1728579595,
 65045,
 -39157,
 1728689812,
 65074,
 -1,
 1728733910,
 65073,
 1728931599,
 1728630384,
 -1,
 -39154,
 1728841239,
 65042,
 -1,
 1728947703,
 65041,
 1729128210,
 1728871498,
 -1,
 -39151,
 1729054803,
 65040,
 -1,
 1729104341,
 65043,
 -39149,
 1729064317,
 65076,
 -39148,
 1729245118,
 65072,
 -39147,
 1729312055,
 65044,
 -39146,
 1729410787,
 65046,
 -1,
 1729434217,
 65049,
 -1,
 1726712566,
 8478,
 1729718056,
 1726637910,
 8826,
 1729822719,
 1729647657,
 -1,
 1729849123,
 1729750179,
 -1,
 1729914654,
 1729814958,
 -1,
 -39139,
 1729843749,
 10929,
 -1,
 1729920122,
 10927,
 1730111265,
 1729878016,
 -1,
 -39136,
 1730056176,
 10933,
 -1,
 1730137379,
 10937,
 -39134,
 1730051194,
 10931,
 -1,
 1730268451,
 10935,
 1730438950,
 1729762648,
 -1,
 -39131,
 1730354435,
 8830,
 -1,
 1730447175,
 8828,
 -39129,
 1730355177,
 8880,
 -1,
 1730598442,
 8936,
 -1,
 1729663413,
 9111,
 1730832175,
 1726586104,
 -1,
 1730897710,
 1730795936,
 -1,
 1730963245,
 1730855626,
 8759,
 -1,
 1730905927,
 8733,
 -1,
 1730929943,
 8522,
 -1,
 1730812566,
 8965,
 1731264511,
 1730746525,
 -1,
 -39119,
 1731147543,
 9113,
 -1,
 1731202979,
 8242,
 1731422028,
 1726533263,
 -1,
 1731487560,
 1731344225,
 -1,
 1731553095,
 1731438478,
 -1,
 1731618630,
 1731496355,
 43,
 1731723263,
 1731548201,
 -1,
 1731749697,
 1731638695,
 -1,
 1731815227,
 1731682037,
 -1,
 -39110,
 1731770486,
 10790,
 -1,
 1731814629,
 10788,
 1732011838,
 1731766158,
 -1,
 -39107,
 1731960128,
 10791,
 -1,
 1731993869,
 10786,
 -39105,
 1731957049,
 10789,
 -39104,
 1732142208,
 10787,
 -1,
 1732194734,
 10792,
 1732405061,
 1731675960,
 -1,
 -39101,
 1732325482,
 10809,
 -39100,
 1732402952,
 10798,
 -1,
 1732488126,
 10797,
 -1,
 1732346833,
 10866,
 -1,
 1731578079,
 177,
 -1,
 1731486133,
 9799,
 1732902911,
 1731396403,
 -1,
 1732929355,
 1732781863,
 8462,
 -1,
 1732841923,
 8463,
 -1,
 1732865005,
 8984,
 1733125982,
 1731333420,
 -1,
 1733191513,
 1733080327,
 -1,
 1733257042,
 1733121065,
 -1,
 -39088,
 1733165056,
 8241,
 -39087,
 1733277065,
 8524,
 -1,
 1733347581,
 8240,
 1733519189,
 1733207950,
 -1,
 -39084,
 1733486447,
 8966,
 -1,
 1733549072,
 9977,
 1733715799,
 1733446884,
 10178,
 -1,
 1733672323,
 10977,
 -39080,
 1733645871,
 9854,
 -1,
 1733755154,
 37,
 1733977948,
 1733142414,
 -1,
 -39077,
 1733940421,
 8369,
 -1,
 1733993617,
 8359,
 -39075,
 1733944594,
 9999,
 -1,
 1734104123,
 9774,
 1734305637,
 1733040285,
 -1,
 1734371169,
 1734217534,
 8916,
 -1,
 1734324159,
 10970,
 -39070,
 1734297647,
 9811,
 -39069,
 1734461449,
 10031,
 -39068,
 1734503504,
 182,
 -1,
 1734573124,
 9935,
 1734764396,
 1734253816,
 -1,
 1734829930,
 1734715278,
 -1,
 1734895465,
 1734790151,
 12306,
 -1,
 1734816432,
 12320,
 -1,
 1734837495,
 8982,
 -39061,
 1734763785,
 163,
 -1,
 1735005992,
 8236,
 -1,
 1734705844,
 8200,
 1735289057,
 1701666088,
 -1,
 1735354386,
 1735200044,
 -1,
 1735419870,
 1735297422,
 -1,
 1735485405,
 1735339872,
 -1,
 1735550900,
 1735402853,
 -1,
 1735616399,
 1735474149,
 -1,
 1735681911,
 1735583114,
 -1,
 -39051,
 1735612076,
 6539,
 -39050,
 1735702963,
 6546,
 -1,
 1735721779,
 6545,
 1735944058,
 1735591855,
 -1,
 -39047,
 1735884019,
 6569,
 -1,
 1735918387,
 6534,
 1736140669,
 1735894926,
 -1,
 -39044,
 1736077516,
 6571,
 -1,
 1736114995,
 6540,
 1736337280,
 1736104352,
 -1,
 -39041,
 1736292787,
 6552,
 -1,
 1736311603,
 6551,
 1736533891,
 1736269096,
 -1,
 -39038,
 1736486547,
 6535,
 -1,
 1736508211,
 6547,
 1736730502,
 1736479031,
 -1,
 -39035,
 1736670451,
 6568,
 -1,
 1736704819,
 6533,
 -39033,
 1736649764,
 6541,
 -39032,
 1736867059,
 6558,
 -39031,
 1736916697,
 6529,
 -39030,
 1736970150,
 6553,
 -39029,
 1737032446,
 6559,
 -39028,
 1737144755,
 6563,
 -39027,
 1737203967,
 6557,
 -39026,
 1737263120,
 6564,
 -1,
 1737347585,
 6565,
 1737516972,
 1735555400,
 -1,
 1737582484,
 1737483658,
 -1,
 -39022,
 1737512620,
 6536,
 -39021,
 1737603507,
 6543,
 -1,
 1737622323,
 6542,
 1737844631,
 1737492399,
 -1,
 -39018,
 1737784563,
 6567,
 -1,
 1737818931,
 6531,
 1738041242,
 1737795470,
 -1,
 -39015,
 1737978060,
 6570,
 -1,
 1738015539,
 6537,
 1738237853,
 1738004896,
 -1,
 -39012,
 1738193331,
 6549,
 -1,
 1738212147,
 6548,
 1738434464,
 1738169640,
 -1,
 -39009,
 1738387091,
 6532,
 -1,
 1738408755,
 6544,
 1738631075,
 1738379575,
 -1,
 -39006,
 1738570995,
 6566,
 -1,
 1738605363,
 6530,
 -39004,
 1738550308,
 6538,
 -39003,
 1738767603,
 6555,
 -39002,
 1738817241,
 6528,
 -39001,
 1738870694,
 6550,
 -39000,
 1738932990,
 6556,
 -38999,
 1739045299,
 6560,
 -38998,
 1739104511,
 6554,
 -38997,
 1739163664,
 6561,
 -1,
 1739248129,
 6562,
 1739456511,
 1737464684,
 -1,
 1739483055,
 1739349288,
 6595,
 -1,
 1739425485,
 6594,
 -38992,
 1739420872,
 6593,
 -38991,
 1739530836,
 6596,
 -38990,
 1739624759,
 6597,
 -38989,
 1739700475,
 6598,
 -1,
 1739734464,
 6599,
 1739941832,
 1735494709,
 -1,
 1740007354,
 1739863905,
 6579,
 1740072888,
 1739918636,
 6585,
 -1,
 1739997817,
 6591,
 -38983,
 1739997817,
 6588,
 -1,
 1740126049,
 6580,
 1740335038,
 1739955448,
 6583,
 1740400573,
 1740243763,
 6584,
 -1,
 1740325497,
 6590,
 -1,
 1740325497,
 6589,
 1740597187,
 1740243763,
 -1,
 1740662721,
 1740505907,
 6577,
 -1,
 1740587641,
 6587,
 -38974,
 1740587641,
 6586,
 -1,
 1740705068,
 6582,
 1740924870,
 1740511389,
 -1,
 -38971,
 1740849785,
 6592,
 -1,
 1740904605,
 6578,
 -38969,
 1740849035,
 6576,
 -1,
 1741032748,
 6581,
 1741252566,
 1739907441,
 -1,
 1741318092,
 1741219210,
 -1,
 -38965,
 1741261041,
 6610,
 -1,
 1741326355,
 6611,
 1741514703,
 1741268878,
 -1,
 -38962,
 1741473131,
 6614,
 -1,
 1741503102,
 6615,
 1741711314,
 1741441095,
 -1,
 -38959,
 1741656562,
 6612,
 -1,
 1741694978,
 6613,
 -38957,
 1741621603,
 6608,
 -38956,
 1741861176,
 6609,
 -38955,
 1741894198,
 6617,
 -1,
 1741996234,
 6616,
 1742170075,
 1741219210,
 -1,
 1742235610,
 1742124372,
 -1,
 -38951,
 1742148624,
 6601,
 -1,
 1742257832,
 6600,
 -1,
 1742156157,
 6618,
 1742536703,
 1742091486,
 6622,
 -1,
 1742435528,
 6623,
 -1,
 1735404069,
 8362,
 1742694399,
 1735350122,
 -1,
 1742759934,
 1742631955,
 -1,
 1742825461,
 1742716254,
 -1,
 1742890993,
 1742754500,
 -1,
 1742956519,
 1742857610,
 -1,
 1743022054,
 1742899431,
 -1,
 -38939,
 1742986359,
 9460,
 -1,
 1743035208,
 9452,
 -1,
 1742967254,
 9453,
 1743284202,
 1742907278,
 -1,
 -38935,
 1743251457,
 9456,
 -1,
 1743273399,
 9457,
 1743480813,
 1743210567,
 -1,
 -38932,
 1743424451,
 9454,
 -1,
 1743507017,
 9455,
 1743677424,
 1743392044,
 -1,
 -38929,
 1743605115,
 9451,
 -1,
 1743663746,
 9458,
 -1,
 1743612031,
 9459,
 1743939572,
 1742807885,
 -1,
 -38925,
 1743903136,
 127327,
 -1,
 1743963026,
 127319,
 -1,
 1743874350,
 9471,
 1744240639,
 1742762598,
 -1,
 1744267259,
 1744118605,
 -1,
 -38920,
 1744230816,
 127359,
 -38919,
 1744249428,
 127356,
 -38918,
 1744359055,
 127355,
 -1,
 1744392908,
 127353,
 -38916,
 1744197292,
 127373,
 -38915,
 1744522616,
 127372,
 -1,
 1744618924,
 127371,
 -1,
 1742699080,
 8879,
 1744857103,
 1742659826,
 -1,
 1744922629,
 1744765011,
 -1,
 1744988164,
 1744880532,
 -1,
 -38909,
 1744903427,
 8820,
 -1,
 1744996167,
 8816,
 -1,
 1744952232,
 8824,
 1745250314,
 1744867886,
 -1,
 1745315849,
 1745208212,
 -1,
 -38904,
 1745231107,
 8821,
 -1,
 1745323847,
 8817,
 -1,
 1745229415,
 8825,
 1745616895,
 1745158963,
 -1,
 1745643534,
 1745524862,
 -1,
 -38899,
 1745557424,
 8841,
 -1,
 1745662696,
 8840,
 -1,
 1745569282,
 8775,
 -38896,
 1744784208,
 9112,
 -38895,
 1745828723,
 9906,
 -1,
 1745893091,
 9798,
 1746102364,
 1735319527,
 -1,
 1746167867,
 1746062991,
 -1,
 1746233401,
 1746116944,
 -1,
 1746298906,
 1746165032,
 2002,
 1746364440,
 1746218020,
 2018,
 -1,
 1746295671,
 2023,
 1746534399,
 1746273075,
 2019,
 -1,
 1746426743,
 2016,
 1746626592,
 1746227916,
 -1,
 1746692127,
 1746578330,
 -1,
 -38883,
 1746618793,
 2026,
 -38882,
 1746719222,
 2024,
 -1,
 1746776642,
 2025,
 -1,
 1746600755,
 2006,
 1747019811,
 1746580743,
 -1,
 -38878,
 1746946473,
 2010,
 -1,
 1746993971,
 2009,
 1747216421,
 1746967800,
 2000,
 -1,
 1747164408,
 1999,
 1747347495,
 1747127596,
 1997,
 -1,
 1747258668,
 1995,
 1747478569,
 1747290128,
 2008,
 -1,
 1747423646,
 2001,
 -38870,
 1747397668,
 2022,
 -38869,
 1747552490,
 2021,
 -38868,
 1747597153,
 1998,
 -38867,
 1747673570,
 2005,
 -38866,
 1747736236,
 2011,
 -38865,
 1747799416,
 2004,
 -38864,
 1747849126,
 2017,
 -38863,
 1747911422,
 2015,
 -38862,
 1748033487,
 2014,
 -38861,
 1748048029,
 1996,
 -38860,
 1748154803,
 2020,
 -38859,
 1748189219,
 2012,
 -38858,
 1748279551,
 2013,
 -38857,
 1748349506,
 2007,
 -38856,
 1748423169,
 2003,
 -1,
 1748435763,
 1994,
 -38854,
 1746143197,
 2037,
 -1,
 1748624554,
 2042,
 1748789321,
 1746133361,
 -1,
 1748854847,
 1748755850,
 -1,
 -38850,
 1748797681,
 1986,
 -1,
 1748862995,
 1987,
 1749051458,
 1748805518,
 -1,
 -38847,
 1749009771,
 1990,
 -1,
 1749039742,
 1991,
 1749248069,
 1748977735,
 -1,
 -38844,
 1749193202,
 1988,
 -1,
 1749231618,
 1989,
 -38842,
 1749158243,
 1984,
 -38841,
 1749397816,
 1985,
 -38840,
 1749430838,
 1993,
 -1,
 1749532874,
 1992,
 1749706839,
 1748717328,
 -1,
 1749772374,
 1749622011,
 -1,
 1749837904,
 1749719327,
 -1,
 -38835,
 1749791644,
 2033,
 -38834,
 1749863827,
 2032,
 -38833,
 1749901620,
 2031,
 -1,
 1749968645,
 2030,
 1750165588,
 1749750802,
 -1,
 -38830,
 1750119324,
 2029,
 -38829,
 1750191507,
 2028,
 -1,
 1750229300,
 2027,
 -38827,
 1750073870,
 2034,
 -1,
 1750340710,
 2035,
 -1,
 1749684134,
 2040,
 1750624346,
 1749637891,
 -1,
 -38823,
 1750568331,
 2038,
 -1,
 1750602455,
 2039,
 -38821,
 1750537253,
 2036,
 -1,
 1750786626,
 2041,
 1750952111,
 1746050296,
 -1,
 1751017611,
 1750906119,
 8893,
 1751083145,
 1750982993,
 -1,
 1751148653,
 1750996860,
 -1,
 1751214186,
 1751057203,
 -1,
 1751279721,
 1751171346,
 8598,
 1751384063,
 1751209001,
 -1,
 1751410790,
 1751295567,
 -1,
 -38811,
 1751376213,
 8632,
 -1,
 1751409816,
 8689,
 -38809,
 1751361607,
 10531,
 -38808,
 1751541410,
 10546,
 -1,
 1751600184,
 10535,
 -1,
 1751223111,
 10529,
 -38805,
 1751146393,
 11009,
 -38804,
 1751802957,
 8662,
 -1,
 1751850883,
 11017,
 1752066172,
 1751082519,
 -1,
 1752131703,
 1752022672,
 -1,
 1752197236,
 1752087686,
 -1,
 -38799,
 1752112080,
 43059,
 -38798,
 1752218582,
 43056,
 -38797,
 1752267653,
 43057,
 -1,
 1752308044,
 43060,
 1752563711,
 1752143883,
 -1,
 -38794,
 1752481094,
 43061,
 -1,
 1752545818,
 43058,
 1752721530,
 1752061595,
 -1,
 -38791,
 1752677990,
 43062,
 -1,
 1752701173,
 43065,
 -38789,
 1752672435,
 43064,
 -1,
 1752884063,
 43063,
 1753087999,
 1752027250,
 -1,
 1753114758,
 1752957747,
 -1,
 1753180293,
 1753071890,
 8599,
 1753284607,
 1753109545,
 -1,
 1753311363,
 1753175530,
 -1,
 -38782,
 1753247474,
 10542,
 -1,
 1753287200,
 10545,
 -38780,
 1753262151,
 10532,
 -1,
 1753468737,
 10536,
 -1,
 1753097743,
 10530,
 -38777,
 1753046937,
 11008,
 -38776,
 1753637965,
 8663,
 -1,
 1753685891,
 11016,
 1753939967,
 1751039936,
 8882,
 -1,
 1753816742,
 8884,
 1754032297,
 1750984074,
 -1,
 1754097830,
 1753961513,
 -1,
 1754163348,
 1754006323,
 -1,
 1754228881,
 1754110078,
 -1,
 -38768,
 1754189944,
 8837,
 -1,
 1754215193,
 8836,
 -38766,
 1754171181,
 8772,
 -38765,
 1754335495,
 8713,
 -1,
 1754426334,
 8777,
 1754622105,
 1754113934,
 -1,
 1754687640,
 1754565434,
 -1,
 -38761,
 1754644865,
 8931,
 -1,
 1754719050,
 8930,
 -1,
 1754651479,
 172,
 1754949788,
 1754588554,
 -1,
 -38757,
 1754863602,
 8877,
 -1,
 1754927064,
 8769,
 1755146398,
 1754900896,
 8938,
 -1,
 1755061926,
 8940,
 1755277473,
 1755104148,
 -1,
 -38752,
 1755192579,
 8813,
 -1,
 1755285319,
 8800,
 -38750,
 1755194086,
 8742,
 -38749,
 1755387495,
 8814,
 -38748,
 1755453347,
 8802,
 -38747,
 1755569064,
 8815,
 -1,
 1755616326,
 9083,
 1755840511,
 1754050462,
 -1,
 -38744,
 1755721368,
 10161,
 -1,
 1755789598,
 10159,
 1755998380,
 1753963816,
 -1,
 -38741,
 1755958366,
 10973,
 -1,
 1756022523,
 8209,
 -38739,
 1755917726,
 8303,
 -38738,
 1756120552,
 160,
 -1,
 1756217002,
 9940,
 1756391622,
 1750868513,
 -1,
 1756457142,
 1756330864,
 -1,
 1756522677,
 1756423058,
 -1,
 -38733,
 1756454542,
 10754,
 -38732,
 1756548546,
 10753,
 -1,
 1756581434,
 10752,
 -1,
 1756458656,
 8720,
 1756850362,
 1756368730,
 8899,
 1756954623,
 1756803525,
 -1,
 -38727,
 1756861619,
 10756,
 -1,
 1756893242,
 10755,
 1757112511,
 1756800910,
 -1,
 1757178046,
 1757055802,
 -1,
 -38723,
 1757101748,
 10758,
 -1,
 1757162090,
 10757,
 -1,
 1757114149,
 8721,
 1757440194,
 1757069765,
 -1,
 -38719,
 1757357801,
 8897,
 -1,
 1757467475,
 8896,
 -38717,
 1757387221,
 11007,
 -38716,
 1757568654,
 10761,
 -38715,
 1757662688,
 8719,
 -1,
 1757696327,
 8898,
 1757898971,
 1756328101,
 -1,
 1757964506,
 1757820100,
 -1,
 1758030030,
 1757930890,
 -1,
 1758095564,
 1757972711,
 -1,
 -38709,
 1758052540,
 9371,
 -1,
 1758073172,
 9363,
 -38707,
 1758058151,
 9364,
 -1,
 1758213580,
 9361,
 1758423251,
 1757980558,
 -1,
 1758488786,
 1758337181,
 -1,
 -38703,
 1758439408,
 9367,
 -1,
 1758506649,
 35,
 -1,
 1758422065,
 9368,
 1758750934,
 1758349383,
 -1,
 -38699,
 1758699960,
 9365,
 -1,
 1758750675,
 9366,
 1758947545,
 1758661932,
 -1,
 -38696,
 1758864074,
 9362,
 -1,
 1758972449,
 9369,
 -1,
 1758857307,
 9370,
 -1,
 1757895029,
 8470,
 1759313919,
 1757807411,
 -1,
 -38691,
 1759215529,
 8302,
 -38690,
 1759280449,
 8239,
 -38689,
 1759320864,
 8892,
 -38688,
 1759422918,
 8358,
 -1,
 1759482205,
 8711,
 1759668800,
 1735202973,
 -1,
 1759734147,
 1759610886,
 -1,
 1759799679,
 1759697483,
 -1,
 1759865161,
 1759726260,
 -1,
 1759930696,
 1759803056,
 -1,
 1759996181,
 1759885563,
 -1,
 1760061716,
 1759953544,
 -1,
 1760127234,
 1760028042,
 -1,
 1760192763,
 1760080709,
 -1,
 1760258298,
 1760103724,
 -1,
 1760323833,
 1760222327,
 13299,
 1760428031,
 1760277640,
 -1,
 1760454896,
 1760355722,
 -1,
 -38673,
 1760397553,
 13301,
 -1,
 1760462867,
 13302,
 1760651507,
 1760405390,
 -1,
 -38670,
 1760609643,
 13305,
 -1,
 1760639614,
 13306,
 1760848118,
 1760577607,
 -1,
 -38667,
 1760793074,
 13303,
 -1,
 1760831490,
 13304,
 -38665,
 1760801080,
 13300,
 -38664,
 1760965174,
 13308,
 -1,
 1761067210,
 13307,
 -1,
 1760271176,
 13291,
 -1,
 1760206072,
 13281,
 1761372417,
 1760150418,
 -1,
 1761437952,
 1761286303,
 -1,
 1761503487,
 1761362553,
 13309,
 -1,
 1761429319,
 13310,
 -1,
 1761439674,
 13292,
 -1,
 1761367635,
 13282,
 -1,
 1761318325,
 13289,
 1761831175,
 1760077710,
 -1,
 1761896709,
 1761789291,
 13285,
 -1,
 1761862422,
 13295,
 1762066431,
 1761819262,
 13286,
 -1,
 1761993494,
 13296,
 1762158861,
 1761757255,
 -1,
 1762224394,
 1762103794,
 13283,
 -1,
 1762190102,
 13293,
 1762394111,
 1762138269,
 -1,
 -38644,
 1762295037,
 13284,
 -1,
 1762333234,
 13294,
 1762552081,
 1762069804,
 -1,
 1762617616,
 1762501182,
 13287,
 -1,
 1762553786,
 13297,
 -1,
 1762545019,
 13290,
 1762814227,
 1762472502,
 13288,
 -1,
 1762779926,
 13298,
 -1,
 1762767160,
 13280,
 -1,
 1760022462,
 13003,
 1763076409,
 1759939506,
 -1,
 1763141926,
 1763042698,
 -1,
 1763207458,
 1763095365,
 -1,
 1763272993,
 1763118380,
 -1,
 1763338528,
 1763236983,
 13164,
 1763442687,
 1763292296,
 -1,
 1763469598,
 1763370378,
 -1,
 -38627,
 1763412209,
 13166,
 -1,
 1763477523,
 13167,
 -38625,
 1763422520,
 13165,
 -1,
 1763585667,
 13168,
 -1,
 1763285832,
 13156,
 -1,
 1763220728,
 13146,
 1763928357,
 1763165074,
 -1,
 -38620,
 1763858003,
 13147,
 -1,
 1763922500,
 13157,
 -1,
 1763874229,
 13154,
 1764190507,
 1763092366,
 -1,
 1764256041,
 1764148587,
 13150,
 -1,
 1764221718,
 13160,
 1764425727,
 1764178558,
 13151,
 -1,
 1764352790,
 13161,
 1764518193,
 1764116551,
 -1,
 1764583726,
 1764463090,
 13148,
 -1,
 1764549398,
 13158,
 1764753407,
 1764497565,
 -1,
 -38608,
 1764654333,
 13149,
 -1,
 1764692530,
 13159,
 1764911413,
 1764429100,
 -1,
 1764976948,
 1764860478,
 13152,
 -1,
 1764913082,
 13162,
 -1,
 1764904315,
 13155,
 1765173559,
 1764831798,
 13153,
 -1,
 1765139222,
 13163,
 -38600,
 1765083491,
 13144,
 -1,
 1765257528,
 13145,
 1765435710,
 1763005132,
 -1,
 1765501245,
 1765357409,
 -1,
 -38596,
 1765415715,
 12997,
 -1,
 1765475120,
 12998,
 -1,
 1765449305,
 12992,
 1765763393,
 1765347238,
 -1,
 -38592,
 1765687929,
 12996,
 -1,
 1765766378,
 12994,
 1765960004,
 1765671731,
 -1,
 -38589,
 1765901368,
 12999,
 -1,
 1765984933,
 12995,
 -38587,
 1765895849,
 13000,
 -38586,
 1766103847,
 13001,
 -38585,
 1766181771,
 13002,
 -1,
 1766211137,
 12993,
 -1,
 1759892713,
 12343,
 1766484319,
 1759825590,
 -1,
 1766549840,
 1766450570,
 -1,
 1766615374,
 1766507410,
 -1,
 -38579,
 1766532894,
 12692,
 -1,
 1766609236,
 12699,
 -38577,
 1766577166,
 12691,
 -1,
 1766745252,
 12694,
 1766943061,
 1766475847,
 -1,
 1767008596,
 1766887922,
 -1,
 -38573,
 1766963594,
 12700,
 -1,
 1767002841,
 12693,
 -1,
 1766963581,
 12697,
 1767270744,
 1766859348,
 -1,
 -38569,
 1767219661,
 12695,
 -1,
 1767302616,
 12703,
 -38567,
 1767235833,
 12698,
 -38566,
 1767420344,
 12689,
 -38565,
 1767477178,
 12690,
 -38564,
 1767535837,
 12688,
 -38563,
 1767589772,
 12701,
 -38562,
 1767671675,
 12702,
 -1,
 1767756143,
 12696,
 1767926131,
 1766426630,
 -1,
 1767991666,
 1767878857,
 -1,
 1768057194,
 1767929626,
 -1,
 1768122725,
 1768007648,
 -1,
 -38556,
 1768072809,
 12281,
 -1,
 1768117851,
 12280,
 1768319336,
 1768083087,
 -1,
 -38553,
 1768250245,
 12282,
 -1,
 1768350270,
 12279,
 -38551,
 1768274038,
 12278,
 -1,
 1768449253,
 12277,
 1768647021,
 1768003343,
 -1,
 -38548,
 1768597097,
 12272,
 -1,
 1768671053,
 12274,
 1768843632,
 1768579737,
 -1,
 -38545,
 1768798873,
 12275,
 -1,
 1768863862,
 12273,
 -38543,
 1768808590,
 12283,
 -1,
 1768956061,
 12276,
 -1,
 1767917872,
 12332,
 1769236854,
 1767865200,
 -1,
 -38539,
 1769177424,
 12289,
 -1,
 1769267351,
 12294,
 -38537,
 1769197542,
 12350,
 -38536,
 1769400315,
 12288,
 -38535,
 1769424444,
 12331,
 -38534,
 1769527551,
 12295,
 -38533,
 1769583794,
 12330,
 -38532,
 1769640419,
 12293,
 -38531,
 1769680499,
 12351,
 -38530,
 1769735703,
 12290,
 -1,
 1769855871,
 12333,
 1770061823,
 1759719543,
 -1,
 1770088834,
 1769955765,
 8801,
 -1,
 1770008081,
 10725,
 -1,
 1770009021,
 10855,
 1770285587,
 1759665448,
 -1,
 1770351059,
 1770235790,
 -1,
 1770416594,
 1770306933,
 -1,
 1770482094,
 1770334580,
 -1,
 1770547618,
 1770399077,
 -1,
 1770613133,
 1770497934,
 -1,
 1770678668,
 1770521395,
 -1,
 -38517,
 1770613216,
 68430,
 -1,
 1770686573,
 68433,
 -1,
 1770612152,
 68436,
 1770940816,
 1770579338,
 -1,
 -38513,
 1770864978,
 68424,
 -1,
 1770938910,
 68437,
 1771137426,
 1770895798,
 68420,
 -1,
 1771086097,
 68423,
 1771268501,
 1771045683,
 -1,
 -38508,
 1771228331,
 68431,
 -1,
 1771278889,
 68416,
 -38506,
 1771215359,
 68422,
 -38505,
 1771418494,
 68425,
 -38504,
 1771488481,
 68421,
 -38503,
 1771560764,
 68435,
 -38502,
 1771580274,
 68434,
 -38501,
 1771647552,
 68432,
 -38500,
 1771746200,
 68429,
 -38499,
 1771776380,
 68428,
 -38498,
 1771840791,
 68427,
 -38497,
 1771909008,
 68426,
 -38496,
 1772011816,
 68418,
 -38495,
 1772056076,
 68419,
 -1,
 1772109276,
 68417,
 1772355583,
 1770476228,
 -1,
 1772382633,
 1772283274,
 -1,
 1772448167,
 1772335941,
 -1,
 -38490,
 1772395768,
 68441,
 -1,
 1772467519,
 68445,
 -38488,
 1772390419,
 68442,
 -1,
 1772590517,
 68444,
 1772775853,
 1772335416,
 68440,
 1772879871,
 1772704809,
 -1,
 -38484,
 1772782430,
 68447,
 -1,
 1772830787,
 68446,
 -1,
 1772695171,
 68443,
 1773142015,
 1770424465,
 -1,
 1773169094,
 1773020517,
 -1,
 1773234613,
 1773119374,
 -1,
 1773300148,
 1773142835,
 -1,
 -38477,
 1773234656,
 68462,
 -1,
 1773308013,
 68464,
 -1,
 1773233592,
 68465,
 1773562296,
 1773200778,
 -1,
 -38473,
 1773486418,
 68456,
 -1,
 1773560350,
 68466,
 1773758906,
 1773517238,
 68452,
 -1,
 1773707537,
 68455,
 -38469,
 1773705727,
 68454,
 -38468,
 1773843326,
 68457,
 -38467,
 1773877983,
 68453,
 -38466,
 1773941312,
 68463,
 -38465,
 1774039960,
 68461,
 -38464,
 1774109616,
 68460,
 -38463,
 1774134551,
 68459,
 -38462,
 1774202768,
 68458,
 -38461,
 1774305576,
 68450,
 -38460,
 1774349836,
 68451,
 -38459,
 1774403036,
 68449,
 -1,
 1774473128,
 68448,
 1774714879,
 1773097668,
 -1,
 1774741965,
 1774642570,
 -1,
 1774807499,
 1774695237,
 -1,
 -38454,
 1774755064,
 68473,
 -1,
 1774826815,
 68477,
 -38452,
 1774749715,
 68474,
 -1,
 1774949813,
 68476,
 1775135185,
 1774694712,
 68472,
 1775239167,
 1775064105,
 -1,
 -38448,
 1775141726,
 68479,
 -1,
 1775190083,
 68478,
 -1,
 1775054467,
 68475,
 -1,
 1770376426,
 9088,
 1775528439,
 1770283487,
 -1,
 1775593960,
 1775482119,
 -1,
 1775659487,
 1775539444,
 8745,
 1775763455,
 1775588393,
 -1,
 1775790555,
 1775678887,
 -1,
 -38439,
 1775746297,
 10819,
 -38438,
 1775798168,
 10820,
 -1,
 1775833146,
 10816,
 1776052702,
 1775756451,
 -1,
 -38435,
 1775963994,
 10823,
 -1,
 1776077110,
 10825,
 -1,
 1776015819,
 10827,
 1776314853,
 1775619727,
 -1,
 1776380388,
 1776223954,
 -1,
 -38430,
 1776329824,
 65531,
 -38429,
 1776401984,
 65530,
 -1,
 1776463966,
 65529,
 -1,
 1776313788,
 9892,
 -38426,
 1776234217,
 8253,
 -38425,
 1776670591,
 10812,
 -1,
 1776708474,
 8890,
 1776943103,
 1775545457,
 8747,
 1777008639,
 1776833577,
 -1,
 1777035763,
 1776924071,
 -1,
 1777101294,
 1776971965,
 -1,
 -38419,
 1777055983,
 10778,
 -1,
 1777120563,
 10780,
 -38417,
 1777015147,
 10776,
 -38416,
 1777253625,
 10779,
 -38415,
 1777280844,
 10775,
 -38414,
 1777357127,
 10777,
 -1,
 1777429413,
 10766,
 1777625590,
 1776943923,
 -1,
 -38411,
 1777574122,
 10767,
 -1,
 1777654357,
 10773,
 -1,
 1777590275,
 9134,
 1777887751,
 1775465672,
 -1,
 1777953283,
 1777833459,
 -1,
 1778018816,
 1777889591,
 -1,
 -38405,
 1777984725,
 8276,
 -38404,
 1778038499,
 191,
 -38403,
 1778108608,
 8487,
 -38402,
 1778159499,
 8766,
 -38401,
 1778224213,
 11800,
 -1,
 1778311746,
 161,
 1778515967,
 1777975758,
 -1,
 -38398,
 1778413448,
 9689,
 -1,
 1778489428,
 9688,
 1778712575,
 1777886177,
 -1,
 -38395,
 1778586936,
 8290,
 -38394,
 1778695744,
 8291,
 -1,
 1778750643,
 8292,
 1778936331,
 1777813575,
 -1,
 1779001866,
 1778891317,
 8734,
 -1,
 1778939371,
 10718,
 -1,
 1778940749,
 8505,
 1779198480,
 1778875248,
 -1,
 1779264015,
 1779124646,
 -1,
 -38386,
 1779223330,
 8710,
 -1,
 1779282352,
 10721,
 -1,
 1779222697,
 10716,
 1779564543,
 1779118866,
 -1,
 -38382,
 1779462483,
 8298,
 -1,
 1779552923,
 8300,
 1779722815,
 1770201684,
 -1,
 1779788349,
 1779640260,
 -1,
 1779853872,
 1779705189,
 -1,
 1779919387,
 1779804046,
 -1,
 1779984922,
 1779827507,
 -1,
 -38375,
 1779919328,
 67662,
 -1,
 1779992685,
 67665,
 -1,
 1779918264,
 67668,
 1780247070,
 1779885450,
 -1,
 -38371,
 1780171090,
 67656,
 -1,
 1780245022,
 67669,
 1780443680,
 1780201910,
 67652,
 -1,
 1780392209,
 67655,
 1780574755,
 1780351795,
 -1,
 -38366,
 1780534443,
 67663,
 -1,
 1780585001,
 67648,
 -38364,
 1780521471,
 67654,
 -38363,
 1780724606,
 67657,
 -38362,
 1780794593,
 67653,
 -38361,
 1780866876,
 67667,
 -38360,
 1780886386,
 67666,
 -38359,
 1780953664,
 67664,
 -38358,
 1781052312,
 67661,
 -38357,
 1781082492,
 67660,
 -38356,
 1781146903,
 67659,
 -38355,
 1781215120,
 67658,
 -38354,
 1781317928,
 67650,
 -38353,
 1781362188,
 67651,
 -1,
 1781415388,
 67649,
 1781623356,
 1779782340,
 -1,
 1781688888,
 1781589386,
 -1,
 1781754421,
 1781642053,
 -1,
 -38348,
 1781701880,
 67673,
 -1,
 1781773631,
 67676,
 1781951031,
 1781700021,
 67675,
 -1,
 1781898540,
 67679,
 -1,
 1781893139,
 67674,
 1782185983,
 1781641528,
 67672,
 1782251519,
 1782076457,
 -1,
 -38341,
 1782154078,
 67678,
 -1,
 1782202435,
 67677,
 -1,
 1781587867,
 67671,
 1782513663,
 1779748640,
 8887,
 -1,
 1782412893,
 8787,
 -1,
 1779679102,
 9976,
 1782672134,
 1759594567,
 -1,
 1782737611,
 1782593377,
 -1,
 1782803142,
 1782645508,
 -1,
 1782868674,
 1782712576,
 -1,
 1782934148,
 1782828687,
 -1,
 1782999676,
 1782887513,
 -1,
 1783065185,
 1782954686,
 -1,
 -38328,
 1783005131,
 65370,
 -38327,
 1783054969,
 65369,
 -38326,
 1783105455,
 65368,
 -38325,
 1783214917,
 65367,
 -38324,
 1783264456,
 65366,
 -38323,
 1783314273,
 65365,
 -38322,
 1783424394,
 65364,
 -38321,
 1783474062,
 65363,
 -38320,
 1783543047,
 65362,
 -38319,
 1783573821,
 65361,
 -38318,
 1783683488,
 65360,
 -38317,
 1783733496,
 65359,
 -38316,
 1783782696,
 65358,
 -38315,
 1783833172,
 65357,
 -38314,
 1783942799,
 65356,
 -38313,
 1783992631,
 65355,
 -38312,
 1784042188,
 65354,
 -38311,
 1784092829,
 65353,
 -38310,
 1784202130,
 65352,
 -38309,
 1784252109,
 65351,
 -38308,
 1784301639,
 65350,
 -38307,
 1784352044,
 65349,
 -38306,
 1784461563,
 65348,
 -38305,
 1784511344,
 65347,
 -38304,
 1784561088,
 65346,
 -1,
 1784611635,
 65345,
 1784872959,
 1783005758,
 -1,
 -38301,
 1784774603,
 65338,
 -38300,
 1784824441,
 65337,
 -38299,
 1784874927,
 65336,
 -38298,
 1784984389,
 65335,
 -38297,
 1785033928,
 65334,
 -38296,
 1785083745,
 65333,
 -38295,
 1785193866,
 65332,
 -38294,
 1785243534,
 65331,
 -38293,
 1785312519,
 65330,
 -38292,
 1785343293,
 65329,
 -38291,
 1785452960,
 65328,
 -38290,
 1785502968,
 65327,
 -38289,
 1785552168,
 65326,
 -38288,
 1785602644,
 65325,
 -38287,
 1785712271,
 65324,
 -38286,
 1785762103,
 65323,
 -38285,
 1785811660,
 65322,
 -38284,
 1785862301,
 65321,
 -38283,
 1785971602,
 65320,
 -38282,
 1786021581,
 65319,
 -38281,
 1786071111,
 65318,
 -38280,
 1786121516,
 65317,
 -38279,
 1786231035,
 65316,
 -38278,
 1786280816,
 65315,
 -38277,
 1786330560,
 65314,
 -1,
 1786381107,
 65313,
 1786604163,
 1782910252,
 -1,
 1786669698,
 1786552436,
 -1,
 -38273,
 1786597213,
 65375,
 -38272,
 1786680121,
 65339,
 -38271,
 1786716575,
 65288,
 -1,
 1786797874,
 65371,
 -1,
 1786604675,
 65308,
 -1,
 1786538683,
 65343,
 1787128468,
 1782888699,
 -1,
 1787194003,
 1787092135,
 -1,
 1787259529,
 1787159946,
 -1,
 -38264,
 1787201777,
 65298,
 -1,
 1787267091,
 65299,
 1787456140,
 1787209614,
 -1,
 -38261,
 1787413867,
 65302,
 -1,
 1787443838,
 65303,
 1787652751,
 1787381831,
 -1,
 -38258,
 1787597298,
 65300,
 -1,
 1787635714,
 65301,
 -38256,
 1787562339,
 65296,
 -38255,
 1787801912,
 65297,
 -38254,
 1787834934,
 65305,
 -1,
 1787936970,
 65304,
 -1,
 1787159020,
 65284,
 1788177051,
 1787081991,
 -1,
 1788242586,
 1788142490,
 -1,
 -38249,
 1788170077,
 65376,
 -38248,
 1788252985,
 65341,
 -38247,
 1788289439,
 65289,
 -1,
 1788370738,
 65373,
 -1,
 1788204561,
 65340,
 1788635811,
 1788115824,
 -1,
 1788701345,
 1788583160,
 -1,
 1788766880,
 1788612524,
 -1,
 -38241,
 1788712451,
 65312,
 -1,
 1788740403,
 65292,
 -1,
 1788676565,
 65306,
 -38238,
 1788627935,
 65342,
 -1,
 1788950508,
 65504,
 1789160103,
 1788598688,
 -1,
 -38235,
 1789105456,
 65505,
 -38234,
 1789179825,
 65291,
 -1,
 1789240973,
 65285,
 1789422251,
 1789068083,
 -1,
 -38231,
 1789352031,
 65290,
 -38230,
 1789432172,
 65287,
 -1,
 1789460848,
 65286,
 1789684398,
 1789372302,
 -1,
 -38227,
 1789621201,
 65295,
 -1,
 1789708752,
 65307,
 1789881009,
 1789607626,
 -1,
 -38224,
 1789827844,
 65282,
 -1,
 1789869133,
 65311,
 1790077620,
 1789812008,
 -1,
 -38221,
 1790009258,
 65283,
 -1,
 1790105847,
 65506,
 1790274231,
 1790029419,
 -1,
 -38218,
 1790230526,
 65310,
 -1,
 1790260554,
 65344,
 1790470842,
 1790184748,
 -1,
 -38215,
 1790380043,
 65281,
 -1,
 1790495019,
 65309,
 -38213,
 1790418094,
 65509,
 -38212,
 1790622872,
 65510,
 -38211,
 1790698680,
 65372,
 -38210,
 1790710842,
 65374,
 -38209,
 1790800538,
 65507,
 -38208,
 1790850043,
 65293,
 -38207,
 1790903831,
 65294,
 -1,
 1791010474,
 65508,
 1791229951,
 1782797353,
 -1,
 -38204,
 1791112592,
 46,
 -38203,
 1791174189,
 10199,
 -1,
 1791254467,
 9608,
 1791453897,
 1782734120,
 -1,
 -38200,
 1791396003,
 9905,
 -1,
 1791481047,
 8289,
 -38198,
 1791383215,
 9179,
 -1,
 1791568333,
 9981,
 1791781598,
 1782684920,
 -1,
 1791847128,
 1791702881,
 -1,
 1791912663,
 1791800583,
 -1,
 1791978197,
 1791841321,
 -1,
 1792043730,
 1791928175,
 -1,
 -38191,
 1791952183,
 8280,
 -1,
 1792042239,
 8283,
 -38189,
 1791982744,
 10018,
 -38188,
 1792206904,
 10021,
 -1,
 1792225043,
 10019,
 -38186,
 1791914455,
 8732,
 -1,
 1792348370,
 8197,
 -1,
 1791857794,
 9970,
 1792671743,
 1791800583,
 -1,
 1792699100,
 1792577847,
 -1,
 -38181,
 1792624552,
 10972,
 -1,
 1792681103,
 11792,
 -38179,
 1792650848,
 8873,
 -1,
 1792811138,
 8704,
 1793026792,
 1791695005,
 -1,
 1793092322,
 1792940427,
 -1,
 -38175,
 1793000759,
 8281,
 -1,
 1793090815,
 11821,
 1793288933,
 1793037550,
 -1,
 -38172,
 1793255419,
 8199,
 -1,
 1793285053,
 8210,
 -38170,
 1793238478,
 9673,
 -38169,
 1793403953,
 9789,
 -1,
 1793479890,
 10765,
 1793682161,
 1792986767,
 -1,
 1793747693,
 1793629432,
 -1,
 1793813228,
 1793701262,
 9880,
 -1,
 1793761136,
 8277,
 -1,
 1793722547,
 10086,
 1794009840,
 1793655603,
 -1,
 -38161,
 1793947816,
 9189,
 -1,
 1794031466,
 9971,
 -1,
 1793958766,
 9884,
 1794271993,
 1793635591,
 -1,
 1794337525,
 1794219256,
 -1,
 -38156,
 1794279668,
 8994,
 -1,
 1794360017,
 10156,
 1794534136,
 1794287325,
 -1,
 -38153,
 1794467627,
 8260,
 -1,
 1794550242,
 8543,
 -1,
 1794485591,
 8355,
 1794796289,
 1794179891,
 -1,
 1794861823,
 1794758449,
 -1,
 1794927358,
 1794790890,
 -1,
 -38147,
 1794841123,
 10540,
 -1,
 1794952051,
 10543,
 -1,
 1794877996,
 9950,
 -38144,
 1794827900,
 9771,
 -1,
 1795097225,
 8507,
 1795358719,
 1794706732,
 -1,
 1795386117,
 1795236436,
 -1,
 -38140,
 1795304944,
 170,
 -1,
 1795368032,
 9792,
 -1,
 1795329529,
 9972,
 1795648420,
 1782593377,
 -1,
 1795713893,
 1795611040,
 -1,
 1795779385,
 1795677696,
 -1,
 1795844886,
 1795687219,
 -1,
 1795910421,
 1795801362,
 8593,
 1796014079,
 1795839017,
 -1,
 1796041490,
 1795929511,
 -1,
 1796107024,
 1795961090,
 -1,
 -38129,
 1796057527,
 8625,
 -1,
 1796111306,
 8624,
 -38127,
 1796019105,
 10505,
 -1,
 1796238245,
 8670,
 -38125,
 1795959603,
 10514,
 -38124,
 1796367634,
 8645,
 -1,
 1796420278,
 8613,
 -1,
 1795850279,
 11797,
 1796696868,
 1795784205,
 -1,
 1796762399,
 1796626011,
 -1,
 1796827934,
 1796690985,
 -1,
 1796893468,
 1796784617,
 -1,
 -38117,
 1796842825,
 10595,
 -1,
 1796923471,
 10606,
 -38115,
 1796811571,
 10584,
 -1,
 1797010102,
 10592,
 -1,
 1796767651,
 8639,
 1797324799,
 1796712041,
 -1,
 1797352227,
 1797215273,
 -1,
 -38110,
 1797270323,
 10580,
 -1,
 1797337782,
 10588,
 -1,
 1797291939,
 8638,
 1797614382,
 1796659174,
 -1,
 1797679916,
 1797545638,
 8679,
 1797783551,
 1797608489,
 -1,
 1797810987,
 1797696236,
 8683,
 1797914623,
 1797735711,
 -1,
 -38102,
 1797793063,
 8685,
 -1,
 1797877998,
 8684,
 -1,
 1797730998,
 8682,
 1798176767,
 1797612621,
 8686,
 -1,
 1798096476,
 8687,
 1798269747,
 1797580170,
 -1,
 1798335282,
 1798211825,
 -1,
 -38095,
 1798294248,
 10569,
 -1,
 1798355578,
 8607,
 -1,
 1798273885,
 10506,
 1798597430,
 1798224123,
 -1,
 -38091,
 1798545891,
 8657,
 -1,
 1798621991,
 8673,
 -38089,
 1798515449,
 10224,
 -38088,
 1798708788,
 8648,
 -1,
 1798774659,
 11014,
 1798990671,
 1795707945,
 -1,
 1799056192,
 1798915878,
 -1,
 1799121725,
 1798987430,
 8597,
 -1,
 1799073863,
 8616,
 -38082,
 1799053209,
 8691,
 -38081,
 1799185485,
 8661,
 -1,
 1799233411,
 11021,
 1799449415,
 1799003995,
 -1,
 1799514948,
 1799402992,
 -1,
 -38077,
 1799457383,
 10575,
 -1,
 1799514377,
 10572,
 1799749631,
 1799454765,
 -1,
 -38074,
 1799653991,
 10573,
 -1,
 1799710985,
 10577,
 1799908171,
 1799380646,
 -1,
 1799973706,
 1799815989,
 8963,
 -1,
 1799889689,
 8996,
 -1,
 1799897542,
 10685,
 1800170317,
 1799862396,
 8869,
 -1,
 1800101285,
 10207,
 -38066,
 1800102932,
 8944,
 -1,
 1800221251,
 10622,
 1800432482,
 1798913910,
 -1,
 1800498007,
 1800380679,
 -1,
 -38062,
 1800417386,
 9721,
 -38061,
 1800525871,
 10066,
 -38060,
 1800546329,
 9693,
 -38059,
 1800603133,
 10000,
 -38058,
 1800698612,
 9137,
 -1,
 1800734322,
 10064,
 1800956764,
 1800415981,
 -1,
 -38055,
 1800876138,
 9720,
 -38054,
 1800939545,
 9692,
 -38053,
 1801036391,
 9136,
 -1,
 1801097796,
 10196,
 1801284448,
 1800912458,
 -1,
 -38050,
 1801225712,
 9690,
 -38049,
 1801266023,
 9696,
 -1,
 1801347011,
 9600,
 -38047,
 1801215436,
 9620,
 -1,
 1801469935,
 9985,
 1801715711,
 1800363584,
 -1,
 -38044,
 1801625317,
 9710,
 -1,
 1801684231,
 9709,
 1801874318,
 1795638908,
 -1,
 1801939853,
 1801790821,
 -1,
 1802005357,
 1801889678,
 -1,
 1802070891,
 1801913139,
 -1,
 -38038,
 1801998315,
 66450,
 -1,
 1802078214,
 66453,
 -38036,
 1802000020,
 66461,
 -1,
 1802200504,
 66444,
 1802398577,
 1801971082,
 -1,
 -38033,
 1802345720,
 66458,
 -38032,
 1802374007,
 66456,
 -1,
 1802474986,
 66441,
 1802660724,
 1802338251,
 -1,
 -38029,
 1802581857,
 66449,
 -1,
 1802649916,
 66439,
 1802857335,
 1802604855,
 -1,
 -38026,
 1802811827,
 66435,
 -1,
 1802854903,
 66443,
 1803053945,
 1802811806,
 66437,
 -1,
 1802985954,
 66440,
 1803185020,
 1802995405,
 -1,
 -38021,
 1803148195,
 66457,
 -1,
 1803168812,
 66434,
 1803381631,
 1803139323,
 -1,
 -38018,
 1803323732,
 66447,
 -1,
 1803367829,
 66436,
 1803578242,
 1803289395,
 -1,
 -38015,
 1803527071,
 66432,
 -1,
 1803601318,
 66451,
 -38013,
 1803539846,
 66442,
 -38012,
 1803716849,
 66438,
 -38011,
 1803761505,
 66460,
 -38010,
 1803861009,
 66455,
 -38009,
 1803925040,
 66454,
 -38008,
 1803956751,
 66452,
 -38007,
 1804055448,
 66448,
 -38006,
 1804085628,
 66446,
 -38005,
 1804147106,
 66445,
 -38004,
 1804212381,
 66459,
 -1,
 1804287447,
 66433,
 -1,
 1801871728,
 66463,
 1804561311,
 1801805096,
 -1,
 1804626843,
 1804474525,
 -1,
 1804692378,
 1804543640,
 8746,
 1804795903,
 1804620841,
 -1,
 1804823446,
 1804711335,
 -1,
 -37996,
 1804778745,
 10818,
 -37995,
 1804796261,
 10817,
 -1,
 1804868315,
 10821,
 1805085593,
 1804788899,
 -1,
 -37992,
 1805013319,
 10822,
 -1,
 1805086036,
 10824,
 -1,
 1804993341,
 10826,
 -1,
 1804630494,
 9842,
 1805413278,
 1804581115,
 -1,
 -37987,
 1805378934,
 9100,
 -1,
 1805404225,
 8255,
 -1,
 1805358605,
 9903,
 1805675427,
 1804500590,
 9730,
 1805778943,
 1805603881,
 -1,
 -37982,
 1805659390,
 9748,
 -1,
 1805734886,
 9969,
 -1,
 1805624263,
 9797,
 1806003278,
 1795601221,
 -1,
 1806068788,
 1805960082,
 -1,
 1806134321,
 1805987899,
 -1,
 1806199856,
 1806062633,
 -1,
 1806265287,
 1806149518,
 -1,
 1806330810,
 1806223404,
 9633,
 1806434303,
 1806259241,
 -1,
 1806461881,
 1806349735,
 -1,
 1806527409,
 1806421647,
 -1,
 1806592944,
 1806470699,
 -1,
 -37969,
 1806538520,
 9714,
 -1,
 1806602621,
 9713,
 -1,
 1806547000,
 10212,
 1806855092,
 1806477280,
 -1,
 -37965,
 1806800664,
 9715,
 -1,
 1806864765,
 9712,
 1807051703,
 1806808327,
 -1,
 -37962,
 1806986550,
 9634,
 -1,
 1807071649,
 10213,
 -37960,
 1806965954,
 9707,
 -1,
 1807178377,
 9093,
 -1,
 1806408422,
 9635,
 1807444929,
 1806246484,
 -1,
 1807510464,
 1807384028,
 -1,
 1807575999,
 1807460238,
 -1,
 -37954,
 1807523172,
 11090,
 -1,
 1807599660,
 9643,
 -1,
 1807497328,
 11051,
 -1,
 1807453620,
 9786,
 -37950,
 1807388699,
 9788,
 -37949,
 1807850852,
 9734,
 -37948,
 1807924112,
 9828,
 -37947,
 1807964504,
 9750,
 -37946,
 1808029844,
 65094,
 -1,
 1808081206,
 9988,
 1808296929,
 1806203760,
 -1,
 1808362452,
 1808251977,
 9675,
 1808465919,
 1808287007,
 -1,
 1808493517,
 1808377824,
 -1,
 -37940,
 1808439064,
 9719,
 -1,
 1808503165,
 9716,
 1808690128,
 1808437418,
 -1,
 -37937,
 1808635672,
 9718,
 -1,
 1808699773,
 9717,
 1808886739,
 1808631805,
 -1,
 -37934,
 1808815641,
 10732,
 -1,
 1808916707,
 9862,
 -1,
 1808820099,
 9863,
 1809148892,
 1808282701,
 -1,
 1809214424,
 1809092919,
 -1,
 -37929,
 1809170453,
 9816,
 -1,
 1809205160,
 9812,
 -37927,
 1809141327,
 9814,
 -37926,
 1809343737,
 9813,
 -37925,
 1809437718,
 9817,
 -1,
 1809485622,
 9815,
 1809673184,
 1809095066,
 10209,
 1809776639,
 1809597727,
 -1,
 -37921,
 1809658167,
 10211,
 -1,
 1809749898,
 10210,
 -1,
 1809591465,
 9831,
 1810000880,
 1808251131,
 -1,
 1810066408,
 1809925907,
 9671,
 1810169855,
 1809994793,
 -1,
 -37915,
 1810092936,
 10192,
 -37914,
 1810124655,
 9826,
 -37913,
 1810179619,
 9931,
 -1,
 1810282252,
 9672,
 1810459629,
 1810012881,
 -1,
 1810525164,
 1810398602,
 -1,
 -37909,
 1810444394,
 9661,
 -1,
 1810554353,
 9663,
 -1,
 1810451841,
 9759,
 1810825215,
 1810418589,
 -1,
 -37905,
 1810708610,
 9920,
 -1,
 1810803485,
 9921,
 1810983930,
 1809954055,
 -1,
 1811049465,
 1810932286,
 -1,
 1811115000,
 1810988426,
 -1,
 1811180534,
 1811077536,
 -1,
 -37899,
 1811130042,
 9659,
 -1,
 1811205647,
 11092,
 -37897,
 1811099754,
 9655,
 -1,
 1811340785,
 9657,
 -1,
 1811041665,
 9758,
 -1,
 1811000412,
 9645,
 1811639300,
 1810943631,
 -1,
 1811704835,
 1811604030,
 -1,
 1811770368,
 1811643786,
 -1,
 -37890,
 1811689578,
 9665,
 -37889,
 1811799537,
 9667,
 -1,
 1811862973,
 9669,
 1812070399,
 1811698729,
 -1,
 -37886,
 1811997600,
 9756,
 -1,
 1812031339,
 9945,
 -1,
 1811629663,
 11036,
 1812294667,
 1811579057,
 -1,
 1812360201,
 1812244366,
 -1,
 -37881,
 1812307300,
 11088,
 -37880,
 1812383788,
 9723,
 -1,
 1812413505,
 9725,
 -37878,
 1812281456,
 11048,
 -1,
 1812532205,
 11046,
 1812753426,
 1812219975,
 -1,
 1812818960,
 1812713103,
 -1,
 1812884495,
 1812750836,
 9872,
 -1,
 1812842334,
 9983,
 -1,
 1812799288,
 10048,
 -37871,
 1812728658,
 9785,
 -1,
 1813037753,
 10023,
 1813212184,
 1812708236,
 -1,
 1813277719,
 1813119666,
 -1,
 -37867,
 1813210633,
 9647,
 -37866,
 1813256904,
 11055,
 -1,
 1813319874,
 11006,
 -1,
 1813199345,
 11038,
 1813605406,
 1813147796,
 -1,
 1813670941,
 1813544330,
 -1,
 1813736476,
 1813590122,
 9651,
 -1,
 1813692276,
 9708,
 -1,
 1813700081,
 9653,
 -1,
 1813597569,
 9757,
 1813998628,
 1813570954,
 -1,
 1814064162,
 1813951751,
 -1,
 -37855,
 1814005135,
 10177,
 -1,
 1814040475,
 9186,
 -37853,
 1814001369,
 9943,
 -1,
 1814180089,
 9743,
 1814391851,
 1813955474,
 -1,
 1814457384,
 1814338808,
 -1,
 -37849,
 1814388587,
 10710,
 -1,
 1814453771,
 11053,
 1814691839,
 1814367532,
 -1,
 -37846,
 1814566110,
 11041,
 -1,
 1814638167,
 9825,
 1814850606,
 1814354336,
 -1,
 -37843,
 1814810127,
 11040,
 -1,
 1814881261,
 9649,
 -37841,
 1814815113,
 10001,
 -1,
 1814992980,
 9702,
 -1,
 1806153576,
 10163,
 1815281663,
 1806069669,
 -1,
 -37837,
 1815158425,
 9855,
 -1,
 1815233379,
 9784,
 1815440451,
 1805976371,
 -1,
 1815505985,
 1815377096,
 -1,
 1815571516,
 1815454368,
 -1,
 1815637050,
 1815531151,
 -1,
 -37831,
 1815571131,
 65103,
 -1,
 1815627684,
 8967,
 -37829,
 1815586575,
 65099,
 -1,
 1815763901,
 12336,
 1816002559,
 1815516547,
 -1,
 1816030272,
 1815898786,
 -1,
 -37825,
 1815979625,
 10547,
 -1,
 1816024667,
 11071,
 -1,
 1815960509,
 12316,
 -37822,
 1815451871,
 8986,
 -1,
 1816251615,
 9888,
 1816423496,
 1815387384,
 -1,
 1816489031,
 1816381675,
 -1,
 -37818,
 1816413568,
 11825,
 -1,
 1816461358,
 8288,
 -1,
 1816399033,
 8361,
 1816751179,
 1816376583,
 -1,
 -37814,
 1816716144,
 9997,
 -1,
 1816740503,
 8768,
 1816985599,
 1816661292,
 -1,
 -37811,
 1816871469,
 9840,
 -1,
 1816942326,
 10172,
 1817144523,
 1805931212,
 -1,
 1817210055,
 1817051955,
 -1,
 1817275588,
 1817159423,
 -1,
 1817341065,
 1817182968,
 -1,
 1817406600,
 1817301653,
 -1,
 1817472091,
 1817337128,
 -1,
 1817537623,
 1817423507,
 43412,
 1817640959,
 1817475797,
 43402,
 -1,
 1817530717,
 43403,
 1817734233,
 1817455652,
 43418,
 -1,
 1817700025,
 43416,
 1817903103,
 1817641779,
 43428,
 -1,
 1817831097,
 43423,
 1817996384,
 1817437578,
 -1,
 1818061918,
 1817928162,
 43419,
 -1,
 1818001971,
 43420,
 1818230783,
 1817969459,
 43424,
 -1,
 1818158777,
 43425,
 1818324069,
 1817950459,
 -1,
 1818389603,
 1818265616,
 43421,
 -1,
 1818329651,
 43422,
 1818558463,
 1818297139,
 43426,
 -1,
 1818460723,
 43427,
 1818651753,
 1818252972,
 43441,
 1818755071,
 1818599271,
 -1,
 -37784,
 1818654296,
 43439,
 -1,
 1818703563,
 43440,
 1818913901,
 1818578296,
 43429,
 1819017215,
 1818842153,
 -1,
 -37780,
 1818893682,
 43430,
 -1,
 1818998619,
 43401,
 1819176049,
 1818877903,
 43407,
 1819279359,
 1819104297,
 -1,
 -37776,
 1819156842,
 43408,
 -1,
 1819221362,
 43409,
 1819438196,
 1819089053,
 43398,
 -37773,
 1819351197,
 43399,
 -1,
 1819464840,
 43397,
 1819634806,
 1819363753,
 43435,
 -1,
 1819595724,
 43436,
 1819765880,
 1819595254,
 43415,
 -1,
 1819705907,
 43417,
 1819896954,
 1819717267,
 43410,
 -1,
 1819862713,
 43411,
 1820028028,
 1819835472,
 43413,
 -1,
 1819993785,
 43414,
 1820159102,
 1819988481,
 43431,
 -1,
 1820124857,
 43432,
 1820290176,
 1820066611,
 43396,
 -1,
 1820203165,
 43405,
 -37759,
 1820208164,
 43434,
 -37758,
 1820362986,
 43438,
 -37757,
 1820407649,
 43400,
 -37756,
 1820499192,
 43406,
 -37755,
 1820528550,
 43433,
 -37754,
 1820590846,
 43437,
 -37753,
 1820703155,
 43442,
 -1,
 1820724524,
 43404,
 -1,
 1817343608,
 43457,
 1821011102,
 1817267576,
 -1,
 1821076635,
 1820931885,
 -1,
 1821142160,
 1821036175,
 -1,
 1821207695,
 1821063009,
 -1,
 -37746,
 1821116612,
 43465,
 -1,
 1821201748,
 43461,
 -1,
 1821158201,
 43464,
 1821469844,
 1821049651,
 -1,
 1821535379,
 1821396051,
 43466,
 -1,
 1821492288,
 43467,
 -1,
 1821496643,
 43459,
 1821731991,
 1821432224,
 -1,
 -37738,
 1821658591,
 43468,
 -1,
 1821756539,
 43463,
 -37736,
 1821664434,
 43462,
 -37735,
 1821841367,
 43486,
 -37734,
 1821917306,
 43460,
 -1,
 1821969105,
 43487,
 1822228479,
 1820990246,
 -1,
 -37731,
 1822131279,
 43471,
 -1,
 1822181481,
 43456,
 1822387372,
 1820975473,
 -1,
 1822452898,
 1822352778,
 -1,
 -37727,
 1822394609,
 43474,
 -1,
 1822459923,
 43475,
 1822649509,
 1822402446,
 -1,
 -37724,
 1822606699,
 43478,
 -1,
 1822636670,
 43479,
 1822846120,
 1822574663,
 -1,
 -37721,
 1822790130,
 43476,
 -1,
 1822828546,
 43477,
 -37719,
 1822755171,
 43472,
 -37718,
 1822994744,
 43473,
 -37717,
 1823027766,
 43481,
 -1,
 1823129802,
 43480,
 1823304888,
 1822329909,
 -1,
 1823370418,
 1823270282,
 -1,
 1823435953,
 1823277875,
 -1,
 -37712,
 1823349750,
 43444,
 -1,
 1823460887,
 43450,
 -1,
 1823397561,
 43445,
 1823698100,
 1823298614,
 43446,
 -1,
 1823663448,
 43447,
 1823829174,
 1823659756,
 43448,
 -1,
 1823789743,
 43449,
 -37705,
 1823789281,
 43452,
 -1,
 1823910555,
 43451,
 1824091326,
 1823220997,
 -1,
 1824156859,
 1824010752,
 43393,
 -1,
 1824102320,
 43443,
 -37700,
 1824077966,
 43395,
 -37699,
 1824241451,
 43392,
 -1,
 1824263211,
 43394,
 1824484546,
 1824032463,
 -1,
 -37696,
 1824401702,
 43454,
 -37695,
 1824507786,
 43453,
 -1,
 1824580844,
 43455,
 -37693,
 1824431499,
 43469,
 -1,
 1824671853,
 43458,
 1824915455,
 1817207165,
 -1,
 -37690,
 1824812184,
 12292,
 -1,
 1824865730,
 9979,
 1825074378,
 1817130849,
 -1,
 -37687,
 1825017285,
 9795,
 -1,
 1825053466,
 9909,
 -1,
 1824997329,
 10781,
 1825336554,
 1817067210,
 -1,
 1825402083,
 1825243955,
 -1,
 1825467617,
 1825343525,
 -1,
 1825533150,
 1825404259,
 -1,
 1825598683,
 1825482720,
 -1,
 1825664216,
 1825527387,
 9624,
 1825767423,
 1825575357,
 -1,
 1825795285,
 1825662272,
 -1,
 -37676,
 1825744489,
 9628,
 -1,
 1825789531,
 9627,
 1826029567,
 1825738922,
 -1,
 -37673,
 1825941097,
 9626,
 -1,
 1825986773,
 9625,
 1826226175,
 1825613417,
 9629,
 1826291711,
 1826110513,
 9630,
 -1,
 1826204491,
 9631,
 1826422783,
 1825542314,
 -1,
 -37667,
 1826334313,
 9623,
 -1,
 1826379355,
 9622,
 1826619391,
 1825474673,
 -1,
 -37664,
 1826525205,
 8279,
 -1,
 1826591385,
 10764,
 -37662,
 1825421581,
 10774,
 -1,
 1826731658,
 9833,
 1826909416,
 1825312490,
 -1,
 1826974951,
 1826837545,
 -1,
 -37658,
 1826907391,
 63,
 -1,
 1827004994,
 8264,
 -1,
 1826938635,
 8799,
 -37655,
 1826855684,
 34,
 -1,
 1827197282,
 9915,
 1827368197,
 1825275851,
 -1,
 1827433727,
 1827319519,
 -1,
 1827499251,
 1827383182,
 -1,
 1827564786,
 1827438004,
 -1,
 1827630321,
 1827527072,
 -1,
 -37648,
 1827560630,
 10785,
 -1,
 1827622941,
 10784,
 -1,
 1827572217,
 10783,
 -1,
 1827502358,
 10625,
 1827958009,
 1827452167,
 -1,
 1828023543,
 1827922842,
 -1,
 -37642,
 1827931363,
 10632,
 -1,
 1828040357,
 10634,
 -37640,
 1827961282,
 10814,
 -1,
 1828148374,
 10853,
 1828351228,
 1827875565,
 -1,
 -37637,
 1828259043,
 10631,
 -1,
 1828368037,
 10633,
 -37635,
 1828308038,
 10626,
 -37634,
 1828455308,
 10852,
 -1,
 1828550611,
 8959,
 1828782079,
 1827356031,
 -1,
 1828809987,
 1828657946,
 -1,
 -37630,
 1828734388,
 8204,
 -1,
 1828799976,
 65279,
 -37628,
 1828775931,
 8203,
 -1,
 1828913198,
 8205,
 1829175295,
 1827276719,
 -1,
 -37625,
 1829054185,
 8891,
 -1,
 1829143418,
 8999]
_charnames_32 = [
19793,
11930,
27880,
26833,
24411,
26456,
14011,
13811,
9736,
25505,
13995,
26421,
3790,
21089,
27331,
19716,
24746,
24750,
24720,
24724,
24738,
24742,
24729,
24733,
24758,
24754,
4033,
19747,
10007,
11882,
21793,
27877,
3789,
8552,
8979,
8903,
8854,
8603,
9011,
8889,
8872,
8725,
9007,
8933,
8798,
8989,
8836,
8493,
8969,
9003,
8776,
8757,
8693,
8649,
8959,
8947,
8999,
8819,
8917,
9640,
25869,
25438,
4958,
10100,
21795,
7965,
8373,
8284,
8206,
7908,
8445,
8358,
8264,
8174,
8452,
8342,
8139,
8413,
8240,
7848,
8400,
8438,
8103,
8069,
7780,
8020,
8387,
8426,
8459,
8324,
8304,
9689,
24037,
25491,
17793,
]

_charnames_160 = [
26797,
27135,
5207,
26474,
2535,
15318,
15581,
19753,
24832,
3985,
27395,
9862,
26776,
19720,
25896,
6527,
24709,
26438,
19316,
19317,
14004,
7772,
26467,
7770,
5209,
19330,
6524,
25630,
24077,
24079,
24084,
27131,
8589,
8590,
8555,
8583,
8570,
8580,
8591,
8906,
8635,
8637,
8606,
8624,
8745,
8747,
8738,
8733,
8643,
8849,
8543,
8545,
8516,
8524,
8513,
7346,
8535,
8688,
8690,
8680,
8653,
8834,
8720,
8101,
8006,
8007,
7968,
8000,
7983,
7995,
8008,
8287,
7942,
7944,
7911,
7929,
8193,
8195,
8185,
8180,
7960,
8255,
7897,
7899,
7871,
7879,
7868,
24845,
7892,
8061,
8063,
8051,
8024,
8340,
7838,
8330,
8586,
8003,
8572,
7985,
8585,
8002,
8913,
8295,
8908,
8290,
8912,
8294,
8909,
8291,
8863,
8212,
8859,
8221,
8625,
7930,
8636,
7943,
8622,
7927,
8632,
7938,
8617,
7922,
8892,
8361,
8899,
8369,
8898,
8368,
8893,
8362,
8881,
8273,
8884,
8276,
8735,
8182,
8742,
8190,
8746,
8194,
8741,
8189,
8731,
8234,
9017,
8475,
9010,
8456,
8942,
8351,
8357,
8817,
8161,
8806,
8144,
8807,
8145,
8813,
8152,
8809,
8156,
8852,
8260,
8844,
8246,
8845,
8247,
8261,
8648,
7964,
8530,
7884,
8544,
7898,
8512,
7867,
9016,
8473,
8792,
8125,
8786,
8118,
8787,
8119,
8769,
8081,
8763,
8075,
8764,
8076,
8760,
8072,
8698,
7816,
8699,
7817,
8705,
7825,
8675,
8046,
8683,
8057,
8689,
8062,
8685,
8055,
8664,
8035,
8686,
8059,
8956,
8436,
8833,
8339,
8825,
8932,
8323,
8922,
8309,
8929,
8314,
8162,
8379,
8987,
8984,
8378,
8718,
7834,
8547,
8911,
8293,
8601,
8869,
8867,
8214,
7809,
8795,
8774,
8548,
9013,
8449,
8897,
8902,
8282,
8756,
8740,
8945,
8355,
8155,
8173,
8713,
8841,
8249,
8534,
8496,
7851,
8551,
7907,
8975,
8408,
9081,
8717,
7833,
8647,
9067,
7827,
8708,
7830,
8706,
8667,
8038,
8692,
8965,
8826,
8331,
8926,
8317,
8638,
8641,
7953,
7951,
9084,
8719,
7835,
9075,
9082,
9087,
9086,
9079,
9068,
8871,
8858,
8229,
8818,
8810,
8171,
8853,
8850,
8263,
8562,
7975,
8739,
8186,
8523,
7878,
8682,
8053,
8656,
8027,
8659,
8030,
8658,
8029,
8657,
8028,
7808,
8571,
7984,
8567,
7980,
8593,
8010,
8895,
8364,
8894,
8363,
8943,
8352,
8537,
7894,
8538,
7895,
8640,
7950,
8457,
8870,
8857,
8225,
8900,
8370,
8886,
8958,
8851,
8259,
8581,
7996,
8594,
8011,
8536,
7893,
8569,
7982,
8587,
8004,
8623,
7928,
8633,
7940,
8732,
8178,
8743,
8191,
8511,
7866,
8542,
7896,
8784,
8111,
8791,
8124,
8663,
8034,
8687,
8060,
8762,
8074,
8696,
7814,
8835,
8341,
8883,
8275,
8839,
8209,
8549,
7905,
8931,
8322,
8566,
7979,
8615,
7920,
8514,
7869,
8526,
7881,
8507,
7862,
8508,
7863,
8830,
8336,
8142,
8244,
7813,
8231,
8239,
8444,
8584,
8910,
8292,
8816,
8704,
8083,
8316,
8901,
8371,
8985,
8691,
8712,
8631,
7936,
9009,
8458,
8772,
8441,
8789,
8121,
8829,
8334,
7791,
8014,
7792,
8383,
7901,
8289,
8215,
8216,
8135,
8095,
8098,
7903,
8128,
8131,
8300,
8232,
8367,
8099,
9042,
8372,
8138,
7788,
8278,
8281,
8187,
8203,
9040,
8151,
8154,
8157,
8172,
7797,
7798,
8420,
8251,
8256,
9055,
8386,
9030,
8299,
8412,
7783,
7786,
7787,
8113,
8120,
8115,
8134,
9022,
9041,
8086,
7954,
8233,
8100,
7958,
7804,
7826,
8064,
8065,
8395,
7803,
7802,
7801,
9049,
8318,
8312,
7945,
7949,
9076,
9085,
9074,
9063,
9072,
9044,
8298,
9043,
9059,
8455,
7806,
9038,
8440,
9077,
9066,
8227,
8236,
8228,
7843,
7845,
7846,
8451,
8170,
8168,
9071,
9073,
7789,
7790,
6618,
6619,
6613,
6586,
6538,
6539,
6552,
6622,
6620,
6791,
6761,
6788,
6797,
6717,
6713,
6703,
6779,
6716,
6704,
6714,
6774,
6759,
6675,
3400,
6786,
6751,
6798,
6778,
6694,
6696,
6698,
6700,
6789,
6770,
6670,
6671,
6773,
6758,
6792,
6750,
15582,
24395,
25644,
25381,
19674,
24293,
6718,
6673,
6574,
6594,
6559,
6621,
6589,
6731,
6768,
6743,
6689,
6725,
6782,
6783,
6785,
6776,
6762,
6687,
6695,
6681,
6693,
6692,
6749,
6747,
6748,
6690,
6711,
6795,
6735,
6794,
6734,
6630,
6799,
6680,
3668,
3678,
3485,
3728,
3696,
3764,
3744,
3590,
3621,
3767,
3648,
3587,
3479,
3759,
3569,
3585,
3481,
3738,
3732,
3474,
3651,
3475,
3669,
3679,
3548,
3643,
3539,
3766,
3542,
3753,
3596,
3776,
3705,
3777,
3653,
3592,
3622,
3647,
3476,
3487,
3762,
3758,
3748,
3741,
3480,
3486,
3746,
3739,
3731,
3704,
3559,
3583,
3730,
3720,
3555,
3721,
3556,
3640,
3740,
3724,
3726,
3774,
3760,
3582,
3670,
3680,
3662,
3663,
3664,
3661,
3749,
3716,
3568,
3538,
3785,
3768,
3694,
3546,
3752,
3674,
3633,
3543,
3783,
3773,
3532,
3634,
3631,
3641,
3591,
3690,
3576,
3771,
3581,
3580,
3578,
3579,
3571,
3584,
3577,
3491,
3503,
3501,
3513,
3510,
3505,
3520,
3517,
3515,
3495,
3511,
3509,
3508,
21493,
21306,
21437,
21220,
21750,
21680,
21477,
21287,
-1,
-1,
21739,
21312,
21314,
21313,
21749,
-1,
-1,
-1,
-1,
-1,
21705,
21688,
21434,
21589,
21404,
21391,
21455,
-1,
21363,
-1,
21470,
21350,
21255,
21407,
21497,
21494,
21495,
21393,
21487,
21366,
21483,
21438,
21492,
21491,
21490,
21489,
21488,
21352,
21475,
21485,
-1,
21479,
21484,
21458,
21476,
21496,
21474,
21325,
21446,
21466,
21217,
21184,
21172,
21273,
21228,
21187,
21310,
21307,
21300,
21173,
21301,
21144,
21293,
21249,
21297,
21305,
21304,
21303,
21302,
21130,
21285,
21288,
21308,
21281,
21294,
21222,
21286,
21309,
21284,
21101,
21252,
21225,
21141,
21246,
21129,
21503,
21752,
21700,
21730,
21732,
21731,
21715,
21714,
21726,
21676,
21221,
21671,
21280,
21675,
21299,
21674,
21296,
21672,
21279,
3925,
3833,
3959,
3867,
3939,
3847,
3952,
3860,
3955,
3863,
3924,
3832,
3920,
3828,
21725,
21736,
21678,
21673,
21502,
21679,
21737,
21480,
21282,
21498,
21481,
21278,
21735,
21500,
21504,
21501,
4327,
4315,
4363,
4435,
4443,
4358,
4413,
4392,
4492,
4480,
4484,
4397,
4312,
4331,
4340,
4362,
4417,
4416,
4490,
4428,
4367,
4325,
4370,
4377,
4314,
4338,
4305,
4279,
4288,
4273,
4468,
4474,
4286,
4284,
4399,
4436,
4290,
4445,
4398,
4453,
4344,
4343,
4450,
4383,
4349,
4272,
4390,
4387,
4188,
4187,
4262,
4199,
4138,
4096,
4141,
4148,
4085,
4109,
4076,
4050,
4059,
4044,
4246,
4240,
4057,
4055,
4170,
4207,
4061,
4216,
4169,
4224,
4115,
4114,
4221,
4154,
4120,
4043,
4161,
4158,
4098,
4086,
4134,
4206,
4214,
4129,
4184,
4163,
4264,
4252,
4256,
4168,
4083,
4102,
4111,
4133,
4469,
4247,
4388,
4159,
4320,
4091,
4481,
4253,
4319,
4090,
4412,
4183,
4322,
4093,
4311,
4082,
4478,
4244,
4493,
4265,
4333,
4104,
4334,
4105,
4442,
4213,
4466,
4237,
4470,
4248,
4471,
4249,
4304,
4075,
4502,
3462,
3458,
3471,
3459,
3460,
3466,
3469,
4339,
4110,
4355,
4126,
4287,
4058,
4432,
4203,
4430,
4201,
4433,
4204,
4374,
4145,
4380,
4151,
4310,
4081,
4307,
4078,
4308,
4079,
4409,
4180,
4278,
4049,
4496,
4268,
4476,
4242,
4421,
4192,
4285,
4056,
4402,
4173,
4351,
4122,
4352,
4123,
4449,
4220,
4495,
4267,
4457,
4228,
4458,
4229,
4342,
4113,
4419,
4190,
4420,
4191,
4500,
4375,
4146,
4309,
4080,
4281,
4052,
4277,
4048,
4275,
4046,
4313,
4084,
4289,
4060,
4245,
4425,
4196,
4424,
4195,
4497,
4269,
4328,
4099,
4353,
4124,
4354,
4125,
4373,
4144,
4379,
4150,
4422,
4193,
4330,
4101,
4332,
4103,
4472,
4250,
4407,
4178,
4408,
4179,
4291,
4062,
4441,
4212,
4440,
4211,
4439,
4210,
4456,
4227,
4434,
4205,
4385,
4156,
4431,
4202,
4448,
4219,
4447,
4218,
4298,
4069,
4297,
4068,
4299,
4070,
4296,
4067,
4303,
4074,
4302,
4073,
4301,
4072,
4300,
4071,
4463,
4234,
4283,
4054,
4482,
4254,
4467,
4238,
4389,
4160,
4491,
4263,
4489,
4261,
4426,
4197,
4282,
4053,
4276,
4047,
4477,
4243,
]

_charnames_1329 = [
13682,
13681,
13670,
13680,
13642,
13645,
13641,
13640,
13652,
13644,
13677,
13676,
13672,
13638,
13664,
13678,
13668,
13671,
13635,
13675,
13646,
13674,
13655,
13649,
13636,
13662,
13667,
13659,
13656,
13650,
13653,
13658,
13637,
13647,
13661,
13665,
13673,
13679,
-1,
-1,
13691,
13688,
13686,
13685,
13683,
13690,
13689,
-1,
13622,
13621,
13610,
13620,
13582,
13585,
13581,
13580,
13592,
13584,
13617,
13616,
13612,
13578,
13604,
13618,
13608,
13611,
13575,
13615,
13586,
13614,
13595,
13589,
13576,
13602,
13607,
13599,
13596,
13590,
13593,
13598,
13577,
13587,
13601,
13605,
13613,
13619,
13630,
-1,
13693,
13692,
-1,
-1,
-1,
-1,
-1,
-1,
20734,
20721,
20720,
20696,
20697,
20706,
20731,
20698,
20727,
20717,
20705,
20713,
20714,
20715,
20723,
20704,
20726,
20735,
20710,
20711,
20708,
20709,
20730,
20724,
20703,
20718,
20732,
20733,
20729,
20699,
20772,
20749,
20740,
20742,
20741,
20745,
20756,
20751,
20758,
20753,
20743,
20744,
20755,
20761,
20759,
20769,
20757,
20767,
20748,
20750,
20766,
20771,
20773,
20768,
20754,
]

_charnames_1488 = [
20629,
20664,
20680,
20682,
20661,
20649,
20668,
20662,
20641,
20645,
20622,
20657,
20678,
20626,
20676,
20625,
20674,
20617,
20637,
20620,
20653,
20624,
20639,
20672,
20670,
20608,
20643,
-1,
-1,
-1,
-1,
-1,
20688,
20690,
20687,
20765,
20764,
]

_charnames_1536 = [
13547,
13464,
13497,
13466,
-1,
-1,
13569,
13568,
13529,
13567,
13566,
14021,
13549,
13507,
13531,
13474,
13465,
13475,
13471,
13472,
13473,
13444,
13435,
13445,
13459,
13460,
13458,
13487,
-1,
-1,
13514,
13546,
-1,
12914,
12988,
12984,
13313,
12980,
13152,
12975,
13217,
12793,
12790,
12843,
13377,
12892,
13061,
12923,
12850,
13185,
13361,
13111,
13138,
13128,
12938,
12854,
13354,
13008,
13295,
13032,
13030,
13260,
13258,
13259,
13511,
13266,
13397,
13039,
13339,
13407,
13069,
12863,
13310,
13002,
13149,
13494,
13502,
13517,
13489,
13501,
13516,
13482,
13477,
13541,
13544,
13543,
13481,
13548,
13540,
13545,
13523,
13524,
13525,
13528,
13491,
-1,
13561,
13562,
13553,
13554,
13559,
13560,
13556,
13557,
13564,
13563,
13533,
13508,
13515,
13498,
12973,
12971,
13147,
12998,
12994,
12993,
12916,
12920,
12919,
13390,
12918,
12828,
12829,
13241,
12801,
12800,
13325,
12806,
13234,
12907,
12897,
13103,
12959,
12901,
12813,
12814,
12951,
12934,
12932,
12933,
12946,
12955,
12966,
12928,
12935,
13212,
13190,
13199,
13197,
13191,
13198,
13196,
13384,
13202,
13122,
13115,
13116,
13131,
13132,
12859,
13016,
12972,
13275,
13276,
13366,
13272,
13326,
13401,
13400,
13024,
13146,
13045,
13046,
13089,
13044,
13283,
13289,
13090,
13287,
13303,
13288,
13345,
13346,
13344,
13343,
13079,
13080,
13205,
13078,
13074,
12873,
12825,
12881,
12865,
12870,
12796,
13321,
13057,
13424,
13388,
13180,
13053,
13320,
13365,
13249,
13161,
13162,
13322,
13417,
13160,
13163,
13166,
13496,
13022,
13433,
13434,
13440,
13436,
13451,
13443,
13448,
13538,
13486,
13449,
13447,
13452,
13439,
13454,
13441,
13457,
13456,
13446,
13450,
13532,
13536,
13537,
13527,
13455,
12930,
13200,
11923,
11924,
11915,
11916,
11921,
11922,
11918,
11919,
11926,
11925,
13143,
12943,
13300,
13469,
13468,
12885,
18885,
18855,
18859,
18853,
18857,
18850,
18889,
18888,
18854,
18858,
18890,
18847,
18848,
18849,
-1,
18901,
18839,
18804,
18838,
18824,
18825,
18828,
18827,
18822,
18830,
18829,
18823,
18814,
18815,
18817,
18818,
18835,
18834,
18833,
18832,
18806,
18836,
18837,
18808,
18821,
18807,
18831,
18820,
18805,
18816,
18812,
18810,
18811,
18880,
18879,
18878,
18876,
18875,
18874,
18870,
18869,
18895,
18896,
18844,
18843,
18845,
18884,
18883,
18871,
18899,
18897,
18872,
18863,
18862,
18866,
18865,
18893,
18892,
18898,
18900,
-1,
-1,
18801,
18802,
18803,
13224,
13228,
13222,
13223,
13225,
13227,
13226,
12898,
12900,
12927,
12931,
13193,
13120,
13013,
13015,
13012,
13273,
13271,
13033,
13031,
13029,
13411,
13410,
13073,
13077,
13076,
13347,
13195,
13201,
13117,
12906,
12904,
13118,
13192,
12905,
12996,
12997,
13254,
13255,
13256,
13318,
13319,
13171,
13172,
12908,
13121,
13119,
13043,
18242,
18214,
18232,
18249,
18256,
18235,
18239,
18244,
18248,
18252,
18254,
18230,
18206,
18236,
18225,
18223,
18215,
18228,
18219,
18210,
18246,
18251,
18253,
18255,
18208,
18241,
18238,
18207,
18220,
18213,
18216,
18229,
18209,
18221,
18245,
18224,
18250,
18247,
18266,
18267,
18270,
18263,
18268,
18258,
18264,
18262,
18259,
18260,
18269,
18233,
]

_charnames_1984 = [
26693,
26694,
26685,
26686,
26691,
26692,
26688,
26689,
26696,
26695,
26680,
26662,
26674,
26661,
26667,
26660,
26659,
26664,
26645,
26679,
26670,
26668,
26655,
26678,
26663,
26658,
26657,
26669,
26676,
26677,
26673,
26672,
26649,
26671,
26646,
26648,
26675,
26666,
26665,
26647,
26653,
26654,
26652,
26707,
26706,
26705,
26703,
26702,
26701,
26700,
26708,
26709,
26714,
26681,
26712,
26713,
26710,
26715,
26682,
-1,
-1,
-1,
-1,
-1,
19155,
19142,
19152,
19154,
19135,
19143,
19144,
19136,
19132,
19145,
19151,
19150,
19149,
19148,
19139,
19137,
19153,
19131,
19147,
19146,
19140,
19133,
19195,
19196,
19197,
19200,
19204,
19199,
19162,
19173,
19165,
19159,
19170,
19164,
19158,
19169,
19202,
19168,
19160,
19171,
19203,
19161,
19172,
19163,
19167,
19198,
-1,
-1,
19190,
19181,
19178,
19192,
19179,
19187,
19205,
19191,
19183,
19189,
19184,
19188,
19180,
19186,
19177,
]

_charnames_2304 = [
24556,
24540,
24552,
24548,
24420,
24467,
24470,
24504,
24505,
24499,
24500,
24435,
24437,
24458,
24419,
24513,
24469,
24457,
24418,
24510,
24468,
24484,
24483,
24453,
24450,
24445,
24455,
24460,
24488,
24487,
24444,
24464,
24463,
24430,
24429,
24443,
24466,
24465,
24432,
24431,
24446,
24442,
24503,
24502,
24492,
24490,
24511,
24498,
24474,
24472,
24479,
24478,
24477,
24439,
24421,
24422,
24423,
24508,
-1,
-1,
24555,
24551,
24527,
24533,
24534,
24528,
24529,
24516,
24517,
24523,
24532,
24537,
24526,
24521,
24531,
24536,
24525,
24549,
24535,
-1,
24585,
24560,
24561,
24580,
24583,
24522,
-1,
-1,
24509,
24482,
24449,
24495,
24427,
24473,
24512,
24497,
24436,
24438,
24518,
24519,
24578,
24577,
24573,
24574,
24565,
24566,
24571,
24572,
24568,
24569,
24576,
24575,
24584,
24557,
24459,
-1,
-1,
-1,
-1,
-1,
-1,
24494,
24507,
24452,
24486,
24451,
24428,
24491,
-1,
16643,
16641,
16637,
-1,
16566,
16569,
16589,
16590,
16581,
16582,
16545,
16547,
-1,
-1,
16604,
16568,
-1,
-1,
16600,
16567,
16577,
16575,
16593,
16592,
16558,
16596,
16595,
16588,
16587,
16556,
16552,
16551,
16563,
16562,
16557,
16554,
16553,
16565,
16564,
16559,
-1,
16585,
16584,
16599,
16598,
16601,
16580,
16538,
-1,
16602,
-1,
-1,
-1,
16572,
16571,
16573,
16603,
-1,
-1,
16642,
16640,
16614,
16617,
16618,
16615,
16616,
16607,
16608,
-1,
-1,
16620,
16613,
-1,
-1,
16619,
16612,
16638,
16576,
]

_charnames_2519 = [
16658,
-1,
-1,
-1,
-1,
16542,
16543,
-1,
16579,
16546,
16548,
16609,
16610,
-1,
-1,
16631,
16632,
16623,
16624,
16629,
16630,
16626,
16627,
16634,
16633,
16540,
16541,
16655,
16654,
16649,
16647,
16648,
16651,
16650,
16652,
16656,
16657,
-1,
-1,
-1,
-1,
-1,
22009,
22008,
22003,
-1,
21929,
21932,
21960,
21961,
21943,
21944,
-1,
-1,
-1,
-1,
21975,
21931,
-1,
-1,
21971,
21930,
21937,
21936,
21942,
21941,
21921,
21964,
21963,
21959,
21958,
21919,
21915,
21914,
21926,
21925,
21920,
21917,
21916,
21928,
21927,
21922,
-1,
21953,
21952,
21967,
21966,
21972,
21969,
21950,
-1,
21956,
21955,
-1,
21970,
21946,
-1,
21947,
21973,
-1,
-1,
22007,
-1,
21994,
21997,
21998,
21995,
21996,
-1,
-1,
-1,
-1,
22000,
21993,
-1,
-1,
21999,
21992,
22004,
-1,
-1,
-1,
22006,
]

_charnames_2662 = [
21986,
21987,
21978,
21979,
21984,
21985,
21981,
21982,
21989,
21988,
22011,
22014,
22012,
22010,
22013,
22005,
]

_charnames_2689 = [
21907,
21905,
21901,
-1,
21823,
21826,
21845,
21846,
21831,
21832,
21801,
21803,
21884,
-1,
21861,
21825,
21883,
-1,
21858,
21824,
21841,
21840,
21849,
21848,
21815,
21852,
21851,
21844,
21843,
21813,
21809,
21808,
21820,
21819,
21814,
21811,
21810,
21822,
21821,
21816,
-1,
21835,
21834,
21855,
21854,
21859,
21856,
21857,
-1,
21838,
21837,
-1,
21805,
21829,
21828,
21830,
21860,
-1,
-1,
21906,
21904,
21872,
21875,
21876,
21873,
21874,
21865,
21866,
21879,
-1,
21881,
21871,
21878,
-1,
21880,
21870,
21902,
-1,
-1,
21909,
]

_charnames_2784 = [
21802,
21804,
21867,
21868,
-1,
-1,
21895,
21896,
21887,
21888,
21893,
21894,
21890,
21891,
21898,
21897,
-1,
21908,
]

_charnames_2817 = [
25282,
25280,
25276,
-1,
25199,
25202,
25228,
25229,
25214,
25215,
25177,
25179,
-1,
-1,
25243,
25201,
-1,
-1,
25240,
25200,
25224,
25223,
25232,
25231,
25191,
25235,
25234,
25227,
25226,
25189,
25185,
25184,
25196,
25195,
25190,
25187,
25186,
25198,
25197,
25192,
-1,
25218,
25217,
25238,
25237,
25241,
25213,
25210,
-1,
25221,
25220,
-1,
25181,
25205,
25204,
25206,
25242,
-1,
-1,
25281,
25279,
25253,
25256,
25257,
25254,
25255,
25246,
25247,
-1,
-1,
25259,
25252,
-1,
-1,
25258,
25251,
25277,
]

_charnames_2902 = [
25285,
25284,
-1,
-1,
-1,
-1,
25208,
25209,
-1,
25212,
25178,
25180,
25248,
25249,
-1,
-1,
25270,
25271,
25262,
25263,
25268,
25269,
25265,
25266,
25273,
25272,
25286,
25239,
]

_charnames_2946 = [
17431,
17429,
-1,
17356,
17359,
17379,
17380,
17369,
17370,
-1,
-1,
-1,
17381,
17382,
17358,
-1,
17377,
17378,
17357,
17387,
-1,
-1,
-1,
17354,
17390,
-1,
17388,
-1,
17353,
17372,
-1,
-1,
-1,
17352,
17373,
-1,
-1,
-1,
17355,
17351,
17385,
-1,
-1,
-1,
17386,
17383,
17376,
17375,
17368,
17367,
17366,
17384,
17362,
17361,
17363,
17389,
-1,
-1,
-1,
-1,
17412,
17417,
17418,
17413,
17414,
-1,
-1,
-1,
17419,
17420,
17411,
-1,
17415,
17416,
17410,
17430,
-1,
-1,
17437,
-1,
-1,
-1,
-1,
-1,
-1,
17433,
]

_charnames_3046 = [
17402,
17403,
17394,
17395,
17400,
17401,
17397,
17398,
17405,
17404,
17425,
17424,
17423,
17407,
17438,
17435,
17406,
17439,
17434,
17436,
17426,
-1,
-1,
-1,
-1,
-1,
-1,
17943,
17941,
17937,
-1,
17847,
17850,
17874,
17875,
17855,
17856,
17823,
17825,
-1,
17879,
17880,
17849,
-1,
17863,
17864,
17848,
17870,
17869,
17878,
17877,
17845,
17883,
17882,
17873,
17872,
17843,
17831,
17830,
17838,
17837,
17844,
17834,
17833,
17841,
17840,
17846,
-1,
17862,
17861,
17886,
17885,
17888,
17887,
17859,
17858,
17867,
17866,
-1,
17827,
17853,
17852,
17854,
17889,
-1,
-1,
-1,
17940,
17900,
17905,
17906,
17901,
17902,
17893,
17894,
-1,
17907,
17908,
17899,
-1,
17903,
17904,
17898,
17938,
]

_charnames_3157 = [
17890,
17944,
-1,
17832,
17839,
-1,
-1,
-1,
-1,
-1,
-1,
17824,
17826,
17895,
17896,
-1,
-1,
17919,
17920,
17911,
17912,
17917,
17918,
17914,
17915,
17922,
17921,
]

_charnames_3192 = [
17934,
17932,
17926,
17929,
17933,
17927,
17930,
17942,
-1,
-1,
22773,
22769,
-1,
22690,
22693,
22717,
22718,
22698,
22699,
22668,
22670,
-1,
22722,
22723,
22692,
-1,
22706,
22707,
22691,
22713,
22712,
22721,
22720,
22682,
22726,
22725,
22716,
22715,
22680,
22676,
22675,
22687,
22686,
22681,
22678,
22677,
22689,
22688,
22683,
-1,
22705,
22704,
22729,
22728,
22731,
22730,
22702,
22701,
22710,
22709,
-1,
22672,
22696,
22695,
22697,
22732,
-1,
-1,
22775,
22772,
22744,
22749,
22750,
22745,
22746,
22737,
22738,
-1,
22751,
22752,
22743,
-1,
22747,
22748,
22742,
22770,
]

_charnames_3294 = [
22733,
-1,
22669,
22671,
22739,
22740,
-1,
-1,
22763,
22764,
22755,
22756,
22761,
22762,
22758,
22759,
22766,
22765,
-1,
22776,
22774,
]

_charnames_3330 = [
6432,
6428,
-1,
6350,
6353,
6379,
6380,
6363,
6364,
6328,
6330,
-1,
6384,
6385,
6352,
-1,
6371,
6372,
6351,
6375,
6374,
6383,
6382,
6342,
6325,
6324,
6378,
6377,
6340,
6336,
6335,
6347,
6346,
6341,
6338,
6337,
6349,
6348,
6343,
-1,
6370,
6369,
6388,
6387,
6390,
6389,
6367,
6366,
6362,
6361,
6360,
6332,
6356,
6355,
6357,
6391,
-1,
-1,
-1,
6431,
6401,
6406,
6407,
6402,
6403,
6394,
6395,
-1,
6408,
6409,
6400,
-1,
6404,
6405,
6399,
6429,
]

_charnames_3424 = [
6329,
6331,
6396,
6397,
-1,
-1,
6421,
6422,
6413,
6414,
6419,
6420,
6416,
6417,
6424,
6423,
6437,
6436,
6435,
6440,
6441,
6442,
-1,
-1,
-1,
6425,
6319,
6318,
6322,
6320,
6321,
6323,
-1,
-1,
19507,
19509,
-1,
19416,
19420,
19414,
19415,
19448,
19449,
19466,
19467,
19443,
19444,
19446,
19447,
19472,
19473,
19419,
19469,
19470,
19417,
-1,
-1,
-1,
19408,
19431,
19410,
19433,
19477,
19455,
19411,
19434,
19409,
19432,
19460,
19459,
19454,
19402,
19425,
19405,
19428,
19439,
19452,
19403,
19426,
19406,
19429,
19463,
-1,
19453,
19407,
19430,
19412,
19435,
19436,
19418,
19474,
19476,
-1,
19464,
-1,
-1,
19475,
19458,
19438,
19462,
19478,
19440,
19479,
-1,
-1,
-1,
19508,
-1,
-1,
-1,
-1,
19504,
19492,
19500,
19491,
19499,
19490,
-1,
19497,
-1,
19503,
19483,
19498,
19488,
19487,
19486,
19485,
19502,
]

_charnames_3585 = [
18138,
18135,
18133,
18132,
18134,
18136,
18154,
18162,
18165,
18163,
18098,
18164,
18168,
18183,
18115,
18106,
18111,
18110,
18152,
18182,
18114,
18108,
18107,
18109,
18151,
18186,
18147,
18143,
18172,
18144,
18173,
18145,
18127,
18169,
18177,
18176,
18157,
18159,
18184,
18099,
18100,
18097,
18180,
18158,
18185,
18179,
18148,
18080,
18122,
18086,
18084,
18091,
18092,
18088,
18089,
18087,
18090,
18146,
-1,
-1,
-1,
-1,
18188,
18094,
18085,
18093,
18082,
18083,
18160,
18125,
18126,
18123,
18121,
18120,
18124,
18112,
18153,
18170,
18174,
18199,
18200,
18191,
18192,
18197,
18198,
18194,
18195,
18202,
18201,
18187,
18137,
]

_charnames_3713 = [
9116,
9115,
-1,
9114,
-1,
-1,
9111,
9134,
-1,
9118,
-1,
-1,
9109,
-1,
-1,
-1,
-1,
-1,
-1,
9133,
9102,
9101,
9100,
-1,
9110,
9135,
9107,
9106,
9127,
9105,
9128,
-1,
9132,
9129,
9122,
-1,
9121,
-1,
9130,
-1,
-1,
9119,
9125,
-1,
9131,
9124,
9182,
9137,
9148,
9141,
9139,
9149,
9150,
9142,
9143,
9144,
9145,
-1,
9147,
9176,
9175,
-1,
-1,
9151,
9152,
9153,
9138,
9140,
-1,
9181,
-1,
9172,
9171,
9170,
9173,
9183,
9180,
-1,
-1,
9164,
9165,
9156,
9157,
9162,
9163,
9159,
9160,
9167,
9166,
-1,
-1,
9178,
9179,
]

_charnames_3840 = [
17549,
17621,
17619,
17620,
17653,
17633,
17631,
17668,
17661,
17647,
17650,
17655,
17672,
17660,
17640,
17657,
17639,
17663,
17664,
17629,
17622,
17613,
17612,
17725,
17727,
17726,
17518,
17517,
17516,
17512,
17511,
17519,
17697,
17698,
17689,
17690,
17695,
17696,
17692,
17693,
17700,
17699,
17685,
17676,
17677,
17682,
17683,
17679,
17680,
17687,
17686,
17684,
17649,
17643,
17630,
17642,
17635,
17658,
17624,
17625,
17666,
17667,
17523,
17527,
17579,
17578,
17595,
17594,
17573,
17598,
17597,
17606,
-1,
17571,
17555,
17554,
17567,
17566,
17572,
17560,
17559,
17569,
17568,
17574,
17592,
17591,
17601,
17600,
17604,
17558,
17557,
17564,
17563,
17603,
17585,
17586,
17610,
17602,
17589,
17605,
17582,
17581,
17583,
17607,
17609,
17576,
17608,
17577,
17588,
-1,
-1,
-1,
-1,
17717,
17713,
17714,
17707,
17708,
17703,
17704,
17705,
17706,
17715,
17716,
17711,
17712,
17521,
17520,
17709,
17710,
17535,
17534,
17671,
17669,
17529,
17524,
17530,
17526,
17533,
17532,
-1,
-1,
-1,
-1,
17476,
17475,
17489,
17488,
17467,
17492,
17491,
17501,
-1,
17465,
17449,
17448,
17461,
17460,
17466,
17454,
17453,
17463,
17462,
17468,
17486,
17485,
17495,
17494,
17499,
17452,
17451,
17458,
17457,
17497,
17482,
17483,
17504,
17496,
17498,
17500,
17471,
17470,
17472,
17502,
17503,
17474,
17479,
17478,
17480,
-1,
17728,
17729,
17721,
17720,
17722,
17719,
17548,
17543,
17547,
17544,
17546,
17538,
17540,
17541,
17542,
-1,
17513,
17510,
17648,
17670,
17638,
17654,
17634,
25636,
9868,
25637,
9869,
]

_charnames_4096 = [
7397,
7369,
7466,
7465,
7434,
7488,
7487,
7483,
7482,
7433,
7431,
7444,
7443,
7455,
7454,
7432,
7446,
7445,
7457,
7456,
7435,
7477,
7476,
7491,
7490,
7428,
7492,
7474,
7480,
7462,
7419,
7494,
7479,
7467,
7416,
7484,
7485,
7470,
7471,
7447,
7427,
7493,
7468,
7594,
7577,
7590,
7591,
7585,
7586,
7592,
7574,
7589,
7588,
7593,
7528,
7532,
7521,
7522,
7527,
7613,
7615,
7614,
7616,
7464,
7606,
7607,
7598,
7599,
7604,
7605,
7601,
7602,
7609,
7608,
7531,
7513,
7557,
7559,
7553,
7558,
7399,
7417,
7437,
7438,
7439,
7440,
7569,
7570,
7571,
7572,
7425,
7426,
7424,
7423,
7618,
7619,
7620,
7418,
7567,
7624,
7623,
7460,
7461,
7584,
7583,
7519,
7518,
7517,
7516,
7515,
7450,
7449,
7451,
7595,
7580,
7579,
7581,
7406,
7405,
7411,
7414,
7407,
7402,
7413,
7403,
7409,
7412,
7415,
7408,
7410,
7621,
7566,
7563,
7564,
7565,
7507,
7506,
7505,
7504,
7511,
7510,
7512,
7473,
7529,
7543,
7544,
7535,
7536,
7541,
7542,
7538,
7539,
7546,
7545,
7525,
7524,
7575,
7576,
7555,
7556,
22176,
22175,
22161,
22174,
22173,
22164,
22143,
22146,
22172,
22155,
22171,
22170,
22169,
22168,
22152,
22142,
22166,
22149,
22145,
22165,
22151,
22154,
22160,
22167,
22148,
22137,
22140,
22157,
22139,
22138,
22162,
22158,
22131,
22134,
22133,
22163,
22130,
22132,
]

_charnames_4304 = [
22060,
22076,
22055,
22075,
22057,
22065,
22040,
22036,
22073,
22049,
22072,
22071,
22070,
22069,
22046,
22039,
22067,
22043,
22035,
22066,
22045,
22048,
22054,
22068,
22042,
22029,
22032,
22051,
22031,
22030,
22063,
22052,
22023,
22026,
22025,
22064,
22022,
22024,
22074,
22062,
22058,
22037,
22061,
22177,
6780,
-1,
-1,
-1,
20252,
20140,
20255,
20235,
20130,
20199,
20263,
20144,
20138,
20107,
20132,
20217,
20197,
20134,
20184,
20254,
20243,
20168,
20272,
20260,
20139,
20257,
20259,
20241,
20213,
20137,
20215,
20250,
20267,
20251,
20160,
20166,
20157,
20147,
20153,
20150,
20152,
20155,
20154,
20163,
20164,
20158,
20165,
20247,
20249,
20117,
20124,
20114,
20123,
20125,
20110,
20111,
20122,
20126,
20120,
20121,
20118,
20115,
20112,
20127,
20180,
20178,
20193,
20191,
20172,
20232,
20224,
20231,
20220,
20229,
20222,
20141,
20227,
20228,
20225,
20221,
20270,
20198,
20182,
20179,
20195,
20192,
20186,
20187,
20183,
20196,
20170,
20248,
20142,
20271,
20253,
20258,
20262,
20261,
20238,
20274,
20104,
20075,
20087,
20023,
20028,
20057,
20048,
20018,
20017,
20062,
20100,
20101,
20074,
20006,
20088,
20099,
20098,
20102,
19995,
20049,
20029,
20031,
20085,
20084,
20027,
20025,
20060,
20059,
20061,
20022,
20021,
20072,
20071,
20065,
20069,
20073,
20009,
20010,
20011,
20014,
20015,
20092,
20093,
20096,
20090,
20094,
20001,
20000,
19999,
19998,
19997,
20003,
20005,
20054,
20052,
20030,
20043,
20034,
20041,
20045,
20047,
20044,
20076,
20079,
20080,
20081,
20103,
20086,
20026,
20020,
20067,
20068,
19906,
19862,
19908,
19954,
19960,
19966,
19942,
19811,
19823,
19829,
19814,
19846,
19841,
19820,
19848,
19923,
19883,
19885,
19865,
19851,
19981,
19988,
19992,
19922,
19953,
19896,
19975,
19910,
19909,
19965,
19957,
19962,
19964,
19958,
19952,
19950,
19825,
19847,
19839,
19840,
19857,
19832,
19831,
19817,
19819,
19828,
19844,
19821,
19827,
19835,
19939,
19937,
19931,
19929,
19927,
19933,
19936,
19940,
19921,
19887,
19893,
19895,
19918,
19874,
19868,
19879,
19871,
19901,
19984,
19986,
19863,
19985,
19968,
19970,
19971,
19900,
19919,
19979,
19977,
19980,
19978,
19974,
19912,
19911,
19915,
19913,
19914,
19860,
11719,
11721,
11722,
11720,
11718,
11717,
11715,
11716,
11782,
11785,
11786,
11783,
11781,
11780,
11778,
11784,
11709,
11712,
11714,
11710,
11708,
11707,
11713,
11711,
11733,
11736,
11737,
11734,
11732,
11731,
11729,
11728,
11407,
11410,
11412,
11408,
11406,
11405,
11411,
11409,
11771,
11775,
11776,
11772,
11770,
11769,
11767,
11774,
11430,
11433,
11434,
11431,
11427,
11421,
11428,
11432,
11399,
11402,
11403,
11400,
11398,
11397,
11395,
11401,
11506,
11508,
11509,
11507,
11505,
11504,
11502,
11503,
11499,
-1,
11501,
11500,
11498,
11497,
-1,
-1,
11483,
11485,
11487,
11484,
11482,
11481,
11486,
-1,
11478,
-1,
11480,
11479,
11477,
11476,
-1,
-1,
11762,
11764,
11765,
11763,
11761,
11760,
11758,
11757,
11818,
11821,
11823,
11819,
11817,
11816,
11822,
11820,
11468,
11471,
11472,
11469,
11467,
11466,
11464,
11470,
11578,
11581,
11582,
11579,
11577,
11576,
11574,
11580,
11661,
11663,
11664,
11662,
11660,
11659,
11657,
11658,
11654,
-1,
11656,
11655,
11653,
11652,
-1,
-1,
11680,
11683,
11684,
11681,
11679,
11678,
11676,
11682,
11671,
11674,
11675,
11672,
11670,
11669,
11667,
11673,
11366,
11369,
11370,
11367,
11365,
11364,
11362,
11368,
11543,
11545,
11546,
11544,
11542,
11541,
11539,
11540,
11536,
-1,
11538,
11537,
11535,
11534,
-1,
-1,
11520,
11522,
11524,
11521,
11519,
11518,
11523,
-1,
11515,
-1,
11517,
11516,
11514,
11513,
-1,
-1,
11811,
11813,
11814,
11812,
11810,
11809,
11807,
11808,
11589,
11591,
11593,
11590,
11588,
11587,
11592,
-1,
11637,
11640,
11641,
11638,
11636,
11635,
11633,
11639,
11619,
11622,
11624,
11620,
11618,
11617,
11623,
11621,
11802,
11804,
11805,
11803,
11801,
11800,
11798,
11799,
11700,
11703,
11704,
11701,
11699,
11698,
11696,
11702,
11691,
11694,
11695,
11692,
11690,
11689,
11687,
11693,
11792,
11795,
11796,
11793,
11791,
11790,
11788,
11794,
11389,
11391,
11392,
11390,
11388,
11387,
11385,
11386,
11382,
-1,
11384,
11383,
11381,
11380,
-1,
-1,
11356,
11358,
11360,
11357,
11355,
11354,
11359,
11352,
11441,
11444,
11445,
11442,
11440,
11439,
11437,
11443,
11569,
11572,
11573,
11570,
11568,
11567,
11565,
11571,
11585,
11600,
11601,
11594,
11598,
11597,
11595,
11599,
11458,
11461,
11463,
11459,
11457,
11456,
11462,
11460,
11451,
11453,
11454,
11452,
11450,
11449,
11447,
11448,
11746,
11749,
11751,
11747,
11745,
11744,
11750,
11743,
11611,
11613,
11614,
11612,
11610,
11609,
11607,
11606,
11773,
11735,
11748,
-1,
-1,
-1,
-1,
11871,
11826,
11876,
11878,
11870,
11825,
11872,
11874,
11877,
11875,
11865,
11857,
11858,
11863,
11864,
11860,
11861,
11867,
11866,
11829,
11831,
11832,
11837,
11838,
11834,
11835,
11841,
11839,
11840,
11830,
-1,
-1,
-1,
11424,
11727,
11726,
11725,
11426,
11756,
11755,
11754,
11425,
11742,
11741,
11740,
11423,
11605,
11604,
11603,
11850,
11844,
11852,
11851,
11846,
11849,
11854,
11853,
11845,
11848,
-1,
-1,
-1,
-1,
-1,
-1,
5059,
5058,
5057,
5055,
5054,
5053,
5046,
5056,
5045,
5044,
5043,
5042,
5041,
5003,
5002,
5001,
4999,
4998,
4997,
5039,
5038,
5037,
5036,
5035,
5034,
5052,
5051,
5050,
5049,
5048,
4989,
5000,
4990,
4995,
4994,
4993,
4992,
4991,
5032,
5031,
5030,
5029,
5028,
5027,
4987,
4981,
4986,
4985,
4984,
4983,
4982,
5011,
4980,
5010,
4979,
5009,
4978,
5007,
5006,
5005,
5008,
4977,
4976,
4975,
4974,
4973,
4972,
4970,
4969,
4968,
4967,
4966,
4965,
5025,
5024,
5023,
5022,
5021,
5020,
5018,
5017,
5016,
5015,
5014,
5013,
]

_charnames_5120 = [
3338,
3334,
3314,
3331,
3333,
3293,
3309,
3104,
2753,
2751,
3311,
3312,
2771,
2849,
2898,
2845,
2899,
2846,
2878,
2843,
2879,
2844,
2912,
2895,
2847,
2897,
2848,
2913,
3318,
3101,
3340,
3149,
3147,
3148,
3144,
3134,
3133,
3139,
3138,
3146,
3143,
3145,
3140,
3335,
3332,
3310,
3321,
3273,
3266,
3271,
3272,
3268,
3270,
3099,
2693,
2692,
3264,
3265,
3263,
2832,
3259,
2828,
3260,
2829,
3256,
2826,
3258,
2827,
3261,
2830,
3262,
2831,
3098,
3254,
2824,
2684,
3030,
3024,
3028,
3029,
3026,
3027,
3102,
2606,
2607,
3022,
3023,
3009,
2822,
3005,
2818,
3006,
2819,
3003,
2816,
3004,
2817,
3007,
2820,
3008,
2821,
2915,
2968,
3000,
2999,
2998,
3001,
3292,
3286,
3290,
3291,
3288,
3289,
3108,
3284,
3285,
3283,
2857,
3281,
2853,
3282,
2854,
3279,
2851,
3280,
2852,
3276,
2855,
3278,
2856,
2918,
3274,
3275,
3088,
3087,
3086,
3089,
2769,
2755,
2766,
2767,
2764,
2765,
3109,
2542,
2754,
2763,
2865,
2759,
2861,
2760,
2862,
2757,
2859,
2758,
2860,
2761,
2863,
2762,
2864,
2919,
2541,
3053,
3200,
3195,
3204,
3205,
3197,
3198,
3106,
3193,
3194,
3192,
2841,
3188,
2837,
3189,
2838,
3186,
2835,
3187,
2836,
3190,
2839,
3191,
2840,
2917,
3184,
2833,
3206,
3317,
3054,
2967,
2921,
2964,
2965,
2957,
2959,
3105,
2901,
2920,
2949,
2875,
2947,
2873,
2948,
2874,
2916,
2900,
2714,
2966,
3183,
3177,
3181,
3182,
3179,
3180,
3107,
3175,
3176,
3167,
2799,
3163,
2795,
3164,
2796,
3161,
2793,
3162,
2794,
3165,
2797,
3166,
2798,
3159,
2791,
3203,
3094,
3056,
3092,
3093,
3084,
3091,
3103,
3032,
3055,
3083,
2782,
3079,
2778,
3080,
2779,
3077,
2776,
3078,
2777,
3081,
2780,
3082,
2781,
2906,
3031,
3316,
3076,
3224,
3199,
2904,
2910,
2908,
2907,
2905,
2909,
3075,
3073,
3074,
3067,
3069,
3070,
3072,
3066,
2790,
3062,
2786,
3063,
2787,
3059,
2784,
3061,
2785,
3064,
2788,
3065,
2789,
3057,
3127,
3120,
3125,
3126,
3122,
3124,
3100,
3118,
3119,
3117,
2813,
3113,
2809,
3114,
2810,
3111,
2807,
3112,
2808,
3115,
2811,
3116,
2812,
2914,
3095,
3232,
2805,
3052,
3253,
3252,
2804,
3244,
3248,
3249,
3246,
3247,
2800,
3242,
3243,
2802,
3240,
2867,
3233,
2866,
3202,
3158,
3153,
3129,
3150,
3154,
3155,
3151,
3152,
3156,
2876,
3128,
2988,
2963,
2984,
2961,
2985,
2962,
2982,
2983,
2986,
2987,
2980,
2823,
2969,
2997,
2996,
2991,
2993,
2990,
3020,
3019,
3018,
3021,
2931,
2927,
2928,
2925,
2926,
2929,
2930,
2924,
2932,
3339,
3325,
3329,
3330,
3327,
3328,
3323,
3324,
3322,
3015,
3014,
3011,
3016,
2870,
2869,
2868,
2871,
2936,
2940,
2941,
2938,
2939,
2934,
2935,
2933,
2950,
3040,
3039,
3036,
3041,
2892,
2891,
2890,
2893,
2881,
3171,
3172,
3169,
3170,
3173,
3174,
3168,
2977,
2973,
2974,
2971,
2972,
2975,
2976,
2970,
3319,
3227,
3226,
3225,
3228,
3212,
3211,
3210,
3213,
3217,
3216,
3215,
3218,
3222,
3221,
3220,
3223,
3046,
3045,
3043,
3047,
2612,
2613,
2610,
2611,
2614,
2615,
2733,
2734,
2731,
2732,
2735,
2736,
2726,
2727,
2724,
2725,
2728,
2729,
2688,
2689,
2686,
2687,
2690,
2691,
2583,
2584,
2581,
2582,
2585,
2586,
2555,
2556,
2553,
2554,
2557,
2558,
2704,
2705,
2702,
2703,
2706,
2707,
2701,
2623,
2624,
2619,
2620,
2625,
2621,
2651,
2652,
2649,
2650,
2653,
2654,
2644,
2645,
2642,
2643,
2646,
2647,
2641,
2711,
2712,
2709,
2710,
2713,
2715,
2740,
2741,
2738,
2739,
2742,
2743,
2719,
2720,
2717,
2718,
2721,
2722,
2666,
3049,
2667,
2663,
2664,
2668,
3051,
2669,
2659,
2660,
2657,
2658,
2661,
2662,
2680,
2681,
2678,
2679,
2682,
2683,
2598,
2599,
2596,
2597,
2600,
2601,
2674,
2675,
2672,
2673,
2676,
2677,
2563,
2564,
2561,
2562,
2565,
2566,
2569,
2570,
2567,
2568,
2571,
2572,
2697,
2698,
2695,
2696,
2699,
2700,
2694,
2752,
2591,
2592,
2589,
2590,
2593,
2594,
2636,
2637,
2634,
2635,
2638,
2639,
2630,
2631,
2628,
2629,
2632,
2633,
2627,
2576,
2577,
2574,
2575,
2578,
2579,
2747,
2748,
2745,
2746,
2749,
2750,
2549,
2550,
2547,
2548,
2551,
2552,
2768,
3157,
3326,
2937,
2953,
2954,
2951,
2952,
2955,
2956,
2889,
2885,
2886,
2883,
2884,
2887,
2888,
2894,
3209,
25378,
25376,
25372,
25374,
25355,
25360,
25348,
25375,
25368,
25366,
25367,
25371,
25373,
25361,
25354,
25369,
25377,
25358,
25346,
25351,
25363,
25352,
25357,
25347,
25364,
25350,
25370,
25380,
25379,
-1,
-1,
-1,
25737,
25729,
25730,
25715,
25714,
25716,
25720,
25688,
25710,
25668,
25713,
25712,
25675,
25657,
25666,
25671,
25670,
25731,
25722,
25700,
25723,
25704,
25689,
25707,
25708,
25717,
25725,
25726,
25677,
25660,
25734,
25658,
25695,
25684,
25687,
25736,
25706,
25678,
25662,
25683,
25733,
25711,
25664,
25665,
25656,
25698,
25727,
25719,
25655,
25692,
25738,
25661,
25694,
25669,
25690,
25735,
25676,
25659,
25679,
25696,
25682,
25681,
25697,
25667,
25691,
25685,
25702,
25703,
25701,
25663,
25674,
25654,
25686,
25732,
25728,
25740,
25741,
25742,
25744,
25739,
25743,
]

_charnames_5888 = [
17320,
17315,
17308,
17314,
17317,
17304,
17309,
17318,
17305,
17311,
17319,
17312,
17306,
-1,
17313,
17307,
17310,
17316,
17323,
17322,
17324,
]

_charnames_5920 = [
20433,
20428,
20420,
20427,
20430,
20416,
20421,
20431,
20417,
20424,
20432,
20425,
20418,
20423,
20426,
20419,
20422,
20429,
20436,
20435,
20437,
26342,
26343,
]

_charnames_5952 = [
16862,
16857,
16849,
16856,
16859,
16845,
16850,
16860,
16846,
16853,
16861,
16854,
16847,
16852,
16855,
16848,
16851,
16858,
16865,
16864,
]

_charnames_5984 = [
17343,
17339,
17332,
17338,
17340,
17328,
17333,
17341,
17329,
17335,
17342,
17336,
17330,
-1,
17337,
17331,
17334,
-1,
17346,
17345,
]

_charnames_6016 = [
23195,
23193,
23194,
23192,
23189,
23201,
23199,
23200,
23198,
23186,
23216,
23179,
23215,
23178,
23188,
23184,
23182,
23183,
23181,
23187,
23223,
23209,
23210,
23208,
23221,
23217,
23219,
23212,
23218,
23204,
23203,
23205,
23222,
23213,
23220,
23255,
23257,
23261,
23262,
23249,
23252,
23250,
23251,
23264,
23265,
23266,
23267,
23263,
23256,
23260,
23259,
23254,
23245,
23246,
23230,
23237,
23238,
23231,
23232,
23234,
23235,
23236,
23242,
23233,
23239,
23243,
23229,
23228,
23241,
23227,
23172,
23164,
23168,
23173,
23160,
23149,
23163,
23161,
23154,
23158,
23170,
23169,
23166,
23147,
23153,
23148,
23167,
23174,
23150,
23171,
23152,
23282,
23156,
23157,
-1,
-1,
23278,
23279,
23270,
23271,
23276,
23277,
23273,
23274,
23281,
23280,
-1,
-1,
-1,
-1,
-1,
-1,
23131,
23132,
23127,
23130,
23129,
23120,
23126,
23125,
23124,
23123,
-1,
-1,
-1,
-1,
-1,
-1,
6998,
6997,
6991,
6985,
6992,
6986,
6994,
6995,
6989,
6988,
6996,
6984,
6982,
6983,
6993,
-1,
6975,
6976,
6967,
6968,
6973,
6974,
6970,
6971,
6978,
6977,
-1,
-1,
-1,
-1,
-1,
-1,
6842,
6947,
6959,
6939,
6937,
6940,
6938,
6948,
6957,
6878,
6964,
6956,
6955,
6961,
6907,
6943,
6906,
6905,
6841,
6963,
6951,
6958,
6952,
6954,
6953,
6962,
6946,
6945,
6840,
6936,
6960,
6934,
6942,
6935,
6950,
6833,
6837,
6835,
6817,
6812,
6818,
6813,
6811,
6839,
6830,
6829,
6822,
6832,
6816,
6826,
6838,
6821,
6815,
6827,
6828,
6834,
6823,
6836,
6820,
6831,
6825,
6901,
6889,
6890,
6885,
6884,
6904,
6898,
6893,
6891,
6897,
6895,
6888,
6902,
6899,
6900,
6894,
6892,
6887,
6883,
6896,
6903,
6882,
6931,
6930,
6929,
6932,
6928,
]

_charnames_6272 = [
6856,
6872,
6852,
6873,
6868,
6877,
6848,
6855,
6867,
6875,
6866,
6876,
6847,
6846,
6854,
6865,
6849,
6851,
6863,
6862,
6874,
6859,
6860,
6857,
6810,
6809,
6926,
6923,
6921,
6925,
6914,
6918,
6915,
6917,
6922,
6920,
6911,
6912,
6871,
6870,
6927,
6853,
6924,
-1,
-1,
-1,
-1,
-1,
3308,
3320,
3313,
2896,
3269,
3267,
3257,
3025,
3287,
3277,
3196,
2958,
2922,
3178,
3090,
3033,
3068,
3071,
3060,
3123,
3121,
3245,
2945,
3299,
2946,
3300,
2943,
3297,
2944,
3298,
3241,
3237,
3238,
3235,
3236,
3239,
3304,
3303,
3306,
3307,
3305,
3295,
3301,
3302,
3336,
2877,
3142,
3135,
3251,
2801,
2803,
2981,
2979,
2995,
2992,
2994,
3013,
3012,
3038,
3037,
3044,
2617,
2605,
2622,
2618,
3050,
2665,
3231,
3230,
2604,
]

_charnames_6400 = [
9544,
9491,
9490,
9497,
9496,
9487,
9503,
9502,
9494,
9493,
9479,
9482,
9481,
9500,
9499,
9488,
9485,
9484,
9506,
9505,
9509,
9478,
9508,
9510,
9507,
9476,
9475,
9477,
9511,
-1,
-1,
-1,
9535,
9543,
9542,
9541,
9537,
9539,
9536,
9540,
9538,
9530,
9532,
9531,
-1,
-1,
-1,
-1,
9522,
9515,
9523,
9517,
9516,
9519,
9520,
9518,
9521,
9526,
9528,
9525,
-1,
-1,
-1,
-1,
9527,
-1,
-1,
-1,
9560,
9559,
9555,
9556,
9547,
9548,
9553,
9554,
9550,
9551,
9558,
9557,
17171,
17173,
17167,
17150,
17175,
17172,
17152,
17151,
17178,
17163,
17162,
17177,
17181,
17174,
17180,
17176,
17170,
17149,
17168,
17156,
17179,
17155,
17154,
17159,
17165,
17164,
17160,
17153,
17157,
17158,
-1,
-1,
17147,
17146,
17145,
17144,
17143,
]

_charnames_6528 = [
26533,
26504,
26530,
26518,
26526,
26501,
26489,
26497,
26513,
26521,
26531,
26484,
26492,
26502,
26515,
26514,
26527,
26486,
26485,
26498,
26524,
26523,
26534,
26495,
26494,
26505,
26537,
26532,
26535,
26508,
26503,
26506,
26536,
26538,
26539,
26507,
26509,
26510,
26529,
26517,
26500,
26488,
26520,
26491,
-1,
-1,
-1,
-1,
26566,
26559,
26565,
26549,
26553,
26567,
26562,
26554,
26555,
26550,
26561,
26560,
26552,
26557,
26556,
26551,
26564,
26543,
26542,
26541,
26544,
26545,
26546,
26547,
26585,
26584,
-1,
-1,
-1,
-1,
-1,
-1,
26578,
26579,
26570,
26571,
26576,
26577,
26573,
26574,
26581,
26580,
26586,
-1,
-1,
-1,
26587,
26588,
23095,
23142,
23094,
23139,
23136,
23091,
23088,
23085,
23082,
23079,
23117,
23114,
23104,
23111,
23108,
23101,
23143,
23141,
23093,
23138,
23135,
23090,
23087,
23084,
23081,
23078,
23116,
23113,
23103,
23110,
23107,
23100,
16826,
16829,
16813,
16812,
16824,
16832,
16818,
16817,
16821,
16830,
16815,
16814,
16831,
16827,
16810,
16809,
16819,
16823,
16825,
16820,
16822,
16833,
16828,
16837,
16835,
16838,
16836,
16839,
-1,
-1,
16840,
16841,
16912,
16911,
16910,
16885,
16883,
16884,
16933,
16921,
16920,
16894,
16896,
16893,
16932,
16928,
16923,
16944,
16897,
16929,
16915,
16914,
16888,
16887,
16934,
16945,
16918,
16917,
16925,
16891,
16899,
16890,
16941,
16895,
16922,
16927,
16930,
16900,
16902,
16939,
16907,
16906,
16908,
16924,
16903,
16946,
16898,
16937,
16938,
16935,
16936,
16943,
16940,
16901,
16942,
17035,
17036,
17040,
16965,
17043,
17039,
17042,
17037,
17044,
17041,
-1,
16962,
16992,
17001,
16995,
16998,
16999,
17000,
16991,
16990,
16988,
16989,
16982,
16984,
16986,
17002,
16994,
16987,
16993,
16997,
16985,
16964,
16972,
16971,
16953,
16952,
16951,
16975,
16967,
16954,
-1,
-1,
17045,
17027,
17028,
17019,
17020,
17025,
17026,
17022,
17023,
17030,
17029,
-1,
-1,
-1,
-1,
-1,
-1,
17013,
17014,
17005,
17006,
17011,
17012,
17008,
17009,
17016,
17015,
-1,
-1,
-1,
-1,
-1,
-1,
16968,
16969,
16961,
16957,
16977,
16979,
16974,
16966,
16955,
16956,
16959,
16960,
16978,
16980,
]

_charnames_6912 = [
16109,
16110,
16113,
16111,
16114,
15995,
15996,
16017,
16018,
16009,
16010,
16004,
16005,
16007,
16008,
16022,
15998,
16013,
16014,
15984,
15986,
16019,
16020,
15982,
16024,
16025,
16015,
16016,
15981,
15976,
15975,
15992,
15991,
15980,
15972,
15974,
15988,
15993,
15979,
16011,
16012,
16026,
16027,
16032,
16029,
16003,
16006,
16030,
16002,
16001,
15999,
16033,
16112,
16082,
16083,
16084,
16085,
16086,
16087,
16088,
16091,
16092,
16077,
16079,
16081,
16080,
16089,
16090,
16126,
15985,
15987,
15977,
16023,
16031,
16028,
15997,
-1,
-1,
-1,
-1,
16103,
16104,
16095,
16096,
16101,
16102,
16098,
16099,
16106,
16105,
16119,
16118,
16125,
16123,
16124,
16122,
16117,
16047,
16045,
16046,
16037,
16039,
16048,
16042,
16044,
16041,
16040,
16055,
16058,
16051,
16053,
16056,
16052,
16054,
16059,
16057,
16070,
16071,
16073,
16074,
16064,
16062,
16067,
16066,
16063,
-1,
-1,
-1,
19276,
19275,
19274,
19226,
19242,
19233,
19227,
19238,
19224,
19225,
19223,
19236,
19244,
19216,
19247,
19241,
19228,
19215,
19234,
19246,
19217,
19237,
19245,
19232,
19248,
19239,
19229,
19235,
19240,
19231,
19220,
19230,
19243,
19282,
19281,
19280,
19267,
19265,
19269,
19266,
19270,
19268,
19277,
-1,
-1,
-1,
19222,
19219,
19259,
19260,
19251,
19252,
19257,
19258,
19254,
19255,
19262,
19261,
]

_charnames_7168 = [
9892,
9890,
9891,
9908,
9907,
9887,
9914,
9913,
9923,
9886,
9880,
9879,
9896,
9888,
9884,
9882,
9883,
9911,
9910,
9917,
9916,
9902,
9901,
9878,
9877,
9894,
9918,
9921,
9922,
9905,
9904,
9920,
9899,
9898,
9919,
9924,
9966,
9967,
9956,
9954,
9952,
9953,
9950,
9951,
9955,
9942,
9947,
9948,
9940,
9946,
9945,
9944,
9941,
9943,
9969,
9970,
-1,
-1,
-1,
9961,
9962,
9963,
9960,
9959,
9935,
9936,
9927,
9928,
9933,
9934,
9930,
9931,
9938,
9937,
-1,
-1,
-1,
9875,
9874,
9895,
25156,
25157,
25148,
25149,
25154,
25155,
25151,
25152,
25159,
25158,
25120,
25115,
25118,
25116,
25117,
25121,
25113,
25114,
25112,
25111,
25124,
25137,
25140,
25139,
25138,
25122,
25130,
25129,
25128,
25127,
25125,
25143,
25145,
25144,
25142,
25123,
25133,
25135,
25132,
25134,
25167,
25169,
25166,
25168,
25164,
25170,
25162,
25163,
]

_charnames_7376 = [
24026,
24030,
24032,
24011,
24009,
24019,
24018,
24016,
24033,
24017,
24028,
24022,
24025,
24029,
24021,
24023,
24031,
24034,
24003,
23999,
24006,
24001,
24007,
24000,
24002,
23996,
23995,
23992,
23993,
24010,
24013,
24012,
24008,
23994,
23997,
]

_charnames_7424 = [
9046,
9047,
7793,
9045,
9062,
9061,
9037,
9035,
7795,
7799,
9058,
9057,
9039,
9056,
9025,
9027,
9029,
8088,
8089,
8090,
7796,
9028,
7836,
8385,
9054,
9024,
9033,
9031,
9052,
8091,
8093,
8092,
9051,
9050,
9048,
9036,
9083,
9080,
21670,
21669,
21667,
21668,
21666,
4499,
6641,
6642,
6639,
6640,
6657,
6656,
6636,
6655,
6654,
6653,
6652,
6651,
6650,
6649,
6648,
6635,
6637,
6638,
6647,
6633,
6646,
6645,
6643,
6601,
6535,
6602,
6537,
6575,
6598,
6565,
6562,
6593,
6543,
6570,
6544,
6623,
6611,
6569,
6590,
6592,
6546,
6576,
6606,
6533,
6583,
6563,
6540,
6604,
6603,
6577,
6573,
6600,
6572,
6557,
8487,
8484,
8482,
8481,
21320,
21318,
21316,
21317,
21319,
8068,
8381,
8223,
8448,
8419,
8258,
8407,
8123,
8116,
8085,
7828,
8320,
7807,
6672,
8200,
7841,
8478,
8204,
8403,
8477,
8066,
8380,
8222,
8447,
8365,
8353,
8158,
8418,
8257,
8406,
8122,
8084,
7957,
8394,
8464,
8319,
7999,
8015,
8217,
7937,
7904,
8130,
8097,
8188,
7902,
7956,
8056,
7952,
6536,
6549,
6558,
6567,
6588,
6624,
6599,
6561,
6545,
6617,
6616,
6551,
6553,
6614,
6596,
6597,
6556,
6612,
6541,
6610,
6609,
6555,
6578,
6607,
6564,
6568,
6548,
6585,
6584,
6554,
6605,
6542,
6579,
6581,
6582,
6566,
6547,
3594,
3595,
3725,
3723,
3700,
3672,
3698,
3682,
3673,
3683,
3498,
3745,
3699,
3586,
3763,
3770,
3742,
3755,
3754,
3519,
3494,
3493,
3492,
3506,
3502,
3504,
3518,
3526,
3516,
3499,
3525,
3524,
3514,
3523,
3522,
3497,
3512,
3500,
3507,
]

_charnames_7677 = [
3693,
3533,
3632,
8582,
7997,
8983,
8377,
8982,
8376,
8986,
8382,
8907,
8288,
8866,
8220,
8865,
8219,
8868,
8224,
8862,
8211,
8861,
8210,
8627,
7932,
8628,
7933,
8614,
7919,
8630,
7935,
8616,
7921,
9014,
8450,
8896,
8366,
8877,
8269,
8876,
8268,
8878,
8270,
8882,
8274,
8885,
8279,
8736,
8183,
8734,
8181,
8946,
8356,
8936,
8345,
8944,
8354,
8801,
8147,
8802,
8148,
8814,
8159,
8805,
8143,
8995,
8421,
8993,
8417,
8992,
8416,
8848,
8254,
8847,
8253,
8840,
8250,
8843,
8245,
8528,
7883,
8527,
7882,
8532,
7886,
8533,
7887,
8978,
8411,
8977,
8410,
8783,
8110,
8781,
8108,
8782,
8109,
8790,
8114,
8768,
8080,
8766,
8078,
8770,
8082,
8761,
8073,
8767,
8079,
8703,
7821,
8702,
7820,
8707,
7829,
8697,
7815,
8660,
8031,
8677,
8048,
8681,
8052,
8678,
8049,
8684,
8058,
8964,
8392,
8962,
8390,
8955,
8435,
8957,
8437,
8953,
8432,
8952,
8431,
8951,
8430,
9001,
8462,
9002,
8463,
8824,
8329,
8928,
8313,
8921,
8308,
8930,
8321,
8277,
7824,
8433,
8335,
7998,
8165,
8166,
8167,
8773,
8237,
8568,
7981,
8588,
8005,
8561,
7974,
8559,
7972,
8558,
7971,
8557,
7970,
8560,
7973,
8578,
7991,
8576,
7989,
8575,
7988,
8574,
7987,
8577,
7990,
8621,
7926,
8634,
7941,
8629,
7934,
8613,
7918,
8611,
7916,
8610,
7915,
8609,
7914,
8612,
7917,
8744,
8192,
8730,
8179,
8509,
7864,
8503,
7858,
8522,
7877,
8520,
7875,
8519,
7874,
8518,
7873,
8521,
7876,
8502,
7857,
8500,
7855,
8499,
7854,
8498,
7853,
8501,
7856,
8665,
8036,
8674,
8045,
8673,
8044,
8671,
8042,
8670,
8041,
8669,
8040,
8672,
8043,
8832,
8338,
8823,
8328,
8827,
8332,
8828,
8333,
8998,
8424,
8997,
8423,
8831,
8337,
21190,
21201,
21192,
21203,
21196,
21207,
21194,
21205,
21410,
21421,
21416,
21427,
21418,
21429,
21413,
21424,
21175,
21179,
21177,
21181,
21178,
21182,
-1,
-1,
21395,
21399,
21397,
21401,
21398,
21402,
-1,
-1,
21147,
21158,
21149,
21160,
21153,
21164,
21151,
21162,
21369,
21380,
21375,
21386,
21377,
21388,
21372,
21383,
21264,
21258,
21266,
21260,
21268,
21262,
21267,
21261,
21447,
21441,
21449,
21443,
21451,
21445,
21450,
21444,
21132,
21136,
21134,
21138,
21135,
21139,
-1,
-1,
21354,
21358,
21356,
21360,
21357,
21361,
-1,
-1,
21237,
21231,
21239,
21233,
21241,
21235,
21240,
21234,
-1,
21461,
-1,
21463,
-1,
21465,
-1,
21464,
21104,
21115,
21106,
21117,
21110,
21121,
21108,
21119,
21328,
21339,
21334,
21345,
21336,
21347,
21331,
21342,
21211,
21214,
21183,
21185,
21167,
21169,
21272,
21274,
21140,
21142,
21245,
21247,
21124,
21126,
-1,
-1,
21198,
21209,
21193,
21204,
21197,
21208,
21195,
21206,
21415,
21426,
21417,
21428,
21419,
21430,
21414,
21425,
21155,
21166,
21150,
21161,
21154,
21165,
21152,
21163,
21374,
21385,
21376,
21387,
21378,
21389,
21373,
21384,
21112,
21123,
21107,
21118,
21111,
21122,
21109,
21120,
21333,
21344,
21335,
21346,
21337,
21348,
21332,
21343,
21213,
21218,
21212,
21216,
21215,
-1,
21199,
21200,
21432,
21436,
21433,
21435,
21420,
21728,
21713,
21708,
21716,
21686,
21168,
21171,
21170,
-1,
21156,
21157,
21403,
21405,
21390,
21392,
21379,
21710,
21712,
21711,
21271,
21275,
21254,
21257,
-1,
-1,
21269,
21256,
21453,
21457,
21454,
21456,
-1,
21691,
21693,
21692,
21244,
21248,
21227,
21230,
21290,
21291,
21242,
21229,
21468,
21472,
21469,
21471,
21486,
21685,
21687,
21660,
-1,
-1,
21125,
21128,
21127,
-1,
21113,
21114,
21362,
21364,
21349,
21351,
21338,
21720,
21689,
-1,
11988,
11959,
11987,
11958,
18287,
27350,
19531,
27363,
26476,
18298,
20593,
27907,
27905,
27908,
9859,
25627,
21084,
26795,
27364,
11989,
11960,
21071,
24267,
24256,
9652,
25450,
19513,
19516,
9732,
25487,
24255,
24291,
24863,
24286,
16867,
18337,
25430,
18403,
21074,
21088,
9470,
26151,
9860,
25628,
26475,
9858,
25626,
26845,
26449,
26447,
26417,
24270,
18308,
25859,
25852,
25850,
3397,
19514,
19515,
25897,
24292,
27109,
25431,
27549,
5171,
3398,
13997,
21087,
27382,
9647,
25445,
24289,
27878,
11929,
17813,
25860,
16714,
16734,
10102,
25856,
5189,
18413,
3788,
19802,
27130,
27371,
18279,
27871,
27344,
27360,
18402,
27345,
24384,
18338,
24061,
7718,
27718,
27336,
27140,
27141,
27142,
-1,
-1,
-1,
-1,
-1,
27153,
14006,
27154,
14007,
26844,
26796,
19327,
19313,
-1,
-1,
19322,
19323,
19319,
19320,
19326,
19331,
19329,
19332,
19325,
19314,
19328,
19312,
19347,
19350,
19336,
19337,
19342,
19343,
19339,
19340,
19346,
19351,
19349,
19352,
19345,
19353,
19348,
-1,
8489,
8488,
8485,
8480,
8483,
]

_charnames_8352 = [
11995,
4035,
5221,
27384,
9634,
7771,
26847,
26459,
25795,
27719,
26589,
24410,
11996,
23380,
18397,
24867,
22188,
26458,
22015,
14016,
21092,
5210,
9633,
19794,
18069,
]

_charnames_8400 = [
3544,
3642,
3557,
3722,
3687,
3484,
3536,
3637,
3646,
3483,
3686,
3734,
3782,
3711,
3709,
3715,
3712,
3547,
3710,
3714,
3713,
3652,
3570,
3688,
3733,
3784,
3551,
3558,
3644,
3550,
3535,
3636,
3691,
]

_charnames_8448 = [
14008,
14015,
24305,
24711,
5206,
3399,
3404,
11997,
19740,
24710,
19738,
19731,
16797,
24303,
26441,
26442,
19730,
16796,
19729,
19737,
10151,
24302,
26842,
19715,
19727,
24297,
24301,
19726,
16795,
24300,
26391,
25893,
19756,
17946,
18341,
24066,
24299,
25422,
25432,
27132,
16794,
18394,
23378,
13975,
19734,
16798,
12004,
19739,
19733,
19732,
18395,
19728,
19736,
13992,
16663,
22353,
24862,
27146,
25953,
27392,
24314,
24315,
24304,
24298,
24316,
18387,
18386,
25857,
18385,
24312,
24311,
24310,
24309,
24308,
26413,
18391,
26448,
14019,
18388,
18975,
24076,
24078,
24073,
24072,
24088,
24080,
24089,
24085,
24094,
24075,
24092,
24081,
24086,
24093,
24096,
27383,
25919,
25914,
25918,
25911,
25903,
25926,
25928,
25931,
25933,
25916,
25930,
25915,
25907,
25923,
25906,
25921,
19632,
19622,
19624,
19631,
19628,
19637,
19638,
19641,
19642,
19625,
19640,
19623,
19630,
19635,
19629,
19634,
25922,
25905,
25917,
25932,
8132,
25927,
25910,
25909,
25924,
24095,
-1,
-1,
-1,
-1,
-1,
-1,
9761,
27402,
25529,
24334,
9661,
27451,
26721,
26750,
19698,
19708,
9776,
25544,
9850,
25619,
9833,
27441,
25601,
24362,
9765,
25533,
9796,
27412,
25564,
24345,
27452,
9779,
25547,
9778,
25546,
9674,
9665,
24367,
27407,
27406,
24339,
24338,
25548,
24342,
13966,
5194,
26724,
9783,
13967,
5195,
9811,
9818,
27427,
27422,
25579,
25586,
24360,
24355,
25566,
27411,
9798,
9853,
27447,
25622,
24370,
9819,
25587,
9843,
9671,
25611,
9839,
27444,
25607,
24365,
9668,
27454,
26731,
26759,
19705,
19713,
9836,
25604,
9851,
25620,
27409,
24341,
9847,
27445,
25615,
24366,
9782,
25556,
9849,
27429,
25617,
24368,
27435,
27431,
27434,
27433,
27436,
27437,
25618,
26725,
19701,
27453,
25468,
24344,
18281,
9775,
25543,
9664,
9773,
25541,
9666,
9854,
25623,
9675,
27357,
3793,
26155,
18291,
18292,
11950,
27149,
26848,
11933,
26770,
19649,
4027,
24404,
19661,
11992,
26820,
26805,
26814,
7757,
7766,
24392,
24844,
19755,
13996,
25641,
16868,
18605,
2537,
27349,
26412,
27144,
25456,
13971,
7721,
19787,
24847,
24407,
26148,
26785,
10139,
10128,
27093,
27536,
27112,
24283,
18318,
4028,
19394,
24101,
5196,
5192,
13964,
18293,
16668,
25964,
26411,
24394,
11931,
22182,
21081,
17795,
25848,
27133,
19517,
27722,
26779,
7765,
13998,
26769,
13806,
13809,
26638,
13981,
26771,
13983,
18316,
13988,
11910,
22180,
24855,
13810,
22181,
13807,
27198,
4036,
11897,
25642,
25643,
4037,
12003,
11911,
19764,
24715,
11905,
7738,
27879,
26784,
27008,
26787,
19770,
9981,
21763,
9984,
21768,
10006,
21789,
7363,
7364,
16662,
26783,
26786,
26788,
26627,
26632,
9980,
21762,
26626,
26631,
9982,
21764,
26628,
26633,
26392,
19374,
26405,
19387,
26404,
19386,
24398,
24405,
19355,
19286,
26768,
26767,
19362,
19293,
26637,
26636,
19364,
19295,
7357,
7360,
7359,
18666,
18689,
18669,
18692,
18614,
18616,
4912,
4928,
4922,
4906,
4908,
4924,
4933,
4938,
4909,
18780,
18783,
18790,
18793,
25504,
9717,
24373,
27467,
13999,
6801,
18342,
27356,
18304,
24264,
24400,
26778,
24409,
26622,
26406,
19388,
26761,
4025,
26762,
4026,
25287,
27197,
7361,
20951,
27111,
27910,
26846,
26717,
25460,
25500,
26817,
26816,
26821,
26806,
24830,
24393,
19762,
24846,
16529,
9757,
25526,
9656,
25453,
25849,
2531,
2532,
24246,
24244,
24282,
24280,
26463,
11906,
10000,
21784,
24064,
24065,
10008,
21794,
11903,
11904,
11902,
11901,
24399,
24406,
26775,
26774,
18668,
18691,
10005,
21788,
26407,
19389,
26780,
24402,
26781,
24403,
24062,
7769,
27469,
24375,
11940,
11936,
19651,
11941,
11939,
19652,
11937,
11938,
4023,
4021,
19659,
4022,
19660,
27902,
24831,
11947,
21076,
27464,
24377,
26414,
26451,
27705,
9696,
25497,
9750,
25520,
16514,
16519,
18347,
18352,
25865,
18698,
13702,
19757,
19752,
17947,
26473,
24099,
26443,
18393,
27713,
21077,
18353,
18348,
16520,
16515,
18362,
16526,
27379,
19693,
27465,
25399,
11972,
27911,
23377,
9864,
25632,
11973,
16659,
4573,
13989,
19018,
18380,
24854,
4031,
19785,
4016,
4015,
13784,
13778,
13732,
13713,
13714,
13730,
13725,
13758,
13761,
13779,
13802,
13726,
13733,
13721,
13731,
13791,
13786,
13722,
13727,
13763,
13741,
13753,
13711,
13716,
13742,
13773,
13718,
13768,
13749,
13719,
13715,
13769,
13745,
13710,
13735,
13752,
13754,
13794,
13760,
13771,
13736,
13759,
13724,
13770,
13750,
13777,
13795,
13762,
13743,
13792,
13799,
13800,
13764,
13748,
13798,
13776,
13780,
13729,
13728,
13744,
13772,
13782,
13787,
13788,
13797,
13801,
13783,
13789,
13796,
26789,
25459,
19611,
16667,
24043,
27090,
4029,
24850,
11956,
3792,
27576,
11991,
13985,
20950,
4887,
4921,
15580,
27548,
7005,
21091,
25397,
25396,
26160,
26159,
24853,
19719,
13706,
24713,
26408,
26639,
26416,
5199,
9738,
9740,
9739,
25507,
25509,
25508,
9648,
9650,
9649,
25446,
25448,
25447,
9691,
9692,
9693,
2533,
25493,
25494,
25495,
27126,
21073,
27482,
27477,
19392,
19393,
18360,
16522,
16523,
25963,
9752,
25511,
21068,
21067,
21066,
21065,
24689,
24692,
24697,
24707,
24702,
24696,
24706,
24701,
24694,
24705,
24700,
24703,
24698,
24690,
24693,
18712,
25894,
12005,
24044,
7751,
7748,
7749,
7747,
7742,
7743,
7744,
7745,
7750,
12000,
27337,
18361,
16525,
18363,
16527,
18359,
16524,
27681,
16660,
19772,
27374,
14009,
11946,
24714,
]

_charnames_9216 = [
19001,
18969,
18968,
18993,
18991,
18995,
19017,
19009,
19010,
19015,
19014,
19011,
19003,
19006,
18971,
18972,
18986,
18982,
18980,
18981,
18983,
19000,
18973,
18992,
19007,
18994,
18965,
18996,
19004,
19016,
19013,
19012,
18974,
18984,
16803,
25393,
18999,
18985,
18966,
]

_charnames_9280 = [
25413,
25411,
25414,
25412,
25405,
25404,
25403,
25415,
25408,
25410,
25407,
]

_charnames_9312 = [
4902,
4893,
4894,
4899,
4900,
4896,
4897,
4904,
4903,
4752,
4788,
4733,
4751,
4772,
4776,
4780,
4783,
4787,
4789,
4717,
26137,
26129,
26130,
26135,
26136,
26132,
26133,
26139,
26138,
26116,
26124,
26114,
26115,
26121,
26122,
26118,
26119,
26125,
26126,
26113,
24752,
24722,
24726,
24740,
24744,
24731,
24735,
24760,
24756,
26829,
26839,
26827,
26828,
26836,
26837,
26832,
26834,
26840,
26841,
26826,
25996,
25995,
25994,
25993,
25992,
25991,
25990,
25989,
25988,
25987,
25986,
25985,
25984,
25983,
25982,
25981,
25980,
25979,
25978,
25977,
25976,
25975,
25974,
25973,
25972,
25971,
4712,
4711,
4710,
4709,
4708,
4707,
4706,
4705,
4704,
4703,
4702,
4701,
4700,
4699,
4698,
4697,
4696,
4695,
4694,
4693,
4692,
4691,
4690,
4689,
4688,
4687,
4685,
4684,
4683,
4682,
4681,
4680,
4679,
4678,
4677,
4676,
4675,
4674,
4673,
4672,
4671,
4670,
4669,
4668,
4667,
4666,
4665,
4664,
4663,
4662,
4661,
4660,
4901,
26606,
26597,
26598,
26603,
26604,
26600,
26601,
26607,
26608,
26596,
24237,
24229,
24230,
24235,
24236,
24232,
24233,
24239,
24238,
24240,
26612,
16300,
16386,
16279,
16372,
16293,
16379,
16292,
16378,
16296,
16382,
16295,
16381,
16261,
16317,
16326,
16359,
16262,
16320,
16329,
16360,
16277,
16390,
16399,
16370,
16278,
16393,
16402,
16369,
16281,
16420,
16400,
16325,
16424,
16316,
16391,
16374,
16282,
16421,
16403,
16328,
16425,
16319,
16394,
16375,
16263,
16309,
16439,
16322,
16331,
16435,
16305,
16361,
16275,
16308,
16438,
16395,
16404,
16434,
16304,
16371,
16283,
16307,
16437,
16422,
16405,
16330,
16426,
16310,
16440,
16311,
16441,
16321,
16396,
16433,
16303,
16376,
16266,
16364,
16265,
16363,
16354,
16341,
16333,
16337,
16351,
16334,
16338,
16352,
16407,
16411,
16347,
16408,
16412,
16348,
16416,
16428,
16343,
16417,
16429,
16344,
16335,
16339,
16353,
16409,
16413,
16349,
16418,
16430,
16345,
16289,
16290,
16287,
16286,
16269,
16270,
16271,
16297,
16272,
16299,
16259,
16383,
16365,
16385,
16357,
16298,
16276,
16384,
16368,
27487,
10095,
10094,
10092,
10089,
10097,
10091,
10096,
27333,
9655,
9714,
9748,
9755,
9715,
9743,
9744,
25517,
9629,
7712,
24861,
27488,
25515,
27869,
27868,
27856,
27863,
27862,
27860,
27859,
27864,
27865,
27866,
16700,
27561,
27573,
27577,
18550,
18546,
18549,
18539,
18536,
18551,
16694,
27582,
16736,
27641,
16775,
27668,
16789,
27693,
16755,
27674,
16756,
27676,
16729,
27638,
16730,
27639,
16727,
27636,
16747,
27626,
16748,
27627,
16708,
27645,
16709,
27646,
16710,
27647,
16738,
27618,
27623,
27365,
10149,
27592,
24385,
4951,
16869,
16681,
4950,
4953,
4949,
4944,
4943,
4955,
9756,
25518,
27138,
27137,
27485,
10087,
27481,
27475,
10078,
10085,
27486,
10088,
16717,
16718,
16753,
16752,
27695,
18545,
18548,
18540,
18543,
27575,
27675,
27492,
27491,
9197,
27571,
27567,
27566,
27570,
27596,
27599,
27598,
27595,
27480,
27473,
10083,
27655,
16761,
27656,
16762,
10077,
16698,
5198,
27551,
19796,
3794,
16699,
27586,
9632,
18296,
19211,
14000,
24684,
4030,
25400,
16781,
27683,
16129,
16132,
16131,
19207,
27553,
21080,
27588,
16703,
19600,
25863,
16712,
16735,
27649,
27677,
27640,
27628,
19800,
3405,
25962,
16874,
3403,
13976,
25291,
5175,
5218,
5219,
19765,
27391,
14014,
20591,
26461,
15317,
18327,
18326,
18328,
18324,
18322,
18323,
18325,
18329,
27699,
27664,
27584,
16697,
27585,
27366,
9200,
7752,
27396,
11999,
6448,
27848,
19206,
27555,
26641,
26439,
13701,
17440,
22189,
3342,
10009,
24098,
9635,
19741,
19209,
3407,
14018,
26465,
27607,
27609,
27608,
27611,
27606,
27610,
16676,
16678,
16677,
16680,
16675,
16679,
16701,
27690,
27621,
16687,
27587,
16772,
16741,
27616,
21079,
27874,
11984,
16666,
16665,
7343,
7342,
7341,
27724,
12001,
27546,
25886,
25885,
25884,
25883,
25882,
25881,
25880,
25887,
16757,
25888,
26154,
26455,
27698,
24839,
24838,
24837,
24836,
24835,
24834,
27602,
27603,
16683,
16684,
7003,
7002,
24775,
24768,
24769,
24774,
27661,
16785,
20592,
13978,
5215,
19768,
19742,
13991,
27370,
22183,
19767,
14017,
27376,
25418,
18275,
18276,
27714,
21061,
24330,
24329,
27108,
6449,
6446,
6447,
24059,
21072,
7716,
7719,
7711,
6525,
24848,
27550,
4038,
27335,
26640,
5211,
26163,
27849,
24067,
5174,
16765,
19754,
19745,
27881,
19749,
19721,
16251,
18785,
27630,
27631,
16744,
16745,
19797,
19283,
25960,
16702,
18297,
18392,
18396,
27622,
5220,
24851,
-1,
26468,
3401,
20949,
4930,
5172,
26798,
13986,
16779,
27682,
16713,
27650,
24868,
20928,
9695,
18771,
27390,
16780,
25892,
25891,
-1,
20874,
-1,
-1,
-1,
-1,
16686,
19613,
5176,
3406,
21060,
22185,
22186,
6526,
7006,
27554,
27351,
27375,
27397,
19208,
18711,
19801,
27199,
26452,
18068,
27846,
20947,
27338,
2536,
27662,
-1,
27489,
16704,
10098,
27590,
-1,
17948,
17441,
14020,
11990,
-1,
-1,
24100,
27721,
10079,
26460,
27476,
27694,
16790,
5060,
20879,
7356,
20942,
16133,
20892,
25420,
20944,
25387,
20933,
9018,
19598,
25419,
6450,
19763,
27346,
27348,
20945,
27347,
16786,
27665,
-1,
19771,
4917,
25388,
16688,
25421,
20932,
26466,
19597,
20946,
25389,
11983,
11980,
11979,
19528,
11978,
20925,
18414,
19530,
18071,
25386,
20897,
19529,
16784,
27663,
11981,
4936,
20896,
19798,
17814,
20878,
19792,
20904,
16134,
11982,
20924,
-1,
19599,
-1,
10080,
27478,
10075,
27474,
-1,
-1,
-1,
16742,
20921,
9628,
7717,
20939,
20902,
20903,
20936,
20937,
-1,
-1,
2534,
20922,
20943,
20891,
25951,
27372,
25952,
7707,
7702,
7715,
7714,
7709,
7704,
20915,
20909,
20916,
20910,
9631,
9630,
7708,
7703,
24803,
24795,
24796,
24801,
24802,
24798,
24799,
24805,
24804,
24806,
24818,
24810,
24811,
24816,
24817,
24813,
24814,
24820,
24819,
24821,
24789,
24781,
24782,
24787,
24788,
24784,
24785,
24791,
24790,
24792,
20927,
-1,
-1,
-1,
20905,
20911,
20941,
24866,
20912,
18336,
20899,
24858,
20938,
16732,
18285,
18286,
16733,
20890,
20889,
18795,
20880,
25635,
9867,
16252,
27380,
20917,
20940,
26792,
-1,
26791,
4888,
27696,
16800,
16801,
16802,
20884,
20885,
20886,
18072,
20898,
27725,
20929,
25398,
-1,
18280,
27680,
26453,
25392,
25391,
9658,
25454,
25292,
25872,
19308,
24053,
-1,
10125,
-1,
-1,
-1,
27620,
13977,
11943,
10081,
27483,
9745,
25514,
27332,
9194,
9196,
9703,
9702,
9758,
10123,
10115,
27468,
10150,
27612,
27615,
27614,
27568,
27574,
6308,
6301,
6311,
6304,
6310,
6303,
6307,
6300,
6309,
6302,
27446,
24369,
13969,
5197,
25469,
10108,
10120,
10114,
10106,
10118,
10113,
10109,
10121,
10107,
10119,
10122,
15578,
15323,
15451,
15324,
15515,
15388,
15452,
15325,
15547,
15420,
15484,
15357,
15516,
15389,
15453,
15326,
15563,
15436,
15500,
15373,
15532,
15405,
15469,
15342,
15548,
15421,
15485,
15358,
15517,
15390,
15454,
15327,
15571,
15444,
15508,
15381,
15540,
15413,
15477,
15350,
15556,
15429,
15493,
15366,
15525,
15398,
15462,
15335,
15564,
15437,
15501,
15374,
15533,
15406,
15470,
15343,
15549,
15422,
15486,
15359,
15518,
15391,
15455,
15328,
15575,
15448,
15512,
15385,
15544,
15417,
15481,
15354,
15560,
15433,
15497,
15370,
15529,
15402,
15466,
15339,
15568,
15441,
15505,
15378,
15537,
15410,
15474,
15347,
15553,
15426,
15490,
15363,
15522,
15395,
15459,
15332,
15572,
15445,
15509,
15382,
15541,
15414,
15478,
15351,
15557,
15430,
15494,
15367,
15526,
15399,
15463,
15336,
15565,
15438,
15502,
15375,
15534,
15407,
15471,
15344,
15550,
15423,
15487,
15360,
15519,
15392,
15456,
15329,
15577,
15450,
15514,
15387,
15546,
15419,
15483,
15356,
15562,
15435,
15499,
15372,
15531,
15404,
15468,
15341,
15570,
15443,
15507,
15380,
15539,
15412,
15476,
15349,
15555,
15428,
15492,
15365,
15524,
15397,
15461,
15334,
15574,
15447,
15511,
15384,
15543,
15416,
15480,
15353,
15559,
15432,
15496,
15369,
15528,
15401,
15465,
15338,
15567,
15440,
15504,
15377,
15536,
15409,
15473,
15346,
15552,
15425,
15489,
15362,
15521,
15394,
15458,
15331,
15576,
15449,
15513,
15386,
15545,
15418,
15482,
15355,
15561,
15434,
15498,
15371,
15530,
15403,
15467,
15340,
15569,
15442,
15506,
15379,
15538,
15411,
15475,
15348,
15554,
15427,
15491,
15364,
15523,
15396,
15460,
15333,
15573,
15446,
15510,
15383,
15542,
15415,
15479,
15352,
15558,
15431,
15495,
15368,
15527,
15400,
15464,
15337,
15566,
15439,
15503,
15376,
15535,
15408,
15472,
15345,
15551,
15424,
15488,
15361,
15520,
15393,
15457,
15330,
25597,
25598,
9842,
25610,
9670,
25599,
9844,
25612,
24340,
27408,
27442,
24363,
9846,
25614,
9835,
25603,
25600,
25542,
27410,
24343,
25535,
25536,
25593,
25595,
25596,
9799,
25567,
9845,
25613,
9784,
25555,
9797,
25565,
26729,
26757,
26726,
26755,
19700,
19710,
26728,
26756,
19703,
19711,
25647,
27388,
19702,
26753,
27389,
25646,
26754,
26727,
27710,
13696,
13697,
13700,
13699,
25634,
9866,
18356,
16528,
18358,
18357,
10076,
10084,
13965,
5193,
25562,
9794,
19609,
25545,
9777,
25551,
9667,
27440,
9722,
9724,
27459,
27461,
9721,
27458,
9725,
27462,
9809,
25577,
27425,
24358,
9814,
25582,
27420,
24353,
9810,
25578,
27426,
24359,
9815,
25583,
27421,
24354,
9807,
27418,
25576,
24352,
9808,
9817,
25575,
25585,
9806,
9816,
25574,
25584,
27419,
24351,
25484,
11887,
17801,
9793,
25561,
25563,
9992,
9788,
21776,
19373,
9787,
19304,
9749,
25521,
27470,
24376,
18305,
27890,
27900,
9681,
25474,
9685,
25478,
27898,
27893,
27899,
27894,
9646,
25444,
9644,
25443,
9645,
25442,
9700,
25462,
9708,
25470,
24260,
24288,
9727,
25523,
24390,
24057,
7736,
25463,
7737,
13974,
14003,
19790,
19789,
18390,
25861,
13973,
25862,
25425,
25426,
7725,
7726,
7734,
7735,
7728,
7731,
7729,
7732,
25867,
11954,
11952,
11953,
11955,
4954,
4935,
4914,
4925,
4913,
4956,
4946,
4934,
27466,
4918,
4939,
4713,
4937,
4947,
4952,
18791,
18789,
18794,
18769,
18768,
18411,
18335,
18333,
19803,
18334,
25501,
9711,
24056,
16532,
16531,
16791,
17812,
17811,
27686,
16768,
9687,
25480,
9731,
25486,
27151,
17815,
27145,
24327,
18552,
27150,
19612,
11890,
11891,
27009,
22318,
18294,
24380,
24379,
16740,
16719,
27601,
16685,
11964,
11968,
11965,
11969,
11966,
11970,
25796,
25873,
19717,
25871,
16872,
16873,
24273,
18309,
9863,
25631,
17808,
7767,
26804,
26803,
26802,
26809,
26808,
26813,
26812,
18407,
18406,
26819,
6800,
19391,
27872,
27367,
27122,
27124,
4959,
13968,
9468,
9467,
9469,
27125,
27873,
27120,
27118,
27121,
27116,
27119,
27117,
27850,
9195,
27889,
27888,
27887,
26429,
26431,
26426,
26430,
26425,
26428,
26432,
7763,
7762,
7761,
7760,
26436,
26435,
24068,
7355,
7354,
19746,
19692,
7351,
7350,
4927,
7352,
4907,
26434,
7764,
7349,
27110,
25638,
27895,
14012,
27098,
27540,
27539,
27096,
27097,
27541,
27543,
27100,
27544,
27101,
27545,
27102,
5186,
5188,
24249,
24248,
5187,
10145,
10135,
24259,
24258,
18410,
18409,
19783,
19784,
10138,
10147,
10136,
10148,
10137,
10144,
10146,
10143,
19681,
10134,
10133,
27901,
27896,
11894,
27010,
18315,
18314,
17799,
17798,
19525,
4032,
11896,
13982,
13808,
11888,
26437,
11886,
24241,
18412,
18282,
11893,
11909,
10001,
21785,
9999,
21783,
9974,
21756,
9978,
21760,
9976,
21758,
9977,
21759,
9983,
21765,
9996,
21780,
9997,
21781,
9994,
21778,
9989,
21773,
9990,
21774,
9993,
21777,
9991,
21775,
19776,
19778,
19777,
19779,
24325,
24326,
24320,
24321,
19520,
19521,
19523,
19524,
24275,
24277,
24276,
21767,
21790,
10002,
21791,
10003,
21792,
19690,
9198,
19691,
9199,
11895,
26397,
19379,
26396,
19378,
26401,
19383,
26399,
19381,
26402,
19384,
26400,
19382,
24272,
24245,
19368,
19299,
19366,
19297,
19367,
19298,
19363,
19294,
19360,
19291,
19358,
19289,
19361,
19292,
19359,
19290,
18703,
18595,
5184,
5182,
5185,
5183,
19371,
19303,
19372,
19302,
19306,
19307,
11944,
26464,
18340,
27354,
26794,
19610,
19607,
19603,
26454,
24054,
24266,
24055,
24265,
10126,
19608,
19605,
19606,
24285,
24279,
24250,
25854,
24408,
24042,
24041,
24374,
26147,
26146,
18306,
18303,
18319,
18311,
18312,
24322,
24323,
18317,
9190,
24251,
27670,
26818,
26758,
26730,
19704,
19712,
9673,
9855,
27448,
24371,
26760,
26732,
19706,
19714,
9676,
27455,
25539,
25538,
9771,
9770,
18547,
18553,
18537,
18544,
24828,
24827,
24826,
24829,
24387,
16721,
27651,
16777,
27671,
16788,
27692,
27689,
16771,
21070,
16722,
16764,
27658,
16763,
27657,
16696,
16695,
27583,
16769,
27687,
16776,
27669,
9706,
18277,
9707,
10110,
9829,
9830,
9831,
9832,
9774,
9767,
9768,
9825,
9827,
9828,
9786,
27711,
11889,
25876,
9792,
25553,
25552,
9852,
25621,
25875,
25560,
17802,
9795,
9791,
25559,
-1,
-1,
-1,
27654,
16693,
27581,
16728,
27637,
20918,
20931,
20875,
20872,
20876,
]

_charnames_11264 = [
22317,
22306,
22308,
22315,
22288,
22270,
22291,
22287,
22292,
22277,
22281,
22274,
22289,
22313,
22300,
22312,
22311,
22298,
22294,
22310,
22264,
22283,
22309,
22303,
22314,
22297,
22295,
22258,
22284,
22316,
22260,
22268,
22269,
22273,
22263,
22271,
22261,
22262,
22272,
22279,
22307,
22280,
22304,
22276,
22259,
22285,
22301,
-1,
22254,
22243,
22245,
22252,
22225,
22207,
22228,
22224,
22229,
22214,
22218,
22211,
22226,
22250,
22237,
22249,
22248,
22235,
22231,
22247,
22201,
22220,
22246,
22240,
22251,
22234,
22232,
22195,
22221,
22253,
22197,
22205,
22206,
22210,
22200,
22208,
22198,
22199,
22209,
22216,
22244,
22217,
22241,
22213,
22196,
22222,
22238,
-1,
8803,
8149,
8812,
8972,
8788,
8001,
7823,
8879,
8271,
8938,
8347,
8923,
8310,
8600,
8994,
8710,
8711,
8393,
8954,
8434,
8396,
8888,
8283,
7847,
7939,
7785,
7889,
9034,
8486,
6644,
8771,
8925,
3961,
3869,
3964,
3872,
3956,
3864,
3921,
3829,
3970,
3878,
3926,
3834,
3963,
3871,
3953,
3861,
3943,
3851,
3969,
3877,
3941,
3849,
3949,
3857,
3968,
3876,
3967,
3875,
3940,
3848,
3891,
3799,
3947,
3855,
3966,
3874,
3927,
3835,
3944,
3852,
3965,
3873,
3958,
3866,
3938,
3846,
3946,
3854,
3913,
3821,
3919,
3827,
3906,
3814,
3934,
3842,
3917,
3825,
3916,
3824,
3932,
3840,
3902,
3810,
3928,
3836,
3935,
3843,
3901,
3809,
3904,
3812,
3962,
3870,
3918,
3826,
3897,
3805,
3895,
3803,
3950,
3858,
3898,
3806,
3896,
3804,
3903,
3811,
3905,
3813,
3900,
3808,
3912,
3820,
3910,
3818,
3909,
3817,
3911,
3819,
3885,
3888,
3887,
3881,
3886,
3884,
3882,
3931,
3839,
3933,
3841,
3975,
3974,
3973,
]

_charnames_11513 = [
3979,
3980,
3978,
3977,
3983,
3982,
3984,
22126,
22125,
22111,
22124,
22123,
22114,
22093,
22096,
22122,
22105,
22121,
22120,
22119,
22118,
22102,
22092,
22116,
22099,
22095,
22115,
22101,
22104,
22110,
22117,
22098,
22087,
22090,
22107,
22089,
22088,
22112,
22108,
22081,
22084,
22083,
22113,
22080,
22082,
]

_charnames_11568 = [
17733,
17757,
17758,
17750,
17752,
17787,
17767,
17734,
17737,
17735,
17736,
17773,
17768,
17747,
17776,
17749,
17755,
17788,
17784,
17756,
17770,
17748,
17777,
17762,
17782,
17772,
17740,
17791,
17781,
17766,
17765,
17764,
17779,
17783,
17763,
17771,
17753,
17754,
17751,
17780,
17790,
17744,
17745,
17746,
17741,
17743,
17769,
17742,
17761,
17760,
17759,
17738,
17785,
17739,
]

_charnames_11648 = [
11779,
11730,
11768,
11429,
11396,
11759,
11465,
11575,
11677,
11668,
11363,
11634,
11697,
11688,
11789,
11438,
11566,
11596,
11608,
11351,
11353,
11350,
11349,
]

_charnames_11680 = [
11416,
11418,
11420,
11417,
11415,
11414,
11419,
-1,
11559,
11561,
11563,
11560,
11558,
11557,
11562,
-1,
11628,
11630,
11632,
11629,
11627,
11626,
11631,
-1,
11552,
11554,
11556,
11553,
11551,
11550,
11555,
-1,
11491,
11493,
11495,
11492,
11490,
11489,
11494,
-1,
11528,
11530,
11532,
11529,
11527,
11526,
11531,
-1,
11646,
11648,
11650,
11647,
11645,
11644,
11649,
-1,
11374,
11376,
11378,
11375,
11373,
11372,
11377,
-1,
3443,
3444,
3451,
3440,
3427,
3428,
3449,
3420,
3419,
3418,
3446,
3445,
3417,
3415,
3434,
3450,
3433,
3453,
3437,
3436,
3452,
3416,
3454,
3425,
3439,
3447,
3431,
3430,
3424,
3448,
3442,
3423,
25464,
25465,
9657,
25452,
9735,
25489,
25958,
25959,
24386,
9712,
25502,
25957,
9677,
25525,
12006,
26150,
27355,
25866,
21090,
24389,
24346,
27413,
24388,
24290,
27134,
26162,
21086,
17807,
9759,
25527,
17806,
17805,
9753,
25512,
18354,
18349,
16521,
16516,
9653,
25451,
9733,
25488,
18404,
25429,
18788,
27361,
25864,
24058,
25640,
27717,
]

_charnames_11904 = [
1232,
1119,
1141,
1139,
1140,
1250,
1169,
1226,
1257,
1256,
1253,
1142,
1153,
1152,
1193,
1191,
1192,
1194,
1147,
1225,
1146,
1145,
1210,
1209,
1213,
1229,
-1,
1124,
1154,
1163,
1254,
1161,
1121,
1181,
1180,
1260,
1249,
1248,
1133,
1123,
1252,
1205,
1171,
1220,
1150,
1149,
1176,
1135,
1091,
1237,
1235,
1236,
1238,
1165,
1155,
1230,
1221,
1261,
1174,
1173,
1166,
1162,
1244,
1242,
1243,
1224,
1118,
1187,
1186,
1093,
1132,
1212,
1090,
1092,
1259,
1115,
1130,
1184,
1183,
1122,
1107,
1197,
1196,
1104,
1108,
1160,
1159,
1231,
1175,
1098,
1105,
1112,
1101,
1219,
1217,
1218,
1111,
1211,
1113,
1170,
1245,
1102,
1116,
1094,
1129,
1134,
1100,
1203,
1110,
1202,
1097,
1204,
1114,
1223,
1201,
1096,
]

_charnames_12032 = [
22634,
22563,
22413,
22392,
22387,
22582,
22467,
22565,
22554,
22560,
22597,
22601,
22417,
22501,
22653,
22466,
22633,
22662,
22627,
22524,
22373,
22605,
22588,
22478,
22426,
22388,
22510,
22626,
22643,
22543,
22598,
22592,
22403,
22615,
22617,
22595,
22453,
22527,
22516,
22612,
22652,
22409,
22569,
22502,
22372,
22541,
22604,
22526,
22635,
22471,
22429,
22378,
22416,
22567,
22468,
22380,
22437,
22408,
22444,
22365,
22585,
22575,
22419,
22576,
22445,
22609,
22402,
22427,
22641,
22406,
22646,
22405,
22395,
22547,
22461,
22570,
22361,
22434,
22536,
22421,
22503,
22495,
22508,
22366,
22521,
22482,
22507,
22486,
22418,
22574,
22393,
22487,
22500,
22420,
22625,
22659,
22552,
22476,
22404,
22564,
22661,
22484,
22439,
22400,
22415,
22532,
22410,
22425,
22599,
22371,
22639,
22363,
22374,
22462,
22620,
22512,
22367,
22455,
22606,
22399,
22658,
22648,
22383,
22497,
22636,
22642,
22628,
22591,
22443,
22553,
22549,
22385,
22640,
22545,
22474,
22632,
22441,
22362,
22504,
22619,
22477,
22651,
22448,
22520,
22509,
22535,
22386,
22581,
22370,
22656,
22457,
22629,
22456,
22382,
22613,
22611,
22496,
22440,
22514,
22451,
22546,
22519,
22515,
22529,
22424,
22655,
22616,
22566,
22622,
22542,
22391,
22379,
22610,
22447,
22523,
22488,
22558,
22464,
22561,
22407,
22559,
22530,
22493,
22593,
22586,
22491,
22580,
22438,
22465,
22577,
22483,
22397,
22513,
22621,
22481,
22452,
22396,
22433,
22533,
22587,
22660,
22550,
22449,
22600,
22490,
22460,
22430,
22608,
22647,
22594,
22473,
22431,
22470,
22494,
]

_charnames_12272 = [
26987,
26991,
26988,
26990,
26993,
26985,
26984,
26983,
26980,
26979,
26982,
26992,
-1,
-1,
-1,
-1,
26999,
26996,
27005,
24852,
27845,
27003,
26997,
27001,
9699,
25461,
9734,
25485,
9694,
25496,
9682,
25475,
9728,
25524,
26471,
22187,
9716,
25503,
9686,
25479,
9683,
25476,
9684,
25477,
27712,
25853,
24271,
10101,
26472,
20410,
20398,
20401,
20408,
20409,
20405,
20406,
20412,
20411,
27002,
27000,
26994,
27006,
20392,
20394,
27707,
24046,
24050,
24048,
24051,
24049,
4911,
26952,
20403,
20399,
20402,
24060,
6523,
26157,
26998,
27004,
-1,
20970,
21056,
20968,
21054,
20965,
21052,
20969,
21055,
20967,
21053,
21017,
21029,
21015,
21027,
21013,
21025,
21016,
21028,
21014,
21026,
20975,
20987,
20973,
20985,
20971,
20983,
20974,
20986,
20972,
20984,
20993,
21035,
20991,
21033,
20966,
20989,
21031,
20992,
21034,
20990,
21032,
20981,
20979,
20977,
20980,
20978,
21023,
21041,
21005,
21021,
21039,
21003,
21019,
21037,
21001,
21022,
21040,
21004,
21020,
21038,
21002,
21011,
21009,
21007,
21010,
21008,
20960,
21050,
20958,
21048,
20959,
21049,
20999,
20997,
20995,
20998,
20996,
20964,
21046,
21044,
21045,
21043,
20976,
21051,
20963,
20962,
-1,
-1,
3779,
3780,
22913,
22914,
21058,
21057,
21059,
22916,
22816,
22907,
22814,
22905,
22810,
22903,
22815,
22906,
22811,
22904,
22869,
22881,
22867,
22879,
22865,
22877,
22868,
22880,
22866,
22878,
22821,
22833,
22819,
22831,
22817,
22829,
22820,
22832,
22818,
22830,
22845,
22887,
22843,
22885,
22804,
22841,
22883,
22844,
22886,
22842,
22884,
22827,
22825,
22823,
22826,
22824,
22875,
22893,
22857,
22873,
22891,
22855,
22871,
22889,
22853,
22874,
22892,
22856,
22872,
22890,
22854,
22863,
22861,
22859,
22862,
22860,
22798,
22902,
22796,
22900,
22797,
22901,
22851,
22849,
22847,
22850,
22848,
22809,
22898,
22896,
22897,
22895,
22822,
22835,
22802,
22801,
22839,
22837,
22838,
22836,
22909,
22915,
22910,
22908,
22911,
-1,
-1,
-1,
-1,
-1,
16492,
16499,
16500,
16504,
16505,
16496,
16478,
16501,
16481,
16502,
16503,
16488,
16498,
16494,
16477,
16491,
16487,
16497,
16475,
16490,
16486,
16444,
16468,
16453,
16459,
16450,
16458,
16448,
16472,
16445,
16454,
16447,
16456,
16457,
16461,
16484,
16464,
16495,
16479,
16483,
16467,
-1,
-1,
-1,
20351,
20303,
20352,
20354,
20360,
20359,
20381,
20299,
20314,
20324,
20328,
20317,
20327,
20323,
20319,
20329,
20367,
20331,
20301,
20333,
20307,
20300,
20386,
20388,
20306,
20389,
20353,
20382,
20342,
20391,
20373,
20376,
20294,
20295,
20379,
20377,
20282,
20277,
20383,
20364,
20365,
20384,
20289,
20390,
20363,
20362,
20366,
20284,
20378,
20296,
20385,
20393,
20302,
20356,
20357,
20358,
20325,
20322,
20318,
20320,
20326,
20370,
20372,
20371,
20350,
20340,
20338,
20336,
20335,
20341,
20339,
20347,
20349,
20312,
20311,
20309,
20310,
20313,
20343,
20304,
20278,
20280,
20281,
20348,
20305,
20283,
20291,
20292,
20293,
20287,
20286,
20288,
20374,
20375,
-1,
26971,
26969,
26970,
26958,
26956,
26963,
26959,
26966,
26974,
26964,
26968,
26957,
26962,
26972,
26973,
26967,
16493,
16476,
16489,
16482,
16460,
16455,
16473,
16470,
16465,
16446,
16462,
16485,
16466,
16480,
16451,
16449,
16452,
16474,
16471,
16463,
16508,
16507,
16509,
16510,
]

_charnames_12736 = [
1291,
1294,
1293,
1298,
1281,
1265,
1272,
1273,
1270,
1280,
1271,
1268,
1274,
1269,
1266,
1296,
1263,
1277,
1287,
1285,
1297,
1264,
1276,
1278,
1282,
1284,
1286,
1290,
1288,
1292,
1279,
1283,
1275,
1267,
1289,
1295,
]

_charnames_12784 = [
22800,
22808,
22807,
22805,
22812,
22794,
22792,
22790,
22793,
22791,
22813,
22788,
22786,
22784,
22787,
22785,
26094,
26102,
26084,
26100,
26104,
26089,
26098,
26106,
26077,
26081,
26096,
26086,
26091,
26108,
26095,
26103,
26085,
26101,
26105,
26090,
26099,
26107,
26080,
26082,
26097,
26087,
26092,
26109,
26079,
26141,
26142,
-1,
26071,
26052,
26053,
26043,
26040,
26037,
26033,
26057,
26063,
26054,
26066,
26041,
26061,
26060,
26067,
26058,
26028,
26031,
26073,
26036,
26064,
26035,
26042,
26069,
26072,
26049,
26070,
26030,
26027,
26056,
26048,
26074,
26044,
26047,
26034,
26050,
4650,
4643,
4593,
4642,
4753,
4727,
4745,
4766,
4775,
4779,
4782,
4786,
26156,
4726,
4720,
4721,
4729,
4730,
4723,
4724,
4732,
4731,
4735,
4744,
4738,
4739,
4747,
4748,
4864,
4881,
4854,
4879,
4883,
4859,
4877,
4873,
4869,
4871,
4866,
4856,
4861,
4885,
4865,
4882,
4855,
4880,
4884,
4860,
4878,
4876,
4870,
4872,
4867,
4857,
4862,
4886,
4850,
4849,
4875,
23379,
4652,
4626,
4627,
4599,
4596,
4592,
4588,
4617,
4631,
4628,
4612,
4597,
4640,
4639,
4610,
4618,
4582,
4586,
4646,
4591,
4633,
4590,
4598,
4623,
4637,
4589,
4613,
4600,
4583,
4615,
4651,
4648,
4653,
4604,
4622,
4621,
4645,
4624,
4635,
4636,
4607,
4611,
4606,
4585,
4581,
4616,
4605,
4649,
4632,
4741,
4742,
4750,
4749,
4756,
4765,
4759,
4760,
4768,
4769,
4762,
4763,
4771,
4770,
4774,
26941,
26951,
26944,
26947,
26943,
26939,
26940,
26946,
26948,
26949,
26950,
26900,
18575,
18648,
18649,
9561,
4847,
4845,
4843,
4846,
4844,
4827,
4825,
4823,
4826,
4824,
4803,
4801,
4799,
4802,
4800,
4797,
4795,
4793,
4796,
4794,
4815,
4813,
4811,
4814,
4812,
4833,
4831,
4829,
4832,
4830,
4821,
4819,
4817,
4820,
4818,
4842,
4840,
4841,
4809,
4807,
4805,
4808,
4806,
4838,
4836,
4837,
4835,
-1,
18683,
18682,
18684,
18686,
18665,
18664,
18718,
18650,
18651,
18695,
18694,
18483,
18482,
18481,
18582,
18583,
18580,
18579,
18490,
18578,
18475,
18478,
18477,
18476,
18585,
18586,
18485,
18486,
18499,
18488,
18489,
18658,
18657,
18661,
18655,
18654,
18626,
18630,
18627,
18715,
18634,
18638,
18572,
18513,
18512,
18674,
18519,
18517,
18518,
18678,
18560,
18559,
18675,
18558,
18570,
18508,
18507,
18569,
18506,
18509,
18679,
18522,
18677,
18565,
18521,
18563,
18564,
18432,
18431,
18435,
18433,
18434,
18447,
18444,
18445,
18453,
18454,
18455,
18707,
18706,
18708,
18593,
18594,
18601,
18600,
18604,
18603,
18555,
26935,
26936,
26913,
26915,
26924,
26927,
26919,
26921,
26930,
26933,
26917,
26932,
26912,
26916,
26925,
26928,
26920,
26922,
26931,
26934,
26905,
26910,
26908,
26909,
26911,
18567,
18625,
18681,
18673,
18693,
18531,
18621,
18623,
18624,
18670,
18647,
18645,
18644,
18646,
18612,
18514,
18633,
18428,
18429,
18479,
18501,
18460,
18590,
18615,
18500,
18530,
18640,
18427,
18426,
18467,
18498,
18573,
18497,
18466,
18589,
18716,
18425,
18465,
18628,
18495,
18713,
18639,
18424,
18448,
18607,
18469,
18450,
18609,
18441,
18474,
18451,
18610,
18442,
18472,
18438,
18439,
18510,
18494,
18463,
18588,
18596,
18597,
18598,
18525,
18637,
18423,
18462,
18524,
18636,
18422,
18458,
18492,
18459,
18523,
18635,
18421,
18456,
18491,
18457,
18502,
18440,
18685,
18676,
18618,
18617,
18619,
18611,
18631,
18587,
18571,
18566,
18663,
18496,
18473,
18493,
18702,
18701,
18699,
18700,
18461,
18446,
18464,
18529,
18528,
18527,
18526,
18660,
18659,
18554,
18717,
18687,
26899,
26874,
26880,
26888,
26891,
26883,
26885,
26894,
26897,
26881,
26896,
26873,
26879,
26889,
26892,
26884,
26886,
26895,
26898,
26859,
26870,
26862,
26863,
26868,
26869,
26865,
26866,
26872,
26871,
26877,
26878,
18584,
]

_charnames_19904 = [
20778,
20789,
20803,
20865,
20858,
20846,
20784,
20867,
20819,
20795,
20837,
20821,
20864,
20812,
20861,
20868,
20863,
20857,
20853,
20845,
20850,
20815,
20822,
20831,
20825,
20814,
20860,
20813,
20785,
20779,
20827,
20804,
20832,
20811,
20836,
20805,
20794,
20841,
20842,
20799,
20800,
20828,
20849,
20847,
20816,
20835,
20840,
20787,
20833,
20780,
20783,
20791,
20798,
20790,
20855,
20788,
20793,
20792,
20802,
20866,
20826,
20820,
20854,
20851,
]

_charnames_40960 = [
15224,
15223,
15218,
15225,
15221,
15220,
15219,
15222,
15232,
15231,
15230,
15233,
15235,
15234,
15236,
15228,
15227,
15226,
15229,
15238,
15237,
15204,
14586,
14585,
14580,
14587,
14583,
14582,
14581,
14584,
14600,
14599,
14598,
14601,
14573,
14572,
14574,
14596,
14595,
14594,
14597,
14603,
14602,
14604,
14578,
14577,
14571,
14579,
14576,
14575,
14592,
14591,
14588,
14593,
14590,
14589,
15028,
15027,
15023,
15029,
15025,
15024,
15026,
15042,
15041,
15040,
15043,
15016,
15015,
15017,
15038,
15037,
15036,
15039,
15021,
15020,
15014,
15022,
15019,
15018,
15034,
15033,
15030,
15035,
15032,
15031,
14554,
14553,
14548,
14555,
14551,
14550,
14549,
14552,
14566,
14565,
14564,
14567,
14541,
14540,
14542,
14562,
14561,
14560,
14563,
14569,
14568,
14570,
14546,
14545,
14539,
14547,
14544,
14543,
14558,
14557,
14556,
14559,
14063,
14062,
14058,
14064,
14060,
14059,
14061,
14083,
14082,
14081,
14084,
14079,
14078,
14077,
14080,
14075,
14074,
14071,
14076,
14073,
14072,
14069,
14068,
14065,
14070,
14067,
14066,
14272,
14271,
14267,
14273,
14269,
14268,
14270,
14285,
14284,
14283,
14286,
14260,
14259,
14261,
14281,
14280,
14279,
14282,
14265,
14264,
14258,
14266,
14263,
14262,
14277,
14274,
14278,
14276,
14275,
14767,
14766,
14762,
14768,
14764,
14763,
14765,
14779,
14778,
14777,
14780,
14755,
14754,
14753,
14756,
14775,
14774,
14773,
14776,
14782,
14781,
14760,
14759,
14752,
14761,
14758,
14757,
14771,
14770,
14769,
14772,
15173,
15172,
15171,
15174,
15177,
15176,
15175,
15178,
15180,
15179,
15181,
15165,
15164,
15161,
15166,
15163,
15162,
15169,
15168,
15167,
15170,
14988,
14987,
14982,
14989,
14985,
14984,
14983,
14986,
15008,
15007,
15006,
15009,
15004,
15003,
15002,
15005,
15011,
15012,
15000,
14999,
14996,
15001,
14998,
14997,
14994,
14993,
14990,
14995,
14992,
14991,
14880,
14879,
14875,
14881,
14877,
14876,
14878,
14888,
14887,
14886,
14889,
14871,
14870,
14884,
14883,
14882,
14885,
14891,
14890,
14892,
14873,
14872,
14867,
14874,
14869,
14868,
15089,
15088,
15084,
15090,
15086,
15085,
15087,
15097,
15096,
15095,
15098,
15077,
15076,
15075,
15078,
15093,
15092,
15091,
15094,
15100,
15099,
15101,
15082,
15081,
15074,
15083,
15080,
15079,
14854,
14853,
14849,
14855,
14851,
14850,
14852,
14862,
14861,
14860,
14863,
14842,
14841,
14843,
14858,
14857,
14856,
14859,
14865,
14864,
14866,
14847,
14846,
14840,
14848,
14845,
14844,
14146,
14145,
14142,
14147,
14144,
14143,
14154,
14153,
14152,
14155,
14150,
14149,
14148,
14151,
14157,
14156,
14158,
14140,
14139,
14136,
14141,
14138,
14137,
14318,
14317,
14312,
14319,
14315,
14314,
14313,
14316,
14322,
14321,
14320,
14323,
14326,
14325,
14330,
14329,
14331,
14333,
14332,
14334,
14327,
14211,
14210,
14206,
14212,
14208,
14207,
14209,
14221,
14220,
14222,
14199,
14198,
14200,
14215,
14214,
14213,
14216,
14218,
14217,
14219,
14204,
14203,
14197,
14205,
14202,
14201,
14239,
14238,
14234,
14240,
14236,
14235,
14237,
14249,
14248,
14247,
14250,
14227,
14226,
14228,
14252,
14251,
14253,
14255,
14254,
14256,
14232,
14231,
14225,
14233,
14230,
14229,
14245,
14244,
14241,
14246,
14243,
14242,
14962,
14961,
14956,
14963,
14959,
14958,
14957,
14960,
14976,
14975,
14974,
14977,
14949,
14948,
14947,
14950,
14972,
14971,
14970,
14973,
14979,
14978,
14980,
14954,
14953,
14946,
14955,
14952,
14951,
14968,
14967,
14964,
14969,
14966,
14965,
14714,
14713,
14708,
14715,
14711,
14710,
14709,
14712,
14726,
14725,
14724,
14727,
14701,
14700,
14699,
14702,
14718,
14717,
14716,
14719,
14722,
14721,
14720,
14723,
14706,
14705,
14698,
14707,
14704,
14703,
15146,
15145,
15141,
15147,
15143,
15142,
15144,
15158,
15157,
15156,
15159,
15134,
15133,
15135,
15150,
15149,
15148,
15151,
15154,
15153,
15152,
15155,
15139,
15138,
15132,
15140,
15137,
15136,
14685,
14684,
14680,
14682,
14681,
14683,
14696,
14695,
14694,
14697,
14673,
14672,
14671,
14674,
14688,
14687,
14686,
14689,
14692,
14691,
14690,
14693,
14678,
14677,
14670,
14679,
14676,
14675,
14751,
14750,
14745,
14744,
14743,
14746,
14732,
14731,
14733,
14741,
14740,
14739,
14742,
14748,
14747,
14749,
14737,
14736,
14730,
14738,
14735,
14734,
14294,
14293,
14288,
14295,
14291,
14290,
14289,
14292,
14306,
14305,
14304,
14307,
14298,
14297,
14296,
14299,
14302,
14301,
14300,
14303,
14309,
14308,
14310,
14192,
14191,
14193,
14186,
14185,
14184,
14187,
14190,
14189,
14188,
14182,
14181,
14180,
14183,
14195,
14194,
14196,
14350,
14349,
14348,
14345,
14344,
14343,
14346,
14337,
14336,
14335,
14338,
14341,
14340,
14339,
14342,
14352,
14351,
14353,
15210,
15209,
15208,
15211,
15206,
15205,
15207,
15213,
15212,
15214,
15216,
15215,
15217,
14427,
14426,
14422,
14428,
14424,
14423,
14425,
14441,
14440,
14439,
14442,
14415,
14414,
14416,
14437,
14436,
14435,
14438,
14444,
14443,
14445,
14420,
14419,
14413,
14421,
14418,
14417,
14433,
14432,
14429,
14434,
14431,
14430,
14649,
14648,
14643,
14650,
14646,
14645,
14644,
14647,
14663,
14662,
14661,
14664,
14636,
14635,
14637,
14659,
14658,
14657,
14660,
14666,
14665,
14667,
14641,
14640,
14634,
14642,
14639,
14638,
14655,
14654,
14651,
14656,
14653,
14652,
14362,
14361,
14356,
14363,
14359,
14358,
14357,
14360,
14377,
14376,
14375,
14378,
14380,
14379,
14381,
14383,
14382,
14384,
14373,
14370,
14374,
14372,
14371,
14368,
14367,
14364,
14369,
14366,
14365,
14040,
14039,
14035,
14041,
14037,
14036,
14038,
14050,
14049,
14048,
14051,
14032,
14031,
14053,
14054,
14056,
14055,
14033,
14028,
14034,
14030,
14029,
14046,
14045,
14042,
14047,
14044,
14043,
14518,
14517,
14513,
14519,
14515,
14514,
14516,
14532,
14531,
14530,
14533,
14506,
14505,
14507,
14528,
14527,
14526,
14529,
14535,
14534,
14536,
14511,
14510,
14504,
14512,
14509,
14508,
14524,
14523,
14520,
14525,
14522,
14521,
14453,
14452,
14448,
14454,
14450,
14449,
14451,
14471,
14470,
14469,
14472,
14467,
14466,
14465,
14468,
14474,
14473,
14475,
14463,
14462,
14461,
14464,
14459,
14458,
14455,
14460,
14457,
14456,
14411,
14410,
14409,
14412,
14388,
14387,
14389,
14403,
14402,
14401,
14404,
14407,
14406,
14405,
14408,
14393,
14392,
14386,
14394,
14391,
14390,
14399,
14398,
14395,
14400,
14397,
14396,
14632,
14631,
14630,
14633,
14610,
14609,
14608,
14611,
14624,
14623,
14622,
14625,
14628,
14627,
14626,
14629,
14614,
14607,
14615,
14613,
14612,
14620,
14619,
14616,
14621,
14618,
14617,
14918,
14917,
14899,
14898,
14911,
14910,
14909,
14912,
14915,
14914,
14913,
14916,
14901,
14900,
14895,
14902,
14897,
14896,
14907,
14906,
14903,
14908,
14905,
14904,
14130,
14129,
14128,
14131,
14133,
14132,
14134,
14126,
14125,
14124,
14127,
14122,
14121,
14118,
14123,
14120,
14119,
14116,
14115,
14112,
14117,
14114,
14113,
14502,
14501,
14500,
14503,
14479,
14478,
14480,
14494,
14493,
14492,
14495,
14498,
14497,
14496,
14499,
14484,
14483,
14477,
14485,
14482,
14481,
14490,
14489,
14486,
14491,
14488,
14487,
14940,
14939,
14938,
14941,
14921,
14920,
14922,
14936,
14935,
14934,
14937,
14943,
14942,
14944,
14926,
14925,
14919,
14927,
14924,
14923,
14932,
14931,
14928,
14933,
14930,
14929,
14826,
14825,
14820,
14827,
14823,
14822,
14821,
14824,
14813,
14812,
14811,
14814,
14836,
14835,
14834,
14837,
14818,
14817,
14810,
14819,
14816,
14815,
14832,
14831,
14828,
14833,
14830,
14829,
15119,
15118,
15113,
15120,
15116,
15115,
15114,
15117,
15106,
15105,
15104,
15107,
15129,
15128,
15127,
15130,
15111,
15110,
15103,
15112,
15109,
15108,
15125,
15124,
15121,
15126,
15123,
15122,
14800,
14799,
14794,
14801,
14797,
14796,
14795,
14798,
14787,
14786,
14788,
14808,
14807,
14806,
14809,
14792,
14791,
14785,
14793,
14790,
14789,
14804,
14803,
14802,
14805,
14092,
14091,
14086,
14093,
14089,
14088,
14087,
14090,
14098,
14097,
14109,
14108,
14107,
14110,
14099,
14094,
14100,
14096,
14095,
14105,
14104,
14101,
14106,
14103,
14102,
14166,
14165,
14160,
14167,
14163,
14162,
14161,
14164,
14170,
14169,
14171,
14177,
14176,
14175,
14178,
14173,
14172,
14168,
14174,
15189,
15188,
15183,
15190,
15186,
15185,
15184,
15187,
15202,
15201,
15199,
15198,
15197,
15200,
15195,
15194,
15191,
15196,
15193,
15192,
15061,
15060,
15055,
15062,
15058,
15057,
15056,
15059,
15048,
15047,
15046,
15049,
15071,
15070,
15069,
15072,
15053,
15052,
15045,
15054,
15051,
15050,
15067,
15066,
15063,
15068,
15065,
15064,
-1,
-1,
-1,
15315,
15287,
15306,
15271,
15243,
15260,
15264,
15266,
15304,
15284,
15289,
15313,
15303,
15291,
15301,
15282,
15298,
15267,
15250,
15242,
15310,
15312,
15263,
15270,
15297,
15316,
15277,
15252,
15300,
15285,
15292,
15294,
15256,
15295,
15253,
15279,
15272,
15276,
15265,
15278,
15314,
15309,
15257,
15288,
15241,
15244,
15245,
15283,
15259,
15249,
15258,
15246,
15251,
15273,
15307,
]

_charnames_42192 = [
9622,
9589,
9588,
9608,
9577,
9576,
9603,
9597,
9596,
9619,
9611,
9610,
9607,
9575,
9574,
9617,
9594,
9618,
9586,
9582,
9583,
9593,
9600,
9615,
9599,
9621,
9616,
9585,
9614,
9602,
9612,
9613,
9604,
9605,
9620,
9590,
9578,
9580,
9579,
9591,
9567,
9572,
9570,
9571,
9568,
9569,
9625,
9624,
23685,
23686,
23608,
23545,
23546,
23652,
23591,
23598,
23450,
23489,
23442,
23511,
23668,
23636,
23566,
23559,
23474,
23467,
23618,
23644,
23481,
23410,
23582,
23575,
23535,
23528,
23676,
23660,
23426,
23628,
23499,
23391,
23517,
23457,
23433,
23418,
23690,
23691,
23611,
23612,
23550,
23551,
23654,
23593,
23600,
23452,
23495,
23444,
23513,
23670,
23638,
23568,
23561,
23476,
23469,
23622,
23646,
23483,
23412,
23584,
23577,
23537,
23530,
23678,
23662,
23428,
23630,
23503,
23395,
23521,
23459,
23435,
23420,
23692,
23693,
23399,
23613,
23614,
23552,
23553,
23655,
23594,
23601,
23453,
23492,
23493,
23445,
23514,
23671,
23639,
23569,
23562,
23477,
23470,
23623,
23647,
23484,
23413,
23585,
23578,
23538,
23531,
23679,
23663,
23429,
23631,
23500,
23501,
23396,
23522,
23460,
23436,
23421,
23681,
23682,
23604,
23541,
23542,
23650,
23589,
23596,
23448,
23491,
23440,
23507,
23666,
23634,
23564,
23557,
23472,
23465,
23620,
23642,
23479,
23408,
23580,
23573,
23533,
23526,
23674,
23658,
23424,
23626,
23497,
23393,
23519,
23455,
23431,
23416,
23688,
23689,
23609,
23610,
23548,
23549,
23653,
23592,
23599,
23451,
23494,
23443,
23512,
23669,
23637,
23567,
23560,
23475,
23468,
23621,
23645,
23482,
23411,
23583,
23576,
23536,
23529,
23677,
23661,
23427,
23629,
23502,
23394,
23520,
23458,
23434,
23419,
23680,
23683,
23397,
23603,
23605,
23540,
23543,
23649,
23588,
23595,
23447,
23490,
23439,
23506,
23508,
23665,
23633,
23563,
23556,
23471,
23464,
23619,
23641,
23478,
23401,
23579,
23572,
23532,
23525,
23673,
23657,
23423,
23625,
23496,
23392,
23518,
23454,
23430,
23415,
23684,
23687,
23398,
23606,
23607,
23544,
23547,
23651,
23590,
23597,
23449,
23487,
23488,
23441,
23509,
23510,
23667,
23635,
23565,
23558,
23473,
23466,
23616,
23643,
23480,
23409,
23581,
23574,
23534,
23527,
23675,
23659,
23425,
23627,
23498,
23389,
23390,
23515,
23516,
23456,
23432,
23417,
23387,
23617,
23729,
23728,
23727,
23406,
23405,
23403,
23708,
23706,
23697,
23710,
23712,
23709,
23698,
23703,
23701,
23705,
23696,
23702,
23711,
23723,
23724,
23715,
23716,
23721,
23722,
23718,
23719,
23726,
23725,
23404,
23407,
]

_charnames_42560 = [
4381,
4152,
4359,
4130,
4465,
4236,
4324,
4095,
4364,
4135,
4487,
4259,
4414,
4185,
4485,
4257,
4386,
4157,
4318,
4089,
4464,
4235,
4323,
4094,
4459,
4230,
4415,
4186,
4321,
4092,
4391,
4162,
-1,
-1,
4350,
4121,
4348,
4119,
4347,
4118,
4488,
4260,
4411,
4182,
4366,
4137,
4501,
3468,
3464,
3467,
3463,
19780,
]

_charnames_42620 = [
3470,
3457,
4504,
4503,
4365,
4136,
4361,
4132,
4376,
4147,
4460,
4231,
4360,
4131,
4401,
4172,
4403,
4174,
4395,
4166,
4396,
4167,
4404,
4175,
4451,
4222,
4341,
4112,
]

_charnames_42656 = [
16239,
16168,
16235,
16165,
16238,
16194,
16214,
16236,
16151,
16237,
16222,
16208,
16196,
16197,
16221,
16172,
16215,
16154,
16141,
16169,
16186,
16176,
16184,
16187,
16185,
16188,
16164,
16162,
16147,
16146,
16139,
16230,
16182,
16229,
16231,
16152,
16161,
16205,
16140,
16150,
16202,
16233,
16206,
16226,
16198,
16218,
16178,
16153,
16192,
16199,
16163,
16143,
16144,
16145,
16183,
16203,
16224,
16225,
16234,
16155,
16220,
16207,
16219,
16157,
16174,
16193,
16171,
16179,
16216,
16167,
16177,
16175,
16211,
16166,
16212,
16149,
16189,
16227,
16158,
16159,
16244,
16243,
16249,
16250,
16246,
16245,
16247,
16248,
]

_charnames_42752 = [
6663,
6668,
6660,
6665,
6662,
6667,
6661,
6666,
6729,
6766,
6741,
6685,
6723,
6730,
6767,
6742,
6686,
6724,
6732,
6769,
6744,
6682,
6726,
6754,
6755,
6756,
6701,
6707,
6710,
6709,
6708,
6697,
6627,
6626,
8645,
7962,
8646,
7963,
8887,
8280,
8723,
7842,
8724,
7844,
8914,
8301,
8915,
8302,
9060,
9053,
8602,
8019,
8599,
8018,
8598,
8017,
8595,
8012,
8596,
8013,
8597,
8016,
8796,
8133,
8939,
8348,
8937,
8346,
8940,
8349,
8988,
8384,
8815,
8160,
8541,
7891,
8540,
7890,
8550,
7906,
8973,
8404,
8976,
8409,
8974,
8405,
9005,
8442,
9006,
8443,
8793,
8126,
8797,
8137,
8963,
8391,
8966,
8397,
8967,
8398,
8721,
7839,
8722,
7840,
8968,
8399,
8642,
7959,
8755,
8205,
8916,
8303,
6775,
8238,
8169,
8425,
8262,
8136,
9026,
7810,
8067,
8754,
8202,
8753,
8201,
8752,
8715,
7800,
8714,
7805,
8751,
8199,
8750,
8198,
8749,
8197,
6699,
6674,
6629,
8775,
8102,
]

_charnames_43003 = [
9091,
9090,
9093,
9094,
9095,
18946,
18943,
18960,
18937,
18945,
18939,
18959,
18923,
18924,
18929,
18930,
18961,
18932,
18933,
18926,
18927,
18906,
18907,
18912,
18913,
18908,
18909,
18914,
18915,
18940,
18920,
18921,
18935,
18936,
18941,
18918,
18942,
18917,
18938,
18944,
18952,
18950,
18948,
18951,
18949,
18957,
18956,
18955,
18954,
-1,
-1,
-1,
-1,
26737,
26738,
26742,
26736,
26739,
26741,
26744,
26747,
26746,
26745,
-1,
-1,
-1,
-1,
-1,
-1,
26208,
26207,
26211,
26180,
26191,
26193,
26223,
26178,
26176,
26175,
26189,
26181,
26205,
26204,
26227,
26221,
26174,
26173,
26187,
26216,
26198,
26199,
26183,
26214,
26218,
26222,
26184,
26185,
26225,
26194,
26224,
26217,
26212,
26220,
26219,
26215,
26226,
26210,
26213,
26232,
26231,
26171,
26170,
26188,
26179,
26196,
26201,
26202,
26195,
26233,
26234,
26192,
26235,
26239,
26237,
26238,
]

_charnames_43136 = [
19126,
19124,
19046,
19049,
19070,
19071,
19054,
19055,
19024,
19025,
19026,
19027,
19075,
19076,
19048,
19059,
19060,
19047,
19066,
19065,
19074,
19073,
19038,
19079,
19078,
19069,
19068,
19036,
19032,
19031,
19043,
19042,
19037,
19034,
19033,
19045,
19044,
19039,
19058,
19057,
19082,
19081,
19085,
19083,
19084,
19063,
19028,
19052,
19051,
19053,
19086,
19062,
19127,
19096,
19101,
19102,
19097,
19098,
19089,
19090,
19091,
19092,
19103,
19104,
19095,
19099,
19100,
19094,
19125,
]

_charnames_43214 = [
19121,
19120,
19116,
19117,
19108,
19109,
19114,
19115,
19111,
19112,
19119,
19118,
-1,
-1,
-1,
-1,
-1,
-1,
3608,
3609,
3600,
3601,
3606,
3607,
3603,
3604,
3611,
3610,
3619,
3614,
3618,
3617,
3616,
3615,
3613,
3620,
24553,
24545,
24558,
24543,
24544,
24546,
24554,
24581,
24587,
24586,
-1,
-1,
-1,
-1,
23052,
23053,
23044,
23045,
23050,
23051,
23047,
23048,
23055,
23054,
23025,
23024,
23037,
23009,
23016,
23015,
23029,
23008,
23013,
23027,
23010,
23019,
23018,
23034,
23038,
23040,
23033,
23030,
23035,
23031,
23012,
23028,
23032,
23039,
23041,
23022,
23036,
23021,
23058,
23059,
23057,
23060,
23061,
23065,
23063,
23064,
23068,
23067,
25819,
25822,
25806,
25814,
25823,
25808,
25817,
25825,
25811,
25824,
25820,
25803,
25815,
25816,
25818,
25812,
25813,
25821,
25810,
25805,
25807,
25802,
25826,
25837,
25835,
25829,
25834,
25836,
25833,
25830,
25831,
25841,
25840,
25842,
25843,
25838,
]

_charnames_43359 = [
25844,
20240,
20239,
20237,
20242,
20208,
20205,
20211,
20203,
20214,
20212,
20204,
20210,
20206,
20216,
20209,
20268,
20265,
20266,
20151,
20161,
20167,
20133,
20230,
20233,
20135,
20131,
20171,
20273,
20136,
-1,
-1,
-1,
27836,
27833,
27837,
27835,
27774,
27763,
27761,
27762,
27778,
27756,
27733,
27734,
27783,
27775,
27779,
27757,
27759,
27760,
27768,
27769,
27732,
27770,
27771,
27766,
27736,
27767,
27735,
27740,
27741,
27745,
27746,
27738,
27742,
27743,
27747,
27748,
27737,
27753,
27755,
27772,
27773,
27780,
27776,
27764,
27765,
27781,
27777,
27751,
27752,
27749,
27782,
27834,
27823,
27825,
27826,
27827,
27828,
27829,
27824,
27831,
27830,
27840,
27839,
27841,
27805,
27784,
27843,
27795,
27801,
27790,
27799,
27798,
27791,
27789,
27793,
27794,
27797,
27842,
-1,
27804,
27816,
27817,
27808,
27809,
27814,
27815,
27811,
27812,
27819,
27818,
-1,
-1,
-1,
-1,
27800,
27802,
]

_charnames_43520 = [
5119,
5127,
5123,
5129,
5120,
5125,
5109,
5108,
5115,
5114,
5082,
5083,
5118,
5117,
5112,
5111,
5078,
5080,
5079,
5100,
5099,
5093,
5091,
5084,
5085,
5092,
5089,
5087,
5088,
5097,
5095,
5105,
5106,
5096,
5121,
5124,
5126,
5122,
5102,
5103,
5128,
5134,
5139,
5140,
5141,
5135,
5138,
5137,
5133,
5132,
5136,
5161,
5163,
5164,
5162,
]

_charnames_43584 = [
5073,
5074,
5066,
5158,
5075,
5068,
5065,
5071,
5067,
5070,
5072,
5069,
5159,
5160,
-1,
-1,
5152,
5153,
5144,
5145,
5150,
5151,
5147,
5148,
5155,
5154,
-1,
-1,
5170,
5168,
5167,
5169,
7395,
7390,
7389,
7384,
7383,
7380,
7378,
7377,
7374,
7373,
7375,
7381,
7393,
7387,
7386,
7396,
7625,
7392,
7391,
7394,
7497,
7496,
7498,
7552,
7551,
7550,
7469,
7530,
-1,
-1,
-1,
-1,
17057,
17088,
17055,
17086,
17056,
17087,
17075,
17106,
17052,
17083,
17065,
17096,
17066,
17097,
17069,
17100,
17050,
17081,
17077,
17108,
17059,
17090,
17060,
17091,
17051,
17082,
17078,
17109,
17062,
17093,
17063,
17094,
17076,
17107,
17072,
17103,
17067,
17098,
17070,
17101,
17073,
17104,
17068,
17099,
17074,
17105,
17071,
17102,
17139,
17116,
17121,
17118,
17117,
17124,
17123,
17138,
17122,
17119,
17120,
17113,
17112,
17114,
17115,
17136,
17135,
17133,
17134,
]

_charnames_43968 = [
7644,
7668,
7649,
7647,
7640,
7633,
7671,
7636,
7646,
7631,
7638,
7666,
7665,
7670,
7667,
7654,
7642,
7672,
7657,
7653,
7669,
7664,
7652,
7660,
7658,
7661,
7663,
7645,
7650,
7648,
7641,
7634,
7637,
7632,
7655,
7692,
7694,
7696,
7689,
7691,
7690,
7695,
7693,
7697,
7673,
7698,
-1,
-1,
7684,
7685,
7676,
7677,
7682,
7683,
7679,
7680,
7687,
7686,
]

_charnames_55216 = [
20066,
20070,
20012,
20013,
20016,
20091,
20095,
20002,
20004,
20056,
20053,
20051,
20055,
20036,
20035,
20038,
20037,
20042,
20040,
20039,
20046,
20082,
20078,
-1,
-1,
-1,
-1,
19963,
19961,
19855,
19856,
19951,
19944,
19945,
19947,
19948,
19949,
19845,
19826,
19858,
19833,
19816,
19818,
19837,
19836,
19920,
19938,
19928,
19861,
19932,
19935,
19892,
19888,
19894,
19859,
19886,
19890,
19891,
19880,
19875,
19854,
19853,
19872,
19877,
19878,
19869,
19881,
19903,
19904,
19972,
19973,
19991,
19990,
19864,
19899,
19898,
]

_charnames_63744 = [
856,
855,
854,
853,
852,
851,
850,
849,
848,
847,
846,
845,
844,
843,
842,
841,
839,
838,
837,
836,
835,
834,
833,
832,
831,
830,
829,
828,
827,
826,
825,
824,
822,
821,
820,
819,
818,
817,
816,
815,
814,
813,
812,
811,
810,
809,
808,
807,
805,
804,
803,
802,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
788,
787,
786,
785,
784,
783,
782,
781,
780,
779,
778,
777,
776,
775,
774,
773,
771,
770,
769,
768,
767,
766,
765,
764,
763,
762,
761,
760,
759,
758,
757,
756,
754,
753,
752,
751,
750,
749,
748,
747,
746,
745,
744,
743,
742,
741,
740,
739,
737,
736,
735,
734,
733,
732,
731,
730,
729,
728,
727,
726,
725,
724,
723,
722,
720,
719,
718,
717,
716,
715,
714,
713,
712,
711,
710,
709,
708,
707,
706,
705,
703,
702,
701,
700,
699,
698,
697,
696,
695,
694,
693,
692,
691,
690,
689,
688,
686,
685,
684,
683,
682,
681,
680,
679,
678,
677,
676,
675,
674,
673,
672,
671,
669,
668,
667,
666,
665,
664,
663,
662,
661,
660,
659,
658,
657,
656,
655,
654,
652,
651,
650,
649,
648,
647,
646,
645,
644,
643,
642,
641,
640,
639,
638,
637,
635,
634,
633,
632,
631,
630,
629,
628,
627,
626,
625,
624,
623,
622,
621,
620,
618,
617,
616,
615,
614,
613,
612,
611,
610,
609,
608,
607,
606,
605,
604,
603,
601,
600,
599,
598,
597,
596,
595,
594,
593,
592,
591,
590,
589,
588,
587,
586,
1044,
1043,
1042,
1041,
1040,
1039,
1038,
1037,
1036,
1035,
1034,
1033,
1032,
1031,
1030,
1029,
1027,
1026,
1025,
1024,
1023,
1022,
1021,
1020,
1019,
1018,
1017,
1016,
1015,
1014,
1013,
1012,
1074,
1073,
1072,
1071,
1070,
1069,
1068,
1067,
1066,
1065,
1064,
1063,
1062,
1061,
-1,
-1,
1010,
1009,
1008,
1007,
1006,
1005,
1004,
1003,
1002,
1001,
1000,
999,
998,
997,
996,
995,
993,
992,
991,
990,
989,
988,
987,
986,
985,
984,
983,
982,
981,
980,
979,
978,
976,
975,
974,
973,
972,
971,
970,
969,
968,
967,
966,
965,
964,
963,
962,
961,
1059,
1058,
1057,
1056,
1055,
1054,
1053,
1052,
1051,
1050,
1049,
1048,
1047,
1046,
-1,
-1,
959,
958,
957,
956,
955,
954,
953,
952,
951,
950,
949,
948,
947,
946,
945,
944,
942,
941,
940,
939,
938,
937,
936,
935,
934,
933,
932,
931,
930,
929,
928,
927,
925,
924,
923,
922,
921,
920,
919,
918,
917,
916,
915,
914,
913,
912,
911,
910,
908,
907,
906,
905,
904,
903,
902,
901,
900,
899,
898,
897,
896,
895,
894,
893,
891,
890,
889,
888,
887,
886,
885,
884,
883,
882,
881,
880,
879,
878,
877,
876,
874,
873,
872,
871,
870,
869,
868,
867,
866,
865,
864,
863,
862,
861,
860,
859,
1085,
1084,
1083,
1082,
1081,
1080,
1079,
1078,
1077,
1076,
]

_charnames_64256 = [
8467,
8471,
8470,
8469,
8468,
8474,
8472,
]

_charnames_64275 = [
13626,
13628,
13627,
13629,
13625,
-1,
-1,
-1,
-1,
-1,
20647,
20760,
20689,
20636,
20606,
20605,
20603,
20602,
20601,
20604,
20600,
20599,
20635,
20616,
20615,
20613,
20612,
20632,
20631,
20633,
20667,
20681,
20683,
20663,
20652,
20669,
-1,
20642,
20648,
20623,
20660,
20679,
-1,
20677,
-1,
20675,
20618,
-1,
20621,
20656,
-1,
20640,
20673,
20671,
20610,
20644,
20651,
20666,
20659,
20655,
20691,
13000,
13001,
13244,
13247,
13245,
13246,
13335,
13338,
13336,
13337,
13237,
13240,
13238,
13239,
12832,
12835,
12833,
12834,
12809,
12812,
12810,
12811,
12838,
12841,
12839,
12840,
13369,
13372,
13370,
13371,
13329,
13332,
13330,
13331,
12962,
12965,
12963,
12964,
13106,
13109,
13107,
13108,
12823,
12827,
12824,
12826,
12817,
12820,
12818,
12819,
12957,
12958,
12948,
12949,
12968,
12969,
12953,
12954,
13386,
13387,
13214,
13215,
13035,
13038,
13036,
13037,
13291,
13294,
13292,
13293,
13306,
13309,
13307,
13308,
13093,
13096,
13094,
13095,
13082,
13083,
13208,
13211,
13209,
13210,
12883,
12884,
12868,
12872,
12869,
12871,
12876,
12879,
12877,
12878,
13173,
13174,
13168,
13169,
]

_charnames_64467 = [
13099,
13102,
13100,
13101,
13392,
13393,
13426,
13427,
13182,
13183,
13391,
13374,
13375,
13059,
13060,
13055,
13056,
13420,
13423,
13421,
13422,
13396,
13395,
12267,
12268,
12270,
12271,
12298,
12299,
12301,
12302,
12304,
12305,
12274,
12275,
12294,
12296,
12295,
12781,
12783,
12782,
13262,
13265,
13263,
13264,
12307,
12290,
12281,
12265,
12277,
12574,
12553,
12567,
12561,
12577,
12571,
12206,
12187,
12198,
12175,
12212,
12209,
12234,
12221,
12229,
12226,
12700,
12693,
12630,
12626,
12457,
12462,
12454,
12118,
12098,
12110,
12092,
12139,
12146,
12678,
12666,
12659,
12675,
12253,
12246,
12776,
12600,
12593,
12769,
12763,
12726,
12729,
12715,
12719,
12732,
12723,
12750,
12744,
12753,
12747,
12435,
12444,
12447,
12441,
12427,
12421,
12433,
12438,
12388,
12399,
12407,
12374,
12363,
12410,
12519,
12535,
12527,
12539,
12544,
12546,
12475,
12484,
12502,
12494,
12505,
12499,
12648,
12645,
12652,
12650,
12334,
12315,
12341,
12328,
12344,
12338,
12236,
12785,
12614,
12076,
12071,
12079,
12075,
12070,
12080,
12310,
12309,
12284,
12311,
12266,
12278,
12580,
12579,
12564,
12581,
12578,
12572,
12215,
12214,
12178,
12216,
12213,
12210,
12232,
12231,
12224,
12233,
12230,
12227,
12733,
12724,
12754,
12748,
12436,
12430,
12424,
12434,
12439,
12377,
12364,
12411,
12545,
12542,
12508,
12507,
12497,
12509,
12506,
12500,
12615,
12347,
12346,
12331,
12348,
12345,
12339,
12308,
12291,
12312,
12282,
12288,
12575,
12554,
12568,
12562,
12558,
12207,
12188,
12199,
12176,
12191,
12222,
12701,
12694,
12631,
12627,
12458,
12455,
12119,
12099,
12111,
12093,
12140,
12157,
12147,
12679,
12667,
12660,
12676,
12254,
12777,
12601,
12594,
12770,
12764,
12727,
12730,
12716,
12720,
12751,
12745,
12445,
12448,
12442,
12428,
12422,
12389,
12400,
12408,
12375,
12401,
12520,
12536,
12528,
12540,
12476,
12485,
12503,
12495,
12488,
12649,
12646,
12651,
12335,
12316,
12342,
12329,
12320,
12283,
12287,
12563,
12557,
12177,
12190,
12223,
12235,
12094,
12103,
12042,
12029,
12429,
12423,
12376,
12496,
12487,
12330,
12319,
12078,
12074,
12069,
12256,
12250,
12606,
12603,
12772,
12766,
12128,
12122,
12064,
12058,
12637,
12634,
12706,
12703,
12460,
12451,
12155,
12149,
12681,
12669,
12046,
12024,
12053,
12040,
12061,
12125,
12152,
12672,
12257,
12251,
12607,
12604,
12773,
12767,
12129,
12123,
12065,
12059,
12638,
12635,
12707,
12704,
12461,
12452,
12156,
12150,
12682,
12670,
12050,
12027,
12056,
12043,
12062,
12126,
12153,
12673,
12047,
12025,
12054,
12041,
12104,
12030,
12247,
12120,
12101,
12112,
12049,
12026,
12055,
12248,
12778,
12612,
12611,
25290,
25289,
]

_charnames_64848 = [
12203,
12184,
12183,
12185,
12195,
12171,
12172,
12170,
12689,
12688,
12623,
12624,
12100,
12115,
12116,
12089,
12088,
12090,
12086,
12085,
12136,
12135,
12144,
12021,
12020,
12048,
12038,
12037,
12035,
12034,
12664,
12657,
12656,
12242,
12241,
12244,
12243,
12598,
12589,
12588,
12591,
12760,
12759,
12761,
12713,
12712,
12740,
12742,
12395,
12396,
12397,
12384,
12385,
12405,
12404,
12371,
12370,
12533,
12532,
12531,
12517,
12515,
12525,
12524,
-1,
-1,
12516,
12643,
12642,
12481,
12482,
12468,
12467,
12473,
12491,
12492,
12325,
12324,
12569,
12202,
12204,
12194,
12196,
12169,
12173,
12690,
12698,
12691,
12108,
12137,
12022,
12663,
12386,
12372,
12317,
12336,
12326,
12541,
12741,
12480,
12739,
12394,
12590,
12419,
12470,
12523,
12381,
12418,
12382,
12471,
12697,
12632,
12514,
12721,
12555,
12417,
12597,
12143,
12107,
12472,
]

_charnames_65008 = [
12161,
12755,
12616,
12618,
12547,
12164,
12786,
12617,
12787,
12162,
12163,
12708,
25648,
12582,
-1,
-1,
23731,
23842,
23976,
23965,
23954,
23943,
23932,
23921,
23910,
23831,
23820,
23809,
23798,
23787,
23776,
23765,
26384,
26382,
26381,
26385,
26388,
26377,
26389,
26351,
26365,
26390,
-1,
-1,
-1,
-1,
-1,
-1,
3562,
3561,
3574,
3573,
3703,
3702,
3477,
]

_charnames_65072 = [
26387,
26379,
26378,
26362,
26386,
26358,
26372,
26354,
26368,
26356,
26370,
26360,
26374,
26359,
26373,
26361,
26375,
26355,
26369,
26352,
26366,
19750,
27589,
26357,
26371,
24859,
5204,
27706,
24287,
24860,
5205,
27704,
19664,
19685,
19688,
-1,
19682,
19665,
19683,
19653,
19655,
19669,
19645,
19670,
19646,
19668,
19644,
19684,
19680,
19679,
19676,
19686,
19671,
19687,
19654,
-1,
19647,
19689,
19677,
19663,
-1,
-1,
-1,
-1,
13495,
13512,
13503,
13513,
13518,
-1,
13493,
13492,
13506,
13505,
13521,
13520,
13485,
13484,
13480,
13479,
12915,
12990,
12991,
12986,
12987,
13315,
13316,
12982,
12983,
13155,
13158,
13156,
13157,
13006,
13007,
13230,
13233,
13231,
13232,
12795,
12797,
12803,
12805,
12804,
12798,
12846,
12849,
12847,
12848,
13380,
13383,
13381,
13382,
12910,
12913,
12911,
12912,
13064,
13067,
13065,
13066,
12936,
12937,
12852,
12853,
13203,
13204,
13363,
13364,
13124,
13127,
13125,
13126,
13141,
13145,
13142,
13144,
13134,
13137,
13135,
13136,
12941,
12945,
12942,
12944,
12857,
12861,
12858,
12860,
13357,
13360,
13358,
13359,
13018,
13021,
13019,
13020,
13298,
13302,
13299,
13301,
13278,
13281,
13279,
13280,
13403,
13406,
13404,
13405,
13048,
13051,
13049,
13050,
13349,
13352,
13350,
13351,
13413,
13416,
13414,
13415,
13085,
13088,
13086,
13087,
12887,
12890,
12888,
12889,
13323,
13324,
13004,
13005,
13176,
13179,
13177,
13178,
12360,
12361,
12357,
12358,
12354,
12355,
12365,
12366,
-1,
-1,
27906,
-1,
27320,
27311,
27314,
27283,
27302,
27306,
27305,
27264,
27288,
27304,
27301,
27295,
27327,
27328,
27308,
27279,
27280,
27271,
27272,
27277,
27278,
27274,
27275,
27282,
27281,
27296,
27309,
27266,
27321,
27317,
27312,
27294,
27259,
27258,
27257,
27256,
27255,
27254,
27253,
27252,
27251,
27250,
27249,
27248,
27247,
27246,
27245,
27244,
27243,
27242,
27241,
27240,
27239,
27238,
27237,
27236,
27235,
27234,
27263,
27290,
27287,
27297,
27267,
27318,
27232,
27231,
27230,
27229,
27228,
27227,
27226,
27225,
27224,
27223,
27222,
27221,
27220,
27219,
27218,
27217,
27216,
27215,
27214,
27213,
27212,
27211,
27210,
27209,
27208,
27207,
27265,
27324,
27289,
27325,
27262,
27286,
20583,
20581,
20578,
20584,
20509,
20500,
20453,
20451,
20448,
20452,
20450,
20447,
20445,
20446,
20449,
20510,
20506,
20504,
20502,
20505,
20503,
20488,
20486,
20484,
20487,
20485,
20458,
20456,
20454,
20457,
20455,
20470,
20468,
20466,
20469,
20467,
20464,
20462,
20460,
20463,
20461,
20494,
20492,
20490,
20493,
20491,
20482,
20480,
20478,
20481,
20479,
20498,
20496,
20497,
20476,
20474,
20472,
20475,
20473,
20501,
20459,
20507,
20508,
20575,
20554,
20536,
20555,
20549,
20552,
20551,
20561,
20533,
20513,
20521,
20520,
20516,
20519,
20518,
20517,
20522,
20573,
20546,
20535,
20547,
20538,
20534,
20566,
20568,
20537,
20569,
20556,
20562,
20548,
20574,
-1,
-1,
-1,
20570,
20571,
20526,
20527,
20559,
20557,
-1,
-1,
20525,
20524,
20563,
20542,
20543,
20564,
-1,
-1,
20529,
20572,
20541,
20540,
20544,
20528,
-1,
-1,
20558,
20530,
20565,
-1,
-1,
-1,
27298,
27300,
27315,
27326,
27329,
27322,
27323,
-1,
20587,
20580,
20586,
20577,
20588,
20589,
20585,
]

_charnames_65529 = [
27107,
27106,
27105,
25427,
25895,
-1,
-1,
9383,
9411,
9373,
9398,
9426,
9390,
9403,
9384,
9422,
9369,
9364,
9402,
-1,
9413,
9396,
9353,
9404,
9394,
9360,
9430,
9431,
9423,
9357,
9421,
9378,
9385,
9377,
9417,
9368,
9365,
9388,
9358,
9410,
9425,
9370,
9420,
9352,
9379,
9415,
-1,
9399,
9374,
9367,
9389,
9375,
9416,
9382,
9407,
9424,
9363,
9362,
9387,
9412,
9386,
9392,
9366,
9355,
9408,
9406,
-1,
9419,
9356,
-1,
9380,
9376,
9405,
9429,
9359,
9434,
9401,
9372,
9397,
9354,
9414,
9393,
9395,
9428,
9433,
-1,
-1,
9449,
9448,
9453,
9452,
9446,
9445,
9451,
9443,
9442,
9450,
9440,
9439,
9438,
9437,
]

_charnames_65664 = [
9227,
9226,
9225,
9212,
9211,
9210,
9224,
9223,
9221,
9220,
9218,
9217,
9215,
9214,
9277,
9276,
9275,
9274,
9273,
9461,
9460,
9281,
9280,
9279,
9458,
9457,
9271,
9270,
9269,
9268,
9267,
9257,
9256,
9255,
9254,
9253,
9462,
9252,
9251,
9250,
9238,
9237,
9236,
9235,
9234,
9233,
9232,
9231,
9230,
9229,
9248,
9247,
9246,
9245,
9244,
9243,
9242,
9241,
9240,
9265,
9264,
9263,
9262,
9261,
9260,
9259,
9284,
9283,
9314,
9313,
9311,
9310,
9309,
9308,
9307,
9306,
9304,
9303,
9302,
9301,
9300,
9299,
9463,
9298,
9297,
9295,
9294,
9293,
9292,
9291,
9290,
9289,
9288,
9287,
9348,
9338,
9337,
9336,
9335,
9334,
9333,
9332,
9331,
9330,
9329,
9327,
9326,
9325,
9324,
9323,
9322,
9321,
9320,
9319,
9318,
9345,
9344,
9343,
9342,
9341,
9340,
9346,
9347,
-1,
-1,
-1,
-1,
-1,
13884,
13885,
13891,
-1,
-1,
-1,
-1,
13871,
13816,
13823,
13846,
13853,
13832,
13838,
13865,
13859,
13829,
13820,
13827,
13850,
13857,
13833,
13839,
13866,
13860,
13874,
13819,
13826,
13849,
13856,
13837,
13843,
13870,
13864,
13873,
13818,
13825,
13848,
13855,
13836,
13842,
13869,
13863,
13830,
13821,
13828,
13851,
13858,
13834,
13840,
13867,
13861,
-1,
-1,
-1,
13882,
13879,
138