#!/bin/sh
# Determine the translation options and translate

set -e -u

usage() {
	name=$(basename $0)
	echo <<EOF
Usage: $name [options...]"
Options:
  --sandbox       Translate a sandboxed PyPy
  --python=PYTHON Use PYTHON to tranlate PyPy

EOF
}

SANDBOX=0
PYTHON=python

while [ $# -ge 1 ]; do
	case "$1" in
	--sandbox)
		SANDBOX=1
		;;
	--python)
		PYTHON="$2"
		shift
		;;
	--help|-h)
		usage
		exit 0
		;;
	*)
		echo "Unkown option: $1" >&2
		usage
		exit 1
		;;
	esac
	shift
done

OPTIONS="--batch --source"

OPT=3
if echo "$DEB_BUILD_OPTIONS" | egrep -q '\bnoopt\b'; then
	OPT=0
elif [ $SANDBOX -gt 0 ]; then
	OPT=2
elif dpkg-architecture -iany-i386; then
	OPT=jit
	#OPTIONS="$OPTIONS --jit-backend=x86-without-sse2"
elif dpkg-architecture -iany-amd64; then
	OPT=jit
else
	OPT=3
fi
OPTIONS="$OPTIONS --opt=$OPT"

if [ $SANDBOX -gt 0 ]; then
	OPTIONS="$OPTIONS --sandbox --gc=generation --gcrootfinder=shadowstack"
fi

set -x
cd pypy/translator/goal
exec "$PYTHON" -u translate.py $OPTIONS targetpypystandalone
