'''OpenGL extension NV.geometry_program4

This module customises the behaviour of the 
OpenGL.raw.GL.NV.geometry_program4 to provide a more 
Python-friendly API

Overview (from the spec)
	
	NV_geometry_program4 defines a new type of program available to be run on
	the GPU, called a geometry program.  Geometry programs are run on full
	primitives after vertices are transformed, but prior to flat shading and
	clipping.
	
	A geometry program begins with a single primitive - a point, line, or
	triangle.  Quads and polygons are allowed, but are decomposed into
	individual triangles prior to geometry program execution.  It can read the
	attributes of any of the vertex in the primitive and use them to generate
	new primitives.  A geometry program has a fixed output primitive type,
	either a point, a line strip, or a triangle strip.  It emits vertices
	(using the EMIT opcode) to define the output primitive.  The attributes of
	emitted vertices are specified by writing to the same set of result
	bindings (e.g., "result.position") provided for vertex programs.
	Additionally, a geometry program can emit multiple disconnected primitives
	by using the ENDPRIM opcode, which is roughly equivalent to calling End
	and then Begin again.  The primitives emitted by the geometry program are
	then clipped and then processed like an equivalent OpenGL primitive
	specified by the application.
	
	This extension provides four additional primitive types:  lines with
	adjacency, line strips with adjacency, separate triangles with adjacency,
	and triangle strips with adjacency.  Some of the vertices specified in
	these new primitive types are not part of the ordinary primitives.
	Instead, they represent neighboring vertices that are adjacent to the two
	line segment end points (lines/strips) or the three triangle edges
	(triangles/tstrips).  These "adjacency" vertices can be accessed by
	geometry programs and used to match up the outputs of the geometry program
	with those of neighboring primitives.
	
	Additionally, geometry programs allow for layered rendering, where entire
	three-dimensional, cube map, or array textures (EXT_texture_array) can be
	bound to the current framebuffer.  Geometry programs can use the
	"result.layer" binding to select a layer or cube map face to render to.
	Each primitive emitted by such a geometry program is rendered to the layer
	taken from its provoking vertex.
	
	Since geometry programs expect a specific input primitive type, an error
	will occur if the application presents primtives of a different type.  For
	example, if an enabled geometry program expects points, an error will
	occur at Begin() time, if a primitive mode of TRIANGLES is specified.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/geometry_program4.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.geometry_program4 import *
### END AUTOGENERATED SECTION