#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

# Stupid vector character set

Ht = 1.0  # caps height
ht = 0.6  # lower height
ds = -0.4 # lower depth

Bvl = 0.11  # caps bevel
bvl = 0.09 # lower bevel

Mw = 0.6 # M width
Nw = 0.5 # N width
mw = 0.5 # m width
nw = 0.3 # n width
Iw = 0.25 # I width
iw = 0.05 # i width

sp = 0.20

# calculated values

Ht_Bvl  = Ht - Bvl
Ht_bvl  = Ht - bvl
ht_bvl  = ht - bvl
Nw_Bvl  = Nw - Bvl
nw_bvl  = nw - bvl
Mw_Bvl  = Mw - Bvl
Ht_2    = Ht / 2.0
ht_2    = ht / 2.0
ds_bvl  = ds + bvl
iw_2    = iw / 2.0

Nw_Btop = Nw * 7 / 8.0
Nw_Bbot = Nw / 8.0
Nw_BBvl = Nw_Btop - Bvl
Ht_2pBvl = Ht_2 + Bvl
Ht_2mBvl = Ht_2 - Bvl
ht_2mbvl = ht_2 - bvl
ht_2pbvl = ht_2 + bvl

Mw_2    = Mw / 2.0
Iw_2    = Iw / 2.0
Nw_2    = Nw / 2.0
Nw_4    = Nw / 4.0
Nw3_4    = Nw * 3/ 4.0
nw_2    = nw / 2.0
Nw_Iw   = Nw - Iw
Nw_Iw_2 = Nw - Iw_2
Nw_Iw_2_Bvl = Nw_Iw_2 - Bvl
mw_2    = mw / 2.0

Msp = Mw + sp
Nsp = Nw + sp
msp = mw + sp
nsp = nw + sp
Isp = Iw + sp
isp = iw + sp

# Depth

# 0 = newpath, x,y
# 1 = continue, x,y
     
plain = {
    ' ': [ Nsp, []],   
    'A': [ Nsp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                1, Nw, 0.0,
                0, 0.0, Ht_2,
                1, Nw, Ht_2
                ],
             ],
    'B': [ Nsp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw_BBvl, Ht,
                1, Nw_Btop, Ht_Bvl,            
                1, Nw_Btop, Ht_2pBvl,
                1, Nw_BBvl, Ht_2,
                0, 0.0, Ht_2,
                1, Nw_Bvl, Ht_2,
                1, Nw, Ht_2mBvl,
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, 0.0, 0.0,
                ],
             ],
    'C': [ Nsp,
             [
                0, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                ],
             ],
    'D': [ Nsp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw_2, Ht,
                1, Nw, Ht-Bvl*2,            
                1, Nw, Bvl*2,
                1, Nw_2, 0.0,
                1, 0.0, 0.0,
                ],
             ],
    'E': [ Nsp,
             [ 0, Nw, 0.0,
                1, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw, Ht,
                0, 0.0, Ht_2,
                1, Nw_Bvl, Ht_2,
                ],
             ],
    'F': [ Nsp,
             [ 
                0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw, Ht,
                0, 0.0, Ht_2,
                1, Nw_Bvl, Ht_2,
                ],
             ],
    'G': [ Nsp,
             [
                0, Nw_2, Ht_2,   
                1, Nw, Ht_2,   
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                ],
             ],
    'H': [ Nsp,
             [ 
                0, 0.0, 0.0,
                1, 0.0, Ht,
                0, Nw, 0.0,
                1, Nw, Ht,
                0, 0.0, Ht_2,
                1, Nw, Ht_2,
                ],
             ],
    'I': [ Isp,
             [ 
                0, 0.0, 0.0,
                1, Iw, 0.0,
                0, Iw_2, 0.0,
                1, Iw_2, Ht,
                0, 0.0, Ht,
                1, Iw, Ht,
                ],
             ],
    'J': [ Nsp,
             [
                0, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Iw_2_Bvl, 0.0,
                1, Nw_Iw_2, Bvl,            
                1, Nw_Iw_2, Ht,
                0, Nw_Iw, Ht,
                1, Nw, Ht,
                ],
             ],
    'K': [ Nsp,
             [ 
                0, 0.0, 0.0,
                1, 0.0, Ht,
                0, Nw, Ht,
                1, 0.0, Ht_2-Bvl,
                0, Bvl*(Nw/(Ht_2+Bvl)), Ht_2,
                1, Nw, 0.0,
                ],
             ],
    'L': [ Nsp,
             [ 0, Nw, 0.0,
                1, 0.0, 0.0,
                1, 0.0, Ht,
                ],
             ],
    'M': [ Msp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Mw_2, Ht_2,
                1, Mw, Ht,
                1, Mw, 0.0,
                ],
             ],
    'N': [ Nsp,
             [ 
                0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw, 0.0,
                1, Nw, Ht,                        
                ],
             ],
    'O': [ Nsp,
             [ 
                0, Nw_Bvl, Ht,   
                1, Nw, Ht_Bvl,   
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                ],
             ],
    'P': [ Nsp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw_Bvl, Ht,
                1, Nw, Ht_Bvl,            
                1, Nw, Ht_2pBvl,
                1, Nw_Bvl, Ht_2,
                1, 0.0, Ht_2,
                ],
             ],
    'Q': [ Nsp,
             [ 
                0, Nw_Bvl, Ht,   
                1, Nw, Ht_Bvl,   
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,
                0, Nw, 0.0,
                1, Nw_BBvl,Nw_Bbot+Bvl,
                ],
             ],
    'R': [ Nsp,
             [ 0, 0.0, 0.0,
                1, 0.0, Ht,
                1, Nw_Bvl, Ht,
                1, Nw, Ht_Bvl,            
                1, Nw, Ht_2pBvl,
                1, Nw_Bvl, Ht_2,
                1, 0.0, Ht_2,
                0, Bvl,Ht_2,
                1, Nw,0.0,
                ],
             ],
    'S': [ Nsp,
             [
                0, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Bvl, 0.0,
                1, Nw, Bvl,
                1, Nw, Ht_2mBvl,
                1, Nw_Bvl, Ht_2,
                1, Bvl, Ht_2,
                1, 0.0, Ht_2pBvl,                                    
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                ],
             ],
    'T': [ Nsp,
             [ 0, 0.0, Ht,
                1, Nw, Ht,
                0, Nw_2, 0.0,
                1, Nw_2, Ht,
                ],
             ],
    'U': [ Nsp,
             [
                0, Nw, Ht,   
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, 0.0, Ht,
                ],
             ],
    'V': [ Nsp,
             [
                0, 0.0, Ht,   
                1, Nw_2, 0.0,
                1, Nw, Ht,
                ],
             ],
    'W': [ Msp,
             [ 0, 0.0, Ht,
                1, Bvl, 0.0,
                1, Mw_2, Ht_2,
                1, Mw_Bvl, 0.0,
                1, Mw, Ht,
                ],
             ],
    'X': [ Nsp,
             [ 0, 0.0, 0.0,
                1, Nw, Ht,
                0, Nw, 0.0,
                1, 0.0, Ht,
                ],
             ],
    'Y': [ Nsp,
             [ 0, 0.0, Ht,
                1, Nw_2, Ht_2,
                1, Nw, Ht,
                0, Nw_2, Ht_2,
                1, Nw_2, 0.0,
                ],
             ],
    'Z': [ Nsp,
             [ 
                0, 0.0, Ht,
                1, Nw, Ht,
                1, 0.0, 0.0,
                1, Nw, 0.0,                        
                ],
             ],
    '1': [ Isp,
             [ 
                0, 0.0, Ht_Bvl,
                1, Iw_2, Ht,
                1, Iw_2, 0.0,
                0, 0.0, 0.0,
                1, Iw, 0.0,
                ],
             ],
    '2': [ Nsp,
             [
                0, Nw, 0.0,
                1, 0.0, 0.0,
                1, 0.0, Bvl,
                1, Nw, Ht_Bvl - Bvl,            
                1, Nw, Ht_Bvl,
                1, Nw_Bvl, Ht,            
                1, Bvl, Ht,
                1, 0.0, Ht_Bvl,
                ],
             ],
    '3': [ Nsp,
             [
                0, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Bvl, 0.0,
                1, Nw, Bvl,
                1, Nw, Ht_2mBvl,
                1, Nw_Bvl, Ht_2,
                1, Bvl, Ht_2,
                0, Nw_Bvl, Ht_2,
                1, Nw, Ht_2pBvl,            
                1, Nw, Ht_Bvl,
                1, Nw_Bvl, Ht,            
                1, Bvl, Ht,
                1, 0.0, Ht_Bvl,
                ],
             ],
    '4': [ Nsp,
             [
                0, Nw_2, Ht,
                1, 0.0, Ht_2,
                1, Nw, Ht_2,
                0, Nw_Bvl,Ht,
                1, Nw_Bvl,0.0            
                ],
             ],
    '5': [ Nsp,
             [
                0, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Bvl, 0.0,
                1, Nw, Bvl,
                1, Nw, Ht_2,
                1, Nw_Bvl, Ht_2pBvl,
                1, Bvl, Ht_2pBvl,
                1, 0.0, Ht_2,                                    
                1, 0.0, Ht,
                1, Nw, Ht,
                ],
             ],
    '6': [ Nsp,
             [
                0, Nw, Ht_Bvl,
                1, Nw_Bvl, Ht,         
                1, Bvl, Ht,      
                1, 0.0, Ht_Bvl,   
                1, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Bvl, 0.0,
                1, Nw, Bvl,
                1, Nw, Ht_2mBvl,
                1, Nw_Bvl, Ht_2,
                1, Bvl, Ht_2,
                1, 0.0, Ht_2mBvl,                                    
                ],
             ],
    '7': [ Nsp,
             [
                0, Nw_2,0.0,
                1, Nw, Ht,
                1, 0.0, Ht,
                1, 0.0, Ht_Bvl,
                ],
             ],
    '8': [ Nsp,
             [
                0, Bvl, Ht_2,
                1, 0.0, Ht_2mBvl,            
                1, 0.0, Bvl,
                1, Bvl, 0.0,
                1, Nw_Bvl, 0.0,
                1, Nw, Bvl,
                1, Nw, Ht_2mBvl,
                1, Nw_Bvl, Ht_2,
                1, Bvl, Ht_2,
                1, 0.0, Ht_2pBvl,                                    
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                1, Nw, Ht_2pBvl,
                1, Nw_Bvl, Ht_2,                        
                ],
             ],
    '9': [ Nsp,
             [
                0, Nw, Ht_2pBvl,
                1, Nw_Bvl, Ht_2,
                1, Bvl, Ht_2,
                1, 0.0, Ht_2pBvl,                                    
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,            
                1, Nw, Ht_Bvl,
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                ],
             ],
    '0': [ Nsp,
             [ 
                0, Nw_Bvl, Ht,   
                1, Nw, Ht_Bvl,   
                1, Nw, Bvl,
                1, Nw_Bvl, 0.0,
                1, Bvl, 0.0,
                1, 0.0, Bvl,
                1, 0.0, Ht_Bvl,
                1, Bvl, Ht,
                1, Nw_Bvl, Ht,
                0, Nw, Ht_Bvl,
                1, 0.0,Bvl,
                ],
             ],
    'a': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,            
                0, nw, ht_2,
                1, nw_bvl, ht_2pbvl,
                1, bvl, ht_2pbvl,
                1, 0.0, ht_2,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                0, nw, 0.0,
                1, nw, ht,            
                ],
             ],
    'b': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                1, nw, bvl,
                1, nw_bvl, 0.0,
                1, bvl, 0.0,
                1, 0.0, bvl,
                
                0, 0.0,0.0,
                1, 0.0, Ht,            
                ],
             ],
    'c': [ nsp,
             [
                0, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                ],
             ],
    'd': [ nsp,
             [
                0, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                0, nw, 0.0,
                1, nw, Ht,            
                ],
             ],
    'e': [ nsp,
             [
                0, 0.0, ht_2,
                1, nw_bvl, ht_2,
                1, nw, ht_2pbvl,            
                1, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                ],
             ],
    'f': [ nsp,
             [
                0, bvl, 0.0,
                1, bvl, Ht_bvl,
                1, nw_2, Ht,
                1, nw_2+bvl, Ht,
                1, nw, Ht-bvl,
                0, 0.0, ht,
                1, 2*bvl,ht,
                ],
             ],
    'g': [ nsp,
             [
                0, 0.0, ds_bvl,
                1, bvl, ds,                  
                1, nw_bvl, ds,      
                1, nw, ds_bvl,   
                1, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                ],
             ],
    'h': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                1, nw, bvl,
                1, nw, 0.0,
                0, 0.0,0.0,
                1, 0.0, Ht,            
                ],
             ],
    'i': [ isp,
             [
                0, iw_2, 0.0,
                1, iw_2, ht_bvl,
                0, iw_2, ht+bvl,
                1, iw_2, ht+2*bvl,
                ],
             ],
    'j': [ nsp,
             [
                0, 0.0, ds_bvl,
                1, bvl, ds,                  
                1, nw_bvl, ds,      
                1, nw, ds_bvl,   
                1, nw, ht_bvl,
                0, nw, ht+bvl,
                1, nw, ht+2*bvl,
                ],
             ],
    'k': [ nsp,
             [
                0, 0.0, 0.0,
                1, 0.0, Ht,
                0, nw, ht,
                1, 0.0, ht_2,
                1, nw, 0.0
                ],
             ],
    'l': [ isp,
             [ 
                0, 0.0, Ht,
                1, 0.0, 0.0,
                ],
             ],
    'm': [ msp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, mw_2-bvl, ht,
                1, mw_2, ht_bvl,
                1, mw_2, 0.0,
                0, mw_2, ht_bvl,
                1, mw_2+bvl, ht,
                1, mw-bvl, ht,
                1, mw, ht_bvl,
                1, mw, 0.0,
                0, 0.0,0.0,
                1, 0.0, ht,            
                ],
             ],
    'n': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                1, nw, bvl,
                1, nw, 0.0,
                0, 0.0,0.0,
                1, 0.0, ht,            
                ],
             ],
    'o': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                1, nw, bvl,
                1, nw_bvl, 0.0,
                1, bvl, 0.0,
                1, 0.0, bvl,
                1, 0.0, ht_bvl,            
                ],
             ],
    'p': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                1, nw, bvl,
                1, nw_bvl, 0.0,
                1, bvl, 0.0,
                1, 0.0, bvl,
                
                0, 0.0,ds,
                1, 0.0, ht,            
                ],
             ],
    'q': [ nsp,
             [
                0, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                0, nw, ds,
                1, nw, ht,            
                ],
             ],
    'r': [ nsp,
             [
                0, 0.0, ht_bvl,
                1, bvl, ht,
                1, nw_bvl, ht,
                1, nw, ht_bvl,
                0, 0.0,0.0,
                1, 0.0, ht,            
                ],
             ],
    's': [ nsp,
             [
                0, nw, ht_bvl,
                1, nw_bvl, ht,
                1, bvl, ht,
                1, 0.0, ht_bvl,
                1, 0.0, ht_2pbvl,
                1, bvl, ht_2,
                1, nw_bvl, ht_2,
                1, nw, ht_2mbvl,                                                
                1, nw, bvl,
                1, nw_bvl, 0.0,
                1, bvl, 0.0,
                1, 0.0, bvl,
                ],
             ],
    't': [ nsp,
             [
                0, bvl, Ht,
                1, bvl, bvl,
                1, nw_2, 0.0,
                1, nw_2+bvl, 0.0,
                1, nw, bvl,
                0, 0.0, ht,
                1, 2*bvl,ht,
                ],
             ],
    'u': [ nsp,
             [
                0, 0.0, ht,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,
                0, nw, 0.0,
                1, nw, ht,            
                ],
             ],
    'v': [ nsp,
             [
                0, 0.0, ht,
                1, nw_2, 0.0,
                1, nw,  ht,
                ],
             ],
    'w': [ msp,
             [
                0, 0.0, ht,
                1, mw_2-bvl, 0.0,
                1, mw_2, ht_2,
                1, mw_2+bvl, 0.0,
                1, mw, ht,
                ],
             ],
    'x': [ nsp,
             [ 0, 0.0, 0.0,
                1, nw, ht,
                0, nw, 0.0,
                1, 0.0, ht,
                ],
             ],
    'y': [ nsp,
             [
                0, 0.0, ds_bvl,
                1, bvl, ds,                  
                1, nw_bvl, ds,      
                1, nw, ds_bvl,   
                1, nw, ht,
                0, 0.0, ht,
                1, 0.0, bvl,
                1, bvl, 0.0,
                1, nw_bvl, 0.0,
                1, nw, bvl,

                ],
             ],
    'z': [ nsp,
             [ 0, 0.0, ht,
                1, nw, ht,
                1, 0.0, 0.0,
                1, nw, 0.0,
                ],
             ],
    '.': [ isp,
             [
                0, iw_2-bvl/3.0, 0.0,
                1, iw_2-bvl/3.0, 1.2*bvl,
                1, iw_2+bvl/3.0, 1.2*bvl,
                1, iw_2, 0.6*bvl,
                1, iw_2+bvl/3.0, 0.0,
                1, iw_2-bvl/3.0, 0.0,
                ],
             ],
    ',': [ isp,
             [
                0, iw_2-bvl/2, 0.0,
                1, iw_2+bvl/2, 2*bvl,
                ],
             ],
    '!': [ isp,
             [
                0, iw_2, 0.0,
                1, iw_2, 1.2*bvl,
                0, iw_2, Ht,
                1, iw_2, ht_2+bvl/2,
                ],
             ],
    '*': [ Nsp,
             [
                0, 0.0, Ht_2,
                1, Nw, Ht_2,
                0, Nw_4, Bvl*2,
                1, Nw3_4, Ht-Bvl*2,
                0, Nw3_4, Bvl*2,
                1, Nw_4, Ht-Bvl*2,
                ],
             ],
    '+': [ Nsp,
             [
                0, 0.0, Ht_2,
                1, Nw, Ht_2,
                0, Nw_2, Bvl*2,
                1, Nw_2, Ht-Bvl*2,
                ],
             ],
    '-': [ Nsp,
             [
                0, 0.0, Ht_2,
                1, Nw, Ht_2,
                ],
             ],
    '(': [ Nsp,
             [
                0, Nw, Ht,
                1, Nw_2, Ht,
                1, 0.0, Ht-Bvl*2,
                1, 0.0, Bvl*2,
                1, Nw_2, 0.0,
                1, Nw, 0.0,            
                ],
             ],
    ')': [ Nsp,
             [
                0, 0.0, Ht,
                1, Nw_2, Ht,
                1, Nw, Ht-Bvl*2,
                1, Nw, Bvl*2,
                1, Nw_2, 0.0,
                1, 0.0, 0.0,            
                ],
             ],
    '[': [ Isp,
             [
                0, Iw, Ht,
                1, 0.0, Ht,
                1, 0.0, 0.0,
                1, Iw, 0.0,
                ],
             ],
    ']': [ Isp,
             [
                0, 0.0, Ht,
                1, Iw, Ht,
                1, Iw, 0.0,
                1, 0.0, 0.0,
                ],
             ],
    '/': [ Nsp,
             [
                0, 0.0, 0.0,
                1, Nw, Ht,
                ],
             ],
    '\\': [ Nsp,
             [
                0, 0.0, Ht,
                1, Nw, 0.0,
                ],
             ],
    '%': [ Nsp,
             [
                0, 0.0, 0.0,
                1, Nw, Ht,
                0, 0.0, Ht,
                1, Bvl, Ht,
                1, Bvl, Ht-Bvl,
                1, 0.0, Ht-Bvl,
                1, 0.0, Ht,            

                0, Nw, 0.0,
                1, Nw, Bvl,
                1, Nw-Bvl, Bvl,
                1, Nw-Bvl, 0.0,
                1, Nw, 0.0,            
                ],
             ],
    '<': [ Nsp,
             [
                0, Nw, Ht-Bvl,
                1, 0.0, Ht_2,
                1, Nw, Bvl,
                ],
             ],
    '>': [ Nsp,
             [
                0, 0.0, Ht-Bvl,
                1, Nw, Ht_2,
                1, 0.0, Bvl,
                ],
             ],
    
    }

def get_font(size,face,style):
    return plain



