#ifndef SKIN_H
#define SKIN_H

#include <QListWidgetItem>

#include "ui_previewer.h"
#include "ui_getskinname.h"

class Skin : public QListWidgetItem
{
    public:
         Skin(QListWidget* parent) : QListWidgetItem(parent) {};
         ~Skin() {};
         void setFile(QString file);
         QString filePass();
         QString name();
         QString skinFolder();
         QPixmap previewPixmap();

    private:
         QString filePass_;

};

class Previewer : public QDialog
{
    Q_OBJECT
    public:
        Previewer(Skin *skin, QWidget *parent = 0);
        bool loadSkinInformation();

    private:        
        Ui::Previewer ui_;
        Skin *skin_;

    signals:
        void applySkin();

};

class GetSkinName : public QDialog
{
    Q_OBJECT
    public:
        GetSkinName(QString name, QString author, QString version, QWidget *parent = 0);

    private slots:
        void okPressed();

    signals:
        void ok(QString, QString, QString);

    private:
        Ui::GetSkinName ui_;
    };

#endif // SKIN_H
