#ifndef SERVER_H
#define SERVER_H

#include <QListWidgetItem>

class Server : public QListWidgetItem
{
public:
	Server(QListWidget *parent = 0);
	QString displayName() { return displayName_; };
	QString url() { return url_; };
	QString userName() { return userName_; };
	QString password() { return password_; };
	QString proxyHost() { return proxyHost_; };
	int proxyPort() { return proxyPort_; };
	QString proxyUserPass() { return proxyUserPass_; };
	QString proxyUserName() { return proxyUserName_; };
	QString servPostdata() { return servPostdata_; };
	QString servFileinput() { return servFileinput_; };
	QString servRegexp() { return servRegexp_; };
	//QString servFilefilter() { return servFilefilter_; };
	void setServer(QString url, QString user = "", QString pass = "");
	void setServerData(QString post = "", QString fInput = "", QString reg = ""/*, QString fFilter = ""*/);
	void setProxy(QString host, QString port = "3128", QString user = "", QString pass = "");
	void setDisplayName(QString n);

	QString settingsToString();
	void setFromString(QString settings);

private:
	QString displayName_;
	QString url_, userName_, password_;
	QString proxyHost_, proxyUserName_, proxyUserPass_;
	int proxyPort_;
	QString servPostdata_, servFileinput_, servRegexp_/*, servFilefilter_*/;
};

#endif // SERVER_H
