#include "editserverdlg.h"

EditServerDlg::EditServerDlg(QWidget *parent)
	: QDialog(parent)
{
	setAttribute(Qt::WA_DeleteOnClose);
	setModal(false);
	ui_.setupUi(this);

	connect(ui_.buttonBox, SIGNAL(accepted()), SLOT(onOkPressed()));
}

void EditServerDlg::onOkPressed()
{
	QString settings = ui_.le_name->text() + "&split&" + ui_.le_url->text() + "&split&" + ui_.le_user->text() + "&split&" + ui_.le_pass->text() + "&split&";
	settings += ui_.le_proxy_host->text() + "&split&" + ui_.le_proxy_port->text() + "&split&" + ui_.le_proxy_user->text() + "&split&" + ui_.le_proxy_pass->text() + "&split&";
	settings += ui_.le_post_data->text() + "&split&" + ui_.le_file_input->text() + "&split&" + ui_.le_regexp->text();
	emit okPressed(settings, ui_.cb_all_servers->isChecked());
	close();
}

void EditServerDlg::setSettings(QString settings)
{
		QStringList l = settings.split("&split&");
		if(!l.isEmpty())
			ui_.le_name->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_url->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_user->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_pass->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_proxy_host->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_proxy_port->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_proxy_user->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_proxy_pass->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_post_data->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_file_input->setText(l.takeFirst());
		if(!l.isEmpty())
			ui_.le_regexp->setText(l.takeFirst());
}
