#include <QWebFrame>
#include <QFile>
#include <QDebug>
#include <QClipboard>
#include <QMimeData>
#include <QApplication>

#include "webview.h"
#include "urlobject.h"
#include "textutil.h"

WebView::WebView(QWidget* parent) : QWebView(parent)
{

    settings()->setAttribute(QWebSettings::JavaEnabled, false);
    settings()->setAttribute(QWebSettings::PluginsEnabled, false);
	setAcceptDrops(false);

	page()->setNetworkAccessManager(NetworkAccessManager::instance());
    page()->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);

    //actions
	//copyAction = page()->action(QWebPage::Copy);
	//copyLinkAction = page()->action(QWebPage::CopyLinkToClipboard);

	connect(page(), SIGNAL(linkClicked(const QUrl&)), this, SLOT(linkClickedEvent(const QUrl&)));
	connect(page()->action(QWebPage::Copy), SIGNAL(triggered()), SLOT(textCopiedEvent()));
}

void WebView::linkClickedEvent(const QUrl& url)
{
	qDebug()<<"clicked link: "<<url.toString();
	URLObject::getInstance()->popupAction(url.toEncoded());
}

void WebView::scrollToBottom()
{
	page()->mainFrame()->setScrollBarValue(Qt::Vertical,
                                           page()->mainFrame()->scrollBarMaximum(Qt::Vertical));
}


void WebView::scrollToTop()
{
    page()->mainFrame()->setScrollBarValue(Qt::Vertical, 0);
}

void WebView::contextMenuEvent(QContextMenuEvent* event)
{
	QWebHitTestResult r = page()->mainFrame()->hitTestContent(event->pos());
	QMenu *menu;

	if (!r.linkUrl().isEmpty()) {
		if (r.linkUrl().scheme() == "addnick") {
			event->ignore();
			return;
		}
		menu = URLObject::getInstance()->createPopupMenu(r.linkUrl());
		//menu->addAction(pageAction(QWebPage::CopyLinkToClipboard));
	} else {
		menu = new QMenu(this);
		if (!page()->selectedText().isEmpty()) {
			menu->addAction(pageAction(QWebPage::Copy));
		} else {
			if (!menu->isEmpty()) {
				menu->addSeparator();
			}
			menu->addAction(pageAction(QWebPage::SelectAll));
		}
	}
	menu->exec(mapToGlobal(event->pos()));
	event->accept();
	delete menu;
}

void WebView::escapeString(QString& str)
{

    str.replace("\r\n", "\n");  //windows
    str.replace("\r", "\n");    //mac
    str.replace("\\", "\\\\");
    str.replace("\"", "\\\"");
    str.replace("\n", "\\\n");
    str.replace(QChar(8232), "\\\n"); //ctrl+enter
}


QString WebView::escapeStringCopy(QString str)
{
    escapeString(str);
    return str;
}

void WebView::evaluateJS(QString scriptSource)
{
    page()->mainFrame()->evaluateJavaScript(scriptSource);
    //qDebug() << "HTMLChatView::evaluateJS(" << scriptSource << ")\n";
}

void WebView::copySelected()
{
	page()->triggerAction(QWebPage::Copy);
	textCopiedEvent();
}

void WebView::textCopiedEvent()
{
	QClipboard *cb = QApplication::clipboard();
	cb->setText(TextUtil::rich2plain(TextUtil::img2title(cb->mimeData()->html())));
}
