/**
 ** Proll (PROM replacement)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#include <stdarg.h>

#include <crs.h>
#include <asi.h>
#include "pgtsrmmu.h"
#include "phys_jk.h"
#include "vconsole.h"
#include "version.h"
#include <general.h>		/* __P() */
#include <net.h>		/* init_net() */
#include <romlib.h>		/* we are a provider for part of this. */
#include <netpriv.h>		/* myipaddr */
#include <arpa.h>
#include <system.h>		/* our own prototypes */
#include <silo_arg.h>		/* Interface to SILO */

#if 0
static int iga_find_darkest(void);
#endif
static void iga_set_color(int x, unsigned r, unsigned g, unsigned b);
int load_pre(struct silo_to_proll *ap);

struct vconterm dp0;
struct mem cmem;		/* Current memory, virtual */
struct mem cio;			/* Current I/O space */
struct phym pmem;		/* Current phys. mem. */
struct pcic cpcic;		/* Current PCIC. */

/*
 * This struct must be pre-initialized,
 * or our bss cleaning zaps parameters that were patched in.
 */
struct silo_to_proll silo_arg = {	/* <== Will be patched when loading */
   { "LROP" }
};

/*
 */
void prolmain()
{
	static char fname[14] = "00000000.PROL";
	static struct banks bb;
	int nmegs;
	int i;
	unsigned int hiphybas;
	void *romvec;
	struct silo_to_proll *ap;

	/*
	 * XXX OK we do not know if this causes any weird flashing.
	 * Waiting for user feedback.
	 */
	iga_set_color(255, 0, 0, 0);			/* background black */
	iga_set_color(0, 255, 255, 255);		/* foreground white */
	vcon_init(&dp0, PHYS_JK_MM_IGA);
	printk("PROLL %s Krups BOOTP+IGA+SILO\n", PROLL_VERSION_STRING);

	get_banks_layout(&bb, 2);
	if (bb.nbanks <= 0) {
		printk("No memory found\n");
		return;
	}

	printk("Memory:");
	nmegs = 0;
	for (i = 0; i < bb.nbanks; i++) {
		printk(" %d=0x%x[0x%x]", i,
		    bb.bankv[i].start, bb.bankv[i].length);
		nmegs += bb.bankv[i].length/(1024*1024);
	}
	printk(" total %d MB\n", nmegs);

	i = bb.nbanks - 1;
	hiphybas = bb.bankv[i].start + bb.bankv[i].length - PROLSIZE;
	/* printk("high phys base 0x%x\n", hiphybas); */ /* P3 */

	/*
	 * We generate tables and switch two times.
	 * We start off being in low physical memory (LOADBASE) and
	 * mapped to high virtual (PROLBASE), running off PROM tables.
	 * These tables are located somewhere in upper physical so
	 * when we copy ourselves up we may step on them. The
	 * solution is to create temporary pages in low physical memory,
	 * then use them to move ourselves high. After that we may
	 * create new tables in high physical memory.
	 */

	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, LOADBASE);
#if 0
	proc_tablewalk(0, PROLBASE+PROLSIZE-PAGE_SIZE);
	mem_tablewalk((pmem.pctp[0]&(~0xF))<<4, PROLBASE+PROLSIZE-PAGE_SIZE);
#endif
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + LOADBASE);
	move_phys_high(hiphybas, PROLSIZE);
	/*
	 * We did not use the dynamic memory for anything but
	 * page tables, which are left down in low memory. Reinitiate cmem.
	 */
	mem_fini(&cmem);
	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, hiphybas);
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + hiphybas);

	mem_init(&cio, (char *)(PROLBASE+PROLSIZE),
	    (char *)(PROLBASE+PROLSIZE+IOMAPSIZE));

	pcic_init(&cpcic, hiphybas);

	/*
	 */
	init_eeprom();

	sched_init();

	ap = &silo_arg;
	if (ap->magic[0] == 'S' && ap->magic[1] == 'i') {
		printk("Found SILO argument.\n");
		if (load_pre(ap) != 0) fatal();
	} else {
		printk("Booting from network.\n");
		hme_probe();
		init_net();
#if 0 /* RARP */
		if (rarp() != 0) fatal();
		/* printrarp(); */
		xtoa(myipaddr, fname, 8);
		if (load(servaddr, fname) != 0) fatal();
#else
		if (bootp() != 0) fatal();
		/*
		 * boot_rec.bp_file cannot be used because system PROM uses
		 * it to locate ourselves. If we load from boot_rec.bp_file,
		 * we will loop reloading PROLL over and over again.
		 * Thus we use traditional PROLL scheme "HEXIPADDR.PROL".
		 */
		xtoa(myipaddr, fname, 8);
		if (load(boot_rec.bp_siaddr, fname) != 0) fatal();
#endif
		ap = NULL;
	}

	pcic_map_irq(&cpcic, PHYS_JK_PIN_RTC, PHYS_JK_IRQ_RTC);
	romvec = init_openprom_silo(bb.nbanks, bb.bankv, hiphybas, ap);

	printk("Memory used: virt 0x%x:0x%x[%dK] iomap 0x%x:0x%x\n",
	    PROLBASE, (int)cmem.curp, ((unsigned) cmem.curp - PROLBASE)/1024,
	    (int)cio.start, (int)cio.curp);
	set_timeout(5);  while (!chk_timeout()) { }  /* Let user read */
	{
		void (*entry)(void *, int) = (void (*)(void*, int)) LOADBASE;
		entry(romvec, 0);
	}

	printk("bye.\n");	/* Not reached, but let it be. */
	mem_fini(&cmem);
	vcon_fini(&dp0);
	/* XXX Redo head.S so that it starts kernel */
}

#if 0
static int iga_find_darkest()
{
	unsigned int mmbase = PHYS_JK_MM_IGA | 0x00800000;
	unsigned int r, g, b, mod, mod1;
	int i, darkest;

	darkest = 0;
	mod = 0xff*0xff * 3;
	for (i = 0; i < 256; i++) {
		stb_bypass(mmbase + 0x3C7, i);
		r = ldb_bypass(mmbase + 0x3C9);
		g = ldb_bypass(mmbase + 0x3C9);
		b = ldb_bypass(mmbase + 0x3C9);
		mod1 = r*r + g*g + b*b;
		if (mod1 < mod) {
			mod = mod1;
			darkest = i;
		}
	}
/* P3 */ printk("darkest %d(0x%x) mod 0%x\n", darkest, darkest, mod);
	return darkest;
}
#endif

static void iga_set_color(int index,
    unsigned int r, unsigned int g, unsigned int b)
{
	unsigned int mmbase = PHYS_JK_PCI_IO;

	stb_bypass(mmbase + 0x3C8, index);
	stb_bypass(mmbase + 0x3C9, r);
	stb_bypass(mmbase + 0x3C9, g);
	stb_bypass(mmbase + 0x3C9, b);
}

/*
 * There is not a lot to do. Silo loaded stuff for us, so we move it.
 */
int load_pre(struct silo_to_proll *ap)
{
	int len;
	unsigned int *loadptr = (unsigned int *)LOADBASE;
	unsigned int *inbuf;

	len = (ap->kern_size + 3) & (~3);
	if (len < 0 || len > LOWMEMSZ) {
		printk("Illegal kernel size %d(0x%x)\n", len, len);
		return -1;
	}
	inbuf = (unsigned int *) ap->kern_base;
	printk("Kernel base 0x%x size %d(0x%x)\n", inbuf, len, len);

	while (len >= 4) {
		len -= 4;

		*loadptr++ = *inbuf++;
	}

	return 0;
}
 
#if 0
/*
 * This comes handy when we unplug the keyboard then say "boot net".
 * The system comes up with a disabled screen.
 */
static void iga_enable_visual()
{
	unsigned int mmbase = PHYS_JK_PCI_IO;

	stb_bypass(mmbase + 0x3C0, 0x20);
}
#endif

/*
 * dvma_alloc over iommu_alloc.
 */
void *dvma_alloc(int size, unsigned int *pphys)
{
        return pcic_alloc(&cpcic, size, pphys);
}

/*
 */
unsigned long virt_to_bus(volatile void *addr)
{
	return pcic_virt_to_bus(addr);
}

/*
 * Stub for hme.c
 */
unsigned long sbus_dvma_addr(void *addr) {
	printk("sbus_dvma_addr!\n");
	return (~0);
}

/*
 */
void udelay(unsigned long usecs)
{
	int i, n = usecs * 50;
	for (i = 0; i < n; i++) { }
}
