/***************************************************************************
                       lvi_playlist.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 
    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_playlist.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_Playlist::LVI_Playlist(QListView *parent, PLAYLIST *_playlist)
: QListViewItem(parent), playlist(_playlist) {
    setText(0,playlist->name);
    setPixmap(0, pixmapcache->get
              ("lvi_playlist.png"));
}

int LVI_Playlist::getID() {
    return playlist->id;
}
QString LVI_Playlist::getName() {
    return playlist->name;
}

void LVI_Playlist::setName(QString newname) {
    playlist->name = newname;
    setText(0,newname);
}

QString LVI_Playlist::key() {
    return playlist->name.lower();
}

LVI_Playlist::~LVI_Playlist() {
    delete playlist;
}
