/***************************************************************************
                          lvi_cddrive.h  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LVI_CDDRIVE_H
#define LVI_CDDRIVE_H

#include <qlistview.h>

#define NO_AUTOMOUNT  0
#define SUPERMOUNT    1
#define SUBMOUNT      2

class LVI_CDDrive : public QListViewItem  {
public:
    LVI_CDDrive(QListView *parent, int _driveID, QString _path, QString _device, int _isSuperMounted);

    void lock(QString comment)
        ;
    void unlock();

    void applyMount(unsigned checksum);
    void applyUnmount();

    void applyInfo(bool isKnown, QString label, int cdID=0);

    int getDriveID()        {
        return driveID;
    }
    unsigned getChecksum()      {
        return checksum;
    }
    int getCdID()               {
        return cdID;
    }
    bool getIsKnown()       {
        return isKnown;
    }
    bool getIsLocked()  {
        return isLocked;
    }
    bool getIsMounted() {
        return isMounted;
    }
    int getIsAutoMounted() {
        return isAutoMounted;
    }
    QString getPath()       {
        return path;
    }
    QString getDevice() {
        return device;
    }
    QString getName()   {
        return name;
    }

private:
    int          driveID;
    unsigned checksum;
    int          cdID;
    bool         isKnown;
    bool         isLocked;
    bool         isMounted;
    int          isAutoMounted;
    QString  path;
    QString  device;
    QString  name;
    QString  label;
};

#endif
