/***************************************************************************
                    database_embedded_dialog.cpp  -  description
                             -------------------
    begin                : Sun Sep 19 2004
    copyright            : (C) 2004 by Paul-henri Ferme
    email                : paul-henri.ferme@noos.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "database_embedded_dialog.h"

#include "database.h"
#include "configuration.h"
#include "jobmanager.h"
#include "job_connecttodatabase.h"
#include "gui.h"
#include <qvbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qtextcodec.h>

Database_Embedded_Dialog::Database_Embedded_Dialog(QWidget *parent, const char *name)
: QDialog(parent, name, true) {
    QVBoxLayout *lay = new QVBoxLayout(this);

    QGroupBox *hostbox = new QGroupBox(1, Qt::Horizontal, _("Database Embedded Server"), this);
    QFrame *hostboxf = new QFrame(hostbox);
    QGridLayout *hostlay = new QGridLayout(hostboxf, 3, 3);

    QLabel *aa = new QLabel("<b>" + QString(_("Directory of MySQL table files (will be created if not existing)")) + " : </b>", hostboxf);
    aa->setAlignment(Qt::AlignVCenter);
    hostlay->addWidget(aa, 0, 0);

    mysql_file = new QLineEdit( "", hostboxf);
    hostlay->addWidget(mysql_file, 0, 1);

    file_loc1 = new QPushButton( QString( "..." ), hostboxf ,"file locator 1");
    file_loc1->setMaximumWidth( 30 );
    hostlay->addWidget(file_loc1, 0, 2);

    QLabel *bb = new QLabel("<b>" + QString(_("Directory of MySQL error messages (must exist)")) + " : </b>", hostboxf);
    bb->setAlignment(Qt::AlignVCenter);
    hostlay->addWidget(bb, 1, 0);

    msg_file = new QLineEdit("", hostboxf);
    msg_file->setMinimumWidth( 300 );
    hostlay->addWidget(msg_file, 1, 1);

    file_loc2 = new QPushButton( QString( "..." ), hostboxf ,"file locator 2");
    file_loc2->setMaximumWidth( 30 );
    hostlay->addWidget(file_loc2, 1, 2);

    QLabel *cc = new QLabel("<b>" + QString(_("Encoding")) + ": </b>", hostboxf);
    cc->setAlignment(Qt::AlignVCenter);
    hostlay->addWidget(cc, 2, 0);
    comboEncoding = new QComboBox(hostboxf);
    comboEncoding->insertItem( "Latin1/ISO-8859-1" );
    comboEncoding->insertItem( "UTF-8");
    if ( !qstrcmp( QTextCodec::codecForLocale()->mimeName() ,"UTF-8" ) )
        comboEncoding->setCurrentText( "UTF-8" );
    else
        comboEncoding->setCurrentText( "Latin1/ISO-8859-1" );
    hostlay->addWidget(comboEncoding, 2, 1);

    lay->addWidget(hostbox);

    QLabel* helper = new QLabel( _(
                                     "<b> Welcome to the embedded MySQL wizard.<br><br> "
                                     "If you want to setup prokyon3 to use an embedded "
                                     "MySQL server for the first time, prokyon3 will create "
                                     "the needed directory structure for you. In this case "
                                     "you have to restart prokyon3 after the directories "
                                     "were created.</b><br><br>"
                                     "basedir = root directory for storing MySQL table files<br>"
                                     "You must have read and write  access to that directory.<br><br>"
                                     "language = path to a MySQL error file<br>"
                                     "A Mysql error file is typically named errmsg.sys "
                                     "in /usr/local/share/mysql/xxxxx/, where xxxxx is your "
                                     "preferred language. You <b>must</b> provide this error file,"
                                     "otherwise the embedded server won't start.<br><br>"
                                     "If necessary, changed the text encoding for your database."
                                     "By default it will be set to your local encoding if "
                                     "supported or latin1.<br>"
                                     "Note: utf-8 encoding is supported by MySQL versions >=4.0<br><br>"
                                     "Hint: You might also setup an embedded MySQL server on an "
                                     "existing file structure created by a *normal* MySQL server. "
                                     "In this case you have to ensure that the *normal* MySQL server "
                                     "isn't running at the same time! So be carefull, "
                                     "it's on your own risk!"
                                 ) ,
                                 this );
    helper->setTextFormat( Qt::RichText );
    helper->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    lay->addWidget( helper );

    QHBox *butbox = new QHBox(this);

    QPushButton *createbutton = new QPushButton(_("Create"), butbox);
    QPushButton *cancelbutton = new QPushButton(_("Cancel"), butbox);

    connect(createbutton, SIGNAL(clicked()), this, SLOT(slot_create()));
    connect(cancelbutton, SIGNAL(clicked()), this, SLOT(slot_cancel()));
    connect(file_loc1, SIGNAL(clicked()), this, SLOT(slot_file1dialog()));
    connect(file_loc2, SIGNAL(clicked()), this, SLOT(slot_file2dialog()));

    lay->addWidget(butbox);

    mysql_file->setText( config->getEmbeddedBaserdir() );
    msg_file->setText( config->getEmbeddedLanguage() );
}

void Database_Embedded_Dialog::slot_create() {

    QDir dir1( mysql_file->text() );
    if (!dir1.exists())
        if (!dir1.mkdir(dir1.path())) {
            QMessageBox::warning(this, _("Cannot make directory"),
                                 QString(_("Could not create directory ") ) + dir1.path() +
                                 _(".\n Check your settings.") );
        }


    QDir dir2( mysql_file->text() + "/var/" );
    if (!dir2.exists())
        if (!dir2.mkdir(dir2.path())) {
            QMessageBox::warning(this, _("Cannot make directory"),
                                 QString(_("Could not create directory ") ) + dir2.path() +
                                 _(".\n Check your settings.") );
        }


    config->setEmbeddedBaserdir(mysql_file->text());
    config->setEmbeddedLanguage(msg_file->text());
    config->db_encoding = comboEncoding->currentText();
    config->setStartupTip( 2 );
    QMessageBox::information(this, "Prokyon3", _("You must now restart prokyon3 \n"
                             "to initialize the embedded MySQL server with your new settings!" ), QMessageBox::Ok);
    accept();
    return;
}

void Database_Embedded_Dialog::slot_cancel() {
    reject();
}

void Database_Embedded_Dialog::slot_file1dialog() {
    QFileDialog *fd = new QFileDialog( QDir::homeDirPath() );
    fd->setMode( QFileDialog::Directory );
    QString filename;
    if ( fd->exec() == QDialog::Accepted )
        filename = fd->selectedFile();
    mysql_file->setText( filename );
}

void Database_Embedded_Dialog::slot_file2dialog() {
    QFileDialog *fd = new QFileDialog( config->getEmbeddedLanguage() );
    fd->setMode( QFileDialog::Directory );
    QString filename;
    if ( fd->exec() == QDialog::Accepted )
        filename = fd->selectedFile();
    msg_file->setText( filename );
}


Database_Embedded_Dialog::~Database_Embedded_Dialog() {}

