/*-----------------------------------------------------------------------
QMBTagger - Qt Based MusicBrainz MP3/OGG/FLAC Tagger
Copyright (C) 2003,2004 Ewen Cheslack-Postava

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------*/

#ifndef _QMBMETADATA_H_
#define _QMBMETADATA_H_

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_LIBMUSICBRAINZ

#include <qstring.h>

class QMBMetadata {
public:
	QMBMetadata();
	~QMBMetadata();
	
	QString GetTRMID();
	QString GetArtistName();
	QString GetCleanArtistName();
	QString GetAlbumName();
	QString GetCleanAlbumName();
	QString GetTrackName();
	QString GetCleanTrackName();
	QString GetTrackNumber();
	QString GetPaddedTrackNumber();
	QString GetDuration();
	QString GetFormattedDuration();
	QString GetFileName();
	QString GetArtistID();
	QString GetAlbumID();
	QString GetTrackID();
	int GetRelevance();
	void ReplaceFilenameWildcards(QString &filename, QString &ext);

	void SetTRMID(QString trm);
	void SetArtistName(QString artist);
	void SetAlbumName(QString album);
	void SetTrackName(QString track);
	void SetTrackNumber(QString tnum);
	void SetDuration(QString dur);
	void SetFileName(QString file);
	void SetArtistID(QString id);
	void SetAlbumID(QString id);
	void SetTrackID(QString id);
	void SetRelevance(int rel);
    
    void debugDump();
	
private:
	QString trmid;
	QString artistName;
	QString albumName;
	QString trackName;
	QString trackNum;
	QString duration;
	QString fileName;
	QString artistId;
	QString albumId;
	QString trackId;
	int relevance;
	
public:
	QMBMetadata& operator=(const QMBMetadata &m);
};

#endif  /*HAVE_LIBMUSICBRAINZ*/
#endif //define _QMBMETADATA_H_
