#include "prokyon.h"
#include "lvi_track.h"
#include "configuration.h"
#include "mtabwatcher.h"
#include "supermountwatcher.h"
#include "submountwatcher.h"
#include "gui.h"

#include <qdir.h>
#include <qmessagebox.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qrect.h>
#include <qvariant.h>

const char* JOB_CODE[27] = {  // debug only
  " Unknown",
  "JOB_CONNECT_TO_DATABASE",
  "JOB_DISCONNECT_FROM_DATABASE",
  "JOB_MODIFY_FAVOURITE",
  "JOB_SYNCHRONIZE_WITH_DATABASE",
  "JOB_QUERY_DATABASE",
  "JOB_MODIFY_TRACKS_IN_DATABASE",
  "JOB_COMPUTE_CDROM_ID",
  "JOB_APPEND_CDROM_TO_DATABASE",
  "JOB_DELETE_MEDIUM_FROM_DATABASE",
  "JOB_APPEND_SMB_TO_DATABASE",
  "JOB_DELETE_TRACK_PHYSICALLY",
  "JOB_APPEND_NFS_TO_DATABASE",
  "JOB_MODIFY_PLAYLISTS",
  "JOB_MODIFY_PLAYLIST_TRACKS",
  "JOB_QUERY_PLAYLIST_TRACKS",
  "JOB_COUNT_DATA",
  "JOB_GENERATE_PLAYLIST",
  "JOB_GET_EXTRA_DATA",
  "JOB_CALL_MUSICEXTRAS",
  "JOB_PLAYALBUM",
  "JOB_CONNECT_TO_MIXXX",
  "JOB_DISCONNECT_FROM_MIXXX",
  "JOB_IMPORT_PLAYLIST",
  "JOB_RENAME_MEDIUM",
  "JOB_STORE_CUSTOM_QUERY",
  "JOB_REMOVE_CUSTOM_QUERY"
};


class QPixmapView : public QWidget
/* Displays a  QPixmap for debugging purpose. */
{
public:
  QPixmapView( const QPixmap& px, QWidget* parent=0, const char* name=0 ):
    QWidget( parent, name, Qt::WStyle_Dialog)
  { label = new QLabel( this, "label" );
    label->setPixmap( px);
    label->setMinimumSize( px.size());}
  QLabel *label;
};

// static init for gettext convenience class
char _::ss[]="";

#ifdef HAVE_MEXTRAS
// helper functions checking whether retuned string from musiextras means no info is available....
bool biography_isEmpty(QString bio)
{
  return bio == "No biography found." || bio.isEmpty();
}

bool years_active_isEmpty(QString years)
{
  return years == "No years active found." || years.isEmpty();
}

bool lyrics_isEmpty(QString lyrics)
{
  return lyrics == "No lyrics found." || lyrics == "No lyrics plugin loaded." || lyrics.isEmpty();
}

bool album_review_isEmpty(QString album)
{
  return album=="No album review found." || album.isEmpty();
}

bool album_tracks_isEmpty(QString tracks)
{
  return tracks=="No album tracks found." || tracks.isEmpty();
}
#endif /* HAVE_MEXTRAS */


QString adjustQString(QString s)
{

  if ( s.isNull() ) {
    return QString("");
  }

  for(unsigned i=0; i<s.length(); i++) {
    if(s[i] == '\'' || s[i] == '"' || s[i] == '\\' )  s.insert(i++, '\\');
    if(s[i] == 0x0) { s[i]='0'; s.insert(i++, '\\');}  
  }

  return s;
}

// *** adjust strings before writing to mysql ***
//  0.9.2 always use latin1
//  >0.9.3 will use latin1
QCString  adjustString(QString s)
{
  if ( config->getENCODING() == "UTF-8" )
    return adjustQString(s).utf8();
  else
    return adjustQString(s).latin1();
}

// *** adjust strings for use with bash command line ***
QString adjustStringCommandLine(QString s)
{ 
  if ( s.isNull() ) {
    return QString("");
  }
  
  for(unsigned i=0; i<s.length(); i++) {
    if(s[i] == '\\') s.insert(i++, '\\');
    if(s[i] == '$') s.insert(i++, '\\');
    if(s[i] == '`') s.insert(i++, '\\');
    if(s[i] == '"') s.insert(i++, '\\');
  }
  
  s.prepend("\"");
  s.append("\"");
  
  return s;
}


// *** adjust strings when reading/writing mysql ***
//  prokyon3<0.9.2 and MySQL<4.1
//       only support latin1 encoding. Other undefined
//  prokyon3 >=0.9.3 and MySQL<4.1 
//       encode either with latin1 or utf-8 depending of  
//            locale where the base was created.
//       base encoding type is tagged into version_history base
//  prokyon3 >=0.9.3 and MySQL>=MySQL4.1 
//       will test QSqlDriver::Unicode
//       to be tested later with QT4
QString toLocaleString( QVariant qv)
{
  if ( config->getENCODING() == "UTF-8" )  
    return QString::fromUtf8( qv.toCString() );
  else
    return qv.toString();  // use latin1
}


QString dumpAllQString(QString ss) {   
  int i = ss.find('\0');
  if (i!=-1) ss.replace( i, 1, QString("0") );
  return ss;
}

void dumpdeltamap( QMap<int, QMap<int, DELTAINFO*> > *deltamap ) {  
  qWarning( " ******dumpdeltamap starts here************* ");
  if (deltamap) {
    for ( QMap<int, QMap<int, DELTAINFO*> >::Iterator it1 = deltamap->begin(); it1 != deltamap->end(); ++it1 ) {
        qWarning( "deltamap key artistID:%i", it1.key() ); 
      for ( QMap<int, DELTAINFO*>::Iterator it2 = it1.data().begin(); it2 != it1.data().end(); ++it2 ) {
	qWarning( "       key mediumID :%d total:%d local:%d name:\"%s\"", 
		  it2.key(), it2.data()->total, it2.data()->local, it2.data()->name.local8Bit().data() );

	if ( !it2.data()->deltaalbum->empty() )
	  for( QMap<QString, ALBUMINFO>::Iterator it3 = it2.data()->deltaalbum->begin(); it3 != it2.data()->deltaalbum->end(); ++it3) 
	    qWarning( "            deltaalbum album:\"%s\" local:%i total:%i", it3.data().name.local8Bit().data(), it3.data().local, it3.data().total );
	else qWarning("            deltaalbum \"No album\"" );
      };
    }; 
  } else qWarning( " NULL deltamap " );
  qWarning( " **************************************** ");
}

void dumpSelectedItems( QList<QListViewItem>* select )
{
  qWarning( " ******dumpSelectedItems starts here*****" );
  if ( select ) {
    qWarning( "select->count():%d", select->count() );
    for(QListViewItem *curr = select->first(); curr != 0; curr = select->next()) {
      LVI_Track *lvi = dynamic_cast<LVI_Track*>(curr);
      qWarning( "Artist:%s Title:%s", lvi->getArtist().local8Bit().data(), lvi->getTitle().local8Bit().data() );
    } 
  } else qWarning( "NULL pointer" );
  qWarning( " ****************************************" );
}

void dumpListTracks( QList<TRACK>* alist )
{
  qWarning( " ******dumpListTracks starts here********" );
  if ( alist ) {
    qWarning( "list->count():%d",alist->count() );
    for(TRACK *curr = alist->first(); curr != 0; curr = alist->next()) {
      qWarning( "filename: %s/%s", curr->path.local8Bit().data(), curr->filename.local8Bit().data() );
    } 
  } else  qWarning( "NULL pointer" );
  qWarning( " ****************************************" );
}

void dumpBaseList( QMap<int, int> *baselist ) {  

  qWarning( " ******dumpbaselist starts here************* ");
  if (baselist) {
    for ( QMap<int,int>::Iterator it1 = baselist->begin(); it1 != baselist->end(); ++it1 ) 
      qWarning( "    artistID:%i count:%i", it1.key(), it1.data() ); 
  } else 
    qWarning( " NULL baselist " );
  qWarning( " **************************************** ");
}

void dumpArtistToID( QMap<QString, int> *artisttoid ) {  

  qWarning( " ******dumpartisttoID starts here************* ");
  if (artisttoid) {
    for ( QMap<QString,int>::Iterator it1 = artisttoid->begin(); it1 != artisttoid->end(); ++it1 )
      qWarning( "     artist:%s ID:%i", it1.key().local8Bit().data(), it1.data() ); 
  } else 
    qWarning( " NULL artistID " );
  qWarning( " **************************************** ");
}

/**
 * Calls configured player to play or enqueue a list of files.
 */
void commandLineCallToRegularPlayer(QStringList fileList, bool enqueue)
{
    if ( fileList.count() == 0 ) {
          MessageEvent* e = new MessageEvent(_("File(s) not available for playing"));
          QApplication::postEvent( gui, e );
        return;
    }

    QString tmpFilePath( QDir::homeDirPath() + "/.prokyon3" );
    QString tmpFileName( tmpFilePath + "/tmp.pls" );
  
    QDir myDir;
    bool result;
    if ( !myDir.exists( tmpFilePath ) ) {
        result = myDir.mkdir( tmpFilePath );
        if ( !result ) {
            qWarning( ("Could not create directory " + tmpFilePath).latin1() );
            return;
        }
    }

    QFile file( tmpFileName );
    if( file.open( IO_WriteOnly ) ) {
        QTextStream stream( &file );
        stream << "[playlist]\nNumberOfEntries=" << fileList.count() << "\n";
        unsigned int i = 1;
        for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it ) {
            stream << "File" << i++ << "=" << *it << "\n";
        }
        file.close();
        
        QString command;

        if (enqueue)
            command = config->getEnqueueCmd().stripWhiteSpace().utf8();
        else
            command = config->getPlayCmd().stripWhiteSpace().utf8();

        command.append( " " + tmpFileName + " &" );
	    
        //  qWarning( command.local8Bit().data());
	    system(command.local8Bit().data());
    } else {
        qWarning( ("Could not create file " + tmpFileName).latin1() );
        return;
    }
}

PLAYLIST_TRACK* getPlaylistTrackFromTrack(TRACK* track)
{
    PLAYLIST_TRACK *p_track = new PLAYLIST_TRACK();
    p_track->track_id             = track->id;
    p_track->medium_id            = track->medium;
    p_track->artist               = track->artist;
    p_track->title                = track->title;
    p_track->path                 = track->path;
    p_track->filename             = track->filename;
    p_track->size                 = track->size;
    p_track->length               = track->length;
    return p_track;
}

// The ultimate debugging tool. use "at wish"
//  qWarning( "%s %i", __FILE__, __LINE__);

void dumpQPixmap( QPixmap px ) {  
  if ( &px == 0 ) {
    qWarning( "dumpQPixmap: NULL " );
    return;
  }

  if ( px.isNull() ) {
    qWarning( "dumpQPixmap: isNull()" );
    return;
  }

  qWarning( "dumpQPixmap w:%i h:%i ", px.width(), px.height() );
  QPixmapView* viewbox = new QPixmapView( px );
  viewbox->show();
  return;
};

void pauseWatchers()
{
  mtabwatcher->pause();
  supermountwatcher->pause();
  submountwatcher->pause();
}

void proceedWatchers()
{
  mtabwatcher->proceed();
  supermountwatcher->proceed();
  submountwatcher->proceed();
}

QString albumTypeTranslation(QString type)
{
  if     (type == NORMAL)     return _(NORMAL);
  else if(type == SAMPLER)    return _(SAMPLER);
  else if(type == SOUNDTRACK) return _(SOUNDTRACK);
  else if(type == MUSICAL)    return _(MUSICAL);
  else if(type == COMEDY)     return _(COMEDY);
  else if(type == DRAMA)      return _(DRAMA);
  return type;
}

QString revertAlbumTypeTranslation(QString type)
{
  if     (type == _(NORMAL))     return NORMAL;
  else if(type == _(SAMPLER))    return SAMPLER;
  else if(type == _(SOUNDTRACK)) return SOUNDTRACK;
  else if(type == _(MUSICAL))    return MUSICAL;
  else if(type == _(COMEDY))     return COMEDY;
  else if(type == _(DRAMA))      return DRAMA;
  return type;
}

bool isNormalAlbum(QString type)
{
  if (    type == SAMPLER
       || type == SOUNDTRACK
       || type == MUSICAL
       || type == COMEDY
       || type == DRAMA
      )
    return false;
  return true;
}
