/***************************************************************************
                          jobbasetagmanipulation.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "jobbasetagmanipulation.h"
#include "tagger.h"
#include "progressdialogscroll.h"

#include <qptrqueue.h>

#include <iostream>

using namespace std;

// ##############################################
// # get list of all relevant files in dir
// ##############################################
QList<TRACK> *JobBaseTagManipulation::getFileList(QDir *directory, bool append, QList<TRACK> *files)
{
  QList<TRACK> *musiclist;
  
  if(append) musiclist = files; else musiclist = new QList<TRACK>;
  
  QPtrQueue<QDir> queue;
  if(directory->exists()) queue.enqueue(directory);
  
  while(!queue.isEmpty()) {
    QDir *d = queue.dequeue();
    d->setFilter(QDir::Files | QDir::Dirs | QDir::NoSymLinks);
    const QFileInfoList *list = d->entryInfoList();
    QFileInfoListIterator it(*list);
    QFileInfo *fi;
    while((fi = it.current())) {
      if(!(fi->fileName() == ".") && !(fi->fileName() == "..")) {
	if(fi->isDir() && fi->isReadable()) {
	  QDir *const newdir = new QDir(fi->absFilePath());
	  queue.enqueue(newdir);
	} else if(fi->size() > 5000) {
	  if(Tagger::isKnownFile(fi) && fi->isReadable()) {

	    TRACK *item = new TRACK;
	    item->id 		= 0;
	    item->medium	= 0;
	    item->hasChanged	= false;
	    item->filename	= fi->fileName();
	    item->path		= fi->dirPath();
	    item->lastModified	= fi->lastModified();
	    item->size		= fi->size();
	    
	    musiclist->append(item);
	  }
	}
      }
      ++it;
    }
    if(d != directory) delete d;
  }
  return musiclist;
}

// ##############################################
// # read tags from files in list
// ##############################################
QList<TRACK> *JobBaseTagManipulation::readTags(QList<TRACK> *files, bool lazyRead)
{
 
  qApp->lock();
  ProgressDialogScroll *wdial = new ProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();

  TRACK *curr = files->first();
  while(curr != 0) {
    QFileInfo fi(curr->path + '/' + curr->filename);
 
    qApp->lock();
    if ( !wdial->wasCancelled() ) {
      wdial->setProgress( count );
      count++;
      wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
    };
    qApp->unlock();
    

    if (verbose)  qWarning("Readtags:%s/%s",curr->path.local8Bit().data() ,curr->filename.local8Bit().data());
    if(curr->id != 0 && fi.lastModified() == curr->lastModified) { // File is known and unchanged
      if(curr == files->getLast()) {
	files->remove();
	delete curr;
	curr = 0;
      } else {
	files->remove();
	delete curr;
	curr = files->current();
      }
    } else { // Files is not known or have been changed
	if(Tagger::getInfo(curr, lazyRead)) {
    	    QFileInfo fi(curr->path + '/' + curr->filename);
    	    curr->lastModified = fi.lastModified();
    	    curr->hasChanged = false;
    	    curr->size = fi.size();
    	    curr = files->next();
	} else {
    	    if(curr == files->getLast()) {
		files->remove();
		delete curr;
		curr = 0;
    	    } else {
		files->remove();
		delete curr;
		curr = files->current();
    	    }
	}
    }
  }
  wdial->deleteLater();
  return files;
}

// ##############################################
// # read tags from files in list
// ##############################################
QList<TRACK> *JobBaseTagManipulation::readTagsOnly(QList<TRACK> *files)
{

  qApp->lock();
  ProgressDialogScroll *wdial = new ProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();

  TRACK *curr = files->first();
  while(curr != 0) {
    QFileInfo fi(curr->path + '/' + curr->filename);
    
    qApp->lock();
    if ( !wdial->wasCancelled() ) 
      wdial->setProgress( count );
    count++;
    wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
    qApp->unlock();
    
    if((curr->id == 0 || fi.lastModified() != curr->lastModified) && !Tagger::getTagOnly(curr)) {
      if(curr == files->getLast()) {
	files->remove();
	delete curr;
	curr = 0;
      } else {
	files->remove();
	delete curr;
	curr = files->current();
      }
    } else {
      QFileInfo fi(curr->path + '/' + curr->filename);
      curr->lastModified = fi.lastModified();
      curr->hasChanged = false;
      curr->size = fi.size();
      curr = files->next();
    }
  }
  wdial->deleteLater();
  return files;
}

// ##############################################
// # write tags from list to files
// ##############################################
QList<TRACK> *JobBaseTagManipulation::writeTags(QList<TRACK> *files)
{

  QStringList write_NOK;  
  qApp->lock();
  ProgressDialogScroll *wdial = new ProgressDialogScroll("", _("Hide"), files->count()-1, 0 , "progress" ); 
  int count = 0;
  qApp->unlock();
  
  TRACK *curr = files->first();
  while(curr != 0) {
    if(Tagger::writeInfo(curr)) {
      QFileInfo fi(curr->path + '/' + curr->filename);
      
      qApp->lock();
      if ( !wdial->wasCancelled() ) 
	wdial->setProgress( count );
      count++;
      wdial->TextEdit->append( QString("%1/%2").arg(curr->path).arg(curr->filename) );
      qApp->unlock();
      
      if (verbose)  qWarning("Writetags:%s/%s",curr->path.local8Bit().data() ,curr->filename.local8Bit().data());

      if(curr->lastModified != fi.lastModified()) { // did we really changed it ?! --- strange SMB behaviour
	curr->lastModified = fi.lastModified();
	curr->hasChanged = false;
	curr->size = fi.size();
      }
    } else {
      write_NOK.append( QString("<b>cannot write to </b> %1/%2 <br>").arg(curr->path).arg(curr->filename));
    }

    curr = files->next();
    }

  wdial->deleteLater();

  if ( !write_NOK.isEmpty() ) {
    qApp->lock();
    View_Dialog view( 0, write_NOK.join(QString::null) );
    view.exec();
    qApp->unlock();
  }

  return files;
}
