/***************************************************************************
                    guess_dialog.h  -  description
                             -------------------
    begin                : Sun Oct 5 2003
    copyright            : (C) 2003 by paul-henri ferme
    email                : pual-henri@users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUESS_DIALOG_H
#define GUESS_DIALOG_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qspinbox.h>

#include "gui_taglisting.h"

class Guess_Dialog : public QDialog {
    Q_OBJECT
friend class GUI_TagListing;
public: 
  Guess_Dialog(QWidget *parent, const QString &filename, const QString &path, const char *name=0);
  ~Guess_Dialog();
  enum DialogCode { SkipRemaining = 0x100 };

private:
    QLineEdit *titlename, *artistname, *albumname, *track, *sepanamePath1, *sepanamePath2, *sepanameFileName;
    QLineEdit *path1Value, *path2Value, *fileNameValue;
    QSpinBox *titlespinPath1, *artistspinPath1, *albumspinPath1, *trackspinPath1;
    QSpinBox *titlespinPath2, *artistspinPath2, *albumspinPath2, *trackspinPath2;
    QSpinBox *titlespinFileName, *artistspinFileName, *albumspinFileName, *trackspinFileName;
    QString Filename, Path1, Path2;
    static int titlespinPath1_v, artistspinPath1_v, albumspinPath1_v, trackspinPath1_v;
    static int titlespinPath2_v, artistspinPath2_v, albumspinPath2_v, trackspinPath2_v;
    static int titlespinFileName_v, artistspinFileName_v, albumspinFileName_v, trackspinFileName_v;
    static QString sepanamePath1_v;
    static QString sepanamePath2_v;
    static QString sepanameFileName_v;

private slots:
    void slot_guess();
    void slot_cancel();
    void slot_cancelall();
    void slot_edit();
    void slot_artistspinFileName();
    void slot_artistspinPath1();
    void slot_artistspinPath2();
    void slot_albumspinFileName();
    void slot_albumspinPath1();
    void slot_albumspinPath2();
    void slot_titlespinFileName();
    void slot_titlespinPath1();
    void slot_titlespinPath2();
    void slot_trackspinFileName();
    void slot_trackspinPath1();
    void slot_trackspinPath2();
};

#endif
