/***************************************************************************
                          gui_datadispatcher.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "datadispatcher.h"

#include "gui.h"
#include "database.h"

DataDispatcher::DataDispatcher() {}

DataDispatcher::~DataDispatcher() {}

#ifdef HAVE_MIXXX
void DataDispatcher::eventEstablishedMixxxConnection() {
  gui->notifyEstablishedMixxxConnection();
}

void DataDispatcher::eventLostMixxxConnection() {
  gui->notifyLostMixxxConnection();
}
#endif /* HAVE_MIXXX */

void DataDispatcher::eventStartedExaminingCDROM(LVI_CDDrive *drive) {
  drive->lock(_("examining"));
}

void DataDispatcher::eventStartedAppendingCDROM(LVI_CDDrive *drive) {
  drive->lock(_("appending"));
}

void DataDispatcher::eventStoppedAppendingCDROM(LVI_CDDrive *drive) {
  drive->unlock();
}

void DataDispatcher::eventStartedAppendingSMB(LVI_SMBShare *share) {
  share->lock(_("appending"));
}
void DataDispatcher::eventStoppedAppendingSMB(LVI_SMBShare *share) {
  share->unlock();
}

void DataDispatcher::eventStartedAppendingNFS(LVI_NFSExport *Export) {
  Export->lock(_("appending"));
}
void DataDispatcher::eventStoppedAppendingNFS(LVI_NFSExport *Export) {
  Export->unlock();
}

void DataDispatcher::eventCDROMInserted(LVI_CDDrive *drive) {
  drive->unlock();
  gui->getSourcer()->notifyCDROMInserted(drive);
  if(drive->getIsKnown()) {
    gui->getSelector()->notifyMediumAvailabilityChanged(drive->getCdID(), true);
    gui->getListing()->notifyMediumAvailabilityChanged(drive->getCdID(), drive->getPath(), true);
    gui->getPlaylisting()->notifyMediumAvailabilityChanged(drive->getCdID(), drive->getPath(), true);
  }
}

void DataDispatcher::eventSMBMounted(LVI_SMBShare *share) {
  gui->getSourcer()->notifySMBMounted(share);
  if(share->getIsKnown()) {
    gui->getSelector()->notifyMediumAvailabilityChanged(share->getMediumID(), true);
    gui->getListing()->notifyMediumAvailabilityChanged(share->getMediumID(), share->getPath(), true);
    gui->getPlaylisting()->notifyMediumAvailabilityChanged(share->getMediumID(), share->getPath(), true);
  }
}

void DataDispatcher::eventNFSMounted(LVI_NFSExport *Export) {
  gui->getSourcer()->notifyNFSMounted(Export);
  if(Export->getIsKnown()) {
    gui->getSelector()->notifyMediumAvailabilityChanged(Export->getMediumID(), true);
    gui->getListing()->notifyMediumAvailabilityChanged(Export->getMediumID(), Export->getPath(), true);
    gui->getPlaylisting()->notifyMediumAvailabilityChanged(Export->getMediumID(), Export->getPath(), true);
  }
}

void DataDispatcher::eventFilenameHasChanged(int id, QString filename) {
  gui->getListing()->notifyFilenameHasChanged(id, filename);
}

void DataDispatcher::eventDirHasChanged(QString dir) {
  gui->getSourcer()->notifyDirHasChanged(dir);
}

void DataDispatcher::eventStartedHarddiskSynchronizing() {
  gui->getSourcer()->notifyStartedHarddiskSynchronizing();
  gui->getListing()->notifyMediumBusy(MEDIUM_HARDDISK, true);
}

void DataDispatcher::eventStoppedHarddiskSynchronizing() {
  gui->getSourcer()->notifyStoppedHarddiskSynchronizing();
  gui->getListing()->notifyMediumBusy(MEDIUM_HARDDISK, false);
}

void DataDispatcher::eventStartedCDROMSynchronizing(LVI_CDDrive *drive) {
  gui->getSourcer()->notifyStartedCDROMSynchronizing(drive);
  gui->getListing()->notifyMediumBusy(drive->getCdID(), true);
}

void DataDispatcher::eventStoppedCDROMSynchronizing(LVI_CDDrive *drive) {
  gui->getSourcer()->notifyStoppedCDROMSynchronizing(drive);
  gui->getListing()->notifyMediumBusy(drive->getCdID(), false);
}

void DataDispatcher::eventStartedSMBSynchronizing(LVI_SMBShare *share) {
  gui->getSourcer()->notifyStartedSMBSynchronizing(share);
  gui->getListing()->notifyMediumBusy(share->getMediumID(), true);
}

void DataDispatcher::eventStoppedSMBSynchronizing(LVI_SMBShare *share) {
  gui->getSourcer()->notifyStoppedSMBSynchronizing(share);
  gui->getListing()->notifyMediumBusy(share->getMediumID(), false);
}

void DataDispatcher::eventStartedNFSSynchronizing(LVI_NFSExport *Export) {
  gui->getSourcer()->notifyStartedNFSSynchronizing(Export);
  gui->getListing()->notifyMediumBusy(Export->getMediumID(), true);
}

void DataDispatcher::eventStoppedNFSSynchronizing(LVI_NFSExport *Export) {
  gui->getSourcer()->notifyStoppedNFSSynchronizing(Export);
  gui->getListing()->notifyMediumBusy(Export->getMediumID(), false);
}

void DataDispatcher::eventMediumNoMoreAvailable(int id) {
  gui->getSelector()->notifyMediumAvailabilityChanged(id, false);
  gui->getListing()->notifyMediumAvailabilityChanged(id, "", false);
  gui->getPlaylisting()->notifyMediumAvailabilityChanged(id, "", false);
}

void DataDispatcher::eventAddEditLock() {
  gui->getTagListing()->notifyAddEditLock();
}

void DataDispatcher::eventRemoveEditLock() {
  gui->getTagListing()->notifyRemoveEditLock();
}

void DataDispatcher::eventAddReadWriteLock() {
  gui->getSourcer()->notifyAddReadWriteLock();
  gui->getSelector()->notifyAddReadWriteLock();
}

void DataDispatcher::eventRemoveReadWriteLock() {
  gui->getSourcer()->notifyRemoveReadWriteLock();
  gui->getSelector()->notifyRemoveReadWriteLock();
}

void DataDispatcher::eventNewAlbumBasis(QList<ARTISTALBUM> *list) {
  gui->getSelector()->notifyNewSamplerBasis(list);
}

void DataDispatcher::eventNewFavouritesBasis(QList<ARTISTALBUM> *list) {
  gui->getSelector()->notifyNewFavouritesBasis(list);
}

void DataDispatcher::eventNewArtistAlbumBasis(QList<ARTISTALBUM> *list, bool select) {
  gui->getSelector()->notifyNewArtistAlbumBasis(list, select);
}

void DataDispatcher::eventNewMediumBasis(QList<MEDIUM> *list) {
  gui->getSelector()->notifyNewMediumBasis(list);
  gui->getListing()->notifyNewMediumBasis(list);
  gui->getPlaylisting()->notifyNewMediumBasis(list);
  gui->getSourcer()->notifyNewMediumBasis(list);
}

void DataDispatcher::eventNewLocalAlbumDeltaBasis(QMap<int, QMap<QString, int> > *delta) {
  gui->getSelector()->notifyNewLocalAlbumDeltaBasis(delta);
}

void DataDispatcher::eventNewLocalAlbumDelta(int id, QMap<QString, int> delta) {
  gui->getSelector()->notifyNewLocalAlbumDelta(id, delta);
}

void DataDispatcher::eventSelectArtistAlbum() {
  gui->getSelector()->notifySelectArtistAlbum();
}

void DataDispatcher::eventNewArtistDelta(QMap<int, QMap<int, DELTAINFO*> > *delta) {
  gui->getSelector()->notifyNewArtistDelta(delta);
}

void DataDispatcher::eventNewTrackListing(QList<TRACK> *list) {
  gui->getListing()->notifyNewTrackListing(list);
}

#ifdef HAVE_MEXTRAS
void DataDispatcher::eventMextrasTrackListing(QList<TRACK> *list) {
   gui->notifyMextrasTrackListing(list);
}

void DataDispatcher::eventNewExtraData(EXTRADATA_GUI *data) {
  gui->getPlaylisting()->notifyNewExtraData(data);
}
#endif /* HAVE_MEXTRAS */

void DataDispatcher::eventNewMedium(MEDIUM *medium) {
  gui->getSelector()->notifyNewMedium(medium);
  gui->getListing()->notifyNewMedium(medium);
  gui->getPlaylisting()->notifyNewMedium(medium);
  gui->getSourcer()->notifyNewMedium(medium);
}

void DataDispatcher::eventMediumRemoved(int id) {
  gui->getSelector()->notifyMediumRemoved(id);
  gui->getListing()->notifyMediumRemoved(id);
  gui->getPlaylisting()->notifyMediumRemoved(id);
  gui->getSourcer()->notifyMediumRemoved(id);
}


void DataDispatcher::eventMediumRenamed(MEDIUM *medium) {
  // The order of the calls is essential.
  // The selector may request an update of the track listing;
  // by then the listing must have been notified.
  gui->getListing()->notifyMediumRenamed(medium);
  gui->getSelector()->notifyMediumRenamed(medium);
  gui->getSourcer()->notifyMediumRenamed(medium);
}

void DataDispatcher::eventMediumIsBusy(LVI_Medium *medium) {
  medium->lock();
}


void DataDispatcher::eventNewPlaylistBasis(QList<PLAYLIST> *list) {
  gui->getPlaylisting()->notifyNewPlaylistBasis(list);
}

void DataDispatcher::eventNewPlaylistTracksBasis(QList<PLAYLIST_TRACK> *list, int playlistID) {
  gui->getPlaylisting()->notifyNewPlaylistTracksBasis(list, playlistID);
}

void DataDispatcher::eventNewPlaylist(PLAYLIST *playlist, bool isNewCreated) {
  gui->getPlaylisting()->notifyNewPlaylist(playlist, isNewCreated);
}

void DataDispatcher::eventNewPlaylistTrack(PLAYLIST_TRACK *p_track, int playlistID) {
  gui->getPlaylisting()->notifyNewPlaylistTrack(p_track, playlistID);
}

void DataDispatcher::eventRemovePlaylist(LVI_Playlist *playlist) {
  gui->getPlaylisting()->notifyRemovePlaylist(playlist);
}

void DataDispatcher::eventRenamePlaylist(LVI_Playlist *playlist, QString newname) {
  gui->getPlaylisting()->notifyRenamePlaylist(playlist, newname);
}

void DataDispatcher::eventMovePlaylistTrack() {
  gui->getPlaylisting()->notifyMovePlaylistTrack();
}

void DataDispatcher::eventCloseSelectorTree() {
  gui->getSelector()->notifyCloseSelectorTree();
}
  
void DataDispatcher::eventNewCustomQueries(QMap<QString,QString> queries) {
  gui->getListing()->getSQL()->notifyNewCustomQueries(queries);
}
  
  
