/******************************************************************************
* Copyright (C) 2010 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <iostream>
#include <fstream>
#include <sstream>

#include "CDAOFactorySQLite.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CDAOFactorySQLite::CDAOFactorySQLite(const std::string &filepath)
{
    m_filepath      = filepath;
    m_filepath_tmp  = filepath;
    m_filepath_tmp += ".tmp";

    copyFile(m_filepath, m_filepath_tmp);
    if( sqlite3_open(m_filepath_tmp.c_str(), &m_database )!=SQLITE_OK ){
        sqlite3_close(m_database);
        m_database = NULL;
        throw PFEXCEPTION("Can't open database file: '%s' --> '%s'", m_filepath_tmp.c_str(), sqlite3_errmsg(m_database));
    }

    m_PfCompetitionPhasesDAOSQLite = new CPfCompetitionPhasesDAOSQLite(m_database);
    m_PfRankingDAOSQLite = new CPfRankingDAOSQLite(m_database);
    m_PfTeamAveragesDAOSQLite = new CPfTeamAveragesDAOSQLite(m_database);
    m_PfFormationsDAOSQLite = new CPfFormationsDAOSQLite(m_database);
    m_PfTeamsByCompetitionsDAOSQLite = new CPfTeamsByCompetitionsDAOSQLite(m_database);
    m_PfConfederationsDAOSQLite = new CPfConfederationsDAOSQLite(m_database);
    m_PfTeamPlayersDAOSQLite = new CPfTeamPlayersDAOSQLite(m_database);
    m_PfStadiumsDAOSQLite = new CPfStadiumsDAOSQLite(m_database);
    m_PfTeamsDAOSQLite = new CPfTeamsDAOSQLite(m_database);
    m_PfTeamPlayerAveragesDAOSQLite = new CPfTeamPlayerAveragesDAOSQLite(m_database);
    m_PfCompetitionsBySeasonDAOSQLite = new CPfCompetitionsBySeasonDAOSQLite(m_database);
    m_PfSeasonsDAOSQLite = new CPfSeasonsDAOSQLite(m_database);
    m_PfDemarcationsDAOSQLite = new CPfDemarcationsDAOSQLite(m_database);
    m_PfTeamPlayerContractsDAOSQLite = new CPfTeamPlayerContractsDAOSQLite(m_database);
    m_PfStrategicPositionsDAOSQLite = new CPfStrategicPositionsDAOSQLite(m_database);
    m_PfCoachesDAOSQLite = new CPfCoachesDAOSQLite(m_database);
    m_PfMatchesDAOSQLite = new CPfMatchesDAOSQLite(m_database);
    m_PfGameOptionsDAOSQLite = new CPfGameOptionsDAOSQLite(m_database);
    m_PfGoalsDAOSQLite = new CPfGoalsDAOSQLite(m_database);
    m_PfRolesDAOSQLite = new CPfRolesDAOSQLite(m_database);
    m_PfCountriesDAOSQLite = new CPfCountriesDAOSQLite(m_database);
    m_PfCoachContractsDAOSQLite = new CPfCoachContractsDAOSQLite(m_database);
    m_PfRolesByTeamPlayersDAOSQLite = new CPfRolesByTeamPlayersDAOSQLite(m_database);
    m_PfFormationsByCoachesDAOSQLite = new CPfFormationsByCoachesDAOSQLite(m_database);
    m_PfScorersDAOSQLite = new CPfScorersDAOSQLite(m_database);
    m_PfCompetitionsDAOSQLite = new CPfCompetitionsDAOSQLite(m_database);

    LOG_DEBUG("[CDAOFactorySQLite::CDAOFactorySQLite] SQLite Database open: '%s'", m_filepath_tmp.c_str());
}

CDAOFactorySQLite::~CDAOFactorySQLite()
{
    delete m_PfCompetitionPhasesDAOSQLite;
    delete m_PfRankingDAOSQLite;
    delete m_PfTeamAveragesDAOSQLite;
    delete m_PfFormationsDAOSQLite;
    delete m_PfTeamsByCompetitionsDAOSQLite;
    delete m_PfConfederationsDAOSQLite;
    delete m_PfTeamPlayersDAOSQLite;
    delete m_PfStadiumsDAOSQLite;
    delete m_PfTeamsDAOSQLite;
    delete m_PfTeamPlayerAveragesDAOSQLite;
    delete m_PfCompetitionsBySeasonDAOSQLite;
    delete m_PfSeasonsDAOSQLite;
    delete m_PfDemarcationsDAOSQLite;
    delete m_PfTeamPlayerContractsDAOSQLite;
    delete m_PfStrategicPositionsDAOSQLite;
    delete m_PfCoachesDAOSQLite;
    delete m_PfMatchesDAOSQLite;
    delete m_PfGameOptionsDAOSQLite;
    delete m_PfGoalsDAOSQLite;
    delete m_PfRolesDAOSQLite;
    delete m_PfCountriesDAOSQLite;
    delete m_PfCoachContractsDAOSQLite;
    delete m_PfRolesByTeamPlayersDAOSQLite;
    delete m_PfFormationsByCoachesDAOSQLite;
    delete m_PfScorersDAOSQLite;
    delete m_PfCompetitionsDAOSQLite;

    sqlite3_close(m_database);
    remove(m_filepath_tmp.c_str());
    LOG_DEBUG("[CDAOFactorySQLite::~CDAOFactorySQLite] SQLite Database closed: '%s'", m_filepath_tmp.c_str());
}

bool CDAOFactorySQLite::executeScript(const std::string &script)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    if( sqlite3_exec(m_database, script.c_str(), NULL, NULL, &msgError)!=SQLITE_OK ){
        LOG_ERROR("[CDAOFactorySQLite::executeScript] Error in SQL: \"%s\" --> \"%s\"", script.c_str(), msgError);
        sqlite3_free(msgError);
        correct = false;
    }
    return correct;
}

bool CDAOFactorySQLite::executeScriptFile(const char *scriptFile)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("[CDAOFactorySQLite::executeScriptFile] No database connection.");
    }

    char                c;
    std::ostringstream  sql;
    std::ifstream       script(scriptFile);
    if( script.fail() ){
        LOG_ERROR("[CDAOFactorySQLite::executeScriptFile] Error opening the script file: '%s'", scriptFile);
        return false;
    }

    while( script.good() ){
        c = (char) script.get();
        if( c!='\r' && c!='\n' && script.good() ){
            sql << c;
        }else{
            sql << ' ';
        }
    }
    script.close();

    return executeScript(sql.str());
}

bool CDAOFactorySQLite::beginTransaction()
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    if( sqlite3_exec(m_database, "BEGIN TRANSACTION;", NULL, NULL, &msgError)!=SQLITE_OK ){
        LOG_ERROR("Error in 'BEGIN TRANSACTION;': \"%s\"", msgError);
        sqlite3_free(msgError);
        correct = false;
    }
    return correct;
}

bool CDAOFactorySQLite::commit()
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    if( sqlite3_exec(m_database, "COMMIT;", NULL, NULL, &msgError)!=SQLITE_OK ){
        LOG_ERROR("Error in 'COMMIT;': \"%s\"", msgError);
        sqlite3_free(msgError);
        correct = false;
    }
    return correct;
}

bool CDAOFactorySQLite::rollback()
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    if( sqlite3_exec(m_database, "ROLLBACK;", NULL, NULL, &msgError)!=SQLITE_OK ){
        LOG_ERROR("Error in 'ROLLBACK;': \"%s\"", msgError);
        sqlite3_free(msgError);
        correct = false;
    }
    return correct;
}

void CDAOFactorySQLite::save()
{
    // Closing temp database
    m_PfCompetitionPhasesDAOSQLite->setSQLite(NULL);
    m_PfRankingDAOSQLite->setSQLite(NULL);
    m_PfTeamAveragesDAOSQLite->setSQLite(NULL);
    m_PfFormationsDAOSQLite->setSQLite(NULL);
    m_PfTeamsByCompetitionsDAOSQLite->setSQLite(NULL);
    m_PfConfederationsDAOSQLite->setSQLite(NULL);
    m_PfTeamPlayersDAOSQLite->setSQLite(NULL);
    m_PfStadiumsDAOSQLite->setSQLite(NULL);
    m_PfTeamsDAOSQLite->setSQLite(NULL);
    m_PfTeamPlayerAveragesDAOSQLite->setSQLite(NULL);
    m_PfCompetitionsBySeasonDAOSQLite->setSQLite(NULL);
    m_PfSeasonsDAOSQLite->setSQLite(NULL);
    m_PfDemarcationsDAOSQLite->setSQLite(NULL);
    m_PfTeamPlayerContractsDAOSQLite->setSQLite(NULL);
    m_PfStrategicPositionsDAOSQLite->setSQLite(NULL);
    m_PfCoachesDAOSQLite->setSQLite(NULL);
    m_PfMatchesDAOSQLite->setSQLite(NULL);
    m_PfGameOptionsDAOSQLite->setSQLite(NULL);
    m_PfGoalsDAOSQLite->setSQLite(NULL);
    m_PfRolesDAOSQLite->setSQLite(NULL);
    m_PfCountriesDAOSQLite->setSQLite(NULL);
    m_PfCoachContractsDAOSQLite->setSQLite(NULL);
    m_PfRolesByTeamPlayersDAOSQLite->setSQLite(NULL);
    m_PfFormationsByCoachesDAOSQLite->setSQLite(NULL);
    m_PfScorersDAOSQLite->setSQLite(NULL);
    m_PfCompetitionsDAOSQLite->setSQLite(NULL);

    sqlite3_close(m_database);
    m_database = NULL;

    // Copying data to original database
    copyFile(m_filepath_tmp, m_filepath);
    LOG_DEBUG("[CDAOFactorySQLite::save] SQLite Database saved: '%s'", m_filepath.c_str());

    // Reopening temp database
    if( sqlite3_open(m_filepath_tmp.c_str(), &m_database )!=SQLITE_OK ){
        sqlite3_close(m_database);
        m_database = NULL;
        throw PFEXCEPTION("Can't open database file: '%s' --> '%s'", m_filepath_tmp.c_str(), sqlite3_errmsg(m_database));
    }

    m_PfCompetitionPhasesDAOSQLite->setSQLite(m_database);
    m_PfRankingDAOSQLite->setSQLite(m_database);
    m_PfTeamAveragesDAOSQLite->setSQLite(m_database);
    m_PfFormationsDAOSQLite->setSQLite(m_database);
    m_PfTeamsByCompetitionsDAOSQLite->setSQLite(m_database);
    m_PfConfederationsDAOSQLite->setSQLite(m_database);
    m_PfTeamPlayersDAOSQLite->setSQLite(m_database);
    m_PfStadiumsDAOSQLite->setSQLite(m_database);
    m_PfTeamsDAOSQLite->setSQLite(m_database);
    m_PfTeamPlayerAveragesDAOSQLite->setSQLite(m_database);
    m_PfCompetitionsBySeasonDAOSQLite->setSQLite(m_database);
    m_PfSeasonsDAOSQLite->setSQLite(m_database);
    m_PfDemarcationsDAOSQLite->setSQLite(m_database);
    m_PfTeamPlayerContractsDAOSQLite->setSQLite(m_database);
    m_PfStrategicPositionsDAOSQLite->setSQLite(m_database);
    m_PfCoachesDAOSQLite->setSQLite(m_database);
    m_PfMatchesDAOSQLite->setSQLite(m_database);
    m_PfGameOptionsDAOSQLite->setSQLite(m_database);
    m_PfGoalsDAOSQLite->setSQLite(m_database);
    m_PfRolesDAOSQLite->setSQLite(m_database);
    m_PfCountriesDAOSQLite->setSQLite(m_database);
    m_PfCoachContractsDAOSQLite->setSQLite(m_database);
    m_PfRolesByTeamPlayersDAOSQLite->setSQLite(m_database);
    m_PfFormationsByCoachesDAOSQLite->setSQLite(m_database);
    m_PfScorersDAOSQLite->setSQLite(m_database);
    m_PfCompetitionsDAOSQLite->setSQLite(m_database);
}

IPfCompetitionPhasesDAO* CDAOFactorySQLite::getIPfCompetitionPhasesDAO()
{
    return m_PfCompetitionPhasesDAOSQLite;
}

IPfRankingDAO* CDAOFactorySQLite::getIPfRankingDAO()
{
    return m_PfRankingDAOSQLite;
}

IPfTeamAveragesDAO* CDAOFactorySQLite::getIPfTeamAveragesDAO()
{
    return m_PfTeamAveragesDAOSQLite;
}

IPfFormationsDAO* CDAOFactorySQLite::getIPfFormationsDAO()
{
    return m_PfFormationsDAOSQLite;
}

IPfTeamsByCompetitionsDAO* CDAOFactorySQLite::getIPfTeamsByCompetitionsDAO()
{
    return m_PfTeamsByCompetitionsDAOSQLite;
}

IPfConfederationsDAO* CDAOFactorySQLite::getIPfConfederationsDAO()
{
    return m_PfConfederationsDAOSQLite;
}

IPfTeamPlayersDAO* CDAOFactorySQLite::getIPfTeamPlayersDAO()
{
    return m_PfTeamPlayersDAOSQLite;
}

IPfStadiumsDAO* CDAOFactorySQLite::getIPfStadiumsDAO()
{
    return m_PfStadiumsDAOSQLite;
}

IPfTeamsDAO* CDAOFactorySQLite::getIPfTeamsDAO()
{
    return m_PfTeamsDAOSQLite;
}

IPfTeamPlayerAveragesDAO* CDAOFactorySQLite::getIPfTeamPlayerAveragesDAO()
{
    return m_PfTeamPlayerAveragesDAOSQLite;
}

IPfCompetitionsBySeasonDAO* CDAOFactorySQLite::getIPfCompetitionsBySeasonDAO()
{
    return m_PfCompetitionsBySeasonDAOSQLite;
}

IPfSeasonsDAO* CDAOFactorySQLite::getIPfSeasonsDAO()
{
    return m_PfSeasonsDAOSQLite;
}

IPfDemarcationsDAO* CDAOFactorySQLite::getIPfDemarcationsDAO()
{
    return m_PfDemarcationsDAOSQLite;
}

IPfTeamPlayerContractsDAO* CDAOFactorySQLite::getIPfTeamPlayerContractsDAO()
{
    return m_PfTeamPlayerContractsDAOSQLite;
}

IPfStrategicPositionsDAO* CDAOFactorySQLite::getIPfStrategicPositionsDAO()
{
    return m_PfStrategicPositionsDAOSQLite;
}

IPfCoachesDAO* CDAOFactorySQLite::getIPfCoachesDAO()
{
    return m_PfCoachesDAOSQLite;
}

IPfMatchesDAO* CDAOFactorySQLite::getIPfMatchesDAO()
{
    return m_PfMatchesDAOSQLite;
}

IPfGameOptionsDAO* CDAOFactorySQLite::getIPfGameOptionsDAO()
{
    return m_PfGameOptionsDAOSQLite;
}

IPfGoalsDAO* CDAOFactorySQLite::getIPfGoalsDAO()
{
    return m_PfGoalsDAOSQLite;
}

IPfRolesDAO* CDAOFactorySQLite::getIPfRolesDAO()
{
    return m_PfRolesDAOSQLite;
}

IPfCountriesDAO* CDAOFactorySQLite::getIPfCountriesDAO()
{
    return m_PfCountriesDAOSQLite;
}

IPfCoachContractsDAO* CDAOFactorySQLite::getIPfCoachContractsDAO()
{
    return m_PfCoachContractsDAOSQLite;
}

IPfRolesByTeamPlayersDAO* CDAOFactorySQLite::getIPfRolesByTeamPlayersDAO()
{
    return m_PfRolesByTeamPlayersDAOSQLite;
}

IPfFormationsByCoachesDAO* CDAOFactorySQLite::getIPfFormationsByCoachesDAO()
{
    return m_PfFormationsByCoachesDAOSQLite;
}

IPfScorersDAO* CDAOFactorySQLite::getIPfScorersDAO()
{
    return m_PfScorersDAOSQLite;
}

IPfCompetitionsDAO* CDAOFactorySQLite::getIPfCompetitionsDAO()
{
    return m_PfCompetitionsDAOSQLite;
}

void CDAOFactorySQLite::copyFile(const std::string &origin, const std::string &destination)
{
    std::ifstream  is(origin.c_str(),       std::ifstream::in|std::ifstream::binary);
    std::ofstream  os(destination.c_str(),  std::ofstream::out|std::ofstream::binary|std::ofstream::trunc);
    if( is.is_open() && os.is_open() ){
        LOG_DEBUG("[CDAOFactorySQLite::copyFile] Copying files: is:'%s' os:'%s'", origin.c_str(), destination.c_str());

        char buffer[4096]; // 4KBytes
        int  nBytes;
        while( !is.eof() ){
            is.read(buffer, sizeof(buffer));
            nBytes = is.gcount();
            os.write(buffer, nBytes);
        }
    }

    is.close();
    os.close();
}

