/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfGoalsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfGoalsDAOSQLiteEntity::CPfGoalsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfGoalsDAOSQLiteEntity::~CPfGoalsDAOSQLiteEntity()
{
}

void CPfGoalsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfGoalsDAOSQLiteEntity::deleteReg(CPfGoals *reg)
{
    std::string sql("DELETE FROM PF_GOALS WHERE X_GOAL=");
    sql += "'"+reg->getXGoal_str()+"'";
    return exec(sql);
}

bool CPfGoalsDAOSQLiteEntity::insertReg(CPfGoals *reg)
{
    std::string sql("INSERT INTO PF_GOALS (X_FK_TEAM_PLAYER_SCORER,L_OWN_GOAL,X_FK_TEAM_SCORER,X_FK_MATCH,N_MINUTE) VALUES (");
    sql += (reg->getXFkTeamPlayerScorer_str()=="")?"NULL":"'"+reg->getXFkTeamPlayerScorer_str()+"'";
    sql += (reg->getLOwnGoal_str()=="")?",NULL":",'"+reg->getLOwnGoal_str()+"'";
    sql += (reg->getXFkTeamScorer_str()=="")?",NULL":",'"+reg->getXFkTeamScorer_str()+"'";
    sql += (reg->getXFkMatch_str()=="")?",NULL":",'"+reg->getXFkMatch_str()+"'";
    sql += (reg->getNMinute_str()=="")?",NULL":",'"+reg->getNMinute_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXGoal(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfGoalsDAOSQLiteEntity::updateReg(CPfGoals *reg)
{
    std::string sql("UPDATE PF_GOALS SET ");
    sql += (reg->getXFkTeamPlayerScorer_str()=="")?" X_FK_TEAM_PLAYER_SCORER=NULL":" X_FK_TEAM_PLAYER_SCORER='"+reg->getXFkTeamPlayerScorer_str()+"'";
    sql += (reg->getXGoal_str()=="")?",X_GOAL=NULL":",X_GOAL='"+reg->getXGoal_str()+"'";
    sql += (reg->getLOwnGoal_str()=="")?",L_OWN_GOAL=NULL":",L_OWN_GOAL='"+reg->getLOwnGoal_str()+"'";
    sql += (reg->getXFkTeamScorer_str()=="")?",X_FK_TEAM_SCORER=NULL":",X_FK_TEAM_SCORER='"+reg->getXFkTeamScorer_str()+"'";
    sql += (reg->getXFkMatch_str()=="")?",X_FK_MATCH=NULL":",X_FK_MATCH='"+reg->getXFkMatch_str()+"'";
    sql += (reg->getNMinute_str()=="")?",N_MINUTE=NULL":",N_MINUTE='"+reg->getNMinute_str()+"'";
    sql += " WHERE X_GOAL='"+reg->getXGoal_str()+"'";
    return exec(sql);
}

void CPfGoalsDAOSQLiteEntity::freeVector(std::vector<CPfGoals*>* vector )
{
    std::vector<CPfGoals*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfGoals* CPfGoalsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfGoals *destiny = new CPfGoals();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfGoals*> * CPfGoalsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfGoals*> *container = new std::vector<CPfGoals*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfGoalsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfGoalsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfGoals *destiny = (CPfGoals*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_TEAM_PLAYER_SCORER")==0 ){
                destiny->setXFkTeamPlayerScorer_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_GOAL")==0 ){
                destiny->setXGoal_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "L_OWN_GOAL")==0 ){
                destiny->setLOwnGoal_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM_SCORER")==0 ){
                destiny->setXFkTeamScorer_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_MATCH")==0 ){
                destiny->setXFkMatch_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_MINUTE")==0 ){
                destiny->setNMinute_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfGoalsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfGoals*> *container = (std::vector<CPfGoals*> *)object;
        CPfGoals *destiny = new CPfGoals();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_TEAM_PLAYER_SCORER")==0 ){
                destiny->setXFkTeamPlayerScorer_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_GOAL")==0 ){
                destiny->setXGoal_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "L_OWN_GOAL")==0 ){
                destiny->setLOwnGoal_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM_SCORER")==0 ){
                destiny->setXFkTeamScorer_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_MATCH")==0 ){
                destiny->setXFkMatch_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_MINUTE")==0 ){
                destiny->setNMinute_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

