/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <iostream>
#include <sstream>

#include "CPfTeamsDAOSQLite.h"

CPfTeamsDAOSQLite::CPfTeamsDAOSQLite(sqlite3 *database)
  : CPfTeamsDAOSQLiteEntity(database)
{
}

CPfTeamsDAOSQLite::~CPfTeamsDAOSQLite()
{
}

CPfTeams* CPfTeamsDAOSQLite::findByXTeam(int XTeam)
{
    std::ostringstream stream;
    stream << XTeam;
    return findByXTeam(stream.str());
}

CPfTeams* CPfTeamsDAOSQLite::findByXTeam(const std::string &XTeam)
{
    std::string sql("SELECT * FROM PF_TEAMS WHERE ");
    sql = sql+"X_TEAM='"+XTeam+"'";
    return loadRegister(sql);
}

std::vector<CPfTeams*>* CPfTeamsDAOSQLite::findAll()
{
    std::string sql("SELECT * FROM PF_TEAMS");
    return loadVector(sql);
}

CPfTeams* CPfTeamsDAOSQLite::findByXFkStadium(int XFkStadium)
{
    std::ostringstream stream;
    stream << XFkStadium;
    return findByXFkStadium(stream.str());
}

CPfTeams* CPfTeamsDAOSQLite::findByXFkStadium(const std::string &XFkStadium)
{
    std::string sql("SELECT * FROM PF_TEAMS WHERE ");
    sql = sql+"X_FK_STADIUM='"+XFkStadium+"'";
    return loadRegister(sql);
}

std::vector<CPfTeams*>* CPfTeamsDAOSQLite::findByXFKCompetitionAndXFKSeason(int XFKCompetition, int XFKSeason)
{
    std::ostringstream strXFKCompetition;
    strXFKCompetition << XFKCompetition;

    std::ostringstream strXFKSeason;
    strXFKSeason << XFKSeason;

    return findByXFKCompetitionAndXFKSeason(strXFKCompetition.str(), strXFKSeason.str());
}

std::vector<CPfTeams*>* CPfTeamsDAOSQLite::findByXFKCompetitionAndXFKSeason(const std::string &XFKCompetition, const std::string &XFKSeason)
{
	std::string sql(
			"SELECT T.* "
			"FROM PF_TEAMS T "
			"  JOIN PF_TEAMS_BY_COMPETITIONS TBC ON TBC.X_FK_TEAM=T.X_TEAM "
			"  JOIN PF_COMPETITIONS_BY_SEASON CBS ON CBS.X_COMPETITION_BY_SEASON=TBC.X_FK_COMPETITION_BY_SEASON ");
	sql +=	"WHERE CBS.X_FK_SEASON='"+XFKSeason+"' AND CBS.X_FK_COMPETITION='"+XFKCompetition+"' ";
	sql +=	"ORDER BY T.S_TEAM";
	return loadVector(sql);
}

CPfTeams* CPfTeamsDAOSQLite::findByXFkCountry(int XFkCountry)
{
    std::ostringstream stream;
    stream << XFkCountry;
    return findByXFkCountry(stream.str());
}

CPfTeams* CPfTeamsDAOSQLite::findByXFkCountry(const std::string &XFkCountry)
{
    std::string sql("SELECT * FROM PF_TEAMS WHERE ");
    sql = sql+"X_FK_COUNTRY='"+XFkCountry+"'";
    return loadRegister(sql);
}

