/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.UsageMarker;

public class ShortestUsageMarker
extends UsageMarker {
    private static final ShortestUsageMark INITIAL_MARK = new ShortestUsageMark("is kept by a directive in the configuration.\n\n");
    private ShortestUsageMark currentUsageMark = INITIAL_MARK;
    private MyRecursiveCauseChecker recursiveCauseChecker = new MyRecursiveCauseChecker();

    protected void markProgramClassBody(ProgramClassFile programClassFile) {
        ShortestUsageMark shortestUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(programClassFile), "is extended by ", 10000, programClassFile);
        super.markProgramClassBody(programClassFile);
        this.currentUsageMark = shortestUsageMark;
    }

    protected void markProgramMethodBody(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        ShortestUsageMark shortestUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(programMethodInfo), "is invoked by  ", 1, programClassFile, programMethodInfo);
        super.markProgramMethodBody(programClassFile, programMethodInfo);
        this.currentUsageMark = shortestUsageMark;
    }

    protected void markMethodHierarchy(ClassFile classFile, MethodInfo methodInfo) {
        ShortestUsageMark shortestUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(methodInfo), "implements     ", 100, classFile, methodInfo);
        super.markMethodHierarchy(classFile, methodInfo);
        this.currentUsageMark = shortestUsageMark;
    }

    protected void markAsUsed(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        ShortestUsageMark shortestUsageMark = object != null && object instanceof ShortestUsageMark && !((ShortestUsageMark)object).isCertain() && !this.currentUsageMark.isShorter((ShortestUsageMark)object) ? new ShortestUsageMark((ShortestUsageMark)object, true) : this.currentUsageMark;
        visitorAccepter.setVisitorInfo(shortestUsageMark);
    }

    protected boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        return object == null || !(object instanceof ShortestUsageMark) || !((ShortestUsageMark)object).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)object);
    }

    protected boolean isUsed(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        return object != null && object instanceof ShortestUsageMark && ((ShortestUsageMark)object).isCertain();
    }

    protected void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(new ShortestUsageMark(this.currentUsageMark, false));
    }

    protected boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        return object == null || !(object instanceof ShortestUsageMark) || !((ShortestUsageMark)object).isCertain() && this.currentUsageMark.isShorter((ShortestUsageMark)object);
    }

    protected boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        return object != null && object instanceof ShortestUsageMark && !((ShortestUsageMark)object).isCertain();
    }

    protected ShortestUsageMark getShortestUsageMark(VisitorAccepter visitorAccepter) {
        Object object = visitorAccepter.getVisitorInfo();
        return (ShortestUsageMark)object;
    }

    private boolean isCausedBy(ShortestUsageMark shortestUsageMark, ClassFile classFile) {
        return this.recursiveCauseChecker.check(shortestUsageMark, classFile);
    }

    private class MyRecursiveCauseChecker
    implements ClassFileVisitor,
    MemberInfoVisitor {
        private ClassFile checkClassFile;
        private boolean isRecursing;

        private MyRecursiveCauseChecker() {
        }

        public boolean check(ShortestUsageMark shortestUsageMark, ClassFile classFile) {
            this.checkClassFile = classFile;
            this.isRecursing = false;
            shortestUsageMark.acceptClassFileVisitor(this);
            shortestUsageMark.acceptMethodInfoVisitor(this);
            return this.isRecursing;
        }

        public void visitProgramClassFile(ProgramClassFile programClassFile) {
            this.checkCause(programClassFile);
        }

        public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
            this.checkCause(libraryClassFile);
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            this.checkCause(programFieldInfo);
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            this.checkCause(programMethodInfo);
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
            this.checkCause(libraryFieldInfo);
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
            this.checkCause(libraryMethodInfo);
        }

        private void checkCause(VisitorAccepter visitorAccepter) {
            if (ShortestUsageMarker.this.isUsed(visitorAccepter)) {
                ShortestUsageMark shortestUsageMark = ShortestUsageMarker.this.getShortestUsageMark(visitorAccepter);
                this.isRecursing = shortestUsageMark.isCausedBy(this.checkClassFile);
                if (!this.isRecursing) {
                    shortestUsageMark.acceptClassFileVisitor(this);
                    shortestUsageMark.acceptMethodInfoVisitor(this);
                }
            }
        }
    }
}

