/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.peephole.SingleImplementationMarker;

public class SingleImplementationInliner
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.constantPoolEntriesAccept(this);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(stringCpInfo.referencedClassFile);
        if (classFile2 != null) {
            stringCpInfo.referencedClassFile = classFile2;
        }
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(interfaceMethodrefCpInfo.referencedClassFile);
        if (classFile2 != null) {
            String string = interfaceMethodrefCpInfo.getName(classFile);
            String string2 = interfaceMethodrefCpInfo.getType(classFile);
            interfaceMethodrefCpInfo.referencedClassFile = classFile2;
            interfaceMethodrefCpInfo.referencedMemberInfo = classFile2.findMethod(string, string2);
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(classCpInfo.referencedClassFile);
        if (classFile2 != null) {
            classCpInfo.referencedClassFile = classFile2;
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        ClassFile classFile = SingleImplementationMarker.singleImplementation(programFieldInfo.referencedClassFile);
        if (classFile != null) {
            programFieldInfo.referencedClassFile = classFile;
        }
        programFieldInfo.attributesAccept(programClassFile, this);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.updateReferencedClassFiles(programMethodInfo.referencedClassFiles);
        programMethodInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        this.updateReferencedClassFiles(signatureAttrInfo.referencedClassFiles);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(localVariableInfo.referencedClassFile);
        if (classFile2 != null) {
            localVariableInfo.referencedClassFile = classFile2;
        }
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        this.updateReferencedClassFiles(localVariableTypeInfo.referencedClassFiles);
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        this.updateReferencedClassFiles(annotation.referencedClassFiles);
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.updateReferencedClassFiles(enumConstantElementValue.referencedClassFiles);
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        this.updateReferencedClassFiles(classElementValue.referencedClassFiles);
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    private void updateReferencedClassFiles(ClassFile[] classFileArray) {
        if (classFileArray != null) {
            for (int i = 0; i < classFileArray.length; ++i) {
                ClassFile classFile = SingleImplementationMarker.singleImplementation(classFileArray[i]);
                if (classFile == null) continue;
                classFileArray[i] = classFile;
            }
        }
    }
}

