/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;

public class GotoGotoReplacer
implements InstructionVisitor {
    private CodeAttrInfoEditor codeAttrInfoEditor;
    private InstructionVisitor extraInstructionVisitor;

    public GotoGotoReplacer(CodeAttrInfoEditor codeAttrInfoEditor) {
        this(codeAttrInfoEditor, null);
    }

    public GotoGotoReplacer(CodeAttrInfoEditor codeAttrInfoEditor, InstructionVisitor instructionVisitor) {
        this.codeAttrInfoEditor = codeAttrInfoEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        if (by == -89 || by == -56) {
            int n2 = branchInstruction.branchOffset;
            int n3 = n + n2;
            if (n2 != branchInstruction.length(n) && !this.codeAttrInfoEditor.isModified(n) && !this.codeAttrInfoEditor.isModified(n3)) {
                Instruction instruction = InstructionFactory.create(codeAttrInfo.code, n3);
                if (instruction.opcode == -89) {
                    int n4 = ((BranchInstruction)instruction).branchOffset;
                    BranchInstruction branchInstruction2 = new BranchInstruction(by, n2 + n4);
                    this.codeAttrInfoEditor.replaceInstruction(n, branchInstruction2);
                    if (this.extraInstructionVisitor != null) {
                        this.extraInstructionVisitor.visitBranchInstruction(classFile, methodInfo, codeAttrInfo, n, branchInstruction);
                    }
                }
            }
        }
    }
}

