/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation.value;

import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.DoubleValueFactory;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.FloatValueFactory;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.IntegerValueFactory;
import proguard.optimize.evaluation.value.LongValue;
import proguard.optimize.evaluation.value.LongValueFactory;

class SpecificLongValue
extends LongValue {
    private long value;

    public SpecificLongValue(long l) {
        this.value = l;
    }

    public long value() {
        return this.value;
    }

    public LongValue generalize(LongValue longValue) {
        return longValue.generalize(this);
    }

    public LongValue add(LongValue longValue) {
        return longValue.add(this);
    }

    public LongValue subtract(LongValue longValue) {
        return longValue.subtractFrom(this);
    }

    public LongValue subtractFrom(LongValue longValue) {
        return longValue.subtract(this);
    }

    public LongValue multiply(LongValue longValue) {
        return longValue.multiply(this);
    }

    public LongValue divide(LongValue longValue) {
        return longValue.divideOf(this);
    }

    public LongValue divideOf(LongValue longValue) {
        return longValue.divide(this);
    }

    public LongValue remainder(LongValue longValue) {
        return longValue.remainderOf(this);
    }

    public LongValue remainderOf(LongValue longValue) {
        return longValue.remainder(this);
    }

    public LongValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public LongValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public LongValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public LongValue and(LongValue longValue) {
        return longValue.and(this);
    }

    public LongValue or(LongValue longValue) {
        return longValue.or(this);
    }

    public LongValue xor(LongValue longValue) {
        return longValue.xor(this);
    }

    public IntegerValue compare(LongValue longValue) {
        return longValue.compareReverse(this);
    }

    public LongValue negate() {
        return LongValueFactory.create(-this.value);
    }

    public IntegerValue convertToInteger() {
        return IntegerValueFactory.create((int)this.value);
    }

    public FloatValue convertToFloat() {
        return FloatValueFactory.create(this.value);
    }

    public DoubleValue convertToDouble() {
        return DoubleValueFactory.create(this.value);
    }

    public LongValue generalize(SpecificLongValue specificLongValue) {
        return this.value == specificLongValue.value ? this : LongValueFactory.create();
    }

    public LongValue add(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value + specificLongValue.value);
    }

    public LongValue subtract(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value - specificLongValue.value);
    }

    public LongValue subtractFrom(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value - this.value);
    }

    public LongValue multiply(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value * specificLongValue.value);
    }

    public LongValue divide(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value / specificLongValue.value);
    }

    public LongValue divideOf(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value / this.value);
    }

    public LongValue remainder(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value % specificLongValue.value);
    }

    public LongValue remainderOf(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value % this.value);
    }

    public LongValue and(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value & specificLongValue.value);
    }

    public LongValue or(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value | specificLongValue.value);
    }

    public LongValue xor(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(this.value ^ specificLongValue.value);
    }

    public IntegerValue compare(SpecificLongValue specificLongValue) {
        return this.value < specificLongValue.value ? IntegerValueFactory.create(-1) : (this.value == specificLongValue.value ? IntegerValueFactory.create(0) : IntegerValueFactory.create(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificLongValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return "l:" + this.value;
    }
}

