/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.MethodInfo;
import proguard.classfile.util.MethodInfoLinker;

public class MethodOptimizationInfo {
    private boolean hasNoSideEffects = false;
    private boolean hasSideEffects = false;
    private boolean canBeMadePrivate = true;
    private long usedVariables = 0L;

    public void setNoSideEffects() {
        this.hasNoSideEffects = true;
    }

    public boolean hasNoSideEffects() {
        return this.hasNoSideEffects;
    }

    public void setSideEffects() {
        this.hasSideEffects = true;
    }

    public boolean hasSideEffects() {
        return this.hasSideEffects;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void setUsedVariables(long l) {
        this.usedVariables = l;
    }

    public long getUsedVariables() {
        return this.usedVariables;
    }

    public void setVariableUsed(int n) {
        this.usedVariables |= (long)(1 << n);
    }

    public boolean isVariableUsed(int n) {
        return n >= 64 || (this.usedVariables & (long)(1 << n)) != 0L;
    }

    public static void setMethodOptimizationInfo(MethodInfo methodInfo) {
        MethodInfoLinker.lastMemberInfo(methodInfo).setVisitorInfo(new MethodOptimizationInfo());
    }

    public static MethodOptimizationInfo getMethodOptimizationInfo(MethodInfo methodInfo) {
        Object object = MethodInfoLinker.lastMemberInfo(methodInfo).getVisitorInfo();
        return object instanceof MethodOptimizationInfo ? (MethodOptimizationInfo)object : null;
    }
}

