/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.visitor.LineNumberInfoVisitor;

public class LineNumberTableAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2lineNumberTableLength;
    public LineNumberInfo[] lineNumberTable;

    protected LineNumberTableAttrInfo() {
    }

    public int getLineNumber(int n) {
        for (int i = this.u2lineNumberTableLength - 1; i >= 0; --i) {
            LineNumberInfo lineNumberInfo = this.lineNumberTable[i];
            if (n < lineNumberInfo.u2startpc) continue;
            return lineNumberInfo.u2lineNumber;
        }
        return this.u2lineNumberTableLength > 0 ? this.lineNumberTable[0].u2lineNumber : 0;
    }

    protected int getLength() {
        return 2 + this.u2lineNumberTableLength * 4;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2lineNumberTableLength = dataInput.readUnsignedShort();
        this.lineNumberTable = new LineNumberInfo[this.u2lineNumberTableLength];
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            this.lineNumberTable[i] = LineNumberInfo.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2lineNumberTableLength);
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            this.lineNumberTable[i].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitLineNumberTableAttrInfo(classFile, methodInfo, codeAttrInfo, this);
    }

    public void lineNumbersAccept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberInfoVisitor lineNumberInfoVisitor) {
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            lineNumberInfoVisitor.visitLineNumberInfo(classFile, methodInfo, codeAttrInfo, this.lineNumberTable[i]);
        }
    }
}

