/*
 * prismstumbler wireless lan analyzing tool
 *
 * Copyright (C) 2000 and created by Jan Fernquist  <Jan.B.Fernquist@telia.com>
 * Copyright (C) 2004 Florian Boor <florian.boor@kernelconcepts.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * GTK+ frontend, settings dialog
 *
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "setupdlg.h"
#include "psgui.h" 		/* show_message, do_detect_cards */
#include "helper.h"
#include "prismstumbler.h"

extern GtkWidget *fMain;


void
on_bRecGPSD_clicked (GtkButton *button, gpointer user_data)
{
	send_command(C_GPSD, 0);
}


void
on_bRedetect_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *parent = user_data;
	if (!GTK_IS_WINDOW(parent))
	{
		fprintf(stderr,"err parent window\n");
		return;		
	}	
	if (do_detect_cards())
		show_message(parent,GTK_MESSAGE_INFO,"Wireless LAN card(s) found.");
	else
		show_message(parent,GTK_MESSAGE_WARNING,"No wireless LAN cards detected.");
	
}


int
ps_do_setup(psconfig_t *cfg)
{
	GtkWidget *dialog;
	GtkWidget *cbLogPackets;
	GtkWidget *lDelay, *sbDelay;
	GtkWidget *lWPFile, *eWPFile;	
	GtkWidget *lDumpFile, *eDumpFile;
	GtkWidget *bRecGPSD, *bRedetect;
	GtkWidget *cbDHCP, *lDHCP;

	void
	create_setup_widgets(GtkWidget *dlgbox)
	{
		GtkWidget *table, *tw;
		GSList *dhcp_items = NULL;
		int i;
		
		table = gtk_table_new(6,3,FALSE);
		gtk_table_set_col_spacings(GTK_TABLE(table),3);
		gtk_table_set_row_spacings(GTK_TABLE(table),3);
		gtk_box_pack_start(GTK_BOX(dlgbox),table,TRUE,TRUE,0);
		
		tw = gtk_label_new(NULL);
		gtk_label_set_markup(GTK_LABEL(tw),"<b>Global Parameters</b>");
		gtk_misc_set_alignment(GTK_MISC(tw),0.0,0.5);
		gtk_table_attach(GTK_TABLE(table),tw,0,2,0,1,GTK_FILL,GTK_FILL,0,2);
		
		cbLogPackets = gtk_check_button_new_with_label("Log Data Packets");
		gtk_widget_set_sensitive(cbLogPackets,FALSE);
		gtk_table_attach(GTK_TABLE(table),cbLogPackets,0,2,1,2,GTK_FILL,GTK_FILL,0,0);
		
		lDelay = gtk_label_new("Slope Delay / us");
		gtk_misc_set_alignment(GTK_MISC(lDelay),1.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lDelay,0,1,2,3,GTK_FILL,GTK_FILL,0,0);
		sbDelay = gtk_spin_button_new_with_range(2000,2000000,100);
		gtk_table_attach(GTK_TABLE(table),sbDelay,1,2,2,3,GTK_FILL,GTK_FILL,0,0);
		
		lWPFile = gtk_label_new("Waypoint file");
		gtk_misc_set_alignment(GTK_MISC(lWPFile),1.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lWPFile,0,1,3,4,GTK_FILL,GTK_FILL,0,0);
		eWPFile = gtk_entry_new_with_max_length(255);
		gtk_table_attach(GTK_TABLE(table),eWPFile,1,2,3,4,GTK_FILL,GTK_FILL,0,0);

		lDHCP = gtk_label_new("DHCP client");
		gtk_misc_set_alignment(GTK_MISC(lDHCP),1.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lDHCP,0,1,4,5,GTK_FILL,GTK_FILL,0,0);
		cbDHCP = gtk_combo_new();
		gtk_combo_set_value_in_list(GTK_COMBO(cbDHCP),TRUE,FALSE);
		gtk_table_attach(GTK_TABLE(table),cbDHCP,1,2,4,5,GTK_FILL,GTK_FILL,0,0);
		
		lDumpFile = gtk_label_new("Package dump file");
		gtk_misc_set_alignment(GTK_MISC(lDumpFile),1.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lDumpFile,0,1,5,6,GTK_FILL,GTK_FILL,0,0);
		eDumpFile = gtk_entry_new_with_max_length(255);
		gtk_table_attach(GTK_TABLE(table),eDumpFile,1,2,5,6,GTK_FILL,GTK_FILL,0,0);

		bRecGPSD = gtk_button_new();
		gtk_button_set_label(GTK_BUTTON(bRecGPSD),"Connect GPS");
		gtk_table_attach(GTK_TABLE(table),bRecGPSD,0,1,6,7,GTK_FILL,GTK_FILL,3,3);
		g_signal_connect(G_OBJECT(bRecGPSD),"clicked",G_CALLBACK(on_bRecGPSD_clicked),fMain);		
		bRedetect = gtk_button_new();
		gtk_button_set_label(GTK_BUTTON(bRedetect),"Find Interfaces");
		gtk_table_attach(GTK_TABLE(table),bRedetect,1,2,6,7,GTK_FILL,GTK_FILL,3,3);
		g_signal_connect(G_OBJECT(bRedetect),"clicked",G_CALLBACK(on_bRedetect_clicked),fMain);		

		/* populate values */
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(sbDelay),(gdouble)cfg->delay);
		gtk_entry_set_text(GTK_ENTRY(eWPFile),cfg->wpfile);
		gtk_entry_set_text(GTK_ENTRY(eDumpFile),cfg->dumpfile);

		for (i=0;i<DHCP_CMDCOUNT;i++)
			dhcp_items = g_slist_append(dhcp_items,dhcpcommands[i]);
		gtk_combo_set_popdown_strings(GTK_COMBO(cbDHCP),dhcp_items);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cbDHCP)->entry),
          dhcpcommands[cfg->dhcpcommand]);
        
		gtk_widget_show_all(table);
	}


	dialog = gtk_dialog_new_with_buttons("Preferences",GTK_WINDOW(fMain),
	           GTK_DIALOG_DESTROY_WITH_PARENT,
	           GTK_STOCK_CANCEL,
	           GTK_RESPONSE_REJECT,
	           GTK_STOCK_OK,
	           GTK_RESPONSE_ACCEPT,
	           NULL);

	create_setup_widgets(GTK_DIALOG(dialog)->vbox);
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
	{
		int i;
		
		/* grab values */
		cfg->delay = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(sbDelay));
		snprintf(cfg->wpfile,255,gtk_entry_get_text(GTK_ENTRY(eWPFile)));
		snprintf(cfg->dumpfile,255,gtk_entry_get_text(GTK_ENTRY(eDumpFile)));
		
		cfg->dhcpcommand = 0;
		for (i=0;i<DHCP_CMDCOUNT;i++)
			if (!strcmp(gtk_entry_get_text(GTK_COMBO(cbDHCP)->entry),dhcpcommands[i]))
				cfg->dhcpcommand = i;
				
		gtk_widget_destroy(dialog);
		return TRUE;
	}
	else
	{		
		gtk_widget_destroy(dialog);
		return FALSE;
	}
}
