/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: urlnode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:42  slash
 * Initial release.
 *
 */

#ifndef URLNODE_H
#define URLNODE_H

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class represents an URL-node.
 * Note, that this class is obsoleted by the A-Node.
 */
class URLNode : public Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the URL-node.
     *
     * @param node The XML-node, which represents the URL-node.
     */
    URLNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~URLNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * This member-variable contains the target-URL itself.
     */
    char *url_;

    /**
     * This member-variable contains the name of the target-URL.
     */
    char *name_;
};

#endif //URLNODE_H
