/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = mm_strdup("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, mm_strdup("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = (name[0] == ':' ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 268 of yacc.c  */
#line 534 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BARRIER = 372,
     BEFORE = 373,
     BEGIN_P = 374,
     BETWEEN = 375,
     BIGINT = 376,
     BINARY = 377,
     BIT = 378,
     BOOLEAN_P = 379,
     BOTH = 380,
     BY = 381,
     CACHE = 382,
     CALLED = 383,
     CASCADE = 384,
     CASCADED = 385,
     CASE = 386,
     CAST = 387,
     CATALOG_P = 388,
     CHAIN = 389,
     CHAR_P = 390,
     CHARACTER = 391,
     CHARACTERISTICS = 392,
     CHECK = 393,
     CHECKPOINT = 394,
     CLASS = 395,
     CLEAN = 396,
     CLOSE = 397,
     CLUSTER = 398,
     COALESCE = 399,
     COLLATE = 400,
     COLLATION = 401,
     COLUMN = 402,
     COMMENT = 403,
     COMMENTS = 404,
     COMMIT = 405,
     COMMITTED = 406,
     CONCURRENTLY = 407,
     CONFIGURATION = 408,
     CONNECTION = 409,
     CONSTRAINT = 410,
     CONSTRAINTS = 411,
     CONTENT_P = 412,
     CONTINUE_P = 413,
     CONVERSION_P = 414,
     COORDINATOR = 415,
     COPY = 416,
     COST = 417,
     CREATE = 418,
     CROSS = 419,
     CSV = 420,
     CURRENT_P = 421,
     CURRENT_CATALOG = 422,
     CURRENT_DATE = 423,
     CURRENT_ROLE = 424,
     CURRENT_SCHEMA = 425,
     CURRENT_TIME = 426,
     CURRENT_TIMESTAMP = 427,
     CURRENT_USER = 428,
     CURSOR = 429,
     CYCLE = 430,
     DATA_P = 431,
     DATABASE = 432,
     DAY_P = 433,
     DEALLOCATE = 434,
     DEC = 435,
     DECIMAL_P = 436,
     DECLARE = 437,
     DEFAULT = 438,
     DEFAULTS = 439,
     DEFERRABLE = 440,
     DEFERRED = 441,
     DEFINER = 442,
     DELETE_P = 443,
     DELIMITER = 444,
     DELIMITERS = 445,
     DESC = 446,
     DICTIONARY = 447,
     DIRECT = 448,
     DISABLE_P = 449,
     DISCARD = 450,
     DISTINCT = 451,
     DISTRIBUTE = 452,
     DO = 453,
     DOCUMENT_P = 454,
     DOMAIN_P = 455,
     DOUBLE_P = 456,
     DROP = 457,
     EACH = 458,
     ELSE = 459,
     ENABLE_P = 460,
     ENCODING = 461,
     ENCRYPTED = 462,
     END_P = 463,
     ENUM_P = 464,
     ESCAPE = 465,
     EXCEPT = 466,
     EXCLUDE = 467,
     EXCLUDING = 468,
     EXCLUSIVE = 469,
     EXECUTE = 470,
     EXISTS = 471,
     EXPLAIN = 472,
     EXTENSION = 473,
     EXTERNAL = 474,
     EXTRACT = 475,
     FALSE_P = 476,
     FAMILY = 477,
     FETCH = 478,
     FIRST_P = 479,
     FLOAT_P = 480,
     FOLLOWING = 481,
     FOR = 482,
     FORCE = 483,
     FOREIGN = 484,
     FORWARD = 485,
     FREEZE = 486,
     FROM = 487,
     FULL = 488,
     FUNCTION = 489,
     FUNCTIONS = 490,
     GLOBAL = 491,
     GRANT = 492,
     GRANTED = 493,
     GREATEST = 494,
     GROUP_P = 495,
     HANDLER = 496,
     HASH = 497,
     HAVING = 498,
     HEADER_P = 499,
     HOLD = 500,
     HOUR_P = 501,
     IDENTITY_P = 502,
     IF_P = 503,
     ILIKE = 504,
     IMMEDIATE = 505,
     IMMUTABLE = 506,
     IMPLICIT_P = 507,
     IN_P = 508,
     INCLUDING = 509,
     INCREMENT = 510,
     INDEX = 511,
     INDEXES = 512,
     INHERIT = 513,
     INHERITS = 514,
     INITIALLY = 515,
     INLINE_P = 516,
     INNER_P = 517,
     INOUT = 518,
     INPUT_P = 519,
     INSENSITIVE = 520,
     INSERT = 521,
     INSTEAD = 522,
     INT_P = 523,
     INTEGER = 524,
     INTERSECT = 525,
     INTERVAL = 526,
     INTO = 527,
     INVOKER = 528,
     IS = 529,
     ISNULL = 530,
     ISOLATION = 531,
     JOIN = 532,
     KEY = 533,
     LABEL = 534,
     LANGUAGE = 535,
     LARGE_P = 536,
     LAST_P = 537,
     LC_COLLATE_P = 538,
     LC_CTYPE_P = 539,
     LEADING = 540,
     LEAST = 541,
     LEFT = 542,
     LEVEL = 543,
     LIKE = 544,
     LIMIT = 545,
     LISTEN = 546,
     LOAD = 547,
     LOCAL = 548,
     LOCALTIME = 549,
     LOCALTIMESTAMP = 550,
     LOCATION = 551,
     LOCK_P = 552,
     MAPPING = 553,
     MATCH = 554,
     MAXVALUE = 555,
     MINUTE_P = 556,
     MINVALUE = 557,
     MODE = 558,
     MODULO = 559,
     MONTH_P = 560,
     MOVE = 561,
     NAME_P = 562,
     NAMES = 563,
     NATIONAL = 564,
     NATURAL = 565,
     NCHAR = 566,
     NEXT = 567,
     NO = 568,
     NODE = 569,
     NONE = 570,
     NOT = 571,
     NOTHING = 572,
     NOTIFY = 573,
     NOTNULL = 574,
     NOWAIT = 575,
     NULL_P = 576,
     NULLIF = 577,
     NULLS_P = 578,
     NUMERIC = 579,
     OBJECT_P = 580,
     OF = 581,
     OFF = 582,
     OFFSET = 583,
     OIDS = 584,
     ON = 585,
     ONLY = 586,
     OPERATOR = 587,
     OPTION = 588,
     OPTIONS = 589,
     OR = 590,
     ORDER = 591,
     OUT_P = 592,
     OUTER_P = 593,
     OVER = 594,
     OVERLAPS = 595,
     OVERLAY = 596,
     OWNED = 597,
     OWNER = 598,
     PARSER = 599,
     PARTIAL = 600,
     PARTITION = 601,
     PASSING = 602,
     PASSWORD = 603,
     PLACING = 604,
     PLANS = 605,
     POSITION = 606,
     PRECEDING = 607,
     PRECISION = 608,
     PREFERRED = 609,
     PRESERVE = 610,
     PREPARE = 611,
     PREPARED = 612,
     PRIMARY = 613,
     PRIOR = 614,
     PRIVILEGES = 615,
     PROCEDURAL = 616,
     PROCEDURE = 617,
     QUOTE = 618,
     RANGE = 619,
     READ = 620,
     REAL = 621,
     REASSIGN = 622,
     RECHECK = 623,
     RECURSIVE = 624,
     REF = 625,
     REFERENCES = 626,
     REINDEX = 627,
     RELATIVE_P = 628,
     RELEASE = 629,
     RENAME = 630,
     REPEATABLE = 631,
     REPLACE = 632,
     REPLICA = 633,
     REPLICATION = 634,
     RESET = 635,
     RESTART = 636,
     RESTRICT = 637,
     RETURNING = 638,
     RETURNS = 639,
     REVOKE = 640,
     RIGHT = 641,
     ROBIN = 642,
     ROLE = 643,
     ROLLBACK = 644,
     ROUND = 645,
     ROW = 646,
     ROWS = 647,
     RULE = 648,
     SAVEPOINT = 649,
     SCHEMA = 650,
     SCROLL = 651,
     SEARCH = 652,
     SECOND_P = 653,
     SECURITY = 654,
     SELECT = 655,
     SEQUENCE = 656,
     SEQUENCES = 657,
     SERIALIZABLE = 658,
     SERVER = 659,
     SESSION = 660,
     SESSION_USER = 661,
     SET = 662,
     SETOF = 663,
     SHARE = 664,
     SHOW = 665,
     SIMILAR = 666,
     SIMPLE = 667,
     SMALLINT = 668,
     SOME = 669,
     STABLE = 670,
     STANDALONE_P = 671,
     START = 672,
     STATEMENT = 673,
     STATISTICS = 674,
     STDIN = 675,
     STDOUT = 676,
     STORAGE = 677,
     STRICT_P = 678,
     STRIP_P = 679,
     SUBSTRING = 680,
     SYMMETRIC = 681,
     SYSID = 682,
     SYSTEM_P = 683,
     TABLE = 684,
     TABLES = 685,
     TABLESPACE = 686,
     TEMP = 687,
     TEMPLATE = 688,
     TEMPORARY = 689,
     TEXT_P = 690,
     THEN = 691,
     TIME = 692,
     TIMESTAMP = 693,
     TO = 694,
     TRAILING = 695,
     TRANSACTION = 696,
     TREAT = 697,
     TRIGGER = 698,
     TRIM = 699,
     TRUE_P = 700,
     TRUNCATE = 701,
     TRUSTED = 702,
     TYPE_P = 703,
     UNBOUNDED = 704,
     UNCOMMITTED = 705,
     UNENCRYPTED = 706,
     UNION = 707,
     UNIQUE = 708,
     UNKNOWN = 709,
     UNLISTEN = 710,
     UNLOGGED = 711,
     UNTIL = 712,
     UPDATE = 713,
     USER = 714,
     USING = 715,
     VACUUM = 716,
     VALID = 717,
     VALIDATE = 718,
     VALIDATOR = 719,
     VALUE_P = 720,
     VALUES = 721,
     VARCHAR = 722,
     VARIADIC = 723,
     VARYING = 724,
     VERBOSE = 725,
     VERSION_P = 726,
     VIEW = 727,
     VOLATILE = 728,
     WHEN = 729,
     WHERE = 730,
     WHITESPACE_P = 731,
     WINDOW = 732,
     WITH = 733,
     WITHOUT = 734,
     WORK = 735,
     WRAPPER = 736,
     WRITE = 737,
     XML_P = 738,
     XMLATTRIBUTES = 739,
     XMLCONCAT = 740,
     XMLELEMENT = 741,
     XMLEXISTS = 742,
     XMLFOREST = 743,
     XMLPARSE = 744,
     XMLPI = 745,
     XMLROOT = 746,
     XMLSERIALIZE = 747,
     YEAR_P = 748,
     YES_P = 749,
     ZONE = 750,
     NULLS_FIRST = 751,
     NULLS_LAST = 752,
     WITH_TIME = 753,
     POSTFIXOP = 754,
     UMINUS = 755
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 463 "preproc.y"

	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 293 of yacc.c  */
#line 1087 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 1112 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   103228

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  520
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  704
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2740
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4924

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   755

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   507,     2,     2,
     512,   513,   505,   503,   515,   504,   514,   506,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   517,   516,
     500,   499,   501,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   510,     2,   511,   508,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   518,     2,   519,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   502,   509
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   265,   267,   269,   271,   273,   275,   277,
     279,   280,   286,   288,   289,   292,   293,   296,   297,   300,
     303,   307,   311,   313,   317,   321,   324,   326,   328,   331,
     334,   337,   341,   345,   351,   357,   358,   362,   368,   374,
     379,   383,   389,   393,   399,   405,   412,   414,   416,   420,
     426,   433,   438,   440,   441,   444,   445,   447,   449,   451,
     453,   455,   457,   460,   464,   468,   472,   476,   480,   484,
     488,   492,   495,   501,   504,   507,   510,   513,   517,   521,
     525,   527,   531,   533,   537,   539,   541,   544,   547,   550,
     552,   554,   556,   558,   560,   562,   564,   568,   575,   577,
     579,   581,   583,   585,   586,   588,   590,   593,   597,   602,
     606,   609,   612,   614,   618,   623,   629,   634,   637,   642,
     644,   646,   648,   650,   652,   655,   658,   661,   664,   669,
     674,   679,   684,   686,   690,   693,   697,   702,   709,   716,
     723,   729,   735,   742,   749,   754,   763,   766,   770,   777,
     782,   786,   790,   794,   798,   802,   807,   812,   816,   820,
     824,   828,   832,   836,   841,   846,   850,   853,   857,   860,
     863,   867,   871,   874,   877,   879,   883,   886,   888,   890,
     891,   894,   895,   898,   899,   903,   906,   907,   909,   913,
     917,   919,   925,   929,   934,   936,   940,   945,   952,   957,
     966,   969,   972,   983,   990,   992,   994,   996,   998,  1000,
    1002,  1006,  1009,  1010,  1012,  1014,  1018,  1022,  1024,  1026,
    1030,  1034,  1038,  1042,  1047,  1050,  1052,  1053,  1056,  1057,
    1061,  1062,  1064,  1065,  1067,  1071,  1074,  1076,  1078,  1080,
    1084,  1085,  1087,  1091,  1093,  1107,  1124,  1137,  1153,  1155,
    1157,  1160,  1163,  1166,  1169,  1171,  1172,  1174,  1175,  1179,
    1180,  1182,  1186,  1188,  1192,  1194,  1196,  1198,  1200,  1202,
    1206,  1211,  1214,  1215,  1219,  1221,  1223,  1226,  1229,  1231,
    1235,  1240,  1245,  1248,  1254,  1256,  1259,  1262,  1265,  1269,
    1273,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1290,  1294,
    1296,  1302,  1310,  1314,  1323,  1328,  1338,  1350,  1354,  1355,
    1357,  1361,  1363,  1366,  1369,  1372,  1373,  1375,  1379,  1383,
    1390,  1395,  1396,  1398,  1400,  1403,  1406,  1407,  1411,  1415,
    1418,  1420,  1422,  1425,  1428,  1433,  1434,  1437,  1440,  1443,
    1444,  1448,  1453,  1458,  1459,  1462,  1463,  1466,  1470,  1475,
    1482,  1486,  1491,  1492,  1496,  1500,  1501,  1506,  1507,  1511,
    1519,  1523,  1524,  1526,  1530,  1532,  1535,  1539,  1540,  1546,
    1551,  1553,  1554,  1556,  1559,  1562,  1564,  1567,  1571,  1574,
    1577,  1580,  1583,  1587,  1591,  1593,  1597,  1599,  1600,  1602,
    1605,  1607,  1609,  1613,  1620,  1631,  1633,  1634,  1636,  1639,
    1642,  1643,  1646,  1649,  1651,  1652,  1658,  1666,  1668,  1669,
    1676,  1679,  1680,  1684,  1690,  1696,  1705,  1708,  1709,  1712,
    1715,  1718,  1724,  1727,  1728,  1731,  1739,  1750,  1757,  1764,
    1771,  1778,  1786,  1794,  1804,  1814,  1821,  1828,  1837,  1846,
    1855,  1864,  1871,  1878,  1886,  1895,  1902,  1909,  1917,  1920,
    1923,  1926,  1929,  1931,  1934,  1936,  1937,  1944,  1953,  1961,
    1968,  1973,  1974,  1976,  1980,  1985,  1987,  1991,  1993,  1996,
    1999,  2002,  2005,  2007,  2009,  2020,  2023,  2024,  2027,  2030,
    2032,  2033,  2038,  2045,  2051,  2056,  2061,  2070,  2082,  2086,
    2089,  2091,  2095,  2097,  2103,  2112,  2114,  2116,  2118,  2126,
    2136,  2145,  2161,  2182,  2184,  2186,  2189,  2191,  2195,  2197,
    2199,  2201,  2205,  2207,  2211,  2212,  2214,  2215,  2217,  2219,
    2224,  2225,  2227,  2231,  2232,  2234,  2236,  2238,  2240,  2243,
    2244,  2245,  2248,  2251,  2253,  2256,  2259,  2262,  2269,  2278,
    2287,  2292,  2298,  2303,  2308,  2313,  2317,  2325,  2334,  2341,
    2348,  2355,  2362,  2367,  2373,  2377,  2379,  2383,  2387,  2389,
    2391,  2393,  2395,  2397,  2399,  2403,  2407,  2411,  2413,  2417,
    2421,  2423,  2424,  2426,  2430,  2437,  2446,  2455,  2469,  2471,
    2475,  2481,  2488,  2493,  2501,  2504,  2506,  2507,  2510,  2511,
    2514,  2519,  2520,  2522,  2523,  2530,  2539,  2548,  2550,  2554,
    2560,  2566,  2574,  2584,  2592,  2602,  2608,  2615,  2622,  2627,
    2629,  2631,  2633,  2635,  2638,  2640,  2642,  2644,  2646,  2648,
    2650,  2654,  2658,  2662,  2666,  2668,  2672,  2674,  2677,  2680,
    2684,  2690,  2693,  2696,  2697,  2704,  2712,  2720,  2728,  2737,
    2746,  2753,  2762,  2772,  2782,  2790,  2801,  2809,  2818,  2827,
    2836,  2845,  2847,  2849,  2851,  2853,  2855,  2857,  2859,  2861,
    2863,  2865,  2867,  2869,  2871,  2873,  2876,  2878,  2882,  2884,
    2886,  2895,  2905,  2915,  2925,  2935,  2938,  2939,  2941,  2944,
    2946,  2948,  2950,  2952,  2954,  2956,  2958,  2960,  2963,  2966,
    2970,  2975,  2981,  2986,  2992,  2996,  3001,  3005,  3010,  3012,
    3015,  3019,  3023,  3027,  3031,  3036,  3041,  3045,  3049,  3054,
    3059,  3064,  3069,  3071,  3073,  3075,  3076,  3084,  3092,  3103,
    3105,  3107,  3110,  3115,  3121,  3123,  3127,  3130,  3133,  3136,
    3139,  3141,  3144,  3147,  3152,  3156,  3159,  3162,  3165,  3169,
    3172,  3175,  3181,  3187,  3193,  3195,  3199,  3201,  3204,  3208,
    3209,  3211,  3215,  3218,  3225,  3232,  3242,  3246,  3247,  3251,
    3252,  3258,  3261,  3262,  3266,  3270,  3274,  3282,  3290,  3301,
    3303,  3305,  3307,  3322,  3324,  3325,  3327,  3328,  3330,  3331,
    3334,  3335,  3337,  3341,  3347,  3353,  3361,  3364,  3365,  3367,
    3370,  3371,  3373,  3375,  3376,  3378,  3380,  3381,  3391,  3404,
    3412,  3415,  3416,  3420,  3423,  3425,  3429,  3433,  3436,  3438,
    3442,  3446,  3450,  3453,  3456,  3458,  3460,  3462,  3464,  3467,
    3469,  3471,  3473,  3475,  3480,  3486,  3488,  3492,  3496,  3498,
    3501,  3506,  3512,  3514,  3516,  3518,  3520,  3524,  3528,  3531,
    3534,  3537,  3540,  3542,  3545,  3548,  3550,  3552,  3554,  3558,
    3561,  3562,  3565,  3567,  3571,  3577,  3579,  3582,  3584,  3585,
    3591,  3599,  3605,  3613,  3619,  3627,  3631,  3637,  3643,  3649,
    3651,  3655,  3658,  3660,  3663,  3665,  3668,  3680,  3691,  3702,
    3705,  3708,  3709,  3719,  3722,  3723,  3728,  3733,  3738,  3740,
    3742,  3744,  3745,  3753,  3760,  3767,  3774,  3781,  3788,  3796,
    3806,  3816,  3823,  3830,  3837,  3844,  3851,  3859,  3868,  3878,
    3887,  3894,  3901,  3908,  3914,  3920,  3929,  3938,  3947,  3956,
    3963,  3973,  3975,  3976,  3979,  3980,  3988,  3995,  4002,  4009,
    4016,  4023,  4031,  4041,  4051,  4058,  4067,  4076,  4085,  4094,
    4101,  4108,  4116,  4123,  4131,  4138,  4145,  4152,  4159,  4166,
    4174,  4182,  4190,  4200,  4210,  4217,  4224,  4231,  4240,  4249,
    4258,  4265,  4279,  4281,  4283,  4287,  4291,  4293,  4295,  4297,
    4299,  4301,  4303,  4305,  4306,  4308,  4310,  4312,  4314,  4316,
    4318,  4319,  4326,  4335,  4339,  4342,  4343,  4346,  4349,  4352,
    4355,  4359,  4363,  4366,  4369,  4372,  4375,  4379,  4382,  4388,
    4393,  4397,  4401,  4405,  4407,  4409,  4410,  4414,  4417,  4420,
    4422,  4425,  4427,  4431,  4434,  4436,  4437,  4446,  4457,  4461,
    4466,  4471,  4472,  4475,  4481,  4484,  4485,  4489,  4493,  4497,
    4501,  4505,  4509,  4513,  4517,  4521,  4525,  4529,  4533,  4537,
    4542,  4546,  4550,  4552,  4553,  4559,  4566,  4571,  4574,  4575,
    4580,  4584,  4590,  4597,  4602,  4609,  4616,  4622,  4630,  4632,
    4633,  4640,  4652,  4664,  4676,  4690,  4700,  4712,  4723,  4728,
    4731,  4737,  4740,  4741,  4746,  4752,  4758,  4763,  4770,  4772,
    4776,  4778,  4780,  4782,  4784,  4787,  4792,  4794,  4796,  4798,
    4799,  4801,  4802,  4804,  4805,  4809,  4810,  4814,  4816,  4817,
    4822,  4824,  4826,  4830,  4832,  4837,  4841,  4848,  4853,  4856,
    4861,  4865,  4871,  4873,  4875,  4877,  4879,  4881,  4883,  4885,
    4887,  4891,  4894,  4896,  4898,  4900,  4902,  4904,  4905,  4911,
    4913,  4921,  4929,  4937,  4941,  4944,  4945,  4949,  4952,  4953,
    4959,  4964,  4968,  4969,  4971,  4973,  4975,  4977,  4982,  4991,
    4995,  4996,  5003,  5005,  5010,  5013,  5015,  5019,  5022,  5026,
    5027,  5035,  5038,  5039,  5045,  5049,  5050,  5053,  5056,  5059,
    5063,  5065,  5069,  5071,  5074,  5076,  5077,  5086,  5088,  5092,
    5094,  5096,  5100,  5106,  5109,  5111,  5115,  5123,  5125,  5127,
    5128,  5132,  5135,  5138,  5141,  5142,  5145,  5148,  5150,  5152,
    5156,  5160,  5162,  5165,  5170,  5175,  5178,  5182,  5188,  5194,
    5196,  5198,  5208,  5210,  5213,  5218,  5223,  5228,  5231,  5235,
    5237,  5241,  5248,  5250,  5251,  5254,  5256,  5257,  5261,  5265,
    5270,  5275,  5280,  5285,  5289,  5292,  5294,  5296,  5297,  5299,
    5301,  5302,  5304,  5310,  5312,  5313,  5315,  5316,  5320,  5322,
    5326,  5331,  5335,  5338,  5341,  5343,  5345,  5347,  5348,  5351,
    5356,  5362,  5365,  5369,  5371,  5373,  5375,  5377,  5381,  5382,
    5384,  5386,  5388,  5390,  5392,  5396,  5397,  5400,  5401,  5403,
    5407,  5409,  5410,  5412,  5415,  5420,  5425,  5428,  5429,  5432,
    5436,  5439,  5440,  5442,  5446,  5448,  5451,  5453,  5456,  5462,
    5469,  5475,  5477,  5480,  5482,  5487,  5491,  5496,  5502,  5507,
    5513,  5518,  5524,  5527,  5532,  5534,  5537,  5540,  5543,  5545,
    5547,  5548,  5553,  5556,  5558,  5561,  5564,  5569,  5571,  5575,
    5577,  5580,  5584,  5586,  5589,  5590,  5593,  5598,  5599,  5601,
    5602,  5604,  5608,  5612,  5615,  5619,  5625,  5632,  5635,  5639,
    5643,  5648,  5649,  5651,  5653,  5655,  5657,  5659,  5662,  5668,
    5670,  5672,  5674,  5676,  5679,  5683,  5687,  5688,  5690,  5692,
    5694,  5696,  5698,  5701,  5704,  5707,  5710,  5713,  5715,  5719,
    5720,  5722,  5724,  5726,  5728,  5734,  5737,  5739,  5741,  5743,
    5745,  5751,  5754,  5757,  5760,  5762,  5766,  5770,  5773,  5775,
    5776,  5780,  5781,  5787,  5790,  5796,  5799,  5801,  5804,  5808,
    5809,  5811,  5813,  5815,  5817,  5819,  5821,  5825,  5829,  5833,
    5837,  5841,  5845,  5849,  5850,  5852,  5857,  5859,  5863,  5867,
    5873,  5876,  5879,  5883,  5887,  5891,  5895,  5899,  5903,  5907,
    5911,  5915,  5919,  5922,  5925,  5929,  5933,  5936,  5940,  5946,
    5951,  5958,  5962,  5968,  5973,  5980,  5985,  5992,  5998,  6006,
    6010,  6013,  6018,  6021,  6025,  6029,  6034,  6038,  6043,  6047,
    6052,  6058,  6065,  6072,  6080,  6087,  6095,  6102,  6110,  6114,
    6119,  6124,  6131,  6134,  6138,  6143,  6145,  6149,  6152,  6155,
    6159,  6163,  6167,  6171,  6175,  6179,  6183,  6187,  6191,  6195,
    6198,  6201,  6207,  6214,  6221,  6229,  6233,  6238,  6240,  6242,
    6245,  6250,  6252,  6254,  6256,  6259,  6262,  6265,  6267,  6272,
    6278,  6285,  6294,  6301,  6309,  6317,  6323,  6325,  6327,  6332,
    6334,  6339,  6341,  6346,  6348,  6353,  6355,  6357,  6359,  6361,
    6363,  6365,  6372,  6377,  6382,  6387,  6392,  6399,  6405,  6411,
    6417,  6422,  6429,  6434,  6439,  6444,  6449,  6455,  6463,  6471,
    6481,  6487,  6492,  6499,  6505,  6513,  6521,  6529,  6532,  6536,
    6540,  6544,  6549,  6550,  6555,  6557,  6561,  6565,  6567,  6569,
    6571,  6574,  6577,  6578,  6581,  6586,  6591,  6598,  6601,  6602,
    6604,  6608,  6612,  6615,  6618,  6619,  6626,  6628,  6629,  6633,
    6634,  6637,  6640,  6641,  6643,  6648,  6651,  6654,  6657,  6660,
    6663,  6668,  6672,  6678,  6680,  6682,  6684,  6686,  6688,  6690,
    6692,  6694,  6696,  6698,  6700,  6702,  6704,  6706,  6708,  6713,
    6715,  6720,  6722,  6727,  6729,  6732,  6734,  6737,  6739,  6743,
    6745,  6749,  6751,  6755,  6757,  6761,  6765,  6769,  6772,  6774,
    6778,  6782,  6783,  6785,  6787,  6789,  6791,  6793,  6795,  6797,
    6799,  6804,  6808,  6811,  6815,  6816,  6820,  6824,  6827,  6830,
    6832,  6833,  6836,  6839,  6843,  6846,  6848,  6850,  6854,  6860,
    6862,  6865,  6870,  6873,  6874,  6876,  6877,  6879,  6882,  6885,
    6888,  6892,  6898,  6900,  6903,  6904,  6907,  6909,  6910,  6912,
    6914,  6916,  6920,  6924,  6926,  6930,  6934,  6937,  6939,  6941,
    6943,  6947,  6949,  6952,  6954,  6958,  6960,  6962,  6964,  6966,
    6968,  6970,  6972,  6975,  6977,  6979,  6981,  6983,  6985,  6988,
    6994,  6997,  7001,  7008,  7010,  7012,  7014,  7016,  7018,  7020,
    7022,  7024,  7026,  7029,  7032,  7034,  7036,  7038,  7040,  7042,
    7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,  7060,  7062,
    7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,  7080,  7082,
    7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,  7100,  7102,
    7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,  7120,  7122,
    7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,  7140,  7142,
    7144,  7146,  7148,  7150,  7152,  7154,  7156,  7158,  7160,  7162,
    7164,  7166,  7168,  7170,  7172,  7174,  7176,  7178,  7180,  7182,
    7184,  7186,  7188,  7190,  7192,  7194,  7196,  7198,  7200,  7202,
    7204,  7206,  7208,  7210,  7212,  7214,  7216,  7218,  7220,  7222,
    7224,  7226,  7228,  7230,  7232,  7234,  7236,  7238,  7240,  7242,
    7244,  7246,  7248,  7250,  7252,  7254,  7256,  7258,  7260,  7262,
    7264,  7266,  7268,  7270,  7272,  7274,  7276,  7278,  7280,  7282,
    7284,  7286,  7288,  7290,  7292,  7294,  7296,  7298,  7300,  7302,
    7304,  7306,  7308,  7310,  7312,  7314,  7316,  7318,  7320,  7322,
    7324,  7326,  7328,  7330,  7332,  7334,  7336,  7338,  7340,  7342,
    7344,  7346,  7348,  7350,  7352,  7354,  7356,  7358,  7360,  7362,
    7364,  7366,  7368,  7370,  7372,  7374,  7376,  7378,  7380,  7382,
    7384,  7386,  7388,  7390,  7392,  7394,  7396,  7398,  7400,  7402,
    7404,  7406,  7408,  7410,  7412,  7414,  7416,  7418,  7420,  7422,
    7424,  7426,  7428,  7430,  7432,  7434,  7436,  7438,  7440,  7442,
    7444,  7446,  7448,  7450,  7452,  7454,  7456,  7458,  7460,  7462,
    7464,  7466,  7468,  7470,  7472,  7474,  7476,  7478,  7480,  7482,
    7484,  7486,  7488,  7490,  7492,  7494,  7496,  7498,  7500,  7502,
    7504,  7506,  7508,  7510,  7512,  7514,  7516,  7518,  7520,  7522,
    7524,  7526,  7528,  7530,  7532,  7534,  7536,  7538,  7540,  7542,
    7544,  7546,  7548,  7550,  7552,  7554,  7556,  7558,  7560,  7562,
    7564,  7566,  7568,  7570,  7572,  7574,  7576,  7578,  7580,  7582,
    7584,  7586,  7588,  7590,  7592,  7594,  7596,  7598,  7600,  7602,
    7604,  7606,  7608,  7610,  7612,  7614,  7616,  7618,  7620,  7622,
    7624,  7626,  7628,  7630,  7632,  7634,  7636,  7638,  7640,  7642,
    7644,  7646,  7648,  7650,  7652,  7654,  7656,  7658,  7660,  7662,
    7664,  7666,  7668,  7670,  7672,  7674,  7676,  7678,  7680,  7682,
    7684,  7686,  7688,  7690,  7692,  7694,  7696,  7698,  7700,  7702,
    7704,  7706,  7708,  7710,  7712,  7714,  7716,  7718,  7720,  7722,
    7724,  7726,  7728,  7730,  7732,  7734,  7736,  7738,  7740,  7742,
    7744,  7746,  7748,  7750,  7752,  7754,  7756,  7758,  7760,  7762,
    7764,  7766,  7768,  7770,  7772,  7774,  7776,  7778,  7780,  7782,
    7784,  7786,  7788,  7790,  7792,  7794,  7796,  7798,  7800,  7802,
    7804,  7806,  7808,  7810,  7812,  7814,  7815,  7818,  7823,  7827,
    7830,  7832,  7834,  7836,  7838,  7840,  7841,  7850,  7853,  7859,
    7863,  7866,  7869,  7873,  7881,  7883,  7885,  7887,  7888,  7891,
    7894,  7896,  7897,  7899,  7903,  7905,  7908,  7909,  7912,  7913,
    7916,  7917,  7919,  7923,  7928,  7932,  7934,  7936,  7938,  7940,
    7943,  7944,  7947,  7952,  7953,  7956,  7959,  7962,  7964,  7966,
    7974,  7978,  7980,  7982,  7984,  7986,  7989,  7990,  7992,  7996,
    8000,  8004,  8008,  8009,  8014,  8020,  8026,  8027,  8029,  8031,
    8033,  8036,  8039,  8041,  8044,  8045,  8053,  8054,  8060,  8061,
    8066,  8069,  8072,  8073,  8076,  8078,  8080,  8082,  8084,  8086,
    8088,  8090,  8092,  8094,  8096,  8098,  8104,  8107,  8109,  8113,
    8116,  8119,  8123,  8124,  8130,  8132,  8133,  8139,  8142,  8145,
    8147,  8149,  8151,  8154,  8157,  8161,  8163,  8166,  8169,  8173,
    8177,  8182,  8185,  8187,  8190,  8192,  8194,  8197,  8200,  8204,
    8206,  8208,  8210,  8212,  8213,  8215,  8219,  8225,  8226,  8229,
    8230,  8232,  8235,  8239,  8242,  8244,  8246,  8248,  8249,  8251,
    8253,  8255,  8257,  8259,  8262,  8265,  8269,  8270,  8272,  8275,
    8277,  8282,  8286,  8291,  8295,  8298,  8300,  8304,  8306,  8308,
    8310,  8312,  8315,  8318,  8320,  8323,  8326,  8328,  8330,  8332,
    8337,  8342,  8347,  8352,  8357,  8359,  8360,  8364,  8368,  8373,
    8375,  8379,  8383,  8388,  8390,  8394,  8398,  8400,  8402,  8404,
    8411,  8413,  8417,  8421,  8428,  8430,  8434,  8438,  8440,  8442,
    8445,  8448,  8450,  8452,  8454,  8456,  8458,  8460,  8462,  8464,
    8466,  8468,  8470,  8472,  8474,  8476,  8478,  8480,  8485,  8490,
    8492,  8494,  8499,  8504,  8508,  8509,  8517,  8519,  8520,  8521,
    8529,  8533,  8538,  8542,  8544,  8546,  8548,  8551,  8555,  8561,
    8564,  8570,  8573,  8575,  8577,  8579,  8581,  8583,  8585,  8587,
    8589,  8591,  8593,  8595,  8597,  8599,  8601,  8603,  8605,  8607,
    8609,  8611,  8613,  8615,  8617,  8619,  8621,  8623,  8625,  8627,
    8629,  8631,  8633,  8635,  8637,  8639,  8641,  8643,  8645,  8647,
    8649,  8651,  8653,  8655,  8657,  8659,  8661,  8663,  8665,  8667,
    8669,  8671,  8673,  8675,  8677,  8679,  8681,  8683,  8685,  8687,
    8689,  8691,  8693,  8695,  8697,  8699,  8701,  8703,  8705,  8707,
    8709,  8711,  8713,  8715,  8717,  8719,  8721,  8723,  8725,  8727,
    8729,  8731,  8733,  8735,  8737,  8739,  8741,  8743,  8745,  8747,
    8749,  8751,  8753,  8755,  8757,  8759,  8761,  8763,  8765,  8767,
    8769,  8773,  8775,  8776,  8778,  8781,  8783,  8786,  8788,  8790,
    8792,  8795,  8798,  8800,  8802,  8804,  8806,  8808,  8810,  8812,
    8814,  8816,  8818,  8820,  8822,  8824,  8826,  8828,  8830,  8833,
    8837,  8839,  8842,  8844,  8848,  8850,  8854,  8856,  8858,  8860,
    8862,  8864,  8866,  8868,  8870,  8872,  8874,  8876,  8878,  8880,
    8882,  8884,  8886,  8888,  8890,  8892,  8894,  8896,  8898,  8900,
    8902,  8904,  8906,  8908,  8910,  8912,  8914,  8916,  8918,  8920,
    8922,  8924,  8926,  8928,  8930,  8932,  8934,  8936,  8938,  8940,
    8942,  8944,  8946,  8948,  8950,  8952,  8954,  8956,  8958,  8960,
    8962,  8964,  8966,  8968,  8970,  8972,  8974,  8976,  8979,  8983,
    8986,  8990,  8992,  8996,  9000,  9004,  9008,  9012,  9016,  9018,
    9020,  9021,  9024,  9027,  9029,  9031,  9034,  9036,  9038,  9040,
    9041
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     521,     0,    -1,  1075,    -1,   850,    -1,   851,    -1,   768,
      -1,   856,    -1,   719,    -1,   659,    -1,   662,    -1,   668,
      -1,   682,    -1,   687,    -1,   803,    -1,   538,    -1,   878,
      -1,   824,    -1,   825,    -1,   638,    -1,   563,    -1,   574,
      -1,   532,    -1,   530,    -1,   859,    -1,   858,    -1,   691,
      -1,   534,    -1,   533,    -1,   866,    -1,   872,    -1,   561,
      -1,   890,    -1,   577,    -1,   861,    -1,   742,    -1,   558,
      -1,   578,    -1,  1077,    -1,   706,    -1,   814,    -1,   860,
      -1,   855,    -1,   656,    -1,   663,    -1,   677,    -1,   683,
      -1,   784,    -1,   537,    -1,   880,    -1,   874,    -1,   720,
      -1,   727,    -1,   728,    -1,   645,    -1,   541,    -1,   637,
      -1,   593,    -1,   653,    -1,   692,    -1,   523,    -1,   529,
      -1,   688,    -1,   846,    -1,  1218,    -1,   916,    -1,   708,
      -1,   903,    -1,   562,    -1,   811,    -1,   707,    -1,   816,
      -1,   667,    -1,   681,    -1,   540,    -1,   881,    -1,   879,
      -1,   731,    -1,   732,    -1,   733,    -1,   651,    -1,   833,
      -1,   735,    -1,   655,    -1,   705,    -1,   535,    -1,   536,
      -1,   690,    -1,   854,    -1,   896,    -1,   888,    -1,   882,
      -1,   749,    -1,   753,    -1,   764,    -1,   773,    -1,   898,
      -1,   836,    -1,   845,    -1,   905,    -1,   834,    -1,   893,
      -1,   734,    -1,   818,    -1,   807,    -1,   806,    -1,   808,
      -1,   821,    -1,   754,    -1,   765,    -1,   826,    -1,   745,
      -1,   920,    -1,   838,    -1,   740,    -1,   837,    -1,   909,
      -1,   863,    -1,   555,    -1,   545,    -1,   557,    -1,   843,
      -1,  1154,    -1,  1080,    -1,  1097,    -1,  1155,    -1,  1137,
      -1,  1152,    -1,  1138,    -1,  1098,    -1,  1142,    -1,  1164,
      -1,  1156,    -1,  1143,    -1,  1172,    -1,  1174,    -1,  1167,
      -1,  1159,    -1,  1175,    -1,  1178,    -1,  1180,    -1,    -1,
     163,   388,  1069,   524,   525,    -1,   478,    -1,    -1,   525,
     528,    -1,    -1,   526,   527,    -1,    -1,   348,  1208,    -1,
     348,   321,    -1,   207,   348,  1208,    -1,   451,   348,  1208,
      -1,   258,    -1,   154,   290,  1070,    -1,   462,   457,  1208,
      -1,   459,  1059,    -1,  1210,    -1,   527,    -1,   427,  1068,
      -1,    96,  1059,    -1,   388,  1059,    -1,   253,   388,  1059,
      -1,   253,   240,  1059,    -1,   163,   459,  1069,   524,   525,
      -1,   101,   388,  1069,   524,   526,    -1,    -1,   253,   177,
    1061,    -1,   101,   388,  1069,   531,   556,    -1,   101,   459,
    1069,   524,   526,    -1,   101,   459,  1069,   556,    -1,   202,
     388,  1059,    -1,   202,   388,   248,   216,  1059,    -1,   202,
     459,  1059,    -1,   202,   459,   248,   216,  1059,    -1,   163,
     240,  1069,   524,   525,    -1,   101,   240,  1069,   539,   459,
    1059,    -1,    95,    -1,   202,    -1,   202,   240,  1059,    -1,
     202,   240,   248,   216,  1059,    -1,   163,   395,   542,   115,
    1069,   543,    -1,   163,   395,  1188,   543,    -1,  1188,    -1,
      -1,   543,   544,    -1,    -1,   593,    -1,   773,    -1,   637,
      -1,   692,    -1,   753,    -1,   843,    -1,   407,   546,    -1,
     407,   293,   546,    -1,   407,   405,   546,    -1,   547,   439,
     548,    -1,   547,   499,   548,    -1,   547,   439,   183,    -1,
     547,   499,   183,    -1,   547,   232,   166,    -1,   437,   495,
     552,    -1,   441,   841,    -1,   405,   137,   108,   441,   841,
      -1,   133,  1208,    -1,   395,  1208,    -1,   308,   553,    -1,
     388,   554,    -1,   405,   115,   554,    -1,   405,   115,   183,
      -1,   483,   333,  1006,    -1,  1187,    -1,   547,   514,  1188,
      -1,   549,    -1,   548,   515,   549,    -1,   551,    -1,   643,
      -1,   365,   450,    -1,   365,   151,    -1,   376,   365,    -1,
     403,    -1,   445,    -1,   221,    -1,   330,    -1,   554,    -1,
    1208,    -1,  1210,    -1,   993,  1208,   995,    -1,   993,   512,
    1068,   513,  1208,   995,    -1,   643,    -1,   183,    -1,   293,
      -1,  1208,    -1,   183,    -1,    -1,  1188,    -1,  1208,    -1,
     380,   547,    -1,   380,   437,   495,    -1,   380,   441,   276,
     288,    -1,   380,   405,   115,    -1,   380,    99,    -1,   407,
     546,    -1,   555,    -1,   410,   547,  1221,    -1,   410,   437,
     495,  1221,    -1,   410,   441,   276,   288,  1221,    -1,   410,
     405,   115,  1221,    -1,   410,    99,    -1,   407,   156,   559,
     560,    -1,    99,    -1,  1057,    -1,   186,    -1,   250,    -1,
     139,    -1,   195,    99,    -1,   195,   432,    -1,   195,   434,
      -1,   195,   350,    -1,   101,   429,   964,   564,    -1,   101,
     256,  1058,   564,    -1,   101,   401,  1058,   564,    -1,   101,
     472,  1058,   564,    -1,   565,    -1,   564,   515,   565,    -1,
      95,   601,    -1,    95,   147,   601,    -1,   101,   822,  1188,
     566,    -1,   101,   822,  1188,   202,   316,   321,    -1,   101,
     822,  1188,   407,   316,   321,    -1,   101,   822,  1188,   407,
     419,  1070,    -1,   101,   822,  1188,   407,   570,    -1,   101,
     822,  1188,   380,   570,    -1,   101,   822,  1188,   407,   422,
    1188,    -1,   202,   822,   248,   216,  1188,   567,    -1,   202,
     822,  1188,   567,    -1,   101,   822,  1188,   823,   448,   973,
     568,   569,    -1,    95,   610,    -1,   463,   155,  1060,    -1,
     202,   155,   248,   216,  1060,   567,    -1,   202,   155,  1060,
     567,    -1,   407,   478,   329,    -1,   407,   479,   329,    -1,
     143,   330,  1060,    -1,   407,   479,   143,    -1,   205,   443,
    1060,    -1,   205,   102,   443,  1060,    -1,   205,   378,   443,
    1060,    -1,   205,   443,    99,    -1,   205,   443,   459,    -1,
     194,   443,  1060,    -1,   194,   443,    99,    -1,   194,   443,
     459,    -1,   205,   393,  1060,    -1,   205,   102,   393,  1060,
      -1,   205,   378,   393,  1060,    -1,   194,   393,  1060,    -1,
     258,  1058,    -1,   313,   258,  1058,    -1,   326,   738,    -1,
     316,   326,    -1,   343,   439,  1069,    -1,   407,   431,  1060,
      -1,   407,   570,    -1,   380,   570,    -1,   671,    -1,   407,
     183,   997,    -1,   202,   183,    -1,   129,    -1,   382,    -1,
      -1,   145,   738,    -1,    -1,   460,   997,    -1,    -1,   512,
     572,   513,    -1,   478,   570,    -1,    -1,   573,    -1,   572,
     515,   573,    -1,  1190,   499,   712,    -1,  1190,    -1,  1190,
     514,  1190,   499,   712,    -1,  1190,   514,  1190,    -1,   101,
     448,   738,   575,    -1,   576,    -1,   575,   515,   576,    -1,
      95,   114,   972,   567,    -1,   202,   114,   248,   216,  1188,
     567,    -1,   202,   114,  1188,   567,    -1,   101,   114,  1188,
     823,   448,   973,   568,   567,    -1,   142,   917,    -1,   142,
      99,    -1,   161,   584,  1058,   612,   585,   579,   580,   586,
     524,   581,    -1,   161,   921,   439,   580,   524,   581,    -1,
     232,    -1,   439,    -1,  1208,    -1,   420,    -1,   421,    -1,
     582,    -1,   512,   588,   513,    -1,   582,   583,    -1,    -1,
     122,    -1,   329,    -1,   189,   857,  1208,    -1,   321,   857,
    1208,    -1,   165,    -1,   244,    -1,   363,   857,  1208,    -1,
     210,   857,  1208,    -1,   228,   363,   613,    -1,   228,   363,
     505,    -1,   228,   316,   321,   613,    -1,   206,  1208,    -1,
     122,    -1,    -1,   478,   329,    -1,    -1,   587,   190,  1208,
      -1,    -1,   460,    -1,    -1,   589,    -1,   588,   515,   589,
      -1,  1190,   590,    -1,   551,    -1,   643,    -1,   505,    -1,
     512,   591,   513,    -1,    -1,   592,    -1,   591,   515,   592,
      -1,   551,    -1,   163,   594,   429,  1058,   512,   595,   513,
     623,   624,   625,   626,   628,   629,    -1,   163,   594,   429,
     248,   316,   216,  1058,   512,   595,   513,   623,   624,   625,
     626,   628,   629,    -1,   163,   594,   429,  1058,   326,   738,
     596,   624,   625,   626,   628,   629,    -1,   163,   594,   429,
     248,   316,   216,  1058,   326,   738,   596,   624,   625,   626,
     628,   629,    -1,   434,    -1,   432,    -1,   293,   434,    -1,
     293,   432,    -1,   236,   434,    -1,   236,   432,    -1,   456,
      -1,    -1,   597,    -1,    -1,   512,   598,   513,    -1,    -1,
     599,    -1,   597,   515,   599,    -1,   600,    -1,   598,   515,
     600,    -1,   601,    -1,   607,    -1,   610,    -1,   602,    -1,
     610,    -1,  1188,   973,   603,    -1,  1188,   478,   334,   603,
      -1,   603,   604,    -1,    -1,   155,  1060,   605,    -1,   605,
      -1,   606,    -1,   145,   738,    -1,   316,   321,    -1,   321,
      -1,   453,   800,   630,    -1,   358,   278,   800,   630,    -1,
     138,   512,   997,   513,    -1,   183,   998,    -1,   371,  1058,
     612,   615,   619,    -1,   185,    -1,   316,   185,    -1,   260,
     186,    -1,   260,   250,    -1,   289,  1058,   608,    -1,   608,
     254,   609,    -1,   608,   213,   609,    -1,    -1,   184,    -1,
     156,    -1,   257,    -1,   422,    -1,   149,    -1,    99,    -1,
     155,  1060,   611,    -1,   611,    -1,   138,   512,   997,   513,
     703,    -1,   453,   512,   613,   513,   800,   630,   703,    -1,
     453,   631,   703,    -1,   358,   278,   512,   613,   513,   800,
     630,   703,    -1,   358,   278,   631,   703,    -1,   212,   777,
     512,   616,   513,   800,   630,   618,   703,    -1,   229,   278,
     512,   613,   513,   371,  1058,   612,   615,   619,   703,    -1,
     512,   613,   513,    -1,    -1,   614,    -1,   613,   515,   614,
      -1,  1188,    -1,   299,   233,    -1,   299,   345,    -1,   299,
     412,    -1,    -1,   617,    -1,   616,   515,   617,    -1,   779,
     478,   810,    -1,   779,   478,   332,   512,   810,   513,    -1,
     475,   512,   997,   513,    -1,    -1,   620,    -1,   621,    -1,
     620,   621,    -1,   621,   620,    -1,    -1,   330,   458,   622,
      -1,   330,   188,   622,    -1,   313,    94,    -1,   382,    -1,
     129,    -1,   407,   321,    -1,   407,   183,    -1,   259,   512,
    1057,   513,    -1,    -1,   478,   570,    -1,   478,   329,    -1,
     479,   329,    -1,    -1,   330,   150,   202,    -1,   330,   150,
     188,   392,    -1,   330,   150,   355,   392,    -1,    -1,   431,
    1060,    -1,    -1,   197,   126,    -1,   197,   126,   242,    -1,
     627,   512,  1060,   513,    -1,   197,   126,   304,   512,  1060,
     513,    -1,   197,   126,   379,    -1,   197,   126,   390,   387,
      -1,    -1,   439,   314,   877,    -1,   439,   240,   876,    -1,
      -1,   460,   256,   431,  1060,    -1,    -1,   460,   256,  1064,
      -1,  1058,   633,   624,   625,   626,   628,   629,    -1,   512,
     634,   513,    -1,    -1,   635,    -1,   634,   515,   635,    -1,
    1188,    -1,   478,   176,    -1,   478,   313,   176,    -1,    -1,
     163,   594,   401,  1058,   639,    -1,   101,   401,  1058,   640,
      -1,   640,    -1,    -1,   641,    -1,   640,   641,    -1,   127,
     643,    -1,   175,    -1,   313,   175,    -1,   255,   642,   643,
      -1,   300,   643,    -1,   302,   643,    -1,   313,   300,    -1,
     313,   302,    -1,   342,   126,   738,    -1,   417,   524,   643,
      -1,   381,    -1,   381,   524,   643,    -1,   126,    -1,    -1,
    1207,    -1,   504,  1207,    -1,  1070,    -1,   643,    -1,   644,
     515,   643,    -1,   163,   785,   646,   652,   280,   554,    -1,
     163,   785,   646,   652,   280,   554,   241,   647,   648,   650,
      -1,   447,    -1,    -1,  1060,    -1,  1060,   739,    -1,   261,
     647,    -1,    -1,   464,   647,    -1,   313,   464,    -1,   649,
      -1,    -1,   202,   652,   280,   554,   567,    -1,   202,   652,
     280,   248,   216,   554,   567,    -1,   361,    -1,    -1,   163,
     431,  1060,   654,   296,  1208,    -1,   343,  1060,    -1,    -1,
     202,   431,  1060,    -1,   202,   431,   248,   216,  1060,    -1,
     163,   218,  1060,   524,   657,    -1,   163,   218,   248,   316,
     216,  1060,   524,   657,    -1,   657,   658,    -1,    -1,   395,
    1060,    -1,   471,   554,    -1,   232,   554,    -1,   101,   218,
    1060,   458,   660,    -1,   660,   661,    -1,    -1,   439,   554,
      -1,   101,   218,  1060,   539,    98,  1066,   713,    -1,   101,
     218,  1060,   539,   132,   512,   973,   108,   973,   513,    -1,
     101,   218,  1060,   539,   146,   738,    -1,   101,   218,  1060,
     539,   159,   738,    -1,   101,   218,  1060,   539,   200,   738,
      -1,   101,   218,  1060,   539,   234,   763,    -1,   101,   218,
    1060,   539,   652,   280,  1060,    -1,   101,   218,  1060,   539,
     332,   810,   809,    -1,   101,   218,  1060,   539,   332,   140,
     738,   460,  1062,    -1,   101,   218,  1060,   539,   332,   222,
     738,   460,  1062,    -1,   101,   218,  1060,   539,   395,  1060,
      -1,   101,   218,  1060,   539,   429,   738,    -1,   101,   218,
    1060,   539,   435,   397,   344,   738,    -1,   101,   218,  1060,
     539,   435,   397,   192,   738,    -1,   101,   218,  1060,   539,
     435,   397,   433,   738,    -1,   101,   218,  1060,   539,   435,
     397,   153,   738,    -1,   101,   218,  1060,   539,   401,   738,
      -1,   101,   218,  1060,   539,   472,   738,    -1,   101,   218,
    1060,   539,   229,   429,   738,    -1,   101,   218,  1060,   539,
     229,   176,   481,  1060,    -1,   101,   218,  1060,   539,   404,
    1060,    -1,   101,   218,  1060,   539,   448,   738,    -1,   163,
     229,   176,   481,  1060,   666,   669,    -1,   241,   647,    -1,
     313,   241,    -1,   464,   647,    -1,   313,   464,    -1,   664,
      -1,   665,   664,    -1,   665,    -1,    -1,   202,   229,   176,
     481,  1060,   567,    -1,   202,   229,   176,   481,   248,   216,
    1060,   567,    -1,   101,   229,   176,   481,  1060,   666,   671,
      -1,   101,   229,   176,   481,  1060,   665,    -1,   334,   512,
     670,   513,    -1,    -1,   674,    -1,   670,   515,   674,    -1,
     334,   512,   672,   513,    -1,   673,    -1,   672,   515,   673,
      -1,   674,    -1,   407,   674,    -1,    95,   674,    -1,   202,
     675,    -1,   675,   676,    -1,  1190,    -1,  1208,    -1,   163,
     404,  1060,   678,   680,   229,   176,   481,  1060,   669,    -1,
     448,  1208,    -1,    -1,   471,  1208,    -1,   471,   321,    -1,
     679,    -1,    -1,   202,   404,  1060,   567,    -1,   202,   404,
     248,   216,  1060,   567,    -1,   101,   404,  1060,   679,   671,
      -1,   101,   404,  1060,   679,    -1,   101,   404,  1060,   671,
      -1,   163,   229,   429,  1058,   684,   404,  1060,   669,    -1,
     163,   229,   429,   248,   316,   216,  1058,   684,   404,  1060,
     669,    -1,   512,   685,   513,    -1,   512,   513,    -1,   686,
      -1,   685,   515,   686,    -1,   601,    -1,   101,   229,   429,
     964,   564,    -1,   163,   459,   298,   227,   689,   404,  1060,
     669,    -1,   173,    -1,   459,    -1,  1069,    -1,   202,   459,
     298,   227,   689,   404,  1060,    -1,   202,   459,   298,   248,
     216,   227,   689,   404,  1060,    -1,   101,   459,   298,   227,
     689,   404,  1060,   671,    -1,   163,   443,  1060,   693,   694,
     330,  1058,   696,   699,   215,   362,  1066,   512,   700,   513,
      -1,   163,   155,   443,  1060,    97,   694,   330,  1058,   702,
     703,   227,   203,   391,   699,   215,   362,  1066,   512,   700,
     513,    -1,   118,    -1,    97,    -1,   267,   326,    -1,   695,
      -1,   694,   335,   695,    -1,   266,    -1,   188,    -1,   458,
      -1,   458,   326,   613,    -1,   446,    -1,   227,   697,   698,
      -1,    -1,   203,    -1,    -1,   391,    -1,   418,    -1,   474,
     512,   997,   513,    -1,    -1,   701,    -1,   700,   515,   701,
      -1,    -1,  1068,    -1,  1207,    -1,  1208,    -1,  1190,    -1,
     232,  1058,    -1,    -1,    -1,   703,   704,    -1,   316,   185,
      -1,   185,    -1,   260,   250,    -1,   260,   186,    -1,   316,
     462,    -1,   202,   443,  1060,   330,  1058,   567,    -1,   202,
     443,   248,   216,  1060,   330,  1058,   567,    -1,   163,   110,
    1060,   138,   512,   997,   513,   703,    -1,   202,   110,  1060,
     567,    -1,   163,    98,  1066,   713,   709,    -1,   163,    98,
    1066,   714,    -1,   163,   332,   810,   709,    -1,   163,   448,
     738,   709,    -1,   163,   448,   738,    -1,   163,   448,   738,
     108,   512,   970,   513,    -1,   163,   448,   738,   108,   209,
     512,   717,   513,    -1,   163,   435,   397,   344,   738,   709,
      -1,   163,   435,   397,   192,   738,   709,    -1,   163,   435,
     397,   433,   738,   709,    -1,   163,   435,   397,   153,   738,
     709,    -1,   163,   146,   738,   709,    -1,   163,   146,   738,
     232,   738,    -1,   512,   710,   513,    -1,   711,    -1,   710,
     515,   711,    -1,  1190,   499,   712,    -1,  1190,    -1,   794,
      -1,  1074,    -1,  1024,    -1,   643,    -1,  1208,    -1,   512,
    1029,   513,    -1,   512,   505,   513,    -1,   512,   715,   513,
      -1,   716,    -1,   715,   515,   716,    -1,  1210,   499,   712,
      -1,   718,    -1,    -1,  1208,    -1,   718,   515,  1208,    -1,
     101,   448,   738,    95,   465,  1208,    -1,   101,   448,   738,
      95,   465,  1208,   118,  1208,    -1,   101,   448,   738,    95,
     465,  1208,    97,  1208,    -1,   163,   332,   140,   738,   723,
     227,   448,   973,   460,  1062,   724,   108,   721,    -1,   722,
      -1,   721,   515,   722,    -1,   332,  1068,   810,   725,   726,
      -1,   332,  1068,   810,   809,   725,   726,    -1,   234,  1068,
    1066,   786,    -1,   234,  1068,   512,  1029,   513,  1066,   786,
      -1,   422,   973,    -1,   183,    -1,    -1,   222,   738,    -1,
      -1,   227,   397,    -1,   227,   336,   126,   738,    -1,    -1,
     368,    -1,    -1,   163,   332,   222,   738,   460,  1062,    -1,
     101,   332,   222,   738,   460,  1062,    95,   721,    -1,   101,
     332,   222,   738,   460,  1062,   202,   729,    -1,   730,    -1,
     729,   515,   730,    -1,   332,  1068,   512,  1029,   513,    -1,
     234,  1068,   512,  1029,   513,    -1,   202,   332,   140,   738,
     460,  1062,   567,    -1,   202,   332,   140,   248,   216,   738,
     460,  1062,   567,    -1,   202,   332,   222,   738,   460,  1062,
     567,    -1,   202,   332,   222,   248,   216,   738,   460,  1062,
     567,    -1,   202,   342,   126,  1059,   567,    -1,   367,   342,
     126,  1059,   439,  1060,    -1,   202,   736,   248,   216,   737,
     567,    -1,   202,   736,   737,   567,    -1,   429,    -1,   401,
      -1,   472,    -1,   256,    -1,   229,   429,    -1,   448,    -1,
     200,    -1,   146,    -1,   159,    -1,   395,    -1,   218,    -1,
     435,   397,   344,    -1,   435,   397,   192,    -1,   435,   397,
     433,    -1,   435,   397,   153,    -1,   738,    -1,   737,   515,
     738,    -1,  1188,    -1,  1188,   739,    -1,   514,  1063,    -1,
     739,   514,  1063,    -1,   446,   931,   965,   741,   567,    -1,
     158,   247,    -1,   381,   247,    -1,    -1,   148,   330,   743,
     738,   274,   744,    -1,   148,   330,    98,  1066,   713,   274,
     744,    -1,   148,   330,   234,  1066,   786,   274,   744,    -1,
     148,   330,   332,   810,   809,   274,   744,    -1,   148,   330,
     155,  1060,   330,   738,   274,   744,    -1,   148,   330,   393,
    1060,   330,   738,   274,   744,    -1,   148,   330,   393,  1060,
     274,   744,    -1,   148,   330,   443,  1060,   330,   738,   274,
     744,    -1,   148,   330,   332,   140,   738,   460,  1062,   274,
     744,    -1,   148,   330,   332,   222,   738,   460,  1062,   274,
     744,    -1,   148,   330,   281,   325,   643,   274,   744,    -1,
     148,   330,   132,   512,   973,   108,   973,   513,   274,   744,
      -1,   148,   330,   652,   280,   738,   274,   744,    -1,   148,
     330,   435,   397,   344,   738,   274,   744,    -1,   148,   330,
     435,   397,   192,   738,   274,   744,    -1,   148,   330,   435,
     397,   433,   738,   274,   744,    -1,   148,   330,   435,   397,
     153,   738,   274,   744,    -1,   147,    -1,   177,    -1,   395,
      -1,   256,    -1,   401,    -1,   429,    -1,   200,    -1,   448,
      -1,   472,    -1,   146,    -1,   159,    -1,   431,    -1,   218,
      -1,   388,    -1,   229,   429,    -1,   404,    -1,   229,   176,
     481,    -1,  1208,    -1,   321,    -1,   399,   279,   746,   330,
     747,   738,   274,   748,    -1,   399,   279,   746,   330,    98,
    1066,   713,   274,   748,    -1,   399,   279,   746,   330,   234,
    1066,   786,   274,   748,    -1,   399,   279,   746,   330,   281,
     325,   643,   274,   748,    -1,   399,   279,   746,   330,   652,
     280,   738,   274,   748,    -1,   227,   554,    -1,    -1,   147,
      -1,   229,   429,    -1,   395,    -1,   401,    -1,   429,    -1,
     200,    -1,   448,    -1,   472,    -1,  1208,    -1,   321,    -1,
     223,   750,    -1,   306,   750,    -1,   223,   750,  1222,    -1,
     223,   230,   917,  1223,    -1,   223,   230,   751,   917,  1223,
      -1,   223,   116,   917,  1223,    -1,   223,   116,   751,   917,
    1223,    -1,   306,   230,   917,    -1,   306,   230,   751,   917,
      -1,   306,   116,   917,    -1,   306,   116,   751,   917,    -1,
     917,    -1,   751,   917,    -1,   312,   752,   917,    -1,   359,
     752,   917,    -1,   224,   752,   917,    -1,   282,   752,   917,
      -1,    92,  1070,   752,   917,    -1,   373,  1070,   752,   917,
      -1,  1070,   752,   917,    -1,    99,   752,   917,    -1,   230,
    1070,   752,   917,    -1,   230,    99,   752,   917,    -1,   116,
    1070,   752,   917,    -1,   116,    99,   752,   917,    -1,   232,
      -1,   253,    -1,   751,    -1,    -1,   237,   755,   330,   758,
     439,   759,   761,    -1,   385,   755,   330,   758,   232,   759,
     567,    -1,   385,   237,   333,   227,   755,   330,   758,   232,
     759,   567,    -1,   756,    -1,    99,    -1,    99,   360,    -1,
      99,   512,   613,   513,    -1,    99,   360,   512,   613,   513,
      -1,   757,    -1,   756,   515,   757,    -1,   400,   612,    -1,
     371,   612,    -1,   163,   612,    -1,  1188,   612,    -1,  1057,
      -1,   429,  1057,    -1,   401,  1057,    -1,   229,   176,   481,
    1059,    -1,   229,   404,  1059,    -1,   234,   762,    -1,   177,
    1059,    -1,   280,  1059,    -1,   281,   325,   644,    -1,   395,
    1059,    -1,   431,  1059,    -1,    99,   430,   253,   395,  1059,
      -1,    99,   402,   253,   395,  1059,    -1,    99,   235,   253,
     395,  1059,    -1,   760,    -1,   759,   515,   760,    -1,  1069,
      -1,   240,  1069,    -1,   478,   237,   333,    -1,    -1,   763,
      -1,   762,   515,   763,    -1,  1066,   786,    -1,   237,   756,
     439,  1059,   766,   767,    -1,   385,   756,   232,  1059,   767,
     567,    -1,   385,    96,   333,   227,   756,   232,  1059,   767,
     567,    -1,   478,    96,   333,    -1,    -1,   238,   126,  1069,
      -1,    -1,   101,   183,   360,   769,   771,    -1,   769,   770,
      -1,    -1,   253,   395,  1059,    -1,   227,   388,  1059,    -1,
     227,   459,  1059,    -1,   237,   755,   330,   772,   439,   759,
     761,    -1,   385,   755,   330,   772,   232,   759,   567,    -1,
     385,   237,   333,   227,   755,   330,   772,   232,   759,   567,
      -1,   430,    -1,   235,    -1,   402,    -1,   163,   774,   256,
     775,   776,   330,  1058,   777,   512,   778,   513,   571,   626,
     968,    -1,   453,    -1,    -1,   152,    -1,    -1,  1064,    -1,
      -1,   460,  1062,    -1,    -1,   779,    -1,   778,   515,   779,
      -1,  1188,   780,   781,   782,   783,    -1,  1000,   780,   781,
     782,   783,    -1,   512,   997,   513,   780,   781,   782,   783,
      -1,   145,   738,    -1,    -1,   738,    -1,   460,   738,    -1,
      -1,   109,    -1,   191,    -1,    -1,   496,    -1,   497,    -1,
      -1,   163,   785,   234,  1066,   788,   384,   793,   796,   800,
      -1,   163,   785,   234,  1066,   788,   384,   429,   512,   802,
     513,   796,   800,    -1,   163,   785,   234,  1066,   788,   796,
     800,    -1,   335,   377,    -1,    -1,   512,   787,   513,    -1,
     512,   513,    -1,   790,    -1,   787,   515,   790,    -1,   512,
     789,   513,    -1,   512,   513,    -1,   795,    -1,   789,   515,
     795,    -1,   791,   792,   794,    -1,   792,   791,   794,    -1,
     792,   794,    -1,   791,   794,    -1,   794,    -1,   253,    -1,
     337,    -1,   263,    -1,   253,   337,    -1,   468,    -1,  1189,
      -1,   794,    -1,   973,    -1,  1189,   739,   507,   448,    -1,
     408,  1189,   739,   507,   448,    -1,   790,    -1,   790,   183,
     997,    -1,   790,   499,   997,    -1,   798,    -1,   796,   798,
      -1,   128,   330,   321,   264,    -1,   384,   321,   330,   321,
     264,    -1,   423,    -1,   251,    -1,   415,    -1,   473,    -1,
     219,   399,   187,    -1,   219,   399,   273,    -1,   399,   187,
      -1,   399,   273,    -1,   162,   643,    -1,   392,   643,    -1,
     556,    -1,   108,   799,    -1,   280,   554,    -1,   477,    -1,
     797,    -1,  1208,    -1,  1208,   515,  1208,    -1,   478,   709,
      -1,    -1,   792,   794,    -1,   801,    -1,   802,   515,   801,
      -1,   101,   234,   763,   804,   805,    -1,   797,    -1,   804,
     797,    -1,   382,    -1,    -1,   202,   234,  1066,   786,   567,
      -1,   202,   234,   248,   216,  1066,   786,   567,    -1,   202,
      98,  1066,   713,   567,    -1,   202,    98,   248,   216,  1066,
     713,   567,    -1,   202,   332,   810,   809,   567,    -1,   202,
     332,   248,   216,   810,   809,   567,    -1,   512,   973,   513,
      -1,   512,   973,   515,   973,   513,    -1,   512,   315,   515,
     973,   513,    -1,   512,   973,   515,   315,   513,    -1,  1021,
      -1,  1188,   514,   810,    -1,   198,   812,    -1,   813,    -1,
     812,   813,    -1,  1208,    -1,   280,   554,    -1,   163,   132,
     512,   973,   108,   973,   513,   478,   234,   763,   815,    -1,
     163,   132,   512,   973,   108,   973,   513,   479,   234,   815,
      -1,   163,   132,   512,   973,   108,   973,   513,   478,   263,
     815,    -1,   108,   252,    -1,   108,   111,    -1,    -1,   202,
     132,   817,   512,   973,   108,   973,   513,   567,    -1,   248,
     216,    -1,    -1,   372,   819,  1058,   820,    -1,   372,   428,
    1060,   820,    -1,   372,   177,  1060,   820,    -1,   256,    -1,
     429,    -1,   228,    -1,    -1,   101,    98,  1066,   713,   375,
     439,  1060,    -1,   101,   146,   738,   375,   439,  1060,    -1,
     101,   159,   738,   375,   439,  1060,    -1,   101,   177,  1061,
     375,   439,  1061,    -1,   101,   234,   763,   375,   439,  1060,
      -1,   101,   240,  1069,   375,   439,  1069,    -1,   101,   652,
     280,  1060,   375,   439,  1060,    -1,   101,   332,   140,   738,
     460,  1062,   375,   439,  1060,    -1,   101,   332,   222,   738,
     460,  1062,   375,   439,  1060,    -1,   101,   395,  1060,   375,
     439,  1060,    -1,   101,   429,   964,   375,   439,  1060,    -1,
     101,   401,  1058,   375,   439,  1060,    -1,   101,   472,  1058,
     375,   439,  1060,    -1,   101,   256,  1058,   375,   439,  1060,
      -1,   101,   229,   429,   964,   375,   439,  1060,    -1,   101,
     429,   964,   375,   822,  1060,   439,  1060,    -1,   101,   229,
     429,   964,   375,   822,  1060,   439,  1060,    -1,   101,   443,
    1060,   330,  1058,   375,   439,  1060,    -1,   101,   388,  1069,
     375,   439,  1069,    -1,   101,   459,  1069,   375,   439,  1069,
      -1,   101,   431,  1060,   375,   439,  1060,    -1,   101,   431,
    1060,   407,   570,    -1,   101,   431,  1060,   380,   570,    -1,
     101,   435,   397,   344,   738,   375,   439,  1060,    -1,   101,
     435,   397,   192,   738,   375,   439,  1060,    -1,   101,   435,
     397,   433,   738,   375,   439,  1060,    -1,   101,   435,   397,
     153,   738,   375,   439,  1060,    -1,   101,   448,   738,   375,
     439,  1060,    -1,   101,   448,   738,   375,   114,  1060,   439,
    1060,   567,    -1,   147,    -1,    -1,   407,   176,    -1,    -1,
     101,    98,  1066,   713,   407,   395,  1060,    -1,   101,   146,
     738,   407,   395,  1060,    -1,   101,   159,   738,   407,   395,
    1060,    -1,   101,   200,   738,   407,   395,  1060,    -1,   101,
     218,   738,   407,   395,  1060,    -1,   101,   234,   763,   407,
     395,  1060,    -1,   101,   332,   810,   809,   407,   395,  1060,
      -1,   101,   332,   140,   738,   460,  1062,   407,   395,  1060,
      -1,   101,   332,   222,   738,   460,  1062,   407,   395,  1060,
      -1,   101,   429,   964,   407,   395,  1060,    -1,   101,   435,
     397,   344,   738,   407,   395,  1060,    -1,   101,   435,   397,
     192,   738,   407,   395,  1060,    -1,   101,   435,   397,   433,
     738,   407,   395,  1060,    -1,   101,   435,   397,   153,   738,
     407,   395,  1060,    -1,   101,   401,  1058,   407,   395,  1060,
      -1,   101,   472,  1058,   407,   395,  1060,    -1,   101,   229,
     429,   964,   407,   395,  1060,    -1,   101,   448,   738,   407,
     395,  1060,    -1,   101,    98,  1066,   713,   343,   439,  1069,
      -1,   101,   146,   738,   343,   439,  1069,    -1,   101,   159,
     738,   343,   439,  1069,    -1,   101,   177,  1061,   343,   439,
    1069,    -1,   101,   200,   738,   343,   439,  1069,    -1,   101,
     234,   763,   343,   439,  1069,    -1,   101,   652,   280,  1060,
     343,   439,  1069,    -1,   101,   281,   325,   643,   343,   439,
    1069,    -1,   101,   332,   810,   809,   343,   439,  1069,    -1,
     101,   332,   140,   738,   460,  1062,   343,   439,  1069,    -1,
     101,   332,   222,   738,   460,  1062,   343,   439,  1069,    -1,
     101,   395,  1060,   343,   439,  1069,    -1,   101,   448,   738,
     343,   439,  1069,    -1,   101,   431,  1060,   343,   439,  1069,
      -1,   101,   435,   397,   192,   738,   343,   439,  1069,    -1,
     101,   435,   397,   153,   738,   343,   439,  1069,    -1,   101,
     229,   176,   481,  1060,   343,   439,  1069,    -1,   101,   404,
    1060,   343,   439,  1069,    -1,   163,   785,   393,  1060,   108,
     330,   831,   439,  1058,   968,   198,   832,   827,    -1,   317,
      -1,   829,    -1,   512,   828,   513,    -1,   828,   516,   830,
      -1,   830,    -1,   920,    -1,   898,    -1,   909,    -1,   903,
      -1,   834,    -1,   829,    -1,    -1,   400,    -1,   458,    -1,
     188,    -1,   266,    -1,   267,    -1,   100,    -1,    -1,   202,
     393,  1060,   330,  1058,   567,    -1,   202,   393,   248,   216,
    1060,   330,  1058,   567,    -1,   318,  1188,   835,    -1,   515,
    1208,    -1,    -1,   291,  1188,    -1,   455,  1188,    -1,   455,
     505,    -1,    91,   839,    -1,   119,   839,   842,    -1,   417,
     441,   842,    -1,   150,   839,    -1,   208,   839,    -1,   389,
     839,    -1,   394,  1188,    -1,   374,   394,  1188,    -1,   374,
    1188,    -1,   389,   839,   439,   394,  1188,    -1,   389,   839,
     439,  1188,    -1,   356,   441,  1208,    -1,   150,   357,  1208,
      -1,   389,   357,  1208,    -1,   480,    -1,   441,    -1,    -1,
     276,   288,   550,    -1,   365,   331,    -1,   365,   482,    -1,
     185,    -1,   316,   185,    -1,   840,    -1,   841,   515,   840,
      -1,   841,   840,    -1,   841,    -1,    -1,   163,   594,   472,
    1058,   612,   108,   920,   844,    -1,   163,   335,   377,   594,
     472,  1058,   612,   108,   920,   844,    -1,   478,   138,   333,
      -1,   478,   130,   138,   333,    -1,   478,   293,   138,   333,
      -1,    -1,   292,  1065,    -1,   163,   177,  1061,   524,   847,
      -1,   847,   848,    -1,    -1,   431,   849,  1060,    -1,   431,
     849,   183,    -1,   296,   849,  1208,    -1,   296,   849,   183,
      -1,   433,   849,  1060,    -1,   433,   849,   183,    -1,   206,
     849,  1208,    -1,   206,   849,  1068,    -1,   206,   849,   183,
      -1,   283,   849,  1208,    -1,   283,   849,   183,    -1,   284,
     849,  1208,    -1,   284,   849,   183,    -1,   154,   290,   849,
    1070,    -1,   343,   849,  1060,    -1,   343,   849,   183,    -1,
     499,    -1,    -1,   101,   177,  1061,   524,   852,    -1,   101,
     177,  1061,   407,   431,  1060,    -1,   101,   177,  1061,   556,
      -1,   852,   853,    -1,    -1,   154,   290,   849,  1070,    -1,
     202,   177,  1061,    -1,   202,   177,   248,   216,  1061,    -1,
     163,   200,   738,   857,   973,   603,    -1,   101,   200,   738,
     566,    -1,   101,   200,   738,   202,   316,   321,    -1,   101,
     200,   738,   407,   316,   321,    -1,   101,   200,   738,    95,
     610,    -1,   101,   200,   738,   202,   155,  1060,   567,    -1,
     108,    -1,    -1,   101,   435,   397,   192,   738,   709,    -1,
     101,   435,   397,   153,   738,    95,   298,   227,  1059,   478,
     737,    -1,   101,   435,   397,   153,   738,   101,   298,   227,
    1059,   478,   737,    -1,   101,   435,   397,   153,   738,   101,
     298,   377,   738,   478,   738,    -1,   101,   435,   397,   153,
     738,   101,   298,   227,  1059,   377,   738,   478,   738,    -1,
     101,   435,   397,   153,   738,   202,   298,   227,  1059,    -1,
     101,   435,   397,   153,   738,   202,   298,   248,   216,   227,
    1059,    -1,   163,   723,   159,   738,   227,  1208,   439,  1208,
     232,   738,    -1,   143,   868,  1058,   862,    -1,   143,   868,
      -1,   143,   868,  1064,   330,  1058,    -1,   460,  1064,    -1,
      -1,   461,   869,   870,   868,    -1,   461,   869,   870,   868,
    1058,    -1,   461,   869,   870,   868,   866,    -1,   461,   512,
     864,   513,    -1,   461,   512,   864,   513,  1058,   871,    -1,
     865,    -1,   864,   515,   865,    -1,   867,    -1,   470,    -1,
     231,    -1,   233,    -1,   867,   868,    -1,   867,   868,  1058,
     871,    -1,   104,    -1,   103,    -1,   470,    -1,    -1,   233,
      -1,    -1,   231,    -1,    -1,   512,  1059,   513,    -1,    -1,
     163,   117,   873,    -1,  1208,    -1,    -1,   163,   314,   875,
     624,    -1,  1188,    -1,  1188,    -1,   877,   515,   875,    -1,
     875,    -1,   101,   314,   875,   624,    -1,   202,   314,   875,
      -1,   163,   314,   240,   876,   478,   877,    -1,   202,   314,
     240,   876,    -1,   217,   883,    -1,   217,   867,   868,   883,
      -1,   217,   470,   883,    -1,   217,   512,   884,   513,   883,
      -1,   920,    -1,   898,    -1,   909,    -1,   903,    -1,   916,
      -1,  1077,    -1,   896,    -1,   885,    -1,   884,   515,   885,
      -1,   886,   887,    -1,  1188,    -1,   867,    -1,   470,    -1,
     551,    -1,   643,    -1,    -1,   215,   193,   330,   877,   889,
      -1,  1208,    -1,   141,   154,   439,   160,   877,   891,   892,
      -1,   141,   154,   439,   314,   877,   891,   892,    -1,   141,
     154,   439,    99,   820,   891,   892,    -1,   227,   177,  1061,
      -1,   227,  1061,    -1,    -1,   439,   459,  1069,    -1,   439,
    1069,    -1,    -1,   356,  1096,   894,   108,   895,    -1,   356,
    1096,   232,  1141,    -1,   512,  1029,   513,    -1,    -1,   920,
      -1,   898,    -1,   909,    -1,   903,    -1,   215,  1096,   897,
    1220,    -1,   163,   594,   429,   632,   108,   215,  1096,   897,
      -1,   512,  1026,   513,    -1,    -1,   928,   266,   272,  1058,
     899,   902,    -1,   920,    -1,   512,   900,   513,   920,    -1,
     183,   466,    -1,   901,    -1,   900,   515,   901,    -1,  1188,
    1050,    -1,   383,  1055,  1221,    -1,    -1,   928,   188,   232,
     966,   904,   969,   902,    -1,   460,   957,    -1,    -1,   297,
     931,   965,   906,   908,    -1,   253,   907,   303,    -1,    -1,
      93,   409,    -1,   391,   409,    -1,   391,   214,    -1,   409,
     458,   214,    -1,   409,    -1,   409,   391,   214,    -1,   214,
      -1,    93,   214,    -1,   320,    -1,    -1,   928,   458,   966,
     407,   910,   956,   969,   902,    -1,   911,    -1,   910,   515,
     911,    -1,   912,    -1,   913,    -1,   914,   499,  1052,    -1,
     512,   915,   513,   499,  1054,    -1,  1188,  1050,    -1,   914,
      -1,   915,   515,   914,    -1,   182,   917,   918,   174,   919,
     227,   920,    -1,  1060,    -1,  1201,    -1,    -1,   918,   313,
     396,    -1,   918,   396,    -1,   918,   122,    -1,   918,   265,
      -1,    -1,   478,   245,    -1,   479,   245,    -1,   922,    -1,
     921,    -1,   512,   922,   513,    -1,   512,   921,   513,    -1,
     924,    -1,   923,   935,    -1,   923,   934,   950,   939,    -1,
     923,   934,   938,   951,    -1,   925,   923,    -1,   925,   923,
     935,    -1,   925,   923,   934,   950,   939,    -1,   925,   923,
     934,   938,   951,    -1,   924,    -1,   921,    -1,   400,   933,
    1055,   929,   956,   968,   948,   949,  1009,    -1,   955,    -1,
     429,   964,    -1,   923,   452,   932,   923,    -1,   923,   270,
     932,   923,    -1,   923,   211,   932,   923,    -1,   478,   926,
      -1,   478,   369,   926,    -1,   927,    -1,   926,   515,   927,
      -1,  1060,   871,   108,   512,   895,   513,    -1,   925,    -1,
      -1,   272,   930,    -1,  1221,    -1,    -1,   434,   931,  1058,
      -1,   432,   931,  1058,    -1,   293,   434,   931,  1058,    -1,
     293,   432,   931,  1058,    -1,   236,   434,   931,  1058,    -1,
     236,   432,   931,  1058,    -1,   456,   931,  1058,    -1,   429,
    1058,    -1,  1058,    -1,   429,    -1,    -1,    99,    -1,   196,
      -1,    -1,   196,    -1,   196,   330,   512,  1026,   513,    -1,
      99,    -1,    -1,   935,    -1,    -1,   336,   126,   936,    -1,
     937,    -1,   936,   515,   937,    -1,   997,   460,  1024,   783,
      -1,   997,   782,   783,    -1,   940,   941,    -1,   941,   940,
      -1,   940,    -1,   941,    -1,   938,    -1,    -1,   290,   942,
      -1,   290,   942,   515,   943,    -1,   223,   947,   944,   946,
     331,    -1,   328,   943,    -1,   328,   945,   946,    -1,   997,
      -1,    99,    -1,   997,    -1,  1070,    -1,   512,   997,   513,
      -1,    -1,   999,    -1,   391,    -1,   392,    -1,   224,    -1,
     312,    -1,   240,   126,  1026,    -1,    -1,   243,   997,    -1,
      -1,   952,    -1,   227,   365,   331,    -1,   950,    -1,    -1,
     953,    -1,   952,   953,    -1,   227,   458,   954,   908,    -1,
     227,   409,   954,   908,    -1,   326,  1057,    -1,    -1,   466,
    1054,    -1,   955,   515,  1054,    -1,   232,   957,    -1,    -1,
     958,    -1,   957,   515,   958,    -1,   964,    -1,   964,   960,
      -1,   967,    -1,   967,   960,    -1,   967,   108,   512,   971,
     513,    -1,   967,   108,  1188,   512,   971,   513,    -1,   967,
    1188,   512,   971,   513,    -1,   921,    -1,   921,   960,    -1,
     959,    -1,   512,   959,   513,   960,    -1,   512,   959,   513,
      -1,   958,   164,   277,   958,    -1,   958,   961,   277,   958,
     963,    -1,   958,   277,   958,   963,    -1,   958,   310,   961,
     277,   958,    -1,   958,   310,   277,   958,    -1,   108,  1188,
     512,  1059,   513,    -1,   108,  1188,    -1,  1188,   512,  1059,
     513,    -1,  1188,    -1,   233,   962,    -1,   287,   962,    -1,
     386,   962,    -1,   262,    -1,   338,    -1,    -1,   460,   512,
    1059,   513,    -1,   330,   997,    -1,  1058,    -1,  1058,   505,
      -1,   331,  1058,    -1,   331,   512,  1058,   513,    -1,   964,
      -1,   965,   515,   964,    -1,   964,    -1,   964,  1188,    -1,
     964,   108,  1188,    -1,  1000,    -1,   475,   997,    -1,    -1,
     475,   997,    -1,   475,   166,   326,   917,    -1,    -1,   971,
      -1,    -1,   972,    -1,   971,   515,   972,    -1,  1188,   973,
     568,    -1,   975,   974,    -1,   408,   975,   974,    -1,   975,
     107,   510,  1068,   511,    -1,   408,   975,   107,   510,  1068,
     511,    -1,   975,   107,    -1,   408,   975,   107,    -1,   974,
     510,   511,    -1,   974,   510,  1219,   511,    -1,    -1,   977,
      -1,   979,    -1,   981,    -1,   985,    -1,   992,    -1,   993,
     995,    -1,   993,   512,  1068,   513,   995,    -1,   979,    -1,
     982,    -1,   986,    -1,   992,    -1,  1189,   978,    -1,  1189,
     739,   978,    -1,   512,  1026,   513,    -1,    -1,   268,    -1,
     269,    -1,   413,    -1,   121,    -1,   366,    -1,   225,   980,
      -1,   201,   353,    -1,   181,   978,    -1,   180,   978,    -1,
     324,   978,    -1,   124,    -1,   512,  1068,   513,    -1,    -1,
     983,    -1,   984,    -1,   983,    -1,   984,    -1,   123,   990,
     512,  1026,   513,    -1,   123,   990,    -1,   987,    -1,   988,
      -1,   987,    -1,   988,    -1,   989,   512,  1068,   513,   991,
      -1,   989,   991,    -1,   136,   990,    -1,   135,   990,    -1,
     467,    -1,   309,   136,   990,    -1,   309,   135,   990,    -1,
     311,   990,    -1,   469,    -1,    -1,   136,   407,  1188,    -1,
      -1,   438,   512,  1068,   513,   994,    -1,   438,   994,    -1,
     437,   512,  1068,   513,   994,    -1,   437,   994,    -1,   271,
      -1,   498,   495,    -1,   479,   437,   495,    -1,    -1,   493,
      -1,   305,    -1,   178,    -1,   246,    -1,   301,    -1,   996,
      -1,   493,   439,   305,    -1,   178,   439,   246,    -1,   178,
     439,   301,    -1,   178,   439,   996,    -1,   246,   439,   301,
      -1,   246,   439,   996,    -1,   301,   439,   996,    -1,    -1,
     398,    -1,   398,   512,  1068,   513,    -1,   999,    -1,   997,
      88,   973,    -1,   997,   145,   738,    -1,   997,   113,   437,
     495,   997,    -1,   503,   997,    -1,   504,   997,    -1,   997,
     503,   997,    -1,   997,   504,   997,    -1,   997,   505,   997,
      -1,   997,   506,   997,    -1,   997,   507,   997,    -1,   997,
     508,   997,    -1,   997,   500,   997,    -1,   997,   501,   997,
      -1,   997,   499,   997,    -1,   997,  1023,   997,    -1,  1023,
     997,    -1,   997,  1023,    -1,   997,   105,   997,    -1,   997,
     335,   997,    -1,   316,   997,    -1,   997,   289,   997,    -1,
     997,   289,   997,   210,   997,    -1,   997,   316,   289,   997,
      -1,   997,   316,   289,   997,   210,   997,    -1,   997,   249,
     997,    -1,   997,   249,   997,   210,   997,    -1,   997,   316,
     249,   997,    -1,   997,   316,   249,   997,   210,   997,    -1,
     997,   411,   439,   997,    -1,   997,   411,   439,   997,   210,
     997,    -1,   997,   316,   411,   439,   997,    -1,   997,   316,
     411,   439,   997,   210,   997,    -1,   997,   274,   321,    -1,
     997,   275,    -1,   997,   274,   316,   321,    -1,   997,   319,
      -1,  1019,   340,  1019,    -1,   997,   274,   445,    -1,   997,
     274,   316,   445,    -1,   997,   274,   221,    -1,   997,   274,
     316,   221,    -1,   997,   274,   454,    -1,   997,   274,   316,
     454,    -1,   997,   274,   196,   232,   997,    -1,   997,   274,
     316,   196,   232,   997,    -1,   997,   274,   326,   512,  1029,
     513,    -1,   997,   274,   316,   326,   512,  1029,   513,    -1,
     997,   120,  1051,   998,   105,   998,    -1,   997,   316,   120,
    1051,   998,   105,   998,    -1,   997,   120,   426,   998,   105,
     998,    -1,   997,   316,   120,   426,   998,   105,   998,    -1,
     997,   253,  1041,    -1,   997,   316,   253,  1041,    -1,   997,
    1025,  1020,   921,    -1,   997,  1025,  1020,   512,   997,   513,
      -1,   453,   921,    -1,   997,   274,   199,    -1,   997,   274,
     316,   199,    -1,   999,    -1,   998,    88,   973,    -1,   503,
     998,    -1,   504,   998,    -1,   998,   503,   998,    -1,   998,
     504,   998,    -1,   998,   505,   998,    -1,   998,   506,   998,
      -1,   998,   507,   998,    -1,   998,   508,   998,    -1,   998,
     500,   998,    -1,   998,   501,   998,    -1,   998,   499,   998,
      -1,   998,  1023,   998,    -1,  1023,   998,    -1,   998,  1023,
      -1,   998,   274,   196,   232,   998,    -1,   998,   274,   316,
     196,   232,   998,    -1,   998,   274,   326,   512,  1029,   513,
      -1,   998,   274,   316,   326,   512,  1029,   513,    -1,   998,
     274,   199,    -1,   998,   274,   316,   199,    -1,  1047,    -1,
    1067,    -1,  1205,  1050,    -1,   512,   997,   513,  1050,    -1,
    1042,    -1,  1000,    -1,   921,    -1,   216,   921,    -1,   107,
     921,    -1,   107,  1030,    -1,  1019,    -1,  1066,   512,   513,
    1012,    -1,  1066,   512,  1027,   513,  1012,    -1,  1066,   512,
     468,  1028,   513,  1012,    -1,  1066,   512,  1027,   515,   468,
    1028,   513,  1012,    -1,  1066,   512,  1027,   935,   513,  1012,
      -1,  1066,   512,    99,  1027,   934,   513,  1012,    -1,  1066,
     512,   196,  1027,   934,   513,  1012,    -1,  1066,   512,   505,
     513,  1012,    -1,   168,    -1,   171,    -1,   171,   512,  1068,
     513,    -1,   172,    -1,   172,   512,  1068,   513,    -1,   294,
      -1,   294,   512,  1068,   513,    -1,   295,    -1,   295,   512,
    1068,   513,    -1,   169,    -1,   173,    -1,   406,    -1,   459,
      -1,   167,    -1,   170,    -1,   132,   512,   997,   108,   973,
     513,    -1,   220,   512,  1032,   513,    -1,   341,   512,  1034,
     513,    -1,   351,   512,  1036,   513,    -1,   425,   512,  1037,
     513,    -1,   442,   512,   997,   108,   973,   513,    -1,   444,
     512,   125,  1040,   513,    -1,   444,   512,   285,  1040,   513,
      -1,   444,   512,   440,  1040,   513,    -1,   444,   512,  1040,
     513,    -1,   322,   512,   997,   515,   997,   513,    -1,   144,
     512,  1026,   513,    -1,   239,   512,  1026,   513,    -1,   286,
     512,  1026,   513,    -1,   485,   512,  1026,   513,    -1,   486,
     512,   307,  1190,   513,    -1,   486,   512,   307,  1190,   515,
    1003,   513,    -1,   486,   512,   307,  1190,   515,  1026,   513,
      -1,   486,   512,   307,  1190,   515,  1003,   515,  1026,   513,
      -1,   487,   512,   999,  1008,   513,    -1,   488,   512,  1004,
     513,    -1,   489,   512,  1006,   997,  1007,   513,    -1,   490,
     512,   307,  1190,   513,    -1,   490,   512,   307,  1190,   515,
     997,   513,    -1,   491,   512,   997,   515,  1001,  1002,   513,
      -1,   492,   512,  1006,   997,   108,   975,   513,    -1,   471,
     997,    -1,   471,   313,   465,    -1,   515,   416,   494,    -1,
     515,   416,   313,    -1,   515,   416,   313,   465,    -1,    -1,
     484,   512,  1004,   513,    -1,  1005,    -1,  1004,   515,  1005,
      -1,   997,   108,  1190,    -1,   997,    -1,   199,    -1,   157,
      -1,   355,   476,    -1,   424,   476,    -1,    -1,   347,   999,
      -1,   347,   999,   126,   370,    -1,   347,   126,   370,   999,
      -1,   347,   126,   370,   999,   126,   370,    -1,   477,  1010,
      -1,    -1,  1011,    -1,  1010,   515,  1011,    -1,  1188,   108,
    1013,    -1,   339,  1013,    -1,   339,  1188,    -1,    -1,   512,
    1014,  1015,   934,  1016,   513,    -1,  1188,    -1,    -1,   346,
     126,  1026,    -1,    -1,   364,  1017,    -1,   392,  1017,    -1,
      -1,  1018,    -1,   120,  1018,   105,  1018,    -1,   449,   352,
      -1,   449,   226,    -1,   166,   391,    -1,   997,   352,    -1,
     997,   226,    -1,   391,   512,  1026,   513,    -1,   391,   512,
     513,    -1,   512,  1026,   515,   997,   513,    -1,   106,    -1,
     414,    -1,    99,    -1,    85,    -1,  1022,    -1,   503,    -1,
     504,    -1,   505,    -1,   506,    -1,   507,    -1,   508,    -1,
     500,    -1,   501,    -1,   499,    -1,    85,    -1,   332,   512,
     810,   513,    -1,  1021,    -1,   332,   512,   810,   513,    -1,
    1021,    -1,   332,   512,   810,   513,    -1,   289,    -1,   316,
     289,    -1,   249,    -1,   316,   249,    -1,   997,    -1,  1026,
     515,   997,    -1,  1028,    -1,  1027,   515,  1028,    -1,   997,
      -1,   792,    90,   997,    -1,   973,    -1,  1029,   515,   973,
      -1,   510,  1026,   511,    -1,   510,  1031,   511,    -1,   510,
     511,    -1,  1030,    -1,  1031,   515,  1030,    -1,  1033,   232,
     997,    -1,    -1,  1210,    -1,   493,    -1,   305,    -1,   178,
      -1,   246,    -1,   301,    -1,   398,    -1,  1208,    -1,   997,
    1035,  1038,  1039,    -1,   997,  1035,  1038,    -1,   349,   997,
      -1,   998,   253,   998,    -1,    -1,   997,  1038,  1039,    -1,
     997,  1039,  1038,    -1,   997,  1038,    -1,   997,  1039,    -1,
    1026,    -1,    -1,   232,   997,    -1,   227,   997,    -1,   997,
     232,  1026,    -1,   232,  1026,    -1,  1026,    -1,   921,    -1,
     512,  1026,   513,    -1,   131,  1046,  1043,  1045,   208,    -1,
    1044,    -1,  1043,  1044,    -1,   474,   997,   436,   997,    -1,
     204,   997,    -1,    -1,   997,    -1,    -1,  1188,    -1,  1188,
    1049,    -1,   514,  1063,    -1,   514,   505,    -1,   510,   997,
     511,    -1,   510,   997,   517,   997,   511,    -1,  1048,    -1,
    1049,  1048,    -1,    -1,  1050,  1048,    -1,   112,    -1,    -1,
     997,    -1,   183,    -1,  1052,    -1,  1053,   515,  1052,    -1,
     512,  1053,   513,    -1,  1056,    -1,  1055,   515,  1056,    -1,
     997,   108,  1190,    -1,   997,  1210,    -1,   997,    -1,   505,
      -1,  1058,    -1,  1057,   515,  1058,    -1,  1188,    -1,  1188,
    1049,    -1,  1060,    -1,  1059,   515,  1060,    -1,  1188,    -1,
    1188,    -1,  1188,    -1,  1190,    -1,  1188,    -1,  1208,    -1,
    1189,    -1,  1188,  1049,    -1,  1068,    -1,  1207,    -1,  1208,
      -1,  1206,    -1,    84,    -1,  1066,  1208,    -1,  1066,   512,
    1027,   513,  1208,    -1,   976,  1208,    -1,   993,  1208,   995,
      -1,   993,   512,  1068,   513,  1208,   995,    -1,   445,    -1,
     221,    -1,   321,    -1,  1202,    -1,  1200,    -1,    86,    -1,
    1188,    -1,  1068,    -1,  1202,    -1,   503,  1068,    -1,   504,
    1068,    -1,    91,    -1,    92,    -1,    93,    -1,    94,    -1,
      95,    -1,    96,    -1,    97,    -1,    98,    -1,   100,    -1,
     101,    -1,   102,    -1,   110,    -1,   111,    -1,   113,    -1,
     114,    -1,   116,    -1,   117,    -1,   118,    -1,   119,    -1,
     126,    -1,   127,    -1,   128,    -1,   129,    -1,   130,    -1,
     133,    -1,   134,    -1,   137,    -1,   139,    -1,   140,    -1,
     141,    -1,   142,    -1,   143,    -1,   146,    -1,   148,    -1,
     149,    -1,   150,    -1,   151,    -1,   153,    -1,   156,    -1,
     157,    -1,   158,    -1,   159,    -1,   160,    -1,   161,    -1,
     162,    -1,   165,    -1,   174,    -1,   175,    -1,   176,    -1,
     177,    -1,   179,    -1,   182,    -1,   184,    -1,   186,    -1,
     187,    -1,   188,    -1,   189,    -1,   190,    -1,   192,    -1,
     193,    -1,   194,    -1,   195,    -1,   197,    -1,   199,    -1,
     200,    -1,   201,    -1,   202,    -1,   203,    -1,   205,    -1,
     206,    -1,   207,    -1,   209,    -1,   210,    -1,   212,    -1,
     213,    -1,   214,    -1,   215,    -1,   217,    -1,   218,    -1,
     219,    -1,   222,    -1,   224,    -1,   226,    -1,   228,    -1,
     230,    -1,   234,    -1,   235,    -1,   236,    -1,   238,    -1,
     241,    -1,   242,    -1,   244,    -1,   245,    -1,   247,    -1,
     248,    -1,   250,    -1,   251,    -1,   252,    -1,   254,    -1,
     255,    -1,   256,    -1,   257,    -1,   258,    -1,   259,    -1,
     261,    -1,   265,    -1,   266,    -1,   267,    -1,   273,    -1,
     276,    -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,
     282,    -1,   283,    -1,   284,    -1,   288,    -1,   291,    -1,
     292,    -1,   293,    -1,   296,    -1,   297,    -1,   298,    -1,
     299,    -1,   300,    -1,   302,    -1,   303,    -1,   304,    -1,
     306,    -1,   307,    -1,   308,    -1,   312,    -1,   313,    -1,
     314,    -1,   317,    -1,   318,    -1,   320,    -1,   323,    -1,
     325,    -1,   326,    -1,   327,    -1,   329,    -1,   332,    -1,
     333,    -1,   334,    -1,   342,    -1,   343,    -1,   344,    -1,
     345,    -1,   346,    -1,   347,    -1,   348,    -1,   350,    -1,
     352,    -1,   354,    -1,   356,    -1,   357,    -1,   355,    -1,
     359,    -1,   360,    -1,   361,    -1,   362,    -1,   363,    -1,
     364,    -1,   365,    -1,   367,    -1,   368,    -1,   369,    -1,
     370,    -1,   372,    -1,   373,    -1,   374,    -1,   375,    -1,
     376,    -1,   377,    -1,   378,    -1,   379,    -1,   380,    -1,
     381,    -1,   382,    -1,   384,    -1,   385,    -1,   387,    -1,
     388,    -1,   389,    -1,   390,    -1,   392,    -1,   393,    -1,
     394,    -1,   395,    -1,   396,    -1,   397,    -1,   399,    -1,
     401,    -1,   402,    -1,   403,    -1,   404,    -1,   405,    -1,
     407,    -1,   409,    -1,   410,    -1,   412,    -1,   415,    -1,
     416,    -1,   417,    -1,   418,    -1,   419,    -1,   420,    -1,
     421,    -1,   422,    -1,   423,    -1,   424,    -1,   427,    -1,
     428,    -1,   430,    -1,   431,    -1,   432,    -1,   433,    -1,
     434,    -1,   435,    -1,   441,    -1,   443,    -1,   446,    -1,
     447,    -1,   448,    -1,   449,    -1,   450,    -1,   451,    -1,
     454,    -1,   455,    -1,   456,    -1,   457,    -1,   458,    -1,
     461,    -1,   462,    -1,   463,    -1,   464,    -1,   465,    -1,
     469,    -1,   471,    -1,   472,    -1,   473,    -1,   476,    -1,
     479,    -1,   480,    -1,   481,    -1,   482,    -1,   483,    -1,
     494,    -1,   495,    -1,   120,    -1,   121,    -1,   123,    -1,
     124,    -1,   136,    -1,   144,    -1,   180,    -1,   181,    -1,
     216,    -1,   220,    -1,   225,    -1,   239,    -1,   263,    -1,
     269,    -1,   271,    -1,   286,    -1,   309,    -1,   311,    -1,
     315,    -1,   322,    -1,   324,    -1,   337,    -1,   341,    -1,
     351,    -1,   353,    -1,   366,    -1,   391,    -1,   408,    -1,
     413,    -1,   425,    -1,   437,    -1,   438,    -1,   442,    -1,
     444,    -1,   467,    -1,   484,    -1,   485,    -1,   486,    -1,
     487,    -1,   488,    -1,   489,    -1,   490,    -1,   491,    -1,
     492,    -1,   115,    -1,   122,    -1,   152,    -1,   164,    -1,
     170,    -1,   231,    -1,   233,    -1,   249,    -1,   262,    -1,
     274,    -1,   275,    -1,   277,    -1,   287,    -1,   289,    -1,
     310,    -1,   319,    -1,   338,    -1,   339,    -1,   340,    -1,
     386,    -1,   411,    -1,   470,    -1,    99,    -1,   103,    -1,
     104,    -1,   105,    -1,   106,    -1,   107,    -1,   108,    -1,
     109,    -1,   112,    -1,   125,    -1,   131,    -1,   132,    -1,
     138,    -1,   145,    -1,   147,    -1,   155,    -1,   163,    -1,
     167,    -1,   168,    -1,   169,    -1,   171,    -1,   172,    -1,
     173,    -1,   183,    -1,   185,    -1,   191,    -1,   196,    -1,
     198,    -1,   204,    -1,   208,    -1,   211,    -1,   221,    -1,
     223,    -1,   227,    -1,   229,    -1,   232,    -1,   237,    -1,
     240,    -1,   243,    -1,   253,    -1,   260,    -1,   270,    -1,
     272,    -1,   285,    -1,   290,    -1,   294,    -1,   295,    -1,
     316,    -1,   321,    -1,   328,    -1,   330,    -1,   331,    -1,
     335,    -1,   336,    -1,   349,    -1,   358,    -1,   371,    -1,
     383,    -1,   400,    -1,   406,    -1,   414,    -1,   426,    -1,
     429,    -1,   436,    -1,   440,    -1,   445,    -1,   453,    -1,
     459,    -1,   460,    -1,   468,    -1,   474,    -1,   475,    -1,
     477,    -1,   478,    -1,    -1,  1075,  1076,    -1,  1197,  1079,
     522,   516,    -1,  1197,   522,   516,    -1,  1197,  1099,    -1,
    1104,    -1,  1216,    -1,    73,    -1,   518,    -1,   519,    -1,
      -1,   163,   594,   429,   632,   108,  1078,   920,   636,    -1,
     113,  1140,    -1,     9,   439,  1081,  1088,  1089,    -1,     9,
     439,   183,    -1,     9,  1090,    -1,   177,  1081,    -1,  1082,
    1085,  1087,    -1,  1083,   517,  1084,  1087,   506,  1082,  1093,
      -1,  1092,    -1,  1208,    -1,  1061,    -1,    -1,  1210,  1204,
      -1,    85,  1086,    -1,  1084,    -1,    -1,  1188,    -1,  1188,
     514,  1086,    -1,    74,    -1,   517,  1068,    -1,    -1,   108,
    1140,    -1,    -1,   459,  1090,    -1,    -1,  1091,    -1,  1091,
     506,  1091,    -1,  1091,    21,   126,  1091,    -1,  1091,   460,
    1091,    -1,  1069,    -1,  1208,    -1,  1202,    -1,  1204,    -1,
      85,  1094,    -1,    -1,  1188,  1095,    -1,  1188,  1095,    85,
    1094,    -1,    -1,   499,  1068,    -1,   499,  1210,    -1,   499,
    1202,    -1,  1060,    -1,  1092,    -1,   182,   917,   918,   174,
     919,   227,  1096,    -1,   215,   250,  1141,    -1,  1100,    -1,
    1111,    -1,  1113,    -1,   643,    -1,   515,   643,    -1,    -1,
     995,    -1,   493,   439,   301,    -1,   493,   439,   398,    -1,
     178,   439,   178,    -1,   305,   439,   305,    -1,    -1,  1106,
    1105,  1108,  1107,    -1,  1197,   119,   182,    34,   516,    -1,
    1197,   208,   182,    34,   516,    -1,    -1,  1109,    -1,  1100,
      -1,    73,    -1,  1109,  1100,    -1,  1109,    73,    -1,  1113,
      -1,  1110,  1113,    -1,    -1,    70,  1112,  1120,  1136,  1192,
     974,   516,    -1,    -1,  1117,  1120,  1114,  1133,   516,    -1,
      -1,  1120,  1115,  1133,   516,    -1,  1123,   516,    -1,   517,
    1068,    -1,    -1,  1118,  1119,    -1,  1118,    -1,  1119,    -1,
      56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,
      69,    -1,  1129,    -1,  1125,    -1,  1121,    -1,  1192,   512,
    1101,  1102,   513,    -1,  1192,  1103,    -1,  1127,    -1,   209,
    1186,  1122,    -1,   209,  1122,    -1,   209,  1186,    -1,   518,
    1214,   519,    -1,    -1,  1127,  1124,   518,  1110,   519,    -1,
    1123,    -1,    -1,  1128,  1126,   518,  1110,   519,    -1,    43,
    1186,    -1,   452,  1186,    -1,    43,    -1,   452,    -1,  1130,
      -1,  1132,  1131,    -1,    44,    35,    -1,    44,    35,   268,
      -1,    44,    -1,    44,   268,    -1,    44,    25,    -1,    44,
      25,   268,    -1,    44,    25,    25,    -1,    44,    25,    25,
     268,    -1,    44,   135,    -1,    35,    -1,    35,   268,    -1,
     268,    -1,    25,    -1,    25,   268,    -1,    25,    25,    -1,
      25,    25,   268,    -1,     5,    -1,   135,    -1,   201,    -1,
      36,    -1,    -1,  1134,    -1,  1133,   515,  1134,    -1,  1136,
    1191,   974,  1116,  1135,    -1,    -1,   499,  1215,    -1,    -1,
     505,    -1,   505,   505,    -1,   182,   418,  1210,    -1,    15,
    1139,    -1,  1140,    -1,   166,    -1,    99,    -1,    -1,  1061,
      -1,   183,    -1,  1092,    -1,  1092,    -1,    71,    -1,    17,
     917,    -1,    17,    99,    -1,    28,   917,  1144,    -1,    -1,
    1145,    -1,   460,  1149,    -1,  1146,    -1,   460,    37,    14,
    1211,    -1,   460,    14,  1060,    -1,   272,    37,    14,  1211,
      -1,   272,    14,  1060,    -1,   272,  1060,    -1,  1150,    -1,
    1150,   515,  1149,    -1,  1151,    -1,  1202,    -1,  1200,    -1,
    1068,    -1,   503,  1068,    -1,   504,  1068,    -1,  1207,    -1,
     503,  1207,    -1,   504,  1207,    -1,  1208,    -1,  1206,    -1,
    1209,    -1,    13,   264,  1096,  1146,    -1,    13,  1153,  1096,
    1146,    -1,    13,  1153,  1096,  1147,    -1,    13,   264,  1096,
    1148,    -1,    13,  1153,  1096,  1148,    -1,    29,    -1,    -1,
       3,    14,  1211,    -1,   179,    14,  1211,    -1,    18,    14,
    1211,  1157,    -1,  1158,    -1,  1157,   515,  1158,    -1,  1204,
     499,  1163,    -1,   407,    14,  1211,  1160,    -1,  1161,    -1,
    1160,   515,  1161,    -1,  1163,   499,  1162,    -1,  1068,    -1,
    1204,    -1,    10,    -1,    18,    14,  1211,   465,  1162,  1165,
      -1,  1166,    -1,  1165,   515,  1166,    -1,  1204,   499,  1171,
      -1,   407,    14,  1211,   465,  1162,  1168,    -1,  1169,    -1,
    1168,   515,  1169,    -1,  1171,   499,  1170,    -1,  1207,    -1,
    1162,    -1,   504,  1207,    -1,   504,  1068,    -1,  1208,    -1,
       8,    -1,   176,    -1,    11,    -1,    12,    -1,    22,    -1,
      23,    -1,    24,    -1,   307,    -1,    26,    -1,    27,    -1,
     353,    -1,    31,    -1,    32,    -1,    33,    -1,   448,    -1,
     407,     4,   499,  1173,    -1,   407,     4,   439,  1173,    -1,
     330,    -1,   327,    -1,   407,   154,   439,  1140,    -1,   407,
     154,   499,  1140,    -1,   407,   154,  1140,    -1,    -1,   448,
    1176,  1192,   274,  1120,   974,  1177,    -1,    30,    -1,    -1,
      -1,    45,  1179,  1190,   274,  1120,   974,  1177,    -1,    46,
      38,  1181,    -1,    46,   316,    16,  1181,    -1,    46,    40,
    1181,    -1,   158,    -1,    39,    -1,    42,    -1,    20,  1060,
      -1,    19,   439,  1060,    -1,   198,  1060,   512,  1198,   513,
      -1,   198,     6,    -1,     7,  1060,   512,  1198,   513,    -1,
       7,  1060,    -1,  1183,    -1,  1184,    -1,     6,    -1,     7,
      -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,    16,
      -1,    19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,
      -1,    24,    -1,    26,    -1,    27,    -1,    31,    -1,    32,
      -1,    33,    -1,    34,    -1,    37,    -1,    38,    -1,    39,
      -1,    40,    -1,    42,    -1,     9,    -1,    13,    -1,    15,
      -1,    28,    -1,    45,    -1,    46,    -1,     5,    -1,    25,
      -1,    29,    -1,    35,    -1,    43,    -1,    36,    -1,    44,
      -1,  1190,    -1,  1210,    -1,  1071,    -1,  1072,    -1,  1195,
      -1,  1182,    -1,  1193,    -1,   135,    -1,   466,    -1,  1210,
      -1,  1194,    -1,  1072,    -1,  1182,    -1,  1193,    -1,   135,
      -1,   466,    -1,  1210,    -1,  1194,    -1,  1073,    -1,  1182,
      -1,  1193,    -1,  1185,    -1,  1191,    -1,  1185,    -1,   135,
      -1,   166,    -1,   264,    -1,   268,    -1,   439,    -1,   452,
      -1,   466,    -1,  1193,    -1,  1195,    -1,  1192,    -1,  1071,
      -1,  1074,    -1,  1184,    -1,   154,    -1,  1210,    -1,  1072,
      -1,  1073,    -1,  1183,    -1,    50,    -1,    51,    -1,    56,
      -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,  1071,
      -1,  1195,    -1,   154,    -1,   178,    -1,   246,    -1,   301,
      -1,   305,    -1,   398,    -1,   493,    -1,  1199,    -1,  1196,
     515,  1199,    -1,    41,    -1,    -1,  1214,    -1,  1204,  1203,
      -1,  1204,    -1,  1204,  1203,    -1,  1092,    -1,  1204,    -1,
    1204,    -1,    22,  1204,    -1,    22,  1060,    -1,    72,    -1,
      87,    -1,    83,    -1,    81,    -1,    82,    -1,    76,    -1,
      77,    -1,    78,    -1,    75,    -1,    84,    -1,    80,    -1,
      71,    -1,    79,    -1,  1060,    -1,  1092,    -1,  1217,    -1,
     512,   513,    -1,   512,  1213,   513,    -1,  1212,    -1,  1213,
    1212,    -1,  1215,    -1,  1214,   515,  1215,    -1,  1213,    -1,
     518,  1214,   519,    -1,  1217,    -1,   512,    -1,   513,    -1,
     515,    -1,   516,    -1,  1210,    -1,  1068,    -1,  1207,    -1,
    1208,    -1,   505,    -1,   503,    -1,   504,    -1,   506,    -1,
     507,    -1,   321,    -1,    47,    -1,    48,    -1,    49,    -1,
      50,    -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,
      55,    -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,
      59,    -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,
      65,    -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,
      69,    -1,     5,    -1,   209,    -1,   246,    -1,   268,    -1,
      25,    -1,   301,    -1,   305,    -1,   398,    -1,    35,    -1,
      36,    -1,    43,    -1,    44,    -1,   493,    -1,   135,    -1,
     225,    -1,   439,    -1,   452,    -1,   467,    -1,   510,    -1,
     511,    -1,   499,    -1,   517,    -1,   179,  1096,    -1,   179,
     356,  1096,    -1,   179,    99,    -1,   179,   356,    99,    -1,
    1068,    -1,   512,  1219,   513,    -1,  1219,   503,  1219,    -1,
    1219,   504,  1219,    -1,  1219,   505,  1219,    -1,  1219,   506,
    1219,    -1,  1219,   507,  1219,    -1,  1208,    -1,  1188,    -1,
      -1,  1145,  1221,    -1,  1221,  1145,    -1,  1145,    -1,  1221,
      -1,   272,  1196,    -1,  1147,    -1,  1221,    -1,  1146,    -1,
      -1,  1222,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1393,  1393,  1396,  1398,  1400,  1402,  1404,  1406,  1408,
    1410,  1412,  1414,  1416,  1418,  1420,  1422,  1424,  1426,  1428,
    1430,  1432,  1434,  1436,  1438,  1440,  1442,  1444,  1446,  1448,
    1450,  1452,  1454,  1472,  1474,  1476,  1478,  1480,  1482,  1484,
    1486,  1488,  1490,  1492,  1494,  1496,  1498,  1500,  1502,  1504,
    1506,  1508,  1510,  1512,  1514,  1516,  1518,  1520,  1522,  1524,
    1526,  1528,  1530,  1532,  1536,  1538,  1540,  1542,  1544,  1546,
    1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,
    1568,  1570,  1572,  1574,  1576,  1578,  1580,  1582,  1584,  1586,
    1588,  1590,  1592,  1594,  1596,  1598,  1600,  1602,  1604,  1606,
    1608,  1615,  1617,  1619,  1621,  1623,  1625,  1627,  1629,  1631,
    1633,  1635,  1637,  1643,  1645,  1647,  1649,  1651,  1653,  1655,
    1657,  1659,  1665,  1675,  1679,  1685,  1689,  1699,  1709,  1710,
    1724,  1731,  1737,  1748,  1754,  1763,  1770,  1776,  1785,  1792,
    1800,  1805,  1813,  1818,  1824,  1829,  1835,  1840,  1846,  1850,
    1854,  1858,  1862,  1866,  1870,  1874,  1878,  1886,  1890,  1894,
    1898,  1902,  1906,  1914,  1922,  1931,  1933,  1941,  1949,  1957,
    1965,  1969,  1977,  1981,  1989,  1997,  2005,  2009,  2017,  2021,
    2029,  2033,  2041,  2046,  2052,  2057,  2063,  2067,  2071,  2075,
    2079,  2083,  2091,  2095,  2099,  2107,  2111,  2115,  2119,  2123,
    2127,  2131,  2135,  2139,  2144,  2148,  2152,  2156,  2160,  2164,
    2172,  2176,  2184,  2188,  2196,  2200,  2214,  2218,  2222,  2226,
    2234,  2238,  2242,  2246,  2254,  2258,  2262,  2266,  2270,  2274,
    2278,  2286,  2290,  2295,  2301,  2305,  2313,  2317,  2321,  2325,
    2329,  2337,  2341,  2349,  2353,  2357,  2361,  2365,  2374,  2382,
    2386,  2394,  2398,  2406,  2414,  2418,  2422,  2426,  2434,  2438,
    2442,  2446,  2454,  2458,  2466,  2470,  2474,  2478,  2482,  2486,
    2490,  2494,  2498,  2502,  2506,  2510,  2514,  2518,  2522,  2526,
    2530,  2534,  2538,  2542,  2546,  2550,  2554,  2558,  2562,  2566,
    2570,  2574,  2578,  2582,  2586,  2590,  2594,  2598,  2602,  2606,
    2610,  2614,  2618,  2622,  2626,  2634,  2638,  2646,  2650,  2655,
    2661,  2666,  2672,  2677,  2683,  2691,  2696,  2702,  2706,  2714,
    2718,  2722,  2726,  2734,  2742,  2746,  2754,  2758,  2762,  2766,
    2774,  2779,  2787,  2798,  2809,  2813,  2821,  2825,  2829,  2837,
    2841,  2849,  2854,  2860,  2864,  2868,  2872,  2876,  2880,  2884,
    2888,  2892,  2896,  2900,  2904,  2912,  2917,  2923,  2928,  2934,
    2939,  2945,  2950,  2956,  2960,  2968,  2976,  2980,  2984,  2988,
    2993,  2999,  3003,  3011,  3019,  3023,  3027,  3031,  3039,  3043,
    3047,  3051,  3055,  3059,  3063,  3068,  3074,  3079,  3085,  3090,
    3096,  3100,  3108,  3112,  3120,  3124,  3128,  3136,  3140,  3148,
    3156,  3164,  3169,  3175,  3179,  3183,  3187,  3195,  3199,  3203,
    3207,  3211,  3215,  3219,  3227,  3231,  3235,  3239,  3247,  3255,
    3259,  3264,  3270,  3274,  3278,  3282,  3286,  3290,  3298,  3302,
    3310,  3314,  3318,  3322,  3326,  3330,  3334,  3342,  3347,  3353,
    3357,  3365,  3373,  3377,  3382,  3387,  3393,  3397,  3405,  3409,
    3417,  3422,  3428,  3432,  3436,  3440,  3445,  3451,  3459,  3467,
    3471,  3475,  3479,  3483,  3491,  3496,  3502,  3506,  3510,  3515,
    3521,  3525,  3529,  3534,  3540,  3545,  3551,  3555,  3563,  3567,
    3571,  3575,  3580,  3586,  3590,  3595,  3601,  3606,  3612,  3620,
    3628,  3633,  3639,  3643,  3651,  3659,  3663,  3668,  3674,  3682,
    3690,  3695,  3701,  3705,  3713,  3717,  3721,  3725,  3729,  3733,
    3737,  3741,  3745,  3749,  3753,  3757,  3765,  3770,  3776,  3780,
    3784,  3792,  3796,  3804,  3808,  3816,  3821,  3827,  3831,  3839,
    3844,  3850,  3854,  3862,  3867,  3873,  3877,  3885,  3890,  3896,
    3904,  3909,  3915,  3919,  3927,  3931,  3939,  3944,  3950,  3954,
    3958,  3966,  3974,  3979,  3985,  3993,  3997,  4001,  4005,  4009,
    4013,  4017,  4021,  4025,  4029,  4033,  4037,  4041,  4045,  4049,
    4053,  4057,  4061,  4065,  4069,  4073,  4077,  4085,  4093,  4097,
    4101,  4105,  4113,  4117,  4125,  4130,  4136,  4140,  4148,  4152,
    4160,  4165,  4171,  4175,  4183,  4191,  4195,  4203,  4207,  4211,
    4215,  4223,  4231,  4239,  4247,  4255,  4260,  4266,  4270,  4278,
    4283,  4289,  4293,  4301,  4305,  4309,  4317,  4321,  4329,  4333,
    4341,  4345,  4353,  4361,  4369,  4377,  4381,  4385,  4393,  4397,
    4405,  4413,  4417,  4425,  4429,  4433,  4441,  4445,  4453,  4457,
    4461,  4465,  4469,  4477,  4482,  4488,  4493,  4499,  4503,  4511,
    4516,  4522,  4526,  4531,  4537,  4541,  4545,  4549,  4557,  4562,
    4569,  4571,  4579,  4583,  4587,  4591,  4595,  4603,  4607,  4615,
    4624,  4633,  4637,  4641,  4645,  4649,  4653,  4657,  4661,  4665,
    4669,  4673,  4677,  4681,  4689,  4697,  4701,  4709,  4713,  4721,
    4725,  4729,  4733,  4737,  4745,  4749,  4757,  4765,  4769,  4777,
    4785,  4790,  4796,  4800,  4808,  4812,  4816,  4824,  4832,  4836,
    4844,  4848,  4852,  4856,  4860,  4868,  4873,  4879,  4884,  4890,
    4894,  4899,  4905,  4911,  4917,  4925,  4929,  4937,  4941,  4949,
    4953,  4961,  4965,  4973,  4977,  4985,  4993,  5001,  5005,  5013,
    5017,  5021,  5025,  5029,  5033,  5037,  5041,  5045,  5049,  5053,
    5057,  5061,  5065,  5069,  5077,  5081,  5089,  5093,  5101,  5105,
    5113,  5121,  5125,  5130,  5136,  5140,  5144,  5148,  5152,  5156,
    5160,  5164,  5168,  5172,  5176,  5180,  5184,  5188,  5192,  5196,
    5200,  5208,  5212,  5216,  5220,  5224,  5228,  5232,  5236,  5240,
    5244,  5248,  5252,  5256,  5260,  5264,  5268,  5272,  5280,  5284,
    5292,  5296,  5300,  5304,  5308,  5316,  5321,  5327,  5331,  5335,
    5339,  5343,  5347,  5351,  5355,  5363,  5367,  5375,  5379,  5383,
    5387,  5393,  5399,  5405,  5411,  5417,  5423,  5429,  5439,  5450,
    5461,  5472,  5483,  5494,  5505,  5521,  5537,  5553,  5564,  5580,
    5591,  5607,  5622,  5626,  5634,  5639,  5645,  5653,  5657,  5665,
    5669,  5673,  5677,  5681,  5689,  5693,  5701,  5705,  5709,  5713,
    5721,  5725,  5729,  5733,  5737,  5741,  5745,  5749,  5753,  5757,
    5761,  5765,  5769,  5773,  5781,  5785,  5793,  5797,  5805,  5810,
    5816,  5820,  5828,  5836,  5844,  5848,  5856,  5861,  5867,  5872,
    5878,  5886,  5891,  5897,  5901,  5905,  5913,  5917,  5921,  5929,
    5933,  5937,  5945,  5953,  5958,  5964,  5969,  5975,  5980,  5986,
    5991,  5997,  6001,  6009,  6013,  6017,  6025,  6030,  6036,  6040,
    6045,  6051,  6055,  6060,  6066,  6070,  6075,  6081,  6085,  6089,
    6097,  6102,  6108,  6112,  6120,  6124,  6132,  6136,  6144,  6148,
    6156,  6160,  6164,  6168,  6172,  6180,  6184,  6188,  6192,  6196,
    6204,  6212,  6220,  6224,  6228,  6236,  6240,  6244,  6252,  6256,
    6264,  6268,  6272,  6276,  6280,  6284,  6288,  6292,  6296,  6300,
    6304,  6308,  6312,  6320,  6324,  6328,  6332,  6340,  6344,  6352,
    6357,  6363,  6371,  6375,  6383,  6391,  6395,  6403,  6408,  6414,
    6418,  6426,  6430,  6438,  6442,  6450,  6454,  6458,  6462,  6470,
    6474,  6482,  6490,  6494,  6502,  6506,  6514,  6518,  6522,  6530,
    6534,  6539,  6545,  6553,  6558,  6564,  6568,  6572,  6580,  6584,
    6592,  6597,  6603,  6607,  6611,  6615,  6619,  6623,  6627,  6631,
    6635,  6639,  6643,  6647,  6651,  6655,  6659,  6663,  6667,  6671,
    6675,  6679,  6683,  6687,  6691,  6695,  6699,  6703,  6707,  6711,
    6715,  6723,  6728,  6734,  6739,  6745,  6749,  6753,  6757,  6761,
    6765,  6769,  6773,  6777,  6781,  6785,  6789,  6793,  6797,  6801,
    6805,  6809,  6813,  6821,  6825,  6829,  6833,  6837,  6841,  6845,
    6849,  6853,  6857,  6861,  6865,  6869,  6873,  6877,  6881,  6885,
    6889,  6897,  6905,  6909,  6913,  6921,  6925,  6933,  6937,  6941,
    6945,  6949,  6957,  6962,  6968,  6972,  6976,  6980,  6988,  6992,
    6997,  7003,  7007,  7015,  7023,  7028,  7034,  7042,  7046,  7054,
    7058,  7062,  7066,  7070,  7074,  7078,  7082,  7086,  7090,  7094,
    7098,  7102,  7106,  7114,  7118,  7123,  7129,  7133,  7137,  7141,
    7145,  7153,  7157,  7161,  7169,  7174,  7180,  7184,  7192,  7197,
    7202,  7208,  7214,  7222,  7230,  7235,  7241,  7245,  7249,  7253,
    7257,  7261,  7265,  7269,  7273,  7277,  7281,  7285,  7289,  7293,
    7297,  7301,  7309,  7314,  7320,  7324,  7332,  7340,  7345,  7351,
    7359,  7363,  7371,  7379,  7383,  7387,  7391,  7395,  7403,  7408,
    7414,  7422,  7426,  7430,  7434,  7438,  7442,  7450,  7458,  7462,
    7466,  7474,  7479,  7485,  7489,  7493,  7497,  7501,  7509,  7513,
    7521,  7525,  7529,  7533,  7541,  7545,  7553,  7557,  7565,  7570,
    7576,  7581,  7587,  7592,  7598,  7603,  7609,  7617,  7622,  7628,
    7636,  7644,  7652,  7656,  7664,  7672,  7680,  7688,  7696,  7700,
    7704,  7708,  7716,  7720,  7724,  7728,  7732,  7736,  7740,  7748,
    7752,  7760,  7768,  7772,  7776,  7784,  7788,  7793,  7799,  7807,
    7815,  7819,  7823,  7831,  7835,  7840,  7846,  7850,  7855,  7861,
    7867,  7877,  7882,  7888,  7892,  7896,  7900,  7908,  7910,  7918,
    7923,  7929,  7937,  7941,  7945,  7953,  7957,  7965,  7973,  7978,
    7984,  7992,  7997,  8003,  8011,  8016,  8022,  8026,  8030,  8034,
    8038,  8042,  8046,  8050,  8058,  8063,  8069,  8077,  8081,  8089,
    8093,  8101,  8109,  8117,  8125,  8129,  8137,  8190,  8194,  8207,
    8209,  8213,  8217,  8221,  8230,  8236,  8240,  8248,  8252,  8260,
    8264,  8272,  8276,  8280,  8284,  8288,  8292,  8296,  8300,  8308,
    8312,  8320,  8324,  8328,  8332,  8336,  8340,  8348,  8352,  8360,
    8364,  8372,  8380,  8385,  8391,  8396,  8398,  8404,  8408,  8412,
    8416,  8420,  8424,  8428,  8432,  8436,  8444,  8449,  8455,  8459,
    8464,  8470,  8474,  8478,  8483,  8489,  8494,  8500,  8508,  8512,
    8520,  8524,  8532,  8536,  8540,  8544,  8552,  8557,  8563,  8567,
    8572,  8580,  8584,  8592,  8596,  8604,  8612,  8616,  8621,  8627,
    8635,  8639,  8647,  8651,  8659,  8664,  8670,  8675,  8681,  8685,
    8693,  8698,  8704,  8708,  8716,  8720,  8728,  8733,  8739,  8743,
    8751,  8756,  8762,  8766,  8774,  8778,  8782,  8786,  8790,  8794,
    8798,  8802,  8808,  8812,  8816,  8824,  8828,  8832,  8836,  8840,
    8844,  8852,  8856,  8860,  8864,  8872,  8876,  8880,  8884,  8892,
    8897,  8903,  8907,  8915,  8919,  8923,  8927,  8935,  8939,  8947,
    8951,  8955,  8963,  8971,  8976,  8982,  8986,  8992,  8998,  9003,
    9009,  9013,  9021,  9029,  9031,  9033,  9037,  9041,  9045,  9053,
    9063,  9074,  9083,  9087,  9091,  9095,  9099,  9103,  9107,  9115,
    9119,  9123,  9127,  9135,  9139,  9147,  9152,  9158,  9162,  9166,
    9170,  9174,  9178,  9182,  9186,  9190,  9194,  9198,  9206,  9211,
    9217,  9221,  9229,  9233,  9241,  9249,  9257,  9261,  9269,  9273,
    9281,  9289,  9297,  9301,  9305,  9309,  9313,  9317,  9325,  9330,
    9336,  9341,  9347,  9351,  9355,  9359,  9367,  9375,  9379,  9384,
    9390,  9394,  9398,  9402,  9406,  9410,  9414,  9418,  9422,  9426,
    9430,  9434,  9438,  9443,  9449,  9453,  9461,  9465,  9469,  9473,
    9477,  9481,  9485,  9489,  9493,  9497,  9501,  9505,  9509,  9513,
    9517,  9521,  9525,  9529,  9533,  9537,  9541,  9545,  9549,  9553,
    9557,  9561,  9565,  9569,  9573,  9577,  9581,  9585,  9589,  9593,
    9597,  9601,  9605,  9609,  9613,  9617,  9621,  9625,  9629,  9633,
    9637,  9641,  9645,  9649,  9653,  9657,  9661,  9665,  9669,  9673,
    9677,  9681,  9685,  9690,  9694,  9702,  9706,  9710,  9714,  9718,
    9722,  9726,  9730,  9734,  9738,  9742,  9746,  9750,  9754,  9758,
    9762,  9766,  9770,  9774,  9778,  9782,  9786,  9794,  9798,  9802,
    9806,  9810,  9814,  9818,  9822,  9826,  9830,  9834,  9842,  9846,
    9850,  9854,  9858,  9862,  9866,  9870,  9874,  9878,  9882,  9886,
    9890,  9894,  9898,  9902,  9906,  9910,  9914,  9918,  9922,  9926,
    9930,  9934,  9938,  9942,  9946,  9950,  9954,  9958,  9962,  9966,
    9970,  9974,  9978,  9982,  9986,  9990,  9994,  9998, 10002, 10006,
   10010, 10014, 10018, 10022, 10026, 10030, 10034, 10042, 10046, 10054,
   10058, 10062, 10067, 10073, 10081, 10085, 10093, 10097, 10105, 10109,
   10117, 10121, 10126, 10132, 10136, 10140, 10144, 10152, 10157, 10163,
   10167, 10175, 10183, 10187, 10192, 10198, 10206, 10210, 10217, 10222,
   10228, 10233, 10238, 10244, 10248, 10256, 10260, 10264, 10268, 10272,
   10280, 10284, 10288, 10296, 10300, 10304, 10312, 10316, 10324, 10328,
   10332, 10336, 10340, 10344, 10348, 10352, 10356, 10364, 10368, 10376,
   10380, 10388, 10392, 10396, 10400, 10404, 10408, 10416, 10420, 10428,
   10432, 10440, 10444, 10452, 10456, 10464, 10468, 10472, 10480, 10484,
   10492, 10497, 10503, 10507, 10511, 10515, 10519, 10523, 10527, 10531,
   10539, 10543, 10551, 10559, 10564, 10570, 10574, 10578, 10582, 10586,
   10591, 10597, 10605, 10613, 10617, 10621, 10629, 10633, 10641, 10649,
   10653, 10661, 10669, 10674, 10680, 10685, 10691, 10695, 10703, 10707,
   10711, 10715, 10723, 10727, 10736, 10738, 10746, 10751, 10757, 10761,
   10769, 10773, 10781, 10789, 10793, 10801, 10805, 10809, 10813, 10821,
   10825, 10833, 10837, 10845, 10849, 10857, 10865, 10873, 10881, 10889,
   10897, 10905, 10909, 10917, 10921, 10925, 10929, 10933, 10937, 10941,
   10945, 10949, 10953, 10957, 10961, 10965, 10969, 10970, 10975, 10981,
   10989, 10993, 10994, 10998, 11006, 11010, 11014, 11018, 11022, 11026,
   11030, 11034, 11038, 11042, 11046, 11050, 11054, 11058, 11062, 11066,
   11070, 11074, 11078, 11082, 11086, 11090, 11094, 11098, 11102, 11106,
   11110, 11114, 11118, 11122, 11126, 11130, 11134, 11138, 11142, 11146,
   11150, 11154, 11158, 11162, 11166, 11170, 11174, 11178, 11182, 11186,
   11190, 11194, 11198, 11202, 11206, 11210, 11214, 11218, 11222, 11226,
   11230, 11234, 11238, 11242, 11246, 11250, 11254, 11258, 11262, 11266,
   11270, 11274, 11278, 11282, 11286, 11290, 11294, 11298, 11302, 11306,
   11310, 11314, 11318, 11322, 11326, 11330, 11334, 11338, 11342, 11346,
   11350, 11354, 11358, 11362, 11366, 11370, 11374, 11378, 11382, 11386,
   11390, 11394, 11398, 11402, 11406, 11410, 11414, 11418, 11422, 11426,
   11430, 11434, 11438, 11442, 11446, 11450, 11454, 11458, 11462, 11466,
   11470, 11474, 11478, 11482, 11486, 11490, 11494, 11498, 11502, 11506,
   11510, 11514, 11518, 11522, 11526, 11530, 11534, 11538, 11542, 11546,
   11550, 11554, 11558, 11562, 11566, 11570, 11574, 11578, 11582, 11586,
   11590, 11594, 11598, 11602, 11606, 11610, 11614, 11618, 11622, 11626,
   11630, 11634, 11638, 11642, 11646, 11650, 11654, 11658, 11662, 11666,
   11670, 11674, 11678, 11682, 11686, 11690, 11694, 11698, 11702, 11706,
   11710, 11714, 11718, 11722, 11726, 11730, 11734, 11738, 11742, 11746,
   11750, 11754, 11758, 11762, 11766, 11770, 11774, 11778, 11782, 11786,
   11790, 11794, 11798, 11802, 11806, 11810, 11814, 11818, 11822, 11826,
   11830, 11834, 11838, 11842, 11846, 11850, 11854, 11858, 11862, 11866,
   11870, 11874, 11878, 11882, 11886, 11890, 11894, 11898, 11902, 11906,
   11910, 11914, 11918, 11922, 11926, 11930, 11934, 11938, 11942, 11946,
   11950, 11954, 11958, 11962, 11966, 11970, 11974, 11978, 11982, 11986,
   11990, 11994, 11998, 12002, 12006, 12014, 12018, 12022, 12026, 12030,
   12034, 12038, 12042, 12046, 12050, 12054, 12058, 12062, 12066, 12070,
   12074, 12078, 12082, 12086, 12090, 12094, 12098, 12102, 12106, 12110,
   12114, 12118, 12122, 12126, 12130, 12134, 12138, 12142, 12146, 12150,
   12154, 12158, 12162, 12166, 12170, 12174, 12178, 12182, 12186, 12194,
   12198, 12202, 12206, 12210, 12214, 12218, 12222, 12226, 12230, 12234,
   12238, 12242, 12246, 12250, 12254, 12258, 12262, 12266, 12270, 12274,
   12278, 12286, 12290, 12294, 12298, 12302, 12306, 12310, 12314, 12318,
   12322, 12326, 12330, 12334, 12338, 12342, 12346, 12350, 12354, 12358,
   12362, 12366, 12370, 12374, 12378, 12382, 12386, 12390, 12394, 12398,
   12402, 12406, 12410, 12414, 12418, 12422, 12426, 12430, 12434, 12438,
   12442, 12446, 12450, 12454, 12458, 12462, 12466, 12470, 12474, 12478,
   12482, 12486, 12490, 12494, 12498, 12502, 12506, 12510, 12514, 12518,
   12522, 12526, 12530, 12534, 12538, 12542, 12546, 12550, 12554, 12558,
   12562, 12566, 12570, 12574, 12578, 12588, 12589, 12592, 12593, 12594,
   12600, 12601, 12602, 12603, 12604, 12617, 12617, 12626, 12642, 12644,
   12647, 12649, 12653, 12665, 12681, 12685, 12696, 12697, 12700, 12712,
   12721, 12722, 12725, 12726, 12727, 12730, 12731, 12734, 12735, 12738,
   12739, 12742, 12744, 12746, 12748, 12752, 12759, 12766, 12782, 12816,
   12826, 12829, 12831, 12844, 12845, 12847, 12849, 12853, 12866, 12873,
   12934, 12943, 12945, 12946, 12949, 12951, 12952, 12955, 12956, 12957,
   12958, 12959, 12966, 12965, 12975, 12977, 12979, 12980, 12983, 12984,
   12985, 12986, 12989, 12990, 12994, 12993, 13010, 13008, 13024, 13023,
   13037, 13043, 13044, 13047, 13049, 13050, 13053, 13054, 13055, 13056,
   13059, 13060, 13063, 13071, 13088, 13096, 13119, 13225, 13259, 13261,
   13263, 13267, 13271, 13270, 13321, 13323, 13322, 13337, 13343, 13350,
   13355, 13358, 13359, 13362, 13363, 13364, 13365, 13366, 13367, 13368,
   13376, 13384, 13387, 13388, 13389, 13390, 13391, 13392, 13400, 13408,
   13409, 13410, 13413, 13414, 13417, 13419, 13423, 13511, 13512, 13519,
   13520, 13521, 13527, 13536, 13539, 13540, 13541, 13542, 13545, 13546,
   13547, 13550, 13552, 13560, 13561, 13567, 13575, 13576, 13579, 13580,
   13583, 13588, 13595, 13600, 13607, 13614, 13614, 13616, 13623, 13624,
   13627, 13628, 13629, 13630, 13631, 13632, 13633, 13634, 13635, 13641,
   13648, 13660, 13666, 13673, 13681, 13682, 13694, 13705, 13716, 13720,
   13721, 13724, 13729, 13733, 13734, 13737, 13743, 13751, 13754, 13761,
   13765, 13766, 13769, 13772, 13776, 13777, 13780, 13786, 13794, 13795,
   13804, 13813, 13825, 13826, 13827, 13828, 13829, 13830, 13831, 13832,
   13833, 13834, 13835, 13836, 13837, 13838, 13839, 13846, 13847, 13850,
   13851, 13858, 13859, 13860, 13867, 13866, 13883, 13884, 13891, 13890,
   13960, 13966, 13972, 13980, 13986, 13992, 13998, 14004, 14010, 14016,
   14022, 14028, 14039, 14040, 14043, 14044, 14045, 14046, 14047, 14048,
   14049, 14050, 14051, 14052, 14053, 14054, 14055, 14056, 14057, 14058,
   14059, 14060, 14061, 14062, 14063, 14064, 14065, 14066, 14069, 14070,
   14071, 14072, 14073, 14074, 14078, 14079, 14080, 14081, 14082, 14083,
   14084, 14087, 14090, 14091, 14092, 14093, 14094, 14095, 14096, 14097,
   14110, 14111, 14112, 14113, 14114, 14115, 14116, 14121, 14122, 14123,
   14124, 14125, 14126, 14132, 14133, 14134, 14135, 14136, 14137, 14138,
   14139, 14140, 14141, 14142, 14145, 14146, 14147, 14148, 14149, 14152,
   14153, 14154, 14155, 14158, 14159, 14160, 14161, 14162, 14163, 14164,
   14181, 14182, 14183, 14186, 14187, 14188, 14189, 14190, 14191, 14195,
   14195, 14198, 14204, 14205, 14208, 14210, 14215, 14225, 14236, 14243,
   14244, 14245, 14248, 14281, 14283, 14285, 14288, 14298, 14308, 14318,
   14319, 14322, 14324, 14325, 14326, 14329, 14331, 14339, 14340, 14341,
   14345, 14346, 14350, 14351, 14354, 14355, 14358, 14359, 14360, 14361,
   14362, 14365, 14366, 14367, 14368, 14369, 14370, 14371, 14372, 14373,
   14374, 14375, 14376, 14377, 14378, 14379, 14380, 14381, 14382, 14383,
   14384, 14385, 14386, 14387, 14388, 14389, 14390, 14391, 14392, 14393,
   14394, 14395, 14396, 14397, 14398, 14399, 14400, 14401, 14402, 14403,
   14404, 14405, 14406, 14407, 14408, 14409, 14410, 14411, 14412, 14413,
   14414, 14415, 14416, 14417, 14418, 14419, 14420, 14423, 14424, 14425,
   14426, 14429, 14430, 14431, 14432, 14433, 14434, 14435, 14436, 14437,
   14440, 14441, 14442, 14443, 14444, 14447, 14448, 14451, 14452, 14463,
   14464
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BARRIER", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT",
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE",
  "CASCADED", "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLEAN", "CLOSE",
  "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT",
  "COMMENTS", "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION",
  "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P",
  "CONVERSION_P", "COORDINATOR", "COPY", "COST", "CREATE", "CROSS", "CSV",
  "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE",
  "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER",
  "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC",
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED",
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY",
  "DIRECT", "DISABLE_P", "DISCARD", "DISTINCT", "DISTRIBUTE", "DO",
  "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P",
  "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT",
  "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN",
  "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH",
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD",
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT",
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HASH", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL",
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MODULO", "MONTH_P", "MOVE", "NAME_P",
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NODE", "NONE",
  "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF",
  "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON",
  "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P",
  "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER",
  "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS",
  "POSITION", "PRECEDING", "PRECISION", "PREFERRED", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE",
  "REF", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "REPLICATION", "RESET", "RESTART",
  "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROBIN", "ROLE",
  "ROLLBACK", "ROUND", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA",
  "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE",
  "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET",
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION",
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER",
  "USING", "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT",
  "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", "XMLCONCAT",
  "XMLELEMENT", "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT",
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST",
  "WITH_TIME", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'",
  "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','",
  "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt",
  "opt_with", "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "var_name", "var_list", "var_value", "iso_level",
  "opt_boolean_or_string", "zone_value", "opt_encoding", "ColId_or_Sconst",
  "VariableResetStmt", "SetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "copy_file_name", "copy_options", "copy_opt_list",
  "copy_opt_item", "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList",
  "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "DistributeByHash", "OptDistributeBy",
  "OptSubCluster", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement",
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList",
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list",
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler",
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "OptForeignTableElementList", "ForeignTableElementList",
  "ForeignTableElement", "AlterForeignTableStmt", "CreateUserMappingStmt",
  "auth_ident", "DropUserMappingStmt", "AlterUserMappingStmt",
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents",
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOptEach",
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg",
  "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintAttributeElem", "DropTrigStmt", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default",
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt",
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop",
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt",
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list",
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt",
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider",
  "security_label_type", "security_label", "FetchStmt", "fetch_args",
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges",
  "privilege_list", "privilege", "privilege_target", "grantee_list",
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list",
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt",
  "opt_grant_admin_option", "opt_granted_by", "AlterDefaultPrivilegesStmt",
  "DefACLOptionList", "DefACLOption", "DefACLAction",
  "defacl_privilege_target", "IndexStmt", "opt_unique", "opt_concurrently",
  "opt_index_name", "access_method_clause", "index_params", "index_elem",
  "opt_collate", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "BarrierStmt",
  "opt_barrier_id", "CreateNodeStmt", "pgxcnode_name", "pgxcgroup_name",
  "pgxcnode_list", "AlterNodeStmt", "DropNodeStmt", "CreateNodeGroupStmt",
  "DropNodeGroupStmt", "ExplainStmt", "ExplainableStmt",
  "explain_option_list", "explain_option_elem", "explain_option_name",
  "explain_option_arg", "ExecDirectStmt", "DirectStmt", "CleanConnStmt",
  "CleanConnDbName", "CleanConnUserName", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "SignedIconst", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,    61,
      60,    62,   754,    43,    45,    42,    47,    37,    94,   755,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   520,   521,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   523,   524,   524,   525,   525,   526,   526,   527,   527,
     527,   527,   527,   527,   527,   527,   527,   528,   528,   528,
     528,   528,   528,   529,   530,   531,   531,   532,   533,   534,
     535,   535,   536,   536,   537,   538,   539,   539,   540,   540,
     541,   541,   542,   542,   543,   543,   544,   544,   544,   544,
     544,   544,   545,   545,   545,   546,   546,   546,   546,   546,
     546,   546,   546,   546,   546,   546,   546,   546,   546,   546,
     547,   547,   548,   548,   549,   549,   550,   550,   550,   550,
     551,   551,   551,   551,   552,   552,   552,   552,   552,   552,
     552,   553,   553,   553,   554,   554,   555,   555,   555,   555,
     555,   556,   556,   557,   557,   557,   557,   557,   558,   559,
     559,   560,   560,   561,   562,   562,   562,   562,   563,   563,
     563,   563,   564,   564,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   566,   566,   567,   567,   567,
     568,   568,   569,   569,   570,   571,   571,   572,   572,   573,
     573,   573,   573,   574,   575,   575,   576,   576,   576,   576,
     577,   577,   578,   578,   579,   579,   580,   580,   580,   581,
     581,   582,   582,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   584,   584,   585,   585,   586,
     586,   587,   587,   588,   588,   589,   590,   590,   590,   590,
     590,   591,   591,   592,   593,   593,   593,   593,   594,   594,
     594,   594,   594,   594,   594,   594,   595,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   600,   600,   601,
     602,   603,   603,   604,   604,   604,   604,   605,   605,   605,
     605,   605,   605,   605,   606,   606,   606,   606,   607,   608,
     608,   608,   609,   609,   609,   609,   609,   609,   610,   610,
     611,   611,   611,   611,   611,   611,   611,   612,   612,   613,
     613,   614,   615,   615,   615,   615,   616,   616,   617,   617,
     618,   618,   619,   619,   619,   619,   619,   620,   621,   622,
     622,   622,   622,   622,   623,   623,   624,   624,   624,   624,
     625,   625,   625,   625,   626,   626,   627,   627,   628,   628,
     628,   628,   628,   629,   629,   629,   630,   630,   631,   632,
     633,   633,   634,   634,   635,   636,   636,   636,   637,   638,
     639,   639,   640,   640,   641,   641,   641,   641,   641,   641,
     641,   641,   641,   641,   641,   641,   642,   642,   643,   643,
     643,   644,   644,   645,   645,   646,   646,   647,   647,   648,
     648,   649,   649,   650,   650,   651,   651,   652,   652,   653,
     654,   654,   655,   655,   656,   656,   657,   657,   658,   658,
     658,   659,   660,   660,   661,   662,   662,   662,   662,   662,
     662,   662,   662,   662,   662,   662,   662,   662,   662,   662,
     662,   662,   662,   662,   662,   662,   662,   663,   664,   664,
     664,   664,   665,   665,   666,   666,   667,   667,   668,   668,
     669,   669,   670,   670,   671,   672,   672,   673,   673,   673,
     673,   674,   675,   676,   677,   678,   678,   679,   679,   680,
     680,   681,   681,   682,   682,   682,   683,   683,   684,   684,
     685,   685,   686,   687,   688,   689,   689,   689,   690,   690,
     691,   692,   692,   693,   693,   693,   694,   694,   695,   695,
     695,   695,   695,   696,   696,   697,   697,   698,   698,   699,
     699,   700,   700,   700,   701,   701,   701,   701,   702,   702,
     703,   703,   704,   704,   704,   704,   704,   705,   705,   706,
     707,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   709,   710,   710,   711,   711,   712,
     712,   712,   712,   712,   713,   713,   714,   715,   715,   716,
     717,   717,   718,   718,   719,   719,   719,   720,   721,   721,
     722,   722,   722,   722,   722,   723,   723,   724,   724,   725,
     725,   725,   726,   726,   727,   728,   728,   729,   729,   730,
     730,   731,   731,   732,   732,   733,   734,   735,   735,   736,
     736,   736,   736,   736,   736,   736,   736,   736,   736,   736,
     736,   736,   736,   736,   737,   737,   738,   738,   739,   739,
     740,   741,   741,   741,   742,   742,   742,   742,   742,   742,
     742,   742,   742,   742,   742,   742,   742,   742,   742,   742,
     742,   743,   743,   743,   743,   743,   743,   743,   743,   743,
     743,   743,   743,   743,   743,   743,   743,   743,   744,   744,
     745,   745,   745,   745,   745,   746,   746,   747,   747,   747,
     747,   747,   747,   747,   747,   748,   748,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   750,   750,
     750,   750,   750,   750,   750,   750,   750,   750,   750,   750,
     750,   750,   751,   751,   752,   752,   753,   754,   754,   755,
     755,   755,   755,   755,   756,   756,   757,   757,   757,   757,
     758,   758,   758,   758,   758,   758,   758,   758,   758,   758,
     758,   758,   758,   758,   759,   759,   760,   760,   761,   761,
     762,   762,   763,   764,   765,   765,   766,   766,   767,   767,
     768,   769,   769,   770,   770,   770,   771,   771,   771,   772,
     772,   772,   773,   774,   774,   775,   775,   776,   776,   777,
     777,   778,   778,   779,   779,   779,   780,   780,   781,   781,
     781,   782,   782,   782,   783,   783,   783,   784,   784,   784,
     785,   785,   786,   786,   787,   787,   788,   788,   789,   789,
     790,   790,   790,   790,   790,   791,   791,   791,   791,   791,
     792,   793,   794,   794,   794,   795,   795,   795,   796,   796,
     797,   797,   797,   797,   797,   797,   797,   797,   797,   797,
     797,   797,   797,   798,   798,   798,   798,   799,   799,   800,
     800,   801,   802,   802,   803,   804,   804,   805,   805,   806,
     806,   807,   807,   808,   808,   809,   809,   809,   809,   810,
     810,   811,   812,   812,   813,   813,   814,   814,   814,   815,
     815,   815,   816,   817,   817,   818,   818,   818,   819,   819,
     820,   820,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   822,   822,   823,   823,   824,   824,   824,   824,   824,
     824,   824,   824,   824,   824,   824,   824,   824,   824,   824,
     824,   824,   824,   825,   825,   825,   825,   825,   825,   825,
     825,   825,   825,   825,   825,   825,   825,   825,   825,   825,
     825,   826,   827,   827,   827,   828,   828,   829,   829,   829,
     829,   829,   830,   830,   831,   831,   831,   831,   832,   832,
     832,   833,   833,   834,   835,   835,   836,   837,   837,   838,
     838,   838,   838,   838,   838,   838,   838,   838,   838,   838,
     838,   838,   838,   839,   839,   839,   840,   840,   840,   840,
     840,   841,   841,   841,   842,   842,   843,   843,   844,   844,
     844,   844,   845,   846,   847,   847,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   849,   849,   850,   850,   851,   852,   852,   853,
     854,   854,   855,   856,   856,   856,   856,   856,   857,   857,
     858,   859,   859,   859,   859,   859,   859,   860,   861,   861,
     861,   862,   862,   863,   863,   863,   863,   863,   864,   864,
     865,   865,   865,   865,   866,   866,   867,   867,   868,   868,
     869,   869,   870,   870,   871,   871,   872,   873,   873,   874,
     875,   876,   877,   877,   878,   879,   880,   881,   882,   882,
     882,   882,   883,   883,   883,   883,   883,   883,   883,   884,
     884,   885,   886,   886,   886,   887,   887,   887,   888,   889,
     890,   890,   890,   891,   891,   891,   892,   892,   892,   893,
     893,   894,   894,   895,   895,   895,   895,   896,   896,   897,
     897,   898,   899,   899,   899,   900,   900,   901,   902,   902,
     903,   904,   904,   905,   906,   906,   907,   907,   907,   907,
     907,   907,   907,   907,   908,   908,   909,   910,   910,   911,
     911,   912,   913,   914,   915,   915,   916,   917,   917,   918,
     918,   918,   918,   918,   919,   919,   919,   920,   920,   921,
     921,   922,   922,   922,   922,   922,   922,   922,   922,   923,
     923,   924,   924,   924,   924,   924,   924,   925,   925,   926,
     926,   927,   928,   928,   929,   929,   929,   930,   930,   930,
     930,   930,   930,   930,   930,   930,   931,   931,   932,   932,
     932,   933,   933,   933,   933,   934,   934,   935,   936,   936,
     937,   937,   938,   938,   938,   938,   939,   939,   940,   940,
     940,   941,   941,   942,   942,   943,   944,   944,   944,   945,
     946,   946,   947,   947,   948,   948,   949,   949,   950,   950,
     951,   951,   952,   952,   953,   953,   954,   954,   955,   955,
     956,   956,   957,   957,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   959,   959,   959,   959,   959,
     959,   960,   960,   960,   960,   961,   961,   961,   961,   962,
     962,   963,   963,   964,   964,   964,   964,   965,   965,   966,
     966,   966,   967,   968,   968,   969,   969,   969,   970,   970,
     971,   971,   972,   973,   973,   973,   973,   973,   973,   974,
     974,   974,   975,   975,   975,   975,   975,   975,   975,   976,
     976,   976,   976,   977,   977,   978,   978,   979,   979,   979,
     979,   979,   979,   979,   979,   979,   979,   979,   980,   980,
     981,   981,   982,   982,   983,   984,   985,   985,   986,   986,
     987,   988,   989,   989,   989,   989,   989,   989,   990,   990,
     991,   991,   992,   992,   992,   992,   993,   994,   994,   994,
     995,   995,   995,   995,   995,   995,   995,   995,   995,   995,
     995,   995,   995,   995,   996,   996,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   998,   998,   998,   998,   998,
     998,   998,   998,   998,   998,   998,   998,   998,   998,   998,
     998,   998,   998,   998,   998,   998,   998,   999,   999,   999,
     999,   999,   999,   999,   999,   999,   999,   999,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1001,  1001,  1002,
    1002,  1002,  1002,  1003,  1004,  1004,  1005,  1005,  1006,  1006,
    1007,  1007,  1007,  1008,  1008,  1008,  1008,  1009,  1009,  1010,
    1010,  1011,  1012,  1012,  1012,  1013,  1014,  1014,  1015,  1015,
    1016,  1016,  1016,  1017,  1017,  1018,  1018,  1018,  1018,  1018,
    1019,  1019,  1019,  1020,  1020,  1020,  1021,  1021,  1022,  1022,
    1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,  1023,  1024,
    1024,  1025,  1025,  1025,  1025,  1025,  1025,  1026,  1026,  1027,
    1027,  1028,  1028,  1029,  1029,  1030,  1030,  1030,  1031,  1031,
    1032,  1032,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1034,  1034,  1035,  1036,  1036,  1037,  1037,  1037,  1037,  1037,
    1037,  1038,  1039,  1040,  1040,  1040,  1041,  1041,  1042,  1043,
    1043,  1044,  1045,  1045,  1046,  1046,  1047,  1047,  1048,  1048,
    1048,  1048,  1049,  1049,  1050,  1050,  1051,  1051,  1052,  1052,
    1053,  1053,  1054,  1055,  1055,  1056,  1056,  1056,  1056,  1057,
    1057,  1058,  1058,  1059,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1066,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1068,  1069,
    1070,  1070,  1070,  1070,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1075,  1075,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1078,  1077,  1079,  1080,  1080,
    1080,  1080,  1081,  1081,  1081,  1081,  1082,  1082,  1083,  1084,
    1085,  1085,  1086,  1086,  1086,  1087,  1087,  1088,  1088,  1089,
    1089,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1092,  1093,
    1093,  1094,  1094,  1095,  1095,  1095,  1095,  1096,  1096,  1097,
    1098,  1099,  1100,  1100,  1101,  1102,  1102,  1103,  1103,  1103,
    1103,  1103,  1105,  1104,  1106,  1107,  1108,  1108,  1109,  1109,
    1109,  1109,  1110,  1110,  1112,  1111,  1114,  1113,  1115,  1113,
    1113,  1116,  1116,  1117,  1117,  1117,  1118,  1118,  1118,  1118,
    1119,  1119,  1120,  1120,  1120,  1120,  1120,  1120,  1121,  1121,
    1121,  1122,  1124,  1123,  1125,  1126,  1125,  1127,  1127,  1128,
    1128,  1129,  1129,  1130,  1130,  1130,  1130,  1130,  1130,  1130,
    1130,  1130,  1131,  1131,  1131,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1132,  1132,  1133,  1133,  1134,  1135,  1135,  1136,
    1136,  1136,  1137,  1138,  1139,  1139,  1139,  1139,  1140,  1140,
    1140,  1141,  1141,  1142,  1142,  1143,  1144,  1144,  1145,  1145,
    1146,  1146,  1147,  1147,  1148,  1149,  1149,  1150,  1150,  1150,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1152,
    1152,  1152,  1152,  1152,  1153,  1153,  1154,  1155,  1156,  1157,
    1157,  1158,  1159,  1160,  1160,  1161,  1162,  1162,  1163,  1164,
    1165,  1165,  1166,  1167,  1168,  1168,  1169,  1170,  1170,  1170,
    1170,  1170,  1171,  1171,  1171,  1171,  1171,  1171,  1171,  1171,
    1171,  1171,  1171,  1171,  1171,  1171,  1171,  1172,  1172,  1173,
    1173,  1174,  1174,  1174,  1176,  1175,  1177,  1177,  1179,  1178,
    1180,  1180,  1180,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1182,  1182,  1183,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1184,  1184,
    1184,  1184,  1184,  1184,  1185,  1185,  1185,  1185,  1185,  1185,
    1185,  1186,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1188,  1188,  1188,  1188,  1188,  1188,  1188,  1189,  1189,  1189,
    1189,  1189,  1189,  1190,  1190,  1190,  1190,  1190,  1190,  1190,
    1190,  1190,  1190,  1190,  1191,  1191,  1191,  1191,  1191,  1192,
    1192,  1192,  1192,  1193,  1193,  1193,  1193,  1193,  1193,  1193,
    1194,  1194,  1194,  1195,  1195,  1195,  1195,  1195,  1195,  1196,
    1196,  1197,  1198,  1198,  1199,  1199,  1200,  1201,  1202,  1203,
    1203,  1203,  1204,  1205,  1206,  1207,  1208,  1208,  1208,  1208,
    1208,  1209,  1210,  1210,  1210,  1211,  1211,  1212,  1212,  1212,
    1213,  1213,  1214,  1214,  1215,  1215,  1216,  1216,  1216,  1216,
    1216,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1218,  1218,  1218,
    1218,  1219,  1219,  1219,  1219,  1219,  1219,  1219,  1219,  1219,
    1220,  1220,  1220,  1220,  1220,  1221,  1221,  1222,  1222,  1223,
    1223
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     5,     1,     0,     2,     0,     2,     0,     2,     2,
       3,     3,     1,     3,     3,     2,     1,     1,     2,     2,
       2,     3,     3,     5,     5,     0,     3,     5,     5,     4,
       3,     5,     3,     5,     5,     6,     1,     1,     3,     5,
       6,     4,     1,     0,     2,     0,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     5,     2,     2,     2,     2,     3,     3,     3,
       1,     3,     1,     3,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     6,     1,     1,
       1,     1,     1,     0,     1,     1,     2,     3,     4,     3,
       2,     2,     1,     3,     4,     5,     4,     2,     4,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     4,     4,
       4,     4,     1,     3,     2,     3,     4,     6,     6,     6,
       5,     5,     6,     6,     4,     8,     2,     3,     6,     4,
       3,     3,     3,     3,     3,     4,     4,     3,     3,     3,
       3,     3,     3,     4,     4,     3,     2,     3,     2,     2,
       3,     3,     2,     2,     1,     3,     2,     1,     1,     0,
       2,     0,     2,     0,     3,     2,     0,     1,     3,     3,
       1,     5,     3,     4,     1,     3,     4,     6,     4,     8,
       2,     2,    10,     6,     1,     1,     1,     1,     1,     1,
       3,     2,     0,     1,     1,     3,     3,     1,     1,     3,
       3,     3,     3,     4,     2,     1,     0,     2,     0,     3,
       0,     1,     0,     1,     3,     2,     1,     1,     1,     3,
       0,     1,     3,     1,    13,    16,    12,    15,     1,     1,
       2,     2,     2,     2,     1,     0,     1,     0,     3,     0,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       4,     2,     0,     3,     1,     1,     2,     2,     1,     3,
       4,     4,     2,     5,     1,     2,     2,     2,     3,     3,
       3,     0,     1,     1,     1,     1,     1,     1,     3,     1,
       5,     7,     3,     8,     4,     9,    11,     3,     0,     1,
       3,     1,     2,     2,     2,     0,     1,     3,     3,     6,
       4,     0,     1,     1,     2,     2,     0,     3,     3,     2,
       1,     1,     2,     2,     4,     0,     2,     2,     2,     0,
       3,     4,     4,     0,     2,     0,     2,     3,     4,     6,
       3,     4,     0,     3,     3,     0,     4,     0,     3,     7,
       3,     0,     1,     3,     1,     2,     3,     0,     5,     4,
       1,     0,     1,     2,     2,     1,     2,     3,     2,     2,
       2,     2,     3,     3,     1,     3,     1,     0,     1,     2,
       1,     1,     3,     6,    10,     1,     0,     1,     2,     2,
       0,     2,     2,     1,     0,     5,     7,     1,     0,     6,
       2,     0,     3,     5,     5,     8,     2,     0,     2,     2,
       2,     5,     2,     0,     2,     7,    10,     6,     6,     6,
       6,     7,     7,     9,     9,     6,     6,     8,     8,     8,
       8,     6,     6,     7,     8,     6,     6,     7,     2,     2,
       2,     2,     1,     2,     1,     0,     6,     8,     7,     6,
       4,     0,     1,     3,     4,     1,     3,     1,     2,     2,
       2,     2,     1,     1,    10,     2,     0,     2,     2,     1,
       0,     4,     6,     5,     4,     4,     8,    11,     3,     2,
       1,     3,     1,     5,     8,     1,     1,     1,     7,     9,
       8,    15,    20,     1,     1,     2,     1,     3,     1,     1,
       1,     3,     1,     3,     0,     1,     0,     1,     1,     4,
       0,     1,     3,     0,     1,     1,     1,     1,     2,     0,
       0,     2,     2,     1,     2,     2,     2,     6,     8,     8,
       4,     5,     4,     4,     4,     3,     7,     8,     6,     6,
       6,     6,     4,     5,     3,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     1,     3,     3,
       1,     0,     1,     3,     6,     8,     8,    13,     1,     3,
       5,     6,     4,     7,     2,     1,     0,     2,     0,     2,
       4,     0,     1,     0,     6,     8,     8,     1,     3,     5,
       5,     7,     9,     7,     9,     5,     6,     6,     4,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     3,     1,     1,
       8,     9,     9,     9,     9,     2,     0,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     3,
       4,     5,     4,     5,     3,     4,     3,     4,     1,     2,
       3,     3,     3,     3,     4,     4,     3,     3,     4,     4,
       4,     4,     1,     1,     1,     0,     7,     7,    10,     1,
       1,     2,     4,     5,     1,     3,     2,     2,     2,     2,
       1,     2,     2,     4,     3,     2,     2,     2,     3,     2,
       2,     5,     5,     5,     1,     3,     1,     2,     3,     0,
       1,     3,     2,     6,     6,     9,     3,     0,     3,     0,
       5,     2,     0,     3,     3,     3,     7,     7,    10,     1,
       1,     1,    14,     1,     0,     1,     0,     1,     0,     2,
       0,     1,     3,     5,     5,     7,     2,     0,     1,     2,
       0,     1,     1,     0,     1,     1,     0,     9,    12,     7,
       2,     0,     3,     2,     1,     3,     3,     2,     1,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     4,     5,     1,     3,     3,     1,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     2,     2,
       2,     2,     1,     2,     2,     1,     1,     1,     3,     2,
       0,     2,     1,     3,     5,     1,     2,     1,     0,     5,
       7,     5,     7,     5,     7,     3,     5,     5,     5,     1,
       3,     2,     1,     2,     1,     2,    11,    10,    10,     2,
       2,     0,     9,     2,     0,     4,     4,     4,     1,     1,
       1,     0,     7,     6,     6,     6,     6,     6,     7,     9,
       9,     6,     6,     6,     6,     6,     7,     8,     9,     8,
       6,     6,     6,     5,     5,     8,     8,     8,     8,     6,
       9,     1,     0,     2,     0,     7,     6,     6,     6,     6,
       6,     7,     9,     9,     6,     8,     8,     8,     8,     6,
       6,     7,     6,     7,     6,     6,     6,     6,     6,     7,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,    13,     1,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     6,     8,     3,     2,     0,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       2,     1,     3,     2,     1,     0,     8,    10,     3,     4,
       4,     0,     2,     5,     2,     0,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     4,
       3,     3,     1,     0,     5,     6,     4,     2,     0,     4,
       3,     5,     6,     4,     6,     6,     5,     7,     1,     0,
       6,    11,    11,    11,    13,     9,    11,    10,     4,     2,
       5,     2,     0,     4,     5,     5,     4,     6,     1,     3,
       1,     1,     1,     1,     2,     4,     1,     1,     1,     0,
       1,     0,     1,     0,     3,     0,     3,     1,     0,     4,
       1,     1,     3,     1,     4,     3,     6,     4,     2,     4,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     0,     5,     1,
       7,     7,     7,     3,     2,     0,     3,     2,     0,     5,
       4,     3,     0,     1,     1,     1,     1,     4,     8,     3,
       0,     6,     1,     4,     2,     1,     3,     2,     3,     0,
       7,     2,     0,     5,     3,     0,     2,     2,     2,     3,
       1,     3,     1,     2,     1,     0,     8,     1,     3,     1,
       1,     3,     5,     2,     1,     3,     7,     1,     1,     0,
       3,     2,     2,     2,     0,     2,     2,     1,     1,     3,
       3,     1,     2,     4,     4,     2,     3,     5,     5,     1,
       1,     9,     1,     2,     4,     4,     4,     2,     3,     1,
       3,     6,     1,     0,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     3,     2,     1,     1,     0,     1,     1,
       0,     1,     5,     1,     0,     1,     0,     3,     1,     3,
       4,     3,     2,     2,     1,     1,     1,     0,     2,     4,
       5,     2,     3,     1,     1,     1,     1,     3,     0,     1,
       1,     1,     1,     1,     3,     0,     2,     0,     1,     3,
       1,     0,     1,     2,     4,     4,     2,     0,     2,     3,
       2,     0,     1,     3,     1,     2,     1,     2,     5,     6,
       5,     1,     2,     1,     4,     3,     4,     5,     4,     5,
       4,     5,     2,     4,     1,     2,     2,     2,     1,     1,
       0,     4,     2,     1,     2,     2,     4,     1,     3,     1,
       2,     3,     1,     2,     0,     2,     4,     0,     1,     0,
       1,     3,     3,     2,     3,     5,     6,     2,     3,     3,
       4,     0,     1,     1,     1,     1,     1,     2,     5,     1,
       1,     1,     1,     2,     3,     3,     0,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       1,     1,     1,     1,     5,     2,     1,     1,     1,     1,
       5,     2,     2,     2,     1,     3,     3,     2,     1,     0,
       3,     0,     5,     2,     5,     2,     1,     2,     3,     0,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
       3,     3,     3,     0,     1,     4,     1,     3,     3,     5,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     3,     3,     2,     3,     5,     4,
       6,     3,     5,     4,     6,     4,     6,     5,     7,     3,
       2,     4,     2,     3,     3,     4,     3,     4,     3,     4,
       5,     6,     6,     7,     6,     7,     6,     7,     3,     4,
       4,     6,     2,     3,     4,     1,     3,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     5,     6,     6,     7,     3,     4,     1,     1,     2,
       4,     1,     1,     1,     2,     2,     2,     1,     4,     5,
       6,     8,     6,     7,     7,     5,     1,     1,     4,     1,
       4,     1,     4,     1,     4,     1,     1,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     4,     4,     4,     5,     7,     7,     9,
       5,     4,     6,     5,     7,     7,     7,     2,     3,     3,
       3,     4,     0,     4,     1,     3,     3,     1,     1,     1,
       2,     2,     0,     2,     4,     4,     6,     2,     0,     1,
       3,     3,     2,     2,     0,     6,     1,     0,     3,     0,
       2,     2,     0,     1,     4,     2,     2,     2,     2,     2,
       4,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     1,
       4,     1,     4,     1,     2,     1,     2,     1,     3,     1,
       3,     1,     3,     1,     3,     3,     3,     2,     1,     3,
       3,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     3,     2,     3,     0,     3,     3,     2,     2,     1,
       0,     2,     2,     3,     2,     1,     1,     3,     5,     1,
       2,     4,     2,     0,     1,     0,     1,     2,     2,     2,
       3,     5,     1,     2,     0,     2,     1,     0,     1,     1,
       1,     3,     3,     1,     3,     3,     2,     1,     1,     1,
       3,     1,     2,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     5,
       2,     3,     6,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     4,     3,     2,
       1,     1,     1,     1,     1,     0,     8,     2,     5,     3,
       2,     2,     3,     7,     1,     1,     1,     0,     2,     2,
       1,     0,     1,     3,     1,     2,     0,     2,     0,     2,
       0,     1,     3,     4,     3,     1,     1,     1,     1,     2,
       0,     2,     4,     0,     2,     2,     2,     1,     1,     7,
       3,     1,     1,     1,     1,     2,     0,     1,     3,     3,
       3,     3,     0,     4,     5,     5,     0,     1,     1,     1,
       2,     2,     1,     2,     0,     7,     0,     5,     0,     4,
       2,     2,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     2,     1,     3,     2,
       2,     3,     0,     5,     1,     0,     5,     2,     2,     1,
       1,     1,     2,     2,     3,     1,     2,     2,     3,     3,
       4,     2,     1,     2,     1,     1,     2,     2,     3,     1,
       1,     1,     1,     0,     1,     3,     5,     0,     2,     0,
       1,     2,     3,     2,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     2,     2,     3,     0,     1,     2,     1,
       4,     3,     4,     3,     2,     1,     3,     1,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     1,     4,
       4,     4,     4,     4,     1,     0,     3,     3,     4,     1,
       3,     3,     4,     1,     3,     3,     1,     1,     1,     6,
       1,     3,     3,     6,     1,     3,     3,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     4,     1,
       1,     4,     4,     3,     0,     7,     1,     0,     0,     7,
       3,     4,     3,     1,     1,     1,     2,     3,     5,     2,
       5,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     0,     1,     2,     1,     2,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       1,     2,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     2,
       3,     1,     3,     3,     3,     3,     3,     3,     1,     1,
       0,     2,     2,     1,     1,     2,     1,     1,     1,     0,
       1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2265,     0,     2,     1,  2695,  2699,  2703,  2704,  2621,  2705,
    2706,  2671,  2672,  2673,  2674,  2675,  2676,  2677,  2678,  2679,
    2680,  2681,  2682,  2684,  2683,  2685,  2686,  2687,  2688,  2689,
    2690,  2691,  2692,  2694,  2693,  2643,  2272,  2640,  2637,  2638,
    2639,  2644,  2642,  2635,  2636,  1868,  2708,  2696,  2709,  2697,
    2698,  2700,  2701,  2670,  2702,  2710,  2711,  2712,  2707,  2715,
    2666,  2667,  2665,  2668,  2669,  2713,  2714,  2657,  2658,  2659,
    2660,  2716,  2273,  2274,  2662,  2266,  2270,  2332,  2403,  2663,
    2664,  2661,  2271,  2656,  2403,     0,  2524,  2525,  2526,     0,
    2527,  2528,  2529,  2455,  2417,  2530,     0,     0,  2531,  2532,
    2533,  2534,  2535,  2536,  2537,  2538,     0,  2539,  2540,  2541,
    2542,  2402,  2543,  2544,  2545,  2546,  2547,  2379,  2385,  2508,
       0,  2359,  2360,  2356,  2358,  2357,  2361,  2344,  1135,   538,
    1217,  1216,     0,  2169,  1135,  2125,  2126,  2170,  2127,  2128,
    2129,   253,     0,     0,  1219,  2130,     0,  1135,  2171,   356,
     931,  2172,  2173,  2287,     0,  2131,  2132,     0,     0,     0,
     538,  1135,     0,     0,  2133,  1353,  2134,     0,  2135,  2174,
    2175,     0,  2136,  2176,  2177,  2137,  2138,  2139,  2178,  2179,
    2180,  2140,  2181,  2182,     0,     0,  1367,     0,  2141,  2183,
    2142,  2143,     0,  2184,  2144,  2145,  2146,  2185,  2186,  2187,
    2147,  2148,  2149,     0,  2150,     0,     0,     0,     0,     0,
    2188,  1135,  2151,     0,     0,  1374,     0,  2152,     0,  2189,
    2153,     0,  2154,     0,  2155,  2156,  2157,  2158,  1367,  2504,
    2380,     0,  1221,     0,  2159,  2190,     0,  2160,  2161,  2162,
    2163,  2164,  2165,  2166,  2167,  2168,     0,     0,    59,    60,
      22,    21,    27,    26,    84,    85,    47,    14,    73,    54,
     118,   117,   119,    35,    30,    67,    19,    20,    32,    36,
      56,    55,    18,    53,    79,    57,    82,    42,     8,     9,
      43,    71,    10,    44,    72,    11,    45,    12,    61,    86,
      25,    58,    83,    38,    69,    65,     7,    50,    51,    52,
      76,    77,    78,   101,    81,   113,    34,   110,    91,    92,
     107,    93,   108,     5,    94,    46,    13,   104,   103,   105,
      68,    39,    70,   102,   106,    16,    17,   109,    80,    99,
      96,   114,   112,   120,    97,    62,     3,     4,    87,    41,
       6,    24,    23,    40,    33,   116,    28,  1219,    29,    49,
      15,    75,    48,    74,    90,    89,    31,   100,    88,    95,
      66,    98,   115,    64,   111,  1340,  1327,  1376,  1339,  1352,
       0,  1342,  2600,  2601,    37,  1353,   122,   123,   128,  2269,
    2321,  2322,  2323,  2403,  2354,  2355,  2348,  2364,  2374,  2363,
    2367,  2375,  2362,  2381,     0,   125,   127,   129,   132,   126,
     121,   124,   131,   136,   130,   135,   133,   134,   137,   138,
     139,  2602,  1553,  2599,    63,  2339,  2338,     0,  2403,     0,
    2548,  2549,  2550,  2551,  2552,  2553,  2603,  2604,  2605,  2606,
    2607,  2609,  2608,  2632,  1874,  1875,  1876,  1877,  1878,  1879,
    1880,  1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,  1889,
    1890,  1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,
    2575,  1900,  1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,
    1909,  1910,  1911,  2612,  1912,  1913,  1914,  1915,  1916,  1917,
    1918,  1919,  1920,  1921,  1922,  1923,  2613,  1924,  1925,  1926,
    1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,
    1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,  1946,
    1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,
    1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,
    2614,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,
    1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
    1996,  1997,  1998,  1999,  2615,  2000,  2001,  2002,  2616,  2003,
    2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,
    2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2027,  2028,  2029,  2032,  2030,  2031,  2033,
    2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,
    2044,  2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,
    2054,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,
    2064,  2065,  2066,  2617,  2067,  2068,  2069,  2070,  2071,  2072,
    2073,  2074,  2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,
    2083,  2084,  2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,
    2093,  2094,  2287,  2095,  2096,  2097,  2098,  2099,  2100,  2101,
    2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,
    2112,  2576,  2113,  2114,  2115,  2116,  2117,  2118,  2119,  2120,
    2121,  2122,  2618,  2123,  2124,  2305,  2610,  2572,  2280,  2301,
    2573,  2522,  2523,  1869,  2574,  2571,  2611,  2307,  2628,  2306,
    2570,  2454,     0,     0,  2416,  2415,  2419,  2418,  2420,  2413,
    2414,  1846,  2308,  2424,  2423,  1317,  2627,  1845,  1318,     0,
    2426,  2554,  2555,  2556,  2557,  2559,  2558,  2560,  2191,  2192,
    2193,  2194,  2195,  2196,  2197,  2198,  2199,  2200,  2201,  2202,
    2585,  2203,  2204,  2205,  2598,  2206,  2207,  2586,  2208,  2209,
    2210,  2211,  2212,  2213,  2214,  2215,  2216,  2217,  2218,  2219,
    2220,  2221,  2222,  2223,  2224,  2225,  2226,  2227,  2228,  2229,
    2230,  2231,  2587,  2588,  2232,  2233,  2234,  2235,  2236,  2237,
    2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
    2248,  2249,  2250,  2251,  2252,  2253,  2254,  2589,  2255,  2256,
    2590,  2257,  2258,  2259,  2591,  2260,  2261,  2262,  2263,  2264,
    2595,  2596,  2597,  2584,  2377,  2561,  2583,  2594,  2592,  2593,
    2387,  2383,  2391,  2386,     0,     0,     0,     0,  2403,  1134,
    1133,  1119,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   537,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2277,
       0,  1145,     0,   331,   330,  1218,  1199,   538,     0,  1122,
     355,     0,     0,     0,     0,  1228,     0,     0,     0,     0,
     715,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,     0,     0,   379,   378,     0,     0,     0,   903,
     384,     0,     0,     0,     0,   526,  2286,  2281,  2291,     0,
    2284,  2285,  2570,     0,  2719,  2030,  2317,  2318,  2717,  2080,
    1319,   254,   257,   255,   256,     0,  1001,  1002,  1004,     0,
       0,  1014,   746,   747,     0,   745,   749,     0,     0,     0,
     742,     0,     0,     0,     0,     0,   748,   740,     0,   739,
       0,     0,     0,   744,     0,   741,     0,     0,  1123,     0,
    2369,  2370,  1933,  1969,  1280,   385,     0,     0,  1353,     0,
    1219,  1238,  1248,  1243,  1245,  1244,  1246,  1242,  1247,  1875,
     845,  1889,   845,  1958,   842,   843,   845,   845,   845,  2045,
       0,     0,   817,     0,   828,  1870,   845,  1871,  2628,   850,
     438,   438,   438,     0,   849,   854,   438,  1116,  1152,  1850,
    1366,     0,  1889,  1958,   818,  1115,  2095,  1272,     0,     0,
    1018,     0,  1019,     0,  2063,  1127,   240,  2568,  2072,  2155,
    2095,  2569,   236,  2563,  2564,  2566,   210,  2567,  2565,  2562,
    1879,     0,     0,   849,     0,  1124,  1125,   806,  1373,  1371,
       0,     0,     0,  1898,     0,  1912,  1994,   233,  2058,  2064,
    2072,  2155,  2095,  2122,   192,     0,   247,  2072,  2155,  2095,
       0,  1145,     0,  1343,  1453,  1841,     0,     0,  2378,  1118,
    1117,  1220,     0,  1223,     0,  1418,  2042,  1347,  1349,  1225,
    1340,     0,     0,  2268,  1214,  1370,  1370,     0,  1370,     0,
    1332,  1340,  1335,  1339,     0,     0,     0,     0,  1135,     0,
    2346,  2374,  2353,  2409,  2350,     0,     0,  2399,  2395,  2392,
    2400,  2401,  2394,  2382,  1542,  1543,  1544,  1541,  1554,  1540,
       0,  2327,  1545,  2366,  2333,     0,  2341,  2340,  2645,  2646,
    2456,  2279,  2298,     0,     0,     0,     0,     0,     0,     0,
    2425,  2427,  2429,  2389,  2388,  2384,     0,     0,     0,     0,
    2514,  2515,  2513,     0,  2510,  2512,     0,  2409,     0,  2579,
    2573,  2582,     0,  1851,  2574,  2571,  2570,     0,   756,     0,
     143,   892,     0,     0,     0,  1845,     0,     0,     0,     0,
       0,     0,     0,   469,  1230,  1746,  1902,  1954,  1756,  1754,
    1755,  1748,  1749,  1750,  1751,  1752,  1753,     0,   999,  1747,
       0,   143,     0,     0,     0,     0,     0,     0,     0,     0,
    1997,   143,     0,     0,     0,  1139,     0,     0,     0,  1141,
    1144,  1120,     0,  1202,     0,  1841,     0,     0,   790,   781,
       0,   791,   782,   787,   793,     0,     0,   784,     0,     0,
     794,     0,   783,   785,   796,   786,   792,     0,     0,   788,
     789,     0,     0,  1131,   438,     0,     0,     0,  1226,  1227,
       0,     0,     0,   143,  1189,  1968,   143,     0,     0,   383,
     382,   143,   381,   380,     0,   469,  1902,  1954,     0,   930,
     143,     0,   185,   606,   541,     0,     0,   675,  1997,   143,
       0,     0,     0,     0,   906,     0,     0,   525,   538,     0,
    2290,  2296,     0,  2288,  2457,  2720,  2718,  2412,     0,  1005,
     234,   235,  1003,  1968,     0,   309,     0,     0,  1968,  1180,
       0,   743,  1968,     0,  1968,   178,  1843,     0,  1235,  1902,
    1954,  1968,     0,     0,  1968,   170,  1968,     0,  1968,   309,
    1968,   542,     0,  1968,     0,  1968,  1997,   172,     0,  1968,
     309,   754,     0,     0,  2650,  2654,     0,  2652,  2647,  2368,
       0,  2422,  2421,  2320,     0,  2730,     0,  1319,  1240,  2576,
    1254,  1253,     0,  1249,  1257,  1252,  1353,   845,   844,     0,
     845,     0,  2739,   845,     0,   845,     0,  2739,   845,     0,
       0,     0,   845,  1872,  1873,     0,     0,  2738,  2736,  2737,
     819,   829,     0,   851,     0,     0,   858,   857,   856,     0,
       0,     0,   859,  1457,  1295,     0,   826,     0,   824,     0,
    1113,  1130,     0,     0,     0,     0,  1021,  1021,  1021,  1126,
     239,   237,     0,     0,     0,     0,     0,     0,  1132,     0,
       0,     0,     0,  2634,  1857,  1757,  2633,     0,  2126,  2127,
    2128,  1815,     0,  2575,  2129,  2130,  1669,  1656,  1665,  1670,
    1657,  1659,  1666,  2131,  2132,  1939,  2133,  2134,  1864,  2135,
    2136,  1497,  2138,  2139,  2140,  1661,  1663,  2141,  2142,     0,
    1865,  2144,  2145,  2017,  2147,  2148,  2150,  2151,  1667,  2153,
    2154,  2155,  2156,  2157,  2158,  1863,     0,  1668,  2159,  2161,
    2162,  2163,  2164,  2165,  2166,  2167,  2168,     0,     0,  1838,
       0,  1643,     0,  1489,  1490,  1512,  1513,  1491,  1518,  1519,
    1531,  1492,     0,  1837,  1556,  1642,  1647,     0,  1641,  1637,
    1356,  1833,     0,  1638,  1853,  1816,  1867,  1866,  2628,  1824,
    1856,  1854,  1855,     0,     0,     0,   203,     0,     0,  2503,
     249,     0,   250,  1839,  2072,   193,   232,   205,   231,   206,
     204,     0,  1900,   194,     0,   201,     0,     0,     0,     0,
       0,     0,     0,   243,  1121,     0,  1455,  1454,     0,     0,
    1822,  1842,   763,     0,  1212,  1213,  1211,     0,  1208,  1210,
    1222,  1219,  1829,  1828,  1830,     0,  1348,     0,     0,     0,
    1330,  1329,  1225,  1368,  1369,     0,     0,     0,     0,     0,
       0,     0,     0,  1411,  1384,  1385,  1387,  1408,  1412,     0,
    1336,     0,     0,  1459,     0,  1419,  2267,  2409,  2410,     0,
    2404,     0,  2403,  2403,  2397,  2396,  2393,     0,     0,     0,
       0,     0,     0,     0,  2324,   520,  2326,   518,     0,     0,
    2300,     0,  2304,  2302,     0,  2449,  2452,     0,  2450,  2451,
    2453,     0,  2458,  2459,     0,     0,     0,  2641,     0,     0,
    2440,  2428,  2435,  2437,  2439,  2438,  2447,  2443,  2446,  2448,
    2390,  2403,  2521,     0,  2516,  2519,     0,  2511,     0,     0,
       0,  1852,     0,     0,     0,     0,   757,     0,     0,     0,
       0,     0,     0,   142,  1178,   242,  1176,     0,     0,     0,
       0,     0,  1183,     0,   176,   177,   553,   538,     0,     0,
       0,     0,     0,   963,     0,     0,     0,     0,     0,     0,
     964,   962,   965,   972,   985,   988,     0,   882,     0,     0,
       0,  1052,     0,     0,  1052,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   259,   262,   304,     0,
       0,     0,  1234,     0,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,   505,   517,     0,     0,     0,
       0,     0,   514,     0,   143,   260,   499,   502,     0,     0,
     615,   614,  1052,     0,   258,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     323,   324,     0,     0,     0,   147,   169,     0,     0,   261,
       0,  2334,     0,  1140,  1137,  1138,     0,  1143,  1021,     0,
       0,     0,  1198,     0,     0,     0,     0,     0,   795,     0,
       0,  1902,  1954,     0,     0,     0,     0,     0,     0,   358,
     337,   338,   143,   336,     0,     0,   672,     0,  1500,  1529,
    1507,  1529,  1529,  1496,  1496,  1509,  1498,  1536,     0,  1529,
    1496,  1501,     0,  1499,  1539,  1539,  1524,     0,  1481,  1482,
    1483,  1484,  1510,  1511,  1485,  1516,  1517,  1486,  1553,  2580,
    1496,  2581,  2578,  2577,     0,     0,   682,     0,  1155,  1188,
       0,     0,   547,     0,  1968,     0,   145,     0,  1231,  1229,
     716,     0,   673,     0,   145,     0,   181,     0,   610,     0,
       0,     0,     0,     0,     0,   634,   633,     0,     0,     0,
     674,     0,   145,   501,  1968,     0,   491,   438,     0,   905,
     908,     0,     0,     0,  2294,  2289,  2292,     0,  2282,  2296,
    1322,  1324,  1323,     0,  1321,     0,   309,   307,   308,   670,
    1013,     0,     0,     0,     0,   309,     0,     0,  1237,  1968,
       0,  1968,     0,     0,   309,   309,     0,     0,     0,     0,
     611,     0,   753,   751,   750,   752,     0,     0,     0,     0,
       0,  1968,   309,     0,     0,   738,  2648,     0,     0,  2651,
       0,  2371,  1233,     0,  1767,     0,  2733,  1277,  2734,     0,
       0,  1353,     0,   221,   222,   220,  1255,   223,  1256,  1251,
    1239,     0,   837,     0,  2739,  2740,   822,     0,   832,     0,
    2739,   820,     0,   833,   830,   831,     0,     0,     0,  2735,
    2619,  2625,   836,     0,     0,   439,   441,     0,     0,  1923,
       0,  1959,  1986,  1987,  2064,  2068,     0,  2090,     0,   860,
     887,   855,     0,     0,  1305,   827,   825,  1114,  1270,  1773,
       0,  1353,     0,  1020,  1017,  1016,  1015,   238,   211,     0,
       0,     0,   889,  2063,  1129,   805,   538,     0,     0,  1645,
    1646,  1528,  1515,  1814,     0,     0,  1523,  1522,     0,     0,
       0,     0,  1505,  1504,  1503,  1644,  1781,     0,  1502,     0,
       0,     0,     0,  1529,  1529,  1527,  1576,     0,  1506,     0,
       0,  1794,     0,  1800,     0,     0,     0,  1535,     0,  1533,
       0,     0,  1612,     0,     0,     0,     0,     0,     0,     0,
       0,  1560,  1561,  1643,  1767,     0,  1860,     0,     0,  1521,
       0,  1553,  1757,     0,     0,     0,     0,  1827,     0,  1765,
       0,     0,  1590,  1763,     0,  1592,     0,     0,     0,  1756,
    1754,  1755,  1748,  1749,  1750,  1751,  1752,  1753,  1761,  1573,
       0,  1836,     0,  1572,     0,     0,  1421,  1355,     0,  1858,
    1817,     0,  2626,  2629,  1639,  2500,  2499,  2498,  2497,  2468,
       0,  2462,  2463,     0,  2501,  2502,   251,   252,   248,     0,
       0,   208,   207,     0,   229,   230,   200,   228,     0,   224,
     225,  1709,  1708,   209,   199,   197,   195,   212,   214,   215,
     198,   196,   246,   244,     0,     0,     0,  1819,  1818,  1848,
    1823,     0,     0,   309,  2403,  1206,     0,  1203,  1832,     0,
    1350,     0,     0,  1215,  1346,  1345,  1377,  1378,   923,  1344,
    1402,  1403,  1398,     0,  1417,  1417,  1394,  1388,  1393,  1391,
       0,  1395,  1556,  1410,  1334,  1382,  1383,  1386,  1333,     0,
    1413,  1411,  1387,  1292,     0,     0,  1460,     0,     0,  2411,
    2409,  2349,  1481,  2403,  2342,  2403,  2398,  2330,  1547,  1548,
    1549,  1550,  1551,  1552,  2331,     0,  2328,  1546,  2329,   519,
       0,     0,     0,  2297,     0,  2278,  2303,  2434,  2543,  2466,
       0,  2467,     0,     0,  2431,     0,  2441,  2444,  2442,  2445,
       0,  1481,  2622,  2517,  2622,  1481,     0,     0,     0,     0,
       0,     0,     0,     0,   758,     0,     0,     0,     0,     0,
       0,  2090,   241,  1174,     0,     0,     0,     0,   891,   890,
       0,     0,   910,     0,     0,     0,  1186,   429,     0,   306,
       0,     0,     0,     0,     0,     0,   551,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   585,  1052,     0,   623,     0,   970,     0,
       0,     0,     0,   971,   968,   969,  2064,   987,   986,   984,
     945,   947,   946,     0,   949,   933,     0,   934,     0,     0,
     944,   952,   950,     0,     0,     0,  1947,   264,   276,     0,
    1051,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   296,     0,   299,   298,     0,     0,     0,     0,   303,
       0,     0,     0,   302,     0,     0,     0,   467,   466,   468,
       0,     0,     0,     0,     0,     0,  1000,     0,     0,   164,
     167,     0,     0,   504,   516,     0,   508,   509,   506,   510,
     511,     0,     0,     0,     0,     0,     0,   503,     0,   608,
     607,   613,     0,     0,     0,     0,     0,  1044,  1043,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   625,   626,     0,   627,     0,   168,     0,
       0,     0,     0,     0,     0,   219,  1136,  1142,  1265,  1265,
    1265,  1201,  1849,  1200,     0,     0,     0,   797,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   342,     0,   697,  2577,   671,     0,
    1481,     0,  1477,  1473,  1542,  1541,  1540,     0,  1487,  1496,
    1493,   683,     0,   685,   688,     0,  1153,   402,     0,   544,
     585,     0,     0,     0,   174,     0,     0,     0,     0,   141,
     185,   385,     0,   184,   186,   188,   189,   190,   187,   191,
     605,   609,     0,   540,     0,     0,     0,     0,     0,   635,
     639,   638,   642,   640,     0,   636,     0,  1469,     0,   163,
     498,   500,     0,  2275,     0,   387,   469,     0,     0,     0,
     907,     0,     0,     0,     0,     0,  2295,     0,     0,     0,
       0,  1320,     0,   991,     0,  1181,  1968,   309,     0,   989,
     179,  1844,     0,     0,     0,     0,     0,   993,   735,   171,
       0,   309,   309,   543,     0,   309,   173,     0,     0,     0,
     535,   309,   755,  2649,  2655,  2653,     0,  1258,  1259,  1279,
       0,  2731,  2732,   491,  1324,  1241,  1250,   834,   841,   823,
     840,   839,   821,   838,   835,  2433,     0,     0,  2624,     0,
     852,     0,   437,     0,     0,     0,   866,     0,     0,   865,
     880,   867,     0,   869,   862,   861,   870,     0,     0,   889,
       0,  1302,     0,  1300,     0,  1458,  1304,  1293,  1271,     0,
    1269,  1274,  1276,  1275,  1273,     0,     0,     0,   849,     0,
       0,   309,  1128,     0,   807,   812,     0,     0,     0,   809,
     810,   811,   813,   814,     0,     0,     0,  1777,     0,  1778,
       0,     0,     0,  1813,  1809,     0,     0,     0,     0,     0,
    1785,  1786,  1787,  1784,  1788,  1783,     0,     0,  1789,  1782,
       0,     0,     0,     0,     0,  1526,  1525,     0,     0,     0,
       0,     0,     0,     0,  1615,  1647,     0,     0,  1741,     0,
    1767,  1799,     0,     0,  1537,     0,     0,     0,     0,     0,
       0,     0,  1767,  1805,     0,     0,     0,     0,  1707,     0,
    1704,     0,     0,     0,     0,  1824,     0,     0,     0,     0,
    1861,  1557,  1574,  1835,     0,  1826,     0,     0,  1558,  1581,
       0,  1806,  1608,     0,  1613,  1596,     0,  1589,     0,  1594,
    1598,  1577,  1827,  1766,     0,  1764,     0,     0,  1575,     0,
    1570,  1568,  1569,  1562,  1563,  1564,  1565,  1566,  1567,  1571,
    1745,  1743,  1744,     0,     0,     0,  1593,  1961,  1994,     0,
    1367,  1367,  1367,  1354,  1365,  1834,     0,  1464,     0,     0,
       0,     0,  1724,     0,  1771,     0,  1769,  1851,  2631,  2630,
    1825,     0,     0,     0,  1840,     0,     0,  1553,     0,   245,
    1456,  1820,     0,   761,   762,   760,  1481,  1225,  1209,  1205,
    1204,  1831,  1224,  1353,     0,   921,   922,     0,   926,     0,
       0,  1396,  1409,     0,  1305,  1305,     0,  1400,  1401,  1392,
    1338,  1337,     0,  1467,     0,     0,  1289,  1282,  1461,     0,
    1421,  1307,  1309,  1310,     0,  1824,  2347,  2405,  2352,  2373,
    2343,  2376,  1555,  2325,  2365,     0,  2299,  2469,  2470,     0,
    2460,  2461,  2430,  2436,  2507,     0,  2623,     0,     0,   695,
     694,     0,     0,     0,  1074,  1023,  1056,   759,  1075,  1024,
    1057,  1076,  1025,  1175,     0,  1177,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     660,   309,  1184,  1077,   305,  1185,  1058,  1059,     0,   552,
       0,     0,   557,   558,   559,     0,     0,   560,  1902,  1954,
       0,   565,   571,   575,   566,     0,   576,   572,     0,     0,
       0,     0,     0,   582,   584,     0,     0,     0,     0,     0,
     966,   967,  1078,  1026,     0,  1060,   948,  1496,   932,     0,
       0,   943,     0,   942,  1496,  1496,  1027,   175,   265,   402,
    1054,   282,   295,   290,   291,   289,  1968,   309,  1968,   309,
       0,     0,     0,     0,   292,   287,   288,   284,   297,  1878,
    1940,  2073,     0,   595,   597,     0,   602,   300,  1035,     0,
     317,   320,   301,   280,   283,   281,   277,   263,     0,     0,
    1847,     0,     0,   995,     0,     0,     0,   166,  1040,     0,
       0,   152,     0,     0,     0,     0,   146,   156,  1084,  1031,
     507,   512,  1033,   515,  1069,   513,  1090,  1032,     0,  1064,
    1086,  1042,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1190,     0,     0,     0,     0,     0,   309,     0,   704,
    1054,  1968,   309,  1085,     0,  1049,  1072,     0,   325,     0,
    1041,  1034,  1070,     0,     0,   217,   216,   218,     0,  1268,
    1268,  1268,     0,     0,     0,     0,     0,     0,     0,     0,
     799,   770,   798,     0,     0,     0,     0,     0,     0,     0,
     764,   357,   334,   335,     0,     0,   333,   339,   696,     0,
       0,     0,  1478,  1474,     0,     0,     0,     0,     0,     0,
    1494,   684,     0,     0,     0,     0,  1173,  1173,  1173,  1173,
    1173,  1173,  1173,  1154,  1182,   143,     0,     0,     0,   546,
     584,   591,     0,   619,   622,     0,   620,     0,     0,     0,
       0,     0,   157,   144,  1236,     0,   724,   438,   180,     0,
       0,     0,   539,   681,   679,   678,   680,     0,     0,     0,
     701,     0,  1468,  1470,     0,     0,     0,     0,   389,     0,
       0,   386,   390,   394,   395,   396,     0,   492,   494,   473,
       0,     0,     0,   937,     0,   955,   938,     0,     0,     0,
     975,   980,   976,   958,     0,   523,  2293,  2287,  1325,  1326,
       0,   309,     0,     0,   586,   309,     0,   309,     0,   309,
     309,     0,  1111,   612,     0,   667,     0,     0,   309,   737,
    1232,  1768,     0,     0,  2432,  2620,   853,   440,     0,     0,
       0,     0,   864,     0,   521,   868,     0,   879,   874,   876,
       0,   883,  1303,  1296,  1298,  1297,     0,     0,  1294,  1774,
     736,     0,     0,   309,     0,   884,     0,   808,     0,     0,
       0,     0,  1372,  1775,  1776,     0,     0,     0,     0,  1810,
       0,     0,  1682,  1658,  1660,  1495,  1672,     0,  1508,  1683,
    1684,  1662,  1664,     0,  1758,     0,     0,  1673,  1617,  1618,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1630,  1629,  1674,  1740,     0,     0,  1797,
    1798,  1675,  1538,  1539,  1539,     0,     0,  1804,     0,     0,
       0,  1680,  1685,     0,     0,     0,     0,  1691,     0,  1712,
       0,     0,     0,  1640,  1768,  1530,  1531,     0,     0,     0,
       0,     0,     0,     0,     0,  1614,  1597,  1591,     0,  1595,
    1599,     0,     0,     0,     0,  1583,  1609,  1579,     0,     0,
    1585,     0,  1610,  1367,  1367,  1367,  1367,  1364,     0,     0,
       0,     0,  1431,  1420,  1422,  1433,  1424,  1426,  1462,     0,
    1841,     0,  1405,  1376,  1376,     0,  1724,     0,  1648,     0,
    1724,     0,     0,  2482,  2484,  2485,  2486,  2487,  2488,  2490,
    2491,  2493,  2494,  2495,  2483,  2489,  2492,  2496,  2473,  2474,
       0,  2464,  2465,   202,     0,   226,   213,     0,  2507,  1207,
       0,  1379,     0,  1759,   926,   924,   925,  1381,     0,     0,
    1416,  1415,  1414,  1389,  1291,     0,  1289,  1284,     0,  1285,
    1824,     0,  1281,  1314,     0,     0,  1467,     0,  1313,     0,
    2407,  2335,     0,     0,  2506,  2509,  2520,  2518,  2345,  1073,
    1022,  1055,  1173,   894,   895,     0,   893,     0,     0,     0,
     428,   909,     0,     0,     0,   660,     0,     0,   432,  1187,
     554,   555,     0,     0,   573,     0,     0,   562,     0,     0,
       0,     0,   561,   578,   527,   579,   581,     0,   580,   583,
     588,  1036,     0,  1071,   960,     0,  1496,   935,   940,   941,
       0,   399,     0,     0,     0,   266,     0,     0,   279,     0,
     274,   293,   285,   294,   286,   599,   600,   598,   594,     0,
     601,   603,   314,     0,     0,     0,  1080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1081,  1061,
       0,     0,   149,   148,     0,   155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   326,   311,     0,     0,     0,     0,     0,   328,
       0,     0,  1079,  1028,  1923,  1264,     0,  1262,  1260,  1261,
     765,     0,     0,   766,   774,     0,     0,   767,     0,     0,
       0,     0,     0,     0,   776,   360,     0,   363,   370,   343,
     347,  1189,     0,  1189,     0,   348,  1189,   344,  1189,   341,
     698,     0,  2017,  1748,  1749,   692,   699,   689,   691,   690,
     693,   660,     0,     0,     0,  1479,     0,  2721,  2729,  2728,
       0,  1553,   686,   687,     0,  1173,  1172,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   414,     0,
       0,   408,     0,     0,   980,   401,   404,   405,   547,   550,
     548,   549,     0,   577,     0,   618,     0,   591,   159,     0,
       0,   160,   158,     0,     0,   385,     0,     0,   641,   644,
     637,     0,   700,   702,   676,     0,   591,     0,  1280,   497,
       0,   469,   421,   465,     0,   490,     0,     0,   475,  1151,
       0,   910,   936,     0,     0,     0,   973,   977,   974,     0,
       0,   951,     0,   959,   929,  1106,  1107,  1104,  1105,     0,
       0,  2310,  1316,  2319,   992,     0,   309,   990,     0,   731,
       0,   733,   994,   309,   309,   628,     0,   536,   494,     0,
       0,     0,     0,   863,   881,     0,   877,     0,     0,   846,
     886,  1301,  1299,   889,     0,   847,   888,     0,     0,     0,
       0,     0,  1779,  1514,     0,  1812,  1808,     0,  1780,     0,
    1792,  1791,  1616,  1793,     0,  1635,     0,     0,  1627,  1625,
    1626,  1619,  1620,  1621,  1622,  1623,  1624,  1628,  1802,  1801,
    1795,  1796,  1534,  1532,     0,  1677,  1678,  1679,  1803,  1686,
       0,  1893,  1713,  1690,  1706,  1705,     0,     0,     0,  1693,
       0,     0,  1702,     0,  1742,  1520,  1553,  1559,     0,     0,
    1582,  1807,  1600,     0,     0,     0,  1578,     0,     0,     0,
       0,  1587,  1758,     0,     0,     0,     0,     0,     0,  1358,
    1357,  1363,  1340,     0,  1433,     0,  1432,  1444,     0,     0,
    1450,  1448,     0,  1450,     0,  1450,     0,  1425,     0,  1427,
    1444,     0,  1842,  1463,     0,  1407,     0,     0,  1375,     0,
    1724,  1655,  1727,  1722,  1723,  1772,  1649,  1859,     0,  1770,
    1724,     0,     0,     0,  1821,  2505,  1351,     0,  1380,  1397,
    1390,     0,  1465,  1290,     0,     0,  1287,     0,     0,     0,
    1308,  1289,  1311,  2351,     0,  2406,  2471,  2472,     0,   900,
     901,   899,     0,     0,     0,   660,     0,     0,   446,     0,
     917,   917,     0,     0,   434,   488,   980,   663,     0,     0,
     661,     0,   574,     0,     0,   570,   568,   567,   569,   528,
    1089,     0,   961,     0,   953,     0,   271,  1053,     0,     0,
       0,   270,     0,   309,   309,   596,   318,   319,   322,     0,
       0,     0,     0,     0,     0,   725,   708,     0,     0,   726,
     727,     0,     0,     0,   997,   998,   996,   153,   150,   151,
     154,  1037,     0,     0,     0,     0,     0,  1088,  1048,  1068,
    1087,  1046,  1066,  1045,  1065,  1047,  1067,  1039,     0,  1472,
     706,   705,     0,   309,   309,   630,  1263,     0,  1267,     0,
     768,     0,     0,   769,   780,   778,   777,   779,   771,   361,
     143,     0,   340,     0,   368,     0,   366,   365,   367,     0,
     354,     0,     0,     0,     0,     0,   669,     0,     0,     0,
    1475,     0,     0,     0,     0,     0,     0,  1480,  1488,   659,
       0,  1164,  1163,  1162,  1166,  1165,  1168,  1167,  1159,  1158,
    1171,  1170,  1157,  1156,  1161,  1160,     0,   406,     0,   412,
     416,   417,   415,   407,   980,   438,   487,   545,     0,     0,
     621,   616,   162,   161,     0,     0,     0,     0,   646,   650,
     677,     0,  1471,   624,     0,   387,  1278,     0,  2276,     0,
     392,   397,   398,     0,   473,   418,     0,   469,   391,   493,
       0,     0,   482,     0,  1146,     0,     0,   939,   956,   957,
       0,     0,   980,   979,     0,   530,     0,  2283,   309,   587,
     309,   309,  1112,   668,     0,   873,   872,   871,   522,     0,
     875,   309,     0,     0,     0,     0,     0,   816,   800,   815,
    1811,  1671,  1681,  1790,     0,     0,  1636,     0,     0,  1676,
    2160,     0,     0,     0,     0,  1710,  1711,  1692,     0,  2007,
    1697,     0,     0,     0,  1862,  1606,  1604,  1601,     0,  1602,
       0,     0,  1584,  1580,     0,  1586,  1611,  1362,  1361,  1360,
    1359,  1435,  1442,     0,  1423,     0,  1449,  1445,     0,  1446,
       0,     0,  1447,     0,     0,  1442,     0,     0,     0,     0,
    1718,  1724,  1724,  1650,  1729,  1726,     0,  1652,  2475,     0,
    2478,  2476,  2477,  2481,  1553,     0,     0,  1283,  1286,  1288,
       0,  1315,  1306,  2408,  1179,     0,     0,     0,   430,     0,
     980,     0,     0,     0,   920,   920,     0,   980,   487,   665,
     664,   662,   666,     0,   563,   564,  1038,   954,   267,   268,
     269,   272,   311,   278,   273,     0,  1082,  1029,  1062,     0,
       0,   714,     0,     0,     0,     0,  1083,  1030,  1063,     0,
       0,     0,  1195,     0,   310,   311,   327,  1050,  1266,     0,
     772,   773,   342,     0,   364,   373,     0,   371,   345,   350,
       0,   352,   351,   346,   349,  1476,     0,  1011,  1011,  2722,
    2723,  2724,  2725,  2726,  2727,     0,   660,  1169,     0,     0,
     403,   487,   445,     0,   409,     0,   592,     0,     0,  1151,
     387,   591,   645,     0,     0,     0,   703,   389,     0,   495,
       0,   388,     0,     0,   475,     0,     0,     0,   473,     0,
     470,     0,   474,     0,     0,   485,     0,     0,     0,     0,
       0,   978,     0,   982,     0,   950,   927,  1464,     0,   534,
    2309,  2313,  1012,   732,   734,   629,   878,   885,   309,   801,
     802,   803,   804,  1631,     0,     0,     0,     0,  1687,     0,
    1688,  1715,  1714,  1694,  1698,     0,  1695,  1696,  1603,  1607,
    1605,  1588,  1434,     0,     0,  1436,     0,     0,  1438,  1440,
       0,     0,     0,     0,     0,  1845,  1724,  1404,  1406,     0,
    1341,  1653,  1654,     0,  1376,  1724,  2480,  2479,   227,  1760,
    1466,  1312,   879,     0,   309,   917,   487,   447,  2017,   448,
     916,     0,   918,   923,   923,     0,   487,   660,   556,   313,
     321,     0,     0,   721,   709,     0,     0,   728,     0,     0,
       0,     0,     0,   309,   775,   332,   359,   369,     0,   353,
    1011,     0,  1008,  1007,   658,     0,   411,   410,     0,   456,
       0,   590,     0,   591,   718,  1147,   604,   647,   648,   643,
       0,     0,   469,   465,   496,   393,   402,   482,   427,   426,
     423,   422,   424,   425,   420,   419,     0,   475,   471,   472,
     476,     0,     0,   489,     0,  1148,     0,  1197,     0,   911,
     981,     0,     0,     0,   529,     0,     0,   533,   524,     0,
    2311,   848,  1632,     0,  1633,     0,     0,     0,  1700,  1699,
       0,  1443,  1452,     0,  1439,  1437,  1428,     0,  1430,  1717,
    1719,     0,     0,  1732,  1651,   896,     0,   897,   920,   451,
       0,   919,   926,   926,   438,   660,   431,     0,   275,     0,
     712,     0,   723,   721,     0,     0,  1191,     0,  1192,  1193,
    1196,   329,   372,  1006,  1010,  1009,     0,   442,   443,   444,
       0,   413,   452,   453,     0,   593,   617,     0,     0,     0,
       0,   473,   469,   400,   485,   464,   482,   477,     0,   480,
       0,     0,     0,     0,  1149,  1150,   316,     0,   980,   983,
    1110,   532,   531,  2314,  2316,  2315,     0,  1634,  1703,  1689,
    1716,  1701,  1441,     0,  1429,     0,     0,  1728,     0,     0,
       0,     0,   923,     0,   660,     0,   914,   913,   445,   433,
     312,     0,     0,   719,   722,   710,   723,   730,   729,     0,
       0,     0,     0,     0,   454,     0,   455,   486,   717,     0,
     649,     0,   475,   473,   376,   485,     0,   481,   478,   484,
     483,     0,   475,   912,   928,  1109,  1108,  1353,  2312,  1451,
    1720,  1721,  2125,     0,  2100,     0,  1730,  1733,  1731,  1725,
     309,   926,     0,   435,   449,   456,     0,     0,   711,  1194,
     650,   461,     0,   460,     0,   458,   457,   707,   653,   482,
     475,   374,     0,   315,  1464,  1092,  1353,  1091,  1093,  1101,
    1098,  1100,  1099,  1097,     0,  1737,  1736,  1735,  1739,  1738,
     898,   915,     0,   660,   713,   720,     0,   459,   463,   462,
       0,   651,   654,   657,   655,   656,   485,   482,   479,   902,
       0,  1102,  1096,  1340,  1327,     0,   450,   436,     0,   631,
       0,   377,   485,  1094,  1353,  1734,     0,   652,   375,  1095,
       0,   653,     0,   632
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1724,  2604,  2489,  3272,  3273,   249,
     250,  1791,   251,   252,   253,   254,   255,   256,   257,  1737,
     258,   259,  1301,  1936,  2613,   260,  2372,  1075,  2246,  2247,
    2546,  2248,  2236,  1577,  2037,  1725,  1753,   262,   263,  1571,
    2228,   264,   265,   266,  1776,  1777,  1732,  1979,  4139,  4708,
    2473,  4822,  3119,  3120,   267,  1830,  1831,   268,   269,  3224,
    1872,  3226,  3227,  3749,   881,  2573,  4160,  4161,  3736,  3737,
    4167,  4436,  4437,   270,  1933,  3300,  3831,  3301,  4239,  3302,
    4240,  3303,  4241,  3254,  3795,  3796,  3797,  3304,  4245,  4644,
    3305,  2387,  1426,  2064,  2065,  4619,  4057,  4058,  4784,  4731,
    4732,  4733,  4855,  4247,  1782,  3838,  4252,  4494,  4495,  4653,
    4464,  3030,  1955,  2646,  3306,  3307,  4238,   271,   272,  2640,
    1806,  1807,  2495,  3755,  3365,   273,  1318,  3623,  4509,  4667,
    4668,   274,   868,   275,  1940,   276,   277,  2599,  3259,   278,
    2396,  3039,   279,   280,  3063,  3064,  3065,   281,   282,  3803,
    4465,  1778,  3112,  3113,  3114,  3115,  3660,   283,  1938,  1811,
    2622,   284,   285,   286,  2603,  3265,  3266,   287,   288,  2535,
     289,   290,   291,  1948,  2634,  2635,  4229,  4473,  4629,  4475,
    4890,  4891,  4456,  3608,  4070,   292,   293,   294,   295,  1916,
    2592,  2593,  3756,  1710,  1876,  2575,  2576,  3821,  3822,   296,
     297,  4105,  4106,   913,  4738,  4712,  4795,   298,   299,  4109,
    4110,   300,   301,   302,   303,   304,   967,  1370,  1371,  1716,
     305,  2263,   306,  1272,  3211,   307,  1461,  2775,  4288,   308,
    1002,  1398,  1399,   309,   310,  1013,  2758,  1015,  2078,  3367,
    3368,  3889,  2729,  1198,   311,   312,  2739,  2761,   313,  1727,
    2378,  2379,  4052,   314,   914,  1960,  2649,  3025,  4658,  4059,
    4384,  4583,  2948,  3557,   315,   915,  1757,  2436,  2652,  3314,
    3315,  2438,  2913,  3850,  2440,  3316,  3321,  3322,  3323,  3846,
    3854,  4503,  4504,   316,  1755,  2429,   317,   318,   319,  1786,
    1217,   320,   936,   937,   321,  4612,   322,  1337,   323,  1033,
    2094,   324,  2451,  3646,   325,   326,   327,  4867,  4900,  4901,
    4902,  3859,  4827,   328,  4869,  1440,   330,   331,   332,   871,
    1239,  1240,  1241,   333,  4254,   334,   335,  2596,  3253,  3777,
     336,   337,  2373,  3015,   338,   339,   340,  1920,   341,   342,
     343,   344,  1852,   345,  1607,  1608,   346,   347,   876,  1093,
    1611,  1619,   348,  1278,   349,  2022,  1927,  2023,   350,   351,
     352,   353,   354,   981,  1392,  1393,  1394,  2039,   355,  2697,
     356,  3199,  3717,   357,  1444,  2750,   982,  1385,   983,  2966,
    3568,  3569,  3572,   984,  2963,   361,  2084,  2744,  2747,   985,
    2970,  2971,  2972,  2973,  2974,  3574,   986,  1004,  1328,  2660,
     987,  1531,   366,   367,   368,  1102,  1097,  1098,   370,  2206,
    2903,  1021,  1625,  1060,  1109,  4008,  2276,  2277,  2297,  2298,
    1634,  1635,  2287,  2289,  2950,  2290,  2959,  2282,  4005,  4350,
    2293,  2294,  1637,  1638,  2954,   371,  2907,  3503,  3504,  3505,
    3986,  3996,  4337,  4548,  3506,  1434,  1644,  3507,  3512,  3566,
    3291,  3292,  3293,  2441,  2583,  1898,  1532,  1899,  2590,  1533,
    2128,  1901,  1534,  1535,  1536,  1904,  1537,  1538,  1539,  1540,
    2112,  2169,  1541,  1542,  2147,  1141,  1142,  2024,  2813,  1544,
    1545,  3952,  4312,  4301,  2839,  2840,  2243,  3948,  3455,  4560,
    4689,  4690,  4016,  4013,  4354,  4564,  4780,  4836,  4837,  1546,
    2893,  2198,  1219,  1547,  3758,  2200,  2833,  2915,  2916,  2357,
    2110,  2780,  2796,  2797,  2810,  3416,  2817,  2822,  3439,  3440,
    2834,  2862,  1548,  2783,  2784,  3400,  2114,  1549,  1600,  1601,
    2214,  2857,  1614,  1615,  1095,  1550,  1551,  2079,  1084,  4544,
    1346,   717,  3129,  2258,  1244,  1018,  1552,  1553,  1554,  3369,
    1665,   696,   697,  1179,   821,     2,    75,   988,  3297,   375,
     376,   917,   918,   919,  1320,  1321,  1965,  1968,  1670,  2335,
     698,   699,   726,  4267,  4510,  4670,   974,   377,   378,   379,
     380,  1666,  2331,  1143,    76,    84,    77,  1144,   417,   418,
    2313,   381,   838,   382,  1647,  1123,  3580,   383,   384,   385,
     386,   387,   970,   388,  1125,   389,  1126,   390,   391,   392,
     393,  1133,   394,  1649,  1650,  4045,  1651,   395,   396,   719,
     720,  1383,   397,   398,  1160,  1161,  1417,  1418,  1676,  1691,
    1692,  1693,   399,   713,   400,   401,   402,  1682,  1683,   403,
    2221,  2222,  2340,  2223,   404,  2987,  2988,   405,  3538,  3539,
    4361,  3540,   406,  2217,   407,   408,  1087,  3585,   409,   834,
     410,  1174,   700,   701,   702,  1181,   824,  1046,   727,  1183,
    3116,   826,   827,   704,   705,   706,  2059,    78,  2995,  2060,
    1556,   728,  1557,  2212,  1558,  1559,  1560,  1561,  1562,  1699,
     710,  1150,  1374,  1375,  2996,  1377,    82,  1378,   414,  3770,
    2027,  1419,  2045,  2046
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4257
static const int yypact[] =
{
   -4257,   395, 20832, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, 22364, -4257,
   -4257, -4257, -4257, -4257,100788,   747, -4257, -4257, -4257, 62568,
   -4257, -4257, -4257,   263, 67958, -4257, 71388,   793, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, 75308, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, 55206,  1036, -4257,
     370, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  1402, 10699,
   -4257, -4257, 71878, -4257,   398, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,   336, 72368,   418, -4257,   722,  1059, -4257,   108,
   12092, -4257, -4257, 63548, 68938, -4257, -4257, 75798,   185,  1760,
    8526,  1402, 21871, 76288, -4257,  1828, -4257, 51734, -4257, -4257,
   -4257, 68448, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, 84128,  2680,   649, 52233, -4257, -4257,
   -4257, -4257, 84128, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, 76778, -4257,   818,   734, 84618, 85108, 65508,
   -4257,  1163, -4257, 84128,   968,   271, 54224, -4257, 85598, -4257,
   -4257,   911, -4257, 77268, -4257, -4257, -4257, -4257,   649, -4257,
   55206, 49255,   142,  1050, -4257, -4257, 86088, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257,  1314,   992, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257,   418, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257,   891, -4257,  1088,  1122,  1941,
     289,  1056, -4257, -4257, -4257, 23205, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257,102249,  1247, -4257, -4257, -4257,  1071, -4257,
    1128, -4257, -4257, -4257,  1773, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  1269, -4257, -4257, -4257, -4257,  1662,101275, 75308,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, 63058, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,   196,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, 75308, 75308, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, 75308,
    1206, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
     468,  1620, -4257, -4257, 55206,  2284,  2284,  1703,102249, -4257,
   -4257, -4257, 56188, 84128, 84128, 84128,  1566, 84128, 84128,   349,
   56188, 84128, 84128,  1631, 84128, 44751, -4257, 84128, 84128, 84128,
   84128, 77268, 84128,  1565, 84128, 84128, 86578, 84128,  1744, -4257,
    1952,  1227,  1610, -4257, -4257, -4257, 84128, 12383,  2680, -4257,
   -4257, 84128,  1629, 56188, 84128,  2680,  1573, 84128,  1661, 84128,
   -4257, 84128, 87068,   589,  1032, 84128,  1858, 77758, 45254,  1755,
   84128, 84128, 84128, 84128, -4257, -4257,  1779, 84128, 84128, -4257,
   -4257, 87558,  1583,  1993,  1909,   708, -4257, -4257,  2119,  1707,
   -4257, -4257,  2229, 75308, -4257, 72858, -4257, -4257, -4257,  2312,
   -4257, -4257, -4257, -4257, -4257, 65998,  1760, -4257, -4257, 56679,
   84128,  2067, -4257, -4257, 88048, -4257, -4257,   613, 57170, 88538,
   -4257, 78248, 45757,  2206, 89028, 89518, -4257, -4257, 90008, -4257,
   90498,  1939, 90988, -4257, 91478, -4257,  2062, 91968, -4257, 14563,
   -4257,  1833,  2026,  2160,  1872,  1508, 75308, 75308,   782, 40296,
     418, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,   269,
    1856, 52732,   851, 53231, -4257, -4257,   937,  1064,  1089,   269,
    2301,  2301,   705, 75308, -4257, -4257,  1856, -4257,    51,   -26,
    1882,  1882,  1882,  2069,   795, -4257,  1882, -4257, -4257, -4257,
   -4257, 77268, 52732, 53231, -4257,  1894,  2680,    48,  2293, 84128,
   -4257, 84128, -4257, 84128, 84128, -4257, -4257, -4257,  2314,  1961,
    2164, -4257,  1946, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
    2136,  2143,  2151,   161,  2680,  2047, -4257,  2268, -4257,  2179,
   27721,  1259, 75308,  2680, 53730, 78738, 98828,   329, 65998,  2680,
   92458,  2006,  1227,  2181, -4257,    29, -4257,  2407,  2031,  2256,
      45,  1227, 42272, -4257,  2048,  1729, 77268,102736, -4257, -4257,
   -4257, -4257,   311,  2325, 28229, -4257, 84128,  2068, -4257,  2057,
    2073,  2082,  1941, -4257, 84128,  1302,  1302,  2495,  1302,  1937,
    2137, -4257,  2010, -4257,  2378,  2358, 77268,  1050,  1402,  2188,
   -4257, -4257, -4257,  2130, -4257,  2158,  2169, -4257,   719,  2387,
   -4257, -4257, -4257, -4257,  2274,  2285,  2296,  2300,  2220,  2307,
     246, -4257, -4257, -4257, -4257,  2542, -4257, -4257, -4257, -4257,
   -4257, -4257,  2652,  2628, 63548, 63548,   808,   812,   171,   380,
   -4257, -4257, -4257,  2508, -4257, -4257,  2498, 84128,  2343, 84128,
   -4257, -4257, -4257, 92948, -4257, -4257,  2284,  2130,  2276, -4257,
     343, -4257,  1729, -4257,   456,   476,   493,    53,  2298,  1330,
    1558, -4257,   267,  2389,   151,   -43,  2341, 77268,  2409,  2319,
     314,  3396,   246,  1955, -4257, -4257, 84128, 84128, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257,  2326, -4257, -4257,
    2327,   730,  1548,  8266,  1019,  4773,  1695,   898,  2520,  1421,
    2629,  1499,  4990, 84128,  2356, -4257,  2597,  2706,     2, -4257,
     241, -4257,   765,  2434,  2568,   947, 56188,  2416, -4257, -4257,
   84128, -4257, -4257, -4257, -4257,   657, 56188, -4257,  2606, 46260,
   -4257, 84128, -4257, -4257, -4257, -4257, -4257,  2562, 84128, -4257,
   -4257,  2642, 84128, -4257,  1882,  1373,  2444,  2814, -4257, -4257,
   59625,   166, 84128,  2489,  2884,  2677,  2489,  2517, 93438, -4257,
   -4257,  2489, -4257, -4257, 84128,  1955, 84128, 84128,  2490,  1333,
    2489,  2886,  2891,  2570,  2679,  1039,   841,   110,  2803,  2489,
   84128, 93928, 84128, 84128,  2902, 56188, 84128, -4257,  2694, 79228,
   -4257,  2552,  2119, -4257, -4257, -4257, -4257, -4257,   933, -4257,
   -4257, -4257, -4257,  2846,  2276,   375,  2847,  2564,  2867, -4257,
    2607, -4257,  2878,  2319,  2880,  2582, -4257, 84128, -4257, 94418,
   94908,  2883,  2326, 84128,  2885,  2582,  2889,  2772,  2890,   375,
    2895, -4257,  1222,  2896,  2783,  2898,  1975,  2582, 66488,  2899,
     109, -4257, 19923, 14563, -4257, 23676,  1847, -4257, -4257, -4257,
   84128, -4257, -4257, -4257, 31785,   837,  2671, -4257, -4257,  1050,
   -4257, -4257,  1936, -4257, 51235, -4257,   782,  1856, -4257, 75308,
    1856, 75308,   705,  1856, 75308,  1856, 75308,   705,  1856, 75308,
   75308, 75308,  1856, -4257, -4257,  2058,  1826, -4257, -4257, -4257,
   -4257, -4257, 75308,  2608, 84128, 84128, -4257, -4257, -4257, 69428,
   84128, 69918, -4257, -4257,   197, 75308, -4257, 75308, -4257,  2680,
   -4257, -4257,  2160, 59625,  3011, 84128,  2894,  2894,  2894, -4257,
   -4257, -4257,  2837, 84128,  2900,  2901, 69428, 84128, -4257, 95398,
   65998,  2793,  2614, -4257, -4257, -4257, -4257,  1958,  2743,   424,
    2770, 31785,  2617,   302,   302,  2621, -4257, -4257, -4257,   525,
    2623,  2626, -4257,   365,   365,  2786,  2630,  2632, -4257,   405,
    2643, -4257,  2784,   569,  2644,  2647,  2648,  2404,   302, 31785,
   -4257,  2649,   365,  2653,  2654,  2656,  2792,  2660, -4257,  2835,
    2673,   231,   397,  2674,  2675, -4257,  2630, -4257,   536,  2676,
    2681,  2684,  2685,  2687,  2690,  2691,  2698, 31785, 31785, -4257,
   26705, -4257,  2680, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
     113, -4257,   606,  4970, -4257, -4257,  2796, 31785, -4257, -4257,
     541, -4257,   642, -4257, -4257,  1729, -4257, -4257,  1474, -4257,
   -4257, -4257, -4257,   694,   694,   203, -4257, 71878, 71878, -4257,
   -4257,   783,  2625, -4257,  1853, -4257, -4257, -4257, -4257, -4257,
   -4257, 64038,  3050, -4257,  1873,   241,   255,  2998, 50237, 50736,
    2917,  2917,  2903, -4257, -4257, 84128, -4257, -4257, 31785, 48273,
   -4257,  1729,   124,  2937, -4257, -4257, -4257,  1976, -4257, -4257,
   -4257,   418, -4257, 11736, -4257,  2035,  2068, 84128, 84128,  3104,
   -4257, -4257,  2057, -4257, -4257,  1941,  1941, 31785,  1941,   147,
    1412, 28737, 31785,  2987,  2887,  1217,  1495,  2991, -4257,  1937,
    2137, 77268, 84128, 95888,  2812, -4257, -4257,  2130,  2715,  2060,
   -4257, 61588,101762,101762,  2954, -4257, -4257,  1062,    47,  2826,
    2920,  2301,    67,  2197, -4257, -4257,  2711, -4257,  3047, 71878,
    2771, 63548, -4257, -4257, 84128, -4257, -4257, 79718, -4257, -4257,
   -4257,  2154,  2716, -4257,  2739, 84128,  3220, -4257,  2197,  2197,
   -4257, -4257,  2727, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257,102249,  2732, 84128, -4257,  2733,  2734, -4257,102736, 48764,
    1348,  1729,  2811,  2813,  2856, 55206,  2740,  2816,  2820,  2866,
    2823,  2827, 99318, -4257, -4257, -4257, -4257,  1315,   764,  1336,
    2832,   824, -4257,  2870, -4257, -4257, -4257,  3244, 84128,  5526,
    2942,   246,  2875, -4257,  2836,  2839,  2958,   246,   162, 99808,
   -4257, -4257, -4257, -4257, -4257,  1470, 25207, -4257,  2841,  2822,
   64528,  3135,  2953,  1504,  2014,   143, 84128,  3028,  2965, 84128,
    2780,  2854,  2855,  2787,  2141,  3140,  2781, -4257, -4257,  2957,
      -5,  2972, -4257,  2843,  2845, 58643,  1281, 46763,  3130,  2871,
   -4257,  1268,  2872,  2873,   246, -4257,  3183,   246,   246,  1625,
    3187,  2879,   628,  1574,  2489,  2781,  1706, -4257,  2881,  1917,
   -4257,  2980,   139,  1900,  2781,  2882,  2888,  2787,  2787, 84128,
   84128, 84128, 84128, 84128,   156,  3205,  3208,  2897,   150,  2929,
    2810, -4257, 73348,  2905, 98828, -4257, -4257,  2907,  2126,  2781,
    1768, -4257,  1810, -4257, -4257, -4257,  1227, -4257,  2894, 84128,
   84128, 84128, -4257, 84128,  2276, 59625,  2999,  2857, -4257,  2319,
     246, 84128, 84128,  2326,  1188,  1276,  3007, 84128,  3074,  2874,
   -4257, -4257,  2489, -4257, 48764,  2490, -4257,  2838, -4257,  2893,
   -4257,  2893,  2893,  2842,  2842,  2844, -4257, -4257,  2404,  2893,
    2842, -4257, 60607, -4257,  1890,  1985, -4257,  3241,  3246, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  1375, -4257,
    1992, -4257, -4257, -4257, 84128, 55206, -4257,  3254, -4257, -4257,
   59625,  3139, -4257, 84128,  3041,  2851, -4257,  2892, -4257, -4257,
    3175,  2904, -4257,  2908, -4257, 84128,  1237,  2680,  2910, 84128,
    3063, 84128, 84128, 84128, 84128, -4257, -4257,  3039,  1053,    62,
   -4257, 73348, -4257,  1706,  3052,  3258,   617,  1882,  3144, -4257,
   84128,  2860,  3265,  3105, -4257, -4257,  2877,  2301, -4257,  2552,
   -4257,  2120, -4257,  2988, -4257, 56188,   375, -4257, -4257, -4257,
   -4257, 59625, 84128, 96378, 56188,   375, 84128, 84128, -4257,  3170,
    2927,  3173,  2933, 46763,   375,   133, 84128, 84128, 84128, 84128,
   -4257, 84128, -4257, -4257, -4257, -4257, 84128, 84128, 84128, 73348,
    3188,  3190,   375, 84128, 84128, -4257, -4257, 23401,  1874, -4257,
   14563, -4257, -4257,   201, 11736,  2081,  2917, -4257,  1206, 84128,
    1180,   782, 70408, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, 75308, -4257, 75308,   705, -4257, -4257, 75308, -4257, 75308,
     705, -4257, 75308, -4257, -4257, -4257, 75308, 84128,  3394,  2906,
   -4257,  1474, -4257, 84128,  2093, -4257, -4257,  2098,    94, 84128,
     318, 56188, 84128,  3084, 84128, 84128, 84128, 84128,  2971,  2625,
    1371, -4257,   572, 77268,  3094, -4257, -4257, -4257, -4257, -4257,
    2112,  1314,   998, -4257, -4257, -4257, -4257, -4257, -4257, 69918,
   68448,  3185,    35, 84128, -4257, -4257,  1813, 31785, 27213, -4257,
   -4257, -4257,  2921, 11736,  2941, 31785, -4257, -4257, 31785,  2301,
    2301, 31785, -4257, -4257, -4257, -4257,  1097,  2301, -4257, 31785,
   31785,  2301,  2301,  2893,  2893, -4257,  5802, 31785, -4257, 46763,
   31785, 33309, 24698, 31785,  2983,  2939,  2301, -4257,  2301, -4257,
   31785, 26197, -4257, 31785,  3125, 34325, 31785,   255,  3131, 31785,
     255,  3349,  3349,  1806,  5851,  2925, -4257,  3034,  2301, -4257,
    2301,  1355,   248, 59625, 31785, 55206,  3005,   190, 84128, 31785,
    2938,  1963, -4257, 31785,   804, -4257,  2945, 31785,  3010, 31785,
   31785, 31785, 31785, 31785, 31785, 31785, 31785, 31785, -4257, 35313,
     277, -4257,   459,  1556, 70898, 27721,  3219, -4257, 24189, -4257,
     218, 75308, -4257, -4257,  1729, -4257, -4257, -4257, -4257, -4257,
    2154,  2943, -4257,  2960, -4257, -4257, -4257, -4257, -4257, 84128,
    3050, -4257, -4257,  3020, -4257, -4257, -4257, -4257,   720, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257,  2947, -4257, -4257, -4257,
   -4257,  2947, -4257, -4257,  2917,  2951,  5007, -4257, -4257, -4257,
   -4257,  3218,  3221,   375,102249, 84128,   311, 73838, -4257, 28229,
   -4257,  2121,  2955, -4257,  3200, -4257,  2959, -4257,  9331,  3200,
   -4257, -4257,   154,  3141,  3149,  3149, -4257,  2961, 11736, -4257,
    2250, 11736,  2316, -4257, -4257, -4257, -4257, -4257, -4257,  1398,
   -4257,  2987,  1495,  3023,   829, 84128, -4257, 42766,  2248, -4257,
    2130, -4257, -4257, 21350, -4257, 22851, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257,  2977, -4257, -4257, -4257, -4257,
     246,  2981,  3450, -4257, 63548, -4257, -4257, -4257,  3394, -4257,
    2229, -4257,  2229,  3475, -4257, 75308, -4257, -4257, -4257, -4257,
    1075, -4257, 14563, -4257, 14563, -4257,  2982,  2132,  3059,  3062,
    3107, 84128, 84128, 84128, -4257, 55206, 84128, 84128, 84128, 84128,
   84128, 84128, -4257,  3350,   896, 68448,  3108, 66978, -4257, -4257,
    2993, 84128,  3046,  3229,  3233,  1264, -4257, -4257, 84128, -4257,
    3191, 84128, 31785,  3192, 84128, 84128,  3075, 56188,  3003, 84128,
   84128, 84128,   659, 56188, 47266, 84128, 84128, 84128, 84128,  3121,
   84128, 84128,  3243,   648,   184,  2139,  2781,  3204, -4257,  1244,
   84128, 84128,  3197, -4257, -4257, -4257, 65998, -4257, -4257, -4257,
    3193, -4257, -4257, 60607, -4257, -4257,  2135, -4257, 60116, 57661,
   -4257, -4257,   416, 84128, 84128, 84128,  1404, -4257, -4257, 59625,
   -4257, 84128, 84128, 84128, 74328, 96868, 97358,  1564,  1587, 84128,
   74818, -4257, 84128, -4257, -4257, 55697, 84128, 84128, 55206, -4257,
   84128,  3199,   819, -4257, 84128,  5082,  3095, -4257, -4257, -4257,
   84128, 84128,  3022,  2146,  3096,  3143, -4257, 84128, 84128,  1477,
   -4257, 84128, 84128, -4257, -4257,   246, -4257, -4257, -4257, -4257,
   -4257, 84128, 84128,   246, 84128,   246,  1130, -4257, 84128, -4257,
   -4257, -4257, 84128, 84128, 84128, 84128, 84128, -4257, -4257,  1696,
     806,  1792,  1793,  3165, 84128,  2680, 84128, 97848, 84128, 84128,
   84128, 84128,   925, -4257, -4257,  3137, -4257, 84128,  1477, 84128,
   84128,  3103,  3109,   112,  3179, -4257, -4257, -4257,  3319,    70,
      70, -4257, -4257, -4257,  3273,  3441, 84128, -4257,  3277,  3278,
    3090,  3093,  3280,  2134, 84128, 84128, 84128, 84128, 84128, 84128,
    3282,  2134,  3228,   703,  3048,  2171, -4257,  3065, -4257, 31785,
    3451, 59625,  3051,  3055,  3123, -4257,  3129,  2301, -4257,  2015,
   -4257, -4257,  2190, -4257,  3068,  1053,  2102, -4257, 84128,   559,
     672,  3356, 38800,  3169,  3648, 84128,  3347, 84128, 84128,  3648,
   -4257,  3252, 68448, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  3348, -4257,  2680,  2490,  2490,  2490,  2490, -4257,
   -4257, -4257, -4257,  3255,  1990, -4257,  3070, 84128,  3176,  3648,
   -4257,  1706,  3369,  3371, 84128, 65018,  1955,  3480,  2680,  3259,
   -4257, 25702,  2924,  3262, 65998, 79228, -4257,  3087,  3351,  3354,
    3367, -4257,  2276, -4257,  3494, -4257,  3387,   375,  2319, -4257,
    2582, -4257, 84128, 84128, 84128, 84128,  2326, -4257, -4257,  2582,
    3281,   375,   375, -4257,  3283,   375,  2582,  3203,  3383, 65998,
   -4257,   109, -4257, -4257, -4257, -4257, 84128, -4257, -4257, -4257,
   31785, -4257, -4257,  3106,  2120, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, 75308,  2229, -4257,  2225,
   -4257, 84128, -4257,  3363,  3364,  3370,  2582,  3145, 84128,  3110,
   -4257,  2582,   246,  2582,  2625,  2625,  2582, 80208,  3524,  3384,
     121, -4257,   544,    -9,  3321, -4257, -4257, -4257, -4257, 59625,
   -4257, -4257, -4257, -4257, -4257, 84128,   212,  3300,  3126, 80208,
    3511,   375, -4257, 56188, -4257, -4257,  3209, 56188,  3315, -4257,
   -4257, -4257, -4257, -4257,  3362, 84128,  2236, -4257,  1899, -4257,
    1915, 31785, 31785,   249, -4257, 10100,  2254,  3133,  3136,  2258,
   -4257, -4257, -4257, -4257, -4257, -4257,  3138,  3411, -4257, -4257,
    3142,  2262,  2270,  3146,  3147, -4257, -4257,  5085,  3152, 10180,
    3154, 33309, 33309,   977, -4257, -4257, 33309,  3155, -4257,  2282,
    9480,  3156,  3161,  3157, -4257,  3162,  3163, 10442, 29245, 31785,
   29245, 29245, 10743,  3156,  3167,  2287, 55206,  3297, 11149,  2290,
   -4257, 31785, 55206,  5695, 31785, -4257, 31785, 84128,  3168,  3172,
   -4257, -4257,  5802, -4257,  3158, -4257, 33309, 33309, -4257,  3809,
   26705, -4257, -4257,  3418, -4257, -4257,  1725, -4257,  3166, -4257,
   -4257,  6129,   207, 31785,  2938, 31785,  3217, 46763,  5306, 31785,
    2646,  3247,  3247,   981,   981,   153,   153,   153,  1969,  1556,
   -4257, -4257, -4257,  3171,  2660, 31785, -4257,  2372,  2379, 84128,
    5465,  9412, 11607, -4257, -4257, -4257, 36823,  3207, 31785, 31785,
   31785,  3178,  3355,  3599, 11736,   991, -4257,  3603, -4257, -4257,
   -4257,   334,  3475,  2154, -4257,  1227,  2301,  1355, 51235, -4257,
   -4257, -4257, 31785, -4257, -4257, -4257, -4257,  2057, -4257, -4257,
   -4257, -4257, -4257,  1314, 31785, -4257, -4257,  1111,  2422, 31785,
    2250, -4257, -4257, 84128,  3094,  3094, 31785, -4257, -4257, -4257,
   -4257, -4257, 36823,  3223,  3230, 41778,  3316, -4257, -4257, 84128,
     219, -4257, -4257, -4257,  3201, -4257, -4257, -4257,  1646, -4257,
   -4257, -4257, -4257, -4257, -4257,  3186, -4257,  3189, -4257,  3202,
   -4257, -4257, -4257, -4257,   182,  3194,  3195,  3198,  1345, -4257,
   -4257, 84128, 84128, 84128, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257,  3413, -4257, 84128, 84128,  3376, 84128,
    3380,  3388, 31785,   753, 84128,  3214,  3222,  1429,  3458, 84128,
   -4257,   375, -4257, -4257, 11736, -4257, -4257, -4257, 65998, -4257,
    2276, 59625, -4257, -4257, -4257,  3236, 84128, -4257, 84128, 84128,
    2326, -4257, -4257, -4257, -4257,  1283, -4257, -4257, 84128, 84128,
     552,  3290, 84128, -4257,   608,  2980, 84128, 84128, 84128,  3456,
   -4257, -4257, -4257, -4257,  3400, -4257, -4257,  1992, -4257, 57661,
   60116, -4257, 60116, -4257,  1992,  1932, -4257,  2582, -4257, -4257,
     965, -4257, -4257, -4257, -4257, -4257,  3515,   375,  3517,   375,
   84128, 84128, 84128, 84128, -4257, -4257, -4257, -4257, -4257, 55206,
   55206, 55206,  2302, -4257, -4257,  2680, -4257, -4257, -4257,  2338,
   -4257,  1579, -4257, -4257, -4257, -4257, -4257, -4257, 84128,  1715,
   -4257,   880, 59625, -4257, 59134, 84128, 84128, -4257, -4257,  3445,
    3389, -4257,  2252,  3392, 84128,  3288, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  3310, -4257,
   -4257, -4257,  3459,  3460,  3462,  3317,  3322,  3368,  3325,  3327,
    3372, -4257,  3329,  3374,  3331,  3377,  3334,   375, 59625,  2118,
    3373,  3558,   375, -4257,  3338, -4257, -4257,  3665, -4257, 84128,
   -4257, -4257, -4257, 84128, 84128, -4257, -4257, -4257, 98338,  3342,
    3342,  3342,  2134, 59625,  3508,  2134,  2134, 84128, 84128,  2134,
   -4257, -4257, -4257,  3509,  3510,  3514,  3516,  3518,  3519,  2134,
   -4257, -4257, -4257, -4257,  1373, 55206, -4257,  2735, -4257,  2312,
   44248,  6168,  3279,  3055,  3284,  2301, 39802,  1340,  3486,  3285,
   -4257, -4257, 55206, 44248,  2018,  3504,  3296,  3296,  3296,  3296,
    3296,  3296,  3296, -4257,  3024,  2489, 65998, 84128, 65998, -4257,
     672,  3465, 84128, -4257, -4257,  2350, -4257, 84128, 84128,   996,
   84128,  2301, -4257, -4257,  3286,  3352, -4257,  1882,  1237,  3419,
    1602,  3628, -4257, -4257, -4257, -4257, -4257, 84128, 84128,  1053,
    2680,  3292,  3291, -4257, 84128, 84128, 75308,  1314,  3295, 84128,
    3299,  3293, -4257, -4257, -4257, -4257,  2368, -4257, 59625,  3479,
    1314,  3375, 84128, -4257,  2373,   105, -4257,  2680, 65998, 58152,
   -4257,  3989, -4257, -4257,   675,  3572, -4257, 84128, -4257, -4257,
   41284,   375, 59625, 84128, -4257,   375,  3358,   375,  3359,   375,
     375, 84128, -4257, -4257, 84128, -4257, 84128, 73348,   375, -4257,
   -4257, 11736, 84128,  3588, -4257, -4257, -4257, -4257,  3421,  3425,
    3427, 84128,  2582, 56188, -4257,  3309, 84128,  1611, -4257, -4257,
    3493, -4257, -4257, -4257, -4257, -4257,  3614,  3615, -4257, -4257,
   -4257, 84128, 69428,   140, 84128, -4257,  2276, -4257,  2319,   246,
   84128,  3556, -4257, -4257, -4257,  3323,  2388, 11233, 31785, -4257,
    3623, 59625, -4257, -4257, -4257, -4257, -4257, 31785, -4257, -4257,
   -4257, -4257, -4257, 31785, -4257, 31785,  3600, -4257,  3746,  3746,
   59625, 33309,  2023,  2653, 33309, 33309, 33309, 33309, 33309, 33309,
   33309, 33309, 33309, 35821,   681, -4257, -4257, 31785, 31785,  3608,
    3600, -4257, -4257,  1525,  1525, 59625,  3324,  3156,  3326,  3332,
   31785, -4257, -4257,  2401, 34819,  3333, 55206, -4257, 31785,  9528,
    2410,  3378, 11500,  1729,  6647, -4257,  3702,  2680, 31785,  2167,
    2211, 31785,  2414, 31785,  3612, -4257, -4257, -4257,  3328, -4257,
   -4257, 59625, 31785, 33309, 33309,  6282, -4257,  6614, 31785,  3335,
    7210, 26705, -4257,   649,   649,   649,   649, -4257, 84128, 84128,
   84128, 36329, 80698,  3339,  2367, -4257, 80698, 81188, -4257,  3341,
    1729, 31785,  3607,    -6,    -6,  3337,  3355, 43260, -4257, 31785,
    1742, 29753,  3344, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  3343, -4257,
    3382, -4257, -4257,   241,  3353, -4257, -4257,  9188,   182, -4257,
    3357, -4257,  3360, -4257,  2422, -4257, -4257, -4257,  6767,  3530,
    2625, -4257, -4257, -4257,  3339, 30261,  3316, -4257,  2419, -4257,
   -4257, 27721, -4257, -4257,  2424, 42766,  3223, 28229,  1729,  2301,
    3385, -4257,  2229,   334, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  3296,  2582,  2582,   714,  2582,  3641,   714,  7271,
   -4257, -4257, 37317, 84128, 84128, -4257, 84128,  2425,  1414, -4257,
   -4257, -4257,  3761, 84128, -4257,  3414,  3416, -4257, 84128, 84128,
   84128, 84128, -4257, -4257,  2298, -4257, -4257, 84128, -4257, -4257,
   -4257, -4257,  3438, -4257, -4257,  3618,  1991, -4257, -4257, -4257,
    3431,  3024,   176,  2787,   803, -4257,  3435, 84128, -4257, 84128,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, 55697,
   -4257, -4257, -4257, 55206, 44248, 55206, -4257,  3446,  3447,  3492,
     104,   676,  3449,  3452,  3497,  3386,  3390,  3391, -4257, -4257,
     269,  2680, -4257, -4257,  2680,  2582,  2680, 84128,  3662,   579,
    2061, 84128, 84128, 84128, 84128, 84128, 84128, 84128, 84128, 84128,
   84128, 84128, -4257,  3748,  2680,  2680,  3719,  3448, 84128, -4257,
   84128,  2980, -4257, -4257, 84128, -4257, 81678, -4257, -4257, -4257,
   -4257,  3397,  2134, -4257, -4257,  3624,  3626, -4257,  2134,  2134,
    2134,  2134,  2134,  2134, -4257,   391,  2435, -4257, 39295, -4257,
   -4257,  2884,  2680,  2884,  1541, -4257,  2884, -4257,  2884, -4257,
   -4257,  3065,  3360,  2301,  2197, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  2301,  2397,  3401, -4257, 40790, -4257, -4257, -4257,
    2186,  1355, -4257, -4257, 84128,  3296, -4257,  2402,  2199,  2587,
    2624, 82168, 82658, 83148,  3393, 84128, 84128, 33309, -4257,  1522,
     155, -4257,  3635, 84128,  3437, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  3404, -4257,  2851, -4257, 84128,  3465,  2582, 84128,
   84128,  2582, -4257, 59625,  3810,  1508, 93928,  3436,  3405,  3692,
   -4257,  3408,  3409, -4257, -4257, 84128,  3465,   844,  1872,  3454,
   67468,  1955, -4257,  3667, 65018, -4257, 84128,  3778,  3499,  3457,
    2680,  3046, -4257, 57661, 31785, 31785, -4257,  3422, -4257,  3424,
    4148, -4257,  2490, -4257, -4257, -4257, -4257, -4257, -4257,  3495,
   84128,  3855, -4257, -4257, -4257,  3429,   375, -4257, 84128, -4257,
   84128, -4257, -4257,   375,   375, -4257,  3540, -4257, -4257,  1314,
   84128, 84128, 84128,  2582, -4257,   246, -4257,  3708, 80208, -4257,
   -4257, -4257, -4257,    35,  3714, -4257, -4257,  3673,  3676,  3679,
    3681,  2469, -4257, -4257, 31785, 11736, -4257,  3453, 11736,  7565,
   11736,  3608, -4257,  2012,  3726, -4257,  1351,  3461,  2012,  2222,
    2222,   303,   303,   145,   145,   145,  3746,   681, 11736, 11736,
   -4257, -4257, -4257, -4257,  3463, -4257, -4257, -4257,  3156, -4257,
   32293,  3589,  3834, -4257, -4257, -4257,  3487,  3489,  3464, -4257,
   31785, 32801,  3455, 60607, -4257, -4257,  1355,  1046, 33309, 33309,
    2467, -4257,   758, 31785, 59625,  2436,  2467,  2504,  3128, 31785,
   31785,  7449,   323, 31785,  7830, 84128, 84128, 84128, 84128, -4257,
   -4257, -4257, 38305,  2367,  3466, 84128, -4257,  3470, 36823,  3697,
    3631, -4257, 36823,  3631,  1821,  3631,  3698, -4257, 43754, -4257,
    3472, 24189,  1980, 11736,  3852,  3742, 31785,  3474, -4257,  3476,
    3355, -4257,100298, -4257, -4257, 11736, -4257, -4257, 31785, -4257,
    3355,   334,   963,  2680, -4257, -4257, -4257, 46763, -4257, -4257,
   -4257,  3666, 11736, -4257,  1314, 84128,  1729,   585,  3496, 84128,
   -4257,  3316, -4257, -4257, 14563, -4257, -4257, -4257,   269, -4257,
   -4257, -4257,  3549, 68448,  3759, -4257, 31785,  2440, -4257,  3520,
    3848,   159,  2453,  2471,  1414, -4257,  3437, -4257,  1563,   202,
   -4257, 59625, -4257, 84128, 84128, -4257, -4257, -4257, -4257,  2740,
   -4257, 84128, -4257,  3546, -4257,  3680, -4257, -4257,  3682,   269,
   84128, -4257, 59625,   375,   375, -4257, -4257, -4257,  3498, 84128,
   84128, 84128,  2301,  2301, 59625,  3485, -4257,  2301,  2301,  3491,
   -4257, 84128, 84128, 84128, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, 84128, 84128, 84128, 84128,  3786, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, 84128, -4257,
   -4257, -4257, 59625,   375,   375, -4257, -4257, 84128, -4257,  3733,
   -4257,  2134,  2134, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
    2489,  3818, -4257, 55206, -4257, 62078, -4257, -4257, -4257,  2680,
   -4257,  2680,  3688, 49746,  2680,  2680,  1414,  3500,  1782,  3776,
   -4257,  2175, 40790, 40790, 40790, 40790, 40790, -4257, -4257,  3780,
     269, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, 31785, -4257,   912,  2012,
   -4257, -4257, -4257, -4257,  3437,  1882,  3553,   559, 55206,  3610,
   -4257, -4257,  2582,  2582,  3557,  1314,   867, 84128,  3815,  3547,
   -4257,  2680, -4257, -4257, 84128, 65018, -4257,  1061, -4257,  2472,
   -4257, -4257, -4257,  3542,  3479,  1491,  3512,  1955, -4257, -4257,
    1240, 84128,  3825,  1288, -4257,  3791,  3513, -4257, 11736, 11736,
    2680, 61098,  3989, -4257, 84128,  3765, 84128, -4257,   375, -4257,
     375,   375, -4257, -4257, 84128,  2582,  2582,  2582, -4257,  3695,
   -4257,   375, 80208,  2469,  2469,  2469,  2469, -4257, -4257, -4257,
   11736, -4257, -4257, -4257, 33309,  3797, -4257,  3521, 59625, -4257,
    3522,  2475,  2476, 34325,  3660, -4257, -4257, -4257,  7882,  3566,
   11736,  3616,  3525,  3526, -4257,   785,   785,   758,  2484, -4257,
   33309, 33309,  2467,  2467, 31785,  2467, -4257, -4257, -4257, -4257,
   -4257, 80698,  3523, 84128,  2367, 36823, -4257, -4257,  1972, -4257,
   36823,  3760, -4257, 36823, 84128,  3528, 84128,  1045, 31785, 31785,
    3564,  3355,  3355, -4257,  3699, -4257,  3531, -4257, -4257,  2197,
   -4257, -4257, -4257, -4257,  1355,  3533, 75308, -4257, -4257, -4257,
    1050, -4257, -4257, -4257, -4257, 80208,  3713, 80208,  1414,  8039,
    3437, 37317, 47769, 84128, 83638, 83638,  3677,  3437,  3553, -4257,
   -4257, -4257, -4257,  3534, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  3748, -4257, -4257, 44248, -4257, -4257, -4257, 37811,
   46763, -4257,   104,  3538,  3539,   676, -4257, -4257, -4257,  1632,
     890,  3574,  2582,  3828, -4257,  3748, -4257, -4257, -4257,  2134,
   -4257, -4257,  3048,  2680, -4257, -4257,  2500, -4257, -4257, -4257,
   84128, -4257,  3405, -4257, -4257, -4257, 56188,  3948,  3948, -4257,
    2054,  2054, -4257, -4257, -4257, 84128, -4257, -4257,  8607,  3736,
   -4257,  3553,  3764,  3803, -4257,  2501, -4257, 84128, 84128,  3457,
   65018,  3465, -4257,  1869,  3548,  3849, -4257,  3295,  3552, -4257,
    3890, -4257, 67468,  3734,  3499,   817,   817, 84128,  3479,  3675,
   -4257,  3684, -4257,  3945,  3560,  3634,  3936,  3744,  3940, 84128,
   37317, -4257, 60116, -4257,  2510, -4257, -4257,  3207, 84128,   884,
   -4257,  3580, -4257, -4257, -4257, -4257, -4257, -4257,   140, -4257,
   -4257, -4257, -4257,   696, 33309, 59625,  2514, 31785, -4257, 31785,
   -4257,  3954, -4257, -4257, -4257,   686, -4257, -4257, -4257,   785,
     785,  2467, -4257, 84128,  2518, -4257, 31785,  3570, -4257, -4257,
   36823,  1972,  2521, 84128,  2522, 59625,  3355,  3156, 11736, 84128,
   -4257, -4257, -4257,  3960,  3752,  3355, -4257, -4257, -4257, -4257,
   -4257, -4257,  1611,   714,   140,  3848,  3553, -4257,  3577, -4257,
   -4257, 84128, -4257,   789,   789, 84128,  3553, -4257, -4257,  3632,
   -4257, 59625,  2319,   163, -4257, 59625, 59625, -4257, 84128, 84128,
   84128, 84128, 84128,   375, -4257, -4257, -4257, -4257, 62078,  3405,
    3948,   226, -4257, -4257, -4257,  1817, -4257, -4257,  1482,  3763,
    3663, -4257, 55206,  3465,  3869, -4257, -4257, -4257, -4257, -4257,
   31785,  3738,  1955,  3667, -4257, -4257, -4257,  3825, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257,  2525,  3499, -4257, -4257,
    1175, 84128,   987, -4257,  3768, -4257,  3770, -4257,  2531, -4257,
   -4257,  4148, 61098,  3898, -4257,  3640, 84128, -4257, -4257,  2560,
    4020, -4257,   696,  2532, -4257,  2535,  2538,  3739,  3646, -4257,
    2545, -4257, 11736, 84128, -4257, -4257, -4257,  2546, -4257,  3591,
   -4257,  4004, 31785,    39, -4257, -4257,  3881, -4257, 83638,  3647,
   46763, -4257,  2422,  2422,  1882, -4257,  1414, 31785, -4257,  2555,
   -4257,  1191,  3747,  3889,  2559,  2566,  3606,  3645,  3606, -4257,
    2582, -4257, -4257, -4257, -4257, -4257,  3921, -4257, -4257, -4257,
     565, -4257,  3795,  3796, 84128, -4257, -4257, 84128,  4019,  8657,
   56188,  3479,  1955,  3024,  3634, -4257,  3825, -4257,  3617, -4257,
    3743,  3619, 84128, 84128, -4257, -4257,  3653, 37317,  3989, -4257,
     236, -4257, -4257, -4257, -4257, -4257, 84128, -4257, -4257, -4257,
   -4257, -4257, -4257,  2569, -4257, 84128,  3621,  3156, 30769, 30769,
    3622, 80208,   789,  3625, -4257,  3630, -4257, -4257,  3764,  1414,
   11736, 56188,  4008, -4257, -4257, -4257,  3747, -4257, -4257, 84128,
    3753,   828,   828,  3950, -4257,  3687, -4257, -4257, -4257,   104,
   -4257,  3627,  3499,  3479, -4257,  3634, 84128, -4257, -4257, -4257,
    3286,  2787,  3499, -4257, -4257, -4257, -4257,  1451, -4257, -4257,
   -4257, -4257, 33817,  3756,   118,  9937, -4257, -4257, -4257, -4257,
     140,  2422, 31785,  1414, -4257,  3763,  2319, 84128, -4257, -4257,
    3547, -4257,  4054, -4257,   952, -4257, -4257,  3485, 54715,  3825,
    3499, -4257,  3636, -4257,  3207, -4257,  1945, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257,  4049, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257,  8756, -4257, -4257, -4257,  3941, -4257, -4257, -4257,
    2576, -4257, -4257, -4257, -4257, -4257,  3634,  3825, -4257, -4257,
    1685, -4257, -4257,  1801,  2082, 31277, -4257,  1414,  3793, -4257,
   54715, -4257,  3634, -4257,  1945, -4257, 56188, -4257, -4257, -4257,
    3650, 54715,  2580, -4257
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4257, -4257,  3782, -4257, -1164,   409,  2323,  -660, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  2963,
   -4257, -4257, -4257,  1549, -4257, -4257,   -57,   715,  2575,  1238,
   -4257, -1371, -4257, -4257,  -883,   223,  -992, -4257, -4257, -4257,
   -4257, -4257, -4257, -4257, -1024,  1690,  1082,  2200, -2391, -4257,
   -1734, -4257, -4257,   510, -4257, -4257,  1643, -4257, -4257, -4257,
     953,  -254, -4257, -4257, -4257, -4257, -4257, -4257, -4257,    16,
   -4257, -4257,  -428, -1840,  -109,   -53,  -296, -4257, -4257,   350,
    -299, -1694, -4257, -3008, -4257,   -22, -4257, -4257, -4257,  -297,
   -1701,  1165, -1007, -1350,  1469,  -597, -4257,  -189, -4257,  -652,
    -537,  -535,  -604,  -434, -1289, -4051, -3746, -4257, -3834, -3052,
   -2923,  1176, -4257, -4257, -4257,   366, -4257, -1826, -4257, -4257,
    2257, -1641, -4257,  -993, -4257, -4257, -4257, -2964, -4257, -4257,
   -4257, -4257,   -92, -4257, -4257, -4257, -4257,   411, -4257, -4257,
   -4257, -4257, -4257, -4257, -2742,  1607,  1615, -4257, -4257, -3634,
   -4257, -1181, -4257,   558, -3000,  1101, -4257, -4257, -4257,  2280,
   -4257, -4257, -4257, -4257,   415, -4257,   420, -4257, -4257, -1838,
   -4257, -4257, -1824, -4257,  1626,   935, -4257, -4257, -4257,  -628,
    -694,  -682, -4257, -3462, -4257, -4257, -4257, -4257, -4257, -1238,
   -4257,   988, -3099, -1228, -4257, -4257,  1000, -4257, -4257, -4257,
   -4257,  -578,  -180,  2303, -4257,  -478,  -558, -4257, -4257, -4257,
    -176, -4257, -4257, -4257, -4257, -4257, -4257, -1976,  9110, -1808,
   -4257, -4257, -4257, -4257, -2337, -4257, -4257, -4257, -1719, -4257,
    4055,    24,   328, -1822, -4257,  -197,  -101,  2815, -1382, -2680,
     353,  -328, -4257, -2040, -4257, -4257, -4257, -2590, -4257, -4257,
   -4257, -4257, -3443, -1820, -4257, -4257, -4257,   404, -4257, -4175,
   -3864, -4126, -3636, -3422, -4257, -4257, -1322, -4257, -4257, -4257,
   -1633,  1808, -1693, -4257, -2385,   406, -3683, -1015, -3226, -4257,
   -3620,  -412, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -1316,
    -890, -4257, -4257,  3318, -4257, -4097, -4257, -4257, -4257, -4257,
   -1216, -4257, -1588,  1072, -4257, -4257, -4257, -4257, -4257,  -576,
    -661, -4257, -4257, -4257,   295, -4257, -4257, -4257, -4257,  1623,
   -1196,  -995,  3174, -1819,  -212, -4257, -4257, -4257, -4257, -2995,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -1328, -4257, -4257,
   -4257, -4257, -4257, -4257, -4257,  1994,  1996,  -120,  -205, -4257,
   -4257, -1493, -4257, -4257, -4257,  -762, -1336, -1817, -4257, -4257,
   -4257, -4257, -4257,  -817, -4257,  2226, -4257, -4257, -4257, -4257,
   -4257,   394,  -224, -4257, -4257,  1318,   319,   436,   -65, -4257,
   -4257,   230, -3356,   -63, -4257, -4257, -4257, -4257,    26,   -59,
   -4257,   692, -4257, -4257, -2823, -4257,   324,   -71,  2911,  1567,
     -54,   274,  -244,  -215,  -203,   -64,  3177,  2651, -4257, -4257,
   -4257,  -206,  1911, -4257, -1109,  -366, -4257,  1326,  -914,  1970,
    2639,  2641, -4257,  1321, -4257, -4257,  1329, -4257, -4257, -4257,
    -913,  1984, -4257,  2650,  2001, -4257,  1319,  1328, -3329,   792,
   -3328,   300,  -920,  -252,   -82,  3211,  2659, -4257, -4256,   726,
   -4257, -3440, -2398,  3276, -2083, -1828, -4257, -4257, -1395, 12396,
   -4257, -4257, -4257, 14299, 15602, -4257, -4257, 16208, 16997, -4257,
   -1254,   838, 17364,  7169, -1447, -1857, -1554, 15036, -2609,   930,
   -2768, -4257, -4257, -4257,  -222,   845,   211, -4257, -4257, -4257,
   -4257,  -469, -2815,  -467, -4257, -4257, -4257,  -472, -3302,  1051,
   -4257,  -827, -4257, 16294,  1364, -4257, -1366, -2751, -2747, -1401,
   -1975, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -3016, -3218,
    -240,  1446, -4257, -4257,  1540, -4257, -4257, -4257, -1543, -1156,
   -2670,  1452, -2138, -4257, -1097,   754,  2122, -1048,  8911,  -435,
   10639,  -106, -2347, -1535, -1760, -4257,  3122, -4257,    98,  3014,
    -137,     7,   -68,   -44, -3091, -4257, -4257,   356, -4257, -4257,
   -4257,  3664,  1001, -4257,  3008, -4257,  1674,  2362, -4257, -4257,
    1998,  -950,   -33, -4257,  -432, -4257,  -125, -4257, -4257, -4257,
     174, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,
    2682, -4257, -4257, -1471, -4257, -4257, -4257, -4257, -4257,  3952,
    -298, -4257,  3366,  -293, -4257, -4257, -4257, -4257, -4257, -4257,
   -4257, -4257, -4257,  2692,  2030, -4257,  3206, -4257, -4257, -4257,
      -4,  2923, -4257, -4257, -4257, -1201,  -593,  3196,  3213,  1995,
   -4257, -4257, -4257, -4257, -4257, -4257, -4257, -4257,  2000, -4257,
   -4257,  1422, -2164,  2005, -4257, -4257,   761, -4257, -4257,   331,
   -4257,   766, -4257,  2802, -4257, -4257, -4257,   802, -4257, -4257,
   -4257,  -586, 11329,   158,   268,   422,  1271, -4257,  4798, 13820,
      60,  2720,     9,  7959, 14240,    73, -4257,  3955,  2020,  1658,
   -1006, -4257,  4047,  2321, 13450, -4257, -1003,     5,  1589, -4257,
      -2,  -649, -1188,  3013,  -742, -1965, -4257,  4375, -4257, -3479,
   -4257, -1042,  3395, -1219
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2582
static const yytype_int16 yytable[] =
{
      81,  1110,  1101,  1639,  1427,  1428,  1929,    79,  1298,  1432,
     372,  1988,  1052,   359,   369,   360,   372,  1572,  2025,   362,
    1645,  1985,  1086,  2036,   364,   724,  1711,  2386,  1218,   928,
    1006,  2730,  2549,  2550,   373,   730,  1994,  2691,  1593,  2469,
     373,   912,  2090,  1810,  1847,   980,  2478,   916,  1875,   372,
    1006,  2588,  1329,  3081,  3083,  2695,  2921,  1790,  2260,  2448,
    1932,   718,  1352,  2439,  2580,  2149,  2447,  1835,   966,  1950,
    1014,  1218,   874,   373,  2101,  2067,   413,  1585,  1027,  3383,
    1158,  3641,   413,  2517,  2518,  1120,   930,   412,  2122,  2123,
    1121,  2551,  1203,   412,   372,  3853,  2614,  3518,  3628,   718,
      74,   369,  2589,  2320,  2322,  2323,  1976,  2138,  1053,  3655,
    2615,  3657,  2616,  2638,  2617,   413,  2618,  2619,   373,  1918,
     920,   927,  1922,  2437,   820,  1218,  3177,  1926,   869,  2273,
     927,  2941,  4028,  2779,  3131,  1295,  1934,  1162,  3508,  3759,
    1044,  1083,  1104,  4064,  3773,  1952,  3573,  1664,  1044,  3371,
    1044,   922,  3759,  1694,  1112,  4054,  1696,  3513,  3514,  1074,
     413,  1388,   372,  3515,  2165,  2507,  1113,  4262,  2260,   820,
     927,  2687,  3983,  4221,  4216,  3463,  2456,   825,  3997,  3999,
    2364,  2314,  2314,  1754,  2026,  1579,   373,  2019,  2051,  1348,
     829,  1003,  4233,  4484,  3508,  1633,  1636,  4385,  1726,  1805,
    2650,  1814,  3418,  3419,  1672,  1673,  1049,  3434,  1839,  1779,
    4033,  1003,  3584,  2219,  1049,  1043,  1049,  1153,  1949,  2116,
    2117,  3930,   825,  1043,  2513,  1043,   433,  1376,   413,  2978,
     880,  2095,  2096,  3420,  3220,   829,   411,   820,  1977,  1836,
      45,  2173,   411,   433,  2135,  2457,  1734,  3469,  3470,  2167,
    1175,  4663,  3778,  3779,  3780,  3781,  3782,  3783,   416,  4584,
    3276,  1587,  1977,  3195,  2529,  1005,  2176,  1869,  2994,  1977,
    2524,  2636,  2998,  2760,  1324,   411,    37,    38,    39,    40,
    1442,  1048,  2261,    44,   931,  1005,  2450,  4181,  3844,  1048,
     825,  1048,   711, -1852, -1852, -1852, -1852,  3198,  2178,  4176,
   -1852,   261,  2855,   829,  4383,  3578, -1539, -1539, -1539, -1539,
     359,   369,   360, -1539,  2850,   372,   362,  1415,   433,  2855,
     411,   364,  3629, -2308,  2477,  4659,  3337,    43,  3339,  2723,
    1107,  2450,    45,  1844,  1423,  3372,  4825,  4724,  4102,   373,
    4212,   433,  3523,  2028,  4876,  3524,  3525, -1746,  2321,  2424,
     372,  4613,   365,  1735, -1746,    45,  3526,  3527,  3528,  2389,
    3529,  3530,  1728,  3047,  -756,  3531,  3532,  3533,  2326,  1863,
    1058,  2280,  2327,   329,   373,  1091,  2890, -1529, -1529, -1529,
   -1529,   413,  3376,  2891, -1529,   822,  1149,  4391,   411,  1847,
    4711,  3420,   412,  1457,  1685,     3,  1712,   358,  1914,  2210,
    3911,  2038,   363,  4778,    37,    38,    39,    40,   835,  1734,
     836,    44,  2241,  1565,   130,   131,   413,  1686, -2580, -2580,
   -2580, -2580, -1762,   882,  3931, -2580,  1235,   412,  1713, -1762,
     822,  4779,  1218, -2580,   374,  2425,  4103,  4647, -1529,   365,
   -1496, -1496, -1496, -1496,  3381,  1138,  4388, -1496,  2149,  3377,
    2082,  2906,   433,  3398,  2242,    37,    38,    39,    40,  2281,
    1714,    43,    44,  1463,  1687,  2328,    45,  1059,  1588,  1729,
    4877,  1715, -1539, -1539, -1539, -1539,  4213,  1114,  4725, -1539,
   -1509, -1509, -1509, -1509,  1845,  2012,  1424, -1509,  2122,  2123,
     872,  1978,  4085,  1163,  2727,  2138,  2724,  3233,   822, -1529,
   -1529, -1529, -1529,  4826,  1977,  2262, -1529,  2468,  2207,  4006,
    3534, -2308,  1576,  4723,  1345,  1978,  1735,  1236,  3629,  1355,
    1100,  2458,  1978, -1496,  2725,  1196,  4104,   712,  1589,  1367,
    3373, -2581, -2581, -2581, -2581,   932,  2459,  2558, -2581,   823,
    1177,   411,  1604,  1453,  1605,  1121, -2581,  2562,  2252,  2253,
    1987, -2578, -2578, -2578, -2578,  1115,   916,  1237, -2578,  1453,
    1443, -2005,  3196,  1675,  1678,  4097, -2578, -2308, -2577, -2577,
   -2577, -2577,  4782,  3759,  2637, -2577,   411,  2105,  2512,  2040,
     870,  -362,  4823, -2577,   823,  2696,  2460,  1156,  1157,  2530,
    1707,  2237,  1147,  4378,  4461,  2249,  2249,  4048,   261, -1496,
   -2173, -2173, -2173, -2173,  3845,  2580,  1238, -2173,  4899,  1736,
    1730, -1524, -1524, -1524, -1524, -2173,  2856,   933, -1524,   934,
     246,  2525,  1915,  3066,  2014,  2168,  2554,  2116,  2117,   920,
    2511,  2018,  2548,  3483,  3085,  2135,  1681,  2578,  2503,  2083,
    2505,  3535,  4506,  1111, -1536, -1536, -1536, -1536,  1987,   365,
    2547, -1536,   823,  3432,  1092,  3888,  1154,  1000,  1001,  4334,
     922,  2197, -1746,  4338,  4392,  2740,  2949,  2260,  2220,  1598,
     329,  2920, -1524,  1599,  1731,  1785,  1431,  3601,  1915,   927,
     927,    37,    38,    39,    40,  4372,   837,  3536,    44,  1758,
    4812,  2892,  3236,  4293,   358,  3638,  1149,  3639,  2232,   363,
    -143,  4011,  1155,  4450,  4451,  4452,  4453,  4454,  2574,  -143,
    2144,  4698,  2083,  2719,  -143,  2416,  2696,    37,    38,    39,
      40,  2336,  2728,  2782,    44,  2301,  2302,  1431,  1598,  2145,
   -1852,   374,  1599,  3508,  3575,  1101,  1164, -1762,  4637,  1190,
    2428,  2776,  2778,  2146,  1654,  3080,  1640,  1116,  2418,  1000,
    1663,  3088,  2786,  4801,  2423,  2789,  1846,  1978,  3374,  3542,
    4576,   419,  4860,  2801,  2802,  1287,   372,  4586, -2005,  3420,
     372,  2111,  1000,  1001,  4019,  1396,  2819,  2821,  1197,  1225,
    4190,  1606,  3537,  1283,  3420,  1271,  2741,  2835,  3274,  1340,
     373,  3256,  1162,  3625,   373,    37,    38,    39,    40,  2490,
    1326,  2493,    44,  4744,  2496,  2497,  4123,   729,  3429,  3430,
    3431,  3432,  3913,  2204, -1529,  3918,  3919,  3920,  3921,  3922,
    3923,  3924,  3925,  3926,  3927,  2709,  3067,  2702, -2005,  2019,
    3007,  2712,   413,  1857,  4060,  3045,   413,  4626,  1339,   839,
    1186,   820,  2980, -2005,  2980,  3757,  2173,   412,  1186,  3059,
    2894,  4159,  1397,  3548,  1403, -2580,  1408,  1415,  3757,  1391,
    3725,  3726,  1412,  3855,  1848,  3720,  1386,  2559,  3723,  3724,
    1465,  2176,  3727,  3420,  3967,  3968,  2144,  2121,   840,  2805,
    2806,  1186,  3734,  1688,  1689,  1403,  1408,  1112,   875,  3059,
    1149,  2380,   927,  2111,  1166,  2145,  4265,  2486,  2945,  1113,
    4036,  4746,  2380,  2178,  4552,  1387,  4554,   829,  3264,  2148,
    4107,  1029,  4815,  3059,   369, -1496,  4638,  2127,  1995,  2381,
    1402,  3060,  1407,  1042,  2872,  1849, -1496,  1327,  2121, -1496,
    1715, -1496,  1421,  1080,  3851,  3222, -1529,  1186,  1945,  1433,
    1382,  3856,  1315,  2644,   927,   975,  1186,  4702,  4703,  4049,
    2647,  1436,  1438,  3375,  3257,  3422,  4124,  4851,  2439,  1946,
    1218,  3060,  3124,  2742,   976,  2382,  4639,    81, -2581,  2226,
   -2582,  2895,  1609,  4640,    79,  3670,  2382,  1415,  4758,  4087,
    2946,  2743,  2383,  1788,  2701,  3060,  2392,  1655, -2578,  4736,
    1030,  3061,   411,  2383,  4615,  2080,   411,   977,  1044,  4678,
    2507,  4641,  1044,  4542,  1433, -2577,  4545,  2392,  4108,  1575,
    2092,  4549,  2964,  1583,  4551,  1401,  3626,  1406,  1288,   372,
    3187,  2215,  2102,  4802,  2216,  4896,  1825,  2734,  2735,  1149,
    3258,   718, -2582,  2227,  1643,   433,  3853, -2173,    37,    38,
      39,    40,  1341,   373,    43,    44,  1435,  1437, -1524,    45,
    3784,  1819,   877,  2873, -1328,  1970,  2205,  2874,  1186,  3422,
    1569,   830,  1465,  4912,  1049,  3420,  4859,    74,  1049,  2173,
    3545,   831,  3062,  1043,  4642,  3857,  4864,  1043,  1020,  1850,
    1674, -1536,  3671,   994,  1677,   413,  1858,  1005,  3046,  1005,
    1820,  1005,  1186,  2875,  2176,  3787,  1603,  1005,  1413,  1414,
    2205,  1316,   822,  2676,   995,  1789,  1723,  1971,  1947,  1415,
    -165,  2384,  3062,  4687,  4897,  1739,  4050,  3423,  2170,  4088,
    1005,  1005,  2384, -1955,  -589,  4706,  2178,  1826, -1328,  2645,
    4696,  -143,  -143,  3858,  2173,  4888,  3062,  -165,  4824,  1048,
    2393,  4852,  3223,  1048,  4051,  1667,  4841,   433,  3125,  3168,
      37,    38,    39,    40,  2208,  1317,    43,    44,  1463,  1687,
    1028,    45,  1031,  1032,  1697,  1416,  1218,  3642,    35,   994,
    4234,   832,    37,    38,    39,    40,    41,    42,  4209,    44,
    4679,  3169,   215,  2271,  3427,  3428,  3429,  3430,  3431,  3432,
     995,  2178,  1941,  2644,  3240,  4353,  1205,  4665,  1972,  3427,
    3428,  3429,  3430,  3431,  3432,  4357,  2385,  1667,  1723, -1988,
    4853,   223,  2929,  3170,  2705,  2876,  4371,  2385,  4466,  2394,
    3508,  4684,  4089,  3672,  3508,  4090,  1963,  4752,  4459,   215,
    3421,  1942,  2926,  3791,  1430,  4854,  3809,  4479,  1005,  4643,
    2317,  2630,  1821,  4789,  1186,   411,  1973,  1057,   233,  2808,
    4347,  3422,   365,  1100,  1186,  3673,   823,  1690,   223,  4019,
     236,  2192,  2193,  2194,  2195,  2196,  2197,  4599,  1416,  3636,
    3792,  4356,  1416,  4889, -1328,  2790,  3085, -1849,  1913,  3757,
    4786,  4787,  3171,  3793,  3016, -1331,  1101,  3674,  3427,  3428,
    3429,  3430,  3431,  3432,   246,   233,   994,  1159,   122,  1105,
    1005,  4753,  1970,  4281,   833,  2498,  4590,   236,  2318,  3423,
    1431, -1955,  1218,  1186,  3759,  2468,   126,   995,  1915,  2631,
    1404,   994,  4843,  3884,  1409,  1410,  1411,  1107,  2042,  1974,
    2044,  1822,   369,  2048,  1422,  2050, -2006,  2983,  2053,  2054,
    2055,  2965,   995,  2791,  1694,  3643,  3335,  1696,  4666,  4315,
    4316,  2062,  1081,  1770,  2704,  3017,  4235,  3309,  1106, -1331,
    3340, -2033,  1808,  2319,  2085,  3794,  2086, -1955,  4600, -1328,
      81,    81,  3644,    81,  4480,  2002,  1111,    79,    79,  4470,
      79,  1107,  1186,  1943,  3810,  4150,  2439,  3283,  3284,  3285,
    3286,  4153,  4154,  4155,  4156,  4157,  4158, -1988,  2792,  1667,
    2611,  1623,  2793,  2351, -1328,  1987,  2267, -1328,  1121,  1382,
    2274,  2275,  1235,  2279,  2003,  3396,   878,  4747,  4496,  4881,
    3902,  4907,  1113,  1113,  1107,  1113,  4497,  4232,  4489,  2565,
    2499,  3070,  2500,   971,  3331,  1162,  3618,  2755,  2614,  4042,
    1629,  1913,  4490,  3552,  3549,  1972,  3637,  1134,    37,    38,
      39,    40,  2615, -1988,  2616,    44,  2617,  1598,  2618,  2619,
    1138,  1599,  2563,  3447,  1289,  4587,  1290,  4359,  2566,  1186,
      74,    74,  1944,    74,  2612,  3619,  3424,  3425,  3426,  4748,
    3427,  3428,  3429,  3430,  3431,  3432,  2194,  2195,  2196,  2197,
    1809,  2388,  1005,  1973,  3472,  2794,  2211,  1186,  1624,  2632,
     839,  1088,  3150,  1236,  3520, -1331,  3521,  1631,  1103,  3876,
    3153,  2633,  3155,  1987,  3050,  1135,  1824,  3071,  2564,  2389,
    1054,  4270,  1825,  4271, -2006,  1186,  1186,  4792,  1186,  2165,
    4874,   372,  3853,  2584,   718,   718,  4561,  4562,  4617,   840,
    1108,  2201,  2374,  1237,  4664,  1186,   433,  4295,    35, -2033,
    4296,  2670,  2375,  2584,  4749,   373,    41,    42,  4556,  1643,
    3521,  2679,  1094,  2224,  2225,  4750,  2004,  3508,  2376,   894,
    1136,  1117,  3508,  2686,  1137,  3508,  1974,  1218,  1688,  1689,
   -2006,  4498,  2240,   372,   372,   372,  2318,  1124,  4793,  1667,
    2795,    80,  1238,  1667,  1667,  4491,  1186,   413,  1740,  4067,
   -1331,  1135,  4518,  4915,   839, -2033,   820,   373,   373,   373,
    1208,  1209,  1210,  4060,  1211,  1212,  1213,  1214,  1215,  1216,
    2567,  1135,  4735,  1826,  2484,  1186,   896,  3620,  4743,  1186,
    1186,  3139,  1741,   372,  2726, -1331,   718,  2731, -1331,  2733,
     372,  2319,  2736,   840,  2173,  2412, -2372,   372,   208,   413,
     413,   413,  2390,  4699,  1044,  2005,  1136,   373,   820,  2259,
    2585,   412,   412,  4705,   373,  2333,  1159,  1138,  2329,  2176,
     365,   373,   829,  1717,  4068,  1834,  1136,  4297,   709,  3607,
    2585,  1044,  1005,  2320,  3140,  4523,  1005,  1005,  2485,  1742,
    3240,  2358,  4814,  2347,  2349,  4572,  2992,  4574,  1563,   413,
    2377,  2178,  4762,     8,  4485,  1718,   413,  1913,  4210,  2568,
     412,  4539,  4540,   413,   215,  4727,  3621,  2355,  1629,  1176,
    1049,  1743,   820,  2359,  3028,  2041,  4394,  4395,  2043,  1043,
    4069,  2047,  4060,  2049,  3617,  3141,  2052,  1719,  1138,  3364,
    2056,  2109,   921,   223,   894,  4486,  1667,  1049,   938,  4389,
    4694,   841,  1667,  1138,  1913,  2360,  1043,   411,  1564,  2325,
    2125,  1414,  1139,  4861,  1827,   904,  1044,   905,  4865,   192,
     879,  3325,  4211,  1138,  1019,  2259,  3029,  2283,  1127,  2339,
     233,  1140,  3508,  1913,   968,  1631,  2346,  2348,   829,   910,
    2152,  3162,   236,  1870,  1871,  1048,  1828,  3163,  1128,  1667,
    2498,   896,  1667,  1667,  2163,  -385,  3348,  2284,  1129,   411,
     411,   411,  3611,  4390,  4430,  4431,  4079,    37,    38,    39,
      40,  2284,  1048,  1632,    44,  3142,   246,  4728,  1829,  3146,
    2181,  2182,  1049,  1794,  1055,    37,    38,    39,    40,  1005,
    1685,  1043,    44,   839,  4911,  1005,  4065,   372,  2586,  2738,
     208,   215,  2427,  1913,  1746,  3236,  2285,  4172,  4360,   411,
    4918,  3588,  1747,  1686,  3024,  1667,   411,   822,  2586,  1748,
    2285,   373,  2577,   411,  1833,  2185,  2665,  1834,  3146,   208,
     223,  1795,   840,  2462,  3630,  1750,  1987,  2587,  1165,  3028,
    1913,  1792,  1005,  1751,  4729,  1005,  1005,  2453,  3164,  1111,
    1111,  1720,  1111,  2757,  4173,  3560,  1834,  1048,  1130,  4086,
    4091,  2763,  1391,   413,  4188,  4672,  -910,   233,  1913,   822,
    2920,  3474,   820,  1793,  3475,  2499,  1191,  2500,  3143,   236,
    3543,   130,   131,  1721,  3350,  2249,  3144,  3818,   208,  3145,
     904,  3604,   905,  1752,    35,   433,  3476,  2454,    37,    38,
      39,    40,    41,    42,    43,    44,  1202,  3100,  1005,    45,
    2764,  1796,  1227,  4866,   910,  1722,  2936,   369,  1581,  2504,
    2707,  1121,  2708,  1186,  1131,  2594,  2710,  1723,  2711,  1913,
    3102,  2713,  1186,   822,  1310,  2714,  1234,  3489,   829,  4060,
    2230,   975,    37,    38,    39,    40,  3932,  3933,  2756,    44,
    3894,  2745,  4067,  1310,  2144,  2470,  1797,  3101,  1798,  3087,
     976,  4589,  1311,  2765,  2774,    81,  4446, -1340,    81,  2506,
    3757,   823,    79,  2145,  1233,    79,  2751,   369,  2752, -1340,
    3103,  3816,  2753, -1340,  4603,  2920,  1723,  2754,  1815,  3165,
     935,  1132,  2766,   977,  4726,  4447,  3477,  2767,  1800,  1242,
    1218,  3478,  2471,  2472,  3990,  1312,  2234,  2173,  3667,  2192,
    2193,  2194,  2195,  2196,  2197,  2656,  3898,  3354,  1275,  1186,
    1816,  3166,  2057,   411,  1312,  1817, -1340,  4068,  3664,  4373,
    3965,  3517,  2176,  3991,  3938,  1280,  2468,  1802,   994,  3887,
    3668,  3798,  4604,  3665,  2768,  2058, -1340,  1465,  4340,  4314,
    3420,  4840,  1818,  3167,  1282,  1186,  1186,   372,  3993,   995,
    4598,  2541,  3264,  1186,  2178,    74,  1186,  4660,    74,  1186,
    3553,  4624,  3669,  1804,  2799,  4313,  3888,  1186,  1186,  4242,
     433,   373,  1299,  4069, -1340,  1186,  3989,   823,  1186,  1186,
    1186,  1186, -1340,  2542,  1887,  2951,  1609,  1987,  1186,  1186,
    2439,  1186,  1313,  1186,  1186,  3610,  3236,  1186,  3897,  2863,
    1629,  2450,  2864,  3579,  1630,  1314,  2235,  3172,  3174,  2455,
    3479,  1913,  1186,   413,   856,  2543,  1305,  1186,  3018,  3480,
    3021,  1186,   820,   822,  2865,  1186,  2544,  1186,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,   372,  1186,  4913,  3173,
    3175,  4914,  2009,  1186,  1319,  3990,  1186,  3995,  2769,    37,
      38,    39,    40,  2545,  2770,  3704,    44,  2787,  2788,  3914,
     373,  1105,  3915,  2010,  1322,  2800,   433,  1631,   215,  2803,
    2804,  1381,   433, -1376,  3991,  2853,  3705, -1376,  2509,  1598,
      45,  3240,  2771,  1599,  2825,   372,  2826,   372,   829,  3992,
    2967,   921,  1465,  4062,  4063,  3420,  3245,   223, -1340,  3993,
    4627,  2772,   413,   192,  3012,  1632,  2848,  1186,  2849,   373,
    3814,   373,  3958,   412,    37,    38,    39,    40,    43,  2866,
    1106,    44,  3994,    45,  2867,  2773,  3422,  4628,  4125,  2868,
    1292,  1167,  1293,  3362,   233,  2514,  1465,   372,   978,  3420,
   -1376,   433,  4546,  1168,  1169,   365,   236,  1465,  3246,  4126,
    3420,   413,  1149,   413,  1620,  1336,  3959, -1328,  2339,  1620,
    3288,   373,   412,  1170,   412,  3289,  1171,    37,    38,    39,
      40,  2470,  1353,   411,    44,  1667,  1362,   823, -1376,  3916,
     979,   215,  1368,  2609,  3423,   215,  1107,  1847,  3774,  3917,
      81,   969,    81,  3289,  4002,  1697,  1380,    79,  3995,    79,
   -1375,  2639,  2020,   413, -1375,   365,  2021,  4166,  2841,  2144,
     223,  2844,   820,  3799,   223,  3801,  1000,  1663,  2471,  2472,
    1005,  3137,  4194,    35,  1384,  3247,  3248,    45,  2145,  2020,
    1186,    41,    42,  2694,  1425,  1186,  3899,   372,  3249,  1429,
     372,  1186,  2146,  3553,  4007,  4009,  4610,   233,  2869,  1439,
    3393,   233,  2468,  4169,  2700,  4171,  3553,  2870,  4174,  1445,
    4175,   373,   411,   236,   373,  2259,  3394, -1375,  1005,  1450,
    3395,  1913,  4547,  1780,  1781,  3848,  1913,  1913,   829,  3640,
    1452,  3422,  1172,   822,  2121,  3250,  2365,  1913,  1690,  2031,
      74,  2032,    74,   246,  2861,  3210,  1451,   246, -1103,  2260,
    1453, -1103,  1108,   413,  2144, -1375,   413,  1273,  2108,  1454,
     246,   411,   820,   411,  1279,   820,  1455,    37,    38,    39,
      40,  1456,  1173,  2145,    44,  3422,  1459,  3147,    45,  2265,
    1598,  2266, -1852,  2920,  1599,  1460,  3422,  2148,  4083,  3423,
    1667,  1584,  3280,  2121,  2121,  2365,  1715,  4568,  1667,  1462,
    1667,  3424,  3425,  3426,  1586,  3427,  3428,  3429,  3430,  3431,
    3432,  2540,  1590,   411,  1331,   938,  1591,  2121,  3121,  2365,
    4145,  3989,  1592,  3251,  3068,  3252,  3147,  1740,   829,  2133,
    2134,   829,  4244,  3423,    37,    38,    39,    40,  2268,  3522,
    2269,    44,  2172,  1597,  3423,  2173,  1610,  2470,    80,  4184,
    4185,  4186,  2292,  4318,  4519,  4520,  4521,  4522,  4502,  1618,
    2470,  1741,  2470,  3682,  4302,  2310,  2311,  1186,   365,  1913,
    2176,  3593,  3594,  1617,  3596,  4191,  1620,  2177,  3446,  1465,
    3448,  3449,  3420,  1005,  2699,  1621,  2700,   823,  2658,  2659,
    3990,  1005,  3147,  1005,  2471,  2472,  2720,  3147,  2721,  4320,
    1641,  2722,  2178,  2721,  4263,  1441,  1101,  2471,  2472,  2471,
    2472,  1627,  4716,   411,  4718,  2748,   411,  2749,  1742,  3991,
    1642,    35,   433,   822,  2942,  1648,  1987,  3147,  2468,    41,
      42,  2957,  2958,  1458,  3992,  3000,    45,  2749,  3078,  1913,
    3079,  2468,  1566,  2468,  3993,  1656,  1578,  1331,  1580,  3133,
    1743,  3134,    37,    38,    39,    40,  3424,  3425,  3426,    44,
    3427,  3428,  3429,  3430,  3431,  3432,  1652,  3994,  4182,  4183,
    4184,  4185,  4186,  1149,  3228,  3239,  3229,  1653,  4449,  4182,
    4183,  4184,  4185,  4186,  3498,  3499,  3500,  4187,  1186,    37,
      38,    39,    40,  3241,  1646,  3242,    44, -1399, -1399,  3685,
    3424,  3425,  3426,  1657,  3427,  3428,  3429,  3430,  3431,  3432,
    2180,  1101, -2582, -2582,  1658,  3427,  3428,  3429,  3430,  3431,
    3432,  2172,  1661,   822,  2173,  1659,   822,  1667,  3356,  1660,
    2721,  2181,  2182,   709,   709,  4168,  1662,  1913,  1698,  3392,
    1668,  2700,  1744,  3995,  1671,    37,    38,    39,    40,  2176,
    1669,  1186,    44,  2310,  2976,  1186,  2177,  3402,   372,  2700,
    4196,  3405,  1701,  2700,   372,  3409,  1700,  2700,  3422,  1186,
    1186,  4242,  1703,  3410,  1745,  2700,  2185,   823,  1709,   208,
    4287,  2178,   373,  1746,  4435,  3436,  1733,  2700,   373,  2186,
    3452,  1747,  2700,  3457,  3493,  3458,  3494,  4198,  1748,  1186,
    1186,  3495,  1715,  3496,  1186,  3658,  1749,  3659, -1500, -1500,
   -1500, -1500,  1738,  4442,  1750, -1500,  1186,  1186,  1186,  1186,
    1005,  1756,  1751,  3808,   413,  3811,  3423,  3553,  1785,  1186,
     413,  1787,  1186,   820,  1186, -1507, -1507, -1507, -1507,   820,
    1823,  3662, -1507,  3663,  1186,  1186,  1832,  3739,  1186, -1498,
   -1498, -1498, -1498,  3805,  1873,  3806, -1498, -1501, -1501, -1501,
   -1501,  1186,  1841,  1186, -1501,  4178,  4179,  1186,  2751,   369,
    2752,  3835,  1752,  3836,  2753,  1842,  3842,   823,  3843,  2754,
     823,  1843,  4278,  1186,  1851,  2179,  3453,  4526,  1853,  2180,
    3740,  3903,  3460,  2700,  1186,  1711,  1186,  1186,  1186,   829,
   -1499, -1499, -1499, -1499,  3939,   829,  3940, -1499,  3555,  3556,
    2181,  2182,  1867,  3949,  3741,  3950,  3883,  3961,  1855,  2700,
    1186,  1860,  4034,  1667,  4035,  2183,  4820,  4038,  4066,  4039,
    2721,  3742,  1186,  3200,  3201,  3743,  3893,  1186,  4162,  4319,
    4163,  2749,  1877,  4380,  1186,  4381,  1874,  1331,  4488,  1865,
    1186,    80,    80,  3744,    80,  2185,  4386,  1723,  2721,  4502,
    2192,  2193,  2194,  2195,  2196,  2197,  3718,  3719,  2186,  3745,
    3561,  3562,  4557,  1331,  4387,  4481,  2721,  4482,  4528,  4530,
    4529,  2700,  1919,  1921,   411,  4369,  4432,  4538,  1923,  2749,
     411,  1935,  1915,  3424,  3425,  3426,  -182,  3427,  3428,  3429,
    3430,  3431,  3432,  4607,  4621,  4608,  4622,  1626,  1937,  1628,
    1186,  2339,  1939,  4661,  3544,  4662,  1005,  4674,  2087,  2749,
    1951,  4681,  3317,  1987,  4686,  4688,  3825,  3825,  4745,  1913,
    2229,   372,   372,   372,  4756,  4767,  4757,  2749,  4768,  1331,
    3458,  4769,  1740,  2700,  1959,   856,  3746,  2188,  4772,  4774,
    1987,  3825,  1975,  1980,  3747,   373,   373,   373,  4791,  1967,
    2749,  2814,  4797,  4339,  2749,  4342,  1981,  1913,  1913,  4798,
    1913,  2749,  4829,  1982,  1987,  2837,  1741,  4863,  1983,  4909,
    4609,  4910,  3715,  4923,  1984,  4910,  1986,  1987,  3748,  1993,
    2029,  1996,  1998,   695,   822,  1997,  1999,   413,   413,   413,
     822,  2001,  2006,  2007,  2008,  2013,   820,   820,   820,  2091,
    2063,  2166,  2093,  2106,  4673,  2097,  2107,  2099,  2100,  2115,
    1913,  2171,  1913,  2118,  2163,  2119,  2202,  4365,  2120,  2124,
    2229,  2209,   246,  1742,  2126,  2189,  2190,  2191,  2861,  2192,
    2193,  2194,  2195,  2196,  2197,  2129,  2130,   372,  2233,  2131,
    2132,  2137,  3784,  4676,  2244,  2139,  2140,  3492,  2141,  3785,
    1331,  3828,  2142,  2239,   372,  1743,  1913,  1331,  1331,  3786,
    3502,   373,   829,   829,   829,  2143,  2150,  2151,  2153,  1415,
    4709,  2254,  2815,  2154,  4714,  4715,  2155,  2156,   373,  2157,
    1218,  1913,  2158,  2159,  3318,  3863,  2815,  3787,  4462,  3788,
    2160,  2264,  2272,  1465,  1630,  1632,  3420,   365,  2299,  2307,
    2309,   916,  2316,   413,  1138,  2324,  2330,  3751,  1913,  2332,
    2334,  2342,   820,  4321,  2345,  1667,  3502,  4435,  2343,  1100,
     413,  1913,  2350,  3829,  2352, -2524,  2354,  1101,  1667,   820,
    2361,  2363,  2362,  2896,  2365,  2366,  3839,  1101,   823,  2367,
     709,  2368,  2369,   927,   823,  2395,  2370,   411,   411,   411,
    4710,  2391,  2417,  4571,  2419,  2420,  3862,  4713,  2421,  2422,
    2443,  2444,  2450,  2452,  3789,  3738,  2462,  3975,  3976,  3977,
    3978,  2463,  2465,  2466,  2467,  2474,  2475,   927,   829,  2468,
    2476,  2479,  2594,  2480,   208,  2481,  1913,  2487,  3319,  2494,
    2488,  2491,  2492,  2501,  1770,   829,  1747,  1913,  2502,  2526,
    2508,  2515,  2527,  1748,  2531,  2532,  4777,  2516,  1005,  2556,
    1913,  1834,  2172,  3764,  3767,  2173,  2528,  2569,  2557,  1750,
    3790,  1005,  2397,  4741,  2537,  3791,  2539,  1751,  2571,  2581,
    2579,  2595,  2572,  2582,  2121,  2598,  2127,  2601,   890,  2624,
    2176,  1186,  2111,  2602,  2607,  2629,  2643,  2177,  2642,  3812,
    2605,  2648,  2651,  2653,  4222,  4223,  2398,   822,   822,   822,
    2608,  1809,  3792,   411,  2661,  2654,  2672,  2673,   372,  2674,
    2399,  2655,  2178,  2675,  1667,  3793,  1186,  1752,  2510,  1913,
     411,  3320,  3422,  2400,  2688,  1186,  2689,   888,  2716,  2732,
    2737,  1186,   373,  1186,  2746,  2782,  4819,  2759,  1913,  1186,
    2823,  2717,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,
    1186,  1186,  2836,  2781,  2824,  1186,  1186,  2173,  2842,  4646,
    2846,  2847,  2854,  1913,  2401,  4275,  4276,  4277,  1186,  2879,
    2860,  2906,  1186,  4813,   413,  4693,  1186,  2877,  2922,  2923,
    3423,  2925,  2928,   820,  2930,  2933,  1186,  2943,  2934,  1186,
    1106,  1186,  2952,  2402,  2944,  2953,  2956,  3794,  2403,  1913,
    1186,  1186,  1186,  2962,  2985,  2219,  1186,  1005,   894,  1186,
    2982,  1760,  4579,   822,  2984,  2999,  2179,  1761,  3001,  1186,
    2180,  3002,  3003,  3019,  3014,  3022,  3024,  3026,  -904,  1186,
     822,  3027,  3032,  3035,  3038,  3041,  3944,  1186,  3055,  1186,
    4593,  2181,  2182,  3058,  4884,  3069,  2620,  3074,  3123,   829,
    3076,   823,   823,   823,  3128,  3135,  2183,  3132,  3136,  1762,
    3176,  3189,  3193,  4117,  3197,   896,  3198,  3202,  3194,  3203,
    3207,  3205,  3206,  3208,  3209,  1218,  3219,  3221,  3232,  2000,
    3225,  3235,  3237,  1186,  3230,  3236,  2185,  3243,  3238,  1186,
    2015,   365,  3262,  3267,  3275,  1186,  2404,  3281,  3553,  2186,
    3294,  3287,  3290,  1218,   365,  3295,  3296,  3279,  3310,  3312,
    1763,   372,  3324,  3327,  3330,   372,  3328,   372,  1764,  3329,
    1186,  1765,  3332,  3333,   365,   856,    80,  3346,  4146,    80,
    3347,  3341,  2698,  3344,   411,   373,  3358,  3359,  3352,   373,
    3370,   373,  2760,  3360,  3378,  3363,  3361,  3424,  3425,  3426,
    3382,  3427,  3428,  3429,  3430,  3431,  3432,  3384,  3387,  2405,
    3389,  1431,  3390,  3407,  3454,  2406,  3403,   823,  2407,  3404,
    3473,  3406,  3442,  3468,  1766,  3408,  3488,   413,  2188,  3411,
    3412,   413,  1913,   413,   823,  3414,   820,  3417,  3435,  1667,
     820,  2700,   820,  2408,  3441,  3443,  3444,  4043,  3481,  2409,
    3451,  3466,  3511,  3491,   904,  3467,   905,  4419,  4420,  3519,
    4422,  3516,  2410,  -950,  3517,   907,  3567,  4788,  3565,  3571,
    3577,  3583,  3581,  3592,  3582,   909,  3595,  3586,   910,  1767,
    2020,  3587,  1768,  3597,  3606,  2798,  2411,  3613,  3598,    35,
    3634,  3635,  1769,  3121,   822,  4098,  3602,    41,    42,  3627,
    1770,  3647,   829,  3649,  3603,  3680,   829,  3681,   829,  1771,
    3684,  2814,  2814,  1667,  3268,  3686,  2814, -2582, -2582,  3687,
    2192,  2193,  2194,  2195,  2196,  2197,  3691,  3688,  3689,  2329,
    3690,  3692,  1005,  3693,  3694,  2163,  3695,  3696,  3697,  3698,
    3699,  1772,  3700,  3701,  3708,  3982,  1773,  3710,  1005,  2524,
    3706,  3716,  3722,  3728,  3729,  1186,  2814,  2814,  3730,  3762,
    3731,  2327,  3732,  3733,  3775,  3776,  3815,  3763,  3771,  3802,
    3813,  2696,  3139,  1774,  3817,  3824,  3825,  3830,  3834,  3837,
    4785,  1913,  3833,  3860,  3840,  3879,  3880,   411,  3868,  3870,
    3881,   411,  3882,   411,  3885,  3862,  3890,  2927,  3891,  3892,
    3901,  3906,  3438,  2108,  3420,  3437,  1005,  3935,  2167,  3936,
    3964,  1913,  1186,  1186,  3963,  3937,  3943,  4004,  3972,  3951,
    4010,  1413,  1414,  4001,  3988,  3140,  4376,  4020,  4021,  1775,
    4177,  4030,  2815,  2815,  3767,  1200,  4023,  2815,  4053,  4071,
    4026,  1221,  4027,  1218,  4073,  4192,  4074,  4081,   823,  4084,
    1231,  4022,  4082,  4092,  4044,  4099,  4100,  4101,  4111,  4122,
    1667,  4112,  4113,  4138,  2172,  4087,  4142,  2173,  4151,  4114,
    4152,  3269,  1186,  4115,  4116,  4206,  3141,  2815,  2815,  1291,
    4149,  4374,  4180,  4214,  1300,  3852,  4218,  4227,  4225,  4228,
    2721,  4230,  2176,   709,  4231,  1309,  4246,   822,  4250,  2177,
    4251,   822,  4237,   822,  4264,  4253,  4261,  4260,  1186,  1698,
    4266,    80,  4268,    80,  4274,  4279,  4282,  4283,  1186,  1186,
    4284,  1913,  4400,  4285,  2178,  4286,  1186,  1186,  4294,  4303,
    4304,  1186,  1913,  4305,  1178,  4306,  4291,  1186,  1186,  4336,
    4311,  1186,  1199,  4298,  4335,  4343,  4299,  4307,  4348,  4331,
    4367,  3522,  4333,  1005,  4346,  4349,  1186,  4351,  4375,  4352,
    1186,  4377,  4366,  4383,  4397,  4370,  3142,  4405,  4382,  1186,
    4412,  4398,  4423,  4399,  1186,  1276,  4415,  4429,  4433,  4440,
    4448,  4445,  4455,  4463,  4467,  1580,  1186,  4468,  4472,  3471,
    4483,  4474,  4493,  4499,  4487,  4500,  4508,  4362,  4516,  4524,
    4532,  4534,  4535,  4525,  4527,  4543,  3270,  4550,  4536,  4537,
    4553,  4559,    81,  4573,  4565,  4563,  4569,  4588,  4585,    79,
    4595,  4596,  4601,  4457,  1186,  4602,  4611,  4213, -2582,  4620,
    4630,  1334,  2180,  4618,  4631,  4633,  4634,  4648,  4636,  1913,
    1343,  4650,  4651,  4652,  4654,  3271,  4649,  4655,  4656,  4669,
    4677,   823,  4683,  2181,  2182,   823,  4692,   823,  1107,  4700,
    1913,  4737,  4707,  4730,  4734,   372,  4760,  3317, -2582,  3143,
    4740,  4754,  1913,  4755,  4761,  4766,  4775,  3144,  4680,  4770,
    3145,  4771,  4776,  4781,  3179,  4794,  4711,  1740,  4680,   373,
    2339,  2014,  4783,  4799,  4800,  4803,  4805,  4809,  2185,  4816,
    4817,  4821,  4818,  4012,  4847,  4839,   707,  4842,  4801,  4858,
    1913,  2186,    74,  4844,  4850,  4802,  1005,  4875,  4887,  4898,
     372,  1741,  3212,   365,  4905,  4916,  4908,  1119,  2538,  3278,
    3212,   413,  4921,  1759,  2251,  3127,  3546,  4720,   695,   695,
     820,  4469,  3645,  4096,   373,  3188,  2663,  3735,  4605,  4434,
    4722,  4632,  4478,  4635,  4248,  2669,  4460,  1005,  3600,  4645,
    3357,  4845,  4577,  4883,  2677,  2678,  4806,  4804,  4856,  4742,
    4409,  4410,  4249,  3605,  1186,  4413,  4414,  3260,  1742,  4217,
    2641,  3656,  2690,  3282,  1007,  3261,   413,  4095,  2621,  4219,
   -2582,  3244,  4886,  3738,  3820,   820,  4220,  4922,  4917,  3750,
    3772,  4857,  4594,  2606,  1007,  4796,   829,  3311,  4848,  4597,
    1743,  4280,  1024,  1331,  4695,  4256,  2081,  3082,  4773,  4257,
    4759,  4868,  3707,  4919,  1332,  1594,  3317,  4625,  2706,  1913,
    2938,  3550,  3502,  2939,  4236,  4368,  3502,  4040,  2270,  3318,
    3551,  3353,  2961,  1616,  2296,  2295,  1740,  3563,  1331,  3559,
    3767,  3767,  3767,  3767,  3767,  2960,  2955,  2300,  1005,  3576,
    3564,   829,  1186,  3984,  4341,  4570,  1913,  1602,  2030,  4685,
    2303,  1186,  4041,  3945,  3955,  4675,  4830,  4838,   365,  4831,
    1741,  3554,  2192,  2193,  2194,  2195,  2196,  2197,  1186,  1186,
    3486,   411,  1186,  3399,  3484,  4037,  1152,  2905,  3861,  3326,
    1969,  2657,  2986,  1186,  4828,  2315,  1122,  1379,  1186,  2308,
    2977,  1186,  2990,  4046,  3541,  2993,  1186,  1186,  2991,  4047,
    4025,  2814,  4358,  1679,  2814,  2814,  2814,  2814,  2814,  2814,
    2814,  2814,  2814,  2814,  4567,  2088,  2218,  1742,  1854,   208,
    1680,  2312,  1145,  1746,  2997,  3355,   411,    83,  1859,  1186,
       0,  1747,  2718,  1708,  3942,  2017,     0,     0,  1748,     0,
       0,     0,     0,     0,     0,     0,  1834,  1420,     0,  1743,
       0,     0,     0,  1913,  1750,     0,     0,  1186,     0,     0,
    1667,     0,  1751,  2814,  2814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3318,     0,
       0,   822,     0,     0,     0,     0,     0,  1961,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4566,     0,     0,
       0,     0,  1752,  2935,     0,     0,  3320,  3852,     0,     0,
       0,     0,  2815,     0,     0,  2815,  2815,  2815,  2815,  2815,
    2815,  2815,  2815,  2815,  2815,     0,   822,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,   365,
    1913,     0,     0,  1005,     0,  2815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1331,     0,     0,
       0,     0,  1186,  1913,     0,  1186,     0,  1186,   208,     0,
       0,     0,  1746,     0,  2815,  2815,     0,     0,     0,     0,
    1747,     0,     0,     0,  1186,     0,     0,  1748,  1186,     0,
       0,     0,     0,  1913,   372,  1834,  1897,     0,     0,     0,
       0,     0,     0,  1750,     0,     0,     0,     0,     0,     0,
       0,  1751,     0,     0,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,   823,     0,     0,     0,  1913,
       0,     0,     0,  1913,  1913,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3502,
       0,     0,     0,     0,  3502,     0,     0,  3502,     0,     0,
     413,  1752,  4904,     0,     0,  3320,     0,  1331,  1186,   820,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1913,     0,     0,     0,     0,     0,     0,  4765,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   695,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,   829,     0,     0,     0,     0,
       0,     0,     0,     0,  3661,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2814,     0,  2089,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3683,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,  4870,   369,  4871,     0,     0,  4763,  4872,     0,
       0,     0,     0,  4873,     0,     0,  1186,  1186,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
     372,  3212,     0,     0,  3212,  3212,     0,     0,  3212,     0,
       0,  4870,   369,  4871,     0,     0,     0,  4872,  3212,     0,
       0,     0,  4873,  1873,   373,     0,     0,     0,     0,  3760,
       0,     0,     0,     0,  3502,  3769,     0,     0,     0,     0,
    1186,     0,  3760,     0,     0,     0,     0,     0,  2815,     0,
    1186,     0,   372,     0,     0,  1331,  2536,  1331,     0,  4870,
     369,  4871,     0,   372,     0,  4872,   413,     0,     0,     0,
    4873,     0,     0,  4894,     0,   820,   373,  3334,  1760,     0,
       0,     0,     0,     0,  1761,     0,     0,   373,     0,  3823,
       0,  3342,  3343,     0,     0,  3345,     0,   703,  2814,  2814,
     822,  3349,   721,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,  3847,  1331,   413,     0,
       0,     0,     0,     0,  1186,  4894,  1762,   820,  4893,   413,
       0,     0,     0,     0,     0,     0,  4894,     0,   820,     0,
     721,   829,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2610,
       0,   721,     0,     0,     0,     0,  4892,     0,     0,     0,
       0,  3385,     0,     0,     0,  2536,     0,  1763,     0,  1016,
    4893,     0,     0,     0,     0,  1764,     0,     0,  1765,     0,
       0,  4893,  1017,   829,     0,  2089,     0,     0,     0,     0,
    1025,     0,     0,     0,   829,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1035,     0,  1016,  4892,  2815,
    2815,  1056,     0,     0,     0,     0,   411,     0,     0,  4892,
       0,  1085,     0,  2536,     0,     0,     0,     0,     0,  1090,
       0,  1766,     0,     0,     0,     0,  1007,     0,  1007,     0,
    1007,    35,     0,     0,   823,     0,  1007,     0,     0,    41,
      42,     0,     0,     0,     0,  2172,  3956,     0,  2173,     0,
       0,  2483,     0,     0,     0,     0,     0,     0,   411,  1007,
    1007,     0,     0,     0,     0,  2174,     0,     0,  2175,   411,
       0,     0,     0,  2176,     0,  1760,  1767,     0,     0,  1768,
    2177,  1761,  2172,     0,     0,  2173,     0,  2662,     0,  1769,
       0,   365,     0,     0,     0,     0,  2668,  1770,     0,  4017,
       0,     0,  2174,     0,     0,  2178,  1771,     0,     0,     0,
    2176,     0,     0,     0,     0,     0,   822,  2177,     0,     0,
       0,  2555,     0,  1762,     0,     0,     0,     0,     0,     0,
    4903,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
    2089,     0,  2178,  1773,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2172,     0,     0,  2173,     0,     0,     0,  1760,   822,     0,
    1813,     0,     0,  1761,  1763,     0,     0,  1007,   365,   822,
    2174,     0,  1764,  1199,     0,  1765,  2597,     0,  2176,     0,
       0,   707,   707,     0,     0,  2177,  1695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2179,
       0,     0,     0,  2180,  2814,  1762,     0,     0,     0,     0,
    2178,  3609,     0,  4531,     0,     0,  1775,     0,     0,     0,
       0,     0,     0,     0,  2181,  2182,     0,     0,  1766,  1007,
    2814,  2814,     0,  3760,     0,     0,  2179,  2664,     0,  2183,
    2180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4118,     0,     0,  4119,     0,  4120,  1763,     0,     0,     0,
     823,  2181,  2182,     0,  1764,     0,  2184,  1765,     0,  2185,
       0,     0,     0,  4140,  4141,     0,  2183,  3648,     0,  3650,
       0,     0,  2186,  1767,     0,  2187,  1768,     0,     0,     0,
       0,  3212,     0,     0,     0,     0,  1769,  3212,  3212,  3212,
    3212,  3212,  3212,  2184,  1770,     0,  2185,  1331,     0,     0,
       0,  4170,   823,  1771,  2179,     0,     0,     0,  2180,  2186,
    1766,     0,  2187,   823,     0,  2815,     0,     0,   695,     0,
       0,     0,     0,     0,  2815,  3769,     0,     0,     0,  2181,
    2182,     0,     0,     0,     0,  1837,  4193,  4195,  4197,  4199,
    1773,  2815,  2815,     0,  2183,  3004,     0,  3702,     0,     0,
    3008,  2188,  3709,  3011,     0,     0,     0,     0,     0,     0,
       0,  2172,     0,     0,  2173,  1767,     0,  1838,  1768,     0,
       0,  2184,     0,     0,  2185,  3033,     0,     0,  1769,     0,
       0,  2174,     0,     0,     0,     0,  1770,  2186,  2188,  2176,
    2187,     0,     0,     0,     0,  1771,  2177,     0,     0,  4255,
       0,     0,     0,     0,  3072,     0,     0,     0,     0,     0,
       0,  1007,     0,     0,     0,     0,     0,     0,     0,  2851,
       0,  2178,     0,  1775,  2814,     0,     0,  3086,     0,     0,
     721,     0,  1773,     0,     0,     0,     0,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
    3117,     0,     0,     0,     0,     0,     0,     0,     0,  1774,
    4289,     0,     0,     0,     0,     0,  2188,     0,     0,     0,
       0,     0,  3138,     0,     0,  3148,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,  2931,  3040,
       0,     0,  3156,     0,  2932,  1199,     0,     0,     0,  3160,
       0,  3864,     0,     0,     0,  3867,     0,  3869,     0,  3871,
    3872,     0,  3183,     0,     0,  1775,     0,     0,  3877,     0,
       0,  3190,     0,     0,     0,  2179,     0,     0,     0,  2180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2815,     0,     0,     0,     0,
    2181,  2182,     0,  3895,  2189,  2190,  2191,     0,  2192,  2193,
    2194,  2195,  2196,  2197,     0,  2183,     0,     0,     0,     0,
    3413,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4363,  4364,     0,     0,     0,     0,     0,     0,     0,
       0,  1760,  2184,     0,     0,  2185,     0,  1761, -2091,     0,
       0,  1007,     0,    80,     0,  1007,  1007,     0,  2186,     0,
    1182,  1188,  1188,   721,     0,  1188,  1195,     0,  1182,   703,
    1085,     0,  1204,  1220,     0,   703,     0,  1085,     0,  1085,
       0,     0,     0,  1188,   703,  1085,     0,     0,     0,  1762,
       0,     0,     0,     0,  1245,     0, -2091,     0,     0,  1085,
       0,  1182,     0,     0,     0,  1188,     0,   721, -2091,  1188,
       0,     0, -2091,   703,     0,  1204,  1220, -2091,   703,  1302,
       0,     0, -2091,     0,     0, -2091,  1188,     0, -2091,   703,
       0,     0,     0,     0,     0,     0,     0,  2188,   707,     0,
    1763,     0,     0,     0,     0,  3089,     0,     0,  1764,     0,
       0,  1765,     0,  1330,     0, -2091,     0,  1182,     0,     0,
    3212,  3212,   721,     0,     0,     0,  1182,     0,     0,  1204,
    1220,     0,     0,     0,  1331, -2091,     0,     0,  4438,     0,
    4439,     0,     0,  4443,  4444,  1188,     0,     0,     0,     0,
       0,  3769,  3769,  3769,  3769,  3769,     0,  1395,     0,     0,
    2172,     0,     0,  2173,  1766,     0,     0,     0,  1007,     0,
       0,     0,     0, -2091,  1007,     0,     0,     0,     0,     0,
    2174, -2091,     0,     0,     0,  2189,  2190,  2191,  2176,  2192,
    2193,  2194,  2195,  2196,  2197,  2177,     0,     0,     0,  1085,
    4476,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1085,  1449,     0,     0,     0,     0,     0,     0,  1767,
    2178,  1007,  1768,     0,  1007,  1007,     0,     0, -2091,  4501,
       0,     0,  1769,     0,     0,     0,     0,  3234,  1555,     0,
    1770,     0,   721,  1085,     0,     0,  1330,     0,     0,  1771,
       0,     0,  4289,  4289,  4289,  4289,     0,     0,     0,     0,
    1085,     0,     0,     0,  1085,  3386,     0,  2172,     0,  3388,
    2173,     0,  1555,     0,  1020,     0,     0,     0,     0,     0,
       0,  2414,  1085,     0,     0,     0,  1773,  1007,     0,     0,
       0,     0,     0,     0,  1085,  2176,     0, -2091,     0,     0,
       0,     0,  2177,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2415,     0,     0,  2172,     0,     0,  2173,
   -2091,     0, -2091, -2091,  2179,     0,     0,  2178,  2180,     0,
       0,     0,   703,   703,     0,     0,  2174,     0,     0,     0,
       0,     0,     0,     0,  2176,     0,     0,     0,     0,  2181,
    2182,  2177,     0,     0,     0, -2091,     0,     0, -2091, -2091,
       0, -2091,     0,     0,  2183,     0,     0,     0,     0,  1775,
       0,     0,     0,     0,  3760,  1085,  2178,     0,     0,     0,
       0,     0,     0,     0,  1188,  1188,     0,     0,     0,     0,
       0,  2184,     0,     0,  2185,  3589,     0,     0,  3212,     0,
       0,     0,  4606,     0,     0,  3379,     0,  2186,  3509,     0,
    2187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1182,     0,     0,     0,     0,     0,
       0,  2179,     0,     0,  1182,  2180,     0,  1220,     0,     0,
       0,     0,     0,     0,     0,     0,  4269,     0,     0,     0,
    1188,     0,     0,  4272,  4273,     0,  2181,  2182,     0,     0,
       0,     0,     0,     0,  3509,     0,  1085,     0,     0,     0,
       0,  2183,  1928,     0,  1188,  1188,     0,     0,     0,     0,
    2179,     0,     0,     0,  2180,     0,  2188,     0,  1085,  1085,
    1085,  1188,     0,  1182,     0,     0,     0,  1966,  2184,     0,
       0,  2185,     0,     0,     0,  2181,  2182,     0,     0,     0,
       0,     0,     0,     0,  2186,     0,     0,     0,     0,     0,
    2183,     0,  3666,     0,     0,  1928,     0,  1188,  1188,  3678,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1330,  2184,     0,     0,
    2185,     0,     0,     0,     0,     0,     0,     0,  1204,     0,
       0,     0,  1555,  2186,     0,     0,  2187,     0,     0,     0,
       0,     0,  1330,     0,  2189,  2190,  2191,  1331,  2192,  2193,
    2194,  2195,  2196,  2197,     0,     0,     0,  3712,     0,     0,
    3461,     0,     0,  2188,  2172,     0,     0,  2173,     0,     0,
       0,     0,  2066,  2066,     0,     0,     0,  1085,     0,  1016,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2176,     0,     0,     0,     0,     0,     0,  2177,
       0,  2098,     0,  2172,  1085,     0,  2173,  2104,  1330,     0,
       0,     0,  2188,     0,     0,     0,     0,     0,     0,  1555,
       0,     0,     0,  2174,  2178,     0,     0,     0,     0,     0,
       0,  2176,     0,     0,     0,     0,     0,     0,  2177,     0,
       0,     0,     0,  4403,  4404,     0,     0,  1555,     0,     0,
       0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,     0,     0,  2178,     0,     0,     0,  3612,     0,     0,
       0,     0,     0,     0,     0,  1555,  1555,     0,  1555,  1007,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3482,
       0,     0,     0,  4426,  4427,  1555,     0,     0,     0,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,  2536,     0,     0,  2845,   721,   721,  2172,     0,     0,
    2173,     0,     0,     0,     0,     0,     0,  1007, -2582,  1330,
    3886,   707,  2180,     0,     0,     0,  1330,  1330,     0,     0,
       0,     0,     0,  1085,     0,  2176,  1555,  1695,  3896,     0,
       0,     0,  2177,  2181,  2182,     0,     0,     0,  3675,     0,
    3677,     0,     0,     0,     0,     0,     0,  2179, -2582,     0,
       0,  2180,     0,     0,     0,  1555,     0,  2178,     0,  1555,
    1555,     0,     0,     0,     0,     0,     0,     0,     0,  1085,
    1085,  2306,  2181,  2182,     0,     0,     0,  4895,  2185,     0,
       0,     0,     0,     0,  3703,     0,     0,  2183,     0,     0,
       0,  2186,     0,     0,     0,     0,     0,   721,  4512,   703,
    4513,  4514,     0,     0,     0,     0,     0,     0,     0,  3721,
       0,  4517,     0,     0,  2184,  1199,     0,  2185,     0,     0,
       0,     0,  3969,     0,     0,     0,     0,     0,     0,  4895,
    2186,     0,     0,  2187,     0,     0,     0,     0,     0,     0,
    4895,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2582,     0,     0,     0,  2180,     0,     0,     0,     0,
   -2582,     0,  1007,     0,     0,     0,     0,     0,     0,     0,
    1007,     0,  1007,     0,     0,     0,  2181,  2182,  2449,     0,
       0,     0,     0,     0,  1085,     0,     0,  1188,     0,     0,
       0, -2582,     0,     0,     0,     0,     0,     0,     0,  2188,
       0,     0,     0,     0,  3089,  1220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2185,     0,     0,     0,     0,     0,     0,  3865,     0,
       0,     0,     0,     0,  2186,     0,     0,  1188,  1188,  1188,
    1188,  1085,     0,  3509,     0,     0,     0,     0,     0,     0,
     703,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,  4080,     0,     0,     0,     0,     0,  1204,  1204,  2552,
       0,  1085,     0,     0,     0,     0,     0,     0,     0,  1188,
    1188,     0,     0,     0,     0,  1188,     0,  2189,  2190,  2191,
       0,  2192,  2193,  2194,  2195,  2196,  2197,  3907,     0,     0,
       0,  3761,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2582,     0,     0,  3912,     0,     0,  2172,
       0,     0,  2173,     0,     0,  4127,     0,     0,  4130,     0,
       0,     0,  1188,     0,     0,     0,     0,     0,  4671,     0,
       0,  3934,     0,     0,  3509,     0,     0,  2176,     0,     0,
    4148,     0,  2172,   703,  2177,  2173,     0,     0,     0,  1188,
    1188,  1188,  1188,     0,     0,     0,     0,     0,     0,   703,
       0,     0,  2174,     0,     0,     0,     0,  2089,  2552,  2178,
    2176,     0,     0,     0,     0,     0,     0,  2177,     0,     0,
       0,     0,     0,  1182,  4697,     0,     0,     0,     0,  1007,
     721,     0,  1182,     0,     0,  2192,  2193,  2194,  2195,  2196,
    2197,  1220,  2178,     0,     0,     0,  1085,     0,     0,     0,
       0,     0,     0,  4721,     0,  1085,     0,   703,     0,     0,
       0,  1188,  1188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3970,     0,     0,  1085,     0,     0,
    1395,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2172,     0,     0,  2173,     0,     0,     0,     0,
       0,  2066,     0, -2582,     0,     0,     0,  2180,     0,  1182,
       0,     0,  2174,  1085,  1085,     0,     0,     0,     0,     0,
    2176,  1085,     0,     0,     0,     0,     0,  2177,  2181,  2182,
       0,     0,     0,     0,     0,     0,  2179,  1016,  1016,     0,
    2180,  2762,     0, -2582,     0,  1555,  1555,     0,     0,     0,
       0,     0,  2178,  1555,     0,     0,  1555,     0,     0,  1555,
       0,  2181,  2182,     0,     0,     0,     0,  1555,  1555,     0,
       0,     0,     0,  2185,     0,  1555,  2183,  1220,  1555,  1555,
    1555,  1555,     0,     0,     0,     0,  2186,     0,  1555,  1555,
       0,  1555,     0,  1555,  1555,     0,     0,  1555,     0,     0,
       0,     0,     0,  2184,     0,     0,  2185,     0,     0,     0,
       0,     0,  1555,     0,     0,  1007,  1188,  1555,     0,  2186,
       0,  1555,  2187,     0,     0,  1555,     0,  1555,  1555,  1555,
    1555,  1555,  1555,  1555,  1555,  1555,     0,  1555,     0,     0,
       0,     0,  1085,  1555,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2179,     0,     0,     0,
    2180,     0,     0,     0,     0, -2582,     0,  1085,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4880,  2181,  2182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2183,     0,  2188,     0,
       0,     0,     0,  1085,     0,  1085,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2184,     0,     0,  2185,     0,     0,  4224,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2186,
       0,     0,  2187,  2968,     0,  2975,     0,     0,     0,     0,
    3509,     0,     0,  4406,  3509,     0,     0,  2192,  2193,  2194,
    2195,  2196,  2197,     0,     0,  4416,     0,     0,     0,     0,
       0,     0,   703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,     0,   703,
    3954,  4428,     0,     0,   703,     0,     0,   703,   721,     0,
       0,     0,     0,  1016,     0,  1016,     0,     0,  2188,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   703,
    1555,     0,     0,     0,     0,  1182,     0,  1188,  1188,  1188,
       0,  1182,  1220,     0,  1188,     0,  1188,     0,  1188,  1188,
       0,     0,     0,     0,     0,     0,     0,     0,   703,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2089,   703,     0,  2449,     0,     0,     0,     0,     0,  3090,
       0,     0,     0,     0,  3099,     0,     0,     0,     0,     0,
    1085,     0,     0,     0,   703,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,  1007,  3130,  3130,
    4029,     0,     0,     0,     0,   721,   703,     0,     0,   703,
    1007,     0,     0,     0,     0,  2172,     0,     0,  2173,  1188,
       0,     0,     0,     0,     0,     0,   703,     0,     0,     0,
       0,     0,     0,   703,     0,     0,     0,     0,     0,     0,
       0,     0,  3178,  2176,  3180,  3182,   703,     0,     0,     0,
    2177,     0,     0,     0,     0,   703,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4393,     0,     0,
       0,     0,     0,     0,  1188,  2178,  2172,     0,     0,  2173,
       0,     0,  1188,  1188,  1188,  1188,  1188,  1188,  4402,     0,
       0,     0,     0,     0,     0,     0,  2174,  1555,     0,     0,
    4411,     0,     0,     0,  2176,     0,     0,     0,     0,     0,
       0,  2177,     0,     0,     0,     0,     0,     0,     0,     0,
    2449,     0,     0,  1204,     0,  3130,  1085,     0,     0,     0,
    1016,     0,     0,     0,     0,     0,  2178,     0,  4425,     0,
    3973,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3178,  1007,     0,     0,     0,
       0,     0,  1188,  3308,     0,     0,     0,     0,     0,     0,
       0,     0,  1330,  1966,     0,     0,     0,  3509,     0, -2582,
       0,     0,  3509,  2180,     0,  3509,     0,     0,     0,     0,
    1188,  3130,  1188,  3130,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,  2182,     0,  1330,     0,     0,
       0,     0,     0,     0,  1204,     0,     0,     0,  1555, -2582,
       0,     0,     0,  3509,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2066,
    2179,     0,     0,     0,  2180,     0,     0,     0,     0,  2185,
       0,  4592,     0,     0,  2172,   703,     0,  2173,     0,     0,
       0,     0,  2186,     0,     0,  2181,  2182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   703,     0,     0,
    2183,  1182,  2176,     0,     0,  1182,     0,     0,  1199,  2177,
       0,     0,     0,  1188,  2089,     0,     0,     0,     0,  1555,
    1555,     0,     0,     0,     0,     0,     0,  2184,     0,     0,
    2185,     0,     0,     0,  2178,     0,     0,     0,     0,     0,
       0,     0,     0,  2186,     0,     0,  2187,     0,     0,  1555,
    1555,     0,     0,     0,  1555,     0,     0,     0,     0,     0,
       0, -2582,  3509,     0,     0,     0,  1555,  1555,  1555,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1555,
       0,     0,  1555,     0,  1555,  3465,     0,     0,     0,     0,
    2172,     0,     0,  2173,  1555,  1555,     0,     0,  1555,  4324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2174,  1555,  3509,  1555,     0,  1220,     0,  1555,  2176,     0,
       0,     0,  2188,     0,     0,  2177,     0,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,  1085, -2582,     0,
       0,     0,  2180,     0,  3510,     0,  1555,  1555,  1555,     0,
    2178,  1007,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
       0,     0,     0,  2181,  2182,     0,  1330,  1007,     0,     0,
    1555,     0,     0,     0,     0,     0,     0,     0, -2582,     0,
       0,     0,  1555,     0,     0,     0,     0,  1555,     0,     0,
       0,  1085,     0,     0,  1555,     0,     0,     0,     0,     0,
    3510,     0,     0,  3570,     0,     0,     0,  2975,  2185,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,  2186,     0,     0,  4055,  1007,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   703,
       0,  2089,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2179,     0,     0,     0,  2180,     0,
    1555,     0,  3130,     0,     0,     0,     0,  2066,     0,     0,
       0,  3703,     0,     0,     0,     0,  1330,     0,     0,  2181,
    2182,     0,     0,     0,  1188,     0,  1188,  1188,     0,     0,
       0,     0,     0,     0,  2183,     0,     0,     0,     0,     0,
   -2582,     0,  4811,     0,     0,     0,     0,  2089,     0,     0,
       0,  2089,  2089,     0,     0,     0,     0,     0,     0,  3509,
       0,  2184,     0,     0,  2185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2186,     0,     0,
    2187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4846,     0,  2172,     0,     0,  2173,     0,
       0,     0,     0,     0,     0,     0,   703,     0,     0,     0,
       0,     0,  1007,   703,     0,  2174,     0,     0,     0,     0,
       0,     0,     0,  2176,     0,     0,     0,     0,     0,     0,
    2177,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2172,     0,     0,
    2173,     0,     0,     0,     0,  2178,  2188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2174,     0,     0,
       0,   703,     0,     0,     0,  2176,   721,     0,     0,     0,
       0,     0,  2177,     0,     0,  3130,  3130,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2178,     0,     0,
       0,     0,     0,     0,  3768,     0,     0,     0,  4920,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1330,     0,  1330,     0,     0,     0,
    1085,     0,     0,     0,  2189,  2190,  2191,     0,  2192,  2193,
    2194,  2195,  2196,  2197,     0,     0,   828,     0,  4292,  2179,
       0,     0,     0,  2180,     0,  2066,  1085,     0,     0,     0,
       0,     0,     0,  1085,     0,  1007,     0,  1085,     0,     0,
       0,     0,     0,     0,  2181,  2182,     0,     0,     0,     0,
    1085,     0,     0,     0,     0,     0,  1330,     0,     0,  2183,
       0,   828,     0,     0,  2172,   721,     0,  2173,     0,     0,
       0,  2179,     0,     0,     0,  2180,  1007,     0,     0,  1085,
       0,     0,  1085,     0,  2174,   703,  2184,     0,     0,  2185,
    3878,     0,  2176,     0,     0,     0,  2181,  2182,     0,  2177,
       0,  1182,  2186,     0,   703,  2187,     0,  1047,     0,     0,
       0,  2183,     0,     0,     0,  1047,     0,  1047,     0,     0,
    1085,     0,   703,     0,  2178,     0,     0,     0,  1188,   828,
       0,     0,     0,     0,     0,     0,  1555,     0,  2184,     0,
       0,  2185,     0,     0,     0,  1555,     0,     0,     0,     0,
       0,  1555,     0,  1555,  2186,     0,     0,  2187,     0,  1555,
       0,     0,  1555,  1555,  1555,  1555,  1555,  1555,  1555,  1555,
    1555,  1555,     0,     0,     0,  1555,  1555,  1007,     0,     0,
       0,  2188,     0,     0,     0,     0,     0,     0,  1555,     0,
       0,     0,  1555,     0,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1555,     0,     0,  1555,
       0,  1555,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,  1555,  1555,     0,     0,     0,  1555,     0,  2179,  1555,
       0,     0,  2180,  2188,     0,     0,  1085,  1085,  1085,  3510,
    3987,     0,     0,     0,  3987,  4000,     0,     0,     0,  1555,
       0,     0,     0,  2181,  2182,  4014,     0,  1555,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,  2183,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
       0,     0,     0,  4326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2184,     0,     0,  2185,     0,
       0,  1760,     0,  1555,     0,     0,     0,  1761,     0,  1555,
       0,  2186,     0,  2975,  2187,  1555,     0,     0,     0,     0,
       0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,     0,     0,  1794,     0,  4533,     0,     0,     0,     0,
    4061,  2066,  2066,     0,  2552,     0,     0,     0,     0,  1762,
       0,     0,     0,     0,     0,     0,  1188,  1188,  1188,  1188,
       0,     0,     0,     0,     0,   703,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1795,     0,     0,     0,     0,     0,  4094,     0,  1908,
    2188,     0,  1007,     0,     0,     0,     0,     0,     0,     0,
    1763,     0,     0,     0,     0,     0,     0,     0,  1764,     0,
       0,  1765,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   703,
       0,     0,   703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4143,     0,     0,     0,
       0,     0,   721,     0,   703,     0,     0,     0,     0,     0,
       0,  1796,     0,     0,  1766,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1330,     0,  2189,  2190,
    2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,     0,  4575,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3768,     0,  1797,     0,  1798,     0,
       0,     0,  1085,     0,     0,     0,     0,     0,     0,  1799,
       0,     0,  1768,  1188,     0,  1555,     0,     0,     0,     0,
       0,  1085,  1769,     0,     0,     0,     0,     0,     0,     0,
    1770,     0,     0,     0,  2449,     0,     0,     0,  1800,  1771,
       0,     0,  1908,     0,  1085,     0,     0,     0,     0,     0,
       0,     0,     0,  3178,   939,     0,     0,     0,  4243,     0,
       0,     0,  2449,     0,  3878,     0,   940,     0,     0,     0,
       0,  1801,  1555,  1555,     0,     0,  1773,  1802,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   941,     0,
       0,     0,     0,     0,     0,     0,  3130,     0,  3130,     0,
       0,     0,   942,  1803,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1804,     0,   943,   703,     0,     0,     0,
       0,     0,  2172,     0,     0,  2173,     0,     0,     0,     0,
       0,     0,  1555,   944,     0,     0,     0,     0,     0,     0,
       0,     0,  2174,     0,     0,     0,  4764,     0,     0,     0,
    2176,     0,     0,     0,     0,     0,   945,  2177,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,  1555,     0,
       0,     0,  2172,     0,   946,  2173,     0,     0,  1555,  1555,
       0,     0,  2178,  2238,     0,   947,  1555,  1555,     0,     0,
     948,  1555,  2174,     0,     0,     0,   949,  1555,  1555,     0,
    2176,  1555,     0,  1085,  1085,  1085,  1085,  2177,     0,     0,
    3987,     0,   950,  4332,     0,     0,  3510,     0,     0,     0,
    3510,     0,     0,   828,     0,     0,  4345,     0,     0,  1555,
       0,  1184,  2178,     0,  1555,     0,     0,     0,     0,  1184,
    4355,     0,     0,     0,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,  1220,     0,     0,     0,     0,
       0,     0,     0,  3570,     0,     0,     0,  2975,     0,     0,
     951,  2172,  1184,     0,  2173,     0,     0,     0,     0,     0,
       0,  1016,     0,     0,  1555,     0,  2179,     0,   952,     0,
    2180,  2174,     0,     0,     0,     0,     0,     0,   953,  2176,
       0,  3130,  3130,     0,     0,     0,  2177,     0,  1908,     0,
       0,  2181,  2182,     0,     0,     0,     0,   856,  4401,     0,
       0,     0,     0,     0,     0,     0,  2183,   703,  1184,     0,
       0,  2178,     0,     0,     0,     0,  2179,  1184,     0,   703,
    2180,     0,     0,     0,   954,     0,     0,     0,     0,   955,
       0,   956,  1188,  2184,     0,  1908,  2185,   957,     0,     0,
     958,  2181,  2182,     0,     0,     0,  1188,     0,     0,  2186,
       0,     0,  2187,     0,     0,   703,  2183,     0,     0,     0,
       0,     0,     0,     0,  1908,   959,     0,   960,     0,     0,
       0,   961,     0,  1330,     0,     0,     0,     0,     0,   962,
       0,  2066,     0,  2184,   963,     0,  2185,     0,     0,     0,
    3768,  3768,  3768,  3768,  3768,   964,     0,     0,     0,  2186,
       0,     0,  2187,     0,     0,     0,     0,     0,   965,     0,
       0,     0,     0,     0,  1555,  2179,     0,     0,     0,  2180,
       0,     0,     0,     0,     0,     0,     0,     0,  2188,  1184,
       0,     0,     0,     0,  1908,  1047,     0,     0,     0,  1047,
    2181,  2182,  1188,  2449,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1908,     0,  2183,     0,     0,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,  1908,  1085,     0,  4511,     0,     0,     0,  2188,     0,
       0,     0,  2184,     0,     0,  2185,     0,     0,     0,     0,
     703,     0,     0,     0,     0,     0,     0,     0,  2186,  1908,
       0,  2187,  1555,     0,     0,     0,     0,     0,     0,     0,
       0,  1555,     0,     0,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,  1555,  1555,
    4616,     0,  1555,     0,     0,     0,     0,     0,     0,  3987,
       0,     0,     0,  3510,     0,     0,     0,     0,  3510,     0,
       0,  3510,  3178,     0,  4555,     0,  1555,  1555,     0,     0,
    1908,     0,     0,     0,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,  2188,     0,     0,
    4810,     0,     0,   703,     0,   703,     0,     0,     0,  4061,
    1220,  1188,  1188,  1188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1184,     0,  1182,  1220,     0,
       0,     0,     0,     0,     0,  1184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2066,  1911,
       0,     0,     0,     0,  1182,     0,     0,     0,     0,     0,
       0,     0,     0,  1085,     0,  2189,  2190,  2191,     0,  2192,
    2193,  2194,  2195,  2196,  2197,     0,  3130,     0,  2449,  4906,
       0,     0,     0,  2172,  1184,     0,  2173,     0,     0,     0,
    4243,     0,     0,     0,     0,  1085,     0,     0,     0,     0,
       0,     0,     0,  2174,     0,     0,     0,  1188,  4061,     0,
       0,  2176,     0,     0,     0,     0,     0,     0,  2177,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1555,     0,     0,  1555,     0,  1555,     0,     0,
       0,     0,     0,  2178,     0,     0,     0,     0,     0,     0,
       0,     0,  1908,  1184,  1555,     0,     0,     0,  3510,     0,
       0,  4555,     0,     0,     0,     0,     0,  4691,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1188,
       0,     0,     0,  1085,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1188,  1188,  1188,  1188,
       0,     0,  1911,     0,     0,     0,  1330,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2172,     0,     0,  2173,
       0,     0,     0,     0,     0,     0,     0,     0,  1555,     0,
    1184,     0,     0,     0,     0,     0,  2174,  2179,     0,     0,
    2945,  2180,     0,     0,  2176,     0,     0,     0,     0,     0,
       0,  2177,     0,     0,     0,     0,     0,     0,  1184,     0,
       0,     0,  2181,  2182,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2178,  2183,     0,     0,
       0,     0,     0,     0,     0,     0,  1184,  1184,     0,  1184,
    1555,     0,     0,     0,     0,     0,  1188,     0,  1220,     0,
       0,     0,     0,     0,  2184,  1555,  1184,  2185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2186,     0,  2946,  2187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1188,     0,     0,  1182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,  1204,     0,     0,     0,  4061,     0,  1184,   828,     0,
       0,     0,     0,     0,  4511,  2172,     0,     0,  2173,     0,
       0,     0,     0,  4691,     0, -2093,  1555,  1555,     0,   703,
    2179,     0,     0,     0,  2180,  2174,  1184,     0,     0,  1182,
    1184,  1184,     0,  2176,     0,     0,     0,  1188,     0,  2188,
    2177,     0,  1908,     0,     0,  2181,  2182,  1908,  1908,     0,
       0,     0,     0,  2172,     0,     0,  2173,     0,  1908,     0,
    2183,     0,     0, -2093,     0,  2178,     0,     0,     0,     0,
    1555,     0,     0,  2174,     0, -2093,     0,     0,     0, -2093,
    1555,  2176,     0,     0, -2093,  1188,     0,  2184,  2177, -2093,
    2185,     0, -2093,     0,     0, -2093,     0,     0,     0,     0,
       0,     0,     0,  2186,     0,     0,  2187,     0,  1911,     0,
       0,     0,     0,  2178,   828,     0,     0,     0,     0,     0,
       0,  1047, -2093,     0,     0,     0,     0,  2189,  2190,  2191,
       0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,  4024,
       0,     0, -2093,  1555,     0,     0,     0,  3437,  1047,     0,
       0,     0,  3438,     0,  1182,  1911,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2179,
       0,     0,     0,  2180,     0,     0,     0,     0,     0,     0,
   -2093,     0,  2188,     0,  1911,     0,     0,     0, -2093,     0,
    1908,     0,     0,     0,  2181,  2182,     0,     0,     0,     0,
       0,     0,     0,  1201,     0,     0,     0,     0,     0,  2183,
    1223,     0,     0,     0,     0,     0,     0,  2179,  1232,     0,
       0,  2180,     0,     0,     0,     0,     0,  1243,     0,     0,
       0,  2947,  1274,  1047,     0, -2093,  2184,     0,     0,  2185,
       0,     0,  2181,  2182,     0,     0,     0,     0,     0,     0,
       0,     0,  2186,     0,  1911,  2187,     0,  2183,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2189,  2190,  2191,  1911,  2192,  2193,  2194,  2195,  2196,  2197,
       0,  1020,     0,     0,  2184,     0,     0,  2185,     0,     0,
       0,  1911,     0,     0,     0,     0,     0,     0,     0,     0,
    2186,     0,     0,  2187, -2093,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   828,     0,     0,     0,     0,  1911,
       0,     0,     0,  3946,     0,     0,     0, -2093,     0, -2093,
   -2093,  2188,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1908,     0,
       0,     0, -2093,     0,     0, -2093, -2093,     0, -2093,     0,
       0,     0,     0,     0,  1184,     0,     0,     0,     0,  2188,
    1911,     0,     0,  1184,  1448,     0,     0,     0,     0,     0,
       0,     0,  3947,  1187,  1189,     0,     0,  1192,  1193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1229,  1573,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
       0,     0,     0,  1596,     0,     0,     0,  1281,     0,     0,
       0,  1284,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1622,     0,     0,  1307,     0,
       0,     0,  2172,     0,     0,  2173,     0,  2189,  2190,  2191,
    1184,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,     0,
       0,     0,  2174,     0,     0,     0,     0,     0,     0,     0,
    2176,     0,     0,     0,     0,     0,     0,  2177,     0,     0,
       0,     0,     0,     0,     0,     0,  1184,  1184,     0,     0,
       0,     0,     0,     0,  1184,     0,     0,  1184,     0,     0,
    1184,     0,  2178,     0,     0,     0,     0,     0,  1184,  1184,
       0,     0,     0,     0,     0,     0,  1184,     0,     0,  1184,
    1184,  1184,  1184,     0,     0,     0,     0,     0,     0,  1184,
    1184,     0,  1184,     0,  1184,  1184,     0,     0,  1184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1911,  1184,   828,     0,     0,     0,  1184,     0,
       0,     0,  1184,     0,     0,     0,  1184,     0,  1184,  1184,
    1184,  1184,  1184,  1184,  1184,  1184,  1184,     0,  1184,     0,
       0,     0,     0,  4878,  1184,     0,     0,  1184,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2172,  2179,     0,  2173,     0,
    2180,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,  2174,     0,     0,  3401,     0,
    1908,  2181,  2182,  2176,     0,     0,     0,     0,     0,     0,
    2177,  1953,  1956,  1957,     0,     0,  2183,     0,  1184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2178,     0,     0,  1908,  1908,
       0,  1908,     0,  2184,     0,     0,  2185,     0,     0,     0,
       0,     0,     0,     0,     0,  2172,     0,     0,  2173,  2186,
       0,     0,  2187,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2174,     0,     0,     0,  4879,
       0,     0,     0,  2176,     0,     0,     0,     0,     0,     0,
    2177,  1908,     0,  1908,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1783,  1784,     0,     0,
       0,     0,     0,     0,   828,  2178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1573,     0,     0,     0,     0,     0,     0,  1908,  2188,  2179,
       0,  1184,     0,  2180,     0,     0,  1184,     0,     0,     0,
       0,     0,  1184,     0,     0,     0,     0,  1573,     0,     0,
       0,     0,  1908,     0,  2181,  2182,     0,     0,     0,     0,
       0,     0,  1868,     0,     0,     0,     0,     0,     0,  2183,
       0,     0,  1911,     0,     0,     0,     0,  1911,  1911,  1908,
       0,     0,     0,     0,     0,     0,  1930,  1931,  1911,     0,
       0,     0,  1908,     0,     0,     0,  2184,     0,     0,  2185,
       0,     0,     0,  1958,   828,     0,     0,   828,     0,  2179,
       0,     0,  2186,  2180,     0,  2187,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,  2182,     0,     0,     0,  1990,
    1992,     0,     0,     0,     0,     0,     0,     0,     0,  2183,
       0,     0,     0,     0,     0,     0,     0,  1908,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1908,     0,
       0,     0,     0,     0,     0,     0,  2184,     0,     0,  2185,
       0,  1908,     0,     0,     0,     0,  2255,     0,     0,     0,
       0,  2188,  2186,     0,     0,  2187,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2172,     0,  3415,
    2173,     0,     0,     0,     0,     0,     0,     0,  1184,     0,
    1911,     0,     0,     0,     0,     0,     0,  2174,     0,     0,
    3445,     0,     0,  2304,     0,  2176,     0,     0,     0,     0,
       0,     0,  2177,     0,     0,     0,     0,     0,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2178,     0,  1908,
       0,  2188,     0,     0,     0,     0,     0,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
    1911,     0,     0,     0,  1908,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,     0,     0,  1184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2461,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
       0,  2179,     0,     0,     0,  2180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1911,     0,
       0,     0,     0,     0,     0,     0,  2181,  2182,     0,     0,
       0,     0,  1184,     0,     0,     0,  1184,     0,     0,     0,
       0,  2183,     0,     0,  2523,   725,     0,     0,     0,     0,
    1184,  1184,     0,     0,     0,   725,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2184,     0,
       0,  2185,     0,     0,  2553,     0,     0,     0,     0,     0,
    1184,  1184,     0,     0,  2186,  1184,     0,  2187,     0,     0,
       0,     0,   725,     0,     0,     0,     0,  1184,  1184,  1184,
    1184,     0,     0,   926,     0,   828,   725,   842,     0,     0,
    1184,   828,   926,  1184,     0,  1184,   725,     0,     0,     0,
       0,     0,     0,     0,     0,  1184,  1184,     0,     0,  1184,
       0,     0,     0,     0,     0,     0,   725,     0,  2172,     0,
       0,  2173,  1184,  1908,  1184,     0,     0,     0,  1184,     0,
       0,     0,   926,     0,     0,   843,     0,     0,  2174,     0,
       0,     0,     0,  2188,  1184,     0,  2176,     0,   844,     0,
       0,     0,     0,  2177,     0,  1184,     0,  1184,  1184,  1184,
       0,     0,     0,     0,     0,  1099,   845,     0,     0,  2464,
       0,     0,   846,     0,     0,     0,     0,     0,  2178,     0,
       0,  1184,     0,     0,     0,     0,     0,     0,     0,   847,
       0,     0,     0,  1184,     0,     0,     0,     0,  1184,  2681,
       0,     0,     0,     0,     0,  1184,     0,   848,  2685,     0,
       0,  1184,     0,     0,     0,     0,     0,     0,   849,  2519,
    2520,  2521,  2522,   850,     0,     0,     0,     0,     0,   851,
    2703,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,     0,     0,     0,     0,   852,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2560,  2561,     0,     0,  3450,     0,  2570,     0,     0,
     853,  1184,  1908,     0,     0,     0,  1573,  1573,     0,     0,
       0,     0,  2179,     0,     0,     0,  2180,     0,     0,     0,
    1911,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1908,   854,     0,     0,     0,  2181,  2182,     0,
       0,     0,     0,     0,  2591,     0,     0,     0,     0,     0,
       0,   855,  2183,     0,     0,     0,     0,     0,  1911,  1911,
       0,  1911,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2625,  2626,  2627,  2628,     0,     0,     0,  1148,  2184,
     856,     0,  2185,     0,     0,     0,     0,     0,   828,   828,
     828,     0,     0,     0,     0,  2186,     0,     0,  2187,     0,
       0,     0,     0,     0,     0,     0,     0,   857,     0,     0,
       0,  1911,     0,  1911,   858,     0,     0,     0,     0,     0,
     859,     0,     0,   860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2904,     0,     0,     0,     0,
       0,     0,  1908,     0,  2692,     0,     0,     0,   861,     0,
     862,     0,     0,  1908,   863,     0,     0,  1911,     0,     0,
    2924,     0,   864,     0,     0,     0,     0,   865,     0,     0,
       0,     0,     0,     0,  2188,     0,     0,     0,   866,     0,
       0,     0,  1911,     0,     0,     0,     0,     0,     0,     0,
       0,   867,     0,     0,     0,     0,  2937,     0,  2940,     0,
       0,     0,     0,     0,   828,     0,     0,     0,     0,  1911,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   828,  1911,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2172,     0,     0,  2173,     0,     0,
    1908,     0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,
    2196,  2197,     0,     0,  2174,     0,     0,  3456,     0,     0,
       0,  1908,  2176,     0,     0,     0,     0,  1911,     0,  2177,
       0,     0,     0,  1908,     0,     0,     0,     0,  1911,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2858,     0,
       0,  1911,     0,     0,  2178,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1908,     0,     0,     0,     0,     0,     0,  2172,     0,
       0,  2173,  1184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2174,     0,
       0,     0,     0,     0,     0,     0,  2176,     0,     0,     0,
       0,   926,   926,  2177,     0,     0,     0,  1184,     0,     0,
    1911,     0,     0,     0,     0,     0,  1184,     0,  1148,     0,
       0,     0,  1184,  3108,  1184,     0,     0,     0,  2178,  1911,
    1184,     0,     0,  1184,  1184,  1184,  1184,  1184,  1184,  1184,
    1184,  1184,  1184,     0,     0,     0,  1184,  1184,  2179,     0,
       0,     0,  2180,     0,  1911,     0,     0,     0,     0,  1184,
       0,     0,     0,  1184,     0,   828,     0,  1184,     0,     0,
       0,     0,     0,  2181,  2182,     0,     0,  1184,     0,     0,
    1184,     0,  1184,     0,     0,     0,     0,     0,  2183,     0,
    1911,  1184,  1184,  1184,     0,     0,     0,  1184,     0,     0,
    1184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1184,     0,     0,     0,     0,  2184,     0,  1908,  2185,     0,
    1184,     0,     0,     0,     0,     0,     0,     0,  1184,     0,
    1184,  2186,  2179,     0,  2187,     0,  2180,  1194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1222,     0,  1224,
       0,  1226,     0,  1228,     0,     0,     0,  2181,  2182,  3042,
    3043,  3044,     0,     0,     0,     0,  3052,     0,  3054,  3277,
    3056,  3057,  2183,  1277,  1184,     0,     0,     0,     0,     0,
    1184,  1286,     0,     0,     0,     0,  1184,  1045,     0,     0,
       0,  1303,  1304,     0,     0,  1045,  1306,  1045,     0,  2184,
       0,     0,  2185,     0,     0,     0,     0,     0,     0,     0,
    2188,  1184,  1148,     0,   926,  2186,     0,     0,  2187,     0,
       0,     0,     0,     0,  1908,     0,     0,     0,     0,  1335,
       0,     0,     0,     0,     0,  2172,     0,     0,  2173,     0,
       0,     0,     0,     0,  1357,     0,     0,  1359,     0,  1361,
       0,  1364,     0,     0,     0,  2174,     0,     0,  3953,     0,
       0,  3151,     0,  2176,     0,   725,   926,     0,   828,     0,
    2177,     0,   828,  1911,   828,     0,     0,     0,     0,     0,
     725,     0,   725,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   725,     0,  2188,  2178,     0,     0,  2189,  2190,
    2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,   725,   725,     0,     0,     0,  3204,     0,  1446,  3904,
    1447,  1908,     0,     0,  3213,  3214,  3215,  3216,  3217,  3218,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1908,     0,     0,     0,     0,     0,
       0,  1148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1908,     0,     0,     0,     0,     0,
       0,     0,  2189,  2190,  2191,  1099,  2192,  2193,  2194,  2195,
    2196,  2197,     0,     0,     0,     0,  1184,     0,     0,  2179,
       0,     0,     0,  2180,  3298,     0,     0,     0,     0,     0,
    1908,     0,     0,     0,  1908,  1908,     0,     0,     0,     0,
   -2105,     0,  1911,     0,  2181,  2182,     0,     0,     0,     0,
       0,     0,  3336,     0,  3338,     0,     0,     0,     0,  2183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1911,  1184,  1184,     0,  1702,     0,  1704,     0,
    3497,     0,  1706,     0,     0,     0,  2184,     0, -2105,  2185,
       0,  2172,     0,     0,  2173,     0,     0,     0,     0,     0,
   -2105,     0,  2186,     0, -2105,  2187,     0,     0,     0, -2105,
       0,  2174,     0,     0, -2105,     0,     0, -2105,     0,  2176,
   -2105,     0,     0,     0,     0,     0,  2177,     0,     0,     0,
       0,     0,     0,  1184,  1573,     0,     0,     0,     0,     0,
       0,     0,  1840,     0,     0,     0,     0, -2105,     0,     0,
       0,  2178,     0,     0,     0,  3391,     0,     0,     0,  1856,
       0,     0,     0,     0,     0,     0,     0, -2105,     0,  1184,
    1864,     0,     0,     0,     0,     0,     0,  1866,     0,  1184,
    1184,  2188,  1911,     0,     0,     0,     0,  1184,  1184,     0,
       0,  1917,  1184,  1911,     0,     0,     0,     0,  1184,  1184,
       0,     0,  1184,     0,     0, -2105,     0,     0,     0,     0,
       0,     0,     0, -2105,     0,     0,     0,  1184,     0,     0,
       0,  1184,     0,     0,     0,  1962,     0,     0,     0,     0,
    1184,     0,     0,     0,     0,  1184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1184,     0,     0,
       0,     0,     0,     0,     0,  2179,     0,     0,     0,  2180,
   -2105,     0,     0,     0,     0,     0,     0,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
    2181,  2182,     0,     0,     0,  1184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2183,     0,     0,     0,     0,
    1911,     0,     0,     0,     0,     0,  1020,     0,   725,     0,
     725,     0,     0,   725,     0,   725,     0,     0,   725,   725,
     725,  1911,  2184,     0,     0,  2185,     0,     0,     0, -2105,
       0,   725,     0,  1911,     0,     0,     0,     0,  2186,     0,
       0,  2187,     0,     0,   725,     0,   725,     0,     0,     0,
       0,     0, -2105,     0, -2105, -2105,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1911,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2105,     0,     0,
   -2105, -2105,   828, -2105,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2188,     0,     0,
       0,     0,     0,     0,     0,     0,  3614,     0,  3615,  3616,
       0,     0,     0,     0,     0,  1184,     0,     0,     0,     0,
       0,  1180,     0,  3804,     0,     0,     0,   828,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     883,     0,     0,     0,     0,     0,     0,     0,     0,  3819,
       0,     0,   884,     0,     0,     0,  3827,     0,     0,   885,
    3832,     0,  1180,     0,     0,     0,     0,     0,     0,     0,
    1911,     0,     0,  3841,   886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2189,  2190,  2191,   887,  2192,
    2193,  2194,  2195,  2196,  2197,     0,     0,   888,     0,     0,
       0,  -716,  3873,  1184,     0,  3874,  1099,  1911,     0,     0,
       0,     0,  1184,     0,     0,     0,     0,     0,  1180,   889,
       0,     0,     0,     0,     0,   890,     0,  1180,     0,  1184,
    1184,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,     0,   891,  1573,  1184,     0,     0,     0,     0,  1184,
       0,     0,  1184,     0,     0,     0,     0,  1184,  1184,     0,
     892,     0,     0,  2337,     0,     0,  2337,     0,     0,     0,
       0,   893,     0,     0,  2344,     0,     0,     0,   894,     0,
       0,     0,   895,     0,     0,     0,     0,     0,     0,     0,
    1184,     0,  2353,     0,     0,     0,     0,     0,  -904,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1911,     0,     0,     0,  1184,     0,
       0,     0,     0,     0,     0,     0,     0,  2413,     0,     0,
       0,     0,     0,     0,     0,   896,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,  1045,     0,     0,     0,  1045,
       0,     0,     0,     0,     0,  1184,   897,     0,     0,  3979,
    3980,  3981,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,   898,     0,     0,   899,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1184,
       0,  1911,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     900,  1246,     0,  1184,  1911,     0,  1184,   901,  1184,     0,
       0,     0,     0,  -385,     0,     0,   902,     0,     0,     0,
    3900,     0,     0,     0,     0,  1184,     0,     0,     0,  1184,
       0,     0,     0,     0,  1911,  1247,     0,     0,     0,     0,
       0,  -385,     0,   903,   904,     0,   905,   906,     0,  1248,
    1249,     0,     0,     0,     0,   907,     0,     0,  1250,     0,
     908,     0,  1251,     0,     0,   909,     0,     0,   910,     0,
    1911,   911,     0,     0,  1911,  1911,     0,     0,     0,     0,
    1252,     0,  2600,     0,  -385,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,  2623,     0,
       0,   828,     0,  1253,     0,  1180,     0,     0,     0,  1184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1254,     0,     0,     0,     0,     0,     0,     0,  1909,
       0,     0,  1255,     0,     0,     0,     0,  1256,     0,     0,
       0,  1911,  2667,     0,     0,     0,  2671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2680,     0,  2682,  1257,
    2683,     0,     0,     0,  1180,  2684,     0,     0,     0,     0,
       0,  1184,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,  1184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     725,     0,   725,     0,     0,  4189,   725,     0,   725,     0,
       0,   725,     0,     0,     0,   725,  2715,     0,     0,  1184,
       0,     0,     0,     0,  4215,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,  1259,  1184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4226,  4075,  4076,
    4077,  4078,     0,     0,     0,     0,     0,  1184,  1184,     0,
       0,     0,     0,     0,   856,     0,     0,     0,     0,     0,
    1184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1260,  1909,     0,     0,     0,  1261,     0,  1262,     0,
       0,     0,     0,     0,  1263,     0,     0,  1264,     0,     0,
       0,  1184,     0,     0,     0,     0,     0,     0,     0,     0,
    1180,  1184,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1265,     0,  1266,     0,     0,   828,  1267,     0,
       0,     0,     0,     0,     0,     0,  1268,     0,  1180,     0,
       0,  1269,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2918,     0,     0,     0,     0,  1270,  1180,  1180,     0,  1180,
       0,     0,     0,     0,  1184,     0,     0,     0,     0,   828,
       0,     0,     0,     0,     0,  1184,  1180,     0,     0,     0,
     828,     0,     0,     0,     0,     0,  4327,  4328,  4329,  4330,
       0,     0,     0,     0,     0,  4207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,     0,     0,     0,
    1180,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3005,  3006,     0,     0,     0,  3009,  3010,     0,     0,
    3013,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3023,     0,     0,     0,     0,     0,     0,  3031,     0,     0,
       0,     0,     0,  3036,  3037,     0,     0,     0,  1909,     0,
       0,     0,     0,     0,  3051,     0,  3053,     0,     0,     0,
       0,  1045,     0,     0,     0,     0,     0,     0,     0,     0,
    3073,     0,     0,     0,     0,  3075,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1045,     0,
       0,     0,     0,     0,     0,  1909,     0,     0,     0,     0,
       0,  3091,  3092,  3095,  3097,     0,     0,     0,  3104,  3107,
       0,     0,     0,     0,     0,     0,  3118,     0,     0,  3122,
       0,     0,     0,  3126,  1909,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3152,     0,  3154,     0,     0,     0,     0,     0,     0,
       0,  3157,  3158,  3159,     0,  3161,     0,     0,     0,     0,
       0,     0,     0,  1045,     0,     0,     0,     0,  3184,  3185,
    3186,     0,     0,     0,     0,  4507,     0,     0,  3191,  3192,
       0,     0,     0,     0,  1909,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4421,     0,     0,  3255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4424,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,     0,     0,     0,
    1909,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4477,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4614,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3380,     0,     0,     0,  1573,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,  1180,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,  1180,     0,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,  1180,  1180,
       0,     0,     0,     0,     0,     0,  1180,     0,     0,  1180,
    1180,  1180,  1180,     0,     0,     0,     0,     0,     0,  1180,
    1180,     0,  1180,     0,  1180,  1180,     0,     0,  1180,     0,
       0,     0,     0,  4580,  4582,  4582,  4704,     0,     0,     0,
       0,     0,  1909,  1180,     0,     0,     0,     0,  1180,     0,
       0,     0,  1180,     0,     0,     0,  1180,     0,  1180,  1180,
    1180,  1180,  1180,  1180,  1180,  1180,  1180,     0,  1180,     0,
       0,     0,     0,     0,  1180,     0,     0,  1180,     0,   708,
       0,     0,     0,     0,   722,     0,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   722,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,   722,   722,     0,     0,   722,     0,  4657,
       0,     0,     0,   722,     0,     0,     0,  1008,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1008,     0,     0,
       0,  3590,  3591,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   722,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1900,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4701,     0,     0,     0,     0,     0,  3622,  3624,     0,
       0,  3624,     0,     0,     0,  3631,  3632,  3633,     0,  4717,
       0,  4719,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,  3651,
    3652,  3653,  3654,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,     0,  1909,  1909,     0,
       0,     0,     0,     0,     0,  3679,     0,     0,  1909,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4582,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3711,     0,
       0,     0,     0,  3713,     0,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,     0,     0,  4808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   722,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3800,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3807,     0,  1180,  4849,
    1909,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3826,     0,   926,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4885,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   926,
       0,     0,  3866,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,  3875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1909,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,  1900,     0,     0,     0,     0,
    1180,  1180,   722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1180,  1180,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,  1900,     0,     0,     0,     0,  1180,  1180,  1180,
    1180,     0,   722,   722,     0,     0,     0,     0,     0,     0,
    1180,     0,     0,  1180,     0,  1180,     0,     0,     0,   722,
       0,  1900,     0,     0,     0,  1180,  1180,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,  1180,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,  1180,  1180,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,  4072,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
    1900,     0,     0,  1180,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,     0,  1180,  4093,     0,  1900,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1900,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4121,     0,     0,     0,
       0,  4128,  4129,     0,  4131,  4132,  4133,  4134,  4135,  4136,
    4137,     0,     0,     0,     0,     0,     0,     0,     0,  4144,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,  1323,   722,     0,   722,     0,  1900,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1909,  1909,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
    4201,  4203,  4205,   722,     0,  4208,   722,   722,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
       0,  1008,     0,  1008,     0,     0,     0,     0,     0,   708,
       0,     0,     0,   722,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,  1008,  1008,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3624,
       0,     0,     0,     0,     0,     0,     0,  1909,     0,     0,
       0,     0,   722,     0,   722,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     4,  1900,
       0,     0,  1909,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
     708,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,   708,   708,     9,    10,  1684,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,  1909,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,  1909,    45,
       0,     0,   708,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4396,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
    1909,     0,     0,     0,     0,     0,  1180,     0,     0,  4407,
    4408,     0,  1180,     0,  1180,     0,     0,     0,     0,  1909,
    1180,  4417,  4418,  1180,  1180,  1180,  1180,  1180,  1180,  1180,
    1180,  1180,  1180,     0,     0,     0,  1180,  1180,     0,     0,
       0,     0,    47,     0,  1909,     0,     0,     0,     0,  1180,
       0,     0,     0,  1180,     0,     0,     0,  1180,    48,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
    1180,     0,  1180,     0,     0,     0,     0,     0,     0,    49,
    1909,  1180,  1180,  1180,     0,     0,     0,  1180,     0,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,  1900,
    1180,    50,     0,     0,  1900,  1900,     0,     0,     0,     0,
    1180,     0,     0,     0,   708,  1900,     0,     0,  1180,   722,
    1180,   722,     0,     0,   722,     0,   722,     0,     0,   722,
     722,   722,     0,     0,    51,  2061,  4471,     0,    52,     0,
       0,     0,   722,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,   722,     0,   722,     0,     0,
    4492,     0,   722,     0,  1180,     0,     0,     0,     0,     0,
    1180,     0,     0,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,     0,  4515,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1900,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,   725,     0,     0,  2213,     0,
       0,     0,     0,     0,     0,    56,     0,   722,   722,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,   708,     0,     0,     0,   708,   708,
       0,     0,     0,     0,     0,     0,     0,  1900,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1372,     0,     0,     0,     0,
      71,  1373,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1910,     0,     0,     0,     0,     0,  4623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,     0,     0,   722,
       0,   708,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,  2341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1909,     0,     0,  1900,     0,  3624,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1909,  1180,  1180,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,   708,     0,     0,     0,     0,     0,   708,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   708,     0,     0,   708,   708,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1910,     0,     0,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
    1180,     0,  1909,     0,     0,     0,     0,  1180,  1180,     0,
    4751,     0,  1180,  1909,     0,     0,     0,     0,  1180,  1180,
    1185,     0,  1180,     0,     0,  3624,     0,     0,     0,     0,
     708,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
    1180,     0,     0,     0,  1185,  1180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4807,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,  1900,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4862,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,  1900,  1900,     0,  1900,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,   722,     0,   722,     0,     0,  1185,   722,     0,   722,
       0,     0,   722,     0,     0,     0,   722,     0,     0,     0,
       0,  2213,     0,     0,     0,     0,     0,     0,     0,     0,
    1912,     0,     0,     0,     0,     0,     0,     0,  1900,  1910,
    1900,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1900,     0,  2442,     0,     0,  1902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,  1910,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,  1185,     0,  1900,  1909,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
    1180,     0,     0,  1180,  2061,     0,     0,     0,     0,     0,
       0,  2919,     0,     0,  1180,     0,     0,     0,     0,  1180,
    2341,     0,  1180,     0,     0,  1910,     0,  1180,  1180,     0,
       0,     0,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1910,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1900,     0,     0,     0,     0,     0,
    1180,  1185,  1910,     0,     0,  1900,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1900,     0,
       0,     0,   708,     0,  1909,     0,     0,     0,  1180,  1185,
    1910,     0,  1902,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,     0,
    1185,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
     708,     0,     0,     0,   708,     0,     0,  1185,     0,     0,
    2989,     0,  1684,     0,     0,   722,     0,  1900,     0,     0,
       0,  1910,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1900,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,  1909,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,  1909,     0,  1180,     0,  1180,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1185,  1185,     0,     0,  1180,     0,  1900,     0,  1180,
       0,     0,     0,     0,  1909,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,  1909,  1909,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   708,     0,     0,     0,  1912,
       0,     0,     0,   708,     0,   708,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,  1910,     0,     0,  1912,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1902,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,  1912,     0,     0,  2917,     0,
       0,     0,     0,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1902,     0,     0,     0,     0,
    1900,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1902,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,  1912,  1543,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,  1180,     0,
       0,     0,     0,     0,  1912,     0,     0,     0,     0,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1613,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1902,     0,     0,     0,     0,     0,
    1912,  1180,     0,     0,     0,     0,   722,  2061,     0,     0,
       0,  1180,     0,  1902,     0,     0,     0,     0,     0,     0,
       0,     0,   708,     0,     0,     0,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  1902,
       0,  1912,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,     0,  3077,     0,     0,     0,     0,  2442,  3084,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1910,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1902,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,  1900,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,     0,
    1900,  1185,     0,     0,     0,     0,     0,     0,     0,  1185,
    1185,     0,     0,  2341,     0,     0,     0,  1185,   708,     0,
    1185,  1185,  1185,  1185,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,  1185,     0,  1185,  1185,     0,     0,  1185,
       0,  1910,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1912,  1185,     0,     0,     0,     0,  1185,
       0,     0,     0,  1185,     0,     0,     0,  1185,     0,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,     0,  1185,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1900,     0,     0,
       0,  2442,  1902,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1900,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1900,     0,     0,     0,     0,     0,     0,  2113,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2136,     0,     0,  1900,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2161,  2162,     0,  2164,     0,     0,  1910,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,  2256,     0,     0,  1185,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2278,     0,     0,     0,  2288,  2291,     0,
       0,     0,     0,  1912,     0,     0,     0,     0,  1912,  1912,
     708,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
       0,     0,     0,   708,  1900,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2917,  2917,
    2917,     0,  1902,     0,     0,     0,     0,  1902,  1902,     0,
       0,     0,     0,     0,     0,     0,   722,     0,  1902,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1912,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1910,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1902,     0,  1903,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,     0,     0,     0,     0,     0,  1900,  2442,
    3084,     0,  3084,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1902,  1900,  1910,     0,  1910,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1900,     0,  1912,
       0,  1900,  1900,     0,     0,     0,     0,     0,  1910,     0,
       0,     0,     0,  1185,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,  1185,  1910,     0,     0,     0,     0,     0,     0,
       0,     0,  2989,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1903,     0,     0,  1902,     0,
    3084,  1185,  1185,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,  3084,     0,     0,     0,     0,  1185,  1185,
    1185,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,  1185,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,   708,  1185,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,  1910,     0,
     708,     0,     0,     0,     0,  1185,     0,     0,     0,  3084,
       0,     0,     0,     0,     0,     0,  1185,     0,  1185,  1185,
    1185,  2785,  1910,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,  2807,     0,     0,  2809,     0,     0,  2820,
       0,     0,     0,     0,  1185,     0,  2827,  2832,   708,  1185,
       0,     0,  2838,     0,     0,  2843,  1185,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    2852,     0,     0,     0,     0,  2859,     0,     0,     0,  2871,
       0,  1910,     0,  2878,     0,  2880,  2881,  2882,  2883,  2884,
    2885,  2886,  2887,  2888,     0,  2889,     0,     0,     0,     0,
    1910,  1543,     0,     0,  2914,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,  1910,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1910,     0,     0,     0,  1613,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,     0,  1912,
    1912,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   708,     0,     0,     0,     0,
    1902,  2917,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1903,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,  1912,     0,     0,     0,  1902,  1902,
       0,  1902,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1912,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3034,     0,
       0,  1902,     0,  1902,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1912,     0,  2341,     0,     0,     0,  1903,  1902,     0,     0,
       0,     0,     0,  1912,  3084,     0,     0,     0,  1905,     0,
       0,     0,     0,     0,  1903,     0,     0,     0,   708,     0,
       0,     0,  1902,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   708,
       0,     0,  1902,     0,     0,     0,     0,     0,  1912,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1903,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,  1902,     0,     0,
       0,     0,     0,     0,     0,  3231,     0,     0,  1902,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1902,     0,  1910,     0,     0,     0,     0,  1185,     0,
     708,  1912,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1905,     0,  1185,     0,  1185,     0,     0,     0,     0,
    1912,  1185,     0,  2442,  1185,  1185,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,     0,     0,  1912,     0,     0,     0,     0,
    1185,     0,     0,     0,  1185,     0,     0,     0,  1185,     0,
    1902,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,  1185,     0,  1185,     0,     0,     0,     0,     0,  1902,
       0,  1912,  1185,  1185,  1185,     0,     0,     0,  1185,     0,
       0,  1185,     0,     0,     0,     0,  3351,     0,     0,     0,
       0,  1185,     0,     0,  1902,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1910,     0,  1903,     0,     0,     0,     0,
    1902,     0,     0,     0,  1910,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,   722,  1185,  3397,     0,
       0,  2917,     0,     0,     0,     0,  2917,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,  2917,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   708,     0,     0,     0,     0,
       0,     0,     0,     0,  2832,     0,  2832,  2832,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3459,     0,     0,
    3462,     0,  3464,     0,     0,     0,     0,     0,     0,     0,
       0,  1910,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1912,     0,     0,  2199,     0,  3485,
       0,  3487,  1910,     0,     0,  3490,     0,  1905,     0,     0,
       0,     0,     0,     0,  1910,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2914,  2914,  2914,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1910,  1902,  1905,     0,     0,     0,  3547,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2278,     0,     0,     0,     0,  3558,     0,     0,     0,     0,
       0,     0,  2291,  1905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,  1903,     0,     0,     0,     0,
    1903,  1903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1903,     0,  1912,     0,     0,     0,     0,  3599,     0,
       0,     0,     0,  1905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4505,  1905,  1912,  1185,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1902,     0,     0,     0,     0,     0,  1910,   708,
       0,     0,     0,     0,     0,     0,     0,     0,  1905,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1902,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1903,     0,     0,     0,     0,     0,  1905,
    1185,  1185,     0,  1912,     0,     0,     0,     0,  1185,  1185,
       0,     0,     0,  1185,  1912,     0,     0,     0,     0,  1185,
    1185,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3084,     0,     0,  1185,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1902,  1903,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,  1902,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1906,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,     0,     0,     0,     0,     0,  2199,     0,
       0,     0,  3084,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1912,  1910,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1902,     0,     0,     0,     0,  1910,     0,     0,     0,     0,
       0,  1905,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1902,     0,     0,     0,  2199,     0,     0,
       0,  1910,     0,     0,     0,  1910,  1910,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2199,     0,     0,     0,  3905,  2816,     0,     0,     0,     0,
    1906,  1902,     0,  3908,     0,     0,  1185,     0,     0,  3909,
       0,  3910,     0,     0,     0,  2199,  2199,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3928,  3929,     0,     0,     0,     0,     0,
       0,     0,  4505,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2838,     0,     0,  2199,     0,     0,
       0,  1912,     0,     0,  3957,     0,     0,  3960,     0,  3962,
       0,     0,     0,     0,     0,     0,     0,     0,  3966,     0,
       0,     0,     0,     0,  3971,     0,     0,  3974,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,  1912,     0,
       0,     0,     0,  1185,     0,     0,     0,  4003,     0,     0,
    2199,     0,     0,     0,     0,  4015,     0,  2914,     0,     0,
    1185,  1185,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,  1185,     0,     0,     0,     0,
    1185,     0,  2199,  1185,     0,  2199,     0,     0,  1185,  1185,
       0,     0,     0,     0,     0,     0,     0,  1902,     0,     0,
       0,  4032,     0,     0,     0,     0,     0,  1543,     0,     0,
       0,     0,     0,  1613,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1905,     0,  1903,  1907,  1912,  1905,  1905,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,  1905,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1903,  1903,     0,  1903,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1902,     0,  1906,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,  1903,     0,     0,     0,
    1185,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1906,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,  1912,     0,  1185,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1903,     0,  1906,     0,     0,     0,  1185,     0,     0,  1905,
    1185,     0,     0,     0,     0,  1912,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,  1903,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1902,     0,     0,     0,     0,     0,
       0,  1912,  1903,     0,     0,  1912,  1912,     0,     0,     0,
       0,     0,     0,     0,     0,  1903,     0,     0,     0,     0,
       0,     0,  1906,     0,  1902,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
    4258,  4259,     0,     0,     0,     0,     0,     0,     0,  1906,
    1902,     0,     0,     0,  1902,  1902,     0,     0,     0,     0,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,     0,     0,     0,  1906,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,  1903,     0,     0,     0,     0,     0,
    4290,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1905,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
    1185,     0,     0,     0,     0,     0,  4308,  4310,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,  4317,
       0,     0,     0,  1903,     0,  4322,  4323,     0,     0,  4325,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,  2914,     0,     0,
       0,     0,  2914,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,     0,     0,  2914,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,  1907,     0,     0,     0,     0,     0,  2199,
       0,     0,  1185,  1903,     0,     0,     0,     0,     0,     0,
       0,     0,  4379,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,     0,  2199,     0,  2816,  2816,  3433,     0,     0,
    2816,     0,     0,     0,  2199,     0,     0,     0,     0,     0,
    1907,  2199,     0,     0,     0,     0,  2199,     0,     0,     0,
       0,     0,  2199,     0,     0,     0,     0,  2199,     0,     0,
       0,     0,     0,     0,     0,  1185,  2199,     0,     0,  1907,
    2816,  2816,     0,  2199,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,  2199,     0,     0,     0,     0,
    1906,     0,  2199,     0,  2199,  2199,  2199,  2199,  2199,  2199,
    2199,  2199,  2199,  2199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1907,     0,
       0,     0,  4458,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,  1907,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1903,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1907,     0,     0,  1905,  1905,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1905,     0,  1905,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4541,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4558,  1905,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,  1903,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1906,     0,     0,     0,     0,  1906,  1906,     0,  1905,     0,
       0,     0,     0,     0,     0,  1903,  1906,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1905,     0,     0,     0,
       0,     0,     0,     0,     0,  2199,     0,  1905,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1903,     0,     0,     0,     0,
       0,     0,     0,  2838,     0,     0,  1903,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,  4682,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1905,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2199,     0,     0,  1906,     0,
       0,     0,     0,  1905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4739,     0,     0,     0,
       0,     0,     0,  1903,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1905,
       0,  2199,     0,     0,  1903,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1903,     0,     0,     0,
       0,     0,  3433,  3433,     0,  2816,     0,     0,  2816,  2816,
    2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,  3433,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4790,  1903,     0,  1906,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,  2199,     0,  2199,     0,
       0,     0,     0,  3433,  3433,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2816,  2816,  2199,
       0,  2199,     0,     0,  2199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,  1907,  1907,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1907,  4835,  4835,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4835,     0,
       0,     0,  1905,     0,     0,     0,     0,     0,  4882,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4835,     0,     0,     0,  1907,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,  1903,     0,    45,
       0,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1906,  1906,     0,  1906,
       0,  2816,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,     0,     0,     0,     0,
       0,     0,     0,  1907,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1903,     0,  1906,
       0,  1906,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,  1905,     0,     0,  1906,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,  1903,     0,     0,     0,  1903,  1903,  2199,
    1906,     0,  2199,  2199,  2199,     0,     0,  3433,     0,     0,
       0,     0,  3433,  3433,  3433,  3433,  3433,  3433,  3433,  3433,
    3433,  3433,  2199,  2199,    51,     0,     0,  1906,    52,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1906,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,  2199,  2816,  2816,  2199,     0,  2199,     0,     0,     0,
    2199,  3433,  3433,     0,     0,  2199,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,     0,     0,
    1905,     0,     0,     0,     0,  1906,     0,     0,     0,  2199,
       0,     0,  1905,     0,     0,     0,  1906,     0,     0,     0,
       0,    54,     0,     0,     0,     0,  2199,     0,     0,  1906,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,  1906,     0,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1372,  2016,     0,     0,     0,
      71,     0,  1906,  1907,  1907,     0,  1907,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1907,     0,  1907,     0,
       0,     0,     0,  3433,     0,     0,  1905,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1907,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,  2199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,     0,     0,  2816,     0,
       0,     0,     0,     0,  1907,     0,     0,     0,     0,     0,
       0,     0,  2199,     0,  2199,     0,     0,  1907,     0,  3433,
    3433,  2199,     0,  1905,  2816,  2816,  2199,  2199,     0,  2199,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1907,  2199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1907,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1907,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1905,     0,  1907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1907,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,  1905,  1905,     0,     0,     0,     0,  1907,
    1906,     0,     0,     0,     0,     0,     0,  3433,  2816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3433,  3433,  2199,     0,     4,     0,     0,
    1906,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     8,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,    36,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1906,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,     0,     0,  3433,    46,     0,     0,
       0,     0,     0,     0,     0,     0,  2199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1907,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1906,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,  2199,     0,     0,     0,     0,  1906,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,     0,    51,     0,     0,     0,    52,     0,  1906,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2199,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1906,     0,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,  1907,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,     0,     0,     0,     0,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,  1906,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1907,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,  1907,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,     0,   145,     0,     0,     0,     0,  1906,
       0,     0,   148,     0,     0,     0,  1907,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,  1906,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,  1906,   172,
       0,     0,  1906,  1906,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,   190,  1907,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1907,     0,     0,  2979,
       0,     0,     0,     0,     0,     0,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,  1907,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,  1907,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,  1907,     0,     0,     0,  1907,
    1907,     0,   434,   435,   436,   437,   438,   439,   440,   441,
     738,   442,   443,   444,   739,   740,   741,   742,   743,   744,
     745,   445,   446,   746,   447,   448,   133,   449,   450,   451,
     452,   135,   136,   137,   138,   139,   747,   453,   454,   455,
     456,   457,   748,   749,   458,   459,   750,   140,   461,   751,
     462,   463,   464,   465,   466,   145,   752,   467,   753,   468,
     469,   470,   471,   148,   472,   754,   755,   474,   475,   476,
     477,   478,   479,   480,   756,   151,   481,   757,   758,   759,
     760,   152,   761,   762,   763,   482,   483,   484,   485,   486,
     487,   155,   156,   488,   764,   489,   765,   490,   491,   492,
     493,   494,   766,   495,   496,   497,   498,   767,   499,   768,
     500,   501,   502,   503,   504,   769,   505,   506,   507,   770,
     508,   509,   771,   510,   511,   512,   513,   164,   514,   515,
     516,   166,   772,   517,   773,   518,   168,   519,   774,   520,
     775,   521,   169,   776,   170,   522,   523,   524,   777,   525,
     172,   778,   526,   527,   779,   528,   529,   530,   531,   532,
     173,   533,   534,   535,   780,   536,   537,   538,   539,   540,
     541,   781,   542,   174,   175,   782,   543,   544,   545,   783,
     176,   784,   177,   785,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,   786,   181,   182,   555,
     183,   787,   556,   557,   558,   788,   789,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,   189,   190,   572,   573,   574,   191,   790,   575,   576,
     193,   577,   791,   194,   578,   195,   579,   580,   581,   792,
     582,   793,   794,   583,   584,   585,   795,   796,   196,   197,
     198,   199,   200,   586,   587,   588,   589,   590,   591,   592,
     797,   593,   201,   594,   202,   595,   596,   597,   598,   798,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,   799,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,   800,   621,   622,   210,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,   801,   635,   636,   637,   638,   639,   802,   640,   217,
     641,   642,   219,   643,   220,   803,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,   804,   654,   655,
     805,   656,   657,   658,   659,   660,   661,   806,   224,   225,
     807,   808,   663,   226,   664,   227,   809,   665,   666,   667,
     668,   669,   670,   810,   811,   671,   672,   673,   674,   675,
     812,   813,   676,   677,   678,   679,   680,   814,   234,   815,
     682,   235,   683,   684,   685,   816,   817,   686,   818,   819,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,    85,     0,     0,
      86,    87,    88,    89,    90,    91,    92,    93,     0,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   969,
     104,   105,   106,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,   119,
     120,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,   130,   131,     0,
       0,     0,     0,     0,     0,     0,     0,   132,     0,   133,
       0,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,   145,     0,
       0,     0,   146,     0,   147,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,   150,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,   153,     0,   154,   155,   156,   157,     0,     0,     0,
       0,     0, -1353,     0,     0,     0,     0,     0,     0,   158,
       0,     0,   159,     0,     0,     0,   160,     0,     0,     0,
       0,     0,   161,   162,     0,     0,     0,     0,     0,   163,
     164,   165,     0,     0,   166,     0,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,   171,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
   -1353,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,   184,   185,     0,     0,     0,
       0,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,   205,     0,     0,     0,     0,   206,     0,   207,     0,
       0,     0,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,   211,     0,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,     0,     0,
       0,   216,   217,     0,   218,   219,     0,   220,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
     228,     0,   229,     0,     0,     0,   230,     0,     0,   231,
       0,     0, -1353,     0,     0,   232,     0,     0,     0,     0,
     233,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   246,   104,   105,     0,
    -140,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,   202,     0,     0,     0,    85,     0,
       0,     0,     0,     0,    89,     0,     0,   204,    93,     0,
      94,     0,    96,    97,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   106,     0,     0,     0,   210,     0,     0,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
     119,   120,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,   128,     0,     0,     0,
       0,     0,     0,   230,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,   234,     0,
       0,   235,     0,     0,  1118,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   141,     0,   142,   143,   144,     0,
       0,     0,     0,   146,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,     0,   150,     0,
    2981,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,   154,     0,     0,   157,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     158,     0,     0,   159,     0,     0,     4,   160,     0,     0,
       0,     0,     0,   161,     0,     0,     0,     0,     0,     0,
     163,     0,   165,     0,     0,     0,     5,     0,   167,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,   171,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   206,     0,   207,
       0,     0,     0,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,   211,     0,     0,     0,     0,   213,
       0,     0,     0,     0,   214,   215,     0,     0,     0,     0,
      47,     0,   216,     0,     0,   218,     0,     0,     0,     0,
       0,     0,   221,     0,     0,     0,    48,     0,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,     0,     0,
       0,   228,     0,   229,     0,     0,     0,     0,     0,     0,
     231,     0,     0,     0,     0,     0,   232,     0,     0,    50,
       0,   233,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,   236,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,    51,     0,     0,     0,    52,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,   246,     0,     9,
      10,  -140,    53,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    56,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,     0,
      59,    48,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1372,  2693,     0,     0,     0,    71,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1372,     0,
       0,     0,     0,    71,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,  2908,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,  2909,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,  2910,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,  2911,     0,     0,     0,     0,     0,
       0,  1530,  2912,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,  1467,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,   135,  1468,
     137,  1469,  1470,     0,   453,   454,   455,   456,   457,  1471,
    1472,   458,   459,  1473,  1474,   461,     0,   462,   463,   464,
     465,   466,  1475,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,
    1481,  1482,   482,   483,   484,   485,   486,   487,  1483,  1484,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,  1485,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,  1486,   514,   515,   516,  1487,  1488,
     517,     0,   518,  1489,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,  1490,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,   175,     0,   543,   544,   545,  1491,  1492,     0,  1493,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,  1494,   182,   555,   183,     0,   556,
     557,   558,  1495,  1496,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,  1497,   189,  1498,
     572,   573,   574,   191,  1499,   575,   576,   193,   577,  1500,
    1501,   578,  1502,   579,   580,   581,     0,   582,     0,     0,
    1503,   584,   585,     0,     0,   196,   197,   198,   199,  1504,
     586,   587,   588,   589,   590,   591,   592,     0,   593,  1505,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,  1506,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,  1507,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,  1508,   640,   217,   641,   642,   219,
     643,  1509,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,  1510,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1511,  1512,     0,     0,   663,
    1513,   664,  1514,  1515,   665,   666,   667,   668,   669,   670,
       0,  1516,   671,   672,   673,   674,   675,  1517,     0,   676,
     677,   678,   679,   680,   681,  1518,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,
    1526,   692,   693,   694,     0,     0,     0,     0,     0,     0,
       0,  1527,  1528,     0,     0,     0,     0,     0,     0,     0,
    1530,  2818,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,     0,  1878,   137,
    1879,  1880,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,  1881,  1882,   461,     0,   462,   463,   464,   465,
     466,     0,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,     0,     0,     0,   152,     0,     0,
       0,   482,   483,   484,   485,   486,   487,  1883,  1884,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,     0,   514,   515,   516,     0,     0,   517,
       0,   518,  1885,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,     0,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
    2430,   536,   537,   538,   539,   540,   541,     0,   542,   174,
    2431,     0,   543,   544,   545,  1491,  1886,     0,  1887,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,     0,   182,   555,   183,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1888,   189,  1889,   572,
     573,   574,     0,     0,   575,   576,   193,   577,     0,     0,
     578,  1890,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,  2432,   197,   198,   199,     0,   586,
     587,   588,   589,   590,   591,   592,     0,   593,     0,   594,
       0,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1891,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,     0,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,  2433,   641,   642,   219,   643,
    1893,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,     0,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1894,  1895,     0,     0,   663,     0,
     664,     0,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,     0,  1896,  2434,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     692,   693,   694,     0,     0,     0,     0,   731,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
    2435,    98,    99,   100,   101,   102,   103,   732,   104,   105,
     423,   733,     0,   107,   108,   109,   110,   734,   735,   112,
     113,   114,   115,     0,   116,   736,   737,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,   133,   449,   450,
     451,   452,     0,  1878,   137,  1879,  1880,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,  1881,  1882,   461,
       0,   462,   463,   464,   465,   466,     0,     0,   467,     0,
     468,   469,   470,   471,   148,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,   151,   481,     0,     0,
       0,     0,   152,     0,     0,     0,   482,   483,   484,   485,
     486,   487,  1883,  1884,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,  1485,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,     0,   514,
     515,   516,     0,     0,   517,     0,   518,  1885,   519,     0,
     520,     0,   521,   169,     0,   170,   522,   523,   524,     0,
     525,     0,     0,   526,   527,     0,   528,   529,   530,   531,
     532,   173,   533,   534,   535,  2430,   536,   537,   538,   539,
     540,   541,     0,   542,   174,  2431,     0,   543,   544,   545,
    1491,  1886,     0,  1887,     0,   546,   178,   179,   547,   180,
     548,   549,   550,   551,   552,   553,   554,     0,     0,   182,
     555,   183,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,  1888,   189,  1889,   572,   573,   574,     0,     0,   575,
     576,   193,   577,     0,     0,   578,  1890,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,  2432,
     197,   198,   199,     0,   586,   587,   588,   589,   590,   591,
     592,     0,   593,     0,   594,     0,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,  1891,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,   210,   623,
     624,   625,   626,     0,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
    2433,   641,   642,   219,   643,  1893,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,     0,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,  1894,
    1895,     0,     0,   663,     0,   664,     0,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,     0,  1896,
    2434,   682,   235,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   692,   693,   694,     0,     0,
       0,     0,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,  3313,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,  2828,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,  2829,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,  2830,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,  2831,   663,  1513,
     664,  1514,  1515,   665,   666,   667,   668,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,   215,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,   223,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,  1389,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,   236,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,  2108,  2777,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,  1529,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,  1612,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,  2286,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,   668,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,  2829,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,  4018,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,  4031,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,  4832,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,  4833,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,  4834,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,  4833,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,  4834,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,  4300,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,  4309,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,     0,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  2811,  2812,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452, -2582,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,  4833,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,     0,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,     0,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,     0,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,  4834,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
       0,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,     0,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,  1530,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,     0,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,  3941,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,     0,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,   583,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,  1530,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,     0,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,     0,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,     0,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,     0,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,     0,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,     0,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,     0,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
       0,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,     0,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,     0,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  2811,  2812,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
     136,   137,   138,   139,     0,   453,   454,   455,   456,   457,
       0,  1472,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,  1487,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,   189,
     190,   572,   573,   574,   191,     0,   575,   576,   193,   577,
       0,  1501,   578,   195,   579,   580,   581,     0,   582,     0,
    1082,   583,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,   215,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,   223,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,  1513,   664,  1514,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,  1389,   234,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,   236,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,  3501,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,   136,   137,   138,   139,     0,   453,
     454,   455,   456,   457,     0,  1472,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,  1487,     0,   517,     0,   518,   168,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,   189,   190,   572,   573,   574,   191,     0,
     575,   576,   193,   577,     0,  1501,   578,   195,   579,   580,
     581,     0,   582,     0,  1082,   583,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,  1513,   664,  1514,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,  3501,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,   136,   137,
     138,   139,     0,   453,   454,   455,   456,   457,     0,  1472,
     458,   459,   460,   140,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,   155,   156,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,  1487,     0,   517,
       0,   518,   168,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,   189,   190,   572,
     573,   574,   191,     0,   575,   576,   193,   577,     0,  1501,
     578,   195,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,  1513,
     664,  1514,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,  4056,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,   136,   137,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,   463,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,     0,     0,
       0,   152,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,   517,     0,   518,   168,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,   181,   182,   555,
     183,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,   189,   190,   572,   573,   574,   191,     0,   575,   576,
     193,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,   197,
     198,   199,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,   219,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
       0,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,  4591,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,  3985,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0, -1431,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,     0,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0, -1431,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542, -1431,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547, -1431,   548,   549,   550,   551,   552,   553,   554,
       0,   181, -1431,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188, -1431,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622, -1431,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,  1620,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
       0,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,  3263,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,  2033,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,  2034,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
    2035,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1000,  1663,
    4164,     0,     0,     0,     0,     0,     0,  4165,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,     0,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,  3765,  3766,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   130,
     131,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,   215,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,   223,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,  1389,   234,     0,   682,  1390,   683,   684,   685,
       0,     0,   686,     0,   236,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,  3766,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,   433,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,   215,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,   223,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
    1389,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,   236,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,     0,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,   215,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,   223,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1389,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,   236,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,     0,     0,     0,     0,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
     246,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,     0,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,  1595,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,  2969,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,  4012,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,  4344,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,  1205,    45,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   738,   442,   443,
     444,   739,   740,   741,   742,   743,   744,   745,   445,   446,
     746,   447,   448,   133,   449,   450,   451,   452,     0,  1878,
     137,  1879,  1880,   747,   453,   454,   455,   456,   457,   748,
     749,   458,   459,  1881,  1882,   461,   751,   462,   463,   464,
     465,   466,     0,   752,   467,   753,   468,   469,   470,   471,
     148,   472,   473,   755,   474,   475,   476,   477,   478,   479,
     480,   756,   151,   481,     0,   758,   759,   760,   152,   761,
     762,   763,   482,   483,   484,   485,   486,   487,  1883,  1884,
     488,   764,   489,   765,   490,   491,   492,   493,   494,   766,
     495,   496,   497,   498,   767,   499,   768,   500,   501,  1485,
     503,   504,   769,   505,   506,   507,   770,   508,   509,   771,
     510,   511,   512,   513,     0,   514,   515,   516,     0,   772,
     517,   773,   518,  1885,   519,   774,   520,   775,   521,   169,
     776,   170,   522,   523,   524,   777,   525,     0,   778,   526,
     527,   779,   528,   529,   530,   531,   532,   173,   533,   534,
     535,   780,   536,   537,   538,   539,   540,   541,   781,   542,
     174,     0,     0,   543,   544,   545,  1491,  1886,   784,  1887,
     785,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,   786,     0,   182,   555,   183,   787,   556,
     557,   558,   788,   789,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,  1888,   189,  1889,
     572,   573,   574,     0,   790,   575,   576,   193,   577,   791,
       0,   578,  1890,   579,   580,   581,   792,   582,   793,   794,
    3752,   584,   585,   795,   796,     0,   197,   198,   199,     0,
     586,   587,   588,   589,   590,   591,   592,   797,   593,     0,
     594,     0,   595,   596,   597,   598,   798,   599,   600,   601,
     602,   603,   604,   605,  1891,   606,   607,   608,   609,   799,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   800,   621,   622,   210,   623,   624,   625,   626,     0,
     627,   628,   629,   630,   631,   632,   633,   634,   801,   635,
     636,   637,   638,   639,   802,   640,  2433,   641,   642,   219,
     643,  1893,   803,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,     0,   804,   654,   655,   805,   656,   657,
     658,   659,   660,   661,   806,  1894,  1895,     0,   808,   663,
       0,   664,     0,   809,   665,   666,   667,   668,   669,   670,
       0,   811,   671,   672,   673,   674,   675,   812,   813,   676,
     677,   678,   679,   680,     0,  1896,   815,   682,   235,   683,
     684,   685,   816,   817,   686,   818,   819,   687,   688,   689,
     690,   691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   692,   693,   694,     0,     0,     0,  1208,  1209,  1210,
       0,  3753,  3754,  1213,  1214,  1215,  1216,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   423,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1205,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,     0,   449,   450,   451,
     452,   135,   136,     0,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,  1206,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,     0,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,     0,   481,     0,     0,     0,
       0,     0,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,  1207,     0,   518,   168,   519,     0,   520,
       0,   521,     0,     0,     0,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,     0,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,     0,     0,   547,     0,   548,
     549,   550,   551,   552,   553,   554,     0,   181,     0,   555,
       0,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,     0,   190,   572,   573,   574,   191,     0,   575,   576,
       0,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,     0,
       0,     0,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,     0,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,     0,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,     0,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
    1208,  1209,  1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1205,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,  1296,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,  1297,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,  1208,  1209,  1210,     0,  1211,  1212,  1213,
    1214,  1215,  1216,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   423,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1205,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,     0,   449,   450,   451,   452,   135,   136,     0,
     138,   139,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,   460,   140,   461,     0,   462,  1349,   464,   465,
     466,   145,     0,   467,     0,   468,   469,   470,   471,     0,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,     0,   481,     0,     0,     0,     0,     0,     0,     0,
       0,   482,   483,   484,   485,   486,   487,   155,   156,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,   166,     0,  1350,
       0,   518,   168,   519,     0,   520,     0,   521,     0,     0,
       0,   522,   523,   524,     0,   525,   172,     0,   526,   527,
       0,   528,   529,   530,   531,  1351,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,     0,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,     0,     0,   547,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   181,     0,   555,     0,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,     0,   190,   572,
     573,   574,   191,     0,   575,   576,     0,   577,     0,   194,
     578,   195,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,   196,     0,     0,     0,   200,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   201,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,     0,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,   217,   641,   642,     0,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,   226,
     664,   227,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,     0,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,     0,     0,     0,  1208,  1209,  1210,     0,
    1211,  1212,  1213,  1214,  1215,  1216,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1205,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
    1861,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,  1862,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,  1208,
    1209,  1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   423,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1205,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,     0,   449,
     450,   451,   452,   135,   136,     0,   138,   139,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,   145,     0,   467,
       0,   468,   469,   470,   471,     0,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,     0,   481,     0,
       0,     0,     0,     0,     0,     0,     0,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,   166,     0,   517,     0,   518,   168,   519,
       0,   520,     0,   521,     0,     0,     0,   522,   523,   524,
       0,   525,   172,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,     0,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,     0,     0,   547,
       0,   548,   549,   550,   551,   552,   553,   554,     0,   181,
       0,   555,     0,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,     0,   190,   572,   573,   574,   191,     0,
     575,   576,     0,   577,     0,   194,   578,   195,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
     196,     0,     0,     0,   200,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   201,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,     0,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,   217,   641,   642,     0,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,   226,   664,   227,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,     0,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,     0,
       0,     0,  1208,  1209,  1210,     0,  1211,  1212,  1213,  1214,
    1215,  1216,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1205,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,  3048,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,  3049,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,  1208,  1209,  1210,     0,  1211,
    1212,  1213,  1214,  1215,  1216,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   423,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1205,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,     0,   449,   450,   451,   452,   135,
     136,     0,   138,   139,     0,   453,   454,   455,   456,   457,
       0,     0,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,   145,     0,   467,     0,   468,   469,   470,
     471,     0,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,     0,   481,     0,     0,     0,     0,     0,
       0,     0,     0,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,   166,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
       0,     0,     0,   522,   523,   524,     0,   525,   172,     0,
     526,   527,     0,   528,   529,   530,   531,   532,     0,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,     0,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,     0,     0,   547,     0,   548,   549,   550,
     551,   552,   553,   554,     0,   181,     0,   555,     0,     0,
     556,   557,   558,     0,     0,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,     0,
     190,   572,   573,   574,   191,     0,   575,   576,     0,   577,
       0,   194,   578,   195,   579,   580,   581,     0,   582,     0,
       0,  4578,   584,   585,     0,     0,   196,     0,     0,     0,
     200,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     201,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,     0,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,     0,   640,   217,   641,   642,
       0,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,   222,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,   226,   664,   227,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,     0,     0,
     676,   677,   678,   679,   680,   681,   234,     0,   682,     0,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   692,   693,   694,     0,     0,     0,  1208,  1209,
    1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,   738,   442,   443,   444,   739,   740,   741,   742,
     743,   744,   745,   445,   446,   746,   447,   448,   133,   449,
     450,   451,   452,   135,   136,   137,   138,   139,   747,   453,
     454,   455,   456,   457,   748,   749,   458,   459,   750,   140,
     461,   751,   462,   463,   464,   465,   466,   145,   752,   467,
     753,   468,   469,   470,   471,   148,   472,   754,   755,   474,
     475,   476,   477,   478,   479,   480,   756,   151,   481,   757,
     758,   759,   760,   152,   761,   762,   763,   482,   483,   484,
     485,   486,   487,   155,   156,   488,   764,   489,   765,   490,
     491,   492,   493,   494,   766,   495,   496,   497,   498,   767,
     499,   768,   500,   501,   502,   503,   504,   769,   505,   506,
     507,   770,   508,   509,   771,   510,   511,   512,   513,   164,
     514,   515,   516,   166,   772,   517,   773,   518,   168,   519,
     774,   520,   775,   521,   169,   776,   170,   522,   523,   524,
     777,   525,   172,   778,   526,   527,   779,   528,   529,   530,
     531,   532,   173,   533,   534,   535,   780,   536,   537,   538,
     539,   540,   541,   781,   542,   174,   175,   782,   543,   544,
     545,   783,   176,   784,   177,   785,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,   786,   181,
     182,   555,   183,   787,   556,   557,   558,   788,   789,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,   189,   190,   572,   573,   574,   191,   790,
     575,   576,   193,   577,   791,   194,   578,   195,   579,   580,
     581,   792,   582,   793,   794,   583,   584,   585,   795,   796,
     196,   197,   198,   199,   200,   586,   587,   588,   589,   590,
     591,   592,   797,   593,   201,   594,   202,   595,   596,   597,
     598,   798,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,   799,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   800,   621,   622,   210,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,   801,   635,   636,   637,   638,   639,   802,
     640,   217,   641,   642,   219,   643,   220,   803,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,   804,
     654,   655,   805,   656,   657,   658,   659,   660,   661,   806,
     224,   225,   807,   808,   663,   226,   664,   227,   809,   665,
     666,   667,   668,   669,   670,   810,   811,   671,   672,   673,
     674,   675,   812,   813,   676,   677,   678,   679,   680,   814,
     234,   815,   682,   235,   683,   684,   685,   816,   817,   686,
     818,   819,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,   731,
      86,    87,    88,   420,    90,    91,    92,   421,  2257,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   732,
     104,   105,   423,   733,     0,   107,   108,   109,   110,   734,
     735,   112,   113,   114,   115,     0,   116,   736,   737,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,   133,
     449,   450,   451,   452,     0,  1878,   137,  1879,  1880,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,  1881,
    1882,   461,     0,   462,   463,   464,   465,   466,     0,     0,
     467,     0,   468,   469,   470,   471,   148,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,   151,   481,
       0,     0,     0,     0,   152,     0,     0,     0,   482,   483,
     484,   485,   486,   487,  1883,  1884,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,  1485,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
       0,   514,   515,   516,     0,     0,   517,     0,   518,  1885,
     519,     0,   520,     0,   521,   169,     0,   170,   522,   523,
     524,     0,   525,     0,     0,   526,   527,     0,   528,   529,
     530,   531,   532,   173,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   174,     0,     0,   543,
     544,   545,  1491,  1886,     0,  1887,     0,   546,   178,   179,
     547,   180,   548,   549,   550,   551,   552,   553,   554,     0,
       0,   182,   555,   183,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,  1888,   189,  1889,   572,   573,   574,     0,
       0,   575,   576,   193,   577,     0,     0,   578,  1890,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,     0,   197,   198,   199,     0,   586,   587,   588,   589,
     590,   591,   592,     0,   593,     0,   594,     0,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
    1891,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
     210,   623,   624,   625,   626,     0,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,  1892,   641,   642,   219,   643,  1893,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,     0,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1894,  1895,     0,     0,   663,     0,   664,     0,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
       0,  1896,     0,   682,   235,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   692,   693,   694,
       0,    86,    87,    88,   420,    90,    91,    92,   421,  2356,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,     0,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,    86,    87,    88,   420,    90,    91,    92,   421,
    1089,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,    86,    87,    88,   420,    90,    91,    92,
     421,  4441,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   423,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,     0,   449,   450,   451,   452,   135,   136,     0,
     138,   139,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,   460,   140,   461,     0,   462,   463,   464,   465,
     466,   145,     0,   467,     0,   468,   469,   470,   471,     0,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,     0,   481,     0,     0,     0,     0,     0,     0,     0,
       0,   482,   483,   484,   485,   486,   487,   155,   156,   488,
    2245,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,   166,  2033,   517,
       0,   518,   168,   519,     0,   520,     0,   521,     0,     0,
       0,   522,   523,   524,     0,   525,   172,     0,   526,   527,
       0,   528,   529,   530,   531,   532,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,     0,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,     0,     0,   547,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   181,     0,   555,     0,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,     0,   190,   572,
     573,   574,   191,     0,   575,   576,     0,   577,     0,   194,
     578,   195,   579,   580,   581,     0,   582,  2034,     0,   583,
     584,   585,     0,     0,   196,     0,     0,     0,   200,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   201,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,     0,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,   217,   641,   642,     0,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,   226,
     664,   227,  2035,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,     0,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1000,  1663,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,   433,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,  2250,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,  2033,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,  2034,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,  2035,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,     0,     0,     0,  1000,
    1663,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,  2033,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,  2034,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
    2035,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1000,  1663,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,   433,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   434,   989,   436,   437,   438,
     439,   440,   441,   990,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     991,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   992,   168,
     519,     0,   520,     0,   993,     0,   994,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,   995,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   996,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   997,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   998,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   999,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,     0,     0,     0,     0,  1000,  1001,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   423,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,   434,   989,   436,   437,   438,   439,
     440,   441,   990,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,     0,  1022,
     450,   451,   452,   135,   136,     0,   138,   139,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,   145,     0,   467,
       0,   468,   469,   470,   471,     0,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,     0,   481,     0,
       0,     0,     0,     0,     0,     0,     0,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,   166,     0,   517,     0,   992,   168,   519,
       0,   520,     0,  1023,     0,   994,     0,   522,   523,   524,
       0,   525,   172,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,   995,   536,   537,   538,
     539,   540,   541,     0,   542,     0,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,     0,     0,   547,
       0,   548,   549,   550,   551,   996,   553,   554,     0,   181,
       0,   555,     0,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,     0,   190,   997,   573,   574,   191,     0,
     575,   576,     0,   577,     0,   194,   578,   195,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
     196,     0,     0,     0,   200,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   201,   594,   202,   595,   596,   597,
     598,     0,   998,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   999,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,     0,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,   217,   641,   642,     0,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,   226,   664,   227,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,     0,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1000,  1001,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,   433,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,  1400,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,   994,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,   995,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,     0,     0,     0,  1000,  1001,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   423,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
    1405,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,     0,   449,   450,   451,
     452,   135,   136,     0,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,   463,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,     0,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,     0,   481,     0,     0,     0,
       0,     0,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,   517,     0,   518,   168,   519,     0,   520,
       0,   521,     0,   994,     0,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,   995,   536,   537,   538,   539,   540,
     541,     0,   542,     0,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,     0,     0,   547,     0,   548,
     549,   550,   551,   552,   553,   554,     0,   181,     0,   555,
       0,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,     0,   190,   572,   573,   574,   191,     0,   575,   576,
       0,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,     0,
       0,     0,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,     0,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,     0,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,     0,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1000,  1001,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,   433,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,   716,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,  1567,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,  1061,  1568,
      86,    87,    88,   420,    90,    91,    92,   421,  1062,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,  1063,   459,  1037,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,  1064,     0,
    1065,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,  1066,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,  1067,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,  1068,   625,   626,   212,   627,   628,   629,  1069,
     631,   632,   633,   634,     0,   635,   636,   637,   638,  1070,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1071,   225,     0,     0,  1072,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
    1041,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,  1073,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,   738,   442,   443,   444,   739,   740,
     741,   742,   743,   744,   745,   445,   446,   746,   447,   448,
     133,   449,   450,   451,   452,   135,   136,   137,   138,   139,
     747,   453,   454,   455,   456,   457,   748,   749,   458,   459,
     750,   140,   461,   751,   462,   463,   464,   465,   466,   145,
     752,   467,   753,   468,   469,   470,   471,   148,   472,   754,
     755,   474,   475,   476,   477,   478,   479,   480,   756,   151,
     481,   757,   758,   759,   760,   152,   761,   762,   763,   482,
     483,   484,   485,   486,   487,   155,   156,   488,   764,   489,
     765,   490,   491,   492,   493,   494,   766,   495,   496,   497,
     498,   767,   499,   768,   500,   501,   502,   503,   504,   769,
     505,   506,   507,   770,   508,   509,   771,   510,   511,   512,
     513,   164,   514,   515,   516,   166,   772,   517,   773,   518,
     168,   519,   774,   520,   775,   521,   169,   776,   170,   522,
     523,   524,   777,   525,   172,   778,   526,   527,   779,   528,
     529,   530,   531,   532,   173,   533,   534,   535,   780,   536,
     537,   538,   539,   540,   541,   781,   542,   174,   175,   782,
     543,   544,   545,   783,   176,   784,   177,   785,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
     786,   181,   182,   555,   183,   787,   556,   557,   558,   788,
     789,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,   189,   190,   572,   573,   574,
     191,   790,   575,   576,   193,   577,   791,   194,   578,   195,
     579,   580,   581,   792,   582,   793,   794,   583,   584,   585,
     795,   796,   196,   197,   198,   199,   200,   586,   587,   588,
     589,   590,   591,   592,   797,   593,   201,   594,   202,   595,
     596,   597,   598,   798,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,   799,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   800,   621,
     622,   210,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,   801,   635,   636,   637,   638,
     639,   802,   640,   217,   641,   642,   219,   643,   220,   803,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,   804,   654,   655,   805,   656,   657,   658,   659,   660,
     661,   806,   224,   225,   807,   808,   663,   226,   664,   227,
     809,   665,   666,   667,   668,   669,   670,   810,   811,   671,
     672,   673,   674,   675,   812,   813,   676,   677,   678,   679,
     680,   814,   234,   815,   682,   235,   683,   684,   685,   816,
     817,   686,   818,   819,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,   731,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   732,   104,   105,   423,   733,     0,   107,   108,   109,
     110,   734,   735,   112,   113,   114,   115,     0,   116,   736,
     737,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,   738,   442,   443,   444,   739,
     740,   741,   742,   743,   744,   745,   445,   446,   746,   447,
     448,   133,   449,   450,   451,   452,   135,   136,   137,   138,
     139,   747,   453,   454,   455,   456,   457,   748,   749,   458,
     459,   750,   140,   461,   751,   462,   463,   464,   465,   466,
     145,   752,   467,   753,   468,   469,   470,   471,   148,   472,
     754,   755,   474,   475,   476,   477,   478,   479,   480,   756,
     151,   481,   757,   758,   759,   760,   152,   761,   762,   763,
     482,   483,   484,   485,   486,   487,   155,   156,   488,   764,
     489,   765,   490,   491,   492,   493,   494,   766,   495,   496,
     497,   498,   767,   499,   768,   500,   501,   502,   503,   504,
     769,   505,   506,   507,   770,   508,   509,   771,   510,   511,
     512,   513,   164,   514,   515,   516,   166,   772,   517,   773,
     518,   168,   519,   774,   520,   775,   521,   169,   776,   170,
     522,   523,   524,   777,   525,   172,   778,   526,   527,   779,
     528,   529,   530,   531,   532,   173,   533,   534,   535,   780,
     536,   537,   538,   539,   540,   541,   781,   542,   174,   175,
     782,   543,   544,   545,   783,   176,   784,   177,   785,   546,
     178,   179,   547,   180,   548,   549,   550,   551,   552,   553,
     554,   786,   181,   182,   555,   183,   787,   556,   557,   558,
     788,   789,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,   189,   190,   572,   573,
     574,   191,   790,   575,   576,   193,   577,   791,   194,   578,
     195,   579,   580,   581,   792,   582,   793,   794,   583,   584,
     585,   795,   796,   196,   197,   198,   199,   200,   586,   587,
     588,   589,   590,   591,   592,   797,   593,   201,   594,   202,
     595,   596,   597,   598,   798,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,   799,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   800,
     621,   622,   210,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,   801,   635,   636,   637,
     638,   639,   802,   640,   217,   641,   642,   219,   643,   220,
     803,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,   804,   654,   655,   805,   656,   657,   658,   659,
     660,   661,   806,   224,   225,   807,   808,   663,   226,   664,
     227,   809,   665,   666,   667,   668,   669,   670,   810,   811,
     671,   672,   673,   674,   675,   812,   813,   676,   677,   678,
     679,   680,   814,   234,   815,   682,   235,   683,   684,   685,
     816,   817,   686,   818,   819,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,  3109,   439,   440,   441,   738,   442,   443,   444,
     739,   740,   741,   742,   743,   744,   745,   445,   446,   746,
     447,   448,   133,   449,   450,   451,   452,   135,   136,   137,
     138,   139,   747,   453,   454,   455,   456,   457,   748,   749,
     458,   459,   750,   140,   461,   751,   462,   463,   464,   465,
     466,   145,   752,   467,   753,   468,   469,   470,   471,   148,
     472,   754,   755,   474,   475,   476,   477,   478,   479,   480,
     756,   151,   481,   757,   758,   759,   760,   152,   761,   762,
     763,   482,   483,   484,   485,   486,   487,   155,   156,   488,
     764,   489,   765,   490,   491,   492,   493,   494,   766,   495,
     496,   497,   498,   767,   499,   768,   500,   501,   502,  3110,
     504,   769,   505,   506,   507,   770,   508,   509,   771,   510,
     511,   512,   513,   164,   514,   515,   516,   166,   772,   517,
     773,   518,   168,   519,   774,   520,   775,   521,   169,   776,
     170,   522,   523,   524,   777,   525,   172,   778,   526,   527,
     779,   528,   529,   530,   531,   532,   173,   533,   534,   535,
     780,   536,   537,   538,   539,   540,   541,   781,   542,   174,
     175,   782,   543,   544,   545,   783,   176,   784,   177,   785,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,   786,   181,   182,   555,   183,   787,   556,   557,
     558,   788,   789,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,   189,   190,   572,
     573,   574,   191,   790,   575,   576,   193,   577,   791,   194,
     578,   195,   579,   580,   581,   792,   582,   793,   794,   583,
     584,   585,   795,   796,   196,   197,   198,   199,   200,   586,
     587,   588,   589,   590,   591,   592,   797,   593,   201,   594,
     202,   595,   596,   597,   598,   798,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,   799,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     800,   621,   622,   210,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,   801,   635,   636,
     637,   638,   639,   802,  3111,   217,   641,   642,   219,   643,
     220,   803,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,   804,   654,   655,   805,   656,   657,   658,
     659,   660,   661,   806,   224,   225,   807,   808,   663,   226,
     664,   227,   809,   665,   666,   667,   668,   669,   670,   810,
     811,   671,   672,   673,   674,   675,   812,   813,   676,   677,
     678,   679,   680,   814,   234,   815,   682,   235,   683,   684,
     685,   816,   817,   686,   818,   819,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,   135,   136,
     137,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,     0,     0,     0,   152,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,   181,   182,   555,   183,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,   189,   190,
     572,   573,   574,   191,     0,   575,   576,   193,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,   197,   198,   199,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,   219,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
     136,   137,   138,   139,     0,   453,   454,   455,   456,   457,
       0,     0,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,   145,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,     0,     0,     0,   152,
       0,     0,     0,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,   166,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,   172,     0,
     526,   527,     0,   528,   529,   530,   531,  1333,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,   181,   182,   555,   183,     0,
     556,   557,   558,     0,     0,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,   189,
     190,   572,   573,   574,   191,     0,   575,   576,   193,   577,
       0,   194,   578,   195,   579,   580,   581,     0,   582,     0,
       0,   583,   584,   585,     0,     0,   196,   197,   198,   199,
     200,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     201,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,     0,   640,   217,   641,   642,
     219,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,   222,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,   226,   664,   227,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,     0,     0,
     676,   677,   678,   679,   680,   681,   234,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   692,   693,   694,   731,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   732,   104,   105,   423,   733,
       0,   107,   108,   109,   110,   734,   735,   112,   113,   114,
     115,     0,   116,   736,   737,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,   133,   449,   450,   451,   452,
     135,   136,   137,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,   148,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,   151,   481,     0,     0,     0,     0,
     152,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,   169,     0,   170,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,  1342,   173,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   174,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,   178,   179,   547,   180,   548,   549,
     550,   551,   552,   553,   554,     0,   181,   182,   555,   183,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
     189,   190,   572,   573,   574,   191,     0,   575,   576,   193,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,   197,   198,
     199,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,   210,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,   219,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
     235,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,     0,  1878,   137,  1879,  1880,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,  1881,  1882,   461,     0,
     462,   463,   464,   465,   466,     0,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,     0,     0,
       0,   152,     0,     0,     0,   482,   483,   484,   485,   486,
     487,  1883,  1884,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,     0,   514,   515,
     516,     0,     0,   517,     0,   518,  1885,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
       0,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,  2430,   536,   537,   538,   539,   540,
     541,     0,   542,   174,  2431,     0,   543,   544,   545,  1491,
    1886,     0,  1887,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,     0,   182,   555,
     183,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1888,   189,  1889,   572,   573,   574,     0,     0,   575,   576,
     193,   577,     0,     0,   578,  1890,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,  2432,   197,
     198,   199,     0,   586,   587,   588,   589,   590,   591,   592,
       0,   593,     0,   594,     0,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1891,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,     0,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,  2433,
     641,   642,   219,   643,  1893,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,     0,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1894,  1895,
       0,     0,   663,     0,   664,     0,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,     0,  1896,  2434,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   692,   693,   694,   731,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   732,   104,   105,
     423,   733,     0,   107,   108,   109,   110,   734,   735,   112,
     113,   114,   115,     0,   116,   736,   737,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,   133,   449,   450,
     451,   452,     0,  1878,   137,  1879,  1880,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,  1881,  1882,   461,
       0,   462,   463,   464,   465,   466,     0,     0,   467,     0,
     468,   469,   470,   471,   148,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,   151,   481,     0,     0,
       0,     0,   152,     0,     0,     0,   482,   483,   484,   485,
     486,   487,  1883,  1884,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,  1485,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,     0,   514,
     515,   516,     0,     0,   517,     0,   518,  1885,   519,     0,
     520,     0,   521,   169,     0,   170,   522,   523,   524,     0,
     525,     0,     0,   526,   527,     0,   528,   529,   530,   531,
     532,   173,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   174,     0,     0,   543,   544,   545,
    1491,  1886,     0,  1887,     0,   546,   178,   179,   547,   180,
     548,   549,   550,   551,   552,   553,   554,     0,     0,   182,
     555,   183,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,  1888,   189,  1889,   572,   573,   574,     0,     0,   575,
     576,   193,   577,  2422,     0,   578,  1890,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,     0,
     197,   198,   199,     0,   586,   587,   588,   589,   590,   591,
     592,     0,   593,     0,   594,     0,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,  1891,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,   210,   623,
     624,   625,   626,     0,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
    2433,   641,   642,   219,   643,  1893,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,     0,     0,   654,
     655,  3849,   656,   657,   658,   659,   660,   661,     0,  1894,
    1895,     0,     0,   663,     0,   664,     0,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,     0,  1896,
       0,   682,   235,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   692,   693,   694,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,     0,  1878,   137,  1879,  1880,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,  1881,  1882,
     461,     0,   462,   463,   464,   465,   466,     0,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
       0,     0,     0,   152,     0,     0,     0,   482,   483,   484,
     485,   486,   487,  1883,  1884,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,     0,
     514,   515,   516,     0,     0,   517,     0,   518,  1885,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,     0,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,     0,     0,   543,   544,
     545,  1491,  1886,     0,  1887,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,     0,
     182,   555,   183,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1888,   189,  1889,   572,   573,   574,  2482,     0,
     575,   576,   193,   577,     0,     0,   578,  1890,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
       0,   197,   198,   199,     0,   586,   587,   588,   589,   590,
     591,   592,     0,   593,     0,   594,     0,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1891,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,     0,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,  1892,   641,   642,   219,   643,  1893,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,     0,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1894,  1895,     0,     0,   663,     0,   664,     0,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,     0,
    1896,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   692,   693,   694,   731,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   732,
     104,   105,   423,   733,     0,   107,   108,   109,   110,   734,
     735,   112,   113,   114,   115,     0,   116,   736,   737,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,   133,
     449,   450,   451,   452,     0,  1878,   137,  1879,  1880,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,  1881,
    1882,   461,     0,   462,   463,   464,   465,   466,     0,     0,
     467,     0,   468,   469,   470,   471,   148,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,   151,   481,
       0,     0,     0,     0,   152,     0,     0,     0,   482,   483,
     484,   485,   486,   487,  1883,  1884,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,  1485,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
       0,   514,   515,   516,     0,     0,   517,     0,   518,  1885,
     519,     0,   520,     0,   521,   169,     0,   170,   522,   523,
     524,     0,   525,     0,     0,   526,   527,     0,   528,   529,
     530,   531,   532,   173,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   174,     0,     0,   543,
     544,   545,  1491,  1886,     0,  1887,     0,   546,   178,   179,
     547,   180,   548,   549,   550,   551,   552,   553,   554,     0,
       0,   182,   555,   183,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,  1888,   189,  1889,   572,   573,   574,  3676,
       0,   575,   576,   193,   577,     0,     0,   578,  1890,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,     0,   197,   198,   199,     0,   586,   587,   588,   589,
     590,   591,   592,     0,   593,     0,   594,     0,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
    1891,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
     210,   623,   624,   625,   626,     0,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,  1892,   641,   642,   219,   643,  1893,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,     0,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1894,  1895,     0,     0,   663,     0,   664,     0,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
       0,  1896,     0,   682,   235,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   692,   693,   694,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,     0,  1878,   137,  1879,  1880,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
    1881,  1882,   461,     0,   462,   463,   464,   465,   466,     0,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,     0,     0,     0,   152,     0,     0,     0,   482,
     483,   484,   485,   486,   487,  1883,  1884,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,     0,   514,   515,   516,     0,     0,   517,     0,   518,
    1885,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,     0,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,     0,     0,
     543,   544,   545,  1491,  1886,     0,  1887,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,     0,   182,   555,   183,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1888,   189,  1889,   572,   573,   574,
       0,     0,   575,   576,   193,   577,     0,     0,   578,  1890,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,     0,   197,   198,   199,     0,   586,   587,   588,
     589,   590,   591,   592,     0,   593,     0,   594,     0,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1891,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,     0,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,  1892,   641,   642,   219,   643,  1893,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
       0,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1894,  1895,     0,     0,   663,     0,   664,     0,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,     0,  1896,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   692,   693,
     694,   731,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   732,   104,   105,   423,   733,     0,   107,   108,   109,
     110,   734,   735,   112,   113,   114,   115,     0,   116,   736,
     737,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,   133,   449,   450,   451,   452,     0,  1878,   137,  1879,
    1880,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,  1881,  1882,   461,     0,   462,   463,   464,   465,   466,
       0,     0,   467,     0,   468,   469,   470,   471,   148,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
     151,   481,     0,     0,     0,     0,   152,     0,     0,     0,
     482,   483,   484,   485,   486,   487,  1883,  1884,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,  1485,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,     0,   514,   515,   516,     0,     0,   517,     0,
     518,  1885,   519,     0,   520,     0,   521,   169,     0,   170,
     522,   523,   524,     0,   525,     0,     0,   526,   527,     0,
     528,   529,   530,   531,   532,   173,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   174,     0,
       0,   543,   544,   545,  1491,  1886,     0,  1887,     0,   546,
     178,   179,   547,   180,   548,   549,   550,   551,   552,   553,
     554,     0,     0,   182,   555,   183,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,  1888,   189,  1889,   572,   573,
     574,     0,     0,   575,   576,   193,   577,     0,     0,   578,
    1890,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,     0,   197,   198,   199,     0,   586,   587,
     588,   589,   590,   591,   592,     0,   593,     0,   594,     0,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,  1891,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,   210,   623,   624,   625,   626,     0,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,  2433,   641,   642,   219,   643,  1893,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,     0,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,  1894,  1895,     0,     0,   663,     0,   664,
       0,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,     0,  1896,     0,   682,   235,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   692,
     693,   694,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,     0,  1878,   137,
    1879,  1880,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,  1881,  1882,   461,     0,   462,   463,   464,   465,
     466,     0,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,     0,     0,     0,   152,     0,     0,
       0,   482,   483,   484,   485,   486,   487,  1883,  1884,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,     0,   514,   515,   516,     0,     0,   517,
       0,   518,  1885,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,     0,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
       0,     0,   543,   544,   545,  1491,  1886,     0,  1887,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,     0,   182,   555,   183,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1888,   189,  1889,   572,
     573,   574,     0,     0,   575,   576,   193,   577,     0,     0,
     578,  1890,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,     0,   197,   198,   199,     0,   586,
     587,   588,   589,   590,   591,   592,     0,   593,     0,   594,
       0,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1891,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,     0,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,     0,   641,   642,   219,   643,
    1893,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,     0,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1894,  1895,     0,     0,   663,     0,
     664,     0,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,     0,  1896,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     692,   693,   694,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,     0,     0,
     137,     0,     0,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,     0,     0,     0,   152,     0,
       0,     0,   482,   483,   484,   485,   486,   487,     0,     0,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,     0,   514,   515,   516,     0,     0,
     517,     0,   518,     0,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,     0,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,     0,     0,   543,   544,   545,     0,     0,     0,     0,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,     0,   182,   555,   183,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,     0,   189,     0,
     572,   573,   574,     0,     0,   575,   576,   193,   577,     0,
       0,   578,     0,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,     0,   197,   198,   199,     0,
     586,   587,   588,   589,   590,   591,   592,     0,   593,     0,
     594,     0,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,     0,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,     0,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,     0,   641,   642,   219,
     643,     0,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,     0,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,   663,
       0,   664,     0,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,     0,     0,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   738,   442,   443,
     444,   739,   740,   741,   742,   743,   744,   745,   445,   446,
     746,   447,   448,   133,   449,   450,   451,   452,   135,   136,
     137,   138,   139,   747,   453,   454,   455,   456,   457,   748,
     749,   458,   459,     0,   140,   461,   751,   462,   463,   464,
     465,   466,   145,   752,   467,   753,   468,   469,   470,   471,
     148,   472,   754,   755,   474,   475,   476,   477,   478,   479,
     480,   756,   151,   481,     0,   758,   759,   760,   152,   761,
     762,   763,   482,   483,   484,   485,     0,   487,   155,   156,
     488,   764,   489,   765,   490,   491,   492,   493,   494,   766,
     495,   496,   497,   498,   767,   499,   768,   500,   501,   502,
     503,   504,   769,   505,   506,   507,   770,   508,   509,   771,
     510,   511,   512,   513,   164,   514,   515,   516,   166,   772,
     517,   773,   518,   168,   519,   774,   520,   775,   521,   169,
     776,   170,   522,   523,   524,   777,   525,   172,   778,   526,
     527,   779,   528,   529,     0,   531,   532,   173,   533,   534,
     535,   780,   536,   537,   538,   539,   540,   541,   781,   542,
     174,   175,     0,   543,   544,   545,     0,   176,   784,   177,
     785,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,   786,   181,   182,   555,   183,   787,   556,
     557,   558,   788,   789,   559,   560,   561,   562,   563,     0,
     565,   566,   567,     0,   569,   570,   571,   188,   189,   190,
     572,   573,   574,   191,   790,   575,   576,   193,   577,   791,
     194,   578,   195,   579,   580,   581,   792,   582,   793,   794,
     583,   584,   585,   795,   796,   196,   197,   198,   199,   200,
     586,   587,   588,   589,   590,   591,   592,   797,   593,   201,
     594,   202,   595,   596,   597,   598,   798,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,   799,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   800,   621,   622,   210,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,     0,   634,   801,   635,
     636,   637,   638,   639,   802,   640,   217,   641,   642,   219,
     643,   220,   803,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,   804,   654,   655,   805,   656,   657,
     658,   659,   660,   661,   806,   224,   225,     0,   808,   663,
     226,   664,   227,   809,   665,   666,   667,   668,   669,   670,
       0,   811,   671,   672,   673,   674,   675,   812,   813,   676,
     677,   678,   679,   680,     0,   234,   815,   682,   235,   683,
     684,   685,   816,   817,   686,   818,   819,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,  2033,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,  2034,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,  2035,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,   662,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  1151,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  2231,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,  2445,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,  3299,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,  1050,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,  1051,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  2011,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,  3020,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   714,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,   715,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,   716,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,   923,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   924,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   925,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  2068,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,  2069,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2070,   521,     0,
       0,     0,  2071,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,  2072,  2073,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,  2074,   631,   632,   633,   634,     0,  2075,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,  2076,   656,  2077,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   130,   131,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,  1390,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,  2057,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,  2338,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,  2897,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,  2898,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,  2899,   656,   657,
    2900,   659,  2901,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,  2902,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   723,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,   716,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   873,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1325,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,  2533,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  2534,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   130,   131,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  3093,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  3094,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  3105,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  3106,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   929,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   972,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   973,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,  1026,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,  1082,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  1294,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  1347,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1570,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,  1964,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,  2057,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,  2338,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  3366,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  3985,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  3998,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  4147,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4200,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4202,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4204,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,  4581,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,  1034,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1036,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,  1037,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1038,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1039,   225,     0,     0,  1040,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1076,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,  1037,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1077,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1078,   225,     0,     0,  1079,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,  1096,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1230,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1285,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1308,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1338,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1344,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1354,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1356,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1358,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1360,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1363,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1365,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1366,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1369,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,  1581,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,  1063,   459,  1037,   140,  1582,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,  1067,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,  1068,   625,   626,   212,
     627,   628,   629,  1069,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1574,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1071,   225,     0,     0,  1072,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,  1073,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,  1705,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1924,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1954,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1989,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1991,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,  2103,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  2305,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,     0,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0, 