/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, 
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXMASS_GLOBALS_H
#define POLYXMASS_GLOBALS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
#define _(String) (String)
#define N_(String) String
#define textdomain(GETTEXT_PACKAGE)
#define bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR)
*/

/* When ready for the gettext step, change lines above with:
 */
// #include <libintl.h>  replace with the wrapper ENABLE_NLS depending one:
#include "gettext.h" // see gettext manual page 111.
#define _(String) gettext (String) 
#define gettext_noop(String) String 
#define N_(String) gettext_noop (String)
/*
 */

#define debug_printf( x ) \
{ \
  printf ( "%s @ %u : ", __FILE__, __LINE__ ); \
  printf x; \
  fflush ( stdout ); \
}

#if 0

The way to change all the debug_printf statement into commented
material is by using the following sed script:

sed 's|debug_printf (\(.*\));|/\*debug_printf (\1);\*/|'

#endif


/* all the includes */

#include <glib.h>
#include <math.h>
#include <stddef.h>
#include <limits.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <stdlib.h>
#include <locale.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h> /* Not included by gtk.h */

#include <glade/glade.h>

#include <libgnomecanvas/libgnomecanvas.h>
#include <librsvg/rsvg.h>

#include "libpolyxmass-acidobasic.h"
#include "libpolyxmass-atomspec.h"
#include "libpolyxmass-chemgroup.h"
#include "libpolyxmass-config.h"
#include "libpolyxmass-globals.h"
#include "libpolyxmass-init.h"
#include "libpolyxmass-masspair.h"
#include "libpolyxmass-modifspec.h"
#include "libpolyxmass-monomerspec.h"
#include "libpolyxmass-note.h"
#include "libpolyxmass-plugin.h"
#include "libpolyxmass-polchemdefspec.h"
#include "libpolyxmass-prop.h"
#include "libpolyxmass-reportopt.h"
#include "libpolyxmass-userspec.h"
#include "pxmchem-atom.h"
#include "pxmchem-calcopt.h"
#include "pxmchem-cleave.h"
#include "pxmchem-cleaveopt.h"
#include "pxmchem-cleavespec.h"
#include "pxmchem-elemcompcalc.h"
#include "pxmchem-findmass.h"
#include "pxmchem-findmassopt.h"
#include "pxmchem-formula.h"
#include "pxmchem-fragment.h"
#include "pxmchem-fragopt.h"
#include "pxmchem-fragspec.h"
#include "pxmchem-ionizerule.h"
#include "pxmchem-masscalc.h"
#include "pxmchem-mnmcompcalc.h"
#include "pxmchem-modif.h"
#include "pxmchem-monomer.h"
#include "pxmchem-oligomer.h"
#include "pxmchem-polchemdef.h"
#include "pxmchem-polchemdef-plugins.h"
#include "pxmchem-polymer.h"
#include "pxmchem-polymer-plugins.h"
#include "pxmchem-searchmass.h"
#include "pxmchem-searchmassopt.h"

#include "polyxmass-timeoutmsg.h"
#include "polyxmass-polchemdefctxt.h"
#include "polyxmass-ui-filechoosers.h"


/* A number of generally available data.
 */
PxmUserSpec *userspec;

GtkWindow *polyxmass_main_wnd;
GtkWindow *polyxmass_console_wnd;


/* When editing notes, it may be for polymer notes or 
   monomer notes.
*/
enum
  {
    NOTE_TARGET_POLYMER,
    NOTE_TARGET_MONOMER_RANGE,
    NOTE_TARGET_MONOMER_SINGLE
  };



/************** The MAIN GLOBAL ARRAYS ************************/



GPtrArray *polyxmass_atomdefsGPA;
GPtrArray *polyxmass_polchemdefsGPA;
GPtrArray *polyxmass_polchematomdicGPA;

GPtrArray *polyxmass_polchemdefctxtGPA;

GPtrArray *polyxmass_timeoutmsgGPA;

/* This array will contain pointer arrays of PxmWinMngmt instances.
 */
GPtrArray *polyxmass_winmngmtGPA_GPA;

/**************************************************************/

#define MAX_LINE_LENGTH 1000

#define NAME_SOUND 1
#define CODE_SOUND 2
#define BOTH_SOUND 3

#define POLYXMASS_NORM_MSG_TIMEOUT 2500
#define POLYXMASS_MEDI_MSG_TIMEOUT 6000
#define POLYXMASS_LONG_MSG_TIMEOUT 10000


PxmAtomSpec *
polyxmass_globals_get_matching_polchemdef_atomdef (gchar *polchemdef, 
						   gint *polchemdef_idx,
						   gchar *atomdef,
						   gint *atomdef_idx);

void
polyxmass_globals_print_greeting (void);

void
polyxmass_globals_print_polchemdef_xml_file_version (void);

void
polyxmass_globals_print_polymer_sequence_xml_file_version (void);

void
polyxmass_globals_log_warning_msg (const gchar *log_domain,
				   GLogLevelFlags log_level,
				   const gchar *message,
				   gpointer data);

void
polyxmass_globals_log_libpolyxmass_warning_msg (const gchar *log_domain,
						GLogLevelFlags log_level,
						const gchar *message,
						gpointer data);

void
polyxmass_globals_log_critical_msg (const gchar *log_domain,
				    GLogLevelFlags log_level,
				    const gchar *message,
				    gpointer data);

void
polyxmass_globals_log_libpolyxmass_critical_msg (const gchar *log_domain,
						 GLogLevelFlags log_level,
						 const gchar *message,
						 gpointer data);


void
polyxmass_globals_log_message_msg (const gchar *log_domain,
				    GLogLevelFlags log_level,
				    const gchar *message,
				    gpointer data);

void
polyxmass_globals_log_libpolyxmass_message_msg (const gchar *log_domain,
						 GLogLevelFlags log_level,
						 const gchar *message,
						 gpointer data);




/* Automatical destroying of window referenced into a prop object.
 */
gboolean
polyxmass_globals_gtk_window_prop_free (PxmProp *prop);







#endif /* ifndef POLYXMASS_GLOBALS_H */
