/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxdef-globals.h"
#include "polyxdef-defctxt.h"


gboolean
polyxdef_init (void)
{
  /* Initialize the array that will contain all the polyxdef contexts
     (PxmDefctxt instances) made on behalf of the polymer
     chemistry/atom definition module (polyxdef).
  */
  polyxdef_defctxtGPA = g_ptr_array_new ();

  polyxdef_uninitialized = FALSE;
  
  return TRUE;
}


gboolean
polyxdef_uninit (void)
{
  GtkWidget *dialog = NULL;

  gint iter = 0;
  gint result = 0;

  gchar *help = NULL;

  PxmDefCtxt *defctxt = NULL;


  /* Since this function might be called more than once in a single 
     GNU polyxmass session, we must ensure that what we might free 
     here in the first run does not get freed a second time, otherwise
     crash guaranteed!
  */
  if (polyxdef_uninitialized == TRUE)
    return TRUE;
  
  /* This function is called right before leaving the GNU polyxmass
     program, by the polyxmass_main_uninit_program () function.
  */


  /* We start by checking if some definitions are still opened and NOT
     saved.

     It is important NOT to start freeing other housekeeping data
     because if we return from exiting (the user chooses not to quit
     the polyxdef module because he is given a chance to save a
     polymer sequence, for example), we might well come to this
     function again, or the user might want to continue the working
     session. In those cases, if the housekeepiing data have been
     freed, the crsh is guaranteed !
  */

  /* We only return TRUE is all the definitions that are opened (if
     any) are unmodified. Since we might remove one or more items, as
     usual, we iterate in the array in the reverse order.
  */
  for (iter = polyxdef_defctxtGPA->len - 1; iter >= 0 ; iter--) 
    {
      defctxt = g_ptr_array_index (polyxdef_defctxtGPA, iter);
      g_assert (defctxt != NULL);
      
      if (FALSE == defctxt->is_modified)
	{
	  /* Remove the window from the array of polyxdef contexts.
	   */
	  if (FALSE == g_ptr_array_remove (polyxdef_defctxtGPA, 
					   defctxt))
	    {
	      g_critical (_("%s@%d: failed to remove context from array.\n"),
		     __FILE__, __LINE__);
	    }
	  
	  polyxdef_defctxt_free (defctxt);  
	}
    }
  
      

  /* Check if we still have defctxt instances in the array. If not,
     then we can go on with the freeing work...
  */
  if (polyxdef_defctxtGPA->len <= 0)
    {
      polyxdef_defctxt_GPA_free (polyxdef_defctxtGPA);
	  
      polyxdef_uninitialized = TRUE;
	  
      return TRUE;
    }
      
  /* Apparently, there remains at least one sequence that is not
     saved.
  */
  help = g_strdup_printf (_("GNU polyxdef: %d unsaved definition(s) "
			    "still opened. \nQuit Anyway ?"),
			  polyxdef_defctxtGPA->len);
  
  dialog = gtk_message_dialog_new (GTK_WINDOW (polyxmass_main_wnd),
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_QUESTION,
				   GTK_BUTTONS_YES_NO,
				   help);

  g_free (help);
  				  
  /*
    dialog = gtk_dialog_new_with_buttons 
    (_("GNU polyxdef: UNSAVED definition(s)"),
    polyxmass_main_wnd,
    GTK_DIALOG_MODAL 
    | GTK_DIALOG_DESTROY_WITH_PARENT,
    _("Exit Anyway"), GTK_RESPONSE_ACCEPT,
    _("Cancel"), GTK_RESPONSE_REJECT,
    NULL);
  */

  result = gtk_dialog_run (GTK_DIALOG (dialog));
  
  if (result != GTK_RESPONSE_YES)
    {
      /* The user does not want to "Exit Anyway", so we just destroy
	 the dialog widget and we return FALSE, so that GNU polyxmass
	 knows that exiting the program is aborted. Note that
	 polyxdef_uninitialized, which was FALSE at the entering of
	 this function remains FALSE: it will be possible to continue
	 work as usual and come back to this function later...
      */
      gtk_widget_destroy (dialog);
      
      return FALSE;
    }
  

  /* At this point, we know that the user wanted to exit the polyxdef
     module even if one or more polymer chemistry definition(s) is(were)
     modified.
     
     Continue the freeing work.
  */
  gtk_widget_destroy (dialog);
  
  polyxdef_defctxt_GPA_free (polyxdef_defctxtGPA);

  polyxdef_uninitialized = TRUE;
  
  return TRUE; 
}
