/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXCALC_UI_CHEMPAD_H
#define POLYXCALC_UI_CHEMPAD_H

#include "polyxcalc-globals.h"

typedef struct _PxmChempadkey PxmChempadkey;
typedef struct _PxmChempadgeo PxmChempadgeo;


struct _PxmChempadgeo
{
  gint rows;
  gint cols;
};

struct _PxmChempadkey
{
  gchar *label;
  gchar *actform;
  gchar *tooltip;
};


/* CHEMPAD KEY/GEO HELPER FUNCTIONS
 */
PxmChempadkey *
polyxcalc_chempadkey_new (void);

PxmChempadgeo *
polyxcalc_chempadgeo_new (void);

gint
polyxcalc_chempadkey_free (PxmChempadkey *cpk);

gint
polyxcalc_chempadgeo_free (PxmChempadgeo *cpg);

gint
polyxcalc_chempadkey_GPA_free (GPtrArray *GPA);

gboolean
polyxcalc_chempadkey_set_label (PxmChempadkey *cpk, gchar *label);

gboolean
polyxcalc_chempadkey_set_actform (PxmChempadkey *cpk, gchar *actform);

gboolean
polyxcalc_chempadkey_set_tooltip (PxmChempadkey *cpk, gchar *tooltip);

gboolean
polyxcalc_chempadgeo_set_rows (PxmChempadgeo *cpg, gint rows);

gboolean
polyxcalc_chempadgeo_set_cols (PxmChempadgeo *cpg, gint cols);




GtkWidget *
polyxcalc_ui_chempad_wnd_setup_window (PxmCalcCtxt *calcctxt);

gboolean
polyxcalc_ui_chempad_wnd_fill_layout (PxmCalcCtxt *calcctxt, gchar *file);

gint
polyxcalc_ui_chempad_wnd_chempadkey_button (GtkWidget * button, 
					 gpointer data);



gboolean
polyxcalc_chempad_parse_file (gchar *file, 
			      GPtrArray *GPA, 
			      PxmChempadgeo *cpg,
			      GPtrArray *atom_refGPA);

gboolean
polyxcalc_chempad_parse_geometry (gchar *line, PxmChempadgeo *cpg);

gboolean
polyxcalc_chempad_parse_chempadkey (gchar *line, PxmChempadkey *cpk,
				    GPtrArray *atom_refGPA);






/* WINDOW LIFE CYCLE-RELATED FUNCTIONS
 */
gboolean
polyxcalc_ui_chempad_wnd_delete_event (GtkWidget *widget,
				     GdkEvent *event,
				    gpointer data);


gboolean
polyxcalc_ui_chempad_wnd_destroy_event (GtkWidget *widget,
				      GdkEvent *event,
				     gpointer data);




#endif /* ifndef POLYXCALC_UI_CHEMPAD_H */
