
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__RUNTIME_AGENTCFG_H
#define POLYGRAPH__RUNTIME_AGENTCFG_H

#include "xstd/Array.h"

class RndDistr;
class AgentSym;
class SslWrap;

// agent configuration items that can be shared among multiple agents
class AgentCfg {
	public:
		AgentCfg();
		~AgentCfg();

		void configure(const AgentSym *agent);

		int selectHttpVersion();
		bool selectSslWrap(const SslWrap *&wrap);
		bool selectCookieSenderStatus();

	protected:
		void configureSslWraps(const AgentSym *agent);
		void configureHttpVersions(const AgentSym *agent);

	protected:
		Array<SslWrap*> theSslWraps;   // local entries from TheSslWraps
		RndDistr *theSslWrapSel;       // selects an SSL wrapper
		RndDistr *theHttpVersionSel;   // selects HTTP version
		double theCookieSenderProb;    // probability of sending cookies
};

#endif
