
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#include "base/polygraph.h"

#include <fstream>

#include "xml/XmlAttr.h"
#include "loganalyzers/LevelStex.h"
#include "loganalyzers/ReportBlob.h"
#include "loganalyzers/BlobDb.h"
#include "loganalyzers/RepOpts.h"
#include "loganalyzers/PhaseInfo.h"
#include "loganalyzers/PhaseTrace.h"
#include "loganalyzers/LevelTraceFig.h"


LevelTraceFig::LevelTraceFig(): theStex1(0), theStex2(0), thePhase(0), theTrace(0) {
}

void LevelTraceFig::stats(const Stex *aStex1, const Stex *aStex2, const PhaseInfo *aPhase) {
	theStex1 = aStex1;
	theStex2 = aStex2;
	thePhase = aPhase;
	theTrace = &thePhase->trace();
	Assert(theTrace);
}

void LevelTraceFig::setCtrlOptions() {
	theLabelY1 = "level, #";
	ReportTraceFigure::setCtrlOptions();
}

int LevelTraceFig::createCtrlFile() {
	if (ReportTraceFigure::createCtrlFile() < 0)
		return -1;

	addPlotLine(theStex1->name(), theLabelY1);
	if (theStex2)
		addPlotLine(theStex2->name(), theLabelY1);
	addedAllPlotLines();

	int pointCount = 0;
	pointCount += dumpDataLines(theStex1);
	if (theStex2) {
		*theCtrlFile << 'e' << endl;
		pointCount += dumpDataLines(theStex2);
	}

	return pointCount;
}

int LevelTraceFig::dumpDataLines(const LevelStex *stex) {
	int pointCount = 0;
	for (int i = 0; i < theTrace->count(); ++i)
		pointCount += dumpDataLine(stex, theTrace->winPos(i), theTrace->winStats(i));

	return pointCount;
}

int LevelTraceFig::dumpDataLine(const LevelStex *stex, Time stamp, const StatIntvlRec &r) {
	const LevelStat &stat = stex->level(r);
	if (stat.known()) {
		dumpTime(stamp);
		*theCtrlFile << ' ' << stat.level() << endl;
		return 1;
	}
	return 0;	
}
