
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__CLIENT_CLTCONNMGR_H
#define POLYGRAPH__CLIENT_CLTCONNMGR_H

#include "xstd/NetAddr.h"
#include "xstd/Queue.h"
#include "client/ConnHash.h"
#include "runtime/ConnMgr.h"

class ObjId;
class RndDistr;
class RobotSym;
class PortMgr;
class SslSession;

class CltConnMgr: public ConnMgr {
	public:
		CltConnMgr();
		virtual ~CltConnMgr();

		void configure(const SockOpt &anOpt, const RobotSym *cfg, int srvCnt);
		virtual void configureSsl(SslCtx *aCtx, const SslWrap *wrap);
		void portMgr(PortMgr *aPortMgr);
		PortMgr *portMgr();

		bool atHardConnLimit() const; 
		Connection *get(const ObjId &oid, const NetAddr &hopAddr, ProtoIntvlPtr protoStat);

		void closeAllIdle(); // close all idle connections

		virtual void noteReadReady(int fd);

	protected:
		Connection *open(const NetAddr &hopAddr, ProtoIntvlPtr protoStat, bool needsSsl);
		virtual void putIdle(Connection *conn);
		virtual void delIdle(Connection *conn);
		virtual void closePrep(Connection *conn);

		bool findIdle(const NetAddr &hopAddr, const NetAddr &tunnelAddr, ConnHashPos &pos);
		bool findIdleSubst(const NetAddr &addr, const NetAddr &tunnelAddr, ConnHashPos &pos);
		bool needSsl(const ObjId &oid, const NetAddr &hopAddr, const NetAddr &tunnelAddr, bool &needTunnel) const;
		bool needMoreSslSessions() const;

	protected:
		ConnHash theIdleHash;
		Queue<Connection> theIdleQueue;
		PortMgr *thePortMgr;

		RndDistr *thePipeDepth;

		Array<SslSession*> theSslSessionCache;
		double theSslResumpProb;  // how often to try to resume a session
		int theSslCacheLimit;     // desired maximum number of cached sessions

		double theMinNewConnProb; // try limit #open() calls using substitutes
		int theConnLvlLmt;        // limit for #opened connections
};

#endif
