//
// OptionSet.cpp
//
// $Id: //poco/1.2/Util/src/OptionSet.cpp#2 $
//
// Library: Util
// Package: Options
// Module:  OptionSet
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Util/OptionSet.h"
#include "Poco/Util/OptionException.h"
#include "Poco/Exception.h"


namespace Poco {
namespace Util {


OptionSet::OptionSet()
{
}


OptionSet::OptionSet(const OptionSet& options):
	_options(options._options)
{
}


OptionSet::~OptionSet()
{
}


OptionSet& OptionSet::operator = (const OptionSet& options)
{
	if (&options != this)
		_options = options._options;
	return *this;
}


void OptionSet::addOption(const Option& option)
{
	poco_assert (!option.fullName().empty());
	OptionVec::const_iterator it = _options.begin();
	OptionVec::const_iterator itEnd = _options.end();
	for (; it != itEnd; ++it)
	{
		if (it->fullName() == option.fullName())
		{
			throw DuplicateOptionException(it->fullName());
		}
	}

	_options.push_back(option);
}


bool OptionSet::hasOption(const std::string& name, bool matchShort) const
{
	bool found = false;
	for (Iterator it = _options.begin(); it != _options.end(); ++it)
	{
		if (matchShort && it->matchesShort(name) || !matchShort && it->matchesFull(name))
		{
			if (!found)
				found = true;
			else
				return false;
		}
	}
	return found;
}

	
const Option& OptionSet::getOption(const std::string& name, bool matchShort) const
{
	const Option* pOption = 0;
	for (Iterator it = _options.begin(); it != _options.end(); ++it)
	{
		if (matchShort && it->matchesShort(name) || !matchShort && it->matchesPartial(name))
		{
			if (!pOption)
			{
				pOption = &*it;
				if (!matchShort && it->matchesFull(name))
					break;
			}
			else if (!matchShort && it->matchesFull(name))
			{
				pOption = &*it;
				break;
			}
			else throw AmbiguousOptionException(name);
		}
	}
	if (pOption)
		return *pOption;
	else
		throw UnknownOptionException(name);
}


OptionSet::Iterator OptionSet::begin() const
{
	return _options.begin();
}


OptionSet::Iterator OptionSet::end() const
{
	return _options.end();
}


} } // namespace Poco::Util
