//
// StopwatchTest.cpp
//
// $Id: //poco/1.2/Foundation/testsuite/src/StopwatchTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "StopwatchTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/Stopwatch.h"
#include "Poco/Timestamp.h"
#include "Poco/Thread.h"


using Poco::Stopwatch;
using Poco::Timestamp;
using Poco::Thread;


StopwatchTest::StopwatchTest(const std::string& name): CppUnit::TestCase(name)
{
}


StopwatchTest::~StopwatchTest()
{
}


void StopwatchTest::testStopwatch()
{
	Stopwatch sw;
	sw.start();
	Thread::sleep(200);
	sw.stop();
	Timestamp::TimeDiff d = sw.elapsed();
	assert (d >= 180000 && d <= 300000);	
	sw.start();	
	Thread::sleep(100);
	d = sw.elapsed();
	assert (d >= 280000 && d <= 400000);	
	Thread::sleep(100);
	sw.stop();
	d = sw.elapsed();
	assert (d >= 380000 && d <= 500000);
	sw.reset();
	sw.start();
	Thread::sleep(200);
	sw.stop();
	d = sw.elapsed();
	assert (d >= 180000 && d <= 300000);	
}


void StopwatchTest::setUp()
{
}


void StopwatchTest::tearDown()
{
}


CppUnit::Test* StopwatchTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("StopwatchTest");

	CppUnit_addTest(pSuite, StopwatchTest, testStopwatch);

	return pSuite;
}
